/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.ua.DSTU4145NamedCurves;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.asymmetric.CustomNamedCurves;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersID;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;

public class ECDomainParametersIndex {
    public static NamedECDomainParameters lookupDomainParameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByOID(aSN1ObjectIdentifier);
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.getByOID(aSN1ObjectIdentifier);
        }
        if (x9ECParameters != null) {
            return new NamedECDomainParameters(aSN1ObjectIdentifier, x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
        }
        ECDomainParameters eCDomainParameters = ECGOST3410NamedCurves.getByOID(aSN1ObjectIdentifier);
        if (eCDomainParameters == null) {
            eCDomainParameters = DSTU4145NamedCurves.getByOID(aSN1ObjectIdentifier);
        }
        if (eCDomainParameters != null) {
            return new NamedECDomainParameters(aSN1ObjectIdentifier, eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
        }
        return null;
    }

    public static NamedECDomainParameters lookupDomainParameters(ECDomainParametersID eCDomainParametersID) {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByName(eCDomainParametersID.getCurveName());
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.getByName(eCDomainParametersID.getCurveName());
        }
        if (x9ECParameters != null) {
            return new NamedECDomainParameters(ECNamedCurveTable.getOID(eCDomainParametersID.getCurveName()), x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
        }
        ECDomainParameters eCDomainParameters = ECGOST3410NamedCurves.getByName(eCDomainParametersID.getCurveName());
        if (eCDomainParameters != null) {
            return new NamedECDomainParameters(ECGOST3410NamedCurves.getOID(eCDomainParametersID.getCurveName()), eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
        }
        return null;
    }

    public static ASN1ObjectIdentifier lookupOID(ECDomainParameters eCDomainParameters) {
        Enumeration enumeration = ECNamedCurveTable.getNames();
        while (enumeration.hasMoreElements()) {
            NamedECDomainParameters namedECDomainParameters;
            final String string = (String)enumeration.nextElement();
            X9ECParameters x9ECParameters = ECNamedCurveTable.getByName(string);
            if (!x9ECParameters.getN().equals(eCDomainParameters.getN()) || !((ECDomainParameters)(namedECDomainParameters = ECDomainParametersIndex.lookupDomainParameters(new ECDomainParametersID(){

                public String getCurveName() {
                    return string;
                }
            }))).equals(eCDomainParameters)) continue;
            return ECNamedCurveTable.getOID(string);
        }
        return null;
    }
}

