/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.screenshot;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.TileRendererBase;
import org.gephi.visualization.VizController;
import org.gephi.visualization.swing.GLAbstractListener;
import org.gephi.visualization.text.TextManager;

public class OffscreenCanvas
extends GLAbstractListener
implements TileRendererBase.TileRendererListener {
    private final boolean transparentBackground;

    public OffscreenCanvas(int width, int height, boolean transparentBackground, int antialiasing) {
        GLProfile glp = GLProfile.get((String)"GL2");
        GLCapabilities caps = this.getCaps();
        caps.setOnscreen(false);
        caps.setDoubleBuffered(false);
        if (antialiasing == 0) {
            caps.setSampleBuffers(false);
        } else {
            caps.setSampleBuffers(true);
            caps.setNumSamples(antialiasing);
        }
        GLDrawableFactory factory = GLDrawableFactory.getFactory((GLProfile)glp);
        this.drawable = factory.createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)caps, null, width, height);
        this.drawable.addGLEventListener((GLEventListener)this);
        this.cameraLocation = this.vizController.getDrawable().getCameraLocation();
        this.cameraTarget = this.vizController.getDrawable().getCameraTarget();
        this.engine = VizController.getInstance().getEngine();
        this.globalScale = VizController.getInstance().getDrawable().getGlobalScale();
        this.transparentBackground = transparentBackground;
    }

    @Override
    public void init(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        this.initConfig(gl);
        this.engine.initDisplayLists(gl, GLU);
        TextManager textManager = VizController.getInstance().getTextManager();
        textManager.reinitRenderers();
    }

    @Override
    public void initConfig(GL2 gl) {
        super.initConfig(gl);
        gl.glClear(16384);
        float[] backgroundColor = this.vizController.getVizModel().getBackgroundColorComponents();
        gl.glClearColor(backgroundColor[0], backgroundColor[1], backgroundColor[2], this.transparentBackground ? 0.0f : 1.0f);
    }

    @Override
    public void display(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glClear(16384);
        float[] backgroundColor = this.vizController.getVizModel().getBackgroundColorComponents();
        gl.glClearColor(backgroundColor[0], backgroundColor[1], backgroundColor[2], this.transparentBackground ? 0.0f : 1.0f);
        this.engine.display(gl, GLU);
    }

    @Override
    protected void init(GL2 gl) {
    }

    @Override
    protected void render3DScene(GL2 gl, GLU glu) {
    }

    @Override
    protected void reshape3DScene(GL2 gl) {
    }

    public void addTileRendererNotify(TileRendererBase trb) {
    }

    public void removeTileRendererNotify(TileRendererBase trb) {
    }

    public void reshapeTile(TileRendererBase tr, int tileX, int tileY, int tileWidth, int tileHeight, int imageWidth, int imageHeight) {
        GL2 gl = tr.getAttachedDrawable().getGL().getGL2();
        double aspectRatio = (double)imageWidth / (double)imageHeight;
        float top = (float)(1.0 * Math.tan(0.26179938750000004));
        float bottom = -top;
        float left = (float)((double)bottom * aspectRatio);
        float right = (float)((double)top * aspectRatio);
        float w = right - left;
        float h = top - bottom;
        float l = left + (float)tileX * w / (float)imageWidth;
        float r = l + (float)tileWidth * w / (float)imageWidth;
        float b = bottom + (float)tileY * h / (float)imageHeight;
        float t = b + (float)tileHeight * h / (float)imageHeight;
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glFrustum((double)l, (double)r, (double)b, (double)t, 1.0, 150000.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        this.setCameraPosition(gl, GLU);
    }

    public void startTileRendering(TileRendererBase trb) {
    }

    public void endTileRendering(TileRendererBase trb) {
    }

    @Override
    public void reinitWindow() {
    }
}

