/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.dirchooser;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.swing.dirchooser.DirectoryCellEditor;
import org.netbeans.swing.dirchooser.DirectoryNode;
import org.netbeans.swing.dirchooser.FileCompletionPopup;
import org.netbeans.swing.dirchooser.InputBlocker;
import org.netbeans.swing.dirchooser.spi.CustomDirectoryProvider;
import org.openide.awt.HtmlRenderer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class DirectoryChooserUI
extends BasicFileChooserUI {
    private static final Dimension horizontalStrut1 = new Dimension(25, 1);
    private static final Dimension verticalStrut1 = new Dimension(1, 4);
    private static final Dimension verticalStrut2 = new Dimension(1, 6);
    private static final Dimension verticalStrut3 = new Dimension(1, 8);
    private static Dimension PREF_SIZE = new Dimension(425, 245);
    private static Dimension MIN_SIZE = new Dimension(425, 245);
    private static Dimension TREE_PREF_SIZE = new Dimension(380, 230);
    private static final int ACCESSORY_WIDTH = 250;
    private static final Logger LOG = Logger.getLogger(DirectoryChooserUI.class.getName());
    private static final String TIMEOUT_KEY = "nb.fileChooser.timeout";
    private JPanel centerPanel;
    private JLabel lookInComboBoxLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private ActionListener directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterTypeComboBoxModel filterTypeComboBoxModel;
    private JTextField filenameTextField;
    private JComponent placesBar;
    private boolean placesBarFailed = false;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterTypeComboBox;
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String homeFolderTooltipText = null;
    private Action newFolderAction = new NewDirectoryAction();
    private BasicFileChooserUI.BasicFileView fileView = new DirectoryChooserFileView();
    private static JTree tree;
    private DirectoryTreeModel model;
    private DirectoryNode newFolderNode;
    private JComponent treeViewPanel;
    private InputBlocker blocker;
    private static JFileChooser fileChooser;
    private boolean changeDirectory = true;
    private boolean showPopupCompletion = false;
    private boolean addNewDirectory = false;
    private JPopupMenu popupMenu;
    private FileCompletionPopup completionPopup;
    private RequestProcessor.Task updateWorker;
    private boolean useShellFolder = false;
    private JButton upFolderButton;
    private JButton newFolderButton;
    private JComponent topCombo;
    private JComponent topComboWrapper;
    private JComponent topToolbar;
    private JPanel slownessPanel;
    private CustomDirectoryProvider customDirectoryProvider;

    public static ComponentUI createUI(JComponent c) {
        return new DirectoryChooserUI((JFileChooser)c);
    }

    public DirectoryChooserUI(JFileChooser filechooser) {
        super(filechooser);
        Collection directoryProviders = Lookup.getDefault().lookupAll(CustomDirectoryProvider.class);
        this.customDirectoryProvider = null;
        for (CustomDirectoryProvider directoryProvider : directoryProviders) {
            if (!directoryProvider.isEnabled()) continue;
            this.customDirectoryProvider = directoryProvider;
            break;
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
        super.uninstallComponents(fc);
    }

    @Override
    public void installComponents(JFileChooser fc) {
        fileChooser = fc;
        fc.setFocusCycleRoot(true);
        fc.setBorder(new EmptyBorder(4, 10, 10, 10));
        fc.setLayout(new BorderLayout(8, 8));
        this.updateUseShellFolder();
        this.createCenterPanel(fc);
        fc.add((Component)this.centerPanel, "Center");
        if (fc.isMultiSelectionEnabled()) {
            this.setFileName(this.getStringOfFileNames(fc.getSelectedFiles()));
        } else {
            this.setFileName(this.getStringOfFileName(fc.getSelectedFile()));
        }
        if (fc.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
        this.createPopup();
    }

    @Override
    public String getDialogTitle(JFileChooser fc) {
        String title = super.getDialogTitle(fc);
        fc.getAccessibleContext().setAccessibleDescription(title);
        return title;
    }

    private void updateUseShellFolder() {
        Boolean prop = (Boolean)fileChooser.getClientProperty("FileChooser.useShellFolder");
        if (prop != null) {
            this.useShellFolder = prop;
        } else {
            File[] cbFolders;
            this.useShellFolder = false;
            File[] roots = fileChooser.getFileSystemView().getRoots();
            if (roots != null && roots.length == 1 && (cbFolders = this.getShellFolderRoots()) != null && cbFolders.length > 0 && roots[0] == cbFolders[0]) {
                this.useShellFolder = true;
            }
        }
        if (Utilities.isWindows()) {
            if (this.useShellFolder) {
                if (this.placesBar == null) {
                    this.placesBar = this.getPlacesBar();
                }
                if (this.placesBar != null) {
                    fileChooser.add((Component)this.placesBar, "Before");
                    if (this.placesBar instanceof PropertyChangeListener) {
                        fileChooser.addPropertyChangeListener((PropertyChangeListener)((Object)this.placesBar));
                    }
                }
            } else if (this.placesBar != null) {
                fileChooser.remove(this.placesBar);
                if (this.placesBar instanceof PropertyChangeListener) {
                    fileChooser.removePropertyChangeListener((PropertyChangeListener)((Object)this.placesBar));
                }
                this.placesBar = null;
            }
        }
    }

    private JComponent getPlacesBar() {
        if (this.placesBarFailed) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName("sun.swing.WindowsPlacesBar");
            Class[] params = new Class[]{JFileChooser.class, Boolean.TYPE};
            Constructor<?> constr = clazz.getConstructor(params);
            return (JComponent)constr.newInstance(fileChooser, this.isXPStyle());
        }
        catch (Exception exc) {
            Logger.getLogger(DirectoryChooserUI.class.getName()).log(Level.FINE, "WindowsPlacesBar class can't be instantiated.", exc);
            this.placesBarFailed = true;
            return null;
        }
    }

    private File getShellFolderForFile(File file) {
        try {
            Class<?> clazz = Class.forName("sun.awt.shell.ShellFolder");
            return (File)clazz.getMethod("getShellFolder", File.class).invoke(null, file);
        }
        catch (Exception exc) {
            Logger.getLogger(DirectoryChooserUI.class.getName()).log(Level.FINE, "ShellFolder can't be used.", exc);
            return null;
        }
    }

    private File getShellFolderForFileLinkLoc(File file) {
        try {
            Class<?> clazz = Class.forName("sun.awt.shell.ShellFolder");
            Object sf = clazz.getMethod("getShellFolder", File.class).invoke(null, file);
            return (File)clazz.getMethod("getLinkLocation", new Class[0]).invoke(sf, new Object[0]);
        }
        catch (Exception exc) {
            Logger.getLogger(DirectoryChooserUI.class.getName()).log(Level.FINE, "ShellFolder can't be used.", exc);
            return null;
        }
    }

    private File[] getShellFolderRoots() {
        try {
            Class<?> clazz = Class.forName("sun.awt.shell.ShellFolder");
            return (File[])clazz.getMethod("get", String.class).invoke(null, "fileChooserComboBoxFolders");
        }
        catch (Exception exc) {
            Logger.getLogger(DirectoryChooserUI.class.getName()).log(Level.FINE, "ShellFolder can't be used.", exc);
            return null;
        }
    }

    private void createBottomPanel(JFileChooser fc) {
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 2));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 3));
        labelPanel.add(Box.createRigidArea(verticalStrut1));
        JLabel fnl = new JLabel(this.fileNameLabelText);
        fnl.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        fnl.setAlignmentY(0.0f);
        labelPanel.add(fnl);
        labelPanel.add(Box.createRigidArea(new Dimension(1, 12)));
        JLabel ftl = new JLabel(this.filesOfTypeLabelText);
        ftl.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        labelPanel.add(ftl);
        this.bottomPanel.add(labelPanel);
        this.bottomPanel.add(Box.createRigidArea(new Dimension(15, 0)));
        JPanel fileAndFilterPanel = new JPanel();
        fileAndFilterPanel.add(Box.createRigidArea(verticalStrut3));
        fileAndFilterPanel.setLayout(new BoxLayout(fileAndFilterPanel, 1));
        this.filenameTextField = new JTextField(24){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        this.filenameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DirectoryChooserUI.this.updateCompletions();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DirectoryChooserUI.this.updateCompletions();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.filenameTextField.addKeyListener(new TextFieldKeyListener());
        fnl.setLabelFor(this.filenameTextField);
        this.filenameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!DirectoryChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    tree.clearSelection();
                }
            }
        });
        Set<AWTKeyStroke> tKeys = this.filenameTextField.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newTKeys = new HashSet<AWTKeyStroke>(tKeys);
        newTKeys.remove(AWTKeyStroke.getAWTKeyStroke(9, 0));
        newTKeys.add(AWTKeyStroke.getAWTKeyStroke(9, 128));
        this.filenameTextField.setFocusTraversalKeys(0, newTKeys);
        fileAndFilterPanel.add(this.filenameTextField);
        fileAndFilterPanel.add(Box.createRigidArea(verticalStrut3));
        this.filterTypeComboBoxModel = this.createFilterComboBoxModel();
        fc.addPropertyChangeListener(this.filterTypeComboBoxModel);
        this.filterTypeComboBox = new JComboBox(this.filterTypeComboBoxModel);
        ftl.setLabelFor(this.filterTypeComboBox);
        this.filterTypeComboBox.setRenderer(this.createFilterComboBoxRenderer());
        fileAndFilterPanel.add(this.filterTypeComboBox);
        this.bottomPanel.add(fileAndFilterPanel);
        this.bottomPanel.add(Box.createRigidArea(horizontalStrut1));
        this.createButtonsPanel(fc);
    }

    private void createButtonsPanel(JFileChooser fc) {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        this.approveButton = new JButton(this.getApproveButtonText(fc)){

            @Override
            public Dimension getMaximumSize() {
                return ((DirectoryChooserUI)DirectoryChooserUI.this).approveButton.getPreferredSize().width > ((DirectoryChooserUI)DirectoryChooserUI.this).cancelButton.getPreferredSize().width ? DirectoryChooserUI.this.approveButton.getPreferredSize() : DirectoryChooserUI.this.cancelButton.getPreferredSize();
            }
        };
        if (!Utilities.isMac()) {
            this.approveButton.setMnemonic(this.getApproveButtonMnemonic(fc));
        }
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.buttonPanel.add(Box.createRigidArea(verticalStrut1));
        this.buttonPanel.add(this.approveButton);
        this.buttonPanel.add(Box.createRigidArea(verticalStrut2));
        this.cancelButton = new JButton(this.cancelButtonText){

            @Override
            public Dimension getMaximumSize() {
                return ((DirectoryChooserUI)DirectoryChooserUI.this).approveButton.getPreferredSize().width > ((DirectoryChooserUI)DirectoryChooserUI.this).cancelButton.getPreferredSize().width ? DirectoryChooserUI.this.approveButton.getPreferredSize() : DirectoryChooserUI.this.cancelButton.getPreferredSize();
            }
        };
        if (!Utilities.isMac()) {
            this.cancelButton.setMnemonic(this.cancelButtonMnemonic);
        }
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.buttonPanel.add(this.cancelButton);
        if (this.customDirectoryProvider != null) {
            this.approveButton.setEnabled(false);
        }
    }

    private void createCenterPanel(final JFileChooser fc) {
        this.centerPanel = new JPanel(new BorderLayout());
        this.treeViewPanel = this.createTree();
        this.treeViewPanel.setPreferredSize(TREE_PREF_SIZE);
        JPanel treePanel = new JPanel();
        treePanel.setLayout(new BorderLayout());
        JComponent accessory = fc.getAccessory();
        this.topToolbar = this.createTopToolbar();
        this.topCombo = this.createTopCombo(fc);
        this.topComboWrapper = new JPanel(new BorderLayout());
        this.topComboWrapper.add((Component)this.topCombo, "Center");
        if (accessory == null) {
            this.topComboWrapper.add((Component)this.topToolbar, "East");
        }
        treePanel.add((Component)this.topComboWrapper, "North");
        treePanel.add((Component)this.treeViewPanel, "Center");
        this.centerPanel.add((Component)treePanel, "Center");
        JPanel wrapAccessory = new JPanel(){
            private Dimension prefSize = new Dimension(250, 0);
            private Dimension minSize = new Dimension(250, 0);

            @Override
            public Dimension getMinimumSize() {
                if (fc.getAccessory() != null) {
                    this.minSize.height = DirectoryChooserUI.this.getAccessoryPanel().getMinimumSize().height;
                    return this.minSize;
                }
                return super.getMinimumSize();
            }

            @Override
            public Dimension getPreferredSize() {
                if (fc.getAccessory() != null) {
                    Dimension origPref = DirectoryChooserUI.this.getAccessoryPanel().getPreferredSize();
                    LOG.fine("AccessoryWrapper.getPreferredSize: orig pref size: " + origPref);
                    this.prefSize.height = origPref.height;
                    this.prefSize.width = Math.max(this.prefSize.width, origPref.width);
                    int centerW = DirectoryChooserUI.this.centerPanel.getWidth();
                    if (centerW != 0 && this.prefSize.width > centerW / 2) {
                        this.prefSize.width = centerW / 2;
                    }
                    LOG.fine("AccessoryWrapper.getPreferredSize: resulting pref size: " + this.prefSize);
                    return this.prefSize;
                }
                return super.getPreferredSize();
            }
        };
        wrapAccessory.setLayout(new BorderLayout());
        JPanel accessoryPanel = this.getAccessoryPanel();
        if (accessory != null) {
            accessoryPanel.add((Component)this.topToolbar, "North");
            accessoryPanel.add((Component)accessory, "Center");
        }
        wrapAccessory.add((Component)accessoryPanel, "Center");
        this.centerPanel.add((Component)wrapAccessory, "East");
        this.createBottomPanel(fc);
        this.centerPanel.add((Component)this.bottomPanel, "South");
    }

    private JComponent createTopCombo(JFileChooser fc) {
        JPanel panel = new JPanel();
        if (fc.getAccessory() != null) {
            panel.setBorder(BorderFactory.createEmptyBorder(4, 0, 8, 0));
        } else {
            panel.setBorder(BorderFactory.createEmptyBorder(6, 0, 10, 0));
        }
        panel.setLayout(new BorderLayout());
        Box labelBox = Box.createHorizontalBox();
        this.lookInComboBoxLabel = new JLabel(this.lookInLabelText);
        this.lookInComboBoxLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        this.lookInComboBoxLabel.setAlignmentX(0.0f);
        this.lookInComboBoxLabel.setAlignmentY(0.5f);
        labelBox.add(this.lookInComboBoxLabel);
        labelBox.add(Box.createRigidArea(new Dimension(9, 0)));
        this.directoryComboBox = new JComboBox(){

            @Override
            public Dimension getMinimumSize() {
                Dimension d = super.getMinimumSize();
                d.width = 60;
                return d;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.height = 24;
                d.width = 150;
                return d;
            }
        };
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.lookInComboBoxLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(fc));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.5f);
        this.directoryComboBox.setMaximumRowCount(8);
        panel.add((Component)labelBox, "West");
        panel.add((Component)this.directoryComboBox, "Center");
        return panel;
    }

    private JComponent createTopToolbar() {
        JToolBar topPanel = new JToolBar();
        topPanel.setFloatable(false);
        if (Utilities.isWindows()) {
            topPanel.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        }
        this.upFolderButton = new JButton(this.getChangeToParentDirectoryAction());
        this.upFolderButton.setText(null);
        boolean isMac = Utilities.isMac();
        Icon upFolderIcon = null;
        if (!isMac) {
            upFolderIcon = UIManager.getIcon("FileChooser.upFolderIcon");
        }
        if (isMac || upFolderIcon == null) {
            upFolderIcon = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"/org/netbeans/swing/dirchooser/resources/upFolderIcon.gif", (boolean)false));
        }
        this.upFolderButton.setIcon(upFolderIcon);
        this.upFolderButton.setToolTipText(this.upFolderToolTipText);
        this.upFolderButton.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        this.upFolderButton.setAlignmentX(1.0f);
        this.upFolderButton.setAlignmentY(0.5f);
        if (this.useShellFolder) {
            this.upFolderButton.setFocusPainted(false);
        }
        topPanel.add(this.upFolderButton);
        topPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        if (!Utilities.isWindows()) {
            JButton homeButton = new JButton(this.getGoHomeAction());
            Icon homeIcon = null;
            if (!isMac) {
                homeIcon = UIManager.getIcon("FileChooser.homeFolderIcon");
            }
            if (isMac || homeIcon == null) {
                homeIcon = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"/org/netbeans/swing/dirchooser/resources/homeIcon.gif", (boolean)false));
            }
            homeButton.setIcon(homeIcon);
            homeButton.setText(null);
            String tooltip = homeButton.getToolTipText();
            if (tooltip == null) {
                tooltip = this.homeFolderTooltipText;
                if (tooltip == null) {
                    tooltip = NbBundle.getMessage(DirectoryChooserUI.class, (String)"TLTP_HomeFolder");
                }
                homeButton.setToolTipText(tooltip);
            }
            topPanel.add(homeButton);
        }
        this.newFolderButton = new JButton(this.newFolderAction);
        this.newFolderButton.setText(null);
        Icon newFolderIcon = null;
        if (!isMac) {
            newFolderIcon = UIManager.getIcon("FileChooser.newFolderIcon");
        }
        if (isMac || newFolderIcon == null) {
            newFolderIcon = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"/org/netbeans/swing/dirchooser/resources/newFolderIcon.gif", (boolean)false));
        }
        this.newFolderButton.setIcon(newFolderIcon);
        this.newFolderButton.setToolTipText(this.newFolderToolTipText);
        this.newFolderButton.setAlignmentX(1.0f);
        this.newFolderButton.setAlignmentY(0.5f);
        if (this.useShellFolder) {
            this.newFolderButton.setFocusPainted(false);
        }
        topPanel.add(this.newFolderButton);
        topPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(4, 9, 8, 0));
        panel.add((Component)topPanel, "Center");
        return panel;
    }

    private JComponent createTree() {
        final DirectoryHandler dirHandler = this.createDirectoryHandler(fileChooser);
        tree = new JTree(new Object[0]){
            private boolean firstPaint;
            {
                super(x0);
                this.firstPaint = true;
            }

            @Override
            protected void processMouseEvent(MouseEvent e) {
                dirHandler.preprocessMouseEvent(e);
                super.processMouseEvent(e);
            }

            @Override
            public boolean isLargeModel() {
                return true;
            }

            @Override
            public void setFont(Font f) {
                this.firstPaint = true;
                super.setFont(f);
            }

            @Override
            public void paint(Graphics g) {
                if (this.firstPaint) {
                    g.setFont(this.getFont());
                    this.setRowHeight(Math.max(17, g.getFontMetrics().getHeight()));
                    this.firstPaint = false;
                    return;
                }
                super.paint(g);
            }
        };
        File curDir = fileChooser.getCurrentDirectory();
        if (curDir == null) {
            curDir = fileChooser.getFileSystemView().getRoots()[0];
        }
        this.updateTree(curDir);
        tree.setFocusable(true);
        tree.setOpaque(true);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setToggleClickCount(0);
        tree.addTreeExpansionListener(new TreeExpansionHandler());
        TreeKeyHandler keyHandler = new TreeKeyHandler();
        tree.addKeyListener(keyHandler);
        tree.addFocusListener(keyHandler);
        tree.addMouseListener(dirHandler);
        tree.addFocusListener(dirHandler);
        tree.addTreeSelectionListener(dirHandler);
        if (fileChooser.isMultiSelectionEnabled()) {
            tree.getSelectionModel().setSelectionMode(4);
        } else {
            tree.getSelectionModel().setSelectionMode(1);
        }
        DirectoryCellEditor tce = new DirectoryCellEditor(tree, fileChooser, new JTextField());
        tree.setCellEditor(tce);
        tce.addCellEditorListener(dirHandler);
        tree.setCellRenderer(new DirectoryTreeRenderer());
        JScrollPane scrollBar = new JScrollPane(tree);
        scrollBar.setViewportView(tree);
        tree.setInvokesStopCellEditing(true);
        return scrollBar;
    }

    private List<TreePath> getVisiblePaths() {
        int rowCount = tree.getRowCount();
        Object node = null;
        ArrayList<TreePath> result = new ArrayList<TreePath>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            result.add(tree.getPathForRow(i));
        }
        return result;
    }

    private void createPopup() {
        this.popupMenu = new JPopupMenu();
        JMenuItem item1 = new JMenuItem(DirectoryChooserUI.getBundle().getString("LBL_NewFolder"));
        item1.addActionListener(this.newFolderAction);
        JMenuItem item2 = new JMenuItem(DirectoryChooserUI.getBundle().getString("LBL_Rename"));
        item2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryNode node = (DirectoryNode)tree.getLastSelectedPathComponent();
                DirectoryChooserUI.this.applyEdit(node);
            }
        });
        JMenuItem item3 = new JMenuItem(DirectoryChooserUI.getBundle().getString("LBL_Delete"));
        item3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryChooserUI.this.deleteAction();
            }
        });
        this.popupMenu.add(item1);
        this.popupMenu.add(item2);
        this.popupMenu.add(item3);
    }

    private void deleteAction() {
        final TreePath[] nodePath = tree.getSelectionPaths();
        if (nodePath == null) {
            return;
        }
        String message = "";
        if (nodePath.length == 1) {
            File file = ((DirectoryNode)nodePath[0].getLastPathComponent()).getFile();
            if (!DirectoryChooserUI.canWrite(file)) {
                return;
            }
            message = MessageFormat.format(DirectoryChooserUI.getBundle().getString("MSG_Delete"), file.getName());
        } else {
            message = MessageFormat.format(DirectoryChooserUI.getBundle().getString("MSG_Delete_Multiple"), nodePath.length);
        }
        int answer = JOptionPane.showConfirmDialog(fileChooser, message, DirectoryChooserUI.getBundle().getString("MSG_Confirm"), 0);
        if (answer == 0) {
            RequestProcessor.getDefault().post(new Runnable(){
                DirectoryNode node;
                ArrayList<File> list = new ArrayList();
                int cannotDelete;
                ArrayList<DirectoryNode> nodes2Remove = new ArrayList(nodePath.length);

                @Override
                public void run() {
                    if (!EventQueue.isDispatchThread()) {
                        DirectoryChooserUI.this.setCursor(fileChooser, 3);
                        this.cannotDelete = 0;
                        for (int i = 0; i < nodePath.length; ++i) {
                            DirectoryNode nodeToDelete = (DirectoryNode)nodePath[i].getLastPathComponent();
                            try {
                                FileObject fo = FileUtil.toFileObject((File)nodeToDelete.getFile());
                                fo.delete();
                                this.nodes2Remove.add(nodeToDelete);
                                continue;
                            }
                            catch (IOException ignore) {
                                ++this.cannotDelete;
                                if (!DirectoryChooserUI.canWrite(nodeToDelete.getFile())) continue;
                                this.list.add(nodeToDelete.getFile());
                            }
                        }
                        EventQueue.invokeLater(this);
                    } else {
                        for (DirectoryNode curNode : this.nodes2Remove) {
                            DirectoryChooserUI.this.model.removeNodeFromParent(curNode);
                        }
                        DirectoryChooserUI.this.setCursor(fileChooser, 0);
                        if (this.cannotDelete > 0) {
                            String message = "";
                            message = this.cannotDelete == 1 ? this.cannotDelete + " " + DirectoryChooserUI.getBundle().getString("MSG_Sing_Delete") : this.cannotDelete + " " + DirectoryChooserUI.getBundle().getString("MSG_Plur_Delete");
                            DirectoryChooserUI.this.setSelected(this.list.toArray(new File[this.list.size()]));
                            JOptionPane.showConfirmDialog(fileChooser, message, DirectoryChooserUI.getBundle().getString("MSG_Confirm"), 0);
                        } else {
                            DirectoryChooserUI.this.setSelected(new File[]{null});
                            DirectoryChooserUI.this.setFileName("");
                        }
                    }
                }
            });
        }
    }

    private void updateCompletions() {
        File[] children;
        String prefix;
        File d;
        String name = DirectoryChooserUI.normalizeFile(this.getFileName());
        int slash = name.lastIndexOf(File.separatorChar);
        if (slash != -1 && (d = new File(prefix = name.substring(0, slash + 1))).isDirectory() && (children = d.listFiles()) != null) {
            Vector<File> list = this.buildList(name, children);
            if (this.completionPopup == null) {
                this.completionPopup = new FileCompletionPopup(fileChooser, this.filenameTextField, list);
            } else if (this.completionPopup.isShowing() || this.showPopupCompletion && fileChooser.isShowing()) {
                this.completionPopup.setDataList(list);
            }
            if (this.showPopupCompletion && fileChooser.isShowing() && !this.completionPopup.isShowing()) {
                Point los = this.filenameTextField.getLocation();
                int popX = los.x;
                int popY = los.y + this.filenameTextField.getHeight() - 6;
                this.completionPopup.showPopup(this.filenameTextField, popX, popY);
            }
        }
    }

    public Vector<File> buildList(String text, File[] children) {
        Vector<File> files = new Vector<File>(children.length);
        for (int i = children.length - 1; i >= 0; --i) {
            String path;
            File completion = children[i];
            if (!fileChooser.accept(completion) || !(path = completion.getAbsolutePath()).regionMatches(true, 0, text, 0, text.length())) continue;
            if (fileChooser.getFileSelectionMode() == 1) {
                if (!completion.isDirectory()) continue;
                files.add(completion);
                continue;
            }
            if (fileChooser.getFileSelectionMode() == 0) {
                if (!completion.isFile()) continue;
                files.add(completion);
                continue;
            }
            if (fileChooser.getFileSelectionMode() != 2) continue;
            files.add(completion);
        }
        Collections.sort(files, DirectoryNode.FILE_NAME_COMPARATOR);
        return files;
    }

    private static String normalizeFile(String text) {
        Matcher m;
        Pattern p = Pattern.compile("(^|[^\\\\])\\$([a-zA-Z_0-9.]+)");
        while ((m = p.matcher(text)).find()) {
            String var = System.getenv(m.group(2));
            if (var == null) {
                var = System.getProperty(m.group(2), "");
            }
            text = text.substring(0, m.end(1)) + var + text.substring(m.end(2));
        }
        if (text.equals("~")) {
            return System.getProperty("user.home");
        }
        if (text.startsWith("~" + File.separatorChar)) {
            return System.getProperty("user.home") + text.substring(1);
        }
        int i = text.lastIndexOf("//");
        if (i != -1) {
            return text.substring(i + 1);
        }
        i = text.lastIndexOf(File.separatorChar + "~" + File.separatorChar);
        if (i != -1) {
            return System.getProperty("user.home") + text.substring(i + 2);
        }
        return text;
    }

    private static ResourceBundle getBundle() {
        return NbBundle.getBundle(DirectoryChooserUI.class);
    }

    private void updateTree(final File file) {
        if (this.updateWorker != null) {
            if (!this.updateWorker.isFinished()) {
                this.updateWorker.cancel();
            }
            this.updateWorker.waitFinished();
        }
        this.updateWorker = RequestProcessor.getDefault().post(new Runnable(){
            DirectoryNode node;
            long startTime;

            @Override
            public void run() {
                if (!EventQueue.isDispatchThread()) {
                    DirectoryChooserUI.this.markStartTime();
                    DirectoryChooserUI.this.setCursor(fileChooser, 3);
                    this.node = new DirectoryNode(file);
                    this.node.loadChildren(fileChooser, true);
                    EventQueue.invokeLater(this);
                } else {
                    DirectoryChooserUI.this.model = new DirectoryTreeModel(this.node);
                    tree.setModel(DirectoryChooserUI.this.model);
                    tree.repaint();
                    DirectoryChooserUI.this.setCursor(fileChooser, 0);
                    DirectoryChooserUI.this.checkUpdate();
                }
            }
        });
    }

    private void markStartTime() {
        if (fileChooser.getClientProperty("start.time") == null) {
            fileChooser.putClientProperty("start.time", System.currentTimeMillis());
        }
    }

    private void checkUpdate() {
        if (Utilities.isWindows() && this.useShellFolder) {
            Long startTime = (Long)fileChooser.getClientProperty("start.time");
            if (startTime == null) {
                return;
            }
            fileChooser.putClientProperty("start.time", null);
            long elapsed = System.currentTimeMillis() - startTime;
            long timeOut = NbPreferences.forModule(DirectoryChooserUI.class).getLong(TIMEOUT_KEY, 10000L);
            if (timeOut > 0L && elapsed > timeOut && this.slownessPanel == null) {
                JLabel slownessNote = new JLabel(NbBundle.getMessage(DirectoryChooserUI.class, (String)"MSG_SlownessNote"));
                slownessNote.setForeground(Color.RED);
                this.slownessPanel = new JPanel();
                JButton notShow = new JButton(NbBundle.getMessage(DirectoryChooserUI.class, (String)"BTN_NotShow"));
                notShow.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NbPreferences.forModule(DirectoryChooserUI.class).putLong(DirectoryChooserUI.TIMEOUT_KEY, 0L);
                        DirectoryChooserUI.this.centerPanel.remove(DirectoryChooserUI.this.slownessPanel);
                        DirectoryChooserUI.this.centerPanel.revalidate();
                    }
                });
                JPanel notShowP = new JPanel();
                notShowP.add(notShow);
                this.slownessPanel.setLayout(new BorderLayout());
                this.slownessPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
                this.slownessPanel.add("Center", slownessNote);
                this.slownessPanel.add("South", notShowP);
                this.centerPanel.add("North", this.slownessPanel);
                this.centerPanel.revalidate();
            }
        }
    }

    private Boolean isXPStyle() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Boolean themeActive = (Boolean)toolkit.getDesktopProperty("win.xpstyle.themeActive");
        if (themeActive == null) {
            themeActive = Boolean.FALSE;
        }
        if (themeActive.booleanValue() && System.getProperty("swing.noxp") == null) {
            themeActive = Boolean.TRUE;
        }
        return themeActive;
    }

    @Override
    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        Locale l = fc.getLocale();
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString((Object)"FileChooser.lookInLabelText", l);
        this.saveInLabelText = UIManager.getString((Object)"FileChooser.saveInLabelText", l);
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", l);
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", l);
        this.upFolderToolTipText = UIManager.getString((Object)"FileChooser.upFolderToolTipText", l);
        this.upFolderAccessibleName = UIManager.getString((Object)"FileChooser.upFolderAccessibleName", l);
        this.newFolderToolTipText = UIManager.getString((Object)"FileChooser.newFolderToolTipText", l);
        this.homeFolderTooltipText = UIManager.getString((Object)"FileChooser.homeFolderToolTipText", l);
    }

    @Override
    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(fc, actionMap);
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    protected ActionMap createActionMap() {
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryChooserUI.this.getFileChooser().cancelSelection();
            }

            @Override
            public boolean isEnabled() {
                return DirectoryChooserUI.this.getFileChooser().isEnabled();
            }
        };
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("approveSelection", this.getApproveSelectionAction());
        map.put("cancelSelection", escAction);
        map.put("Go Up", this.getChangeToParentDirectoryAction());
        return map;
    }

    @Override
    public Action getNewFolderAction() {
        return this.newFolderAction;
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.filterTypeComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.filenameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int prefWidth = DirectoryChooserUI.PREF_SIZE.width;
        Dimension d = c.getLayout().preferredLayoutSize(c);
        if (d != null) {
            return new Dimension(d.width < prefWidth ? prefWidth : d.width, d.height < DirectoryChooserUI.PREF_SIZE.height ? DirectoryChooserUI.PREF_SIZE.height : d.height);
        }
        return new Dimension(prefWidth, DirectoryChooserUI.PREF_SIZE.height);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return MIN_SIZE;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private String getStringOfFileName(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser fc = this.getFileChooser();
        if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String getStringOfFileNames(File[] files) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            if (files.length > 1) {
                buf.append("\"");
            }
            buf.append(this.getStringOfFileName(files[i]));
            if (files.length <= 1) continue;
            buf.append("\"");
        }
        return buf.toString();
    }

    private void fireSelectedFileChanged(PropertyChangeEvent e) {
        File f = (File)e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (f != null && (fc.isFileSelectionEnabled() && !f.isDirectory() || f.isDirectory() && fc.isDirectorySelectionEnabled())) {
            this.setFileName(this.getStringOfFileName(f));
        }
        if (this.customDirectoryProvider != null) {
            this.approveButton.setEnabled(this.customDirectoryProvider.isValidCustomDirectory(f));
        }
    }

    private void fireSelectedFilesChanged(PropertyChangeEvent e) {
        File[] files = (File[])e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (files != null && files.length > 0 && (files.length > 1 || fc.isDirectorySelectionEnabled() || !files[0].isDirectory())) {
            this.setFileName(this.getStringOfFileNames(files));
        }
    }

    private void fireDirectoryChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        FileSystemView fsv = fc.getFileSystemView();
        this.showPopupCompletion = false;
        this.setFileName("");
        this.clearIconCache();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null) {
            this.directoryComboBoxModel.addItem(currentDirectory);
            this.newFolderAction.setEnabled(currentDirectory.canWrite());
            this.getChangeToParentDirectoryAction().setEnabled(!fsv.isRoot(currentDirectory));
            this.updateTree(currentDirectory);
            if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
                if (fsv.isFileSystem(currentDirectory)) {
                    this.setFileName(this.getStringOfFileName(currentDirectory));
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    private void fireFilterChanged(PropertyChangeEvent e) {
        this.clearIconCache();
    }

    private void fireFileSelectionModeChanged(PropertyChangeEvent e) {
        this.clearIconCache();
        JFileChooser fc = this.getFileChooser();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null && fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystem(currentDirectory)) {
            this.setFileName(currentDirectory.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void fireMultiSelectionChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            tree.getSelectionModel().setSelectionMode(4);
        } else {
            tree.getSelectionModel().setSelectionMode(1);
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private void fireAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent oldAcc = (JComponent)e.getOldValue();
            JComponent newAcc = (JComponent)e.getNewValue();
            JPanel accessoryPanel = this.getAccessoryPanel();
            if (oldAcc != null) {
                accessoryPanel.remove(oldAcc);
            }
            if (oldAcc != null && newAcc == null) {
                accessoryPanel.remove(this.topToolbar);
                this.topComboWrapper.add((Component)this.topToolbar, "East");
                this.topCombo.setBorder(BorderFactory.createEmptyBorder(6, 0, 10, 0));
                this.topCombo.revalidate();
            }
            if (newAcc != null) {
                this.getAccessoryPanel().add((Component)newAcc, "Center");
            }
            if (oldAcc == null && newAcc != null) {
                this.topComboWrapper.remove(this.topToolbar);
                this.topCombo.setBorder(BorderFactory.createEmptyBorder(4, 0, 8, 0));
                accessoryPanel.add((Component)this.topToolbar, "North");
            }
        }
    }

    private void fireApproveButtonTextChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        if (!Utilities.isMac()) {
            this.approveButton.setMnemonic(this.getApproveButtonMnemonic(chooser));
        }
    }

    private void fireDialogTypeChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        if (!Utilities.isMac()) {
            this.approveButton.setMnemonic(this.getApproveButtonMnemonic(chooser));
        }
        if (chooser.getDialogType() == 1) {
            this.lookInComboBoxLabel.setText(this.saveInLabelText);
        } else {
            this.lookInComboBoxLabel.setText(this.lookInLabelText);
        }
    }

    private void fireApproveButtonMnemonicChanged(PropertyChangeEvent e) {
        if (!Utilities.isMac()) {
            this.approveButton.setMnemonic(this.getApproveButtonMnemonic(this.getFileChooser()));
        }
    }

    private void fireControlButtonsChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String s = e.getPropertyName();
                if (s.equals("SelectedFileChangedProperty")) {
                    DirectoryChooserUI.this.fireSelectedFileChanged(e);
                } else if (s.equals("SelectedFilesChangedProperty")) {
                    DirectoryChooserUI.this.fireSelectedFilesChanged(e);
                } else if (s.equals("directoryChanged") && DirectoryChooserUI.this.changeDirectory) {
                    DirectoryChooserUI.this.fireDirectoryChanged(e);
                } else if (s.equals("fileFilterChanged")) {
                    DirectoryChooserUI.this.fireFilterChanged(e);
                } else if (s.equals("fileSelectionChanged")) {
                    DirectoryChooserUI.this.fireFileSelectionModeChanged(e);
                } else if (s.equals("MultiSelectionEnabledChangedProperty")) {
                    DirectoryChooserUI.this.fireMultiSelectionChanged(e);
                } else if (s.equals("AccessoryChangedProperty")) {
                    DirectoryChooserUI.this.fireAccessoryChanged(e);
                } else if (s.equals("ApproveButtonTextChangedProperty") || s.equals("ApproveButtonToolTipTextChangedProperty")) {
                    DirectoryChooserUI.this.fireApproveButtonTextChanged(e);
                } else if (s.equals("DialogTypeChangedProperty")) {
                    DirectoryChooserUI.this.fireDialogTypeChanged(e);
                } else if (s.equals("ApproveButtonMnemonicChangedProperty")) {
                    DirectoryChooserUI.this.fireApproveButtonMnemonicChanged(e);
                } else if (s.equals("ControlButtonsAreShownChangedProperty")) {
                    DirectoryChooserUI.this.fireControlButtonsChanged(e);
                } else if (s.equals("FileChooser.useShellFolder")) {
                    DirectoryChooserUI.this.updateUseShellFolder();
                    DirectoryChooserUI.this.fireDirectoryChanged(e);
                } else if (s.equals("componentOrientation")) {
                    ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                    JFileChooser cc = (JFileChooser)e.getSource();
                    if (o != (ComponentOrientation)e.getOldValue()) {
                        cc.applyComponentOrientation(o);
                    }
                } else if (s.equals("ancestor") && e.getOldValue() == null && e.getNewValue() != null) {
                    DirectoryChooserUI.this.filenameTextField.selectAll();
                    DirectoryChooserUI.this.filenameTextField.requestFocus();
                }
            }
        };
    }

    protected void removeControlButtons() {
        this.bottomPanel.remove(this.buttonPanel);
    }

    protected void addControlButtons() {
        this.bottomPanel.add(this.buttonPanel);
    }

    @Override
    public String getFileName() {
        if (this.filenameTextField != null) {
            return this.filenameTextField.getText();
        }
        return null;
    }

    @Override
    public void setFileName(String filename) {
        if (this.filenameTextField != null) {
            this.filenameTextField.setText(filename);
        }
    }

    private DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser fc) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterTypeComboBoxModel createFilterComboBoxModel() {
        return new FilterTypeComboBoxModel();
    }

    @Override
    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    @Override
    public FileView getFileView(JFileChooser fc) {
        if (Utilities.isWindows()) {
            if (this.useShellFolder) {
                this.fileView = new DirectoryChooserFileView();
            }
        } else {
            this.fileView = (BasicFileChooserUI.BasicFileView)super.getFileView(fileChooser);
        }
        return this.fileView;
    }

    private void setSelected(File[] files) {
        this.changeDirectory = false;
        fileChooser.setSelectedFiles(files);
        this.changeDirectory = true;
    }

    private DirectoryHandler createDirectoryHandler(JFileChooser chooser) {
        return new DirectoryHandler(chooser);
    }

    private void addNewDirectory(final TreePath path) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DirectoryNode selectedNode = (DirectoryNode)path.getLastPathComponent();
                        if (selectedNode == null || !DirectoryChooserUI.canWrite(selectedNode.getFile())) {
                            return;
                        }
                        try {
                            DirectoryChooserUI.this.newFolderNode = new DirectoryNode(fileChooser.getFileSystemView().createNewFolder(selectedNode.getFile()));
                            DirectoryChooserUI.this.model.insertNodeInto(DirectoryChooserUI.this.newFolderNode, selectedNode, selectedNode.getChildCount());
                            DirectoryChooserUI.this.applyEdit(DirectoryChooserUI.this.newFolderNode);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
        });
    }

    private void applyEdit(DirectoryNode node) {
        Object[] nodes = this.model.getPathToRoot(node);
        TreePath editingPath = new TreePath(nodes);
        tree.setEditable(true);
        tree.makeVisible(editingPath);
        tree.scrollPathToVisible(editingPath);
        tree.setSelectionPath(editingPath);
        tree.startEditingAtPath(editingPath);
        JTextField editField = DirectoryCellEditor.getTextField();
        editField.setCursor(Cursor.getPredefinedCursor(2));
        editField.setRequestFocusEnabled(true);
        editField.requestFocus();
        editField.setSelectionStart(0);
        editField.setSelectionEnd(editField.getText().length());
    }

    private static boolean canWrite(File f) {
        boolean writeable = false;
        if (f != null) {
            try {
                writeable = f.canWrite();
            }
            catch (AccessControlException ex) {
                writeable = false;
            }
        }
        return writeable;
    }

    private void expandNode(final JFileChooser fileChooser, final TreePath path) {
        RequestProcessor.getDefault().post(new Runnable(){
            DirectoryNode node;

            @Override
            public void run() {
                if (!EventQueue.isDispatchThread()) {
                    DirectoryChooserUI.this.markStartTime();
                    DirectoryChooserUI.this.setCursor(fileChooser, 3);
                    this.node = (DirectoryNode)path.getLastPathComponent();
                    this.node.loadChildren(fileChooser, true);
                    EventQueue.invokeLater(this);
                } else {
                    ((DefaultTreeModel)tree.getModel()).nodeStructureChanged(this.node);
                    if (DirectoryChooserUI.this.addNewDirectory) {
                        DirectoryChooserUI.this.addNewDirectory(path);
                        DirectoryChooserUI.this.addNewDirectory = false;
                    }
                    DirectoryChooserUI.this.setCursor(fileChooser, 0);
                    DirectoryChooserUI.this.checkUpdate();
                }
            }
        });
    }

    private void setCursor(JComponent comp, int type) {
        Window window = SwingUtilities.getWindowAncestor(comp);
        if (window != null) {
            Cursor cursor = Cursor.getPredefinedCursor(type);
            window.setCursor(cursor);
            window.setFocusable(true);
        }
        JRootPane pane = fileChooser.getRootPane();
        if (null == this.blocker) {
            this.blocker = new InputBlocker();
        }
        if (type == 3) {
            this.blocker.block(pane);
        } else if (type == 0) {
            this.blocker.unBlock(pane);
        }
    }

    private void refreshNode(TreePath path, final DirectoryNode node) {
        final File folder = node.getFile();
        if (!folder.exists()) {
            TreePath parentPath = path.getParentPath();
            boolean refreshTree = false;
            if (tree.isExpanded(path)) {
                tree.collapsePath(path);
                refreshTree = true;
            }
            this.model.removeNodeFromParent(node);
            if (refreshTree) {
                tree.expandPath(parentPath);
            }
            return;
        }
        RequestProcessor.getDefault().post(new Runnable(){
            private Set<String> realDirs;

            @Override
            public void run() {
                if (!EventQueue.isDispatchThread()) {
                    this.realDirs = new HashSet<String>();
                    File[] files = folder.listFiles();
                    for (File file : files = files == null ? new File[]{} : files) {
                        if (!file.isDirectory()) continue;
                        String name = file.getName();
                        this.realDirs.add(name);
                    }
                    SwingUtilities.invokeLater(this);
                } else {
                    HashSet currentNames;
                    int count = node.getChildCount();
                    HashMap<String, DirectoryNode> currentFiles = new HashMap<String, DirectoryNode>();
                    for (int i = 0; i < count; ++i) {
                        TreeNode child = node.getChildAt(i);
                        if (!(child instanceof DirectoryNode)) continue;
                        File file = ((DirectoryNode)child).getFile();
                        currentFiles.put(file.getName(), (DirectoryNode)child);
                    }
                    HashSet<String> realCloned = new HashSet<String>(this.realDirs);
                    if (realCloned.removeAll(currentFiles.keySet())) {
                        for (String name : realCloned) {
                            DirectoryNode added = new DirectoryNode(new File(folder, name));
                            DirectoryChooserUI.this.model.insertNodeInto(added, node, node.getChildCount());
                        }
                    }
                    if ((currentNames = new HashSet(currentFiles.keySet())).removeAll(this.realDirs)) {
                        for (String name : currentNames) {
                            DirectoryNode removed = (DirectoryNode)currentFiles.get(name);
                            DirectoryChooserUI.this.model.removeNodeFromParent(removed);
                        }
                    }
                }
            }
        });
    }

    private class DirectoryTreeModel
    extends DefaultTreeModel {
        public DirectoryTreeModel(TreeNode root) {
            super(root);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            File newFile;
            boolean refreshTree = false;
            DirectoryNode node = (DirectoryNode)path.getLastPathComponent();
            File f = node.getFile();
            if (f.renameTo(newFile = new File(f.getParentFile(), (String)newValue))) {
                if (tree.isExpanded(path)) {
                    tree.collapsePath(path);
                    refreshTree = true;
                }
                node.setFile(newFile);
                node.removeAllChildren();
                ((DefaultTreeModel)tree.getModel()).nodeStructureChanged(node);
                if (refreshTree) {
                    tree.expandPath(path);
                }
            }
        }
    }

    private class DirectoryTreeRenderer
    implements TreeCellRenderer {
        HtmlRenderer.Renderer renderer = HtmlRenderer.createRenderer();

        private DirectoryTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component stringDisplayer = this.renderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
            if (value instanceof DirectoryNode) {
                tree.setShowsRootHandles(true);
                DirectoryNode node = (DirectoryNode)value;
                ((JLabel)stringDisplayer).setIcon(this.getNodeIcon(node));
                ((JLabel)stringDisplayer).setText(this.getNodeText(node.getFile()));
            }
            Font f = stringDisplayer.getFont();
            stringDisplayer.setPreferredSize(new Dimension(stringDisplayer.getPreferredSize().width, 30));
            ((JComponent)stringDisplayer).setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
            stringDisplayer.setSize(stringDisplayer.getPreferredSize());
            return stringDisplayer;
        }

        private Icon getNodeIcon(DirectoryNode node) {
            File file = node.getFile();
            if (file.exists()) {
                if (DirectoryChooserUI.this.customDirectoryProvider != null && DirectoryChooserUI.this.customDirectoryProvider.isValidCustomDirectory(file)) {
                    return DirectoryChooserUI.this.customDirectoryProvider.getCustomDirectoryIcon();
                }
                return fileChooser.getIcon(file);
            }
            return null;
        }

        private String getNodeText(File file) {
            if (file.exists()) {
                return "<html>" + fileChooser.getName(file) + "</html>";
            }
            return "<html></html>";
        }
    }

    private class NewDirectoryAction
    extends AbstractAction {
        private NewDirectoryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath path = tree.getSelectionPath();
            if (path == null) {
                DirectoryChooserUI.this.addNewDirectory(new TreePath(DirectoryChooserUI.this.model.getPathToRoot((DirectoryNode)tree.getModel().getRoot())));
            }
            if (path != null) {
                if (tree.isExpanded(path)) {
                    DirectoryChooserUI.this.addNewDirectory(path);
                } else {
                    DirectoryChooserUI.this.addNewDirectory = true;
                    tree.expandPath(path);
                }
            }
        }
    }

    private class TreeExpansionHandler
    implements TreeExpansionListener {
        private TreeExpansionHandler() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent evt) {
            TreePath path = evt.getPath();
            DirectoryNode node = (DirectoryNode)path.getLastPathComponent();
            if (!node.isLoaded()) {
                DirectoryChooserUI.this.expandNode(fileChooser, path);
            } else {
                if (DirectoryChooserUI.this.addNewDirectory) {
                    DirectoryChooserUI.this.addNewDirectory(path);
                    DirectoryChooserUI.this.addNewDirectory = false;
                }
                DirectoryChooserUI.this.refreshNode(path, node);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }

    private class DirectoryHandler
    extends MouseAdapter
    implements TreeSelectionListener,
    CellEditorListener,
    ActionListener,
    FocusListener,
    Runnable {
        private JFileChooser fileChooser;
        private WeakReference<TreePath> curSelPath;
        private Timer renameTimer;
        private TreePath pathToRename;

        public DirectoryHandler(JFileChooser fileChooser) {
            this.fileChooser = fileChooser;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DirectoryNode node;
            File file;
            DirectoryChooserUI.this.showPopupCompletion = false;
            FileSystemView fsv = this.fileChooser.getFileSystemView();
            JTree tree = (JTree)e.getSource();
            TreePath path = tree.getSelectionPath();
            TreePath curSel = e.getNewLeadSelectionPath();
            WeakReference<TreePath> weakReference = this.curSelPath = curSel != null ? new WeakReference<TreePath>(curSel) : null;
            if (path != null && (file = (node = (DirectoryNode)path.getLastPathComponent()).getFile()) != null) {
                DirectoryChooserUI.this.setSelected(this.getSelectedNodes(tree.getSelectionPaths()));
                DirectoryChooserUI.this.newFolderAction.setEnabled(DirectoryChooserUI.canWrite(file) && file.isDirectory());
                if (file.isDirectory()) {
                    DirectoryChooserUI.this.setDirectorySelected(true);
                }
            }
        }

        private File[] getSelectedNodes(TreePath[] paths) {
            Vector<File> files = new Vector<File>();
            for (int i = 0; i < paths.length; ++i) {
                File file = ((DirectoryNode)paths[i].getLastPathComponent()).getFile();
                if (file.isDirectory() && this.fileChooser.isTraversable(file) && !this.fileChooser.getFileSystemView().isFileSystem(file)) continue;
                files.add(file);
            }
            return files.toArray(new File[files.size()]);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int y;
            JTree tree = (JTree)e.getSource();
            Point p = e.getPoint();
            int x = e.getX();
            int row = tree.getRowForLocation(x, y = e.getY());
            TreePath path = tree.getPathForRow(row);
            if (path != null) {
                DirectoryNode node = (DirectoryNode)path.getLastPathComponent();
                DirectoryChooserUI.this.newFolderAction.setEnabled(DirectoryChooserUI.canWrite(node.getFile()));
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    this.cancelRename();
                    if (node.isNetBeansProject()) {
                        this.fileChooser.approveSelection();
                    } else if (node.getFile().isFile() && !node.getFile().getPath().endsWith(".lnk")) {
                        this.fileChooser.approveSelection();
                    } else {
                        this.changeTreeDirectory(node.getFile());
                    }
                }
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1 && this.pathToRename != null) {
                    if (this.renameTimer != null) {
                        this.renameTimer.stop();
                    }
                    this.renameTimer = new Timer(800, this);
                    this.renameTimer.setRepeats(false);
                    this.renameTimer.start();
                }
                ((DirectoryTreeModel)tree.getModel()).nodeChanged(node);
                if (row == 0) {
                    tree.revalidate();
                    tree.repaint();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handlePopupMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handlePopupMenu(e);
        }

        private void handlePopupMenu(MouseEvent e) {
            int y;
            if (!e.isPopupTrigger()) {
                return;
            }
            JTree tree = (JTree)e.getSource();
            Point p = e.getPoint();
            int x = e.getX();
            int row = tree.getRowForLocation(x, y = e.getY());
            TreePath path = tree.getPathForRow(row);
            if (path != null) {
                DirectoryNode node = (DirectoryNode)path.getLastPathComponent();
                ((DirectoryTreeModel)tree.getModel()).nodeChanged(node);
                if (!this.fileChooser.getFileSystemView().isFileSystem(node.getFile())) {
                    return;
                }
                tree.setSelectionPath(path);
                DirectoryChooserUI.this.popupMenu.show(tree, x, y);
            }
        }

        private void changeTreeDirectory(File dir) {
            if (File.separatorChar == '\\' && dir.getPath().endsWith(".lnk")) {
                File linkLocation = DirectoryChooserUI.this.getShellFolderForFileLinkLoc(dir);
                if (linkLocation != null && this.fileChooser.isTraversable(linkLocation)) {
                    dir = linkLocation;
                } else {
                    return;
                }
            }
            this.fileChooser.setCurrentDirectory(dir);
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            DirectoryNode node = (DirectoryNode)tree.getLastSelectedPathComponent();
            if (node != null) {
                DirectoryChooserUI.this.setFileName(DirectoryChooserUI.this.getStringOfFileName(node.getFile()));
            }
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DirectoryNode node;
            if (tree.isFocusOwner() && this.isSelectionKept(this.pathToRename) && (node = (DirectoryNode)tree.getLastSelectedPathComponent()) != null) {
                DirectoryChooserUI.this.applyEdit(node);
            }
            this.cancelRename();
        }

        void preprocessMouseEvent(MouseEvent e) {
            if (e.getID() != 501 || e.getButton() != 1) {
                return;
            }
            TreePath clickedPath = tree.getPathForLocation(e.getX(), e.getY());
            if (clickedPath != null && this.isSelectionKept(clickedPath)) {
                this.pathToRename = clickedPath;
            }
        }

        private boolean isSelectionKept(TreePath selPath) {
            TreePath oldSel;
            return this.curSelPath != null && (oldSel = (TreePath)this.curSelPath.get()) != null && oldSel.equals(selPath);
        }

        private void cancelRename() {
            if (this.renameTimer != null) {
                this.renameTimer.stop();
                this.renameTimer = null;
            }
            this.pathToRename = null;
        }

        @Override
        public void focusGained(FocusEvent e) {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            this.cancelRename();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.cancelRename();
        }
    }

    private class TextFieldKeyListener
    extends KeyAdapter {
        private TextFieldKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            DirectoryChooserUI.this.showPopupCompletion = true;
            int keyCode = evt.getKeyCode();
            if (DirectoryChooserUI.this.completionPopup != null && !DirectoryChooserUI.this.completionPopup.isVisible()) {
                File file;
                if (keyCode == 10 && (file = new File(DirectoryChooserUI.this.filenameTextField.getText())).exists() && file.isDirectory()) {
                    DirectoryChooserUI.this.setSelected(new File[]{file});
                    fileChooser.approveSelection();
                }
                if (keyCode == 9 || keyCode == 40 || keyCode == 39 && DirectoryChooserUI.this.filenameTextField.getCaretPosition() >= DirectoryChooserUI.this.filenameTextField.getDocument().getLength() - 1) {
                    DirectoryChooserUI.this.updateCompletions();
                }
            }
            if (DirectoryChooserUI.this.filenameTextField.isFocusOwner() && (DirectoryChooserUI.this.completionPopup == null || !DirectoryChooserUI.this.completionPopup.isVisible()) && keyCode == 27) {
                fileChooser.cancelSelection();
            }
        }
    }

    private class DirectoryChooserFileView
    extends BasicFileChooserUI.BasicFileView {
        private DirectoryChooserFileView() {
            super(DirectoryChooserUI.this);
        }

        @Override
        public Icon getIcon(File f) {
            Icon icon = this.getCachedIcon(f);
            if (icon != null) {
                return icon;
            }
            if (f != null) {
                try {
                    icon = fileChooser.getFileSystemView().getSystemIcon(f);
                }
                catch (NullPointerException exc) {
                    LOG.log(Level.FINE, "JDK bug 6357445 encountered, NPE caught", exc);
                }
            }
            if (icon == null) {
                icon = super.getIcon(f);
            }
            this.cacheIcon(f, icon);
            return icon;
        }
    }

    private class DirectoryComboBoxAction
    implements ActionListener {
        private DirectoryComboBoxAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f = (File)DirectoryChooserUI.this.directoryComboBox.getSelectedItem();
            DirectoryChooserUI.this.getFileChooser().setCurrentDirectory(f);
        }
    }

    protected class FilterTypeComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterTypeComboBoxModel() {
            this.filters = DirectoryChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public void setSelectedItem(Object filter) {
            if (filter != null) {
                DirectoryChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                DirectoryChooserUI.this.setFileName(null);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            FileFilter currentFilter = DirectoryChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                for (int i = 0; i < this.filters.length; ++i) {
                    if (this.filters[i] != currentFilter) continue;
                    found = true;
                }
                if (!found) {
                    DirectoryChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return DirectoryChooserUI.this.getFileChooser().getFileFilter();
        }

        @Override
        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        @Override
        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return DirectoryChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    private class FilterComboBoxRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public FilterComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value != null && value instanceof FileFilter) {
                this.setText(((FileFilter)value).getDescription());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector<File> directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser = DirectoryChooserUI.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File dir = DirectoryChooserUI.this.getFileChooser().getCurrentDirectory();
            if (dir != null) {
                this.addItem(dir);
            }
        }

        private void addItem(File directory) {
            File sf;
            File f;
            if (directory == null) {
                return;
            }
            this.directories.clear();
            if (DirectoryChooserUI.this.useShellFolder) {
                this.directories.addAll(Arrays.asList(DirectoryChooserUI.this.getShellFolderRoots()));
            } else {
                this.directories.addAll(Arrays.asList(fileChooser.getFileSystemView().getRoots()));
            }
            File canonical = null;
            try {
                canonical = directory.getCanonicalFile();
            }
            catch (IOException e) {
                canonical = directory;
            }
            Vector<File> path = new Vector<File>(10);
            for (f = sf = DirectoryChooserUI.this.getShellFolderForFile(canonical); f != null; f = f.getParentFile()) {
                path.addElement(f);
            }
            int pathCount = path.size();
            for (int i = 0; i < pathCount; ++i) {
                f = (File)path.get(i);
                if (!this.directories.contains(f)) continue;
                int topIndex = this.directories.indexOf(f);
                for (int j = i - 1; j >= 0; --j) {
                    this.directories.insertElementAt((File)path.get(j), topIndex + i - j);
                }
                break;
            }
            this.calculateDepths();
            this.setSelectedItem(sf);
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            block0: for (int i = 0; i < this.depths.length; ++i) {
                File dir = this.directories.get(i);
                File parent = dir.getParentFile();
                this.depths[i] = 0;
                if (parent == null) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!parent.equals(this.directories.get(j))) continue;
                    this.depths[i] = this.depths[j] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int i) {
            return this.depths != null && i >= 0 && i < this.depths.length ? this.depths[i] : 0;
        }

        @Override
        public void setSelectedItem(Object selectedDirectory) {
            this.selectedDirectory = (File)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        @Override
        public int getSize() {
            return this.directories.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.directories.elementAt(index);
        }
    }

    private class DirectoryComboBoxRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        IconIndenter indenter;

        public DirectoryComboBoxRenderer() {
            this.indenter = new IconIndenter();
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon;
            this.setName("ComboBox.listRenderer");
            if (value == null) {
                this.setText("");
                return this;
            }
            File directory = (File)value;
            this.setText(DirectoryChooserUI.this.getFileChooser().getName(directory));
            this.indenter.icon = icon = DirectoryChooserUI.this.getFileChooser().getIcon(directory);
            this.indenter.depth = DirectoryChooserUI.this.directoryComboBoxModel.getDepth(index);
            this.setIcon(this.indenter);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private class IconIndenter
    implements Icon {
        static final int space = 10;
        Icon icon = null;
        int depth = 0;

        private IconIndenter() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.icon == null) {
                return;
            }
            if (c.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(c, g, x + this.depth * 10, y);
            } else {
                this.icon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.icon != null ? Integer.valueOf(this.icon.getIconWidth() + this.depth * 10) : null;
        }

        @Override
        public int getIconHeight() {
            return this.icon != null ? Integer.valueOf(this.icon.getIconHeight()) : null;
        }
    }

    class TreeKeyHandler
    extends KeyAdapter
    implements FocusListener {
        StringBuffer searchBuf = new StringBuffer();
        List<TreePath> paths;

        TreeKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            JTree tree;
            int selRow;
            DirectoryNode node;
            if (evt.getKeyCode() == 127) {
                DirectoryChooserUI.this.deleteAction();
            }
            if (evt.getKeyCode() == 113 && (node = (DirectoryNode)tree.getLastSelectedPathComponent()) != null) {
                DirectoryChooserUI.this.applyEdit(node);
            }
            if (this.isCharForSearch(evt)) {
                evt.consume();
            } else {
                this.resetBuffer();
            }
            if (evt.getKeyCode() == 121 && evt.isShiftDown() && !DirectoryChooserUI.this.popupMenu.isShowing() && (selRow = (tree = (JTree)evt.getSource()).getLeadSelectionRow()) >= 0) {
                Rectangle bounds = tree.getRowBounds(selRow);
                DirectoryChooserUI.this.popupMenu.show(tree, bounds.x + bounds.width / 2, bounds.y + bounds.height * 3 / 5);
                evt.consume();
            }
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            char keyChar = evt.getKeyChar();
            if (this.isCharForSearch(evt)) {
                if (this.paths == null) {
                    this.paths = DirectoryChooserUI.this.getVisiblePaths();
                }
                this.searchBuf.append(keyChar);
                String searchedText = this.searchBuf.toString().toLowerCase();
                String curFileName = null;
                for (TreePath path : this.paths) {
                    curFileName = fileChooser.getName(((DirectoryNode)path.getLastPathComponent()).getFile());
                    if (curFileName == null || !curFileName.toLowerCase().startsWith(searchedText)) continue;
                    tree.makeVisible(path);
                    tree.scrollPathToVisible(path);
                    tree.setSelectionPath(path);
                    break;
                }
            } else {
                this.resetBuffer();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.resetBuffer();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.resetBuffer();
        }

        private boolean isCharForSearch(KeyEvent evt) {
            char ch = evt.getKeyChar();
            if (ch == '\b') {
                return false;
            }
            if (evt.getModifiers() != 0) {
                return false;
            }
            return Character.isJavaIdentifierPart(ch) && !Character.isIdentifierIgnorable(ch) || Character.isSpaceChar(ch);
        }

        private void resetBuffer() {
            this.searchBuf.delete(0, this.searchBuf.length());
            this.paths = null;
        }
    }
}

