/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.util;

import javax.swing.Icon;
import javax.swing.JLabel;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class NameVisitor
implements OsmPrimitiveVisitor {
    public String className;
    public String classNamePlural;
    public String name = "";
    public Icon icon;
    private static final Icon nodeIcon = ImageProvider.get("data", "node");
    private static final Icon wayIcon = ImageProvider.get("data", "way");
    private static final Icon relIcon = ImageProvider.get("data", "relation");

    @Override
    public void visit(Node n) {
        this.name = n.getDisplayName(DefaultNameFormatter.getInstance());
        this.icon = nodeIcon;
        this.className = "node";
        this.classNamePlural = I18n.trn("node", "nodes", 2L, new Object[0]);
    }

    @Override
    public void visit(Way w) {
        this.name = w.getDisplayName(DefaultNameFormatter.getInstance());
        this.icon = wayIcon;
        this.className = "way";
        this.classNamePlural = I18n.trn("way", "ways", 2L, new Object[0]);
    }

    @Override
    public void visit(Relation e) {
        this.name = e.getDisplayName(DefaultNameFormatter.getInstance());
        this.icon = relIcon;
        this.className = "relation";
        this.classNamePlural = I18n.trn("relation", "relations", 2L, new Object[0]);
    }

    public JLabel toLabel() {
        return new JLabel(this.name, this.icon, 0);
    }
}

