/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.ApiCleanupNeeded;
import org.languagetool.Experimental;
import org.languagetool.rules.MatchPosition;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.tools.StringTools;

public class RuleMatch
implements Comparable<RuleMatch> {
    private static final Pattern SUGGESTION_PATTERN = Pattern.compile("<suggestion>(.*?)</suggestion>");
    private final Rule rule;
    private final String message;
    private final String shortMessage;
    private final AnalyzedSentence sentence;
    private OffsetPosition offsetPosition;
    private LinePosition linePosition = new LinePosition(-1, -1);
    private ColumnPosition columnPosition = new ColumnPosition(-1, -1);
    private List<SuggestedReplacement> suggestedReplacements = new ArrayList<SuggestedReplacement>();
    private URL url;
    private Type type = Type.Other;
    private SortedMap<String, Float> features = Collections.emptySortedMap();
    private boolean autoCorrect = false;

    public RuleMatch(Rule rule, int fromPos, int toPos, String message) {
        this(rule, fromPos, toPos, message, null, false, null);
    }

    public RuleMatch(Rule rule, AnalyzedSentence sentence, int fromPos, int toPos, String message) {
        this(rule, sentence, fromPos, toPos, message, null, false, null);
    }

    public RuleMatch(Rule rule, AnalyzedSentence sentence, int fromPos, int toPos, String message, String shortMessage) {
        this(rule, sentence, fromPos, toPos, message, shortMessage, false, null);
    }

    public RuleMatch(Rule rule, int fromPos, int toPos, String message, String shortMessage, boolean startWithUppercase, String suggestionsOutMsg) {
        this(rule, null, fromPos, toPos, message, shortMessage, startWithUppercase, suggestionsOutMsg);
    }

    public RuleMatch(Rule rule, AnalyzedSentence sentence, int fromPos, int toPos, String message, String shortMessage, boolean startWithUppercase, String suggestionsOutMsg) {
        this.rule = Objects.requireNonNull(rule);
        if (toPos <= fromPos) {
            throw new IllegalArgumentException("fromPos (" + fromPos + ") must be less than toPos (" + toPos + ")");
        }
        this.offsetPosition = new OffsetPosition(fromPos, toPos);
        this.message = Objects.requireNonNull(message);
        this.shortMessage = shortMessage;
        Matcher matcher = SUGGESTION_PATTERN.matcher(message + suggestionsOutMsg);
        int pos = 0;
        while (matcher.find(pos)) {
            SuggestedReplacement repl;
            pos = matcher.end();
            String replacement = matcher.group(1);
            if (startWithUppercase) {
                replacement = StringTools.uppercaseFirstChar(replacement);
            }
            if (this.suggestedReplacements.contains(repl = new SuggestedReplacement(replacement))) continue;
            this.suggestedReplacements.add(repl);
        }
        this.sentence = sentence;
    }

    public RuleMatch(RuleMatch clone) {
        this(clone.getRule(), clone.getSentence(), clone.getFromPos(), clone.getToPos(), clone.getMessage(), clone.getShortMessage());
        this.setSuggestedReplacementObjects(clone.getSuggestedReplacementObjects());
        this.setAutoCorrect(clone.isAutoCorrect());
        this.setFeatures(clone.getFeatures());
        this.setUrl(clone.getUrl());
        this.setType(clone.getType());
        this.setLine(clone.getLine());
        this.setEndLine(clone.getEndLine());
        this.setColumn(clone.getColumn());
        this.setEndColumn(clone.getEndColumn());
    }

    public RuleMatch(RuleMatch clone, List<String> replacements) {
        this(clone.getRule(), clone.getSentence(), clone.getFromPos(), clone.getToPos(), clone.getMessage(), clone.getShortMessage());
        this.setSuggestedReplacements(replacements);
        this.setAutoCorrect(clone.isAutoCorrect());
        this.setFeatures(clone.getFeatures());
        this.setUrl(clone.getUrl());
        this.setType(clone.getType());
        this.setLine(clone.getLine());
        this.setEndLine(clone.getEndLine());
        this.setColumn(clone.getColumn());
        this.setEndColumn(clone.getEndColumn());
    }

    @NotNull
    public SortedMap<String, Float> getFeatures() {
        return this.features;
    }

    public void setFeatures(@NotNull SortedMap<String, Float> features) {
        this.features = features;
    }

    public boolean isAutoCorrect() {
        return this.autoCorrect;
    }

    public void setAutoCorrect(boolean autoCorrect) {
        this.autoCorrect = autoCorrect;
    }

    public Rule getRule() {
        return this.rule;
    }

    public int getLine() {
        return this.linePosition.getStart();
    }

    public void setLine(int fromLine) {
        this.linePosition = new LinePosition(fromLine, this.linePosition.getEnd());
    }

    public int getEndLine() {
        return this.linePosition.getEnd();
    }

    public void setEndLine(int endLine) {
        this.linePosition = new LinePosition(this.linePosition.getStart(), endLine);
    }

    public int getColumn() {
        return this.columnPosition.getStart();
    }

    public void setColumn(int column) {
        this.columnPosition = new ColumnPosition(column, this.columnPosition.getEnd());
    }

    public int getEndColumn() {
        return this.columnPosition.getEnd();
    }

    public void setEndColumn(int endColumn) {
        this.columnPosition = new ColumnPosition(this.columnPosition.getStart(), endColumn);
    }

    public int getFromPos() {
        return this.offsetPosition.getStart();
    }

    public int getToPos() {
        return this.offsetPosition.getEnd();
    }

    public void setOffsetPosition(int fromPos, int toPos) {
        if (toPos <= fromPos) {
            throw new RuntimeException("fromPos (" + fromPos + ") must be less than toPos (" + toPos + ")");
        }
        this.offsetPosition = new OffsetPosition(fromPos, toPos);
    }

    public String getMessage() {
        return this.message;
    }

    @ApiCleanupNeeded(value="Should return an Optional")
    public String getShortMessage() {
        if (this.shortMessage == null) {
            return "";
        }
        return this.shortMessage;
    }

    public void setSuggestedReplacement(String replacement) {
        Objects.requireNonNull(replacement, "replacement may be empty but not null");
        ArrayList<String> replacements = new ArrayList<String>();
        replacements.add(replacement);
        this.setSuggestedReplacements(replacements);
    }

    public void addSuggestedReplacement(String replacement) {
        Objects.requireNonNull(replacement, "replacement may be empty but not null");
        ArrayList<String> l = new ArrayList<String>();
        for (SuggestedReplacement repl : this.suggestedReplacements) {
            l.add(repl.getReplacement());
        }
        l.add(replacement);
        this.setSuggestedReplacements(l);
    }

    public void addSuggestedReplacements(List<String> replacements) {
        Objects.requireNonNull(replacements, "replacements may be empty but not null");
        for (String replacement : replacements) {
            this.suggestedReplacements.add(new SuggestedReplacement(replacement));
        }
    }

    public List<String> getSuggestedReplacements() {
        ArrayList<String> l = new ArrayList<String>();
        for (SuggestedReplacement repl : this.suggestedReplacements) {
            l.add(repl.getReplacement());
        }
        return Collections.unmodifiableList(l);
    }

    public void setSuggestedReplacements(List<String> replacements) {
        Objects.requireNonNull(replacements, "replacements may be empty but not null");
        this.suggestedReplacements.clear();
        for (String replacement : replacements) {
            this.suggestedReplacements.add(new SuggestedReplacement(replacement));
        }
    }

    public List<SuggestedReplacement> getSuggestedReplacementObjects() {
        return Collections.unmodifiableList(this.suggestedReplacements);
    }

    public void setSuggestedReplacementObjects(List<SuggestedReplacement> replacements) {
        this.suggestedReplacements = Objects.requireNonNull(replacements, "replacements may be empty but not null");
    }

    @Nullable
    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public AnalyzedSentence getSentence() {
        return this.sentence;
    }

    @Experimental
    public Type getType() {
        return this.type;
    }

    @Experimental
    public void setType(Type type) {
        this.type = Objects.requireNonNull(type);
    }

    public String toString() {
        if (this.rule instanceof PatternRule) {
            return ((PatternRule)this.rule).getFullId() + ":" + this.offsetPosition + ":" + this.message;
        }
        return this.rule.getId() + ":" + this.offsetPosition + ":" + this.message;
    }

    @Override
    public int compareTo(RuleMatch other) {
        Objects.requireNonNull(other);
        return Integer.compare(this.getFromPos(), other.getFromPos());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleMatch other = (RuleMatch)o;
        return Objects.equals(this.rule.getId(), other.rule.getId()) && Objects.equals(this.offsetPosition, other.offsetPosition) && Objects.equals(this.message, other.message) && Objects.equals(this.suggestedReplacements, other.suggestedReplacements) && Objects.equals(this.sentence, other.sentence) && Objects.equals((Object)this.type, (Object)other.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rule.getId(), this.offsetPosition, this.message, this.suggestedReplacements, this.sentence, this.type});
    }

    static class ColumnPosition
    extends MatchPosition {
        ColumnPosition(int start, int end) {
            super(start, end);
        }
    }

    static class LinePosition
    extends MatchPosition {
        LinePosition(int start, int end) {
            super(start, end);
        }
    }

    static class OffsetPosition
    extends MatchPosition {
        OffsetPosition(int start, int end) {
            super(start, end);
        }
    }

    @Experimental
    public static enum Type {
        UnknownWord,
        Hint,
        Other;

    }
}

