/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.deprecation;

import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.protege.editor.owl.model.deprecation.DeprecateEntityInfo;
import org.protege.editor.owl.model.deprecation.DeprecationProfile;
import org.protege.editor.owl.model.deprecation.DeprecationProfileLoader;
import org.protege.editor.owl.model.deprecation.EntityDeprecator;
import org.protege.editor.owl.model.entity.HomeOntologySupplier;
import org.protege.editor.owl.ui.action.SelectedOWLEntityAction;
import org.protege.editor.owl.ui.deprecation.DeprecateEntityWizard;
import org.protege.editor.owl.ui.deprecation.DeprecateEntityWizardState;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeprecateSelectedEntityAction
extends SelectedOWLEntityAction {
    private static final Logger logger = LoggerFactory.getLogger(DeprecateSelectedEntityAction.class);

    @Override
    protected void actionPerformed(OWLEntity selectedEntity) {
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)this.getWorkspace());
        DeprecationProfileLoader profileLoader = new DeprecationProfileLoader();
        try {
            List<DeprecationProfile> profiles = profileLoader.loadProfiles();
            DeprecateEntityWizard wizard = new DeprecateEntityWizard(frame, this.getOWLEditorKit(), selectedEntity, profiles);
            int ret = wizard.showModalDialog();
            if (ret == 0) {
                this.runDeprecation(selectedEntity, wizard);
            }
        }
        catch (IOException e) {
            logger.error("Unabled to load deprecation profiles: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void runDeprecation(OWLEntity selectedEntity, DeprecateEntityWizard wizard) {
        DeprecateEntityWizardState state = wizard.getWizardState();
        DeprecateEntityInfo<OWLEntity> info = new DeprecateEntityInfo<OWLEntity>(selectedEntity, state.getReplacementEntity().orElse(null), state.getReasonForDeprecation(), new HashSet<OWLEntity>(state.getAlternateEntities()), state.getDeprecationCode().orElse(null));
        EntityDeprecator<OWLEntity> deprecator = new EntityDeprecator<OWLEntity>(info, wizard.getWizardState().getDeprecationProfile().get(), this.getOWLModelManager().getActiveOntologies(), new HomeOntologySupplier(), this.getOWLDataFactory());
        this.getOWLModelManager().applyChanges(deprecator.getChanges());
        long referenceCount = this.getOWLModelManager().getActiveOntology().getReferencingAxioms((OWLPrimitive)selectedEntity, Imports.INCLUDED).stream().filter(OWLAxiom::isLogicalAxiom).count();
        this.getOWLWorkspace().getOWLSelectionModel().setSelectedEntity(selectedEntity);
        if (referenceCount != 0L) {
            JOptionPane.showMessageDialog((Component)((Object)this.getOWLWorkspace()), "<html><body>There are " + referenceCount + " logical axioms that refer to the entity that has just been deprecated/obsoleted.<br>You should use the usage view to examine and replace axioms that reference the entity.</body></html>", "Deprecated Entity has " + referenceCount + " usages", 2);
        }
    }

    @Override
    protected void disposeAction() throws Exception {
    }
}

