/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.ssh.AbstractSshBasedRepository;
import org.apache.ivy.plugins.repository.ssh.RemoteScpException;
import org.apache.ivy.plugins.repository.ssh.Scp;
import org.apache.ivy.plugins.repository.ssh.SshResource;
import org.apache.ivy.util.Message;

public class SshRepository
extends AbstractSshBasedRepository {
    private static final int BUFFER_SIZE = 65536;
    private static final String ARGUMENT_PLACEHOLDER = "%arg";
    private static final int POLL_SLEEP_TIME = 500;
    private char fileSeparator = (char)47;
    private String listCommand = "ls -1";
    private String existCommand = "ls";
    private String createDirCommand = "mkdir";
    private String publishPermissions = null;

    @Override
    public Resource getResource(String string) {
        Message.debug("SShRepository:getResource called: " + string);
        return new SshResource(this, string);
    }

    public SshResource resolveResource(String string) {
        Message.debug("SShRepository:resolveResource called: " + string);
        SshResource sshResource = null;
        Session session = null;
        try {
            session = this.getSession(string);
            Scp scp = new Scp(session);
            Scp.FileInfo fileInfo = scp.getFileinfo(new URI(string).getPath());
            sshResource = new SshResource(this, string, true, fileInfo.getLength(), fileInfo.getLastModified());
        }
        catch (IOException iOException) {
            if (session != null) {
                this.releaseSession(session, string);
            }
            sshResource = new SshResource();
        }
        catch (URISyntaxException uRISyntaxException) {
            if (session != null) {
                this.releaseSession(session, string);
            }
            sshResource = new SshResource();
        }
        catch (RemoteScpException remoteScpException) {
            sshResource = new SshResource();
        }
        Message.debug("SShRepository:resolveResource end.");
        return sshResource;
    }

    private void readSessionOutput(ChannelExec channelExec, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws IOException {
        int n;
        int n2;
        InputStream inputStream = channelExec.getInputStream();
        InputStream inputStream2 = channelExec.getErrStream();
        try {
            channelExec.connect();
        }
        catch (JSchException jSchException) {
            throw (IOException)new IOException("Channel connection problems").initCause(jSchException);
        }
        byte[] byArray = new byte[65536];
        while (true) {
            n2 = 0;
            while ((n2 = inputStream.available()) > 0) {
                n = inputStream.read(byArray, 0, n2 > 65535 ? 65536 : n2);
                stringBuffer.append(new String(byArray, 0, n));
            }
            while ((n2 = inputStream2.available()) > 0) {
                n = inputStream2.read(byArray, 0, n2 > 65535 ? 65536 : n2);
                stringBuffer2.append(new String(byArray, 0, n));
            }
            if (channelExec.isClosed()) break;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        n2 = 0;
        while ((n2 = inputStream.available()) > 0) {
            n = inputStream.read(byArray, 0, n2 > 65535 ? 65536 : n2);
            stringBuffer.append(new String(byArray, 0, n));
        }
        while ((n2 = inputStream2.available()) > 0) {
            n = inputStream2.read(byArray, 0, n2 > 65535 ? 65536 : n2);
            stringBuffer2.append(new String(byArray, 0, n));
        }
    }

    @Override
    public List list(String string) throws IOException {
        Message.debug("SShRepository:list called: " + string);
        ArrayList<String> arrayList = new ArrayList<String>();
        Session session = null;
        ChannelExec channelExec = null;
        session = this.getSession(string);
        channelExec = this.getExecChannel(session);
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException("The uri '" + string + "' is not valid!");
            iOException.initCause(uRISyntaxException);
            throw iOException;
        }
        String string2 = this.replaceArgument(this.listCommand, uRI.getPath());
        channelExec.setCommand(string2);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        this.readSessionOutput(channelExec, stringBuffer, stringBuffer2);
        if (channelExec.getExitStatus() != 0) {
            Message.error("Ssh ListCommand exited with status != 0");
            Message.error(stringBuffer2.toString());
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new StringReader(stringBuffer.toString()));
        String string3 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            arrayList.add(string3);
        }
        return arrayList;
    }

    private ChannelExec getExecChannel(Session session) throws IOException {
        ChannelExec channelExec;
        try {
            channelExec = (ChannelExec)session.openChannel("exec");
        }
        catch (JSchException jSchException) {
            throw new IOException();
        }
        return channelExec;
    }

    private String replaceArgument(String string, String string2) {
        String string3 = string.indexOf(ARGUMENT_PLACEHOLDER) == -1 ? string + " " + string2 : string.replaceAll(ARGUMENT_PLACEHOLDER, string2);
        return string3;
    }

    @Override
    public void put(File file, String string, boolean bl) throws IOException {
        Message.debug("SShRepository:put called: " + string);
        Session session = this.getSession(string);
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException("The uri '" + string + "' is not valid!");
            iOException.initCause(uRISyntaxException);
            throw iOException;
        }
        try {
            String string2;
            String string3;
            String string4 = uRI.getPath();
            int n = string4.lastIndexOf(this.fileSeparator);
            if (n == -1) {
                string3 = string4;
                string2 = null;
            } else {
                string3 = string4.substring(n + 1);
                string2 = string4.substring(0, n);
            }
            if (!bl && this.checkExistence(string4, session)) {
                throw new IOException("destination file exists and overwrite == false");
            }
            if (string2 != null) {
                this.makePath(string2, session);
            }
            Scp scp = new Scp(session);
            scp.put(file.getCanonicalPath(), string2, string3, this.publishPermissions);
        }
        catch (IOException iOException) {
            if (session != null) {
                this.releaseSession(session, string);
            }
            throw iOException;
        }
        catch (RemoteScpException remoteScpException) {
            throw new IOException(remoteScpException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makePath(String string, Session session) throws IOException {
        ChannelExec channelExec = null;
        String string2 = string;
        try {
            String string3;
            while (string2.length() > 0 && string2.charAt(string2.length() - 1) == this.fileSeparator) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.length() == 0 || this.checkExistence(string2, session)) {
                return;
            }
            int n = string2.lastIndexOf(this.fileSeparator);
            if (n > 0) {
                string3 = string2.substring(0, n);
                this.makePath(string3, session);
            }
            channelExec = this.getExecChannel(session);
            string3 = this.replaceArgument(this.createDirCommand, string2);
            Message.debug("SShRepository: trying to create path: " + string3);
            channelExec.setCommand(string3);
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            this.readSessionOutput(channelExec, stringBuffer, stringBuffer2);
        }
        finally {
            if (channelExec != null) {
                channelExec.disconnect();
            }
        }
    }

    private boolean checkExistence(String string, Session session) throws IOException {
        Message.debug("SShRepository: checkExistence called: " + string);
        ChannelExec channelExec = null;
        channelExec = this.getExecChannel(session);
        String string2 = this.replaceArgument(this.existCommand, string);
        channelExec.setCommand(string2);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        this.readSessionOutput(channelExec, stringBuffer, stringBuffer2);
        return channelExec.getExitStatus() == 0;
    }

    @Override
    public void get(String string, File file) throws IOException {
        Message.debug("SShRepository:get called: " + string + " to " + file.getCanonicalPath());
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        Session session = this.getSession(string);
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException("The uri '" + string + "' is not valid!");
            iOException.initCause(uRISyntaxException);
            throw iOException;
        }
        try {
            Scp scp = new Scp(session);
            scp.get(uRI.getPath(), file.getCanonicalPath());
        }
        catch (IOException iOException) {
            if (session != null) {
                this.releaseSession(session, string);
            }
            throw iOException;
        }
        catch (RemoteScpException remoteScpException) {
            throw new IOException(remoteScpException.getMessage());
        }
    }

    public void setListCommand(String string) {
        this.listCommand = string.trim();
    }

    public String getListCommand() {
        return this.listCommand;
    }

    public String getCreateDirCommand() {
        return this.createDirCommand;
    }

    public void setCreateDirCommand(String string) {
        this.createDirCommand = string;
    }

    public String getExistCommand() {
        return this.existCommand;
    }

    public void setExistCommand(String string) {
        this.existCommand = string;
    }

    public void setFileSeparator(char c) {
        this.fileSeparator = c;
    }

    public void setPublishPermissions(String string) {
        this.publishPermissions = string;
    }

    @Override
    protected String getRepositoryScheme() {
        return "ssh";
    }

    public InputStream openStream(SshResource sshResource) throws IOException {
        Session session = this.getSession(sshResource.getName());
        Scp scp = new Scp(session);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            scp.get(sshResource.getName(), byteArrayOutputStream);
        }
        catch (IOException iOException) {
            if (session != null) {
                this.releaseSession(session, sshResource.getName());
            }
            throw iOException;
        }
        catch (RemoteScpException remoteScpException) {
            throw new IOException(remoteScpException.getMessage());
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }
}

