#ifndef _EFL_SINUSOIDAL_INTERPOLATOR_EO_H_
#define _EFL_SINUSOIDAL_INTERPOLATOR_EO_H_

#ifndef _EFL_SINUSOIDAL_INTERPOLATOR_EO_CLASS_TYPE
#define _EFL_SINUSOIDAL_INTERPOLATOR_EO_CLASS_TYPE

typedef Eo Efl_Sinusoidal_Interpolator;

#endif

#ifndef _EFL_SINUSOIDAL_INTERPOLATOR_EO_TYPES
#define _EFL_SINUSOIDAL_INTERPOLATOR_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Efl sinusoidal interpolator class
 *
 * output = (1 - cos(input * Pi)) / 2;
 *
 * @ingroup Efl_Sinusoidal_Interpolator
 */
#define EFL_SINUSOIDAL_INTERPOLATOR_CLASS efl_sinusoidal_interpolator_class_get()

EWAPI const Efl_Class *efl_sinusoidal_interpolator_class_get(void);

/**
 * @brief Factor property
 *
 * @param[in] obj The object.
 * @param[in] factor Factor of the interpolation function.
 *
 * @ingroup Efl_Sinusoidal_Interpolator
 */
EOAPI void efl_sinusoidal_interpolator_factor_set(Eo *obj, double factor);

/**
 * @brief Factor property
 *
 * @param[in] obj The object.
 *
 * @return Factor of the interpolation function.
 *
 * @ingroup Efl_Sinusoidal_Interpolator
 */
EOAPI double efl_sinusoidal_interpolator_factor_get(const Eo *obj);
#endif /* EFL_BETA_API_SUPPORT */

#endif
