#ifndef _EFL_UI_PAN_EO_H_
#define _EFL_UI_PAN_EO_H_

#ifndef _EFL_UI_PAN_EO_CLASS_TYPE
#define _EFL_UI_PAN_EO_CLASS_TYPE

typedef Eo Efl_Ui_Pan;

#endif

#ifndef _EFL_UI_PAN_EO_TYPES
#define _EFL_UI_PAN_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Elementary pan class
 *
 * @ingroup Efl_Ui_Pan
 */
#define EFL_UI_PAN_CLASS efl_ui_pan_class_get()

EWAPI const Efl_Class *efl_ui_pan_class_get(void);

/**
 * @brief Position
 *
 * @param[in] obj The object.
 * @param[in] position
 *
 * @ingroup Efl_Ui_Pan
 */
EOAPI void efl_ui_pan_position_set(Eo *obj, Eina_Position2D position);

/** Position
 *
 * @ingroup Efl_Ui_Pan
 */
EOAPI Eina_Position2D efl_ui_pan_position_get(const Eo *obj);

/** Content size
 *
 * @ingroup Efl_Ui_Pan
 */
EOAPI Eina_Size2D efl_ui_pan_content_size_get(const Eo *obj);

/** The minimal position to scroll
 *
 * @ingroup Efl_Ui_Pan
 */
EOAPI Eina_Position2D efl_ui_pan_position_min_get(const Eo *obj);

/** The maximal position to scroll
 *
 * @ingroup Efl_Ui_Pan
 */
EOAPI Eina_Position2D efl_ui_pan_position_max_get(const Eo *obj);

EWAPI extern const Efl_Event_Description _EFL_UI_PAN_EVENT_PAN_CONTENT_CHANGED;

/** Called when pan content changed
 *
 * @ingroup Efl_Ui_Pan
 */
#define EFL_UI_PAN_EVENT_PAN_CONTENT_CHANGED (&(_EFL_UI_PAN_EVENT_PAN_CONTENT_CHANGED))

EWAPI extern const Efl_Event_Description _EFL_UI_PAN_EVENT_PAN_VIEWPORT_CHANGED;

/** Called when pan viewport changed
 *
 * @ingroup Efl_Ui_Pan
 */
#define EFL_UI_PAN_EVENT_PAN_VIEWPORT_CHANGED (&(_EFL_UI_PAN_EVENT_PAN_VIEWPORT_CHANGED))

EWAPI extern const Efl_Event_Description _EFL_UI_PAN_EVENT_PAN_POSITION_CHANGED;

/** Called when pan position changed
 *
 * @ingroup Efl_Ui_Pan
 */
#define EFL_UI_PAN_EVENT_PAN_POSITION_CHANGED (&(_EFL_UI_PAN_EVENT_PAN_POSITION_CHANGED))
#endif /* EFL_BETA_API_SUPPORT */

#endif
