#ifndef _EFL_UI_WIN_EO_LEGACY_H_
#define _EFL_UI_WIN_EO_LEGACY_H_

#ifndef _EFL_UI_WIN_EO_CLASS_TYPE
#define _EFL_UI_WIN_EO_CLASS_TYPE

typedef Eo Efl_Ui_Win;

#endif

#ifndef _EFL_UI_WIN_EO_TYPES
#define _EFL_UI_WIN_EO_TYPES

#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Defines the types of window that can be created
 *
 * These are hints set on a window so that a running Window Manager knows how
 * the window should be handled and/or what kind of decorations it should have.
 *
 * Currently, only the X11 backed engines use them.
 *
 * @ingroup Efl_Ui
 */
typedef enum
{
  EFL_UI_WIN_TYPE_UNKNOWN = -1 /* +1 */, /**< Default, unknown, type */
  EFL_UI_WIN_TYPE_BASIC, /**< A normal window. Indicates a normal, top-level
                          * window. Almost every window will be created with
                          * this type. */
  EFL_UI_WIN_TYPE_DIALOG_BASIC, /**< Used for simple dialog windows. */
  EFL_UI_WIN_TYPE_DESKTOP, /**< For special desktop windows, like a background
                            * window holding desktop icons. */
  EFL_UI_WIN_TYPE_DOCK, /**< The window is used as a dock or panel. Usually
                         * would be kept on top of any other window by the
                         * Window Manager. */
  EFL_UI_WIN_TYPE_TOOLBAR, /**< The window is used to hold a floating toolbar,
                            * or similar. */
  EFL_UI_WIN_TYPE_MENU, /**< Similar to @.toolbar. */
  EFL_UI_WIN_TYPE_UTILITY, /**< A persistent utility window, like a toolbox or
                            * palette. */
  EFL_UI_WIN_TYPE_SPLASH, /**< Splash window for a starting up application. */
  EFL_UI_WIN_TYPE_DROPDOWN_MENU, /**< The window is a dropdown menu, as when an
                                  *  entry in a menubar is clicked. This hint
                                  * exists for completion only, as the EFL way
                                  * of implementing a menu would not normally
                                  * use a separate window for its contents. */
  EFL_UI_WIN_TYPE_POPUP_MENU, /**< Like @.dropdown_menu, but for the menu
                               * triggered by right-clicking an object. */
  EFL_UI_WIN_TYPE_TOOLTIP, /**< The window is a tooltip. A short piece of
                            * explanatory text that typically appear after the
                            * mouse cursor hovers over an object for a while.
                            * Typically not very commonly used in the EFL. */
  EFL_UI_WIN_TYPE_NOTIFICATION, /**< A notification window, like a warning about
                                 * battery life or a new E-Mail received. */
  EFL_UI_WIN_TYPE_COMBO, /**< A window holding the contents of a combo box. Not
                          * usually used in the EFL. */
  EFL_UI_WIN_TYPE_DND,
  EFL_UI_WIN_TYPE_INLINED_IMAGE,
  EFL_UI_WIN_TYPE_SOCKET_IMAGE,
  EFL_UI_WIN_TYPE_FAKE,
  EFL_UI_WIN_TYPE_NAVIFRAME_BASIC = 17 /**< Used for naviframe style replacement
                                        * with a back button instead of a close
                                        * button. */
} Efl_Ui_Win_Type;
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief The different layouts that can be requested for the virtual keyboard.
 *
 * When the application window is being managed by Illume it may request any of
 * the following layouts for the virtual keyboard.
 *
 * @ingroup Efl_Ui
 */
typedef enum
{
  EFL_UI_WIN_KEYBOARD_MODE_UNKNOWN = 0, /**< Unknown keyboard state */
  EFL_UI_WIN_KEYBOARD_MODE_OFF, /**< Request to deactivate the keyboard */
  EFL_UI_WIN_KEYBOARD_MODE_ON, /**< Enable keyboard with default layout */
  EFL_UI_WIN_KEYBOARD_MODE_ALPHA, /**< Alpha (a-z) keyboard layout */
  EFL_UI_WIN_KEYBOARD_MODE_NUMERIC, /**< Numeric keyboard layout */
  EFL_UI_WIN_KEYBOARD_MODE_PIN, /**< PIN keyboard layout */
  EFL_UI_WIN_KEYBOARD_MODE_PHONE_NUMBER, /**< Phone keyboard layout */
  EFL_UI_WIN_KEYBOARD_MODE_HEX, /**< Hexadecimal numeric keyboard layout */
  EFL_UI_WIN_KEYBOARD_MODE_TERMINAL, /**< Full (QWERTY) keyboard layout */
  EFL_UI_WIN_KEYBOARD_MODE_PASSWORD, /**< Password keyboard layout */
  EFL_UI_WIN_KEYBOARD_MODE_IP, /**< IP keyboard layout */
  EFL_UI_WIN_KEYBOARD_MODE_HOST, /**< Host keyboard layout */
  EFL_UI_WIN_KEYBOARD_MODE_FILE, /**< File keyboard layout */
  EFL_UI_WIN_KEYBOARD_MODE_URL, /**< URL keyboard layout */
  EFL_UI_WIN_KEYBOARD_MODE_KEYPAD, /**< Keypad layout */
  EFL_UI_WIN_KEYBOARD_MODE_J2ME /**< J2ME keyboard layout */
} Efl_Ui_Win_Keyboard_Mode;
#endif /* EFL_BETA_API_SUPPORT */

/** Defines the type indicator that can be shown
 *
 * @since 1.22
 *
 * @ingroup Efl_Ui
 */
typedef enum
{
  EFL_UI_WIN_INDICATOR_MODE_OFF = 0, /**< Request to deactivate the indicator */
  EFL_UI_WIN_INDICATOR_MODE_BG_OPAQUE, /**< The indicator icon is opaque, as is
                                        * the indicator background. The content
                                        * of window is located at the end of
                                        * the indicator. The area of indicator
                                        * and window content are not overlapped
                                        */
  EFL_UI_WIN_INDICATOR_MODE_BG_TRANSPARENT, /**< The icon of indicator is
                                             * opaque, but the background is
                                             * transparent. The content of
                                             * window is located under the
                                             * indicator in Z-order. The area
                                             * of indicator and window content
                                             * are overlapped */
  EFL_UI_WIN_INDICATOR_MODE_HIDDEN /**< The indicator is hidden so user can see
                                    * only the content of window such as in
                                    * video mode. If user flicks the upper side
                                    * of window, the indicator is shown
                                    * temporarily. */
} Efl_Ui_Win_Indicator_Mode;

#ifdef EFL_BETA_API_SUPPORT
/** Defines the mode of a modal window
 *
 * @ingroup Efl_Ui
 */
typedef enum
{
  EFL_UI_WIN_MODAL_MODE_NONE = 0, /**< The window is not modal window. */
  EFL_UI_WIN_MODAL_MODE_MODAL /**< The window is modal window. */
} Efl_Ui_Win_Modal_Mode;
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/** Defines the mode of a urgent window.
 *
 * @ingroup Efl_Ui
 */
typedef enum
{
  EFL_UI_WIN_URGENT_MODE_NONE = 0, /**< The window is not a urgent window. */
  EFL_UI_WIN_URGENT_MODE_URGENT /**< The window is a urgent window. */
} Efl_Ui_Win_Urgent_Mode;
#endif /* EFL_BETA_API_SUPPORT */

/**
 * @brief Define the move or resize mode of window.
 *
 * The user can request the display server to start moving or resizing the
 * window by combining these modes. However only limited combinations are
 * allowed.
 *
 * Currently, only the following 9 combinations are permitted. More
 * combinations may be added in future: 1. move, 2. top, 3. bottom, 4. left, 5.
 * right, 6. top | left, 7. top | right, 8. bottom | left, 9. bottom | right.
 *
 * @since 1.22
 *
 * @ingroup Efl_Ui
 */
typedef enum
{
  EFL_UI_WIN_MOVE_RESIZE_MODE_MOVE = 1, /**< Start moving window */
  EFL_UI_WIN_MOVE_RESIZE_MODE_TOP = 2 /* 1 >> 1 */, /**< Start resizing window
                                                     * to the top */
  EFL_UI_WIN_MOVE_RESIZE_MODE_BOTTOM = 4 /* 1 >> 2 */, /**< Start resizing
                                                        * window to the bottom
                                                        */
  EFL_UI_WIN_MOVE_RESIZE_MODE_LEFT = 8 /* 1 >> 3 */, /**< Start resizing window
                                                      * to the left */
  EFL_UI_WIN_MOVE_RESIZE_MODE_RIGHT = 16 /* 1 >> 4 */ /**< Start resizing window
                                                       * to the right */
} Efl_Ui_Win_Move_Resize_Mode;


#endif

#endif
