/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import sun.text.CodePointIterator;

final class CharSequenceCodePointIterator
extends CodePointIterator {
    private CharSequence text;
    private int index;

    public CharSequenceCodePointIterator(CharSequence charSequence) {
        this.text = charSequence;
    }

    @Override
    public void setToStart() {
        this.index = 0;
    }

    @Override
    public void setToLimit() {
        this.index = this.text.length();
    }

    @Override
    public int next() {
        if (this.index < this.text.length()) {
            char c;
            char c2;
            if (Character.isHighSurrogate(c2 = this.text.charAt(this.index++)) && this.index < this.text.length() && Character.isLowSurrogate(c = this.text.charAt(this.index + 1))) {
                ++this.index;
                return Character.toCodePoint(c2, c);
            }
            return c2;
        }
        return -1;
    }

    @Override
    public int prev() {
        if (this.index > 0) {
            char c;
            char c2;
            if (Character.isLowSurrogate(c2 = this.text.charAt(--this.index)) && this.index > 0 && Character.isHighSurrogate(c = this.text.charAt(this.index - 1))) {
                --this.index;
                return Character.toCodePoint(c, c2);
            }
            return c2;
        }
        return -1;
    }

    @Override
    public int charIndex() {
        return this.index;
    }
}

