"use strict";
/**
 * Created by Sviridov on 5/1/2015.
 */
Object.defineProperty(exports, "__esModule", { value: true });
var JsonSchemaGenerator = /** @class */ (function () {
    function JsonSchemaGenerator() {
    }
    JsonSchemaGenerator.prototype.generateSchema = function (obj) {
        var sch = {};
        sch['required'] = true;
        sch['$schema'] = 'http://json-schema.org/draft-03/schema';
        this.pass(obj, sch);
        return sch;
    };
    JsonSchemaGenerator.prototype.pass = function (value, property) {
        var valueType = this.detectType(value);
        property['type'] = valueType;
        if (!value || value == null) {
        }
        else if (Array.isArray(value)) {
            this.passArray(value, property);
        }
        else if (value instanceof Object) {
            this.passObject(value, property);
        }
    };
    JsonSchemaGenerator.prototype.passObject = function (obj, sch) {
        var _this = this;
        Object.keys(obj).forEach(function (x) { return _this.registerProperty(x, obj[x], sch); });
    };
    JsonSchemaGenerator.prototype.registerProperty = function (propName, value, sch) {
        var properties = sch['properties'];
        if (!properties) {
            properties = {};
            sch['properties'] = properties;
        }
        var property = properties[propName];
        if (!property) {
            property = {};
            properties[propName] = property;
        }
        property['required'] = false;
        this.pass(value, property);
    };
    JsonSchemaGenerator.prototype.passArray = function (array, property) {
        var _this = this;
        var items = property['items'];
        if (!items) {
            items = [];
            property['items'] = items;
        }
        var l = array.length;
        var itemSet = [];
        array.forEach(function (value) {
            var item = {};
            _this.pass(value, item);
            itemSet.push(item);
        });
        items.push(itemSet[0]);
    };
    JsonSchemaGenerator.prototype.detectType = function (value) {
        if (Array.isArray(value)) {
            return 'array';
        }
        return typeof value;
    };
    return JsonSchemaGenerator;
}());
exports.JsonSchemaGenerator = JsonSchemaGenerator;
function generateSchema(text, mediaType) {
    var generator = new JsonSchemaGenerator();
    var obj = JSON.parse(text);
    var schemaObject = generator.generateSchema(obj);
    var schemaString = JSON.stringify(schemaObject, null, 2);
    return schemaString;
}
exports.generateSchema = generateSchema;
//# sourceMappingURL=schemaGenerator.js.map