/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.util;

import java.io.IOException;
import java.io.InputStream;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.impl.PrivateIonConstants;
import software.amazon.ion.impl.PrivateListWriter;
import software.amazon.ion.util.GzipOrRawInputStream;

public class IonStreamUtils {
    public static boolean isIonBinary(byte[] buffer) {
        return buffer != null && IonStreamUtils.isIonBinary(buffer, 0, buffer.length);
    }

    public static boolean isIonBinary(byte[] buffer, int offset, int length) {
        return IonStreamUtils.cookieMatches(PrivateIonConstants.BINARY_VERSION_MARKER_1_0, buffer, offset, length);
    }

    public static boolean isGzip(byte[] buffer, int offset, int length) {
        return IonStreamUtils.cookieMatches(GzipOrRawInputStream.GZIP_HEADER, buffer, offset, length);
    }

    private static boolean cookieMatches(byte[] cookie, byte[] buffer, int offset, int length) {
        if (buffer == null || length < cookie.length) {
            return false;
        }
        for (int i = 0; i < cookie.length; ++i) {
            if (cookie[i] == buffer[offset + i]) continue;
            return false;
        }
        return true;
    }

    public static InputStream unGzip(InputStream in) throws IOException {
        return new GzipOrRawInputStream(in);
    }

    public static void writeBoolList(IonWriter writer2, boolean[] values) throws IOException {
        if (writer2 instanceof PrivateListWriter) {
            ((PrivateListWriter)writer2).writeBoolList(values);
            return;
        }
        writer2.stepIn(IonType.LIST);
        for (int ii = 0; ii < values.length; ++ii) {
            writer2.writeBool(values[ii]);
        }
        writer2.stepOut();
    }

    public static void writeFloatList(IonWriter writer2, float[] values) throws IOException {
        if (writer2 instanceof PrivateListWriter) {
            ((PrivateListWriter)writer2).writeFloatList(values);
            return;
        }
        writer2.stepIn(IonType.LIST);
        for (int ii = 0; ii < values.length; ++ii) {
            writer2.writeFloat(values[ii]);
        }
        writer2.stepOut();
    }

    public static void writeFloatList(IonWriter writer2, double[] values) throws IOException {
        if (writer2 instanceof PrivateListWriter) {
            ((PrivateListWriter)writer2).writeFloatList(values);
            return;
        }
        writer2.stepIn(IonType.LIST);
        for (int ii = 0; ii < values.length; ++ii) {
            writer2.writeFloat(values[ii]);
        }
        writer2.stepOut();
    }

    public static void writeIntList(IonWriter writer2, byte[] values) throws IOException {
        if (writer2 instanceof PrivateListWriter) {
            ((PrivateListWriter)writer2).writeIntList(values);
            return;
        }
        writer2.stepIn(IonType.LIST);
        for (int ii = 0; ii < values.length; ++ii) {
            writer2.writeInt(values[ii]);
        }
        writer2.stepOut();
    }

    public static void writeIntList(IonWriter writer2, short[] values) throws IOException {
        if (writer2 instanceof PrivateListWriter) {
            ((PrivateListWriter)writer2).writeIntList(values);
            return;
        }
        writer2.stepIn(IonType.LIST);
        for (int ii = 0; ii < values.length; ++ii) {
            writer2.writeInt(values[ii]);
        }
        writer2.stepOut();
    }

    public static void writeIntList(IonWriter writer2, int[] values) throws IOException {
        if (writer2 instanceof PrivateListWriter) {
            ((PrivateListWriter)writer2).writeIntList(values);
            return;
        }
        writer2.stepIn(IonType.LIST);
        for (int ii = 0; ii < values.length; ++ii) {
            writer2.writeInt(values[ii]);
        }
        writer2.stepOut();
    }

    public static void writeIntList(IonWriter writer2, long[] values) throws IOException {
        if (writer2 instanceof PrivateListWriter) {
            ((PrivateListWriter)writer2).writeIntList(values);
            return;
        }
        writer2.stepIn(IonType.LIST);
        for (int ii = 0; ii < values.length; ++ii) {
            writer2.writeInt(values[ii]);
        }
        writer2.stepOut();
    }

    public static void writeStringList(IonWriter writer2, String[] values) throws IOException {
        if (writer2 instanceof PrivateListWriter) {
            ((PrivateListWriter)writer2).writeStringList(values);
            return;
        }
        writer2.stepIn(IonType.LIST);
        for (int ii = 0; ii < values.length; ++ii) {
            writer2.writeString(values[ii]);
        }
        writer2.stepOut();
    }
}

