/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.systemd;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Build;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.systemd.Libsystemd;

public class SystemdPlugin
extends Plugin
implements ClusterPlugin {
    private static final Logger logger = LogManager.getLogger(SystemdPlugin.class);
    private final boolean enabled;

    final boolean isEnabled() {
        return this.enabled;
    }

    public SystemdPlugin() {
        this(true, Build.CURRENT.type(), System.getenv("ES_SD_NOTIFY"));
    }

    SystemdPlugin(boolean assertIsPackageDistribution, Build.Type buildType, String esSDNotify) {
        boolean isPackageDistribution;
        boolean bl = isPackageDistribution = buildType == Build.Type.DEB || buildType == Build.Type.RPM;
        if (assertIsPackageDistribution) assert (isPackageDistribution) : buildType;
        if (!isPackageDistribution) {
            logger.debug("disabling sd_notify as the build type [{}] is not a package distribution", (Object)buildType);
            this.enabled = false;
            return;
        }
        logger.trace("ES_SD_NOTIFY is set to [{}]", (Object)esSDNotify);
        if (esSDNotify == null) {
            this.enabled = false;
            return;
        }
        if (!Boolean.TRUE.toString().equals(esSDNotify) && !Boolean.FALSE.toString().equals(esSDNotify)) {
            throw new RuntimeException("ES_SD_NOTIFY set to unexpected value [" + esSDNotify + "]");
        }
        this.enabled = Boolean.TRUE.toString().equals(esSDNotify);
    }

    int sd_notify(int unset_environment, String state) {
        return Libsystemd.sd_notify(unset_environment, state);
    }

    public void onNodeStarted() {
        if (!this.enabled) {
            return;
        }
        int rc = this.sd_notify(0, "READY=1");
        logger.trace("sd_notify returned [{}]", (Object)rc);
        if (rc < 0) {
            throw new RuntimeException("sd_notify returned error [" + rc + "]");
        }
    }

    public void close() {
        if (!this.enabled) {
            return;
        }
        int rc = this.sd_notify(0, "STOPPING=1");
        logger.trace("sd_notify returned [{}]", (Object)rc);
        if (rc < 0) {
            logger.warn("sd_notify returned error [{}]", (Object)rc);
        }
    }
}

