#include "libm.h"

double copysign(double x, double y) {
// XXX EMSCRIPTEN: on wasm backend, use the wasm instruction via clang builtin
// See https://github.com/emscripten-core/emscripten/issues/9236
#ifdef __wasm__
	return __builtin_copysign(x, y);
#else
	union {double f; uint64_t i;} ux={x}, uy={y};
	ux.i &= -1ULL/2;
	ux.i |= uy.i & 1ULL<<63;
	return ux.f;
#endif
}
