/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.io.ObjectStreamException;

public enum PCLRenderingMode {
    QUALITY("quality", 1.0f),
    SPEED("speed", 0.25f),
    BITMAP("bitmap", 1.0f);

    private static final long serialVersionUID = 6359884255324755026L;
    private String name;
    private float defaultDitheringQuality;

    private PCLRenderingMode(String name, float defaultDitheringQuality) {
        this.name = name;
        this.defaultDitheringQuality = defaultDitheringQuality;
    }

    public String getName() {
        return this.name;
    }

    public float getDefaultDitheringQuality() {
        return this.defaultDitheringQuality;
    }

    public static PCLRenderingMode getValueOf(String name) {
        for (PCLRenderingMode mode : PCLRenderingMode.values()) {
            if (!mode.getName().equalsIgnoreCase(name)) continue;
            return mode;
        }
        throw new IllegalArgumentException("Illegal value for enumeration: " + name);
    }

    private Object readResolve() throws ObjectStreamException {
        return PCLRenderingMode.getValueOf(this.getName());
    }

    public String toString() {
        return "PCLRenderingMode:" + this.name;
    }
}

