/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.reflect.ClassLoadingReporter;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AbstractAnnotationMetadata;
import io.micronaut.inject.annotation.AnnotationMetadataSupport;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Internal
public class DefaultAnnotationMetadata
extends AbstractAnnotationMetadata
implements AnnotationMetadata,
Cloneable {
    @Nullable
    Map<String, Map<CharSequence, Object>> declaredAnnotations;
    @Nullable
    Map<String, Map<CharSequence, Object>> allAnnotations;
    @Nullable
    Map<String, Map<CharSequence, Object>> declaredStereotypes;
    @Nullable
    Map<String, Map<CharSequence, Object>> allStereotypes;
    @Nullable
    Map<String, List<String>> annotationsByStereotype;
    @Nullable
    Map<String, Map<CharSequence, Object>> annotationDefaultValues;
    private Map<Class, List> annotationValuesByType = new ConcurrentHashMap<Class, List>(2);
    private Map<String, String> repeated = null;

    @Internal
    protected DefaultAnnotationMetadata() {
    }

    @Internal
    public DefaultAnnotationMetadata(@Nullable Map<String, Map<CharSequence, Object>> declaredAnnotations, @Nullable Map<String, Map<CharSequence, Object>> declaredStereotypes, @Nullable Map<String, Map<CharSequence, Object>> allStereotypes, @Nullable Map<String, Map<CharSequence, Object>> allAnnotations, @Nullable Map<String, List<String>> annotationsByStereotype) {
        super(declaredAnnotations, allAnnotations);
        this.declaredAnnotations = declaredAnnotations;
        this.declaredStereotypes = declaredStereotypes;
        this.allStereotypes = allStereotypes;
        this.allAnnotations = allAnnotations;
        this.annotationsByStereotype = annotationsByStereotype;
        if (ClassLoadingReporter.isReportingEnabled() && allAnnotations != null) {
            for (String annotationName : allAnnotations.keySet()) {
                ClassUtils.forName((String)annotationName, (ClassLoader)DefaultAnnotationMetadata.class.getClassLoader()).ifPresent(ClassLoadingReporter::reportPresent);
            }
        }
    }

    public boolean isPresent(@Nonnull String annotation, @Nonnull String member) {
        boolean isPresent = false;
        if (this.allAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation)) {
            Map<CharSequence, Object> values = this.allAnnotations.get(annotation);
            if (values != null) {
                isPresent = values.containsKey(member);
            } else if (this.allStereotypes != null && (values = this.allStereotypes.get(annotation)) != null) {
                isPresent = values.containsKey(member);
            }
        }
        return isPresent;
    }

    public <E extends Enum> Optional<E> enumValue(@Nonnull String annotation, Class<E> enumType) {
        return this.enumValue(annotation, "value", enumType, null);
    }

    public <E extends Enum> Optional<E> enumValue(@Nonnull String annotation, @Nonnull String member, Class<E> enumType) {
        return this.enumValue(annotation, member, enumType, null);
    }

    public <E extends Enum> Optional<E> enumValue(@Nonnull Class<? extends Annotation> annotation, Class<E> enumType) {
        return this.enumValue(annotation, "value", enumType);
    }

    public <E extends Enum> Optional<E> enumValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member, Class<E> enumType) {
        return this.enumValue(annotation, member, enumType, null);
    }

    @Internal
    <E extends Enum> Optional<E> enumValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member, Class<E> enumType, @Nullable Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawSingleValue(repeatable.value().getName(), "value", valueMapper);
            if (v instanceof AnnotationValue) {
                return ((AnnotationValue)v).enumValue(member, enumType, valueMapper);
            }
            return Optional.empty();
        }
        return this.enumValue(annotation.getName(), member, enumType, valueMapper);
    }

    @Internal
    <E extends Enum> Optional<E> enumValue(@Nonnull String annotation, @Nonnull String member, Class<E> enumType, @Nullable Function<Object, Object> valueMapper) {
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        return this.enumValueOf(enumType, rawValue);
    }

    private <E extends Enum> Optional<E> enumValueOf(Class<E> enumType, Object rawValue) {
        if (rawValue != null) {
            if (enumType.isInstance(rawValue)) {
                return Optional.of((Enum)rawValue);
            }
            try {
                return Optional.of(Enum.valueOf(enumType, rawValue.toString()));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public <T> Class<T>[] classValues(@Nonnull String annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        Object rawSingleValue = this.getRawValue(annotation, member);
        Class[] classes = AnnotationValue.resolveClassValues((Object)rawSingleValue);
        if (classes != null) {
            return classes;
        }
        return ReflectionUtils.EMPTY_CLASS_ARRAY;
    }

    public <T> Class<T>[] classValues(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawSingleValue(repeatable.value().getName(), member, null);
            if (v instanceof AnnotationValue) {
                Class[] classes = ((AnnotationValue)v).classValues(member);
                return classes;
            }
            return ReflectionUtils.EMPTY_CLASS_ARRAY;
        }
        return this.classValues(annotation.getName(), member);
    }

    @Nonnull
    public Optional<Class> classValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        return this.classValue(annotation, member, null);
    }

    Optional<Class> classValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member, Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawSingleValue(repeatable.value().getName(), member, valueMapper);
            if (v instanceof AnnotationValue) {
                Optional o = ((AnnotationValue)v).classValue(member, valueMapper);
                return o;
            }
            return Optional.empty();
        }
        return this.classValue(annotation.getName(), member, valueMapper);
    }

    @Nonnull
    public Optional<Class> classValue(@Nonnull String annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        return this.classValue(annotation, member, null);
    }

    @Internal
    Optional<Class> classValue(@Nonnull String annotation, @Nonnull String member, @Nullable Function<Object, Object> valueMapper) {
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof AnnotationClassValue) {
            return ((AnnotationClassValue)rawValue).getType();
        }
        if (rawValue instanceof Class) {
            return Optional.of((Class)rawValue);
        }
        if (rawValue != null) {
            Optional converted = ConversionService.SHARED.convert(rawValue, Class.class);
            return converted;
        }
        return Optional.empty();
    }

    @Nonnull
    public OptionalInt intValue(@Nonnull String annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        return this.intValue(annotation, member, null);
    }

    @Nonnull
    public OptionalInt intValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        return this.intValue(annotation, member, null);
    }

    @Internal
    OptionalInt intValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member, @Nullable Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawSingleValue(repeatable.value().getName(), "value", valueMapper);
            if (v instanceof AnnotationValue) {
                return ((AnnotationValue)v).intValue(member, valueMapper);
            }
            return OptionalInt.empty();
        }
        return this.intValue(annotation.getName(), member);
    }

    public Optional<Boolean> booleanValue(@Nonnull String annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        return this.booleanValue(annotation, member, null);
    }

    public Optional<Boolean> booleanValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        return this.booleanValue(annotation, member, null);
    }

    Optional<Boolean> booleanValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member, Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawSingleValue(repeatable.value().getName(), "value", null);
            if (v instanceof AnnotationValue) {
                return ((AnnotationValue)v).booleanValue(member, valueMapper);
            }
            return Optional.empty();
        }
        return this.booleanValue(annotation.getName(), member, valueMapper);
    }

    @Nonnull
    Optional<Boolean> booleanValue(@Nonnull String annotation, @Nonnull String member, @Nullable Function<Object, Object> valueMapper) {
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof Boolean) {
            return Optional.of((Boolean)rawValue);
        }
        if (rawValue != null) {
            return Optional.of(StringUtils.isTrue((String)rawValue.toString()));
        }
        return Optional.empty();
    }

    @Nonnull
    public OptionalLong longValue(@Nonnull String annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        return this.longValue(annotation, member, null);
    }

    @Nonnull
    public OptionalLong longValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        return this.longValue(annotation, member, null);
    }

    @Internal
    OptionalLong longValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member, @Nullable Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawSingleValue(repeatable.value().getName(), "value", valueMapper);
            if (v instanceof AnnotationValue) {
                return ((AnnotationValue)v).longValue(member, valueMapper);
            }
            return OptionalLong.empty();
        }
        return this.longValue(annotation.getName(), member, valueMapper);
    }

    @Nonnull
    OptionalLong longValue(@Nonnull String annotation, @Nonnull String member, @Nullable Function<Object, Object> valueMapper) {
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof Number) {
            return OptionalLong.of(((Number)rawValue).longValue());
        }
        return OptionalLong.empty();
    }

    @Nonnull
    OptionalInt intValue(@Nonnull String annotation, @Nonnull String member, @Nullable Function<Object, Object> valueMapper) {
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof Number) {
            return OptionalInt.of(((Number)rawValue).intValue());
        }
        return OptionalInt.empty();
    }

    @Nonnull
    public Optional<String> stringValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        return this.stringValue(annotation, member, null);
    }

    Optional<String> stringValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member, Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawSingleValue(repeatable.value().getName(), "value", valueMapper);
            if (v instanceof AnnotationValue) {
                return ((AnnotationValue)v).stringValue(member, valueMapper);
            }
            return Optional.empty();
        }
        return this.stringValue(annotation.getName(), member, valueMapper);
    }

    @Nonnull
    public String[] stringValues(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        return this.stringValues(annotation, member, null);
    }

    @Nonnull
    String[] stringValues(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member, Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawValue(repeatable.value().getName(), member);
            if (v instanceof AnnotationValue) {
                return ((AnnotationValue)v).stringValues(member, valueMapper);
            }
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        Object v = this.getRawValue(annotation.getName(), member);
        String[] strings = AnnotationValue.resolveStringValues((Object)v, valueMapper);
        return strings != null ? strings : StringUtils.EMPTY_STRING_ARRAY;
    }

    @Nonnull
    public Optional<String> stringValue(@Nonnull String annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        return this.stringValue(annotation, member, null);
    }

    @Nonnull
    Optional<String> stringValue(@Nonnull String annotation, @Nonnull String member, @Nullable Function<Object, Object> valueMapper) {
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof CharSequence) {
            return Optional.of(rawValue.toString());
        }
        if (rawValue instanceof Class) {
            String name = ((Class)rawValue).getName();
            return Optional.of(name);
        }
        if (rawValue != null) {
            return Optional.of(rawValue.toString());
        }
        return Optional.empty();
    }

    public boolean isTrue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        return this.isTrue(annotation, member, null);
    }

    boolean isTrue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member, Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawSingleValue(repeatable.value().getName(), "value", valueMapper);
            if (v instanceof AnnotationValue) {
                return ((AnnotationValue)v).isTrue(member, valueMapper);
            }
            return false;
        }
        return this.isTrue(annotation.getName(), member, valueMapper);
    }

    public boolean isTrue(@Nonnull String annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        return this.isTrue(annotation, member, null);
    }

    boolean isTrue(@Nonnull String annotation, @Nonnull String member, @Nullable Function<Object, Object> valueMapper) {
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof Boolean) {
            return (Boolean)rawValue;
        }
        if (rawValue != null) {
            String booleanString = rawValue.toString().toLowerCase(Locale.ENGLISH);
            return StringUtils.isTrue((String)booleanString);
        }
        return false;
    }

    public boolean isFalse(@Nonnull String annotation, @Nonnull String member) {
        return !this.isTrue(annotation, member);
    }

    @Nonnull
    public OptionalDouble doubleValue(@Nonnull String annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        return this.doubleValue(annotation, member, null);
    }

    @Nonnull
    public OptionalDouble doubleValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        return this.doubleValue(annotation, member, null);
    }

    @Internal
    OptionalDouble doubleValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member, @Nullable Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawSingleValue(repeatable.value().getName(), "value", valueMapper);
            if (v instanceof AnnotationValue) {
                return ((AnnotationValue)v).doubleValue(member, valueMapper);
            }
            return OptionalDouble.empty();
        }
        return this.doubleValue(annotation.getName(), member);
    }

    @Nonnull
    @Internal
    OptionalDouble doubleValue(@Nonnull String annotation, @Nonnull String member, Function<Object, Object> valueMapper) {
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof Number) {
            return OptionalDouble.of(((Number)rawValue).doubleValue());
        }
        return OptionalDouble.empty();
    }

    @Nonnull
    public <T> Optional<T> getValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member, @Nonnull Class<T> requiredType) {
        boolean isRepeatable;
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        ArgumentUtils.requireNonNull((String)"requiredType", requiredType);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        boolean bl = isRepeatable = repeatable != null;
        if (isRepeatable) {
            List<AnnotationValue<? extends Annotation>> values = this.getAnnotationValuesByType(annotation);
            if (!values.isEmpty()) {
                return values.iterator().next().get((CharSequence)member, requiredType);
            }
            return Optional.empty();
        }
        return this.getValue(annotation.getName(), member, requiredType);
    }

    @Nonnull
    public <T> Optional<T> getValue(@Nonnull String annotation, @Nonnull String member, @Nonnull Argument<T> requiredType) {
        return this.getValue(annotation, member, requiredType, null);
    }

    @Nonnull
    <T> Optional<T> getValue(@Nonnull String annotation, @Nonnull String member, @Nonnull Argument<T> requiredType, @Nullable Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        ArgumentUtils.requireNonNull((String)"requiredType", requiredType);
        Optional resolved = Optional.empty();
        if (this.allAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation)) {
            Object rawValue;
            Map<CharSequence, Object> values = this.allAnnotations.get(annotation);
            if (values != null) {
                Object rawValue2 = values.get(member);
                if (rawValue2 != null) {
                    if (valueMapper != null) {
                        rawValue2 = valueMapper.apply(rawValue2);
                    }
                    resolved = ConversionService.SHARED.convert(rawValue2, requiredType);
                }
            } else if (this.allStereotypes != null && (values = this.allStereotypes.get(annotation)) != null && (rawValue = values.get(member)) != null) {
                if (valueMapper != null) {
                    rawValue = valueMapper.apply(rawValue);
                }
                resolved = ConversionService.SHARED.convert(rawValue, requiredType);
            }
        }
        if (!resolved.isPresent() && this.hasStereotype(annotation)) {
            return this.getDefaultValue(annotation, member, requiredType);
        }
        return resolved;
    }

    @Nonnull
    public <T> Optional<T> getDefaultValue(@Nonnull String annotation, @Nonnull String member, @Nonnull Class<T> requiredType) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        ArgumentUtils.requireNonNull((String)"requiredType", requiredType);
        Map<String, Object> defaultValues = AnnotationMetadataSupport.getDefaultValues(annotation);
        if (defaultValues.containsKey(member)) {
            return ConversionService.SHARED.convert(defaultValues.get(member), requiredType);
        }
        return Optional.empty();
    }

    @Nonnull
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByType(@Nullable Class<T> annotationType) {
        if (annotationType != null) {
            List<Object> results = this.annotationValuesByType.get(annotationType);
            if (results == null) {
                results = this.resolveAnnotationValuesByType(annotationType, this.allAnnotations, this.allStereotypes);
                if (results != null) {
                    return results;
                }
                results = Collections.emptyList();
                this.annotationValuesByType.put(annotationType, results);
            }
            return results;
        }
        return Collections.emptyList();
    }

    @Nonnull
    public <T extends Annotation> List<AnnotationValue<T>> getDeclaredAnnotationValuesByType(@Nonnull Class<T> annotationType) {
        Map<String, Map<CharSequence, Object>> sourceStereotypes;
        Map<String, Map<CharSequence, Object>> sourceAnnotations;
        List<AnnotationValue<T>> results;
        if (annotationType != null && (results = this.resolveAnnotationValuesByType(annotationType, sourceAnnotations = this.declaredAnnotations, sourceStereotypes = this.declaredStereotypes)) != null) {
            return results;
        }
        return Collections.emptyList();
    }

    public <T extends Annotation> T[] synthesizeAnnotationsByType(@Nonnull Class<T> annotationClass) {
        if (annotationClass != null) {
            List<AnnotationValue<T>> values = this.getAnnotationValuesByType(annotationClass);
            return (Annotation[])values.stream().map(entries -> AnnotationMetadataSupport.buildAnnotation(annotationClass, (ConvertibleValues<Object>)entries.getConvertibleValues())).toArray(value -> (Annotation[])Array.newInstance(annotationClass, value));
        }
        return AnnotationUtil.ZERO_ANNOTATIONS;
    }

    public <T extends Annotation> T[] synthesizeDeclaredAnnotationsByType(@Nonnull Class<T> annotationClass) {
        if (annotationClass != null) {
            List<AnnotationValue<T>> values = this.getAnnotationValuesByType(annotationClass);
            return (Annotation[])values.stream().map(entries -> AnnotationMetadataSupport.buildAnnotation(annotationClass, (ConvertibleValues<Object>)entries.getConvertibleValues())).toArray(value -> (Annotation[])Array.newInstance(annotationClass, value));
        }
        return AnnotationUtil.ZERO_ANNOTATIONS;
    }

    public boolean isEmpty() {
        return this.allAnnotations == null || this.allAnnotations.isEmpty();
    }

    public boolean hasDeclaredAnnotation(String annotation) {
        return this.declaredAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation) && this.declaredAnnotations.containsKey(annotation);
    }

    public boolean hasAnnotation(String annotation) {
        return this.hasDeclaredAnnotation(annotation) || this.allAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation) && this.allAnnotations.keySet().contains(annotation);
    }

    public boolean hasStereotype(String annotation) {
        return this.hasAnnotation(annotation) || this.allStereotypes != null && StringUtils.isNotEmpty((CharSequence)annotation) && this.allStereotypes.keySet().contains(annotation);
    }

    public boolean hasDeclaredStereotype(String annotation) {
        return this.hasDeclaredAnnotation(annotation) || this.declaredStereotypes != null && StringUtils.isNotEmpty((CharSequence)annotation) && this.declaredStereotypes.containsKey(annotation);
    }

    @Nonnull
    public Optional<Class<? extends Annotation>> getAnnotationTypeByStereotype(@Nullable String stereotype) {
        if (stereotype != null) {
            List<String> annotations;
            if (this.annotationsByStereotype != null && CollectionUtils.isNotEmpty(annotations = this.annotationsByStereotype.get(stereotype))) {
                return this.getAnnotationType(annotations.get(0));
            }
            if (this.allAnnotations != null && this.allAnnotations.containsKey(stereotype)) {
                return this.getAnnotationType(stereotype);
            }
            if (this.declaredAnnotations != null && this.declaredAnnotations.containsKey(stereotype)) {
                return this.getAnnotationType(stereotype);
            }
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<String> getAnnotationNameByStereotype(@Nullable String stereotype) {
        if (stereotype != null) {
            List<String> annotations;
            if (this.annotationsByStereotype != null && CollectionUtils.isNotEmpty(annotations = this.annotationsByStereotype.get(stereotype))) {
                return Optional.of(annotations.get(0));
            }
            if (this.allAnnotations != null && this.allAnnotations.containsKey(stereotype)) {
                return Optional.of(stereotype);
            }
            if (this.declaredAnnotations != null && this.declaredAnnotations.containsKey(stereotype)) {
                return Optional.of(stereotype);
            }
        }
        return Optional.empty();
    }

    @Nonnull
    public List<String> getAnnotationNamesByStereotype(@Nullable String stereotype) {
        List<String> annotations;
        if (stereotype == null) {
            return Collections.emptyList();
        }
        if (this.annotationsByStereotype != null && (annotations = this.annotationsByStereotype.get(stereotype)) != null) {
            return Collections.unmodifiableList(annotations);
        }
        if (this.allAnnotations != null && this.allAnnotations.containsKey(stereotype)) {
            return StringUtils.internListOf((Object[])new Object[]{stereotype});
        }
        if (this.declaredAnnotations != null && this.declaredAnnotations.containsKey(stereotype)) {
            return StringUtils.internListOf((Object[])new Object[]{stereotype});
        }
        return Collections.emptyList();
    }

    @Nonnull
    public Set<String> getAnnotationNames() {
        if (this.allAnnotations != null) {
            return this.allAnnotations.keySet();
        }
        return Collections.emptySet();
    }

    @Nonnull
    public Set<String> getDeclaredAnnotationNames() {
        if (this.declaredAnnotations != null) {
            return this.declaredAnnotations.keySet();
        }
        return Collections.emptySet();
    }

    @Nonnull
    public List<String> getDeclaredAnnotationNamesByStereotype(@Nullable String stereotype) {
        List<String> annotations;
        if (stereotype == null) {
            return Collections.emptyList();
        }
        if (this.annotationsByStereotype != null && (annotations = this.annotationsByStereotype.get(stereotype)) != null) {
            annotations = new ArrayList<String>(annotations);
            if (this.declaredAnnotations != null) {
                annotations.removeIf(s -> !this.declaredAnnotations.containsKey(s));
                return Collections.unmodifiableList(annotations);
            }
            return Collections.emptyList();
        }
        if (this.declaredAnnotations != null && this.declaredAnnotations.containsKey(stereotype)) {
            return StringUtils.internListOf((Object[])new Object[]{stereotype});
        }
        return Collections.emptyList();
    }

    @Nonnull
    public Optional<Class<? extends Annotation>> getAnnotationType(@Nonnull String name) {
        return AnnotationMetadataSupport.getAnnotationType(name);
    }

    @Nonnull
    public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(@Nonnull String annotation) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        if (this.allAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation)) {
            Map<CharSequence, Object> values = this.allAnnotations.get(annotation);
            if (values != null) {
                return Optional.of(new AnnotationValue(annotation, values, AnnotationMetadataSupport.getDefaultValues(annotation)));
            }
            if (this.allStereotypes != null && (values = this.allStereotypes.get(annotation)) != null) {
                return Optional.of(new AnnotationValue(annotation, values, AnnotationMetadataSupport.getDefaultValues(annotation)));
            }
        }
        return Optional.empty();
    }

    @Nonnull
    public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(@Nonnull String annotation) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        if (this.declaredAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation)) {
            Map<CharSequence, Object> values = this.declaredAnnotations.get(annotation);
            if (values != null) {
                return Optional.of(new AnnotationValue(annotation, values, AnnotationMetadataSupport.getDefaultValues(annotation)));
            }
            if (this.declaredStereotypes != null && (values = this.declaredStereotypes.get(annotation)) != null) {
                return Optional.of(new AnnotationValue(annotation, values, AnnotationMetadataSupport.getDefaultValues(annotation)));
            }
        }
        return Optional.empty();
    }

    @Nonnull
    public <T> OptionalValues<T> getValues(@Nonnull String annotation, @Nonnull Class<T> valueType) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"valueType", valueType);
        if (this.allAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation)) {
            Map<CharSequence, Object> values = this.allAnnotations.get(annotation);
            if (values != null) {
                return OptionalValues.of(valueType, values);
            }
            if (this.allStereotypes != null && (values = this.allStereotypes.get(annotation)) != null) {
                return OptionalValues.of(valueType, values);
            }
        }
        return OptionalValues.empty();
    }

    @Nonnull
    public <T> Optional<T> getDefaultValue(@Nonnull String annotation, @Nonnull String member, @Nonnull Argument<T> requiredType) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        ArgumentUtils.requireNonNull((String)"requiredType", requiredType);
        Map<String, Object> defaultValues = AnnotationMetadataSupport.getDefaultValues(annotation);
        if (defaultValues.containsKey(member)) {
            return ConversionService.SHARED.convert(defaultValues.get(member), requiredType);
        }
        return Optional.empty();
    }

    public AnnotationMetadata clone() {
        return new DefaultAnnotationMetadata(this.declaredAnnotations != null ? new HashMap<String, Map<CharSequence, Object>>(this.declaredAnnotations) : null, this.declaredStereotypes != null ? new HashMap<String, Map<CharSequence, Object>>(this.declaredStereotypes) : null, this.allStereotypes != null ? new HashMap<String, Map<CharSequence, Object>>(this.allStereotypes) : null, this.allAnnotations != null ? new HashMap<String, Map<CharSequence, Object>>(this.allAnnotations) : null, (Map<String, List<String>>)(this.annotationsByStereotype != null ? new HashMap<String, List<String>>(this.annotationsByStereotype) : null));
    }

    protected final void addAnnotation(String annotation, Map<CharSequence, Object> values) {
        if (annotation != null) {
            String repeatedName = this.getRepeatedName(annotation);
            Object v = values.get("value");
            if (v instanceof AnnotationValue[]) {
                AnnotationValue[] avs;
                for (AnnotationValue av : avs = (AnnotationValue[])v) {
                    this.addRepeatable(annotation, av);
                }
            } else if (v instanceof Iterable && repeatedName != null) {
                Iterable i = (Iterable)v;
                for (Object o : i) {
                    if (!(o instanceof AnnotationValue)) continue;
                    this.addRepeatable(annotation, (AnnotationValue)o);
                }
            } else {
                Map<String, Map<CharSequence, Object>> allAnnotations = this.getAllAnnotations();
                this.addAnnotation(annotation, values, null, allAnnotations, false);
            }
        }
    }

    protected final void addDefaultAnnotationValues(String annotation, Map<CharSequence, Object> values) {
        if (annotation != null) {
            Map<String, Map<CharSequence, Object>> annotationDefaults = this.annotationDefaultValues;
            if (annotationDefaults == null) {
                annotationDefaults = this.annotationDefaultValues = new HashMap<String, Map<CharSequence, Object>>();
            }
            this.putValues(annotation, values, annotationDefaults);
        }
    }

    @Internal
    protected static boolean areAnnotationDefaultsRegistered(String annotation) {
        return AnnotationMetadataSupport.hasDefaultValues(annotation);
    }

    @Internal
    protected static void registerAnnotationDefaults(String annotation, Map<String, Object> defaultValues) {
        AnnotationMetadataSupport.registerDefaultValues(annotation, defaultValues);
    }

    @Internal
    protected static void registerAnnotationDefaults(AnnotationClassValue<?> annotation, Map<String, Object> defaultValues) {
        AnnotationMetadataSupport.registerDefaultValues(annotation, defaultValues);
    }

    @Internal
    protected static void registerAnnotationType(AnnotationClassValue<?> annotation) {
        AnnotationMetadataSupport.registerAnnotationType(annotation);
    }

    protected final void addRepeatable(String annotationName, AnnotationValue annotationValue) {
        if (StringUtils.isNotEmpty((CharSequence)annotationName) && annotationValue != null) {
            Map<String, Map<CharSequence, Object>> allAnnotations = this.getAllAnnotations();
            this.addRepeatableInternal(annotationName, annotationValue, allAnnotations);
        }
    }

    protected void addRepeatableStereotype(List<String> parents, String stereotype, AnnotationValue annotationValue) {
        Map<String, Map<CharSequence, Object>> allStereotypes = this.getAllStereotypes();
        List<String> annotationList = this.getAnnotationsByStereotypeInternal(stereotype);
        for (String parentAnnotation : parents) {
            if (annotationList.contains(parentAnnotation)) continue;
            annotationList.add(parentAnnotation);
        }
        this.addRepeatableInternal(stereotype, annotationValue, allStereotypes);
    }

    protected void addDeclaredRepeatableStereotype(List<String> parents, String stereotype, AnnotationValue annotationValue) {
        Map<String, Map<CharSequence, Object>> declaredStereotypes = this.getDeclaredStereotypesInternal();
        List<String> annotationList = this.getAnnotationsByStereotypeInternal(stereotype);
        for (String parentAnnotation : parents) {
            if (annotationList.contains(parentAnnotation)) continue;
            annotationList.add(parentAnnotation);
        }
        this.addRepeatableInternal(stereotype, annotationValue, declaredStereotypes);
        this.addRepeatableInternal(stereotype, annotationValue, this.getAllStereotypes());
    }

    protected final void addDeclaredRepeatable(String annotationName, AnnotationValue annotationValue) {
        if (StringUtils.isNotEmpty((CharSequence)annotationName) && annotationValue != null) {
            Map<String, Map<CharSequence, Object>> allAnnotations = this.getDeclaredAnnotationsInternal();
            this.addRepeatableInternal(annotationName, annotationValue, allAnnotations);
            this.addRepeatable(annotationName, annotationValue);
        }
    }

    protected final void addStereotype(List<String> parentAnnotations, String stereotype, Map<CharSequence, Object> values) {
        if (stereotype != null) {
            String repeatedName = this.getRepeatedName(stereotype);
            if (repeatedName != null) {
                Object v = values.get("value");
                if (v instanceof AnnotationValue[]) {
                    AnnotationValue[] avs;
                    for (AnnotationValue av : avs = (AnnotationValue[])v) {
                        this.addRepeatableStereotype(parentAnnotations, stereotype, av);
                    }
                } else if (v instanceof Iterable) {
                    Iterable i = (Iterable)v;
                    for (Object o : i) {
                        if (!(o instanceof AnnotationValue)) continue;
                        this.addRepeatableStereotype(parentAnnotations, stereotype, (AnnotationValue)o);
                    }
                }
            } else {
                Map<String, Map<CharSequence, Object>> allStereotypes = this.getAllStereotypes();
                List<String> annotationList = this.getAnnotationsByStereotypeInternal(stereotype);
                for (String parentAnnotation : parentAnnotations) {
                    if (annotationList.contains(parentAnnotation)) continue;
                    annotationList.add(parentAnnotation);
                }
                this.addAnnotation(stereotype, values, null, allStereotypes, false);
            }
        }
    }

    protected final void addDeclaredStereotype(List<String> parentAnnotations, String stereotype, Map<CharSequence, Object> values) {
        if (stereotype != null) {
            String repeatedName = this.getRepeatedName(stereotype);
            if (repeatedName != null) {
                Object v = values.get("value");
                if (v instanceof AnnotationValue[]) {
                    AnnotationValue[] avs;
                    for (AnnotationValue av : avs = (AnnotationValue[])v) {
                        this.addDeclaredRepeatableStereotype(parentAnnotations, stereotype, av);
                    }
                } else if (v instanceof Iterable) {
                    Iterable i = (Iterable)v;
                    for (Object o : i) {
                        if (!(o instanceof AnnotationValue)) continue;
                        this.addDeclaredRepeatableStereotype(parentAnnotations, stereotype, (AnnotationValue)o);
                    }
                }
            } else {
                Map<String, Map<CharSequence, Object>> declaredStereotypes = this.getDeclaredStereotypesInternal();
                Map<String, Map<CharSequence, Object>> allStereotypes = this.getAllStereotypes();
                List<String> annotationList = this.getAnnotationsByStereotypeInternal(stereotype);
                for (String parentAnnotation : parentAnnotations) {
                    if (annotationList.contains(parentAnnotation)) continue;
                    annotationList.add(parentAnnotation);
                }
                this.addAnnotation(stereotype, values, declaredStereotypes, allStereotypes, true);
            }
        }
    }

    protected void addDeclaredAnnotation(String annotation, Map<CharSequence, Object> values) {
        if (annotation != null) {
            String repeatedName = this.getRepeatedName(annotation);
            if (repeatedName != null) {
                Object v = values.get("value");
                if (v instanceof AnnotationValue[]) {
                    AnnotationValue[] avs;
                    for (AnnotationValue av : avs = (AnnotationValue[])v) {
                        this.addDeclaredRepeatable(annotation, av);
                    }
                } else if (v instanceof Iterable) {
                    Iterable i = (Iterable)v;
                    for (Object o : i) {
                        if (!(o instanceof AnnotationValue)) continue;
                        this.addDeclaredRepeatable(annotation, (AnnotationValue)o);
                    }
                }
            } else {
                Map<String, Map<CharSequence, Object>> declaredAnnotations = this.getDeclaredAnnotationsInternal();
                Map<String, Map<CharSequence, Object>> allAnnotations = this.getAllAnnotations();
                this.addAnnotation(annotation, values, declaredAnnotations, allAnnotations, true);
            }
        }
    }

    @Internal
    void dump() {
        System.out.println("declaredAnnotations = " + this.declaredAnnotations);
        System.out.println("declaredStereotypes = " + this.declaredStereotypes);
        System.out.println("allAnnotations = " + this.allAnnotations);
        System.out.println("allStereotypes = " + this.allStereotypes);
        System.out.println("annotationsByStereotype = " + this.annotationsByStereotype);
    }

    private <T extends Annotation> List<AnnotationValue<T>> resolveAnnotationValuesByType(Class<T> annotationType, Map<String, Map<CharSequence, Object>> sourceAnnotations, Map<String, Map<CharSequence, Object>> sourceStereotypes) {
        Class<? extends Annotation> repeatableType;
        Repeatable repeatable = annotationType.getAnnotation(Repeatable.class);
        if (repeatable != null && this.hasStereotype(repeatableType = repeatable.value())) {
            Map<CharSequence, Object> values;
            ArrayList<AnnotationValue<T>> results = new ArrayList<AnnotationValue<T>>();
            if (sourceAnnotations != null) {
                values = sourceAnnotations.get(repeatableType.getName());
                this.addAnnotationValuesFromData(results, values);
            }
            if (sourceStereotypes != null) {
                values = sourceStereotypes.get(repeatableType.getName());
                this.addAnnotationValuesFromData(results, values);
            }
            return results;
        }
        return null;
    }

    private void addAnnotation(String annotation, Map<CharSequence, Object> values, Map<String, Map<CharSequence, Object>> declaredAnnotations, Map<String, Map<CharSequence, Object>> allAnnotations, boolean isDeclared) {
        if (isDeclared && declaredAnnotations != null) {
            this.putValues(annotation, values, declaredAnnotations);
        }
        this.putValues(annotation, values, allAnnotations);
    }

    private void putValues(String annotation, Map<CharSequence, Object> values, Map<String, Map<CharSequence, Object>> currentAnnotationValues) {
        Map<CharSequence, Object> existing = currentAnnotationValues.get(annotation);
        boolean hasValues = CollectionUtils.isNotEmpty(values);
        if (existing != null && hasValues) {
            if (existing.isEmpty()) {
                existing = new LinkedHashMap<CharSequence, Object>();
                currentAnnotationValues.put(annotation, existing);
            }
            for (CharSequence key : values.keySet()) {
                if (existing.containsKey(key)) continue;
                existing.put(key, values.get(key));
            }
        } else {
            if (!hasValues) {
                existing = existing == null ? Collections.emptyMap() : existing;
            } else {
                existing = new LinkedHashMap<CharSequence, Object>(values.size());
                existing.putAll(values);
            }
            currentAnnotationValues.put(annotation, existing);
        }
    }

    private Map<String, Map<CharSequence, Object>> getAllStereotypes() {
        Map<String, Map<CharSequence, Object>> stereotypes = this.allStereotypes;
        if (stereotypes == null) {
            this.allStereotypes = stereotypes = new HashMap<String, Map<CharSequence, Object>>(3);
        }
        return stereotypes;
    }

    private Map<String, Map<CharSequence, Object>> getDeclaredStereotypesInternal() {
        Map<String, Map<CharSequence, Object>> stereotypes = this.declaredStereotypes;
        if (stereotypes == null) {
            this.declaredStereotypes = stereotypes = new HashMap<String, Map<CharSequence, Object>>(3);
        }
        return stereotypes;
    }

    private Map<String, Map<CharSequence, Object>> getAllAnnotations() {
        Map<String, Map<CharSequence, Object>> annotations = this.allAnnotations;
        if (annotations == null) {
            this.allAnnotations = annotations = new HashMap<String, Map<CharSequence, Object>>(3);
        }
        return annotations;
    }

    private Map<String, Map<CharSequence, Object>> getDeclaredAnnotationsInternal() {
        Map<String, Map<CharSequence, Object>> annotations = this.declaredAnnotations;
        if (annotations == null) {
            this.declaredAnnotations = annotations = new HashMap<String, Map<CharSequence, Object>>(3);
        }
        return annotations;
    }

    private List<String> getAnnotationsByStereotypeInternal(String stereotype) {
        return this.getAnnotationsByStereotypeInternal().computeIfAbsent(stereotype, s -> new ArrayList());
    }

    private String getRepeatedName(String annotation) {
        if (this.repeated != null) {
            return this.repeated.get(annotation);
        }
        return null;
    }

    private Map<String, List<String>> getAnnotationsByStereotypeInternal() {
        Map<String, List<String>> annotations = this.annotationsByStereotype;
        if (annotations == null) {
            this.annotationsByStereotype = annotations = new HashMap<String, List<String>>(3);
        }
        return annotations;
    }

    @Nullable
    private Object getRawSingleValue(@Nonnull String annotation, @Nonnull String member, @Nullable Function<Object, Object> valueMapper) {
        int len;
        Object rawValue = this.getRawValue(annotation, member);
        if (rawValue != null && rawValue.getClass().isArray() && (len = Array.getLength(rawValue)) > 0) {
            rawValue = Array.get(rawValue, 0);
        }
        if (valueMapper != null && rawValue instanceof CharSequence) {
            return valueMapper.apply(rawValue);
        }
        return rawValue;
    }

    @Nullable
    private Object getRawValue(@Nonnull String annotation, @Nonnull String member) {
        Object rawValue = null;
        if (this.allAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation)) {
            Map<CharSequence, Object> values = this.allAnnotations.get(annotation);
            if (values != null) {
                rawValue = values.get(member);
            } else if (this.allStereotypes != null && (values = this.allStereotypes.get(annotation)) != null) {
                rawValue = values.get(member);
            }
        }
        return rawValue;
    }

    private void addRepeatableInternal(String annotationName, AnnotationValue annotationValue, Map<String, Map<CharSequence, Object>> allAnnotations) {
        this.addRepeatableInternal(annotationName, "value", annotationValue, allAnnotations);
    }

    private void addRepeatableInternal(String annotationName, String member, AnnotationValue annotationValue, Map<String, Map<CharSequence, Object>> allAnnotations) {
        if (this.repeated == null) {
            this.repeated = new HashMap<String, String>(2);
        }
        this.repeated.put(annotationName, annotationValue.getAnnotationName());
        Map values = allAnnotations.computeIfAbsent(annotationName, s -> new HashMap());
        Object v = values.get(member);
        if (v != null) {
            if (v.getClass().isArray()) {
                Object[] array = (Object[])v;
                LinkedHashSet<Object> newValues = new LinkedHashSet<Object>(array.length + 1);
                newValues.addAll(Arrays.asList(array));
                newValues.add(annotationValue);
                values.put(member, newValues);
            } else if (v instanceof Collection) {
                ((Collection)v).add(annotationValue);
            }
        } else {
            LinkedHashSet<AnnotationValue> newValues = new LinkedHashSet<AnnotationValue>(2);
            newValues.add(annotationValue);
            values.put(member, newValues);
        }
    }

    @Internal
    public static AnnotationMetadata mutateMember(AnnotationMetadata annotationMetadata, String annotationName, String member, Object value) {
        return DefaultAnnotationMetadata.mutateMember(annotationMetadata, annotationName, Collections.singletonMap(member, value));
    }

    @Internal
    public static void contributeDefaults(AnnotationMetadata target, AnnotationMetadata source) {
        Map<String, Map<CharSequence, Object>> additionalDefaults;
        Map<String, Map<CharSequence, Object>> existingDefaults;
        if (target instanceof DefaultAnnotationMetadata && source instanceof DefaultAnnotationMetadata && (existingDefaults = ((DefaultAnnotationMetadata)target).annotationDefaultValues) != null && (additionalDefaults = ((DefaultAnnotationMetadata)source).annotationDefaultValues) != null) {
            existingDefaults.putAll(additionalDefaults);
        }
    }

    @Internal
    public static AnnotationMetadata mutateMember(AnnotationMetadata annotationMetadata, final String annotationName, final Map<CharSequence, Object> members) {
        if (StringUtils.isEmpty((CharSequence)annotationName)) {
            throw new IllegalArgumentException("Argument [annotationName] cannot be blank");
        }
        if (!members.isEmpty()) {
            for (Map.Entry<CharSequence, Object> entry : members.entrySet()) {
                if (StringUtils.isEmpty((CharSequence)entry.getKey())) {
                    throw new IllegalArgumentException("Argument [members] cannot have a blank key");
                }
                if (entry.getValue() != null) continue;
                throw new IllegalArgumentException("Argument [members] cannot have a null value. Key [" + entry.getKey() + "]");
            }
        }
        if (!(annotationMetadata instanceof DefaultAnnotationMetadata)) {
            return new DefaultAnnotationMetadata(){
                {
                    this.addDeclaredAnnotation(annotationName, members);
                }
            };
        }
        DefaultAnnotationMetadata defaultMetadata = (DefaultAnnotationMetadata)annotationMetadata;
        defaultMetadata = (DefaultAnnotationMetadata)defaultMetadata.clone();
        defaultMetadata.addDeclaredAnnotation(annotationName, members);
        return defaultMetadata;
    }

    static {
        ConversionService.SHARED.addConverter(AnnotationValue.class, Annotation.class, (object, targetType, context) -> {
            Optional annotationClass = ClassUtils.forName((String)object.getAnnotationName(), (ClassLoader)targetType.getClassLoader());
            return annotationClass.map(aClass -> AnnotationMetadataSupport.buildAnnotation(aClass, (ConvertibleValues<Object>)ConvertibleValues.of((Map)object.getValues())));
        });
        ConversionService.SHARED.addConverter(AnnotationValue[].class, Object[].class, (object, targetType, context) -> {
            ArrayList result = new ArrayList();
            Class annotationClass = null;
            for (AnnotationValue annotationValue : object) {
                if (annotationClass == null) {
                    Optional aClass = ClassUtils.forName((String)annotationValue.getAnnotationName(), (ClassLoader)targetType.getClassLoader());
                    if (!aClass.isPresent()) break;
                    annotationClass = (Class)aClass.get();
                }
                Object annotation = AnnotationMetadataSupport.buildAnnotation(annotationClass, (ConvertibleValues<Object>)ConvertibleValues.of((Map)annotationValue.getValues()));
                result.add(annotation);
            }
            if (!result.isEmpty()) {
                return Optional.of(result.toArray((Object[])Array.newInstance(annotationClass, result.size())));
            }
            return Optional.empty();
        });
    }
}

