/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.value;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.value.PropertyResolver;
import java.util.Map;
import java.util.Optional;

public class MapPropertyResolver
implements PropertyResolver {
    private final Map<String, Object> map;
    private final ConversionService<?> conversionService;

    public MapPropertyResolver(Map<String, Object> map) {
        this.map = map;
        this.conversionService = ConversionService.SHARED;
    }

    public MapPropertyResolver(Map<String, Object> map, ConversionService conversionService) {
        this.map = map;
        this.conversionService = conversionService;
    }

    @Override
    public boolean containsProperty(String name) {
        return this.map.containsKey(name);
    }

    @Override
    public boolean containsProperties(String name) {
        return this.map.keySet().stream().anyMatch(k -> k.startsWith(name));
    }

    @Override
    public <T> Optional<T> getProperty(String name, ArgumentConversionContext<T> conversionContext) {
        Object value = this.map.get(name);
        return this.conversionService.convert(value, conversionContext);
    }
}

