/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartPointerManagerImpl
extends SmartPointerManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl");
    private final Project myProject;
    private final Key<SmartPointerTracker> POINTERS_KEY;
    private final PsiDocumentManagerBase myPsiDocManager;
    private static final Key<Reference<SmartPsiElementPointerImpl>> CACHED_SMART_POINTER_KEY = Key.create("CACHED_SMART_POINTER_KEY");

    public SmartPointerManagerImpl(Project project, PsiDocumentManagerBase psiDocManager) {
        this.myProject = project;
        this.myPsiDocManager = psiDocManager;
        this.POINTERS_KEY = Key.create("SMART_POINTERS " + SmartPointerManagerImpl.anonymize(project));
    }

    @NotNull
    private static String anonymize(@NotNull Project project) {
        if (project == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(0);
        }
        String string = project.isDefault() ? "default" : String.valueOf(project.hashCode());
        if (string == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void fastenBelts(@NotNull VirtualFile file2) {
        SmartPointerTracker pointers;
        if (file2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(2);
        }
        if ((pointers = this.getTracker(file2)) != null) {
            pointers.fastenBelts(this);
        }
    }

    @Override
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element) {
        if (element == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile containingFile = element.getContainingFile();
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile);
        if (smartPsiElementPointer == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(4);
        }
        return smartPsiElementPointer;
    }

    @Override
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile) {
        if (element == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(5);
        }
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile, false);
        if (smartPsiElementPointer == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(6);
        }
        return smartPsiElementPointer;
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile, boolean forInjected) {
        if (element == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(7);
        }
        SmartPointerManagerImpl.ensureValid(element, containingFile);
        SmartPointerTracker.processQueue();
        this.ensureMyProject(containingFile != null ? containingFile.getProject() : element.getProject());
        SmartPsiElementPointerImpl<E> pointer = SmartPointerManagerImpl.getCachedPointer(element);
        if (!(pointer == null || pointer.getElementInfo() instanceof SelfElementInfo && ((SelfElementInfo)pointer.getElementInfo()).isForInjected() != forInjected || pointer.incrementAndGetReferenceCount(1) <= 0)) {
            SmartPsiElementPointerImpl<E> smartPsiElementPointerImpl = pointer;
            if (smartPsiElementPointerImpl == null) {
                SmartPointerManagerImpl.$$$reportNull$$$0(8);
            }
            return smartPsiElementPointerImpl;
        }
        pointer = new SmartPsiElementPointerImpl<E>(this, element, containingFile, forInjected);
        if (containingFile != null) {
            this.trackPointer(pointer, containingFile.getViewProvider().getVirtualFile());
        }
        element.putUserData(CACHED_SMART_POINTER_KEY, new SoftReference<SmartPsiElementPointerImpl<E>>(pointer));
        SmartPsiElementPointerImpl<E> smartPsiElementPointerImpl = pointer;
        if (smartPsiElementPointerImpl == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(9);
        }
        return smartPsiElementPointerImpl;
    }

    private void ensureMyProject(@NotNull Project project) {
        if (project == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(10);
        }
        if (project != this.myProject) {
            throw new IllegalArgumentException("Element from alien project: " + SmartPointerManagerImpl.anonymize(project) + " expected: " + SmartPointerManagerImpl.anonymize(this.myProject));
        }
    }

    private static void ensureValid(@NotNull PsiElement element, @Nullable PsiFile containingFile) {
        boolean valid;
        if (element == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(11);
        }
        boolean bl = valid = containingFile != null ? containingFile.isValid() : element.isValid();
        if (!valid) {
            PsiUtilCore.ensureValid(element);
            if (containingFile != null && !containingFile.isValid()) {
                throw new PsiInvalidElementAccessException((PsiElement)containingFile, "Element " + element.getClass() + "(" + element.getLanguage() + ") claims to be valid but returns invalid containing file ");
            }
        }
    }

    private static <E extends PsiElement> SmartPsiElementPointerImpl<E> getCachedPointer(@NotNull E element) {
        Object cachedElement;
        Reference<SmartPsiElementPointerImpl> data;
        SmartPsiElementPointerImpl cachedPointer;
        if (element == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(12);
        }
        if ((cachedPointer = SoftReference.dereference(data = element.getUserData(CACHED_SMART_POINTER_KEY))) != null && (cachedElement = cachedPointer.getElement()) != element) {
            return null;
        }
        return cachedPointer;
    }

    @Override
    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file2, @NotNull TextRange range) {
        if (file2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(13);
        }
        if (range == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(14);
        }
        SmartPsiFileRange smartPsiFileRange = this.createSmartPsiFileRangePointer(file2, range, false);
        if (smartPsiFileRange == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(15);
        }
        return smartPsiFileRange;
    }

    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file2, @NotNull TextRange range, boolean forInjected) {
        if (file2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(16);
        }
        if (range == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(17);
        }
        PsiUtilCore.ensureValid(file2);
        SmartPointerTracker.processQueue();
        SmartPsiFileRangePointerImpl pointer = new SmartPsiFileRangePointerImpl(this, file2, ProperTextRange.create(range), forInjected);
        this.trackPointer(pointer, file2.getViewProvider().getVirtualFile());
        SmartPsiFileRangePointerImpl smartPsiFileRangePointerImpl = pointer;
        if (smartPsiFileRangePointerImpl == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(18);
        }
        return smartPsiFileRangePointerImpl;
    }

    private <E extends PsiElement> void trackPointer(@NotNull SmartPsiElementPointerImpl<E> pointer, @NotNull VirtualFile containingFile) {
        SmartPointerTracker pointers;
        SmartPointerElementInfo info2;
        if (pointer == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(19);
        }
        if (containingFile == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(20);
        }
        if (!((info2 = pointer.getElementInfo()) instanceof SelfElementInfo)) {
            return;
        }
        SmartPointerTracker.PointerReference reference = new SmartPointerTracker.PointerReference(pointer, containingFile, this.POINTERS_KEY);
        do {
            if ((pointers = this.getTracker(containingFile)) != null) continue;
            pointers = containingFile.putUserDataIfAbsent(this.POINTERS_KEY, new SmartPointerTracker());
        } while (!pointers.addReference(reference, pointer));
    }

    @Override
    public void removePointer(@NotNull SmartPsiElementPointer pointer) {
        if (pointer == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(21);
        }
        if (!(pointer instanceof SmartPsiElementPointerImpl) || this.myProject.isDisposed()) {
            return;
        }
        this.ensureMyProject(pointer.getProject());
        int refCount = ((SmartPsiElementPointerImpl)pointer).incrementAndGetReferenceCount(-1);
        if (refCount == -1) {
            LOG.error("Double smart pointer removal");
            return;
        }
        if (refCount == 0) {
            PsiElement element = ((SmartPointerEx)pointer).getCachedElement();
            if (element != null) {
                element.putUserData(CACHED_SMART_POINTER_KEY, null);
            }
            SmartPointerElementInfo info2 = ((SmartPsiElementPointerImpl)pointer).getElementInfo();
            info2.cleanup();
            SmartPointerTracker.PointerReference reference = ((SmartPsiElementPointerImpl)pointer).pointerReference;
            if (reference != null) {
                if (reference.get() != pointer) {
                    throw new IllegalStateException("Reference points to " + reference.get());
                }
                if (reference.key != this.POINTERS_KEY) {
                    throw new IllegalStateException("Reference from wrong project: " + reference.key + " vs " + this.POINTERS_KEY);
                }
                SmartPointerTracker pointers = this.getTracker(reference.file);
                if (pointers != null) {
                    pointers.removeReference(reference);
                }
            }
        }
    }

    @Nullable
    SmartPointerTracker getTracker(@NotNull VirtualFile containingFile) {
        if (containingFile == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(22);
        }
        return containingFile.getUserData(this.POINTERS_KEY);
    }

    public int getPointersNumber(@NotNull PsiFile containingFile) {
        VirtualFile file2;
        SmartPointerTracker pointers;
        if (containingFile == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(23);
        }
        return (pointers = this.getTracker(file2 = containingFile.getViewProvider().getVirtualFile())) == null ? 0 : pointers.getSize();
    }

    @Override
    public boolean pointToTheSameElement(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        if (pointer1 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(24);
        }
        if (pointer2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(25);
        }
        return SmartPsiElementPointerImpl.pointsToTheSameElementAs(pointer1, pointer2);
    }

    public void updatePointers(@NotNull Document document, @NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        VirtualFile file2;
        SmartPointerTracker list2;
        if (document == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(26);
        }
        if (frozen == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(27);
        }
        if (events == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(28);
        }
        SmartPointerTracker smartPointerTracker = list2 = (file2 = FileDocumentManager.getInstance().getFile(document)) == null ? null : this.getTracker(file2);
        if (list2 != null) {
            list2.updateMarkers(frozen, events);
        }
    }

    public void updatePointerTargetsAfterReparse(@NotNull VirtualFile file2) {
        SmartPointerTracker list2;
        if (file2 == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(29);
        }
        if ((list2 = this.getTracker(file2)) != null) {
            list2.updatePointerTargetsAfterReparse();
        }
    }

    @NotNull
    Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(30);
        }
        return project;
    }

    @NotNull
    PsiDocumentManagerBase getPsiDocumentManager() {
        PsiDocumentManagerBase psiDocumentManagerBase = this.myPsiDocManager;
        if (psiDocumentManagerBase == null) {
            SmartPointerManagerImpl.$$$reportNull$$$0(31);
        }
        return psiDocumentManagerBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl";
                break;
            }
            case 2: 
            case 13: 
            case 16: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer1";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer2";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frozen";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "anonymize";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmartPsiElementPointer";
                break;
            }
            case 15: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmartPsiFileRangePointer";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiDocumentManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "anonymize";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 30: 
            case 31: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fastenBelts";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createSmartPsiElementPointer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "ensureMyProject";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPointer";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createSmartPsiFileRangePointer";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "trackPointer";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removePointer";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTracker";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPointersNumber";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "pointToTheSameElement";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "updatePointers";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "updatePointerTargetsAfterReparse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

