/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRulePerformer;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.MatchState;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenMatcher;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.rules.patterns.RuleFilterEvaluator;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;

class DisambiguationPatternRuleReplacer
extends AbstractPatternRulePerformer {
    private final List<Boolean> pTokensMatched;

    DisambiguationPatternRuleReplacer(DisambiguationPatternRule rule) {
        super(rule, rule.getLanguage().getDisambiguationUnifier());
        this.pTokensMatched = new ArrayList<Boolean>(rule.getPatternTokens().size());
    }

    public final AnalyzedSentence replace(AnalyzedSentence sentence) throws IOException {
        int i;
        List<PatternTokenMatcher> patternTokenMatchers = this.createElementMatchers();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        AnalyzedTokenReadings[] preDisambigTokens = sentence.getTokens();
        AnalyzedTokenReadings[] whTokens = sentence.getTokens();
        int[] tokenPositions = new int[tokens.length + 1];
        int patternSize = patternTokenMatchers.size();
        int limit = Math.max(0, tokens.length - patternSize + 1);
        PatternTokenMatcher pTokenMatcher = null;
        boolean changed = false;
        this.pTokensMatched.clear();
        for (i = 0; i < patternTokenMatchers.size(); ++i) {
            this.pTokensMatched.add(Boolean.FALSE);
        }
        int minOccurCorrection = this.getMinOccurrenceCorrection();
        for (i = 0; !(i >= limit + minOccurCorrection || this.rule.isSentStart() && i > 0); ++i) {
            int skipShiftTotal = 0;
            boolean allElementsMatch = false;
            this.unifiedTokens = null;
            int matchingTokens = 0;
            int firstMatchToken = -1;
            int lastMatchToken = -1;
            int firstMarkerMatchToken = -1;
            int lastMarkerMatchToken = -1;
            int prevSkipNext = 0;
            if (this.rule.isTestUnification()) {
                this.unifier.reset();
            }
            int minOccurSkip = 0;
            for (int k = 0; k < patternSize; ++k) {
                PatternTokenMatcher prevTokenMatcher = pTokenMatcher;
                pTokenMatcher = patternTokenMatchers.get(k);
                pTokenMatcher.resolveReference(firstMatchToken, tokens, this.rule.getLanguage());
                int nextPos = i + k + skipShiftTotal - minOccurSkip;
                this.prevMatched = false;
                if (prevSkipNext + nextPos >= tokens.length || prevSkipNext < 0) {
                    prevSkipNext = tokens.length - (nextPos + 1);
                }
                int maxTok = Math.min(nextPos + prevSkipNext, tokens.length - (patternSize - k) + minOccurCorrection);
                for (int m = nextPos; m <= maxTok; ++m) {
                    PatternTokenMatcher nextElement;
                    boolean nextElementMatch;
                    allElementsMatch = this.testAllReadings(tokens, pTokenMatcher, prevTokenMatcher, m, firstMatchToken, prevSkipNext);
                    if (pTokenMatcher.getPatternToken().getMinOccurrence() == 0 && k + 1 < patternTokenMatchers.size() && (nextElementMatch = this.testAllReadings(tokens, nextElement = patternTokenMatchers.get(k + 1), pTokenMatcher, m, firstMatchToken, prevSkipNext))) {
                        allElementsMatch = true;
                        ++minOccurSkip;
                        this.pTokensMatched.set(k, false);
                        break;
                    }
                    if (!allElementsMatch) continue;
                    this.pTokensMatched.set(k, true);
                    int skipForMax = this.skipMaxTokens(tokens, pTokenMatcher, firstMatchToken, prevSkipNext, prevTokenMatcher, m, patternSize - k - 1);
                    lastMatchToken = m + skipForMax;
                    int skipShift = lastMatchToken - nextPos;
                    tokenPositions[matchingTokens] = skipShift + 1;
                    prevSkipNext = pTokenMatcher.getPatternToken().getSkipNext();
                    ++matchingTokens;
                    skipShiftTotal += skipShift;
                    if (firstMatchToken == -1) {
                        firstMatchToken = lastMatchToken - skipForMax;
                    }
                    if (firstMarkerMatchToken == -1 && pTokenMatcher.getPatternToken().isInsideMarker()) {
                        firstMarkerMatchToken = lastMatchToken - skipForMax;
                    }
                    if (!pTokenMatcher.getPatternToken().isInsideMarker()) break;
                    lastMarkerMatchToken = lastMatchToken;
                    break;
                }
                if (!allElementsMatch) break;
            }
            if ((!allElementsMatch || matchingTokens != patternSize) && (matchingTokens != patternSize - minOccurSkip || firstMatchToken == -1)) continue;
            int ruleMatchFromPos = -1;
            int ruleMatchToPos = -1;
            int tokenCount = 0;
            for (AnalyzedTokenReadings token : tokens) {
                if (ruleMatchFromPos == -1 && tokenCount == firstMatchToken) {
                    ruleMatchFromPos = token.getStartPos();
                }
                if (ruleMatchToPos == -1 && tokenCount == lastMatchToken) {
                    ruleMatchToPos = token.getEndPos();
                }
                ++tokenCount;
            }
            if (!this.keepDespiteFilter(tokens, tokenPositions, firstMatchToken, lastMatchToken) || !this.keepByDisambig(sentence, ruleMatchFromPos, ruleMatchToPos)) continue;
            whTokens = this.executeAction(sentence, whTokens, this.unifiedTokens, firstMatchToken, lastMarkerMatchToken, matchingTokens, tokenPositions);
            changed = true;
        }
        if (changed) {
            return new AnalyzedSentence(whTokens, preDisambigTokens);
        }
        return sentence;
    }

    private boolean keepByDisambig(AnalyzedSentence sentence, int ruleMatchFromPos, int ruleMatchToPos) throws IOException {
        List<DisambiguationPatternRule> antiPatterns = this.rule.getAntiPatterns();
        for (DisambiguationPatternRule antiPattern : antiPatterns) {
            PatternRule disambigRule = new PatternRule("fake-disambig-id", this.rule.getLanguage(), antiPattern.getPatternTokens(), "desc", "msg", "short");
            RuleMatch[] matches = disambigRule.match(sentence);
            if (matches == null) continue;
            for (RuleMatch disMatch : matches) {
                if (!(disMatch.getFromPos() <= ruleMatchFromPos && disMatch.getToPos() >= ruleMatchFromPos || disMatch.getFromPos() <= ruleMatchToPos && disMatch.getToPos() >= ruleMatchToPos) && (disMatch.getFromPos() < ruleMatchFromPos || disMatch.getToPos() > ruleMatchToPos)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean keepDespiteFilter(AnalyzedTokenReadings[] tokens, int[] tokenPositions, int firstMatchToken, int lastMatchToken) {
        RuleFilter filter = this.rule.getFilter();
        if (filter != null) {
            RuleFilterEvaluator ruleFilterEval = new RuleFilterEvaluator(filter);
            ArrayList<Integer> tokensPos = new ArrayList<Integer>();
            for (int tokenPosition : tokenPositions) {
                tokensPos.add(tokenPosition);
            }
            Map<String, String> resolvedArguments = ruleFilterEval.getResolvedArguments(this.rule.getFilterArguments(), tokens, firstMatchToken, tokensPos);
            AnalyzedTokenReadings[] relevantTokens = Arrays.copyOfRange(tokens, firstMatchToken, lastMatchToken + 1);
            return filter.matches(resolvedArguments, relevantTokens, firstMatchToken);
        }
        return true;
    }

    @Override
    protected int skipMaxTokens(AnalyzedTokenReadings[] tokens, PatternTokenMatcher matcher, int firstMatchToken, int prevSkipNext, PatternTokenMatcher prevElement, int m, int remainingElems) throws IOException {
        boolean nextAllElementsMatch;
        int maxSkip = 0;
        int maxOccurrences = matcher.getPatternToken().getMaxOccurrence() == -1 ? Integer.MAX_VALUE : matcher.getPatternToken().getMaxOccurrence();
        for (int j = 1; j < maxOccurrences && m + j < tokens.length - remainingElems && (nextAllElementsMatch = this.testAllReadings(tokens, matcher, prevElement, m + j, firstMatchToken, prevSkipNext)); ++j) {
            ++maxSkip;
        }
        return maxSkip;
    }

    private AnalyzedTokenReadings[] executeAction(AnalyzedSentence sentence, AnalyzedTokenReadings[] whiteTokens, AnalyzedTokenReadings[] unifiedTokens, int firstMatchToken, int lastMatchToken, int matchingTokens, int[] tokenPositions) {
        AnalyzedTokenReadings[] whTokens = (AnalyzedTokenReadings[])whiteTokens.clone();
        DisambiguationPatternRule rule = (DisambiguationPatternRule)this.rule;
        int correctedStPos = 0;
        int startPositionCorrection = rule.getStartPositionCorrection();
        int endPositionCorrection = rule.getEndPositionCorrection();
        int matchingTokensWithCorrection = matchingTokens;
        ArrayList<Integer> tokenPositionList = new ArrayList<Integer>();
        for (int i : tokenPositions) {
            tokenPositionList.add(i);
        }
        if (startPositionCorrection > 0) {
            --correctedStPos;
            for (int j = 0; j < this.pTokensMatched.size(); ++j) {
                if (this.pTokensMatched.get(j).booleanValue()) continue;
                tokenPositionList.add(j, 0);
            }
            for (int l = 0; l <= startPositionCorrection && tokenPositionList.size() > l; ++l) {
                correctedStPos += ((Integer)tokenPositionList.get(l)).intValue();
            }
            int w = startPositionCorrection;
            for (int j = 0; j <= w; ++j) {
                if (j >= this.pTokensMatched.size() || this.pTokensMatched.get(j).booleanValue()) continue;
                --startPositionCorrection;
            }
        }
        if (endPositionCorrection < 0) {
            for (int d = startPositionCorrection; d < this.pTokensMatched.size(); ++d) {
                if (this.pTokensMatched.get(d).booleanValue()) continue;
                ++endPositionCorrection;
            }
        }
        if (lastMatchToken != -1) {
            int maxPosCorrection = Math.max(lastMatchToken + 1 - (firstMatchToken + correctedStPos) - matchingTokens, 0);
            matchingTokensWithCorrection += maxPosCorrection;
        }
        int fromPos = sentence.getOriginalPosition(firstMatchToken + correctedStPos);
        boolean spaceBefore = whTokens[fromPos].isWhitespaceBefore();
        DisambiguationPatternRule.DisambiguatorAction disAction = rule.getAction();
        AnalyzedToken[] newTokenReadings = rule.getNewTokenReadings();
        Match matchElement = rule.getMatchElement();
        String disambiguatedPOS = rule.getDisambiguatedPOS();
        switch (disAction) {
            case UNIFY: {
                if (unifiedTokens == null || unifiedTokens.length != matchingTokensWithCorrection - startPositionCorrection + endPositionCorrection) break;
                if (whTokens[sentence.getOriginalPosition(firstMatchToken + correctedStPos + unifiedTokens.length - 1)].isSentenceEnd()) {
                    unifiedTokens[unifiedTokens.length - 1].setSentEnd();
                }
                for (int i = 0; i < unifiedTokens.length; ++i) {
                    int position = sentence.getOriginalPosition(firstMatchToken + correctedStPos + i);
                    unifiedTokens[i].setStartPos(whTokens[position].getStartPos());
                    String prevValue = whTokens[position].toString();
                    String prevAnot = whTokens[position].getHistoricalAnnotations();
                    List<ChunkTag> chTags = whTokens[position].getChunkTags();
                    whTokens[position] = unifiedTokens[i];
                    whTokens[position].setChunkTags(chTags);
                    this.annotateChange(whTokens[position], prevValue, prevAnot);
                }
                break;
            }
            case REMOVE: {
                if (newTokenReadings != null && newTokenReadings.length > 0) {
                    if (newTokenReadings.length != matchingTokensWithCorrection - startPositionCorrection + endPositionCorrection) break;
                    for (int i = 0; i < newTokenReadings.length; ++i) {
                        int position = sentence.getOriginalPosition(firstMatchToken + correctedStPos + i);
                        String prevValue = whTokens[position].toString();
                        String prevAnot = whTokens[position].getHistoricalAnnotations();
                        whTokens[position].removeReading(newTokenReadings[i]);
                        this.annotateChange(whTokens[position], prevValue, prevAnot);
                    }
                } else {
                    if (StringTools.isEmpty(disambiguatedPOS)) break;
                    Pattern p = Pattern.compile(disambiguatedPOS);
                    AnalyzedTokenReadings tmp = new AnalyzedTokenReadings(whTokens[fromPos].getReadings(), whTokens[fromPos].getStartPos());
                    for (AnalyzedToken analyzedToken : tmp) {
                        if (analyzedToken.getPOSTag() == null || !p.matcher(analyzedToken.getPOSTag()).matches()) continue;
                        int position = sentence.getOriginalPosition(firstMatchToken + correctedStPos);
                        String prevValue = whTokens[position].toString();
                        String prevAnot = whTokens[position].getHistoricalAnnotations();
                        whTokens[position].removeReading(analyzedToken);
                        this.annotateChange(whTokens[position], prevValue, prevAnot);
                    }
                }
                break;
            }
            case ADD: {
                if (newTokenReadings == null || newTokenReadings.length != matchingTokensWithCorrection - startPositionCorrection + endPositionCorrection) break;
                for (int i = 0; i < newTokenReadings.length; ++i) {
                    int position = sentence.getOriginalPosition(firstMatchToken + correctedStPos + i);
                    String token = newTokenReadings[i].getToken().isEmpty() ? whTokens[position].getToken() : newTokenReadings[i].getToken();
                    String lemma = newTokenReadings[i].getLemma() == null ? token : newTokenReadings[i].getLemma();
                    AnalyzedToken newTok = new AnalyzedToken(token, newTokenReadings[i].getPOSTag(), lemma);
                    String prevValue = whTokens[position].toString();
                    String prevAnot = whTokens[position].getHistoricalAnnotations();
                    whTokens[position].addReading(newTok);
                    this.annotateChange(whTokens[position], prevValue, prevAnot);
                }
                break;
            }
            case FILTERALL: {
                for (int i = 0; i < matchingTokensWithCorrection - startPositionCorrection + endPositionCorrection; ++i) {
                    PatternToken pToken;
                    int position = sentence.getOriginalPosition(firstMatchToken + correctedStPos + i);
                    if (this.pTokensMatched.get(i + startPositionCorrection).booleanValue()) {
                        pToken = rule.getPatternTokens().get(i + startPositionCorrection);
                    } else {
                        int k = 1;
                        while (i + startPositionCorrection + k < rule.getPatternTokens().size() + endPositionCorrection && !this.pTokensMatched.get(i + startPositionCorrection + k).booleanValue()) {
                            ++k;
                        }
                        pToken = rule.getPatternTokens().get(i + k + startPositionCorrection);
                    }
                    Match tmpMatchToken = new Match(pToken.getPOStag(), null, true, pToken.getPOStag(), null, Match.CaseConversion.NONE, false, false, Match.IncludeRange.NONE);
                    MatchState matchState = tmpMatchToken.createState(rule.getLanguage().getSynthesizer(), whTokens[position]);
                    String prevValue = whTokens[position].toString();
                    String prevAnot = whTokens[position].getHistoricalAnnotations();
                    whTokens[position] = matchState.filterReadings();
                    this.annotateChange(whTokens[position], prevValue, prevAnot);
                }
                break;
            }
            case IMMUNIZE: {
                for (int i = 0; i < matchingTokensWithCorrection - startPositionCorrection + endPositionCorrection; ++i) {
                    whTokens[sentence.getOriginalPosition(firstMatchToken + correctedStPos + i)].immunize();
                }
                break;
            }
            case IGNORE_SPELLING: {
                for (int i = 0; i < matchingTokensWithCorrection - startPositionCorrection + endPositionCorrection; ++i) {
                    whTokens[sentence.getOriginalPosition(firstMatchToken + correctedStPos + i)].ignoreSpelling();
                }
                break;
            }
            case FILTER: {
                if (matchElement == null) {
                    Match tmpMatchToken = new Match(disambiguatedPOS, null, true, disambiguatedPOS, null, Match.CaseConversion.NONE, false, false, Match.IncludeRange.NONE);
                    boolean newPOSmatches = false;
                    for (int i = 0; i < whTokens[fromPos].getReadingsLength(); ++i) {
                        if (whTokens[fromPos].getAnalyzedToken(i).hasNoTag() || whTokens[fromPos].getAnalyzedToken(i).getPOSTag() == null || !whTokens[fromPos].getAnalyzedToken(i).getPOSTag().matches(disambiguatedPOS)) continue;
                        newPOSmatches = true;
                        break;
                    }
                    if (!newPOSmatches) break;
                    MatchState matchState = tmpMatchToken.createState(rule.getLanguage().getSynthesizer(), whTokens[fromPos]);
                    String prevValue = whTokens[fromPos].toString();
                    String prevAnot = whTokens[fromPos].getHistoricalAnnotations();
                    whTokens[fromPos] = matchState.filterReadings();
                    this.annotateChange(whTokens[fromPos], prevValue, prevAnot);
                    break;
                }
            }
            default: {
                if (newTokenReadings != null && newTokenReadings.length > 0) {
                    if (newTokenReadings.length != matchingTokensWithCorrection - startPositionCorrection + endPositionCorrection) break;
                    for (int i = 0; i < newTokenReadings.length; ++i) {
                        int position = sentence.getOriginalPosition(firstMatchToken + correctedStPos + i);
                        String token = "".equals(newTokenReadings[i].getToken()) ? whTokens[position].getToken() : newTokenReadings[i].getToken();
                        String lemma = newTokenReadings[i].getLemma() == null ? token : newTokenReadings[i].getLemma();
                        AnalyzedToken analyzedToken = new AnalyzedToken(token, newTokenReadings[i].getPOSTag(), lemma);
                        AnalyzedTokenReadings toReplace = new AnalyzedTokenReadings(analyzedToken, whTokens[fromPos].getStartPos());
                        whTokens[position] = this.replaceTokens(whTokens[position], toReplace);
                    }
                    break;
                }
                if (matchElement == null) {
                    String lemma = "";
                    for (AnalyzedToken analyzedToken : whTokens[fromPos]) {
                        if (analyzedToken.getPOSTag() == null || !analyzedToken.getPOSTag().equals(disambiguatedPOS) || analyzedToken.getLemma() == null) continue;
                        lemma = analyzedToken.getLemma();
                    }
                    if (StringTools.isEmpty(lemma)) {
                        lemma = whTokens[fromPos].getAnalyzedToken(0).getLemma();
                    }
                    AnalyzedToken analyzedToken = new AnalyzedToken(whTokens[fromPos].getToken(), disambiguatedPOS, lemma);
                    AnalyzedTokenReadings toReplace = new AnalyzedTokenReadings(analyzedToken, whTokens[fromPos].getStartPos());
                    whTokens[fromPos] = this.replaceTokens(whTokens[fromPos], toReplace);
                    break;
                }
                MatchState matchElementState = matchElement.createState(rule.getLanguage().getSynthesizer(), whTokens[fromPos]);
                String prevValue = whTokens[fromPos].toString();
                String prevAnot = whTokens[fromPos].getHistoricalAnnotations();
                whTokens[fromPos] = matchElementState.filterReadings();
                whTokens[fromPos].setWhitespaceBefore(spaceBefore);
                this.annotateChange(whTokens[fromPos], prevValue, prevAnot);
            }
        }
        return whTokens;
    }

    private void annotateChange(AnalyzedTokenReadings atr, String prevValue, String prevAnot) {
        atr.setHistoricalAnnotations(prevAnot + "\n" + this.rule.getFullId() + ": " + prevValue + " -> " + atr);
    }

    private AnalyzedTokenReadings replaceTokens(AnalyzedTokenReadings oldAtr, AnalyzedTokenReadings newAtr) {
        String prevValue = oldAtr.toString();
        String prevAnot = oldAtr.getHistoricalAnnotations();
        boolean isSentEnd = oldAtr.isSentenceEnd();
        boolean isParaEnd = oldAtr.isParagraphEnd();
        boolean spaceBefore = oldAtr.isWhitespaceBefore();
        int startPosition = oldAtr.getStartPos();
        List<ChunkTag> chunkTags = oldAtr.getChunkTags();
        if (isSentEnd) {
            newAtr.setSentEnd();
        }
        if (isParaEnd) {
            newAtr.setParagraphEnd();
        }
        newAtr.setWhitespaceBefore(spaceBefore);
        newAtr.setStartPos(startPosition);
        newAtr.setChunkTags(chunkTags);
        if (oldAtr.isImmunized()) {
            newAtr.immunize();
        }
        this.annotateChange(newAtr, prevValue, prevAnot);
        return newAtr;
    }
}

