/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.error.Error;
import org.hsqldb.lib.LineReader;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.map.ValuePool;
import org.hsqldb.result.Result;
import org.hsqldb.rowio.RowInputTextLog;
import org.hsqldb.scriptio.ScriptReaderBase;
import org.hsqldb.scriptio.ScriptWriterText;
import org.hsqldb.types.Type;

public class ScriptReaderText
extends ScriptReaderBase {
    LineReader dataStreamIn;
    InputStream inputStream;
    InputStream bufferedStream;
    GZIPInputStream gzipStream;
    RowInputTextLog rowIn;
    boolean isInsert;

    ScriptReaderText(Database database, String string) {
        super(database, string);
    }

    public ScriptReaderText(Database database, String string, boolean bl) throws IOException {
        super(database, string);
        InputStream inputStream;
        this.inputStream = this.database.logger.getFileAccess().openInputStreamElement(string);
        this.bufferedStream = new BufferedInputStream(this.inputStream);
        if (bl) {
            this.gzipStream = new GZIPInputStream(this.bufferedStream);
            inputStream = this.gzipStream;
        } else {
            inputStream = this.bufferedStream;
        }
        this.dataStreamIn = new LineReader(inputStream, "ISO-8859-1");
        this.rowIn = new RowInputTextLog(database.databaseProperties.isVersion18());
    }

    @Override
    protected void readDDL(Session session) {
        while (true) {
            Statement statement = null;
            Result result = null;
            try {
                boolean bl = this.readLoggedStatement(session);
                if (!bl) break;
                if (this.rowIn.getStatementType() == 3) {
                    this.isInsert = true;
                    break;
                }
                statement = session.compileStatement(this.statement);
                result = session.executeCompiledStatement(statement, ValuePool.emptyObjectArray, 0);
            }
            catch (HsqlException hsqlException) {
                result = Result.newErrorResult(hsqlException);
            }
            if (!result.isError() || statement != null && (statement.getType() == 53 || statement.getType() == 69 && result.getMainString().indexOf("org.hsqldb.Library") > -1)) continue;
            this.database.logger.logWarningEvent(result.getMainString(), result.getException());
            HsqlException hsqlException = this.getError(result.getException(), this.lineCount);
            this.handleError(hsqlException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void readExistingData(Session session) {
        String string = null;
        while (true) {
            Object object;
            try {
                while (true) {
                    boolean bl = false;
                    if (this.isInsert) {
                        this.isInsert = false;
                        bl = true;
                    } else {
                        bl = this.readLoggedStatement(session);
                    }
                    if (!bl) return;
                    if (this.statementType == 6) {
                        session.setSchema(this.currentSchema);
                        string = null;
                        continue;
                    }
                    if (this.statementType != 3) break;
                    if (!this.rowIn.getTableName().equals(string)) {
                        string = this.rowIn.getTableName();
                        object = session.getSchemaName(this.currentSchema);
                        this.currentTable = this.database.schemaManager.getUserTable(string, (String)object);
                        this.currentStore = this.database.persistentStoreCollection.getStore(this.currentTable);
                    }
                    this.currentTable.insertFromScript(session, this.currentStore, this.rowData);
                }
                object = Error.error(458, this.statement);
                throw object;
            }
            catch (Throwable throwable) {
                object = this.getError(throwable, this.lineCount);
                this.handleError((HsqlException)object);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean readLoggedStatement(Session session) {
        if (!this.sessionChanged) {
            try {
                this.rawStatement = this.dataStreamIn.readLine();
            }
            catch (EOFException eOFException) {
                return false;
            }
            catch (IOException iOException) {
                throw Error.error(iOException, 452, null);
            }
            ++this.lineCount;
            this.statement = StringConverter.unicodeStringToString(this.rawStatement);
            if (this.statement == null) {
                return false;
            }
        }
        this.processStatement(session);
        return true;
    }

    void processStatement(Session session) {
        if (this.statement.startsWith("/*C")) {
            int n = this.statement.indexOf(42, 4);
            this.sessionNumber = Integer.parseInt(this.statement.substring(3, n));
            this.statement = this.statement.substring(n + 2);
            this.sessionChanged = true;
            this.statementType = 5;
            return;
        }
        this.sessionChanged = false;
        this.rowIn.setSource(session, this.statement);
        this.statementType = this.rowIn.getStatementType();
        if (this.statementType == 1) {
            this.rowData = null;
            this.currentTable = null;
            return;
        }
        if (this.statementType == 4) {
            this.rowData = null;
            this.currentTable = null;
            return;
        }
        if (this.statementType == 6) {
            this.rowData = null;
            this.currentTable = null;
            this.currentSchema = this.rowIn.getSchemaName();
            return;
        }
        String string = this.rowIn.getTableName();
        String string2 = session.getCurrentSchemaHsqlName().name;
        this.currentTable = this.database.schemaManager.getUserTable(string, string2);
        this.currentStore = this.database.persistentStoreCollection.getStore(this.currentTable);
        Type[] typeArray = this.statementType == 3 ? this.currentTable.getColumnTypes() : (this.currentTable.hasPrimaryKey() ? this.currentTable.getPrimaryKeyTypes() : this.currentTable.getColumnTypes());
        this.rowData = this.rowIn.readData(typeArray);
    }

    @Override
    public void close() {
        try {
            if (this.dataStreamIn != null) {
                this.dataStreamIn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.gzipStream != null) {
                this.gzipStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.scrwriter != null) {
                this.scrwriter.close();
            }
            this.database.recoveryMode = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    HsqlException getError(Throwable throwable, long l) {
        HsqlException hsqlException;
        if (throwable instanceof HsqlException && (hsqlException = (HsqlException)throwable).getErrorCode() == -461) {
            return hsqlException;
        }
        return Error.error(throwable, 461, 25, new Object[]{l, throwable.toString()});
    }

    private void handleError(HsqlException hsqlException) {
        this.database.logger.logSevereEvent("bad line in script file " + this.lineCount, hsqlException);
        if (this.database.recoveryMode == 0) {
            throw hsqlException;
        }
        this.openScriptWriter();
        try {
            this.scrwriter.writeLogStatement(null, this.rawStatement);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void openScriptWriter() {
        if (this.scrwriter == null) {
            String string = this.database.logger.fileDateFormat.format(new Date());
            String string2 = this.fileNamePath + "." + string + ".reject";
            this.scrwriter = new ScriptWriterText(this.database, string2, false, false, true);
        }
    }
}

