/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.regex.PatternSyntaxException;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IRelationMember;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.ConditionFactory;
import org.openstreetmap.josm.gui.mappaint.mapcss.Subpart;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public interface Selector {
    public static final String BASE_ANY = "*";
    public static final String BASE_NODE = "node";
    public static final String BASE_WAY = "way";
    public static final String BASE_RELATION = "relation";
    public static final String BASE_AREA = "area";
    public static final String BASE_META = "meta";
    public static final String BASE_CANVAS = "canvas";
    public static final String BASE_SETTING = "setting";
    public static final String BASE_SETTINGS = "settings";

    public boolean matches(Environment var1);

    public Subpart getSubpart();

    public Range getRange();

    public Selector optimizedBaseCheck();

    public static class OptimizedGeneralSelector
    extends AbstractSelector {
        public final String base;
        public final Range range;
        public final Subpart subpart;

        public OptimizedGeneralSelector(String base, Pair<Integer, Integer> zoom, List<Condition> conds, Subpart subpart) {
            super(conds);
            this.base = OptimizedGeneralSelector.checkBase(base);
            if (zoom != null) {
                int b;
                int a = zoom.a == null ? 0 : (Integer)zoom.a;
                int n = b = zoom.b == null ? Integer.MAX_VALUE : (Integer)zoom.b;
                this.range = a <= b ? OptimizedGeneralSelector.fromLevel(a, b) : Range.ZERO_TO_INFINITY;
            } else {
                this.range = Range.ZERO_TO_INFINITY;
            }
            this.subpart = subpart != null ? subpart : Subpart.DEFAULT_SUBPART;
        }

        public OptimizedGeneralSelector(String base, Range range, List<Condition> conds, Subpart subpart) {
            super(conds);
            this.base = OptimizedGeneralSelector.checkBase(base);
            this.range = range;
            this.subpart = subpart != null ? subpart : Subpart.DEFAULT_SUBPART;
        }

        public OptimizedGeneralSelector(GeneralSelector s) {
            this(s.base, s.range, (List<Condition>)s.conds, s.subpart);
        }

        @Override
        public Subpart getSubpart() {
            return this.subpart;
        }

        @Override
        public Range getRange() {
            return this.range;
        }

        private static String checkBase(String base) {
            switch (base) {
                case "*": {
                    return Selector.BASE_ANY;
                }
                case "node": {
                    return Selector.BASE_NODE;
                }
                case "way": {
                    return Selector.BASE_WAY;
                }
                case "relation": {
                    return Selector.BASE_RELATION;
                }
                case "area": {
                    return Selector.BASE_AREA;
                }
                case "meta": {
                    return Selector.BASE_META;
                }
                case "canvas": {
                    return Selector.BASE_CANVAS;
                }
                case "setting": {
                    return Selector.BASE_SETTING;
                }
                case "settings": {
                    return Selector.BASE_SETTINGS;
                }
            }
            throw new IllegalArgumentException(MessageFormat.format("Unknown MapCSS base selector {0}", base));
        }

        public String getBase() {
            return this.base;
        }

        public boolean matchesBase(OsmPrimitiveType type) {
            if (Selector.BASE_ANY.equals(this.base)) {
                return true;
            }
            if (OsmPrimitiveType.NODE == type) {
                return Selector.BASE_NODE.equals(this.base);
            }
            if (OsmPrimitiveType.WAY == type) {
                return Selector.BASE_WAY.equals(this.base) || Selector.BASE_AREA.equals(this.base);
            }
            if (OsmPrimitiveType.RELATION == type) {
                return Selector.BASE_AREA.equals(this.base) || Selector.BASE_RELATION.equals(this.base) || Selector.BASE_CANVAS.equals(this.base);
            }
            return false;
        }

        public boolean matchesBase(IPrimitive p) {
            if (!this.matchesBase(p.getType())) {
                return false;
            }
            if (p instanceof IRelation) {
                if (Selector.BASE_AREA.equals(this.base)) {
                    return ((IRelation)p).isMultipolygon();
                }
                if (Selector.BASE_CANVAS.equals(this.base)) {
                    return p.get("#canvas") != null;
                }
            }
            return true;
        }

        public boolean matchesBase(Environment e) {
            return this.matchesBase(e.osm);
        }

        @Override
        public Selector optimizedBaseCheck() {
            throw new UnsupportedOperationException();
        }

        public static Range fromLevel(int a, int b) {
            if (a > b) {
                throw new AssertionError();
            }
            double lower = 0.0;
            double upper = Double.POSITIVE_INFINITY;
            if (b != Integer.MAX_VALUE) {
                lower = OptimizedGeneralSelector.level2scale(b + 1);
            }
            if (a != 0) {
                upper = OptimizedGeneralSelector.level2scale(a);
            }
            return new Range(lower, upper);
        }

        public static double level2scale(int lvl) {
            if (lvl < 0) {
                throw new IllegalArgumentException("lvl must be >= 0 but is " + lvl);
            }
            return Math.PI * 2 * Ellipsoid.WGS84.a / Math.pow(2.0, lvl) / 2.56;
        }

        public static int scale2level(double scale) {
            if (scale < 0.0) {
                throw new IllegalArgumentException("scale must be >= 0 but is " + scale);
            }
            return (int)Math.floor(Math.log(Math.PI * 2 * Ellipsoid.WGS84.a / 2.56 / scale) / Math.log(2.0));
        }

        public String toString() {
            return this.base + (Range.ZERO_TO_INFINITY.equals(this.range) ? "" : this.range) + (this.conds != null ? Utils.join("", this.conds) : "") + (this.subpart != null && this.subpart != Subpart.DEFAULT_SUBPART ? "::" + this.subpart : "");
        }
    }

    public static class GeneralSelector
    extends OptimizedGeneralSelector {
        public GeneralSelector(String base, Pair<Integer, Integer> zoom, List<Condition> conds, Subpart subpart) {
            super(base, zoom, conds, subpart);
        }

        public boolean matchesConditions(Environment e) {
            return super.matches(e);
        }

        @Override
        public Selector optimizedBaseCheck() {
            return new OptimizedGeneralSelector(this);
        }

        @Override
        public boolean matches(Environment e) {
            return this.matchesBase(e) && super.matches(e);
        }
    }

    public static class LinkSelector
    extends AbstractSelector {
        public LinkSelector(List<Condition> conditions) {
            super(conditions);
        }

        @Override
        public boolean matches(Environment env) {
            Utils.ensure(env.isLinkContext(), "Requires LINK context in environment, got ''{0}''", new Object[]{env.getContext()});
            return super.matches(env);
        }

        @Override
        public Subpart getSubpart() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Range getRange() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Selector optimizedBaseCheck() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "LinkSelector{conditions=" + this.conds + '}';
        }
    }

    public static abstract class AbstractSelector
    implements Selector {
        protected final List<Condition> conds;

        protected AbstractSelector(List<Condition> conditions) {
            this.conds = conditions == null || conditions.isEmpty() ? null : conditions;
        }

        @Override
        public boolean matches(Environment env) {
            CheckParameterUtil.ensureParameterNotNull(env, "env");
            if (this.conds == null) {
                return true;
            }
            for (Condition c : this.conds) {
                try {
                    if (c.applies(env)) continue;
                    return false;
                }
                catch (PatternSyntaxException e) {
                    Logging.log(Logging.LEVEL_ERROR, "PatternSyntaxException while applying condition" + c + ':', e);
                    return false;
                }
            }
            return true;
        }

        public List<Condition> getConditions() {
            if (this.conds == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.conds);
        }
    }

    public static class ChildOrParentSelector
    implements Selector {
        public final Selector left;
        public final LinkSelector link;
        public final Selector right;
        public final ChildOrParentSelectorType type;

        public ChildOrParentSelector(Selector a, LinkSelector link, Selector b, ChildOrParentSelectorType type) {
            CheckParameterUtil.ensureParameterNotNull(a, "a");
            CheckParameterUtil.ensureParameterNotNull(b, "b");
            CheckParameterUtil.ensureParameterNotNull(link, "link");
            CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
            this.left = a;
            this.link = link;
            this.right = b;
            this.type = type;
        }

        private void visitBBox(Environment e, AbstractFinder finder) {
            boolean withNodes = finder instanceof ContainsFinder;
            if (this.left instanceof OptimizedGeneralSelector) {
                if (withNodes && ((OptimizedGeneralSelector)this.left).matchesBase(OsmPrimitiveType.NODE)) {
                    finder.visit(e.osm.getDataSet().searchNodes(e.osm.getBBox()));
                }
                if (((OptimizedGeneralSelector)this.left).matchesBase(OsmPrimitiveType.WAY)) {
                    finder.visit(e.osm.getDataSet().searchWays(e.osm.getBBox()));
                }
                if (((OptimizedGeneralSelector)this.left).matchesBase(OsmPrimitiveType.RELATION)) {
                    finder.visit(e.osm.getDataSet().searchRelations(e.osm.getBBox()));
                }
            } else {
                if (withNodes) {
                    finder.visit(e.osm.getDataSet().searchNodes(e.osm.getBBox()));
                }
                finder.visit(e.osm.getDataSet().searchWays(e.osm.getBBox()));
                finder.visit(e.osm.getDataSet().searchRelations(e.osm.getBBox()));
            }
        }

        private static boolean isArea(IPrimitive p) {
            return p instanceof IWay && ((IWay)p).isClosed() && ((IWay)p).getNodesCount() >= 4 || p instanceof IRelation && p.isMultipolygon() && !p.isIncomplete();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matches(Environment e) {
            block23: {
                block22: {
                    if (!this.right.matches(e)) {
                        return false;
                    }
                    if (ChildOrParentSelectorType.SUBSET_OR_EQUAL == this.type || ChildOrParentSelectorType.NOT_SUBSET_OR_EQUAL == this.type) {
                        if (e.osm.getDataSet() == null || !ChildOrParentSelector.isArea(e.osm)) {
                            return ChildOrParentSelectorType.NOT_SUBSET_OR_EQUAL == this.type;
                        }
                        ContainsFinder containsFinder = new ContainsFinder(e);
                        e.parent = e.osm;
                        this.visitBBox(e, containsFinder);
                        containsFinder.execGeometryTests();
                        return ChildOrParentSelectorType.SUBSET_OR_EQUAL == this.type ? e.children != null : e.children == null;
                    }
                    if (ChildOrParentSelectorType.SUPERSET_OR_EQUAL == this.type || ChildOrParentSelectorType.NOT_SUPERSET_OR_EQUAL == this.type) {
                        if (e.osm.getDataSet() == null || e.osm instanceof INode && ((INode)e.osm).getCoor() == null || !(e.osm instanceof INode) && !ChildOrParentSelector.isArea(e.osm)) {
                            return ChildOrParentSelectorType.NOT_SUPERSET_OR_EQUAL == this.type;
                        }
                        InsideOrEqualFinder insideOrEqualFinder = new InsideOrEqualFinder(e);
                        e.parent = e.osm;
                        this.visitBBox(e, insideOrEqualFinder);
                        return ChildOrParentSelectorType.SUPERSET_OR_EQUAL == this.type ? e.children != null : e.children == null;
                    }
                    if (ChildOrParentSelectorType.CROSSING == this.type && e.osm instanceof IWay) {
                        e.parent = e.osm;
                        if (this.right instanceof OptimizedGeneralSelector && ((OptimizedGeneralSelector)this.right).matchesBase(OsmPrimitiveType.WAY)) {
                            CrossingFinder crossingFinder = new CrossingFinder(e);
                            ((AbstractFinder)crossingFinder).visit(e.osm.getDataSet().searchWays(e.osm.getBBox()));
                        }
                        return e.children != null;
                    }
                    if (ChildOrParentSelectorType.SIBLING != this.type) break block22;
                    if (!(e.osm instanceof INode)) break block23;
                    for (IPrimitive iPrimitive : e.osm.getReferrers(true)) {
                        Object n;
                        Environment e2;
                        IWay w;
                        int i;
                        if (!(iPrimitive instanceof IWay) || (i = (w = (IWay)iPrimitive).getNodes().indexOf(e.osm)) - 1 < 0 || !this.left.matches(e2 = e.withPrimitive((IPrimitive)(n = w.getNode(i - 1))).withParent(w).withChild(e.osm)) || !this.link.matches(e2.withLinkContext())) continue;
                        e.child = n;
                        e.index = i;
                        e.count = w.getNodesCount();
                        e.parent = w;
                        return true;
                    }
                    break block23;
                }
                if (ChildOrParentSelectorType.CHILD == this.type && this.link.conds != null && !this.link.conds.isEmpty() && this.link.conds.get(0) instanceof ConditionFactory.OpenEndPseudoClassCondition) {
                    if (e.osm instanceof INode) {
                        e.osm.visitReferrers(new MultipolygonOpenEndFinder(e));
                        return e.parent != null;
                    }
                } else if (ChildOrParentSelectorType.CHILD == this.type) {
                    MatchingReferrerFinder collector = new MatchingReferrerFinder(e);
                    e.osm.visitReferrers(collector);
                    if (e.parent != null) {
                        return true;
                    }
                } else if (ChildOrParentSelectorType.PARENT == this.type) {
                    if (e.osm instanceof IWay) {
                        void var3_11;
                        List wayNodes = ((IWay)e.osm).getNodes();
                        boolean bl = false;
                        while (var3_11 < wayNodes.size()) {
                            INode n = (INode)wayNodes.get((int)var3_11);
                            if (this.left.matches(e.withPrimitive(n)) && this.link.matches(e.withChildAndIndexAndLinkContext(n, (int)var3_11, wayNodes.size()))) {
                                e.child = n;
                                e.index = (int)var3_11;
                                e.count = wayNodes.size();
                                return true;
                            }
                            ++var3_11;
                        }
                    } else if (e.osm instanceof IRelation) {
                        void var3_13;
                        List members = ((IRelation)e.osm).getMembers();
                        boolean bl = false;
                        while (var3_13 < members.size()) {
                            Object member = ((IRelationMember)members.get((int)var3_13)).getMember();
                            if (this.left.matches(e.withPrimitive((IPrimitive)member)) && this.link.matches(e.withChildAndIndexAndLinkContext((IPrimitive)member, (int)var3_13, members.size()))) {
                                e.child = member;
                                e.index = (int)var3_13;
                                e.count = members.size();
                                return true;
                            }
                            ++var3_13;
                        }
                    }
                }
            }
            return false;
        }

        @Override
        public Subpart getSubpart() {
            return this.right.getSubpart();
        }

        @Override
        public Range getRange() {
            return this.right.getRange();
        }

        @Override
        public Selector optimizedBaseCheck() {
            return new ChildOrParentSelector(this.left, this.link, this.right.optimizedBaseCheck(), this.type);
        }

        public String toString() {
            return this.left.toString() + ' ' + (ChildOrParentSelectorType.PARENT == this.type ? (char)'<' : '>') + this.link + ' ' + this.right;
        }

        private class InsideOrEqualFinder
        extends AbstractFinder {
            protected InsideOrEqualFinder(Environment e) {
                super(e);
            }

            @Override
            public void visit(IWay<?> w) {
                if (ChildOrParentSelector.this.left.matches(new Environment(w).withParent(this.e.osm)) && w.getBBox().bounds(this.e.osm.getBBox()) && !Geometry.filterInsidePolygon(Collections.singletonList(this.e.osm), w).isEmpty()) {
                    this.addToChildren(this.e, w);
                }
            }

            @Override
            public void visit(IRelation<?> r) {
                if (r instanceof Relation && r.isMultipolygon() && r.getBBox().bounds(this.e.osm.getBBox()) && ChildOrParentSelector.this.left.matches(new Environment(r).withParent(this.e.osm)) && !Geometry.filterInsideMultipolygon(Collections.singletonList(this.e.osm), (Relation)r).isEmpty()) {
                    this.addToChildren(this.e, r);
                }
            }
        }

        private class ContainsFinder
        extends AbstractFinder {
            protected List<IPrimitive> toCheck;

            protected ContainsFinder(Environment e) {
                super(e);
                CheckParameterUtil.ensureThat(!(e.osm instanceof INode), "Nodes not supported");
            }

            @Override
            public void visit(Collection<? extends IPrimitive> primitives) {
                for (IPrimitive iPrimitive : primitives) {
                    if (iPrimitive == this.e.osm || !this.isPrimitiveUsable(iPrimitive) || !ChildOrParentSelector.this.left.matches(new Environment(iPrimitive).withParent(this.e.osm))) continue;
                    if (this.toCheck == null) {
                        this.toCheck = new ArrayList<IPrimitive>();
                    }
                    this.toCheck.add(iPrimitive);
                }
            }

            void execGeometryTests() {
                block4: {
                    block3: {
                        if (this.toCheck == null || this.toCheck.isEmpty()) {
                            return;
                        }
                        if (!(this.e.osm instanceof IWay)) break block3;
                        for (IPrimitive p : Geometry.filterInsidePolygon(this.toCheck, (IWay)this.e.osm)) {
                            this.addToChildren(this.e, p);
                        }
                        break block4;
                    }
                    if (!(this.e.osm instanceof Relation) || !this.e.osm.isMultipolygon()) break block4;
                    for (IPrimitive p : Geometry.filterInsideMultipolygon(this.toCheck, (Relation)this.e.osm)) {
                        this.addToChildren(this.e, p);
                    }
                }
            }
        }

        private final class CrossingFinder
        extends AbstractFinder {
            private final String layer;

            private CrossingFinder(Environment e) {
                super(e);
                CheckParameterUtil.ensureThat(e.osm instanceof IWay, "Only ways are supported");
                this.layer = OsmUtils.getLayer(e.osm);
            }

            @Override
            public void visit(IWay<?> w) {
                if (Objects.equals(this.layer, OsmUtils.getLayer(w)) && ChildOrParentSelector.this.left.matches(new Environment(w).withParent(this.e.osm)) && this.e.osm instanceof IWay && Geometry.PolygonIntersection.CROSSING.equals((Object)Geometry.polygonIntersection(w.getNodes(), ((IWay)this.e.osm).getNodes()))) {
                    this.addToChildren(this.e, w);
                }
            }
        }

        private class MultipolygonOpenEndFinder
        extends AbstractFinder {
            private final PrimitiveVisitor innerVisitor;

            @Override
            public void visit(IWay<?> w) {
                w.visitReferrers(this.innerVisitor);
            }

            MultipolygonOpenEndFinder(Environment e) {
                super(e);
                this.innerVisitor = new AbstractFinder(this.e){

                    @Override
                    public void visit(IRelation<?> r) {
                        List<Node> openEnds;
                        int openEndIndex;
                        if (r instanceof Relation && ChildOrParentSelector.this.left.matches(this.e.withPrimitive(r)) && (openEndIndex = (openEnds = MultipolygonCache.getInstance().get((Relation)r).getOpenEnds()).indexOf(this.e.osm)) >= 0) {
                            this.e.parent = r;
                            this.e.index = openEndIndex;
                            this.e.count = openEnds.size();
                        }
                    }
                };
            }
        }

        private static abstract class AbstractFinder
        implements PrimitiveVisitor {
            protected final Environment e;

            protected AbstractFinder(Environment e) {
                this.e = e;
            }

            @Override
            public void visit(INode n) {
            }

            @Override
            public void visit(IWay<?> w) {
            }

            @Override
            public void visit(IRelation<?> r) {
            }

            public void visit(Collection<? extends IPrimitive> primitives) {
                for (IPrimitive iPrimitive : primitives) {
                    if (this.e.child != null) break;
                    if (!this.isPrimitiveUsable(iPrimitive)) continue;
                    iPrimitive.accept(this);
                }
            }

            public boolean isPrimitiveUsable(IPrimitive p) {
                return !this.e.osm.equals(p) && p.isUsable();
            }

            protected void addToChildren(Environment e, IPrimitive p) {
                if (e.children == null) {
                    e.children = new LinkedHashSet<IPrimitive>();
                }
                e.children.add(p);
            }
        }

        private class MatchingReferrerFinder
        implements PrimitiveVisitor {
            private final Environment e;

            MatchingReferrerFinder(Environment e) {
                this.e = e;
            }

            @Override
            public void visit(INode n) {
                throw new AssertionError();
            }

            private <T extends IPrimitive> void doVisit(T parent, IntSupplier counter, IntFunction<IPrimitive> getter) {
                if (this.e.parent != null) {
                    return;
                }
                if (!ChildOrParentSelector.this.left.matches(this.e.withPrimitive(parent))) {
                    return;
                }
                int count = counter.getAsInt();
                if (ChildOrParentSelector.this.link.conds == null) {
                    this.e.parent = parent;
                    this.e.count = count;
                    return;
                }
                for (int i = 0; i < count; ++i) {
                    if (!getter.apply(i).equals(this.e.osm) || !ChildOrParentSelector.this.link.matches(this.e.withParentAndIndexAndLinkContext(parent, i, count))) continue;
                    this.e.parent = parent;
                    this.e.index = i;
                    this.e.count = count;
                    return;
                }
            }

            @Override
            public void visit(IWay<?> w) {
                this.doVisit(w, w::getNodesCount, w::getNode);
            }

            @Override
            public void visit(IRelation<?> r) {
                this.doVisit(r, r::getMembersCount, i -> r.getMember(i).getMember());
            }
        }
    }

    public static enum ChildOrParentSelectorType {
        CHILD,
        PARENT,
        SUBSET_OR_EQUAL,
        NOT_SUBSET_OR_EQUAL,
        SUPERSET_OR_EQUAL,
        NOT_SUPERSET_OR_EQUAL,
        CROSSING,
        SIBLING;

    }
}

