/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.PsiLabelReference;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiContinueStatementImpl
extends CompositePsiElement
implements PsiContinueStatement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiContinueStatementImpl");

    public PsiContinueStatementImpl() {
        super(JavaElementType.CONTINUE_STATEMENT);
    }

    @Override
    public PsiIdentifier getLabelIdentifier() {
        return (PsiIdentifier)this.findPsiChildByType(JavaTokenType.IDENTIFIER);
    }

    @Override
    public PsiStatement findContinuedStatement() {
        PsiIdentifier label = this.getLabelIdentifier();
        if (label == null) {
            return PsiImplUtil.findEnclosingLoop(this);
        }
        PsiLabeledStatement labeled = PsiImplUtil.findEnclosingLabeledStatement(this, label.getText());
        if (labeled != null) {
            return labeled.getStatement();
        }
        return null;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 82: {
                return this.findChildByType(JavaTokenType.CONTINUE_KEYWORD);
            }
            case 83: {
                return this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 22: {
                return TreeUtil.findChildBackward(this, JavaTokenType.SEMICOLON);
            }
        }
        return null;
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiContinueStatementImpl.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.CONTINUE_KEYWORD) {
            return 82;
        }
        if (i == JavaTokenType.IDENTIFIER) {
            return 83;
        }
        if (i == JavaTokenType.SEMICOLON) {
            return 22;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiContinueStatementImpl.$$$reportNull$$$0(1);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitContinueStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public PsiReference getReference() {
        PsiIdentifier label = this.getLabelIdentifier();
        return label != null ? new PsiLabelReference(this, label) : null;
    }

    @Override
    public String toString() {
        return "PsiContinueStatement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiContinueStatementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildRole";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

