/**
 * @class jQuery.plugin.tabIndex
 */
( function () {

	/**
	 * Find the lowest tabindex in use within a selection.
	 *
	 * @return {number} Lowest tabindex on the page
	 */
	$.fn.firstTabIndex = function () {
		var minTabIndex = null;
		$( this ).find( '[tabindex]' ).each( function () {
			var tabIndex = parseInt( $( this ).prop( 'tabindex' ), 10 );
			// In IE6/IE7 the above jQuery selector returns all elements,
			// because it has a default value for tabIndex in IE6/IE7 of 0
			// (rather than null/undefined). Therefore check "> 0" as well.
			// Under IE7 under Windows NT 5.2 is also capable of returning NaN.
			if ( tabIndex > 0 && !isNaN( tabIndex ) ) {
				// Initial value
				if ( minTabIndex === null ) {
					minTabIndex = tabIndex;
				} else if ( tabIndex < minTabIndex ) {
					minTabIndex = tabIndex;
				}
			}
		} );
		return minTabIndex;
	};

	/**
	 * Find the highest tabindex in use within a selection.
	 *
	 * @return {number} Highest tabindex on the page
	 */
	$.fn.lastTabIndex = function () {
		var maxTabIndex = null;
		$( this ).find( '[tabindex]' ).each( function () {
			var tabIndex = parseInt( $( this ).prop( 'tabindex' ), 10 );
			if ( tabIndex > 0 && !isNaN( tabIndex ) ) {
				// Initial value
				if ( maxTabIndex === null ) {
					maxTabIndex = tabIndex;
				} else if ( tabIndex > maxTabIndex ) {
					maxTabIndex = tabIndex;
				}
			}
		} );
		return maxTabIndex;
	};

	/**
	 * @class jQuery
	 * @mixins jQuery.plugin.tabIndex
	 */

}() );
