/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.views;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.ValueHolder;
import net.osmand.data.Amenity;
import net.osmand.data.LatLon;
import net.osmand.data.PointDescription;
import net.osmand.data.QuadRect;
import net.osmand.data.QuadTree;
import net.osmand.data.RotatedTileBox;
import net.osmand.plus.OsmAndFormatter;
import net.osmand.plus.OsmandSettings;
import net.osmand.plus.poi.PoiFiltersHelper;
import net.osmand.plus.poi.PoiUIFilter;
import net.osmand.plus.resources.ResourceManager;
import net.osmand.plus.routing.RoutingHelper;
import net.osmand.plus.views.MapTextLayer;
import net.osmand.plus.views.OsmandMapLayer;
import net.osmand.util.Algorithms;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.ui.IContextMenuProvider;
import net.sourceforge.offroad.ui.OsmBitmapPanel;
import org.apache.commons.logging.Log;

public class POIMapLayer
extends OsmandMapLayer
implements IContextMenuProvider,
MapTextLayer.MapTextProvider<Amenity>,
RoutingHelper.IRouteInformationListener {
    private static final int startZoom = 9;
    public static final Log log = PlatformUtil.getLog(POIMapLayer.class);
    private BufferedImage poiBackground;
    private BufferedImage poiBackgroundSmall;
    private OsmBitmapPanel view;
    private static final int MAXIMUM_SHOW_AMENITIES = 5;
    private ResourceManager resourceManager;
    private RoutingHelper routingHelper;
    private PoiUIFilter filter;
    private MapTextLayer mapTextLayer;
    private OsmandMapLayer.MapLayerData<List<Amenity>> data;
    private OsmandSettings settings;
    private OsmWindow app;

    public POIMapLayer(final OsmWindow activity) {
        this.routingHelper = activity.getRoutingHelper();
        this.routingHelper.addListener(this);
        this.settings = activity.getSettings();
        this.app = activity;
        this.data = new OsmandMapLayer.MapLayerData<List<Amenity>>(){
            {
                this.ZOOM_THRESHOLD = 0;
            }

            @Override
            public boolean isInterrupted() {
                return super.isInterrupted();
            }

            @Override
            public void layerOnPostExecute() {
                activity.getDrawPanel().refreshMap();
            }

            @Override
            protected List<Amenity> calculateResult(RotatedTileBox tileBox) {
                QuadRect latLonBounds = tileBox.getLatLonBounds();
                if (POIMapLayer.this.filter == null || latLonBounds == null) {
                    return new ArrayList<Amenity>();
                }
                int z = (int)Math.floor((double)tileBox.getZoom() + Math.log(((POIMapLayer)POIMapLayer.this).app.getSettings().MAP_DENSITY.get().floatValue()) / Math.log(2.0));
                List<Amenity> res = POIMapLayer.this.filter.searchAmenities(latLonBounds.top, latLonBounds.left, latLonBounds.bottom, latLonBounds.right, z, new ResultMatcher<Amenity>(){

                    @Override
                    public boolean publish(Amenity object) {
                        return true;
                    }

                    @Override
                    public boolean isCancelled() {
                        return this.isInterrupted();
                    }
                });
                Collections.sort(res, new Comparator<Amenity>(){

                    @Override
                    public int compare(Amenity lhs, Amenity rhs) {
                        return lhs.getId() < rhs.getId() ? -1 : (lhs.getId().longValue() == rhs.getId().longValue() ? 0 : 1);
                    }
                });
                return res;
            }
        };
    }

    public void getAmenityFromPoint(RotatedTileBox tb, Point2D pPoint, List<? super Amenity> am) {
        List<Amenity> objects = this.data.getResults();
        if (objects != null) {
            int rp;
            int ex = (int)pPoint.getX();
            int ey = (int)pPoint.getY();
            int compare = rp = this.getRadiusPoi(tb);
            int radius = rp * 3 / 2;
            try {
                for (int i = 0; i < objects.size(); ++i) {
                    Amenity n = objects.get(i);
                    int x = (int)tb.getPixXFromLatLon(n.getLocation().getLatitude(), n.getLocation().getLongitude());
                    int y = (int)tb.getPixYFromLatLon(n.getLocation().getLatitude(), n.getLocation().getLongitude());
                    if (Math.abs(x - ex) > compare || Math.abs(y - ey) > compare) continue;
                    compare = radius;
                    am.add(n);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private StringBuilder buildPoiInformation(StringBuilder res, Amenity n) {
        String format = OsmAndFormatter.getPoiStringWithoutType(n, this.view.getSettings().MAP_PREFERRED_LOCALE.get());
        res.append(" " + format + "\n" + OsmAndFormatter.getAmenityDescriptionContent(this.view.getApplication(), n, true));
        return res;
    }

    @Override
    public void initLayer(OsmBitmapPanel view) {
        this.view = view;
        this.poiBackground = this.readImage("map_white_orange_poi_shield", view);
        this.poiBackgroundSmall = this.readImage("map_white_orange_poi_shield_small", view);
        this.resourceManager = view.getApplication().getResourceManager();
        this.mapTextLayer = view.getLayerByClass(MapTextLayer.class);
    }

    public int getRadiusPoi(RotatedTileBox tb) {
        int r = 0;
        double zoom = tb.getZoom();
        r = zoom < 9.0 ? 0 : (zoom <= 15.0 ? 10 : (zoom <= 16.0 ? 14 : (zoom <= 17.0 ? 16 : 18)));
        return (int)((float)r * this.view.getScaleCoefficient());
    }

    @Override
    public void onPrepareBufferImage(Graphics2D canvas, RotatedTileBox tileBox, OsmandMapLayer.DrawSettings settings) {
        Graphics2D g2 = this.view.createGraphics(canvas);
        g2.setColor(Color.blue);
        g2.setStroke(new BasicStroke(1.0f));
        if (!Algorithms.objectEquals(this.settings.SELECTED_POI_FILTER_FOR_MAP.get(), this.filter == null ? null : this.filter.getFilterId())) {
            if (this.settings.SELECTED_POI_FILTER_FOR_MAP.get() == null) {
                this.filter = null;
            } else {
                PoiFiltersHelper pfh = this.app.getPoiFilters();
                this.filter = pfh.getFilterById(this.settings.SELECTED_POI_FILTER_FOR_MAP.get());
            }
            this.data.clearCache();
        }
        List<Object> objects = Collections.emptyList();
        ArrayList<Amenity> fullObjects = new ArrayList<Amenity>();
        ArrayList<LatLon> fullObjectsLatLon = new ArrayList<LatLon>();
        ArrayList<LatLon> smallObjectsLatLon = new ArrayList<LatLon>();
        if (this.filter != null && tileBox.getZoom() >= 9) {
            this.data.queryNewData(tileBox);
            objects = this.data.getResults();
            if (objects != null) {
                float iconSize = this.poiBackground.getWidth() * 3 / 2;
                QuadTree<QuadRect> boundIntersections = this.initBoundIntersections(tileBox);
                for (Amenity amenity : objects) {
                    float y;
                    float x = tileBox.getPixXFromLatLon(amenity.getLocation().getLatitude(), amenity.getLocation().getLongitude());
                    if (this.intersects(boundIntersections, x, y = tileBox.getPixYFromLatLon(amenity.getLocation().getLatitude(), amenity.getLocation().getLongitude()), iconSize, iconSize)) {
                        g2.drawImage((Image)this.poiBackgroundSmall, (int)(x - (float)(this.poiBackgroundSmall.getWidth() / 2)), (int)(y - (float)(this.poiBackgroundSmall.getHeight() / 2)), null);
                        smallObjectsLatLon.add(new LatLon(amenity.getLocation().getLatitude(), amenity.getLocation().getLongitude()));
                        continue;
                    }
                    fullObjects.add(amenity);
                    fullObjectsLatLon.add(new LatLon(amenity.getLocation().getLatitude(), amenity.getLocation().getLongitude()));
                }
                for (Amenity amenity : fullObjects) {
                    int x = (int)tileBox.getPixXFromLatLon(amenity.getLocation().getLatitude(), amenity.getLocation().getLongitude());
                    int y = (int)tileBox.getPixYFromLatLon(amenity.getLocation().getLatitude(), amenity.getLocation().getLongitude());
                    g2.drawImage((Image)this.poiBackground, x - this.poiBackground.getWidth() / 2, y - this.poiBackground.getHeight() / 2, null);
                    BufferedImage bmp = this.app.getBitmap(amenity);
                    if (bmp == null) continue;
                    g2.drawImage((Image)bmp, x - bmp.getWidth() / 2, y - bmp.getHeight() / 2, null);
                }
                this.fullObjectsLatLon = fullObjectsLatLon;
                this.smallObjectsLatLon = smallObjectsLatLon;
            }
        }
        this.mapTextLayer.putData(this, objects);
        g2.dispose();
    }

    @Override
    public void onDraw(Graphics2D canvas, RotatedTileBox tileBox, OsmandMapLayer.DrawSettings settings) {
    }

    @Override
    public void destroyLayer() {
        this.routingHelper.removeListener(this);
    }

    @Override
    public boolean drawInScreenPixels() {
        return true;
    }

    public static void showWikipediaDialog(OsmWindow ctx, OsmWindow app, Amenity a) {
        String lang = app.getSettings().MAP_PREFERRED_LOCALE.get();
        if (a.getType().isWiki()) {
            String preferredLang = lang;
            if (Algorithms.isEmpty(preferredLang)) {
                preferredLang = app.getLanguage();
            }
            POIMapLayer.showWiki(ctx, app, a, preferredLang);
        }
    }

    public static void showDescriptionDialog(OsmWindow ctx, OsmWindow app, String text, String title) {
        POIMapLayer.showText(ctx, app, text, title);
    }

    private static void showWiki(OsmWindow ctx, OsmWindow app, Amenity a, String lang) {
        String title = a.getName(lang);
        String lng = a.getContentSelected("content", lang, "en");
        if (Algorithms.isEmpty(lng)) {
            lng = "en";
        }
        String langSelected = lng;
        String content = a.getDescription(langSelected);
        String article = "https://" + langSelected.toLowerCase() + ".wikipedia.org/wiki/" + title.replace(' ', '_');
        app.showWikipedia(content, title, article);
    }

    private static void showText(OsmWindow ctx, OsmWindow app, String text, String title) {
        app.showWikipedia(text, title, "");
    }

    @Override
    public String getObjectDescription(Object o) {
        if (o instanceof Amenity) {
            return this.buildPoiInformation(new StringBuilder(), (Amenity)o).toString();
        }
        return null;
    }

    @Override
    public PointDescription getObjectName(Object o) {
        if (o instanceof Amenity) {
            return new PointDescription("poi", ((Amenity)o).getName(this.view.getSettings().MAP_PREFERRED_LOCALE.get()));
        }
        return null;
    }

    @Override
    public boolean disableSingleTap() {
        return false;
    }

    @Override
    public boolean disableLongPressOnMap() {
        return false;
    }

    @Override
    public void collectObjectsFromPoint(Point2D point, RotatedTileBox tileBox, List<Object> objects) {
        this.getAmenityFromPoint(tileBox, point, objects);
    }

    @Override
    public LatLon getObjectLocation(Object o) {
        if (o instanceof Amenity) {
            return ((Amenity)o).getLocation();
        }
        return null;
    }

    @Override
    public boolean isObjectClickable(Object o) {
        return o instanceof Amenity;
    }

    @Override
    public LatLon getTextLocation(Amenity o) {
        return o.getLocation();
    }

    @Override
    public int getTextShift(Amenity o, RotatedTileBox rb) {
        return this.getRadiusPoi(rb);
    }

    @Override
    public String getText(Amenity o) {
        return o.getName(this.view.getSettings().MAP_PREFERRED_LOCALE.get());
    }

    @Override
    public void newRouteIsCalculated(boolean newRoute, ValueHolder<Boolean> showToast) {
    }

    @Override
    public void routeWasCancelled() {
    }

    @Override
    public void routeWasFinished() {
    }

    public static int dpToPx(OsmWindow ctx, float dp) {
        return -1;
    }
}

