/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.util;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLLiteral;

public class LiteralLexicalValueReplacer {
    private static final Pattern WHOLE_STRING_PATTERN = Pattern.compile("^.*$");
    @Nonnull
    private final OWLDataFactory dataFactory;

    public LiteralLexicalValueReplacer(@Nonnull OWLDataFactory dataFactory) {
        this.dataFactory = dataFactory;
    }

    @Nonnull
    public OWLLiteral replaceLexicalValue(@Nonnull OWLLiteral literal, @Nonnull Pattern pattern, @Nonnull String replacement) {
        Preconditions.checkNotNull((Object)literal);
        Preconditions.checkNotNull((Object)replacement);
        String currentLexicalValue = literal.getLiteral();
        String replacementLexicalValue = pattern.matcher(currentLexicalValue).replaceAll(replacement);
        if (literal.hasLang()) {
            return this.dataFactory.getOWLLiteral(replacementLexicalValue, literal.getLang());
        }
        return this.dataFactory.getOWLLiteral(replacementLexicalValue, literal.getDatatype());
    }

    @Nonnull
    public OWLLiteral replaceLexicalValue(@Nonnull OWLLiteral literal, @Nonnull String replacement) {
        return this.replaceLexicalValue(literal, WHOLE_STRING_PATTERN, replacement);
    }
}

