# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.13
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.


"""
Xapian is a highly adaptable toolkit which allows developers to easily
add advanced indexing and search facilities to their own applications.
It has built-in support for several families of weighting models
and also supports a rich set of boolean query operators.

In addition to the doc strings provided by this python library, you
may wish to look at the library's overall documentation, either
installed along with the bindings or online at
<https://xapian.org/docs/bindings/python/>, as well as the library's
documentation, possibly installed with the library or with its
development files, or again online at <https://xapian.org/docs/>.
"""



from . import _xapian

def _swig_setattr(self, class_type, name, value):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    object.__setattr__(self, name, value)




def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    strthis = ""
    if hasattr(self.this, '__repr__'):
        strthis = "proxy of " + self.this.__repr__()

    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)



from weakref import proxy as weakref_proxy



__version__ = '1.4.13'

class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _xapian.delete_SwigPyIterator
    def __iter__(self):
        return self
SwigPyIterator.value = _xapian.SWIG_PyInstanceMethod_New(_xapian.SwigPyIterator_value)
SwigPyIterator.incr = _xapian.SWIG_PyInstanceMethod_New(_xapian.SwigPyIterator_incr)
SwigPyIterator.decr = _xapian.SWIG_PyInstanceMethod_New(_xapian.SwigPyIterator_decr)
SwigPyIterator.distance = _xapian.SWIG_PyInstanceMethod_New(_xapian.SwigPyIterator_distance)
SwigPyIterator.equal = _xapian.SWIG_PyInstanceMethod_New(_xapian.SwigPyIterator_equal)
SwigPyIterator.copy = _xapian.SWIG_PyInstanceMethod_New(_xapian.SwigPyIterator_copy)
SwigPyIterator.next = _xapian.SWIG_PyInstanceMethod_New(_xapian.SwigPyIterator_next)
SwigPyIterator.__next__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.SwigPyIterator___next__)
SwigPyIterator.previous = _xapian.SWIG_PyInstanceMethod_New(_xapian.SwigPyIterator_previous)
SwigPyIterator.advance = _xapian.SWIG_PyInstanceMethod_New(_xapian.SwigPyIterator_advance)
SwigPyIterator.__eq__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.SwigPyIterator___eq__)
SwigPyIterator.__ne__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.SwigPyIterator___ne__)
SwigPyIterator.__iadd__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.SwigPyIterator___iadd__)
SwigPyIterator.__isub__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.SwigPyIterator___isub__)
SwigPyIterator.__add__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.SwigPyIterator___add__)
SwigPyIterator.__sub__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.SwigPyIterator___sub__)
SwigPyIterator_swigregister = _xapian.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

class Error(Exception):
    """


    All exceptions thrown by Xapian are subclasses of Xapian::Error.

    This class can not be instantiated directly - instead a subclass
    should be used. 
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Error, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Error, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def get_type(self):
        """


        The type of this error (e.g. "DocNotFoundError".)

        const char* Xapian::Error::get_type() const 
        """
        return _xapian.Error_get_type(self)


    def get_msg(self):
        """


        Message giving details of the error, intended for human consumption.

        const std::string& Xapian::Error::get_msg() const 
        """
        return _xapian.Error_get_msg(self)


    def get_context(self):
        """


        Optional context information.

        const std::string& Xapian::Error::get_context() const

        This context is intended for use by Xapian::ErrorHandler (for example
        so it can know which remote server is unreliable and report the
        problem and remove that server from those being searched). But it's
        typically a plain-text string, and so also fit for human consumption.

        """
        return _xapian.Error_get_context(self)


    def get_error_string(self):
        """


        Returns any system error string associated with this exception.

        const char* Xapian::Error::get_error_string() const

        The system error string may come from errno, h_errno (on UNIX), or
        GetLastError() (on MS Windows). If there is no associated system error
        string, NULL is returned. 
        """
        return _xapian.Error_get_error_string(self)

    __swig_destroy__ = _xapian.delete_Error
Error.get_type = _xapian.SWIG_PyInstanceMethod_New(_xapian.Error_get_type)
Error.get_msg = _xapian.SWIG_PyInstanceMethod_New(_xapian.Error_get_msg)
Error.get_context = _xapian.SWIG_PyInstanceMethod_New(_xapian.Error_get_context)
Error.get_error_string = _xapian.SWIG_PyInstanceMethod_New(_xapian.Error_get_error_string)
Error.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.Error___str__)
Error_swigregister = _xapian.Error_swigregister
Error_swigregister(Error)

class LogicError(Error):
    """


    The base class for exceptions indicating errors in the program logic.

    A subclass of LogicError will be thrown if Xapian detects a violation
    of a class invariant or a logical precondition or postcondition, etc.

    """

    __swig_setmethods__ = {}
    for _s in [Error]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LogicError, name, value)
    __swig_getmethods__ = {}
    for _s in [Error]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LogicError, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _xapian.delete_LogicError
LogicError_swigregister = _xapian.LogicError_swigregister
LogicError_swigregister(LogicError)

class RuntimeError(Error):
    """


    The base class for exceptions indicating errors only detectable at
    runtime.

    A subclass of RuntimeError will be thrown if Xapian detects an error
    which is exception derived from RuntimeError is thrown when an error
    is caused by problems with the data or environment rather than a
    programming mistake. 
    """

    __swig_setmethods__ = {}
    for _s in [Error]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RuntimeError, name, value)
    __swig_getmethods__ = {}
    for _s in [Error]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RuntimeError, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _xapian.delete_RuntimeError
RuntimeError_swigregister = _xapian.RuntimeError_swigregister
RuntimeError_swigregister(RuntimeError)

class AssertionError(LogicError):
    """


    AssertionError is thrown if a logical assertion inside Xapian fails.

    In a debug build of Xapian, a failed assertion in the core library
    code will cause AssertionError to be thrown.

    This represents a bug in Xapian (either an invariant, precondition,
    etc has been violated, or the assertion is incorrect!) 
    """

    __swig_setmethods__ = {}
    for _s in [LogicError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AssertionError, name, value)
    __swig_getmethods__ = {}
    for _s in [LogicError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, AssertionError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::AssertionError::AssertionError(const std::string &msg_, int
        errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.AssertionError_swiginit(self, _xapian.new_AssertionError(*args))
    __swig_destroy__ = _xapian.delete_AssertionError
AssertionError_swigregister = _xapian.AssertionError_swigregister
AssertionError_swigregister(AssertionError)

class InvalidArgumentError(LogicError):
    """


    InvalidArgumentError indicates an invalid parameter value was passed
    to the API. 
    """

    __swig_setmethods__ = {}
    for _s in [LogicError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InvalidArgumentError, name, value)
    __swig_getmethods__ = {}
    for _s in [LogicError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InvalidArgumentError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::InvalidArgumentError::InvalidArgumentError(const std::string
        &msg_, int errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.InvalidArgumentError_swiginit(self, _xapian.new_InvalidArgumentError(*args))
    __swig_destroy__ = _xapian.delete_InvalidArgumentError
InvalidArgumentError_swigregister = _xapian.InvalidArgumentError_swigregister
InvalidArgumentError_swigregister(InvalidArgumentError)

class InvalidOperationError(LogicError):
    """


    InvalidOperationError indicates the API was used in an invalid way. 
    """

    __swig_setmethods__ = {}
    for _s in [LogicError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InvalidOperationError, name, value)
    __swig_getmethods__ = {}
    for _s in [LogicError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InvalidOperationError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::InvalidOperationError::InvalidOperationError(const std::string
        &msg_, int errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.InvalidOperationError_swiginit(self, _xapian.new_InvalidOperationError(*args))
    __swig_destroy__ = _xapian.delete_InvalidOperationError
InvalidOperationError_swigregister = _xapian.InvalidOperationError_swigregister
InvalidOperationError_swigregister(InvalidOperationError)

class UnimplementedError(LogicError):
    """


    UnimplementedError indicates an attempt to use an unimplemented
    feature. 
    """

    __swig_setmethods__ = {}
    for _s in [LogicError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UnimplementedError, name, value)
    __swig_getmethods__ = {}
    for _s in [LogicError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UnimplementedError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::UnimplementedError::UnimplementedError(const std::string
        &msg_, int errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.UnimplementedError_swiginit(self, _xapian.new_UnimplementedError(*args))
    __swig_destroy__ = _xapian.delete_UnimplementedError
UnimplementedError_swigregister = _xapian.UnimplementedError_swigregister
UnimplementedError_swigregister(UnimplementedError)

class DatabaseError(RuntimeError):
    """


    DatabaseError indicates some sort of database related error. 
    """

    __swig_setmethods__ = {}
    for _s in [RuntimeError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DatabaseError, name, value)
    __swig_getmethods__ = {}
    for _s in [RuntimeError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DatabaseError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::DatabaseError::DatabaseError(const std::string &msg_, int
        errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.DatabaseError_swiginit(self, _xapian.new_DatabaseError(*args))
    __swig_destroy__ = _xapian.delete_DatabaseError
DatabaseError_swigregister = _xapian.DatabaseError_swigregister
DatabaseError_swigregister(DatabaseError)

class DatabaseCorruptError(DatabaseError):
    """


    DatabaseCorruptError indicates database corruption was detected. 
    """

    __swig_setmethods__ = {}
    for _s in [DatabaseError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DatabaseCorruptError, name, value)
    __swig_getmethods__ = {}
    for _s in [DatabaseError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DatabaseCorruptError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::DatabaseCorruptError::DatabaseCorruptError(const std::string
        &msg_, int errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.DatabaseCorruptError_swiginit(self, _xapian.new_DatabaseCorruptError(*args))
    __swig_destroy__ = _xapian.delete_DatabaseCorruptError
DatabaseCorruptError_swigregister = _xapian.DatabaseCorruptError_swigregister
DatabaseCorruptError_swigregister(DatabaseCorruptError)

class DatabaseCreateError(DatabaseError):
    """


    DatabaseCreateError indicates a failure to create a database. 
    """

    __swig_setmethods__ = {}
    for _s in [DatabaseError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DatabaseCreateError, name, value)
    __swig_getmethods__ = {}
    for _s in [DatabaseError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DatabaseCreateError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::DatabaseCreateError::DatabaseCreateError(const std::string
        &msg_, int errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.DatabaseCreateError_swiginit(self, _xapian.new_DatabaseCreateError(*args))
    __swig_destroy__ = _xapian.delete_DatabaseCreateError
DatabaseCreateError_swigregister = _xapian.DatabaseCreateError_swigregister
DatabaseCreateError_swigregister(DatabaseCreateError)

class DatabaseLockError(DatabaseError):
    """


    DatabaseLockError indicates failure to lock a database. 
    """

    __swig_setmethods__ = {}
    for _s in [DatabaseError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DatabaseLockError, name, value)
    __swig_getmethods__ = {}
    for _s in [DatabaseError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DatabaseLockError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::DatabaseLockError::DatabaseLockError(const std::string &msg_,
        int errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.DatabaseLockError_swiginit(self, _xapian.new_DatabaseLockError(*args))
    __swig_destroy__ = _xapian.delete_DatabaseLockError
DatabaseLockError_swigregister = _xapian.DatabaseLockError_swigregister
DatabaseLockError_swigregister(DatabaseLockError)

class DatabaseModifiedError(DatabaseError):
    """


    DatabaseModifiedError indicates a database was modified.

    To recover after catching this error, you need to call
    Xapian::Database::reopen() on the Database and repeat the operation
    which failed. 
    """

    __swig_setmethods__ = {}
    for _s in [DatabaseError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DatabaseModifiedError, name, value)
    __swig_getmethods__ = {}
    for _s in [DatabaseError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DatabaseModifiedError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::DatabaseModifiedError::DatabaseModifiedError(const std::string
        &msg_, int errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.DatabaseModifiedError_swiginit(self, _xapian.new_DatabaseModifiedError(*args))
    __swig_destroy__ = _xapian.delete_DatabaseModifiedError
DatabaseModifiedError_swigregister = _xapian.DatabaseModifiedError_swigregister
DatabaseModifiedError_swigregister(DatabaseModifiedError)

class DatabaseOpeningError(DatabaseError):
    """


    DatabaseOpeningError indicates failure to open a database. 
    """

    __swig_setmethods__ = {}
    for _s in [DatabaseError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DatabaseOpeningError, name, value)
    __swig_getmethods__ = {}
    for _s in [DatabaseError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DatabaseOpeningError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::DatabaseOpeningError::DatabaseOpeningError(const std::string
        &msg_, int errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.DatabaseOpeningError_swiginit(self, _xapian.new_DatabaseOpeningError(*args))
    __swig_destroy__ = _xapian.delete_DatabaseOpeningError
DatabaseOpeningError_swigregister = _xapian.DatabaseOpeningError_swigregister
DatabaseOpeningError_swigregister(DatabaseOpeningError)

class DatabaseVersionError(DatabaseOpeningError):
    """


    DatabaseVersionError indicates that a database is in an unsupported
    format.

    From time to time, new versions of Xapian will require the database
    format to be changed, to allow new information to be stored or new
    optimisations to be performed. Backwards compatibility will sometimes
    be maintained, so that new versions of Xapian can open old databases,
    but in some cases Xapian will be unable to open a database because it
    is in too old (or new) a format. This can be resolved either be
    upgrading or downgrading the version of Xapian in use, or by
    rebuilding the database from scratch with the current version of
    Xapian. 
    """

    __swig_setmethods__ = {}
    for _s in [DatabaseOpeningError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DatabaseVersionError, name, value)
    __swig_getmethods__ = {}
    for _s in [DatabaseOpeningError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DatabaseVersionError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::DatabaseVersionError::DatabaseVersionError(const std::string
        &msg_, int errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.DatabaseVersionError_swiginit(self, _xapian.new_DatabaseVersionError(*args))
    __swig_destroy__ = _xapian.delete_DatabaseVersionError
DatabaseVersionError_swigregister = _xapian.DatabaseVersionError_swigregister
DatabaseVersionError_swigregister(DatabaseVersionError)

class DocNotFoundError(RuntimeError):
    """


    Indicates an attempt to access a document not present in the database.

    """

    __swig_setmethods__ = {}
    for _s in [RuntimeError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DocNotFoundError, name, value)
    __swig_getmethods__ = {}
    for _s in [RuntimeError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DocNotFoundError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::DocNotFoundError::DocNotFoundError(const std::string &msg_,
        int errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.DocNotFoundError_swiginit(self, _xapian.new_DocNotFoundError(*args))
    __swig_destroy__ = _xapian.delete_DocNotFoundError
DocNotFoundError_swigregister = _xapian.DocNotFoundError_swigregister
DocNotFoundError_swigregister(DocNotFoundError)

class FeatureUnavailableError(RuntimeError):
    """


    Indicates an attempt to use a feature which is unavailable.

    Typically a feature is unavailable because it wasn't compiled in, or
    because it requires other software or facilities which aren't
    available. 
    """

    __swig_setmethods__ = {}
    for _s in [RuntimeError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FeatureUnavailableError, name, value)
    __swig_getmethods__ = {}
    for _s in [RuntimeError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FeatureUnavailableError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::FeatureUnavailableError::FeatureUnavailableError(const
        std::string &msg_, int errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.FeatureUnavailableError_swiginit(self, _xapian.new_FeatureUnavailableError(*args))
    __swig_destroy__ = _xapian.delete_FeatureUnavailableError
FeatureUnavailableError_swigregister = _xapian.FeatureUnavailableError_swigregister
FeatureUnavailableError_swigregister(FeatureUnavailableError)

class InternalError(RuntimeError):
    """


    InternalError indicates a runtime problem of some sort. 
    """

    __swig_setmethods__ = {}
    for _s in [RuntimeError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InternalError, name, value)
    __swig_getmethods__ = {}
    for _s in [RuntimeError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InternalError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::InternalError::InternalError(const std::string &msg_, int
        errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.InternalError_swiginit(self, _xapian.new_InternalError(*args))
    __swig_destroy__ = _xapian.delete_InternalError
InternalError_swigregister = _xapian.InternalError_swigregister
InternalError_swigregister(InternalError)

class NetworkError(RuntimeError):
    """


    Indicates a problem communicating with a remote database. 
    """

    __swig_setmethods__ = {}
    for _s in [RuntimeError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NetworkError, name, value)
    __swig_getmethods__ = {}
    for _s in [RuntimeError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NetworkError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::NetworkError::NetworkError(const std::string &msg_, int
        errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.NetworkError_swiginit(self, _xapian.new_NetworkError(*args))
    __swig_destroy__ = _xapian.delete_NetworkError
NetworkError_swigregister = _xapian.NetworkError_swigregister
NetworkError_swigregister(NetworkError)

class NetworkTimeoutError(NetworkError):
    """


    Indicates a timeout expired while communicating with a remote
    database. 
    """

    __swig_setmethods__ = {}
    for _s in [NetworkError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NetworkTimeoutError, name, value)
    __swig_getmethods__ = {}
    for _s in [NetworkError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NetworkTimeoutError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::NetworkTimeoutError::NetworkTimeoutError(const std::string
        &msg_, int errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.NetworkTimeoutError_swiginit(self, _xapian.new_NetworkTimeoutError(*args))
    __swig_destroy__ = _xapian.delete_NetworkTimeoutError
NetworkTimeoutError_swigregister = _xapian.NetworkTimeoutError_swigregister
NetworkTimeoutError_swigregister(NetworkTimeoutError)

class QueryParserError(RuntimeError):
    """


    Indicates a query string can't be parsed. 
    """

    __swig_setmethods__ = {}
    for _s in [RuntimeError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, QueryParserError, name, value)
    __swig_getmethods__ = {}
    for _s in [RuntimeError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, QueryParserError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::QueryParserError::QueryParserError(const std::string &msg_,
        int errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.QueryParserError_swiginit(self, _xapian.new_QueryParserError(*args))
    __swig_destroy__ = _xapian.delete_QueryParserError
QueryParserError_swigregister = _xapian.QueryParserError_swigregister
QueryParserError_swigregister(QueryParserError)

class SerialisationError(RuntimeError):
    """


    Indicates an error in the std::string serialisation of an object. 
    """

    __swig_setmethods__ = {}
    for _s in [RuntimeError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerialisationError, name, value)
    __swig_getmethods__ = {}
    for _s in [RuntimeError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerialisationError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::SerialisationError::SerialisationError(const std::string
        &msg_, int errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.SerialisationError_swiginit(self, _xapian.new_SerialisationError(*args))
    __swig_destroy__ = _xapian.delete_SerialisationError
SerialisationError_swigregister = _xapian.SerialisationError_swigregister
SerialisationError_swigregister(SerialisationError)

class RangeError(RuntimeError):
    """


    RangeError indicates an attempt to access outside the bounds of a
    container. 
    """

    __swig_setmethods__ = {}
    for _s in [RuntimeError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RangeError, name, value)
    __swig_getmethods__ = {}
    for _s in [RuntimeError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RangeError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::RangeError::RangeError(const std::string &msg_, int errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.RangeError_swiginit(self, _xapian.new_RangeError(*args))
    __swig_destroy__ = _xapian.delete_RangeError
RangeError_swigregister = _xapian.RangeError_swigregister
RangeError_swigregister(RangeError)

class WildcardError(RuntimeError):
    """


    WildcardError indicates an error expanding a wildcarded query. 
    """

    __swig_setmethods__ = {}
    for _s in [RuntimeError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WildcardError, name, value)
    __swig_getmethods__ = {}
    for _s in [RuntimeError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, WildcardError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::WildcardError::WildcardError(const std::string &msg_, int
        errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.WildcardError_swiginit(self, _xapian.new_WildcardError(*args))
    __swig_destroy__ = _xapian.delete_WildcardError
WildcardError_swigregister = _xapian.WildcardError_swigregister
WildcardError_swigregister(WildcardError)

class DatabaseNotFoundError(DatabaseOpeningError):
    """


    Indicates an attempt to access a database not present. 
    """

    __swig_setmethods__ = {}
    for _s in [DatabaseOpeningError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DatabaseNotFoundError, name, value)
    __swig_getmethods__ = {}
    for _s in [DatabaseOpeningError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DatabaseNotFoundError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::DatabaseNotFoundError::DatabaseNotFoundError(const std::string
        &msg_, int errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.DatabaseNotFoundError_swiginit(self, _xapian.new_DatabaseNotFoundError(*args))
    __swig_destroy__ = _xapian.delete_DatabaseNotFoundError
DatabaseNotFoundError_swigregister = _xapian.DatabaseNotFoundError_swigregister
DatabaseNotFoundError_swigregister(DatabaseNotFoundError)

class DatabaseClosedError(DatabaseError):
    """


    Indicates an attempt to access a closed database. 
    """

    __swig_setmethods__ = {}
    for _s in [DatabaseError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DatabaseClosedError, name, value)
    __swig_getmethods__ = {}
    for _s in [DatabaseError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DatabaseClosedError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct from message and errno value.

        Xapian::DatabaseClosedError::DatabaseClosedError(const std::string
        &msg_, int errno_)

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.DatabaseClosedError_swiginit(self, _xapian.new_DatabaseClosedError(*args))
    __swig_destroy__ = _xapian.delete_DatabaseClosedError
DatabaseClosedError_swigregister = _xapian.DatabaseClosedError_swigregister
DatabaseClosedError_swigregister(DatabaseClosedError)


def version_string():
    return _xapian.version_string()
version_string = _xapian.version_string

def major_version():
    return _xapian.major_version()
major_version = _xapian.major_version

def minor_version():
    return _xapian.minor_version()
minor_version = _xapian.minor_version

def revision():
    return _xapian.revision()
revision = _xapian.revision
BAD_VALUENO = _xapian.BAD_VALUENO
DB_CREATE = _xapian.DB_CREATE
DB_CREATE_OR_OPEN = _xapian.DB_CREATE_OR_OPEN
DB_CREATE_OR_OVERWRITE = _xapian.DB_CREATE_OR_OVERWRITE
DB_OPEN = _xapian.DB_OPEN
DB_NO_SYNC = _xapian.DB_NO_SYNC
DB_FULL_SYNC = _xapian.DB_FULL_SYNC
DB_DANGEROUS = _xapian.DB_DANGEROUS
DB_NO_TERMLIST = _xapian.DB_NO_TERMLIST
DB_BACKEND_CHERT = _xapian.DB_BACKEND_CHERT
DB_BACKEND_GLASS = _xapian.DB_BACKEND_GLASS
DB_BACKEND_INMEMORY = _xapian.DB_BACKEND_INMEMORY
DB_BACKEND_STUB = _xapian.DB_BACKEND_STUB
DB_RETRY_LOCK = _xapian.DB_RETRY_LOCK
DBCHECK_SHORT_TREE = _xapian.DBCHECK_SHORT_TREE
DBCHECK_FULL_TREE = _xapian.DBCHECK_FULL_TREE
DBCHECK_SHOW_FREELIST = _xapian.DBCHECK_SHOW_FREELIST
DBCHECK_SHOW_STATS = _xapian.DBCHECK_SHOW_STATS
DBCHECK_FIX = _xapian.DBCHECK_FIX
DBCOMPACT_MULTIPASS = _xapian.DBCOMPACT_MULTIPASS
DBCOMPACT_NO_RENUMBER = _xapian.DBCOMPACT_NO_RENUMBER
DBCOMPACT_SINGLE_FILE = _xapian.DBCOMPACT_SINGLE_FILE
DOC_ASSUME_VALID = _xapian.DOC_ASSUME_VALID
class _PositionIterator(object):
    """


    Class for iterating over term positions. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Default constructor.

        Xapian::PositionIterator::PositionIterator()

        Creates an uninitialised iterator, which can't be used before being
        assigned to, but is sometimes syntactically convenient. 
        """
        _xapian._PositionIterator_swiginit(self, _xapian.new__PositionIterator())
    __swig_destroy__ = _xapian.delete__PositionIterator

    def skip_to(self, termpos):
        """


        Advance the iterator to term position termpos.

        void Xapian::PositionIterator::skip_to(Xapian::termpos termpos)

        Parameters:
        -----------

        termpos:  The position to advance to. If this position isn't in the
        stream being iterated, then the iterator is moved to the next term
        position after it which is. 
        """
        return _xapian._PositionIterator_skip_to(self, termpos)


    def __str__(self):
        """


        Return a string describing this object.

        std::string Xapian::PositionIterator::get_description() const 
        """
        return _xapian._PositionIterator___str__(self)

_PositionIterator.skip_to = _xapian.SWIG_PyInstanceMethod_New(_xapian._PositionIterator_skip_to)
_PositionIterator.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._PositionIterator___str__)
_PositionIterator.__eq__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._PositionIterator___eq__)
_PositionIterator.__ne__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._PositionIterator___ne__)
_PositionIterator.equals = _xapian.SWIG_PyInstanceMethod_New(_xapian._PositionIterator_equals)
_PositionIterator.get_termpos = _xapian.SWIG_PyInstanceMethod_New(_xapian._PositionIterator_get_termpos)
_PositionIterator.__next__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._PositionIterator___next__)
_PositionIterator_swigregister = _xapian._PositionIterator_swigregister
_PositionIterator_swigregister(_PositionIterator)

class _PostingIterator(object):
    """


    Class for iterating over a list of terms. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Default constructor.

        Xapian::PostingIterator::PostingIterator()

        Creates an uninitialised iterator, which can't be used before being
        assigned to, but is sometimes syntactically convenient. 
        """
        _xapian._PostingIterator_swiginit(self, _xapian.new__PostingIterator())
    __swig_destroy__ = _xapian.delete__PostingIterator

    def get_wdf(self):
        """


        Return the wdf for the document at the current position.

        Xapian::termcount Xapian::PostingIterator::get_wdf() const 
        """
        return _xapian._PostingIterator_get_wdf(self)


    def get_doclength(self):
        """


        Return the length of the document at the current position.

        Xapian::termcount Xapian::PostingIterator::get_doclength() const 
        """
        return _xapian._PostingIterator_get_doclength(self)


    def get_unique_terms(self):
        """


        Return the number of unique terms in the current document.

        Xapian::termcount Xapian::PostingIterator::get_unique_terms() const 
        """
        return _xapian._PostingIterator_get_unique_terms(self)


    def _positionlist_begin(self):
        """


        Return a PositionIterator for the current document.

        PositionIterator Xapian::PostingIterator::positionlist_begin() const

        """
        return _xapian._PostingIterator__positionlist_begin(self)


    def _positionlist_end(self):
        """


        Return an end PositionIterator for the current document.

        PositionIterator Xapian::PostingIterator::positionlist_end() const 
        """
        return _xapian._PostingIterator__positionlist_end(self)


    def skip_to(self, did):
        """


        Advance the iterator to document did.

        void Xapian::PostingIterator::skip_to(Xapian::docid did)

        Parameters:
        -----------

        did:  The document id to advance to. If this document id isn't in the
        stream being iterated, then the iterator is moved to the next document
        id after it which is. 
        """
        return _xapian._PostingIterator_skip_to(self, did)


    def __str__(self):
        """


        Return a string describing this object.

        std::string Xapian::PostingIterator::get_description() const 
        """
        return _xapian._PostingIterator___str__(self)

_PostingIterator.get_wdf = _xapian.SWIG_PyInstanceMethod_New(_xapian._PostingIterator_get_wdf)
_PostingIterator.get_doclength = _xapian.SWIG_PyInstanceMethod_New(_xapian._PostingIterator_get_doclength)
_PostingIterator.get_unique_terms = _xapian.SWIG_PyInstanceMethod_New(_xapian._PostingIterator_get_unique_terms)
_PostingIterator._positionlist_begin = _xapian.SWIG_PyInstanceMethod_New(_xapian._PostingIterator__positionlist_begin)
_PostingIterator._positionlist_end = _xapian.SWIG_PyInstanceMethod_New(_xapian._PostingIterator__positionlist_end)
_PostingIterator.skip_to = _xapian.SWIG_PyInstanceMethod_New(_xapian._PostingIterator_skip_to)
_PostingIterator.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._PostingIterator___str__)
_PostingIterator.__eq__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._PostingIterator___eq__)
_PostingIterator.__ne__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._PostingIterator___ne__)
_PostingIterator.equals = _xapian.SWIG_PyInstanceMethod_New(_xapian._PostingIterator_equals)
_PostingIterator.get_docid = _xapian.SWIG_PyInstanceMethod_New(_xapian._PostingIterator_get_docid)
_PostingIterator.__next__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._PostingIterator___next__)
_PostingIterator_swigregister = _xapian._PostingIterator_swigregister
_PostingIterator_swigregister(_PostingIterator)

class _TermIterator(object):
    """


    Class for iterating over a list of terms. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Default constructor.

        Xapian::TermIterator::TermIterator()

        Creates an uninitialised iterator, which can't be used before being
        assigned to, but is sometimes syntactically convenient. 
        """
        _xapian._TermIterator_swiginit(self, _xapian.new__TermIterator())
    __swig_destroy__ = _xapian.delete__TermIterator

    def get_wdf(self):
        """


        Return the wdf for the term at the current position.

        Xapian::termcount Xapian::TermIterator::get_wdf() const 
        """
        return _xapian._TermIterator_get_wdf(self)


    def get_termfreq(self):
        """


        Return the term frequency for the term at the current position.

        Xapian::doccount Xapian::TermIterator::get_termfreq() const 
        """
        return _xapian._TermIterator_get_termfreq(self)


    def positionlist_count(self):
        """


        Return the length of the position list for the current position.

        Xapian::termcount Xapian::TermIterator::positionlist_count() const 
        """
        return _xapian._TermIterator_positionlist_count(self)


    def _positionlist_begin(self):
        """


        Return a PositionIterator for the current term.

        PositionIterator Xapian::TermIterator::positionlist_begin() const 
        """
        return _xapian._TermIterator__positionlist_begin(self)


    def _positionlist_end(self):
        """


        Return an end PositionIterator for the current term.

        PositionIterator Xapian::TermIterator::positionlist_end() const 
        """
        return _xapian._TermIterator__positionlist_end(self)


    def skip_to(self, term):
        """


        Advance the iterator to term term.

        void Xapian::TermIterator::skip_to(const std::string &term)

        If the iteration is over an unsorted list of terms, then this method
        will throw Xapian::InvalidOperationError.

        Parameters:
        -----------

        term:  The term to advance to. If this term isn't in the stream being
        iterated, then the iterator is moved to the next term after it which
        is. 
        """
        return _xapian._TermIterator_skip_to(self, term)


    def __str__(self):
        """


        Return a string describing this object.

        std::string Xapian::TermIterator::get_description() const 
        """
        return _xapian._TermIterator___str__(self)

_TermIterator.get_wdf = _xapian.SWIG_PyInstanceMethod_New(_xapian._TermIterator_get_wdf)
_TermIterator.get_termfreq = _xapian.SWIG_PyInstanceMethod_New(_xapian._TermIterator_get_termfreq)
_TermIterator.positionlist_count = _xapian.SWIG_PyInstanceMethod_New(_xapian._TermIterator_positionlist_count)
_TermIterator._positionlist_begin = _xapian.SWIG_PyInstanceMethod_New(_xapian._TermIterator__positionlist_begin)
_TermIterator._positionlist_end = _xapian.SWIG_PyInstanceMethod_New(_xapian._TermIterator__positionlist_end)
_TermIterator.skip_to = _xapian.SWIG_PyInstanceMethod_New(_xapian._TermIterator_skip_to)
_TermIterator.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._TermIterator___str__)
_TermIterator.__eq__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._TermIterator___eq__)
_TermIterator.__ne__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._TermIterator___ne__)
_TermIterator.equals = _xapian.SWIG_PyInstanceMethod_New(_xapian._TermIterator_equals)
_TermIterator.get_term = _xapian.SWIG_PyInstanceMethod_New(_xapian._TermIterator_get_term)
_TermIterator.__next__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._TermIterator___next__)
_TermIterator_swigregister = _xapian._TermIterator_swigregister
_TermIterator_swigregister(_TermIterator)

class _ValueIterator(object):
    """


    Class for iterating over document values. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Default constructor.

        Xapian::ValueIterator::ValueIterator()

        Creates an uninitialised iterator, which can't be used before being
        assigned to, but is sometimes syntactically convenient. 
        """
        _xapian._ValueIterator_swiginit(self, _xapian.new__ValueIterator())
    __swig_destroy__ = _xapian.delete__ValueIterator

    def get_docid(self):
        """


        Return the docid at the current position.

        Xapian::docid Xapian::ValueIterator::get_docid() const

        If we're iterating over values of a document, this method will throw
        Xapian::InvalidOperationError. 
        """
        return _xapian._ValueIterator_get_docid(self)


    def get_valueno(self):
        """


        Return the value slot number for the current position.

        Xapian::valueno Xapian::ValueIterator::get_valueno() const

        If the iterator is over all values in a slot, this returns that slot's
        number. If the iterator is over the values in a particular document,
        it returns the number of each slot in turn. 
        """
        return _xapian._ValueIterator_get_valueno(self)


    def skip_to(self, docid_or_slot):
        """


        Advance the iterator to document id or value slot docid_or_slot.

        void Xapian::ValueIterator::skip_to(Xapian::docid docid_or_slot)

        If this iterator is over values in a document, then this method
        advances the iterator to value slot docid_or_slot, or the first slot
        after it if there is no value in slot slot.

        If this iterator is over values in a particular slot, then this method
        advances the iterator to document id docid_or_slot, or the first
        document id after it if there is no value in the slot we're iterating
        over for document docid_or_slot.

        Note: The "two-faced" nature of this method is due to how C++
        overloading works. Xapian::docid and Xapian::valueno are both typedefs
        for the same unsigned integer type, so overloading can't distinguish
        them.

        Parameters:
        -----------

        docid_or_slot:  The docid/slot to advance to. 
        """
        return _xapian._ValueIterator_skip_to(self, docid_or_slot)


    def check(self, docid):
        """


        Check if the specified docid occurs.

        bool Xapian::ValueIterator::check(Xapian::docid docid)

        The caller is required to ensure that the specified document id did
        actually exists in the database.

        This method acts like skip_to() if that can be done at little extra
        cost, in which case it then returns true. This is how chert and glass
        databases behave because they store values in streams which allow for
        an efficient implementation of skip_to().

        Otherwise it simply checks if a particular docid is present. If it is,
        it returns true. If it isn't, it returns false, and leaves the
        position unspecified (and hence the result of calling methods which
        depend on the current position, such as get_docid(), are also
        unspecified). In this state, next() will advance to the first matching
        position after document did, and skip_to() will act as it would if the
        position was the first matching position after document did.

        Currently the inmemory and remote backends behave in the latter way
        because they don't support streamed values and so skip_to() must check
        each document it skips over which is significantly slower.

        Parameters:
        -----------

        docid:  The document id to check. 
        """
        return _xapian._ValueIterator_check(self, docid)


    def __str__(self):
        """


        Return a string describing this object.

        std::string Xapian::ValueIterator::get_description() const 
        """
        return _xapian._ValueIterator___str__(self)

_ValueIterator.get_docid = _xapian.SWIG_PyInstanceMethod_New(_xapian._ValueIterator_get_docid)
_ValueIterator.get_valueno = _xapian.SWIG_PyInstanceMethod_New(_xapian._ValueIterator_get_valueno)
_ValueIterator.skip_to = _xapian.SWIG_PyInstanceMethod_New(_xapian._ValueIterator_skip_to)
_ValueIterator.check = _xapian.SWIG_PyInstanceMethod_New(_xapian._ValueIterator_check)
_ValueIterator.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._ValueIterator___str__)
_ValueIterator.__eq__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._ValueIterator___eq__)
_ValueIterator.__ne__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._ValueIterator___ne__)
_ValueIterator.equals = _xapian.SWIG_PyInstanceMethod_New(_xapian._ValueIterator_equals)
_ValueIterator.get_value = _xapian.SWIG_PyInstanceMethod_New(_xapian._ValueIterator_get_value)
_ValueIterator.__next__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._ValueIterator___next__)
_ValueIterator_swigregister = _xapian._ValueIterator_swigregister
_ValueIterator_swigregister(_ValueIterator)

class Document(object):
    """


    A handle representing a document in a Xapian database.

    The Document class fetches information from the database lazily.
    Usually this behaviour isn't visible to users (except for the speed
    benefits), but if the document in the database is modified or deleted,
    then preexisting Document objects may return the old or new versions
    of data (or throw Xapian::DocNotFoundError in the case of deletion).

    Since Database objects work on a snapshot of the database's state, the
    situation above can only happen with a WritableDatabase object, or if
    you call Database::reopen() on a Database object.

    We recommend you avoid designs where this behaviour is an issue, but
    if you need a way to make a non-lazy version of a Document object, you
    can do this like so:doc =
    Xapian::Document::unserialise(doc.serialise()); 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Make a new empty Document.

        Xapian::Document::Document() 
        """
        _xapian.Document_swiginit(self, _xapian.new_Document())
    __swig_destroy__ = _xapian.delete_Document

    def get_value(self, slot):
        """


        Get value by number.

        std::string Xapian::Document::get_value(Xapian::valueno slot) const

        Returns an empty string if no value with the given number is present
        in the document.

        Parameters:
        -----------

        slot:  The number of the value. 
        """
        return _xapian.Document_get_value(self, slot)


    def add_value(self, slot, value):
        """


        Add a new value.

        void Xapian::Document::add_value(Xapian::valueno slot, const
        std::string &value)

        The new value will replace any existing value with the same number (or
        if the new value is empty, it will remove any existing value with the
        same number).

        Parameters:
        -----------

        slot:  The value slot to add the value in.

        value:  The value to set. 
        """
        return _xapian.Document_add_value(self, slot, value)


    def remove_value(self, slot):
        """


        Remove any value with the given number.

        void Xapian::Document::remove_value(Xapian::valueno slot) 
        """
        return _xapian.Document_remove_value(self, slot)


    def clear_values(self):
        """


        Remove all values associated with the document.

        void Xapian::Document::clear_values() 
        """
        return _xapian.Document_clear_values(self)


    def get_data(self):
        """


        Get data stored in the document.

        std::string Xapian::Document::get_data() const

        This is potentially a relatively expensive operation, and shouldn't
        normally be used during the match (e.g. in a PostingSource or match
        decider functor. Put data for use by match deciders in a value
        instead. 
        """
        return _xapian.Document_get_data(self)


    def set_data(self, data):
        """


        Set data stored in the document.

        void Xapian::Document::set_data(const std::string &data)

        Xapian treats the data as an opaque blob. It may try to compress it,
        but other than that it will just store it and return it when
        requested.

        Parameters:
        -----------

        data:  The data to store. 
        """
        return _xapian.Document_set_data(self, data)


    def add_posting(self, tname, tpos, wdfinc=1):
        """


        Add an occurrence of a term at a particular position.

        void Xapian::Document::add_posting(const std::string &tname,
        Xapian::termpos tpos, Xapian::termcount wdfinc=1)

        Multiple occurrences of the term at the same position are represented
        only once in the positional information, but do increase the wdf.

        If the term is not already in the document, it will be added to it.

        Parameters:
        -----------

        tname:  The name of the term.

        tpos:  The position of the term.

        wdfinc:  The increment that will be applied to the wdf for this term.

        """
        return _xapian.Document_add_posting(self, tname, tpos, wdfinc)


    def add_term(self, tname, wdfinc=1):
        """


        Add a term to the document, without positional information.

        void Xapian::Document::add_term(const std::string &tname,
        Xapian::termcount wdfinc=1)

        Any existing positional information for the term will be left
        unmodified.

        Parameters:
        -----------

        tname:  The name of the term.

        wdfinc:  The increment that will be applied to the wdf for this term
        (default: 1). 
        """
        return _xapian.Document_add_term(self, tname, wdfinc)


    def add_boolean_term(self, term):
        """


        Add a boolean filter term to the document.

        void Xapian::Document::add_boolean_term(const std::string &term)

        This method adds term to the document with wdf of 0 - this is
        generally what you want for a term used for boolean filtering as the
        wdf of such terms is ignored, and it doesn't make sense for them to
        contribute to the document's length.

        If the specified term already indexes this document, this method has
        no effect.

        It is exactly the same as add_term(term, 0).

        This method was added in Xapian 1.0.18.

        Parameters:
        -----------

        term:  The term to add. 
        """
        return _xapian.Document_add_boolean_term(self, term)


    def remove_posting(self, tname, tpos, wdfdec=1):
        """


        Remove a posting of a term from the document.

        void Xapian::Document::remove_posting(const std::string &tname,
        Xapian::termpos tpos, Xapian::termcount wdfdec=1)

        Note that the term will still index the document even if all
        occurrences are removed. To remove a term from a document completely,
        use remove_term().

        Parameters:
        -----------

        tname:  The name of the term.

        tpos:  The position of the term.

        wdfdec:  The decrement that will be applied to the wdf when removing
        this posting. The wdf will not go below the value of 0.

        Parameters:
        -----------

        Xapian::InvalidArgumentError:  will be thrown if the term is not at
        the position specified in the position list for this term in this
        document.

        Xapian::InvalidArgumentError:  will be thrown if the term is not in
        the document 
        """
        return _xapian.Document_remove_posting(self, tname, tpos, wdfdec)


    def remove_postings(self, term, term_pos_first, term_pos_last, wdf_dec=1):
        """


        Remove a range of postings for a term.

        Xapian::termpos Xapian::Document::remove_postings(const std::string
        &term, Xapian::termpos term_pos_first, Xapian::termpos term_pos_last,
        Xapian::termcount wdf_dec=1)

        Any instances of the term at positions >= term_pos_first and <=
        term_pos_last will be removed, and the wdf reduced by wdf_dec for each
        instance removed (the wdf will not ever go below zero though).

        It's OK if the term doesn't occur in the range of positions specified
        (unlike  remove_posting()). And if term_pos_first > term_pos_last,
        this method does nothing.

        The number of postings removed.

        Parameters:
        -----------

        Xapian::InvalidArgumentError:  will be thrown if the term is not in
        the document

        Added in Xapian 1.4.8. 
        """
        return _xapian.Document_remove_postings(self, term, term_pos_first, term_pos_last, wdf_dec)


    def remove_term(self, tname):
        """


        Remove a term and all postings associated with it.

        void Xapian::Document::remove_term(const std::string &tname)

        Parameters:
        -----------

        tname:  The name of the term.

        Parameters:
        -----------

        Xapian::InvalidArgumentError:  will be thrown if the term is not in
        the document 
        """
        return _xapian.Document_remove_term(self, tname)


    def clear_terms(self):
        """


        Remove all terms (and postings) from the document.

        void Xapian::Document::clear_terms() 
        """
        return _xapian.Document_clear_terms(self)


    def termlist_count(self):
        """


        The length of the termlist - i.e.

        Xapian::termcount Xapian::Document::termlist_count() const

        the number of different terms which index this document. 
        """
        return _xapian.Document_termlist_count(self)


    def _termlist_begin(self):
        """


        Iterator for the terms in this document.

        TermIterator Xapian::Document::termlist_begin() const 
        """
        return _xapian.Document__termlist_begin(self)


    def _termlist_end(self):
        """


        Equivalent end iterator for termlist_begin().

        TermIterator Xapian::Document::termlist_end() const 
        """
        return _xapian.Document__termlist_end(self)


    def values_count(self):
        """


        Count the values in this document.

        Xapian::termcount Xapian::Document::values_count() const 
        """
        return _xapian.Document_values_count(self)


    def _values_begin(self):
        """


        Iterator for the values in this document.

        ValueIterator Xapian::Document::values_begin() const 
        """
        return _xapian.Document__values_begin(self)


    def _values_end(self):
        """


        Equivalent end iterator for values_begin().

        ValueIterator Xapian::Document::values_end() const 
        """
        return _xapian.Document__values_end(self)


    def get_docid(self):
        """


        Get the document id which is associated with this document (if any).

        docid Xapian::Document::get_docid() const

        NB If multiple databases are being searched together, then this will
        be the document id in the individual database, not the merged
        database!

        If this document came from a database, return the document id in that
        database. Otherwise, return 0 (in Xapian 1.0.22/1.2.4 or later; prior
        to this the returned value was uninitialised). 
        """
        return _xapian.Document_get_docid(self)


    def serialise(self):
        """


        Serialise document into a string.

        std::string Xapian::Document::serialise() const

        The document representation may change between Xapian releases: even
        between minor versions. However, it is guaranteed not to change if the
        remote database protocol has not changed between releases. 
        """
        return _xapian.Document_serialise(self)

    unserialise = staticmethod(_xapian.Document_unserialise)

    def __str__(self):
        """


        Return a string describing this object.

        std::string Xapian::Document::get_description() const 
        """
        return _xapian.Document___str__(self)

Document.get_value = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document_get_value)
Document.add_value = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document_add_value)
Document.remove_value = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document_remove_value)
Document.clear_values = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document_clear_values)
Document.get_data = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document_get_data)
Document.set_data = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document_set_data)
Document.add_posting = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document_add_posting)
Document.add_term = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document_add_term)
Document.add_boolean_term = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document_add_boolean_term)
Document.remove_posting = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document_remove_posting)
Document.remove_postings = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document_remove_postings)
Document.remove_term = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document_remove_term)
Document.clear_terms = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document_clear_terms)
Document.termlist_count = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document_termlist_count)
Document._termlist_begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document__termlist_begin)
Document._termlist_end = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document__termlist_end)
Document.values_count = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document_values_count)
Document._values_begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document__values_begin)
Document._values_end = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document__values_end)
Document.get_docid = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document_get_docid)
Document.serialise = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document_serialise)
Document.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.Document___str__)
Document_swigregister = _xapian.Document_swigregister
Document_swigregister(Document)

def Document_unserialise(serialised):
    return _xapian.Document_unserialise(serialised)
Document_unserialise = _xapian.Document_unserialise

class Registry(object):
    """


    Registry for user subclasses.

    This class provides a way for the remote server to look up user
    subclasses when unserialising. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Default constructor.

        Xapian::Registry::Registry()

        The registry will contain all standard subclasses of user-subclassable
        classes. 
        """
        _xapian.Registry_swiginit(self, _xapian.new_Registry())
    __swig_destroy__ = _xapian.delete_Registry

    def register_weighting_scheme(self, wt):
        """


        Register a weighting scheme.

        void Xapian::Registry::register_weighting_scheme(const Xapian::Weight
        &wt)

        Parameters:
        -----------

        wt:  The weighting scheme to register. 
        """
        return _xapian.Registry_register_weighting_scheme(self, wt)


    def get_weighting_scheme(self, name):
        """


        Get the weighting scheme given a name.

        const Xapian::Weight* Xapian::Registry::get_weighting_scheme(const
        std::string &name) const

        Parameters:
        -----------

        name:  The name of the weighting scheme to find.

        An object with the requested name, or NULL if the weighting scheme
        could not be found. The returned object is owned by the registry and
        so must not be deleted by the caller. 
        """
        return _xapian.Registry_get_weighting_scheme(self, name)


    def register_posting_source(self, source):
        """


        Register a user-defined posting source class.

        void Xapian::Registry::register_posting_source(const
        Xapian::PostingSource &source)

        Parameters:
        -----------

        source:  The posting source to register. 
        """
        return _xapian.Registry_register_posting_source(self, source)


    def get_posting_source(self, name):
        """


        Get a posting source given a name.

        const Xapian::PostingSource*
        Xapian::Registry::get_posting_source(const std::string &name) const

        Parameters:
        -----------

        name:  The name of the posting source to find.

        An object with the requested name, or NULL if the posting source could
        not be found. The returned object is owned by the registry and so must
        not be deleted by the caller. 
        """
        return _xapian.Registry_get_posting_source(self, name)


    def register_match_spy(self, spy):
        """


        Register a user-defined match spy class.

        void Xapian::Registry::register_match_spy(const Xapian::MatchSpy &spy)

        Parameters:
        -----------

        spy:  The match spy to register. 
        """
        return _xapian.Registry_register_match_spy(self, spy)


    def get_match_spy(self, name):
        """


        Get a match spy given a name.

        const Xapian::MatchSpy* Xapian::Registry::get_match_spy(const
        std::string &name) const

        Parameters:
        -----------

        name:  The name of the match spy to find.

        An object with the requested name, or NULL if the match spy could not
        be found. The returned object is owned by the registry and so must not
        be deleted by the caller. 
        """
        return _xapian.Registry_get_match_spy(self, name)


    def register_lat_long_metric(self, metric):
        """


        Register a user-defined lat-long metric class.

        void Xapian::Registry::register_lat_long_metric(const
        Xapian::LatLongMetric &metric) 
        """
        return _xapian.Registry_register_lat_long_metric(self, metric)


    def get_lat_long_metric(self, name):
        """


        Get a lat-long metric given a name.

        const Xapian::LatLongMetric*
        Xapian::Registry::get_lat_long_metric(const std::string &name) const

        The returned metric is owned by the registry object.

        Returns NULL if the metric could not be found. 
        """
        return _xapian.Registry_get_lat_long_metric(self, name)

Registry.register_weighting_scheme = _xapian.SWIG_PyInstanceMethod_New(_xapian.Registry_register_weighting_scheme)
Registry.get_weighting_scheme = _xapian.SWIG_PyInstanceMethod_New(_xapian.Registry_get_weighting_scheme)
Registry.register_posting_source = _xapian.SWIG_PyInstanceMethod_New(_xapian.Registry_register_posting_source)
Registry.get_posting_source = _xapian.SWIG_PyInstanceMethod_New(_xapian.Registry_get_posting_source)
Registry.register_match_spy = _xapian.SWIG_PyInstanceMethod_New(_xapian.Registry_register_match_spy)
Registry.get_match_spy = _xapian.SWIG_PyInstanceMethod_New(_xapian.Registry_get_match_spy)
Registry.register_lat_long_metric = _xapian.SWIG_PyInstanceMethod_New(_xapian.Registry_register_lat_long_metric)
Registry.get_lat_long_metric = _xapian.SWIG_PyInstanceMethod_New(_xapian.Registry_get_lat_long_metric)
Registry_swigregister = _xapian.Registry_swigregister
Registry_swigregister(Registry)

class Query(object):
    """


    Class representing a query. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    OP_AND = _xapian.Query_OP_AND
    OP_OR = _xapian.Query_OP_OR
    OP_AND_NOT = _xapian.Query_OP_AND_NOT
    OP_XOR = _xapian.Query_OP_XOR
    OP_AND_MAYBE = _xapian.Query_OP_AND_MAYBE
    OP_FILTER = _xapian.Query_OP_FILTER
    OP_NEAR = _xapian.Query_OP_NEAR
    OP_PHRASE = _xapian.Query_OP_PHRASE
    OP_VALUE_RANGE = _xapian.Query_OP_VALUE_RANGE
    OP_SCALE_WEIGHT = _xapian.Query_OP_SCALE_WEIGHT
    OP_ELITE_SET = _xapian.Query_OP_ELITE_SET
    OP_VALUE_GE = _xapian.Query_OP_VALUE_GE
    OP_VALUE_LE = _xapian.Query_OP_VALUE_LE
    OP_SYNONYM = _xapian.Query_OP_SYNONYM
    OP_MAX = _xapian.Query_OP_MAX
    OP_WILDCARD = _xapian.Query_OP_WILDCARD
    OP_INVALID = _xapian.Query_OP_INVALID
    WILDCARD_LIMIT_ERROR = _xapian.Query_WILDCARD_LIMIT_ERROR
    WILDCARD_LIMIT_FIRST = _xapian.Query_WILDCARD_LIMIT_FIRST
    WILDCARD_LIMIT_MOST_FREQUENT = _xapian.Query_WILDCARD_LIMIT_MOST_FREQUENT
    __swig_destroy__ = _xapian.delete_Query

    def _get_terms_begin(self):
        """


        Begin iterator for terms in the query object.

        const TermIterator Xapian::Query::get_terms_begin() const

        The iterator returns terms in ascending query position order, and will
        return the same term in each unique position it occurs in. If you want
        the terms in sorted order and without duplicates, see
        get_unique_terms_begin(). 
        """
        return _xapian.Query__get_terms_begin(self)


    def _get_terms_end(self):
        """


        End iterator for terms in the query object.

        const TermIterator Xapian::Query::get_terms_end() const 
        """
        return _xapian.Query__get_terms_end(self)


    def get_unique_terms_begin(self):
        """


        Begin iterator for unique terms in the query object.

        const TermIterator Xapian::Query::get_unique_terms_begin() const

        Terms are sorted and terms with the same name removed from the list.

        If you want the terms in ascending query position order, see
        get_terms_begin(). 
        """
        return _xapian.Query_get_unique_terms_begin(self)


    def get_unique_terms_end(self):
        """


        End iterator for unique terms in the query object.

        const TermIterator Xapian::Query::get_unique_terms_end() const 
        """
        return _xapian.Query_get_unique_terms_end(self)


    def get_length(self):
        """


        Return the length of this query object.

        Xapian::termcount Xapian::Query::get_length() const 
        """
        return _xapian.Query_get_length(self)


    def empty(self):
        """


        Check if this query is Xapian::Query::MatchNothing.

        bool Xapian::Query::empty() const 
        """
        return _xapian.Query_empty(self)


    def serialise(self):
        """


        Serialise this object into a string.

        std::string Xapian::Query::serialise() const 
        """
        return _xapian.Query_serialise(self)

    unserialise = staticmethod(_xapian.Query_unserialise)

    def get_type(self):
        """


        Get the type of the top level of the query.

        op Xapian::Query::get_type() const 
        """
        return _xapian.Query_get_type(self)


    def get_num_subqueries(self):
        """


        Get the number of subqueries of the top level query.

        size_t Xapian::Query::get_num_subqueries() const 
        """
        return _xapian.Query_get_num_subqueries(self)


    def get_subquery(self, n):
        """


        Read a top level subquery.

        const Query Xapian::Query::get_subquery(size_t n) const

        Parameters:
        -----------

        n:  Return the n-th subquery (starting from 0) - only valid when 0 <=
        n < get_num_subqueries(). 
        """
        return _xapian.Query_get_subquery(self, n)


    def __str__(self):
        """


        Return a string describing this object.

        std::string Xapian::Query::get_description() const 
        """
        return _xapian.Query___str__(self)


    def __init__(self, *args):
        """


        Construct with just an operator.

        Xapian::Query::Query(Query::op op_)

        Parameters:
        -----------

        op_:  The operator to use - currently only OP_INVALID is useful. 
        """
        _xapian.Query_swiginit(self, _xapian.new_Query(*args))
Query._get_terms_begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.Query__get_terms_begin)
Query._get_terms_end = _xapian.SWIG_PyInstanceMethod_New(_xapian.Query__get_terms_end)
Query.get_unique_terms_begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.Query_get_unique_terms_begin)
Query.get_unique_terms_end = _xapian.SWIG_PyInstanceMethod_New(_xapian.Query_get_unique_terms_end)
Query.get_length = _xapian.SWIG_PyInstanceMethod_New(_xapian.Query_get_length)
Query.empty = _xapian.SWIG_PyInstanceMethod_New(_xapian.Query_empty)
Query.serialise = _xapian.SWIG_PyInstanceMethod_New(_xapian.Query_serialise)
Query.get_type = _xapian.SWIG_PyInstanceMethod_New(_xapian.Query_get_type)
Query.get_num_subqueries = _xapian.SWIG_PyInstanceMethod_New(_xapian.Query_get_num_subqueries)
Query.get_subquery = _xapian.SWIG_PyInstanceMethod_New(_xapian.Query_get_subquery)
Query.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.Query___str__)
Query_swigregister = _xapian.Query_swigregister
Query_swigregister(Query)

def Query_unserialise(*args):
    return _xapian.Query_unserialise(*args)
Query_unserialise = _xapian.Query_unserialise


def __or__(a, b):
    return _xapian.__or__(a, b)
__or__ = _xapian.__or__

def __xor__(a, b):
    return _xapian.__xor__(a, b)
__xor__ = _xapian.__xor__

def __mul__(*args):
    return _xapian.__mul__(*args)
__mul__ = _xapian.__mul__

def __truediv__(q, factor):
    return _xapian.__truediv__(q, factor)
__truediv__ = _xapian.__truediv__

def __and__(*args):
    return _xapian.__and__(*args)
__and__ = _xapian.__and__
class StemImplementation(object):
    """


    Class representing a stemming algorithm implementation. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Default constructor.

        Xapian::StemImplementation::StemImplementation() 
        """
        if self.__class__ == StemImplementation:
            _self = None
        else:
            _self = self
        _xapian.StemImplementation_swiginit(self, _xapian.new_StemImplementation(_self, ))
    __swig_destroy__ = _xapian.delete_StemImplementation

    def __str__(self):
        """


        Return a string describing this object.

        virtual std::string Xapian::StemImplementation::get_description()
        const =0 
        """
        return _xapian.StemImplementation___str__(self)

    def __disown__(self):
        self.this.disown()
        _xapian.disown_StemImplementation(self)
        return weakref_proxy(self)
StemImplementation.__call__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.StemImplementation___call__)
StemImplementation.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.StemImplementation___str__)
StemImplementation_swigregister = _xapian.StemImplementation_swigregister
StemImplementation_swigregister(StemImplementation)

class Stem(object):
    """


    Class representing a stemming algorithm. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct a Xapian::Stem object with a user-provided stemming
        algorithm.

        Xapian::Stem::Stem(StemImplementation *p)

        You can subclass Xapian::StemImplementation to implement your own
        stemming algorithm (or to wrap a third-party algorithm) and then wrap
        your implementation in a Xapian::Stem object to pass to the Xapian
        API.

        Parameters:
        -----------

        p:  The user-subclassed StemImplementation object. This is reference
        counted, and so will be automatically deleted by the Xapian::Stem
        wrapper when no longer required. 
        """
        _xapian.Stem_swiginit(self, _xapian.new_Stem(*args))
    __swig_destroy__ = _xapian.delete_Stem

    def __str__(self):
        """


        Return a string describing this object.

        std::string Xapian::Stem::get_description() const 
        """
        return _xapian.Stem___str__(self)

    get_available_languages = staticmethod(_xapian.Stem_get_available_languages)
Stem.__call__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.Stem___call__)
Stem.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.Stem___str__)
Stem_swigregister = _xapian.Stem_swigregister
Stem_swigregister(Stem)

def Stem_get_available_languages():
    return _xapian.Stem_get_available_languages()
Stem_get_available_languages = _xapian.Stem_get_available_languages

class TermGenerator(object):
    """


    Parses a piece of text and generate terms.

    This module takes a piece of text and parses it to produce words which
    are then used to generate suitable terms for indexing. The terms
    generated are suitable for use with Query objects produced by the
    QueryParser class. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Default constructor.

        Xapian::TermGenerator::TermGenerator() 
        """
        _xapian.TermGenerator_swiginit(self, _xapian.new_TermGenerator())
    __swig_destroy__ = _xapian.delete_TermGenerator

    def set_stemmer(self, stemmer):
        """


        Set the Xapian::Stem object to be used for generating stemmed terms.

        void Xapian::TermGenerator::set_stemmer(const Xapian::Stem &stemmer)

        """
        return _xapian.TermGenerator_set_stemmer(self, stemmer)


    def set_stopper(self, stop=None):
        """


        Set the Xapian::Stopper object to be used for identifying stopwords.

        void Xapian::TermGenerator::set_stopper(const Xapian::Stopper
        *stop=NULL)

        Stemmed forms of stopwords aren't indexed, but unstemmed forms still
        are so that searches for phrases including stop words still work.

        Parameters:
        -----------

        stop:  The Stopper object to set (default NULL, which means no
        stopwords). 
        """
        return _xapian.TermGenerator_set_stopper(self, stop)


    def set_document(self, doc):
        """


        Set the current document.

        void Xapian::TermGenerator::set_document(const Xapian::Document &doc)

        """
        return _xapian.TermGenerator_set_document(self, doc)


    def get_document(self):
        """


        Get the current document.

        const Xapian::Document& Xapian::TermGenerator::get_document() const 
        """
        return _xapian.TermGenerator_get_document(self)


    def set_database(self, db):
        """


        Set the database to index spelling data to.

        void Xapian::TermGenerator::set_database(const
        Xapian::WritableDatabase &db) 
        """
        return _xapian.TermGenerator_set_database(self, db)

    FLAG_SPELLING = _xapian.TermGenerator_FLAG_SPELLING
    FLAG_CJK_NGRAM = _xapian.TermGenerator_FLAG_CJK_NGRAM
    STEM_NONE = _xapian.TermGenerator_STEM_NONE
    STEM_SOME = _xapian.TermGenerator_STEM_SOME
    STEM_ALL = _xapian.TermGenerator_STEM_ALL
    STEM_ALL_Z = _xapian.TermGenerator_STEM_ALL_Z
    STEM_SOME_FULL_POS = _xapian.TermGenerator_STEM_SOME_FULL_POS
    STOP_NONE = _xapian.TermGenerator_STOP_NONE
    STOP_ALL = _xapian.TermGenerator_STOP_ALL
    STOP_STEMMED = _xapian.TermGenerator_STOP_STEMMED

    def set_flags(self, *args):
        """


        Set flags.

        flags Xapian::TermGenerator::set_flags(flags toggle, flags
        mask=flags(0))

        The new value of flags is: (flags & mask) ^ toggle

        To just set the flags, pass the new flags in toggle and the default
        value for mask.

        Parameters:
        -----------

        toggle:  Flags to XOR.

        mask:  Flags to AND with first.

        The old flags setting. 
        """
        return _xapian.TermGenerator_set_flags(self, *args)


    def set_stemming_strategy(self, strategy):
        """


        Set the stemming strategy.

        void Xapian::TermGenerator::set_stemming_strategy(stem_strategy
        strategy)

        This method controls how the stemming algorithm is applied. It was new
        in Xapian 1.3.1.

        Parameters:
        -----------

        strategy:  The strategy to use - possible values are: STEM_NONE: Don't
        perform any stemming - only unstemmed terms are generated.

        STEM_SOME: Generate both stemmed (with a "Z" prefix) and unstemmed
        terms. No positional information is stored for unstemmed terms. This
        is the default strategy.

        STEM_SOME_FULL_POS: Like STEM_SOME but positional information is
        stored for both stemmed and unstemmed terms. Added in Xapian 1.4.8.

        STEM_ALL: Generate only stemmed terms (but without a "Z" prefix).

        STEM_ALL_Z: Generate only stemmed terms (with a "Z" prefix). 
        """
        return _xapian.TermGenerator_set_stemming_strategy(self, strategy)


    def set_stopper_strategy(self, strategy):
        """


        Set the stopper strategy.

        void Xapian::TermGenerator::set_stopper_strategy(stop_strategy
        strategy)

        The method controls how the stopper is used. It was added in Xapian
        1.4.1.

        You need to also call  set_stopper() for this to have any effect.

        Parameters:
        -----------

        strategy:  The strategy to use - possible values are: STOP_NONE: Don't
        use the stopper.

        STOP_ALL: If a word is identified as a stop word, skip it completely.

        STOP_STEMMED: If a word is identified as a stop word, index its
        unstemmed form but skip the stem. Unstemmed forms are indexed with
        positional information by default, so this allows searches for phrases
        containing stopwords to be supported. (This is the default mode). 
        """
        return _xapian.TermGenerator_set_stopper_strategy(self, strategy)


    def set_max_word_length(self, max_word_length):
        """


        Set the maximum length word to index.

        void Xapian::TermGenerator::set_max_word_length(unsigned
        max_word_length)

        The limit is on the length of a word prior to stemming and prior to
        adding any term prefix.

        The backends mostly impose a limit on the length of terms (often of
        about 240 bytes), but it's generally useful to have a lower limit to
        help prevent the index being bloated by useless junk terms from trying
        to indexing things like binary data, uuencoded data, ASCII art, etc.

        This method was new in Xapian 1.3.1.

        Parameters:
        -----------

        max_word_length:  The maximum length word to index, in bytes in UTF-8
        representation. Default is 64. 
        """
        return _xapian.TermGenerator_set_max_word_length(self, max_word_length)


    def index_text(self, *args):
        """


        Index some text in a std::string.

        void Xapian::TermGenerator::index_text(const std::string &text,
        Xapian::termcount wdf_inc=1, const std::string &prefix=std::string())

        Parameters:
        -----------

        text:  The text to index.

        wdf_inc:  The wdf increment (default 1).

        prefix:  The term prefix to use (default is no prefix). 
        """
        return _xapian.TermGenerator_index_text(self, *args)


    def index_text_without_positions(self, *args):
        """


        Index some text in a std::string without positional information.

        void Xapian::TermGenerator::index_text_without_positions(const
        std::string &text, Xapian::termcount wdf_inc=1, const std::string
        &prefix=std::string())

        Just like index_text, but no positional information is generated. This
        means that the database will be significantly smaller, but that phrase
        searching and NEAR won't be supported.

        Parameters:
        -----------

        text:  The text to index.

        wdf_inc:  The wdf increment (default 1).

        prefix:  The term prefix to use (default is no prefix). 
        """
        return _xapian.TermGenerator_index_text_without_positions(self, *args)


    def increase_termpos(self, delta=100):
        """


        Increase the term position used by index_text.

        void Xapian::TermGenerator::increase_termpos(Xapian::termpos
        delta=100)

        This can be used between indexing text from different fields or other
        places to prevent phrase searches from spanning between them (e.g.
        between the title and body text, or between two chapters in a book).

        Parameters:
        -----------

        delta:  Amount to increase the term position by (default: 100). 
        """
        return _xapian.TermGenerator_increase_termpos(self, delta)


    def get_termpos(self):
        """


        Get the current term position.

        Xapian::termpos Xapian::TermGenerator::get_termpos() const 
        """
        return _xapian.TermGenerator_get_termpos(self)


    def set_termpos(self, termpos):
        """


        Set the current term position.

        void Xapian::TermGenerator::set_termpos(Xapian::termpos termpos)

        Parameters:
        -----------

        termpos:  The new term position to set. 
        """
        return _xapian.TermGenerator_set_termpos(self, termpos)


    def __str__(self):
        """


        Return a string describing this object.

        std::string Xapian::TermGenerator::get_description() const 
        """
        return _xapian.TermGenerator___str__(self)

TermGenerator.set_stemmer = _xapian.SWIG_PyInstanceMethod_New(_xapian.TermGenerator_set_stemmer)
TermGenerator.set_stopper = _xapian.SWIG_PyInstanceMethod_New(_xapian.TermGenerator_set_stopper)
TermGenerator.set_document = _xapian.SWIG_PyInstanceMethod_New(_xapian.TermGenerator_set_document)
TermGenerator.get_document = _xapian.SWIG_PyInstanceMethod_New(_xapian.TermGenerator_get_document)
TermGenerator.set_database = _xapian.SWIG_PyInstanceMethod_New(_xapian.TermGenerator_set_database)
TermGenerator.set_flags = _xapian.SWIG_PyInstanceMethod_New(_xapian.TermGenerator_set_flags)
TermGenerator.set_stemming_strategy = _xapian.SWIG_PyInstanceMethod_New(_xapian.TermGenerator_set_stemming_strategy)
TermGenerator.set_stopper_strategy = _xapian.SWIG_PyInstanceMethod_New(_xapian.TermGenerator_set_stopper_strategy)
TermGenerator.set_max_word_length = _xapian.SWIG_PyInstanceMethod_New(_xapian.TermGenerator_set_max_word_length)
TermGenerator.index_text = _xapian.SWIG_PyInstanceMethod_New(_xapian.TermGenerator_index_text)
TermGenerator.index_text_without_positions = _xapian.SWIG_PyInstanceMethod_New(_xapian.TermGenerator_index_text_without_positions)
TermGenerator.increase_termpos = _xapian.SWIG_PyInstanceMethod_New(_xapian.TermGenerator_increase_termpos)
TermGenerator.get_termpos = _xapian.SWIG_PyInstanceMethod_New(_xapian.TermGenerator_get_termpos)
TermGenerator.set_termpos = _xapian.SWIG_PyInstanceMethod_New(_xapian.TermGenerator_set_termpos)
TermGenerator.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.TermGenerator___str__)
TermGenerator_swigregister = _xapian.TermGenerator_swigregister
TermGenerator_swigregister(TermGenerator)

class MSet(object):
    """


    Class representing a list of search results. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Default constructor.

        Xapian::MSet::MSet()

        Creates an empty MSet, mostly useful as a placeholder. 
        """
        _xapian.MSet_swiginit(self, _xapian.new_MSet())
    __swig_destroy__ = _xapian.delete_MSet

    def convert_to_percent(self, *args):
        """


        Convert the weight of the current iterator position to a percentage.

        int Xapian::MSet::convert_to_percent(const MSetIterator &it) const

        The matching document with the highest weight will get 100% if it
        matches all the weighted query terms, and proportionally less if it
        only matches some, and other weights are scaled by the same factor.

        Documents with a non-zero score will always score at least 1%.

        Note that these generally aren't percentages of anything meaningful
        (unless you use a custom weighting formula where they are!) 
        """
        return _xapian.MSet_convert_to_percent(self, *args)


    def get_termfreq(self, term):
        """


        Get the termfreq of a term.

        Xapian::doccount Xapian::MSet::get_termfreq(const std::string &term)
        const

        The number of documents term occurs in. 
        """
        return _xapian.MSet_get_termfreq(self, term)


    def get_termweight(self, term):
        """


        Get the term weight of a term.

        double Xapian::MSet::get_termweight(const std::string &term) const

        The maximum weight that term could have contributed to a document. 
        """
        return _xapian.MSet_get_termweight(self, term)


    def get_firstitem(self):
        """


        Rank of first item in this MSet.

        Xapian::doccount Xapian::MSet::get_firstitem() const

        This is the parameter first passed to Xapian::Enquire::get_mset(). 
        """
        return _xapian.MSet_get_firstitem(self)


    def get_matches_lower_bound(self):
        """


        Lower bound on the total number of matching documents.

        Xapian::doccount Xapian::MSet::get_matches_lower_bound() const 
        """
        return _xapian.MSet_get_matches_lower_bound(self)


    def get_matches_estimated(self):
        """


        Estimate of the total number of matching documents.

        Xapian::doccount Xapian::MSet::get_matches_estimated() const 
        """
        return _xapian.MSet_get_matches_estimated(self)


    def get_matches_upper_bound(self):
        """


        Upper bound on the total number of matching documents.

        Xapian::doccount Xapian::MSet::get_matches_upper_bound() const 
        """
        return _xapian.MSet_get_matches_upper_bound(self)


    def get_uncollapsed_matches_lower_bound(self):
        """


        Lower bound on the total number of matching documents before
        collapsing.

        Xapian::doccount Xapian::MSet::get_uncollapsed_matches_lower_bound()
        const

        Conceptually the same as get_matches_lower_bound() for the same query
        without any collapse part (though the actual value may differ). 
        """
        return _xapian.MSet_get_uncollapsed_matches_lower_bound(self)


    def get_uncollapsed_matches_estimated(self):
        """


        Estimate of the total number of matching documents before collapsing.

        Xapian::doccount Xapian::MSet::get_uncollapsed_matches_estimated()
        const

        Conceptually the same as get_matches_estimated() for the same query
        without any collapse part (though the actual value may differ). 
        """
        return _xapian.MSet_get_uncollapsed_matches_estimated(self)


    def get_uncollapsed_matches_upper_bound(self):
        """


        Upper bound on the total number of matching documents before
        collapsing.

        Xapian::doccount Xapian::MSet::get_uncollapsed_matches_upper_bound()
        const

        Conceptually the same as get_matches_upper_bound() for the same query
        without any collapse part (though the actual value may differ). 
        """
        return _xapian.MSet_get_uncollapsed_matches_upper_bound(self)


    def get_max_attained(self):
        """


        The maximum weight attained by any document.

        double Xapian::MSet::get_max_attained() const 
        """
        return _xapian.MSet_get_max_attained(self)


    def get_max_possible(self):
        """


        The maximum possible weight any document could achieve.

        double Xapian::MSet::get_max_possible() const 
        """
        return _xapian.MSet_get_max_possible(self)

    SNIPPET_BACKGROUND_MODEL = _xapian.MSet_SNIPPET_BACKGROUND_MODEL
    SNIPPET_EXHAUSTIVE = _xapian.MSet_SNIPPET_EXHAUSTIVE
    SNIPPET_EMPTY_WITHOUT_MATCH = _xapian.MSet_SNIPPET_EMPTY_WITHOUT_MATCH
    SNIPPET_CJK_NGRAM = _xapian.MSet_SNIPPET_CJK_NGRAM

    def snippet(self, *args):
        """


        Generate a snippet.

        std::string Xapian::MSet::snippet(const std::string &text, size_t
        length=500, const Xapian::Stem &stemmer=Xapian::Stem(), unsigned
        flags=SNIPPET_BACKGROUND_MODEL|SNIPPET_EXHAUSTIVE, const std::string
        &hi_start="<b>", const std::string &hi_end="</b>", const
        std::string &omit="...") const

        This method selects a continuous run of words from text, based mainly
        on where the query matches (currently terms, exact phrases and
        wildcards are taken into account). If flag SNIPPET_BACKGROUND_MODEL is
        used (which it is by default) then the selection algorithm also
        considers the non-query terms in the text with the aim of showing a
        context which provides more useful information.

        The size of the text selected can be controlled by the length
        parameter, which specifies a number of bytes of text to aim to select.
        However slightly more text may be selected. Also the size of any
        escaping, highlighting or omission markers is not considered.

        The returned text is escaped to make it suitable for use in HTML
        (though beware that in upstream releases 1.4.5 and earlier this
        escaping was sometimes incomplete), and matches with the query will be
        highlighted using hi_start and hi_end.

        If the snippet seems to start or end mid-sentence, then omit is
        prepended or append (respectively) to indicate this.

        The same stemming algorithm which was used to build the query should
        be specified in stemmer.

        And flags contains flags controlling behaviour.

        Added in 1.3.5. 
        """
        return _xapian.MSet_snippet(self, *args)


    def fetch(self, *args):
        """


        Prefetch hint the whole MSet.

        void Xapian::MSet::fetch() const

        For a remote database, this may start a pipelined fetch of the
        requested documents from the remote server.

        For a disk-based database, this may send prefetch hints to the
        operating system such that the disk blocks the requested documents are
        stored in are more likely to be in the cache when we come to actually
        read them. 
        """
        return _xapian.MSet_fetch(self, *args)


    def size(self):
        """


        Return number of items in this MSet object.

        Xapian::doccount Xapian::MSet::size() const 
        """
        return _xapian.MSet_size(self)


    def empty(self):
        """


        Return true if this MSet object is empty.

        bool Xapian::MSet::empty() const 
        """
        return _xapian.MSet_empty(self)


    def _begin(self):
        """


        Return iterator pointing to the first item in this MSet.

        MSetIterator Xapian::MSet::begin() const 
        """
        return _xapian.MSet__begin(self)


    def _end(self):
        """


        Return iterator pointing to just after the last item in this MSet.

        MSetIterator Xapian::MSet::end() const 
        """
        return _xapian.MSet__end(self)


    def back(self):
        """


        Return iterator pointing to the last object in this MSet.

        MSetIterator Xapian::MSet::back() const 
        """
        return _xapian.MSet_back(self)


    def __str__(self):
        """


        Return a string describing this object.

        std::string Xapian::MSet::get_description() const 
        """
        return _xapian.MSet___str__(self)


    def _get_hit_internal(self, i):
        """
        Get an item from the MSet.

        The supplied index is relative to the start of the MSet, not the absolute rank
        of the item. 
        """
        return _xapian.MSet__get_hit_internal(self, i)

MSet.convert_to_percent = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet_convert_to_percent)
MSet.get_termfreq = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet_get_termfreq)
MSet.get_termweight = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet_get_termweight)
MSet.get_firstitem = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet_get_firstitem)
MSet.get_matches_lower_bound = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet_get_matches_lower_bound)
MSet.get_matches_estimated = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet_get_matches_estimated)
MSet.get_matches_upper_bound = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet_get_matches_upper_bound)
MSet.get_uncollapsed_matches_lower_bound = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet_get_uncollapsed_matches_lower_bound)
MSet.get_uncollapsed_matches_estimated = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet_get_uncollapsed_matches_estimated)
MSet.get_uncollapsed_matches_upper_bound = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet_get_uncollapsed_matches_upper_bound)
MSet.get_max_attained = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet_get_max_attained)
MSet.get_max_possible = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet_get_max_possible)
MSet.snippet = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet_snippet)
MSet.fetch = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet_fetch)
MSet.size = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet_size)
MSet.empty = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet_empty)
MSet._begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet__begin)
MSet._end = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet__end)
MSet.back = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet_back)
MSet.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet___str__)
MSet.get_docid = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet_get_docid)
MSet.get_document = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet_get_document)
MSet._get_hit_internal = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet__get_hit_internal)
MSet.get_document_percentage = _xapian.SWIG_PyInstanceMethod_New(_xapian.MSet_get_document_percentage)
MSet_swigregister = _xapian.MSet_swigregister
MSet_swigregister(MSet)

class _MSetIterator(object):
    """


    Iterator over a Xapian::MSet. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    mset = property(_xapian._MSetIterator_mset_get, _xapian._MSetIterator_mset_set)
    off_from_end = property(_xapian._MSetIterator_off_from_end_get, _xapian._MSetIterator_off_from_end_set)

    def __init__(self):
        """


        Create an unpositioned MSetIterator.

        Xapian::MSetIterator::MSetIterator() 
        """
        _xapian._MSetIterator_swiginit(self, _xapian.new__MSetIterator())

    def get_rank(self):
        """


        Return the MSet rank for the current position.

        Xapian::doccount Xapian::MSetIterator::get_rank() const

        The rank of mset[0] is mset.get_firstitem(). 
        """
        return _xapian._MSetIterator_get_rank(self)


    def get_document(self):
        """


        Get the Document object for the current position.

        Xapian::Document Xapian::MSetIterator::get_document() const 
        """
        return _xapian._MSetIterator_get_document(self)


    def get_weight(self):
        """


        Get the weight for the current position.

        double Xapian::MSetIterator::get_weight() const 
        """
        return _xapian._MSetIterator_get_weight(self)


    def get_collapse_key(self):
        """


        Return the collapse key for the current position.

        std::string Xapian::MSetIterator::get_collapse_key() const

        If collapsing isn't in use, an empty string will be returned. 
        """
        return _xapian._MSetIterator_get_collapse_key(self)


    def get_collapse_count(self):
        """


        Return a count of the number of collapses done onto the current key.

        Xapian::doccount Xapian::MSetIterator::get_collapse_count() const

        This starts at 0, and is incremented each time an item is eliminated
        because its key is the same as that of the current item (as returned
        by get_collapse_key()).

        Note that this is NOT necessarily one less than the total number of
        matching documents with this collapse key due to various optimisations
        implemented in the matcher - for example, it can skip documents
        completely if it can prove their weight wouldn't be enough to make the
        result set.

        You can say is that if get_collapse_count() > 0 then there are >=
        get_collapse_count() other documents with the current collapse key.
        But if get_collapse_count() == 0 then there may or may not be other
        such documents. 
        """
        return _xapian._MSetIterator_get_collapse_count(self)


    def get_sort_key(self):
        """


        Return the sort key for the current position.

        std::string Xapian::MSetIterator::get_sort_key() const

        If sorting didn't use a key then an empty string will be returned.

        Added in Xapian 1.4.6. 
        """
        return _xapian._MSetIterator_get_sort_key(self)


    def get_percent(self):
        """


        Convert the weight of the current iterator position to a percentage.

        int Xapian::MSetIterator::get_percent() const

        The matching document with the highest weight will get 100% if it
        matches all the weighted query terms, and proportionally less if it
        only matches some, and other weights are scaled by the same factor.

        Documents with a non-zero score will always score at least 1%.

        Note that these generally aren't percentages of anything meaningful
        (unless you use a custom weighting formula where they are!) 
        """
        return _xapian._MSetIterator_get_percent(self)


    def __str__(self):
        """


        Return a string describing this object.

        std::string Xapian::MSetIterator::get_description() const 
        """
        return _xapian._MSetIterator___str__(self)

    __swig_destroy__ = _xapian.delete__MSetIterator
_MSetIterator.get_rank = _xapian.SWIG_PyInstanceMethod_New(_xapian._MSetIterator_get_rank)
_MSetIterator.get_document = _xapian.SWIG_PyInstanceMethod_New(_xapian._MSetIterator_get_document)
_MSetIterator.get_weight = _xapian.SWIG_PyInstanceMethod_New(_xapian._MSetIterator_get_weight)
_MSetIterator.get_collapse_key = _xapian.SWIG_PyInstanceMethod_New(_xapian._MSetIterator_get_collapse_key)
_MSetIterator.get_collapse_count = _xapian.SWIG_PyInstanceMethod_New(_xapian._MSetIterator_get_collapse_count)
_MSetIterator.get_sort_key = _xapian.SWIG_PyInstanceMethod_New(_xapian._MSetIterator_get_sort_key)
_MSetIterator.get_percent = _xapian.SWIG_PyInstanceMethod_New(_xapian._MSetIterator_get_percent)
_MSetIterator.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._MSetIterator___str__)
_MSetIterator.__eq__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._MSetIterator___eq__)
_MSetIterator.__ne__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._MSetIterator___ne__)
_MSetIterator.equals = _xapian.SWIG_PyInstanceMethod_New(_xapian._MSetIterator_equals)
_MSetIterator.get_docid = _xapian.SWIG_PyInstanceMethod_New(_xapian._MSetIterator_get_docid)
_MSetIterator.__next__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._MSetIterator___next__)
_MSetIterator.prev = _xapian.SWIG_PyInstanceMethod_New(_xapian._MSetIterator_prev)
_MSetIterator_swigregister = _xapian._MSetIterator_swigregister
_MSetIterator_swigregister(_MSetIterator)

class ESet(object):
    """


    Class representing a list of search results. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Default constructor.

        Xapian::ESet::ESet()

        Creates an empty ESet, mostly useful as a placeholder. 
        """
        _xapian.ESet_swiginit(self, _xapian.new_ESet())
    __swig_destroy__ = _xapian.delete_ESet

    def size(self):
        """


        Return number of items in this ESet object.

        Xapian::doccount Xapian::ESet::size() const 
        """
        return _xapian.ESet_size(self)


    def empty(self):
        """


        Return true if this ESet object is empty.

        bool Xapian::ESet::empty() const 
        """
        return _xapian.ESet_empty(self)


    def get_ebound(self):
        """


        Return a bound on the full size of this ESet object.

        Xapian::termcount Xapian::ESet::get_ebound() const

        This is a bound on size() if get_eset() had been called with maxitems
        set high enough that all results were returned. 
        """
        return _xapian.ESet_get_ebound(self)


    def _begin(self):
        """


        Return iterator pointing to the first item in this ESet.

        ESetIterator Xapian::ESet::begin() const 
        """
        return _xapian.ESet__begin(self)


    def _end(self):
        """


        Return iterator pointing to just after the last item in this ESet.

        ESetIterator Xapian::ESet::end() const 
        """
        return _xapian.ESet__end(self)


    def back(self):
        """


        Return iterator pointing to the last object in this ESet.

        ESetIterator Xapian::ESet::back() const 
        """
        return _xapian.ESet_back(self)


    def __str__(self):
        """


        Return a string describing this object.

        std::string Xapian::ESet::get_description() const 
        """
        return _xapian.ESet___str__(self)

ESet.size = _xapian.SWIG_PyInstanceMethod_New(_xapian.ESet_size)
ESet.empty = _xapian.SWIG_PyInstanceMethod_New(_xapian.ESet_empty)
ESet.get_ebound = _xapian.SWIG_PyInstanceMethod_New(_xapian.ESet_get_ebound)
ESet._begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.ESet__begin)
ESet._end = _xapian.SWIG_PyInstanceMethod_New(_xapian.ESet__end)
ESet.back = _xapian.SWIG_PyInstanceMethod_New(_xapian.ESet_back)
ESet.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.ESet___str__)
ESet_swigregister = _xapian.ESet_swigregister
ESet_swigregister(ESet)

class _ESetIterator(object):
    """


    Iterator over a Xapian::ESet. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    eset = property(_xapian._ESetIterator_eset_get, _xapian._ESetIterator_eset_set)
    off_from_end = property(_xapian._ESetIterator_off_from_end_get, _xapian._ESetIterator_off_from_end_set)

    def __init__(self):
        """


        Create an unpositioned ESetIterator.

        Xapian::ESetIterator::ESetIterator() 
        """
        _xapian._ESetIterator_swiginit(self, _xapian.new__ESetIterator())

    def get_weight(self):
        """


        Get the weight for the current position.

        double Xapian::ESetIterator::get_weight() const 
        """
        return _xapian._ESetIterator_get_weight(self)


    def __str__(self):
        """


        Return a string describing this object.

        std::string Xapian::ESetIterator::get_description() const 
        """
        return _xapian._ESetIterator___str__(self)

    __swig_destroy__ = _xapian.delete__ESetIterator
_ESetIterator.get_weight = _xapian.SWIG_PyInstanceMethod_New(_xapian._ESetIterator_get_weight)
_ESetIterator.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._ESetIterator___str__)
_ESetIterator.__eq__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._ESetIterator___eq__)
_ESetIterator.__ne__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._ESetIterator___ne__)
_ESetIterator.equals = _xapian.SWIG_PyInstanceMethod_New(_xapian._ESetIterator_equals)
_ESetIterator.get_term = _xapian.SWIG_PyInstanceMethod_New(_xapian._ESetIterator_get_term)
_ESetIterator.__next__ = _xapian.SWIG_PyInstanceMethod_New(_xapian._ESetIterator___next__)
_ESetIterator.prev = _xapian.SWIG_PyInstanceMethod_New(_xapian._ESetIterator_prev)
_ESetIterator_swigregister = _xapian._ESetIterator_swigregister
_ESetIterator_swigregister(_ESetIterator)


def __eq__(*args):
    return _xapian.__eq__(*args)
__eq__ = _xapian.__eq__

def __lt__(*args):
    return _xapian.__lt__(*args)
__lt__ = _xapian.__lt__

def __gt__(*args):
    return _xapian.__gt__(*args)
__gt__ = _xapian.__gt__

def __ge__(*args):
    return _xapian.__ge__(*args)
__ge__ = _xapian.__ge__

def __le__(*args):
    return _xapian.__le__(*args)
__le__ = _xapian.__le__

def __add__(*args):
    return _xapian.__add__(*args)
__add__ = _xapian.__add__
class RSet(object):
    """


    A relevance set (R-Set).

    This is the set of documents which are marked as relevant, for use in
    modifying the term weights, and in performing query expansion. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Default constructor.

        Xapian::RSet::RSet() 
        """
        _xapian.RSet_swiginit(self, _xapian.new_RSet())
    __swig_destroy__ = _xapian.delete_RSet

    def size(self):
        """


        The number of documents in this R-Set.

        Xapian::doccount Xapian::RSet::size() const 
        """
        return _xapian.RSet_size(self)


    def empty(self):
        """


        Test if this R-Set is empty.

        bool Xapian::RSet::empty() const 
        """
        return _xapian.RSet_empty(self)


    def add_document(self, *args):
        """


        Add a document to the relevance set.

        void Xapian::RSet::add_document(const Xapian::MSetIterator &i) 
        """
        return _xapian.RSet_add_document(self, *args)


    def remove_document(self, *args):
        """


        Remove a document from the relevance set.

        void Xapian::RSet::remove_document(const Xapian::MSetIterator &i) 
        """
        return _xapian.RSet_remove_document(self, *args)


    def contains(self, *args):
        """


        Test if a given document in the relevance set.

        bool Xapian::RSet::contains(const Xapian::MSetIterator &i) const 
        """
        return _xapian.RSet_contains(self, *args)


    def __str__(self):
        """


        Return a string describing this object.

        std::string Xapian::RSet::get_description() const 
        """
        return _xapian.RSet___str__(self)

RSet.size = _xapian.SWIG_PyInstanceMethod_New(_xapian.RSet_size)
RSet.empty = _xapian.SWIG_PyInstanceMethod_New(_xapian.RSet_empty)
RSet.add_document = _xapian.SWIG_PyInstanceMethod_New(_xapian.RSet_add_document)
RSet.remove_document = _xapian.SWIG_PyInstanceMethod_New(_xapian.RSet_remove_document)
RSet.contains = _xapian.SWIG_PyInstanceMethod_New(_xapian.RSet_contains)
RSet.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.RSet___str__)
RSet_swigregister = _xapian.RSet_swigregister
RSet_swigregister(RSet)

class MatchDecider(object):
    """


    Base class for matcher decision functor. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Default constructor.

        Xapian::MatchDecider::MatchDecider() 
        """
        if self.__class__ == MatchDecider:
            _self = None
        else:
            _self = self
        _xapian.MatchDecider_swiginit(self, _xapian.new_MatchDecider(_self, ))
    __swig_destroy__ = _xapian.delete_MatchDecider
    def __disown__(self):
        self.this.disown()
        _xapian.disown_MatchDecider(self)
        return weakref_proxy(self)
MatchDecider.__call__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.MatchDecider___call__)
MatchDecider_swigregister = _xapian.MatchDecider_swigregister
MatchDecider_swigregister(MatchDecider)

class Enquire(object):
    """


    This class provides an interface to the information retrieval system
    for the purpose of searching.

    Databases are usually opened lazily, so exceptions may not be thrown
    where you would expect them to be. You should catch Xapian::Error
    exceptions when calling any method in Xapian::Enquire.

    Parameters:
    -----------

    Xapian::InvalidArgumentError:  will be thrown if an invalid argument
    is supplied, for example, an unknown database type. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, database):
        """


        Create a Xapian::Enquire object.

        Xapian::Enquire::Enquire(const Database &database, ErrorHandler
        *errorhandler_)

        This specification cannot be changed once the Xapian::Enquire is
        opened: you must create a new Xapian::Enquire object to access a
        different database, or set of databases.

        The database supplied must have been initialised (ie, must not be the
        result of calling the Database::Database() constructor). If you need
        to handle a situation where you have no databases gracefully, a
        database created with DB_BACKEND_INMEMORY can be passed here to
        provide a completely empty database.

        Parameters:
        -----------

        database:  Specification of the database or databases to use.

        errorhandler_:  This parameter is deprecated (since Xapian 1.3.1), and
        as of 1.3.5 it's ignored completely.

        Parameters:
        -----------

        Xapian::InvalidArgumentError:  will be thrown if an empty Database
        object is supplied. 
        """
        _xapian.Enquire_swiginit(self, _xapian.new_Enquire(database))
    __swig_destroy__ = _xapian.delete_Enquire

    def set_query(self, query, qlen=0):
        """


        Set the query to run.

        void Xapian::Enquire::set_query(const Xapian::Query &query,
        Xapian::termcount qlen=0)

        Parameters:
        -----------

        query:  the new query to run.

        qlen:  the query length to use in weight calculations - by default the
        sum of the wqf of all terms is used. 
        """
        return _xapian.Enquire_set_query(self, query, qlen)


    def get_query(self):
        """


        Get the current query.

        const Xapian::Query& Xapian::Enquire::get_query() const

        If called before set_query(), this will return a default initialised
        Query object. 
        """
        return _xapian.Enquire_get_query(self)


    def add_matchspy(self, spy):
        """


        Add a matchspy.

        void Xapian::Enquire::add_matchspy(MatchSpy *spy)

        This matchspy will be called with some of the documents which match
        the query, during the match process. Exactly which of the matching
        documents are passed to it depends on exactly when certain
        optimisations occur during the match process, but it can be controlled
        to some extent by setting the checkatleast parameter to  get_mset().

        In particular, if there are enough matching documents, at least the
        number specified by checkatleast will be passed to the matchspy. This
        means that you can force the matchspy to be shown all matching
        documents by setting checkatleast to the number of documents in the
        database.

        Parameters:
        -----------

        spy:  The MatchSpy subclass to add. The caller must ensure that this
        remains valid while the Enquire object remains active, or until
        clear_matchspies() is called. 
        """
        return _xapian.Enquire_add_matchspy(self, spy)


    def clear_matchspies(self):
        """


        Remove all the matchspies.

        void Xapian::Enquire::clear_matchspies() 
        """
        return _xapian.Enquire_clear_matchspies(self)


    def set_weighting_scheme(self, weight_):
        """


        Set the weighting scheme to use for queries.

        void Xapian::Enquire::set_weighting_scheme(const Weight &weight_)

        Parameters:
        -----------

        weight_:  the new weighting scheme. If no weighting scheme is
        specified, the default is BM25 with the default parameters. 
        """
        return _xapian.Enquire_set_weighting_scheme(self, weight_)


    def set_expansion_scheme(self, eweightname_, expand_k_=1.0):
        """


        Set the weighting scheme to use for expansion.

        void Xapian::Enquire::set_expansion_scheme(const std::string
        &eweightname_, double expand_k_=1.0) const

        If you don't call this method, the default is as if you'd used:

        get_expansion_scheme("trad");

        Parameters:
        -----------

        eweightname_:  A string in lowercase specifying the name of the scheme
        to be used. The following schemes are currently available: "bo1" :
        The Bo1 scheme for query expansion. "trad" : The TradWeight scheme
        for query expansion.

        expand_k_:  The parameter required for TradWeight query expansion. A
        default value of 1.0 is used if none is specified. 
        """
        return _xapian.Enquire_set_expansion_scheme(self, eweightname_, expand_k_)


    def set_collapse_key(self, collapse_key, collapse_max=1):
        """


        Set the collapse key to use for queries.

        void Xapian::Enquire::set_collapse_key(Xapian::valueno collapse_key,
        Xapian::doccount collapse_max=1)

        Parameters:
        -----------

        collapse_key:  value number to collapse on - at most one MSet entry
        with each particular value will be returned (default is
        Xapian::BAD_VALUENO which means no collapsing).

        collapse_max:  Max number of items with the same key to leave after
        collapsing (default 1).

        The MSet returned by get_mset() will have only the "best" (at most)
        collapse_max entries with each particular value of collapse_key
        ("best" being highest ranked - i.e. highest weight or highest
        sorting key).

        An example use might be to create a value for each document containing
        an MD5 hash of the document contents. Then duplicate documents from
        different sources can be eliminated at search time by collapsing with
        collapse_max = 1 (it's better to eliminate duplicates at index time,
        but this may not be always be possible - for example the search may be
        over more than one Xapian database).

        Another use is to group matches in a particular category (e.g. you
        might collapse a mailing list search on the Subject: so that there's
        only one result per discussion thread). In this case you can use
        get_collapse_count() to give the user some idea how many other results
        there are. And if you index the Subject: as a boolean term as well as
        putting it in a value, you can offer a link to a non-collapsed search
        restricted to that thread using a boolean filter. 
        """
        return _xapian.Enquire_set_collapse_key(self, collapse_key, collapse_max)

    ASCENDING = _xapian.Enquire_ASCENDING
    DESCENDING = _xapian.Enquire_DESCENDING
    DONT_CARE = _xapian.Enquire_DONT_CARE

    def set_docid_order(self, order):
        """


        Set sort order for document IDs.

        void Xapian::Enquire::set_docid_order(docid_order order)

        This order only has an effect on documents which would otherwise have
        equal rank. When ordering by relevance without a sort key, this means
        documents with equal weight. For a boolean match with no sort key,
        this means all documents. And if a sort key is used, this means
        documents with the same sort key (and also equal weight if ordering on
        relevance before or after the sort key).

        Parameters:
        -----------

        order:  This can be:  Xapian::Enquire::ASCENDING docids sort in
        ascending order (default)

        Xapian::Enquire::DESCENDING docids sort in descending order

        Xapian::Enquire::DONT_CARE docids sort in whatever order is most
        efficient for the backend

        Note: If you add documents in strict date order, then a boolean search
        - i.e. set_weighting_scheme(Xapian::BoolWeight()) - with
        set_docid_order(Xapian::Enquire::DESCENDING) is an efficient way to
        perform "sort by date, newest first", and with
        set_docid_order(Xapian::Enquire::ASCENDING) a very efficient way to
        perform "sort by date, oldest first". 
        """
        return _xapian.Enquire_set_docid_order(self, order)


    def set_cutoff(self, percent_cutoff, weight_cutoff=0):
        """


        Set the percentage and/or weight cutoffs.

        void Xapian::Enquire::set_cutoff(int percent_cutoff, double
        weight_cutoff=0)

        Parameters:
        -----------

        percent_cutoff:  Minimum percentage score for returned documents. If a
        document has a lower percentage score than this, it will not appear in
        the MSet. If your intention is to return only matches which contain
        all the terms in the query, then it's more efficient to use
        Xapian::Query::OP_AND instead of Xapian::Query::OP_OR in the query
        than to use set_cutoff(100). (default 0 => no percentage cut-off).

        weight_cutoff:  Minimum weight for a document to be returned. If a
        document has a lower score that this, it will not appear in the MSet.
        It is usually only possible to choose an appropriate weight for cutoff
        based on the results of a previous run of the same query; this is thus
        mainly useful for alerting operations. The other potential use is with
        a user specified weighting scheme. (default 0 => no weight cut-off).

        """
        return _xapian.Enquire_set_cutoff(self, percent_cutoff, weight_cutoff)


    def set_sort_by_relevance(self):
        """


        Set the sorting to be by relevance only.

        void Xapian::Enquire::set_sort_by_relevance()

        This is the default. 
        """
        return _xapian.Enquire_set_sort_by_relevance(self)


    def set_sort_by_value(self, sort_key, reverse):
        """


        Set the sorting to be by value only.

        void Xapian::Enquire::set_sort_by_value(Xapian::valueno sort_key, bool
        reverse)

        Note that sorting by values uses a string comparison, so to use this
        to sort by a numeric value you'll need to store the numeric values in
        a manner which sorts appropriately. For example, you could use
        Xapian::sortable_serialise() (which works for floating point numbers
        as well as integers), or store numbers padded with leading zeros or
        spaces, or with the number of digits prepended.

        Parameters:
        -----------

        sort_key:  value number to sort on.

        reverse:  If true, reverses the sort order. 
        """
        return _xapian.Enquire_set_sort_by_value(self, sort_key, reverse)


    def set_sort_by_key(self, sorter, reverse):
        """


        Set the sorting to be by key generated from values only.

        void Xapian::Enquire::set_sort_by_key(Xapian::KeyMaker *sorter, bool
        reverse)

        Parameters:
        -----------

        sorter:  The functor to use for generating keys.

        reverse:  If true, reverses the sort order. 
        """
        return _xapian.Enquire_set_sort_by_key(self, sorter, reverse)


    def set_sort_by_value_then_relevance(self, sort_key, reverse):
        """


        Set the sorting to be by value, then by relevance for documents with
        the same value.

        void Xapian::Enquire::set_sort_by_value_then_relevance(Xapian::valueno
        sort_key, bool reverse)

        Note that sorting by values uses a string comparison, so to use this
        to sort by a numeric value you'll need to store the numeric values in
        a manner which sorts appropriately. For example, you could use
        Xapian::sortable_serialise() (which works for floating point numbers
        as well as integers), or store numbers padded with leading zeros or
        spaces, or with the number of digits prepended.

        Parameters:
        -----------

        sort_key:  value number to sort on.

        reverse:  If true, reverses the sort order. 
        """
        return _xapian.Enquire_set_sort_by_value_then_relevance(self, sort_key, reverse)


    def set_sort_by_key_then_relevance(self, sorter, reverse):
        """


        Set the sorting to be by keys generated from values, then by relevance
        for documents with identical keys.

        void Xapian::Enquire::set_sort_by_key_then_relevance(Xapian::KeyMaker
        *sorter, bool reverse)

        Parameters:
        -----------

        sorter:  The functor to use for generating keys.

        reverse:  If true, reverses the sort order. 
        """
        return _xapian.Enquire_set_sort_by_key_then_relevance(self, sorter, reverse)


    def set_sort_by_relevance_then_value(self, sort_key, reverse):
        """


        Set the sorting to be by relevance then value.

        void Xapian::Enquire::set_sort_by_relevance_then_value(Xapian::valueno
        sort_key, bool reverse)

        Note that sorting by values uses a string comparison, so to use this
        to sort by a numeric value you'll need to store the numeric values in
        a manner which sorts appropriately. For example, you could use
        Xapian::sortable_serialise() (which works for floating point numbers
        as well as integers), or store numbers padded with leading zeros or
        spaces, or with the number of digits prepended.

        Note that with the default BM25 weighting scheme parameters, non-
        identical documents will rarely have the same weight, so this setting
        will give very similar results to set_sort_by_relevance(). It becomes
        more useful with particular BM25 parameter settings (e.g.
        BM25Weight(1,0,1,0,0)) or custom weighting schemes.

        Parameters:
        -----------

        sort_key:  value number to sort on.

        reverse:  If true, reverses the sort order of sort_key. Beware that in
        1.2.16 and earlier, the sense of this parameter was incorrectly
        inverted and inconsistent with the other set_sort_by_... methods. This
        was fixed in 1.2.17, so make that version a minimum requirement if
        this detail matters to your application. 
        """
        return _xapian.Enquire_set_sort_by_relevance_then_value(self, sort_key, reverse)


    def set_sort_by_relevance_then_key(self, sorter, reverse):
        """


        Set the sorting to be by relevance, then by keys generated from
        values.

        void Xapian::Enquire::set_sort_by_relevance_then_key(Xapian::KeyMaker
        *sorter, bool reverse)

        Note that with the default BM25 weighting scheme parameters, non-
        identical documents will rarely have the same weight, so this setting
        will give very similar results to set_sort_by_relevance(). It becomes
        more useful with particular BM25 parameter settings (e.g.
        BM25Weight(1,0,1,0,0)) or custom weighting schemes.

        Parameters:
        -----------

        sorter:  The functor to use for generating keys.

        reverse:  If true, reverses the sort order of the generated keys.
        Beware that in 1.2.16 and earlier, the sense of this parameter was
        incorrectly inverted and inconsistent with the other set_sort_by_...
        methods. This was fixed in 1.2.17, so make that version a minimum
        requirement if this detail matters to your application. 
        """
        return _xapian.Enquire_set_sort_by_relevance_then_key(self, sorter, reverse)


    def set_time_limit(self, time_limit):
        """


        Set a time limit for the match.

        void Xapian::Enquire::set_time_limit(double time_limit)

        Matches with check_at_least set high can take a long time in some
        cases. You can set a time limit on this, after which check_at_least
        will be turned off.

        Parameters:
        -----------

        time_limit:  time in seconds after which to disable check_at_least
        (default: 0.0 which means no time limit)

        Limitations:

        This feature is currently supported on platforms which support POSIX
        interval timers. Interaction with the remote backend when using
        multiple databases may have bugs. There's not currently a way to force
        the match to end after a certain time. 
        """
        return _xapian.Enquire_set_time_limit(self, time_limit)


    def get_mset(self, *args):
        """


        Get (a portion of) the match set for the current query.

        MSet Xapian::Enquire::get_mset(Xapian::doccount first,
        Xapian::doccount maxitems, const RSet *omrset, const MatchDecider
        *mdecider=0) const

        Parameters:
        -----------

        first:  the first item in the result set to return. A value of zero
        corresponds to the first item returned being that with the highest
        score. A value of 10 corresponds to the first 10 items being ignored,
        and the returned items starting at the eleventh.

        maxitems:  the maximum number of items to return. If you want all
        matches, then you can pass the result of calling get_doccount() on the
        Database object (though if you are doing this so you can filter
        results, you are likely to get much better performance by using
        Xapian's match-time filtering features instead). You can pass 0 for
        maxitems which will give you an empty MSet with valid statistics (such
        as get_matches_estimated()) calculated without looking at any
        postings, which is very quick, but means the estimates may be more
        approximate and the bounds may be much looser.

        omrset:  the relevance set to use when performing the query.

        mdecider:  a decision functor to use to decide whether a given
        document should be put in the MSet.

        A Xapian::MSet object containing the results of the query.

        Parameters:
        -----------

        Xapian::InvalidArgumentError:  See class documentation. 
        """
        return _xapian.Enquire_get_mset(self, *args)

    INCLUDE_QUERY_TERMS = _xapian.Enquire_INCLUDE_QUERY_TERMS
    USE_EXACT_TERMFREQ = _xapian.Enquire_USE_EXACT_TERMFREQ

    def get_eset(self, *args):
        """


        Get the expand set for the given rset.

        ESet Xapian::Enquire::get_eset(Xapian::termcount maxitems, const RSet
        &rset, int flags, double k, const Xapian::ExpandDecider
        *edecider=NULL, double min_wt=0.0) const

        Parameters:
        -----------

        maxitems:  the maximum number of items to return.

        rset:  the relevance set to use when performing the expand operation.

        flags:  zero or more of these values |-ed together:
        Xapian::Enquire::INCLUDE_QUERY_TERMS query terms may be returned from
        expand

        Xapian::Enquire::USE_EXACT_TERMFREQ for multi dbs, calculate the exact
        termfreq; otherwise an approximation is used which can greatly improve
        efficiency, but still returns good results.

        k:  the parameter k in the query expansion algorithm (default is 1.0)

        edecider:  a decision functor to use to decide whether a given term
        should be put in the ESet

        min_wt:  the minimum weight for included terms

        An ESet object containing the results of the expand.

        Parameters:
        -----------

        Xapian::InvalidArgumentError:  See class documentation. 
        """
        return _xapian.Enquire_get_eset(self, *args)


    def _get_matching_terms_begin(self, *args):
        """


        Get terms which match a given document, by match set item.

        TermIterator Xapian::Enquire::get_matching_terms_begin(const
        MSetIterator &it) const

        This method returns the terms in the current query which match the
        given document.

        If the underlying database has suitable support, using this call
        (rather than passing a Xapian::docid) will enable the system to ensure
        that the correct data is returned, and that the document has not been
        deleted or changed since the query was performed.

        Parameters:
        -----------

        it:  The iterator for which to retrieve the matching terms.

        An iterator returning the terms which match the document. The terms
        will be returned (as far as this makes any sense) in the same order as
        the terms in the query. Terms will not occur more than once, even if
        they do in the query.

        Parameters:
        -----------

        Xapian::InvalidArgumentError:  See class documentation.

        Xapian::DocNotFoundError:  The document specified could not be found
        in the database. 
        """
        return _xapian.Enquire__get_matching_terms_begin(self, *args)


    def _get_matching_terms_end(self, *args):
        """


        End iterator corresponding to get_matching_terms_begin()

        TermIterator Xapian::Enquire::get_matching_terms_end(const
        MSetIterator &) const 
        """
        return _xapian.Enquire__get_matching_terms_end(self, *args)


    def __str__(self):
        """


        Return a string describing this object.

        std::string Xapian::Enquire::get_description() const 
        """
        return _xapian.Enquire___str__(self)

Enquire.set_query = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire_set_query)
Enquire.get_query = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire_get_query)
Enquire.add_matchspy = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire_add_matchspy)
Enquire.clear_matchspies = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire_clear_matchspies)
Enquire.set_weighting_scheme = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire_set_weighting_scheme)
Enquire.set_expansion_scheme = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire_set_expansion_scheme)
Enquire.set_collapse_key = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire_set_collapse_key)
Enquire.set_docid_order = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire_set_docid_order)
Enquire.set_cutoff = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire_set_cutoff)
Enquire.set_sort_by_relevance = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire_set_sort_by_relevance)
Enquire.set_sort_by_value = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire_set_sort_by_value)
Enquire.set_sort_by_key = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire_set_sort_by_key)
Enquire.set_sort_by_value_then_relevance = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire_set_sort_by_value_then_relevance)
Enquire.set_sort_by_key_then_relevance = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire_set_sort_by_key_then_relevance)
Enquire.set_sort_by_relevance_then_value = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire_set_sort_by_relevance_then_value)
Enquire.set_sort_by_relevance_then_key = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire_set_sort_by_relevance_then_key)
Enquire.set_time_limit = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire_set_time_limit)
Enquire.get_mset = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire_get_mset)
Enquire.get_eset = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire_get_eset)
Enquire._get_matching_terms_begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire__get_matching_terms_begin)
Enquire._get_matching_terms_end = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire__get_matching_terms_end)
Enquire.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.Enquire___str__)
Enquire_swigregister = _xapian.Enquire_swigregister
Enquire_swigregister(Enquire)

class ExpandDecider(object):
    """


    Virtual base class for expand decider functor. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Default constructor.

        Xapian::ExpandDecider::ExpandDecider() 
        """
        if self.__class__ == ExpandDecider:
            _self = None
        else:
            _self = self
        _xapian.ExpandDecider_swiginit(self, _xapian.new_ExpandDecider(_self, ))
    __swig_destroy__ = _xapian.delete_ExpandDecider

    def release(self):
        """


        Start reference counting this object.

        const ExpandDecider* Xapian::ExpandDecider::release() const

        You can hand ownership of a dynamically allocated ExpandDecider object
        to Xapian by calling release() and then passing the object to a Xapian
        method. Xapian will arrange to delete the object once it is no longer
        required. 
        """
        return _xapian.ExpandDecider_release(self)

    def __disown__(self):
        self.this.disown()
        _xapian.disown_ExpandDecider(self)
        return weakref_proxy(self)
ExpandDecider.__call__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.ExpandDecider___call__)
ExpandDecider.release = _xapian.SWIG_PyInstanceMethod_New(_xapian.ExpandDecider_release)
ExpandDecider_swigregister = _xapian.ExpandDecider_swigregister
ExpandDecider_swigregister(ExpandDecider)

class ExpandDeciderAnd(ExpandDecider):
    """


    ExpandDecider subclass which rejects terms using two ExpandDeciders.

    Terms are only accepted if they are accepted by both of the specified
    ExpandDecider objects. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, first_, second_):
        """


        Compatibility method.

        Xapian::ExpandDeciderAnd::ExpandDeciderAnd(const ExpandDecider
        *first_, const ExpandDecider *second_)

        Parameters:
        -----------

        first_:  First ExpandDecider object to test with.

        second_:   ExpandDecider object to test with if first_ accepts. 
        """
        _xapian.ExpandDeciderAnd_swiginit(self, _xapian.new_ExpandDeciderAnd(first_, second_))
    __swig_destroy__ = _xapian.delete_ExpandDeciderAnd
ExpandDeciderAnd_swigregister = _xapian.ExpandDeciderAnd_swigregister
ExpandDeciderAnd_swigregister(ExpandDeciderAnd)

class ExpandDeciderFilterPrefix(ExpandDecider):
    """


    ExpandDecider subclass which restrict terms to a particular prefix.

    ExpandDeciderFilterPrefix provides an easy way to choose terms with a
    particular prefix when generating an ESet. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, prefix_):
        """


        The parameter specify the prefix of terms to be retained.

        Xapian::ExpandDeciderFilterPrefix::ExpandDeciderFilterPrefix(const
        std::string &prefix_)

        Parameters:
        -----------

        prefix_:  restrict terms to the particular prefix_ 
        """
        _xapian.ExpandDeciderFilterPrefix_swiginit(self, _xapian.new_ExpandDeciderFilterPrefix(prefix_))
    __swig_destroy__ = _xapian.delete_ExpandDeciderFilterPrefix
ExpandDeciderFilterPrefix_swigregister = _xapian.ExpandDeciderFilterPrefix_swigregister
ExpandDeciderFilterPrefix_swigregister(ExpandDeciderFilterPrefix)

class KeyMaker(object):
    """


    Virtual base class for key making functors. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Default constructor.

        Xapian::KeyMaker::KeyMaker() 
        """
        if self.__class__ == KeyMaker:
            _self = None
        else:
            _self = self
        _xapian.KeyMaker_swiginit(self, _xapian.new_KeyMaker(_self, ))
    __swig_destroy__ = _xapian.delete_KeyMaker

    def release(self):
        """


        Start reference counting this object.

        const KeyMaker* Xapian::KeyMaker::release() const

        You can hand ownership of a dynamically allocated KeyMaker object to
        Xapian by calling release() and then passing the object to a Xapian
        method. Xapian will arrange to delete the object once it is no longer
        required. 
        """
        return _xapian.KeyMaker_release(self)

    def __disown__(self):
        self.this.disown()
        _xapian.disown_KeyMaker(self)
        return weakref_proxy(self)
KeyMaker.__call__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.KeyMaker___call__)
KeyMaker.release = _xapian.SWIG_PyInstanceMethod_New(_xapian.KeyMaker_release)
KeyMaker_swigregister = _xapian.KeyMaker_swigregister
KeyMaker_swigregister(KeyMaker)

class MultiValueKeyMaker(KeyMaker):
    """


    KeyMaker subclass which combines several values.

    When the result is used for sorting, results are ordered by the first
    value. In the event of a tie, the second is used. If this is the same
    for both, the third is used, and so on. If reverse is true for a
    value, then the sort order for that value is reversed.

    When used for collapsing, the documents will only be considered equal
    if all the values specified match. If none of the specified values are
    set then the generated key will be empty, so such documents won't be
    collapsed (which is consistent with the behaviour in the "collapse on
    a value" case). If you'd prefer that documents with none of the keys
    set are collapsed together, then you can set reverse for at least one
    of the values. Other than this, it isn't useful to set reverse for
    collapsing. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Construct a MultiValueKeyMaker from a pair of iterators.

        Xapian::MultiValueKeyMaker::MultiValueKeyMaker(Iterator begin,
        Iterator end)

        The iterators must be a begin/end pair returning Xapian::valueno (or a
        compatible type) when dereferenced. 
        """
        _xapian.MultiValueKeyMaker_swiginit(self, _xapian.new_MultiValueKeyMaker())

    def add_value(self, *args):
        """


        Add a value slot to the list to build a key from.

        void Xapian::MultiValueKeyMaker::add_value(Xapian::valueno slot, bool
        reverse=false, const std::string &defvalue=std::string())

        Parameters:
        -----------

        slot:  The value slot to add

        reverse:  Adjust values from this slot to reverse their sort order
        (default: false)

        defvalue:  Value to use for documents which don't have a value set in
        this slot (default: empty). This can be used to make such documents
        sort after all others by passing get_value_upper_bound(slot) + "x"
        this is guaranteed to be greater than any value in this slot. 
        """
        return _xapian.MultiValueKeyMaker_add_value(self, *args)

    __swig_destroy__ = _xapian.delete_MultiValueKeyMaker
MultiValueKeyMaker.add_value = _xapian.SWIG_PyInstanceMethod_New(_xapian.MultiValueKeyMaker_add_value)
MultiValueKeyMaker_swigregister = _xapian.MultiValueKeyMaker_swigregister
MultiValueKeyMaker_swigregister(MultiValueKeyMaker)

RP_SUFFIX = _xapian.RP_SUFFIX
RP_REPEATED = _xapian.RP_REPEATED
RP_DATE_PREFER_MDY = _xapian.RP_DATE_PREFER_MDY
class Stopper(object):
    """


    Base class for stop-word decision functor. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Default constructor.

        Xapian::Stopper::Stopper() 
        """
        if self.__class__ == Stopper:
            _self = None
        else:
            _self = self
        _xapian.Stopper_swiginit(self, _xapian.new_Stopper(_self, ))
    __swig_destroy__ = _xapian.delete_Stopper

    def __str__(self):
        """


        Return a string describing this object.

        virtual std::string Xapian::Stopper::get_description() const 
        """
        return _xapian.Stopper___str__(self)


    def release(self):
        """


        Start reference counting this object.

        const Stopper* Xapian::Stopper::release() const

        You can hand ownership of a dynamically allocated Stopper object to
        Xapian by calling release() and then passing the object to a Xapian
        method. Xapian will arrange to delete the object once it is no longer
        required. 
        """
        return _xapian.Stopper_release(self)

    def __disown__(self):
        self.this.disown()
        _xapian.disown_Stopper(self)
        return weakref_proxy(self)
Stopper.__call__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.Stopper___call__)
Stopper.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.Stopper___str__)
Stopper.release = _xapian.SWIG_PyInstanceMethod_New(_xapian.Stopper_release)
Stopper_swigregister = _xapian.Stopper_swigregister
Stopper_swigregister(Stopper)

class SimpleStopper(Stopper):
    """


    Simple implementation of Stopper class - this will suit most users. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def add(self, word):
        """


        Add a single stop word.

        void Xapian::SimpleStopper::add(const std::string &word) 
        """
        return _xapian.SimpleStopper_add(self, word)


    def __init__(self, *args):
        """


        Initialise from a pair of iterators.

        Xapian::SimpleStopper::SimpleStopper(Iterator begin, Iterator end)

        Xapian includes stop list files for many languages. You can initialise
        from a file like that: 
        """
        _xapian.SimpleStopper_swiginit(self, _xapian.new_SimpleStopper(*args))
    __swig_destroy__ = _xapian.delete_SimpleStopper
SimpleStopper.add = _xapian.SWIG_PyInstanceMethod_New(_xapian.SimpleStopper_add)
SimpleStopper_swigregister = _xapian.SimpleStopper_swigregister
SimpleStopper_swigregister(SimpleStopper)

class RangeProcessor(object):
    """


    Base class for range processors. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Constructor.

        Xapian::RangeProcessor::RangeProcessor(Xapian::valueno slot_, const
        std::string &str_=std::string(), unsigned flags_=0)

        Parameters:
        -----------

        slot_:  Which value slot to generate ranges over.

        str_:  A string to look for to recognise values as belonging to this
        range (as a prefix by default, or as a suffix if flags
        Xapian::RP_SUFFIX is specified).

        flags_:  Zero or more of the following flags, combined with bitwise-or
        (| in C++): Xapian::RP_SUFFIX - require str_ as a suffix instead of a
        prefix.

        Xapian::RP_REPEATED - optionally allow str_ on both ends of the range
        - e.g. $1..$10 or 5m..50m. By default a prefix is only checked for on
        the start (e.g. date:1/1/1980..31/12/1989), and a suffix only on the
        end (e.g. 2..12kg). 
        """
        if self.__class__ == RangeProcessor:
            _self = None
        else:
            _self = self
        _xapian.RangeProcessor_swiginit(self, _xapian.new_RangeProcessor(_self, *args))
    __swig_destroy__ = _xapian.delete_RangeProcessor

    def check_range(self, b, e):
        """


        Check prefix/suffix on range.

        Xapian::Query Xapian::RangeProcessor::check_range(const std::string
        &b, const std::string &e)

        If they match, remove the prefix/suffix and then call operator()() to
        try to handle the range. 
        """
        return _xapian.RangeProcessor_check_range(self, b, e)


    def release(self):
        """


        Start reference counting this object.

        const RangeProcessor* Xapian::RangeProcessor::release() const

        You can hand ownership of a dynamically allocated RangeProcessor
        object to Xapian by calling release() and then passing the object to a
        Xapian method. Xapian will arrange to delete the object once it is no
        longer required. 
        """
        return _xapian.RangeProcessor_release(self)

    def __disown__(self):
        self.this.disown()
        _xapian.disown_RangeProcessor(self)
        return weakref_proxy(self)
RangeProcessor.check_range = _xapian.SWIG_PyInstanceMethod_New(_xapian.RangeProcessor_check_range)
RangeProcessor.__call__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.RangeProcessor___call__)
RangeProcessor.release = _xapian.SWIG_PyInstanceMethod_New(_xapian.RangeProcessor_release)
RangeProcessor_swigregister = _xapian.RangeProcessor_swigregister
RangeProcessor_swigregister(RangeProcessor)

class DateRangeProcessor(RangeProcessor):
    """


    Handle a date range.

    Begin and end must be dates in a recognised format. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Constructor.

        Xapian::DateRangeProcessor::DateRangeProcessor(Xapian::valueno slot_,
        const std::string &str_, unsigned flags_=0, int epoch_year_=1970)

        Parameters:
        -----------

        slot_:  The value slot number to query.

        str_:  A string to look for to recognise values as belonging to this
        date range.

        flags_:  Zero or more of the following flags, combined with bitwise-
        or: Xapian::RP_SUFFIX - require str_ as a suffix instead of a prefix.

        Xapian::RP_REPEATED - optionally allow str_ on both ends of the range
        - e.g. $1..$10 or 5m..50m. By default a prefix is only checked for on
        the start (e.g. date:1/1/1980..31/12/1989), and a suffix only on the
        end (e.g. 2..12kg).

        Xapian::RP_DATE_PREFER_MDY - interpret ambiguous dates as
        month/day/year rather than day/month/year.

        epoch_year_:  Year to use as the epoch for dates with 2 digit years
        (default: 1970, so 1/1/69 is 2069 while 1/1/70 is 1970).

        The string supplied in str_ is used by operator() to decide whether
        the pair of strings supplied to it constitute a valid range. If
        prefix_ is true, the first value in a range must begin with str_ (and
        the second value may optionally begin with str_); if prefix_ is false,
        the second value in a range must end with str_ (and the first value
        may optionally end with str_).

        If str_ is empty, the Xapian::RP_SUFFIX and Xapian::RP_REPEATED are
        irrelevant, and no special strings are required at the start or end of
        the strings defining the range.

        The remainder of both strings defining the endpoints must be valid
        dates.

        For example, if str_ is "created:", Xapian::RP_SUFFIX is not
        specified, and the range processor has been added to the queryparser,
        the queryparser will accept "created:1/1/2000..31/12/2001". 
        """
        _xapian.DateRangeProcessor_swiginit(self, _xapian.new_DateRangeProcessor(*args))
    __swig_destroy__ = _xapian.delete_DateRangeProcessor
DateRangeProcessor_swigregister = _xapian.DateRangeProcessor_swigregister
DateRangeProcessor_swigregister(DateRangeProcessor)

class NumberRangeProcessor(RangeProcessor):
    """


    Handle a number range.

    This class must be used on values which have been encoded using
    Xapian::sortable_serialise() which turns numbers into strings which
    will sort in the same order as the numbers (the same values can be
    used to implement a numeric sort). 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Constructor.

        Xapian::NumberRangeProcessor::NumberRangeProcessor(Xapian::valueno
        slot_, const std::string &str_=std::string(), unsigned flags_=0)

        Parameters:
        -----------

        slot_:  The value slot number to query.

        str_:  A string to look for to recognise values as belonging to this
        numeric range.

        flags_:  Zero or more of the following flags, combined with bitwise-
        or: Xapian::RP_SUFFIX - require str_ as a suffix instead of a prefix.

        Xapian::RP_REPEATED - optionally allow str_ on both ends of the range
        - e.g. $1..$10 or 5m..50m. By default a prefix is only checked for on
        the start (e.g. date:1/1/1980..31/12/1989), and a suffix only on the
        end (e.g. 2..12kg).

        The string supplied in str_ is used by operator() to decide whether
        the pair of strings supplied to it constitute a valid range. If
        prefix_ is true, the first value in a range must begin with str_ (and
        the second value may optionally begin with str_); if prefix_ is false,
        the second value in a range must end with str_ (and the first value
        may optionally end with str_).

        If str_ is empty, the setting of prefix_ is irrelevant, and no special
        strings are required at the start or end of the strings defining the
        range.

        The remainder of both strings defining the endpoints must be valid
        floating point numbers. (FIXME: define format recognised).

        For example, if str_ is "$" and prefix_ is true, and the range
        processor has been added to the queryparser, the queryparser will
        accept "$10..50" or "$10..$50", but not "10..50" or "10..$50"
        as valid ranges. If str_ is "kg" and prefix_ is false, the
        queryparser will accept "10..50kg" or "10kg..50kg", but not
        "10..50" or "10kg..50" as valid ranges. 
        """
        _xapian.NumberRangeProcessor_swiginit(self, _xapian.new_NumberRangeProcessor(*args))
    __swig_destroy__ = _xapian.delete_NumberRangeProcessor
NumberRangeProcessor_swigregister = _xapian.NumberRangeProcessor_swigregister
NumberRangeProcessor_swigregister(NumberRangeProcessor)

class ValueRangeProcessor(object):
    """


    Base class for value range processors. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Default constructor.

        Xapian::ValueRangeProcessor::ValueRangeProcessor() 
        """
        if self.__class__ == ValueRangeProcessor:
            _self = None
        else:
            _self = self
        _xapian.ValueRangeProcessor_swiginit(self, _xapian.new_ValueRangeProcessor(_self, ))
    __swig_destroy__ = _xapian.delete_ValueRangeProcessor

    def release(self):
        """


        Start reference counting this object.

        const ValueRangeProcessor* Xapian::ValueRangeProcessor::release()
        const

        You can hand ownership of a dynamically allocated ValueRangeProcessor
        object to Xapian by calling release() and then passing the object to a
        Xapian method. Xapian will arrange to delete the object once it is no
        longer required. 
        """
        return _xapian.ValueRangeProcessor_release(self)

    def __disown__(self):
        self.this.disown()
        _xapian.disown_ValueRangeProcessor(self)
        return weakref_proxy(self)
ValueRangeProcessor.__call__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValueRangeProcessor___call__)
ValueRangeProcessor.release = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValueRangeProcessor_release)
ValueRangeProcessor_swigregister = _xapian.ValueRangeProcessor_swigregister
ValueRangeProcessor_swigregister(ValueRangeProcessor)

class StringValueRangeProcessor(ValueRangeProcessor):
    """


    Handle a string range.

    The end points can be any strings.

    Deprecated Use Xapian::RangeProcessor instead (added in 1.3.6). 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Constructor.

        Xapian::StringValueRangeProcessor::StringValueRangeProcessor(Xapian::valueno
        slot_, const std::string &str_, bool prefix_=true)

        Parameters:
        -----------

        slot_:  The value number to return from operator().

        str_:  A string to look for to recognise values as belonging to this
        range.

        prefix_:  Flag specifying whether to check for str_ as a prefix or a
        suffix. 
        """
        _xapian.StringValueRangeProcessor_swiginit(self, _xapian.new_StringValueRangeProcessor(*args))
    __swig_destroy__ = _xapian.delete_StringValueRangeProcessor
StringValueRangeProcessor_swigregister = _xapian.StringValueRangeProcessor_swigregister
StringValueRangeProcessor_swigregister(StringValueRangeProcessor)

class DateValueRangeProcessor(StringValueRangeProcessor):
    """


    Handle a date range.

    Begin and end must be dates in a recognised format.

    Deprecated Use Xapian::DateRangeProcessor instead (added in 1.3.6). 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Constructor.

        Xapian::DateValueRangeProcessor::DateValueRangeProcessor(Xapian::valueno
        slot_, const char *str_, bool prefix_=true, bool prefer_mdy_=false,
        int epoch_year_=1970)

        This is like the previous version, but with const char * instead of
        std::string - we need this overload as otherwise
        DateValueRangeProcessor(1, "date:") quietly interprets the second
        argument as a boolean in preference to std::string. If you want to be
        compatible with 1.2.12 and earlier, then explicitly convert to
        std::string, i.e.: DateValueRangeProcessor(1, std::string("date:"))

        Parameters:
        -----------

        slot_:  The value number to return from operator().

        str_:  A string to look for to recognise values as belonging to this
        date range.

        prefix_:  Whether to look for the string at the start or end of the
        values. If true, the string is a prefix; if false, the string is a
        suffix (default: true).

        prefer_mdy_:  Should ambiguous dates be interpreted as month/day/year
        rather than day/month/year? (default: false)

        epoch_year_:  Year to use as the epoch for dates with 2 digit years
        (default: 1970, so 1/1/69 is 2069 while 1/1/70 is 1970).

        The string supplied in str_ is used by operator() to decide whether
        the pair of strings supplied to it constitute a valid range. If
        prefix_ is true, the first value in a range must begin with str_ (and
        the second value may optionally begin with str_); if prefix_ is false,
        the second value in a range must end with str_ (and the first value
        may optionally end with str_).

        If str_ is empty, the setting of prefix_ is irrelevant, and no special
        strings are required at the start or end of the strings defining the
        range.

        The remainder of both strings defining the endpoints must be valid
        dates.

        For example, if str_ is "created:" and prefix_ is true, and the
        range processor has been added to the queryparser, the queryparser
        will accept "created:1/1/2000..31/12/2001". 
        """
        _xapian.DateValueRangeProcessor_swiginit(self, _xapian.new_DateValueRangeProcessor(*args))
    __swig_destroy__ = _xapian.delete_DateValueRangeProcessor
DateValueRangeProcessor_swigregister = _xapian.DateValueRangeProcessor_swigregister
DateValueRangeProcessor_swigregister(DateValueRangeProcessor)

class NumberValueRangeProcessor(StringValueRangeProcessor):
    """


    Handle a number range.

    This class must be used on values which have been encoded using
    Xapian::sortable_serialise() which turns numbers into strings which
    will sort in the same order as the numbers (the same values can be
    used to implement a numeric sort).

    Deprecated Use Xapian::NumberRangeProcessor instead (added in 1.3.6).

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Constructor.

        Xapian::NumberValueRangeProcessor::NumberValueRangeProcessor(Xapian::valueno
        slot_, const std::string &str_, bool prefix_=true)

        Parameters:
        -----------

        slot_:  The value number to return from operator().

        str_:  A string to look for to recognise values as belonging to this
        numeric range.

        prefix_:  Whether to look for the string at the start or end of the
        values. If true, the string is a prefix; if false, the string is a
        suffix (default: true).

        The string supplied in str_ is used by operator() to decide whether
        the pair of strings supplied to it constitute a valid range. If
        prefix_ is true, the first value in a range must begin with str_ (and
        the second value may optionally begin with str_); if prefix_ is false,
        the second value in a range must end with str_ (and the first value
        may optionally end with str_).

        If str_ is empty, the setting of prefix_ is irrelevant, and no special
        strings are required at the start or end of the strings defining the
        range.

        The remainder of both strings defining the endpoints must be valid
        floating point numbers. (FIXME: define format recognised).

        For example, if str_ is "$" and prefix_ is true, and the range
        processor has been added to the queryparser, the queryparser will
        accept "$10..50" or "$10..$50", but not "10..50" or "10..$50"
        as valid ranges. If str_ is "kg" and prefix_ is false, the
        queryparser will accept "10..50kg" or "10kg..50kg", but not
        "10..50" or "10kg..50" as valid ranges. 
        """
        _xapian.NumberValueRangeProcessor_swiginit(self, _xapian.new_NumberValueRangeProcessor(*args))
    __swig_destroy__ = _xapian.delete_NumberValueRangeProcessor
NumberValueRangeProcessor_swigregister = _xapian.NumberValueRangeProcessor_swigregister
NumberValueRangeProcessor_swigregister(NumberValueRangeProcessor)

class FieldProcessor(object):
    """


    Base class for field processors. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Default constructor.

        Xapian::FieldProcessor::FieldProcessor() 
        """
        if self.__class__ == FieldProcessor:
            _self = None
        else:
            _self = self
        _xapian.FieldProcessor_swiginit(self, _xapian.new_FieldProcessor(_self, ))
    __swig_destroy__ = _xapian.delete_FieldProcessor

    def release(self):
        """


        Start reference counting this object.

        const FieldProcessor* Xapian::FieldProcessor::release() const

        You can hand ownership of a dynamically allocated FieldProcessor
        object to Xapian by calling release() and then passing the object to a
        Xapian method. Xapian will arrange to delete the object once it is no
        longer required. 
        """
        return _xapian.FieldProcessor_release(self)

    def __disown__(self):
        self.this.disown()
        _xapian.disown_FieldProcessor(self)
        return weakref_proxy(self)
FieldProcessor.__call__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.FieldProcessor___call__)
FieldProcessor.release = _xapian.SWIG_PyInstanceMethod_New(_xapian.FieldProcessor_release)
FieldProcessor_swigregister = _xapian.FieldProcessor_swigregister
FieldProcessor_swigregister(FieldProcessor)

class QueryParser(object):
    """


    Build a Xapian::Query object from a user query string. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    FLAG_BOOLEAN = _xapian.QueryParser_FLAG_BOOLEAN
    FLAG_PHRASE = _xapian.QueryParser_FLAG_PHRASE
    FLAG_LOVEHATE = _xapian.QueryParser_FLAG_LOVEHATE
    FLAG_BOOLEAN_ANY_CASE = _xapian.QueryParser_FLAG_BOOLEAN_ANY_CASE
    FLAG_WILDCARD = _xapian.QueryParser_FLAG_WILDCARD
    FLAG_PURE_NOT = _xapian.QueryParser_FLAG_PURE_NOT
    FLAG_PARTIAL = _xapian.QueryParser_FLAG_PARTIAL
    FLAG_SPELLING_CORRECTION = _xapian.QueryParser_FLAG_SPELLING_CORRECTION
    FLAG_SYNONYM = _xapian.QueryParser_FLAG_SYNONYM
    FLAG_AUTO_SYNONYMS = _xapian.QueryParser_FLAG_AUTO_SYNONYMS
    FLAG_AUTO_MULTIWORD_SYNONYMS = _xapian.QueryParser_FLAG_AUTO_MULTIWORD_SYNONYMS
    FLAG_CJK_NGRAM = _xapian.QueryParser_FLAG_CJK_NGRAM
    FLAG_DEFAULT = _xapian.QueryParser_FLAG_DEFAULT
    STEM_NONE = _xapian.QueryParser_STEM_NONE
    STEM_SOME = _xapian.QueryParser_STEM_SOME
    STEM_ALL = _xapian.QueryParser_STEM_ALL
    STEM_ALL_Z = _xapian.QueryParser_STEM_ALL_Z
    STEM_SOME_FULL_POS = _xapian.QueryParser_STEM_SOME_FULL_POS

    def __init__(self):
        """


        Default constructor.

        Xapian::QueryParser::QueryParser() 
        """
        _xapian.QueryParser_swiginit(self, _xapian.new_QueryParser())
    __swig_destroy__ = _xapian.delete_QueryParser

    def set_stemmer(self, stemmer):
        """


        Set the stemmer.

        void Xapian::QueryParser::set_stemmer(const Xapian::Stem &stemmer)

        This sets the stemming algorithm which will be used by the query
        parser. The stemming algorithm will be used according to the stemming
        strategy set by set_stemming_strategy(). As of 1.3.1, this defaults to
        STEM_SOME, but in earlier versions the default was STEM_NONE. If you
        want to work with older versions, you should explicitly set a stemming
        strategy as well as setting a stemmer, otherwise your stemmer won't
        actually be used.

        Parameters:
        -----------

        stemmer:  The Xapian::Stem object to set. 
        """
        return _xapian.QueryParser_set_stemmer(self, stemmer)


    def set_stemming_strategy(self, strategy):
        """


        Set the stemming strategy.

        void Xapian::QueryParser::set_stemming_strategy(stem_strategy
        strategy)

        This controls how the query parser will apply the stemming algorithm.
        Note that the stemming algorithm is only applied to words in free-text
        fields - boolean filter terms are never stemmed.

        Parameters:
        -----------

        strategy:  The strategy to use - possible values are: STEM_NONE: Don't
        perform any stemming. (default in Xapian <= 1.3.0)

        STEM_SOME: Stem all terms except for those which start with a capital
        letter, or are followed by certain characters (currently: (/@<>=*[{"
        ), or are used with operators which need positional information.
        Stemmed terms are prefixed with 'Z'. (default in Xapian >= 1.3.1)

        STEM_SOME_FULL_POS: Like STEM_SOME but also stems terms used with
        operators which need positional information. Added in Xapian 1.4.8.

        STEM_ALL: Stem all terms (note: no 'Z' prefix is added).

        STEM_ALL_Z: Stem all terms (note: 'Z' prefix is added). (new in Xapian
        1.2.11 and 1.3.1) 
        """
        return _xapian.QueryParser_set_stemming_strategy(self, strategy)


    def set_stopper(self, stop=None):
        """


        Set the stopper.

        void Xapian::QueryParser::set_stopper(const Stopper *stop=NULL)

        Parameters:
        -----------

        stop:  The Stopper object to set (default NULL, which means no
        stopwords). 
        """
        return _xapian.QueryParser_set_stopper(self, stop)


    def set_default_op(self, default_op):
        """


        Set the default operator.

        void Xapian::QueryParser::set_default_op(Query::op default_op)

        Parameters:
        -----------

        default_op:  The operator to use to combine non-filter query items
        when no explicit operator is used.

        So for example, 'weather forecast' is parsed as if it were 'weather OR
        forecast' by default.

        The most useful values for this are OP_OR (the default) and OP_AND.
        OP_NEAR, OP_PHRASE, OP_ELITE_SET, OP_SYNONYM and OP_MAX are also
        permitted. Passing other values will result in InvalidArgumentError
        being thrown. 
        """
        return _xapian.QueryParser_set_default_op(self, default_op)


    def get_default_op(self):
        """


        Get the current default operator.

        Query::op Xapian::QueryParser::get_default_op() const 
        """
        return _xapian.QueryParser_get_default_op(self)


    def set_database(self, db):
        """


        Specify the database being searched.

        void Xapian::QueryParser::set_database(const Database &db)

        Parameters:
        -----------

        db:  The database to use for spelling correction
        (FLAG_SPELLING_CORRECTION), and synonyms (FLAG_SYNONYM,
        FLAG_AUTO_SYNONYMS, and FLAG_AUTO_MULTIWORD_SYNONYMS). 
        """
        return _xapian.QueryParser_set_database(self, db)


    def set_max_expansion(self, *args):
        """


        Specify the maximum expansion of a wildcard and/or partial term.

        void Xapian::QueryParser::set_max_expansion(Xapian::termcount
        max_expansion, int max_type=Xapian::Query::WILDCARD_LIMIT_ERROR,
        unsigned flags=FLAG_WILDCARD|FLAG_PARTIAL)

        Note: you must also set FLAG_WILDCARD and/or FLAG_PARTIAL in the flags
        parameter to  parse_query() for this setting to have anything to
        affect.

        If you don't call this method, the default settings are no limit on
        wildcard expansion, and partial terms expanding to the most frequent
        100 terms - i.e. as if you'd called:

        set_max_expansion(0); set_max_expansion(100,
        Xapian::Query::WILDCARD_LIMIT_MOST_FREQUENT,
        Xapian::QueryParser::FLAG_PARTIAL);

        Parameters:
        -----------

        max_expansion:  The maximum number of terms each wildcard in the query
        can expand to, or 0 for no limit (which is the default).

        max_type:    Xapian::Query::WILDCARD_LIMIT_ERROR,
        Xapian::Query::WILDCARD_LIMIT_FIRST or
        Xapian::Query::WILDCARD_LIMIT_MOST_FREQUENT (default:
        Xapian::Query::WILDCARD_LIMIT_ERROR).

        flags:  What to set the limit for (default:
        FLAG_WILDCARD|FLAG_PARTIAL, setting the limit for both wildcards and
        partial terms).

        1.3.3 
        """
        return _xapian.QueryParser_set_max_expansion(self, *args)


    def set_max_wildcard_expansion(self, arg2):
        """


        Specify the maximum expansion of a wildcard.

        void
        Xapian::QueryParser::set_max_wildcard_expansion(Xapian::termcount)

        If any wildcard expands to more than max_expansion terms, an exception
        will be thrown.

        This method is provided for API compatibility with Xapian 1.2.x and is
        deprecated - replace it with:

        set_max_wildcard_expansion(max_expansion,
        Xapian::Query::WILDCARD_LIMIT_ERROR,
        Xapian::QueryParser::FLAG_WILDCARD); 
        """
        return _xapian.QueryParser_set_max_wildcard_expansion(self, arg2)


    def parse_query(self, *args):
        """


        Parse a query.

        Query Xapian::QueryParser::parse_query(const std::string
        &query_string, unsigned flags=FLAG_DEFAULT, const std::string
        &default_prefix=std::string())

        Parameters:
        -----------

        query_string:  A free-text query as entered by a user

        flags:  Zero or more QueryParser::feature_flag specifying what
        features the QueryParser should support. Combine multiple values with
        bitwise-or (|) (default FLAG_DEFAULT).

        default_prefix:  The default term prefix to use (default none). For
        example, you can pass "A" when parsing an "Author" field.

        Parameters:
        -----------

        If:  the query string can't be parsed, then Xapian::QueryParserError
        is thrown. You can get an English error message to report to the user
        by catching it and calling get_msg() on the caught exception. The
        current possible values (in case you want to translate them) are:

        Unknown range operation

        parse error

        Syntax: <expression> AND <expression>

        Syntax: <expression> AND NOT <expression>

        Syntax: <expression> NOT <expression>

        Syntax: <expression> OR <expression>

        Syntax: <expression> XOR <expression> 
        """
        return _xapian.QueryParser_parse_query(self, *args)


    def add_prefix(self, *args):
        """


        Register a FieldProcessor.

        void Xapian::QueryParser::add_prefix(const std::string &field,
        Xapian::FieldProcessor *proc) 
        """
        return _xapian.QueryParser_add_prefix(self, *args)


    def add_boolean_prefix(self, *args):
        """


        Register a FieldProcessor for a boolean prefix.

        void Xapian::QueryParser::add_boolean_prefix(const std::string &field,
        Xapian::FieldProcessor *proc, bool exclusive)

        This is an older version of this method - use the version with the
        grouping parameter in preference to this one. 
        """
        return _xapian.QueryParser_add_boolean_prefix(self, *args)


    def _stoplist_begin(self):
        """


        Begin iterator over terms omitted from the query as stopwords.

        TermIterator Xapian::QueryParser::stoplist_begin() const 
        """
        return _xapian.QueryParser__stoplist_begin(self)


    def _stoplist_end(self):
        """


        End iterator over terms omitted from the query as stopwords.

        TermIterator Xapian::QueryParser::stoplist_end() const 
        """
        return _xapian.QueryParser__stoplist_end(self)


    def _unstem_begin(self, term):
        """


        Begin iterator over unstemmed forms of the given stemmed query term.

        TermIterator Xapian::QueryParser::unstem_begin(const std::string
        &term) const 
        """
        return _xapian.QueryParser__unstem_begin(self, term)


    def _unstem_end(self, arg2):
        """


        End iterator over unstemmed forms of the given stemmed query term.

        TermIterator Xapian::QueryParser::unstem_end(const std::string &)
        const 
        """
        return _xapian.QueryParser__unstem_end(self, arg2)


    def add_rangeprocessor(self, range_proc, grouping=None):
        """


        Register a RangeProcessor.

        void Xapian::QueryParser::add_rangeprocessor(Xapian::RangeProcessor
        *range_proc, const std::string *grouping=NULL) 
        """
        return _xapian.QueryParser_add_rangeprocessor(self, range_proc, grouping)


    def add_valuerangeprocessor(self, vrproc):
        """


        Register a ValueRangeProcessor.

        void
        Xapian::QueryParser::add_valuerangeprocessor(Xapian::ValueRangeProcessor
        *vrproc)

        This method is provided for API compatibility with Xapian 1.2.x and is
        deprecated - use  add_rangeprocessor() with a RangeProcessor instead.

        Compatibility shim. 
        """
        return _xapian.QueryParser_add_valuerangeprocessor(self, vrproc)


    def get_corrected_query_string(self):
        """


        Get the spelling-corrected query string.

        std::string Xapian::QueryParser::get_corrected_query_string() const

        This will only be set if FLAG_SPELLING_CORRECTION is specified when
        QueryParser::parse_query() was last called.

        If there were no corrections, an empty string is returned. 
        """
        return _xapian.QueryParser_get_corrected_query_string(self)


    def __str__(self):
        """


        Return a string describing this object.

        std::string Xapian::QueryParser::get_description() const 
        """
        return _xapian.QueryParser___str__(self)

QueryParser.set_stemmer = _xapian.SWIG_PyInstanceMethod_New(_xapian.QueryParser_set_stemmer)
QueryParser.set_stemming_strategy = _xapian.SWIG_PyInstanceMethod_New(_xapian.QueryParser_set_stemming_strategy)
QueryParser.set_stopper = _xapian.SWIG_PyInstanceMethod_New(_xapian.QueryParser_set_stopper)
QueryParser.set_default_op = _xapian.SWIG_PyInstanceMethod_New(_xapian.QueryParser_set_default_op)
QueryParser.get_default_op = _xapian.SWIG_PyInstanceMethod_New(_xapian.QueryParser_get_default_op)
QueryParser.set_database = _xapian.SWIG_PyInstanceMethod_New(_xapian.QueryParser_set_database)
QueryParser.set_max_expansion = _xapian.SWIG_PyInstanceMethod_New(_xapian.QueryParser_set_max_expansion)
QueryParser.set_max_wildcard_expansion = _xapian.SWIG_PyInstanceMethod_New(_xapian.QueryParser_set_max_wildcard_expansion)
QueryParser.parse_query = _xapian.SWIG_PyInstanceMethod_New(_xapian.QueryParser_parse_query)
QueryParser.add_prefix = _xapian.SWIG_PyInstanceMethod_New(_xapian.QueryParser_add_prefix)
QueryParser.add_boolean_prefix = _xapian.SWIG_PyInstanceMethod_New(_xapian.QueryParser_add_boolean_prefix)
QueryParser._stoplist_begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.QueryParser__stoplist_begin)
QueryParser._stoplist_end = _xapian.SWIG_PyInstanceMethod_New(_xapian.QueryParser__stoplist_end)
QueryParser._unstem_begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.QueryParser__unstem_begin)
QueryParser._unstem_end = _xapian.SWIG_PyInstanceMethod_New(_xapian.QueryParser__unstem_end)
QueryParser.add_rangeprocessor = _xapian.SWIG_PyInstanceMethod_New(_xapian.QueryParser_add_rangeprocessor)
QueryParser.add_valuerangeprocessor = _xapian.SWIG_PyInstanceMethod_New(_xapian.QueryParser_add_valuerangeprocessor)
QueryParser.get_corrected_query_string = _xapian.SWIG_PyInstanceMethod_New(_xapian.QueryParser_get_corrected_query_string)
QueryParser.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.QueryParser___str__)
QueryParser_swigregister = _xapian.QueryParser_swigregister
QueryParser_swigregister(QueryParser)


def sortable_serialise(value):
    return _xapian.sortable_serialise(value)
sortable_serialise = _xapian.sortable_serialise

def sortable_unserialise(serialised):
    return _xapian.sortable_unserialise(serialised)
sortable_unserialise = _xapian.sortable_unserialise
class ValueSetMatchDecider(MatchDecider):
    """


    MatchDecider filtering results based on whether document values are in
    a user- defined set. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, slot, inclusive_):
        """


        Construct a ValueSetMatchDecider.

        Xapian::ValueSetMatchDecider::ValueSetMatchDecider(Xapian::valueno
        slot, bool inclusive_)

        Parameters:
        -----------

        slot:  The value slot number to look in.

        inclusive_:  If true, match decider accepts documents which have a
        value in the specified slot which is a member of the test set; if
        false, match decider accepts documents which do not have a value in
        the specified slot. 
        """
        _xapian.ValueSetMatchDecider_swiginit(self, _xapian.new_ValueSetMatchDecider(slot, inclusive_))

    def add_value(self, value):
        """


        Add a value to the test set.

        void Xapian::ValueSetMatchDecider::add_value(const std::string &value)

        Parameters:
        -----------

        value:  The value to add to the test set. 
        """
        return _xapian.ValueSetMatchDecider_add_value(self, value)


    def remove_value(self, value):
        """


        Remove a value from the test set.

        void Xapian::ValueSetMatchDecider::remove_value(const std::string
        &value)

        Parameters:
        -----------

        value:  The value to remove from the test set. 
        """
        return _xapian.ValueSetMatchDecider_remove_value(self, value)

    __swig_destroy__ = _xapian.delete_ValueSetMatchDecider
ValueSetMatchDecider.add_value = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValueSetMatchDecider_add_value)
ValueSetMatchDecider.remove_value = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValueSetMatchDecider_remove_value)
ValueSetMatchDecider_swigregister = _xapian.ValueSetMatchDecider_swigregister
ValueSetMatchDecider_swigregister(ValueSetMatchDecider)

class Weight(object):
    """


    Abstract base class for weighting schemes. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    TWO_STAGE_SMOOTHING = _xapian.Weight_TWO_STAGE_SMOOTHING
    DIRICHLET_SMOOTHING = _xapian.Weight_DIRICHLET_SMOOTHING
    ABSOLUTE_DISCOUNT_SMOOTHING = _xapian.Weight_ABSOLUTE_DISCOUNT_SMOOTHING
    JELINEK_MERCER_SMOOTHING = _xapian.Weight_JELINEK_MERCER_SMOOTHING
    DIRICHLET_PLUS_SMOOTHING = _xapian.Weight_DIRICHLET_PLUS_SMOOTHING
    __swig_destroy__ = _xapian.delete_Weight

    def name(self):
        """


        Return the name of this weighting scheme.

        virtual std::string Xapian::Weight::name() const

        This name is used by the remote backend. It is passed along with the
        serialised parameters to the remote server so that it knows which
        class to create.

        Return the full namespace-qualified name of your class here - if your
        class is called FooWeight, return "FooWeight" from this method (
        Xapian::BM25Weight returns "Xapian::BM25Weight" here).

        If you don't want to support the remote backend, you can use the
        default implementation which simply returns an empty string. 
        """
        return _xapian.Weight_name(self)


    def get_sumpart(self, wdf, doclen, uniqterms):
        """


        Calculate the weight contribution for this object's term to a
        document.

        virtual double Xapian::Weight::get_sumpart(Xapian::termcount wdf,
        Xapian::termcount doclen, Xapian::termcount uniqterms) const =0

        The parameters give information about the document which may be used
        in the calculations:

        Parameters:
        -----------

        wdf:  The within document frequency of the term in the document.

        doclen:  The document's length (unnormalised).

        uniqterms:  Number of unique terms in the document (used for absolute
        smoothing). 
        """
        return _xapian.Weight_get_sumpart(self, wdf, doclen, uniqterms)


    def get_maxpart(self):
        """


        Return an upper bound on what get_sumpart() can return for any
        document.

        virtual double Xapian::Weight::get_maxpart() const =0

        This information is used by the matcher to perform various
        optimisations, so strive to make the bound as tight as possible. 
        """
        return _xapian.Weight_get_maxpart(self)


    def get_sumextra(self, doclen, uniqterms):
        """


        Calculate the term-independent weight component for a document.

        virtual double Xapian::Weight::get_sumextra(Xapian::termcount doclen,
        Xapian::termcount uniqterms) const =0

        The parameter gives information about the document which may be used
        in the calculations:

        Parameters:
        -----------

        doclen:  The document's length (unnormalised).

        uniqterms:  The number of unique terms in the document. 
        """
        return _xapian.Weight_get_sumextra(self, doclen, uniqterms)


    def get_maxextra(self):
        """


        Return an upper bound on what get_sumextra() can return for any
        document.

        virtual double Xapian::Weight::get_maxextra() const =0

        This information is used by the matcher to perform various
        optimisations, so strive to make the bound as tight as possible. 
        """
        return _xapian.Weight_get_maxextra(self)

Weight.name = _xapian.SWIG_PyInstanceMethod_New(_xapian.Weight_name)
Weight.get_sumpart = _xapian.SWIG_PyInstanceMethod_New(_xapian.Weight_get_sumpart)
Weight.get_maxpart = _xapian.SWIG_PyInstanceMethod_New(_xapian.Weight_get_maxpart)
Weight.get_sumextra = _xapian.SWIG_PyInstanceMethod_New(_xapian.Weight_get_sumextra)
Weight.get_maxextra = _xapian.SWIG_PyInstanceMethod_New(_xapian.Weight_get_maxextra)
Weight_swigregister = _xapian.Weight_swigregister
Weight_swigregister(Weight)

class BoolWeight(Weight):
    """


    Class implementing a "boolean" weighting scheme.

    This weighting scheme gives all documents zero weight. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Construct a BoolWeight.

        Xapian::BoolWeight::BoolWeight() 
        """
        _xapian.BoolWeight_swiginit(self, _xapian.new_BoolWeight())
    __swig_destroy__ = _xapian.delete_BoolWeight
BoolWeight_swigregister = _xapian.BoolWeight_swigregister
BoolWeight_swigregister(BoolWeight)

class TfIdfWeight(Weight):
    """


    Xapian::Weight subclass implementing the tf-idf weighting scheme. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct a TfIdfWeight using the default normalizations ("ntn").

        Xapian::TfIdfWeight::TfIdfWeight() 
        """
        _xapian.TfIdfWeight_swiginit(self, _xapian.new_TfIdfWeight(*args))
    __swig_destroy__ = _xapian.delete_TfIdfWeight
TfIdfWeight_swigregister = _xapian.TfIdfWeight_swigregister
TfIdfWeight_swigregister(TfIdfWeight)

class BM25Weight(Weight):
    """


    Xapian::Weight subclass implementing the BM25 probabilistic formula.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """Xapian::BM25Weight::BM25Weight() """
        _xapian.BM25Weight_swiginit(self, _xapian.new_BM25Weight(*args))
    __swig_destroy__ = _xapian.delete_BM25Weight
BM25Weight_swigregister = _xapian.BM25Weight_swigregister
BM25Weight_swigregister(BM25Weight)

class BM25PlusWeight(Weight):
    """


    Xapian::Weight subclass implementing the BM25+ probabilistic formula.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """Xapian::BM25PlusWeight::BM25PlusWeight() """
        _xapian.BM25PlusWeight_swiginit(self, _xapian.new_BM25PlusWeight(*args))
    __swig_destroy__ = _xapian.delete_BM25PlusWeight
BM25PlusWeight_swigregister = _xapian.BM25PlusWeight_swigregister
BM25PlusWeight_swigregister(BM25PlusWeight)

class TradWeight(Weight):
    """


    Xapian::Weight subclass implementing the traditional probabilistic
    formula.

    This class implements the "traditional" Probabilistic Weighting
    scheme, as described by the early papers on Probabilistic Retrieval.
    BM25 generally gives better results.

    TradWeight(k) is equivalent to BM25Weight(k, 0, 0, 1, 0), except that
    the latter returns weights (k+1) times larger. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, k=1.0):
        """


        Construct a TradWeight.

        Xapian::TradWeight::TradWeight(double k=1.0)

        Parameters:
        -----------

        k:  A non-negative parameter controlling how influential within-
        document- frequency (wdf) and document length are. k=0 means that wdf
        and document length don't affect the weights. The larger k is, the
        more they do. (default 1) 
        """
        _xapian.TradWeight_swiginit(self, _xapian.new_TradWeight(k))
    __swig_destroy__ = _xapian.delete_TradWeight
TradWeight_swigregister = _xapian.TradWeight_swigregister
TradWeight_swigregister(TradWeight)

class InL2Weight(Weight):
    """


    This class implements the InL2 weighting scheme.

    InL2 is a representative scheme of the Divergence from Randomness
    Framework by Gianni Amati.

    This weighting scheme is useful for tasks that require early
    precision.

    It uses the Inverse document frequency model (In), the Laplace method
    to find the aftereffect of sampling (L) and the second wdf
    normalization proposed by Amati to normalize the wdf in the document
    to the length of the document (H2).

    For more information about the DFR Framework and the InL2 scheme,
    please refer to: Gianni Amati and Cornelis Joost Van Rijsbergen
    Probabilistic models of information retrieval based on measuring the
    divergence from randomness ACM Transactions on Information Systems
    (TOIS) 20, (4), 2002, pp. 357-389. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """Xapian::InL2Weight::InL2Weight() """
        _xapian.InL2Weight_swiginit(self, _xapian.new_InL2Weight(*args))
    __swig_destroy__ = _xapian.delete_InL2Weight
InL2Weight_swigregister = _xapian.InL2Weight_swigregister
InL2Weight_swigregister(InL2Weight)

class IfB2Weight(Weight):
    """


    This class implements the IfB2 weighting scheme.

    IfB2 is a representative scheme of the Divergence from Randomness
    Framework by Gianni Amati.

    It uses the Inverse term frequency model (If), the Bernoulli method to
    find the aftereffect of sampling (B) and the second wdf normalization
    proposed by Amati to normalize the wdf in the document to the length
    of the document (H2).

    For more information about the DFR Framework and the IfB2 scheme,
    please refer to: Gianni Amati and Cornelis Joost Van Rijsbergen
    Probabilistic models of information retrieval based on measuring the
    divergence from randomness ACM Transactions on Information Systems
    (TOIS) 20, (4), 2002, pp. 357-389. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """Xapian::IfB2Weight::IfB2Weight() """
        _xapian.IfB2Weight_swiginit(self, _xapian.new_IfB2Weight(*args))
    __swig_destroy__ = _xapian.delete_IfB2Weight
IfB2Weight_swigregister = _xapian.IfB2Weight_swigregister
IfB2Weight_swigregister(IfB2Weight)

class IneB2Weight(Weight):
    """


    This class implements the IneB2 weighting scheme.

    IneB2 is a representative scheme of the Divergence from Randomness
    Framework by Gianni Amati.

    It uses the Inverse expected document frequency model (Ine), the
    Bernoulli method to find the aftereffect of sampling (B) and the
    second wdf normalization proposed by Amati to normalize the wdf in the
    document to the length of the document (H2).

    For more information about the DFR Framework and the IneB2 scheme,
    please refer to: Gianni Amati and Cornelis Joost Van Rijsbergen
    Probabilistic models of information retrieval based on measuring the
    divergence from randomness ACM Transactions on Information Systems
    (TOIS) 20, (4), 2002, pp. 357-389. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """Xapian::IneB2Weight::IneB2Weight() """
        _xapian.IneB2Weight_swiginit(self, _xapian.new_IneB2Weight(*args))
    __swig_destroy__ = _xapian.delete_IneB2Weight
IneB2Weight_swigregister = _xapian.IneB2Weight_swigregister
IneB2Weight_swigregister(IneB2Weight)

class BB2Weight(Weight):
    """


    This class implements the BB2 weighting scheme.

    BB2 is a representative scheme of the Divergence from Randomness
    Framework by Gianni Amati.

    It uses the Bose-Einstein probabilistic distribution (B) along with
    Stirling's power approximation, the Bernoulli method to find the
    aftereffect of sampling (B) and the second wdf normalization proposed
    by Amati to normalize the wdf in the document to the length of the
    document (H2).

    For more information about the DFR Framework and the BB2 scheme,
    please refer to : Gianni Amati and Cornelis Joost Van Rijsbergen
    Probabilistic models of information retrieval based on measuring the
    divergence from randomness ACM Transactions on Information Systems
    (TOIS) 20, (4), 2002, pp. 357-389. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """Xapian::BB2Weight::BB2Weight() """
        _xapian.BB2Weight_swiginit(self, _xapian.new_BB2Weight(*args))
    __swig_destroy__ = _xapian.delete_BB2Weight
BB2Weight_swigregister = _xapian.BB2Weight_swigregister
BB2Weight_swigregister(BB2Weight)

class DLHWeight(Weight):
    """


    This class implements the DLH weighting scheme, which is a
    representative scheme of the Divergence from Randomness Framework by
    Gianni Amati.

    This is a parameter free weighting scheme and it should be used with
    query expansion to obtain better results. It uses the HyperGeometric
    Probabilistic model and Laplace's normalization to calculate the risk
    gain.

    For more information about the DFR Framework and the DLH scheme,
    please refer to : a.) Gianni Amati and Cornelis Joost Van Rijsbergen
    Probabilistic models of information retrieval based on measuring the
    divergence from randomness ACM Transactions on Information Systems
    (TOIS) 20, (4), 2002, pp. 357-389. b.) FUB, IASI-CNR and University of
    Tor Vergata at TREC 2007 Blog Track. G. Amati and E. Ambrosi and M.
    Bianchi and C. Gaibisso and G. Gambosi. Proceedings of the 16th Text
    REtrieval Conference (TREC-2007), 2008. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """Xapian::DLHWeight::DLHWeight() """
        _xapian.DLHWeight_swiginit(self, _xapian.new_DLHWeight())
    __swig_destroy__ = _xapian.delete_DLHWeight
DLHWeight_swigregister = _xapian.DLHWeight_swigregister
DLHWeight_swigregister(DLHWeight)

class PL2Weight(Weight):
    """


    This class implements the PL2 weighting scheme.

    PL2 is a representative scheme of the Divergence from Randomness
    Framework by Gianni Amati.

    This weighting scheme is useful for tasks that require early
    precision.

    It uses the Poisson approximation of the Binomial Probabilistic
    distribution (P) along with Stirling's approximation for the factorial
    value, the Laplace method to find the aftereffect of sampling (L) and
    the second wdf normalization proposed by Amati to normalize the wdf in
    the document to the length of the document (H2).

    For more information about the DFR Framework and the PL2 scheme,
    please refer to : Gianni Amati and Cornelis Joost Van Rijsbergen
    Probabilistic models of information retrieval based on measuring the
    divergence from randomness ACM Transactions on Information Systems
    (TOIS) 20, (4), 2002, pp. 357-389. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """Xapian::PL2Weight::PL2Weight() """
        _xapian.PL2Weight_swiginit(self, _xapian.new_PL2Weight(*args))
    __swig_destroy__ = _xapian.delete_PL2Weight
PL2Weight_swigregister = _xapian.PL2Weight_swigregister
PL2Weight_swigregister(PL2Weight)

class PL2PlusWeight(Weight):
    """


    Xapian::Weight subclass implementing the PL2+ probabilistic formula.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """Xapian::PL2PlusWeight::PL2PlusWeight() """
        _xapian.PL2PlusWeight_swiginit(self, _xapian.new_PL2PlusWeight(*args))
    __swig_destroy__ = _xapian.delete_PL2PlusWeight
PL2PlusWeight_swigregister = _xapian.PL2PlusWeight_swigregister
PL2PlusWeight_swigregister(PL2PlusWeight)

class DPHWeight(Weight):
    """


    This class implements the DPH weighting scheme.

    DPH is a representative scheme of the Divergence from Randomness
    Framework by Gianni Amati.

    This is a parameter free weighting scheme and it should be used with
    query expansion to obtain better results. It uses the HyperGeometric
    Probabilistic model and Popper's normalization to calculate the risk
    gain.

    For more information about the DFR Framework and the DPH scheme,
    please refer to : a.) Gianni Amati and Cornelis Joost Van Rijsbergen
    Probabilistic models of information retrieval based on measuring the
    divergence from randomness ACM Transactions on Information Systems
    (TOIS) 20, (4), 2002, pp. 357-389. b.) FUB, IASI-CNR and University of
    Tor Vergata at TREC 2007 Blog Track. G. Amati and E. Ambrosi and M.
    Bianchi and C. Gaibisso and G. Gambosi. Proceedings of the 16th Text
    Retrieval Conference (TREC-2007), 2008. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Construct a DPHWeight.

        Xapian::DPHWeight::DPHWeight() 
        """
        _xapian.DPHWeight_swiginit(self, _xapian.new_DPHWeight())
    __swig_destroy__ = _xapian.delete_DPHWeight
DPHWeight_swigregister = _xapian.DPHWeight_swigregister
DPHWeight_swigregister(DPHWeight)

class LMWeight(Weight):
    """


    Xapian::Weight subclass implementing the Language Model formula.

    This class implements the "Language Model" Weighting scheme, as
    described by the early papers on LM by Bruce Croft.

    LM works by comparing the query to a Language Model of the document.
    The language model itself is parameter-free, though LMWeight takes
    parameters which specify the smoothing used. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct a LMWeight.

        Xapian::LMWeight::LMWeight(double param_log_=0.0, type_smoothing
        select_smoothing_=TWO_STAGE_SMOOTHING, double param_smoothing1_=-1.0,
        double param_smoothing2_=-1.0)

        Parameters:
        -----------

        param_log_:  A non-negative parameter controlling how much to clamp
        negative values returned by the log. The log is calculated by
        multiplying the actual weight by param_log. If param_log is 0.0, then
        the document length upper bound will be used (default: document length
        upper bound)

        select_smoothing_:  A parameter of type enum type_smoothing. This
        parameter controls which smoothing type to use. (default:
        TWO_STAGE_SMOOTHING)

        param_smoothing1_:  A non-negative parameter for smoothing whose
        meaning depends on select_smoothing_. In JELINEK_MERCER_SMOOTHING, it
        plays the role of estimation and in DIRICHLET_SMOOTHING the role of
        query modelling. (default JELINEK_MERCER, ABSOLUTE, TWOSTAGE(0.7),
        DIRCHLET(2000))

        param_smoothing2_:  A non-negative parameter which is used with
        TWO_STAGE_SMOOTHING as parameter for Dirichlet's smoothing (default:
        2000) and as parameter delta to control the scale of the tf lower
        bound in the DIRICHLET_PLUS_SMOOTHING (default 0.05). 
        """
        _xapian.LMWeight_swiginit(self, _xapian.new_LMWeight(*args))
    __swig_destroy__ = _xapian.delete_LMWeight
LMWeight_swigregister = _xapian.LMWeight_swigregister
LMWeight_swigregister(LMWeight)

class CoordWeight(Weight):
    """


    Xapian::Weight subclass implementing Coordinate Matching.

    Each matching term score one point. See Managing Gigabytes, Second
    Edition p181. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def init(self, factor_):
        """


        Allow the subclass to perform any initialisation it needs to.

        void Xapian::CoordWeight::init(double factor_)

        Parameters:
        -----------

        factor:  Any scaling factor (e.g. from OP_SCALE_WEIGHT). If the Weight
        object is for the term-independent weight supplied by
        get_sumextra()/get_maxextra(), then init(0.0) is called (starting from
        Xapian 1.2.11 and 1.3.1 - earlier versions failed to call init() for
        such Weight objects). 
        """
        return _xapian.CoordWeight_init(self, factor_)


    def __init__(self):
        """


        Construct a CoordWeight.

        Xapian::CoordWeight::CoordWeight() 
        """
        _xapian.CoordWeight_swiginit(self, _xapian.new_CoordWeight())
    __swig_destroy__ = _xapian.delete_CoordWeight
CoordWeight.init = _xapian.SWIG_PyInstanceMethod_New(_xapian.CoordWeight_init)
CoordWeight_swigregister = _xapian.CoordWeight_swigregister
CoordWeight_swigregister(CoordWeight)

class Compactor(object):
    """


    Compact a database, or merge and compact several. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    STANDARD = _xapian.Compactor_STANDARD
    FULL = _xapian.Compactor_FULL
    FULLER = _xapian.Compactor_FULLER

    def __init__(self):
        """Xapian::Compactor::Compactor() """
        if self.__class__ == Compactor:
            _self = None
        else:
            _self = self
        _xapian.Compactor_swiginit(self, _xapian.new_Compactor(_self, ))
    __swig_destroy__ = _xapian.delete_Compactor

    def set_block_size(self, block_size):
        """


        Set the block size to use for tables in the output database.

        void Xapian::Compactor::set_block_size(size_t block_size)

        Parameters:
        -----------

        block_size:  The block size to use. Valid block sizes are currently
        powers of two between 2048 and 65536, with the default being 8192, but
        the valid sizes and default may change in the future. 
        """
        return _xapian.Compactor_set_block_size(self, block_size)


    def set_renumber(self, renumber):
        """


        Set whether to preserve existing document id values.

        void Xapian::Compactor::set_renumber(bool renumber)

        Parameters:
        -----------

        renumber:  The default is true, which means that document ids will be
        renumbered - currently by applying the same offset to all the document
        ids in a particular source database.

        If false, then the document ids must be unique over all source
        databases. Currently the ranges of document ids in each source must
        not overlap either, though this restriction may be removed in the
        future. 
        """
        return _xapian.Compactor_set_renumber(self, renumber)


    def set_multipass(self, multipass):
        """


        Set whether to merge postlists in multiple passes.

        void Xapian::Compactor::set_multipass(bool multipass)

        Parameters:
        -----------

        multipass:  If true and merging more than 3 databases, merge the
        postlists in multiple passes, which is generally faster but requires
        more disk space for temporary files. By default we don't do this. 
        """
        return _xapian.Compactor_set_multipass(self, multipass)


    def set_compaction_level(self, compaction):
        """


        Set the compaction level.

        void Xapian::Compactor::set_compaction_level(compaction_level
        compaction)

        Parameters:
        -----------

        compaction:  Available values are:  Xapian::Compactor::STANDARD -
        Don't split items unnecessarily.

        Xapian::Compactor::FULL - Split items whenever it saves space (the
        default).

        Xapian::Compactor::FULLER - Allow oversize items to save more space
        (not recommended if you ever plan to update the compacted database).

        """
        return _xapian.Compactor_set_compaction_level(self, compaction)


    def set_destdir(self, destdir):
        """


        Set where to write the output.

        void Xapian::Compactor::set_destdir(const std::string &destdir)

        Deprecated Use Database::compact(destdir[, compactor]) instead.

        Parameters:
        -----------

        destdir:  Output path. This can be the same as an input if that input
        is a stub database (in which case the database(s) listed in the stub
        will be compacted to a new database and then the stub will be
        atomically updated to point to this new database). 
        """
        return _xapian.Compactor_set_destdir(self, destdir)


    def add_source(self, srcdir):
        """


        Add a source database.

        void Xapian::Compactor::add_source(const std::string &srcdir)

        Deprecated Use Database::compact(destdir[, compactor]) instead.

        Parameters:
        -----------

        srcdir:  The path to the source database to add. 
        """
        return _xapian.Compactor_add_source(self, srcdir)


    def compact(self):
        """


        Perform the actual compaction/merging operation.

        void Xapian::Compactor::compact()

        Deprecated Use Database::compact(destdir[, compactor]) instead. 
        """
        return _xapian.Compactor_compact(self)


    def set_status(self, table, status):
        """


        Update progress.

        virtual void Xapian::Compactor::set_status(const std::string &table,
        const std::string &status)

        Subclass this method if you want to get progress updates during
        compaction. This is called for each table first with empty status, And
        then one or more times with non-empty status.

        The default implementation does nothing.

        Parameters:
        -----------

        table:  The table currently being compacted.

        status:  A status message. 
        """
        return _xapian.Compactor_set_status(self, table, status)


    def resolve_duplicate_metadata(self, key, num_tags, tags):
        """


        Resolve multiple user metadata entries with the same key.

        virtual std::string
        Xapian::Compactor::resolve_duplicate_metadata(const std::string &key,
        size_t num_tags, const std::string tags[])

        When merging, if the same user metadata key is set in more than one
        input, then this method is called to allow this to be resolving in an
        appropriate way.

        The default implementation just returns tags[0].

        For multipass this will currently get called multiple times for the
        same key if there are duplicates to resolve in each pass, but this may
        change in the future.

        Since 1.4.6, an implementation of this method can return an empty
        string to indicate that the appropriate result is to not set a value
        for this user metadata key in the output database. In older versions,
        you should not return an empty string.

        Parameters:
        -----------

        key:  The metadata key with duplicate entries.

        num_tags:  How many tags there are.

        tags:  An array of num_tags strings containing the tags to merge. 
        """
        return _xapian.Compactor_resolve_duplicate_metadata(self, key, num_tags, tags)

    def __disown__(self):
        self.this.disown()
        _xapian.disown_Compactor(self)
        return weakref_proxy(self)
Compactor.set_block_size = _xapian.SWIG_PyInstanceMethod_New(_xapian.Compactor_set_block_size)
Compactor.set_renumber = _xapian.SWIG_PyInstanceMethod_New(_xapian.Compactor_set_renumber)
Compactor.set_multipass = _xapian.SWIG_PyInstanceMethod_New(_xapian.Compactor_set_multipass)
Compactor.set_compaction_level = _xapian.SWIG_PyInstanceMethod_New(_xapian.Compactor_set_compaction_level)
Compactor.set_destdir = _xapian.SWIG_PyInstanceMethod_New(_xapian.Compactor_set_destdir)
Compactor.add_source = _xapian.SWIG_PyInstanceMethod_New(_xapian.Compactor_add_source)
Compactor.compact = _xapian.SWIG_PyInstanceMethod_New(_xapian.Compactor_compact)
Compactor.set_status = _xapian.SWIG_PyInstanceMethod_New(_xapian.Compactor_set_status)
Compactor.resolve_duplicate_metadata = _xapian.SWIG_PyInstanceMethod_New(_xapian.Compactor_resolve_duplicate_metadata)
Compactor_swigregister = _xapian.Compactor_swigregister
Compactor_swigregister(Compactor)

class PostingSource(object):
    """


    Base class which provides an "external" source of postings. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Allow subclasses to be instantiated.

        Xapian::PostingSource::PostingSource() 
        """
        if self.__class__ == PostingSource:
            _self = None
        else:
            _self = self
        _xapian.PostingSource_swiginit(self, _xapian.new_PostingSource(_self, ))
    __swig_destroy__ = _xapian.delete_PostingSource

    def get_termfreq_min(self):
        """


        A lower bound on the number of documents this object can return.

        virtual Xapian::doccount Xapian::PostingSource::get_termfreq_min()
        const =0

        Xapian will always call init() on a PostingSource before calling this
        for the first time. 
        """
        return _xapian.PostingSource_get_termfreq_min(self)


    def get_termfreq_est(self):
        """


        An estimate of the number of documents this object can return.

        virtual Xapian::doccount Xapian::PostingSource::get_termfreq_est()
        const =0

        It must always be true that:

        get_termfreq_min() <= get_termfreq_est() <= get_termfreq_max()

        Xapian will always call init() on a PostingSource before calling this
        for the first time. 
        """
        return _xapian.PostingSource_get_termfreq_est(self)


    def get_termfreq_max(self):
        """


        An upper bound on the number of documents this object can return.

        virtual Xapian::doccount Xapian::PostingSource::get_termfreq_max()
        const =0

        Xapian will always call init() on a PostingSource before calling this
        for the first time. 
        """
        return _xapian.PostingSource_get_termfreq_max(self)


    def set_maxweight(self, max_weight):
        """


        Specify an upper bound on what get_weight() will return from now on.

        void Xapian::PostingSource::set_maxweight(double max_weight)

        This upper bound is used by the matcher to perform various
        optimisations, so if you can return a good bound, then matches will
        generally run faster.

        This method should be called after calling init(), and may be called
        during iteration if the upper bound drops. It is probably only useful
        to call from subclasses (it was actually a "protected" method prior
        to Xapian 1.3.4, but that makes it tricky to wrap for other
        languages).

        It is valid for the posting source to have returned a higher value
        from get_weight() earlier in the iteration, but the posting source
        must not return a higher value from get_weight() than the currently
        set upper bound, and the upper bound must not be increased (until
        init() has been called).

        If you don't call this method, the upper bound will default to 0, for
        convenience when implementing "weight-less" PostingSource
        subclasses.

        Parameters:
        -----------

        max_weight:  The upper bound to set. 
        """
        return _xapian.PostingSource_set_maxweight(self, max_weight)


    def get_maxweight(self):
        """


        Return the currently set upper bound on what get_weight() can return.

        double Xapian::PostingSource::get_maxweight() const 
        """
        return _xapian.PostingSource_get_maxweight(self)


    def get_weight(self):
        """


        Return the weight contribution for the current document.

        virtual double Xapian::PostingSource::get_weight() const

        This default implementation always returns 0, for convenience when
        implementing "weight-less" PostingSource subclasses.

        This method may assume that it will only be called when there is a
        "current document". In detail: Xapian will always call init() on a
        PostingSource before calling this for the first time. It will also
        only call this if the PostingSource reports that it is pointing to a
        valid document (ie, it will not call it before calling at least one of
        next(), skip_to() or check(), and will ensure that the PostingSource
        is not at the end by calling at_end()). 
        """
        return _xapian.PostingSource_get_weight(self)


    def get_docid(self):
        """


        Return the current docid.

        virtual Xapian::docid Xapian::PostingSource::get_docid() const =0

        This method may assume that it will only be called when there is a
        "current document". See  get_weight() for details.

        Note: in the case of a multi-database search, the returned docid
        should be in the single subdatabase relevant to this posting source.
        See the  init() method for details. 
        """
        return _xapian.PostingSource_get_docid(self)


    def __next__(self, min_wt):
        """


        Advance the current position to the next matching document.

        virtual void Xapian::PostingSource::next(double min_wt)=0

        The PostingSource starts before the first entry in the list, so
        next(), skip_to() or check() must be called before any methods which
        need the context of the current position.

        Xapian will always call init() on a PostingSource before calling this
        for the first time.

        Parameters:
        -----------

        min_wt:  The minimum weight contribution that is needed (this is just
        a hint which subclasses may ignore). 
        """
        return _xapian.PostingSource___next__(self, min_wt)


    def skip_to(self, did, min_wt):
        """


        Advance to the specified docid.

        virtual void Xapian::PostingSource::skip_to(Xapian::docid did, double
        min_wt)

        If the specified docid isn't in the list, position ourselves on the
        first document after it (or at_end() if no greater docids are
        present).

        If the current position is already the specified docid, this method
        will leave the position unmodified.

        If the specified docid is earlier than the current position, the
        behaviour is unspecified. A sensible behaviour would be to leave the
        current position unmodified, but it is also reasonable to move to the
        specified docid.

        The default implementation calls next() repeatedly, which works but
        skip_to() can often be implemented much more efficiently.

        Xapian will always call init() on a PostingSource before calling this
        for the first time.

        Note: in the case of a multi-database search, the docid specified is
        the docid in the single subdatabase relevant to this posting source.
        See the  init() method for details.

        Parameters:
        -----------

        did:  The document id to advance to.

        min_wt:  The minimum weight contribution that is needed (this is just
        a hint which subclasses may ignore). 
        """
        return _xapian.PostingSource_skip_to(self, did, min_wt)


    def check(self, did, min_wt):
        """


        Check if the specified docid occurs.

        virtual bool Xapian::PostingSource::check(Xapian::docid did, double
        min_wt)

        The caller is required to ensure that the specified document id did
        actually exists in the database. If it does, it must move to that
        document id, and return true. If it does not, it may either:

        return true, having moved to a definite position (including
        "at_end"), which must be the same position as skip_to() would have
        moved to.

        or

        return false, having moved to an "indeterminate" position, such that
        a subsequent call to next() or skip_to() will move to the next
        matching position after did.

        Generally, this method should act like skip_to() and return true if
        that can be done at little extra cost.

        Otherwise it should simply check if a particular docid is present,
        returning true if it is, and false if it isn't.

        The default implementation calls skip_to() and always returns true.

        Xapian will always call init() on a PostingSource before calling this
        for the first time.

        Note: in the case of a multi-database search, the docid specified is
        the docid in the single subdatabase relevant to this posting source.
        See the  init() method for details.

        Parameters:
        -----------

        did:  The document id to check.

        min_wt:  The minimum weight contribution that is needed (this is just
        a hint which subclasses may ignore). 
        """
        return _xapian.PostingSource_check(self, did, min_wt)


    def at_end(self):
        """


        Return true if the current position is past the last entry in this
        list.

        virtual bool Xapian::PostingSource::at_end() const =0

        At least one of  next(),  skip_to() or  check() will be called before
        this method is first called. 
        """
        return _xapian.PostingSource_at_end(self)


    def name(self):
        """


        Name of the posting source class.

        virtual std::string Xapian::PostingSource::name() const

        This is used when serialising and unserialising posting sources; for
        example, for performing remote searches.

        If the subclass is in a C++ namespace, the namespace should be
        included in the name, using "::" as a separator. For example, for a
        PostingSource subclass called "FooPostingSource" in the "Xapian"
        namespace the result of this call should be
        "Xapian::FooPostingSource".

        This should only be implemented if serialise() and unserialise() are
        also implemented. The default implementation returns an empty string.

        If this returns an empty string, Xapian will assume that serialise()
        and unserialise() are not implemented. 
        """
        return _xapian.PostingSource_name(self)


    def init(self, db):
        """


        Set this PostingSource to the start of the list of postings.

        virtual void Xapian::PostingSource::init(const Database &db)=0

        This is called automatically by the matcher prior to each query being
        processed.

        If a PostingSource is used for multiple searches,  init() will
        therefore be called multiple times, and must handle this by using the
        database passed in the most recent call.

        Parameters:
        -----------

        db:  The database which the PostingSource should iterate through.

        Note: in the case of a multi-database search, a separate PostingSource
        will be used for each database (the separate PostingSources will be
        obtained using  clone()), and each PostingSource will be passed one of
        the sub-databases as the db parameter here. The db parameter will
        therefore always refer to a single database. All docids passed to, or
        returned from, the PostingSource refer to docids in that single
        database, rather than in the multi- database. 
        """
        return _xapian.PostingSource_init(self, db)


    def __str__(self):
        """


        Return a string describing this object.

        virtual std::string Xapian::PostingSource::get_description() const

        This default implementation returns a generic answer. This default it
        provided to avoid forcing those deriving their own PostingSource
        subclass from having to implement this (they may not care what
        get_description() gives for their subclass). 
        """
        return _xapian.PostingSource___str__(self)


    def release(self):
        """


        Start reference counting this object.

        const PostingSource* Xapian::PostingSource::release() const

        You can hand ownership of a dynamically allocated PostingSource object
        to Xapian by calling release() and then passing the object to a Xapian
        method. Xapian will arrange to delete the object once it is no longer
        required. 
        """
        return _xapian.PostingSource_release(self)

    def __disown__(self):
        self.this.disown()
        _xapian.disown_PostingSource(self)
        return weakref_proxy(self)
PostingSource.get_termfreq_min = _xapian.SWIG_PyInstanceMethod_New(_xapian.PostingSource_get_termfreq_min)
PostingSource.get_termfreq_est = _xapian.SWIG_PyInstanceMethod_New(_xapian.PostingSource_get_termfreq_est)
PostingSource.get_termfreq_max = _xapian.SWIG_PyInstanceMethod_New(_xapian.PostingSource_get_termfreq_max)
PostingSource.set_maxweight = _xapian.SWIG_PyInstanceMethod_New(_xapian.PostingSource_set_maxweight)
PostingSource.get_maxweight = _xapian.SWIG_PyInstanceMethod_New(_xapian.PostingSource_get_maxweight)
PostingSource.get_weight = _xapian.SWIG_PyInstanceMethod_New(_xapian.PostingSource_get_weight)
PostingSource.get_docid = _xapian.SWIG_PyInstanceMethod_New(_xapian.PostingSource_get_docid)
PostingSource.__next__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.PostingSource___next__)
PostingSource.skip_to = _xapian.SWIG_PyInstanceMethod_New(_xapian.PostingSource_skip_to)
PostingSource.check = _xapian.SWIG_PyInstanceMethod_New(_xapian.PostingSource_check)
PostingSource.at_end = _xapian.SWIG_PyInstanceMethod_New(_xapian.PostingSource_at_end)
PostingSource.name = _xapian.SWIG_PyInstanceMethod_New(_xapian.PostingSource_name)
PostingSource.init = _xapian.SWIG_PyInstanceMethod_New(_xapian.PostingSource_init)
PostingSource.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.PostingSource___str__)
PostingSource.release = _xapian.SWIG_PyInstanceMethod_New(_xapian.PostingSource_release)
PostingSource_swigregister = _xapian.PostingSource_swigregister
PostingSource_swigregister(PostingSource)

class ValuePostingSource(PostingSource):
    """


    A posting source which generates weights from a value slot.

    This is a base class for classes which generate weights using values
    stored in the specified slot. For example, ValueWeightPostingSource
    uses sortable_unserialise to convert values directly to weights.

    The upper bound on the weight returned is set to DBL_MAX. Subclasses
    should call set_maxweight() in their init() methods after calling
    ValuePostingSource::init() if they know a tighter bound on the weight.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, slot_):
        """


        Construct a ValuePostingSource.

        Xapian::ValuePostingSource::ValuePostingSource(Xapian::valueno slot_)

        Parameters:
        -----------

        slot_:  The value slot to read values from. 
        """
        if self.__class__ == ValuePostingSource:
            _self = None
        else:
            _self = self
        _xapian.ValuePostingSource_swiginit(self, _xapian.new_ValuePostingSource(_self, slot_))

    def get_termfreq_min(self):
        """


        A lower bound on the number of documents this object can return.

        Xapian::doccount Xapian::ValuePostingSource::get_termfreq_min() const

        Xapian will always call init() on a PostingSource before calling this
        for the first time. 
        """
        return _xapian.ValuePostingSource_get_termfreq_min(self)


    def get_termfreq_est(self):
        """


        An estimate of the number of documents this object can return.

        Xapian::doccount Xapian::ValuePostingSource::get_termfreq_est() const

        It must always be true that:

        get_termfreq_min() <= get_termfreq_est() <= get_termfreq_max()

        Xapian will always call init() on a PostingSource before calling this
        for the first time. 
        """
        return _xapian.ValuePostingSource_get_termfreq_est(self)


    def get_termfreq_max(self):
        """


        An upper bound on the number of documents this object can return.

        Xapian::doccount Xapian::ValuePostingSource::get_termfreq_max() const

        Xapian will always call init() on a PostingSource before calling this
        for the first time. 
        """
        return _xapian.ValuePostingSource_get_termfreq_max(self)


    def __next__(self, min_wt):
        """


        Advance the current position to the next matching document.

        void Xapian::ValuePostingSource::next(double min_wt)

        The PostingSource starts before the first entry in the list, so
        next(), skip_to() or check() must be called before any methods which
        need the context of the current position.

        Xapian will always call init() on a PostingSource before calling this
        for the first time.

        Parameters:
        -----------

        min_wt:  The minimum weight contribution that is needed (this is just
        a hint which subclasses may ignore). 
        """
        return _xapian.ValuePostingSource___next__(self, min_wt)


    def skip_to(self, min_docid, min_wt):
        """


        Advance to the specified docid.

        void Xapian::ValuePostingSource::skip_to(Xapian::docid min_docid,
        double min_wt)

        If the specified docid isn't in the list, position ourselves on the
        first document after it (or at_end() if no greater docids are
        present).

        If the current position is already the specified docid, this method
        will leave the position unmodified.

        If the specified docid is earlier than the current position, the
        behaviour is unspecified. A sensible behaviour would be to leave the
        current position unmodified, but it is also reasonable to move to the
        specified docid.

        The default implementation calls next() repeatedly, which works but
        skip_to() can often be implemented much more efficiently.

        Xapian will always call init() on a PostingSource before calling this
        for the first time.

        Note: in the case of a multi-database search, the docid specified is
        the docid in the single subdatabase relevant to this posting source.
        See the  init() method for details.

        Parameters:
        -----------

        did:  The document id to advance to.

        min_wt:  The minimum weight contribution that is needed (this is just
        a hint which subclasses may ignore). 
        """
        return _xapian.ValuePostingSource_skip_to(self, min_docid, min_wt)


    def check(self, min_docid, min_wt):
        """


        Check if the specified docid occurs.

        bool Xapian::ValuePostingSource::check(Xapian::docid min_docid, double
        min_wt)

        The caller is required to ensure that the specified document id did
        actually exists in the database. If it does, it must move to that
        document id, and return true. If it does not, it may either:

        return true, having moved to a definite position (including
        "at_end"), which must be the same position as skip_to() would have
        moved to.

        or

        return false, having moved to an "indeterminate" position, such that
        a subsequent call to next() or skip_to() will move to the next
        matching position after did.

        Generally, this method should act like skip_to() and return true if
        that can be done at little extra cost.

        Otherwise it should simply check if a particular docid is present,
        returning true if it is, and false if it isn't.

        The default implementation calls skip_to() and always returns true.

        Xapian will always call init() on a PostingSource before calling this
        for the first time.

        Note: in the case of a multi-database search, the docid specified is
        the docid in the single subdatabase relevant to this posting source.
        See the  init() method for details.

        Parameters:
        -----------

        did:  The document id to check.

        min_wt:  The minimum weight contribution that is needed (this is just
        a hint which subclasses may ignore). 
        """
        return _xapian.ValuePostingSource_check(self, min_docid, min_wt)


    def at_end(self):
        """


        Return true if the current position is past the last entry in this
        list.

        bool Xapian::ValuePostingSource::at_end() const

        At least one of  next(),  skip_to() or  check() will be called before
        this method is first called. 
        """
        return _xapian.ValuePostingSource_at_end(self)


    def get_docid(self):
        """


        Return the current docid.

        Xapian::docid Xapian::ValuePostingSource::get_docid() const

        This method may assume that it will only be called when there is a
        "current document". See  get_weight() for details.

        Note: in the case of a multi-database search, the returned docid
        should be in the single subdatabase relevant to this posting source.
        See the  init() method for details. 
        """
        return _xapian.ValuePostingSource_get_docid(self)


    def init(self, db_):
        """


        Set this PostingSource to the start of the list of postings.

        void Xapian::ValuePostingSource::init(const Database &db_)

        This is called automatically by the matcher prior to each query being
        processed.

        If a PostingSource is used for multiple searches,  init() will
        therefore be called multiple times, and must handle this by using the
        database passed in the most recent call.

        Parameters:
        -----------

        db:  The database which the PostingSource should iterate through.

        Note: in the case of a multi-database search, a separate PostingSource
        will be used for each database (the separate PostingSources will be
        obtained using  clone()), and each PostingSource will be passed one of
        the sub-databases as the db parameter here. The db parameter will
        therefore always refer to a single database. All docids passed to, or
        returned from, the PostingSource refer to docids in that single
        database, rather than in the multi- database. 
        """
        return _xapian.ValuePostingSource_init(self, db_)


    def get_database(self):
        """


        The database we're reading values from.

        Xapian::Database Xapian::ValuePostingSource::get_database() const

        Added in 1.2.23 and 1.3.5. 
        """
        return _xapian.ValuePostingSource_get_database(self)


    def get_slot(self):
        """


        The slot we're reading values from.

        Xapian::valueno Xapian::ValuePostingSource::get_slot() const

        Added in 1.2.23 and 1.3.5. 
        """
        return _xapian.ValuePostingSource_get_slot(self)


    def get_value(self):
        """


        Read current value.

        std::string Xapian::ValuePostingSource::get_value() const

        Added in 1.2.23 and 1.3.5. 
        """
        return _xapian.ValuePostingSource_get_value(self)


    def done(self):
        """


        End the iteration.

        void Xapian::ValuePostingSource::done()

        Calls to at_end() will return true after calling this method.

        Added in 1.2.23 and 1.3.5. 
        """
        return _xapian.ValuePostingSource_done(self)


    def get_started(self):
        """


        Flag indicating if we've started (true if we have).

        bool Xapian::ValuePostingSource::get_started() const

        Added in 1.2.23 and 1.3.5. 
        """
        return _xapian.ValuePostingSource_get_started(self)


    def set_termfreq_min(self, termfreq_min_):
        """


        Set a lower bound on the term frequency.

        void Xapian::ValuePostingSource::set_termfreq_min(Xapian::doccount
        termfreq_min_)

        Subclasses should set this if they are overriding the next(),
        skip_to() or check() methods to return fewer documents.

        Added in 1.2.23 and 1.3.5. 
        """
        return _xapian.ValuePostingSource_set_termfreq_min(self, termfreq_min_)


    def set_termfreq_est(self, termfreq_est_):
        """


        An estimate of the term frequency.

        void Xapian::ValuePostingSource::set_termfreq_est(Xapian::doccount
        termfreq_est_)

        Subclasses should set this if they are overriding the next(),
        skip_to() or check() methods.

        Added in 1.2.23 and 1.3.5. 
        """
        return _xapian.ValuePostingSource_set_termfreq_est(self, termfreq_est_)


    def set_termfreq_max(self, termfreq_max_):
        """


        An upper bound on the term frequency.

        void Xapian::ValuePostingSource::set_termfreq_max(Xapian::doccount
        termfreq_max_)

        Subclasses should set this if they are overriding the next(),
        skip_to() or check() methods.

        Added in 1.2.23 and 1.3.5. 
        """
        return _xapian.ValuePostingSource_set_termfreq_max(self, termfreq_max_)

    __swig_destroy__ = _xapian.delete_ValuePostingSource
    def __disown__(self):
        self.this.disown()
        _xapian.disown_ValuePostingSource(self)
        return weakref_proxy(self)
ValuePostingSource.get_termfreq_min = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValuePostingSource_get_termfreq_min)
ValuePostingSource.get_termfreq_est = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValuePostingSource_get_termfreq_est)
ValuePostingSource.get_termfreq_max = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValuePostingSource_get_termfreq_max)
ValuePostingSource.__next__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValuePostingSource___next__)
ValuePostingSource.skip_to = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValuePostingSource_skip_to)
ValuePostingSource.check = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValuePostingSource_check)
ValuePostingSource.at_end = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValuePostingSource_at_end)
ValuePostingSource.get_docid = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValuePostingSource_get_docid)
ValuePostingSource.init = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValuePostingSource_init)
ValuePostingSource.get_database = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValuePostingSource_get_database)
ValuePostingSource.get_slot = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValuePostingSource_get_slot)
ValuePostingSource.get_value = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValuePostingSource_get_value)
ValuePostingSource.done = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValuePostingSource_done)
ValuePostingSource.get_started = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValuePostingSource_get_started)
ValuePostingSource.set_termfreq_min = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValuePostingSource_set_termfreq_min)
ValuePostingSource.set_termfreq_est = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValuePostingSource_set_termfreq_est)
ValuePostingSource.set_termfreq_max = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValuePostingSource_set_termfreq_max)
ValuePostingSource_swigregister = _xapian.ValuePostingSource_swigregister
ValuePostingSource_swigregister(ValuePostingSource)

class ValueWeightPostingSource(ValuePostingSource):
    """


    A posting source which reads weights from a value slot.

    This returns entries for all documents in the given database which
    have a non empty values in the specified slot. It returns a weight
    calculated by applying sortable_unserialise to the value stored in the
    slot (so the values stored should probably have been calculated by
    applying sortable_serialise to a floating point number at index time).

    The upper bound on the weight returned is set using the upper bound on
    the values in the specified slot, or DBL_MAX if value bounds aren't
    supported by the current backend.

    For efficiency, this posting source doesn't check that the stored
    values are valid in any way, so it will never raise an exception due
    to invalid stored values. In particular, it doesn't ensure that the
    unserialised values are positive, which is a requirement for weights.
    The behaviour if the slot contains values which unserialise to
    negative values is undefined. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, slot_):
        """


        Construct a ValueWeightPostingSource.

        Xapian::ValueWeightPostingSource::ValueWeightPostingSource(Xapian::valueno
        slot_)

        Parameters:
        -----------

        slot_:  The value slot to read values from. 
        """
        if self.__class__ == ValueWeightPostingSource:
            _self = None
        else:
            _self = self
        _xapian.ValueWeightPostingSource_swiginit(self, _xapian.new_ValueWeightPostingSource(_self, slot_))

    def get_weight(self):
        """


        Return the weight contribution for the current document.

        double Xapian::ValueWeightPostingSource::get_weight() const

        This default implementation always returns 0, for convenience when
        implementing "weight-less" PostingSource subclasses.

        This method may assume that it will only be called when there is a
        "current document". In detail: Xapian will always call init() on a
        PostingSource before calling this for the first time. It will also
        only call this if the PostingSource reports that it is pointing to a
        valid document (ie, it will not call it before calling at least one of
        next(), skip_to() or check(), and will ensure that the PostingSource
        is not at the end by calling at_end()). 
        """
        return _xapian.ValueWeightPostingSource_get_weight(self)


    def name(self):
        """


        Name of the posting source class.

        std::string Xapian::ValueWeightPostingSource::name() const

        This is used when serialising and unserialising posting sources; for
        example, for performing remote searches.

        If the subclass is in a C++ namespace, the namespace should be
        included in the name, using "::" as a separator. For example, for a
        PostingSource subclass called "FooPostingSource" in the "Xapian"
        namespace the result of this call should be
        "Xapian::FooPostingSource".

        This should only be implemented if serialise() and unserialise() are
        also implemented. The default implementation returns an empty string.

        If this returns an empty string, Xapian will assume that serialise()
        and unserialise() are not implemented. 
        """
        return _xapian.ValueWeightPostingSource_name(self)


    def init(self, db_):
        """


        Set this PostingSource to the start of the list of postings.

        void Xapian::ValueWeightPostingSource::init(const Database &db_)

        This is called automatically by the matcher prior to each query being
        processed.

        If a PostingSource is used for multiple searches,  init() will
        therefore be called multiple times, and must handle this by using the
        database passed in the most recent call.

        Parameters:
        -----------

        db:  The database which the PostingSource should iterate through.

        Note: in the case of a multi-database search, a separate PostingSource
        will be used for each database (the separate PostingSources will be
        obtained using  clone()), and each PostingSource will be passed one of
        the sub-databases as the db parameter here. The db parameter will
        therefore always refer to a single database. All docids passed to, or
        returned from, the PostingSource refer to docids in that single
        database, rather than in the multi- database. 
        """
        return _xapian.ValueWeightPostingSource_init(self, db_)


    def __str__(self):
        """


        Return a string describing this object.

        std::string Xapian::ValueWeightPostingSource::get_description() const

        This default implementation returns a generic answer. This default it
        provided to avoid forcing those deriving their own PostingSource
        subclass from having to implement this (they may not care what
        get_description() gives for their subclass). 
        """
        return _xapian.ValueWeightPostingSource___str__(self)

    __swig_destroy__ = _xapian.delete_ValueWeightPostingSource
    def __disown__(self):
        self.this.disown()
        _xapian.disown_ValueWeightPostingSource(self)
        return weakref_proxy(self)
ValueWeightPostingSource.get_weight = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValueWeightPostingSource_get_weight)
ValueWeightPostingSource.name = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValueWeightPostingSource_name)
ValueWeightPostingSource.init = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValueWeightPostingSource_init)
ValueWeightPostingSource.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValueWeightPostingSource___str__)
ValueWeightPostingSource_swigregister = _xapian.ValueWeightPostingSource_swigregister
ValueWeightPostingSource_swigregister(ValueWeightPostingSource)

class DecreasingValueWeightPostingSource(ValueWeightPostingSource):
    """


    Read weights from a value which is known to decrease as docid
    increases.

    This posting source can be used, like ValueWeightPostingSource, to add
    a weight contribution to a query based on the values stored in a slot.
    The values in the slot must be serialised as by  sortable_serialise().

    However, this posting source is additionally given a range of document
    IDs, within which the weight is known to be decreasing. ie, for all
    documents with ids A and B within this range (including the
    endpoints), where A is less than B, the weight of A is less than or
    equal to the weight of B. This can allow the posting source to skip to
    the end of the range quickly if insufficient weight is left in the
    posting source for a particular source.

    By default, the range is assumed to cover all document IDs.

    The ordering property can be arranged at index time, or by sorting an
    indexed database to produce a new, sorted, database. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, slot_, range_start_=0, range_end_=0):
        """


        Construct a DecreasingValueWeightPostingSource.

        Xapian::DecreasingValueWeightPostingSource::DecreasingValueWeightPostingSource(Xapian::valueno
        slot_, Xapian::docid range_start_=0, Xapian::docid range_end_=0)

        Parameters:
        -----------

        slot_:  The value slot to read values from.

        range_start_:  Start of range of docids for which weights are known to
        be decreasing (default: first docid)

        range_end_:  End of range of docids for which weights are known to be
        decreasing (default: last docid) 
        """
        _xapian.DecreasingValueWeightPostingSource_swiginit(self, _xapian.new_DecreasingValueWeightPostingSource(slot_, range_start_, range_end_))
    __swig_destroy__ = _xapian.delete_DecreasingValueWeightPostingSource
DecreasingValueWeightPostingSource_swigregister = _xapian.DecreasingValueWeightPostingSource_swigregister
DecreasingValueWeightPostingSource_swigregister(DecreasingValueWeightPostingSource)

class ValueMapPostingSource(ValuePostingSource):
    """


    A posting source which looks up weights in a map using values as the
    key.

    This allows will return entries for all documents in the given
    database which have a value in the slot specified. The values will be
    mapped to the corresponding weight in the weight map. If there is no
    mapping for a particular value, the default weight will be returned
    (which itself defaults to 0.0). 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, slot_):
        """


        Construct a ValueMapPostingSource.

        Xapian::ValueMapPostingSource::ValueMapPostingSource(Xapian::valueno
        slot_)

        Parameters:
        -----------

        slot_:  The value slot to read values from. 
        """
        _xapian.ValueMapPostingSource_swiginit(self, _xapian.new_ValueMapPostingSource(slot_))

    def add_mapping(self, key, wt):
        """


        Add a mapping.

        void Xapian::ValueMapPostingSource::add_mapping(const std::string
        &key, double wt)

        Parameters:
        -----------

        key:  The key looked up from the value slot.

        wt:  The weight to give this key. 
        """
        return _xapian.ValueMapPostingSource_add_mapping(self, key, wt)


    def clear_mappings(self):
        """


        Clear all mappings.

        void Xapian::ValueMapPostingSource::clear_mappings() 
        """
        return _xapian.ValueMapPostingSource_clear_mappings(self)


    def set_default_weight(self, wt):
        """


        Set a default weight for document values not in the map.

        void Xapian::ValueMapPostingSource::set_default_weight(double wt)

        Parameters:
        -----------

        wt:  The weight to set as the default. 
        """
        return _xapian.ValueMapPostingSource_set_default_weight(self, wt)

    __swig_destroy__ = _xapian.delete_ValueMapPostingSource
ValueMapPostingSource.add_mapping = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValueMapPostingSource_add_mapping)
ValueMapPostingSource.clear_mappings = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValueMapPostingSource_clear_mappings)
ValueMapPostingSource.set_default_weight = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValueMapPostingSource_set_default_weight)
ValueMapPostingSource_swigregister = _xapian.ValueMapPostingSource_swigregister
ValueMapPostingSource_swigregister(ValueMapPostingSource)

class FixedWeightPostingSource(PostingSource):
    """


    A posting source which returns a fixed weight for all documents.

    This returns entries for all documents in the given database, with a
    fixed weight (specified by a parameter to the constructor). 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, wt):
        """


        Construct a FixedWeightPostingSource.

        Xapian::FixedWeightPostingSource::FixedWeightPostingSource(double wt)

        Parameters:
        -----------

        wt:  The fixed weight to return. 
        """
        _xapian.FixedWeightPostingSource_swiginit(self, _xapian.new_FixedWeightPostingSource(wt))
    __swig_destroy__ = _xapian.delete_FixedWeightPostingSource
FixedWeightPostingSource_swigregister = _xapian.FixedWeightPostingSource_swigregister
FixedWeightPostingSource_swigregister(FixedWeightPostingSource)

class MatchSpy(object):
    """


    Abstract base class for match spies.

    The subclasses will generally accumulate information seen during the
    match, to calculate aggregate functions, or other profiles of the
    matching documents. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Default constructor, needed by subclass constructors.

        Xapian::MatchSpy::MatchSpy() 
        """
        if self.__class__ == MatchSpy:
            _self = None
        else:
            _self = self
        _xapian.MatchSpy_swiginit(self, _xapian.new_MatchSpy(_self, ))
    __swig_destroy__ = _xapian.delete_MatchSpy

    def name(self):
        """


        Return the name of this match spy.

        virtual std::string Xapian::MatchSpy::name() const

        This name is used by the remote backend. It is passed with the
        serialised parameters to the remote server so that it knows which
        class to create.

        Return the full namespace-qualified name of your class here - if your
        class is called MyApp::FooMatchSpy, return "MyApp::FooMatchSpy" from
        this method.

        If you don't want to support the remote backend in your match spy, you
        can use the default implementation which simply throws
        Xapian::UnimplementedError. 
        """
        return _xapian.MatchSpy_name(self)


    def merge_results(self, serialised):
        """


        Unserialise some results, and merge them into this matchspy.

        virtual void Xapian::MatchSpy::merge_results(const std::string
        &serialised)

        The order in which results are merged should not be significant, since
        this order is not specified (and will vary depending on the speed of
        the search in each sub-database).

        If you don't want to support the remote backend in your match spy, you
        can use the default implementation which simply throws
        Xapian::UnimplementedError.

        Parameters:
        -----------

        serialised:  A string containing the serialised results. 
        """
        return _xapian.MatchSpy_merge_results(self, serialised)


    def __str__(self):
        """


        Return a string describing this object.

        virtual std::string Xapian::MatchSpy::get_description() const

        This default implementation returns a generic answer, to avoid forcing
        those deriving their own MatchSpy subclasses from having to implement
        this (they may not care what get_description() gives for their
        subclass). 
        """
        return _xapian.MatchSpy___str__(self)


    def release(self):
        """


        Start reference counting this object.

        const MatchSpy* Xapian::MatchSpy::release() const

        You can hand ownership of a dynamically allocated MatchSpy object to
        Xapian by calling release() and then passing the object to a Xapian
        method. Xapian will arrange to delete the object once it is no longer
        required. 
        """
        return _xapian.MatchSpy_release(self)

    def __disown__(self):
        self.this.disown()
        _xapian.disown_MatchSpy(self)
        return weakref_proxy(self)
MatchSpy.__call__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.MatchSpy___call__)
MatchSpy.name = _xapian.SWIG_PyInstanceMethod_New(_xapian.MatchSpy_name)
MatchSpy.merge_results = _xapian.SWIG_PyInstanceMethod_New(_xapian.MatchSpy_merge_results)
MatchSpy.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.MatchSpy___str__)
MatchSpy.release = _xapian.SWIG_PyInstanceMethod_New(_xapian.MatchSpy_release)
MatchSpy_swigregister = _xapian.MatchSpy_swigregister
MatchSpy_swigregister(MatchSpy)

class ValueCountMatchSpy(MatchSpy):
    """


    Class for counting the frequencies of values in the matching
    documents. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct a MatchSpy which counts the values in a particular slot.

        Xapian::ValueCountMatchSpy::ValueCountMatchSpy(Xapian::valueno slot_)

        """
        _xapian.ValueCountMatchSpy_swiginit(self, _xapian.new_ValueCountMatchSpy(*args))

    def get_total(self):
        """


        Return the total number of documents tallied.

        size_t Xapian::ValueCountMatchSpy::get_total() const 
        """
        return _xapian.ValueCountMatchSpy_get_total(self)


    def values_begin(self):
        """


        Get an iterator over the values seen in the slot.

        TermIterator Xapian::ValueCountMatchSpy::values_begin() const

        Items will be returned in ascending alphabetical order.

        During the iteration, the frequency of the current value can be
        obtained with the get_termfreq() method on the iterator. 
        """
        return _xapian.ValueCountMatchSpy_values_begin(self)


    def values_end(self):
        """


        End iterator corresponding to values_begin()

        TermIterator Xapian::ValueCountMatchSpy::values_end() const 
        """
        return _xapian.ValueCountMatchSpy_values_end(self)


    def top_values_begin(self, maxvalues):
        """


        Get an iterator over the most frequent values seen in the slot.

        TermIterator Xapian::ValueCountMatchSpy::top_values_begin(size_t
        maxvalues) const

        Items will be returned in descending order of frequency. Values with
        the same frequency will be returned in ascending alphabetical order.

        During the iteration, the frequency of the current value can be
        obtained with the get_termfreq() method on the iterator.

        Parameters:
        -----------

        maxvalues:  The maximum number of values to return. 
        """
        return _xapian.ValueCountMatchSpy_top_values_begin(self, maxvalues)


    def top_values_end(self, arg2):
        """


        End iterator corresponding to top_values_begin()

        TermIterator Xapian::ValueCountMatchSpy::top_values_end(size_t) const

        """
        return _xapian.ValueCountMatchSpy_top_values_end(self, arg2)

    __swig_destroy__ = _xapian.delete_ValueCountMatchSpy
ValueCountMatchSpy.get_total = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValueCountMatchSpy_get_total)
ValueCountMatchSpy.values_begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValueCountMatchSpy_values_begin)
ValueCountMatchSpy.values_end = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValueCountMatchSpy_values_end)
ValueCountMatchSpy.top_values_begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValueCountMatchSpy_top_values_begin)
ValueCountMatchSpy.top_values_end = _xapian.SWIG_PyInstanceMethod_New(_xapian.ValueCountMatchSpy_top_values_end)
ValueCountMatchSpy_swigregister = _xapian.ValueCountMatchSpy_swigregister
ValueCountMatchSpy_swigregister(ValueCountMatchSpy)


def miles_to_metres(miles):
    return _xapian.miles_to_metres(miles)
miles_to_metres = _xapian.miles_to_metres

def metres_to_miles(metres):
    return _xapian.metres_to_miles(metres)
metres_to_miles = _xapian.metres_to_miles
class LatLongCoord(object):
    """


    A latitude-longitude coordinate.

    Experimental - seehttps://xapian.org/docs/deprecation#experimental-
    features

    Note that latitude-longitude coordinates are only precisely meaningful
    if the datum used to define them is specified. This class ignores this
    issue - it is up to the caller to ensure that the datum used for each
    coordinate in a system is consistent. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    latitude = property(_xapian.LatLongCoord_latitude_get, _xapian.LatLongCoord_latitude_set)
    longitude = property(_xapian.LatLongCoord_longitude_get, _xapian.LatLongCoord_longitude_set)

    def __init__(self, *args):
        """


        Construct a coordinate.

        Xapian::LatLongCoord::LatLongCoord(double latitude_, double
        longitude_)

        If the supplied longitude is out of the standard range, it will be
        normalised to the range 0 <= longitude < 360.

        If you want to avoid the checks (for example, you know that your
        values are already in range), you can use the alternate constructor to
        construct an uninitialised coordinate, and then set the latitude and
        longitude directly.

        Parameters:
        -----------

        InvalidArgumentError:  the supplied latitude is out of range. 
        """
        _xapian.LatLongCoord_swiginit(self, _xapian.new_LatLongCoord(*args))

    def unserialise(self, serialised):
        """


        Unserialise a buffer and set this object to its coordinate.

        void Xapian::LatLongCoord::unserialise(const char **ptr, const char
        *end)

        The buffer may contain further data after that for the coordinate.

        Parameters:
        -----------

        ptr:  A pointer to the start of the string. This will be updated to
        point to the end of the data representing the coordinate.

        end:  A pointer to the end of the string.

        Parameters:
        -----------

        Xapian::SerialisationError:  if the string does not start with a valid
        serialised latitude- longitude pair. 
        """
        return _xapian.LatLongCoord_unserialise(self, serialised)


    def serialise(self):
        """


        Return a serialised representation of the coordinate.

        std::string Xapian::LatLongCoord::serialise() const 
        """
        return _xapian.LatLongCoord_serialise(self)


    def __str__(self):
        """


        Return a string describing this object.

        std::string Xapian::LatLongCoord::get_description() const 
        """
        return _xapian.LatLongCoord___str__(self)

    __swig_destroy__ = _xapian.delete_LatLongCoord
LatLongCoord.unserialise = _xapian.SWIG_PyInstanceMethod_New(_xapian.LatLongCoord_unserialise)
LatLongCoord.serialise = _xapian.SWIG_PyInstanceMethod_New(_xapian.LatLongCoord_serialise)
LatLongCoord.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.LatLongCoord___str__)
LatLongCoord_swigregister = _xapian.LatLongCoord_swigregister
LatLongCoord_swigregister(LatLongCoord)

class LatLongCoordsIterator(object):
    """


    An iterator across the values in a LatLongCoords object.

    Experimental - seehttps://xapian.org/docs/deprecation#experimental-
    features 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        """


        Default constructor. Produces an uninitialised iterator.

        Xapian::LatLongCoordsIterator::LatLongCoordsIterator() 
        """
        _xapian.LatLongCoordsIterator_swiginit(self, _xapian.new_LatLongCoordsIterator())
    __swig_destroy__ = _xapian.delete_LatLongCoordsIterator
LatLongCoordsIterator.__eq__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.LatLongCoordsIterator___eq__)
LatLongCoordsIterator.equals = _xapian.SWIG_PyInstanceMethod_New(_xapian.LatLongCoordsIterator_equals)
LatLongCoordsIterator.get_coord = _xapian.SWIG_PyInstanceMethod_New(_xapian.LatLongCoordsIterator_get_coord)
LatLongCoordsIterator.__next__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.LatLongCoordsIterator___next__)
LatLongCoordsIterator_swigregister = _xapian.LatLongCoordsIterator_swigregister
LatLongCoordsIterator_swigregister(LatLongCoordsIterator)

class LatLongCoords(object):
    """


    A sequence of latitude-longitude coordinates.

    Experimental - seehttps://xapian.org/docs/deprecation#experimental-
    features 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def begin(self):
        """


        Get a begin iterator for the coordinates.

        LatLongCoordsIterator Xapian::LatLongCoords::begin() const 
        """
        return _xapian.LatLongCoords_begin(self)


    def end(self):
        """


        Get an end iterator for the coordinates.

        LatLongCoordsIterator Xapian::LatLongCoords::end() const 
        """
        return _xapian.LatLongCoords_end(self)


    def size(self):
        """


        Get the number of coordinates in the container.

        size_t Xapian::LatLongCoords::size() const 
        """
        return _xapian.LatLongCoords_size(self)


    def empty(self):
        """


        Return true if and only if there are no coordinates in the container.

        bool Xapian::LatLongCoords::empty() const 
        """
        return _xapian.LatLongCoords_empty(self)


    def append(self, coord):
        """


        Append a coordinate to the end of the sequence.

        void Xapian::LatLongCoords::append(const LatLongCoord &coord) 
        """
        return _xapian.LatLongCoords_append(self, coord)


    def __init__(self, *args):
        """


        Construct a container holding one coordinate.

        Xapian::LatLongCoords::LatLongCoords(const LatLongCoord &coord) 
        """
        _xapian.LatLongCoords_swiginit(self, _xapian.new_LatLongCoords(*args))

    def unserialise(self, serialised):
        """


        Unserialise a string and set this object to the coordinates in it.

        void Xapian::LatLongCoords::unserialise(const std::string &serialised)

        Parameters:
        -----------

        serialised:  the string to unserialise the coordinates from.

        Parameters:
        -----------

        Xapian::SerialisationError:  if the string does not contain a valid
        serialised latitude-longitude pair, or contains junk at the end of it.

        """
        return _xapian.LatLongCoords_unserialise(self, serialised)


    def serialise(self):
        """


        Return a serialised form of the coordinate list.

        std::string Xapian::LatLongCoords::serialise() const 
        """
        return _xapian.LatLongCoords_serialise(self)


    def __str__(self):
        """


        Return a string describing this object.

        std::string Xapian::LatLongCoords::get_description() const 
        """
        return _xapian.LatLongCoords___str__(self)

    __swig_destroy__ = _xapian.delete_LatLongCoords
LatLongCoords.begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.LatLongCoords_begin)
LatLongCoords.end = _xapian.SWIG_PyInstanceMethod_New(_xapian.LatLongCoords_end)
LatLongCoords.size = _xapian.SWIG_PyInstanceMethod_New(_xapian.LatLongCoords_size)
LatLongCoords.empty = _xapian.SWIG_PyInstanceMethod_New(_xapian.LatLongCoords_empty)
LatLongCoords.append = _xapian.SWIG_PyInstanceMethod_New(_xapian.LatLongCoords_append)
LatLongCoords.unserialise = _xapian.SWIG_PyInstanceMethod_New(_xapian.LatLongCoords_unserialise)
LatLongCoords.serialise = _xapian.SWIG_PyInstanceMethod_New(_xapian.LatLongCoords_serialise)
LatLongCoords.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.LatLongCoords___str__)
LatLongCoords_swigregister = _xapian.LatLongCoords_swigregister
LatLongCoords_swigregister(LatLongCoords)


def __ne__(*args):
    return _xapian.__ne__(*args)
__ne__ = _xapian.__ne__
class LatLongMetric(object):
    """


    Base class for calculating distances between two lat/long coordinates.

    Experimental - seehttps://xapian.org/docs/deprecation#experimental-
    features 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    __swig_destroy__ = _xapian.delete_LatLongMetric

    def pointwise_distance(self, a, b):
        """


        Return the distance between two coordinates, in metres.

        virtual double Xapian::LatLongMetric::pointwise_distance(const
        LatLongCoord &a, const LatLongCoord &b) const =0 
        """
        return _xapian.LatLongMetric_pointwise_distance(self, a, b)


    def name(self):
        """


        Return the full name of the metric.

        virtual std::string Xapian::LatLongMetric::name() const =0

        This is used when serialising and unserialising metrics; for example,
        for performing remote searches.

        If the subclass is in a C++ namespace, the namespace should be
        included in the name, using "::" as a separator. For example, for a
        LatLongMetric subclass called "FooLatLongMetric" in the "Xapian"
        namespace the result of this call should be
        "Xapian::FooLatLongMetric". 
        """
        return _xapian.LatLongMetric_name(self)


    def __init__(self):
        if self.__class__ == LatLongMetric:
            _self = None
        else:
            _self = self
        _xapian.LatLongMetric_swiginit(self, _xapian.new_LatLongMetric(_self, ))
    def __disown__(self):
        self.this.disown()
        _xapian.disown_LatLongMetric(self)
        return weakref_proxy(self)
LatLongMetric.pointwise_distance = _xapian.SWIG_PyInstanceMethod_New(_xapian.LatLongMetric_pointwise_distance)
LatLongMetric.__call__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.LatLongMetric___call__)
LatLongMetric.name = _xapian.SWIG_PyInstanceMethod_New(_xapian.LatLongMetric_name)
LatLongMetric_swigregister = _xapian.LatLongMetric_swigregister
LatLongMetric_swigregister(LatLongMetric)

class GreatCircleMetric(LatLongMetric):
    """


    Calculate the great-circle distance between two coordinates on a
    sphere.

    Experimental - seehttps://xapian.org/docs/deprecation#experimental-
    features

    This uses the haversine formula to calculate the distance. Note that
    this formula is subject to inaccuracy due to numerical errors for
    coordinates on the opposite side of the sphere.

    Seehttps://en.wikipedia.org/wiki/Haversine_formula 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct a GreatCircleMetric using a specified radius.

        Xapian::GreatCircleMetric::GreatCircleMetric(double radius_)

        This is useful for data sets in which the points are not on Earth (eg,
        a database of features on Mars).

        Parameters:
        -----------

        radius_:  The radius of the sphere to use, in metres. 
        """
        _xapian.GreatCircleMetric_swiginit(self, _xapian.new_GreatCircleMetric(*args))
    __swig_destroy__ = _xapian.delete_GreatCircleMetric
GreatCircleMetric_swigregister = _xapian.GreatCircleMetric_swigregister
GreatCircleMetric_swigregister(GreatCircleMetric)

class LatLongDistancePostingSource(ValuePostingSource):
    """


    Posting source which returns a weight based on geospatial distance.

    Experimental - seehttps://xapian.org/docs/deprecation#experimental-
    features

    Results are weighted by the distance from a fixed point, or list of
    points, calculated according to the metric supplied. If multiple
    points are supplied (either in the constructor, or in the coordinates
    stored in a document), the closest pointwise distance is used.

    Documents further away than a specified maximum range (or with no
    location stored in the specified slot) will not be returned.

    The weight returned is computed from the distance using the formula:

    k1 * pow(distance + k1, -k2)

    (Where k1 and k2 are (strictly) positive, floating point constants,
    which default to 1000 and 1, respectively. Distance is measured in
    metres, so this means that something at the centre gets a weight of
    1.0, something 1km away gets a weight of 0.5, and something 3km away
    gets a weight of 0.25, etc) 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct a new posting source which returns only documents within
        range of one of the central coordinates.

        Xapian::LatLongDistancePostingSource::LatLongDistancePostingSource(Xapian::valueno
        slot_, const LatLongCoords &centre_, double max_range_=0.0, double
        k1_=1000.0, double k2_=1.0)

        Parameters:
        -----------

        slot_:  The value slot to read values from.

        centre_:  The centre point to use for distance calculations.

        max_range_:  The maximum distance for documents which are returned.

        k1_:  The k1 constant to use in the weighting function.

        k2_:  The k2 constant to use in the weighting function.

        Xapian::GreatCircleMetric is used as the metric. 
        """
        _xapian.LatLongDistancePostingSource_swiginit(self, _xapian.new_LatLongDistancePostingSource(*args))
    __swig_destroy__ = _xapian.delete_LatLongDistancePostingSource
LatLongDistancePostingSource_swigregister = _xapian.LatLongDistancePostingSource_swigregister
LatLongDistancePostingSource_swigregister(LatLongDistancePostingSource)

class LatLongDistanceKeyMaker(KeyMaker):
    """


    KeyMaker subclass which sorts by distance from a latitude/longitude.

    Experimental - seehttps://xapian.org/docs/deprecation#experimental-
    features

    Results are ordered by the distance from a fixed point, or list of
    points, calculated according to the metric supplied. If multiple
    points are supplied (either in the constructor, or in the coordinates
    stored in a document), the closest pointwise distance is used.

    If a document contains no coordinate stored in the specified slot, a
    special value for the distance will be used. This defaults to a large
    number, so that such results get a low rank, but may be specified by a
    constructor parameter. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """


        Construct a LatLongDistanceKeyMaker.

        Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker(Xapian::valueno
        slot_, const LatLongCoord &centre_)

        Parameters:
        -----------

        slot_:  Value slot to use.

        centre_:  Point to calculate distance from.

        Xapian::GreatCircleMetric is used as the metric.

        Documents where no value is set are assumed to be a large distance
        away. 
        """
        _xapian.LatLongDistanceKeyMaker_swiginit(self, _xapian.new_LatLongDistanceKeyMaker(*args))
    __swig_destroy__ = _xapian.delete_LatLongDistanceKeyMaker
LatLongDistanceKeyMaker_swigregister = _xapian.LatLongDistanceKeyMaker_swigregister
LatLongDistanceKeyMaker_swigregister(LatLongDistanceKeyMaker)

class Database(object):
    """


    This class is used to access a database, or a group of databases.

    For searching, this class is used in conjunction with an Enquire
    object.

    Parameters:
    -----------

    InvalidArgumentError:  will be thrown if an invalid argument is
    supplied, for example, an unknown database type.

    DatabaseOpeningError:  may be thrown if the database cannot be opened
    (for example, a required file cannot be found).

    DatabaseVersionError:  may be thrown if the database is in an
    unsupported format (for example, created by a newer version of Xapian
    which uses an incompatible format). 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def add_database(self, database):
        """


        Add an existing database (or group of databases) to those accessed by
        this object.

        void Xapian::Database::add_database(const Database &database)

        Parameters:
        -----------

        database:  the database(s) to add. 
        """
        return _xapian.Database_add_database(self, database)


    def size(self):
        """


        Return number of shards in this Database object.

        size_t Xapian::Database::size() const 
        """
        return _xapian.Database_size(self)


    def __init__(self, *args):
        """


        Copying is allowed.

        Xapian::Database::Database(const Database &other)

        The internals are reference counted, so copying is cheap.

        Parameters:
        -----------

        other:  The object to copy. 
        """
        _xapian.Database_swiginit(self, _xapian.new_Database(*args))
    __swig_destroy__ = _xapian.delete_Database

    def reopen(self):
        """


        Re-open the database.

        bool Xapian::Database::reopen()

        This re-opens the database(s) to the latest available version(s). It
        can be used either to make sure the latest results are returned, or to
        recover from a Xapian::DatabaseModifiedError.

        Calling reopen() on a database which has been closed (with  close())
        will always raise a Xapian::DatabaseError.

        true if the database might have been reopened (if false is returned,
        the database definitely hasn't been reopened, which applications may
        find useful when caching results, etc). In Xapian < 1.3.0, this method
        did not return a value. 
        """
        return _xapian.Database_reopen(self)


    def close(self):
        """


        Close the database.

        virtual void Xapian::Database::close()

        This closes the database and closes all its file handles.

        For a WritableDatabase, if a transaction is active it will be aborted,
        while if no transaction is active commit() will be implicitly called.
        Also the write lock is released.

        Closing a database cannot be undone - in particular, calling reopen()
        after close() will not reopen it, but will instead throw a
        Xapian::DatabaseError exception.

        Calling close() again on a database which has already been closed has
        no effect (and doesn't raise an exception).

        After close() has been called, calls to other methods of the database,
        and to methods of other objects associated with the database, will
        either:

        behave exactly as they would have done if the database had not been
        closed (this can only happen if all the required data is cached)

        raise a Xapian::DatabaseError exception indicating that the database
        is closed.

        The reason for this behaviour is that otherwise we'd have to check
        that the database is still open on every method call on every object
        associated with a Database, when in many cases they are working on
        data which has already been loaded and so they are able to just behave
        correctly.

        This method was added in Xapian 1.1.0. 
        """
        return _xapian.Database_close(self)


    def __str__(self):
        """


        Return a string describing this object.

        virtual std::string Xapian::Database::get_description() const 
        """
        return _xapian.Database___str__(self)


    def _postlist_begin(self, tname):
        """


        An iterator pointing to the start of the postlist for a given term.

        PostingIterator Xapian::Database::postlist_begin(const std::string
        &tname) const

        Parameters:
        -----------

        tname:  The termname to iterate postings for. If the term name is the
        empty string, the iterator returned will list all the documents in the
        database. Such an iterator will always return a WDF value of 1, since
        there is no obvious meaning for this quantity in this case. 
        """
        return _xapian.Database__postlist_begin(self, tname)


    def _postlist_end(self, arg2):
        """


        Corresponding end iterator to postlist_begin().

        PostingIterator Xapian::Database::postlist_end(const std::string &)
        const 
        """
        return _xapian.Database__postlist_end(self, arg2)


    def _termlist_begin(self, did):
        """


        An iterator pointing to the start of the termlist for a given
        document.

        TermIterator Xapian::Database::termlist_begin(Xapian::docid did) const

        Parameters:
        -----------

        did:  The document id of the document to iterate terms for. 
        """
        return _xapian.Database__termlist_begin(self, did)


    def _termlist_end(self, arg2):
        """


        Corresponding end iterator to termlist_begin().

        TermIterator Xapian::Database::termlist_end(Xapian::docid) const 
        """
        return _xapian.Database__termlist_end(self, arg2)


    def has_positions(self):
        """


        Does this database have any positional information?

        bool Xapian::Database::has_positions() const 
        """
        return _xapian.Database_has_positions(self)


    def _positionlist_begin(self, did, tname):
        """


        An iterator pointing to the start of the position list for a given
        term in a given document.

        PositionIterator Xapian::Database::positionlist_begin(Xapian::docid
        did, const std::string &tname) const 
        """
        return _xapian.Database__positionlist_begin(self, did, tname)


    def _positionlist_end(self, arg2, arg3):
        """


        Corresponding end iterator to positionlist_begin().

        PositionIterator Xapian::Database::positionlist_end(Xapian::docid,
        const std::string &) const 
        """
        return _xapian.Database__positionlist_end(self, arg2, arg3)


    def _allterms_begin(self, *args):
        """


        An iterator which runs across all terms with a given prefix.

        TermIterator Xapian::Database::allterms_begin(const std::string
        &prefix=std::string()) const

        Parameters:
        -----------

        prefix:  The prefix to restrict the returned terms to (default:
        iterate all terms) 
        """
        return _xapian.Database__allterms_begin(self, *args)


    def _allterms_end(self, *args):
        """


        Corresponding end iterator to allterms_begin(prefix).

        TermIterator Xapian::Database::allterms_end(const std::string
        &=std::string()) const 
        """
        return _xapian.Database__allterms_end(self, *args)


    def get_doccount(self):
        """


        Get the number of documents in the database.

        Xapian::doccount Xapian::Database::get_doccount() const 
        """
        return _xapian.Database_get_doccount(self)


    def get_lastdocid(self):
        """


        Get the highest document id which has been used in the database.

        Xapian::docid Xapian::Database::get_lastdocid() const 
        """
        return _xapian.Database_get_lastdocid(self)


    def get_avlength(self):
        """


        Get the average length of the documents in the database.

        Xapian::doclength Xapian::Database::get_avlength() const 
        """
        return _xapian.Database_get_avlength(self)


    def get_total_length(self):
        """


        Get the total length of all the documents in the database.

        Xapian::totallength Xapian::Database::get_total_length() const

        Added in Xapian 1.4.5. 
        """
        return _xapian.Database_get_total_length(self)


    def get_termfreq(self, tname):
        """


        Get the number of documents in the database indexed by a given term.

        Xapian::doccount Xapian::Database::get_termfreq(const std::string
        &tname) const 
        """
        return _xapian.Database_get_termfreq(self, tname)


    def term_exists(self, tname):
        """


        Check if a given term exists in the database.

        bool Xapian::Database::term_exists(const std::string &tname) const

        Parameters:
        -----------

        tname:  The term to test the existence of.

        true if and only if the term exists in the database. This is the same
        as (get_termfreq(tname) != 0), but will often be more efficient. 
        """
        return _xapian.Database_term_exists(self, tname)


    def get_collection_freq(self, tname):
        """


        Return the total number of occurrences of the given term.

        Xapian::termcount Xapian::Database::get_collection_freq(const
        std::string &tname) const

        This is the sum of the number of occurrences of the term in each
        document it indexes: i.e., the sum of the within document frequencies
        of the term.

        Parameters:
        -----------

        tname:  The term whose collection frequency is being requested. 
        """
        return _xapian.Database_get_collection_freq(self, tname)


    def get_value_freq(self, slot):
        """


        Return the frequency of a given value slot.

        Xapian::doccount Xapian::Database::get_value_freq(Xapian::valueno
        slot) const

        This is the number of documents which have a (non-empty) value stored
        in the slot.

        Parameters:
        -----------

        slot:  The value slot to examine. 
        """
        return _xapian.Database_get_value_freq(self, slot)


    def get_value_lower_bound(self, slot):
        """


        Get a lower bound on the values stored in the given value slot.

        std::string Xapian::Database::get_value_lower_bound(Xapian::valueno
        slot) const

        If there are no values stored in the given value slot, this will
        return an empty string.

        Parameters:
        -----------

        slot:  The value slot to examine. 
        """
        return _xapian.Database_get_value_lower_bound(self, slot)


    def get_value_upper_bound(self, slot):
        """


        Get an upper bound on the values stored in the given value slot.

        std::string Xapian::Database::get_value_upper_bound(Xapian::valueno
        slot) const

        If there are no values stored in the given value slot, this will
        return an empty string.

        Parameters:
        -----------

        slot:  The value slot to examine. 
        """
        return _xapian.Database_get_value_upper_bound(self, slot)


    def get_doclength_lower_bound(self):
        """


        Get a lower bound on the length of a document in this DB.

        Xapian::termcount Xapian::Database::get_doclength_lower_bound() const

        This bound does not include any zero-length documents. 
        """
        return _xapian.Database_get_doclength_lower_bound(self)


    def get_doclength_upper_bound(self):
        """


        Get an upper bound on the length of a document in this DB.

        Xapian::termcount Xapian::Database::get_doclength_upper_bound() const

        """
        return _xapian.Database_get_doclength_upper_bound(self)


    def get_wdf_upper_bound(self, term):
        """


        Get an upper bound on the wdf of term term.

        Xapian::termcount Xapian::Database::get_wdf_upper_bound(const
        std::string &term) const 
        """
        return _xapian.Database_get_wdf_upper_bound(self, term)


    def valuestream_begin(self, slot):
        """


        Return an iterator over the value in slot slot for each document.

        ValueIterator Xapian::Database::valuestream_begin(Xapian::valueno
        slot) const 
        """
        return _xapian.Database_valuestream_begin(self, slot)


    def valuestream_end(self, arg2):
        """


        Return end iterator corresponding to valuestream_begin().

        ValueIterator Xapian::Database::valuestream_end(Xapian::valueno) const

        """
        return _xapian.Database_valuestream_end(self, arg2)


    def get_doclength(self, did):
        """


        Get the length of a document.

        Xapian::termcount Xapian::Database::get_doclength(Xapian::docid did)
        const 
        """
        return _xapian.Database_get_doclength(self, did)


    def get_unique_terms(self, did):
        """


        Get the number of unique terms in document.

        Xapian::termcount Xapian::Database::get_unique_terms(Xapian::docid
        did) const 
        """
        return _xapian.Database_get_unique_terms(self, did)


    def keep_alive(self):
        """


        Send a "keep-alive" to remote databases to stop them timing out.

        void Xapian::Database::keep_alive()

        Has no effect on non-remote databases. 
        """
        return _xapian.Database_keep_alive(self)


    def get_document(self, *args):
        """


        Get a document from the database, given its document id.

        Xapian::Document Xapian::Database::get_document(Xapian::docid did,
        unsigned flags) const

        This method returns a Xapian::Document object which provides the
        information about a document.

        Parameters:
        -----------

        did:  The document id of the document to retrieve.

        flags:  Zero or more flags bitwise-or-ed together (currently only
        Xapian::DOC_ASSUME_VALID is supported).

        A Xapian::Document object containing the document data

        Parameters:
        -----------

        Xapian::DocNotFoundError:  The document specified could not be found
        in the database.

        Xapian::InvalidArgumentError:  did was 0, which is not a valid
        document id. 
        """
        return _xapian.Database_get_document(self, *args)


    def get_spelling_suggestion(self, word, max_edit_distance=2):
        """


        Suggest a spelling correction.

        std::string Xapian::Database::get_spelling_suggestion(const
        std::string &word, unsigned max_edit_distance=2) const

        Parameters:
        -----------

        word:  The potentially misspelled word.

        max_edit_distance:  Only consider words which are at most
        max_edit_distance edits from word. An edit is a character insertion,
        deletion, or the transposition of two adjacent characters (default is
        2). 
        """
        return _xapian.Database_get_spelling_suggestion(self, word, max_edit_distance)


    def _spellings_begin(self):
        """


        An iterator which returns all the spelling correction targets.

        Xapian::TermIterator Xapian::Database::spellings_begin() const

        This returns all the words which are considered as targets for the
        spelling correction algorithm. The frequency of each word is available
        as the term frequency of each entry in the returned iterator. 
        """
        return _xapian.Database__spellings_begin(self)


    def _spellings_end(self):
        """


        Corresponding end iterator to spellings_begin().

        Xapian::TermIterator Xapian::Database::spellings_end() const 
        """
        return _xapian.Database__spellings_end(self)


    def _synonyms_begin(self, term):
        """


        An iterator which returns all the synonyms for a given term.

        Xapian::TermIterator Xapian::Database::synonyms_begin(const
        std::string &term) const

        Parameters:
        -----------

        term:  The term to return synonyms for. 
        """
        return _xapian.Database__synonyms_begin(self, term)


    def _synonyms_end(self, arg2):
        """


        Corresponding end iterator to synonyms_begin(term).

        Xapian::TermIterator Xapian::Database::synonyms_end(const std::string
        &) const 
        """
        return _xapian.Database__synonyms_end(self, arg2)


    def _synonym_keys_begin(self, *args):
        """


        An iterator which returns all terms which have synonyms.

        Xapian::TermIterator Xapian::Database::synonym_keys_begin(const
        std::string &prefix=std::string()) const

        Parameters:
        -----------

        prefix:  If non-empty, only terms with this prefix are returned. 
        """
        return _xapian.Database__synonym_keys_begin(self, *args)


    def _synonym_keys_end(self, *args):
        """


        Corresponding end iterator to synonym_keys_begin(prefix).

        Xapian::TermIterator Xapian::Database::synonym_keys_end(const
        std::string &=std::string()) const 
        """
        return _xapian.Database__synonym_keys_end(self, *args)


    def get_metadata(self, key):
        """


        Get the user-specified metadata associated with a given key.

        std::string Xapian::Database::get_metadata(const std::string &key)
        const

        User-specified metadata allows you to store arbitrary information in
        the form of (key, value) pairs. See  WritableDatabase::set_metadata()
        for more information.

        When invoked on a Xapian::Database object representing multiple
        databases, currently only the metadata for the first is considered but
        this behaviour may change in the future.

        If there is no piece of metadata associated with the specified key, an
        empty string is returned (this applies even for backends which don't
        support metadata).

        Empty keys are not valid, and specifying one will cause an exception.

        Parameters:
        -----------

        key:  The key of the metadata item to access.

        The retrieved metadata item's value.

        Parameters:
        -----------

        Xapian::InvalidArgumentError:  will be thrown if the key supplied is
        empty. 
        """
        return _xapian.Database_get_metadata(self, key)


    def _metadata_keys_begin(self, *args):
        """


        An iterator which returns all user-specified metadata keys.

        Xapian::TermIterator Xapian::Database::metadata_keys_begin(const
        std::string &prefix=std::string()) const

        When invoked on a Xapian::Database object representing multiple
        databases, currently only the metadata for the first is considered but
        this behaviour may change in the future.

        If the backend doesn't support metadata, then this method returns an
        iterator which compares equal to that returned by metadata_keys_end().

        Parameters:
        -----------

        prefix:  If non-empty, only keys with this prefix are returned.

        Parameters:
        -----------

        Xapian::UnimplementedError:  will be thrown if the backend implements
        user-specified metadata, but doesn't implement iterating its keys
        (currently this happens for the InMemory backend). 
        """
        return _xapian.Database__metadata_keys_begin(self, *args)


    def _metadata_keys_end(self, *args):
        """


        Corresponding end iterator to metadata_keys_begin().

        Xapian::TermIterator Xapian::Database::metadata_keys_end(const
        std::string &=std::string()) const 
        """
        return _xapian.Database__metadata_keys_end(self, *args)


    def get_uuid(self):
        """


        Get a UUID for the database.

        std::string Xapian::Database::get_uuid() const

        The UUID will persist for the lifetime of the database.

        Replicas (eg, made with the replication protocol, or by copying all
        the database files) will have the same UUID. However, copies (made
        with copydatabase, or xapian-compact) will have different UUIDs.

        If the backend does not support UUIDs or this database has no
        subdatabases, the UUID will be empty.

        If this database has multiple sub-databases, the UUID string will
        contain the UUIDs of all the sub-databases. 
        """
        return _xapian.Database_get_uuid(self)


    def locked(self):
        """


        Test if this database is currently locked for writing.

        bool Xapian::Database::locked() const

        If the underlying object is actually a WritableDatabase, always
        returns true.

        Otherwise tests if there's a writer holding the lock (or if we can't
        test for a lock without taking it on the current platform, throw
        Xapian::UnimplementedError). If there's an error while trying to test
        the lock, throws Xapian::DatabaseLockError.

        For multi-databases, this tests each sub-database and returns true if
        any of them are locked. 
        """
        return _xapian.Database_locked(self)


    def get_revision(self):
        """


        Get the revision of the database.

        Xapian::rev Xapian::Database::get_revision() const

        The revision is an unsigned integer which increases with each commit.

        The database must have exactly one sub-database, which must be of type
        chert or glass. Otherwise an exception will be thrown.

        Experimental - seehttps://xapian.org/docs/deprecation#experimental-
        features 
        """
        return _xapian.Database_get_revision(self)

    check = staticmethod(_xapian.Database_check)

    def compact(self, *args):
        """


        Produce a compact version of this database.

        void Xapian::Database::compact(int fd, unsigned flags, int block_size,
        Xapian::Compactor &compactor)

        New 1.3.4. Various methods of the Compactor class were deprecated in
        1.3.4.

        The compactor functor allows handling progress output and specifying
        how user metadata is merged.

        This variant writes a single-file database to the specified file
        descriptor. Only the glass backend supports such databases, so this
        form is only supported for this backend.

        Parameters:
        -----------

        fd:  File descriptor to write the compact version to. The descriptor
        needs to be readable and writable (open with O_RDWR) and seekable. The
        current file offset is used, allowing compacting to a single file
        database embedded within another file. Xapian takes ownership of the
        file descriptor and will close it before returning.

        flags:  Any of the following combined using bitwise-or (| in C++):
        Xapian::DBCOMPACT_NO_RENUMBER By default the document ids will be
        renumbered the output - currently by applying the same offset to all
        the document ids in a particular source database. If this flag is
        specified, then this renumbering doesn't happen, but all the document
        ids must be unique over all source databases. Currently the ranges of
        document ids in each source must not overlap either, though this
        restriction may be removed in the future.

        Xapian::DBCOMPACT_MULTIPASS If merging more than 3 databases, merge
        the postlists in multiple passes, which is generally faster but
        requires more disk space for temporary files.

        Xapian::DBCOMPACT_SINGLE_FILE Produce a single-file database (only
        supported for glass currently) - this flag is implied in this form and
        need not be specified explicitly.

        block_size:  This specifies the block size (in bytes) for to use for
        the output. For glass, the block size must be a power of 2 between
        2048 and 65536 (inclusive), and the default (also used if an invalid
        value is passed) is 8192 bytes.

        compactor:  Functor 
        """
        return _xapian.Database_compact(self, *args)

Database.add_database = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_add_database)
Database.size = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_size)
Database.reopen = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_reopen)
Database.close = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_close)
Database.__str__ = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database___str__)
Database._postlist_begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database__postlist_begin)
Database._postlist_end = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database__postlist_end)
Database._termlist_begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database__termlist_begin)
Database._termlist_end = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database__termlist_end)
Database.has_positions = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_has_positions)
Database._positionlist_begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database__positionlist_begin)
Database._positionlist_end = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database__positionlist_end)
Database._allterms_begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database__allterms_begin)
Database._allterms_end = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database__allterms_end)
Database.get_doccount = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_get_doccount)
Database.get_lastdocid = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_get_lastdocid)
Database.get_avlength = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_get_avlength)
Database.get_total_length = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_get_total_length)
Database.get_termfreq = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_get_termfreq)
Database.term_exists = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_term_exists)
Database.get_collection_freq = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_get_collection_freq)
Database.get_value_freq = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_get_value_freq)
Database.get_value_lower_bound = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_get_value_lower_bound)
Database.get_value_upper_bound = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_get_value_upper_bound)
Database.get_doclength_lower_bound = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_get_doclength_lower_bound)
Database.get_doclength_upper_bound = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_get_doclength_upper_bound)
Database.get_wdf_upper_bound = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_get_wdf_upper_bound)
Database.valuestream_begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_valuestream_begin)
Database.valuestream_end = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_valuestream_end)
Database.get_doclength = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_get_doclength)
Database.get_unique_terms = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_get_unique_terms)
Database.keep_alive = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_keep_alive)
Database.get_document = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_get_document)
Database.get_spelling_suggestion = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_get_spelling_suggestion)
Database._spellings_begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database__spellings_begin)
Database._spellings_end = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database__spellings_end)
Database._synonyms_begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database__synonyms_begin)
Database._synonyms_end = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database__synonyms_end)
Database._synonym_keys_begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database__synonym_keys_begin)
Database._synonym_keys_end = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database__synonym_keys_end)
Database.get_metadata = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_get_metadata)
Database._metadata_keys_begin = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database__metadata_keys_begin)
Database._metadata_keys_end = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database__metadata_keys_end)
Database.get_uuid = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_get_uuid)
Database.locked = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_locked)
Database.get_revision = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_get_revision)
Database.compact = _xapian.SWIG_PyInstanceMethod_New(_xapian.Database_compact)
Database_swigregister = _xapian.Database_swigregister
Database_swigregister(Database)

def Database_check(fd, opts=0, out=None):
    return _xapian.Database_check(fd, opts, out)
Database_check = _xapian.Database_check

class WritableDatabase(Database):
    """


    This class provides read/write access to a database. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    __swig_destroy__ = _xapian.delete_WritableDatabase

    def __init__(self, *args):
        """


        Copying is allowed.

        Xapian::WritableDatabase::WritableDatabase(const WritableDatabase
        &other)

        The internals are reference counted, so copying is cheap.

        Parameters:
        -----------

        other:  The object to copy. 
        """
        _xapian.WritableDatabase_swiginit(self, _xapian.new_WritableDatabase(*args))

    def commit(self):
        """


        Commit any pending modifications made to the database.

        void Xapian::WritableDatabase::commit()

        For efficiency reasons, when performing multiple updates to a database
        it is best (indeed, almost essential) to make as many modifications as
        memory will permit in a single pass through the database. To ensure
        this, Xapian batches up modifications.

        This method may be called at any time to commit any pending
        modifications to the database.

        If any of the modifications fail, an exception will be thrown and the
        database will be left in a state in which each separate addition,
        replacement or deletion operation has either been fully performed or
        not performed at all: it is then up to the application to work out
        which operations need to be repeated.

        It's not valid to call commit() within a transaction.

        Beware of calling commit() too frequently: this will make indexing
        take much longer.

        Note that commit() need not be called explicitly: it will be called
        automatically when the database is closed, or when a sufficient number
        of modifications have been made. By default, this is every 10000
        documents added, deleted, or modified. This value is rather
        conservative, and if you have a machine with plenty of memory, you can
        improve indexing throughput dramatically by setting
        XAPIAN_FLUSH_THRESHOLD in the environment to a larger value.

        This method was new in Xapian 1.1.0 - in earlier versions it was
        called flush().

        Parameters:
        -----------

        Xapian::DatabaseError:  will be thrown if a problem occurs while
        modifying the database.

        Xapian::DatabaseCorruptError:  will be thrown if the database is in a
        corrupt state. 
        """
        return _xapian.WritableDatabase_commit(self)


    def flush(self):
        """


        Pre-1.1.0 name for commit().

        void Xapian::WritableDatabase::flush()

        Use commit() instead. 
        """
        return _xapian.WritableDatabase_flush(self)


    def begin_transaction(self, flushed=True):
        """


        Begin a transaction.

        void Xapian::WritableDatabase::begin_transaction(bool flushed=true)

        In Xapian a transaction is a group of modifications to the database
        which are linked such that either all will be applied simultaneously
        or none will be applied at all. Even in the case of a power failure,
        this characteristic should be preserved (as long as the filesystem
        isn't corrupted, etc).

        A transaction is started with begin_transaction() and can either be
        committed by calling commit_transaction() or aborted by calling
        cancel_transaction().

        By default, a transaction implicitly calls commit() before and after
        so that the modifications stand and fall without affecting
        modifications before or after.

        The downside of these implicit calls to commit() is that small
        transactions can harm indexing performance in the same way that
        explicitly calling commit() frequently can.

        If you're applying atomic groups of changes and only wish to ensure
        that each group is either applied or not applied, then you can prevent
        the automatic commit() before and after the transaction by starting
        the transaction with begin_transaction(false). However, if
        cancel_transaction is called (or if commit_transaction isn't called
        before the WritableDatabase object is destroyed) then any changes
        which were pending before the transaction began will also be
        discarded.

        Transactions aren't currently supported by the InMemory backend.

        Parameters:
        -----------

        flushed:  Is this a flushed transaction? By default transactions are
        "flushed", which means that committing a transaction will ensure
        those changes are permanently written to the database. By contrast,
        unflushed transactions only ensure that changes within the transaction
        are either all applied or all aren't.

        Parameters:
        -----------

        Xapian::UnimplementedError:  will be thrown if transactions are not
        available for this database type.

        Xapian::InvalidOperationError:  will be thrown if this is called at an
        invalid time, such as when a transaction is already in progress. 
        """
        return _xapian.WritableDatabase_begin_transaction(self, flushed)


    def commit_transaction(self):
        """


        Complete the transaction currently in progress.

        void Xapian::WritableDatabase::commit_transaction()

        If this method completes successfully and this is a flushed
        transaction, all the database modifications made during the
        transaction will have been committed to the database.

        If an error occurs, an exception will be thrown, and none of the
        modifications made to the database during the transaction will have
        been applied to the database.

        In all cases the transaction will no longer be in progress.

        Parameters:
        -----------

        Xapian::DatabaseError:  will be thrown if a problem occurs while
        modifying the database.

        Xapian::DatabaseCorruptError:  will be thrown if the database is in a
        corrupt state.

        Xapian::InvalidOperationError:  will be thrown if a transaction is not
        currently in progress.

        Xapian::UnimplementedError:  will be thrown if transactions are not
        available for this database type. 
        """
        return _xapian.WritableDatabase_commit_transaction(self)


    def cancel_transaction(self):
        """


        Abort the transaction currently in progress, discarding the pending
        modifications made to the database.

        void Xapian::WritableDatabase::cancel_transaction()

        If an error occurs in this method, an exception will be thrown, but
        the transaction will be cancelled anyway.

        Parameters:
        -----------

        Xapian::DatabaseError:  will be thrown if a problem occurs while
        modifying the database.

        Xapian::DatabaseCorruptError:  will be thrown if the database is in a
        corrupt state.

        Xapian::InvalidOperationError:  will be thrown if a transaction is not
        currently in progress.

        Xapian::UnimplementedError:  will be thrown if transactions are not
        available for this database type. 
        """
        return _xapian.WritableDatabase_cancel_transaction(self)


    def add_document(self, document):
        """


        Add a new document to the database.

        Xapian::docid Xapian::WritableDatabase::add_document(const
        Xapian::Document &document)

        This method adds the specified document to the database, returning a
        newly allocated document ID. Automatically allocated document IDs come
        from a per-database monotonically increasing counter, so IDs from
        deleted documents won't be reused.

        If you want to specify the document ID to be used, you should call
        replace_document() instead.

        Note that changes to the database won't be immediately committed to
        disk; see commit() for more details.

        As with all database modification operations, the effect is atomic:
        the document will either be fully added, or the document fails to be
        added and an exception is thrown (possibly at a later time when
        commit() is called or the database is closed).

        Parameters:
        -----------

        document:  The new document to be added.

        The document ID of the newly added document.

        Parameters:
        -----------

        Xapian::DatabaseError:  will be thrown if a problem occurs while
        writing to the database.

        Xapian::DatabaseCorruptError:  will be thrown if the database is in a
        corrupt state. 
        """
        return _xapian.WritableDatabase_add_document(self, document)


    def delete_document(self, *args):
        """


        Delete any documents indexed by a term from the database.

        void Xapian::WritableDatabase::delete_document(const std::string
        &unique_term)

        This method removes any documents indexed by the specified term from
        the database.

        A major use is for convenience when UIDs from another system are
        mapped to terms in Xapian, although this method has other uses (for
        example, you could add a "deletion date" term to documents at index
        time and use this method to delete all documents due for deletion on a
        particular date).

        Parameters:
        -----------

        unique_term:  The term to remove references to.

        Parameters:
        -----------

        Xapian::DatabaseError:  will be thrown if a problem occurs while
        writing to the database.

        Xapian::DatabaseCorruptError:  will be thrown if the database is in a
        corrupt state. 
        """
        return _xapian.WritableDatabase_delete_document(self, *args)


    def replace_document(self, *args):
        """


        Replace any documents matching a term.

        Xapian::docid Xapian::WritableDatabase::replace_document(const
        std::string &unique_term, const Xapian::Document &document)

        This method replaces any documents indexed by the specified term with
        the specified document. If any documents are indexed by the term, the
        lowest document ID will be used for the document, otherwise a new
        document ID will be generated as for add_document.

        One common use is to allow UIDs from another system to easily be
        mapped to terms in Xapian. Note that this method doesn't automatically
        add unique_term as a term, so you'll need to call
        document.add_term(unique_term) first when using replace_document() in
        this way.

        Note that changes to the database won't be immediately committed to
        disk; see commit() for more details.

        As with all database modification operations, the effect is atomic:
        the document(s) will either be fully replaced, or the document(s) fail
        to be replaced and an exception is thrown (possibly at a later time
        when commit() is called or the database is closed).

        Parameters:
        -----------

        unique_term:  The "unique" term.

        document:  The new document.

        The document ID that document was given.

        Parameters:
        -----------

        Xapian::DatabaseError:  will be thrown if a problem occurs while
        writing to the database.

        Xapian::DatabaseCorruptError:  will be thrown if the database is in a
        corrupt state. 
        """
        return _xapian.WritableDatabase_replace_document(self, *args)


    def add_spelling(self, word, freqinc=1):
        """


        Add a word to the spelling dictionary.

        void Xapian::WritableDatabase::add_spelling(const std::string &word,
        Xapian::termcount freqinc=1) const

        If the word is already present, its frequency is increased.

        Parameters:
        -----------

        word:  The word to add.

        freqinc:  How much to increase its frequency by (default 1). 
        """
        return _xapian.WritableDatabase_add_spelling(self, word, freqinc)


    def remove_spelling(self, word, freqdec=1):
        """


        Remove a word from the spelling dictionary.

        void Xapian::WritableDatabase::remove_spelling(const std::string
        &word, Xapian::termcount freqdec=1) const

        The word's frequency is decreased, and if would become zero or less
        then the word is removed completely.

        Parameters:
        -----------

        word:  The word to remove.

        freqdec:  How much to decrease its frequency by (default 1). 
        """
        return _xapian.WritableDatabase_remove_spelling(self, word, freqdec)


    def add_synonym(self, term, synonym):
        """


        Add a synonym for a term.

        void Xapian::WritableDatabase::add_synonym(const std::string &term,
        const std::string &synonym) const

        Parameters:
        -----------

        term:  The term to add a synonym for.

        synonym:  The synonym to add. If this is already a synonym for term,
        then no action is taken. 
        """
        return _xapian.WritableDatabase_add_synonym(self, term, synonym)


    def remove_synonym(self, term, synonym):
        """


        Remove a synonym for a term.

        void Xapian::WritableDatabase::remove_synonym(const std::string &term,
        const std::string &synonym) const

        Parameters:
        -----------

        term:  The term to remove a synonym for.

        synonym:  The synonym to remove. If this isn't currently a synonym for
        term, then no action is taken. 
        """
        return _xapian.WritableDatabase_remove_synonym(self, term, synonym)


    def clear_synonyms(self, term):
        """


        Remove all synonyms for a term.

        void Xapian::WritableDatabase::clear_synonyms(const std::string &term)
        const

        Parameters:
        -----------

        term:  The term to remove all synonyms for. If the term has no
        synonyms, no action is taken. 
        """
        return _xapian.WritableDatabase_clear_synonyms(self, term)


    def set_metadata(self, key, metadata):
        """


        Set the user-specified metadata associated with a given key.

        void Xapian::WritableDatabase::set_metadata(const std::string &key,
        const std::string &metadata)

        This method sets the metadata value associated with a given key. If
        there is already a metadata value stored in the database with the same
        key, the old value is replaced. If you want to delete an existing item
        of metadata, just set its value to the empty string.

        User-specified metadata allows you to store arbitrary information in
        the form of (key, value) pairs.

        There's no hard limit on the number of metadata items, or the size of
        the metadata values. Metadata keys have a limited length, which depend
        on the backend. We recommend limiting them to 200 bytes. Empty keys
        are not valid, and specifying one will cause an exception.

        Metadata modifications are committed to disk in the same way as
        modifications to the documents in the database are: i.e.,
        modifications are atomic, and won't be committed to disk immediately
        (see commit() for more details). This allows metadata to be used to
        link databases with versioned external resources by storing the
        appropriate version number in a metadata item.

        You can also use the metadata to store arbitrary extra information
        associated with terms, documents, or postings by encoding the termname
        and/or document id into the metadata key.

        Parameters:
        -----------

        key:  The key of the metadata item to set.

        metadata:  The value of the metadata item to set.

        Parameters:
        -----------

        Xapian::DatabaseError:  will be thrown if a problem occurs while
        writing to the database.

        Xapian::DatabaseCorruptError:  will be thrown if the database is in a
        corrupt state.

        Xapian::InvalidArgumentError:  will be thrown if the key supplied is
        empty.

        Xapian::UnimplementedError:  will be thrown if the database backend in
        use doesn't support user- specified metadata. 
        """
        return _xapian.WritableDatabase_set_metadata(self, key, metadata)

WritableDatabase.commit = _xapian.SWIG_PyInstanceMethod_New(_xapian.WritableDatabase_commit)
WritableDatabase.flush = _xapian.SWIG_PyInstanceMethod_New(_xapian.WritableDatabase_flush)
WritableDatabase.begin_transaction = _xapian.SWIG_PyInstanceMethod_New(_xapian.WritableDatabase_begin_transaction)
WritableDatabase.commit_transaction = _xapian.SWIG_PyInstanceMethod_New(_xapian.WritableDatabase_commit_transaction)
WritableDatabase.cancel_transaction = _xapian.SWIG_PyInstanceMethod_New(_xapian.WritableDatabase_cancel_transaction)
WritableDatabase.add_document = _xapian.SWIG_PyInstanceMethod_New(_xapian.WritableDatabase_add_document)
WritableDatabase.delete_document = _xapian.SWIG_PyInstanceMethod_New(_xapian.WritableDatabase_delete_document)
WritableDatabase.replace_document = _xapian.SWIG_PyInstanceMethod_New(_xapian.WritableDatabase_replace_document)
WritableDatabase.add_spelling = _xapian.SWIG_PyInstanceMethod_New(_xapian.WritableDatabase_add_spelling)
WritableDatabase.remove_spelling = _xapian.SWIG_PyInstanceMethod_New(_xapian.WritableDatabase_remove_spelling)
WritableDatabase.add_synonym = _xapian.SWIG_PyInstanceMethod_New(_xapian.WritableDatabase_add_synonym)
WritableDatabase.remove_synonym = _xapian.SWIG_PyInstanceMethod_New(_xapian.WritableDatabase_remove_synonym)
WritableDatabase.clear_synonyms = _xapian.SWIG_PyInstanceMethod_New(_xapian.WritableDatabase_clear_synonyms)
WritableDatabase.set_metadata = _xapian.SWIG_PyInstanceMethod_New(_xapian.WritableDatabase_set_metadata)
WritableDatabase_swigregister = _xapian.WritableDatabase_swigregister
WritableDatabase_swigregister(WritableDatabase)


def remote_open(*args):
    """


    Construct a Database object for read-only access to a remote database
    accessed via a program.

    Database Xapian::Remote::open(const std::string &program, const
    std::string &args, useconds_t timeout=10000)

    Access to the remote database is done by running an external program
    and communicating with it on stdin/stdout.

    Parameters:
    -----------

    program:  the external program to run.

    args:  space-separated list of arguments to pass to program.

    timeout:  timeout in milliseconds. If this timeout is exceeded for any
    individual operation on the remote database then
    Xapian::NetworkTimeoutError is thrown. A timeout of 0 means don't
    timeout. (Default is 10000ms, which is 10 seconds). 
    """
    return _xapian.remote_open(*args)

def remote_open_writable(*args):
    """


    Construct a WritableDatabase object for update access to a remote
    database accessed via a program.

    WritableDatabase Xapian::Remote::open_writable(const std::string
    &program, const std::string &args, useconds_t timeout=0, int flags=0)

    Access to the remote database is done by running an external program
    and communicating with it on stdin/stdout.

    Parameters:
    -----------

    program:  the external program to run.

    args:  space-separated list of arguments to pass to program.

    timeout:  timeout in milliseconds. If this timeout is exceeded for any
    individual operation on the remote database then
    Xapian::NetworkTimeoutError is thrown. (Default is 0, which means
    don't timeout).

    flags:   Xapian::DB_RETRY_LOCK or 0. 
    """
    return _xapian.remote_open_writable(*args)


# Set the documentation format - this is used by tools like "epydoc" to decide
# how to format the documentation strings.
__docformat__ = "restructuredtext en"

##################################
# Support for iteration of MSets #
##################################

class MSetItem(object):
    """An item returned from iteration of the MSet.

    The item supports access to the following attributes and properties:

     - `docid`: The Xapian document ID corresponding to this MSet item.
     - `weight`: The weight corresponding to this MSet item.
     - `rank`: The rank of this MSet item.  The rank is the position in the
       total set of matching documents of this item.  The highest document is
       given a rank of 0.  If the MSet did not start at the highest matching
       document, because a non-zero 'start' parameter was supplied to
       get_mset(), the first document in the MSet will have a rank greater than
       0 (in fact, it will be equal to the value of 'start' supplied to
       get_mset()).
     - `percent`: The percentage score assigned to this MSet item.
     - `document`: The document for this MSet item.  This can be used to access
       the document data, or any other information stored in the document (such
       as term lists).  It is lazily evaluated.
     - `collapse_key`: The value of the key which was used for collapsing.
     - `collapse_count`: An estimate of the number of documents that have been
       collapsed into this one.

    The collapse count estimate will always be less than or equal to the actual
    number of other documents satisfying the match criteria with the same
    collapse key as this document.  If may be 0 even though there are other
    documents with the same collapse key which satisfying the match criteria.
    However if this method returns non-zero, there definitely are other such
    documents.  So this method may be used to inform the user that there are
    "at least N other matches in this group", or to control whether to offer a
    "show other documents in this group" feature (but note that it may not
    offer it in every case where it would show other documents).

    """

    __slots__ = ('_mset', '_firstitem', 'docid', 'weight', 'rank',
                 'percent', 'collapse_key', 'collapse_count', '_document', )

    def __init__(self, iter, mset):
        self._mset = mset
        self._firstitem = self._mset.get_firstitem()
        self.docid = iter.get_docid()
        self.weight = iter.get_weight()
        self.rank = iter.get_rank()
        self.percent = iter.get_percent()
        self.collapse_key = iter.get_collapse_key()
        self.collapse_count = iter.get_collapse_count()
        self._document = None

    def _get_document(self):
        if self._document is None:
            self._document = self._mset._get_hit_internal(self.rank - self._firstitem).get_document()
        return self._document

    document = property(_get_document, doc="The document object corresponding to this MSet item.")

class MSetIter(object):
    """An iterator over the items in an MSet.

    The iterator will return MSetItem objects, which will be evaluated lazily
    where appropriate.

    """
    __slots__ = ('_iter', '_end', '_mset')
    def __init__(self, mset):
        self._iter = mset._begin()
        self._end = mset._end()
        self._mset = mset

    def __iter__(self):
        return self

    def __next__(self):
        if self._iter == self._end:
            raise StopIteration
        else:
            r = MSetItem(self._iter, self._mset)
            next(self._iter)
            return r

# Modify the MSet to allow access to the python iterators, and have other
# convenience methods.

def _mset_gen_iter(self):
    """Return an iterator over the MSet.

    The iterator will return MSetItem objects, which will be evaluated lazily
    where appropriate.

    """
    return MSetIter(self)
MSet.__iter__ = _mset_gen_iter

MSet.__len__ = lambda self: MSet.size(self)

def _mset_getitem(self, index):
    """Get an item from the MSet.

    The supplied index is relative to the start of the MSet, not the absolute
    rank of the item.

    Returns an MSetItem.

    """
    if index < 0:
        index += len(self)
    if index < 0 or index >= len(self):
        raise IndexError("Mset index out of range")
    return MSetItem(self._get_hit_internal(index), self)
MSet.__getitem__ = _mset_getitem
MSet.get_hit = _mset_getitem


##################################
# Support for iteration of ESets #
##################################

class ESetItem(object):
    """An item returned from iteration of the ESet.

    The item supports access to the following attributes:

     - `term`: The term corresponding to this ESet item.
     - `weight`: The weight corresponding to this ESet item.

    """
    __slots__ = ('term', 'weight')

    def __init__(self, iter):
        self.term = iter.get_term()
        self.weight = iter.get_weight()

class ESetIter(object):
    """An iterator over the items in an ESet.

    The iterator will return ESetItem objects.

    """
    __slots__ = ('_iter', '_end')
    def __init__(self, eset):
        self._iter = eset._begin()
        self._end = eset._end()

    def __iter__(self):
        return self

    def __next__(self):
        if self._iter == self._end:
            raise StopIteration
        else:
            r = ESetItem(self._iter)
            next(self._iter)
            return r

# Modify the ESet to allow access to the python iterators, and have other
# convenience methods.

def _eset_gen_iter(self):
    """Return an iterator over the ESet.

    The iterator will return ESetItem objects.

    """
    return ESetIter(self)
ESet.__iter__ = _eset_gen_iter

ESet.__len__ = lambda self: ESet.size(self)


#######################################
# Support for iteration of term lists #
#######################################

class TermListItem(object):
    """An item returned from iteration of a term list.

    The item supports access to the following attributes and properties:

     - `term`: The term corresponding to this TermListItem.
     - `wdf`: The within document frequency of this term.
     - `termfreq`: The number of documents in the collection which are indexed
       by the term
     - `positer`: An iterator over the positions which the term appears at in
       the document.  This is only available until the iterator which returned
       this item next moves.

    """
    __slots__ = ('_iter', 'term', '_wdf', '_termfreq')

    def __init__(self, iter, term):
        self._iter = iter
        self.term = term
        self._wdf = None
        self._termfreq = None

        if iter._has_wdf == TermIter.EAGER:
            self._wdf = iter._iter.get_wdf()
        if iter._has_termfreq == TermIter.EAGER:
            self._termfreq = iter._iter.get_termfreq()

# Support for sequence API
        sequence = ['term', 'wdf', 'termfreq', 'positer']
        if iter._has_wdf == TermIter.INVALID:
            sequence[1] = 0
        if iter._has_termfreq == TermIter.INVALID:
            sequence[2] = 0
        if iter._has_positions == TermIter.INVALID:
            sequence[3] = PositionIter()

    def _get_wdf(self):
        """Get the within-document-frequency of the current term.

        This will raise a InvalidOperationError exception if the iterator this
        item came from doesn't support within-document-frequencies.

        """
        if self._wdf is None:
            if self._iter._has_wdf == TermIter.INVALID:
                raise InvalidOperationError("Iterator does not support wdfs")
            if self.term is not self._iter._lastterm:
                raise InvalidOperationError("Iterator has moved, and does not support random access")
            self._wdf = self._iter._iter.get_wdf()
        return self._wdf
    wdf = property(_get_wdf, doc=
    """The within-document-frequency of the current term (if meaningful).

    This will raise a InvalidOperationError exception if the iterator
    this item came from doesn't support within-document-frequencies.

    """)

    def _get_termfreq(self):
        """Get the term frequency.

        This is the number of documents in the collection which are indexed by
        the term.

        This will raise a InvalidOperationError exception if the iterator this
        item came from doesn't support term frequencies.

        """
        if self._termfreq is None:
            if self._iter._has_termfreq == TermIter.INVALID:
                raise InvalidOperationError("Iterator does not support term frequencies")
            if self.term is not self._iter._lastterm:
                raise InvalidOperationError("Iterator has moved, and does not support random access")
            self._termfreq = self._iter._iter.get_termfreq()
        return self._termfreq
    termfreq = property(_get_termfreq, doc=
    """The term frequency of the current term (if meaningful).

    This is the number of documents in the collection which are indexed by the
    term.

    This will raise a InvalidOperationError exception if the iterator
    this item came from doesn't support term frequencies.

    """)

    def _get_positer(self):
        """Get a position list iterator.

        The iterator will return integers representing the positions that the
        term occurs at.

        This will raise a InvalidOperationError exception if the iterator this
        item came from doesn't support position lists, or if the iterator has
        moved on since the item was returned from it.

        """
        if self._iter._has_positions == TermIter.INVALID:
            raise InvalidOperationError("Iterator does not support position lists")
# Access to position lists is always lazy, so we don't need to check
# _has_positions.
        if self.term is not self._iter._lastterm:
            raise InvalidOperationError("Iterator has moved, and does not support random access")
        return PositionIter(self._iter._iter._positionlist_begin(),
                            self._iter._iter._positionlist_end())
    positer = property(_get_positer, doc=
    """A position iterator for the current term (if meaningful).

    The iterator will return integers representing the positions that the term
    occurs at.

    This will raise a InvalidOperationError exception if the iterator this item
    came from doesn't support position lists, or if the iterator has moved on
    since the item was returned from it.

    """)


class TermIter(object):
    """An iterator over a term list.

    The iterator will return TermListItem objects, which will be evaluated
    lazily where appropriate.

    """
    __slots__ = ('_iter', '_end', '_has_termfreq', '_has_wdf',
                 '_has_positions', '_return_strings', '_lastterm', '_moved')

    INVALID = 0
    LAZY = 1
    EAGER = 2

    def __init__(self, start, end, has_termfreq=INVALID,
                 has_wdf=INVALID, has_positions=INVALID,
                 return_strings=False):
        self._iter = start
        self._end = end
        self._has_termfreq = has_termfreq
        self._has_wdf = has_wdf
        self._has_positions = has_positions
        assert(has_positions != TermIter.EAGER) # Can't do eager access to position lists
        self._return_strings = return_strings
        self._lastterm = None # Used to test if the iterator has moved

# _moved is True if we've moved onto the next item.  This is needed so
# that the iterator doesn't have to move on until just before next() is
# called: since the iterator starts by pointing at a valid item, we
# can't just call next(self._iter) unconditionally at the start of our
# __next__() method.
        self._moved = True

    def __iter__(self):
        return self

    def __next__(self):
        if not self._moved:
            next(self._iter)
            self._moved = True

        if self._iter == self._end:
            self._lastterm = None
            raise StopIteration
        else:
            self._lastterm = self._iter.get_term()
            self._moved = False
            if self._return_strings:
                return self._lastterm
            return TermListItem(self, self._lastterm)

    def skip_to(self, term):
        """Skip the iterator forward.

        The iterator is advanced to the first term at or after the current
        position which is greater than or equal to the supplied term.

        If there are no such items, this will raise StopIteration.

        This returns the item which the iterator is moved to.  The subsequent
        item will be returned the next time that next() is called (unless
        skip_to() is called again first).

        """
        if self._iter != self._end:
            self._iter.skip_to(term)

        if self._iter == self._end:
            self._lastterm = None
            self._moved = True
            raise StopIteration

# Update self._lastterm if the iterator has moved.
# TermListItems compare a saved value of lastterm with self._lastterm
# with the object identity comparator, so it is important to ensure
# that it does not get modified if the new term compares equal.
        newterm = self._iter.get_term()
        if newterm != self._lastterm:
            self._lastterm = newterm

        self._moved = False
        if self._return_strings:
            return self._lastterm
        return TermListItem(self, self._lastterm)

# Modify Enquire to add a "matching_terms()" method.
def _enquire_gen_iter(self, which):
    """Get an iterator over the terms which match a given match set item.

    The match set item to consider is specified by the `which` parameter, which
    may be a document ID, or an MSetItem object.

    The iterator will return string objects.

    """
    if isinstance(which, MSetItem):
        which = which.docid
    return TermIter(self._get_matching_terms_begin(which),
                    self._get_matching_terms_end(which),
                    return_strings=True)
Enquire.matching_terms = _enquire_gen_iter

# Modify Query to add an "__iter__()" method.
def _query_gen_iter(self):
    """Get an iterator over the terms in a query.

    The iterator will return string objects.

    """
    return TermIter(self._get_terms_begin(),
                    self._get_terms_end(),
                    return_strings=True)
Query.__iter__ = _query_gen_iter

# Modify Database to add an "__iter__()" method and an "allterms()" method.
def _database_gen_allterms_iter(self, prefix=None):
    """Get an iterator over all the terms in the database.

    The iterator will return TermListItem objects, but these will not support
    access to wdf, or position information.

    Access to term frequency information is only available until the iterator
    has moved on.

    If prefix is supplied, only terms which start with that prefix will be
    returned.

    """
    if prefix is None:
        return TermIter(self._allterms_begin(), self._allterms_end(),
                        has_termfreq=TermIter.LAZY)
    else:
        return TermIter(self._allterms_begin(prefix), self._allterms_end(prefix),
                        has_termfreq=TermIter.LAZY)
Database.__iter__ = _database_gen_allterms_iter
Database.allterms = _database_gen_allterms_iter

# Modify Database to add a "termlist()" method.
def _database_gen_termlist_iter(self, docid):
    """Get an iterator over all the terms which index a given document ID.

    The iterator will return TermListItem objects.

    Access to term frequency and position information is only available until
    the iterator has moved on.

    """
# Note: has_termfreq is set to LAZY because most databases don't store term
# frequencies in the termlist (because this would require updating many termlist
# entries for every document update), so access to the term frequency requires a
# separate lookup.
    return TermIter(self._termlist_begin(docid), self._termlist_end(docid),
                    has_termfreq=TermIter.LAZY,
                    has_wdf=TermIter.EAGER,
                    has_positions=TermIter.LAZY)
Database.termlist = _database_gen_termlist_iter

# Modify Database to add a "spellings()" method.
def _database_gen_spellings_iter(self):
    """Get an iterator which returns all the spelling correction targets

    The iterator will return TermListItem objects.  Only the term frequency is
    available; wdf and positions are not meaningful.

    """
    return TermIter(self._spellings_begin(), self._spellings_end(),
                    has_termfreq=TermIter.EAGER,
                    has_wdf=TermIter.INVALID,
                    has_positions=TermIter.INVALID)
Database.spellings = _database_gen_spellings_iter

# Modify Database to add a "synonyms()" method.
def _database_gen_synonyms_iter(self, term):
    """Get an iterator which returns all the synonyms for a given term.

    The term to return synonyms for is specified by the `term` parameter.

    The iterator will return string objects.

    """
    return TermIter(self._synonyms_begin(term),
                    self._synonyms_end(term),
                    return_strings=True)
Database.synonyms = _database_gen_synonyms_iter

# Modify Database to add a "synonym_keys()" method.
def _database_gen_synonym_keys_iter(self, prefix=""):
    """Get an iterator which returns all the terms which have synonyms.

    The iterator will return string objects.

    If `prefix` is non-empty, only terms with this prefix are returned.

    """
    return TermIter(self._synonym_keys_begin(prefix),
                    self._synonym_keys_end(prefix),
                    return_strings=True)
Database.synonym_keys = _database_gen_synonym_keys_iter

# Modify Database to add a "metadata_keys()" method, instead of direct access
# to metadata_keys_begin and metadata_keys_end.
def _database_gen_metadata_keys_iter(self, prefix=""):
    """Get an iterator which returns all the metadata keys.

    The iterator will return string objects.

    If `prefix` is non-empty, only metadata keys with this prefix are returned.

    """
    return TermIter(self._metadata_keys_begin(prefix),
                    self._metadata_keys_end(prefix),
                    return_strings=True)
Database.metadata_keys = _database_gen_metadata_keys_iter

# Modify Document to add an "__iter__()" method and a "termlist()" method.
def _document_gen_termlist_iter(self):
    """Get an iterator over all the terms in a document.

    The iterator will return TermListItem objects.

    Access to term frequency and position information is only available until
    the iterator has moved on.

    Note that term frequency information is only meaningful for a document
    retrieved from a database.  If term frequency information is requested for
    a document which was freshly created, an InvalidOperationError will be
    raised.

    """
# Note: document termlist iterators may be implemented entirely in-memory
# (in which case access to all items could be allowed eagerly), but may
# also be implemented by returning a database termlist (for documents which
# are stored in a database, rather than freshly created).  We choose the
# most conservative settings, to avoid doing eager access when lazy access
# would be more appropriate.
    return TermIter(self._termlist_begin(), self._termlist_end(),
                    has_termfreq=TermIter.LAZY,
                    has_wdf=TermIter.EAGER,
                    has_positions=TermIter.LAZY)
Document.__iter__ = _document_gen_termlist_iter
Document.termlist = _document_gen_termlist_iter

# Modify QueryParser to add a "stoplist()" method.
def _queryparser_gen_stoplist_iter(self):
    """Get an iterator over all the stopped terms from the previous query.

    This returns an iterator over all the terms which were omitted from the
    previously parsed query due to being considered to be stopwords.  Each
    instance of a word omitted from the query is represented in the returned
    list, in the order in which the

    The iterator will return string objects.

    """
    return TermIter(self._stoplist_begin(), self._stoplist_end(),
                    return_strings=True)
QueryParser.stoplist = _queryparser_gen_stoplist_iter

# Modify QueryParser to add an "unstemlist()" method.
def _queryparser_gen_unstemlist_iter(self, tname):
    """Get an iterator over all the unstemmed forms of a stemmed term.

    This returns an iterator which returns all the unstemmed words which were
    stemmed to the stemmed form specified by `tname` when parsing the previous
    query.  Each instance of a word which stems to `tname` is returned by the
    iterator in the order in which the words appeared in the query - an
    individual unstemmed word may thus occur multiple times.

    The iterator will return string objects.

    """
    return TermIter(self._unstem_begin(tname), self._unstem_end(tname),
                    return_strings=True)
QueryParser.unstemlist = _queryparser_gen_unstemlist_iter

# Modify ValueCountMatchSpy to add an "values()" method.
def wrapper():
    begin = ValueCountMatchSpy.values_begin
    del ValueCountMatchSpy.values_begin
    end = ValueCountMatchSpy.values_end
    del ValueCountMatchSpy.values_end
    def values(self):
        """Get an iterator over all the values in the slot.

        Values will be returned in ascending alphabetical order.

        The iterator will return TermListItem objects: the value can be
        accessed as the `term` property, and the frequency can be accessed as
        the `termfreq` property.

        """
        return TermIter(begin(self), end(self), has_termfreq=TermIter.EAGER)
    return values
ValueCountMatchSpy.values = wrapper()
del wrapper

# Modify ValueCountMatchSpy to add an "top_values()" method.
def wrapper():
    begin = ValueCountMatchSpy.top_values_begin
    del ValueCountMatchSpy.top_values_begin
    end = ValueCountMatchSpy.top_values_end
    del ValueCountMatchSpy.top_values_end
    def top_values(self, maxvalues):
        """Get an iterator over the most frequent values for the slot.

        Values will be returned in descending order of frequency.  Values with
        the same frequency will be returned in ascending alphabetical order.

        The iterator will return TermListItem objects: the value can be
        accessed as the `term` property, and the frequency can be accessed as
        the `termfreq` property.

        """
        return TermIter(begin(self, maxvalues), end(self, maxvalues),
                        has_termfreq=TermIter.EAGER)
    return top_values
ValueCountMatchSpy.top_values = wrapper()
del wrapper

# When we make a query, keep a note of postingsources involved, so they won't
# be deleted. This hack can probably be removed once xapian bug #186 is fixed.
__query_init_orig = Query.__init__
def _query_init(self, *args):
    """Make a new query object.

    Many possible arguments are possible - see the documentation for details.

    """
    ps = []
    if len(args) == 1 and isinstance(args[0], PostingSource):
        ps.append(args[0])
    else:
        for arg in args:
            if isinstance(arg, Query):
                ps.extend(getattr(arg, '_ps', []))
            elif hasattr(arg, '__iter__'):
                for listarg in arg:
                    if isinstance(listarg, Query):
                        ps.extend(getattr(listarg, '_ps', []))
    __query_init_orig(self, *args)
    self._ps = ps
Query.__init__ = _query_init
del _query_init

# When setting a query on enquire, keep a note of postingsources involved, so
# they won't be deleted. This hack can probably be removed once xapian bug #186
# is fixed.
__enquire_set_query_orig = Enquire.set_query
def _enquire_set_query(self, query, qlen=0):
    self._ps = getattr(query, '_ps', [])
    return __enquire_set_query_orig(self, query, qlen)
_enquire_set_query.__doc__ = __enquire_set_query_orig.__doc__
Enquire.set_query = _enquire_set_query
del _enquire_set_query

# When getting  a query from enquire, keep a note of postingsources involved,
# so they won't be deleted. This hack can probably be removed once xapian bug
# #186 is fixed.
__enquire_get_query_orig = Enquire.get_query
def _enquire_get_query(self):
    query = __enquire_get_query_orig(self)
    query._ps = getattr(self, '_ps', [])
    return query
_enquire_get_query.__doc__ = __enquire_get_query_orig.__doc__
Enquire.get_query = _enquire_get_query
del _enquire_get_query

# When we set a ValueRangeProcessor into the QueryParser, keep a python
# reference so it won't be deleted. This hack can probably be removed once
# xapian bug #186 is fixed.
__queryparser_add_valuerangeprocessor_orig = QueryParser.add_valuerangeprocessor
def _queryparser_add_valuerangeprocessor(self, vrproc):
    if not hasattr(self, '_vrps'):
        self._vrps = []
    self._vrps.append(vrproc)
    return __queryparser_add_valuerangeprocessor_orig(self, vrproc)
_queryparser_add_valuerangeprocessor.__doc__ = __queryparser_add_valuerangeprocessor_orig.__doc__
QueryParser.add_valuerangeprocessor = _queryparser_add_valuerangeprocessor
del _queryparser_add_valuerangeprocessor

# When we set a RangeProcessor into the QueryParser, keep a python
# reference so it won't be deleted. This hack can probably be removed once
# xapian bug #186 is fixed.
__queryparser_add_rangeprocessor_orig = QueryParser.add_rangeprocessor
def _queryparser_add_rangeprocessor(self, rproc):
    if not hasattr(self, '_rps'):
        self._rps = []
    self._rps.append(rproc)
    return __queryparser_add_rangeprocessor_orig(self, rproc)
_queryparser_add_rangeprocessor.__doc__ = __queryparser_add_rangeprocessor_orig.__doc__
QueryParser.add_rangeprocessor = _queryparser_add_rangeprocessor
del _queryparser_add_rangeprocessor

# When we set a FieldProcessor into the QueryParser, keep a python
# reference so it won't be deleted. This hack can probably be removed once
# xapian bug #186 is fixed.
__queryparser_add_prefix_orig = QueryParser.add_prefix
def _queryparser_add_prefix(self, s, proc):
    if not isinstance(proc, (str, bytes)):
        if not hasattr(self, '_fps'):
            self._fps = []
        self._fps.append(proc)
    return __queryparser_add_prefix_orig(self, s, proc)
_queryparser_add_prefix.__doc__ = __queryparser_add_prefix_orig.__doc__
QueryParser.add_prefix = _queryparser_add_prefix
del _queryparser_add_prefix
__queryparser_add_boolean_prefix_orig = QueryParser.add_boolean_prefix
def _queryparser_add_boolean_prefix(self, s, proc, exclusive = True):
    if not isinstance(proc, (str, bytes)):
        if not hasattr(self, '_fps'):
            self._fps = []
        self._fps.append(proc)
    return __queryparser_add_boolean_prefix_orig(self, s, proc, exclusive)
_queryparser_add_boolean_prefix.__doc__ = __queryparser_add_boolean_prefix_orig.__doc__
QueryParser.add_boolean_prefix = _queryparser_add_boolean_prefix
del _queryparser_add_boolean_prefix

# When we set a Stopper into the QueryParser, keep a python reference so it
# won't be deleted. This hack can probably be removed once xapian bug #186 is
# fixed.
__queryparser_set_stopper_orig = QueryParser.set_stopper
def _queryparser_set_stopper(self, stopper):
    self._stopper = stopper
    return __queryparser_set_stopper_orig(self, stopper)
_queryparser_set_stopper.__doc__ = __queryparser_set_stopper_orig.__doc__
QueryParser.set_stopper = _queryparser_set_stopper
del _queryparser_set_stopper

# When we set a Stopper into the TermGenerator, keep a python reference so it
# won't be deleted. This hack can probably be removed once xapian bug #186 is
# fixed.
__termgenerator_set_stopper_orig = TermGenerator.set_stopper
def _termgenerator_set_stopper(self, stopper):
    self._stopper = stopper
    return __termgenerator_set_stopper_orig(self, stopper)
_termgenerator_set_stopper.__doc__ = __termgenerator_set_stopper_orig.__doc__
TermGenerator.set_stopper = _termgenerator_set_stopper
del _termgenerator_set_stopper

# When we set a Sorter on enquire, keep a python reference so it won't be
# deleted.  This hack can probably be removed once xapian bug #186 is fixed.
__enquire_set_sort_by_key_orig = Enquire.set_sort_by_key
def _enquire_set_sort_by_key(self, sorter, reverse):
    self._sorter = sorter
    return __enquire_set_sort_by_key_orig(self, sorter, reverse)
_enquire_set_sort_by_key.__doc__ = __enquire_set_sort_by_key_orig.__doc__
Enquire.set_sort_by_key = _enquire_set_sort_by_key
del _enquire_set_sort_by_key

__enquire_set_sort_by_key_then_relevance_orig = Enquire.set_sort_by_key_then_relevance
def _enquire_set_sort_by_key_then_relevance(self, sorter, reverse):
    self._sorter = sorter
    return __enquire_set_sort_by_key_then_relevance_orig(self, sorter, reverse)
_enquire_set_sort_by_key_then_relevance.__doc__ = __enquire_set_sort_by_key_then_relevance_orig.__doc__
Enquire.set_sort_by_key_then_relevance = _enquire_set_sort_by_key_then_relevance
del _enquire_set_sort_by_key_then_relevance

__enquire_set_sort_by_relevance_then_key_orig = Enquire.set_sort_by_relevance_then_key
def _enquire_set_sort_by_relevance_then_key(self, sorter, reverse):
    self._sorter = sorter
    return __enquire_set_sort_by_relevance_then_key_orig(self, sorter, reverse)
_enquire_set_sort_by_relevance_then_key.__doc__ = __enquire_set_sort_by_relevance_then_key_orig.__doc__
Enquire.set_sort_by_relevance_then_key = _enquire_set_sort_by_relevance_then_key
del _enquire_set_sort_by_relevance_then_key


##########################################
# Support for iteration of posting lists #
##########################################

class PostingItem(object):
    """An item returned from iteration of a posting list.

    The item supports access to the following attributes and properties:

     - `docid`: The document ID corresponding to this PostingItem.
     - `doclength`: The length of the document corresponding to this
       PostingItem.
     - `wdf`: The within document frequency of the term which the posting list
       is for in the document corresponding to this PostingItem.
     - `positer`: An iterator over the positions which the term corresponing to
       this posting list occurs at in the document corresponding to this
       PostingItem.  This is only available until the iterator which returned
       this item next moves.

    """
    __slots__ = ('_iter', 'docid', 'doclength', 'wdf',)

    def __init__(self, iter):
        self._iter = iter
        self.docid = iter._iter.get_docid()
        self.doclength = iter._iter.get_doclength()
        self.wdf = iter._iter.get_wdf()

# Support for sequence API
        sequence = ['docid', 'doclength', 'wdf', 'positer']
        if not iter._has_positions:
            sequence[3] = PositionIter()

    def _get_positer(self):
        """Get a position list iterator.

        The iterator will return integers representing the positions that the
        term occurs at in the document corresponding to this PostingItem.

        This will raise a InvalidOperationError exception if the iterator this
        item came from doesn't support position lists, or if the iterator has
        moved on since the item was returned from it.

        """
        if not self._iter._has_positions:
            raise InvalidOperationError("Iterator does not support position lists")
        if self._iter._iter == self._iter._end or \
           self.docid != self._iter._iter.get_docid():
            raise InvalidOperationError("Iterator has moved, and does not support random access")
        return PositionIter(self._iter._iter._positionlist_begin(),
                            self._iter._iter._positionlist_end())
    positer = property(_get_positer, doc=
    """A position iterator for the current posting (if meaningful).

    The iterator will return integers representing the positions that the term
    occurs at.

    This will raise a InvalidOperationError exception if the iterator this item
    came from doesn't support position lists, or if the iterator has moved on
    since the item was returned from it.

    """)


class PostingIter(object):
    """An iterator over a posting list.

    The iterator will return PostingItem objects, which will be evaluated
    lazily where appropriate.

    """
    __slots__ = ('_iter', '_end', '_has_positions', '_moved')

    def __init__(self, start, end, has_positions=False):
        self._iter = start
        self._end = end
        self._has_positions = has_positions

# _moved is True if we've moved onto the next item.  This is needed so
# that the iterator doesn't have to move on until just before next() is
# called: since the iterator starts by pointing at a valid item, we
# can't just call next(self._iter) unconditionally at the start of our
# __next__() method.
        self._moved = True

    def __iter__(self):
        return self

    def __next__(self):
        if not self._moved:
            next(self._iter)
            self._moved = True

        if self._iter == self._end:
            raise StopIteration
        else:
            self._moved = False
            return PostingItem(self)

    def skip_to(self, docid):
        """Skip the iterator forward.

        The iterator is advanced to the first document with a document ID
        which is greater than or equal to the supplied document ID.

        If there are no such items, this will raise StopIteration.

        This returns the item which the iterator is moved to.  The subsequent
        item will be returned the next time that next() is called (unless
        skip_to() is called again first).

        """
        if self._iter != self._end:
            self._iter.skip_to(docid)
        if self._iter == self._end:
            self._moved = True
            raise StopIteration
        self._moved = False
        return PostingItem(self)

def _database_gen_postlist_iter(self, tname):
    """Get an iterator over the postings which are indexed by a given term.

    If `tname` is empty, an iterator over all the documents will be returned
    (this will contain one entry for each document, will always return a wdf of
    1, and will not allow access to a position iterator).

    """
    if len(tname) != 0:
        return PostingIter(self._postlist_begin(tname), self._postlist_end(tname),
                           has_positions=True)
    else:
        return PostingIter(self._postlist_begin(tname), self._postlist_end(tname))
Database.postlist = _database_gen_postlist_iter


###########################################
# Support for iteration of position lists #
###########################################

class PositionIter(object):
    """An iterator over a position list.

    The iterator will return integers, in ascending order.

    """
    def __init__(self, start = 0, end = 0):
        self.iter = start
        self.end = end

    def __iter__(self):
        return self

    def __next__(self):
        if self.iter==self.end:
            raise StopIteration
        else:
            r = self.iter.get_termpos()
            next(self.iter)
            return r

# Modify Database to add a "positionlist()" method.
def _database_gen_positionlist_iter(self, docid, tname):
    """Get an iterator over all the positions in a given document of a term.

    The iterator will return integers, in ascending order.

    """
    return PositionIter(self._positionlist_begin(docid, tname), self._positionlist_end(docid, tname))
Database.positionlist = _database_gen_positionlist_iter

########################################
# Support for iteration of value lists #
########################################

class ValueItem(object):
    """An item returned from iteration of the values in a document.

    The item supports access to the following attributes:

     - `num`: The number of the value.
     - `value`: The contents of the value.

    """

    __slots__ = ('num', 'value', )

    def __init__(self, num, value):
        self.num = num
        self.value = value

class ValueIter(object):
    """An iterator over all the values stored in a document.

    The iterator will return ValueItem objects, in ascending order of value number.

    """
    def __init__(self, start, end):
        self.iter = start
        self.end = end

    def __iter__(self):
        return self

    def __next__(self):
        if self.iter==self.end:
            raise StopIteration
        else:
            r = ValueItem(self.iter.get_valueno(), self.iter.get_value())
            next(self.iter)
            return r

# Modify Document to add a "values()" method.
def _document_gen_values_iter(self):
    """Get an iterator over all the values stored in a document.

    The iterator will return ValueItem objects, in ascending order of value number.

    """
    return ValueIter(self._values_begin(), self._values_end())
Document.values = _document_gen_values_iter


##########################################
# Support for iteration of value streams #
##########################################

class ValueStreamItem(object):
    """An item returned from iteration of the values in a document.

    The item supports access to the following attributes:

     - `docid`: The docid for the item.
     - `value`: The contents of the value.

    """

    __slots__ = ('docid', 'value', )

    def __init__(self, docid, value):
        self.docid = docid
        self.value = value

class ValueStreamIter(object):
    """An iterator over all the values stored in a document.

    The iterator will return ValueStreamItem objects, in ascending order of value number.

    """
    def __init__(self, start, end):
        self.iter = start
        self.end = end
        self.moved = True

    def __iter__(self):
        return self

    def __next__(self):
        if not self.moved:
            self.iter.__next__()
            self.moved = True

        if self.iter==self.end:
            raise StopIteration
        else:
            self.moved = False
            return ValueStreamItem(self.iter.get_docid(), self.iter.get_value())

    def skip_to(self, docid):
        """Skip the iterator forward.

        The iterator is advanced to the first document with a document ID
        which is greater than or equal to the supplied document ID.

        If there are no such items, this will raise StopIteration.

        This returns the item which the iterator is moved to.  The subsequent
        item will be returned the next time that next() is called (unless
        skip_to() is called again first).

        """
        if self.iter != self.end:
            self.iter.skip_to(docid)
        if self.iter == self.end:
            self.moved = True
            raise StopIteration
        self.moved = False
        return ValueStreamItem(self.iter.get_docid(), self.iter.get_value())

# Modify Database to add a "valuestream()" method, and remove the
# valuestream_begin() and valuestream_end() methods.
def wrapper():
    vs_begin = Database.valuestream_begin
    del Database.valuestream_begin
    vs_end = Database.valuestream_end
    del Database.valuestream_end
    def valuestream(self, slot):
        """Get an iterator over all the values stored in a slot in the database.

        The iterator will return ValueStreamItem objects, in ascending order of
        document id.

        """
        return ValueStreamIter(vs_begin(self, slot), vs_end(self, slot))
    return valuestream
Database.valuestream = wrapper()
del wrapper

##########################################
# Support for iteration of LatLongCoords #
##########################################

class LatLongCoordsIter(object):
    """An iterator over all the coordinates in a LatLongCoords object.

    The iterator returns LatLongCoord objects.

    """
    def __init__(self, start, end):
        self.iter = start
        self.end = end

    def __iter__(self):
        return self

    def __eq__(self, other):
        return self.equals(other)

    def __ne__(self, other):
        return not self.equals(other)

    def __next__(self):
        if self.iter.equals(self.end):
            raise StopIteration
        else:
            r = self.iter.get_coord()
            self.iter.__next__()
            return r

# Modify LatLongCoords to make it iterable.
def _latlongcoords_iter(self):
    """Get an iterator over all the coordinates in a LatLongCoords.

    The iterator will return xapian.LatLongCoord objects.

    """
    return LatLongCoordsIter(self.begin(), self.end())
LatLongCoords.__iter__ = _latlongcoords_iter
del _latlongcoords_iter
del LatLongCoordsIterator

# Fix up Enquire so that it keeps a python reference to the deciders supplied
# to it so that they won't be deleted before the Enquire object.  This hack can
# probably be removed once xapian bug #186 is fixed.
_enquire_add_matchspy_orig = Enquire.add_matchspy
def _enquire_match_spy_add(self, decider):
    if not hasattr(self, '_deciders'):
        self._deciders = []
    self._deciders.append(decider)
    _enquire_add_matchspy_orig(self, decider)
_enquire_match_spy_add.__doc__ = Enquire.add_matchspy.__doc__
Enquire.add_matchspy = _enquire_match_spy_add

_enquire_clear_matchspies_orig = Enquire.clear_matchspies
def _enquire_match_spies_clear(self):
    _enquire_clear_matchspies_orig(self)
    if hasattr(self, '_deciders'):
        del self._deciders
_enquire_match_spies_clear.__doc__ = Enquire.clear_matchspies.__doc__
Enquire.clear_matchspies = _enquire_match_spies_clear


# Fix up Stem.__init__() so that it calls __disown__() on the passed
# StemImplementation object so that Python won't delete it from under us.
_stem_init_orig = Stem.__init__
def _stem_init(self, *args):
    _stem_init_orig(self, *args)
    if len(args) > 0 and isinstance(args[0], StemImplementation):
        args[0].__disown__()
_stem_init.__doc__ = Stem.__init__.__doc__
Stem.__init__ = _stem_init


# Remove static methods which shouldn't be in the API.
del Document_unserialise
del Query_unserialise
del Stem_get_available_languages

# Add wrappers for Query::MatchAll and Query::MatchNothing
Query.MatchAll = Query("")
Query.MatchNothing = Query()


# Set the list of names which should be public.
# Note that this needs to happen at the end of xapian.py.
__all__ = []
for item in dir():
    if item.startswith('_') or item.endswith('_swigregister') or item.endswith('Iterator'):
        continue
    __all__.append(item)
__all__ = tuple(__all__)



