/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.File;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.SaveToFile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class SaveAction
extends SaveActionBase {
    private static SaveAction instance = new SaveAction();
    private final PropertyChangeListener updateOnRequireSaveChange = evt -> {
        if (OsmDataLayer.REQUIRES_SAVE_TO_DISK_PROP.equals(evt.getPropertyName())) {
            this.updateEnabledState();
        }
    };

    private SaveAction() {
        super(I18n.tr("Save", new Object[0]), "save", I18n.tr("Save the current data.", new Object[0]), Shortcut.registerShortcut("system:save", I18n.tr("File: {0}", I18n.tr("Save", new Object[0])), 83, 5006));
        this.setHelpId(HelpUtil.ht("/Action/Save"));
    }

    public static SaveAction getInstance() {
        return instance;
    }

    @Override
    protected JosmAction.LayerChangeAdapter buildLayerChangeAdapter() {
        return new JosmAction.LayerChangeAdapter(){

            @Override
            public void layerAdded(LayerManager.LayerAddEvent e) {
                if (e.getAddedLayer() instanceof OsmDataLayer) {
                    e.getAddedLayer().addPropertyChangeListener(SaveAction.this.updateOnRequireSaveChange);
                }
                super.layerAdded(e);
            }

            @Override
            public void layerRemoving(LayerManager.LayerRemoveEvent e) {
                if (e.getRemovedLayer() instanceof OsmDataLayer) {
                    e.getRemovedLayer().removePropertyChangeListener(SaveAction.this.updateOnRequireSaveChange);
                }
                super.layerRemoving(e);
            }
        };
    }

    @Override
    protected void updateEnabledState() {
        Layer activeLayer = this.getLayerManager().getActiveLayer();
        this.setEnabled(activeLayer != null && activeLayer.isSavable() && (activeLayer.getAssociatedFile() == null || !(activeLayer instanceof SaveToFile) || ((SaveToFile)((Object)activeLayer)).requiresSaveToFile()));
    }

    @Override
    public File getFile(Layer layer) {
        ExtendedDialog dialog;
        File f = layer.getAssociatedFile();
        if (f != null && !f.exists()) {
            f = null;
        }
        if (f != null && layer instanceof GpxLayer && (dialog = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Overwrite", new Object[0]), I18n.tr("Overwrite", new Object[0]), I18n.tr("Cancel", new Object[0])).setButtonIcons("save_as", "cancel").setContent(I18n.tr("File {0} exists. Overwrite?", f.getName()))).showDialog().getValue() != 1) {
            f = null;
        }
        return f == null ? layer.createAndOpenSaveFileChooser() : f;
    }
}

