/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.gui.mappaint.mapcss.Functions;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public final class ExpressionFactory {
    private static final List<Method> arrayFunctions = new ArrayList<Method>();
    private static final List<Method> parameterFunctions = new ArrayList<Method>();
    private static final List<Method> parameterFunctionsEnv = new ArrayList<Method>();

    private ExpressionFactory() {
    }

    public static Expression createFunctionExpression(String name, List<Expression> args) {
        if ("cond".equals(name) && args.size() == 3) {
            return new CondOperator(args.get(0), args.get(1), args.get(2));
        }
        if ("and".equals(name)) {
            return new AndOperator(args);
        }
        if ("or".equals(name)) {
            return new OrOperator(args);
        }
        if ("length".equals(name) && args.size() == 1) {
            return new LengthFunction(args.get(0));
        }
        if ("max".equals(name) && !args.isEmpty()) {
            return new MinMaxFunction(args, true);
        }
        if ("min".equals(name) && !args.isEmpty()) {
            return new MinMaxFunction(args, false);
        }
        for (Method m : arrayFunctions) {
            if (!m.getName().equals(name)) continue;
            return new ArrayFunction(m, args);
        }
        for (Method m : parameterFunctions) {
            if (!m.getName().equals(name) || args.size() != m.getParameterTypes().length) continue;
            return new ParameterFunction(m, args, false);
        }
        for (Method m : parameterFunctionsEnv) {
            if (!m.getName().equals(name) || args.size() != m.getParameterTypes().length - 1) continue;
            return new ParameterFunction(m, args, true);
        }
        return NullExpression.INSTANCE;
    }

    static {
        for (Method m : Functions.class.getDeclaredMethods()) {
            Class<?>[] paramTypes = m.getParameterTypes();
            if (paramTypes.length == 1 && paramTypes[0].isArray()) {
                arrayFunctions.add(m);
                continue;
            }
            if (paramTypes.length >= 1 && paramTypes[0].equals(Environment.class)) {
                parameterFunctionsEnv.add(m);
                continue;
            }
            parameterFunctions.add(m);
        }
        try {
            parameterFunctions.add(Math.class.getMethod("abs", Float.TYPE));
            parameterFunctions.add(Math.class.getMethod("acos", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("asin", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("atan", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("atan2", Double.TYPE, Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("ceil", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("cos", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("cosh", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("exp", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("floor", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("log", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("max", Float.TYPE, Float.TYPE));
            parameterFunctions.add(Math.class.getMethod("min", Float.TYPE, Float.TYPE));
            parameterFunctions.add(Math.class.getMethod("random", new Class[0]));
            parameterFunctions.add(Math.class.getMethod("round", Float.TYPE));
            parameterFunctions.add(Math.class.getMethod("signum", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("sin", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("sinh", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("sqrt", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("tan", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("tanh", Double.TYPE));
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new JosmRuntimeException(ex);
        }
    }

    public static class ArrayFunction
    implements Expression {
        private final Method m;
        private final boolean nullable;
        private final List<Expression> args;
        private final Class<?>[] expectedParameterTypes;
        private final Class<?> arrayComponentType;

        public ArrayFunction(Method m, List<Expression> args) {
            this.m = m;
            this.nullable = m.getAnnotation(NullableArguments.class) != null;
            this.args = args;
            this.expectedParameterTypes = m.getParameterTypes();
            this.arrayComponentType = this.expectedParameterTypes[0].getComponentType();
        }

        @Override
        public Object evaluate(Environment env) {
            Object[] convertedArgs = new Object[this.expectedParameterTypes.length];
            Object arrayArg = Array.newInstance(this.arrayComponentType, this.args.size());
            for (int i = 0; i < this.args.size(); ++i) {
                Object o = Cascade.convertTo(this.args.get(i).evaluate(env), this.arrayComponentType);
                if (o == null && !this.nullable) {
                    return null;
                }
                Array.set(arrayArg, i, o);
            }
            convertedArgs[0] = arrayArg;
            Object result = null;
            try {
                result = this.m.invoke(null, convertedArgs);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new JosmRuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                Logging.error(ex);
                return null;
            }
            return result;
        }

        public String toString() {
            StringBuilder b = new StringBuilder("ArrayFunction~");
            b.append(this.m.getName()).append('(');
            for (int i = 0; i < this.args.size(); ++i) {
                if (i > 0) {
                    b.append(',');
                }
                b.append(this.arrayComponentType).append(' ').append(this.args.get(i));
            }
            b.append(')');
            return b.toString();
        }
    }

    public static class ParameterFunction
    implements Expression {
        private final Method m;
        private final boolean nullable;
        private final List<Expression> args;
        private final Class<?>[] expectedParameterTypes;
        private final boolean needsEnvironment;

        public ParameterFunction(Method m, List<Expression> args, boolean needsEnvironment) {
            this.m = m;
            this.nullable = m.getAnnotation(NullableArguments.class) != null;
            this.args = args;
            this.expectedParameterTypes = m.getParameterTypes();
            this.needsEnvironment = needsEnvironment;
        }

        public final Method getMethod() {
            return this.m;
        }

        public final List<Expression> getArgs() {
            return this.args;
        }

        @Override
        public Object evaluate(Environment env) {
            Object[] convertedArgs;
            int start = 0;
            int offset = 0;
            if (this.needsEnvironment) {
                start = 1;
                offset = 1;
                convertedArgs = new Object[this.args.size() + 1];
                convertedArgs[0] = env;
            } else {
                convertedArgs = new Object[this.args.size()];
            }
            for (int i = start; i < convertedArgs.length; ++i) {
                if (this.expectedParameterTypes[i].isArray()) {
                    Class<?> clazz = this.expectedParameterTypes[i].getComponentType();
                    Object[] varargs = (Object[])Array.newInstance(clazz, this.args.size() - i + 1);
                    for (int j = 0; j < this.args.size() - i + 1; ++j) {
                        varargs[j] = Cascade.convertTo(this.args.get(j + i - 1).evaluate(env), clazz);
                    }
                    convertedArgs[i] = this.expectedParameterTypes[i].cast(varargs);
                    break;
                }
                convertedArgs[i] = Cascade.convertTo(this.args.get(i - offset).evaluate(env), this.expectedParameterTypes[i]);
                if (convertedArgs[i] != null || this.nullable) continue;
                return null;
            }
            Object result = null;
            try {
                result = this.m.invoke(null, convertedArgs);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new JosmRuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                Logging.error(ex);
                return null;
            }
            return result;
        }

        public String toString() {
            StringBuilder b = new StringBuilder("ParameterFunction~");
            b.append(this.m.getName()).append('(');
            for (int i = 0; i < this.expectedParameterTypes.length; ++i) {
                if (i > 0) {
                    b.append(',');
                }
                b.append(this.expectedParameterTypes[i]);
                if (!this.needsEnvironment) {
                    b.append(' ').append(this.args.get(i));
                    continue;
                }
                if (i <= 0) continue;
                b.append(' ').append(this.args.get(i - 1));
            }
            b.append(')');
            return b.toString();
        }
    }

    public static class MinMaxFunction
    implements Expression {
        private final List<Expression> args;
        private final boolean computeMax;

        public MinMaxFunction(List<Expression> args, boolean computeMax) {
            this.args = args;
            this.computeMax = computeMax;
        }

        public Float aggregateList(List<?> lst) {
            List<Float> floats = Utils.transform(lst, x -> Cascade.convertTo(x, Float.TYPE));
            SubclassFilteredCollection<Float, Float> nonNullList = SubclassFilteredCollection.filter(floats, Objects::nonNull);
            return nonNullList.isEmpty() ? Float.valueOf(Float.NaN) : (this.computeMax ? (Float)Collections.max(nonNullList) : (Float)Collections.min(nonNullList));
        }

        @Override
        public Object evaluate(Environment env) {
            List<Object> l = Cascade.convertTo(this.args.get(0).evaluate(env), List.class);
            if (this.args.size() != 1 || l == null) {
                l = Utils.transform(this.args, x -> x.evaluate(env));
            }
            return this.aggregateList(l);
        }
    }

    public static class LengthFunction
    implements Expression {
        private final Expression arg;

        public LengthFunction(Expression args) {
            this.arg = args;
        }

        @Override
        public Object evaluate(Environment env) {
            List l = Cascade.convertTo(this.arg.evaluate(env), List.class);
            if (l != null) {
                return l.size();
            }
            String s = Cascade.convertTo(this.arg.evaluate(env), String.class);
            if (s != null) {
                return s.length();
            }
            return null;
        }
    }

    public static class OrOperator
    implements Expression {
        private final List<Expression> args;

        public OrOperator(List<Expression> args) {
            this.args = args;
        }

        @Override
        public Object evaluate(Environment env) {
            for (Expression arg : this.args) {
                Boolean b = Cascade.convertTo(arg.evaluate(env), Boolean.TYPE);
                if (b == null || !b.booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    public static class AndOperator
    implements Expression {
        private final List<Expression> args;

        public AndOperator(List<Expression> args) {
            this.args = args;
        }

        @Override
        public Object evaluate(Environment env) {
            for (Expression arg : this.args) {
                Boolean b = Cascade.convertTo(arg.evaluate(env), Boolean.TYPE);
                if (b != null && b.booleanValue()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
    }

    public static class CondOperator
    implements Expression {
        private final Expression condition;
        private final Expression firstOption;
        private final Expression secondOption;

        public CondOperator(Expression condition, Expression firstOption, Expression secondOption) {
            this.condition = condition;
            this.firstOption = firstOption;
            this.secondOption = secondOption;
        }

        @Override
        public Object evaluate(Environment env) {
            Boolean b = Cascade.convertTo(this.condition.evaluate(env), Boolean.TYPE);
            if (b != null && b.booleanValue()) {
                return this.firstOption.evaluate(env);
            }
            return this.secondOption.evaluate(env);
        }
    }

    public static class NullExpression
    implements Expression {
        public static final NullExpression INSTANCE = new NullExpression();

        @Override
        public Object evaluate(Environment env) {
            return null;
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface NullableArguments {
    }
}

