"""Locale information.
Holds a map from ISO 3166-1 country code (e.g. GB) to a dict.
Each dict maps from an ISO 639-1 language code (e.g. ja) to the country's name in that language.

Generated from java.util.Locale, generation info:
  java.version=11.0.1
  java.vendor=Oracle Corporation
  os.name=Mac OS X
  os.arch=x86_64
  os.version=10.13.6

Auto-generated file, do not edit by hand.
"""
from ..util import u
LOCALE_DATA = {
  'AD': {'aa':'Andorra','ab':'*aa','ae':'*aa','af':'*aa','ak':'Andora','am':u('\u12a0\u1295\u12f6\u122b'),'an':'*aa','ar':u('\u0623\u0646\u062f\u0648\u0631\u0627'),'as':u('\u0986\u09a8\u09cd\u09a6\u09cb\u09f0\u09be'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u0410\u043d\u0434\u043e\u0440\u0430'),'bg':'*be','bh':'*aa','bi':'*aa','bm':u('And\u0254r'),'bn':u('\u0986\u09a8\u09cd\u09a1\u09cb\u09b0\u09be'),'bo':'*aa','br':'*aa','bs':'*ak','ca':'*aa','ce':u('\u0410\u043d\u0434\u043e\u0440\u0440\u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f68\u0f71\u0f53\u0f0b\u0f51\u0f7c\u0f0b\u0f62'),'ee':'Andorra nutome','el':u('\u0391\u03bd\u03b4\u03cc\u03c1\u03b1'),'en':'*aa','eo':'Andoro','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0622\u0646\u062f\u0648\u0631\u0627'),'ff':'Anndoora','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Andorre','fy':'*aa','ga':u('And\u00f3ra'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':u('\u0a8d\u0a82\u0aa1\u0acb\u0ab0\u0abe'),'gv':'*aa','ha':'*ak','he':u('\u05d0\u05e0\u05d3\u05d5\u05e8\u05d4'),'hi':u('\u090f\u0902\u0921\u094b\u0930\u093e'),'ho':'*aa','hr':'*ak','ht':'*aa','hu':'*aa','hy':u('\u0531\u0576\u0564\u0578\u0580\u0580\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30a2\u30f3\u30c9\u30e9'),'ji':u('\u05d0\u05b7\u05e0\u05d3\u05d0\u05e8\u05e2'),'jv':'*aa','ka':u('\u10d0\u10dc\u10d3\u10dd\u10e0\u10d0'),'kg':'*aa','ki':'*ak','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u17a2\u1784\u17cb\u178a\u17bc\u179a\u17c9\u17b6'),'kn':u('\u0c85\u0c82\u0ca1\u0ccb\u0cb0\u0cbe'),'ko':u('\uc548\ub3c4\ub77c'),'kr':'*aa','ks':u('\u0627\u066e\u06ea\u0646\u0691\u0648\u0631\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*aa','lg':'*ak','li':'*aa','ln':u('Andor\u025b'),'lo':u('\u0ead\u0eb1\u0e99\u0e94\u0ecd\u0ea3\u0eb2'),'lt':'*ak','lu':'Andore','lv':'*ak','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d05\u0d7b\u0d21\u0d4b\u0d31'),'mn':'*ce','mo':'*aa','mr':u('\u0905\u0901\u0921\u094b\u0930\u093e'),'ms':'*aa','mt':'*aa','my':u('\u1021\u1014\u103a\u1012\u102d\u102f\u101b\u102c'),'na':'*aa','nb':'*aa','nd':'*ak','ne':u('\u0905\u0928\u094d\u0921\u094b\u0930\u094d\u0930\u093e'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b06\u0b23\u0b4d\u0b21\u0b4b\u0b30\u0b3e'),'os':'*aa','pa':u('\u0a05\u0a70\u0a21\u0a4b\u0a30\u0a3e'),'pi':'*aa','pl':'*ak','ps':u('\u0627\u0646\u062f\u0648\u0631\u0627'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'*ak','ro':'*aa','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*ps','se':'*aa','sg':u('And\u00f4ro'),'si':u('\u0d87\u0db1\u0dca\u0da9\u0ddd\u0dbb\u0dcf\u0dc0'),'sk':'*aa','sl':'*ak','sm':'*aa','sn':'*ak','so':'*ak','sq':u('Andorr\u00eb'),'sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b85\u0ba9\u0bcd\u0b9f\u0bcb\u0bb0\u0bbe'),'te':u('\u0c06\u0c02\u0c21\u0c4b\u0c30\u0c3e'),'tg':'*ce','th':u('\u0e2d\u0e31\u0e19\u0e14\u0e2d\u0e23\u0e4c\u0e23\u0e32'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':u('\u02bbAnitola'),'tr':'*aa','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u0626\u0627\u0646\u062f\u0648\u0631\u0631\u0627'),'uk':'*ce','ur':u('\u0627\u0646\u0688\u0648\u0631\u0627'),'uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Andoor','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de \u00c0\u00e0nd\u00f3r\u00e0'),'za':'*aa','zh':u('\u5b89\u9053\u5c14'),'zu':'i-Andorra',},
  'AE': {'aa':'United Arab Emirates','ab':'*aa','ae':'*aa','af':'Verenigde Arabiese Emirate','ak':'*aa','am':u('\u12e8\u1270\u1263\u1260\u1229\u1275 \u12d3\u1228\u1265 \u12a4\u121d\u122c\u1275\u1235'),'an':'*aa','ar':u('\u0627\u0644\u0625\u0645\u0627\u0631\u0627\u062a \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0645\u062a\u062d\u062f\u0629'),'as':u('\u09b8\u0982\u09af\u09c1\u0995\u09cd\u09a4 \u0986\u09f0\u09ac \u0986\u09ae\u09bf\u09f0\u09be\u09a4'),'av':'*aa','ay':'*aa','az':u('Birl\u0259\u015fmi\u015f \u018fr\u0259b \u018fmirlikl\u0259ri'),'ba':'*aa','be':u('\u0410\u0431\u2019\u044f\u0434\u043d\u0430\u043d\u044b\u044f \u0410\u0440\u0430\u0431\u0441\u043a\u0456\u044f \u042d\u043c\u0456\u0440\u0430\u0442\u044b'),'bg':u('\u041e\u0431\u0435\u0434\u0438\u043d\u0435\u043d\u0438 \u0430\u0440\u0430\u0431\u0441\u043a\u0438 \u0435\u043c\u0438\u0440\u0441\u0442\u0432\u0430'),'bh':'*aa','bi':'*aa','bm':'Arabu mara kafoli','bn':u('\u09b8\u0982\u09af\u09c1\u0995\u09cd\u09a4 \u0986\u09b0\u09ac \u0986\u09ae\u09bf\u09b0\u09be\u09a4'),'bo':'*aa','br':u('Emirelezhio\u00f9 Arab Unanet'),'bs':'Ujedinjeni Arapski Emirati','ca':u('Emirats \u00c0rabs Units'),'ce':u('\u04c0\u0430\u0440\u0431\u0438\u0439\u043d \u0426\u0445\u044c\u0430\u043d\u0430\u0442\u043e\u044c\u0445\u043d\u0430 \u042d\u043c\u0438\u0440\u0430\u0442\u0430\u0448'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Spojen\u00e9 arabsk\u00e9 emir\u00e1ty'),'cu':'*aa','cv':'*aa','cy':'Emiradau Arabaidd Unedig','da':'De Forenede Arabiske Emirater','de':'Vereinigte Arabische Emirate','dv':'*aa','dz':u('\u0f61\u0f74\u0f0b\u0f53\u0f71\u0f60\u0f72\u0f0b\u0f4a\u0f7a\u0f4c\u0f0b \u0f68\u0f0b\u0f62\u0f56\u0f0b \u0f68\u0f7a\u0f0b\u0f58\u0f7a\u0f0b\u0f62\u0f7a\u0f4a\u0f66'),'ee':'United Arab Emirates nutome','el':u('\u0397\u03bd\u03c9\u03bc\u03ad\u03bd\u03b1 \u0391\u03c1\u03b1\u03b2\u03b9\u03ba\u03ac \u0395\u03bc\u03b9\u03c1\u03ac\u03c4\u03b1'),'en':'*aa','eo':u('Unui\u011dintaj Arabaj Emirlandoj'),'es':u('Emiratos \u00c1rabes Unidos'),'et':u('Araabia \u00dchendemiraadid'),'eu':'Arabiar Emirerri Batuak','fa':u('\u0627\u0645\u0627\u0631\u0627\u062a \u0645\u062a\u062d\u062f\u0647\u0654 \u0639\u0631\u0628\u06cc'),'ff':u('Emiraat Araab Denntu\u0257e'),'fi':'Arabiemiirikunnat','fj':'*aa','fo':u('Sameindu Emirr\u00edkini'),'fr':u('\u00c9mirats arabes unis'),'fy':'Verenigde Arabyske Emiraten','ga':u('Aontas na n\u00c9im\u00edr\u00edochta\u00ed Arabacha'),'gd':'Na h-Iomaratan Arabach Aonaichte','gl':'*es','gn':'*aa','gu':u('\u0aaf\u0ac1\u0aa8\u0abe\u0a87\u0a9f\u0ac7\u0aa1 \u0a86\u0ab0\u0aac \u0a85\u0aae\u0ac0\u0ab0\u0abe\u0aa4'),'gv':'*aa','ha':u('Ha\u0257a\u0257\u0257iyar Daular Larabawa'),'he':u('\u05d0\u05d9\u05d7\u05d5\u05d3 \u05d4\u05d0\u05de\u05d9\u05e8\u05d5\u05d9\u05d5\u05ea \u05d4\u05e2\u05e8\u05d1\u05d9\u05d5\u05ea'),'hi':u('\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0905\u0930\u092c \u0905\u092e\u0940\u0930\u093e\u0924'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Egyes\u00fclt Arab Em\u00edrs\u00e9gek'),'hy':u('\u0531\u0580\u0561\u0562\u0561\u056f\u0561\u0576 \u0544\u056b\u0561\u0581\u0575\u0561\u056c \u0537\u0574\u056b\u0580\u0578\u0582\u0569\u0575\u0578\u0582\u0576\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'Uni Emirat Arab','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Sameinu\u00f0u arab\u00edsku furstad\u00e6min'),'it':'Emirati Arabi Uniti','iu':'*aa','iw':'*he','ja':u('\u30a2\u30e9\u30d6\u9996\u9577\u56fd\u9023\u90a6'),'ji':'*aa','jv':'*aa','ka':u('\u10d0\u10e0\u10d0\u10d1\u10d7\u10d0 \u10d2\u10d0\u10d4\u10e0\u10d7\u10d8\u10d0\u10dc\u10d4\u10d1\u10e3\u10da\u10d8 \u10e1\u10d0\u10d0\u10db\u10d8\u10e0\u10dd\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'Falme za Kiarabu','kj':'*aa','kk':u('\u0411\u0456\u0440\u0456\u043a\u043a\u0435\u043d \u0410\u0440\u0430\u0431 \u04d8\u043c\u0456\u0440\u043b\u0456\u043a\u0442\u0435\u0440\u0456'),'kl':'*aa','km':u('\u17a2\u17c1\u1798\u17b8\u179a\u17c9\u17b6\u178f\u200b\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb\u200b\u179a\u17bd\u1798'),'kn':u('\u0caf\u0cc1\u0ca8\u0cc8\u0c9f\u0cc6\u0ca1\u0ccd \u0c85\u0cb0\u0cac\u0ccd \u0c8e\u0cae\u0cbf\u0cb0\u0cc7\u0c9f\u0ccd\u0cb8\u0ccd'),'ko':u('\uc544\ub78d\uc5d0\ubbf8\ub9ac\ud2b8'),'kr':'*aa','ks':u('\u0645\u064f\u062a\u062d\u062f\u06c1 \u0639\u0631\u064e\u0628 \u0627\u0645\u0627\u0631\u0627\u062a'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0411\u0438\u0440\u0438\u043a\u043a\u0435\u043d \u0410\u0440\u0430\u0431 \u042d\u043c\u0438\u0440\u0430\u0442\u0442\u0430\u0440\u044b'),'la':'*aa','lb':'Vereenegt Arabesch Emirater','lg':'Emireeti','li':'*aa','ln':u('L\u025bmila alabo'),'lo':u('\u0eaa\u0eb0\u0eab\u0eb0\u0ea5\u0eb1\u0e94\u0ead\u0eb2\u0ea3\u0eb1\u0e9a\u0ec0\u0ead\u0ea1\u0eb4\u0ec0\u0ea3\u0e94'),'lt':u('Jungtiniai Arab\u0173 Emyratai'),'lu':'Lemila alabu','lv':u('Apvienotie Ar\u0101bu Emir\u0101ti'),'mg':u('Emir\u00e0 Arabo mitambatra'),'mh':'*aa','mi':'*aa','mk':u('\u041e\u0431\u0435\u0434\u0438\u043d\u0435\u0442\u0438 \u0410\u0440\u0430\u043f\u0441\u043a\u0438 \u0415\u043c\u0438\u0440\u0430\u0442\u0438'),'ml':u('\u0d2f\u0d41\u0d23\u0d48\u0d31\u0d4d\u0d31\u0d21\u0d4d \u0d05\u0d31\u0d2c\u0d4d \u0d0e\u0d2e\u0d3f\u0d31\u0d48\u0d31\u0d4d\u0d31\u0d4d\u200c\u0d38\u0d4d'),'mn':u('\u0410\u0440\u0430\u0431\u044b\u043d \u041d\u044d\u0433\u0434\u0441\u044d\u043d \u042d\u043c\u0438\u0440\u0430\u0442 \u0423\u043b\u0441'),'mo':'Emiratele Arabe Unite','mr':'*hi','ms':'Emiriah Arab Bersatu','mt':u('l-Emirati G\u0127arab Mag\u0127quda'),'my':u('\u101a\u1030\u1021\u1031\u1021\u102e\u1038'),'na':'*aa','nb':'De forente arabiske emirater','nd':'*aa','ne':u('\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0905\u0930\u092c \u0907\u092e\u093f\u0930\u093e\u091f\u094d\u0938'),'ng':'*aa','nl':'Verenigde Arabische Emiraten','nn':'Dei sameinte arabiske emirata','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b02\u0b2f\u0b41\u0b15\u0b4d\u0b24 \u0b06\u0b30\u0b2c \u0b0f\u0b2e\u0b3f\u0b30\u0b47\u0b1f\u0b38\u0b4d'),'os':'*aa','pa':u('\u0a38\u0a70\u0a2f\u0a41\u0a15\u0a24 \u0a05\u0a30\u0a2c \u0a05\u0a2e\u0a40\u0a30\u0a3e\u0a24'),'pi':'*aa','pl':'Zjednoczone Emiraty Arabskie','ps':u('\u0645\u062a\u062d\u062f\u0647 \u0639\u0631\u0628 \u0627\u0645\u0627\u0631\u0627\u062a'),'pt':u('Emirados \u00c1rabes Unidos'),'qu':'*aa','rm':'Emirats Arabs Unids','rn':u('Leta Zunze Ubumwe z\u2019Abarabu'),'ro':'*mo','ru':u('\u041e\u0410\u042d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*ps','se':u('Ovttastuvvan Ar\u00e1baemir\u00e1htat'),'sg':u('Ar\u00e2bo Emir\u00e2ti \u00d4ko'),'si':u('\u0d91\u0d9a\u0dca\u0dc3\u0dad\u0dca \u0d85\u0dbb\u0dcf\u0db6\u0dd2 \u0d91\u0db8\u0dd2\u0dbb\u0dca \u0dbb\u0dcf\u0da2\u0dca\u200d\u0dba\u0dba'),'sk':'*cs','sl':u('Zdru\u017eeni arabski emirati'),'sm':'*aa','sn':'*aa','so':'Imaaraadka Carabta ee Midoobay','sq':'Emiratet e Bashkuara Arabe','sr':u('\u0423\u0458\u0435\u0434\u0438\u045a\u0435\u043d\u0438 \u0410\u0440\u0430\u043f\u0441\u043a\u0438 \u0415\u043c\u0438\u0440\u0430\u0442\u0438'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('F\u00f6renade Arabemiraten'),'sw':'*ki','ta':u('\u0b90\u0b95\u0bcd\u0b95\u0bbf\u0baf \u0b85\u0bb0\u0baa\u0bc1 \u0b8e\u0bae\u0bbf\u0bb0\u0bc7\u0b9f\u0bcd\u0bb8\u0bcd'),'te':u('\u0c2f\u0c41\u0c28\u0c48\u0c1f\u0c46\u0c21\u0c4d \u0c05\u0c30\u0c2c\u0c4d \u0c0e\u0c2e\u0c3f\u0c30\u0c47\u0c1f\u0c4d\u0c38\u0c4d'),'tg':u('\u0410\u043c\u043e\u0440\u0430\u0442\u04b3\u043e\u0438 \u041c\u0443\u0442\u0442\u0430\u04b3\u0438\u0434\u0430\u0438 \u0410\u0440\u0430\u0431'),'th':u('\u0e2a\u0e2b\u0e23\u0e31\u0e10\u0e2d\u0e32\u0e2b\u0e23\u0e31\u0e1a\u0e40\u0e2d\u0e21\u0e34\u0e40\u0e23\u0e15\u0e2a\u0e4c'),'ti':u('\u1215\u1261\u122b\u1275 \u12a2\u121b\u122b\u1275 \u12d3\u1228\u1265'),'tk':u('Birle\u015fen Arap Emirlikleri'),'tl':'*aa','tn':'*aa','to':u('\u02bbAlepea Fakatahataha'),'tr':u('Birle\u015fik Arap Emirlikleri'),'ts':'*aa','tt':u('\u0411\u0435\u0440\u043b\u04d9\u0448\u043a\u04d9\u043d \u0413\u0430\u0440\u04d9\u043f \u04d8\u043c\u0438\u0440\u043b\u0435\u043a\u043b\u04d9\u0440\u0435'),'tw':'*aa','ty':'*aa','ug':u('\u0626\u06d5\u0631\u06d5\u0628 \u0628\u0649\u0631\u0644\u06d5\u0634\u0645\u06d5 \u062e\u06d5\u0644\u0649\u067e\u0649\u0644\u0649\u0643\u0649'),'uk':u('\u041e\u0431\u02bc\u0454\u0434\u043d\u0430\u043d\u0456 \u0410\u0440\u0430\u0431\u0441\u044c\u043a\u0456 \u0415\u043c\u0456\u0440\u0430\u0442\u0438'),'ur':u('\u0645\u062a\u062d\u062f\u06c1 \u0639\u0631\u0628 \u0627\u0645\u0627\u0631\u0627\u062a'),'uz':'Birlashgan Arab Amirliklari','ve':'*aa','vi':u('C\u00e1c Ti\u1ec3u V\u01b0\u01a1ng qu\u1ed1c \u1ea2 R\u1eadp Th\u1ed1ng nh\u1ea5t'),'vo':'*aa','wa':'*aa','wo':'Emira Arab Ini','xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de \u1eb8mirate ti Aw\u1ecdn Arabu'),'za':'*aa','zh':u('\u963f\u62c9\u4f2f\u8054\u5408\u914b\u957f\u56fd'),'zu':'i-United Arab Emirates',},
  'AF': {'aa':'Afghanistan','ab':'*aa','ae':'*aa','af':'Afganistan','ak':'*af','am':u('\u12a0\u134d\u130b\u1292\u1235\u1273\u1295'),'an':'*aa','ar':u('\u0623\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646'),'as':u('\u0986\u09ab\u0997\u09be\u09a8\u09bf\u09b8\u09cd\u09a4\u09be\u09a8'),'av':'*aa','ay':'*aa','az':u('\u018ffqan\u0131stan'),'ba':'*aa','be':u('\u0410\u0444\u0433\u0430\u043d\u0456\u0441\u0442\u0430\u043d'),'bg':u('\u0410\u0444\u0433\u0430\u043d\u0438\u0441\u0442\u0430\u043d'),'bh':'*aa','bi':'*aa','bm':u('Afiganista\u014b'),'bn':'*as','bo':'*aa','br':'*aa','bs':'*af','ca':'*af','ce':u('\u041e\u0432\u0445\u04c0\u0430\u043d \u043c\u043e\u0445\u043a'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Afgh\u00e1nist\u00e1n'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f68\u0f55\u0f0b\u0f42\u0fb7\u0f0b\u0f53\u0f72\u0f0b\u0f66\u0f4f\u0f71\u0f53'),'ee':'Afghanistan nutome','el':u('\u0391\u03c6\u03b3\u03b1\u03bd\u03b9\u03c3\u03c4\u03ac\u03bd'),'en':'*aa','eo':'Afganujo','es':u('Afganist\u00e1n'),'et':'*af','eu':'*af','fa':u('\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646'),'ff':'Afganistaan','fi':'*af','fj':'*aa','fo':'*af','fr':'*aa','fy':'*aa','ga':u('an Afganast\u00e1in'),'gd':u('Afghanast\u00e0n'),'gl':'*es','gn':'*aa','gu':u('\u0a85\u0aab\u0a98\u0abe\u0aa8\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8'),'gv':'*aa','ha':'Afaganistan','he':u('\u05d0\u05e4\u05d2\u05e0\u05d9\u05e1\u05d8\u05df'),'hi':u('\u0905\u092b\u093c\u0917\u093e\u0928\u093f\u0938\u094d\u0924\u093e\u0928'),'ho':'*aa','hr':'*af','ht':'*aa','hu':u('Afganiszt\u00e1n'),'hy':u('\u0531\u0586\u0572\u0561\u0576\u057d\u057f\u0561\u0576'),'hz':'*aa','ia':'*aa','id':'*af','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*af','io':'*aa','is':'*af','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30a2\u30d5\u30ac\u30cb\u30b9\u30bf\u30f3'),'ji':u('\u05d0\u05b7\u05e4\u05bf\u05d2\u05d4\u05d0\u05b7\u05e0\u05d9\u05e1\u05d8\u05d0\u05b7\u05df'),'jv':'*aa','ka':u('\u10d0\u10d5\u10e6\u10d0\u10dc\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'Afuganistani','kj':'*aa','kk':u('\u0410\u0443\u0493\u0430\u043d\u0441\u0442\u0430\u043d'),'kl':'*aa','km':u('\u17a2\u17b6\u17a0\u17d2\u179c\u17a0\u17d2\u1782\u17b6\u1793\u17b8\u179f\u17d2\u1790\u17b6\u1793'),'kn':u('\u0c85\u0cab\u0c98\u0cbe\u0ca8\u0cbf\u0cb8\u0ccd\u0ca5\u0cbe\u0ca8'),'ko':u('\uc544\ud504\uac00\ub2c8\uc2a4\ud0c4'),'kr':'*aa','ks':u('\u0627\u064e\u0641\u063a\u0627\u0646\u064e\u0633\u062a\u0627\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'Afaganisitani','li':'*aa','ln':u('Afiganisit\u00e1'),'lo':u('\u0ead\u0eb2\u0e9f\u0e81\u0eb2\u0e99\u0eb4\u0e94\u0eaa\u0eb0\u0e96\u0eb2\u0e99'),'lt':'Afganistanas','lu':'Afuganisita','lv':u('Afganist\u0101na'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0410\u0432\u0433\u0430\u043d\u0438\u0441\u0442\u0430\u043d'),'ml':u('\u0d05\u0d2b\u0d4d\u200c\u0d17\u0d3e\u0d28\u0d3f\u0d38\u0d4d\u0d25\u0d3e\u0d7b'),'mn':'*bg','mo':'*af','mr':u('\u0905\u092b\u0917\u093e\u0923\u093f\u0938\u094d\u0924\u093e\u0928'),'ms':'*aa','mt':'l-Afganistan','my':u('\u1021\u102c\u1016\u1002\u1014\u103a\u1014\u1005\u1039\u1005\u1010\u1014\u103a'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0905\u092b\u0917\u093e\u0928\u093f\u0938\u094d\u0924\u093e\u0928'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b06\u0b2b\u0b17\u0b3e\u0b28\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28\u0b4d'),'os':'*aa','pa':u('\u0a05\u0a2b\u0a3c\u0a17\u0a3e\u0a28\u0a3f\u0a38\u0a24\u0a3e\u0a28'),'pi':'*aa','pl':'*af','ps':'*fa','pt':u('Afeganist\u00e3o'),'qu':'*es','rm':'*aa','rn':'Afuganisitani','ro':'*af','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*fa','se':'*aa','sg':u('Fagan\u00efta, Afgan\u00efst\u00e4an'),'si':u('\u0d87\u0dc6\u0dca\u0d9c\u0db1\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1\u0dba'),'sk':'*af','sl':'*af','sm':'*aa','sn':'*ki','so':'Afgaanistaan','sq':'*af','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b86\u0baa\u0bcd\u0b95\u0bbe\u0ba9\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd'),'te':u('\u0c06\u0c2b\u0c4d\u0c18\u0c28\u0c3f\u0c38\u0c4d\u0c24\u0c3e\u0c28\u0c4d'),'tg':u('\u0410\u0444\u0493\u043e\u043d\u0438\u0441\u0442\u043e\u043d'),'th':u('\u0e2d\u0e31\u0e1f\u0e01\u0e32\u0e19\u0e34\u0e2a\u0e16\u0e32\u0e19'),'ti':'*am','tk':'Owganystan','tl':'*aa','tn':'*aa','to':u('\u02bbAfik\u0101nisitani'),'tr':'*af','ts':'*aa','tt':u('\u04d8\u0444\u0433\u0430\u043d\u0441\u0442\u0430\u043d'),'tw':'*aa','ty':'*aa','ug':u('\u0626\u0627\u0641\u063a\u0627\u0646\u0649\u0633\u062a\u0627\u0646'),'uk':'*be','ur':'*fa','uz':u('Afg\u02bboniston'),'ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':u('Afganista\u014b'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de \u00c0f\u00f9g\u00e0n\u00edst\u00e1n\u00ec'),'za':'*aa','zh':u('\u963f\u5bcc\u6c57'),'zu':'i-Afghanistan',},
  'AG': {'aa':'Antigua and Barbuda','ab':'*aa','ae':'*aa','af':'Antigua en Barbuda','ak':'Antigua ne Baabuda','am':u('\u12a0\u1295\u1272\u1313 \u12a5\u1293 \u1263\u1229\u12f3'),'an':'*aa','ar':u('\u0623\u0646\u062a\u064a\u063a\u0648\u0627 \u0648\u0628\u0631\u0628\u0648\u062f\u0627'),'as':u('\u098f\u09a3\u09cd\u099f\u09bf\u0997\u09c1\u09f1\u09be \u0986\u09f0\u09c1 \u09ac\u09be\u09f0\u09cd\u09ac\u09c1\u09a1\u09be'),'av':'*aa','ay':'*aa','az':u('Antiqua v\u0259 Barbuda'),'ba':'*aa','be':u('\u0410\u043d\u0442\u044b\u0433\u0443\u0430 \u0456 \u0411\u0430\u0440\u0431\u0443\u0434\u0430'),'bg':u('\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0438 \u0411\u0430\u0440\u0431\u0443\u0434\u0430'),'bh':'*aa','bi':'*aa','bm':'Antiga-ni-Barbuda','bn':u('\u0985\u09cd\u09af\u09be\u09a8\u09cd\u099f\u09bf\u0997\u09c1\u09af\u09bc\u09be \u0993 \u09ac\u09be\u09b0\u09ac\u09c1\u09a1\u09be'),'bo':'*aa','br':'Antigua ha Barbuda','bs':'Antigva i Barbuda','ca':'Antigua i Barbuda','ce':u('\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0430, \u0411\u0430\u0440\u0431\u0443\u0434\u0430 \u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Antigua a Barbuda','cu':'*aa','cv':'*aa','cy':'*cs','da':'Antigua og Barbuda','de':'Antigua und Barbuda','dv':'*aa','dz':u('\u0f68\u0f53\u0f0b\u0f4a\u0f72\u0f0b\u0f42\u0f74\u0f0b\u0f5d\u0f0b \u0f68\u0f7a\u0f53\u0f4c\u0f0b \u0f56\u0fb7\u0f62\u0f0b\u0f56\u0fb7\u0f74\u0f0b\u0f4c'),'ee':u('\u0301Antigua kple Barbuda nutome'),'el':u('\u0391\u03bd\u03c4\u03af\u03b3\u03ba\u03bf\u03c5\u03b1 \u03ba\u03b1\u03b9 \u039c\u03c0\u03b1\u03c1\u03bc\u03c0\u03bf\u03cd\u03bd\u03c4\u03b1'),'en':'Antigua & Barbuda','eo':'Antigvo-Barbudo','es':'Antigua y Barbuda','et':'Antigua ja Barbuda','eu':'Antigua eta Barbuda','fa':u('\u0622\u0646\u062a\u06cc\u06af\u0648\u0627 \u0648 \u0628\u0627\u0631\u0628\u0648\u062f\u0627'),'ff':'Antiguwaa e Barbudaa','fi':'*et','fj':'*aa','fo':'*en','fr':'Antigua-et-Barbuda','fy':'*af','ga':u('Antigua agus Barb\u00fada'),'gd':u('Aint\u00ecoga is Barbuda'),'gl':'Antiga e Barbuda','gn':'*aa','gu':u('\u0a8d\u0aa8\u0acd\u0a9f\u0abf\u0a97\u0ac1\u0a86 \u0a85\u0aa8\u0ac7 \u0aac\u0ab0\u0acd\u0aae\u0ac1\u0aa1\u0abe'),'gv':'*aa','ha':'Antigwa da Barbuba','he':u('\u05d0\u05e0\u05d8\u05d9\u05d2\u05d5\u05d0\u05d4 \u05d5\u05d1\u05e8\u05d1\u05d5\u05d3\u05d4'),'hi':u('\u090f\u0902\u091f\u093f\u0917\u0941\u0906 \u0914\u0930 \u092c\u0930\u092c\u0941\u0921\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Antigua \u00e9s Barbuda'),'hy':u('\u0531\u0576\u057f\u056b\u0563\u0578\u0582\u0561 \u0587 \u0532\u0561\u0580\u0562\u0578\u0582\u0564\u0561'),'hz':'*aa','ia':'*aa','id':'Antigua dan Barbuda','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Ant\u00edgva og Barb\u00fada'),'it':'Antigua e Barbuda','iu':'*aa','iw':'*he','ja':u('\u30a2\u30f3\u30c6\u30a3\u30b0\u30a2\u30fb\u30d0\u30fc\u30d6\u30fc\u30c0'),'ji':u('\u05d0\u05b7\u05e0\u05d8\u05d9\u05d2\u05d5\u05e2 \u05d0\u05d5\u05df \u05d1\u05d0\u05b7\u05e8\u05d1\u05d5\u05d3\u05e2'),'jv':'*aa','ka':u('\u10d0\u10dc\u10e2\u10d8\u10d2\u10e3\u10d0 \u10d3\u10d0 \u10d1\u10d0\u10e0\u10d1\u10e3\u10d3\u10d0'),'kg':'*aa','ki':'Antigua na Barbuda','kj':'*aa','kk':u('\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0436\u04d9\u043d\u0435 \u0411\u0430\u0440\u0431\u0443\u0434\u0430'),'kl':'*aa','km':u('\u17a2\u1784\u17cb\u1791\u17b8\u17a0\u17d2\u1782\u17b6 \u1793\u17b7\u1784 \u1794\u17b6\u1794\u17ca\u17bb\u1799\u178a\u17b6'),'kn':u('\u0c86\u0c82\u0c9f\u0cbf\u0c97\u0cc1\u0cb5\u0cbe \u0cae\u0ca4\u0ccd\u0ca4\u0cc1 \u0cac\u0cb0\u0ccd\u0cac\u0cc1\u0ca1\u0cbe'),'ko':u('\uc564\ud2f0\uac00 \ubc14\ubd80\ub2e4'),'kr':'*aa','ks':u('\u0627\u066e\u06ea\u0646\u0679\u0650\u06af\u064f\u0648\u0627 \u062a\u06c1\u0655 \u0628\u0627\u0631\u0628\u0648\u0691\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0436\u0430\u043d\u0430 \u0411\u0430\u0440\u0431\u0443\u0434\u0430'),'la':'*aa','lb':'*cs','lg':'Antigwa ne Barabuda','li':'*aa','ln':u('Antiga mp\u00e9 Barbuda'),'lo':u('\u0ec1\u0ead\u0e99\u0e97\u0eb4\u0e81\u0ebb\u0ea7 \u0ec1\u0ea5\u0eb0 \u0e9a\u0eb2\u0e9a\u0eb9\u0e94\u0eb2'),'lt':'Antigva ir Barbuda','lu':'Antiga ne Barbuda','lv':'Antigva un Barbuda','mg':'Antiga sy Barboda','mh':'*aa','mi':'*aa','mk':u('\u0410\u043d\u0442\u0438\u0433\u0430 \u0438 \u0411\u0430\u0440\u0431\u0443\u0434\u0430'),'ml':u('\u0d06\u0d7b\u0d31\u0d3f\u0d17\u0d4d\u0d35\u0d2f\u0d41\u0d02 \u0d2c\u0d7c\u0d2c\u0d41\u0d21\u0d2f\u0d41\u0d02'),'mn':u('\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0431\u0430 \u0411\u0430\u0440\u0431\u0443\u0434\u0430'),'mo':u('Antigua \u0219i Barbuda'),'mr':u('\u0905\u0901\u091f\u093f\u0917\u094d\u0935\u093e \u0906\u0923\u093f \u092c\u0930\u094d\u092c\u0941\u0921\u093e'),'ms':'*id','mt':'Antigua u Barbuda','my':u('\u1021\u1014\u103a\u1010\u102e\u1002\u103d\u102b\u1014\u103e\u1004\u1037\u103a \u1018\u102c\u1018\u1030\u1012\u102b'),'na':'*aa','nb':'*da','nd':'Antigua le Barbuda','ne':u('\u090f\u0928\u094d\u091f\u093f\u0917\u0941\u0906 \u0930 \u092c\u093e\u0930\u092c\u0941\u0921\u093e'),'ng':'*aa','nl':'*af','nn':'*da','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b06\u0b23\u0b4d\u0b1f\u0b3f\u0b17\u0b41\u0b06 \u0b0f\u0b2c\u0b02 \u0b2c\u0b3e\u0b30\u0b2c\u0b41\u0b26\u0b3e'),'os':'*aa','pa':u('\u0a10\u0a02\u0a1f\u0a40\u0a17\u0a41\u0a06 \u0a05\u0a24\u0a47 \u0a2c\u0a3e\u0a30\u0a2c\u0a41\u0a21\u0a3e'),'pi':'*aa','pl':'*ca','ps':u('\u0627\u0646\u067c\u064a\u06ab\u0648\u0627 \u0627\u0648 \u0628\u0627\u0631\u0628\u0648\u062f\u0627'),'pt':u('Ant\u00edgua e Barbuda'),'qu':'*aa','rm':'*it','rn':'Antigwa na Baribuda','ro':'*mo','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u0646\u067d\u064a\u06af\u0626\u0627 \u0648 \u0628\u0631\u0628\u0648\u062f\u0627'),'se':'*et','sg':u('Ant\u00eegua na Barb\u00fbda'),'si':u('\u0d87\u0db1\u0dca\u0da7\u0dd2\u0d9c\u0dd4\u0dc0\u0dcf \u0dc3\u0dc4 \u0db6\u0dcf\u0db6\u0dd2\u0dba\u0dd4\u0da9\u0dcf\u0dc0'),'sk':'*cs','sl':'Antigva in Barbuda','sm':'*aa','sn':'Antigua ne Barbuda','so':'Antigua iyo Barbuda','sq':'*it','sr':u('\u0410\u043d\u0442\u0438\u0433\u0432\u0430 \u0438 \u0411\u0430\u0440\u0431\u0443\u0434\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Antigua och Barbuda','sw':'*ki','ta':u('\u0b86\u0ba3\u0bcd\u0b9f\u0bbf\u0b95\u0bc1\u0bb5\u0bbe \u0bae\u0bb1\u0bcd\u0bb1\u0bc1\u0bae\u0bcd \u0baa\u0bbe\u0bb0\u0bcd\u0baa\u0bc1\u0b9f\u0bbe'),'te':u('\u0c06\u0c02\u0c1f\u0c3f\u0c17\u0c4d\u0c35\u0c3e \u0c2e\u0c30\u0c3f\u0c2f\u0c41 \u0c2c\u0c3e\u0c30\u0c4d\u0c2c\u0c41\u0c21\u0c3e'),'tg':u('\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0432\u0430 \u0411\u0430\u0440\u0431\u0443\u0434\u0430'),'th':u('\u0e41\u0e2d\u0e19\u0e15\u0e34\u0e01\u0e32\u0e41\u0e25\u0e30\u0e1a\u0e32\u0e23\u0e4c\u0e1a\u0e39\u0e14\u0e32'),'ti':u('\u12a3\u1295\u1272\u1313\u1295 \u1263\u1229\u12f3\u1295'),'tk':'Antigua we Barbuda','tl':'*en','tn':'*aa','to':'Anitikua mo Palaputa','tr':'Antigua ve Barbuda','ts':'*aa','tt':u('\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u04bb\u04d9\u043c \u0411\u0430\u0440\u0431\u0443\u0434\u0430'),'tw':'*aa','ty':'*aa','ug':u('\u0626\u0627\u0646\u062a\u0649\u06af\u06c7\u0626\u0627 \u06cb\u06d5 \u0628\u0627\u0631\u0628\u06c7\u062f\u0627'),'uk':u('\u0410\u043d\u0442\u0438\u0491\u0443\u0430 \u0456 \u0411\u0430\u0440\u0431\u0443\u0434\u0430'),'ur':u('\u0627\u0646\u0679\u06cc\u06af\u0648\u0627 \u0627\u0648\u0631 \u0628\u0627\u0631\u0628\u0648\u062f\u0627'),'uz':'Antigua va Barbuda','ve':'*aa','vi':u('Antigua v\u00e0 Barbuda'),'vo':'*aa','wa':'*aa','wo':'Antiguwa ak Barbuda','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de \u00c0\u00e0nt\u00edg\u00fa\u00e0 \u00e0ti B\u00e1r\u00edb\u00fad\u00e0'),'za':'*aa','zh':u('\u5b89\u63d0\u74dc\u548c\u5df4\u5e03\u8fbe'),'zu':'i-Antigua ne-Barbuda',},
  'AI': {'aa':'Anguilla','ab':'*aa','ae':'*aa','af':'*aa','ak':'Anguila','am':u('\u12a0\u1295\u1309\u12ed\u120b'),'an':'*aa','ar':u('\u0623\u0646\u063a\u0648\u064a\u0644\u0627'),'as':u('\u098f\u09a8\u0997\u09c1\u0987\u09b2\u09be'),'av':'*aa','ay':'*aa','az':'Angilya','ba':'*aa','be':u('\u0410\u043d\u0433\u0456\u043b\u044c\u044f'),'bg':u('\u0410\u043d\u0433\u0443\u0438\u043b\u0430'),'bh':'*aa','bi':'*aa','bm':'Angiya','bn':u('\u098f\u09cd\u09af\u09be\u0999\u09cd\u0997\u09c1\u0987\u09b2\u09be'),'bo':'*aa','br':'*aa','bs':'Angvila','ca':'*aa','ce':u('\u0410\u043d\u0433\u0438\u043b\u044c\u044f'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f68\u0f44\u0f0b\u0f42\u0f72\u0f0b\u0f63'),'ee':'Anguilla nutome','el':u('\u0391\u03bd\u03b3\u03ba\u03bf\u03c5\u03af\u03bb\u03b1'),'en':'*aa','eo':'Angvilo','es':'*ak','et':'*aa','eu':'Aingira','fa':u('\u0622\u0646\u06af\u0648\u06cc\u0644\u0627'),'ff':'Anngiyaa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Anga\u00edle'),'gd':'Anguillia','gl':'*ak','gn':'*aa','gu':u('\u0a8d\u0a82\u0a97\u0acd\u0ab5\u0abf\u0ab2\u0abe'),'gv':'*aa','ha':'Angila','he':u('\u05d0\u05e0\u05d2\u05d5\u05d5\u05d9\u05dc\u05d4'),'hi':u('\u090f\u0902\u0917\u094d\u0935\u093f\u0932\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u0531\u0576\u0563\u0578\u0582\u056b\u056c\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'Angvilla','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30a2\u30f3\u30ae\u30e9'),'ji':'*aa','jv':'*aa','ka':u('\u10d0\u10dc\u10d2\u10d5\u10d8\u10da\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u17a2\u1784\u17cb\u17a0\u17d2\u1782\u17b8\u17a1\u17b6'),'kn':u('\u0c86\u0c82\u0c97\u0ccd\u0cb5\u0cbf\u0cb2\u0ccd\u0cb2\u0cbe'),'ko':u('\uc575\uadc8\ub77c'),'kr':'*aa','ks':u('\u0627\u0646\u06af\u0648\u0626\u06cc\u0644\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*aa','lg':'Angwila','li':'*aa','ln':u('Angiy\u025b'),'lo':u('\u0ec1\u0ead\u0e99\u0e81\u0eb8\u0e8d\u0ea5\u0eb2'),'lt':'Angilija','lu':'Angiye','lv':'Angilja','mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0410\u043d\u0433\u0432\u0438\u043b\u0430'),'ml':u('\u0d06\u0d7b\u0d17\u0d4d\u0d35\u0d3f\u0d32\u0d4d\u0d32'),'mn':'*ce','mo':'*aa','mr':u('\u0905\u0901\u0917\u094d\u0935\u093f\u0932\u093e'),'ms':'*aa','mt':'*aa','my':u('\u1021\u1014\u103a\u1002\u102e\u101c\u102c'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0906\u0919\u094d\u0917\u0941\u0907\u0932\u093e'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b06\u0b19\u0b4d\u0b17\u0b41\u0b07\u0b32\u0b4d\u0b32\u0b3e'),'os':'*aa','pa':u('\u0a05\u0a70\u0a17\u0a41\u0a07\u0a32\u0a3e'),'pi':'*aa','pl':'*aa','ps':u('\u0627\u0646\u06ab\u06cc\u0644\u0627'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'*lg','ro':'*aa','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u0646\u06af\u0648\u064a\u0644\u0627'),'se':'*aa','sg':u('Ang\u00fb\u00eela'),'si':u('\u0d87\u0db1\u0dca\u0d9c\u0dd4\u0dba\u0dd2\u0dbd\u0dcf\u0dc0'),'sk':'*aa','sl':'*bs','sm':'*aa','sn':'*ak','so':'*aa','sq':u('Anguil\u00eb'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b85\u0b99\u0bcd\u0b95\u0bc1\u0baf\u0bcd\u0bb2\u0bbe'),'te':u('\u0c06\u0c02\u0c17\u0c4d\u0c35\u0c3f\u0c32\u0c4d\u0c32\u0c3e'),'tg':u('\u0410\u043d\u0433\u0438\u043b\u0438\u044f'),'th':u('\u0e41\u0e2d\u0e07\u0e01\u0e27\u0e34\u0e25\u0e25\u0e32'),'ti':u('\u12a0\u1295\u1309\u12a2\u120b'),'tk':u('Angil\u00fda'),'tl':'*aa','tn':'*aa','to':'Anikuila','tr':'*aa','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u0626\u0627\u0646\u06af\u06cb\u0649\u0644\u0644\u0627'),'uk':u('\u0410\u043d\u0491\u0456\u043b\u044c\u044f'),'ur':'*ks','uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Angiiy','xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de \u00c0\u00e0ng\u00fal\u00edl\u00e0'),'za':'*aa','zh':u('\u5b89\u572d\u62c9'),'zu':'i-Anguilla',},
  'AL': {'aa':'Albania','ab':'*aa','ae':'*aa','af':u('Albani\u00eb'),'ak':'Albenia','am':u('\u12a0\u120d\u1263\u1292\u12eb'),'an':'*aa','ar':u('\u0623\u0644\u0628\u0627\u0646\u064a\u0627'),'as':u('\u0986\u09b2\u09ac\u09c7\u09a8\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Albaniya','ba':'*aa','be':u('\u0410\u043b\u0431\u0430\u043d\u0456\u044f'),'bg':u('\u0410\u043b\u0431\u0430\u043d\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Alibani','bn':'*as','bo':'*aa','br':'*aa','bs':'Albanija','ca':u('Alb\u00e0nia'),'ce':u('\u0410\u043b\u0431\u0430\u043d\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Alb\u00e1nie'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'Albanien','de':'*da','dv':'*aa','dz':u('\u0f68\u0f71\u0f63\u0f0b\u0f56\u0f7a\u0f0b\u0f53\u0f72\u0f0b\u0f61'),'ee':'Albania nutome','el':u('\u0391\u03bb\u03b2\u03b1\u03bd\u03af\u03b1'),'en':'*aa','eo':'Albanujo','es':'*aa','et':'Albaania','eu':'*aa','fa':u('\u0622\u0644\u0628\u0627\u0646\u06cc'),'ff':'Albanii','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Albanie','fy':'*af','ga':u('an Alb\u00e1in'),'gd':u('Alb\u00e0inia'),'gl':'*aa','gn':'*aa','gu':u('\u0a85\u0ab2\u0acd\u0aac\u0ac7\u0aa8\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'*az','he':u('\u05d0\u05dc\u05d1\u05e0\u05d9\u05d4'),'hi':u('\u0905\u0932\u094d\u092c\u093e\u0928\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Alb\u00e1nia'),'hy':u('\u0531\u056c\u0562\u0561\u0576\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Alban\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30a2\u30eb\u30d0\u30cb\u30a2'),'ji':u('\u05d0\u05b7\u05dc\u05d1\u05d0\u05b7\u05e0\u05d9\u05e2'),'jv':'*aa','ka':u('\u10d0\u10da\u10d1\u10d0\u10dc\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a2\u17b6\u179b\u17cb\u1794\u17b6\u1793\u17b8'),'kn':u('\u0c85\u0cb2\u0ccd\u0cac\u0cc7\u0ca8\u0cbf\u0caf\u0cbe'),'ko':u('\uc54c\ubc14\ub2c8\uc544'),'kr':'*aa','ks':u('\u0627\u066e\u06ea\u0644\u0628\u0627\u0646\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*da','lg':'Alibaniya','li':'*aa','ln':'*bm','lo':u('\u0ec1\u0ead\u0ea7\u0ec0\u0e9a\u0ec0\u0e99\u0e8d'),'lt':'*bs','lu':'Alubani','lv':u('Alb\u0101nija'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0410\u043b\u0431\u0430\u043d\u0438\u0458\u0430'),'ml':u('\u0d05\u0d7d\u0d2c\u0d47\u0d28\u0d3f\u0d2f'),'mn':'*ce','mo':'*aa','mr':'*hi','ms':'*aa','mt':'l-Albanija','my':u('\u1021\u101a\u103a\u101c\u103a\u1018\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0905\u0932\u094d\u092c\u0947\u0928\u093f\u092f\u093e'),'ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b06\u0b32\u0b2c\u0b3e\u0b28\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a05\u0a32\u0a2c\u0a3e\u0a28\u0a40\u0a06'),'pi':'*aa','pl':'*aa','ps':u('\u0627\u0644\u0628\u0627\u0646\u06cc\u0647'),'pt':u('Alb\u00e2nia'),'qu':'*aa','rm':'*aa','rn':'Alubaniya','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u0644\u0628\u0627\u0646\u064a\u0627'),'se':'*hu','sg':u('Alban\u00efi'),'si':u('\u0d87\u0dbd\u0dca\u0db6\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0'),'sk':u('Alb\u00e1nsko'),'sl':'*bs','sm':'*aa','sn':'*aa','so':'Albaaniya','sq':u('Shqip\u00ebri'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':u('\u0b85\u0bb2\u0bcd\u0baa\u0bc7\u0ba9\u0bbf\u0baf\u0bbe'),'te':u('\u0c05\u0c32\u0c4d\u0c2c\u0c47\u0c28\u0c3f\u0c2f\u0c3e'),'tg':'*bg','th':u('\u0e41\u0e2d\u0e25\u0e40\u0e1a\u0e40\u0e19\u0e35\u0e22'),'ti':'*am','tk':u('Albani\u00fda'),'tl':'*aa','tn':'*aa','to':u('\u02bbAlipania'),'tr':'Arnavutluk','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0626\u0627\u0644\u0628\u0627\u0646\u0649\u064a\u06d5'),'uk':'*be','ur':u('\u0627\u0644\u0628\u0627\u0646\u06cc\u06c1'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Albani','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de \u00c0l\u00f9b\u00e0n\u00ed\u00e1n\u00ec'),'za':'*aa','zh':u('\u963f\u5c14\u5df4\u5c3c\u4e9a'),'zu':'i-Albania',},
  'AM': {'aa':'Armenia','ab':'*aa','ae':'*aa','af':u('Armeni\u00eb'),'ak':'Aamenia','am':u('\u12a0\u122d\u121c\u1292\u12eb'),'an':'*aa','ar':u('\u0623\u0631\u0645\u064a\u0646\u064a\u0627'),'as':u('\u0986\u09f0\u09cd\u09ae\u09c7\u09a8\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':u('Erm\u0259nistan'),'ba':'*aa','be':u('\u0410\u0440\u043c\u0435\u043d\u0456\u044f'),'bg':u('\u0410\u0440\u043c\u0435\u043d\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Arimeni','bn':u('\u0986\u09b0\u09cd\u09ae\u09c7\u09a8\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'*aa','bs':'Armenija','ca':u('Arm\u00e8nia'),'ce':u('\u042d\u0440\u043c\u0430\u043b\u043e\u0439\u0447\u043e\u044c'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Arm\u00e9nie'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'Armenien','de':'*da','dv':'*aa','dz':u('\u0f68\u0f62\u0f0b\u0f58\u0f72\u0f0b\u0f53\u0f72\u0f0b\u0f61'),'ee':'Armenia nutome','el':u('\u0391\u03c1\u03bc\u03b5\u03bd\u03af\u03b1'),'en':'*aa','eo':'Armenujo','es':'*aa','et':'Armeenia','eu':'*aa','fa':u('\u0627\u0631\u0645\u0646\u0633\u062a\u0627\u0646'),'ff':'Armenii','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*cs','fy':'*af','ga':u('an Airm\u00e9in'),'gd':'Airmeinea','gl':'*aa','gn':'*aa','gu':u('\u0a86\u0ab0\u0acd\u0aae\u0ac7\u0aa8\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Armeniya','he':u('\u05d0\u05e8\u05de\u05e0\u05d9\u05d4'),'hi':u('\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('\u00d6rm\u00e9nyorsz\u00e1g'),'hy':u('\u0540\u0561\u0575\u0561\u057d\u057f\u0561\u0576'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Armen\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30a2\u30eb\u30e1\u30cb\u30a2'),'ji':u('\u05d0\u05b7\u05e8\u05de\u05e2\u05e0\u05d9\u05e2'),'jv':'*aa','ka':u('\u10e1\u10dd\u10db\u10ee\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a2\u17b6\u1798\u17c1\u1793\u17b8'),'kn':u('\u0c86\u0cb0\u0ccd\u0cae\u0cc7\u0ca8\u0cbf\u0caf'),'ko':u('\uc544\ub974\uba54\ub2c8\uc544'),'kr':'*aa','ks':u('\u0627\u064e\u0631\u0645\u0627\u0646\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*da','lg':'Arameniya','li':'*aa','ln':u('Am\u025bni'),'lo':u('\u0ead\u0eb2\u0ec0\u0ea1\u0ec0\u0e99\u0e8d'),'lt':u('Arm\u0117nija'),'lu':'Ameni','lv':u('Arm\u0113nija'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0415\u0440\u043c\u0435\u043d\u0438\u0458\u0430'),'ml':u('\u0d05\u0d7c\u0d2e\u0d47\u0d28\u0d3f\u0d2f'),'mn':u('\u0410\u0440\u043c\u0435\u043d\u0438'),'mo':'*aa','mr':u('\u0905\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e'),'ms':'*aa','mt':'l-Armenja','my':u('\u1021\u102c\u1019\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b06\u0b30\u0b4d\u0b2e\u0b47\u0b28\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a05\u0a30\u0a2e\u0a40\u0a28\u0a40\u0a06'),'pi':'*aa','pl':'*aa','ps':'*fa','pt':u('Arm\u00eania'),'qu':'*aa','rm':'*aa','rn':'Arumeniya','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u0631\u0645\u06cc\u0646\u06cc\u0627'),'se':'*aa','sg':u('Armen\u00efi'),'si':u('\u0d86\u0dbb\u0dca\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0'),'sk':u('Arm\u00e9nsko'),'sl':'*bs','sm':'*aa','sn':'*aa','so':'Armeeniya','sq':'Armeni','sr':u('\u0408\u0435\u0440\u043c\u0435\u043d\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':u('\u0b85\u0bb0\u0bcd\u0bae\u0bc7\u0ba9\u0bbf\u0baf\u0bbe'),'te':u('\u0c06\u0c30\u0c4d\u0c2e\u0c47\u0c28\u0c3f\u0c2f\u0c3e'),'tg':u('\u0410\u0440\u043c\u0430\u043d\u0438\u0441\u0442\u043e\u043d'),'th':u('\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e21\u0e40\u0e19\u0e35\u0e22'),'ti':'*am','tk':'Ermenistan','tl':'*aa','tn':'*aa','to':u('\u02bb\u0100menia'),'tr':'*tk','ts':'*aa','tt':u('\u04d8\u0440\u043c\u04d9\u043d\u0441\u0442\u0430\u043d'),'tw':'*aa','ty':'*aa','ug':u('\u0626\u06d5\u0631\u0645\u06d0\u0646\u0649\u064a\u06d5'),'uk':u('\u0412\u0456\u0440\u043c\u0435\u043d\u0456\u044f'),'ur':u('\u0622\u0631\u0645\u06cc\u0646\u06cc\u0627'),'uz':'Armaniston','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*sq','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Am\u00e9n\u00ed\u00e0'),'za':'*aa','zh':u('\u4e9a\u7f8e\u5c3c\u4e9a'),'zu':'i-Armenia',},
  'AO': {'aa':'Angola','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u12a0\u1295\u1310\u120b'),'an':'*aa','ar':u('\u0623\u0646\u063a\u0648\u0644\u0627'),'as':u('\u098f\u0982\u0997\u09cb\u09b2\u09be'),'av':'*aa','ay':'*aa','az':'Anqola','ba':'*aa','be':u('\u0410\u043d\u0433\u043e\u043b\u0430'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u0985\u09cd\u09af\u09be\u0999\u09cd\u0997\u09cb\u09b2\u09be'),'bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f68\u0f44\u0f0b\u0f42\u0fb7\u0f7c\u0f0b\u0f63'),'ee':'Angola nutome','el':u('\u0391\u03b3\u03ba\u03cc\u03bb\u03b1'),'en':'*aa','eo':'Angolo','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0622\u0646\u06af\u0648\u0644\u0627'),'ff':'Anngolaa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Ang\u00f3la'),'gd':u('Ang\u00f2la'),'gl':'*aa','gn':'*aa','gu':u('\u0a85\u0a82\u0a97\u0acb\u0ab2\u0abe'),'gv':'*aa','ha':'*aa','he':u('\u05d0\u05e0\u05d2\u05d5\u05dc\u05d4'),'hi':u('\u0905\u0902\u0917\u094b\u0932\u093e'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u0531\u0576\u0563\u0578\u056c\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*ga','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30a2\u30f3\u30b4\u30e9'),'ji':u('\u05d0\u05b7\u05e0\u05d2\u05d0\u05dc\u05e2'),'jv':'*aa','ka':u('\u10d0\u10dc\u10d2\u10dd\u10da\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u17a2\u1784\u17cb\u17a0\u17d2\u1782\u17c4\u17a1\u17b6'),'kn':u('\u0c85\u0c82\u0c97\u0ccb\u0cb2\u0cbe'),'ko':u('\uc559\uace8\ub77c'),'kr':'*aa','ks':u('\u0627\u0646\u06af\u0648\u0644\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*ga','lo':u('\u0ec1\u0ead\u0e87\u0ec2\u0e81\u0ea5\u0eb2'),'lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d05\u0d02\u0d17\u0d4b\u0d33'),'mn':u('\u0410\u043d\u0433\u043e\u043b'),'mo':'*aa','mr':'*hi','ms':'*aa','mt':'l-Angola','my':u('\u1021\u1014\u103a\u1002\u102d\u102f\u101c\u102c'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0905\u0919\u094d\u0917\u094b\u0932\u093e'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b06\u0b19\u0b4d\u0b17\u0b4b\u0b32\u0b3e'),'os':'*aa','pa':u('\u0a05\u0a70\u0a17\u0a4b\u0a32\u0a3e'),'pi':'*aa','pl':'*aa','ps':u('\u0627\u0646\u06ab\u0648\u0644\u0627'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*ks','se':'*aa','sg':u('Angol\u00e4a'),'si':u('\u0d87\u0db1\u0dca\u0d9c\u0ddd\u0dbd\u0dcf\u0dc0'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'Angoola','sq':u('Angol\u00eb'),'sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b85\u0b99\u0bcd\u0b95\u0bcb\u0bb2\u0bbe'),'te':u('\u0c05\u0c02\u0c17\u0c4b\u0c32\u0c3e'),'tg':'*be','th':u('\u0e41\u0e2d\u0e07\u0e42\u0e01\u0e25\u0e32'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':u('\u02bbAngikola'),'tr':'*aa','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u0626\u0627\u0646\u06af\u0648\u0644\u0627'),'uk':'*be','ur':'*ks','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':u('\u00c0ngolaa'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de \u00c0\u00e0ng\u00f3l\u00e0'),'za':'*aa','zh':u('\u5b89\u54e5\u62c9'),'zu':'i-Angola',},
  'AQ': {'aa':'Antarctica','ab':'*aa','ae':'*aa','af':'Antarktika','ak':'*aa','am':u('\u12a0\u1295\u1273\u122d\u12ad\u1272\u12ab'),'an':'*aa','ar':u('\u0623\u0646\u062a\u0627\u0631\u0643\u062a\u064a\u0643\u0627'),'as':u('\u098f\u09a3\u09cd\u099f\u09be\u09f0\u09cd\u0995\u099f\u09bf\u0995\u09be'),'av':'*aa','ay':'*aa','az':'*af','ba':'*aa','be':u('\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u044b\u043a\u0430'),'bg':u('\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u043a\u0430'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u0985\u09cd\u09af\u09be\u09a8\u09cd\u099f\u09be\u09b0\u09cd\u0995\u099f\u09bf\u0995\u09be'),'bo':'*aa','br':'*af','bs':'*af','ca':u('Ant\u00e0rtida'),'ce':u('\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u0434\u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Antarktida','cu':'*aa','cv':'*aa','cy':'*aa','da':'Antarktis','de':'*da','dv':'*aa','dz':u('\u0f60\u0f5b\u0f58\u0f0b\u0f42\u0fb3\u0f72\u0f44\u0f0b\u0f63\u0fb7\u0f7c\u0f0b\u0f58\u0f50\u0f60\u0f72\u0f0b\u0f41\u0fb1\u0f42\u0f66\u0f0b\u0f42\u0fb3\u0f72\u0f44'),'ee':'Antartica nutome','el':u('\u0391\u03bd\u03c4\u03b1\u03c1\u03ba\u03c4\u03b9\u03ba\u03ae'),'en':'*aa','eo':'Antarkto','es':u('Ant\u00e1rtida'),'et':'*af','eu':'Antartika','fa':u('\u062c\u0646\u0648\u0628\u06af\u0627\u0646'),'ff':'*aa','fi':'*da','fj':'*aa','fo':'*da','fr':'Antarctique','fy':'*aa','ga':'an Antartaice','gd':'An Antartaig','gl':'*es','gn':'*aa','gu':u('\u0a8f\u0aa8\u0acd\u0a9f\u0abe\u0ab0\u0acd\u0a95\u0a9f\u0abf\u0a95\u0abe'),'gv':'*aa','ha':'*aa','he':u('\u05d0\u05e0\u05d8\u05d0\u05e8\u05e7\u05d8\u05d9\u05e7\u05d4'),'hi':u('\u0905\u0902\u091f\u093e\u0930\u094d\u0915\u091f\u093f\u0915\u093e'),'ho':'*aa','hr':'*af','ht':'*aa','hu':'Antarktisz','hy':u('\u0531\u0576\u057f\u0561\u0580\u056f\u057f\u056b\u0564\u0561'),'hz':'*aa','ia':'*aa','id':'*eu','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*eu','io':'*aa','is':u('Su\u00f0urskautslandi\u00f0'),'it':'Antartide','iu':'*aa','iw':'*he','ja':u('\u5357\u6975'),'ji':u('\u05d0\u05b7\u05e0\u05d8\u05d0\u05b7\u05e8\u05e7\u05d8\u05d9\u05e7\u05e2'),'jv':'*aa','ka':u('\u10d0\u10dc\u10e2\u10d0\u10e0\u10e5\u10e2\u10d8\u10d9\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u17a2\u1784\u17cb\u178f\u17b6\u1780\u17cb\u1791\u17b7\u1780'),'kn':u('\u0c85\u0c82\u0c9f\u0cbe\u0cb0\u0ccd\u0c9f\u0cbf\u0c95\u0cbe'),'ko':u('\ub0a8\uadf9 \ub300\ub959'),'kr':'*aa','ks':u('\u0627\u06cc\u0646\u0679\u0627\u0631\u0679\u0650\u06a9\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*da','lg':'*aa','li':'*aa','ln':'*fr','lo':u('\u0ec1\u0ead\u0e99\u0e95\u0eb2\u0e94\u0e95\u0eb4\u0e81\u0eb2'),'lt':'*cs','lu':'*aa','lv':'*af','mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u043a'),'ml':u('\u0d05\u0d28\u0d4d\u0d31\u0d3e\u0d7c\u0d1f\u0d4d\u0d1f\u0d3f\u0d15\u0d4d\u0d15'),'mn':u('\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u0434'),'mo':'*aa','mr':u('\u0905\u0902\u091f\u093e\u0930\u094d\u0915\u094d\u091f\u093f\u0915\u093e'),'ms':'*eu','mt':'l-Antartika','my':u('\u1021\u1014\u1039\u1010\u102c\u1010\u102d\u1000'),'na':'*aa','nb':'*da','nd':'*aa','ne':u('\u0905\u0928\u094d\u091f\u093e\u0930\u091f\u093f\u0915\u093e'),'ng':'*aa','nl':'*aa','nn':'*da','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b06\u0b23\u0b4d\u0b1f\u0b3e\u0b30\u0b4d\u0b15\u0b3e\u0b1f\u0b3f\u0b15\u0b3e'),'os':'*aa','pa':u('\u0a05\u0a70\u0a1f\u0a3e\u0a30\u0a15\u0a1f\u0a3f\u0a15\u0a3e'),'pi':'*aa','pl':'Antarktyda','ps':u('\u0627\u0646\u062a\u0627\u0631\u06a9\u062a\u06cc\u06a9\u0627'),'pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u0646\u067d\u0627\u0631\u06aa\u067d\u064a\u06aa\u0627'),'se':u('Ant\u00e1rktis'),'sg':'*aa','si':u('\u0d87\u0db1\u0dca\u0da7\u0dcf\u0d9a\u0dca\u0da7\u0dd2\u0d9a\u0dcf\u0dc0'),'sk':u('Antarkt\u00edda'),'sl':'*af','sm':'*aa','sn':'*aa','so':'*aa','sq':u('Antarktik\u00eb'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'Antaktiki','ta':u('\u0b85\u0ba3\u0bcd\u0b9f\u0bbe\u0bb0\u0bcd\u0b9f\u0bbf\u0b95\u0bbe'),'te':u('\u0c05\u0c02\u0c1f\u0c3e\u0c30\u0c4d\u0c15\u0c3f\u0c1f\u0c3f\u0c15\u0c3e'),'tg':'*ce','th':u('\u0e41\u0e2d\u0e19\u0e15\u0e32\u0e23\u0e4c\u0e01\u0e15\u0e34\u0e01\u0e32'),'ti':'*am','tk':'*af','tl':'*aa','tn':'*aa','to':u('\u02bbAnit\u0101tika'),'tr':'*af','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0626\u0627\u0646\u062a\u0627\u0631\u0643\u062a\u0649\u0643\u0627'),'uk':'*bg','ur':u('\u0627\u0646\u0679\u0627\u0631\u06a9\u0679\u06cc\u06a9\u0627'),'uz':'*cs','ve':'*aa','vi':u('Nam C\u1ef1c'),'vo':'*aa','wa':'*aa','wo':'Antarktik','xh':'*aa','yi':'*ji','yo':'*aa','za':'*aa','zh':u('\u5357\u6781\u6d32'),'zu':'i-Antarctica',},
  'AR': {'aa':'Argentina','ab':'*aa','ae':'*aa','af':u('Argentini\u00eb'),'ak':u('Agy\u025bntina'),'am':u('\u12a0\u122d\u1300\u1295\u1272\u1293'),'an':'*aa','ar':u('\u0627\u0644\u0623\u0631\u062c\u0646\u062a\u064a\u0646'),'as':u('\u0986\u09f0\u09cd\u099c\u09c7\u09a3\u09cd\u099f\u09bf\u09a8\u09be'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u0410\u0440\u0433\u0435\u043d\u0446\u0456\u043d\u0430'),'bg':u('\u0410\u0440\u0436\u0435\u043d\u0442\u0438\u043d\u0430'),'bh':'*aa','bi':'*aa','bm':'Arizantin','bn':u('\u0986\u09b0\u09cd\u099c\u09c7\u09a8\u09cd\u099f\u09bf\u09a8\u09be'),'bo':'*aa','br':u('Arc\u02bchantina'),'bs':'*aa','ca':'*aa','ce':u('\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'Yr Ariannin','da':'*aa','de':'Argentinien','dv':'*aa','dz':u('\u0f68\u0f62\u0f0b\u0f47\u0f7a\u0f53\u0f0b\u0f4a\u0f72\u0f0b\u0f53'),'ee':'Argentina nutome','el':u('\u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae'),'en':'*aa','eo':'Argentino','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0622\u0631\u0698\u0627\u0646\u062a\u06cc\u0646'),'ff':'Arjantiin','fi':'Argentiina','fj':'*aa','fo':'*aa','fr':'Argentine','fy':'*af','ga':u('an Airgint\u00edn'),'gd':'An Argantain','gl':'Arxentina','gn':'*aa','gu':u('\u0a86\u0ab0\u0acd\u0a9c\u0ac7\u0aa8\u0acd\u0a9f\u0ac0\u0aa8\u0abe'),'gv':'*aa','ha':'Arjantiniya','he':u('\u05d0\u05e8\u05d2\u05e0\u05d8\u05d9\u05e0\u05d4'),'hi':u('\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u0940\u0928\u093e'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':u('Argent\u00edna'),'hy':u('\u0531\u0580\u0563\u0565\u0576\u057f\u056b\u0576\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*hu','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30a2\u30eb\u30bc\u30f3\u30c1\u30f3'),'ji':u('\u05d0\u05b7\u05e8\u05d2\u05e2\u05e0\u05d8\u05d9\u05e0\u05e2'),'jv':'*aa','ka':u('\u10d0\u10e0\u10d2\u10d4\u10dc\u10e2\u10d8\u10dc\u10d0'),'kg':'*aa','ki':'Ajentina','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u17a2\u17b6\u17a0\u17d2\u179f\u1784\u17cb\u1791\u17b8\u1793'),'kn':u('\u0c85\u0cb0\u0ccd\u0c9c\u0cc6\u0c82\u0c9f\u0cbf\u0ca8\u0cbe'),'ko':u('\uc544\ub974\ud5e8\ud2f0\ub098'),'kr':'*aa','ks':u('\u0623\u0631\u062c\u064e\u0646\u0679\u06cc\u0646\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*de','lg':'Arigentina','li':'*aa','ln':u('Arizantin\u025b'),'lo':u('\u0ead\u0eb2\u0ec0\u0e88\u0e99\u0e97\u0eb4\u0e99\u0eb2'),'lt':'*aa','lu':'Alijantine','lv':u('Argent\u012bna'),'mg':'Arzantina','mh':'*aa','mi':'*aa','mk':'*ce','ml':u('\u0d05\u0d7c\u0d1c\u0d28\u0d4d\u0d31\u0d40\u0d28'),'mn':u('\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d'),'mo':'*aa','mr':u('\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u093f\u0928\u093e'),'ms':'*aa','mt':u('l-Ar\u0121entina'),'my':u('\u1021\u102c\u1002\u103b\u1004\u103a\u1010\u102e\u1038\u1014\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'*ki','ne':u('\u0905\u0930\u094d\u091c\u0947\u0928\u094d\u091f\u093f\u0928\u093e'),'ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b06\u0b30\u0b4d\u0b1c\u0b47\u0b23\u0b4d\u0b1f\u0b3f\u0b28\u0b3e'),'os':'*aa','pa':u('\u0a05\u0a30\u0a1c\u0a28\u0a1f\u0a40\u0a28\u0a3e'),'pi':'*aa','pl':'Argentyna','ps':u('\u0627\u0631\u0698\u0646\u067c\u0627\u06cc\u0646'),'pt':'*aa','qu':'*aa','rm':'Argentinia','rn':'Arijantine','ro':'*aa','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u0631\u062c\u0646\u067d\u064a\u0646\u0627'),'se':'*aa','sg':u('Arzant\u00eena'),'si':u('\u0d86\u0dbb\u0dca\u0da2\u0dd9\u0db1\u0dca\u0da7\u0dd2\u0db1\u0dcf\u0dc0'),'sk':'*hu','sl':'*aa','sm':'*aa','sn':'*ki','so':'*ff','sq':u('Argjentin\u00eb'),'sr':'*ce','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*ki','ta':u('\u0b85\u0bb0\u0bcd\u0b9c\u0bc6\u0ba9\u0bcd\u0b9f\u0bbf\u0ba9\u0bbe'),'te':u('\u0c05\u0c30\u0c4d\u0c1c\u0c46\u0c02\u0c1f\u0c40\u0c28\u0c3e'),'tg':'*ce','th':u('\u0e2d\u0e32\u0e23\u0e4c\u0e40\u0e08\u0e19\u0e15\u0e34\u0e19\u0e32'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':u('\u02bbAsenitina'),'tr':'Arjantin','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u0626\u0627\u0631\u06af\u06d0\u0646\u062a\u0649\u0646\u0627'),'uk':'*ce','ur':u('\u0627\u0631\u062c\u0646\u0679\u06cc\u0646\u0627'),'uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':u('Ars\u00e0ntin'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Agent\u00edn\u00e0'),'za':'*aa','zh':u('\u963f\u6839\u5ef7'),'zu':'i-Argentina',},
  'AS': {'aa':'American Samoa','ab':'*aa','ae':'*aa','af':'Amerikaanse Samoa','ak':u('Am\u025brika Samoa'),'am':u('\u12e8\u12a0\u121c\u122a\u12ab \u1233\u121e\u12a0'),'an':'*aa','ar':u('\u0633\u0627\u0645\u0648\u0627 \u0627\u0644\u0623\u0645\u0631\u064a\u0643\u064a\u0629'),'as':u('\u0986\u09ae\u09c7\u09f0\u09bf\u0995\u09be\u09a8 \u099a\u09be\u09ae\u09cb\u09f1\u09be'),'av':'*aa','ay':'*aa','az':u('Amerika Samoas\u0131'),'ba':'*aa','be':u('\u0410\u043c\u0435\u0440\u044b\u043a\u0430\u043d\u0441\u043a\u0430\u0435 \u0421\u0430\u043c\u043e\u0430'),'bg':u('\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u0421\u0430\u043c\u043e\u0430'),'bh':'*aa','bi':'*aa','bm':'Samowa amerikani','bn':u('\u0986\u09ae\u09c7\u09b0\u09bf\u0995\u09be\u09a8 \u09b8\u09be\u09ae\u09cb\u09af\u09bc\u09be'),'bo':'*aa','br':'Samoa Amerikan','bs':u('Ameri\u010dka Samoa'),'ca':'Samoa Nord-americana','ce':u('\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d \u0421\u0430\u043c\u043e\u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Americk\u00e1 Samoa'),'cu':'*aa','cv':'*aa','cy':'Samoa America','da':'Amerikansk Samoa','de':'Amerikanisch-Samoa','dv':'*aa','dz':u('\u0f66\u0f0b\u0f58\u0f7c\u0f0b\u0f68\u0f0b\u0f61\u0f74\u0f0b\u0f68\u0f7a\u0f66\u0f0b\u0f68\u0f7a\u0f0b\u0f58\u0f44\u0f60\u0f0b\u0f41\u0f7c\u0f44\u0f66'),'ee':'Amerika Samoa nutome','el':u('\u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03b1\u03bd\u03b9\u03ba\u03ae \u03a3\u03b1\u03bc\u03cc\u03b1'),'en':'*aa','eo':'*aa','es':'Samoa Americana','et':'Ameerika Samoa','eu':'Samoa Estatubatuarra','fa':u('\u0633\u0627\u0645\u0648\u0622\u06cc \u0627\u0645\u0631\u06cc\u06a9\u0627'),'ff':'Samowa Amerik','fi':'Amerikan Samoa','fj':'*aa','fo':'Amerikanska Samoa','fr':u('Samoa am\u00e9ricaines'),'fy':'Amerikaansk Samoa','ga':u('Sam\u00f3 Mheirice\u00e1'),'gd':'Samotha na h-Aimeireaga','gl':'*es','gn':'*aa','gu':u('\u0a85\u0aae\u0ac7\u0ab0\u0abf\u0a95\u0aa8 \u0ab8\u0aae\u0acb\u0a86'),'gv':'*aa','ha':'Samowa Ta Amurka','he':u('\u05e1\u05de\u05d5\u05d0\u05d4 \u05d4\u05d0\u05de\u05e8\u05d9\u05e7\u05e0\u05d9\u05ea'),'hi':u('\u0905\u092e\u0947\u0930\u093f\u0915\u0940 \u0938\u092e\u094b\u0906'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'Amerikai Szamoa','hy':u('\u0531\u0574\u0565\u0580\u056b\u056f\u0575\u0561\u0576 \u054d\u0561\u0574\u0578\u0561'),'hz':'*aa','ia':'*aa','id':'Samoa Amerika','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Bandar\u00edska Sam\u00f3a'),'it':'Samoa americane','iu':'*aa','iw':'*he','ja':u('\u7c73\u9818\u30b5\u30e2\u30a2'),'ji':'*aa','jv':'*aa','ka':u('\u10d0\u10db\u10d4\u10e0\u10d8\u10d9\u10d8\u10e1 \u10e1\u10d0\u10db\u10dd\u10d0'),'kg':'*aa','ki':'Samoa ya Marekani','kj':'*aa','kk':u('\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043b\u044b\u049b \u0421\u0430\u043c\u043e\u0430'),'kl':'*aa','km':u('\u179f\u17b6\u1798\u17d0\u179a \u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780\u17b6\u17c6\u1784'),'kn':u('\u0c85\u0cae\u0cc7\u0cb0\u0cbf\u0c95\u0ca8\u0ccd \u0cb8\u0cae\u0ccb\u0cb5\u0cbe'),'ko':u('\uc544\uba54\ub9ac\uce78 \uc0ac\ubaa8\uc544'),'kr':'*aa','ks':u('\u0627\u064e\u0645\u0631\u06cc\u0656\u06a9\u064e\u0646 \u0633\u064e\u0645\u0648\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043b\u044b\u043a \u0421\u0430\u043c\u043e\u0430'),'la':'*aa','lb':'Amerikanesch-Samoa','lg':'Samowa omumerika','li':'*aa','ln':'Samoa ya Ameriki','lo':u('\u0ead\u0eb2\u0ec0\u0ea1\u0ea3\u0eb4\u0e81\u0eb2 \u0e8a\u0eb2\u0ea1\u0ebb\u0ea7'),'lt':'Amerikos Samoa','lu':'Samoa wa Ameriki','lv':'ASV Samoa','mg':'Samoa amerikanina','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d05\u0d2e\u0d47\u0d30\u0d3f\u0d15\u0d4d\u0d15\u0d7b \u0d38\u0d2e\u0d4b\u0d35'),'mn':u('\u0410\u043c\u0435\u0440\u0438\u043a\u0438\u0439\u043d \u0421\u0430\u043c\u043e\u0430'),'mo':u('Samoa American\u0103'),'mr':u('\u0905\u092e\u0947\u0930\u093f\u0915\u0928 \u0938\u093e\u092e\u094b\u0906'),'ms':'*id','mt':'is-Samoa Amerikana','my':u('\u1021\u1019\u1031\u101b\u102d\u1000\u1014\u103a \u1006\u1019\u102d\u102f\u1038\u1021\u102c\u1038'),'na':'*aa','nb':'*da','nd':'Samoa ye Amelika','ne':'*hi','ng':'*aa','nl':'Amerikaans-Samoa','nn':'*da','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b3e\u0b28\u0b4d \u0b38\u0b3e\u0b2e\u0b4b\u0b06'),'os':'*aa','pa':u('\u0a05\u0a2e\u0a48\u0a30\u0a40\u0a15\u0a28 \u0a38\u0a2e\u0a4b\u0a06'),'pi':'*aa','pl':u('Samoa Ameryka\u0144skie'),'ps':u('\u0627\u0645\u0631\u06cc\u06a9\u0627\u06cc\u06cc \u0633\u0645\u0648'),'pt':'*es','qu':'*es','rm':'*es','rn':'Samowa nyamerika','ro':'*mo','ru':u('\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e\u0435 \u0421\u0430\u043c\u043e\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0622\u0645\u0631\u064a\u06aa\u064a \u0633\u0627\u0645\u0648\u0627'),'se':u('Amerihk\u00e1 Samoa'),'sg':u('Sam\u00f6a t\u00ee Amer\u00eeka'),'si':u('\u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc3\u0dd0\u0db8\u0ddd\u0dc0\u0dcf\u0dc0'),'sk':'*cs','sl':u('Ameri\u0161ka Samoa'),'sm':'*aa','sn':'Samoa ye Amerika','so':'Samowa Ameerika','sq':'Samoa Amerikane','sr':u('\u0410\u043c\u0435\u0440\u0438\u0447\u043a\u0430 \u0421\u0430\u043c\u043e\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*fo','sw':'*ki','ta':u('\u0b85\u0bae\u0bc6\u0bb0\u0bbf\u0b95\u0bcd\u0b95 \u0b9a\u0bae\u0bcb\u0bb5\u0bbe'),'te':u('\u0c05\u0c2e\u0c46\u0c30\u0c3f\u0c15\u0c28\u0c4d \u0c38\u0c2e\u0c4b\u0c35\u0c3e'),'tg':u('\u0421\u0430\u043c\u043e\u0430\u0438 \u0410\u043c\u0435\u0440\u0438\u043a\u0430'),'th':u('\u0e2d\u0e40\u0e21\u0e23\u0e34\u0e01\u0e31\u0e19\u0e0b\u0e32\u0e21\u0e31\u0e27'),'ti':u('\u1293\u12ed \u12a3\u121c\u122a\u12ab \u1233\u121e\u12a3'),'tk':'Amerikan Samoasy','tl':'*aa','tn':'*aa','to':u('Ha\u02bbamoa \u02bbAmelika'),'tr':u('Amerikan Samoas\u0131'),'ts':'*aa','tt':u('\u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0421\u0430\u043c\u043e\u0430\u0441\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0626\u0627\u0645\u06d0\u0631\u0649\u0643\u0627 \u0633\u0627\u0645\u0648\u0626\u0627'),'uk':u('\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0435 \u0421\u0430\u043c\u043e\u0430'),'ur':u('\u0627\u0645\u0631\u06cc\u06a9\u06cc \u0633\u0627\u0645\u0648\u0622'),'uz':'Amerika Samoasi','ve':'*aa','vi':u('Samoa thu\u1ed9c M\u1ef9'),'vo':'*aa','wa':'*aa','wo':'Samowa bu Amerig','xh':'*aa','yi':'*aa','yo':u('S\u00e1m\u00f3\u00e1n\u00ec ti Or\u00edl\u1eb9\u0301\u00e8de \u00c0m\u00e9r\u00edk\u00e0'),'za':'*aa','zh':u('\u7f8e\u5c5e\u8428\u6469\u4e9a'),'zu':'i-American Samoa',},
  'AT': {'aa':'Austria','ab':'*aa','ae':'*aa','af':'Oostenryk','ak':u('\u0186stria'),'am':u('\u12a6\u1235\u1275\u122a\u12eb'),'an':'*aa','ar':u('\u0627\u0644\u0646\u0645\u0633\u0627'),'as':u('\u0985\u09b7\u09cd\u099f\u09cd\u09f0\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Avstriya','ba':'*aa','be':u('\u0410\u045e\u0441\u0442\u0440\u044b\u044f'),'bg':u('\u0410\u0432\u0441\u0442\u0440\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Otirisi','bn':u('\u0985\u09b8\u09cd\u099f\u09cd\u09b0\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'Aostria','bs':'Austrija','ca':u('\u00c0ustria'),'ce':u('\u0410\u0432\u0441\u0442\u0440\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Rakousko','cu':'*aa','cv':'*aa','cy':'Awstria','da':u('\u00d8strig'),'de':u('\u00d6sterreich'),'dv':'*aa','dz':u('\u0f68\u0f71\u0f7c\u0f66\u0f0b\u0f4a\u0fb2\u0f72\u0f0b\u0f61'),'ee':'Austria nutome','el':u('\u0391\u03c5\u03c3\u03c4\u03c1\u03af\u03b1'),'en':'*aa','eo':u('A\u016dstrujo'),'es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0627\u062a\u0631\u06cc\u0634'),'ff':'Otiriis','fi':u('It\u00e4valta'),'fj':'*aa','fo':u('Eysturr\u00edki'),'fr':'Autriche','fy':'Eastenryk','ga':'an Ostair','gd':'An Ostair','gl':'*aa','gn':'*aa','gu':u('\u0a91\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Ostiriya','he':u('\u05d0\u05d5\u05e1\u05d8\u05e8\u05d9\u05d4'),'hi':u('\u0911\u0938\u094d\u091f\u094d\u0930\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'Ausztria','hy':u('\u0531\u057e\u057d\u057f\u0580\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Austurr\u00edki'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30aa\u30fc\u30b9\u30c8\u30ea\u30a2'),'ji':u('\u05e2\u05e1\u05d8\u05e8\u05d9\u05d9\u05da'),'jv':'*aa','ka':u('\u10d0\u10d5\u10e1\u10e2\u10e0\u10d8\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a2\u17bc\u1791\u17d2\u179a\u17b8\u179f'),'kn':u('\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cbf\u0caf\u0cbe'),'ko':u('\uc624\uc2a4\ud2b8\ub9ac\uc544'),'kr':'*aa','ks':u('\u0622\u0633\u0679\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':u('\u00c9istr\u00e4ich'),'lg':'Awusituriya','li':'*aa','ln':'Otilisi','lo':u('\u0ead\u0ead\u0eaa\u0ec0\u0e97\u0ea3\u0e8d'),'lt':'*bs','lu':'*ln','lv':'*bs','mg':'Aotrisy','mh':'*aa','mi':'*aa','mk':u('\u0410\u0432\u0441\u0442\u0440\u0438\u0458\u0430'),'ml':u('\u0d13\u0d38\u0d4d\u0d1f\u0d4d\u0d30\u0d3f\u0d2f'),'mn':'*ce','mo':'*aa','mr':'*hi','ms':'*aa','mt':'l-Awstrija','my':u('\u1029\u1005\u1010\u103c\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':u('\u00d8sterrike'),'nd':'*aa','ne':u('\u0905\u0937\u094d\u091f\u094d\u0930\u093f\u092f\u093e'),'ng':'*aa','nl':'Oostenrijk','nn':'Austerrike','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b05\u0b37\u0b4d\u0b1f\u0b4d\u0b30\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a06\u0a38\u0a1f\u0a30\u0a40\u0a06'),'pi':'*aa','pl':'*aa','ps':'*fa','pt':u('\u00c1ustria'),'qu':'*aa','rm':'*aa','rn':'Otirishe','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0622\u0634\u067d\u0631\u064a\u0627'),'se':'Nuortariika','sg':u('Otr\u00eesi'),'si':u('\u0d94\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dd2\u0dba\u0dcf\u0dc0'),'sk':u('Rak\u00fasko'),'sl':'Avstrija','sm':'*aa','sn':'*aa','so':'Awsteriya','sq':'Austri','sr':u('\u0410\u0443\u0441\u0442\u0440\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('\u00d6sterrike'),'sw':'*aa','ta':u('\u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bbf\u0baf\u0bbe'),'te':u('\u0c06\u0c38\u0c4d\u0c1f\u0c4d\u0c30\u0c3f\u0c2f\u0c3e'),'tg':'*bg','th':u('\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e35\u0e22'),'ti':'*am','tk':u('Awstri\u00fda'),'tl':'*aa','tn':'*aa','to':u('\u02bbAositulia'),'tr':'Avusturya','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0626\u0627\u06cb\u0649\u0633\u062a\u0649\u0631\u0649\u064a\u06d5'),'uk':u('\u0410\u0432\u0441\u0442\u0440\u0456\u044f'),'ur':u('\u0622\u0633\u0679\u0631\u06cc\u0627'),'uz':'*az','ve':'*aa','vi':u('\u00c1o'),'vo':'*aa','wa':'*aa','wo':u('\u00d3tiriis'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de As\u00edt\u00edr\u00ed\u00e0'),'za':'*aa','zh':u('\u5965\u5730\u5229'),'zu':'i-Austria',},
  'AU': {'aa':'Australia','ab':'*aa','ae':'*aa','af':u('Australi\u00eb'),'ak':u('\u0186strelia'),'am':u('\u12a0\u12cd\u1235\u1275\u122b\u120d\u12eb'),'an':'*aa','ar':u('\u0623\u0633\u062a\u0631\u0627\u0644\u064a\u0627'),'as':u('\u0985\u09b7\u09cd\u099f\u09cd\u09f0\u09c7\u09b2\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Avstraliya','ba':'*aa','be':u('\u0410\u045e\u0441\u0442\u0440\u0430\u043b\u0456\u044f'),'bg':u('\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Ositirali','bn':u('\u0985\u09b8\u09cd\u099f\u09cd\u09b0\u09c7\u09b2\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'Aostralia','bs':'Australija','ca':u('Austr\u00e0lia'),'ce':u('\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Austr\u00e1lie'),'cu':'*aa','cv':'*aa','cy':'Awstralia','da':'Australien','de':'*da','dv':'*aa','dz':u('\u0f68\u0f71\u0f7c\u0f66\u0f0b\u0f4a\u0fb2\u0f7a\u0f63\u0f0b\u0f63\u0f72\u0f0b\u0f61'),'ee':'Australia nutome','el':u('\u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1'),'en':'*aa','eo':u('A\u016dstralio'),'es':'*aa','et':'Austraalia','eu':'*aa','fa':u('\u0627\u0633\u062a\u0631\u0627\u0644\u06cc\u0627'),'ff':'Ostaraalii','fi':'*aa','fj':'*aa','fo':'Avstralia','fr':'Australie','fy':'*af','ga':u('an Astr\u00e1il'),'gd':u('Astr\u00e0ilia'),'gl':'*aa','gn':'*aa','gu':u('\u0a91\u0ab8\u0acd\u0a9f\u0acd\u0ab0\u0ac7\u0ab2\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Ostareliya','he':u('\u05d0\u05d5\u05e1\u05d8\u05e8\u05dc\u05d9\u05d4'),'hi':u('\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Ausztr\u00e1lia'),'hy':u('\u0531\u057e\u057d\u057f\u0580\u0561\u056c\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('\u00c1stral\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30aa\u30fc\u30b9\u30c8\u30e9\u30ea\u30a2'),'ji':u('\u05d0\u05d5\u05d9\u05e1\u05d8\u05e8\u05d0\u05b7\u05dc\u05d9\u05e2'),'jv':'*aa','ka':u('\u10d0\u10d5\u10e1\u10e2\u10e0\u10d0\u10da\u10d8\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a2\u17bc\u179f\u17d2\u178f\u17d2\u179a\u17b6\u179b\u17b8'),'kn':u('\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe'),'ko':u('\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544'),'kr':'*aa','ks':u('\u0622\u0633\u0679\u0631\u06cc\u0644\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*da','lg':'Awusitureliya','li':'*aa','ln':u('Osit\u00e1li'),'lo':u('\u0ead\u0ead\u0eaa\u0ec0\u0e95\u0ea3\u0ec0\u0ea5\u0e8d'),'lt':'*bs','lu':'Ositali','lv':u('Austr\u0101lija'),'mg':'*br','mh':'*aa','mi':'*aa','mk':u('\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0430'),'ml':u('\u0d13\u0d38\u0d4d\u200c\u0d1f\u0d4d\u0d30\u0d47\u0d32\u0d3f\u0d2f'),'mn':'*ce','mo':'*aa','mr':'*hi','ms':'*aa','mt':'l-Awstralja','my':u('\u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0905\u0937\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e'),'ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b05\u0b37\u0b4d\u0b1f\u0b4d\u0b30\u0b47\u0b32\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a06\u0a38\u0a1f\u0a4d\u0a30\u0a47\u0a32\u0a40\u0a06'),'pi':'*aa','pl':'*aa','ps':u('\u0622\u0633\u067c\u0631\u0627\u0644\u06cc\u0627'),'pt':u('Austr\u00e1lia'),'qu':'*aa','rm':'*aa','rn':'Ositaraliya','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0622\u0633\u067d\u0631\u064a\u0644\u064a\u0627'),'se':'*pt','sg':u('Ostral\u00efi, Sotral\u00efi'),'si':u('\u0d95\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*pt','sl':'Avstralija','sm':'*aa','sn':'*aa','so':'Awstaraaliya','sq':'Australi','sr':u('\u0410\u0443\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':u('\u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bc7\u0bb2\u0bbf\u0baf\u0bbe'),'te':u('\u0c06\u0c38\u0c4d\u0c1f\u0c4d\u0c30\u0c47\u0c32\u0c3f\u0c2f\u0c3e'),'tg':'*bg','th':u('\u0e2d\u0e2d\u0e2a\u0e40\u0e15\u0e23\u0e40\u0e25\u0e35\u0e22'),'ti':u('\u12a0\u12cd\u1235\u1275\u122c\u120a\u12eb'),'tk':u('Awstrali\u00fda'),'tl':'*aa','tn':'*aa','to':u('\u02bbAositel\u0113lia'),'tr':'Avustralya','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0626\u0627\u06cb\u0633\u062a\u0631\u0627\u0644\u0649\u064a\u06d5'),'uk':u('\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0456\u044f'),'ur':u('\u0622\u0633\u0679\u0631\u06cc\u0644\u06cc\u0627'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Ostarali','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de \u00c1str\u00e0l\u00ec\u00e1'),'za':'*aa','zh':u('\u6fb3\u5927\u5229\u4e9a'),'zu':'i-Australia',},
  'AW': {'aa':'Aruba','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u12a0\u1229\u1263'),'an':'*aa','ar':u('\u0623\u0631\u0648\u0628\u0627'),'as':u('\u0986\u09f0\u09c1\u09ac\u09be'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u0410\u0440\u0443\u0431\u0430'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u0986\u09b0\u09c1\u09ac\u09be'),'bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f68\u0f0b\u0f62\u0f74\u0f0b\u0f56\u0f71'),'ee':'Aruba nutome','el':u('\u0391\u03c1\u03bf\u03cd\u03bc\u03c0\u03b1'),'en':'*aa','eo':'Arubo','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0622\u0631\u0648\u0628\u0627'),'ff':'Aruuba','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Ar\u00faba'),'gd':u('Ar\u00f9ba'),'gl':'*aa','gn':'*aa','gu':u('\u0a85\u0ab0\u0ac1\u0aac\u0abe'),'gv':'*aa','ha':'*aa','he':u('\u05d0\u05e8\u05d5\u05d1\u05d4'),'hi':u('\u0905\u0930\u0942\u092c\u093e'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u0531\u0580\u0578\u0582\u0562\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*ga','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30a2\u30eb\u30d0'),'ji':u('\u05d0\u05b7\u05e8\u05d5\u05d1\u05d0\u05b7'),'jv':'*aa','ka':u('\u10d0\u10e0\u10e3\u10d1\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u17a2\u17b6\u179a\u17bc\u1794\u17b6'),'kn':u('\u0c85\u0cb0\u0cc1\u0cac\u0cbe'),'ko':u('\uc544\ub8e8\ubc14'),'kr':'*aa','ks':u('\u0627\u064e\u0631\u0648\u0657\u0628\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0ead\u0eb2\u0ea3\u0eb9\u0e9a\u0eb2'),'lt':'*aa','lu':'*aa','lv':'*aa','mg':u('Arob\u00e0'),'mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d05\u0d31\u0d42\u0d2c'),'mn':'*be','mo':'*aa','mr':u('\u0905\u0930\u0941\u092c\u093e'),'ms':'*aa','mt':'*aa','my':u('\u1021\u102c\u101b\u1030\u1038\u1017\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'Arubha','ne':'*mr','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b06\u0b30\u0b41\u0b2c\u0b3e'),'os':'*aa','pa':u('\u0a05\u0a30\u0a42\u0a2c\u0a3e'),'pi':'*aa','pl':'*aa','ps':'*fa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0639\u0631\u0648\u0628\u0627'),'se':'*aa','sg':u('Ar\u00fbba'),'si':u('\u0d85\u0dbb\u0dd6\u0db6\u0dcf'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*nd','so':'*aa','sq':u('Arub\u00eb'),'sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b85\u0bb0\u0bc2\u0baa\u0bbe'),'te':u('\u0c05\u0c30\u0c41\u0c2c\u0c3e'),'tg':'*be','th':u('\u0e2d\u0e32\u0e23\u0e39\u0e1a\u0e32'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':u('\u02bbAlupa'),'tr':'*aa','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u0626\u0627\u0631\u06c7\u0628\u0627'),'uk':'*be','ur':u('\u0627\u0631\u0648\u0628\u0627'),'uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de \u00c1r\u00fab\u00e0'),'za':'*aa','zh':u('\u963f\u9c81\u5df4'),'zu':'i-Aruba',},
  'AX': {'aa':u('\u00c5land Islands'),'ab':'*aa','ae':'*aa','af':u('\u00c5landeilande'),'ak':'*aa','am':u('\u12e8\u12a0\u120b\u1295\u12f5 \u12f0\u1234\u1276\u127d'),'an':'*aa','ar':u('\u062c\u0632\u0631 \u0622\u0644\u0627\u0646\u062f'),'as':u('\u0986\u09b2\u09a3\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'av':'*aa','ay':'*aa','az':u('Aland adalar\u0131'),'ba':'*aa','be':u('\u0410\u043b\u0430\u043d\u0434\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b'),'bg':u('\u041e\u043b\u0430\u043d\u0434\u0441\u043a\u0438 \u043e\u0441\u0442\u0440\u043e\u0432\u0438'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u0986\u09b2\u09be\u09a8\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'bo':'*aa','br':u('Inizi \u00c5land'),'bs':'Olandska ostrva','ca':u('Illes \u00c5land'),'ce':u('\u0410\u043b\u0430\u043d\u0434\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('\u00c5landy'),'cu':'*aa','cv':'*aa','cy':u('Ynysoedd \u00c5land'),'da':u('\u00c5land'),'de':u('\u00c5landinseln'),'dv':'*aa','dz':u('\u0f68\u0f0b\u0f63\u0f53\u0f4c\u0f0b\u0f42\u0fb3\u0f72\u0f44\u0f0b\u0f5a\u0f7c\u0f58'),'ee':u('\u00c5land \u0192udomekpo nutome'),'el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u038c\u03bb\u03b1\u03bd\u03c4'),'en':'*aa','eo':'*aa','es':u('Islas \u00c5land'),'et':'Ahvenamaa','eu':'Aland uharteak','fa':u('\u062c\u0632\u0627\u06cc\u0631 \u0622\u0644\u0627\u0646\u062f'),'ff':'*aa','fi':'Ahvenanmaa','fj':'*aa','fo':u('\u00c1land'),'fr':u('\u00celes \u00c5land'),'fy':u('\u00c5l\u00e2n'),'ga':u('Oile\u00e1in \u00c5land'),'gd':u('Na h-Eileanan \u00c5land'),'gl':'Illas Aland','gn':'*aa','gu':u('\u0a91\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8'),'gv':'*aa','ha':'*aa','he':u('\u05d0\u05d9\u05d9 \u05d0\u05d5\u05dc\u05e0\u05d3'),'hi':u('\u090f\u0932\u0948\u0902\u0921 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939'),'ho':'*aa','hr':u('\u00c5landski otoci'),'ht':'*aa','hu':u('\u00c5land-szigetek'),'hy':u('\u0531\u056c\u0561\u0576\u0564\u0575\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'Kepulauan Aland','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('\u00c1landseyjar'),'it':u('Isole \u00c5land'),'iu':'*aa','iw':'*he','ja':u('\u30aa\u30fc\u30e9\u30f3\u30c9\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':u('\u10d0\u10da\u10d0\u10dc\u10d3\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u0410\u043b\u0430\u043d\u0434 \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'kl':'*aa','km':u('\u1780\u17c4\u17c7\u200b\u17a2\u17b6\u17a1\u1784\u17cb'),'kn':u('\u0c86\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3\u0cc1'),'ko':u('\uc62c\ub780\ub4dc \uc81c\ub3c4'),'kr':'*aa','ks':u('\u0627\u06cc\u0644\u06cc\u0646\u065b\u0691 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':u('\u00c5landinselen'),'lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0eab\u0ea1\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ec2\u0ead\u0ea5\u0eb1\u0e99'),'lt':u('Aland\u0173 Salos'),'lu':'*aa','lv':'Olandes salas','mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u041e\u043b\u0430\u043d\u0434\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438'),'ml':u('\u0d05\u0d32\u0d7b\u0d21\u0d4d \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e'),'mn':u('\u0410\u043b\u0430\u043d\u0434\u044b\u043d \u0430\u0440\u043b\u0443\u0443\u0434'),'mo':u('Insulele \u00c5land'),'mr':u('\u0905\u200d\u0945\u0932\u0901\u0921 \u092c\u0947\u091f\u0947'),'ms':'*id','mt':u('il-G\u017cejjer Aland'),'my':u('\u1021\u102c\u101c\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038'),'na':'*aa','nb':'*da','nd':'*aa','ne':u('\u0905\u0932\u093e\u0928\u094d\u0921 \u091f\u093e\u092a\u0941\u0939\u0930\u0941'),'ng':'*aa','nl':'*da','nn':'*da','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b05\u0b32\u0b3e\u0b23\u0b4d\u0b21 \u0b26\u0b4d\u0b35\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c'),'os':'*aa','pa':u('\u0a05\u0a32\u0a48\u0a02\u0a21 \u0a1f\u0a3e\u0a2a\u0a42'),'pi':'*aa','pl':'Wyspy Alandzkie','ps':u('\u0627\u0644\u0627\u0646\u062f \u067c\u0627\u067e\u0648\u0627\u0646'),'pt':'Ilhas Aland','qu':'*aa','rm':'Inslas Aland','rn':'*aa','ro':'*mo','ru':u('\u0410\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0435 \u043e-\u0432\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u0644\u0646\u062f \u067b\u064a\u067d'),'se':u('\u00c5l\u00e1nda'),'sg':'*aa','si':u('\u0d95\u0dbd\u0db1\u0dca\u0da9\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca'),'sk':'Alandy','sl':u('\u00c5landski otoki'),'sm':'*aa','sn':'*aa','so':'*aa','sq':u('Ishujt Aland\u00eb'),'sr':u('\u041e\u043b\u0430\u043d\u0434\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'Visiwa vya Aland','ta':u('\u0b86\u0bb2\u0ba8\u0bcd\u0ba4\u0bc1 \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd'),'te':u('\u0c06\u0c32\u0c3e\u0c02\u0c21\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41'),'tg':u('\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u0410\u043b\u0430\u043d\u0434'),'th':u('\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e42\u0e2d\u0e25\u0e31\u0e19\u0e14\u0e4c'),'ti':u('\u12f0\u1234\u1273\u1275 \u12a3\u120b\u1295\u12f5'),'tk':'Aland adalary','tl':'*aa','tn':'*aa','to':u('\u02bbOtumotu \u02bbAlani'),'tr':u('\u00c5land Adalar\u0131'),'ts':'*aa','tt':u('\u0410\u043b\u0430\u043d\u0434 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0626\u0627\u0644\u0627\u0646\u062f \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649'),'uk':u('\u0410\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0456 \u043e\u0441\u0442\u0440\u043e\u0432\u0438'),'ur':u('\u0622\u0644\u06cc\u0646\u0688 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632'),'uz':'Aland orollari','ve':'*aa','vi':u('Qu\u1ea7n \u0111\u1ea3o \u00c5land'),'vo':'*aa','wa':'*aa','wo':u('Duni Aal\u00e0nd'),'xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5965\u5170\u7fa4\u5c9b'),'zu':u('i-\u00c5land Islands'),},
  'AZ': {'aa':'Azerbaijan','ab':'*aa','ae':'*aa','af':'Azerbeidjan','ak':'Azebaegyan','am':u('\u12a0\u12d8\u122d\u1263\u1303\u1295'),'an':'*aa','ar':u('\u0623\u0630\u0631\u0628\u064a\u062c\u0627\u0646'),'as':u('\u0986\u099c\u09be\u09f0\u09ac\u09c7\u0987\u099c\u09be\u09a8'),'av':'*aa','ay':'*aa','az':u('Az\u0259rbaycan'),'ba':'*aa','be':u('\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d'),'bg':'*be','bh':'*aa','bi':'*aa','bm':u('Az\u025brbayja\u014b'),'bn':u('\u0986\u099c\u09be\u09b0\u09ac\u09be\u0987\u099c\u09be\u09a8'),'bo':'*aa','br':'Azerbaidjan','bs':u('Azerbejd\u017ean'),'ca':'*br','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':u('\u00c1zerb\u00e1jd\u017e\u00e1n'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'Aserbajdsjan','de':'Aserbaidschan','dv':'*aa','dz':u('\u0f68\u0f0b\u0f5b\u0f62\u0f0b\u0f56\u0fb7\u0f60\u0f72\u0f0b\u0f47\u0f71\u0f53'),'ee':'Azerbaijan nutome','el':u('\u0391\u03b6\u03b5\u03c1\u03bc\u03c0\u03b1\u03ca\u03c4\u03b6\u03ac\u03bd'),'en':'*aa','eo':u('Azerbaj\u011dano'),'es':u('Azerbaiy\u00e1n'),'et':u('Aserbaid\u017eaan'),'eu':'*aa','fa':u('\u062c\u0645\u0647\u0648\u0631\u06cc \u0622\u0630\u0631\u0628\u0627\u06cc\u062c\u0627\u0646'),'ff':'Ajerbayjaan','fi':u('Azerbaid\u017ean'),'fj':'*aa','fo':'Aserbadjan','fr':u('Azerba\u00efdjan'),'fy':'Azerbeidzjan','ga':u('an Asarbaise\u00e1in'),'gd':u('Asarbaide\u00e0n'),'gl':u('Acerbaix\u00e1n'),'gn':'*aa','gu':u('\u0a85\u0a9d\u0ab0\u0aac\u0ac8\u0a9c\u0abe\u0aa8'),'gv':'*aa','ha':'Azarbaijan','he':u('\u05d0\u05d6\u05e8\u05d1\u05d9\u05d9\u05d2\u05f3\u05df'),'hi':u('\u0905\u091c\u093c\u0930\u092c\u0948\u091c\u093e\u0928'),'ho':'*aa','hr':u('Azerbajd\u017ean'),'ht':'*aa','hu':u('Azerbajdzs\u00e1n'),'hy':u('\u0531\u0564\u0580\u0562\u0565\u057b\u0561\u0576'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Aserba\u00eddsjan'),'it':'Azerbaigian','iu':'*aa','iw':'*he','ja':u('\u30a2\u30bc\u30eb\u30d0\u30a4\u30b8\u30e3\u30f3'),'ji':'*aa','jv':'*aa','ka':u('\u10d0\u10d6\u10d4\u10e0\u10d1\u10d0\u10d8\u10ef\u10d0\u10dc\u10d8'),'kg':'*aa','ki':'Azabajani','kj':'*aa','kk':u('\u04d8\u0437\u0456\u0440\u0431\u0430\u0439\u0436\u0430\u043d'),'kl':'*aa','km':u('\u17a2\u17b6\u179f\u17ca\u17c2\u1794\u17c3\u17a0\u17d2\u179f\u1784\u17cb'),'kn':u('\u0c85\u0c9c\u0cb0\u0ccd\u0cac\u0cc8\u0c9c\u0cbe\u0ca8\u0ccd'),'ko':u('\uc544\uc81c\ub974\ubc14\uc774\uc794'),'kr':'*aa','ks':u('\u0622\u0632\u064e\u0631\u0628\u0627\u062c\u0627\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0436\u0430\u043d'),'la':'*aa','lb':'*de','lg':'Azerebayijaani','li':'*aa','ln':u('Az\u025bl\u025bbaiz\u00e1'),'lo':u('\u0ead\u0eb2\u0ec0\u0e8a\u0eb5\u0ec4\u0e9a\u0e88\u0eb2\u0e99'),'lt':u('Azerbaid\u017eanas'),'lu':'Ajelbayidja','lv':u('Azerbaid\u017e\u0101na'),'mg':'*br','mh':'*aa','mi':'*aa','mk':u('\u0410\u0437\u0435\u0440\u0431\u0435\u0458\u045f\u0430\u043d'),'ml':u('\u0d05\u0d38\u0d7c\u0d2c\u0d48\u0d1c\u0d3e\u0d7b'),'mn':'*ky','mo':'*br','mr':u('\u0905\u091d\u0930\u092c\u0948\u091c\u093e\u0928'),'ms':'*aa','mt':u('l-A\u017cerbaj\u0121an'),'my':u('\u1021\u1007\u102c\u1018\u102d\u102f\u1004\u103a\u1002\u103b\u1014\u103a'),'na':'*aa','nb':'*da','nd':'*aa','ne':u('\u0905\u091c\u0930\u092c\u0948\u091c\u093e\u0928'),'ng':'*aa','nl':'*fy','nn':'*da','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b06\u0b1c\u0b47\u0b30\u0b2c\u0b3e\u0b07\u0b1c\u0b3e\u0b28\u0b4d'),'os':'*aa','pa':u('\u0a05\u0a1c\u0a3c\u0a30\u0a2c\u0a3e\u0a08\u0a1c\u0a3e\u0a28'),'pi':'*aa','pl':u('Azerbejd\u017can'),'ps':u('\u0627\u0630\u0631\u0628\u0627\u064a\u062c\u0627\u0646'),'pt':u('Azerbaij\u00e3o'),'qu':'*es','rm':'*de','rn':'Azerubayijani','ro':'*br','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0622\u0630\u0631\u0628\u0627\u0626\u064a\u062c\u0627\u0646'),'se':u('Aserbai\u017ean'),'sg':u('Zerebaidy\u00e4an, Azerbaidy\u00e4an,'),'si':u('\u0d85\u0dc3\u0dbb\u0dca\u0db6\u0dba\u0dd2\u0da2\u0dcf\u0db1\u0dba'),'sk':'*hr','sl':'*hr','sm':'*aa','sn':'*ki','so':'Azerbajaan','sq':'Azerbajxhan','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'Azerbajdzjan','sw':'*aa','ta':u('\u0b85\u0b9a\u0bb0\u0bcd\u0baa\u0bc8\u0b9c\u0bbe\u0ba9\u0bcd'),'te':u('\u0c05\u0c1c\u0c30\u0c4d\u0c2c\u0c48\u0c1c\u0c3e\u0c28\u0c4d'),'tg':u('\u041e\u0437\u0430\u0440\u0431\u043e\u0439\u04b7\u043e\u043d'),'th':u('\u0e2d\u0e32\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e44\u0e1a\u0e08\u0e32\u0e19'),'ti':'*am','tk':u('Azerba\u00fdjan'),'tl':'*aa','tn':'*aa','to':u('\u02bbAsapaisani'),'tr':'Azerbaycan','ts':'*aa','tt':u('\u04d8\u0437\u04d9\u0440\u0431\u0430\u0439\u0497\u0430\u043d'),'tw':'*aa','ty':'*aa','ug':u('\u0626\u06d5\u0632\u06d5\u0631\u0628\u06d5\u064a\u062c\u0627\u0646'),'uk':'*be','ur':u('\u0622\u0630\u0631\u0628\u0627\u0626\u06cc\u062c\u0627\u0646'),'uz':'Ozarbayjon','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':u('Aserbayja\u014b'),'xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de As\u1eb9\u0301b\u00e1j\u00e1n\u00ec'),'za':'*aa','zh':u('\u963f\u585e\u62dc\u7586'),'zu':'i-Azerbaijan',},
  'BA': {'aa':'Bosnia and Herzegovina','ab':'*aa','ae':'*aa','af':u('Bosni\u00eb en Herzegowina'),'ak':u('Bosnia ne H\u025bzegovina'),'am':u('\u1266\u1235\u1292\u12eb \u12a5\u1293 \u1204\u122d\u12de\u130e\u126a\u1292\u12eb'),'an':'*aa','ar':u('\u0627\u0644\u0628\u0648\u0633\u0646\u0629 \u0648\u0627\u0644\u0647\u0631\u0633\u0643'),'as':u('\u09ac\u2019\u099b\u09a8\u09bf\u09af\u09bc\u09be \u0986\u09f0\u09c1 \u09b9\u09be\u09f0\u09cd\u099c\u09c7\u0997\u2019\u09ad\u09bf\u09a8\u09be'),'av':'*aa','ay':'*aa','az':u('Bosniya v\u0259 Herseqovina'),'ba':'*aa','be':u('\u0411\u043e\u0441\u043d\u0456\u044f \u0456 \u0413\u0435\u0440\u0446\u0430\u0433\u0430\u0432\u0456\u043d\u0430'),'bg':u('\u0411\u043e\u0441\u043d\u0430 \u0438 \u0425\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430'),'bh':'*aa','bi':'*aa','bm':u('Bozni-\u0190rizigovini'),'bn':u('\u09ac\u09b8\u09a8\u09bf\u09af\u09bc\u09be \u0993 \u09b9\u09be\u09b0\u09cd\u099c\u09c7\u0997\u09cb\u09ad\u09bf\u09a8\u09be'),'bo':'*aa','br':'Bosnia ha Herzegovina','bs':'Bosna i Hercegovina','ca':u('B\u00f2snia i Hercegovina'),'ce':u('\u0411\u043e\u0441\u043d\u0438 \u0430, \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430 \u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Bosna a Hercegovina','cu':'*aa','cv':'*aa','cy':'Bosnia & Herzegovina','da':'Bosnien-Hercegovina','de':'Bosnien und Herzegowina','dv':'*aa','dz':u('\u0f56\u0fb7\u0f7c\u0f66\u0f0b\u0f53\u0f72\u0f0b\u0f61\u0f0b \u0f68\u0f7a\u0f53\u0f4c\u0f0b \u0f67\u0f62\u0f0b\u0f5b\u0f72\u0f0b\u0f42\u0fb7\u0f7c\u0f0b\u0f56\u0f72\u0f0b\u0f53'),'ee':'Bosnia kple Herzergovina nutome','el':u('\u0392\u03bf\u03c3\u03bd\u03af\u03b1 - \u0395\u03c1\u03b6\u03b5\u03b3\u03bf\u03b2\u03af\u03bd\u03b7'),'en':'*cy','eo':'Bosnio-Hercegovino','es':'Bosnia y Herzegovina','et':'Bosnia ja Hertsegoviina','eu':'Bosnia-Herzegovina','fa':u('\u0628\u0648\u0633\u0646\u06cc \u0648 \u0647\u0631\u0632\u06af\u0648\u06cc\u0646'),'ff':'Bosnii Hersegowiin','fi':'Bosnia ja Hertsegovina','fj':'*aa','fo':'Bosnia-Hersegovina','fr':u('Bosnie-Herz\u00e9govine'),'fy':u('Bosni\u00eb en Herzegovina'),'ga':u('an Bhoisnia agus an Heirseagaiv\u00e9in'),'gd':'Bosna is Hearsagobhana','gl':'Bosnia e Hercegovina','gn':'*aa','gu':u('\u0aac\u0acb\u0ab8\u0acd\u0aa8\u0abf\u0aaf\u0abe \u0a85\u0aa8\u0ac7 \u0ab9\u0ab0\u0acd\u0a9d\u0ac7\u0a97\u0acb\u0ab5\u0abf\u0aa8\u0abe'),'gv':'*aa','ha':'Bosniya Harzagobina','he':u('\u05d1\u05d5\u05e1\u05e0\u05d9\u05d4 \u05d5\u05d4\u05e8\u05e6\u05d2\u05d5\u05d1\u05d9\u05e0\u05d4'),'hi':u('\u092c\u094b\u0938\u094d\u0928\u093f\u092f\u093e \u0914\u0930 \u0939\u0930\u094d\u091c\u093c\u0947\u0917\u094b\u0935\u093f\u0928\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'Bosznia-Hercegovina','hy':u('\u0532\u0578\u057d\u0576\u056b\u0561 \u0587 \u0540\u0565\u0580\u0581\u0565\u0563\u0578\u057e\u056b\u0576\u0561'),'hz':'*aa','ia':'*aa','id':'Bosnia dan Herzegovina','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Bosn\u00eda og Herseg\u00f3v\u00edna'),'it':'Bosnia ed Erzegovina','iu':'*aa','iw':'*he','ja':u('\u30dc\u30b9\u30cb\u30a2\u30fb\u30d8\u30eb\u30c4\u30a7\u30b4\u30d3\u30ca'),'ji':u('\u05d1\u05d0\u05e1\u05e0\u05d9\u05e2 \u05d4\u05e2\u05e8\u05e6\u05e2\u05d2\u05d0\u05d5\u05d5\u05d9\u05e0\u05e2'),'jv':'*aa','ka':u('\u10d1\u10dd\u10e1\u10dc\u10d8\u10d0 \u10d3\u10d0 \u10f0\u10d4\u10e0\u10ea\u10d4\u10d2\u10dd\u10d5\u10d8\u10dc\u10d0'),'kg':'*aa','ki':'Bosnia na Hezegovina','kj':'*aa','kk':u('\u0411\u043e\u0441\u043d\u0438\u044f \u0436\u04d9\u043d\u0435 \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430'),'kl':'*aa','km':u('\u1794\u17bc\u179f\u17d2\u1793\u17b8 \u1793\u17b7\u1784\u17a0\u17ba\u17a0\u17d2\u179f\u17b8\u17a0\u17d2\u1782\u17bc\u179c\u17b8\u178e\u17b6'),'kn':u('\u0cac\u0ccb\u0cb8\u0ccd\u0ca8\u0cbf\u0caf\u0cbe \u0cae\u0ca4\u0ccd\u0ca4\u0cc1 \u0cb9\u0cb0\u0ccd\u0c9c\u0cc6\u0c97\u0ccb\u0cb5\u0cbf\u0ca8\u0cbe'),'ko':u('\ubcf4\uc2a4\ub2c8\uc544 \ud5e4\ub974\uccb4\uace0\ube44\ub098'),'kr':'*aa','ks':u('\u0628\u0648\u0633\u0646\u0650\u06cc\u0627 \u062a\u06c1\u0655 \u06c1\u064e\u0631\u0632\u0650\u06af\u0648\u0648\u0650\u0646\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0411\u043e\u0441\u043d\u0438\u044f \u0436\u0430\u043d\u0430 \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430'),'la':'*aa','lb':'Bosnien an Herzegowina','lg':'Boziniya Hezegovina','li':'*aa','ln':u('Bosini mp\u00e9 Hezegovine'),'lo':u('\u0e9a\u0ead\u0e94\u0eaa\u0eb0\u0ec0\u0e99\u0e8d \u0ec1\u0ea5\u0eb0 \u0ec1\u0eae\u0eaa\u0ec2\u0e81\u0ea7\u0eb5\u0e99\u0eb2'),'lt':'Bosnija ir Hercegovina','lu':'Mbosini ne Hezegovine','lv':'Bosnija un Hercegovina','mg':'Bosnia sy Herzegovina','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d2c\u0d4b\u0d38\u0d4d\u0d28\u0d3f\u0d2f\u0d2f\u0d41\u0d02 \u0d39\u0d46\u0d7c\u0d38\u0d17\u0d4b\u0d35\u0d3f\u0d28\u0d2f\u0d41\u0d02'),'mn':u('\u0411\u043e\u0441\u043d\u0438-\u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d'),'mo':u('Bosnia \u0219i Her\u021begovina'),'mr':u('\u092c\u094b\u0938\u094d\u0928\u093f\u092f\u093e \u0905\u0923\u093f \u0939\u0930\u094d\u091c\u0947\u0917\u094b\u0935\u093f\u0928\u093e'),'ms':'*id','mt':u('il-Bo\u017cnija-\u0126erzegovina'),'my':u('\u1018\u1031\u102c\u1037\u1005\u1014\u102e\u1038\u101a\u102c\u1038\u1014\u103e\u1004\u1037\u103a \u101f\u102c\u1007\u102e\u1002\u102d\u102f\u1017\u102e\u1014\u102c\u1038'),'na':'*aa','nb':'Bosnia-Hercegovina','nd':'Bhosnia le Herzegovina','ne':u('\u092c\u094b\u0938\u094d\u0928\u093f\u092f\u093e \u090f\u0923\u094d\u0921 \u0939\u0930\u094d\u091c\u0917\u094b\u092d\u093f\u0928\u093f\u092f\u093e'),'ng':'*aa','nl':'*fy','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2c\u0b4b\u0b38\u0b28\u0b3f\u0b06 \u0b0f\u0b2c\u0b02 \u0b39\u0b30\u0b4d\u0b1c\u0b17\u0b4b\u0b2d\u0b3f\u0b28\u0b3e'),'os':'*aa','pa':u('\u0a2c\u0a4b\u0a38\u0a28\u0a40\u0a06 \u0a05\u0a24\u0a47 \u0a39\u0a30\u0a1c\u0a3c\u0a47\u0a17\u0a4b\u0a35\u0a40\u0a28\u0a3e'),'pi':'*aa','pl':u('Bo\u015bnia i Hercegowina'),'ps':u('\u0628\u0648\u0633\u0646\u064a\u0627 \u0627\u0648 \u0647\u06d0\u0631\u0632\u06ab\u0648\u064a\u0646\u0627'),'pt':u('B\u00f3snia e Herzegovina'),'qu':'*aa','rm':'*it','rn':'Bosiniya na Herigozevine','ro':'*mo','ru':u('\u0411\u043e\u0441\u043d\u0438\u044f \u0438 \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0628\u0648\u0633\u0646\u06cc\u0627 \u0627\u0648\u0631 \u0647\u0631\u0632\u06cc\u06af\u0648\u06cc\u0646\u0627'),'se':'*nb','sg':u('Bosn\u00efi na Herzegov\u00eenni'),'si':u('\u0db6\u0ddc\u0dc3\u0dca\u0db1\u0dd2\u0dba\u0dcf\u0dc0 \u0dc3\u0dc4 \u0dc4\u0dbb\u0dca\u0dc3\u0d9c\u0ddc\u0dc0\u0dd3\u0db1\u0dcf\u0dc0'),'sk':'*cs','sl':'Bosna in Hercegovina','sm':'*aa','sn':'Boznia ne Herzegovina','so':'Bosniya Hersigoviina','sq':u('Bosnj\u00eb-Hercegovin\u00eb'),'sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'Bosnien och Hercegovina','sw':'*ki','ta':u('\u0baa\u0bcb\u0bb8\u0bcd\u0ba9\u0bbf\u0baf\u0bbe & \u0bb9\u0bc6\u0bb0\u0bcd\u0bb8\u0b95\u0bcb\u0bb5\u0bbf\u0ba9\u0bbe'),'te':u('\u0c2c\u0c4b\u0c38\u0c4d\u0c28\u0c3f\u0c2f\u0c3e \u0c2e\u0c30\u0c3f\u0c2f\u0c41 \u0c39\u0c46\u0c30\u0c4d\u0c1c\u0c46\u0c17\u0c4a\u0c35\u0c40\u0c28\u0c3e'),'tg':u('\u0411\u043e\u0441\u043d\u0438\u044f \u0432\u0430 \u04b2\u0435\u0440\u0441\u0435\u0433\u043e\u0432\u0438\u043d\u0430'),'th':u('\u0e1a\u0e2d\u0e2a\u0e40\u0e19\u0e35\u0e22\u0e41\u0e25\u0e30\u0e40\u0e2e\u0e2d\u0e23\u0e4c\u0e40\u0e0b\u0e42\u0e01\u0e27\u0e35\u0e19\u0e32'),'ti':u('\u1266\u12dd\u1295\u12eb\u1295 \u1204\u122d\u12d8\u130e\u126a\u1293\u1295'),'tk':u('Bosni\u00fda we Gersegowina'),'tl':'*aa','tn':'*aa','to':u('Posinia mo Hesik\u014dvina'),'tr':'Bosna-Hersek','ts':'*aa','tt':u('\u0411\u043e\u0441\u043d\u0438\u044f \u04bb\u04d9\u043c \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430'),'tw':'*aa','ty':'*aa','ug':u('\u0628\u0648\u0633\u0649\u0646\u0649\u064a\u06d5 \u06cb\u06d5 \u06af\u06d0\u0631\u062a\u0633\u06d0\u06af\u0648\u06cb\u0649\u0646\u0627'),'uk':u('\u0411\u043e\u0441\u043d\u0456\u044f \u0456 \u0413\u0435\u0440\u0446\u0435\u0491\u043e\u0432\u0438\u043d\u0430'),'ur':u('\u0628\u0648\u0633\u0646\u06cc\u0627 \u0627\u0648\u0631 \u06c1\u0631\u0632\u06cc\u06af\u0648\u0648\u06cc\u0646\u0627'),'uz':'Bosniya va Gertsegovina','ve':'*aa','vi':u('Bosnia v\u00e0 Herzegovina'),'vo':'*aa','wa':'*aa','wo':'Bosni Ersegowin','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de B\u1ecd\u0300s\u00edn\u00ed\u00e0 \u00e0ti \u1eb8tis\u1eb9g\u00f3f\u00edn\u00e0'),'za':'*aa','zh':u('\u6ce2\u65af\u5c3c\u4e9a\u548c\u9ed1\u585e\u54e5\u7ef4\u90a3'),'zu':'i-Bosnia ne-Herzegovina',},
  'BB': {'aa':'Barbados','ab':'*aa','ae':'*aa','af':'*aa','ak':'Baabados','am':u('\u1263\u122d\u1264\u12f6\u1235'),'an':'*aa','ar':u('\u0628\u0631\u0628\u0627\u062f\u0648\u0633'),'as':u('\u09ac\u09be\u09f0\u09cd\u09ac\u09be\u09a1\u09cb\u099a'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u0411\u0430\u0440\u0431\u0430\u0434\u0430\u0441'),'bg':u('\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441'),'bh':'*aa','bi':'*aa','bm':'Barbadi','bn':u('\u09ac\u09be\u09b0\u09ac\u09be\u09a6\u09cb\u09b8'),'bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f56\u0fb7\u0f62\u0f0b\u0f56\u0f7a\u0f0b\u0f4c\u0f7c\u0f66'),'ee':'Barbados nutome','el':u('\u039c\u03c0\u03b1\u03c1\u03bc\u03c0\u03ad\u03b9\u03bd\u03c4\u03bf\u03c2'),'en':'*aa','eo':'Barbado','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0628\u0627\u0631\u0628\u0627\u062f\u0648\u0633'),'ff':'Barbadoos','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Barbade','fy':'*aa','ga':u('Barbad\u00f3s'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':u('\u0aac\u0abe\u0ab0\u0aac\u0abe\u0aa1\u0acb\u0ab8'),'gv':'*aa','ha':'Barbadas','he':u('\u05d1\u05e8\u05d1\u05d3\u05d5\u05e1'),'hi':u('\u092c\u093e\u0930\u092c\u093e\u0921\u094b\u0938'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u0532\u0561\u0580\u0562\u0561\u0564\u0578\u057d'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30d0\u30eb\u30d0\u30c9\u30b9'),'ji':u('\u05d1\u05d0\u05b7\u05e8\u05d1\u05d0\u05b7\u05d3\u05d0\u05e1'),'jv':'*aa','ka':u('\u10d1\u10d0\u10e0\u10d1\u10d0\u10d3\u10dd\u10e1\u10d8'),'kg':'*aa','ki':'Babadosi','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1794\u17b6\u1794\u17b6\u178a\u17bb\u179f'),'kn':u('\u0cac\u0cbe\u0cb0\u0ccd\u0cac\u0ca1\u0ccb\u0cb8\u0ccd'),'ko':u('\ubc14\ubca0\uc774\ub3c4\uc2a4'),'kr':'*aa','ks':u('\u0628\u0627\u0631\u0628\u06cc\u0688\u0627\u0633'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'Barabadosi','li':'*aa','ln':u('Bar\u025bbad\u025b'),'lo':u('\u0e9a\u0eb2\u0e9a\u0eb2\u0ec2\u0e94\u0eaa'),'lt':'Barbadosas','lu':'Barebade','lv':'Barbadosa','mg':'Barbady','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d2c\u0d3e\u0d7c\u0d2c\u0d21\u0d4b\u0d38\u0d4d'),'mn':'*bg','mo':'*aa','mr':u('\u092c\u093e\u0930\u094d\u092c\u093e\u0921\u094b\u0938'),'ms':'*aa','mt':'*aa','my':u('\u1018\u102c\u1018\u1031\u1038\u1012\u102d\u102f\u1038\u1005\u103a'),'na':'*aa','nb':'*aa','nd':'Bhabhadosi','ne':'*mr','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2c\u0b3e\u0b30\u0b2c\u0b3e\u0b21\u0b4b\u0b38\u0b4d'),'os':'*aa','pa':u('\u0a2c\u0a3e\u0a30\u0a2c\u0a3e\u0a21\u0a4b\u0a38'),'pi':'*aa','pl':'*aa','ps':'*fa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'Barubadosi','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0628\u0627\u0631\u0628\u068a\u0648\u0633'),'se':'*aa','sg':u('Barab\u00e2da'),'si':u('\u0db6\u0dcf\u0db6\u0da9\u0ddd\u0dc3\u0dca'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'Baarbadoos','sq':'*aa','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*ki','ta':u('\u0baa\u0bbe\u0bb0\u0bcd\u0baa\u0b9f\u0bcb\u0bb8\u0bcd'),'te':u('\u0c2c\u0c3e\u0c30\u0c4d\u0c2c\u0c21\u0c4b\u0c38\u0c4d'),'tg':'*bg','th':u('\u0e1a\u0e32\u0e23\u0e4c\u0e40\u0e1a\u0e42\u0e14\u0e2a'),'ti':'*am','tk':'Barbadow','tl':'*aa','tn':'*aa','to':u('P\u0101peitosi'),'tr':'*aa','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':'*fa','uk':'*bg','ur':u('\u0628\u0627\u0631\u0628\u0627\u0688\u0648\u0633'),'uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Barbad','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de B\u00e1b\u00e1d\u00f3s\u00ec'),'za':'*aa','zh':u('\u5df4\u5df4\u591a\u65af'),'zu':'i-Barbados',},
  'BD': {'aa':'Bangladesh','ab':'*aa','ae':'*aa','af':'Bangladesj','ak':u('Banglad\u025bhye'),'am':u('\u1263\u1295\u130d\u120b\u12f2\u123d'),'an':'*aa','ar':u('\u0628\u0646\u063a\u0644\u0627\u062f\u064a\u0634'),'as':u('\u09ac\u09be\u0982\u09b2\u09be\u09a6\u09c7\u09b6'),'av':'*aa','ay':'*aa','az':u('Banqlade\u015f'),'ba':'*aa','be':u('\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u044d\u0448'),'bg':u('\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448'),'bh':'*aa','bi':'*aa','bm':u('B\u025bngilad\u025bsi'),'bn':'*as','bo':'*aa','br':'*aa','bs':u('Banglade\u0161'),'ca':'Bangla Desh','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':u('Banglad\u00e9\u0161'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Bangladesch','dv':'*aa','dz':u('\u0f56\u0f44\u0f92\u0f0b\u0f63\u0f0b\u0f51\u0f7a\u0f64'),'ee':'Bangladesh nutome','el':u('\u039c\u03c0\u03b1\u03bd\u03b3\u03ba\u03bb\u03b1\u03bd\u03c4\u03ad\u03c2'),'en':'*aa','eo':u('Banglade\u015do'),'es':u('Banglad\u00e9s'),'et':'*aa','eu':'*aa','fa':u('\u0628\u0646\u06af\u0644\u0627\u062f\u0634'),'ff':'Banglaadees','fi':'*aa','fj':'*aa','fo':'*af','fr':'*aa','fy':'*aa','ga':u('an Bhanglaid\u00e9is'),'gd':'Bangladais','gl':'*aa','gn':'*aa','gu':u('\u0aac\u0abe\u0a82\u0a97\u0acd\u0ab2\u0abe\u0aa6\u0ac7\u0ab6'),'gv':'*aa','ha':'Bangiladas','he':u('\u05d1\u05e0\u05d2\u05dc\u05d3\u05e9'),'hi':u('\u092c\u093e\u0902\u0917\u094d\u0932\u093e\u0926\u0947\u0936'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'Banglades','hy':u('\u0532\u0561\u0576\u0563\u056c\u0561\u0564\u0565\u0577'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'Bangladess','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30d0\u30f3\u30b0\u30e9\u30c7\u30b7\u30e5'),'ji':u('\u05d1\u05d0\u05b7\u05e0\u05d2\u05dc\u05d0\u05b7\u05d3\u05e2\u05e9'),'jv':'*aa','ka':u('\u10d1\u10d0\u10dc\u10d2\u10da\u10d0\u10d3\u10d4\u10e8\u10d8'),'kg':'*aa','ki':'Bangladeshi','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1794\u1784\u17cb\u1780\u17d2\u179b\u17b6\u178a\u17c2\u179f'),'kn':u('\u0cac\u0cbe\u0c82\u0c97\u0ccd\u0cb2\u0cbe\u0ca6\u0cc7\u0cb6'),'ko':u('\ubc29\uae00\ub77c\ub370\uc2dc'),'kr':'*aa','ks':u('\u0628\u064e\u0646\u065b\u06af\u0644\u0627\u062f\u06cc\u0634'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*de','lg':'Bangaladesi','li':'*aa','ln':u('Bengalid\u025bsi'),'lo':u('\u0e9a\u0eb1\u0e87\u0e81\u0eb0\u0ea5\u0eb2\u0ec0\u0e97\u0e94'),'lt':u('Banglade\u0161as'),'lu':'Benguladeshi','lv':u('Banglade\u0161a'),'mg':'Bangladesy','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d2c\u0d02\u0d17\u0d4d\u0d32\u0d3e\u0d26\u0d47\u0d36\u0d4d'),'mn':'*bg','mo':'*aa','mr':u('\u092c\u093e\u0902\u0917\u0932\u093e\u0926\u0947\u0936'),'ms':'*aa','mt':'il-Bangladesh','my':u('\u1018\u1004\u103a\u1039\u1002\u101c\u102c\u1038\u1012\u1031\u1037\u101b\u103e\u103a'),'na':'*aa','nb':'*aa','nd':'Bhangiladeshi','ne':u('\u092c\u0919\u094d\u0917\u0932\u093e\u0926\u0947\u0936'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2c\u0b3e\u0b02\u0b32\u0b3e\u0b26\u0b47\u0b36'),'os':'*aa','pa':u('\u0a2c\u0a70\u0a17\u0a32\u0a3e\u0a26\u0a47\u0a38\u0a3c'),'pi':'*aa','pl':'Bangladesz','ps':u('\u0628\u0646\u06af\u0644\u0647 \u062f\u06d0\u0634'),'pt':'*aa','qu':'*aa','rm':'*de','rn':'Bangaladeshi','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0628\u0646\u06af\u0644\u0627\u062f\u064a\u0634'),'se':'*aa','sg':u('Benglad\u00eashi'),'si':u('\u0db6\u0d82\u0d9c\u0dca\u0dbd\u0dcf\u0daf\u0dda\u0dc1\u0dba'),'sk':'*cs','sl':'*bs','sm':'*aa','sn':'*ki','so':'Bangaaladheesh','sq':'*aa','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*ki','ta':u('\u0baa\u0b99\u0bcd\u0b95\u0bb3\u0bbe\u0ba4\u0bc7\u0bb7\u0bcd'),'te':u('\u0c2c\u0c02\u0c17\u0c4d\u0c32\u0c3e\u0c26\u0c47\u0c36\u0c4d'),'tg':'*bg','th':u('\u0e1a\u0e31\u0e07\u0e01\u0e25\u0e32\u0e40\u0e17\u0e28'),'ti':'*am','tk':u('Banglade\u015f'),'tl':'*aa','tn':'*aa','to':u('Pengil\u0101tesi'),'tr':'*tk','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0628\u06d0\u0646\u06af\u0627\u0644'),'uk':'*bg','ur':u('\u0628\u0646\u06af\u0644\u06c1 \u062f\u06cc\u0634'),'uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Bengalades','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de B\u00e1ng\u00e1l\u00e1d\u00e9s\u00ec'),'za':'*aa','zh':u('\u5b5f\u52a0\u62c9\u56fd'),'zu':'i-Bangladesh',},
  'BE': {'aa':'Belgium','ab':'*aa','ae':'*aa','af':u('Belgi\u00eb'),'ak':u('B\u025blgyium'),'am':u('\u1264\u120d\u1304\u121d'),'an':'*aa','ar':u('\u0628\u0644\u062c\u064a\u0643\u0627'),'as':u('\u09ac\u09c7\u09b2\u099c\u09bf\u09af\u09bc\u09be\u09ae'),'av':'*aa','ay':'*aa','az':u('Bel\u00e7ika'),'ba':'*aa','be':u('\u0411\u0435\u043b\u044c\u0433\u0456\u044f'),'bg':u('\u0411\u0435\u043b\u0433\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':u('B\u025bliziki'),'bn':'*as','bo':'*aa','br':'Belgia','bs':'Belgija','ca':u('B\u00e8lgica'),'ce':u('\u0411\u0435\u043b\u044c\u0433\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Belgie','cu':'*aa','cv':'*aa','cy':'Gwlad Belg','da':'Belgien','de':'*da','dv':'*aa','dz':u('\u0f56\u0fb7\u0f7a\u0f63\u0f0b\u0f47\u0f58'),'ee':'Belgium nutome','el':u('\u0392\u03ad\u03bb\u03b3\u03b9\u03bf'),'en':'*aa','eo':'Belgujo','es':u('B\u00e9lgica'),'et':'*br','eu':'Belgika','fa':u('\u0628\u0644\u0698\u06cc\u06a9'),'ff':'Beljik','fi':'*br','fj':'*aa','fo':'*br','fr':'Belgique','fy':'*af','ga':'an Bheilg','gd':u('A\u2019 Bheilg'),'gl':u('B\u00e9lxica'),'gn':'*aa','gu':u('\u0aac\u0ac7\u0ab2\u0acd\u0a9c\u0ac0\u0aaf\u0aae'),'gv':'*aa','ha':'Belgiyom','he':u('\u05d1\u05dc\u05d2\u05d9\u05d4'),'hi':u('\u092c\u0947\u0932\u094d\u091c\u093f\u092f\u092e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u0532\u0565\u056c\u0563\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*br','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*br','io':'*aa','is':u('Belg\u00eda'),'it':'Belgio','iu':'*aa','iw':'*he','ja':u('\u30d9\u30eb\u30ae\u30fc'),'ji':u('\u05d1\u05e2\u05dc\u05d2\u05d9\u05e2'),'jv':'*aa','ka':u('\u10d1\u10d4\u10da\u10d2\u10d8\u10d0'),'kg':'*aa','ki':'Ubelgiji','kj':'*aa','kk':u('\u0411\u0435\u043b\u044c\u0433\u0438\u044f'),'kl':'*aa','km':u('\u1794\u17c2\u179b\u17a0\u17d2\u179f\u17ca\u17b7\u1780'),'kn':u('\u0cac\u0cc6\u0cb2\u0ccd\u0c9c\u0cbf\u0caf\u0cae\u0ccd'),'ko':u('\ubca8\uae30\uc5d0'),'kr':'*aa','ks':u('\u0628\u06cc\u065b\u0644\u062c\u0650\u06cc\u064e\u0645'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'Belsch','lg':'Bubirigi','li':'*aa','ln':'Beleziki','lo':u('\u0ec0\u0e9a\u0ea7\u0ea2\u0ebd\u0ea1'),'lt':'*bs','lu':'Belejiki','lv':u('Be\u013c\u0123ija'),'mg':'Belzika','mh':'*aa','mi':'*aa','mk':u('\u0411\u0435\u043b\u0433\u0438\u0458\u0430'),'ml':u('\u0d2c\u0d46\u0d7d\u0d1c\u0d3f\u0d2f\u0d02'),'mn':'*ce','mo':'*br','mr':'*hi','ms':'*aa','mt':u('il-Bel\u0121ju'),'my':u('\u1018\u101a\u103a\u101c\u103a\u1002\u103b\u102e\u101a\u1019\u103a'),'na':'*aa','nb':'*br','nd':'Bhelgium','ne':'*hi','ng':'*aa','nl':'*af','nn':'*br','no':'*br','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2c\u0b47\u0b32\u0b1c\u0b3f\u0b5f\u0b2e\u0b4d'),'os':'*aa','pa':u('\u0a2c\u0a48\u0a32\u0a1c\u0a40\u0a05\u0a2e'),'pi':'*aa','pl':'*br','ps':u('\u0628\u06cc\u0644\u062c\u06cc\u0645'),'pt':'*es','qu':'*es','rm':'*br','rn':'Ububiligi','ro':'*br','ru':'*kk','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0622\u0633\u067d\u0631\u064a\u0627'),'se':'*br','sg':u('B\u00ealeze, Belez\u00eeki'),'si':u('\u0db6\u0dd9\u0dbd\u0dca\u0da2\u0dd2\u0dba\u0db8'),'sk':'Belgicko','sl':'*bs','sm':'*aa','sn':'Beljium','so':'Biljam','sq':u('Belgjik\u00eb'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*ki','ta':u('\u0baa\u0bc6\u0bb2\u0bcd\u0b9c\u0bbf\u0baf\u0bae\u0bcd'),'te':u('\u0c2c\u0c46\u0c32\u0c4d\u0c1c\u0c3f\u0c2f\u0c02'),'tg':'*bg','th':u('\u0e40\u0e1a\u0e25\u0e40\u0e22\u0e35\u0e22\u0e21'),'ti':'*am','tk':u('Belgi\u00fda'),'tl':'*aa','tn':'*aa','to':'Pelesiume','tr':'*az','ts':'*aa','tt':'*kk','tw':'*aa','ty':'*aa','ug':u('\u0628\u06d0\u0644\u06af\u0649\u064a\u06d5'),'uk':u('\u0411\u0435\u043b\u044c\u0491\u0456\u044f'),'ur':'*ps','uz':'Belgiya','ve':'*aa','vi':u('B\u1ec9'),'vo':'*aa','wa':'*aa','wo':'Belsig','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de B\u00e9g\u00ed\u1ecd\u0301m\u00f9'),'za':'*aa','zh':u('\u6bd4\u5229\u65f6'),'zu':'i-Belgium',},
  'BF': {'aa':'Burkina Faso','ab':'*aa','ae':'*aa','af':'*aa','ak':u('B\u0254kina Faso'),'am':u('\u1261\u122d\u12aa\u1293 \u134b\u1236'),'an':'*aa','ar':u('\u0628\u0648\u0631\u0643\u064a\u0646\u0627 \u0641\u0627\u0633\u0648'),'as':u('\u09ac\u09c1\u09f0\u0995\u09bf\u09a8\u09be \u09ab\u09be\u099a\u09cb'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u0411\u0443\u0440\u043a\u0456\u043d\u0430-\u0424\u0430\u0441\u043e'),'bg':u('\u0411\u0443\u0440\u043a\u0438\u043d\u0430 \u0424\u0430\u0441\u043e'),'bh':'*aa','bi':'*aa','bm':'Burukina Faso','bn':u('\u09ac\u09c1\u09b0\u0995\u09bf\u09a8\u09be \u09ab\u09be\u09b8\u09cb'),'bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':u('\u0411\u0443\u0440\u043a\u0438\u043d\u0430- \u0424\u0430\u0441\u043e'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f56\u0fb7\u0f62\u0f0b\u0f40\u0f72\u0f0b\u0f53\u0f0b \u0f55\u0f7a\u0f0b\u0f66\u0f7c'),'ee':'Burkina Faso nutome','el':u('\u039c\u03c0\u03bf\u03c5\u03c1\u03ba\u03af\u03bd\u03b1 \u03a6\u03ac\u03c3\u03bf'),'en':'*aa','eo':'Burkino','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0628\u0648\u0631\u06a9\u06cc\u0646\u0627\u0641\u0627\u0633\u0648'),'ff':'Burkibaa Faaso','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Buirc\u00edne Fas\u00f3'),'gd':'Buirciona Faso','gl':'*aa','gn':'*aa','gu':u('\u0aac\u0ac1\u0ab0\u0acd\u0a95\u0abf\u0aa8\u0abe \u0aab\u0abe\u0ab8\u0acb'),'gv':'*aa','ha':'*aa','he':u('\u05d1\u05d5\u05e8\u05e7\u05d9\u05e0\u05d4 \u05e4\u05d0\u05e1\u05d5'),'hi':u('\u092c\u0941\u0930\u094d\u0915\u093f\u0928\u093e \u092b\u093c\u093e\u0938\u094b'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u0532\u0578\u0582\u0580\u056f\u056b\u0576\u0561 \u0556\u0561\u057d\u0578'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('B\u00fark\u00edna Fas\u00f3'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30d6\u30eb\u30ad\u30ca\u30d5\u30a1\u30bd'),'ji':u('\u05d1\u05d5\u05e8\u05e7\u05d9\u05e0\u05e2 \u05e4\u05bf\u05d0\u05b7\u05e1\u05d0'),'jv':'*aa','ka':u('\u10d1\u10e3\u10e0\u10d9\u10d8\u10dc\u10d0-\u10e4\u10d0\u10e1\u10dd'),'kg':'*aa','ki':'Bukinafaso','kj':'*aa','kk':u('\u0411\u0443\u0440\u043a\u0438\u043d\u0430-\u0424\u0430\u0441\u043e'),'kl':'*aa','km':u('\u1794\u17bd\u1782\u17b8\u178e\u17b6\u17a0\u17d2\u179c\u17b6\u179f\u17bc'),'kn':u('\u0cac\u0cc1\u0cb0\u0ccd\u0c95\u0cbf\u0ca8\u0cbe \u0cab\u0cbe\u0cb8\u0cca'),'ko':u('\ubd80\ub974\ud0a4\ub098\ud30c\uc18c'),'kr':'*aa','ks':u('\u0628\u064f\u0631\u06a9\u0650\u0646\u0627 \u0641\u06cc\u0633\u0648'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*aa','lg':'*bm','li':'*aa','ln':'Bukina Faso','lo':u('\u0ec0\u0e9a\u0eb5\u0e81\u0eb4\u0e99\u0eb2 \u0e9f\u0eb2\u0ec2\u0e8a'),'lt':'Burkina Fasas','lu':'*ki','lv':'Burkinafaso','mg':'Borkina Faso','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d2c\u0d7c\u0d15\u0d4d\u0d15\u0d3f\u0d28 \u0d2b\u0d3e\u0d38\u0d4b'),'mn':'*bg','mo':'*aa','mr':u('\u092c\u0941\u0930\u094d\u0915\u093f\u0928\u093e \u092b\u093e\u0938\u094b'),'ms':'*aa','mt':'il-Burkina Faso','my':u('\u1018\u102c\u1000\u102e\u1038\u1014\u102c\u1038 \u1016\u102c\u1038\u1006\u102d\u102f'),'na':'*aa','nb':'*aa','nd':'Bhukina Faso','ne':u('\u092c\u0930\u094d\u0915\u093f\u0928\u093e \u092b\u093e\u0938\u094b'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2c\u0b41\u0b30\u0b4d\u0b15\u0b3f\u0b28\u0b3e \u0b2b\u0b3e\u0b38\u0b4b'),'os':'*aa','pa':u('\u0a2c\u0a41\u0a30\u0a15\u0a40\u0a28\u0a3e \u0a2b\u0a3c\u0a3e\u0a38\u0a4b'),'pi':'*aa','pl':'*aa','ps':u('\u0628\u0648\u0631\u06a9\u06cc\u0646\u0627 \u0641\u0627\u0633\u0648'),'pt':'Burquina Faso','qu':'*aa','rm':'*aa','rn':'*bm','ro':'*aa','ru':'*kk','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0628\u0631\u06aa\u064a\u0646\u0627 \u0641\u0627\u0633\u0648'),'se':'*aa','sg':'*aa','si':u('\u0db6\u0dbb\u0dca\u0d9a\u0dd2\u0db1\u0dcf \u0dc6\u0dcf\u0dc3\u0ddd'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*ki','so':'Burkiina Faaso','sq':'Burkina-Faso','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*ki','ta':u('\u0baa\u0bc1\u0bb0\u0bcd\u0b95\u0bbf\u0ba9\u0bbe \u0b83\u0baa\u0bbe\u0bb8\u0bcb'),'te':u('\u0c2c\u0c41\u0c30\u0c4d\u0c15\u0c3f\u0c28\u0c3e \u0c2b\u0c3e\u0c38\u0c4b'),'tg':'*kk','th':u('\u0e1a\u0e39\u0e23\u0e4c\u0e01\u0e34\u0e19\u0e32\u0e1f\u0e32\u0e42\u0e0b'),'ti':'*am','tk':'*sq','tl':'*aa','tn':'*aa','to':'Pekano Faso','tr':'*aa','ts':'*aa','tt':'*kk','tw':'*aa','ty':'*aa','ug':u('\u0628\u06c7\u0631\u0643\u0649\u0646\u0627 \u0641\u0627\u0633\u0648'),'uk':'*be','ur':u('\u0628\u0631\u06a9\u06cc\u0646\u0627 \u0641\u0627\u0633\u0648'),'uz':'*sq','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Burkina Faaso','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de B\u00f9\u00f9k\u00edn\u00e1 Fas\u00f2'),'za':'*aa','zh':u('\u5e03\u57fa\u7eb3\u6cd5\u7d22'),'zu':'i-Burkina Faso',},
  'BG': {'aa':'Bulgaria','ab':'*aa','ae':'*aa','af':'Bulgarye','ak':u('B\u0254lgeria'),'am':u('\u1261\u120d\u130c\u122a\u12eb'),'an':'*aa','ar':u('\u0628\u0644\u063a\u0627\u0631\u064a\u0627'),'as':u('\u09ac\u09c1\u09b2\u0997\u09c7\u09f0\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':u('Bolqar\u0131stan'),'ba':'*aa','be':u('\u0411\u0430\u043b\u0433\u0430\u0440\u044b\u044f'),'bg':u('\u0411\u044a\u043b\u0433\u0430\u0440\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Buligari','bn':u('\u09ac\u09c1\u09b2\u0997\u09c7\u09b0\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'*aa','bs':'Bugarska','ca':u('Bulg\u00e0ria'),'ce':u('\u0411\u043e\u043b\u0433\u0430\u0440\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Bulharsko','cu':'*aa','cv':'*aa','cy':'Bwlgaria','da':'Bulgarien','de':'*da','dv':'*aa','dz':u('\u0f56\u0f74\u0f63\u0f0b\u0f42\u0f0b\u0f62\u0f72\u0f0b\u0f61'),'ee':'Bulgaria nutome','el':u('\u0392\u03bf\u03c5\u03bb\u03b3\u03b1\u03c1\u03af\u03b1'),'en':'*aa','eo':'Bulgarujo','es':'*aa','et':'Bulgaaria','eu':'*aa','fa':u('\u0628\u0644\u063a\u0627\u0631\u0633\u062a\u0627\u0646'),'ff':'Bulgarii','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Bulgarie','fy':'Bulgarije','ga':u('an Bhulg\u00e1ir'),'gd':u('A\u2019 Bhulgair'),'gl':'*aa','gn':'*aa','gu':u('\u0aac\u0ab2\u0acd\u0a97\u0ac7\u0ab0\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Bulgariya','he':u('\u05d1\u05d5\u05dc\u05d2\u05e8\u05d9\u05d4'),'hi':u('\u092c\u0941\u0932\u094d\u0917\u093e\u0930\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Bulg\u00e1ria'),'hy':u('\u0532\u0578\u0582\u056c\u0572\u0561\u0580\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('B\u00falgar\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30d6\u30eb\u30ac\u30ea\u30a2'),'ji':u('\u05d1\u05d5\u05dc\u05d2\u05d0\u05b7\u05e8\u05d9\u05e2'),'jv':'*aa','ka':u('\u10d1\u10e3\u10da\u10d2\u10d0\u10e0\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u0411\u043e\u043b\u0433\u0430\u0440\u0438\u044f'),'kl':'*aa','km':u('\u1794\u17ca\u17bb\u179b\u17a0\u17d2\u1782\u17b6\u179a\u17b8'),'kn':u('\u0cac\u0cb2\u0ccd\u0c97\u0cc7\u0cb0\u0cbf\u0caf\u0cbe'),'ko':u('\ubd88\uac00\ub9ac\uc544'),'kr':'*aa','ks':u('\u0628\u064e\u0644\u062c\u06cc\u0631\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*da','lg':'Bulugariya','li':'*aa','ln':'Biligari','lo':u('\u0e9a\u0eb1\u0e87\u0e81\u0eb2\u0ec0\u0ea3\u0e8d'),'lt':'Bulgarija','lu':'*ln','lv':u('Bulg\u0101rija'),'mg':'Biolgaria','mh':'*aa','mi':'*aa','mk':u('\u0411\u0443\u0433\u0430\u0440\u0438\u0458\u0430'),'ml':u('\u0d2c\u0d7e\u0d17\u0d47\u0d31\u0d3f\u0d2f'),'mn':u('\u0411\u043e\u043b\u0433\u0430\u0440'),'mo':'*aa','mr':u('\u092c\u0932\u094d\u0917\u0947\u0930\u093f\u092f\u093e'),'ms':'*aa','mt':'il-Bulgarija','my':u('\u1018\u1030\u101c\u103a\u1002\u1031\u1038\u101b\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'Bhulgariya','ne':u('\u092c\u0941\u0932\u094d\u0917\u0947\u0930\u093f\u092f\u093e'),'ng':'*aa','nl':'*fy','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2c\u0b41\u0b32\u0b17\u0b47\u0b30\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a2c\u0a41\u0a32\u0a17\u0a3e\u0a30\u0a40\u0a06'),'pi':'*aa','pl':u('Bu\u0142garia'),'ps':u('\u0628\u0644\u063a\u0627\u0631\u06cc\u0647'),'pt':'*hu','qu':'*aa','rm':'*aa','rn':'Buligariya','ro':'*aa','ru':'*kk','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*ar','se':'*hu','sg':u('Bulugar\u00efi'),'si':u('\u0db6\u0dbd\u0dca\u0d9c\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*cs','sl':'Bolgarija','sm':'*aa','sn':'*aa','so':'Bulgaariya','sq':'Bullgari','sr':u('\u0411\u0443\u0433\u0430\u0440\u0441\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':u('\u0baa\u0bb2\u0bcd\u0b95\u0bc7\u0bb0\u0bbf\u0baf\u0bbe'),'te':u('\u0c2c\u0c32\u0c4d\u0c17\u0c47\u0c30\u0c3f\u0c2f\u0c3e'),'tg':u('\u0411\u0443\u043b\u0493\u043e\u0440\u0438\u044f'),'th':u('\u0e1a\u0e31\u0e25\u0e41\u0e01\u0e40\u0e23\u0e35\u0e22'),'ti':'*am','tk':u('Bolgari\u00fda'),'tl':'*aa','tn':'*aa','to':'Pulukalia','tr':'Bulgaristan','ts':'*aa','tt':'*kk','tw':'*aa','ty':'*aa','ug':u('\u0628\u06c7\u0644\u063a\u0627\u0631\u0649\u064a\u06d5'),'uk':u('\u0411\u043e\u043b\u0433\u0430\u0440\u0456\u044f'),'ur':u('\u0628\u0644\u063a\u0627\u0631\u06cc\u06c1'),'uz':'Bolgariya','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Bilgari','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de B\u00f9\u00f9g\u00e1r\u00ed\u00e0'),'za':'*aa','zh':u('\u4fdd\u52a0\u5229\u4e9a'),'zu':'i-Bulgaria',},
  'BH': {'aa':'Bahrain','ab':'*aa','ae':'*aa','af':'Bahrein','ak':'Baren','am':u('\u1263\u1205\u122c\u1295'),'an':'*aa','ar':u('\u0627\u0644\u0628\u062d\u0631\u064a\u0646'),'as':u('\u09ac\u09be\u09b9\u09f0\u09c7\u0987\u09a8'),'av':'*aa','ay':'*aa','az':u('B\u0259hreyn'),'ba':'*aa','be':u('\u0411\u0430\u0445\u0440\u044d\u0439\u043d'),'bg':u('\u0411\u0430\u0445\u0440\u0435\u0439\u043d'),'bh':'*aa','bi':'*aa','bm':'Bareyini','bn':u('\u09ac\u09be\u09b9\u09b0\u09be\u0987\u09a8'),'bo':'*aa','br':'*af','bs':'*af','ca':'*aa','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'Bahrajn','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f56\u0fb7\u0f0b\u0f62\u0f7a\u0f53'),'ee':'Bahrain nutome','el':u('\u039c\u03c0\u03b1\u03c7\u03c1\u03ad\u03b9\u03bd'),'en':'*aa','eo':'Barejno','es':u('Bar\u00e9in'),'et':'*af','eu':'*aa','fa':u('\u0628\u062d\u0631\u06cc\u0646'),'ff':'Bahreyn','fi':'*aa','fj':'*aa','fo':'Barein','fr':u('Bahre\u00efn'),'fy':'*af','ga':u('Bair\u00e9in'),'gd':'Bachrain','gl':'*aa','gn':'*aa','gu':u('\u0aac\u0ac7\u0ab9\u0ab0\u0ac0\u0aa8'),'gv':'*aa','ha':'Baharan','he':u('\u05d1\u05d7\u05e8\u05d9\u05d9\u05df'),'hi':u('\u092c\u0939\u0930\u0940\u0928'),'ho':'*aa','hr':'*af','ht':'*aa','hu':'*af','hy':u('\u0532\u0561\u0570\u0580\u0565\u0575\u0576'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*fo','it':'*af','iu':'*aa','iw':'*he','ja':u('\u30d0\u30fc\u30ec\u30fc\u30f3'),'ji':'*aa','jv':'*aa','ka':u('\u10d1\u10d0\u10f0\u10e0\u10d4\u10d8\u10dc\u10d8'),'kg':'*aa','ki':'Bahareni','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1794\u17b6\u179a\u17c9\u17c2\u1793'),'kn':u('\u0cac\u0cb9\u0ccd\u0cb0\u0cc7\u0ca8\u0ccd'),'ko':u('\ubc14\ub808\uc778'),'kr':'*aa','ks':u('\u0628\u062d\u0631\u06cc\u0656\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'Baareeni','li':'*aa','ln':u('Bahr\u025bn\u025b'),'lo':u('\u0e9a\u0eb2\u0ec0\u0ea3\u0e99'),'lt':'Bahreinas','lu':'Bahrene','lv':'Bahreina','mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0411\u0430\u0445\u0440\u0435\u0438\u043d'),'ml':u('\u0d2c\u0d39\u0d4d\u0d31\u0d3f\u0d7b'),'mn':'*bg','mo':'*aa','mr':u('\u092c\u0939\u093e\u0930\u0940\u0928'),'ms':'*aa','mt':'il-Bahrain','my':u('\u1018\u102c\u101b\u102d\u1014\u103a\u1038'),'na':'*aa','nb':'*aa','nd':'Bhahareni','ne':u('\u092c\u0939\u0930\u093e\u0907\u0928'),'ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2c\u0b3e\u0b39\u0b3e\u0b30\u0b3f\u0b28\u0b4d'),'os':'*aa','pa':u('\u0a2c\u0a39\u0a3f\u0a30\u0a40\u0a28'),'pi':'*aa','pl':'*cs','ps':u('\u0628\u062d\u0631\u064a\u0646'),'pt':'*af','qu':'*es','rm':'*aa','rn':'Bahareyini','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*ps','se':'*aa','sg':u('Bahr\u00e2ina'),'si':u('\u0db6\u0dc4\u0dbb\u0dda\u0db1\u0dca'),'sk':'*cs','sl':'*cs','sm':'*aa','sn':'*ki','so':'Baxreyn','sq':'Bahrejn','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*ki','ta':u('\u0baa\u0bb9\u0bcd\u0bb0\u0bc8\u0ba9\u0bcd'),'te':u('\u0c2c\u0c39\u0c4d\u0c30\u0c46\u0c2f\u0c3f\u0c28\u0c4d'),'tg':u('\u0411\u0430\u04b3\u0440\u0430\u0439\u043d'),'th':u('\u0e1a\u0e32\u0e2b\u0e4c\u0e40\u0e23\u0e19'),'ti':'*am','tk':u('Bahre\u00fdn'),'tl':'*aa','tn':'*aa','to':'Paleini','tr':'*ff','ts':'*aa','tt':u('\u0411\u04d9\u0445\u0440\u04d9\u0439\u043d'),'tw':'*aa','ty':'*aa','ug':u('\u0628\u06d5\u06be\u0631\u06d5\u064a\u0646'),'uk':'*bg','ur':'*fa','uz':'Bahrayn','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Bahreyin','xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de B\u00e1r\u00e1n\u00ec'),'za':'*aa','zh':u('\u5df4\u6797'),'zu':'i-Bahrain',},
  'BI': {'aa':'Burundi','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u1265\u1229\u1295\u12f2'),'an':'*aa','ar':u('\u0628\u0648\u0631\u0648\u0646\u062f\u064a'),'as':u('\u09ac\u09c1\u09f0\u09c1\u09a3\u09cd\u09a1\u09bf'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u0411\u0443\u0440\u0443\u043d\u0434\u0437\u0456'),'bg':u('\u0411\u0443\u0440\u0443\u043d\u0434\u0438'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u09ac\u09c1\u09b0\u09c1\u09a8\u09cd\u09a1\u09bf'),'bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f56\u0fb7\u0f74\u0f0b\u0f62\u0f74\u0f53\u0f0b\u0f4c\u0f72'),'ee':'Burundi nutome','el':u('\u039c\u03c0\u03bf\u03c5\u03c1\u03bf\u03cd\u03bd\u03c4\u03b9'),'en':'*aa','eo':'Burundo','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0628\u0648\u0631\u0648\u0646\u062f\u06cc'),'ff':'Burunndi','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('an Bhur\u00fain'),'gd':'Burundaidh','gl':'*aa','gn':'*aa','gu':u('\u0aac\u0ac1\u0ab0\u0ac1\u0a82\u0aa1\u0ac0'),'gv':'*aa','ha':'*aa','he':u('\u05d1\u05d5\u05e8\u05d5\u05e0\u05d3\u05d9'),'hi':u('\u092c\u0941\u0930\u0941\u0902\u0921\u0940'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u0532\u0578\u0582\u0580\u0578\u0582\u0576\u0564\u056b'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('B\u00far\u00fand\u00ed'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30d6\u30eb\u30f3\u30b8'),'ji':'*he','jv':'*aa','ka':u('\u10d1\u10e3\u10e0\u10e3\u10dc\u10d3\u10d8'),'kg':'*aa','ki':'Mburundi','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1794\u17ca\u17bc\u179a\u17bb\u1793\u178c\u17b8'),'kn':u('\u0cac\u0cc1\u0cb0\u0cc1\u0c82\u0ca1\u0cbf'),'ko':u('\ubd80\ub8ec\ub514'),'kr':'*aa','ks':u('\u0628\u0648\u0631\u064e\u0646\u0688\u0650'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0e9a\u0eb9\u0ea3\u0eb8\u0e99\u0e94\u0eb4'),'lt':'Burundis','lu':'*aa','lv':'Burundija','mg':'Borondi','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d2c\u0d31\u0d41\u0d23\u0d4d\u0d1f\u0d3f'),'mn':'*bg','mo':'*aa','mr':'*hi','ms':'*aa','mt':'il-Burundi','my':u('\u1018\u1030\u101b\u103d\u1014\u103a\u1012\u102e'),'na':'*aa','nb':'*aa','nd':'Bhurundi','ne':u('\u092c\u0941\u0930\u0942\u0923\u094d\u0921\u0940'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2c\u0b41\u0b30\u0b41\u0b23\u0b4d\u0b21\u0b3f'),'os':'*aa','pa':u('\u0a2c\u0a41\u0a30\u0a41\u0a70\u0a21\u0a40'),'pi':'*aa','pl':'*aa','ps':u('\u0628\u0631\u0648\u0646\u062f\u064a'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'Uburundi','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0628\u0631\u0648\u0646\u068a\u064a'),'se':'*aa','sg':u('Burund\u00efi'),'si':u('\u0db6\u0dd4\u0dbb\u0dd4\u0db1\u0dca\u0daf\u0dd2'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0baa\u0bc1\u0bb0\u0bc1\u0ba3\u0bcd\u0b9f\u0bbf'),'te':u('\u0c2c\u0c41\u0c30\u0c41\u0c02\u0c21\u0c3f'),'tg':'*bg','th':u('\u0e1a\u0e38\u0e23\u0e38\u0e19\u0e14\u0e35'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':'Puluniti','tr':'*aa','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0628\u06c7\u0631\u06c7\u0646\u062f\u0649'),'uk':u('\u0411\u0443\u0440\u0443\u043d\u0434\u0456'),'ur':u('\u0628\u0631\u0648\u0646\u0688\u06cc'),'uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*he','yo':u('Or\u00edl\u1eb9\u0301\u00e8de B\u00f9\u00f9r\u00fand\u00ec'),'za':'*aa','zh':u('\u5e03\u9686\u8fea'),'zu':'i-Burundi',},
  'BJ': {'aa':'Benin','ab':'*aa','ae':'*aa','af':'*aa','ak':u('B\u025bnin'),'am':u('\u1264\u1292\u1295'),'an':'*aa','ar':u('\u0628\u0646\u064a\u0646'),'as':u('\u09ac\u09c7\u09a8\u09bf\u09a8'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u0411\u0435\u043d\u0456\u043d'),'bg':u('\u0411\u0435\u043d\u0438\u043d'),'bh':'*aa','bi':'*aa','bm':u('Ben\u025bn'),'bn':'*as','bo':'*aa','br':'*aa','bs':'*aa','ca':u('Ben\u00edn'),'ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f56\u0fb7\u0f7a\u0f0b\u0f53\u0f72\u0f53'),'ee':'Benin nutome','el':u('\u039c\u03c0\u03b5\u03bd\u03af\u03bd'),'en':'*aa','eo':'Benino','es':'*ca','et':'*aa','eu':'*aa','fa':u('\u0628\u0646\u06cc\u0646'),'ff':'Benee','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('B\u00e9nin'),'fy':'*aa','ga':'Beinin','gd':'*ga','gl':'*aa','gn':'*aa','gu':u('\u0aac\u0ac7\u0aa8\u0abf\u0aa8'),'gv':'*aa','ha':'Binin','he':u('\u05d1\u05e0\u05d9\u05df'),'hi':u('\u092c\u0947\u0928\u093f\u0928'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u0532\u0565\u0576\u056b\u0576'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*ha','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*ca','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30d9\u30ca\u30f3'),'ji':u('\u05d1\u05e2\u05e0\u05d9\u05df'),'jv':'*aa','ka':u('\u10d1\u10d4\u10dc\u10d8\u10dc\u10d8'),'kg':'*aa','ki':'Benini','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1794\u17c1\u178e\u17b6\u17c6\u1784'),'kn':u('\u0cac\u0cc6\u0ca8\u0cbf\u0ca8\u0ccd'),'ko':u('\ubca0\ub0c9'),'kr':'*aa','ks':u('\u0628\u0650\u0646\u0650\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'*ki','li':'*aa','ln':u('Ben\u025b'),'lo':u('\u0ec0\u0e9a\u0e99\u0eb4\u0e99'),'lt':'Beninas','lu':'Bene','lv':'Benina','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d2c\u0d46\u0d28\u0d3f\u0d7b'),'mn':'*bg','mo':'*aa','mr':'*hi','ms':'*aa','mt':'il-Benin','my':u('\u1018\u102e\u1014\u1004\u103a'),'na':'*aa','nb':'*aa','nd':'Bhenini','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2c\u0b47\u0b28\u0b3f\u0b28\u0b4d'),'os':'*aa','pa':u('\u0a2c\u0a47\u0a28\u0a3f\u0a28'),'pi':'*aa','pl':'*aa','ps':u('\u0628\u06cc\u0646\u0646'),'pt':'*aa','qu':'*ca','rm':'*aa','rn':'*lu','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0628\u064a\u0646\u0646'),'se':'*aa','sg':u('Ben\u00eben'),'si':u('\u0db6\u0dd9\u0db1\u0dd2\u0db1\u0dca'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*ki','so':'Biniin','sq':'*aa','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0baa\u0bc6\u0ba9\u0bbf\u0ba9\u0bcd'),'te':u('\u0c2c\u0c46\u0c28\u0c3f\u0c28\u0c4d'),'tg':'*bg','th':u('\u0e40\u0e1a\u0e19\u0e34\u0e19'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':'Penini','tr':'*aa','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0628\u06d0\u0646\u0649\u0646'),'uk':'*be','ur':'*ps','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*ff','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de B\u1eb9\u0300n\u1eb9\u0300'),'za':'*aa','zh':u('\u8d1d\u5b81'),'zu':'i-Benin',},
  'BL': {'aa':u('Saint Barth\u00e9lemy'),'ab':'*aa','ae':'*aa','af':u('Sint Barth\u00e9lemy'),'ak':'*aa','am':u('\u1245\u12f1\u1235 \u1260\u122d\u1274\u120e\u121c'),'an':'*aa','ar':u('\u0633\u0627\u0646 \u0628\u0627\u0631\u062a\u0644\u064a\u0645\u064a'),'as':u('\u099b\u09c7\u0987\u09a3\u09cd\u099f \u09ac\u09be\u09f0\u09cd\u09a5\u09b2\u09c7\u09ae\u09c7'),'av':'*aa','ay':'*aa','az':'Sent-Bartelemi','ba':'*aa','be':u('\u0421\u0435\u043d-\u0411\u0430\u0440\u0442\u044d\u043b\u044c\u043c\u0456'),'bg':u('\u0421\u0435\u043d \u0411\u0430\u0440\u0442\u0435\u043b\u0435\u043c\u0438'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u09b8\u09c7\u09a8\u09cd\u099f \u09ac\u09be\u09b0\u09a5\u09c7\u09b2\u09bf\u09ae\u09bf'),'bo':'*aa','br':'*aa','bs':'Sveti Bartolomej','ca':'*aa','ce':u('\u0421\u0435\u043d-\u0411\u0430\u0440\u0442\u0435\u043b\u044c\u043c\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Svat\u00fd Bartolom\u011bj'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':u('St. Barth\u00e9lemy'),'dv':'*aa','dz':u('\u0f66\u0f7a\u0f53\u0f4a\u0f0b \u0f56\u0f62\u0f0b\u0f50\u0f7c\u0f0b\u0f63\u0f7c\u0f58\u0f0b\u0f58\u0f72\u0f60\u0f74'),'ee':u('Saint Barth\u00e9lemy nutome'),'el':u('\u0386\u03b3\u03b9\u03bf\u03c2 \u0392\u03b1\u03c1\u03b8\u03bf\u03bb\u03bf\u03bc\u03b1\u03af\u03bf\u03c2'),'en':'*de','eo':'*aa','es':u('San Bartolom\u00e9'),'et':u('Saint-Barth\u00e9lemy'),'eu':'*aa','fa':u('\u0633\u0646 \u0628\u0627\u0631\u062a\u0644\u0645\u06cc'),'ff':'*aa','fi':'*et','fj':'*aa','fo':'*de','fr':'*et','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*et','gn':'*aa','gu':u('\u0ab8\u0ac7\u0a82\u0a9f \u0aac\u0abe\u0ab0\u0acd\u0aa5\u0ac7\u0ab2\u0ac7\u0aae\u0ac0'),'gv':'*aa','ha':'*aa','he':u('\u05e1\u05e0\u05d8 \u05d1\u05e8\u05ea\u05d5\u05dc\u05d5\u05de\u05d9\u05d0\u05d5'),'hi':u('\u0938\u0947\u0902\u091f \u092c\u093e\u0930\u094d\u0925\u0947\u0932\u0947\u092e\u0940'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*et','hy':u('\u054d\u0578\u0582\u0580\u0562 \u0532\u0561\u0580\u0564\u0578\u0582\u0572\u056b\u0574\u0565\u0578\u057d'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Sankti Bart\u00f3l\u00f3meusareyjar'),'it':'*et','iu':'*aa','iw':'*he','ja':u('\u30b5\u30f3\u30fb\u30d0\u30eb\u30c6\u30eb\u30df\u30fc'),'ji':'*aa','jv':'*aa','ka':u('\u10e1\u10d4\u10dc-\u10d1\u10d0\u10e0\u10d7\u10d4\u10da\u10db\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u0421\u0435\u043d-\u0411\u0430\u0440\u0442\u0435\u043b\u0435\u043c\u0438'),'kl':'*aa','km':u('\u179f\u17b6\u17c6\u1784\u200b\u1794\u17b6\u1790\u17c1\u17a1\u17c1\u1798\u17b8'),'kn':u('\u0cb8\u0cc7\u0c82\u0c9f\u0ccd \u0cac\u0cbe\u0cb0\u0ccd\u0ca5\u0cc6\u0cb2\u0cc6\u0cae\u0cbf'),'ko':u('\uc0dd\ubc14\ub974\ud154\ub808\ubbf8'),'kr':'*aa','ks':u('\u0633\u06cc\u0646\u065b\u0679 \u0628\u0627\u0631\u062a\u064e\u06be\u06cc\u0644\u0645\u06cc'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0421\u0435\u043d\u0442 \u0411\u0430\u0440\u0442\u0435\u043b\u0435\u043c\u0438'),'la':'*aa','lb':'*et','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0ec0\u0e8a\u0e99 \u0e9a\u0eb2\u0ec0\u0e97\u0ec0\u0ea5\u0ea1\u0eb5'),'lt':'Sen Bartelemi','lu':'*aa','lv':u('Senbartelm\u012b'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0421\u0432\u0435\u0442\u0438 \u0412\u0430\u0440\u0442\u043e\u043b\u043e\u043c\u0435\u0458'),'ml':u('\u0d38\u0d46\u0d28\u0d4d\u0d31\u0d4d \u0d2c\u0d3e\u0d7c\u0d24\u0d4d\u0d24\u0d32\u0d2e\u0d3f'),'mn':u('\u0421\u0435\u043d\u0442-\u0411\u0430\u0440\u0442\u0435\u043b\u044c\u043c\u0438'),'mo':'*et','mr':'*hi','ms':'*aa','mt':'*aa','my':u('\u1005\u102d\u1014\u1037\u103a\u1018\u102c\u101e\u101a\u103a\u101c\u103a\u1019\u102e'),'na':'*aa','nb':'*et','nd':'*aa','ne':u('\u0938\u0947\u0928\u094d\u091f \u092c\u093e\u0930\u094d\u0925\u093e\u0932\u0947\u092e\u0940'),'ng':'*aa','nl':'*et','nn':'*aa','no':'*et','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b2c\u0b3e\u0b30\u0b4d\u0b25\u0b47\u0b32\u0b47\u0b2e\u0b3f'),'os':'*aa','pa':u('\u0a38\u0a47\u0a02\u0a1f \u0a2c\u0a3e\u0a30\u0a25\u0a47\u0a32\u0a47\u0a2e\u0a40'),'pi':'*aa','pl':'*et','ps':u('\u0633\u06cc\u0646\u067c \u0628\u0627\u0631\u067c\u06cc\u0644\u06cc\u067c\u06cc'),'pt':u('S\u00e3o Bartolomeu'),'qu':'*aa','rm':u('Son Barth\u00e9lemy'),'rn':'*aa','ro':'*et','ru':'*kk','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u06cc\u0646\u067d \u0628\u0631\u067f\u0644\u06cc\u0645\u06cc'),'se':'*aa','sg':'*aa','si':u('\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0db6\u0dbb\u0dca\u0dad\u0dbd\u0dd9\u0db8\u0dd2'),'sk':u('Sv\u00e4t\u00fd Bartolomej'),'sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':u('Sh\u00ebn-Bartolome'),'sr':u('\u0421\u0432\u0435\u0442\u0438 \u0411\u0430\u0440\u0442\u043e\u043b\u043e\u043c\u0435\u0458'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('S:t Barth\u00e9lemy'),'sw':'St. Barthelemy','ta':u('\u0b9a\u0bc6\u0baf\u0bbf\u0ba9\u0bcd\u0b9f\u0bcd \u0baa\u0bbe\u0bb0\u0bcd\u0ba4\u0bc7\u0bb2\u0bc6\u0bae\u0bbf'),'te':u('\u0c38\u0c46\u0c2f\u0c3f\u0c02\u0c1f\u0c4d \u0c2c\u0c30\u0c4d\u0c24\u0c47\u0c32\u0c46\u0c2e\u0c40'),'tg':u('\u0421\u0435\u043d\u0442-\u0411\u0430\u0440\u0442\u0435\u043b\u043c\u0438'),'th':u('\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e1a\u0e32\u0e23\u0e4c\u0e40\u0e18\u0e40\u0e25\u0e21\u0e35'),'ti':u('\u1245\u12f1\u1235 \u1263\u122d\u1270\u1208\u121a\u12ed'),'tk':'Sen-Bartelemi','tl':'*de','tn':'*aa','to':u('S\u0101 Pat\u0113lemi'),'tr':'Saint Barthelemy','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u0633\u0627\u064a\u0646\u062a \u0628\u0627\u0631\u062a\u06d0\u0644\u06d0\u0645\u0649'),'uk':u('\u0421\u0435\u043d-\u0411\u0430\u0440\u0442\u0435\u043b\u044c\u043c\u0456'),'ur':u('\u0633\u06cc\u0646\u0679 \u0628\u0631\u062a\u06be\u0644\u06cc\u0645\u06cc'),'uz':'*tk','ve':'*aa','vi':'*de','vo':'*aa','wa':'*aa','wo':u('Sa\u014b Bartalemi'),'xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5723\u5df4\u6cf0\u52d2\u7c73'),'zu':u('i-Saint Barth\u00e9lemy'),},
  'BM': {'aa':'Bermuda','ab':'*aa','ae':'*aa','af':'*aa','ak':u('B\u025bmuda'),'am':u('\u1264\u122d\u1219\u12f3'),'an':'*aa','ar':u('\u0628\u0631\u0645\u0648\u062f\u0627'),'as':u('\u09ac\u09be\u09f0\u09cd\u09ae\u09c1\u09a1\u09be'),'av':'*aa','ay':'*aa','az':u('Bermud adalar\u0131'),'ba':'*aa','be':u('\u0411\u0435\u0440\u043c\u0443\u0434\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b'),'bg':u('\u0411\u0435\u0440\u043c\u0443\u0434\u0441\u043a\u0438 \u043e\u0441\u0442\u0440\u043e\u0432\u0438'),'bh':'*aa','bi':'*aa','bm':'Bermudi','bn':u('\u09ac\u09be\u09b0\u09ae\u09c1\u09a1\u09be'),'bo':'*aa','br':'*aa','bs':'*aa','ca':'Bermudes','ce':u('\u0411\u0435\u0440\u043c\u0443\u0434\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Bermudy','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f56\u0f62\u0f0b\u0f58\u0f74\u0f0b\u0f4c'),'ee':'Bermuda nutome','el':u('\u0392\u03b5\u03c1\u03bc\u03bf\u03cd\u03b4\u03b5\u03c2'),'en':'*aa','eo':'Bermudoj','es':'Bermudas','et':'*aa','eu':'*aa','fa':'*ar','ff':'Bermudaa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*ca','fy':'*aa','ga':u('Beirmi\u00fada'),'gd':u('Bearm\u00f9da'),'gl':'*es','gn':'*aa','gu':u('\u0aac\u0ab0\u0acd\u0aae\u0ac1\u0aa1\u0abe'),'gv':'*aa','ha':'Barmuda','he':u('\u05d1\u05e8\u05de\u05d5\u05d3\u05d4'),'hi':u('\u092c\u0930\u092e\u0942\u0921\u093e'),'ho':'*aa','hr':'*bm','ht':'*aa','hu':'*aa','hy':u('\u0532\u0565\u0580\u0574\u0578\u0582\u0564\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'Bemuda','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Berm\u00fadaeyjar'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30d0\u30df\u30e5\u30fc\u30c0'),'ji':u('\u05d1\u05e2\u05e8\u05de\u05d5\u05d3\u05e2'),'jv':'*aa','ka':u('\u10d1\u10d4\u10e0\u10db\u10e3\u10d3\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u0411\u0435\u0440\u043c\u0443\u0434 \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'kl':'*aa','km':u('\u1794\u17ca\u17ba\u1798\u17bb\u1799\u178a\u17b6'),'kn':u('\u0cac\u0cb0\u0ccd\u0cae\u0cc1\u0ca1\u0cbe'),'ko':u('\ubc84\ubba4\ub2e4'),'kr':'*aa','ks':u('\u0628\u0654\u0631\u0645\u06cc\u0648\u0688\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*aa','lg':'Beremuda','li':'*aa','ln':'*aa','lo':u('\u0ec0\u0e9a\u0eb5\u0ea1\u0eb4\u0ea7\u0e94\u0eb2'),'lt':'*aa','lu':'*aa','lv':'Bermudu salas','mg':'Bermioda','mh':'*aa','mi':'*aa','mk':u('\u0411\u0435\u0440\u043c\u0443\u0434\u0438'),'ml':u('\u0d2c\u0d7c\u0d2e\u0d41\u0d21'),'mn':u('\u0411\u0435\u0440\u043c\u0443\u0434\u0430'),'mo':'*aa','mr':u('\u092c\u0930\u094d\u092e\u0941\u0921\u093e'),'ms':'*aa','mt':'*aa','my':u('\u1018\u102c\u1019\u103c\u1030\u1012\u102b'),'na':'*aa','nb':'*aa','nd':'Bhemuda','ne':'*mr','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2c\u0b30\u0b4d\u0b2e\u0b41\u0b21\u0b3e'),'os':'*aa','pa':u('\u0a2c\u0a30\u0a2e\u0a42\u0a21\u0a3e'),'pi':'*aa','pl':'*cs','ps':'*ar','pt':'*es','qu':'*aa','rm':'*es','rn':'Berimuda','ro':'*aa','ru':u('\u0411\u0435\u0440\u043c\u0443\u0434\u0441\u043a\u0438\u0435 \u043e-\u0432\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*ar','se':'*aa','sg':u('Berem\u00fbda'),'si':u('\u0db6\u0dbb\u0dca\u0db8\u0dd2\u0dba\u0dd4\u0da9\u0dcf'),'sk':'*cs','sl':'*bm','sm':'*aa','sn':'*aa','so':'Bermuuda','sq':u('Bermud\u00eb'),'sr':'*mn','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0baa\u0bc6\u0bb0\u0bcd\u0bae\u0bc1\u0b9f\u0bbe'),'te':u('\u0c2c\u0c46\u0c30\u0c4d\u0c2e\u0c41\u0c21\u0c3e'),'tg':'*mn','th':u('\u0e40\u0e1a\u0e2d\u0e23\u0e4c\u0e21\u0e34\u0e27\u0e14\u0e32'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':u('P\u0113muta'),'tr':'*aa','ts':'*aa','tt':u('\u0411\u0435\u0440\u043c\u0443\u0434 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0628\u06d0\u0631\u0645\u06c7\u062f\u0627'),'uk':u('\u0411\u0435\u0440\u043c\u0443\u0434\u0441\u044c\u043a\u0456 \u043e\u0441\u0442\u0440\u043e\u0432\u0438'),'ur':'*ar','uz':'Bermuda orollari','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Bermid','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de B\u00e9m\u00fad\u00e0'),'za':'*aa','zh':u('\u767e\u6155\u5927'),'zu':'i-Bermuda',},
  'BN': {'aa':'Brunei','ab':'*aa','ae':'*aa','af':'Broenei','ak':'Brunae','am':u('\u1265\u1229\u1292'),'an':'*aa','ar':u('\u0628\u0631\u0648\u0646\u0627\u064a'),'as':u('\u09ac\u09cd\u09f0\u09c1\u09a8\u09c7\u0987'),'av':'*aa','ay':'*aa','az':'Bruney','ba':'*aa','be':u('\u0411\u0440\u0443\u043d\u0435\u0439'),'bg':u('\u0411\u0440\u0443\u043d\u0435\u0439 \u0414\u0430\u0440\u0443\u0441\u0441\u0430\u043b\u0430\u043c'),'bh':'*aa','bi':'*aa','bm':u('Burin\u025byi'),'bn':u('\u09ac\u09cd\u09b0\u09c1\u09a8\u09c7\u0987'),'bo':'*aa','br':'*aa','bs':'Brunej','ca':'*aa','ce':u('\u0411\u0440\u0443\u043d\u0435\u0439-\u0414\u0430\u0440\u0443\u0441\u0441\u0430\u043b\u0430\u043c'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*bs','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Brunei Darussalam','dv':'*aa','dz':u('\u0f56\u0fb7\u0fb2\u0f74\u0f0b\u0f53\u0f60\u0f72'),'ee':'Brunei nutome','el':u('\u039c\u03c0\u03c1\u03bf\u03c5\u03bd\u03ad\u03b9'),'en':'*aa','eo':'Brunejo','es':u('Brun\u00e9i'),'et':'*aa','eu':'*aa','fa':u('\u0628\u0631\u0648\u0646\u0626\u06cc'),'ff':'Burnaay','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Brun\u00e9i Darussalam'),'fy':'*aa','ga':u('Br\u00fain\u00e9'),'gd':u('Br\u00f9naigh'),'gl':'*aa','gn':'*aa','gu':u('\u0aac\u0acd\u0ab0\u0ac1\u0aa8\u0ac7\u0a87'),'gv':'*aa','ha':'Burune','he':u('\u05d1\u05e8\u05d5\u05e0\u05d9\u05d9'),'hi':u('\u092c\u094d\u0930\u0942\u0928\u0947\u0908'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u0532\u0580\u0578\u0582\u0576\u0565\u0575'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Br\u00fanei'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30d6\u30eb\u30cd\u30a4'),'ji':'*he','jv':'*aa','ka':u('\u10d1\u10e0\u10e3\u10dc\u10d4\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u1796\u17d2\u179a\u17bb\u1799\u178e\u17c1'),'kn':u('\u0cac\u0ccd\u0cb0\u0cc2\u0ca8\u0cbf'),'ko':u('\ube0c\ub8e8\ub098\uc774'),'kr':'*aa','ks':u('\u0628\u064f\u0631\u0646\u0654\u06d2'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*aa','lg':'Burunayi','li':'*aa','ln':'Brineyi','lo':u('\u0e9a\u0ea3\u0eb9\u0ec4\u0e99'),'lt':u('Brun\u0117jus'),'lu':'*ln','lv':'Bruneja','mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0411\u0440\u0443\u043d\u0435\u0458'),'ml':u('\u0d2c\u0d4d\u0d30\u0d42\u0d23\u0d48'),'mn':'*be','mo':'*aa','mr':u('\u092c\u094d\u0930\u0941\u0928\u0947\u0908'),'ms':'*aa','mt':'il-Brunei','my':u('\u1018\u101b\u1030\u1014\u102d\u102f\u1004\u103a\u1038'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u092c\u094d\u0930\u0941\u0928\u093e\u0907'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2c\u0b4d\u0b30\u0b41\u0b28\u0b47\u0b07'),'os':'*aa','pa':u('\u0a2c\u0a30\u0a42\u0a28\u0a47\u0a08'),'pi':'*aa','pl':'*aa','ps':u('\u0628\u0631\u0648\u0646\u064a'),'pt':'*aa','qu':'*es','rm':'*aa','rn':'Buruneyi','ro':'*aa','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0628\u0631\u0648\u0646\u0627\u0626\u064a'),'se':'*aa','sg':u('Brun\u00eai'),'si':u('\u0db6\u0df2\u0db1\u0dcf\u0dba\u0dd2'),'sk':'*bs','sl':'*bs','sm':'*aa','sn':'Burunei','so':'Buruneeya','sq':'*aa','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0baa\u0bc1\u0bb0\u0bc1\u0ba9\u0bc7'),'te':u('\u0c2c\u0c4d\u0c30\u0c42\u0c28\u0c47'),'tg':'*be','th':u('\u0e1a\u0e23\u0e39\u0e44\u0e19'),'ti':'*am','tk':u('Brune\u00fd'),'tl':'*aa','tn':'*aa','to':'Pulunei','tr':'*aa','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u0628\u0649\u0631\u06c7\u0646\u06d0\u064a'),'uk':'*be','ur':u('\u0628\u0631\u0648\u0646\u0627\u0626\u06cc'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Burney','xh':'*aa','yi':'*he','yo':u('Or\u00edl\u1eb9\u0301\u00e8de B\u00far\u00fan\u1eb9\u0301l\u00ec'),'za':'*aa','zh':u('\u6587\u83b1'),'zu':'i-Brunei',},
  'BO': {'aa':'Bolivia','ab':'*aa','ae':'*aa','af':u('Bolivi\u00eb'),'ak':'*aa','am':u('\u1266\u120a\u126a\u12eb'),'an':'*aa','ar':u('\u0628\u0648\u0644\u064a\u0641\u064a\u0627'),'as':u('\u09ac\u09b2\u09bf\u09ad\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Boliviya','ba':'*aa','be':u('\u0411\u0430\u043b\u0456\u0432\u0456\u044f'),'bg':u('\u0411\u043e\u043b\u0438\u0432\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Bolivi','bn':'*as','bo':'*aa','br':'*aa','bs':'Bolivija','ca':u('Bol\u00edvia'),'ce':u('\u0411\u043e\u043b\u0438\u0432\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Bol\u00edvie'),'cu':'*aa','cv':'*aa','cy':'Bolifia','da':'*aa','de':'Bolivien','dv':'*aa','dz':u('\u0f56\u0fb7\u0f7a\u0f0b\u0f63\u0f72\u0f0b\u0f56\u0f72\u0f0b\u0f61'),'ee':'Bolivia nutome','el':u('\u0392\u03bf\u03bb\u03b9\u03b2\u03af\u03b1'),'en':'*aa','eo':'Bolivio','es':'*aa','et':'Boliivia','eu':'*aa','fa':u('\u0628\u0648\u0644\u06cc\u0648\u06cc'),'ff':'Boliwii','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Bolivie','fy':'*aa','ga':'an Bholaiv','gd':'Boilibhia','gl':'*aa','gn':'*aa','gu':u('\u0aac\u0acb\u0ab2\u0abf\u0ab5\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Bolibiya','he':u('\u05d1\u05d5\u05dc\u05d9\u05d1\u05d9\u05d4'),'hi':u('\u092c\u094b\u0932\u0940\u0935\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*ca','hy':u('\u0532\u0578\u056c\u056b\u057e\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('B\u00f3liv\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30dc\u30ea\u30d3\u30a2'),'ji':u('\u05d1\u05d0\u05dc\u05d9\u05d5\u05d5\u05d9\u05e2'),'jv':'*aa','ka':u('\u10d1\u10dd\u10da\u10d8\u10d5\u10d8\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1794\u17bc\u179b\u17b8\u179c\u17b8'),'kn':u('\u0cac\u0cca\u0cb2\u0cbf\u0cb5\u0cbf\u0caf\u0cbe'),'ko':u('\ubcfc\ub9ac\ube44\uc544'),'kr':'*aa','ks':u('\u0628\u0648\u0644\u0650\u0648\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*de','lg':'*az','li':'*aa','ln':'*bm','lo':u('\u0ec2\u0e9a\u0ea5\u0eb4\u0ec0\u0ea7\u0e8d'),'lt':'*bs','lu':'Mbolivi','lv':u('Bol\u012bvija'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0411\u043e\u043b\u0438\u0432\u0438\u0458\u0430'),'ml':u('\u0d2c\u0d4a\u0d33\u0d40\u0d35\u0d3f\u0d2f'),'mn':'*ce','mo':'*aa','mr':u('\u092c\u094b\u0932\u093f\u0935\u094d\u0939\u093f\u092f\u093e'),'ms':'*aa','mt':'il-Bolivja','my':u('\u1018\u102d\u102f\u101c\u102e\u1038\u1017\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'Bholiviya','ne':u('\u092c\u094b\u0932\u093f\u092d\u093f\u092f\u093e'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2c\u0b4b\u0b32\u0b2d\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a2c\u0a4b\u0a32\u0a40\u0a35\u0a40\u0a06'),'pi':'*aa','pl':'Boliwia','ps':u('\u0628\u0648\u0644\u06cc\u0648\u06cc\u0627'),'pt':'*ca','qu':'*aa','rm':'*aa','rn':'*az','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0628\u0648\u0644\u064a\u0648\u064a\u0627'),'se':'*aa','sg':u('Boliv\u00efi'),'si':u('\u0db6\u0ddc\u0dbd\u0dd3\u0dc0\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*ca','sl':'*bs','sm':'*aa','sn':'*aa','so':'Boliifiya','sq':'*bm','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0baa\u0bca\u0bb2\u0bbf\u0bb5\u0bbf\u0baf\u0bbe'),'te':u('\u0c2c\u0c4a\u0c32\u0c40\u0c35\u0c3f\u0c2f\u0c3e'),'tg':'*bg','th':u('\u0e42\u0e1a\u0e25\u0e34\u0e40\u0e27\u0e35\u0e22'),'ti':'*am','tk':u('Boliwi\u00fda'),'tl':'*aa','tn':'*aa','to':u('Pol\u012bvia'),'tr':'Bolivya','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0628\u0648\u0644\u0649\u06cb\u0649\u064a\u06d5'),'uk':u('\u0411\u043e\u043b\u0456\u0432\u0456\u044f'),'ur':'*ps','uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Boliwi','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de B\u1ecd\u0300l\u00edf\u00edy\u00e0'),'za':'*aa','zh':u('\u73bb\u5229\u7ef4\u4e9a'),'zu':'i-Bolivia',},
  'BQ': {'aa':'Bonaire, Sint Eustatius and Saba','ab':'*aa','ae':'*aa','af':'Karibiese Nederland','ak':'*aa','am':u('\u12e8\u12ab\u122a\u1262\u12eb\u1295 \u1294\u12d8\u122d\u120b\u1295\u12f5\u1235'),'an':'*aa','ar':u('\u0647\u0648\u0644\u0646\u062f\u0627 \u0627\u0644\u0643\u0627\u0631\u064a\u0628\u064a\u0629'),'as':u('\u0995\u09c7\u09f0\u09bf\u09ac\u09bf\u09af\u09bc\u09be\u09a8 \u09a8\u09c7\u09a6\u09be\u09f0\u09b2\u09c7\u09a3\u09cd\u09a1\u099b'),'av':'*aa','ay':'*aa','az':u('Karib Niderland\u0131'),'ba':'*aa','be':u('\u041a\u0430\u0440\u044b\u0431\u0441\u043a\u0456\u044f \u041d\u0456\u0434\u044d\u0440\u043b\u0430\u043d\u0434\u044b'),'bg':u('\u041a\u0430\u0440\u0438\u0431\u0441\u043a\u0430 \u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u0995\u09cd\u09af\u09be\u09b0\u09bf\u09ac\u09bf\u09af\u09bc\u09be\u09a8 \u09a8\u09c7\u09a6\u09be\u09b0\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1\u09b8'),'bo':'*aa','br':'Karib Nederlandat','bs':'Karipska Holandija','ca':u('Carib Neerland\u00e8s'),'ce':u('\u0411\u043e\u043d\u044d\u0439\u0440, \u0421\u0438\u043d\u0442-\u042d\u0441\u0442\u0430\u0442\u0438\u0443\u0441 \u0430, \u0421\u0430\u0431\u0430 \u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Karibsk\u00e9 Nizozemsko'),'cu':'*aa','cv':'*aa','cy':'Antilles yr Iseldiroedd','da':'De tidligere Nederlandske Antiller','de':'Bonaire, Sint Eustatius und Saba','dv':'*aa','dz':u('\u0f40\u0f7a\u0f0b\u0f62\u0f72\u0f0b\u0f56\u0f72\u0f0b\u0f61\u0f7a\u0f53\u0f0b\u0f53\u0f7a\u0f0b\u0f51\u0f62\u0f0b\u0f63\u0f53\u0f4c\u0f66\u0f84'),'ee':'*aa','el':u('\u039f\u03bb\u03bb\u03b1\u03bd\u03b4\u03af\u03b1 \u039a\u03b1\u03c1\u03b1\u03ca\u03b2\u03b9\u03ba\u03ae\u03c2'),'en':'Caribbean Netherlands','eo':'*aa','es':u('Caribe neerland\u00e9s'),'et':'Hollandi Kariibi mere saared','eu':'Karibeko Herbehereak','fa':u('\u062c\u0632\u0627\u06cc\u0631 \u06a9\u0627\u0631\u0627\u0626\u06cc\u0628 \u0647\u0644\u0646\u062f'),'ff':'*aa','fi':'Karibian Alankomaat','fj':'*aa','fo':u('Ni\u00f0urlonds Karibia'),'fr':u('Pays-Bas carib\u00e9ens'),'fy':u('Karibysk Nederl\u00e2n'),'ga':u('an \u00cdsilt\u00edr Chairibeach'),'gd':u('Na T\u00ecrean \u00ccsle Caraibeach'),'gl':u('Caribe Neerland\u00e9s'),'gn':'*aa','gu':u('\u0a95\u0ac7\u0ab0\u0ac7\u0aac\u0abf\u0aaf\u0aa8 \u0aa8\u0ac7\u0aa7\u0ab0\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0a9d'),'gv':'*aa','ha':'*aa','he':u('\u05d4\u05d0\u05d9\u05d9\u05dd \u05d4\u05e7\u05e8\u05d9\u05d1\u05d9\u05d9\u05dd \u05d4\u05d4\u05d5\u05dc\u05e0\u05d3\u05d9\u05d9\u05dd'),'hi':u('\u0915\u0948\u0930\u093f\u092c\u093f\u092f\u0928 \u0928\u0940\u0926\u0930\u0932\u0948\u0902\u0921'),'ho':'*aa','hr':'Karipski otoci Nizozemske','ht':'*aa','hu':u('Holland Karib-t\u00e9rs\u00e9g'),'hy':u('\u053f\u0561\u0580\u056b\u0562\u0575\u0561\u0576 \u0546\u056b\u0564\u0565\u057c\u056c\u0561\u0576\u0564\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'Belanda Karibia','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Kar\u00edbahafshluti Hollands'),'it':'Caraibi olandesi','iu':'*aa','iw':'*he','ja':u('\u30aa\u30e9\u30f3\u30c0\u9818\u30ab\u30ea\u30d6'),'ji':'*aa','jv':'*aa','ka':u('\u10d9\u10d0\u10e0\u10d8\u10d1\u10d8\u10e1 \u10dc\u10d8\u10d3\u10d4\u10e0\u10da\u10d0\u10dc\u10d3\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u0411\u043e\u043d\u044d\u0439\u0440, \u0421\u0438\u043d\u0442-\u042d\u0441\u0442\u0430\u0442\u0438\u0443\u0441 \u0436\u04d9\u043d\u0435 \u0421\u0430\u0431\u0430'),'kl':'*aa','km':u('\u17a0\u17bc\u17a1\u1784\u17cb \u1780\u17b6\u179a\u17c9\u17b6\u1794\u17ca\u17b8\u1793'),'kn':u('\u0c95\u0cc6\u0cb0\u0cc0\u0cac\u0cbf\u0caf\u0ca8\u0ccd \u0ca8\u0cc6\u0ca6\u0cb0\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd\u0cb8\u0ccd'),'ko':u('\ub124\ub35c\ub780\ub4dc\ub839 \uce74\ub9ac\ube0c'),'kr':'*aa','ks':u('\u0628\u0631\u0637\u0627\u0646\u0648\u06cc \u0642\u064f\u0637\u0628\u06c1\u0650 \u062c\u064e\u0646\u0648\u0657\u0628\u06cc \u0639\u0644\u0627\u0642\u06c1\u0655'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u041a\u0430\u0440\u0438\u0431 \u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0434\u0430\u0440\u044b'),'la':'*aa','lb':'Karibescht Holland','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0e84\u0eb2\u0ea3\u0eb4\u0e9a\u0e9a\u0ebd\u0e99 \u0ec0\u0e99\u0ec0\u0e97\u0eb5\u0ec1\u0ea5\u0e99'),'lt':u('Karib\u0173 Nyderlandai'),'lu':'*aa','lv':u('N\u012bderlandes Kar\u012bbu salas'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u041a\u0430\u0440\u0438\u043f\u0441\u043a\u0430 \u0425\u043e\u043b\u0430\u043d\u0434\u0438\u0458\u0430'),'ml':u('\u0d15\u0d30\u0d40\u0d2c\u0d3f\u0d2f\u0d7b \u0d28\u0d46\u0d24\u0d7c\u0d32\u0d3e\u0d7b\u0d21\u0d4d\u0d38\u0d4d'),'mn':u('\u041a\u0430\u0440\u0438\u0431\u044b\u043d \u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434'),'mo':'Insulele Caraibe Olandeze','mr':u('\u0915\u0945\u0930\u093f\u092c\u093f\u092f\u0928 \u0928\u0947\u0926\u0930\u0932\u0901\u0921\u094d\u0938'),'ms':'Belanda Caribbean','mt':'in-Netherlands tal-Karibew','my':u('\u1000\u102c\u101b\u1005\u103a\u1018\u102e\u101a\u1036 \u1014\u101a\u103a\u101e\u102c\u101c\u1014\u103a'),'na':'*aa','nb':'Karibisk Nederland','nd':'*aa','ne':u('\u0915\u094d\u092f\u093e\u0930\u093f\u0935\u093f\u092f\u0928 \u0928\u0947\u0926\u0930\u0932\u094d\u092f\u093e\u0923\u094d\u0921\u094d\u0938'),'ng':'*aa','nl':'Caribisch Nederland','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b3e\u0b30\u0b2c\u0b3f\u0b5f\u0b28\u0b4d\u200c \u0b28\u0b47\u0b26\u0b30\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21'),'os':'*aa','pa':u('\u0a15\u0a48\u0a30\u0a47\u0a2c\u0a40\u0a06\u0a08 \u0a28\u0a40\u0a26\u0a30\u0a32\u0a48\u0a02\u0a21'),'pi':'*aa','pl':'Niderlandy Karaibskie','ps':u('\u06a9\u06cc\u0631\u06cc\u0628\u06cc\u0646 \u0647\u0627\u0644\u06cc\u0646\u0689'),'pt':u('Pa\u00edses Baixos Caribenhos'),'qu':'Bonaire','rm':'*aa','rn':'*aa','ro':'*mo','ru':u('\u0411\u043e\u043d\u044d\u0439\u0440, \u0421\u0438\u043d\u0442-\u042d\u0441\u0442\u0430\u0442\u0438\u0443\u0441 \u0438 \u0421\u0430\u0431\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u064a\u0631\u064a\u0628\u064a\u0646 \u0646\u064a\u062f\u0631\u0644\u064a\u0646\u068a'),'se':'*aa','sg':'*aa','si':u('\u0d9a\u0dd0\u0dbb\u0dd2\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0db1\u0dd9\u0daf\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba'),'sk':u('Karibsk\u00e9 Holandsko'),'sl':'Nizozemski Karibi','sm':'*aa','sn':'*aa','so':'*aa','sq':'Karaibet holandeze','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':u('Karibiska Nederl\u00e4nderna'),'sw':'Uholanzi ya Karibiani','ta':u('\u0b95\u0bb0\u0bc0\u0baa\u0bbf\u0baf\u0ba9\u0bcd \u0ba8\u0bc6\u0ba4\u0bb0\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1'),'te':u('\u0c15\u0c30\u0c40\u0c2c\u0c3f\u0c2f\u0c28\u0c4d \u0c28\u0c46\u0c26\u0c30\u0c4d\u0c32\u0c3e\u0c02\u0c21\u0c4d\u0c38\u0c4d'),'tg':'*aa','th':u('\u0e40\u0e19\u0e40\u0e18\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c\u0e41\u0e04\u0e23\u0e34\u0e1a\u0e40\u0e1a\u0e35\u0e22\u0e19'),'ti':u('\u12ab\u122a\u1262\u12eb\u1295 \u1294\u12d8\u122d\u120b\u1295\u12f5\u1235'),'tk':'Karib Niderlandy','tl':'*en','tn':'*aa','to':u('Kalipiane fakah\u014dlani'),'tr':u('Karayip Hollandas\u0131'),'ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':u('\u0643\u0627\u0631\u0649\u0628 \u062f\u06d0\u06ad\u0649\u0632\u0649 \u06af\u0648\u0644\u0644\u0627\u0646\u062f\u0649\u064a\u06d5'),'uk':u('\u041d\u0456\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0456 \u041a\u0430\u0440\u0438\u0431\u0441\u044c\u043a\u0456 \u043e\u0441\u0442\u0440\u043e\u0432\u0438'),'ur':u('\u06a9\u0631\u06cc\u0628\u06cc\u0627\u0626\u06cc \u0646\u06cc\u062f\u0631\u0644\u06cc\u0646\u0688\u0632'),'uz':'Boneyr, Sint-Estatius va Saba','ve':'*aa','vi':u('Ca-ri-b\u00ea H\u00e0 Lan'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u8377\u5c5e\u52a0\u52d2\u6bd4\u533a'),'zu':'i-Caribbean Netherlands',},
  'BR': {'aa':'Brazil','ab':'*aa','ae':'*aa','af':u('Brasili\u00eb'),'ak':'*aa','am':u('\u1265\u122b\u12da\u120d'),'an':'*aa','ar':u('\u0627\u0644\u0628\u0631\u0627\u0632\u064a\u0644'),'as':u('\u09ac\u09cd\u09f0\u09be\u099c\u09bf\u09b2'),'av':'*aa','ay':'*aa','az':'Braziliya','ba':'*aa','be':u('\u0411\u0440\u0430\u0437\u0456\u043b\u0456\u044f'),'bg':u('\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Berezili','bn':u('\u09ac\u09cd\u09b0\u09be\u099c\u09bf\u09b2'),'bo':'*aa','br':'*aa','bs':'*aa','ca':'Brasil','ce':u('\u0411\u0440\u0430\u0437\u0438\u043b\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Braz\u00edlie'),'cu':'*aa','cv':'*aa','cy':'*ca','da':'Brasilien','de':'*da','dv':'*aa','dz':u('\u0f56\u0fb2\u0f0b\u0f5b\u0f72\u0f63'),'ee':'Brazil nutome','el':u('\u0392\u03c1\u03b1\u03b6\u03b9\u03bb\u03af\u03b1'),'en':'*aa','eo':'Brazilo','es':'*ca','et':'Brasiilia','eu':'*ca','fa':u('\u0628\u0631\u0632\u06cc\u0644'),'ff':'Beresiil','fi':'Brasilia','fj':'*aa','fo':'*ca','fr':u('Br\u00e9sil'),'fy':u('Brazili\u00eb'),'ga':u('an Bhrasa\u00edl'),'gd':'Braisil','gl':'*ca','gn':'*aa','gu':u('\u0aac\u0acd\u0ab0\u0abe\u0a9d\u0abf\u0ab2'),'gv':'*aa','ha':'Birazil','he':u('\u05d1\u05e8\u05d6\u05d9\u05dc'),'hi':u('\u092c\u094d\u0930\u093e\u091c\u093c\u0940\u0932'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':u('Braz\u00edlia'),'hy':u('\u0532\u0580\u0561\u0566\u056b\u056c\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*ca','ie':'*aa','ig':'*aa','ii':u('\ua020\ua46d'),'ik':'*aa','in':'*ca','io':'*aa','is':u('Brasil\u00eda'),'it':'Brasile','iu':'*aa','iw':'*he','ja':u('\u30d6\u30e9\u30b8\u30eb'),'ji':u('\u05d1\u05e8\u05d0\u05b7\u05d6\u05d9\u05dc'),'jv':'*aa','ka':u('\u10d1\u10e0\u10d0\u10d6\u10d8\u10da\u10d8\u10d0'),'kg':'*aa','ki':'Brazili','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1794\u17d2\u179a\u17c1\u179f\u17ca\u17b8\u179b'),'kn':u('\u0cac\u0ccd\u0cb0\u0cc6\u0c9c\u0cbf\u0cb2\u0ccd'),'ko':u('\ube0c\ub77c\uc9c8'),'kr':'*aa','ks':u('\u0628\u0631\u065b\u0627\u0632\u0650\u0644'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*da','lg':'Buraziiri','li':'*aa','ln':u('Brez\u00edl\u025b'),'lo':u('\u0e9a\u0ea3\u0eb2\u0e8a\u0eb4\u0ea7'),'lt':'Brazilija','lu':'Mnulezile','lv':u('Braz\u012blija'),'mg':'Brezila','mh':'*aa','mi':'*aa','mk':u('\u0411\u0440\u0430\u0437\u0438\u043b'),'ml':u('\u0d2c\u0d4d\u0d30\u0d38\u0d40\u0d7d'),'mn':'*mk','mo':'Brazilia','mr':u('\u092c\u094d\u0930\u093e\u091d\u093f\u0932'),'ms':'*aa','mt':u('Il-Bra\u017cil'),'my':u('\u1018\u101b\u102c\u1007\u102e\u1038'),'na':'*aa','nb':'*ca','nd':'*ki','ne':u('\u092c\u094d\u0930\u093e\u091c\u093f\u0932'),'ng':'*aa','nl':'*fy','nn':'*ca','no':'*ca','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2c\u0b4d\u0b30\u0b3e\u0b1c\u0b3f\u0b32\u0b4d'),'os':'*ce','pa':u('\u0a2c\u0a4d\u0a30\u0a3e\u0a1c\u0a3c\u0a40\u0a32'),'pi':'*aa','pl':'Brazylia','ps':u('\u0628\u0631\u0627\u0632\u06cc\u0644'),'pt':'*ca','qu':'*ca','rm':'*fi','rn':'Burezili','ro':'*mo','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0628\u0631\u0627\u0632\u064a\u0644'),'se':'*ca','sg':u('Brez\u00eeli'),'si':u('\u0db6\u0dca\u200d\u0dbb\u0dc3\u0dd3\u0dbd\u0dba'),'sk':'*hu','sl':'*lt','sm':'*aa','sn':'*aa','so':'Braasiil','sq':'*aa','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':u('\u0baa\u0bbf\u0bb0\u0bc7\u0b9a\u0bbf\u0bb2\u0bcd'),'te':u('\u0c2c\u0c4d\u0c30\u0c46\u0c1c\u0c3f\u0c32\u0c4d'),'tg':'*bg','th':u('\u0e1a\u0e23\u0e32\u0e0b\u0e34\u0e25'),'ti':'*am','tk':u('Brazili\u00fda'),'tl':'*aa','tn':'*aa','to':u('Pal\u0101sili'),'tr':'Brezilya','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0628\u0649\u0631\u0627\u0632\u0649\u0644\u0649\u064a\u06d5'),'uk':'*be','ur':'*ps','uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Beresil','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de B\u00e0r\u00e0s\u00edl\u00ec'),'za':'*aa','zh':u('\u5df4\u897f'),'zu':'i-Brazil',},
  'BS': {'aa':'Bahamas','ab':'*aa','ae':'*aa','af':'*aa','ak':'Bahama','am':u('\u1263\u1203\u121b\u1235'),'an':'*aa','ar':u('\u0627\u0644\u0628\u0647\u0627\u0645\u0627'),'as':u('\u09ac\u09be\u09b9\u09be\u09ae\u09be\u099b'),'av':'*aa','ay':'*aa','az':u('Baham adalar\u0131'),'ba':'*aa','be':u('\u0411\u0430\u0433\u0430\u043c\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b'),'bg':u('\u0411\u0430\u0445\u0430\u043c\u0438'),'bh':'*aa','bi':'*aa','bm':'Bahamasi','bn':u('\u09ac\u09be\u09b9\u09be\u09ae\u09be \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'bo':'*aa','br':'*aa','bs':'Bahami','ca':'Bahames','ce':u('\u0411\u0430\u0433\u0430\u043c\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Bahamy','cu':'*aa','cv':'*aa','cy':'Y Bahamas','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f56\u0fb7\u0f0b\u0f67\u0f0b\u0f58\u0f66\u0f84'),'ee':'Bahamas nutome','el':u('\u039c\u03c0\u03b1\u03c7\u03ac\u03bc\u03b5\u03c2'),'en':'*aa','eo':'Bahamoj','es':'*aa','et':'*ak','eu':'Bahamak','fa':u('\u0628\u0627\u0647\u0627\u0645\u0627'),'ff':'Bahamaas','fi':'*ak','fj':'*aa','fo':'Bahamaoyggjar','fr':'*aa','fy':u('Bahama\u2019s'),'ga':u('na Bah\u00e1ma\u00ed'),'gd':'Na h-Eileanan Bhathama','gl':'*aa','gn':'*aa','gu':u('\u0aac\u0ab9\u0abe\u0aae\u0abe\u0ab8'),'gv':'*aa','ha':'*aa','he':u('\u05d0\u05d9\u05d9 \u05d1\u05d4\u05d0\u05de\u05d4'),'hi':u('\u092c\u0939\u093e\u092e\u093e\u0938'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'Bahama-szigetek','hy':u('\u0532\u0561\u0570\u0561\u0574\u0561\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'*ak','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*ak','io':'*aa','is':'Bahamaeyjar','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30d0\u30cf\u30de'),'ji':u('\u05d1\u05d0\u05b7\u05d4\u05d0\u05b7\u05de\u05d0\u05b7\u05e1'),'jv':'*aa','ka':u('\u10d1\u10d0\u10f0\u10d0\u10db\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'*ak','kj':'*aa','kk':u('\u0411\u0430\u0433\u0430\u043c \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'kl':'*aa','km':u('\u1794\u17b6\u17a0\u17b6\u1798\u17c9\u17b6'),'kn':u('\u0cac\u0cb9\u0cbe\u0cae\u0cbe\u0cb8\u0ccd'),'ko':u('\ubc14\ud558\ub9c8'),'kr':'*aa','ks':u('\u0628\u064e\u06c1\u0627\u0645\u064e\u0633'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0411\u0430\u0433\u0430\u043c\u0430 \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'la':'*aa','lb':'*aa','lg':'*bm','li':'*aa','ln':u('Bahamas\u025b'),'lo':u('\u0e9a\u0eb2\u0eae\u0eb2\u0ea1\u0eb2\u0eaa'),'lt':'Bahamos','lu':'Bahamase','lv':'Bahamu salas','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d2c\u0d39\u0d3e\u0d2e\u0d3e\u0d38\u0d4d'),'mn':u('\u0411\u0430\u0433\u0430\u043c\u044b\u043d \u0430\u0440\u043b\u0443\u0443\u0434'),'mo':'*aa','mr':u('\u092c\u0939\u093e\u092e\u093e\u091c'),'ms':'*aa','mt':'il-Bahamas','my':u('\u1018\u101f\u102c\u1038\u1019\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'Bhahamas','ne':'*hi','ng':'*aa','nl':'*fy','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2c\u0b3e\u0b39\u0b3e\u0b2e\u0b3e\u0b38\u0b4d'),'os':'*aa','pa':u('\u0a2c\u0a39\u0a3e\u0a2e\u0a3e\u0a38'),'pi':'*aa','pl':'*cs','ps':'*fa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*bm','ro':'*aa','ru':u('\u0411\u0430\u0433\u0430\u043c\u044b'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0628\u0647\u0627\u0645\u0627\u0633'),'se':'*aa','sg':u('Bah\u00e2masa'),'si':u('\u0db6\u0dc4\u0db8\u0dcf\u0dc3\u0dca'),'sk':'*cs','sl':'*bs','sm':'*aa','sn':'*ak','so':'Bahaamas','sq':'*aa','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*ak','ta':u('\u0baa\u0bb9\u0bbe\u0bae\u0bbe\u0bb8\u0bcd'),'te':u('\u0c2c\u0c39\u0c3e\u0c2e\u0c3e\u0c38\u0c4d'),'tg':u('\u0411\u0430\u0433\u0430\u043c'),'th':u('\u0e1a\u0e32\u0e2e\u0e32\u0e21\u0e32\u0e2a'),'ti':'*am','tk':'Bagama adalary','tl':'*aa','tn':'*aa','to':'Pahama','tr':'Bahamalar','ts':'*aa','tt':u('\u0411\u0430\u0433\u0430\u043c \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0628\u0627\u06be\u0627\u0645\u0627'),'uk':u('\u0411\u0430\u0433\u0430\u043c\u0441\u044c\u043a\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438'),'ur':u('\u0628\u06c1\u0627\u0645\u0627\u0633'),'uz':'Bagama orollari','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de B\u00e0h\u00e1m\u00e1s\u00ec'),'za':'*aa','zh':u('\u5df4\u54c8\u9a6c'),'zu':'i-Bahamas',},
  'BT': {'aa':'Bhutan','ab':'*aa','ae':'*aa','af':'Bhoetan','ak':'Butan','am':u('\u1261\u1205\u1273\u1295'),'an':'*aa','ar':u('\u0628\u0648\u062a\u0627\u0646'),'as':u('\u09ad\u09c1\u099f\u09be\u09a8'),'av':'*aa','ay':'*aa','az':'*ak','ba':'*aa','be':u('\u0411\u0443\u0442\u0430\u043d'),'bg':'*be','bh':'*aa','bi':'*aa','bm':u('Buta\u014b'),'bn':'*as','bo':'*aa','br':'Bhoutan','bs':'*ak','ca':'*aa','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':u('Bh\u00fat\u00e1n'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f60\u0f56\u0fb2\u0f74\u0f42'),'ee':'Bhutan nutome','el':u('\u039c\u03c0\u03bf\u03c5\u03c4\u03ac\u03bd'),'en':'*aa','eo':'Butano','es':u('But\u00e1n'),'et':'*aa','eu':'*aa','fa':'*ar','ff':'Butaan','fi':'*aa','fj':'*aa','fo':'*ak','fr':'*br','fy':'*aa','ga':u('an Bh\u00fat\u00e1in'),'gd':u('But\u00e0n'),'gl':'*es','gn':'*aa','gu':u('\u0aad\u0ac2\u0a9f\u0abe\u0aa8'),'gv':'*aa','ha':'*ak','he':u('\u05d1\u05d4\u05d5\u05d8\u05df'),'hi':u('\u092d\u0942\u091f\u093e\u0928'),'ho':'*aa','hr':'*ak','ht':'*aa','hu':u('Bhut\u00e1n'),'hy':u('\u0532\u0578\u0582\u0569\u0561\u0576'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('B\u00fatan'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30d6\u30fc\u30bf\u30f3'),'ji':u('\u05d1\u05d4\u05d5\u05d8\u05d0\u05b7\u05df'),'jv':'*aa','ka':u('\u10d1\u10e3\u10e2\u10d0\u10dc\u10d8'),'kg':'*aa','ki':'Butani','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u1794\u17ca\u17bc\u178f\u1784\u17cb'),'kn':u('\u0cad\u0cc2\u0ca4\u0cbe\u0ca8\u0ccd'),'ko':u('\ubd80\ud0c4'),'kr':'*aa','ks':u('\u0628\u0648\u0657\u0679\u0627\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*aa','lg':'Butaani','li':'*aa','ln':u('But\u00e1ni'),'lo':u('\u0e9e\u0eb9\u0e96\u0eb2\u0e99'),'lt':'Butanas','lu':'*ki','lv':u('But\u0101na'),'mg':'Bhotana','mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d2d\u0d42\u0d1f\u0d4d\u0d1f\u0d3e\u0d7b'),'mn':'*be','mo':'*aa','mr':u('\u092d\u0942\u0924\u093e\u0928'),'ms':'*aa','mt':'il-Bhutan','my':u('\u1018\u1030\u1010\u1014\u103a'),'na':'*aa','nb':'*aa','nd':'Bhutani','ne':u('\u092d\u0941\u091f\u093e\u0928'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2d\u0b41\u0b1f\u0b3e\u0b28'),'os':'*aa','pa':u('\u0a2d\u0a42\u0a1f\u0a3e\u0a28'),'pi':'*aa','pl':'*aa','ps':u('\u0628\u0647\u0648\u067c\u0627\u0646'),'pt':u('But\u00e3o'),'qu':'*es','rm':'*aa','rn':'*ki','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0680\u0648\u067d\u0627\u0646'),'se':'*aa','sg':u('But\u00e4an'),'si':u('\u0db7\u0dd6\u0dad\u0dcf\u0db1\u0dba'),'sk':'*hu','sl':'*ak','sm':'*aa','sn':'*nd','so':'*aa','sq':'*ak','sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0baa\u0bc2\u0b9f\u0bbe\u0ba9\u0bcd'),'te':u('\u0c2d\u0c42\u0c1f\u0c3e\u0c28\u0c4d'),'tg':u('\u0411\u0443\u0442\u043e\u043d'),'th':u('\u0e20\u0e39\u0e0f\u0e32\u0e19'),'ti':'*am','tk':'*ak','tl':'*aa','tn':'*aa','to':u('P\u016btani'),'tr':'*ak','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u0628\u06c7\u062a\u0627\u0646'),'uk':'*be','ur':u('\u0628\u06be\u0648\u0679\u0627\u0646'),'uz':'*ak','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*bm','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de B\u00fat\u00e1n\u00ec'),'za':'*aa','zh':u('\u4e0d\u4e39'),'zu':'i-Bhutan',},
  'BV': {'aa':'Bouvet Island','ab':'*aa','ae':'*aa','af':'Bouvet-eiland','ak':'*aa','am':u('\u1261\u126c\u1275 \u12f0\u1234\u1275'),'an':'*aa','ar':u('\u062c\u0632\u064a\u0631\u0629 \u0628\u0648\u0641\u064a\u0647'),'as':u('\u09ac\u09c1\u09ad\u09c7 \u09a6\u09cd\u09ac\u09c0\u09aa'),'av':'*aa','ay':'*aa','az':u('Buve adas\u0131'),'ba':'*aa','be':u('\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u0411\u0443\u0432\u044d'),'bg':u('\u043e\u0441\u0442\u0440\u043e\u0432 \u0411\u0443\u0432\u0435'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u09ac\u09cb\u09ad\u09c7\u099f \u09a6\u09cd\u09ac\u09c0\u09aa'),'bo':'*aa','br':'Enez Bouvet','bs':'Ostrvo Buve','ca':'Bouvet','ce':u('\u0411\u0443\u0432\u0435\u043d \u0433\u04c0\u0430\u0439\u0440\u0435'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Bouvet\u016fv ostrov'),'cu':'*aa','cv':'*aa','cy':'Ynys Bouvet','da':u('Bouvet\u00f8en'),'de':'Bouvetinsel','dv':'*aa','dz':u('\u0f56\u0f7c\u0f60\u0f74\u0f0b\u0f5d\u0f7a\u0f4a\u0f0b\u0f58\u0f5a\u0f7c\u0f0b\u0f42\u0fb3\u0f72\u0f44'),'ee':u('Bouvet \u0192udomekpo nutome'),'el':u('\u039d\u03ae\u03c3\u03bf\u03c2 \u039c\u03c0\u03bf\u03c5\u03b2\u03ad'),'en':'*aa','eo':'*aa','es':'Isla Bouvet','et':u('Bouvet\u2019 saar'),'eu':'Bouvet uhartea','fa':u('\u062c\u0632\u06cc\u0631\u0647\u0654 \u0628\u0648\u0648\u0647'),'ff':'*aa','fi':u('Bouvet\u2019nsaari'),'fj':'*aa','fo':'Bouvetoyggj','fr':u('\u00cele Bouvet'),'fy':u('Bouveteil\u00e2n'),'ga':u('Oile\u00e1n Bouvet'),'gd':'Eilean Bouvet','gl':'Illa Bouvet','gn':'*aa','gu':u('\u0aac\u0acc\u0ab5\u0ac7\u0aa4 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1'),'gv':'*aa','ha':'*aa','he':u('\u05d4\u05d0\u05d9 \u05d1\u05d5\u05d1\u05d4'),'hi':u('\u092c\u094b\u0935\u0947\u0924 \u0926\u094d\u0935\u0940\u092a'),'ho':'*aa','hr':'Otok Bouvet','ht':'*aa','hu':'Bouvet-sziget','hy':u('\u0532\u0578\u0582\u057e\u0565 \u056f\u0572\u0566\u056b'),'hz':'*aa','ia':'*aa','id':'Pulau Bouvet','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'Bouveteyja','it':'Isola Bouvet','iu':'*aa','iw':'*he','ja':u('\u30d6\u30fc\u30d9\u5cf6'),'ji':'*aa','jv':'*aa','ka':u('\u10d1\u10e3\u10d5\u10d4'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u0411\u0443\u0432\u0435 \u0430\u0440\u0430\u043b\u044b'),'kl':'*aa','km':u('\u1780\u17c4\u17c7\u200b\u1794\u17ca\u17bc\u179c\u17c9\u17c1\u178f'),'kn':u('\u0cac\u0ccb\u0cb5\u0cc6\u0c9f\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa'),'ko':u('\ubd80\ubca0\uc12c'),'kr':'*aa','ks':u('\u0628\u0648\u0648\u064e\u0679 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*de','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0ec0\u0e81\u0eb2\u0eb0\u0e9a\u0eb9\u0ec0\u0ea7\u0e94'),'lt':u('Buv\u0117 Sala'),'lu':'*aa','lv':u('Buv\u0113 sala'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u041e\u0441\u0442\u0440\u043e\u0432 \u0411\u0443\u0432\u0435'),'ml':u('\u0d2c\u0d57\u0d35\u0d46\u0d1f\u0d4d\u0d1f\u0d4d \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d4d'),'mn':u('\u0411\u0443\u0432\u0435 \u0430\u0440\u0430\u043b'),'mo':'Insula Bouvet','mr':u('\u092c\u094b\u0909\u0935\u0947\u091f \u092c\u0947\u091f'),'ms':'*id','mt':u('G\u017cira Bouvet'),'my':u('\u1018\u1030\u1017\u1000\u103a\u1000\u103b\u103d\u1014\u103a\u1038'),'na':'*aa','nb':u('Bouvet\u00f8ya'),'nd':'*aa','ne':u('\u092c\u0941\u092d\u0947\u091f \u091f\u093e\u092a\u0941'),'ng':'*aa','nl':'Bouveteiland','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2c\u0b4c\u0b2d\u0b47\u0b1f\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a'),'os':'*aa','pa':u('\u0a2c\u0a4c\u0a35\u0a47\u0a1f \u0a1f\u0a3e\u0a2a\u0a42'),'pi':'*aa','pl':'Wyspa Bouveta','ps':u('\u0628\u0648\u0648\u06cc\u067c \u067c\u0627\u067e\u0648'),'pt':'Ilha Bouvet','qu':'*aa','rm':'Insla Bouvet','rn':'*aa','ro':'*mo','ru':u('\u043e-\u0432 \u0411\u0443\u0432\u0435'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0628\u0648\u0648\u067d \u067b\u064a\u067d'),'se':'Bouvet-sullot','sg':'*aa','si':u('\u0db6\u0dd4\u0dc0\u0da7\u0dca \u0daf\u0dd4\u0db4\u0dad\u0dca'),'sk':'Bouvetov ostrov','sl':'Bouvetov otok','sm':'*aa','sn':'*aa','so':'*aa','sq':'Ishulli Bove','sr':u('\u041e\u0441\u0442\u0440\u0432\u043e \u0411\u0443\u0432\u0435'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Bouvet\u00f6n'),'sw':'Kisiwa cha Bouvet','ta':u('\u0baa\u0bca\u0bb5\u0bc7\u0b9f\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd'),'te':u('\u0c2c\u0c4a\u0c35\u0c46\u0c1f\u0c4d \u0c26\u0c40\u0c35\u0c3f'),'tg':u('\u04b6\u0430\u0437\u0438\u0440\u0430\u0438 \u0411\u0443\u0432\u0435'),'th':u('\u0e40\u0e01\u0e32\u0e30\u0e1a\u0e39\u0e40\u0e27\u0e15'),'ti':u('\u12f0\u1234\u1273\u1275 \u1266\u12cd\u126c\u1275'),'tk':'Buwe adasy','tl':'*aa','tn':'*aa','to':'Motu Puveti','tr':u('Bouvet Adas\u0131'),'ts':'*aa','tt':u('\u0411\u0443\u0432\u0435 \u0443\u0442\u0440\u0430\u0432\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0628\u0648\u06cb\u06d0\u062a \u0626\u0627\u0631\u0649\u0644\u0649'),'uk':u('\u041e\u0441\u0442\u0440\u0456\u0432 \u0411\u0443\u0432\u0435'),'ur':u('\u0628\u0624\u0648\u06cc\u0679 \u0622\u0626\u0644\u06cc\u0646\u0688'),'uz':'Buve oroli','ve':'*aa','vi':u('\u0110\u1ea3o Bouvet'),'vo':'*aa','wa':'*aa','wo':'Dunu Buwet','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5e03\u97e6\u5c9b'),'zu':'i-Bouvet Island',},
  'BW': {'aa':'Botswana','ab':'*aa','ae':'*aa','af':'*aa','ak':u('B\u0254tswana'),'am':u('\u1266\u1275\u1235\u12cb\u1293'),'an':'*aa','ar':u('\u0628\u0648\u062a\u0633\u0648\u0627\u0646\u0627'),'as':u('\u09ac\u2019\u099f\u099a\u09cb\u09f1\u09be\u09a8\u09be'),'av':'*aa','ay':'*aa','az':'Botsvana','ba':'*aa','be':u('\u0411\u0430\u0442\u0441\u0432\u0430\u043d\u0430'),'bg':u('\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u0430'),'bh':'*aa','bi':'*aa','bm':u('B\u0254tisiwana'),'bn':u('\u09ac\u09a4\u09b8\u09cb\u09af\u09bc\u09be\u09a8\u09be'),'bo':'*aa','br':'*aa','bs':'Bocvana','ca':'*aa','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Botsuana','dv':'*aa','dz':u('\u0f56\u0fb7\u0f7c\u0f59\u0f0b\u0f5d\u0f0b\u0f53'),'ee':'Botswana nutome','el':u('\u039c\u03c0\u03bf\u03c4\u03c3\u03bf\u03c5\u03ac\u03bd\u03b1'),'en':'*aa','eo':'Bocvano','es':'*de','et':'*aa','eu':'*aa','fa':'*ar','ff':'Botswaana','fi':'*aa','fj':'*aa','fo':'*az','fr':'*aa','fy':'*aa','ga':u('an Bhotsu\u00e1in'),'gd':'*de','gl':'*aa','gn':'*aa','gu':u('\u0aac\u0acb\u0aa4\u0acd\u0ab8\u0acd\u0ab5\u0abe\u0aa8\u0abe'),'gv':'*aa','ha':'Baswana','he':u('\u05d1\u05d5\u05e6\u05d5\u05d5\u05d0\u05e0\u05d4'),'hi':u('\u092c\u094b\u0924\u094d\u0938\u094d\u0935\u093e\u0928\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u0532\u0578\u0569\u057d\u057e\u0561\u0576\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*az','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30dc\u30c4\u30ef\u30ca'),'ji':u('\u05d1\u05d0\u05e6\u05d5\u05d5\u05d0\u05b7\u05e0\u05e2'),'jv':'*aa','ka':u('\u10d1\u10dd\u10e2\u10e1\u10d5\u10d0\u10dc\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1794\u17bb\u178f\u179f\u17d2\u179c\u17b6\u178e\u17b6'),'kn':u('\u0cac\u0ccb\u0c9f\u0ccd\u0cb8\u0ccd\u200c\u0cb5\u0cbe\u0ca8\u0cbe'),'ko':u('\ubcf4\uce20\uc640\ub098'),'kr':'*aa','ks':u('\u0628\u0648\u062a\u064e\u0633\u0648\u0627\u0646\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*de','lg':'Botiswana','li':'*aa','ln':'*aa','lo':u('\u0e9a\u0ead\u0e94\u0eaa\u0eb0\u0ea7\u0eb2\u0e99\u0eb2'),'lt':'*az','lu':'Mbotswana','lv':u('Botsv\u0101na'),'mg':'Botsoana','mh':'*aa','mi':'*aa','mk':u('\u0411\u043e\u0446\u0432\u0430\u043d\u0430'),'ml':u('\u0d2c\u0d4b\u0d1f\u0d4d\u0d38\u0d4d\u0d35\u0d3e\u0d28'),'mn':'*bg','mo':'*aa','mr':u('\u092c\u094b\u091f\u094d\u0938\u0935\u093e\u0928\u093e'),'ms':'*aa','mt':'il-Botswana','my':u('\u1018\u1031\u102c\u1037\u1006\u103d\u102c\u1014\u102c'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u092c\u094b\u091f\u094d\u0938\u094d\u0935\u093e\u0928\u093e'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2c\u0b4b\u0b1f\u0b38\u0b4d\u0b71\u0b3e\u0b28\u0b3e'),'os':'*aa','pa':u('\u0a2c\u0a4b\u0a24\u0a38\u0a35\u0a3e\u0a28\u0a3e'),'pi':'*aa','pl':'*aa','ps':u('\u0628\u0648\u062a\u0633\u0648\u0627\u0646\u0647'),'pt':'*de','qu':'*de','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0628\u0648\u067d\u0633\u0648\u0627\u0646\u0627'),'se':'*aa','sg':'*aa','si':u('\u0db6\u0ddc\u0da7\u0dca\u0dc3\u0dca\u0dc0\u0dcf\u0db1\u0dcf'),'sk':'*aa','sl':'*bs','sm':'*aa','sn':'*aa','so':'Botuswaana','sq':u('Botsvan\u00eb'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0baa\u0bcb\u0b9f\u0bcd\u0bb8\u0bcd\u0bb5\u0bbe\u0ba9\u0bbe'),'te':u('\u0c2c\u0c4b\u0c1f\u0c4d\u0c38\u0c4d\u0c35\u0c3e\u0c28\u0c3e'),'tg':'*bg','th':u('\u0e1a\u0e2d\u0e15\u0e2a\u0e27\u0e32\u0e19\u0e32'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':'Potisiuana','tr':'*az','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0628\u0648\u062a\u0633\u06cb\u0627\u0646\u0627'),'uk':'*bg','ur':'*ar','uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de B\u1ecd\u0300t\u00ecs\u00faw\u00e1n\u00e0'),'za':'*aa','zh':u('\u535a\u8328\u74e6\u7eb3'),'zu':'iBotswana',},
  'BY': {'aa':'Belarus','ab':'*aa','ae':'*aa','af':'*aa','ak':u('B\u025blarus'),'am':u('\u1264\u120b\u1229\u1235'),'an':'*aa','ar':u('\u0628\u064a\u0644\u0627\u0631\u0648\u0633'),'as':u('\u09ac\u09c7\u09b2\u09be\u09f0\u09c1\u099b'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u044c'),'bg':u('\u0411\u0435\u043b\u0430\u0440\u0443\u0441'),'bh':'*aa','bi':'*aa','bm':'Belarusi','bn':u('\u09ac\u09c7\u09b2\u09be\u09b0\u09c1\u09b6'),'bo':'*aa','br':'*aa','bs':'Bjelorusija','ca':u('Belar\u00fas'),'ce':u('\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('B\u011blorusko'),'cu':'*aa','cv':'*aa','cy':'Belarws','da':'Hviderusland','de':'*aa','dv':'*aa','dz':u('\u0f56\u0f7a\u0f63\u0f0b\u0f68\u0f0b\u0f62\u0f74\u0f0b\u0f66\u0f74'),'ee':'Belarus nutome','el':u('\u039b\u03b5\u03c5\u03ba\u03bf\u03c1\u03c9\u03c3\u03af\u03b1'),'en':'*aa','eo':'Belorusujo','es':'Bielorrusia','et':'Valgevene','eu':'*es','fa':u('\u0628\u0644\u0627\u0631\u0648\u0633'),'ff':'Belaruus','fi':u('Valko-Ven\u00e4j\u00e4'),'fj':'*aa','fo':u('Hv\u00edtarussland'),'fr':u('Bi\u00e9lorussie'),'fy':u('Wit-Rusl\u00e2n'),'ga':u('an Bhealar\u00fais'),'gd':u('A\u2019 Bhealaruis'),'gl':'*es','gn':'*aa','gu':u('\u0aac\u0ac7\u0ab2\u0abe\u0ab0\u0ac1\u0ab8'),'gv':'*aa','ha':'*aa','he':u('\u05d1\u05dc\u05d0\u05e8\u05d5\u05e1'),'hi':u('\u092c\u0947\u0932\u093e\u0930\u0942\u0938'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'Belarusz','hy':u('\u0532\u0565\u056c\u0561\u057c\u0578\u0582\u057d'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Hv\u00edta-R\u00fassland'),'it':'Bielorussia','iu':'*aa','iw':'*he','ja':u('\u30d9\u30e9\u30eb\u30fc\u30b7'),'ji':u('\u05d1\u05e2\u05dc\u05d0\u05b7\u05e8\u05d5\u05e1'),'jv':'*aa','ka':u('\u10d1\u10d4\u10da\u10d0\u10e0\u10e3\u10e1\u10d8'),'kg':'*aa','ki':'*bm','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u1794\u17c1\u17a1\u17b6\u179a\u17bb\u179f'),'kn':u('\u0cac\u0cc6\u0cb2\u0cbe\u0cb0\u0cb8\u0ccd'),'ko':u('\ubca8\ub77c\ub8e8\uc2a4'),'kr':'*aa','ks':u('\u0628\u06cc\u0644\u0627\u0631\u0648\u0657\u0633'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':u('W\u00e4issrussland'),'lg':'*bm','li':'*aa','ln':'Byelorisi','lo':u('\u0ec0\u0e9a\u0ea7\u0e9a\u0eb2\u0ea3\u0eb8\u0eaa'),'lt':'Baltarusija','lu':'*ln','lv':'Baltkrievija','mg':'Belarosy','mh':'*aa','mi':'*aa','mk':u('\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0438\u0458\u0430'),'ml':u('\u0d2c\u0d46\u0d32\u0d31\u0d42\u0d38\u0d4d'),'mn':'*be','mo':'*aa','mr':'*hi','ms':'*aa','mt':'il-Belarussja','my':u('\u1018\u102e\u101c\u102c\u101b\u102f\u1005\u103a'),'na':'*aa','nb':'Hviterussland','nd':'Bhelarusi','ne':'*hi','ng':'*aa','nl':'*aa','nn':'Kviterussland','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2c\u0b47\u0b32\u0b3e\u0b30\u0b41\u0b37\u0b4d'),'os':'*aa','pa':u('\u0a2c\u0a47\u0a32\u0a3e\u0a30\u0a42\u0a38'),'pi':'*aa','pl':u('Bia\u0142oru\u015b'),'ps':u('\u0628\u06cc\u0644\u0627\u0631\u0648\u0633'),'pt':u('Bielorr\u00fassia'),'qu':'*ca','rm':'*it','rn':'Belausi','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0628\u06cc\u0644\u0627\u0631\u0633'),'se':u('Vilges-Ruo\u0161\u0161a'),'sg':u('Belar\u00fcsi'),'si':u('\u0db6\u0dd9\u0dbd\u0dbb\u0dd4\u0dc3\u0dca'),'sk':'Bielorusko','sl':'Belorusija','sm':'*aa','sn':'*bm','so':'*aa','sq':'Bjellorusi','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'Vitryssland','sw':'*aa','ta':u('\u0baa\u0bc6\u0bb2\u0bbe\u0bb0\u0bc2\u0bb8\u0bcd'),'te':u('\u0c2c\u0c46\u0c32\u0c3e\u0c30\u0c38\u0c4d'),'tg':u('\u0411\u0435\u043b\u043e\u0440\u0443\u0441'),'th':u('\u0e40\u0e1a\u0e25\u0e32\u0e23\u0e38\u0e2a'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':'Pelalusi','tr':'*aa','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u0628\u06d0\u0644\u0627\u0631\u06c7\u0633\u0649\u064a\u06d5'),'uk':u('\u0411\u0456\u043b\u043e\u0440\u0443\u0441\u044c'),'ur':'*ps','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Belaris','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de B\u00e9l\u00e1r\u00fas\u00ec'),'za':'*aa','zh':u('\u767d\u4fc4\u7f57\u65af'),'zu':'i-Belarus',},
  'BZ': {'aa':'Belize','ab':'*aa','ae':'*aa','af':'*aa','ak':'Beliz','am':u('\u1260\u120a\u12dd'),'an':'*aa','ar':u('\u0628\u0644\u064a\u0632'),'as':u('\u09ac\u09c7\u09b2\u09bf\u099c'),'av':'*aa','ay':'*aa','az':'*ak','ba':'*aa','be':u('\u0411\u0435\u043b\u0456\u0437'),'bg':u('\u0411\u0435\u043b\u0438\u0437'),'bh':'*aa','bi':'*aa','bm':'Belizi','bn':'*as','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f56\u0fb7\u0f7a\u0f0b\u0f63\u0f72\u0f5b'),'ee':'Belize nutome','el':u('\u039c\u03c0\u03b5\u03bb\u03af\u03b6'),'en':'*aa','eo':'Belizo','es':'Belice','et':'*aa','eu':'*aa','fa':u('\u0628\u0644\u06cc\u0632'),'ff':'Beliise','fi':'*aa','fj':'*aa','fo':'Belis','fr':'*aa','fy':'*aa','ga':u('an Bheil\u00eds'),'gd':u('A\u2019 Bheil\u00ecs'),'gl':'*aa','gn':'*aa','gu':u('\u0aac\u0ac7\u0ab2\u0ac0\u0a9d'),'gv':'*aa','ha':'*ak','he':u('\u05d1\u05dc\u05d9\u05d6'),'hi':u('\u092c\u0947\u0932\u0940\u091c\u093c'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u0532\u0565\u056c\u056b\u0566'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Bel\u00eds'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30d9\u30ea\u30fc\u30ba'),'ji':u('\u05d1\u05e2\u05dc\u05d9\u05d6'),'jv':'*aa','ka':u('\u10d1\u10d4\u10da\u10d8\u10d6\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1794\u17c1\u179b\u17b8'),'kn':u('\u0cac\u0cc6\u0cb2\u0cbf\u0c9c\u0ccd'),'ko':u('\ubca8\ub9ac\uc988'),'kr':'*aa','ks':u('\u0628\u06cc\u0644\u0650\u062c'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':u('Beliz\u025b'),'lo':u('\u0ec0\u0e9a\u0ea5\u0eb5\u0e8a'),'lt':'Belizas','lu':'*aa','lv':'Beliza','mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0411\u0435\u043b\u0438\u0437\u0435'),'ml':u('\u0d2c\u0d46\u0d32\u0d40\u0d38\u0d4d'),'mn':'*bg','mo':'*aa','mr':u('\u092c\u0947\u0932\u093f\u091d\u0947'),'ms':'*aa','mt':'il-Belize','my':u('\u1018\u101c\u102d\u1007\u103a'),'na':'*aa','nb':'*aa','nd':'Bhelize','ne':u('\u092c\u0947\u0932\u093f\u091c'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2c\u0b47\u0b32\u0b3f\u0b1c\u0b4d'),'os':'*aa','pa':u('\u0a2c\u0a47\u0a32\u0a40\u0a1c\u0a3c'),'pi':'*aa','pl':'*aa','ps':'*fa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0628\u064a\u0644\u064a\u0632'),'se':'*aa','sg':u('Bel\u00eezi'),'si':u('\u0db6\u0dd9\u0dbd\u0dd3\u0dc3\u0dca'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':u('Beliz\u00eb'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0baa\u0bc6\u0bb2\u0bbf\u0bb8\u0bcd'),'te':u('\u0c2c\u0c46\u0c32\u0c3f\u0c1c\u0c4d'),'tg':'*bg','th':u('\u0e40\u0e1a\u0e25\u0e35\u0e0b'),'ti':u('\u1264\u120a\u12d8'),'tk':'*ak','tl':'*aa','tn':'*aa','to':'Pelise','tr':'*aa','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0628\u06d0\u0644\u0649\u0632'),'uk':'*be','ur':u('\u0628\u06cc\u0644\u0627\u0626\u0632'),'uz':'*ak','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*fo','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de B\u00e8l\u00eds\u1eb9\u0300'),'za':'*aa','zh':u('\u4f2f\u5229\u5179'),'zu':'i-Belize',},
  'CA': {'aa':'Canada','ab':'*aa','ae':'*aa','af':'Kanada','ak':'*af','am':u('\u12ab\u1293\u12f3'),'an':'*aa','ar':u('\u0643\u0646\u062f\u0627'),'as':u('\u0995\u09be\u09a8\u09be\u09a1\u09be'),'av':'*aa','ay':'*aa','az':'*af','ba':'*aa','be':u('\u041a\u0430\u043d\u0430\u0434\u0430'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'*af','bn':'*as','bo':'*aa','br':'*af','bs':'*af','ca':u('Canad\u00e0'),'ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*af','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*af','dv':'*aa','dz':u('\u0f40\u0f7a\u0f0b\u0f53\u0f0b\u0f4c'),'ee':'Canada nutome','el':u('\u039a\u03b1\u03bd\u03b1\u03b4\u03ac\u03c2'),'en':'*aa','eo':'Kanado','es':u('Canad\u00e1'),'et':'*af','eu':'*af','fa':u('\u06a9\u0627\u0646\u0627\u062f\u0627'),'ff':'Kanadaa','fi':'*af','fj':'*aa','fo':'*af','fr':'*aa','fy':'*aa','ga':'Ceanada','gd':'*aa','gl':'*es','gn':'*aa','gu':u('\u0a95\u0ac7\u0aa8\u0ac7\u0aa1\u0abe'),'gv':'*aa','ha':'*af','he':u('\u05e7\u05e0\u05d3\u05d4'),'hi':u('\u0915\u0928\u093e\u0921\u093e'),'ho':'*aa','hr':'*af','ht':'*aa','hu':'*af','hy':u('\u053f\u0561\u0576\u0561\u0564\u0561'),'hz':'*aa','ia':'*aa','id':'*af','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*af','io':'*aa','is':'*af','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30ab\u30ca\u30c0'),'ji':u('\u05e7\u05d0\u05b7\u05e0\u05d0\u05b7\u05d3\u05e2'),'jv':'*aa','ka':u('\u10d9\u10d0\u10dc\u10d0\u10d3\u10d0'),'kg':'*aa','ki':'*af','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u1780\u17b6\u178e\u17b6\u178a\u17b6'),'kn':u('\u0c95\u0cc6\u0ca8\u0ca1\u0cbe'),'ko':u('\uce90\ub098\ub2e4'),'kr':'*aa','ks':u('\u06a9\u06cc\u0646\u064e\u0691\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*af','lg':'*af','li':'*aa','ln':'*af','lo':u('\u0ec1\u0e84\u0e99\u0eb2\u0e94\u0eb2'),'lt':'*af','lu':'*af','lv':u('Kan\u0101da'),'mg':'*af','mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d15\u0d3e\u0d28\u0d21'),'mn':u('\u041a\u0430\u043d\u0430\u0434'),'mo':'*aa','mr':u('\u0915\u0945\u0928\u0921\u093e'),'ms':'*af','mt':'il-Kanada','my':u('\u1000\u1014\u1031\u1012\u102b'),'na':'*aa','nb':'*aa','nd':'Khanada','ne':u('\u0915\u094d\u092f\u093e\u0928\u093e\u0921\u093e'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b3e\u0b28\u0b3e\u0b21\u0b3e'),'os':'*aa','pa':u('\u0a15\u0a48\u0a28\u0a47\u0a21\u0a3e'),'pi':'*aa','pl':'*af','ps':u('\u06a9\u0627\u0646\u0627\u0689\u0627'),'pt':'*es','qu':'*aa','rm':'*aa','rn':'*af','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u0626\u0646\u0627\u068a\u0627'),'se':u('Kan\u00e1da'),'sg':u('Kanad\u00e4a'),'si':u('\u0d9a\u0dd0\u0db1\u0da9\u0dcf\u0dc0'),'sk':'*af','sl':'*af','sm':'*aa','sn':'*af','so':'*af','sq':'*af','sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*af','sw':'*af','ta':u('\u0b95\u0ba9\u0b9f\u0bbe'),'te':u('\u0c15\u0c46\u0c28\u0c21\u0c3e'),'tg':'*be','th':u('\u0e41\u0e04\u0e19\u0e32\u0e14\u0e32'),'ti':'*am','tk':'*af','tl':'*aa','tn':'*aa','to':u('K\u0101nata'),'tr':'*af','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u0643\u0627\u0646\u0627\u062f\u0627'),'uk':'*be','ur':u('\u06a9\u06cc\u0646\u06cc\u0688\u0627'),'uz':'*af','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*ff','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de K\u00e1n\u00e1d\u00e0'),'za':'*aa','zh':u('\u52a0\u62ff\u5927'),'zu':'i-Canada',},
  'CC': {'aa':'Cocos Islands','ab':'*aa','ae':'*aa','af':'Kokoseilande','ak':'*aa','am':u('\u12ae\u12ae\u1235(\u12ac\u120a\u1295\u130d) \u12f0\u1234\u1276\u127d'),'an':'*aa','ar':u('\u062c\u0632\u0631 \u0643\u0648\u0643\u0648\u0633 (\u0643\u064a\u0644\u064a\u0646\u063a)'),'as':u('\u0995\u09cb\u0995\u09cb\u099a (\u0995\u09c0\u09b2\u09bf\u0982) \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'av':'*aa','ay':'*aa','az':u('Kokos (Kilinq) adalar\u0131'),'ba':'*aa','be':u('\u041a\u0430\u043a\u043e\u0441\u0430\u0432\u044b\u044f (\u041a\u0456\u043b\u0456\u043d\u0433) \u0430\u0441\u0442\u0440\u0430\u0432\u044b'),'bg':u('\u041a\u043e\u043a\u043e\u0441\u043e\u0432\u0438 \u043e\u0441\u0442\u0440\u043e\u0432\u0438 (\u043e\u0441\u0442\u0440\u043e\u0432\u0438 \u041a\u0438\u0439\u043b\u0438\u043d\u0433)'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u0995\u09cb\u0995\u09cb\u09b8 (\u0995\u09bf\u09b2\u09bf\u0982) \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'bo':'*aa','br':'Inizi Kokoz','bs':'Kokosova (Keelingova) ostrva','ca':'Illes Cocos','ce':u('\u041a\u043e\u043a\u043e\u0441\u0438\u0439\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Kokosov\u00e9 ostrovy'),'cu':'*aa','cv':'*aa','cy':'Ynysoedd Cocos (Keeling)','da':u('Cocos\u00f8erne'),'de':'Kokosinseln','dv':'*aa','dz':u('\u0f40\u0f7c\u0f0b\u0f40\u0f7c\u0f66\u0f0b\u0f42\u0fb3\u0f72\u0f44\u0f0b\u0f5a\u0f7c\u0f58'),'ee':'Kokos (Kiling) fudomekpo nutome','el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u039a\u03cc\u03ba\u03bf\u03c2 (\u039a\u03af\u03bb\u03b9\u03bd\u03b3\u03ba)'),'en':'Cocos (Keeling) Islands','eo':'*aa','es':'Islas Cocos','et':'Kookossaared','eu':'Cocos uharteak','fa':u('\u062c\u0632\u0627\u06cc\u0631 \u06a9\u0648\u06a9\u0648\u0633'),'ff':'*aa','fi':'Kookossaaret (Keelingsaaret)','fj':'*aa','fo':'Kokosoyggjar','fr':u('\u00celes Cocos'),'fy':'Kokosilanen','ga':u('Oile\u00e1in Cocos (Keeling)'),'gd':'Na h-Eileanan Chocos (Keeling)','gl':'Illas Cocos (Keeling)','gn':'*aa','gu':u('\u0a95\u0acb\u0a95\u0acb\u0a9d (\u0a95\u0ac0\u0ab2\u0ac0\u0a82\u0a97) \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8'),'gv':'*aa','ha':'*aa','he':u('\u05d0\u05d9\u05d9 \u05e7\u05d5\u05e7\u05d5\u05e1 (\u05e7\u05d9\u05dc\u05d9\u05e0\u05d2)'),'hi':u('\u0915\u094b\u0915\u094b\u0938 (\u0915\u0940\u0932\u093f\u0902\u0917) \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939'),'ho':'*aa','hr':'Kokosovi (Keelingovi) otoci','ht':'*aa','hu':u('K\u00f3kusz (Keeling)-szigetek'),'hy':u('\u053f\u0578\u056f\u0578\u057d\u0575\u0561\u0576 (\u0554\u056b\u056c\u056b\u0576\u0563) \u056f\u0572\u0566\u056b\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'Kepulauan Cocos (Keeling)','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('K\u00f3koseyjar (Keeling)'),'it':'Isole Cocos (Keeling)','iu':'*aa','iw':'*he','ja':u('\u30b3\u30b3\u30b9(\u30ad\u30fc\u30ea\u30f3\u30b0)\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':u('\u10e5\u10dd\u10e5\u10dd\u10e1\u10d8\u10e1 (\u10d9\u10d8\u10da\u10d8\u10dc\u10d2\u10d8\u10e1) \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u041a\u043e\u043a\u043e\u0441 (\u041a\u0438\u043b\u0438\u043d\u0433) \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'kl':'*aa','km':u('\u1780\u17c4\u17c7\u200b\u1780\u17bc\u1780\u17bc\u179f (\u1782\u17b8\u179b\u17b8\u1784)'),'kn':u('\u0c95\u0cca\u0c95\u0cca\u0cb8\u0ccd (\u0c95\u0cc0\u0cb2\u0cbf\u0c82\u0c97\u0ccd) \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3\u0cc1'),'ko':u('\ucf54\ucf54\uc2a4 \uc81c\ub3c4'),'kr':'*aa','ks':u('\u06a9\u0648\u06a9\u064e\u0633 \u06a9\u06cc\u0656\u0644\u0650\u0646\u065b\u06af \u062c\u0654\u0632\u06cc\u0656\u0631\u0655'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'Kokosinselen','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0eab\u0ea1\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ec2\u0e81\u0ec2\u0e81\u0eaa'),'lt':u('Kokos\u0173 (Kilingo) Salos'),'lu':'*aa','lv':u('Kokosu (K\u012blinga) salas'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u041a\u043e\u043a\u043e\u0441\u043e\u0432\u0438 (\u041a\u0438\u043b\u0438\u043d\u0448\u043a\u0438) \u041e\u0441\u0442\u0440\u043e\u0432\u0438'),'ml':u('\u0d15\u0d4b\u0d15\u0d4d\u0d15\u0d38\u0d4d (\u0d15\u0d40\u0d32\u0d3f\u0d02\u0d17\u0d4d) \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e'),'mn':u('\u041a\u043e\u043a\u043e\u0441 (\u041a\u0438\u0439\u043b\u0438\u043d\u0433) \u0430\u0440\u043b\u0443\u0443\u0434'),'mo':'Insulele Cocos (Keeling)','mr':u('\u0915\u094b\u0915\u094b\u0938 (\u0915\u0940\u0932\u093f\u0902\u0917) \u092c\u0947\u091f\u0947'),'ms':'*id','mt':u('G\u017cejjer Cocos (Keeling)'),'my':u('\u1000\u102d\u102f\u1000\u102d\u102f\u1038\u1000\u103b\u103d\u1014\u103a\u1038'),'na':'*aa','nb':u('Kokos\u00f8yene'),'nd':'*aa','ne':u('\u0915\u094b\u0915\u094b\u0938 (\u0915\u093f\u0932\u093f\u0902\u0917) \u091f\u093e\u092a\u0941\u0939\u0930\u0941'),'ng':'*aa','nl':'Cocoseilanden','nn':u('Kokos\u00f8yane'),'no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b4b\u0b15\u0b4b\u0b38\u0b4d (\u0b15\u0b40\u0b32\u0b3f\u0b02) \u0b26\u0b4d\u0b35\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c'),'os':'*aa','pa':u('\u0a15\u0a4b\u0a15\u0a4b\u0a38 (\u0a15\u0a40\u0a32\u0a3f\u0a70\u0a17) \u0a1f\u0a3e\u0a2a\u0a42'),'pi':'*aa','pl':'Wyspy Kokosowe','ps':u('\u06a9\u0648\u06a9\u0648\u0632 (\u06a9\u06cc\u0628\u0644) \u067c\u0627\u067e\u0648\u06ab\u0627\u0646\u06d0'),'pt':'Ilhas Cocos (Keeling)','qu':'*es','rm':'Inslas Cocos','rn':'*aa','ro':'*mo','ru':u('\u041a\u043e\u043a\u043e\u0441\u043e\u0432\u044b\u0435 \u043e-\u0432\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u0648\u06aa\u0648\u0633 \u067b\u064a\u067d'),'se':'Cocos-sullot','sg':'*aa','si':u('\u0d9a\u0ddc\u0d9a\u0ddd\u0dc3\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca'),'sk':'*cs','sl':'Kokosovi otoki','sm':'*aa','sn':'*aa','so':'*aa','sq':'Ishujt Kokos','sr':u('\u041a\u043e\u043a\u043e\u0441\u043e\u0432\u0430 (\u041a\u0438\u043b\u0438\u043d\u0433\u043e\u0432\u0430) \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Kokos\u00f6arna'),'sw':'Visiwa vya Cocos (Keeling)','ta':u('\u0b95\u0bcb\u0b95\u0bcb\u0bb8\u0bcd (\u0b95\u0bc0\u0bb2\u0bbf\u0b99\u0bcd) \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd'),'te':u('\u0c15\u0c4b\u0c15\u0c4b\u0c38\u0c4d (\u0c15\u0c40\u0c32\u0c3f\u0c02\u0c17\u0c4d) \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41'),'tg':u('\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u041a\u043e\u043a\u043e\u0441 (\u041a\u0438\u043b\u0438\u043d\u0433)'),'th':u('\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e42\u0e04\u0e42\u0e04\u0e2a (\u0e04\u0e35\u0e25\u0e34\u0e07)'),'ti':u('\u12ae\u12ae\u1235 \u12ac\u120a\u1295\u130d \u12f0\u1234\u1276\u127d'),'tk':'Kokos (Kiling) adalary','tl':'*en','tn':'*aa','to':u('\u02bbOtumotu Koko'),'tr':u('Cocos (Keeling) Adalar\u0131'),'ts':'*aa','tt':u('\u041a\u043e\u043a\u043e\u0441 (\u041a\u0438\u043b\u0438\u043d\u0433) \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0643\u0648\u0643\u0648\u0633 (\u0643\u0649\u0644\u0649\u06ad) \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649'),'uk':u('\u041a\u043e\u043a\u043e\u0441\u043e\u0432\u0456 (\u041a\u0456\u043b\u0456\u043d\u0433\u043e\u0432\u0456) \u043e\u0441\u0442\u0440\u043e\u0432\u0438'),'ur':u('\u06a9\u0648\u06a9\u0648\u0633 (\u06a9\u06cc\u0644\u0646\u06af) \u062c\u0632\u0627\u0626\u0631'),'uz':'Kokos (Kiling) orollari','ve':'*aa','vi':u('Qu\u1ea7n \u0111\u1ea3o Cocos (Keeling)'),'vo':'*aa','wa':'*aa','wo':'Duni Koko (Kilin)','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u79d1\u79d1\u65af\uff08\u57fa\u6797\uff09\u7fa4\u5c9b'),'zu':'i-Cocos (Keeling) Islands',},
  'CD': {'aa':'The Democratic Republic Of Congo','ab':'*aa','ae':'*aa','af':'Demokratiese Republiek van die Kongo','ak':'Kongo (Zair)','am':u('\u12ae\u1295\u130e-\u12aa\u1295\u123b\u1233'),'an':'*aa','ar':u('\u0627\u0644\u0643\u0648\u0646\u063a\u0648 - \u0643\u064a\u0646\u0634\u0627\u0633\u0627'),'as':u('\u0995\u0999\u09cd\u0997\u09cb - \u0995\u09bf\u09a8\u099a\u09be\u099b\u09be'),'av':'*aa','ay':'*aa','az':u('Konqo - Kin\u015fasa'),'ba':'*aa','be':u('\u041a\u043e\u043d\u0433\u0430 (\u041a\u0456\u043d\u0448\u0430\u0441\u0430)'),'bg':u('\u041a\u043e\u043d\u0433\u043e (\u041a\u0438\u043d\u0448\u0430\u0441\u0430)'),'bh':'*aa','bi':'*aa','bm':u('Kongo ka republiki dem\u0254kratiki'),'bn':u('\u0995\u0999\u09cd\u0997\u09cb-\u0995\u09bf\u09a8\u09b6\u09be\u09b8\u09be'),'bo':'*aa','br':'Kongo - Kinshasa','bs':'Demokratska Republika Kongo','ca':'Congo - Kinshasa','ce':u('\u0414\u0435\u043c\u043e\u043a\u0440\u0430\u0442\u0438\u043d \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u043e\u043d\u0433\u043e'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Kongo \u2013 Kinshasa'),'cu':'*aa','cv':'*aa','cy':'Y Congo - Kinshasa','da':'Congo-Kinshasa','de':'Kongo-Kinshasa','dv':'*aa','dz':u('\u0f40\u0f7c\u0f44\u0f0b\u0f42\u0fb7\u0f7c \u0f40\u0f72\u0f53\u0f0b\u0f64\u0f0b\u0f66'),'ee':'Kongo Kinshasa nutome','el':u('\u039a\u03bf\u03bd\u03b3\u03ba\u03cc - \u039a\u03b9\u03bd\u03c3\u03ac\u03c3\u03b1'),'en':'*ca','eo':'*aa','es':u('Rep\u00fablica Democr\u00e1tica del Congo'),'et':'Kongo DV','eu':'Kongoko Errepublika Demokratikoa','fa':u('\u06a9\u0646\u06af\u0648 - \u06a9\u06cc\u0646\u0634\u0627\u0633\u0627'),'ff':'Ndenndaandi Demokaraasiire Konngo','fi':'Kongon demokraattinen tasavalta','fj':'*aa','fo':u('Kongo, Dem. L\u00fd\u00f0veldi\u00f0'),'fr':'*da','fy':'*da','ga':u('Poblacht Dhaonlathach an Chong\u00f3'),'gd':'*ca','gl':u('Rep\u00fablica Democr\u00e1tica do Congo'),'gn':'*aa','gu':u('\u0a95\u0acb\u0a82\u0a97\u0acb - \u0a95\u0abf\u0a82\u0ab6\u0abe\u0ab8\u0abe'),'gv':'*aa','ha':u('Jamhuriyar Dimokura\u0257iyyar Kongo'),'he':u('\u05e7\u05d5\u05e0\u05d2\u05d5 - \u05e7\u05d9\u05e0\u05e9\u05d0\u05e1\u05d4'),'hi':u('\u0915\u093e\u0902\u0917\u094b - \u0915\u093f\u0902\u0936\u093e\u0938\u093e'),'ho':'*aa','hr':'*br','ht':'*aa','hu':u('Kong\u00f3 - Kinshasa'),'hy':u('\u053f\u0578\u0576\u0563\u0578 - \u053f\u056b\u0576\u0577\u0561\u057d\u0561'),'hz':'*aa','ia':'*aa','id':'*br','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*br','io':'*aa','is':u('Kong\u00f3-Kinshasa'),'it':'*ca','iu':'*aa','iw':'*he','ja':u('\u30b3\u30f3\u30b4\u6c11\u4e3b\u5171\u548c\u56fd(\u30ad\u30f3\u30b7\u30e3\u30b5)'),'ji':u('\u05e7\u05d0\u05e0\u05d2\u05d0\u05be\u05e7\u05d9\u05e0\u05e9\u05d0\u05b7\u05d6\u05e2'),'jv':'*aa','ka':u('\u10d9\u10dd\u10dc\u10d2\u10dd - \u10d9\u10d8\u10dc\u10e8\u10d0\u10e1\u10d0'),'kg':'*aa','ki':'Jamhuri ya Kidemokrasia ya Kongo','kj':'*aa','kk':u('\u041a\u043e\u043d\u0433\u043e'),'kl':'*aa','km':u('\u1780\u17bb\u1784\u17a0\u17d2\u1782\u17c4- \u1782\u17b8\u1793\u179f\u17d2\u17a0\u17b6\u179f\u17b6'),'kn':u('\u0c95\u0cbe\u0c82\u0c97\u0ccb - \u0c95\u0cbf\u0ca8\u0ccd\u0cb6\u0cbe\u0cb8\u0cbe'),'ko':u('\ucf69\uace0-\ud0a8\uc0e4\uc0ac'),'kr':'*aa','ks':u('\u06a9\u0648\u0646\u065b\u06af\u0648 \u06a9\u0650\u0646\u0634\u0627\u0633\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u041a\u043e\u043d\u0433\u043e-\u041a\u0438\u043d\u0448\u0430\u0441\u0430'),'la':'*aa','lb':'*de','lg':'Kongo - Zayire','li':'*aa','ln':u('Republ\u00edki ya Kong\u00f3 Demokrat\u00edki'),'lo':u('\u0e84\u0ead\u0e87\u0ec2\u0e81 - \u0e84\u0eb4\u0e99\u0e8a\u0eb2\u0e8a\u0eb2'),'lt':u('Kongas-Kin\u0161asa'),'lu':'Ditunga wa Kongu','lv':u('Kongo (Kin\u0161asa)'),'mg':u('Repoblikan\u2019i Kongo'),'mh':'*aa','mi':'*aa','mk':u('\u041a\u043e\u043d\u0433\u043e - \u041a\u0438\u043d\u0448\u0430\u0441\u0430'),'ml':u('\u0d15\u0d4b\u0d02\u0d17\u0d4b - \u0d15\u0d3f\u0d7b\u0d37\u0d3e\u0d38'),'mn':'*ky','mo':'*ca','mr':u('\u0915\u093e\u0901\u0917\u094b - \u0915\u093f\u0902\u0936\u093e\u0938\u093e'),'ms':'*ca','mt':'ir-Repubblika Demokratika tal-Kongo','my':u('\u1000\u103d\u1014\u103a\u1002\u102d\u102f'),'na':'*aa','nb':'*de','nd':'Democratic Republic of the Congo','ne':u('\u0915\u0919\u094d\u0917\u094b - \u0915\u093f\u0928\u094d\u0936\u093e\u0938\u093e'),'ng':'*aa','nl':'*da','nn':'*de','no':'*de','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b19\u0b4d\u0b17\u0b4b-\u0b15\u0b3f\u0b28\u0b38\u0b3e\u0b38\u0b3e'),'os':'*aa','pa':u('\u0a15\u0a3e\u0a02\u0a17\u0a4b - \u0a15\u0a3f\u0a70\u0a38\u0a3c\u0a3e\u0a38\u0a3e'),'pi':'*aa','pl':'Demokratyczna Republika Konga','ps':u('\u06a9\u0627\u0646\u06ab\u0648 - \u06a9\u06cc\u0646\u0634\u0627\u0633\u0627'),'pt':'*ca','qu':'Congo (RDC)','rm':'Republica Democratica dal Congo','rn':'Repubulika Iharanira Demokarasi ya Kongo','ro':'*ca','ru':'*mk','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u0627\u0646\u06af\u0648 -\u06aa\u0646\u0634\u0627\u0633\u0627'),'se':'*de','sg':u('K\u00f6d\u00f6r\u00f6s\u00ease t\u00ee Ngunuhal\u00ebzo t\u00ee kong\u00f6'),'si':u('\u0d9a\u0ddc\u0d82\u0d9c\u0ddc - \u0d9a\u0dd2\u0db1\u0dca\u0dc1\u0dcf\u0dc3\u0dcf'),'sk':u('Kon\u017esk\u00e1 demokratick\u00e1 republika'),'sl':u('Demokrati\u010dna republika Kongo'),'sm':'*aa','sn':'*nd','so':'Jamhuuriyadda Dimuquraadiga Kongo','sq':'*de','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*ki','ta':u('\u0b95\u0bbe\u0b99\u0bcd\u0b95\u0bcb - \u0b95\u0bbf\u0ba9\u0bcd\u0bb7\u0bbe\u0b9a\u0bbe'),'te':u('\u0c15\u0c3e\u0c02\u0c17\u0c4b- \u0c15\u0c3f\u0c28\u0c4d\u0c37\u0c3e\u0c38\u0c3e'),'tg':'*aa','th':u('\u0e04\u0e2d\u0e07\u0e42\u0e01 - \u0e01\u0e34\u0e19\u0e0a\u0e32\u0e0b\u0e32'),'ti':u('\u12ae\u1295\u130e'),'tk':u('Kongo - Kin\u015fasa'),'tl':'*ca','tn':'*aa','to':'Kongo - Kinisasa','tr':'*tk','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':u('\u0643\u0648\u0646\u06af\u0648 - \u0643\u0649\u0646\u0634\u0627\u0633\u0627'),'uk':u('\u041a\u043e\u043d\u0433\u043e \u2013 \u041a\u0456\u043d\u0448\u0430\u0441\u0430'),'ur':u('\u06a9\u0627\u0646\u06af\u0648 - \u06a9\u0646\u0634\u0627\u0633\u0627'),'uz':'*cs','ve':'*aa','vi':'*ca','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*ji','yo':u('Oril\u1eb9\u0301\u00e8de K\u00f3ng\u00f2'),'za':'*aa','zh':u('\u521a\u679c\uff08\u91d1\uff09'),'zu':'i-Congo - Kinshasa',},
  'CF': {'aa':'Central African Republic','ab':'*aa','ae':'*aa','af':'Sentraal-Afrikaanse Republiek','ak':'Afrika Finimfin Man','am':u('\u12e8\u1218\u12ab\u12a8\u1208\u129b\u12cd \u12a0\u134d\u122a\u12ab \u122a\u1350\u1265\u120a\u12ad'),'an':'*aa','ar':u('\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0623\u0641\u0631\u064a\u0642\u064a\u0627 \u0627\u0644\u0648\u0633\u0637\u0649'),'as':u('\u09ae\u09a7\u09cd\u09af \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be\u09a8 \u09aa\u09cd\u09b0\u099c\u09be\u09a4\u09a8\u09cd\u09a4\u09cd\u09b0'),'av':'*aa','ay':'*aa','az':u('M\u0259rk\u0259zi Afrika Respublikas\u0131'),'ba':'*aa','be':u('\u0426\u044d\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430-\u0410\u0444\u0440\u044b\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u044d\u0441\u043f\u0443\u0431\u043b\u0456\u043a\u0430'),'bg':u('\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u0440\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430'),'bh':'*aa','bi':'*aa','bm':'Santarafiriki','bn':u('\u09ae\u09a7\u09cd\u09af \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be\u09b0 \u09aa\u09cd\u09b0\u099c\u09be\u09a4\u09a8\u09cd\u09a4\u09cd\u09b0'),'bo':'*aa','br':'Republik Kreizafrikan','bs':u('Centralnoafri\u010dka Republika'),'ca':u('Rep\u00fablica Centreafricana'),'ce':u('\u042e\u043a\u043a\u044a\u0435\u0440\u0447\u0443 \u0410\u0444\u0440\u0438\u043a\u0438\u043d \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('St\u0159edoafrick\u00e1 republika'),'cu':'*aa','cv':'*aa','cy':'Gweriniaeth Canolbarth Affrica','da':'Den Centralafrikanske Republik','de':'Zentralafrikanische Republik','dv':'*aa','dz':u('\u0f66\u0f7a\u0f53\u0f0b\u0f4a\u0f63\u0f0b \u0f68\u0f55\u0f0b\u0f62\u0f72\u0f0b\u0f40\u0f71\u0f53\u0f0b \u0f62\u0f72\u0f0b\u0f54\u0f56\u0f0b\u0f63\u0f72\u0f40'),'ee':u('Titina Afrika rep\u0254blik nutome'),'el':u('\u039a\u03b5\u03bd\u03c4\u03c1\u03bf\u03b1\u03c6\u03c1\u03b9\u03ba\u03b1\u03bd\u03b9\u03ba\u03ae \u0394\u03b7\u03bc\u03bf\u03ba\u03c1\u03b1\u03c4\u03af\u03b1'),'en':'*aa','eo':'Centr-Afrika Respubliko','es':u('Rep\u00fablica Centroafricana'),'et':'Kesk-Aafrika Vabariik','eu':'Afrika Erdiko Errepublika','fa':u('\u062c\u0645\u0647\u0648\u0631\u06cc \u0627\u0641\u0631\u06cc\u0642\u0627\u06cc \u0645\u0631\u06a9\u0632\u06cc'),'ff':'Ndenndaandi Santarafrik','fi':'Keski-Afrikan tasavalta','fj':'*aa','fo':u('Mi\u00f0afrikal\u00fd\u00f0veldi\u00f0'),'fr':u('R\u00e9publique centrafricaine'),'fy':'Sintraal-Afrikaanske Republyk','ga':u('Poblacht na hAfraice L\u00e1ir'),'gd':'Poblachd Meadhan Afraga','gl':'*es','gn':'*aa','gu':u('\u0ab8\u0ac7\u0aa8\u0acd\u0a9f\u0acd\u0ab0\u0ab2 \u0a86\u0aab\u0acd\u0ab0\u0abf\u0a95\u0aa8 \u0ab0\u0abf\u0aaa\u0aac\u0acd\u0ab2\u0abf\u0a95'),'gv':'*aa','ha':'Jamhuriyar Afirka Ta Tsakiya','he':u('\u05d4\u05e8\u05e4\u05d5\u05d1\u05dc\u05d9\u05e7\u05d4 \u05d4\u05de\u05e8\u05db\u05d6-\u05d0\u05e4\u05e8\u05d9\u05e7\u05d0\u05d9\u05ea'),'hi':u('\u092e\u0927\u094d\u092f \u0905\u092b\u093c\u094d\u0930\u0940\u0915\u0940 \u0917\u0923\u0930\u093e\u091c\u094d\u092f'),'ho':'*aa','hr':u('Srednjoafri\u010dka Republika'),'ht':'*aa','hu':u('K\u00f6z\u00e9p-afrikai K\u00f6zt\u00e1rsas\u00e1g'),'hy':u('\u053f\u0565\u0576\u057f\u0580\u0578\u0576\u0561\u056f\u0561\u0576 \u0531\u0586\u0580\u056b\u056f\u0575\u0561\u0576 \u0540\u0561\u0576\u0580\u0561\u057a\u0565\u057f\u0578\u0582\u0569\u0575\u0578\u0582\u0576'),'hz':'*aa','ia':'*aa','id':'Republik Afrika Tengah','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Mi\u00f0-Afr\u00edkul\u00fd\u00f0veldi\u00f0'),'it':'Repubblica Centrafricana','iu':'*aa','iw':'*he','ja':u('\u4e2d\u592e\u30a2\u30d5\u30ea\u30ab\u5171\u548c\u56fd'),'ji':u('\u05e6\u05e2\u05e0\u05d8\u05e8\u05d0\u05b7\u05dc\u05be\u05d0\u05b7\u05e4\u05bf\u05e8\u05d9\u05e7\u05d0\u05b7\u05e0\u05d9\u05e9\u05e2 \u05e8\u05e2\u05e4\u05bc\u05d5\u05d1\u05dc\u05d9\u05e7'),'jv':'*aa','ka':u('\u10ea\u10d4\u10dc\u10e2\u10e0\u10d0\u10da\u10e3\u10e0\u10d8 \u10d0\u10e4\u10e0\u10d8\u10d9\u10d8\u10e1 \u10e0\u10d4\u10e1\u10de\u10e3\u10d1\u10da\u10d8\u10d9\u10d0'),'kg':'*aa','ki':'Jamhuri ya Afrika ya Kati','kj':'*aa','kk':u('\u041e\u0440\u0442\u0430\u043b\u044b\u049b \u0410\u0444\u0440\u0438\u043a\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u044b'),'kl':'*aa','km':u('\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1780\u178e\u17d2\u178a\u17b6\u179b'),'kn':u('\u0cae\u0ca7\u0ccd\u0caf \u0c86\u0cab\u0ccd\u0cb0\u0cbf\u0c95\u0cbe \u0c97\u0ca3\u0cb0\u0cbe\u0c9c\u0ccd\u0caf'),'ko':u('\uc911\uc559 \uc544\ud504\ub9ac\uce74 \uacf5\ud654\uad6d'),'kr':'*aa','ks':u('\u0645\u0631\u06a9\u0654\u0632\u06cc \u0627\u064e\u0641\u0631\u06cc\u0656\u06a9\u06cc \u062c\u0645\u0648\u0657\u0631\u06cc\u064e\u062a'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0411\u043e\u0440\u0431\u043e\u0440\u0434\u0443\u043a \u0410\u0444\u0440\u0438\u043a\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u044b'),'la':'*aa','lb':'Zentralafrikanesch Republik','lg':'Lipubulika eya Senturafiriki','li':'*aa','ln':u('Repibiki ya Afr\u00edka ya K\u00e1ti'),'lo':u('\u0eaa\u0eb2\u0e97\u0eb2\u0ea5\u0eb0\u0e99\u0eb0\u0ea5\u0eb1\u0e94\u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2\u0e81\u0eb2\u0e87'),'lt':u('Centrin\u0117s Afrikos Respublika'),'lu':'Ditunga dya Afrika wa munkatshi','lv':u('Centr\u0101l\u0101frikas Republika'),'mg':u('Repoblika Ivon\u2019Afrika'),'mh':'*aa','mi':'*aa','mk':u('\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u0420\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430'),'ml':u('\u0d38\u0d46\u0d7b\u0d1f\u0d4d\u0d30\u0d7d \u0d06\u0d2b\u0d4d\u0d30\u0d3f\u0d15\u0d4d\u0d15\u0d7b \u0d31\u0d3f\u0d2a\u0d4d\u0d2a\u0d2c\u0d4d\u0d32\u0d3f\u0d15\u0d4d\u0d15\u0d4d'),'mn':u('\u0422\u04e9\u0432 \u0410\u0444\u0440\u0438\u043a\u0438\u0439\u043d \u0411\u04af\u0433\u0434 \u041d\u0430\u0439\u0440\u0430\u043c\u0434\u0430\u0445 \u0423\u043b\u0441'),'mo':u('Republica Centrafrican\u0103'),'mr':u('\u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u0905\u092b\u094d\u0930\u093f\u0915\u0940 \u092a\u094d\u0930\u091c\u093e\u0938\u0924\u094d\u0924\u093e\u0915'),'ms':'*id','mt':u('ir-Repubblika \u010aentru-Afrikana'),'my':u('\u1017\u101f\u102d\u102f \u1021\u102c\u1016\u101b\u102d\u1000 \u1015\u103c\u100a\u103a\u1011\u1031\u102c\u1004\u103a\u1005\u102f'),'na':'*aa','nb':'Den sentralafrikanske republikk','nd':'*aa','ne':u('\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u0905\u092b\u094d\u0930\u093f\u0915\u0940 \u0917\u0923\u0924\u0928\u094d\u0924\u094d\u0930'),'ng':'*aa','nl':'Centraal-Afrikaanse Republiek','nn':'Den sentralafrikanske republikken','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b27\u0b4d\u0b5f \u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b40\u0b5f \u0b38\u0b3e\u0b27\u0b3e\u0b30\u0b23\u0b24\u0b28\u0b4d\u0b24\u0b4d\u0b30'),'os':'*aa','pa':u('\u0a15\u0a47\u0a02\u0a26\u0a30\u0a40 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a40 \u0a17\u0a23\u0a30\u0a3e\u0a1c'),'pi':'*aa','pl':u('Republika \u015arodkowoafryka\u0144ska'),'ps':u('\u062f \u0645\u0631\u06a9\u0632\u064a \u0627\u0641\u0631\u06cc\u0642\u0627 \u062c\u0645\u0647\u0648\u0631\u06cc\u062a'),'pt':u('Rep\u00fablica Centro-Africana'),'qu':'*aa','rm':'Republica Centralafricana','rn':'Repubulika ya Santarafurika','ro':'*mo','ru':u('\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e-\u0410\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0648\u0686 \u0622\u0641\u0631\u064a\u0642\u064a \u062c\u0645\u0647\u0648\u0631\u064a\u0647'),'se':u('Gaska-Afrihk\u00e1 d\u00e1ssev\u00e1ldi'),'sg':u('K\u00f6d\u00f6r\u00f6s\u00ease t\u00ee B\u00eaafr\u00eeka'),'si':u('\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0da2\u0db1\u0dbb\u0da2\u0dba'),'sk':u('Stredoafrick\u00e1 republika'),'sl':u('Centralnoafri\u0161ka republika'),'sm':'*aa','sn':'*aa','so':'Jamhuuriyadda Afrikada Dhexe','sq':u('Republika e Afrik\u00ebs Qendrore'),'sr':u('\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e\u0430\u0444\u0440\u0438\u0447\u043a\u0430 \u0420\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Centralafrikanska republiken','sw':'*ki','ta':u('\u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b86\u0baa\u0bcd\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0b95\u0bcd \u0b95\u0bc1\u0b9f\u0bbf\u0baf\u0bb0\u0b9a\u0bc1'),'te':u('\u0c38\u0c46\u0c02\u0c1f\u0c4d\u0c30\u0c32\u0c4d \u0c06\u0c2b\u0c4d\u0c30\u0c3f\u0c15\u0c28\u0c4d \u0c30\u0c3f\u0c2a\u0c2c\u0c4d\u0c32\u0c3f\u0c15\u0c4d'),'tg':u('\u04b6\u0443\u043c\u04b3\u0443\u0440\u0438\u0438 \u0410\u0444\u0440\u0438\u049b\u043e\u0438 \u041c\u0430\u0440\u043a\u0430\u0437\u04e3'),'th':u('\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e41\u0e2d\u0e1f\u0e23\u0e34\u0e01\u0e32\u0e01\u0e25\u0e32\u0e07'),'ti':u('\u121b\u12a5\u12a8\u120b\u12ed \u12a3\u134d\u122a\u1243 \u122a\u1353\u1265\u120a\u12ad'),'tk':'Orta Afrika Respublikasy','tl':'*aa','tn':'*aa','to':u('Lepupelika \u02bbAfilika Lotoloto'),'tr':'Orta Afrika Cumhuriyeti','ts':'*aa','tt':u('\u04ae\u0437\u04d9\u043a \u0410\u0444\u0440\u0438\u043a\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u0626\u0627\u0641\u0631\u0649\u0642\u0627 \u062c\u06c7\u0645\u06be\u06c7\u0631\u0649\u064a\u0649\u062a\u0649'),'uk':u('\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0456\u043a\u0430'),'ur':u('\u0648\u0633\u0637 \u0627\u0641\u0631\u06cc\u0642\u06cc \u062c\u0645\u06c1\u0648\u0631\u06cc\u06c1'),'uz':'Markaziy Afrika Respublikasi','ve':'*aa','vi':u('C\u1ed9ng h\u00f2a Trung Phi'),'vo':'*aa','wa':'*aa','wo':u('Repiblik S\u00e0ntar Afrik'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de \u00c0rin g\u00f9ngun \u00c1f\u00edr\u00edk\u00e0'),'za':'*aa','zh':u('\u4e2d\u975e\u5171\u548c\u56fd'),'zu':'i-Central African Republic',},
  'CG': {'aa':'Congo','ab':'*aa','ae':'*aa','af':'Kongo - Brazzaville','ak':'Kongo','am':u('\u12ae\u1295\u130e \u1265\u122b\u12db\u126a\u120d'),'an':'*aa','ar':u('\u0627\u0644\u0643\u0648\u0646\u063a\u0648 - \u0628\u0631\u0627\u0632\u0627\u0641\u064a\u0644'),'as':u('\u0995\u0999\u09cd\u0997\u09cb - \u09ac\u09cd\u09b0\u09be\u099c\u09be\u09ad\u09bf\u09b2'),'av':'*aa','ay':'*aa','az':'Konqo - Brazzavil','ba':'*aa','be':u('\u041a\u043e\u043d\u0433\u0430 - \u0411\u0440\u0430\u0437\u0430\u0432\u0456\u043b\u044c'),'bg':u('\u041a\u043e\u043d\u0433\u043e (\u0411\u0440\u0430\u0437\u0430\u0432\u0438\u043b)'),'bh':'*aa','bi':'*aa','bm':'*ak','bn':'*as','bo':'*aa','br':'*af','bs':'*ak','ca':'Congo - Brazzaville','ce':u('\u041a\u043e\u043d\u0433\u043e - \u0411\u0440\u0430\u0437\u0437\u0430\u0432\u0438\u043b\u044c'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Kongo \u2013 Brazzaville'),'cu':'*aa','cv':'*aa','cy':'Y Congo - Brazzaville','da':'Congo-Brazzaville','de':'Kongo-Brazzaville','dv':'*aa','dz':u('\u0f40\u0f7c\u0f44\u0f0b\u0f42\u0fb7\u0f7c \u0f56\u0fb7\u0fb2\u0f0b\u0f5b\u0f0b\u0f56\u0f72\u0f63'),'ee':'Kongo Brazzaville nutome','el':u('\u039a\u03bf\u03bd\u03b3\u03ba\u03cc - \u039c\u03c0\u03c1\u03b1\u03b6\u03b1\u03b2\u03af\u03bb'),'en':'*ca','eo':'Kongolo','es':u('Rep\u00fablica del Congo'),'et':'Kongo Vabariik','eu':'*ak','fa':u('\u06a9\u0646\u06af\u0648 - \u0628\u0631\u0627\u0632\u0648\u06cc\u0644'),'ff':'Konngo','fi':'Kongon tasavalta','fj':'*aa','fo':'*ak','fr':'*da','fy':'*da','ga':u('an Cong\u00f3'),'gd':u('A\u2019 Chongo - Brazzaville'),'gl':u('Rep\u00fablica do Congo'),'gn':'*aa','gu':u('\u0a95\u0acb\u0a82\u0a97\u0acb - \u0aac\u0acd\u0ab0\u0abe\u0a9d\u0abe\u0ab5\u0abf\u0ab2\u0ac7'),'gv':'*aa','ha':'*ak','he':u('\u05e7\u05d5\u05e0\u05d2\u05d5 - \u05d1\u05e8\u05d6\u05d0\u05d5\u05d9\u05dc'),'hi':u('\u0915\u093e\u0902\u0917\u094b \u2013 \u092c\u094d\u0930\u093e\u091c\u093c\u093e\u0935\u093f\u0932'),'ho':'*aa','hr':'*af','ht':'*aa','hu':u('Kong\u00f3 - Brazzaville'),'hy':u('\u053f\u0578\u0576\u0563\u0578 - \u0532\u0580\u0561\u0566\u0561\u057e\u056b\u056c'),'hz':'*aa','ia':'*aa','id':'*af','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*af','io':'*aa','is':u('Kong\u00f3-Brazzaville'),'it':'*da','iu':'*aa','iw':'*he','ja':u('\u30b3\u30f3\u30b4\u5171\u548c\u56fd(\u30d6\u30e9\u30b6\u30d3\u30eb)'),'ji':'*aa','jv':'*aa','ka':u('\u10d9\u10dd\u10dc\u10d2\u10dd - \u10d1\u10e0\u10d0\u10d6\u10d0\u10d5\u10d8\u10da\u10d8'),'kg':'*aa','ki':'*ak','kj':'*aa','kk':u('\u041a\u043e\u043d\u0433\u043e-\u0411\u0440\u0430\u0437\u0437\u0430\u0432\u0438\u043b\u044c \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u044b'),'kl':'*aa','km':u('\u1780\u17bb\u1784\u17a0\u17d2\u1782\u17c4 - \u1794\u17d2\u179a\u17b6\u17a0\u17d2\u179f\u17b6\u179c\u17b8\u179b'),'kn':u('\u0c95\u0cbe\u0c82\u0c97\u0ccb - \u0cac\u0ccd\u0cb0\u0cbe\u0c9c\u0cbe\u0cb5\u0cbf\u0cb2\u0ccd\u0cb2\u0cc7'),'ko':u('\ucf69\uace0-\ube0c\ub77c\uc790\ube4c'),'kr':'*aa','ks':u('\u06a9\u0648\u0646\u065b\u06af\u0648 \u0628\u0654\u0631\u065b\u0632\u0627\u0648\u0650\u0644\u06cc'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u041a\u043e\u043d\u0433\u043e-\u0411\u0440\u0430\u0437\u0437\u0430\u0432\u0438\u043b'),'la':'*aa','lb':'*de','lg':'*ak','li':'*aa','ln':'*ak','lo':u('\u0e84\u0ead\u0e87\u0ec2\u0e81 - \u0e9a\u0ea3\u0eb2\u0e8a\u0eb2\u0ea7\u0eb4\u0ea7'),'lt':'Kongas-Brazavilis','lu':'Kongu','lv':'Kongo (Brazavila)','mg':u('K\u00f4ng\u00f4'),'mh':'*aa','mi':'*aa','mk':u('\u041a\u043e\u043d\u0433\u043e - \u0411\u0440\u0430\u0437\u0430\u0432\u0438\u043b'),'ml':u('\u0d15\u0d4b\u0d02\u0d17\u0d4b - \u0d2c\u0d4d\u0d30\u0d3e\u0d38\u0d35\u0d3f\u0d32\u0d4d\u0d32\u0d3f'),'mn':u('\u041a\u043e\u043d\u0433\u043e \u0411\u0440\u0430\u0437\u0437\u0430\u0432\u0438\u043b\u044c'),'mo':'*ca','mr':u('\u0915\u093e\u0901\u0917\u094b - \u092c\u094d\u0930\u093e\u091d\u093e\u0935\u093f\u0932\u0947'),'ms':'*ca','mt':'il-Kongo - Brazzaville','my':u('\u1000\u103d\u1014\u103a\u1002\u102d\u102f-\u1018\u101b\u102c\u1007\u102c\u1017\u102e\u1038\u101c\u103a'),'na':'*aa','nb':'*de','nd':'Khongo','ne':u('\u0915\u0919\u094d\u0917\u094b \u092c\u094d\u0930\u093e\u091c\u093e\u092d\u093f\u0932'),'ng':'*aa','nl':'*da','nn':'*de','no':'*de','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b19\u0b4d\u0b17\u0b4b-\u0b2c\u0b4d\u0b30\u0b3e\u0b1c\u0b3f\u0b2d\u0b3f\u0b32\u0b4d\u0b32\u0b47'),'os':'*aa','pa':u('\u0a15\u0a3e\u0a02\u0a17\u0a4b - \u0a2c\u0a4d\u0a30\u0a3e\u0a1c\u0a3c\u0a3e\u0a35\u0a3f\u0a32\u0a47'),'pi':'*aa','pl':'*ak','ps':u('\u06a9\u0627\u0646\u06ab\u0648 - \u0628\u0631\u0648\u0632\u0648\u06cc\u06cc\u0644'),'pt':'*ca','qu':'*aa','rm':'*aa','rn':'*ak','ro':'*ca','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u0627\u0646\u06af\u0648 - \u0628\u0631\u0627\u0632\u0627\u0648\u06cc\u0644'),'se':'*de','sg':u('Kong\u00f6'),'si':u('\u0d9a\u0ddc\u0d82\u0d9c\u0ddc - \u0db6\u0dca\u200d\u0dbb\u0dc3\u0dcf\u0dc0\u0dd2\u0dbd\u0dca'),'sk':u('Kon\u017esk\u00e1 republika'),'sl':'*af','sm':'*aa','sn':'*ak','so':'*ak','sq':u('Kongo-Brazavil\u00eb'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*af','ta':u('\u0b95\u0bbe\u0b99\u0bcd\u0b95\u0bcb - \u0baa\u0bcd\u0bb0\u0bbe\u0bb8\u0bbe\u0bb5\u0bbf\u0bb2\u0bcd\u0bb2\u0bc7'),'te':u('\u0c15\u0c3e\u0c02\u0c17\u0c4b- \u0c2c\u0c4d\u0c30\u0c3e\u0c1c\u0c3e\u0c35\u0c3f\u0c32\u0c4d\u0c32\u0c3f'),'tg':'*aa','th':u('\u0e04\u0e2d\u0e07\u0e42\u0e01 - \u0e1a\u0e23\u0e32\u0e0b\u0e0b\u0e32\u0e27\u0e34\u0e25'),'ti':u('\u12ae\u1295\u130e \u122a\u1353\u1265\u120a\u12ad'),'tk':'Kongo - Brazzawil','tl':'*ca','tn':'*aa','to':'Kongo - Palasavila','tr':'Kongo - Brazavil','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':u('\u0643\u0648\u0646\u06af\u0648 - \u0628\u0649\u0631\u0627\u0632\u0632\u0627\u06cb\u0649\u0644'),'uk':u('\u041a\u043e\u043d\u0433\u043e \u2013 \u0411\u0440\u0430\u0437\u0437\u0430\u0432\u0456\u043b\u044c'),'ur':u('\u06a9\u0627\u0646\u06af\u0648 - \u0628\u0631\u0627\u0632\u0627\u0648\u06cc\u0644\u06d2'),'uz':u('Kongo \u2013 Brazzavil'),'ve':'*aa','vi':'*ca','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de K\u00f3ng\u00f2'),'za':'*aa','zh':u('\u521a\u679c\uff08\u5e03\uff09'),'zu':'i-Congo - Brazzaville',},
  'CH': {'aa':'Switzerland','ab':'*aa','ae':'*aa','af':'Switserland','ak':'Swetzaland','am':u('\u1235\u12ca\u12d8\u122d\u120b\u1295\u12f5'),'an':'*aa','ar':u('\u0633\u0648\u064a\u0633\u0631\u0627'),'as':u('\u099a\u09c1\u0987\u099c\u09be\u09f0\u09b2\u09c7\u09a3\u09cd\u09a1'),'av':'*aa','ay':'*aa','az':u('\u0130sve\u00e7r\u0259'),'ba':'*aa','be':u('\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u044b\u044f'),'bg':u('\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Suwisi','bn':u('\u09b8\u09c1\u0987\u099c\u09be\u09b0\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1'),'bo':'*aa','br':'Suis','bs':u('\u0160vicarska'),'ca':u('Su\u00efssa'),'ce':u('\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('\u0160v\u00fdcarsko'),'cu':'*aa','cv':'*aa','cy':'Y Swistir','da':'Schweiz','de':'*da','dv':'*aa','dz':u('\u0f66\u0f74\u0f0b\u0f5d\u0f72\u0f4a\u0f0b\u0f5b\u0f62\u0f0b\u0f63\u0f7a\u0f53\u0f4c'),'ee':'Switzerland nutome','el':u('\u0395\u03bb\u03b2\u03b5\u03c4\u03af\u03b1'),'en':'*aa','eo':'Svisujo','es':'Suiza','et':u('\u0160veits'),'eu':'Suitza','fa':u('\u0633\u0648\u0626\u06cc\u0633'),'ff':'Suwiis','fi':'Sveitsi','fj':'*aa','fo':'Sveis','fr':'Suisse','fy':u('Switserl\u00e2n'),'ga':u('an Eilv\u00e9is'),'gd':'An Eilbheis','gl':u('Su\u00edza'),'gn':'*aa','gu':u('\u0ab8\u0acd\u0ab5\u0abf\u0a9f\u0acd\u0a9d\u0ab0\u0acd\u0ab2\u0ac5\u0aa8\u0acd\u0aa1'),'gv':'*aa','ha':'Suwizalan','he':u('\u05e9\u05d5\u05d5\u05d9\u05d9\u05e5'),'hi':u('\u0938\u094d\u0935\u093f\u091f\u094d\u091c\u093c\u0930\u0932\u0948\u0902\u0921'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Sv\u00e1jc'),'hy':u('\u0547\u057e\u0565\u0575\u0581\u0561\u0580\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'Swiss','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'Sviss','it':'Svizzera','iu':'*aa','iw':'*he','ja':u('\u30b9\u30a4\u30b9'),'ji':'*he','jv':'*aa','ka':u('\u10e8\u10d5\u10d4\u10d8\u10ea\u10d0\u10e0\u10d8\u10d0'),'kg':'*aa','ki':'Uswisi','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u179f\u17d2\u179c\u17b8\u179f'),'kn':u('\u0cb8\u0ccd\u0cb5\u0cbf\u0c9f\u0ccd\u0c9c\u0cb0\u0ccd\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd'),'ko':u('\uc2a4\uc704\uc2a4'),'kr':'*aa','ks':u('\u0633\u064f\u0648\u0650\u0632\u064e\u0631\u0644\u06cc\u0646\u065b\u0691'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':u('Schw\u00e4iz'),'lg':'Switizirandi','li':'*aa','ln':u('Swis\u025b'),'lo':u('\u0eaa\u0eb0\u0ea7\u0eb4\u0e94\u0ec0\u0e8a\u0eb5\u0ec1\u0ea5\u0e99'),'lt':u('\u0160veicarija'),'lu':'Swise','lv':u('\u0160veice'),'mg':'Soisa','mh':'*aa','mi':'*aa','mk':u('\u0428\u0432\u0430\u0458\u0446\u0430\u0440\u0438\u0458\u0430'),'ml':u('\u0d38\u0d4d\u0d35\u0d3f\u0d31\u0d4d\u0d31\u0d4d\u0d38\u0d7c\u0d32\u0d3e\u0d7b\u0d21\u0d4d'),'mn':u('\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u044c'),'mo':u('Elve\u021bia'),'mr':u('\u0938\u094d\u0935\u093f\u0924\u094d\u091d\u0930\u094d\u0932\u0902\u0921'),'ms':'*aa','mt':u('\u017bvizzera'),'my':u('\u1006\u103d\u1005\u103a\u1007\u102c\u101c\u1014\u103a'),'na':'*aa','nb':'Sveits','nd':'*aa','ne':u('\u0938\u094d\u0935\u093f\u091c\u0930\u0932\u094d\u092f\u093e\u0923\u094d\u0921'),'ng':'*aa','nl':'Zwitserland','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b4d\u0b71\u0b3f\u0b1c\u0b30\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21'),'os':'*aa','pa':u('\u0a38\u0a35\u0a3f\u0a1f\u0a1c\u0a3c\u0a30\u0a32\u0a48\u0a02\u0a21'),'pi':'*aa','pl':'Szwajcaria','ps':u('\u0633\u0648\u06cc\u0633'),'pt':u('Su\u00ed\u00e7a'),'qu':'*es','rm':'Svizra','rn':'Ubusuwisi','ro':'*mo','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u0626\u064a\u067d\u0631\u0632\u0644\u064a\u0646\u068a'),'se':u('\u0160veica'),'sg':u('S\u00fb\u00eesi'),'si':u('\u0dc3\u0dca\u0dc0\u0dd2\u0dc3\u0dca\u0da7\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba'),'sk':u('\u0160vaj\u010diarsko'),'sl':u('\u0160vica'),'sm':'*aa','sn':'*aa','so':'Swiiserlaand','sq':u('Zvic\u00ebr'),'sr':u('\u0428\u0432\u0430\u0458\u0446\u0430\u0440\u0441\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*ki','ta':u('\u0bb8\u0bcd\u0bb5\u0bbf\u0b9f\u0bcd\u0b9a\u0bb0\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1'),'te':u('\u0c38\u0c4d\u0c35\u0c3f\u0c1f\u0c4d\u0c1c\u0c30\u0c4d\u0c32\u0c3e\u0c02\u0c21\u0c4d'),'tg':u('\u0428\u0432\u0435\u0439\u0442\u0441\u0430\u0440\u0438\u044f'),'th':u('\u0e2a\u0e27\u0e34\u0e15\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c'),'ti':'*am','tk':u('\u015ewe\u00fdsari\u00fda'),'tl':'*aa','tn':'*aa','to':'Suisilani','tr':u('\u0130svi\u00e7re'),'ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0634\u0649\u06cb\u06d0\u062a\u0633\u0627\u0631\u0649\u064a\u06d5'),'uk':u('\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0456\u044f'),'ur':u('\u0633\u0648\u0626\u0679\u0632\u0631 \u0644\u06cc\u0646\u0688'),'uz':'Shveytsariya','ve':'*aa','vi':u('Th\u1ee5y S\u0129'),'vo':'*aa','wa':'*aa','wo':'Siwis','xh':'*aa','yi':'*he','yo':u('Or\u00edl\u1eb9\u0301\u00e8de switi\u1e63ilandi'),'za':'*aa','zh':u('\u745e\u58eb'),'zu':'i-Switzerland',},
  'CI': {'aa':u('C\u00f4te d\'Ivoire'),'ab':'*aa','ae':'*aa','af':'Ivoorkus','ak':u('La C\u00f4te d\u2019Ivoire'),'am':u('\u12ae\u1275 \u12f2\u126f\u122d'),'an':'*aa','ar':u('\u0633\u0627\u062d\u0644 \u0627\u0644\u0639\u0627\u062c'),'as':u('\u0995\u09cb\u099f\u09c7 \u09a1\u09bf \u0986\u0987\u09ad\u09f0'),'av':'*aa','ay':'*aa','az':u('Kotd\u2019ivuar'),'ba':'*aa','be':u('\u041a\u043e\u0442-\u0434\u2019\u0406\u0432\u0443\u0430\u0440'),'bg':u('\u041a\u043e\u0442 \u0434\u2019\u0418\u0432\u043e\u0430\u0440'),'bh':'*aa','bi':'*aa','bm':'Kodiwari','bn':u('\u0995\u09cb\u09a4 \u09a6\u09bf\u09ad\u09cb\u09af\u09bc\u09be\u09b0'),'bo':'*aa','br':'Aod an Olifant','bs':u('Obala Slonova\u010de'),'ca':u('Costa d\u2019Ivori'),'ce':u('\u041a\u043e\u0442-\u0414\u2019\u0438\u0432\u0443\u0430\u0440'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Pob\u0159e\u017e\u00ed slonoviny'),'cu':'*aa','cv':'*aa','cy':u('C\u00f4te d\u2019Ivoire'),'da':'Elfenbenskysten','de':'*cy','dv':'*aa','dz':u('\u0f40\u0f7c\u0f0b\u0f4a\u0f7a\u0f0b \u0f4c\u0f72\u0f0b\u0f68\u0f72\u0f0b\u0f5d\u0f7c\u0f0b\u0f62\u0f7a'),'ee':u('Kote d\u2019Ivoire nutome'),'el':u('\u0391\u03ba\u03c4\u03ae \u0395\u03bb\u03b5\u03c6\u03b1\u03bd\u03c4\u03bf\u03c3\u03c4\u03bf\u03cd'),'en':'*cy','eo':'Ebur-Bordo','es':'*cy','et':'*cy','eu':'Boli Kosta','fa':u('\u0633\u0627\u062d\u0644 \u0639\u0627\u062c'),'ff':'Kodduwaar','fi':'Norsunluurannikko','fj':'*aa','fo':u('F\u00edlabeinsstrondin'),'fr':'*cy','fy':'Ivoorkust','ga':u('an C\u00f3sta Eabhair'),'gd':'*cy','gl':'Costa do Marfil','gn':'*aa','gu':u('\u0a95\u0acb\u0a9f \u0aa1\u0ac0\u0a86\u0a87\u0ab5\u0ab0\u0ac0'),'gv':'*aa','ha':'Aibari Kwas','he':u('\u05d7\u05d5\u05e3 \u05d4\u05e9\u05e0\u05d4\u05d1'),'hi':u('\u0915\u094b\u091f \u0921\u0940 \u0906\u0907\u0935\u0930'),'ho':'*aa','hr':'Obala Bjelokosti','ht':'*aa','hu':u('Elef\u00e1ntcsontpart'),'hy':u('\u053f\u0578\u057f \u0564\u2019\u053b\u057e\u0578\u0582\u0561\u0580'),'hz':'*aa','ia':'*aa','id':'Pantai Gading','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*cy','it':u('Costa d\u2019Avorio'),'iu':'*aa','iw':'*he','ja':u('\u30b3\u30fc\u30c8\u30b8\u30dc\u30ef\u30fc\u30eb'),'ji':u('\u05d4\u05e2\u05dc\u05e4\u05bf\u05d0\u05b7 \u05e0\u05d3\u05d1\u05d9\u05d9\u05df \u05d1\u05d0\u05e8\u05d8\u05df'),'jv':'*aa','ka':u('\u10d9\u10dd\u10e2-\u10d3\u10d8\u10d5\u10e3\u10d0\u10e0\u10d8'),'kg':'*aa','ki':'Kodivaa','kj':'*aa','kk':u('\u041a\u043e\u0442-\u0434\u2019\u0418\u0432\u0443\u0430\u0440'),'kl':'*aa','km':u('\u1780\u17bc\u178f\u178c\u17b8\u179c\u17d0\u179a'),'kn':u('\u0c95\u0ccb\u0ca4\u0ccd\u200c \u0ca6\u0cbf\u0cb5\u0cbe\u0cb0\u0ccd\u200d'),'ko':u('\ucf54\ud2b8\ub514\ubd80\uc544\ub974'),'kr':'*aa','ks':u('\u0627\u064e\u06cc\u0648\u0655\u0631\u06cc \u06a9\u0648\u0633\u0679'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*cy','lg':'Kote Divwa','li':'*aa','ln':u('Kot\u00eddivual\u025b'),'lo':u('\u0ec2\u0e84\u0e95\u0eb5 \u0ea7\u0ebb\u0ea7'),'lt':'Dramblio Kaulo Krantas','lu':'Kotedivuale','lv':u('Kotdivu\u0101ra'),'mg':'*cy','mh':'*aa','mi':'*aa','mk':u('\u0411\u0440\u0435\u0433\u043e\u0442 \u043d\u0430 \u0421\u043b\u043e\u043d\u043e\u0432\u0430\u0442\u0430 \u041a\u043e\u0441\u043a\u0430'),'ml':u('\u0d15\u0d4b\u0d1f\u0d4d\u0d1f\u0d4d \u0d21\u0d3f \u0d35\u0d3e\u0d7c'),'mn':'*kk','mo':'*cy','mr':u('\u0906\u092f\u0935\u094d\u0939\u0930\u0940 \u0915\u094b\u0938\u094d\u091f'),'ms':u('Cote d\u2019Ivoire'),'mt':'il-Kosta tal-Avorju','my':u('\u1000\u102d\u102f\u1037\u1010\u103a \u1012\u102e\u1017\u103d\u102c'),'na':'*aa','nb':'*da','nd':'Ivory Coast','ne':u('\u0906\u0907\u092d\u094b\u0930\u0940 \u0915\u094b\u0938\u094d\u091f'),'ng':'*aa','nl':'*fy','nn':'Elfenbeinskysten','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b4b\u0b24\u0b4d \u0b21\u0b3f \u0b2d\u0b4d\u0b35\u0b3e\u0b30\u0b4d'),'os':'*aa','pa':u('\u0a15\u0a4b\u0a1f \u0a21\u0a40\u0a35\u0a4b\u0a06\u0a30'),'pi':'*aa','pl':'*cy','ps':u('\u062f \u0639\u0627\u062c \u0633\u0627\u062d\u0644'),'pt':'Costa do Marfim','qu':'*cy','rm':u('Costa d\u2019Ivur'),'rn':'Kotedivuware','ro':'*cy','ru':'*kk','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0622\u0626\u064a\u0648\u0631\u064a \u06aa\u0646\u0627\u0631\u0648'),'se':'Elfenbenariddu','sg':u('K\u00f4div\u00fc\u00e4ra'),'si':u('\u0d9a\u0ddd\u0da7\u0dca \u0daf\u0dd2 \u0d85\u0dba\u0dd2\u0dc0\u0dbb\u0dd2'),'sk':u('Pobre\u017eie Slonoviny'),'sl':u('Slonoko\u0161\u010dena obala'),'sm':'*aa','sn':'*nd','so':'Ivory coast','sq':'*cy','sr':u('\u041e\u0431\u0430\u043b\u0430 \u0421\u043b\u043e\u043d\u043e\u0432\u0430\u0447\u0435 (\u041a\u043e\u0442 \u0434\u2019\u0418\u0432\u043e\u0430\u0440)'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Elfenbenskusten','sw':'*ms','ta':u('\u0b95\u0bcb\u0b9f\u0bcd \u0ba4\u0bbf\u2019\u0bb5\u0bbe\u0baf\u0bb0\u0bcd'),'te':u('\u0c15\u0c4b\u0c1f\u0c4d \u0c21\u0c3f \u0c10\u0c35\u0c4b\u0c30\u0c4d'),'tg':'*kk','th':u('\u0e42\u0e01\u0e15\u0e14\u0e34\u0e27\u0e31\u0e27\u0e23\u0e4c'),'ti':'*am','tk':u('Kot-d\u2019Iwuar'),'tl':'*cy','tn':'*aa','to':u('Matafonua \u02bbAivol\u012b'),'tr':u('Fildi\u015fi Sahili'),'ts':'*aa','tt':'*kk','tw':'*aa','ty':'*aa','ug':u('\u0643\u0648\u062a\u06d0 \u062f\u06d0 \u0626\u0649\u06cb\u0648\u0626\u0649\u0631'),'uk':'*be','ur':u('\u06a9\u0648\u0679 \u0688\u06cc \u0622\u0626\u06cc\u0648\u0631\u06cc'),'uz':u('Kot-d\u2019Ivuar'),'ve':'*aa','vi':'*cy','vo':'*aa','wa':'*aa','wo':u('Kodiwaar (C\u00f4te d\u2019Ivoire)'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de K\u00f3\u00fat\u00e8 for\u00e0'),'za':'*aa','zh':u('\u79d1\u7279\u8fea\u74e6'),'zu':u('i-C\u00f4te d\u2019Ivoire'),},
  'CK': {'aa':'Cook Islands','ab':'*aa','ae':'*aa','af':'Cookeilande','ak':u('Kook Nsup\u0254w'),'am':u('\u12a9\u12ad \u12f0\u1234\u1276\u127d'),'an':'*aa','ar':u('\u062c\u0632\u0631 \u0643\u0648\u0643'),'as':u('\u0995\u09c1\u0995 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'av':'*aa','ay':'*aa','az':u('Kuk adalar\u0131'),'ba':'*aa','be':u('\u0410\u0441\u0442\u0440\u0430\u0432\u044b \u041a\u0443\u043a\u0430'),'bg':u('\u043e\u0441\u0442\u0440\u043e\u0432\u0438 \u041a\u0443\u043a'),'bh':'*aa','bi':'*aa','bm':'Kuki Gun','bn':'*as','bo':'*aa','br':'Inizi Cook','bs':'Kukova ostrva','ca':'Illes Cook','ce':u('\u041a\u0443\u043a\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Cookovy ostrovy','cu':'*aa','cv':'*aa','cy':'Ynysoedd Cook','da':u('Cook\u00f8erne'),'de':'Cookinseln','dv':'*aa','dz':u('\u0f40\u0f74\u0f42\u0f0b\u0f42\u0fb3\u0f72\u0f44\u0f0b\u0f5a\u0f7c\u0f58'),'ee':u('Kook \u0192udomekpo nutome'),'el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u039a\u03bf\u03c5\u03ba'),'en':'*aa','eo':'Kukinsuloj','es':'Islas Cook','et':'Cooki saared','eu':'Cook uharteak','fa':u('\u062c\u0632\u0627\u06cc\u0631 \u06a9\u0648\u06a9'),'ff':u('Duu\u0257e Kuuk'),'fi':'Cookinsaaret','fj':'*aa','fo':'Cooksoyggjar','fr':u('\u00celes Cook'),'fy':'Cookeilannen','ga':u('Oile\u00e1in Cook'),'gd':'Eileanan Cook','gl':'Illas Cook','gn':'*aa','gu':u('\u0a95\u0ac1\u0a95 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8'),'gv':'*aa','ha':'Tsibiran Kuku','he':u('\u05d0\u05d9\u05d9 \u05e7\u05d5\u05e7'),'hi':u('\u0915\u0941\u0915 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939'),'ho':'*aa','hr':'Cookovi Otoci','ht':'*aa','hu':'Cook-szigetek','hy':u('\u053f\u0578\u0582\u056f\u056b \u056f\u0572\u0566\u056b\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'Kepulauan Cook','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'Cooks-eyjar','it':'Isole Cook','iu':'*aa','iw':'*he','ja':u('\u30af\u30c3\u30af\u8af8\u5cf6'),'ji':u('\u05e7\u05d5\u05e7 \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df'),'jv':'*aa','ka':u('\u10d9\u10e3\u10d9\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'Visiwa vya Cook','kj':'*aa','kk':u('\u041a\u0443\u043a \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'kl':'*aa','km':u('\u1780\u17c4\u17c7\u200b\u1781\u17bc\u1780'),'kn':u('\u0c95\u0cc1\u0c95\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3\u0cc1'),'ko':u('\ucfe1 \uc81c\ub3c4'),'kr':'*aa','ks':u('\u06a9\u064f\u06a9 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'Cookinselen','lg':'Bizinga bya Kkuki','li':'*aa','ln':u('Bisanga bya Kook\u025b'),'lo':u('\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0e84\u0eb8\u0e81'),'lt':'Kuko Salos','lu':u('Lutanda lua Kook\u025b'),'lv':'Kuka salas','mg':'Nosy Kook','mh':'*aa','mi':'*aa','mk':u('\u041a\u0443\u043a\u043e\u0432\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438'),'ml':u('\u0d15\u0d41\u0d15\u0d4d\u0d15\u0d4d \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e'),'mn':u('\u041a\u04af\u04af\u043a\u0438\u0439\u043d \u0430\u0440\u043b\u0443\u0443\u0434'),'mo':'Insulele Cook','mr':u('\u0915\u0941\u0915 \u092c\u0947\u091f\u0947'),'ms':'*id','mt':u('G\u017cejjer Cook'),'my':u('\u1000\u103d\u1010\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f'),'na':'*aa','nb':u('Cook\u00f8yene'),'nd':'*aa','ne':u('\u0915\u0941\u0915 \u091f\u093e\u092a\u0941\u0939\u0930\u0941'),'ng':'*aa','nl':'Cookeilanden','nn':u('Cook\u00f8yane'),'no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b41\u0b15\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c'),'os':'*aa','pa':u('\u0a15\u0a41\u0a71\u0a15 \u0a1f\u0a3e\u0a2a\u0a42'),'pi':'*aa','pl':'Wyspy Cooka','ps':u('\u06a9\u0648\u06a9 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646'),'pt':'Ilhas Cook','qu':'*aa','rm':'Inslas Cook','rn':'Izinga rya Kuku','ro':'*mo','ru':u('\u041e\u0441\u0442\u0440\u043e\u0432\u0430 \u041a\u0443\u043a\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u0648\u06aa \u067b\u064a\u067d'),'se':'Cook-sullot','sg':u('\u00e2z\u00fb\u00e2 K\u00fbku'),'si':u('\u0d9a\u0dd4\u0d9a\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca'),'sk':'Cookove ostrovy','sl':'Cookovi otoki','sm':'*aa','sn':'Zvitsuwa zveCook','so':'Jaziiradda Cook','sq':'Ishujt Kuk','sr':u('\u041a\u0443\u043a\u043e\u0432\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Cook\u00f6arna'),'sw':'*ki','ta':u('\u0b95\u0bc1\u0b95\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd'),'te':u('\u0c15\u0c41\u0c15\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41'),'tg':u('\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u041a\u0443\u043a'),'th':u('\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e04\u0e38\u0e01'),'ti':u('\u12f0\u1234\u1273\u1275 \u12a9\u12ad'),'tk':'Kuk adalary','tl':'*aa','tn':'*aa','to':u('\u02bbOtumotu Kuki'),'tr':u('Cook Adalar\u0131'),'ts':'*aa','tt':u('\u041a\u0443\u043a \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0643\u06c7\u0643 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649'),'uk':u('\u041e\u0441\u0442\u0440\u043e\u0432\u0438 \u041a\u0443\u043a\u0430'),'ur':u('\u06a9\u06a9 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632'),'uz':'Kuk orollari','ve':'*aa','vi':u('Qu\u1ea7n \u0111\u1ea3o Cook'),'vo':'*aa','wa':'*aa','wo':'Duni Kuuk','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Et\u00edokun K\u00f9\u00fak\u00f9'),'za':'*aa','zh':u('\u5e93\u514b\u7fa4\u5c9b'),'zu':'i-Cook Islands',},
  'CL': {'aa':'Chile','ab':'*aa','ae':'*aa','af':'Chili','ak':'Kyili','am':u('\u127a\u120a'),'an':'*aa','ar':u('\u062a\u0634\u064a\u0644\u064a'),'as':u('\u099a\u09bf\u09b2\u09bf'),'av':'*aa','ay':'*aa','az':u('\u00c7ili'),'ba':'*aa','be':u('\u0427\u044b\u043b\u0456'),'bg':u('\u0427\u0438\u043b\u0438'),'bh':'*aa','bi':'*aa','bm':'Sili','bn':'*as','bo':'*aa','br':'*aa','bs':u('\u010cile'),'ca':'Xile','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f45\u0f72\u0f0b\u0f63\u0f72'),'ee':'Tsile nutome','el':u('\u03a7\u03b9\u03bb\u03ae'),'en':'*aa','eo':u('\u0108ilio'),'es':'*aa','et':u('T\u0161iili'),'eu':'Txile','fa':u('\u0634\u06cc\u0644\u06cc'),'ff':'Cilii','fi':'*aa','fj':'*aa','fo':'Kili','fr':'*af','fy':'*af','ga':'an tSile','gd':'An t-Sile','gl':'*aa','gn':'*aa','gu':u('\u0a9a\u0abf\u0ab2\u0ac0'),'gv':'*aa','ha':'Cayile','he':u('\u05e6\u05f3\u05d9\u05dc\u05d4'),'hi':u('\u091a\u093f\u0932\u0940'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u0549\u056b\u056c\u056b'),'hz':'*aa','ia':'*aa','id':'Cile','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('S\u00edle'),'it':'*id','iu':'*aa','iw':'*he','ja':u('\u30c1\u30ea'),'ji':u('\u05d8\u05e9\u05d9\u05dc\u05e2'),'jv':'*aa','ka':u('\u10e9\u10d8\u10da\u10d4'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u179f\u17ca\u17b8\u179b\u17b8'),'kn':u('\u0c9a\u0cbf\u0cb2\u0cbf'),'ko':u('\uce60\ub808'),'kr':'*aa','ks':u('\u0686\u0650\u0644\u06cc'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'*id','li':'*aa','ln':u('S\u00edli'),'lo':u('\u0e8a\u0eb4\u0ea5\u0eb5'),'lt':u('\u010cil\u0117'),'lu':'Shili','lv':u('\u010c\u012ble'),'mg':'*lu','mh':'*aa','mi':'*aa','mk':u('\u0427\u0438\u043b\u0435'),'ml':u('\u0d1a\u0d3f\u0d32\u0d3f'),'mn':'*bg','mo':'*aa','mr':'*hi','ms':'*aa','mt':u('i\u010b-\u010aili'),'my':u('\u1001\u103b\u102e\u101c\u102e'),'na':'*aa','nb':'*aa','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b1a\u0b3f\u0b32\u0b4d\u0b32\u0b40'),'os':'*aa','pa':u('\u0a1a\u0a3f\u0a32\u0a40'),'pi':'*aa','pl':'*aa','ps':u('\u0686\u06cc\u0644\u064a'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'*lu','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0686\u0644\u064a'),'se':u('\u010ciile'),'sg':u('Shil\u00efi'),'si':u('\u0da0\u0dd2\u0dbd\u0dd3'),'sk':'*bs','sl':'*bs','sm':'*aa','sn':'*aa','so':'Jili','sq':'*fo','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b9a\u0bbf\u0bb2\u0bbf'),'te':u('\u0c1a\u0c3f\u0c32\u0c40'),'tg':'*bg','th':u('\u0e0a\u0e34\u0e25\u0e35'),'ti':'*am','tk':'*az','tl':'*aa','tn':'*aa','to':'*bm','tr':u('\u015eili'),'ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0686\u0649\u0644\u0649'),'uk':u('\u0427\u0456\u043b\u0456'),'ur':u('\u0686\u0644\u06cc'),'uz':'*af','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*bm','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de \u1e63\u00edl\u00e8'),'za':'*aa','zh':u('\u667a\u5229'),'zu':'i-Chile',},
  'CM': {'aa':'Cameroon','ab':'*aa','ae':'*aa','af':'Kameroen','ak':u('Kam\u025brun'),'am':u('\u12ab\u121c\u1229\u1295'),'an':'*aa','ar':u('\u0627\u0644\u0643\u0627\u0645\u064a\u0631\u0648\u0646'),'as':u('\u0995\u09c7\u09ae\u09c7\u09f0\u09c1\u09a3'),'av':'*aa','ay':'*aa','az':'Kamerun','ba':'*aa','be':u('\u041a\u0430\u043c\u0435\u0440\u0443\u043d'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'Kameruni','bn':u('\u0995\u09cd\u09af\u09be\u09ae\u09c7\u09b0\u09c1\u09a8'),'bo':'*aa','br':'Kameroun','bs':'*az','ca':'Camerun','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*az','cu':'*aa','cv':'*aa','cy':u('Camer\u0175n'),'da':'Cameroun','de':'*az','dv':'*aa','dz':u('\u0f40\u0f7a\u0f0b\u0f58\u0f0b\u0f62\u0f74\u0f53'),'ee':'Kamerun nutome','el':u('\u039a\u03b1\u03bc\u03b5\u03c1\u03bf\u03cd\u03bd'),'en':'*aa','eo':'Kameruno','es':u('Camer\u00fan'),'et':'*az','eu':'*az','fa':u('\u06a9\u0627\u0645\u0631\u0648\u0646'),'ff':'Kameruun','fi':'*az','fj':'*aa','fo':'*az','fr':'*da','fy':'*af','ga':u('Camar\u00fan'),'gd':'Camarun','gl':'*es','gn':'*aa','gu':u('\u0a95\u0ac5\u0aae\u0ab0\u0ac2\u0aa8'),'gv':'*aa','ha':'Kamaru','he':u('\u05e7\u05de\u05e8\u05d5\u05df'),'hi':u('\u0915\u0948\u092e\u0930\u0942\u0928'),'ho':'*aa','hr':'*az','ht':'*aa','hu':'*az','hy':u('\u053f\u0561\u0574\u0565\u0580\u0578\u0582\u0576'),'hz':'*aa','ia':'*aa','id':'*az','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*az','io':'*aa','is':u('Kamer\u00fan'),'it':'*ca','iu':'*aa','iw':'*he','ja':u('\u30ab\u30e1\u30eb\u30fc\u30f3'),'ji':u('\u05e7\u05d0\u05b7\u05de\u05e2\u05e8\u05d5\u05df'),'jv':'*aa','ka':u('\u10d9\u10d0\u10db\u10d4\u10e0\u10e3\u10dc\u10d8'),'kg':'*aa','ki':'*bm','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u1780\u17b6\u1798\u17c1\u179a\u17bc\u1793'),'kn':u('\u0c95\u0ccd\u0caf\u0cbe\u0cae\u0cb0\u0cc2\u0ca8\u0ccd'),'ko':u('\uce74\uba54\ub8ec'),'kr':'*aa','ks':u('\u06a9\u06cc\u065a\u0645\u0650\u0631\u0648\u0657\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*az','lg':'Kameruuni','li':'*aa','ln':u('Kam\u025brune'),'lo':u('\u0e84\u0eb2\u0ec0\u0ea1\u0ea3\u0eb9\u0e99'),'lt':u('Kamer\u016bnas'),'lu':'Kamerune','lv':u('Kamer\u016bna'),'mg':'Kamerona','mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d15\u0d3e\u0d2e\u0d31\u0d42\u0d7a'),'mn':'*be','mo':'*ca','mr':u('\u0915\u0945\u092e\u0947\u0930\u0942\u0928'),'ms':'*aa','mt':'il-Kamerun','my':u('\u1000\u1004\u103a\u1019\u101b\u103d\u1014\u103a\u1038'),'na':'*aa','nb':'*az','nd':'Khameruni','ne':u('\u0915\u094d\u092f\u093e\u092e\u0930\u0942\u0928'),'ng':'*aa','nl':'*af','nn':'*az','no':'*az','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b3e\u0b2e\u0b47\u0b30\u0b41\u0b28\u0b4d'),'os':'*aa','pa':u('\u0a15\u0a48\u0a2e\u0a30\u0a42\u0a28'),'pi':'*aa','pl':'*az','ps':'*fa','pt':u('Camar\u00f5es'),'qu':'*es','rm':'*ca','rn':'*bm','ro':'*ca','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u064a\u0645\u0631\u0648\u0646'),'se':'*az','sg':u('Kamer\u00fbne'),'si':u('\u0d9a\u0dd0\u0db8\u0dbb\u0dd6\u0db1\u0dca'),'sk':'*az','sl':'*az','sm':'*aa','sn':'*bm','so':'Kaameruun','sq':'*az','sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*az','sw':'*bm','ta':u('\u0b95\u0bc7\u0bae\u0bb0\u0bc2\u0ba9\u0bcd'),'te':u('\u0c15\u0c3e\u0c2e\u0c46\u0c30\u0c42\u0c28\u0c4d'),'tg':'*be','th':u('\u0e41\u0e04\u0e40\u0e21\u0e2d\u0e23\u0e39\u0e19'),'ti':'*am','tk':'*az','tl':'*aa','tn':'*aa','to':'Kameluni','tr':'*az','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u0643\u0627\u0645\u06d0\u0631\u0648\u0646'),'uk':'*be','ur':u('\u06a9\u06cc\u0645\u0631\u0648\u0646'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*az','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Kamer\u00fa\u00fan\u00ec'),'za':'*aa','zh':u('\u5580\u9ea6\u9686'),'zu':'i-Cameroon',},
  'CN': {'aa':'China','ab':'*aa','ae':'*aa','af':'Sjina','ak':'Kyaena','am':u('\u127b\u12ed\u1293'),'an':'*aa','ar':u('\u0627\u0644\u0635\u064a\u0646'),'as':u('\u099a\u09c0\u09a8'),'av':'*aa','ay':'*aa','az':u('\u00c7in'),'ba':'*aa','be':u('\u041a\u0456\u0442\u0430\u0439'),'bg':u('\u041a\u0438\u0442\u0430\u0439'),'bh':'*aa','bi':'*aa','bm':'Siniwajamana','bn':'*as','bo':u('\u0f62\u0f92\u0fb1\u0f0b\u0f53\u0f42'),'br':'Sina','bs':'Kina','ca':'Xina','ce':u('\u0426\u0438\u0439\u0447\u043e\u044c'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('\u010c\u00edna'),'cu':'*aa','cv':'*aa','cy':'Tsieina','da':'*bs','de':'*aa','dv':'*aa','dz':'*bo','ee':'Tsaina nutome','el':u('\u039a\u03af\u03bd\u03b1'),'en':'*aa','eo':u('\u0108inujo'),'es':'*aa','et':'Hiina','eu':'Txina','fa':u('\u0686\u06cc\u0646'),'ff':'Siin','fi':'Kiina','fj':'*aa','fo':'*bs','fr':'Chine','fy':'*br','ga':u('an tS\u00edn'),'gd':u('An t-S\u00ecn'),'gl':'*aa','gn':'*aa','gu':u('\u0a9a\u0ac0\u0aa8'),'gv':'*aa','ha':'Caina, Sin','he':u('\u05e1\u05d9\u05df'),'hi':u('\u091a\u0940\u0928'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('K\u00edna'),'hy':u('\u0549\u056b\u0576\u0561\u057d\u057f\u0561\u0576'),'hz':'*aa','ia':'*aa','id':'Tiongkok','ie':'*aa','ig':'Chaina','ii':u('\ua34f\ua1e9'),'ik':'*aa','in':'*id','io':'*aa','is':'*hu','it':'Cina','iu':'*aa','iw':'*he','ja':u('\u4e2d\u56fd'),'ji':u('\u05db\u05d9\u05e0\u05e2'),'jv':'*aa','ka':u('\u10e9\u10d8\u10dc\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'Caina','kj':'*aa','kk':u('\u049a\u044b\u0442\u0430\u0439'),'kl':'*aa','km':u('\u1785\u17b7\u1793'),'kn':u('\u0c9a\u0cc0\u0ca8\u0cbe'),'ko':u('\uc911\uad6d'),'kr':'*aa','ks':u('\u0686\u06cc\u0656\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u041a\u044b\u0442\u0430\u0439'),'la':'*aa','lb':'*aa','lg':'Cayina','li':'*aa','ln':u('Sin\u025b'),'lo':u('\u0e88\u0eb5\u0e99'),'lt':'Kinija','lu':'Shine','lv':u('\u0136\u012bna'),'mg':'*br','mh':'*aa','mi':'*aa','mk':u('\u041a\u0438\u043d\u0430'),'ml':u('\u0d1a\u0d48\u0d28'),'mn':u('\u0425\u044f\u0442\u0430\u0434'),'mo':'*aa','mr':'*hi','ms':'*aa','mt':'CN','my':u('\u1010\u101b\u102f\u1010\u103a'),'na':'*aa','nb':'*bs','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*bs','no':'*bs','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b1a\u0b3f\u0b28\u0b4d'),'os':'*bg','pa':u('\u0a1a\u0a40\u0a28'),'pi':'*aa','pl':'Chiny','ps':'*fa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'Ubushinwa','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0686\u064a\u0646'),'se':u('Kiinn\u00e1'),'sg':u('Sh\u00eena'),'si':u('\u0da0\u0dd3\u0db1\u0dba'),'sk':'*cs','sl':'Kitajska','sm':'*aa','sn':'*aa','so':'Shiinaha','sq':u('Kin\u00eb'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*bs','sw':'Uchina','ta':u('\u0b9a\u0bc0\u0ba9\u0bbe'),'te':u('\u0c1a\u0c48\u0c28\u0c3e'),'tg':u('\u0425\u0438\u0442\u043e\u0439'),'th':u('\u0e08\u0e35\u0e19'),'ti':'*am','tk':u('Hyta\u00fd'),'tl':'*aa','tn':'*aa','to':'Siaina','tr':'*az','ts':'*aa','tt':'*ky','tw':'*aa','ty':'*aa','ug':u('\u062c\u06c7\u06ad\u06af\u0648'),'uk':'*bg','ur':'*fa','uz':'Xitoy','ve':'*aa','vi':u('Trung Qu\u1ed1c'),'vo':'*aa','wa':'*aa','wo':'*ff','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de \u1e63\u00e1\u00edn\u00e0'),'za':'*aa','zh':'*ja','zu':'i-China',},
  'CO': {'aa':'Colombia','ab':'*aa','ae':'*aa','af':u('Colombi\u00eb'),'ak':'Kolombia','am':u('\u12ae\u120e\u121d\u1262\u12eb'),'an':'*aa','ar':u('\u0643\u0648\u0644\u0648\u0645\u0628\u064a\u0627'),'as':u('\u0995\u09b2\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Kolumbiya','ba':'*aa','be':u('\u041a\u0430\u043b\u0443\u043c\u0431\u0456\u044f'),'bg':u('\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Kolombi','bn':'*as','bo':'*aa','br':'*ak','bs':'Kolumbija','ca':u('Col\u00f2mbia'),'ce':u('\u041a\u043e\u043b\u0443\u043c\u0431\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Kolumbie','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Kolumbien','dv':'*aa','dz':u('\u0f40\u0f7c\u0f0b\u0f63\u0f7c\u0f58\u0f0b\u0f56\u0fb7\u0f72\u0f0b\u0f61'),'ee':'Kolombia nutome','el':u('\u039a\u03bf\u03bb\u03bf\u03bc\u03b2\u03af\u03b1'),'en':'*aa','eo':'Kolombio','es':'*aa','et':'*aa','eu':'Kolonbia','fa':u('\u06a9\u0644\u0645\u0628\u06cc\u0627'),'ff':'Kolombiya','fi':'Kolumbia','fj':'*aa','fo':'*ak','fr':'Colombie','fy':'*ak','ga':u('an Chol\u00f3im'),'gd':'Coloimbia','gl':'*aa','gn':'*aa','gu':u('\u0a95\u0acb\u0ab2\u0aae\u0acd\u0aac\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Kolambiya','he':u('\u05e7\u05d5\u05dc\u05d5\u05de\u05d1\u05d9\u05d4'),'hi':u('\u0915\u094b\u0932\u0902\u092c\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*fi','hy':u('\u053f\u0578\u056c\u0578\u0582\u0574\u0562\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*ak','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*ak','io':'*aa','is':u('K\u00f3lumb\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30b3\u30ed\u30f3\u30d3\u30a2'),'ji':u('\u05e7\u05d0\u05dc\u05d0\u05de\u05d1\u05d9\u05e2'),'jv':'*aa','ka':u('\u10d9\u10dd\u10da\u10e3\u10db\u10d1\u10d8\u10d0'),'kg':'*aa','ki':'*ak','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1780\u17bc\u17a1\u17bb\u17c6\u1794\u17ca\u17b8'),'kn':u('\u0c95\u0cca\u0cb2\u0c82\u0cac\u0cbf\u0caf\u0cbe'),'ko':u('\ucf5c\ub86c\ube44\uc544'),'kr':'*aa','ks':u('\u06a9\u0648\u0644\u064e\u0645\u0628\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*de','lg':'Kolombya','li':'*aa','ln':'*bm','lo':u('\u0ec2\u0e84\u0ea5\u0ebb\u0ea1\u0ec0\u0e9a\u0e8d'),'lt':'*bs','lu':'*bm','lv':'*bs','mg':u('K\u00f4l\u00f4mbia'),'mh':'*aa','mi':'*aa','mk':u('\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u0458\u0430'),'ml':u('\u0d15\u0d4a\u0d33\u0d02\u0d2c\u0d3f\u0d2f'),'mn':'*ce','mo':'Columbia','mr':u('\u0915\u094b\u0932\u092e\u094d\u092c\u093f\u092f\u093e'),'ms':'*aa','mt':'il-Kolombja','my':u('\u1000\u102d\u102f\u101c\u1036\u1018\u102e\u101a\u102c'),'na':'*aa','nb':'*aa','nd':'Kholombiya','ne':u('\u0915\u094b\u0932\u094b\u092e\u094d\u092c\u093f\u092f\u093e'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b4b\u0b32\u0b2e\u0b4d\u0b2c\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a15\u0a4b\u0a32\u0a70\u0a2c\u0a40\u0a06'),'pi':'*aa','pl':'*fi','ps':u('\u06a9\u0648\u0644\u0645\u0628\u06cc\u0627'),'pt':u('Col\u00f4mbia'),'qu':'*aa','rm':'*mo','rn':'*ff','ro':'*mo','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u0648\u0644\u0645\u0628\u064a\u0627'),'se':'*ak','sg':u('Kolomb\u00efi'),'si':u('\u0d9a\u0ddc\u0dc5\u0ddc\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*fi','sl':'*bs','sm':'*aa','sn':'*ak','so':'*ff','sq':'Kolumbi','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*ak','ta':u('\u0b95\u0bca\u0bb2\u0bae\u0bcd\u0baa\u0bbf\u0baf\u0bbe'),'te':u('\u0c15\u0c4a\u0c32\u0c02\u0c2c\u0c3f\u0c2f\u0c3e'),'tg':'*bg','th':u('\u0e42\u0e04\u0e25\u0e2d\u0e21\u0e40\u0e1a\u0e35\u0e22'),'ti':'*am','tk':u('Kolumbi\u00fda'),'tl':'*aa','tn':'*aa','to':'Kolomipia','tr':'*ff','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0643\u0648\u0644\u0648\u0645\u0628\u0649\u064a\u06d5'),'uk':u('\u041a\u043e\u043b\u0443\u043c\u0431\u0456\u044f'),'ur':'*ps','uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*bm','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de K\u00f2l\u00f3m\u00edb\u00eca'),'za':'*aa','zh':u('\u54e5\u4f26\u6bd4\u4e9a'),'zu':'i-Colombia',},
  'CR': {'aa':'Costa Rica','ab':'*aa','ae':'*aa','af':'*aa','ak':u('K\u0254sta Rika'),'am':u('\u12ae\u1235\u1273\u122a\u12ab'),'an':'*aa','ar':u('\u0643\u0648\u0633\u062a\u0627\u0631\u064a\u0643\u0627'),'as':u('\u0995\u09cb\u09b7\u09cd\u099f\u09be \u09f0\u09bf\u0995\u09be'),'av':'*aa','ay':'*aa','az':'Kosta Rika','ba':'*aa','be':u('\u041a\u043e\u0441\u0442\u0430-\u0420\u044b\u043a\u0430'),'bg':u('\u041a\u043e\u0441\u0442\u0430 \u0420\u0438\u043a\u0430'),'bh':'*aa','bi':'*aa','bm':u('K\u0254sitarika'),'bn':u('\u0995\u09cb\u09b8\u09cd\u099f\u09be\u09b0\u09bf\u0995\u09be'),'bo':'*aa','br':'*aa','bs':'Kostarika','ca':'*aa','ce':u('\u041a\u043e\u0441\u0442\u0430-\u0420\u0438\u043a\u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*bs','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f40\u0f7c\u0f66\u0f0b\u0f4a\u0f0b\u0f62\u0f72\u0f0b\u0f40'),'ee':'Kosta Rika nutome','el':u('\u039a\u03cc\u03c3\u03c4\u03b1 \u03a1\u03af\u03ba\u03b1'),'en':'*aa','eo':'Kostariko','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u06a9\u0627\u0633\u062a\u0627\u0631\u06cc\u06a9\u0627'),'ff':'Kosta Rikaa','fi':'*aa','fj':'*aa','fo':'*az','fr':'*aa','fy':'*aa','ga':u('C\u00f3sta R\u00edce'),'gd':u('Costa R\u00eccea'),'gl':'*aa','gn':'*aa','gu':u('\u0a95\u0acb\u0ab8\u0acd\u0a9f\u0abe \u0ab0\u0abf\u0a95\u0abe'),'gv':'*aa','ha':'Kwasta Rika','he':u('\u05e7\u05d5\u05e1\u05d8\u05d4 \u05e8\u05d9\u05e7\u05d4'),'hi':u('\u0915\u094b\u0938\u094d\u091f\u093e\u0930\u093f\u0915\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u053f\u0578\u057d\u057f\u0561 \u054c\u056b\u056f\u0561'),'hz':'*aa','ia':'*aa','id':'*az','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*az','io':'*aa','is':u('Kostar\u00edka'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30b3\u30b9\u30bf\u30ea\u30ab'),'ji':u('\u05e7\u05d0\u05e1\u05d8\u05d0\u05b7 \u05e8\u05d9\u05e7\u05d0\u05b7'),'jv':'*aa','ka':u('\u10d9\u10dd\u10e1\u10e2\u10d0-\u10e0\u10d8\u10d9\u10d0'),'kg':'*aa','ki':'*bs','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u1780\u17bc\u179f\u17d2\u178f\u17b6\u179a\u17b8\u1780\u17b6'),'kn':u('\u0c95\u0cca\u0cb8\u0ccd\u0c9f\u0cbe \u0cb0\u0cbf\u0c95\u0cbe'),'ko':u('\ucf54\uc2a4\ud0c0\ub9ac\uce74'),'kr':'*aa','ks':u('\u06a9\u0648\u0633\u0679\u0627 \u0631\u0650\u06a9\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*aa','lg':'Kosita Rika','li':'*aa','ln':'Kositarika','lo':u('\u0ec2\u0e84\u0eaa\u0e95\u0eb2 \u0ea3\u0eb4\u0e81\u0eb2'),'lt':'*az','lu':'*ln','lv':'*bs','mg':u('Kosta Rik\u00e0'),'mh':'*aa','mi':'*aa','mk':u('\u041a\u043e\u0441\u0442\u0430\u0440\u0438\u043a\u0430'),'ml':u('\u0d15\u0d4b\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d31\u0d3f\u0d15\u0d4d\u0d15'),'mn':'*ce','mo':'*aa','mr':u('\u0915\u094b\u0938\u094d\u091f\u093e \u0930\u093f\u0915\u093e'),'ms':'*aa','mt':'il-Costa Rica','my':u('\u1000\u102d\u102f\u1037\u1005\u103a\u1010\u102c\u101b\u102e\u1000\u102c'),'na':'*aa','nb':'*aa','nd':'Khosta Rikha','ne':u('\u0915\u094b\u0937\u094d\u091f\u093e\u0930\u093f\u0915\u093e'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b4b\u0b37\u0b4d\u0b1f\u0b3e \u0b30\u0b3f\u0b15\u0b3e'),'os':'*aa','pa':u('\u0a15\u0a4b\u0a38\u0a1f\u0a3e \u0a30\u0a40\u0a15\u0a3e'),'pi':'*aa','pl':'Kostaryka','ps':u('\u06a9\u0648\u0633\u062a\u0627\u0631\u06cc\u06a9\u0627'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'*ln','ro':'*aa','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u0648\u0633\u067d\u0627 \u0631\u06aa\u0627'),'se':'*aa','sg':u('K\u00f4sta R\u00eeka'),'si':u('\u0d9a\u0ddc\u0dc3\u0dca\u0da7\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0'),'sk':'*bs','sl':'*bs','sm':'*aa','sn':'*bs','so':'Kosta Riika','sq':u('Kosta-Rik\u00eb'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*bs','ta':u('\u0b95\u0bcb\u0bb8\u0bcd\u0b9f\u0bbe\u0bb0\u0bbf\u0b95\u0bbe'),'te':u('\u0c15\u0c4b\u0c38\u0c4d\u0c1f\u0c3e \u0c30\u0c3f\u0c15\u0c3e'),'tg':'*ce','th':u('\u0e04\u0e2d\u0e2a\u0e15\u0e32\u0e23\u0e34\u0e01\u0e32'),'ti':u('\u12ae\u1235\u1273 \u122a\u12ab'),'tk':'Kosta-Rika','tl':'*aa','tn':'*aa','to':'Kosita Lika','tr':'*az','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u0643\u0648\u0633\u062a\u0627\u0631\u0649\u0643\u0627'),'uk':u('\u041a\u043e\u0441\u0442\u0430-\u0420\u0456\u043a\u0430'),'ur':u('\u06a9\u0648\u0633\u0679\u0627 \u0631\u06cc\u06a9\u0627'),'uz':'*tk','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*az','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Kuusita R\u00edk\u00e0'),'za':'*aa','zh':u('\u54e5\u65af\u8fbe\u9ece\u52a0'),'zu':'i-Costa Rica',},
  'CU': {'aa':'Cuba','ab':'*aa','ae':'*aa','af':'Kuba','ak':'*af','am':u('\u12a9\u1263'),'an':'*aa','ar':u('\u0643\u0648\u0628\u0627'),'as':u('\u0995\u09bf\u0989\u09ac\u09be'),'av':'*aa','ay':'*aa','az':'*af','ba':'*aa','be':u('\u041a\u0443\u0431\u0430'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'*af','bn':'*as','bo':'*aa','br':'*af','bs':'*af','ca':'*aa','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*af','cu':'*aa','cv':'*aa','cy':'Ciwba','da':'*aa','de':'*af','dv':'*aa','dz':u('\u0f40\u0f72\u0f60\u0f74\u0f0b\u0f56\u0fb7'),'ee':'Kuba nutome','el':u('\u039a\u03bf\u03cd\u03b2\u03b1'),'en':'*aa','eo':'Kubo','es':'*aa','et':'Kuuba','eu':'*af','fa':u('\u06a9\u0648\u0628\u0627'),'ff':'Kubaa','fi':'*et','fj':'*aa','fo':'*af','fr':'*aa','fy':'*af','ga':u('C\u00faba'),'gd':u('C\u00f9ba'),'gl':'*aa','gn':'*aa','gu':u('\u0a95\u0acd\u0aaf\u0ac1\u0aac\u0abe'),'gv':'*aa','ha':'Kyuba','he':u('\u05e7\u05d5\u05d1\u05d4'),'hi':u('\u0915\u094d\u092f\u0942\u092c\u093e'),'ho':'*aa','hr':'*af','ht':'*aa','hu':'*af','hy':u('\u053f\u0578\u0582\u0562\u0561'),'hz':'*aa','ia':'*aa','id':'*af','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*af','io':'*aa','is':u('K\u00faba'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30ad\u30e5\u30fc\u30d0'),'ji':u('\u05e7\u05d5\u05d1\u05d0\u05b7'),'jv':'*aa','ka':u('\u10d9\u10e3\u10d1\u10d0'),'kg':'*aa','ki':'Kiumba','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u1782\u17bb\u1799\u1794\u17b6'),'kn':u('\u0c95\u0ccd\u0caf\u0cc2\u0cac\u0cbe'),'ko':u('\ucfe0\ubc14'),'kr':'*aa','ks':u('\u06a9\u06cc\u0648\u0657\u0628\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*af','lg':'*aa','li':'*aa','ln':'Kiba','lo':u('\u0e84\u0eb4\u0ea7\u0e9a\u0eb2'),'lt':'*af','lu':'*af','lv':'*af','mg':u('Kiob\u00e0'),'mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d15\u0d4d\u0d2f\u0d42\u0d2c'),'mn':'*be','mo':'*aa','mr':'*hi','ms':'*aa','mt':'*af','my':u('\u1000\u103b\u1030\u1038\u1018\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0915\u094d\u092f\u0941\u092c\u093e'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b4d\u0b71\u0b3f\u0b2c\u0b3e'),'os':'*aa','pa':u('\u0a15\u0a3f\u0a0a\u0a2c\u0a3e'),'pi':'*aa','pl':'*af','ps':u('\u06a9\u06cc\u0648\u0628\u0627'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'*ln','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u064a\u0648\u0628\u0627'),'se':'*af','sg':u('Kub\u00e4a'),'si':u('\u0d9a\u0dd2\u0dba\u0dd4\u0db6\u0dcf\u0dc0'),'sk':'*af','sl':'*af','sm':'*aa','sn':'*aa','so':'*et','sq':u('Kub\u00eb'),'sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*af','sw':'*aa','ta':u('\u0b95\u0bbf\u0baf\u0bc2\u0baa\u0bbe'),'te':u('\u0c15\u0c4d\u0c2f\u0c42\u0c2c\u0c3e'),'tg':'*be','th':u('\u0e04\u0e34\u0e27\u0e1a\u0e32'),'ti':'*am','tk':'*af','tl':'*aa','tn':'*aa','to':'Kiupa','tr':u('K\u00fcba'),'ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u0643\u06c7\u0628\u0627'),'uk':'*be','ur':'*ps','uz':'*af','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*af','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de K\u00fab\u00e0'),'za':'*aa','zh':u('\u53e4\u5df4'),'zu':'i-Cuba',},
  'CV': {'aa':'Cape Verde','ab':'*aa','ae':'*aa','af':'Kaap Verde','ak':u('Kepv\u025bdfo Islands'),'am':u('\u12ac\u1355 \u126c\u122d\u12f4'),'an':'*aa','ar':u('\u0627\u0644\u0631\u0623\u0633 \u0627\u0644\u0623\u062e\u0636\u0631'),'as':u('\u0995\u09c7\u09aa \u09ad\u09be\u09b0\u09cd\u09a6\u09c7'),'av':'*aa','ay':'*aa','az':'Kabo-Verde','ba':'*aa','be':u('\u041a\u0430\u0431\u0430-\u0412\u0435\u0440\u0434\u044d'),'bg':u('\u041a\u0430\u0431\u043e \u0412\u0435\u0440\u0434\u0435'),'bh':'*aa','bi':'*aa','bm':u('Capiv\u025brdi'),'bn':u('\u0995\u09c7\u09aa\u09ad\u09be\u09b0\u09cd\u09a6\u09c7'),'bo':'*aa','br':'Kab-Glas','bs':'Kape Verde','ca':'Cap Verd','ce':u('\u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Kapverdy','cu':'*aa','cv':'*aa','cy':'Cabo Verde','da':'Kap Verde','de':'*cy','dv':'*aa','dz':u('\u0f40\u0f7a\u0f54\u0f0b\u0f56\u0f71\u0f4c'),'ee':'Kape Verde nutome','el':u('\u03a0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf \u0391\u03ba\u03c1\u03c9\u03c4\u03ae\u03c1\u03b9\u03bf'),'en':'*aa','eo':'Kabo-Verdo','es':'*cy','et':'Roheneemesaared','eu':'*cy','fa':u('\u06a9\u06cc\u067e\u200c\u0648\u0631\u062f'),'ff':u('Duu\u0257e Kap Weer'),'fi':'*da','fj':'*aa','fo':u('Gr\u00f8nh\u00f8vdaoyggjar'),'fr':'Cap-Vert','fy':u('Kaapverdi\u00eb'),'ga':'Rinn Verde','gd':'An Ceap Uaine','gl':'*cy','gn':'*aa','gu':u('\u0a95\u0ac5\u0aaa \u0ab5\u0ab0\u0acd\u0aa1\u0ac7'),'gv':'*aa','ha':'Tsibiran Kap Barde','he':u('\u05db\u05e3 \u05d5\u05e8\u05d3\u05d4'),'hi':u('\u0915\u0947\u092a \u0935\u0930\u094d\u0921'),'ho':'*aa','hr':'Zelenortska Republika','ht':'*aa','hu':u('Z\u00f6ld-foki K\u00f6zt\u00e1rsas\u00e1g'),'hy':u('\u053f\u0561\u0562\u0578 \u054e\u0565\u0580\u0564\u0565'),'hz':'*aa','ia':'*aa','id':'Tanjung Verde','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Gr\u00e6nh\u00f6f\u00f0aeyjar'),'it':'Capo Verde','iu':'*aa','iw':'*he','ja':u('\u30ab\u30fc\u30dc\u30d9\u30eb\u30c7'),'ji':u('\u05e7\u05d0\u05b7\u05e4\u05bc\u05d5\u05d5\u05e2\u05e8\u05d3\u05d9\u05e9\u05e2 \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df'),'jv':'*aa','ka':u('\u10d9\u10d0\u10d1\u10dd-\u10d5\u10d4\u10e0\u10d3\u10d4'),'kg':'*aa','ki':'Kepuvede','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u1780\u17b6\u1794\u17cb\u179c\u17c2\u179a'),'kn':u('\u0c95\u0cc7\u0caa\u0ccd \u0cb5\u0cb0\u0ccd\u0ca1\u0cc6'),'ko':u('\uce74\ubcf4\ubca0\ub974\ub370'),'kr':'*aa','ks':u('\u06a9\u06cc\u067e \u0624\u0631\u0691\u06cc'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u041a\u0430\u043f\u0435 \u0412\u0435\u0440\u0434\u0435'),'la':'*aa','lb':'*da','lg':u('Bizinga by\u2019e Kepu Veredi'),'li':'*aa','ln':u('Bisanga bya Kapev\u025br\u025b'),'lo':u('\u0ec0\u0e84\u0e9a \u0ec0\u0ea7\u0eb5\u0e94'),'lt':u('\u017daliasis Ky\u0161ulys'),'lu':'Lutanda lua Kapevele','lv':'Kaboverde','mg':'Nosy Cap-Vert','mh':'*aa','mi':'*aa','mk':u('\u0417\u0435\u043b\u0435\u043d \u2019\u0420\u0442'),'ml':u('\u0d15\u0d47\u0d2a\u0d4d\u0d2a\u0d4d \u0d35\u0d47\u0d7c\u0d21\u0d4d'),'mn':'*ce','mo':'Capul Verde','mr':u('\u0915\u0947\u092a \u0935\u094d\u0939\u0930\u094d\u0921\u0947'),'ms':'*aa','mt':'*aa','my':u('\u1000\u102d\u1010\u103a\u1017\u102c\u1012\u102e'),'na':'*aa','nb':'Kapp Verde','nd':'Cape Verde Islands','ne':u('\u0915\u0947\u092a \u092d\u0930\u094d\u0921\u0947'),'ng':'*aa','nl':'*fy','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b47\u0b2a\u0b4d \u0b2d\u0b30\u0b4d\u0b26\u0b47'),'os':'*aa','pa':u('\u0a15\u0a47\u0a2a \u0a35\u0a30\u0a21\u0a47'),'pi':'*aa','pl':u('Republika Zielonego Przyl\u0105dka'),'ps':u('\u06a9\u06cc\u067e \u0648\u0631\u062f'),'pt':'*cy','qu':'*aa','rm':'*ca','rn':'Ibirwa bya Kapuveri','ro':'*mo','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u064a\u067e \u0648\u0631\u062f\u064a'),'se':'*da','sg':u('Az\u00fb\u00e2 t\u00ee K\u00e2po-V\u00eare'),'si':u('\u0d9a\u0dda\u0db4\u0dca \u0dc0\u0dbb\u0dca\u0da9\u0dca'),'sk':'*cs','sl':'Zelenortski otoki','sm':'*aa','sn':'Zvitsuwa zveCape Verde','so':'*nd','sq':u('Kepi i Gjelb\u00ebr'),'sr':u('\u0417\u0435\u043b\u0435\u043d\u043e\u0440\u0442\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':u('\u0b95\u0bc7\u0baa\u0bcd \u0bb5\u0bc6\u0bb0\u0bcd\u0b9f\u0bc7'),'te':u('\u0c15\u0c47\u0c2a\u0c4d \u0c35\u0c46\u0c30\u0c4d\u0c21\u0c46'),'tg':'*ce','th':u('\u0e40\u0e04\u0e1b\u0e40\u0e27\u0e34\u0e23\u0e4c\u0e14'),'ti':'*am','tk':'Kabo-Werde','tl':'*aa','tn':'*aa','to':u('Mui\u02bbi V\u0113te'),'tr':'*aa','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u064a\u06d0\u0634\u0649\u0644 \u062a\u06c7\u0645\u0634\u06c7\u0642'),'uk':'*ce','ur':u('\u06a9\u06cc\u067e \u0648\u0631\u0688\u06cc'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Kabo Werde','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Et\u00edokun K\u00e1p\u00e9 f\u00e9nd\u00e8'),'za':'*aa','zh':u('\u4f5b\u5f97\u89d2'),'zu':'i-Cape Verde',},
  'CW': {'aa':u('Cura\u00e7ao'),'ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u12a9\u122b\u1233\u12ce'),'an':'*aa','ar':u('\u0643\u0648\u0631\u0627\u0633\u0627\u0648'),'as':u('\u0995\u09c1\u09f0\u09be\u0995\u09be\u0993'),'av':'*aa','ay':'*aa','az':'Kurasao','ba':'*aa','be':u('\u041a\u044e\u0440\u0430\u0441\u0430\u0430'),'bg':u('\u041a\u044e\u0440\u0430\u0441\u0430\u043e'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u0995\u09c1\u09b0\u09be\u09b8\u09be\u0993'),'bo':'*aa','br':'*aa','bs':'*az','ca':'*aa','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f40\u0fb1\u0f71\u0f74\u0f62\u0f0b\u0f62\u0f0b\u0f40\u0f7c'),'ee':'*aa','el':u('\u039a\u03bf\u03c5\u03c1\u03b1\u03c3\u03ac\u03bf'),'en':'*aa','eo':'*aa','es':'Curazao','et':'*aa','eu':'*aa','fa':u('\u06a9\u0648\u0631\u0627\u0633\u0627\u0626\u0648'),'ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':u('\u0a95\u0acd\u0aaf\u0ac1\u0ab0\u0abe\u0ab8\u0abe\u0a93'),'gv':'*aa','ha':'*aa','he':u('\u05e7\u05d5\u05e8\u05d0\u05e1\u05d0\u05d5'),'hi':u('\u0915\u094d\u092f\u0942\u0930\u093e\u0938\u093e\u0913'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u053f\u0575\u0578\u0582\u0580\u0561\u057d\u0561\u0578'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'Curacao','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30ad\u30e5\u30e9\u30bd\u30fc'),'ji':u('\u05e7\u05d5\u05e8\u05d0\u05b7\u05e1\u05d0\u05b7\u05d0'),'jv':'*aa','ka':u('\u10d9\u10d8\u10e3\u10e0\u10d0\u10e1\u10d0\u10dd'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1780\u17bc\u179a\u17c9\u17b6\u1780\u17c5'),'kn':u('\u0c95\u0cc1\u0cb0\u0cbe\u0c95\u0cbe\u0cb5\u0ccd'),'ko':u('\ud034\ub77c\uc18c'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0e84\u0eb9\u0ea3\u0eb2\u0e8a\u0eb2\u0ea7'),'lt':'Kiurasao','lu':'*aa','lv':'Kirasao','mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u041a\u0443\u0440\u0430\u0441\u0430\u043e'),'ml':u('\u0d15\u0d41\u0d31\u0d3e\u0d15\u0d3e\u0d35\u0d4b'),'mn':'*bg','mo':'*aa','mr':u('\u0915\u094d\u092f\u0941\u0930\u093e\u0938\u093e\u0913'),'ms':'*is','mt':'*aa','my':u('\u1000\u103b\u1030\u101b\u1031\u1038\u1000\u102d\u102f\u1038\u1005\u103a'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0915\u0941\u0930\u093e\u0915\u093e\u0913'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b41\u0b30\u0b3e\u0b15\u0b3e\u0b13'),'os':'*aa','pa':u('\u0a15\u0a41\u0a30\u0a3e\u0a15\u0a3e\u0a13'),'pi':'*aa','pl':'*aa','ps':u('\u06a9\u0648\u06a9\u0648\u06a9\u0627'),'pt':'*aa','qu':'*es','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u064a\u0648\u0631\u0627\u0633\u0627\u0626\u0648'),'se':'*aa','sg':'*aa','si':u('\u0d9a\u0dd4\u0dbb\u0d9a\u0dcf\u0dc0\u0ddd'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':u('Kura\u00e7ao'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*is','ta':u('\u0b95\u0bc1\u0bb0\u0bbe\u0b95\u0bb5\u0bcd'),'te':u('\u0c15\u0c41\u0c30\u0c3e\u0c15\u0c35\u0c4b'),'tg':'*bg','th':u('\u0e04\u0e39\u0e23\u0e32\u0e40\u0e0b\u0e32'),'ti':u('\u12a9\u122b\u12ab\u12ce'),'tk':u('K\u00fdurasao'),'tl':'*aa','tn':'*aa','to':'Kulasao','tr':'*aa','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0643\u06c7\u0631\u0627\u0686\u0627\u06cb'),'uk':'*bg','ur':u('\u06a9\u06cc\u0648\u0631\u0627\u06a9\u0627\u0624'),'uz':'Kyurasao','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Kursawo','xh':'*aa','yi':'*ji','yo':'*aa','za':'*aa','zh':u('\u5e93\u62c9\u7d22'),'zu':u('i-Cura\u00e7ao'),},
  'CX': {'aa':'Christmas Island','ab':'*aa','ae':'*aa','af':'Kerseiland','ak':'*aa','am':u('\u12e8\u1308\u1293 \u12f0\u1234\u1275'),'an':'*aa','ar':u('\u062c\u0632\u064a\u0631\u0629 \u0643\u0631\u064a\u0633\u0645\u0627\u0633'),'as':u('\u0996\u09cd\u09f0\u09c0\u09b7\u09cd\u099f\u09ae\u09be\u099b \u09a6\u09cd\u09ac\u09c0\u09aa'),'av':'*aa','ay':'*aa','az':u('Milad adas\u0131'),'ba':'*aa','be':u('\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u041a\u0430\u043b\u044f\u0434'),'bg':u('\u043e\u0441\u0442\u0440\u043e\u0432 \u0420\u043e\u0436\u0434\u0435\u0441\u0442\u0432\u043e'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u0995\u09cd\u09b0\u09bf\u09b8\u09ae\u09be\u09b8 \u09a6\u09cd\u09ac\u09c0\u09aa'),'bo':'*aa','br':'Enez Christmas','bs':u('Bo\u017ei\u0107no ostrvo'),'ca':'Illa Christmas','ce':u('\u0413\u04c0\u0430\u0439\u0440\u0435 \u04cf\u0438\u0441\u0430 \u043f\u0430\u0439\u0445\u04cf\u0430\u043c\u0430\u0440 \u0432\u0438\u043d\u0430 \u0434\u0435'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('V\u00e1no\u010dn\u00ed ostrov'),'cu':'*aa','cv':'*aa','cy':'Ynys y Nadolig','da':u('Jule\u00f8en'),'de':'Weihnachtsinsel','dv':'*aa','dz':u('\u0f41\u0f72\u0f0b\u0f62\u0f72\u0f66\u0f9f\u0f0b\u0f58\u0f7a\u0f66\u0f0b\u0f58\u0f5a\u0f7c\u0f0b\u0f42\u0fb3\u0f72\u0f44'),'ee':u('Kristmas \u0192udomekpo nutome'),'el':u('\u039d\u03ae\u03c3\u03bf\u03c2 \u03c4\u03c9\u03bd \u03a7\u03c1\u03b9\u03c3\u03c4\u03bf\u03c5\u03b3\u03ad\u03bd\u03bd\u03c9\u03bd'),'en':'*aa','eo':'*aa','es':'Isla de Navidad','et':u('J\u00f5ulusaar'),'eu':'Christmas uhartea','fa':u('\u062c\u0632\u06cc\u0631\u0647\u0654 \u06a9\u0631\u06cc\u0633\u0645\u0633'),'ff':'*aa','fi':'Joulusaari','fj':'*aa','fo':u('J\u00f3laoyggjin'),'fr':u('\u00cele Christmas'),'fy':'Krysteilan','ga':u('Oile\u00e1n na Nollag'),'gd':'Eilean na Nollaig','gl':'Illa de Nadal','gn':'*aa','gu':u('\u0a95\u0acd\u0ab0\u0abf\u0ab8\u0aae\u0ab8 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1'),'gv':'*aa','ha':'*aa','he':u('\u05d0\u05d9 \u05d7\u05d2 \u05d4\u05de\u05d5\u05dc\u05d3'),'hi':u('\u0915\u094d\u0930\u093f\u0938\u092e\u0938 \u0926\u094d\u0935\u0940\u092a'),'ho':'*aa','hr':u('Bo\u017ei\u0107ni otok'),'ht':'*aa','hu':u('Kar\u00e1csony-sziget'),'hy':u('\u054d\u0578\u0582\u0580\u0562 \u053e\u0576\u0576\u0564\u0575\u0561\u0576 \u056f\u0572\u0566\u056b'),'hz':'*aa','ia':'*aa','id':'Pulau Christmas','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('J\u00f3laey'),'it':'Isola Christmas','iu':'*aa','iw':'*he','ja':u('\u30af\u30ea\u30b9\u30de\u30b9\u5cf6'),'ji':'*aa','jv':'*aa','ka':u('\u10e8\u10dd\u10d1\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u0420\u043e\u0436\u0434\u0435\u0441\u0442\u0432\u043e \u0430\u0440\u0430\u043b\u044b'),'kl':'*aa','km':u('\u1780\u17c4\u17c7\u200b\u1782\u17d2\u179a\u17b8\u179f\u17d2\u1798\u17b6\u179f'),'kn':u('\u0c95\u0ccd\u0cb0\u0cbf\u0cb8\u0ccd\u0cae\u0cb8\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa'),'ko':u('\ud06c\ub9ac\uc2a4\ub9c8\uc2a4\uc12c'),'kr':'*aa','ks':u('\u06a9\u0631\u0650\u0633\u0645\u064e\u0633 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':u('Chr\u00ebschtdagsinsel'),'lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0ec0\u0e81\u0eb2\u0eb0\u0e84\u0ea3\u0eb4\u0eaa\u0ea1\u0eb2\u0e94'),'lt':u('Kal\u0117d\u0173 Sala'),'lu':'*aa','lv':u('Ziemsv\u0113tku sala'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0411\u043e\u0436\u0438\u045c\u0435\u043d \u041e\u0441\u0442\u0440\u043e\u0432'),'ml':u('\u0d15\u0d4d\u0d30\u0d3f\u0d38\u0d4d\u0d2e\u0d38\u0d4d \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d4d'),'mn':u('\u0417\u0443\u043b \u0441\u0430\u0440\u044b\u043d \u0430\u0440\u0430\u043b'),'mo':'Insula Christmas','mr':u('\u0916\u094d\u0930\u093f\u0938\u092e\u0938 \u092c\u0947\u091f'),'ms':'Pulau Krismas','mt':u('il-G\u017cira Christmas'),'my':u('\u1001\u101b\u1005\u103a\u1005\u1019\u1010\u103a \u1000\u103b\u103d\u1014\u103a\u1038'),'na':'*aa','nb':u('Christmas\u00f8ya'),'nd':'*aa','ne':u('\u0915\u094d\u0930\u093f\u0937\u094d\u091f\u092e\u0938 \u091f\u093e\u092a\u0941'),'ng':'*aa','nl':'Christmaseiland','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b16\u0b4d\u0b30\u0b40\u0b37\u0b4d\u0b1f\u0b2e\u0b3e\u0b38 \u0b26\u0b4d\u0b71\u0b40\u0b2a'),'os':'*aa','pa':u('\u0a15\u0a4d\u0a30\u0a3f\u0a38\u0a2e\u0a3f\u0a38 \u0a1f\u0a3e\u0a2a\u0a42'),'pi':'*aa','pl':u('Wyspa Bo\u017cego Narodzenia'),'ps':u('\u062f \u06a9\u0631\u06cc\u0633\u0627\u0633 \u067c\u0627\u067e\u0648'),'pt':'Ilha Christmas','qu':'Isla Christmas','rm':'Insla da Christmas','rn':'*aa','ro':'*mo','ru':u('\u043e-\u0432 \u0420\u043e\u0436\u0434\u0435\u0441\u0442\u0432\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u0631\u0633\u0645\u0633 \u067b\u064a\u067d'),'se':'Juovllat-sullot','sg':'*aa','si':u('\u0d9a\u0dca\u200d\u0dbb\u0dd2\u0dc3\u0dca\u0db8\u0dc3\u0dca \u0daf\u0dd6\u0db4\u0dad'),'sk':u('Viano\u010dn\u00fd ostrov'),'sl':u('Bo\u017ei\u010dni otok'),'sm':'*aa','sn':'*aa','so':'*aa','sq':'Ishulli i Krishtlindjes','sr':u('\u0411\u043e\u0436\u0438\u045b\u043d\u043e \u041e\u0441\u0442\u0440\u0432\u043e'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Jul\u00f6n'),'sw':'Kisiwa cha Krismasi','ta':u('\u0b95\u0bbf\u0bb1\u0bbf\u0bb8\u0bcd\u0ba4\u0bc1\u0bae\u0bb8\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1'),'te':u('\u0c15\u0c4d\u0c30\u0c3f\u0c38\u0c4d\u0c2e\u0c38\u0c4d \u0c26\u0c40\u0c35\u0c3f'),'tg':u('\u04b6\u0430\u0437\u0438\u0440\u0430\u0438 \u041a\u0440\u0438\u0441\u043c\u0430\u0441'),'th':u('\u0e40\u0e01\u0e32\u0e30\u0e04\u0e23\u0e34\u0e2a\u0e15\u0e4c\u0e21\u0e32\u0e2a'),'ti':u('\u12f0\u1234\u1273\u1275 \u12ad\u122a\u1235\u1275\u121b\u1235'),'tk':u('Ro\u017edestwo adasy'),'tl':'*aa','tn':'*aa','to':'Motu Kilisimasi','tr':u('Christmas Adas\u0131'),'ts':'*aa','tt':u('\u0420\u0430\u0448\u0442\u0443\u0430 \u0443\u0442\u0440\u0430\u0432\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0645\u0649\u0644\u0627\u062f \u0626\u0627\u0631\u0649\u0644\u0649'),'uk':u('\u041e\u0441\u0442\u0440\u0456\u0432 \u0420\u0456\u0437\u0434\u0432\u0430'),'ur':u('\u062c\u0632\u06cc\u0631\u06c1 \u06a9\u0631\u0633\u0645\u0633'),'uz':'Rojdestvo oroli','ve':'*aa','vi':u('\u0110\u1ea3o Gi\u00e1ng Sinh'),'vo':'*aa','wa':'*aa','wo':'Dunu Kirismas','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5723\u8bde\u5c9b'),'zu':'i-Christmas Island',},
  'CY': {'aa':'Cyprus','ab':'*aa','ae':'*aa','af':'Siprus','ak':u('Saepr\u0254s'),'am':u('\u1233\u12ed\u1355\u1228\u1235'),'an':'*aa','ar':u('\u0642\u0628\u0631\u0635'),'as':u('\u099a\u09be\u0987\u09aa\u09cd\u09f0\u09be\u099b'),'av':'*aa','ay':'*aa','az':'Kipr','ba':'*aa','be':u('\u041a\u0456\u043f\u0440'),'bg':u('\u041a\u0438\u043f\u044a\u0440'),'bh':'*aa','bi':'*aa','bm':'Cipri','bn':u('\u09b8\u09be\u0987\u09aa\u09cd\u09b0\u09be\u09b8'),'bo':'*aa','br':'Kiprenez','bs':'Kipar','ca':'Xipre','ce':u('\u041a\u0438\u043f\u0440'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Kypr','cu':'*aa','cv':'*aa','cy':'*aa','da':'Cypern','de':'Zypern','dv':'*aa','dz':u('\u0f66\u0f71\u0f60\u0f72\u0f0b\u0f54\u0fb2\u0f66'),'ee':'Saiprus nutome','el':u('\u039a\u03cd\u03c0\u03c1\u03bf\u03c2'),'en':'*aa','eo':'Kipro','es':'Chipre','et':u('K\u00fcpros'),'eu':'Zipre','fa':u('\u0642\u0628\u0631\u0633'),'ff':'Siipar','fi':'Kypros','fj':'*aa','fo':u('K\u00fdpros'),'fr':'Chypre','fy':'Syprus','ga':'an Chipir','gd':u('C\u00ecopras'),'gl':'*es','gn':'*aa','gu':u('\u0ab8\u0abe\u0aaf\u0aaa\u0acd\u0ab0\u0ab8'),'gv':'*aa','ha':'Sifurus','he':u('\u05e7\u05e4\u05e8\u05d9\u05e1\u05d9\u05df'),'hi':u('\u0938\u093e\u0907\u092a\u094d\u0930\u0938'),'ho':'*aa','hr':'Cipar','ht':'*aa','hu':'Ciprus','hy':u('\u053f\u056b\u057a\u0580\u0578\u057d'),'hz':'*aa','ia':'*aa','id':'*af','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*af','io':'*aa','is':u('K\u00fdpur'),'it':'Cipro','iu':'*aa','iw':'*he','ja':u('\u30ad\u30d7\u30ed\u30b9'),'ji':'*aa','jv':'*aa','ka':u('\u10d9\u10d5\u10d8\u10de\u10e0\u10dd\u10e1\u10d8'),'kg':'*aa','ki':'Kuprosi','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u179f\u17ca\u17b8\u1794'),'kn':u('\u0cb8\u0cc8\u0caa\u0ccd\u0cb0\u0cb8\u0ccd'),'ko':u('\ud0a4\ud504\ub85c\uc2a4'),'kr':'*aa','ks':u('\u0633\u0627\u06cc\u0641\u0631\u065b\u0633'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*de','lg':'Sipuriya','li':'*aa','ln':u('S\u00edp\u025bl\u025b'),'lo':u('\u0ec4\u0e8a\u0e9b\u0ea3\u0eb1\u0eaa'),'lt':'Kipras','lu':'Shipele','lv':'Kipra','mg':'Sypra','mh':'*aa','mi':'*aa','mk':u('\u041a\u0438\u043f\u0430\u0440'),'ml':u('\u0d38\u0d48\u0d2a\u0d4d\u0d30\u0d38\u0d4d'),'mn':'*ce','mo':'Cipru','mr':u('\u0938\u093e\u092f\u092a\u094d\u0930\u0938'),'ms':'*aa','mt':u('\u010aipru'),'my':u('\u1006\u102d\u102f\u1000\u103a\u1015\u101b\u1015\u103a\u1005\u103a'),'na':'*aa','nb':'*fi','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*fi','no':'*fi','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b3e\u0b07\u0b2a\u0b4d\u0b30\u0b38\u0b4d'),'os':'*aa','pa':u('\u0a38\u0a3e\u0a07\u0a2a\u0a4d\u0a30\u0a38'),'pi':'*aa','pl':'Cypr','ps':'*fa','pt':'*es','qu':'*es','rm':'Cipra','rn':'Izinga rya Shipure','ro':'*mo','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u0627\u0626\u067e\u0631\u0633'),'se':'*fi','sg':u('S\u00eepri'),'si':u('\u0dc3\u0dba\u0dd2\u0db4\u0dca\u200d\u0dbb\u0dc3\u0dba'),'sk':'*aa','sl':'Ciper','sm':'*aa','sn':'*aa','so':'Qubrus','sq':'Qipro','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':u('\u0b9a\u0bc8\u0baa\u0bcd\u0bb0\u0bb8\u0bcd'),'te':u('\u0c38\u0c48\u0c2a\u0c4d\u0c30\u0c38\u0c4d'),'tg':'*ce','th':u('\u0e44\u0e0b\u0e1b\u0e23\u0e31\u0e2a'),'ti':'*am','tk':'*az','tl':'*aa','tn':'*aa','to':'Saipalesi','tr':u('K\u0131br\u0131s'),'ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u0633\u0649\u067e\u0631\u06c7\u0633'),'uk':'*be','ur':'*ar','uz':'*az','ve':'*aa','vi':u('S\u00edp'),'vo':'*aa','wa':'*aa','wo':'*ff','xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de K\u00far\u00fas\u00ec'),'za':'*aa','zh':u('\u585e\u6d66\u8def\u65af'),'zu':'i-Cyprus',},
  'CZ': {'aa':'Czech Republic','ab':'*aa','ae':'*aa','af':u('Tsjeggi\u00eb'),'ak':u('Ky\u025bk Kurok\u025bse'),'am':u('\u127c\u127d\u1292\u12eb'),'an':'*aa','ar':u('\u0627\u0644\u062a\u0634\u064a\u0643'),'as':u('\u099a\u09bf\u099c\u09c7\u099a\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':u('\u00c7exiya'),'ba':'*aa','be':u('\u0427\u044d\u0445\u0456\u044f'),'bg':u('\u0427\u0435\u0445\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Ceki republiki','bn':u('\u099a\u09c7\u099a\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'Tchekia','bs':u('\u010ce\u0161ka'),'ca':u('Tx\u00e8quia'),'ce':u('\u0427\u0435\u0445\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('\u010cesko'),'cu':'*aa','cv':'*aa','cy':'Tsiecia','da':'Tjekkiet','de':'Tschechien','dv':'*aa','dz':u('\u0f45\u0f7a\u0f40\u0f0b \u0f62\u0f72\u0f0b\u0f54\u0f56\u0f0b\u0f63\u0f72\u0f40'),'ee':u('Ts\u025bk rep\u0254blik nutome'),'el':u('\u03a4\u03c3\u03b5\u03c7\u03af\u03b1'),'en':'Czechia','eo':u('\u0108e\u0125ujo'),'es':'Chequia','et':u('T\u0161ehhi'),'eu':'Txekia','fa':u('\u062c\u0645\u0647\u0648\u0631\u06cc \u0686\u06a9'),'ff':'Ndenndaandi Cek','fi':u('T\u0161ekki'),'fj':'*aa','fo':'Kekkia','fr':u('Tch\u00e9quie'),'fy':'Tsjechje','ga':'An tSeicia','gd':'An t-Seic','gl':'*es','gn':'*aa','gu':u('\u0a9a\u0ac7\u0a95\u0ac0\u0aaf\u0abe'),'gv':'*aa','ha':'Jamhuriyar Cak','he':u('\u05e6\u05f3\u05db\u05d9\u05d4'),'hi':u('\u091a\u0947\u0915\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Csehorsz\u00e1g'),'hy':u('\u0549\u0565\u056d\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'Ceko','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('T\u00e9kkland'),'it':'Cechia','iu':'*aa','iw':'*he','ja':u('\u30c1\u30a7\u30b3'),'ji':u('\u05d8\u05e9\u05e2\u05db\u05d9\u05d9'),'jv':'*aa','ka':u('\u10e9\u10d4\u10ee\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'Jamhuri ya Cheki','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1786\u17c2\u1782\u17b6'),'kn':u('\u0c9d\u0cc6\u0c95\u0cbf\u0caf\u0cbe'),'ko':u('\uccb4\ucf54'),'kr':'*aa','ks':u('\u0686\u06cc\u06a9 \u062c\u064e\u0645\u0648\u0657\u0631\u0650\u06cc\u064e\u062a'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*de','lg':'Lipubulika ya Ceeka','li':'*aa','ln':'Shekia','lo':u('\u0ec0\u0e8a\u0eb1\u0e81\u0ec0\u0e8a\u0e8d'),'lt':u('\u010cekija'),'lu':'Ditunga dya Tsheka','lv':u('\u010cehija'),'mg':u('Repoblikan\u2019i Tseky'),'mh':'*aa','mi':'*aa','mk':u('\u0427\u0435\u0448\u043a\u0430'),'ml':u('\u0d1a\u0d46\u0d15\u0d4d\u0d15\u0d3f\u0d2f'),'mn':u('\u0427\u0435\u0445'),'mo':'Cehia','mr':u('\u091d\u0947\u0915\u093f\u092f\u093e'),'ms':'*en','mt':u('ir-Repubblika \u010aeka'),'my':u('\u1001\u103b\u1000\u103a\u1000\u102e\u101a\u102c\u1038'),'na':'*aa','nb':'Tsjekkia','nd':'*aa','ne':'*hi','ng':'*aa','nl':u('Tsjechi\u00eb'),'nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b1a\u0b47\u0b1a\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a1a\u0a48\u0a15\u0a40\u0a06'),'pi':'*aa','pl':'Czechy','ps':u('\u0686\u06a9\u06cc\u0627'),'pt':u('Tch\u00e9quia'),'qu':'*aa','rm':'Republica Tscheca','rn':'Repubulika ya Ceke','ro':'*mo','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0686\u064a\u06aa\u064a\u0627'),'se':u('\u010ceahkka'),'sg':u('K\u00f6d\u00f6r\u00f6s\u00ease t\u00ee Ty\u00eaki'),'si':u('\u0da0\u0dd9\u0d9a\u0dca \u0da2\u0db1\u0dbb\u0da2\u0dba'),'sk':'*cs','sl':'*bs','sm':'*aa','sn':'*aa','so':'Jamhuuriyadda Jek','sq':u('\u00c7eki'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'Tjeckien','sw':'Chechia','ta':u('\u0b9a\u0bc6\u0b9a\u0bbf\u0baf\u0bbe'),'te':u('\u0c1a\u0c46\u0c15\u0c3f\u0c2f\u0c3e'),'tg':u('\u04b6\u0443\u043c\u04b3\u0443\u0440\u0438\u0438 \u0427\u0435\u0445'),'th':u('\u0e40\u0e0a\u0e47\u0e01'),'ti':u('\u127c\u12ad \u122a\u1353\u1265\u120a\u12ad'),'tk':u('\u00c7ehi\u00fda'),'tl':'*en','tn':'*aa','to':u('S\u0113kia'),'tr':u('\u00c7ekya'),'ts':'*aa','tt':u('\u0427\u0435\u0445\u0438\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0686\u06d0\u062e \u062c\u06c7\u0645\u06be\u06c7\u0631\u0649\u064a\u0649\u062a\u0649'),'uk':u('\u0427\u0435\u0445\u0456\u044f'),'ur':u('\u0686\u06cc\u06a9\u06cc\u0627'),'uz':'Chexiya','ve':'*aa','vi':u('S\u00e9c'),'vo':'*aa','wa':'*aa','wo':u('R\u00e9ewum Cek'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de \u1e63\u1eb9\u0301\u1eb9\u0301k\u00ec'),'za':'*aa','zh':u('\u6377\u514b'),'zu':'i-Czechia',},
  'DE': {'aa':'Germany','ab':'*aa','ae':'*aa','af':'Duitsland','ak':'Gyaaman','am':u('\u1300\u122d\u1218\u1295'),'an':'*aa','ar':u('\u0623\u0644\u0645\u0627\u0646\u064a\u0627'),'as':u('\u099c\u09be\u09f0\u09cd\u09ae\u09be\u09a8\u09c0'),'av':'*aa','ay':'*aa','az':'Almaniya','ba':'*aa','be':u('\u0413\u0435\u0440\u043c\u0430\u043d\u0456\u044f'),'bg':u('\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':u('Alima\u0272i'),'bn':u('\u099c\u09be\u09b0\u09cd\u09ae\u09be\u09a8\u09bf'),'bo':u('\u0f60\u0f47\u0f62\u0f0b\u0f58\u0f53\u0f0b'),'br':'Alamagn','bs':u('Njema\u010dka'),'ca':'Alemanya','ce':u('\u0413\u0435\u0440\u043c\u0430\u043d\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('N\u011bmecko'),'cu':'*aa','cv':'*aa','cy':'Yr Almaen','da':'Tyskland','de':'Deutschland','dv':'*aa','dz':u('\u0f47\u0f71\u0f62\u0f0b\u0f58\u0f0b\u0f53\u0f72'),'ee':'Germania nutome','el':u('\u0393\u03b5\u03c1\u03bc\u03b1\u03bd\u03af\u03b1'),'en':'*aa','eo':'Germanujo','es':'Alemania','et':'Saksamaa','eu':'*es','fa':u('\u0622\u0644\u0645\u0627\u0646'),'ff':u('Almaa\u00f1'),'fi':'Saksa','fj':'*aa','fo':u('T\u00fdskland'),'fr':'Allemagne','fy':u('D\u00fatsl\u00e2n'),'ga':u('an Ghearm\u00e1in'),'gd':u('A\u2019 Ghearmailt'),'gl':u('Alema\u00f1a'),'gn':'*aa','gu':u('\u0a9c\u0ab0\u0acd\u0aae\u0aa8\u0ac0'),'gv':'*aa','ha':'Jamus','he':u('\u05d2\u05e8\u05de\u05e0\u05d9\u05d4'),'hi':u('\u091c\u0930\u094d\u092e\u0928\u0940'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('N\u00e9metorsz\u00e1g'),'hy':u('\u0533\u0565\u0580\u0574\u0561\u0576\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'Jerman','ie':'*aa','ig':'*aa','ii':u('\ua113\ua1e9'),'ik':'*aa','in':'*id','io':'*aa','is':u('\u00de\u00fdskaland'),'it':'Germania','iu':'*aa','iw':'*he','ja':u('\u30c9\u30a4\u30c4'),'ji':u('\u05d3\u05d9\u05d9\u05d8\u05e9\u05dc\u05d0\u05b7\u05e0\u05d3'),'jv':'*aa','ka':u('\u10d2\u10d4\u10e0\u10db\u10d0\u10dc\u10d8\u10d0'),'kg':'*aa','ki':'Njeremani','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a2\u17b6\u179b\u17d2\u179b\u17ba\u1798\u17c9\u1784\u17cb'),'kn':u('\u0c9c\u0cb0\u0ccd\u0cae\u0ca8\u0cbf'),'ko':u('\ub3c5\uc77c'),'kr':'*aa','ks':u('\u062c\u0631\u0645\u0654\u0646\u06cc'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':u('D\u00e4itschland'),'lg':'Budaaki','li':'*aa','ln':'Alemani','lo':u('\u0ec0\u0ea2\u0e8d\u0ea5\u0eb0\u0ea1\u0eb1\u0e99'),'lt':'Vokietija','lu':'Alemanu','lv':u('V\u0101cija'),'mg':'Alemaina','mh':'*aa','mi':'*aa','mk':u('\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u0458\u0430'),'ml':u('\u0d1c\u0d7c\u0d2e\u0d4d\u0d2e\u0d28\u0d3f'),'mn':u('\u0413\u0435\u0440\u043c\u0430\u043d'),'mo':'*it','mr':'*hi','ms':'*id','mt':u('il-\u0120ermanja'),'my':u('\u1002\u103b\u102c\u1019\u1014\u102e'),'na':'*aa','nb':'*da','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*af','nn':'*da','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28\u0b40'),'os':'*mn','pa':u('\u0a1c\u0a30\u0a2e\u0a28\u0a40'),'pi':'*aa','pl':'Niemcy','ps':u('\u0627\u0644\u0645\u0627\u0646'),'pt':'Alemanha','qu':'*es','rm':'*it','rn':'Ubudage','ro':'*it','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u062c\u0631\u0645\u0646\u064a'),'se':'Duiska','sg':u('Z\u00e2mani'),'si':u('\u0da2\u0dbb\u0dca\u0db8\u0db1\u0dd2\u0dba'),'sk':'Nemecko','sl':u('Nem\u010dija'),'sm':'*aa','sn':'*aa','so':'Jarmal','sq':'Gjermani','sr':u('\u041d\u0435\u043c\u0430\u0447\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'Ujerumani','ta':u('\u0b9c\u0bc6\u0bb0\u0bcd\u0bae\u0ba9\u0bbf'),'te':u('\u0c1c\u0c30\u0c4d\u0c2e\u0c28\u0c40'),'tg':'*bg','th':u('\u0e40\u0e22\u0e2d\u0e23\u0e21\u0e19\u0e35'),'ti':'*am','tk':u('Germani\u00fda'),'tl':'*aa','tn':'*aa','to':'Siamane','tr':'Almanya','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u06af\u06d0\u0631\u0645\u0627\u0646\u0649\u064a\u06d5'),'uk':u('\u041d\u0456\u043c\u0435\u0447\u0447\u0438\u043d\u0430'),'ur':u('\u062c\u0631\u0645\u0646\u06cc'),'uz':'Germaniya','ve':'*aa','vi':u('\u0110\u1ee9c'),'vo':'*aa','wa':'*aa','wo':'*ff','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Gemani'),'za':'*aa','zh':u('\u5fb7\u56fd'),'zu':'i-Germany',},
  'DJ': {'aa':'Djibouti','ab':'*aa','ae':'*aa','af':'Djiboeti','ak':'Gyibuti','am':u('\u1302\u1261\u1272'),'an':'*aa','ar':u('\u062c\u064a\u0628\u0648\u062a\u064a'),'as':u('\u099c\u09bf\u09ac\u09c1\u099f\u09bf'),'av':'*aa','ay':'*aa','az':'Cibuti','ba':'*aa','be':u('\u0414\u0436\u044b\u0431\u0443\u0446\u0456'),'bg':u('\u0414\u0436\u0438\u0431\u0443\u0442\u0438'),'bh':'*aa','bi':'*aa','bm':'Jibuti','bn':u('\u099c\u09bf\u09ac\u09c1\u09a4\u09bf'),'bo':'*aa','br':'*aa','bs':u('D\u017eibuti'),'ca':'*aa','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':u('D\u017eibutsko'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Dschibuti','dv':'*aa','dz':u('\u0f47\u0f72\u0f0b\u0f56\u0fb7\u0f74\u0f0b\u0f4a\u0f72'),'ee':'Dzibuti nutome','el':u('\u03a4\u03b6\u03b9\u03bc\u03c0\u03bf\u03c5\u03c4\u03af'),'en':'*aa','eo':u('\u011cibutio'),'es':'Yibuti','et':'*aa','eu':'Djibuti','fa':u('\u062c\u06cc\u0628\u0648\u062a\u06cc'),'ff':'Jibutii','fi':'*aa','fj':'*aa','fo':'*eu','fr':'*aa','fy':'*aa','ga':'*aa','gd':u('Diob\u00f9taidh'),'gl':'*eu','gn':'*aa','gu':u('\u0a9c\u0ac0\u0aac\u0acc\u0a9f\u0ac0'),'gv':'*aa','ha':'*bm','he':u('\u05d2\u05f3\u05d9\u05d1\u05d5\u05d8\u05d9'),'hi':u('\u091c\u093f\u092c\u0942\u0924\u0940'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'Dzsibuti','hy':u('\u054b\u056b\u0562\u0578\u0582\u0569\u056b'),'hz':'*aa','ia':'*aa','id':'*bm','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*bm','io':'*aa','is':u('Dj\u00edb\u00fat\u00ed'),'it':'Gibuti','iu':'*aa','iw':'*he','ja':u('\u30b8\u30d6\u30c1'),'ji':u('\u05d3\u05d6\u05e9\u05d9\u05d1\u05d5\u05d8\u05d9'),'jv':'*aa','ka':u('\u10ef\u10d8\u10d1\u10e3\u10e2\u10d8'),'kg':'*aa','ki':'*bm','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1787\u17b8\u1794\u17ca\u17bc\u1791\u17b8'),'kn':u('\u0c9c\u0cbf\u0cac\u0cc2\u0c9f\u0cbf'),'ko':u('\uc9c0\ubd80\ud2f0'),'kr':'*aa','ks':u('\u062c\u0650\u0628\u0648\u0657\u062a\u06cc'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*de','lg':'Jjibuti','li':'*aa','ln':'Dzibuti','lo':u('\u0e88\u0eb4\u0e9a\u0eb9\u0e95\u0eb4'),'lt':u('D\u017eibutis'),'lu':'*eu','lv':u('D\u017eibutija'),'mg':'Djiboti','mh':'*aa','mi':'*aa','mk':u('\u040f\u0438\u0431\u0443\u0442\u0438'),'ml':u('\u0d26\u0d3f\u0d1c\u0d3f\u0d2c\u0d57\u0d1f\u0d4d\u0d1f\u0d3f'),'mn':'*bg','mo':'*aa','mr':u('\u091c\u093f\u092c\u094c\u091f\u0940'),'ms':'*aa','mt':'il-Djibouti','my':u('\u1002\u103b\u102e\u1018\u1030\u1010\u102e'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0921\u093f\u091c\u093f\u092c\u0941\u091f\u0940'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b1c\u0b3f\u0b2c\u0b4b\u0b1f\u0b3f'),'os':'*aa','pa':u('\u0a1c\u0a3c\u0a40\u0a2c\u0a42\u0a24\u0a40'),'pi':'*aa','pl':u('D\u017cibuti'),'ps':u('\u062c\u06cc \u0628\u0648\u062a\u064a'),'pt':'*eu','qu':'*es','rm':'*de','rn':'*bm','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u068a\u062c\u0628\u064a\u0648\u062a\u064a'),'se':'*aa','sg':u('Dibut\u00f9ii'),'si':u('\u0da2\u0dd2\u0db6\u0dd4\u0da7\u0dd2'),'sk':'*cs','sl':'*bs','sm':'*aa','sn':'*aa','so':'Jabuuti','sq':'Xhibuti','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*bm','ta':u('\u0b9c\u0bbf\u0baa\u0bcc\u0b9f\u0bcd\u0b9f\u0bbf'),'te':u('\u0c1c\u0c3f\u0c2c\u0c4c\u0c1f\u0c3f'),'tg':u('\u04b6\u0438\u0431\u0443\u0442\u0438'),'th':u('\u0e08\u0e34\u0e1a\u0e39\u0e15\u0e35'),'ti':'*am','tk':'*bm','tl':'*aa','tn':'*aa','to':'Siputi','tr':'*az','ts':'*aa','tt':u('\u0496\u0438\u0431\u04af\u0442\u0438'),'tw':'*aa','ty':'*aa','ug':u('\u062c\u0649\u0628\u06c7\u062a\u0649'),'uk':u('\u0414\u0436\u0438\u0431\u0443\u0442\u0456'),'ur':u('\u062c\u0628\u0648\u062a\u06cc'),'uz':'*bm','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*bm','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de D\u00edb\u1ecd\u0301\u00f3t\u00ec'),'za':'*aa','zh':u('\u5409\u5e03\u63d0'),'zu':'i-Djibouti',},
  'DK': {'aa':'Denmark','ab':'*aa','ae':'*aa','af':'Denemarke','ak':u('D\u025bnmak'),'am':u('\u12f4\u1295\u121b\u122d\u12ad'),'an':'*aa','ar':u('\u0627\u0644\u062f\u0627\u0646\u0645\u0631\u0643'),'as':u('\u09a1\u09c7\u09a8\u09ae\u09be\u09f0\u09cd\u0995'),'av':'*aa','ay':'*aa','az':'Danimarka','ba':'*aa','be':u('\u0414\u0430\u043d\u0456\u044f'),'bg':u('\u0414\u0430\u043d\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Danemarki','bn':u('\u09a1\u09c7\u09a8\u09ae\u09be\u09b0\u09cd\u0995'),'bo':'*aa','br':'Danmark','bs':'Danska','ca':'Dinamarca','ce':u('\u0414\u0430\u043d\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('D\u00e1nsko'),'cu':'*aa','cv':'*aa','cy':'Denmarc','da':'*br','de':u('D\u00e4nemark'),'dv':'*aa','dz':u('\u0f4c\u0f7a\u0f53\u0f0b\u0f58\u0f71\u0f40'),'ee':'Denmark nutome','el':u('\u0394\u03b1\u03bd\u03af\u03b1'),'en':'*aa','eo':'Danujo','es':'*ca','et':'Taani','eu':'*az','fa':u('\u062f\u0627\u0646\u0645\u0627\u0631\u06a9'),'ff':'*br','fi':'Tanska','fj':'*aa','fo':'*br','fr':'Danemark','fy':'Denemarken','ga':'an Danmhairg','gd':'An Danmhairg','gl':'*ca','gn':'*aa','gu':u('\u0aa1\u0ac7\u0aa8\u0aae\u0abe\u0ab0\u0acd\u0a95'),'gv':'*aa','ha':'*br','he':u('\u05d3\u05e0\u05de\u05e8\u05e7'),'hi':u('\u0921\u0947\u0928\u092e\u093e\u0930\u094d\u0915'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('D\u00e1nia'),'hy':u('\u0534\u0561\u0576\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Danm\u00f6rk'),'it':'Danimarca','iu':'*aa','iw':'*he','ja':u('\u30c7\u30f3\u30de\u30fc\u30af'),'ji':u('\u05d3\u05e2\u05e0\u05de\u05d0\u05b7\u05e8\u05e7'),'jv':'*aa','ka':u('\u10d3\u10d0\u10dc\u10d8\u10d0'),'kg':'*aa','ki':'Denmaki','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u178a\u17b6\u178e\u17ba\u1798\u17c9\u17b6\u1780'),'kn':u('\u0ca1\u0cc6\u0ca8\u0ccd\u0cae\u0cbe\u0cb0\u0ccd\u0c95\u0ccd'),'ko':u('\ub374\ub9c8\ud06c'),'kr':'*aa','ks':u('\u0688\u06cc\u0646\u065b\u0645\u0627\u0631\u0655\u06a9'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*de','lg':'Denimaaka','li':'*aa','ln':u('Dan\u025bmarike'),'lo':u('\u0ec0\u0e94\u0e99\u0ea1\u0eb2\u0e81'),'lt':'Danija','lu':'Danemalaku','lv':u('D\u0101nija'),'mg':'Danmarka','mh':'*aa','mi':'*aa','mk':u('\u0414\u0430\u043d\u0441\u043a\u0430'),'ml':u('\u0d21\u0d46\u0d7b\u0d2e\u0d3e\u0d7c\u0d15\u0d4d\u0d15\u0d4d'),'mn':'*ce','mo':'Danemarca','mr':u('\u0921\u0947\u0928\u094d\u092e\u093e\u0930\u094d\u0915'),'ms':'*aa','mt':'id-Danimarka','my':u('\u1012\u102d\u1014\u103a\u1038\u1019\u1010\u103a'),'na':'*aa','nb':'*br','nd':'Denmakhi','ne':'*hi','ng':'*aa','nl':'*fy','nn':'*br','no':'*br','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b21\u0b47\u0b28\u0b2e\u0b3e\u0b30\u0b4d\u0b15'),'os':'*aa','pa':u('\u0a21\u0a48\u0a28\u0a2e\u0a3e\u0a30\u0a15'),'pi':'*aa','pl':'Dania','ps':u('\u0689\u0646\u0645\u0627\u0631\u06a9'),'pt':'*ca','qu':'*ca','rm':'Danemarc','rn':'Danimariki','ro':'*mo','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u068a\u064a\u0646\u0645\u0627\u0631\u06aa'),'se':u('D\u00e1nm\u00e1rku'),'sg':u('Danem\u00earke'),'si':u('\u0da9\u0dd9\u0db1\u0dca\u0db8\u0dcf\u0dbb\u0dca\u0d9a\u0dba'),'sk':'*cs','sl':'*bs','sm':'*aa','sn':'*aa','so':'*aa','sq':u('Danimark\u00eb'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*br','sw':'*aa','ta':u('\u0b9f\u0bc6\u0ba9\u0bcd\u0bae\u0bbe\u0bb0\u0bcd\u0b95\u0bcd'),'te':u('\u0c21\u0c46\u0c28\u0c4d\u0c2e\u0c3e\u0c30\u0c4d\u0c15\u0c4d'),'tg':'*bg','th':u('\u0e40\u0e14\u0e19\u0e21\u0e32\u0e23\u0e4c\u0e01'),'ti':'*am','tk':u('Dani\u00fda'),'tl':'*aa','tn':'*aa','to':u('Tenima\u02bbake'),'tr':'*az','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u062f\u0627\u0646\u0649\u064a\u06d5'),'uk':'*be','ur':u('\u0688\u0646\u0645\u0627\u0631\u06a9'),'uz':'Daniya','ve':'*aa','vi':u('\u0110an M\u1ea1ch'),'vo':'*aa','wa':'*aa','wo':u('Danm\u00e0rk'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de D\u1eb9\u0301m\u00e1k\u00ec'),'za':'*aa','zh':u('\u4e39\u9ea6'),'zu':'i-Denmark',},
  'DM': {'aa':'Dominica','ab':'*aa','ae':'*aa','af':'*aa','ak':u('D\u0254meneka'),'am':u('\u12f6\u121a\u1292\u12ab'),'an':'*aa','ar':u('\u062f\u0648\u0645\u064a\u0646\u064a\u0643\u0627'),'as':u('\u09a1\u2019\u09ae\u09bf\u09a8\u09bf\u0995\u09be'),'av':'*aa','ay':'*aa','az':'Dominika','ba':'*aa','be':u('\u0414\u0430\u043c\u0456\u043d\u0456\u043a\u0430'),'bg':u('\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430'),'bh':'*aa','bi':'*aa','bm':u('D\u0254miniki'),'bn':u('\u09a1\u09cb\u09ae\u09bf\u09a8\u09bf\u0995\u09be'),'bo':'*aa','br':'*aa','bs':'*az','ca':'*aa','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*az','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f4c\u0f7c\u0f0b\u0f58\u0f72\u0f0b\u0f53\u0f72\u0f0b\u0f40'),'ee':'Dominika nutome','el':u('\u039d\u03c4\u03bf\u03bc\u03af\u03bd\u03b9\u03ba\u03b1'),'en':'*aa','eo':'Dominiko','es':'*aa','et':'*aa','eu':'*az','fa':u('\u062f\u0648\u0645\u06cc\u0646\u06cc\u06a9\u0627'),'ff':'*az','fi':'*aa','fj':'*aa','fo':'*az','fr':'Dominique','fy':'*az','ga':'Doiminice','gd':'Doiminicea','gl':'*aa','gn':'*aa','gu':u('\u0aa1\u0acb\u0aae\u0abf\u0aa8\u0abf\u0a95\u0abe'),'gv':'*aa','ha':'*az','he':u('\u05d3\u05d5\u05de\u05d9\u05e0\u05d9\u05e7\u05d4'),'hi':u('\u0921\u094b\u092e\u093f\u0928\u093f\u0915\u093e'),'ho':'*aa','hr':'*az','ht':'*aa','hu':'*az','hy':u('\u0534\u0578\u0574\u056b\u0576\u056b\u056f\u0561'),'hz':'*aa','ia':'*aa','id':'*az','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*az','io':'*aa','is':u('D\u00f3min\u00edka'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30c9\u30df\u30cb\u30ab\u56fd'),'ji':u('\u05d3\u05d0\u05de\u05d9\u05e0\u05d9\u05e7\u05e2'),'jv':'*aa','ka':u('\u10d3\u10dd\u10db\u10d8\u10dc\u10d8\u10d9\u10d0'),'kg':'*aa','ki':'*az','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u178a\u17bc\u1798\u17b8\u1793\u17b8\u1780'),'kn':u('\u0ca1\u0cca\u0cae\u0cbf\u0ca8\u0cbf\u0c95\u0cbe'),'ko':u('\ub3c4\ubbf8\ub2c8\uce74'),'kr':'*aa','ks':u('\u0688\u0648\u0645\u0650\u0646\u0650\u06a9\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'*az','li':'*aa','ln':u('Dom\u00ednike'),'lo':u('\u0ec2\u0e94\u0ea1\u0eb5\u0e99\u0eb4\u0e84\u0eb2'),'lt':'*az','lu':'Duminiku','lv':'*az','mg':'*az','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d21\u0d4a\u0d2e\u0d3f\u0d28\u0d3f\u0d15\u0d4d\u0d15'),'mn':'*bg','mo':'*aa','mr':'*hi','ms':'*aa','mt':'*aa','my':u('\u1012\u102d\u102f\u1019\u102e\u1014\u102e\u1000\u102c'),'na':'*aa','nb':'*aa','nd':'Dominikha','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b21\u0b4b\u0b2e\u0b3f\u0b28\u0b3f\u0b15\u0b3e'),'os':'*aa','pa':u('\u0a21\u0a4b\u0a2e\u0a40\u0a28\u0a3f\u0a15\u0a3e'),'pi':'*aa','pl':'*az','ps':'*fa','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*az','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u068a\u0648\u0645\u064a\u0646\u064a\u06aa\u0627'),'se':'*aa','sg':u('D\u00f6m\u00efn\u00eeka'),'si':u('\u0da9\u0ddc\u0db8\u0dd2\u0db1\u0dd2\u0d9a\u0dcf\u0dc0'),'sk':'*az','sl':'*az','sm':'*aa','sn':'*aa','so':'Domeenika','sq':u('Dominik\u00eb'),'sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*az','ta':u('\u0b9f\u0bca\u0bae\u0bbf\u0ba9\u0bbf\u0b95\u0bbe'),'te':u('\u0c21\u0c4a\u0c2e\u0c3f\u0c28\u0c3f\u0c15\u0c3e'),'tg':'*bg','th':u('\u0e42\u0e14\u0e21\u0e34\u0e19\u0e34\u0e01\u0e32'),'ti':'*am','tk':'*az','tl':'*aa','tn':'*aa','to':'Tominika','tr':'*az','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u062f\u0648\u0645\u0649\u0646\u0649\u0643\u0627'),'uk':u('\u0414\u043e\u043c\u0456\u043d\u0456\u043a\u0430'),'ur':u('\u0688\u0648\u0645\u0646\u06cc\u06a9\u0627'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Dominik','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de D\u00f2m\u00edn\u00edk\u00e0'),'za':'*aa','zh':u('\u591a\u7c73\u5c3c\u514b'),'zu':'i-Dominica',},
  'DO': {'aa':'Dominican Republic','ab':'*aa','ae':'*aa','af':'Dominikaanse Republiek','ak':u('D\u0254meneka Kurok\u025bse'),'am':u('\u12f6\u1218\u1292\u12ab\u1295 \u122a\u1351\u1265\u120a\u12ad'),'an':'*aa','ar':u('\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u062f\u0648\u0645\u064a\u0646\u064a\u0643\u0627\u0646'),'as':u('\u09a1\u2019\u09ae\u09bf\u09a8\u09bf\u0995\u09be\u09a8 \u09f0\u09bf\u09aa\u09be\u09ac\u09cd\u09b2\u09bf\u0995'),'av':'*aa','ay':'*aa','az':u('Dominikan Respublikas\u0131'),'ba':'*aa','be':u('\u0414\u0430\u043c\u0456\u043d\u0456\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u044d\u0441\u043f\u0443\u0431\u043b\u0456\u043a\u0430'),'bg':u('\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u0440\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430'),'bh':'*aa','bi':'*aa','bm':u('D\u0254mimiki republiki'),'bn':u('\u09a1\u09cb\u09ae\u09c7\u09a8\u09bf\u0995\u09be\u09a8 \u09aa\u09cd\u09b0\u099c\u09be\u09a4\u09a8\u09cd\u09a4\u09cd\u09b0'),'bo':'*aa','br':'Republik Dominikan','bs':'Dominikanska Republika','ca':u('Rep\u00fablica Dominicana'),'ce':u('\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Dominik\u00e1nsk\u00e1 republika'),'cu':'*aa','cv':'*aa','cy':'Gweriniaeth Dominica','da':'Den Dominikanske Republik','de':'Dominikanische Republik','dv':'*aa','dz':u('\u0f4c\u0f7c\u0f0b\u0f58\u0f72\u0f0b\u0f53\u0f72\u0f0b\u0f40\u0f71\u0f53\u0f0b \u0f62\u0f72\u0f0b\u0f54\u0f56\u0f0b\u0f63\u0f72\u0f40'),'ee':u('Dominika rep\u0254blik nutome'),'el':u('\u0394\u03bf\u03bc\u03b9\u03bd\u03b9\u03ba\u03b1\u03bd\u03ae \u0394\u03b7\u03bc\u03bf\u03ba\u03c1\u03b1\u03c4\u03af\u03b1'),'en':'*aa','eo':'Domingo','es':'*ca','et':'Dominikaani Vabariik','eu':'Dominikar Errepublika','fa':u('\u062c\u0645\u0647\u0648\u0631\u06cc \u062f\u0648\u0645\u06cc\u0646\u06cc\u06a9\u0646'),'ff':'Ndenndanndi Dominika','fi':'Dominikaaninen tasavalta','fj':'*aa','fo':u('Dominikal\u00fd\u00f0veldi\u00f0'),'fr':u('R\u00e9publique dominicaine'),'fy':'Dominikaanske Republyk','ga':'an Phoblacht Dhoiminiceach','gd':u('A\u2019 Phoblachd Dhoiminiceach'),'gl':'*ca','gn':'*aa','gu':u('\u0aa1\u0acb\u0aae\u0abf\u0aa8\u0abf\u0a95\u0aa8 \u0ab0\u0abf\u0aaa\u0aac\u0acd\u0ab2\u0abf\u0a95'),'gv':'*aa','ha':'Jamhuriyar Dominika','he':u('\u05d4\u05e8\u05e4\u05d5\u05d1\u05dc\u05d9\u05e7\u05d4 \u05d4\u05d3\u05d5\u05de\u05d9\u05e0\u05d9\u05e7\u05e0\u05d9\u05ea'),'hi':u('\u0921\u094b\u092e\u093f\u0928\u093f\u0915\u0928 \u0917\u0923\u0930\u093e\u091c\u094d\u092f'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Dominikai K\u00f6zt\u00e1rsas\u00e1g'),'hy':u('\u0534\u0578\u0574\u056b\u0576\u056b\u056f\u0575\u0561\u0576 \u0540\u0561\u0576\u0580\u0561\u057a\u0565\u057f\u0578\u0582\u0569\u0575\u0578\u0582\u0576'),'hz':'*aa','ia':'*aa','id':'Republik Dominika','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('D\u00f3min\u00edska l\u00fd\u00f0veldi\u00f0'),'it':'Repubblica Dominicana','iu':'*aa','iw':'*he','ja':u('\u30c9\u30df\u30cb\u30ab\u5171\u548c\u56fd'),'ji':u('\u05d3\u05d0\u05de\u05d9\u05e0\u05d9\u05e7\u05d0\u05b7\u05e0\u05d9\u05e9\u05e2 \u05e8\u05e2\u05e4\u05bc\u05d5\u05d1\u05dc\u05d9\u05e7'),'jv':'*aa','ka':u('\u10d3\u10dd\u10db\u10d8\u10dc\u10d8\u10d9\u10d4\u10da\u10d7\u10d0 \u10e0\u10d4\u10e1\u10de\u10e3\u10d1\u10da\u10d8\u10d9\u10d0'),'kg':'*aa','ki':'Jamhuri ya Dominika','kj':'*aa','kk':u('\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u044b'),'kl':'*aa','km':u('\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u200b\u178a\u17bc\u1798\u17b8\u1793\u17b8\u1780'),'kn':u('\u0ca1\u0cca\u0cae\u0cc6\u0ca8\u0cbf\u0c95\u0ca8\u0ccd \u0cb0\u0cbf\u0caa\u0cac\u0ccd\u0cb2\u0cbf\u0c95\u0ccd'),'ko':u('\ub3c4\ubbf8\ub2c8\uce74 \uacf5\ud654\uad6d'),'kr':'*aa','ks':u('\u0688\u0648\u0645\u0650\u0646\u0650\u06a9\u064e\u0646 \u062c\u0645\u0648\u0657\u0631\u0650\u06cc\u064e\u062a'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u044b'),'la':'*aa','lb':'Dominikanesch Republik','lg':'Lipubulika ya Dominika','li':'*aa','ln':u('Repibiki ya Dom\u00ednik\u025b'),'lo':u('\u0eaa\u0eb2\u0e97\u0eb2\u0ea5\u0eb0\u0e99\u0eb0\u0ea5\u0eb1\u0e94 \u0ec2\u0e94\u0ea1\u0eb4\u0e99\u0eb4\u0e81\u0eb1\u0e99'),'lt':'Dominikos Respublika','lu':'Ditunga wa Duminiku','lv':u('Dominik\u0101na'),'mg':'Repoblika Dominikanina','mh':'*aa','mi':'*aa','mk':u('\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u0420\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430'),'ml':u('\u0d21\u0d4a\u0d2e\u0d3f\u0d28\u0d3f\u0d15\u0d4d\u0d15\u0d7b \u0d31\u0d3f\u0d2a\u0d4d\u0d2a\u0d2c\u0d4d\u0d32\u0d3f\u0d15\u0d4d\u0d15\u0d4d'),'mn':u('\u0411\u04af\u0433\u0434 \u041d\u0430\u0439\u0440\u0430\u043c\u0434\u0430\u0445 \u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d \u0423\u043b\u0441'),'mo':u('Republica Dominican\u0103'),'mr':u('\u0921\u094b\u092e\u093f\u0928\u093f\u0915\u0928 \u092a\u094d\u0930\u091c\u093e\u0938\u0924\u094d\u0924\u093e\u0915'),'ms':'Republik Dominica','mt':'ir-Repubblika Dominicana','my':u('\u1012\u102d\u102f\u1019\u102e\u1014\u102e\u1000\u1014\u103a'),'na':'*aa','nb':'Den dominikanske republikk','nd':'*aa','ne':u('\u0921\u094b\u092e\u093f\u0928\u093f\u0915\u0928 \u0917\u0923\u0924\u0928\u094d\u0924\u094d\u0930'),'ng':'*aa','nl':'Dominicaanse Republiek','nn':'Den dominikanske republikken','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b21\u0b4b\u0b2e\u0b3f\u0b28\u0b3f\u0b15\u0b3e\u0b28\u0b4d\u200c \u0b38\u0b3e\u0b27\u0b3e\u0b30\u0b23\u0b24\u0b28\u0b4d\u0b24\u0b4d\u0b30'),'os':'*aa','pa':u('\u0a21\u0a4b\u0a2e\u0a40\u0a28\u0a3f\u0a15\u0a3e\u0a08 \u0a17\u0a23\u0a30\u0a3e\u0a1c'),'pi':'*aa','pl':'Dominikana','ps':u('\u062f\u0648\u0645\u06cc\u0646\u06cc\u06a9\u0646 \u062c\u0645\u0647\u0648\u0631\u064a\u062a'),'pt':'*ca','qu':'*aa','rm':'Republica Dominicana','rn':'Repubulika ya Dominika','ro':'*mo','ru':u('\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u068a\u0648\u0645\u064a\u0646\u064a\u06aa\u0646 \u062c\u0645\u0647\u0648\u0631\u064a\u0647'),'se':u('Dominik\u00e1na d\u00e1ssev\u00e1ldi'),'sg':u('K\u00f6d\u00f6r\u00f6s\u00ease t\u00ee Domin\u00eeka'),'si':u('\u0da9\u0ddc\u0db8\u0dd2\u0db1\u0dd2\u0d9a\u0dcf \u0da2\u0db1\u0dbb\u0da2\u0dba'),'sk':u('Dominik\u00e1nska republika'),'sl':'Dominikanska republika','sm':'*aa','sn':'*aa','so':'Jamhuuriyadda Domeenika','sq':'Republika Dominikane','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'Dominikanska republiken','sw':'*ki','ta':u('\u0b9f\u0bca\u0bae\u0bbf\u0ba9\u0bbf\u0b95\u0ba9\u0bcd \u0b95\u0bc1\u0b9f\u0bbf\u0baf\u0bb0\u0b9a\u0bc1'),'te':u('\u0c21\u0c4a\u0c2e\u0c3f\u0c28\u0c3f\u0c15\u0c28\u0c4d \u0c30\u0c3f\u0c2a\u0c2c\u0c4d\u0c32\u0c3f\u0c15\u0c4d'),'tg':u('\u04b6\u0443\u043c\u04b3\u0443\u0440\u0438\u0438 \u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d'),'th':u('\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e42\u0e14\u0e21\u0e34\u0e19\u0e34\u0e01\u0e31\u0e19'),'ti':u('\u12f6\u1218\u1292\u12ab \u122a\u1353\u1265\u120a\u12ad'),'tk':'Dominikan Respublikasy','tl':'*aa','tn':'*aa','to':'Lepupelika Tominika','tr':'Dominik Cumhuriyeti','ts':'*aa','tt':u('\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u062f\u0648\u0645\u0649\u0646\u0649\u0643\u0627 \u062c\u06c7\u0645\u06be\u06c7\u0631\u0649\u064a\u0649\u062a\u0649'),'uk':u('\u0414\u043e\u043c\u0456\u043d\u0456\u043a\u0430\u043d\u0441\u044c\u043a\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0456\u043a\u0430'),'ur':u('\u062c\u0645\u06c1\u0648\u0631\u06cc\u06c1 \u0688\u0648\u0645\u064a\u0646\u064a\u06a9\u0646'),'uz':'Dominikan Respublikasi','ve':'*aa','vi':u('C\u1ed9ng h\u00f2a Dominica'),'vo':'*aa','wa':'*aa','wo':'Repiblik Dominiken','xh':'*aa','yi':'*ji','yo':u('Oril\u1eb9\u0301\u00e8de D\u00f2m\u00edn\u00edk\u00e1n\u00ec'),'za':'*aa','zh':u('\u591a\u7c73\u5c3c\u52a0\u5171\u548c\u56fd'),'zu':'i-Dominican Republic',},
  'DZ': {'aa':'Algeria','ab':'*aa','ae':'*aa','af':u('Algeri\u00eb'),'ak':u('\u0186lgyeria'),'am':u('\u12a0\u120d\u1304\u122a\u12eb'),'an':'*aa','ar':u('\u0627\u0644\u062c\u0632\u0627\u0626\u0631'),'as':u('\u0986\u09b2\u099c\u09c7\u09f0\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':u('\u018flc\u0259zair'),'ba':'*aa','be':u('\u0410\u043b\u0436\u044b\u0440'),'bg':u('\u0410\u043b\u0436\u0438\u0440'),'bh':'*aa','bi':'*aa','bm':'Alizeri','bn':u('\u0986\u09b2\u099c\u09c7\u09b0\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'Aljeria','bs':u('Al\u017eir'),'ca':u('Alg\u00e8ria'),'ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':u('Al\u017e\u00edrsko'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'Algeriet','de':'Algerien','dv':'*aa','dz':u('\u0f68\u0f71\u0f63\u0f0b\u0f47\u0f72\u0f0b\u0f62\u0f72\u0f0b\u0f61'),'ee':'Algeria nutome','el':u('\u0391\u03bb\u03b3\u03b5\u03c1\u03af\u03b1'),'en':'*aa','eo':u('Al\u011derio'),'es':'Argelia','et':u('Al\u017eeeria'),'eu':'*br','fa':u('\u0627\u0644\u062c\u0632\u0627\u06cc\u0631'),'ff':'Alaseri','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Alg\u00e9rie'),'fy':'Algerije','ga':u('an Ailg\u00e9ir'),'gd':'Aildiria','gl':'Alxeria','gn':'*aa','gu':u('\u0a85\u0ab2\u0acd\u0a9c\u0ac0\u0ab0\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Aljeriya','he':u('\u05d0\u05dc\u05d2\u05f3\u05d9\u05e8\u05d9\u05d4'),'hi':u('\u0905\u0932\u094d\u091c\u0940\u0930\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Alg\u00e9ria'),'hy':u('\u0531\u056c\u056a\u056b\u0580'),'hz':'*aa','ia':'*aa','id':'Aljazair','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Als\u00edr'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30a2\u30eb\u30b8\u30a7\u30ea\u30a2'),'ji':'*aa','jv':'*aa','ka':u('\u10d0\u10da\u10df\u10d8\u10e0\u10d8'),'kg':'*aa','ki':'*br','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a2\u17b6\u179b\u17cb\u17a0\u17d2\u179f\u17c1\u179a\u17b8'),'kn':u('\u0c85\u0cb2\u0ccd\u0c9c\u0cc0\u0cb0\u0cbf\u0caf'),'ko':u('\uc54c\uc81c\ub9ac'),'kr':'*aa','ks':u('\u0627\u066e\u06ea\u0644\u062c\u06cc\u0631\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*de','lg':'Aligerya','li':'*aa','ln':u('Aliz\u025bri'),'lo':u('\u0ead\u0eb1\u0ea5\u0e88\u0eb4\u0ec0\u0ea3\u0e8d'),'lt':u('Al\u017eyras'),'lu':'Alijeri','lv':u('Al\u017e\u012brija'),'mg':'Alzeria','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d05\u0d7e\u0d1c\u0d40\u0d30\u0d3f\u0d2f'),'mn':'*bg','mo':'*aa','mr':'*hi','ms':'*aa','mt':u('l-Al\u0121erija'),'my':u('\u1021\u101a\u103a\u101c\u103a\u1002\u103b\u102e\u1038\u101b\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'Algerie','nd':'*ha','ne':u('\u0905\u0932\u094d\u091c\u0947\u0930\u093f\u092f\u093e'),'ng':'*aa','nl':'*fy','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b06\u0b32\u0b1c\u0b47\u0b30\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a05\u0a32\u0a1c\u0a40\u0a30\u0a40\u0a06'),'pi':'*aa','pl':'Algieria','ps':'*fa','pt':u('Arg\u00e9lia'),'qu':'*es','rm':'*aa','rn':'Alijeriya','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u0644\u062c\u064a\u0631\u064a\u0627'),'se':'*aa','sg':u('Alzer\u00efi'),'si':u('\u0d87\u0dbd\u0dca\u0da2\u0dd3\u0dbb\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*cs','sl':u('Al\u017eirija'),'sm':'*aa','sn':'*br','so':'Aljeeriya','sq':'Algjeri','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*br','ta':u('\u0b85\u0bb2\u0bcd\u0b9c\u0bc0\u0bb0\u0bbf\u0baf\u0bbe'),'te':u('\u0c05\u0c32\u0c4d\u0c1c\u0c40\u0c30\u0c3f\u0c2f\u0c3e'),'tg':u('\u0410\u043b\u04b7\u0430\u0437\u043e\u0438\u0440'),'th':u('\u0e41\u0e2d\u0e25\u0e08\u0e35\u0e40\u0e23\u0e35\u0e22'),'ti':'*am','tk':'*bs','tl':'*aa','tn':'*aa','to':u('\u02bbAlisilia'),'tr':'Cezayir','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0626\u0627\u0644\u062c\u0649\u0631\u0649\u064a\u06d5'),'uk':'*bg','ur':u('\u0627\u0644\u062c\u06cc\u0631\u06cc\u0627'),'uz':'Jazoir','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Alseri','xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de \u00c0l\u00f9g\u00e8r\u00ed\u00e1n\u00ec'),'za':'*aa','zh':u('\u963f\u5c14\u53ca\u5229\u4e9a'),'zu':'i-Algeria',},
  'EC': {'aa':'Ecuador','ab':'*aa','ae':'*aa','af':'*aa','ak':u('Ikuwad\u0254'),'am':u('\u12a2\u12b3\u12f6\u122d'),'an':'*aa','ar':u('\u0627\u0644\u0625\u0643\u0648\u0627\u062f\u0648\u0631'),'as':u('\u0987\u0995\u09c1\u09f1\u09c7\u09a1\u09f0'),'av':'*aa','ay':'*aa','az':'Ekvador','ba':'*aa','be':u('\u042d\u043a\u0432\u0430\u0434\u043e\u0440'),'bg':u('\u0415\u043a\u0432\u0430\u0434\u043e\u0440'),'bh':'*aa','bi':'*aa','bm':u('Ekwat\u0254r'),'bn':u('\u0987\u0995\u09c1\u09af\u09bc\u09c7\u09a1\u09b0'),'bo':'*aa','br':'*aa','bs':'*az','ca':'Equador','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':u('Ekv\u00e1dor'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f68\u0f7a\u0f0b\u0f41\u0fad\u0f0b\u0f4c\u0f7c\u0f62'),'ee':u('Ekuad\u0254 nutome'),'el':u('\u0399\u03c3\u03b7\u03bc\u03b5\u03c1\u03b9\u03bd\u03cc\u03c2'),'en':'*aa','eo':'Ekvadoro','es':'*aa','et':'*aa','eu':'Ekuador','fa':u('\u0627\u06a9\u0648\u0627\u062f\u0648\u0631'),'ff':'Ekuwatoor','fi':'*aa','fj':'*aa','fo':'*az','fr':u('\u00c9quateur'),'fy':'*aa','ga':u('Eacuad\u00f3r'),'gd':'Eacuador','gl':'*aa','gn':'*aa','gu':u('\u0a8f\u0a95\u0acd\u0ab5\u0abe\u0aa1\u0acb\u0ab0'),'gv':'*aa','ha':'Ekwador','he':u('\u05d0\u05e7\u05d5\u05d5\u05d3\u05d5\u05e8'),'hi':u('\u0907\u0915\u094d\u0935\u093e\u0921\u094b\u0930'),'ho':'*aa','hr':'*az','ht':'*aa','hu':'*aa','hy':u('\u0537\u056f\u057e\u0561\u0564\u0578\u0580'),'hz':'*aa','ia':'*aa','id':'*eu','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*eu','io':'*aa','is':'*az','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30a8\u30af\u30a2\u30c9\u30eb'),'ji':u('\u05e2\u05e7\u05d5\u05d5\u05d0\u05b7\u05d3\u05d0\u05e8'),'jv':'*aa','ka':u('\u10d4\u10d9\u10d5\u10d0\u10d3\u10dd\u10e0\u10d8'),'kg':'*aa','ki':'Ekwado','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u17a2\u17c1\u1780\u17d2\u179c\u17b6\u1791\u17d0\u179a'),'kn':u('\u0c88\u0c95\u0ccd\u0cb5\u0cc6\u0ca1\u0cbe\u0cb0\u0ccd'),'ko':u('\uc5d0\ucf70\ub3c4\ub974'),'kr':'*aa','ks':u('\u0627\u0650\u06a9\u0648\u0627\u0691\u0648\u0631'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*aa','lg':'*ki','li':'*aa','ln':u('Ekwat\u025b\u0301l\u025b'),'lo':u('\u0ec0\u0ead\u0e81\u0ea7\u0eb2\u0e94\u0ecd'),'lt':'Ekvadoras','lu':'Ekwatele','lv':'Ekvadora','mg':'Ekoatera','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d07\u0d15\u0d4d\u0d35\u0d21\u0d4b\u0d7c'),'mn':'*be','mo':'*aa','mr':'*hi','ms':'*aa','mt':'l-Ekwador','my':u('\u1021\u102e\u1000\u103d\u1031\u1012\u1031\u102b'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0907\u0915\u094d\u0935\u0947\u0921\u094b\u0930'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b07\u0b15\u0b4d\u0b71\u0b3e\u0b21\u0b4b\u0b30\u0b4d'),'os':'*aa','pa':u('\u0a07\u0a15\u0a35\u0a47\u0a21\u0a4b\u0a30'),'pi':'*aa','pl':'*ha','ps':'*fa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'Ekwateri','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u064a\u06aa\u0648\u0627\u068a\u0648\u0631'),'se':'*aa','sg':u('Ekuat\u00ebre'),'si':u('\u0d89\u0d9a\u0dca\u0dc0\u0daf\u0ddd\u0dbb\u0dba'),'sk':'*cs','sl':'*az','sm':'*aa','sn':'*aa','so':'Ikuwadoor','sq':'*eu','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b88\u0b95\u0bcd\u0bb5\u0b9f\u0bbe\u0bb0\u0bcd'),'te':u('\u0c08\u0c15\u0c4d\u0c35\u0c21\u0c3e\u0c30\u0c4d'),'tg':'*be','th':u('\u0e40\u0e2d\u0e01\u0e27\u0e32\u0e14\u0e2d\u0e23\u0e4c'),'ti':'*am','tk':'*ha','tl':'*aa','tn':'*aa','to':u('\u02bbEkuetoa'),'tr':'*az','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u0626\u06d0\u0643\u06cb\u0627\u062a\u0648\u0631'),'uk':'*bg','ur':u('\u0627\u06cc\u06a9\u0648\u0627\u0688\u0648\u0631'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':u('Ekwaat\u00ebr'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Eku\u00e1d\u00f2'),'za':'*aa','zh':u('\u5384\u74dc\u591a\u5c14'),'zu':'i-Ecuador',},
  'EE': {'aa':'Estonia','ab':'*aa','ae':'*aa','af':'Estland','ak':u('\u0190stonia'),'am':u('\u12a4\u1235\u1276\u1292\u12eb'),'an':'*aa','ar':u('\u0625\u0633\u062a\u0648\u0646\u064a\u0627'),'as':u('\u0987\u09b7\u09cd\u099f\u09cb\u09a8\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Estoniya','ba':'*aa','be':u('\u042d\u0441\u0442\u043e\u043d\u0456\u044f'),'bg':u('\u0415\u0441\u0442\u043e\u043d\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Esetoni','bn':u('\u098f\u09b8\u09cd\u09a4\u09cb\u09a8\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'*aa','bs':'Estonija','ca':u('Est\u00f2nia'),'ce':u('\u042d\u0441\u0442\u043e\u043d\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Estonsko','cu':'*aa','cv':'*aa','cy':'*aa','da':'*af','de':'*af','dv':'*aa','dz':u('\u0f68\u0f7a\u0f66\u0f0b\u0f4a\u0f7c\u0f0b\u0f53\u0f72\u0f0b\u0f61'),'ee':'Estonia nutome','el':u('\u0395\u03c3\u03b8\u03bf\u03bd\u03af\u03b1'),'en':'*aa','eo':'Estonujo','es':'*aa','et':'Eesti','eu':'*aa','fa':u('\u0627\u0633\u062a\u0648\u0646\u06cc'),'ff':'Estoni','fi':'Viro','fj':'*aa','fo':'*af','fr':'Estonie','fy':u('Estl\u00e2n'),'ga':u('an East\u00f3in'),'gd':'An Eastoin','gl':'*aa','gn':'*aa','gu':u('\u0a8f\u0ab8\u0acd\u0a9f\u0acb\u0aa8\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'*az','he':u('\u05d0\u05e1\u05d8\u05d5\u05e0\u05d9\u05d4'),'hi':u('\u090f\u0938\u094d\u091f\u094b\u0928\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('\u00c9sztorsz\u00e1g'),'hy':u('\u0537\u057d\u057f\u0578\u0576\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'Eistland','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30a8\u30b9\u30c8\u30cb\u30a2'),'ji':u('\u05e2\u05e1\u05d8\u05dc\u05d0\u05b7\u05e0\u05d3'),'jv':'*aa','ka':u('\u10d4\u10e1\u10e2\u10dd\u10dc\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u042d\u0441\u0442\u043e\u043d\u0438\u044f'),'kl':'*aa','km':u('\u17a2\u17c1\u179f\u17d2\u178f\u17bc\u1793\u17b8'),'kn':u('\u0c8e\u0cb8\u0ccd\u0c9f\u0ccb\u0ca8\u0cbf\u0caf\u0cbe'),'ko':u('\uc5d0\uc2a4\ud1a0\ub2c8\uc544'),'kr':'*aa','ks':u('\u0627\u06cc\u0633\u0679\u0648\u0646\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*af','lg':'Esitoniya','li':'*aa','ln':'Esitoni','lo':u('\u0ec0\u0ead\u0eaa\u0ec2\u0e95\u0ec0\u0e99\u0e8d'),'lt':'Estija','lu':'*ln','lv':'Igaunija','mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0415\u0441\u0442\u043e\u043d\u0438\u0458\u0430'),'ml':u('\u0d0e\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d4b\u0d23\u0d3f\u0d2f\u200d'),'mn':'*ce','mo':'*aa','mr':'*hi','ms':'*aa','mt':'l-Estonja','my':u('\u1021\u1000\u103a\u1005\u1010\u102d\u102f\u1038\u1014\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'*af','nd':'*aa','ne':u('\u0907\u0938\u094d\u091f\u094b\u0928\u093f\u092f\u093e'),'ng':'*aa','nl':'*af','nn':'*af','no':'*af','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b0f\u0b38\u0b4d\u0b24\u0b4b\u0b28\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a07\u0a38\u0a1f\u0a4b\u0a28\u0a40\u0a06'),'pi':'*aa','pl':'*aa','ps':u('\u0627\u0633\u062a\u0648\u0646\u06cc\u0627'),'pt':u('Est\u00f4nia'),'qu':'*aa','rm':'*aa','rn':'*lg','ro':'*aa','ru':'*kk','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u064a\u0633\u067d\u0648\u0646\u064a\u0627'),'se':u('Estl\u00e1nda'),'sg':u('Eston\u00efi'),'si':u('\u0d91\u0dc3\u0dca\u0dad\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0dc0'),'sk':u('Est\u00f3nsko'),'sl':'*bs','sm':'*aa','sn':'*aa','so':'Estooniya','sq':'*ff','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*af','sw':'*aa','ta':u('\u0b8e\u0bb8\u0bcd\u0b9f\u0bcb\u0ba9\u0bbf\u0baf\u0bbe'),'te':u('\u0c0e\u0c38\u0c4d\u0c1f\u0c4b\u0c28\u0c3f\u0c2f\u0c3e'),'tg':'*kk','th':u('\u0e40\u0e2d\u0e2a\u0e42\u0e15\u0e40\u0e19\u0e35\u0e22'),'ti':'*am','tk':u('Estoni\u00fda'),'tl':'*aa','tn':'*aa','to':u('\u02bbEsit\u014dnia'),'tr':'Estonya','ts':'*aa','tt':'*kk','tw':'*aa','ty':'*aa','ug':u('\u0626\u06d0\u0633\u062a\u0648\u0646\u0649\u064a\u06d5'),'uk':u('\u0415\u0441\u0442\u043e\u043d\u0456\u044f'),'ur':u('\u0627\u0633\u0679\u0648\u0646\u06cc\u0627'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*ff','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Esitonia'),'za':'*aa','zh':u('\u7231\u6c99\u5c3c\u4e9a'),'zu':'i-Estonia',},
  'EG': {'aa':'Egypt','ab':'*aa','ae':'*aa','af':'Egipte','ak':'Nisrim','am':u('\u130d\u1265\u133d'),'an':'*aa','ar':u('\u0645\u0635\u0631'),'as':u('\u0987\u099c\u09bf\u09aa\u09cd\u09a4'),'av':'*aa','ay':'*aa','az':'Misir','ba':'*aa','be':u('\u0415\u0433\u0456\u043f\u0435\u0442'),'bg':u('\u0415\u0433\u0438\u043f\u0435\u0442'),'bh':'*aa','bi':'*aa','bm':'Eziputi','bn':u('\u09ae\u09bf\u09b6\u09b0'),'bo':'*aa','br':'Egipt','bs':'Egipat','ca':'*af','ce':u('\u041c\u0438\u0441\u0430\u0440'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'Yr Aifft','da':'Egypten','de':u('\u00c4gypten'),'dv':'*aa','dz':u('\u0f68\u0f72\u0f0b\u0f47\u0f72\u0f56\u0f4a'),'ee':'Egypte nutome','el':u('\u0391\u03af\u03b3\u03c5\u03c0\u03c4\u03bf\u03c2'),'en':'*aa','eo':'Egipto','es':'*eo','et':'Egiptus','eu':'*eo','fa':'*ar','ff':'Ejipt','fi':'Egypti','fj':'*aa','fo':'Egyptaland','fr':u('\u00c9gypte'),'fy':'Egypte','ga':u('an \u00c9igipt'),'gd':u('An \u00c8iphit'),'gl':'Exipto','gn':'*aa','gu':u('\u0a87\u0a9c\u0abf\u0aaa\u0acd\u0aa4'),'gv':'*aa','ha':'Masar, Misira','he':u('\u05de\u05e6\u05e8\u05d9\u05dd'),'hi':u('\u092e\u093f\u0938\u094d\u0930'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'Egyiptom','hy':u('\u0535\u0563\u056b\u057a\u057f\u0578\u057d'),'hz':'*aa','ia':'*aa','id':'Mesir','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*fo','it':'Egitto','iu':'*aa','iw':'*he','ja':u('\u30a8\u30b8\u30d7\u30c8'),'ji':u('\u05e2\u05d2\u05d9\u05e4\u05bc\u05d8\u05df'),'jv':'*aa','ka':u('\u10d4\u10d2\u10d5\u10d8\u10de\u10e2\u10d4'),'kg':'*aa','ki':'Misri','kj':'*aa','kk':u('\u041c\u044b\u0441\u044b\u0440'),'kl':'*aa','km':u('\u17a2\u17c1\u17a0\u17d2\u179f\u17ca\u17b8\u1794'),'kn':u('\u0c88\u0c9c\u0cbf\u0caa\u0ccd\u0c9f\u0ccd'),'ko':u('\uc774\uc9d1\ud2b8'),'kr':'*aa','ks':u('\u0645\u0650\u0633\u0654\u0631'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*da','lg':'Misiri','li':'*aa','ln':u('Ez\u00edpite'),'lo':u('\u0ead\u0eb5\u0ea2\u0eb4\u0e9a'),'lt':'Egiptas','lu':'Mushidi','lv':u('\u0112\u0123ipte'),'mg':'Ejypta','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d08\u0d1c\u0d3f\u0d2a\u0d4d\u0d24\u0d4d'),'mn':'*bg','mo':'*br','mr':u('\u0907\u091c\u093f\u092a\u094d\u0924'),'ms':'*id','mt':u('l-E\u0121ittu'),'my':u('\u1021\u102e\u1002\u103b\u1005\u103a'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0907\u091c\u093f\u092a\u094d\u091f'),'ng':'*aa','nl':'*fy','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b07\u0b1c\u0b3f\u0b2a\u0b4d\u0b1f'),'os':'*aa','pa':u('\u0a2e\u0a3f\u0a38\u0a30'),'pi':'*aa','pl':'*br','ps':'*ar','pt':'Egito','qu':'*eo','rm':'Egipta','rn':'*lg','ro':'*br','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*ar','se':'Egypta','sg':u('K\u00e2mit\u00e2'),'si':u('\u0d8a\u0da2\u0dd2\u0db4\u0dca\u0dad\u0dd4\u0dc0'),'sk':'*aa','sl':'*br','sm':'*aa','sn':'*aa','so':'Masar','sq':'Egjipt','sr':u('\u0415\u0433\u0438\u043f\u0430\u0442'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*ki','ta':u('\u0b8e\u0b95\u0bbf\u0baa\u0bcd\u0ba4\u0bc1'),'te':u('\u0c08\u0c1c\u0c3f\u0c2a\u0c4d\u0c1f\u0c4d'),'tg':u('\u041c\u0438\u0441\u0440'),'th':u('\u0e2d\u0e35\u0e22\u0e34\u0e1b\u0e15\u0e4c'),'ti':'*am','tk':u('M\u00fcs\u00fcr'),'tl':'*aa','tn':'*aa','to':u('\u02bbIsipite'),'tr':u('M\u0131s\u0131r'),'ts':'*aa','tt':u('\u041c\u0438\u0441\u044b\u0440'),'tw':'*aa','ty':'*aa','ug':u('\u0645\u0649\u0633\u0649\u0631'),'uk':u('\u0404\u0433\u0438\u043f\u0435\u0442'),'ur':'*ar','uz':'Misr','ve':'*aa','vi':u('Ai C\u1eadp'),'vo':'*aa','wa':'*aa','wo':'Esipt','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de \u00c9g\u00edp\u00edt\u00ec'),'za':'*aa','zh':u('\u57c3\u53ca'),'zu':'i-Egypt',},
  'EH': {'aa':'Western Sahara','ab':'*aa','ae':'*aa','af':'Wes-Sahara','ak':'*aa','am':u('\u121d\u12d5\u122b\u1263\u12ca \u1233\u1205\u122b'),'an':'*aa','ar':u('\u0627\u0644\u0635\u062d\u0631\u0627\u0621 \u0627\u0644\u063a\u0631\u0628\u064a\u0629'),'as':u('\u09aa\u09b6\u09cd\u099a\u09bf\u09ae\u09c0\u09af\u09bc \u099b\u09be\u09b9\u09be\u09f0\u09be'),'av':'*aa','ay':'*aa','az':u('Q\u0259rbi Saxara'),'ba':'*aa','be':u('\u0417\u0430\u0445\u043e\u0434\u043d\u044f\u044f \u0421\u0430\u0445\u0430\u0440\u0430'),'bg':u('\u0417\u0430\u043f\u0430\u0434\u043d\u0430 \u0421\u0430\u0445\u0430\u0440\u0430'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u09aa\u09b6\u09cd\u099a\u09bf\u09ae \u09b8\u09be\u09b9\u09be\u09b0\u09be'),'bo':'*aa','br':u('Sahara ar C\u02bchorn\u00f4g'),'bs':'Zapadna Sahara','ca':u('S\u00e0hara Occidental'),'ce':u('\u041c\u0430\u043b\u0445\u0431\u0443\u0437\u0435\u043d \u0421\u0430\u044c\u0445\u044c\u0430\u0440\u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Z\u00e1padn\u00ed Sahara'),'cu':'*aa','cv':'*aa','cy':'Gorllewin Sahara','da':'Vestsahara','de':'Westsahara','dv':'*aa','dz':u('\u0f53\u0f74\u0f56\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b \u0f66\u0f0b\u0f67\u0f71\u0f0b\u0f62'),'ee':u('\u0194eto\u0256o\u0192e Sahara nutome'),'el':u('\u0394\u03c5\u03c4\u03b9\u03ba\u03ae \u03a3\u03b1\u03c7\u03ac\u03c1\u03b1'),'en':'*aa','eo':'Okcidenta Saharo','es':u('S\u00e1hara Occidental'),'et':u('L\u00e4\u00e4ne-Sahara'),'eu':'Mendebaldeko Sahara','fa':u('\u0635\u062d\u0631\u0627\u06cc \u063a\u0631\u0628\u06cc'),'ff':'*aa','fi':u('L\u00e4nsi-Sahara'),'fj':'*aa','fo':'Vestursahara','fr':'Sahara occidental','fy':'Westelijke Sahara','ga':u('an Sah\u00e1ra Thiar'),'gd':'Sathara an Iar','gl':'*es','gn':'*aa','gu':u('\u0aaa\u0ab6\u0acd\u0a9a\u0abf\u0aae\u0ac0 \u0ab8\u0ab9\u0abe\u0ab0\u0abe'),'gv':'*aa','ha':'*aa','he':u('\u05e1\u05d4\u05e8\u05d4 \u05d4\u05de\u05e2\u05e8\u05d1\u05d9\u05ea'),'hi':u('\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0938\u0939\u093e\u0930\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'Nyugat-Szahara','hy':u('\u0531\u0580\u0587\u0574\u057f\u0575\u0561\u0576 \u054d\u0561\u0570\u0561\u0580\u0561'),'hz':'*aa','ia':'*aa','id':'Sahara Barat','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'Vestur-Sahara','it':'Sahara occidentale','iu':'*aa','iw':'*he','ja':u('\u897f\u30b5\u30cf\u30e9'),'ji':'*aa','jv':'*aa','ka':u('\u10d3\u10d0\u10e1\u10d0\u10d5\u10da\u10d4\u10d7 \u10e1\u10d0\u10f0\u10d0\u10e0\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u0411\u0430\u0442\u044b\u0441 \u0421\u0430\u0445\u0430\u0440\u0430'),'kl':'*aa','km':u('\u179f\u17b6\u17a0\u17b6\u179a\u17c9\u17b6\u1781\u17b6\u1784\u179b\u17b7\u1785'),'kn':u('\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0cb8\u0cb9\u0cbe\u0cb0\u0cbe'),'ko':u('\uc11c\uc0ac\ud558\ub77c'),'kr':'*aa','ks':u('\u0645\u0634\u0631\u0650\u0642\u06cc \u0633\u064e\u06c1\u0627\u0631\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0411\u0430\u0442\u044b\u0448 \u0421\u0430\u0445\u0430\u0440\u0430'),'la':'*aa','lb':'*de','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0e8a\u0eb2\u0eae\u0eb2\u0ea3\u0eb2\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81'),'lt':u('Vakar\u0173 Sachara'),'lu':'*aa','lv':u('Rietumsah\u0101ra'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d2a\u0d36\u0d4d\u0d1a\u0d3f\u0d2e \u0d38\u0d39\u0d3e\u0d31'),'mn':u('\u0411\u0430\u0440\u0443\u0443\u043d \u0421\u0430\u0445\u0430\u0440'),'mo':u('Sahara Occidental\u0103'),'mr':u('\u092a\u0936\u094d\u091a\u093f\u092e \u0938\u0939\u093e\u0930\u093e'),'ms':'*id','mt':u('is-Sa\u0127ara tal-Punent'),'my':u('\u1021\u1014\u1031\u102c\u1000\u103a \u1006\u102c\u101f\u102c\u101b'),'na':'*aa','nb':'Vest-Sahara','nd':'*aa','ne':u('\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0938\u093e\u0939\u093e\u0930\u093e'),'ng':'*aa','nl':'*fy','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2a\u0b36\u0b4d\u0b1a\u0b3f\u0b2e \u0b38\u0b3e\u0b39\u0b3e\u0b30\u0b3e'),'os':'*aa','pa':u('\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a38\u0a39\u0a3e\u0a30\u0a3e'),'pi':'*aa','pl':'Sahara Zachodnia','ps':u('\u0644\u0648\u06cc\u062f\u06cc\u0681 \u0635\u062d\u0631\u0627'),'pt':'Saara Ocidental','qu':'*aa','rm':'Sahara Occidentala','rn':'*aa','ro':'*mo','ru':u('\u0417\u0430\u043f\u0430\u0434\u043d\u0430\u044f \u0421\u0430\u0445\u0430\u0440\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u0648\u0644\u0647\u0647 \u0635\u062d\u0627\u0631\u0627'),'se':u('Oarje-Sah\u00e1ra'),'sg':'*aa','si':u('\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0dc3\u0dc4\u0dbb\u0dcf\u0dc0'),'sk':u('Z\u00e1padn\u00e1 Sahara'),'sl':'Zahodna Sahara','sm':'*aa','sn':'*aa','so':'*aa','sq':u('Saharaja Per\u00ebndimore'),'sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':u('V\u00e4stsahara'),'sw':'Sahara Magharibi','ta':u('\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0bc1 \u0b9a\u0bb9\u0bbe\u0bb0\u0bbe'),'te':u('\u0c2a\u0c21\u0c2e\u0c1f\u0c3f \u0c38\u0c39\u0c3e\u0c30\u0c3e'),'tg':'*aa','th':u('\u0e0b\u0e32\u0e2e\u0e32\u0e23\u0e32\u0e15\u0e30\u0e27\u0e31\u0e19\u0e15\u0e01'),'ti':'*am','tk':u('G\u00fcnbatar Sahara'),'tl':'Kanlurang Sahara','tn':'*aa','to':'Sahala fakahihifo','tr':u('Bat\u0131 Sahra'),'ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':u('\u063a\u06d5\u0631\u0628\u0649\u064a \u0633\u0627\u062e\u0627\u0631\u0627'),'uk':u('\u0417\u0430\u0445\u0456\u0434\u043d\u0430 \u0421\u0430\u0445\u0430\u0440\u0430'),'ur':u('\u0645\u063a\u0631\u0628\u06cc \u0635\u062d\u0627\u0631\u0627'),'uz':u('G\u2018arbiy Sahroi Kabir'),'ve':'*aa','vi':u('T\u00e2y Sahara'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u897f\u6492\u54c8\u62c9'),'zu':'i-Western Sahara',},
  'ER': {'aa':'Eritrea','ab':'*aa','ae':'*aa','af':'*aa','ak':u('\u0190ritrea'),'am':u('\u12a4\u122d\u1275\u122b'),'an':'*aa','ar':u('\u0625\u0631\u064a\u062a\u0631\u064a\u0627'),'as':u('\u098f\u09f0\u09bf\u09a4\u09cd\u09f0\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Eritreya','ba':'*aa','be':u('\u042d\u0440\u044b\u0442\u0440\u044d\u044f'),'bg':u('\u0415\u0440\u0438\u0442\u0440\u0435\u044f'),'bh':'*aa','bi':'*aa','bm':'Eritere','bn':u('\u0987\u09b0\u09bf\u09a4\u09cd\u09b0\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'*aa','bs':'Eritreja','ca':'*aa','ce':u('\u042d\u0440\u0438\u0442\u0440\u0435\u0439'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f68\u0f7a\u0f0b\u0f62\u0f72\u0f0b\u0f4a\u0fb2\u0f7a\u0f0b\u0f61'),'ee':'Eritrea nutome','el':u('\u0395\u03c1\u03c5\u03b8\u03c1\u03b1\u03af\u03b1'),'en':'*aa','eo':'Eritreo','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0627\u0631\u06cc\u062a\u0631\u0647'),'ff':'Eriteree','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('\u00c9rythr\u00e9e'),'fy':'*aa','ga':u('an Eiritr\u00e9'),'gd':'Eartra','gl':'*aa','gn':'*aa','gu':u('\u0a8f\u0ab0\u0abf\u0a9f\u0acd\u0ab0\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Eritireya','he':u('\u05d0\u05e8\u05d9\u05ea\u05e8\u05d9\u05d0\u05d4'),'hi':u('\u0907\u0930\u093f\u091f\u094d\u0930\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u0537\u0580\u056b\u0569\u0580\u0565\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Er\u00edtrea'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30a8\u30ea\u30c8\u30ea\u30a2'),'ji':u('\u05e2\u05e8\u05d9\u05d8\u05e8\u05e2\u05e2'),'jv':'*aa','ka':u('\u10d4\u10e0\u10d8\u10e2\u10e0\u10d4\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u042d\u0440\u0438\u0442\u0440\u0435\u044f'),'kl':'*aa','km':u('\u17a2\u17c1\u179a\u17b8\u178f\u17d2\u179a\u17c1'),'kn':u('\u0c8e\u0cb0\u0cbf\u0c9f\u0ccd\u0cb0\u0cbf\u0caf\u0cbe'),'ko':u('\uc5d0\ub9ac\ud2b8\ub9ac\uc544'),'kr':'*aa','ks':u('\u0627\u0650\u0631\u0655\u0679\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*aa','lg':'Eritureya','li':'*aa','ln':u('Elitel\u025b'),'lo':u('\u0ec0\u0ead\u0ea3\u0eb4\u0ec0\u0e97\u0ea3\u0e8d'),'lt':u('Eritr\u0117ja'),'lu':'Elitele','lv':'*bs','mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0415\u0440\u0438\u0442\u0440\u0435\u0458\u0430'),'ml':u('\u0d0e\u0d31\u0d3f\u0d24\u0d4d\u0d30\u0d3f\u0d2f'),'mn':'*ce','mo':'Eritreea','mr':u('\u090f\u0930\u093f\u091f\u094d\u0930\u093f\u092f\u093e'),'ms':'*aa','mt':'l-Eritrea','my':u('\u1021\u102e\u101b\u102e\u1011\u101b\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u090f\u0930\u093f\u0924\u094d\u0930\u093f\u092f\u093e'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b07\u0b30\u0b3f\u0b1f\u0b4d\u0b30\u0b3f\u0b5f\u0b3e'),'os':'*aa','pa':u('\u0a07\u0a30\u0a40\u0a1f\u0a4d\u0a30\u0a3f\u0a06'),'pi':'*aa','pl':'Erytrea','ps':'*fa','pt':'Eritreia','qu':'*aa','rm':'*aa','rn':'Elitereya','ro':'*mo','ru':'*kk','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u064a\u0631\u064a\u067d\u064a\u0631\u064a\u0627'),'se':'*aa','sg':u('Eritr\u00ebe'),'si':u('\u0d91\u0dbb\u0dd2\u0dad\u0dca\u200d\u0dbb\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*aa','sl':'*bs','sm':'*aa','sn':'*aa','so':'Eretereeya','sq':'Eritre','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b8e\u0bb0\u0bbf\u0b9f\u0bcd\u0bb0\u0bbf\u0baf\u0bbe'),'te':u('\u0c0e\u0c30\u0c3f\u0c1f\u0c4d\u0c30\u0c3f\u0c2f\u0c3e'),'tg':'*kk','th':u('\u0e40\u0e2d\u0e23\u0e34\u0e40\u0e17\u0e23\u0e35\u0e22'),'ti':'*am','tk':u('Eritre\u00fda'),'tl':'*aa','tn':'*aa','to':u('\u02bbElitulia'),'tr':'*sq','ts':'*aa','tt':'*kk','tw':'*aa','ty':'*aa','ug':u('\u0626\u06d0\u0631\u0649\u062a\u0631\u0649\u064a\u06d5'),'uk':'*bg','ur':u('\u0627\u0631\u06cc\u0679\u06cc\u0631\u06cc\u0627'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*bm','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Eritira'),'za':'*aa','zh':u('\u5384\u7acb\u7279\u91cc\u4e9a'),'zu':'i-Eritrea',},
  'ES': {'aa':'Spain','ab':'*aa','ae':'*aa','af':'Spanje','ak':'*aa','am':u('\u1235\u1354\u1295'),'an':'*aa','ar':u('\u0625\u0633\u0628\u0627\u0646\u064a\u0627'),'as':u('\u09b8\u09cd\u09aa\u09c7\u0987\u09a8'),'av':'*aa','ay':'*aa','az':u('\u0130spaniya'),'ba':'*aa','be':u('\u0406\u0441\u043f\u0430\u043d\u0456\u044f'),'bg':u('\u0418\u0441\u043f\u0430\u043d\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':u('Esipa\u0272i'),'bn':u('\u09b8\u09cd\u09aa\u09c7\u09a8'),'bo':'*aa','br':'Spagn','bs':u('\u0160panija'),'ca':'Espanya','ce':u('\u0418\u0441\u043f\u0430\u043d\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('\u0160pan\u011blsko'),'cu':'*aa','cv':'*aa','cy':'Sbaen','da':'Spanien','de':'*da','dv':'*aa','dz':u('\u0f68\u0f72\u0f66\u0f0b\u0f54\u0f7a\u0f53'),'ee':'Spain nutome','el':u('\u0399\u03c3\u03c0\u03b1\u03bd\u03af\u03b1'),'en':'*aa','eo':'Hispanujo','es':u('Espa\u00f1a'),'et':'Hispaania','eu':'Espainia','fa':u('\u0627\u0633\u067e\u0627\u0646\u06cc\u0627'),'ff':u('Espaa\u00f1'),'fi':'Espanja','fj':'*aa','fo':'Spania','fr':'Espagne','fy':'*af','ga':u('an Sp\u00e1inn'),'gd':u('An Sp\u00e0innt'),'gl':'*es','gn':'*aa','gu':u('\u0ab8\u0acd\u0aaa\u0ac7\u0aa8'),'gv':'*aa','ha':'Sipen','he':u('\u05e1\u05e4\u05e8\u05d3'),'hi':u('\u0938\u094d\u092a\u0947\u0928'),'ho':'*aa','hr':u('\u0160panjolska'),'ht':'*aa','hu':u('Spanyolorsz\u00e1g'),'hy':u('\u053b\u057d\u057a\u0561\u0576\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'Spanyol','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Sp\u00e1nn'),'it':'Spagna','iu':'*aa','iw':'*he','ja':u('\u30b9\u30da\u30a4\u30f3'),'ji':u('\u05e9\u05e4\u05bc\u05d0\u05b7\u05e0\u05d9\u05e2'),'jv':'*aa','ka':u('\u10d4\u10e1\u10de\u10d0\u10dc\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'Hispania','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a2\u17c1\u179f\u17d2\u1794\u17c9\u17b6\u1789'),'kn':u('\u0cb8\u0ccd\u0caa\u0cc7\u0ca8\u0ccd'),'ko':u('\uc2a4\ud398\uc778'),'kr':'*aa','ks':u('\u0633\u0655\u067e\u06cc\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*da','lg':'Sipeyini','li':'*aa','ln':'Esipanye','lo':u('\u0eaa\u0eb0\u0ec0\u0e9b\u0e99'),'lt':'Ispanija','lu':'Nsipani','lv':u('Sp\u0101nija'),'mg':'Espaina','mh':'*aa','mi':'*aa','mk':u('\u0428\u043f\u0430\u043d\u0438\u0458\u0430'),'ml':u('\u0d38\u0d4d\u200c\u0d2a\u0d46\u0d2f\u0d3f\u0d7b'),'mn':'*ce','mo':'*fo','mr':'*hi','ms':'Sepanyol','mt':'Spanja','my':u('\u1005\u1015\u102d\u1014\u103a'),'na':'*aa','nb':'*fo','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*af','nn':'*fo','no':'*fo','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b4d\u0b2a\u0b47\u0b28\u0b4d'),'os':'*aa','pa':u('\u0a38\u0a2a\u0a47\u0a28'),'pi':'*aa','pl':'Hiszpania','ps':u('\u0647\u0633\u067e\u0627\u0646\u06cc\u0647'),'pt':'Espanha','qu':'*es','rm':'*it','rn':'Hisipaniya','ro':'*fo','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u0633\u067e\u064a\u0646'),'se':u('Sp\u00e1nia'),'sg':u('Esp\u00e2nye'),'si':u('\u0dc3\u0dca\u0db4\u0dcf\u0da4\u0dca\u0da4\u0dba'),'sk':u('\u0160panielsko'),'sl':'*bs','sm':'*aa','sn':'*aa','so':'Isbeyn','sq':u('Spanj\u00eb'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'Uhispania','ta':u('\u0bb8\u0bcd\u0baa\u0bc6\u0baf\u0bbf\u0ba9\u0bcd'),'te':u('\u0c38\u0c4d\u0c2a\u0c46\u0c2f\u0c3f\u0c28\u0c4d'),'tg':'*bg','th':u('\u0e2a\u0e40\u0e1b\u0e19'),'ti':'*am','tk':u('Ispani\u00fda'),'tl':'*aa','tn':'*aa','to':'Sipeini','tr':u('\u0130spanya'),'ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0626\u0649\u0633\u067e\u0627\u0646\u0649\u064a\u06d5'),'uk':'*be','ur':u('\u06c1\u0633\u067e\u0627\u0646\u06cc\u06c1'),'uz':'Ispaniya','ve':'*aa','vi':u('T\u00e2y Ban Nha'),'vo':'*aa','wa':'*aa','wo':u('Espa\u00f1'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Sipani'),'za':'*aa','zh':u('\u897f\u73ed\u7259'),'zu':'i-Spain',},
  'ET': {'aa':'Ethiopia','ab':'*aa','ae':'*aa','af':u('Ethiopi\u00eb'),'ak':'Ithiopia','am':u('\u12a2\u1275\u12ee\u1335\u12eb'),'an':'*aa','ar':u('\u0625\u062b\u064a\u0648\u0628\u064a\u0627'),'as':u('\u0987\u09a5\u09bf\u0985\u2019\u09aa\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Efiopiya','ba':'*aa','be':u('\u042d\u0444\u0456\u043e\u043f\u0456\u044f'),'bg':u('\u0415\u0442\u0438\u043e\u043f\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Etiopi','bn':u('\u0987\u09a5\u09bf\u0993\u09aa\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'Etiopia','bs':'Etiopija','ca':u('Eti\u00f2pia'),'ce':u('\u042d\u0444\u0438\u043e\u043f\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Etiopie','cu':'*aa','cv':'*aa','cy':'*aa','da':'Etiopien','de':u('\u00c4thiopien'),'dv':'*aa','dz':u('\u0f68\u0f72\u0f0b\u0f50\u0f72\u0f0b\u0f61\u0f7c\u0f0b\u0f54\u0f72\u0f0b\u0f61'),'ee':'Etiopia nutome','el':u('\u0391\u03b9\u03b8\u03b9\u03bf\u03c0\u03af\u03b1'),'en':'*aa','eo':'Etiopujo','es':u('Etiop\u00eda'),'et':'Etioopia','eu':'*br','fa':u('\u0627\u062a\u06cc\u0648\u067e\u06cc'),'ff':'Ecoppi','fi':'*br','fj':'*aa','fo':'*br','fr':u('\u00c9thiopie'),'fy':'*af','ga':u('an Aet\u00f3ip'),'gd':'An Itiop','gl':'*es','gn':'*aa','gu':u('\u0a87\u0aa5\u0abf\u0a93\u0aaa\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Habasha','he':u('\u05d0\u05ea\u05d9\u05d5\u05e4\u05d9\u05d4'),'hi':u('\u0907\u0925\u093f\u092f\u094b\u092a\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Eti\u00f3pia'),'hy':u('\u0535\u0569\u0578\u057e\u057a\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*br','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*br','io':'*aa','is':u('E\u00fe\u00ed\u00f3p\u00eda'),'it':'*br','iu':'*aa','iw':'*he','ja':u('\u30a8\u30c1\u30aa\u30d4\u30a2'),'ji':u('\u05e2\u05d8\u05d9\u05d0\u05e4\u05bc\u05d9\u05e2'),'jv':'*aa','ka':u('\u10d4\u10d7\u10d8\u10dd\u10de\u10d8\u10d0'),'kg':'*aa','ki':'Uhabeshi','kj':'*aa','kk':u('\u042d\u0444\u0438\u043e\u043f\u0438\u044f'),'kl':'*aa','km':u('\u17a2\u17c1\u178f\u17d2\u1799\u17bc\u1796\u17b8'),'kn':u('\u0c87\u0ca5\u0cbf\u0caf\u0ccb\u0caa\u0cbf\u0caf\u0cbe'),'ko':u('\uc5d0\ud2f0\uc624\ud53c\uc544'),'kr':'*aa','ks':u('\u0627\u0650\u062a\u06be\u0648\u067e\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'Ethiopien','lg':'Esyopya','li':'*aa','ln':u('Ets\u00edopi'),'lo':u('\u0ead\u0eb5\u0e97\u0eb4\u0ec2\u0ead\u0ec0\u0e9b\u0e8d'),'lt':'*bs','lu':'Etshiopi','lv':'*bs','mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0415\u0442\u0438\u043e\u043f\u0438\u0458\u0430'),'ml':u('\u0d0e\u0d24\u0d4d\u0d2f\u0d4b\u0d2a\u0d4d\u0d2f'),'mn':u('\u042d\u0442\u0438\u043e\u043f'),'mo':'*br','mr':u('\u0907\u0925\u093f\u0913\u092a\u093f\u092f\u093e'),'ms':'*aa','mt':'l-Etjopja','my':u('\u1021\u102e\u101e\u102e\u101a\u102d\u102f\u1038\u1015\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'*br','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*af','nn':'*br','no':'*br','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'Itoophiyaa','or':u('\u0b07\u0b25\u0b3f\u0b13\u0b2a\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a07\u0a25\u0a4b\u0a2a\u0a40\u0a06'),'pi':'*aa','pl':'*br','ps':u('\u062d\u0628\u0634\u0647'),'pt':'*hu','qu':'*es','rm':'*br','rn':'Etiyopiya','ro':'*br','ru':'*kk','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u064a\u067f\u0648\u067e\u064a\u0627'),'se':'*br','sg':u('Etiop\u00efi'),'si':u('\u0d89\u0dad\u0dd2\u0dba\u0ddd\u0db4\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*hu','sl':'*bs','sm':'*aa','sn':'*br','so':'Itoobiya','sq':'*bm','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':u('\u0b8e\u0ba4\u0bcd\u0ba4\u0bbf\u0baf\u0bcb\u0baa\u0bcd\u0baa\u0bbf\u0baf\u0bbe'),'te':u('\u0c07\u0c25\u0c3f\u0c2f\u0c4b\u0c2a\u0c3f\u0c2f\u0c3e'),'tg':'*kk','th':u('\u0e40\u0e2d\u0e18\u0e34\u0e42\u0e2d\u0e40\u0e1b\u0e35\u0e22'),'ti':'*am','tk':u('Efiopi\u00fda'),'tl':'*aa','tn':'*aa','to':u('\u02bb\u012ati\u014dpia'),'tr':'Etiyopya','ts':'*aa','tt':'*kk','tw':'*aa','ty':'*aa','ug':u('\u0626\u06d0\u0641\u0649\u064a\u0648\u067e\u0649\u064a\u06d5'),'uk':u('\u0415\u0444\u0456\u043e\u043f\u0456\u044f'),'ur':u('\u0627\u06cc\u062a\u06be\u0648\u067e\u06cc\u0627'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Ecopi','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Etopia'),'za':'*aa','zh':u('\u57c3\u585e\u4fc4\u6bd4\u4e9a'),'zu':'i-Ethiopia',},
  'FI': {'aa':'Finland','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u134a\u1295\u120b\u1295\u12f5'),'an':'*aa','ar':u('\u0641\u0646\u0644\u0646\u062f\u0627'),'as':u('\u09ab\u09bf\u09a8\u09b2\u09c7\u09a3\u09cd\u09a1'),'av':'*aa','ay':'*aa','az':'Finlandiya','ba':'*aa','be':u('\u0424\u0456\u043d\u043b\u044f\u043d\u0434\u044b\u044f'),'bg':u('\u0424\u0438\u043d\u043b\u0430\u043d\u0434\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Finilandi','bn':u('\u09ab\u09bf\u09a8\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1'),'bo':'*aa','br':'*aa','bs':'Finska','ca':u('Finl\u00e0ndia'),'ce':u('\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Finsko','cu':'*aa','cv':'*aa','cy':'Y Ffindir','da':'*aa','de':'Finnland','dv':'*aa','dz':u('\u0f55\u0f72\u0f53\u0f0b\u0f63\u0f7a\u0f53\u0f4c'),'ee':'Finland nutome','el':u('\u03a6\u03b9\u03bd\u03bb\u03b1\u03bd\u03b4\u03af\u03b1'),'en':'*aa','eo':'Finnlando','es':'Finlandia','et':'Soome','eu':'*es','fa':u('\u0641\u0646\u0644\u0627\u0646\u062f'),'ff':'Fenland','fi':'Suomi','fj':'*aa','fo':'*de','fr':'Finlande','fy':u('Finl\u00e2n'),'ga':'an Fhionlainn','gd':'An Fhionnlann','gl':'*es','gn':'*aa','gu':u('\u0aab\u0abf\u0aa8\u0ab2\u0ac7\u0aa8\u0acd\u0aa1'),'gv':'*aa','ha':'Finlan','he':u('\u05e4\u05d9\u05e0\u05dc\u05e0\u05d3'),'hi':u('\u092b\u093c\u093f\u0928\u0932\u0948\u0902\u0921'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Finnorsz\u00e1g'),'hy':u('\u0556\u056b\u0576\u056c\u0561\u0576\u0564\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*es','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*es','io':'*aa','is':'*de','it':'*es','iu':'*aa','iw':'*he','ja':u('\u30d5\u30a3\u30f3\u30e9\u30f3\u30c9'),'ji':u('\u05e4\u05bf\u05d9\u05e0\u05dc\u05d0\u05b7\u05e0\u05d3'),'jv':'*aa','ka':u('\u10e4\u10d8\u10dc\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'Ufini','kj':'*aa','kk':u('\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f'),'kl':'*aa','km':u('\u17a0\u17d2\u179c\u17b6\u17c6\u1784\u17a1\u1784\u17cb'),'kn':u('\u0cab\u0cbf\u0ca8\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd'),'ko':u('\ud540\ub780\ub4dc'),'kr':'*aa','ks':u('\u0641\u0650\u0646\u0644\u06cc\u0646\u065b\u0691'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*de','lg':'*bm','li':'*aa','ln':u('Filand\u025b'),'lo':u('\u0e9f\u0eb4\u0e99\u0ec1\u0ea5\u0e99'),'lt':'Suomija','lu':'Filande','lv':'Somija','mg':'Finlandy','mh':'*aa','mi':'*aa','mk':u('\u0424\u0438\u043d\u0441\u043a\u0430'),'ml':u('\u0d2b\u0d3f\u0d7b\u0d32\u0d3e\u0d7b\u0d21\u0d4d'),'mn':u('\u0424\u0438\u043d\u043b\u0430\u043d\u0434'),'mo':'Finlanda','mr':u('\u092b\u093f\u0928\u0932\u0902\u0921'),'ms':'*aa','mt':'il-Finlandja','my':u('\u1016\u1004\u103a\u101c\u1014\u103a'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u092b\u093f\u0928\u094d\u0932\u094d\u092f\u093e\u0923\u094d\u0921'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2b\u0b3f\u0b28\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21'),'os':'*aa','pa':u('\u0a2b\u0a3f\u0a28\u0a32\u0a48\u0a02\u0a21'),'pi':'*aa','pl':'*es','ps':u('\u0641\u0646\u0644\u06cc\u0646\u0689'),'pt':u('Finl\u00e2ndia'),'qu':'*es','rm':'*mo','rn':'*bm','ro':'*mo','ru':'*kk','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0641\u0646 \u0644\u064a\u0646\u068a'),'se':'Suopma','sg':u('F\u00ebl\u00e2nde'),'si':u('\u0dc6\u0dd2\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba'),'sk':u('F\u00ednsko'),'sl':'*bs','sm':'*aa','sn':'*aa','so':'*aa','sq':u('Finland\u00eb'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*ki','ta':u('\u0baa\u0bbf\u0ba9\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1'),'te':u('\u0c2b\u0c3f\u0c28\u0c4d\u0c32\u0c3e\u0c02\u0c21\u0c4d'),'tg':'*kk','th':u('\u0e1f\u0e34\u0e19\u0e41\u0e25\u0e19\u0e14\u0e4c'),'ti':'*am','tk':u('Finlandi\u00fda'),'tl':'*aa','tn':'*aa','to':'Finilani','tr':'*az','ts':'*aa','tt':'*kk','tw':'*aa','ty':'*aa','ug':u('\u0641\u0649\u0646\u0644\u0627\u0646\u062f\u0649\u064a\u06d5'),'uk':u('\u0424\u0456\u043d\u043b\u044f\u043d\u0434\u0456\u044f'),'ur':u('\u0641\u0646 \u0644\u06cc\u0646\u0688'),'uz':'*az','ve':'*aa','vi':u('Ph\u1ea7n Lan'),'vo':'*aa','wa':'*aa','wo':u('Finl\u00e0nd'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Filandi'),'za':'*aa','zh':u('\u82ac\u5170'),'zu':'i-Finland',},
  'FJ': {'aa':'Fiji','ab':'*aa','ae':'*aa','af':'Fidji','ak':'Figyi','am':u('\u134a\u1302'),'an':'*aa','ar':u('\u0641\u064a\u062c\u064a'),'as':u('\u09ab\u09bf\u099c\u09bf'),'av':'*aa','ay':'*aa','az':'Fici','ba':'*aa','be':u('\u0424\u0456\u0434\u0436\u044b'),'bg':u('\u0424\u0438\u0434\u0436\u0438'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':'*as','bo':'*aa','br':'*af','bs':u('Fid\u017ei'),'ca':'*aa','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*bs','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Fidschi','dv':'*aa','dz':u('\u0f55\u0f72\u0f0b\u0f47\u0f72'),'ee':'Fidzi nutome','el':u('\u03a6\u03af\u03c4\u03b6\u03b9'),'en':'*aa','eo':u('Fi\u011doj'),'es':'Fiyi','et':'*bs','eu':'*aa','fa':u('\u0641\u06cc\u062c\u06cc'),'ff':'Fijji','fi':'*bs','fj':'*aa','fo':'*aa','fr':'*af','fy':'*aa','ga':u('Fids\u00ed'),'gd':u('F\u00ecdi'),'gl':'Fidxi','gn':'*aa','gu':u('\u0aab\u0ac0\u0a9c\u0ac0'),'gv':'*aa','ha':'*aa','he':u('\u05e4\u05d9\u05d2\u05f3\u05d9'),'hi':u('\u092b\u093c\u093f\u091c\u0940'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'Fidzsi','hy':u('\u0556\u056b\u057b\u056b'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('F\u00eddj\u00edeyjar'),'it':'Figi','iu':'*aa','iw':'*he','ja':u('\u30d5\u30a3\u30b8\u30fc'),'ji':u('\u05e4\u05bf\u05d9\u05d3\u05d6\u05e9\u05d9'),'jv':'*aa','ka':u('\u10e4\u10d8\u10ef\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a0\u17d2\u179c\u17b8\u1787\u17b8'),'kn':u('\u0cab\u0cbf\u0c9c\u0cbf'),'ko':u('\ud53c\uc9c0'),'kr':'*aa','ks':u('\u0641\u0650\u062c\u06cc'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*de','lg':'*aa','li':'*aa','ln':'Fidzi','lo':u('\u0e9f\u0eb4\u0e88\u0eb4'),'lt':u('Fid\u017eis'),'lu':'Fuji','lv':'*bs','mg':'*af','mh':'*aa','mi':'*aa','mk':u('\u0424\u0438\u045f\u0438'),'ml':u('\u0d2b\u0d3f\u0d1c\u0d3f'),'mn':u('\u0424\u0438\u0436\u0438'),'mo':'*aa','mr':u('\u092b\u093f\u091c\u0940'),'ms':'*aa','mt':u('Fi\u0121i'),'my':u('\u1016\u102e\u1002\u103b\u102e'),'na':'*aa','nb':'*aa','nd':'*aa','ne':'*mr','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2b\u0b3f\u0b1c\u0b3f'),'os':'*aa','pa':u('\u0a2b\u0a3c\u0a3f\u0a1c\u0a40'),'pi':'*aa','pl':u('Fid\u017ci'),'ps':u('\u0641\u064a \u062c\u064a'),'pt':'*aa','qu':'*es','rm':'*de','rn':'*aa','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0641\u062c\u064a'),'se':'Fijisullot','sg':u('Fidy\u00efi'),'si':u('\u0dc6\u0dd3\u0da2\u0dd3'),'sk':'*bs','sl':'*bs','sm':'*aa','sn':'*aa','so':'*aa','sq':'Fixhi','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b83\u0baa\u0bbf\u0b9c\u0bbf'),'te':u('\u0c2b\u0c3f\u0c1c\u0c40'),'tg':u('\u0424\u0438\u04b7\u0438'),'th':u('\u0e1f\u0e34\u0e08\u0e34'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':'Fisi','tr':'*aa','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0641\u0649\u062c\u0649'),'uk':u('\u0424\u0456\u0434\u0436\u0456'),'ur':u('\u0641\u062c\u06cc'),'uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*ff','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Fiji'),'za':'*aa','zh':u('\u6590\u6d4e'),'zu':'i-Fiji',},
  'FK': {'aa':'Falkland Islands','ab':'*aa','ae':'*aa','af':'Falklandeilande','ak':u('F\u0254lkman Aeland'),'am':u('\u12e8\u134e\u12ad\u120b\u1295\u12f5 \u12f0\u1234\u1276\u127d'),'an':'*aa','ar':u('\u062c\u0632\u0631 \u0641\u0648\u0643\u0644\u0627\u0646\u062f'),'as':u('\u09ab\u0995\u09b2\u09c7\u09a3\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'av':'*aa','ay':'*aa','az':u('Folklend adalar\u0131'),'ba':'*aa','be':u('\u0424\u0430\u043b\u043a\u043b\u0435\u043d\u0434\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b'),'bg':u('\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434\u0441\u043a\u0438 \u043e\u0441\u0442\u0440\u043e\u0432\u0438'),'bh':'*aa','bi':'*aa','bm':'Maluwini Gun','bn':u('\u09ab\u0995\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'bo':'*aa','br':'Inizi Falkland','bs':'Folklandska ostrva','ca':'Illes Malvines','ce':u('\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Falklandsk\u00e9 ostrovy'),'cu':'*aa','cv':'*aa','cy':'Ynysoedd y Falkland/Malvinas','da':u('Falklands\u00f8erne'),'de':'Falklandinseln','dv':'*aa','dz':u('\u0f55\u0f63\u0f90\u0f0b\u0f63\u0f53\u0f9c\u0f0b\u0f42\u0fb3\u0f72\u0f44\u0f0b\u0f5a\u0f7c\u0f58'),'ee':u('Falkland \u0192udomekpowo nutome'),'el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u03a6\u03cc\u03ba\u03bb\u03b1\u03bd\u03c4'),'en':'*aa','eo':'*aa','es':'Islas Malvinas','et':'Falklandi saared','eu':'Malvinak','fa':u('\u062c\u0632\u0627\u06cc\u0631 \u0641\u0627\u0644\u06a9\u0644\u0646\u062f'),'ff':u('Duu\u0257e Falkland'),'fi':'Falklandinsaaret','fj':'*aa','fo':'Falklandsoyggjar','fr':u('\u00celes Malouines'),'fy':u('Falkl\u00e2neilannen'),'ga':u('Oile\u00e1in Fh\u00e1clainne'),'gd':u('Na h-Eileanan F\u00e0clannach'),'gl':'Illas Malvinas','gn':'*aa','gu':u('\u0aab\u0ac9\u0a95\u0ab2\u0ac7\u0aa8\u0acd\u0aa1 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8'),'gv':'*aa','ha':'Tsibiran Falkilan','he':u('\u05d0\u05d9\u05d9 \u05e4\u05d5\u05e7\u05dc\u05e0\u05d3'),'hi':u('\u092b\u093c\u0949\u0915\u0932\u0948\u0902\u0921 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939'),'ho':'*aa','hr':'Falklandski otoci','ht':'*aa','hu':'Falkland-szigetek','hy':u('\u0556\u0578\u056c\u0584\u056c\u0565\u0576\u0564\u0575\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'Kepulauan Malvinas','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'Falklandseyjar','it':'Isole Falkland','iu':'*aa','iw':'*he','ja':u('\u30d5\u30a9\u30fc\u30af\u30e9\u30f3\u30c9\u8af8\u5cf6'),'ji':u('\u05e4\u05bf\u05d0\u05b7\u05dc\u05e7\u05dc\u05d0\u05b7\u05e0\u05d3 \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df'),'jv':'*aa','ka':u('\u10e4\u10dd\u10da\u10d9\u10da\u10d4\u10dc\u10d3\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'Visiwa vya Falkland','kj':'*aa','kk':u('\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434 \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'kl':'*aa','km':u('\u1780\u17c4\u17c7\u200b\u17a0\u17d2\u179c\u1780\u17cb\u17a1\u17c2\u1793'),'kn':u('\u0cab\u0cbe\u0c95\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3\u0cc1'),'ko':u('\ud3ec\ud074\ub79c\ub4dc \uc81c\ub3c4'),'kr':'*aa','ks':u('\u0641\u0655\u0644\u0627\u06a9\u0644\u06cc\u0646\u065b\u0691 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'Falklandinselen','lg':u('Bizinga by\u2019eFalikalandi'),'li':'*aa','ln':'Bisanga bya Maluni','lo':u('\u0eab\u0ea1\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0e9f\u0ead\u0e81\u0ec1\u0ea5\u0e99'),'lt':'Folklando Salos','lu':'Lutanda lua Maluni','lv':'Folklenda salas','mg':'Nosy Falkand','mh':'*aa','mi':'*aa','mk':u('\u0424\u043e\u043b\u043a\u043b\u0430\u043d\u0434\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438'),'ml':u('\u0d2b\u0d3e\u0d15\u0d4d\u0d15\u0d4d\u200c\u0d32\u0d3e\u0d28\u0d4d\u0d31\u0d4d \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e'),'mn':u('\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434\u0438\u0439\u043d \u0430\u0440\u043b\u0443\u0443\u0434'),'mo':'Insulele Falkland','mr':u('\u092b\u0949\u0915\u0932\u0902\u0921 \u092c\u0947\u091f\u0947'),'ms':'Kepulauan Falkland','mt':u('il-G\u017cejjer Falkland'),'my':u('\u1016\u1031\u102c\u1037\u1000\u101c\u1014\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f'),'na':'*aa','nb':u('Falklands\u00f8yene'),'nd':'*aa','ne':u('\u092b\u0915\u0932\u094d\u092f\u093e\u0923\u094d\u0921 \u091f\u093e\u092a\u0941\u0939\u0930\u0941'),'ng':'*aa','nl':'Falklandeilanden','nn':u('Falklands\u00f8yane'),'no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2b\u0b15\u0b4d\u200c\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21 \u0b26\u0b4d\u0b35\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c'),'os':'*aa','pa':u('\u0a2b\u0a3c\u0a3e\u0a15\u0a32\u0a48\u0a02\u0a21 \u0a1f\u0a3e\u0a2a\u0a42'),'pi':'*aa','pl':'Falklandy','ps':u('\u0641\u0648\u06a9\u0644\u0646\u0689 \u067c\u0627\u067e\u0648'),'pt':'Ilhas Malvinas','qu':'*aa','rm':'Inslas dal Falkland','rn':'Izinga rya Filikilandi','ro':'*mo','ru':u('\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434\u0441\u043a\u0438\u0435 \u043e-\u0432\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0641\u0627\u06aa \u0644\u064a\u0646\u068a \u067b\u064a\u067d'),'se':'Falklandsullot','sg':u('\u00c2z\u00fb\u00e2 t\u00ee M\u00e4l\u00fc\u00eeni'),'si':u('\u0dc6\u0ddd\u0d9a\u0dca\u0dbd\u0db1\u0dca\u0dad \u0daf\u0dd6\u0db4\u0dad\u0dca'),'sk':'*pl','sl':'Falklandski otoki','sm':'*aa','sn':'Zvitsuwa zveFalklands','so':'Jaziiradaha Fooklaan','sq':'Ishujt Falkland','sr':u('\u0424\u043e\u043a\u043b\u0430\u043d\u0434\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Falklands\u00f6arna'),'sw':'*ki','ta':u('\u0b83\u0baa\u0bbe\u0b95\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1 \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd'),'te':u('\u0c2b\u0c3e\u0c15\u0c4d\u200c\u0c32\u0c4d\u0c2f\u0c3e\u0c02\u0c21\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41'),'tg':u('\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434'),'th':u('\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e1f\u0e2d\u0e25\u0e4c\u0e01\u0e41\u0e25\u0e19\u0e14\u0e4c'),'ti':u('\u12f0\u1234\u1273\u1275 \u134e\u12ad\u120b\u1295\u12f5'),'tk':'Folklend adalary','tl':'*aa','tn':'*aa','to':u('\u02bbOtumotu Fokulani'),'tr':u('Falkland Adalar\u0131'),'ts':'*aa','tt':u('\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0641\u0627\u0644\u0643\u0644\u0627\u0646\u062f \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649'),'uk':u('\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434\u0441\u044c\u043a\u0456 \u043e\u0441\u0442\u0440\u043e\u0432\u0438'),'ur':u('\u0641\u0627\u06a9\u0644\u06cc\u0646\u0688 \u062c\u0632\u0627\u0626\u0631'),'uz':'Folklend orollari','ve':'*aa','vi':u('Qu\u1ea7n \u0111\u1ea3o Falkland'),'vo':'*aa','wa':'*aa','wo':'Duni Falkland','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Etikun Fakalandi'),'za':'*aa','zh':u('\u798f\u514b\u5170\u7fa4\u5c9b'),'zu':'i-Falkland Islands',},
  'FM': {'aa':'Micronesia','ab':'*aa','ae':'*aa','af':u('Mikronesi\u00eb'),'ak':'Maekronehyia','am':u('\u121a\u12ad\u122e\u1294\u12e2\u12eb'),'an':'*aa','ar':u('\u0645\u064a\u0643\u0631\u0648\u0646\u064a\u0632\u064a\u0627'),'as':u('\u09ae\u09be\u0987\u0995\u09cd\u09f0\u09cb\u09a8\u09c7\u099a\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Mikroneziya','ba':'*aa','be':u('\u041c\u0456\u043a\u0440\u0430\u043d\u0435\u0437\u0456\u044f'),'bg':u('\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Mikironesi','bn':u('\u09ae\u09be\u0987\u0995\u09cd\u09b0\u09cb\u09a8\u09c7\u09b6\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'Mikronezia','bs':'Mikronezija','ca':u('Micron\u00e8sia'),'ce':u('\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u043d \u0424\u0435\u0434\u0435\u0440\u0430\u0442\u0438\u0432\u043d\u0438 \u0448\u0442\u0430\u0442\u0430\u0448'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Mikron\u00e9sie'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'Mikronesien','de':'*da','dv':'*aa','dz':u('\u0f58\u0f60\u0f72\u0f0b\u0f40\u0fb2\u0f7c\u0f0b\u0f53\u0f72\u0f0b\u0f64\u0f72\u0f0b\u0f61'),'ee':'Mikronesia nutome','el':u('\u039c\u03b9\u03ba\u03c1\u03bf\u03bd\u03b7\u03c3\u03af\u03b1'),'en':'*aa','eo':'Mikronezio','es':'*aa','et':'Mikroneesia','eu':'Mikronesia','fa':u('\u0645\u06cc\u06a9\u0631\u0648\u0646\u0632\u06cc'),'ff':'Mikoronesii','fi':'Mikronesian liittovaltio','fj':'*aa','fo':u('Mikronesiasamveldi\u00f0'),'fr':u('\u00c9tats f\u00e9d\u00e9r\u00e9s de Micron\u00e9sie'),'fy':u('Micronesi\u00eb'),'ga':u('an Mhicrin\u00e9is'),'gd':'Na Meanbh-eileanan','gl':'*aa','gn':'*aa','gu':u('\u0aae\u0abe\u0a87\u0a95\u0acd\u0ab0\u0acb\u0aa8\u0ac7\u0ab6\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Mikuronesiya','he':u('\u05de\u05d9\u05e7\u05e8\u05d5\u05e0\u05d6\u05d9\u05d4'),'hi':u('\u092e\u093e\u0907\u0915\u094d\u0930\u094b\u0928\u0947\u0936\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Mikron\u00e9zia'),'hy':u('\u0544\u056b\u056f\u0580\u0578\u0576\u0565\u0566\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*eu','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*eu','io':'*aa','is':u('M\u00edkr\u00f3nes\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30df\u30af\u30ed\u30cd\u30b7\u30a2\u9023\u90a6'),'ji':u('\u05de\u05d9\u05e7\u05e8\u05d0\u05e0\u05e2\u05d6\u05d9\u05e2'),'jv':'*aa','ka':u('\u10db\u10d8\u10d9\u10e0\u10dd\u10dc\u10d4\u10d6\u10d8\u10d0'),'kg':'*aa','ki':'*eu','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1798\u17b8\u1780\u17d2\u179a\u17bc\u178e\u17c1\u179f\u17ca\u17b8'),'kn':u('\u0cae\u0cc8\u0c95\u0ccd\u0cb0\u0ccb\u0ca8\u0cc7\u0cb6\u0cbf\u0caf\u0cbe'),'ko':u('\ubbf8\ud06c\ub85c\ub124\uc2dc\uc544'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*da','lg':'Mikuronezya','li':'*aa','ln':'Mikronezi','lo':u('\u0ec4\u0ea1\u0ec2\u0e84\u0ea3\u0e99\u0eb5\u0ec0\u0e8a\u0e8d'),'lt':'*bs','lu':'*ln','lv':u('Mikron\u0113zija'),'mg':u('Mikr\u00f4nezia'),'mh':'*aa','mi':'*aa','mk':u('\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u0458\u0430'),'ml':u('\u0d2e\u0d48\u0d15\u0d4d\u0d30\u0d4b\u0d28\u0d47\u0d37\u0d4d\u0d2f'),'mn':u('\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438'),'mo':'Micronezia','mr':u('\u092e\u093e\u092f\u0915\u094d\u0930\u094b\u0928\u0947\u0936\u093f\u092f\u093e'),'ms':'*aa','mt':u('Mikrone\u017cja'),'my':u('\u1019\u102d\u102f\u1004\u103a\u1001\u101b\u102d\u102f\u1014\u102e\u101b\u103e\u102c\u1038'),'na':'*aa','nb':u('Mikronesiaf\u00f8derasjonen'),'nd':'*aa','ne':u('\u092e\u093e\u0907\u0915\u094d\u0930\u094b\u0928\u0947\u0938\u093f\u092f\u093e'),'ng':'*aa','nl':'*aa','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b3e\u0b07\u0b15\u0b4d\u0b30\u0b4b\u0b28\u0b47\u0b38\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a2e\u0a3e\u0a07\u0a15\u0a4d\u0a30\u0a4b\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06'),'pi':'*aa','pl':'Mikronezja','ps':u('\u0645\u06cc\u06a9\u0631\u0648\u0646\u06cc\u0632\u06cc\u0627'),'pt':u('Micron\u00e9sia'),'qu':'*aa','rm':'*aa','rn':'Mikoroniziya','ro':'*mo','ru':u('\u0424\u0435\u0434\u0435\u0440\u0430\u0442\u0438\u0432\u043d\u044b\u0435 \u0428\u0442\u0430\u0442\u044b \u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u0438'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0645\u0627\u0626\u06aa\u0631\u0648\u0646\u064a\u0634\u064a\u0627'),'se':'*eu','sg':u('Mikronez\u00efi'),'si':u('\u0db8\u0dba\u0dd2\u0d9a\u0dca\u200d\u0dbb\u0ddc\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*hu','sl':'*bs','sm':'*aa','sn':'*aa','so':'*aa','sq':'*ln','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':u('\u0bae\u0bc8\u0b95\u0bcd\u0bb0\u0bcb\u0ba9\u0bc7\u0bb7\u0bbf\u0baf\u0bbe'),'te':u('\u0c2e\u0c48\u0c15\u0c4d\u0c30\u0c4b\u0c28\u0c47\u0c37\u0c3f\u0c2f\u0c3e'),'tg':u('\u0428\u0442\u0430\u0442\u04b3\u043e\u0438 \u0424\u0435\u0434\u0435\u0440\u0430\u0442\u0438\u0432\u0438\u0438 \u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u044f'),'th':u('\u0e44\u0e21\u0e42\u0e04\u0e23\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22'),'ti':'*am','tk':u('Mikronezi\u00fda'),'tl':'*aa','tn':'*aa','to':u('Mikolon\u012bsia'),'tr':'Mikronezya','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0645\u0649\u0643\u0631\u0648\u0646\u06d0\u0632\u0649\u064a\u06d5'),'uk':u('\u041c\u0456\u043a\u0440\u043e\u043d\u0435\u0437\u0456\u044f'),'ur':u('\u0645\u0627\u0626\u06a9\u0631\u0648\u0646\u06cc\u0634\u06cc\u0627'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Mikoronesi','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Makoronesia'),'za':'*aa','zh':u('\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a'),'zu':'i-Micronesia',},
  'FO': {'aa':'Faroe Islands','ab':'*aa','ae':'*aa','af':u('Faro\u00ebreilande'),'ak':'*aa','am':u('\u12e8\u134b\u122e \u12f0\u1234\u1276\u127d'),'an':'*aa','ar':u('\u062c\u0632\u0631 \u0641\u0627\u0631\u0648'),'as':u('\u09ab\u09be\u09f0\u09cb \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'av':'*aa','ay':'*aa','az':u('Farer adalar\u0131'),'ba':'*aa','be':u('\u0424\u0430\u0440\u044d\u0440\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b'),'bg':u('\u0424\u0430\u0440\u044c\u043e\u0440\u0441\u043a\u0438 \u043e\u0441\u0442\u0440\u043e\u0432\u0438'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u09ab\u09cd\u09af\u09be\u09b0\u0993 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'bo':'*aa','br':'Inizi Faero','bs':'Farska ostrva','ca':u('Illes F\u00e8roe'),'ce':u('\u0424\u0430\u0440\u0435\u0440\u0438\u0439\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Faersk\u00e9 ostrovy'),'cu':'*aa','cv':'*aa','cy':'Ynysoedd Ffaro','da':u('F\u00e6r\u00f8erne'),'de':u('F\u00e4r\u00f6er'),'dv':'*aa','dz':u('\u0f55\u0f71\u0f60\u0f7a\u0f0b\u0f62\u0f7c\u0f0b\u0f42\u0fb3\u0f72\u0f44\u0f0b\u0f5a\u0f7c\u0f58'),'ee':u('Faroe \u0192udomekpowo nutome'),'el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u03a6\u03b5\u03c1\u03cc\u03b5\u03c2'),'en':'*aa','eo':'Ferooj','es':'Islas Feroe','et':u('F\u00e4\u00e4ri saared'),'eu':'Faroe uharteak','fa':u('\u062c\u0632\u0627\u06cc\u0631 \u0641\u0627\u0631\u0648'),'ff':'*aa','fi':u('F\u00e4rsaaret'),'fj':'*aa','fo':u('F\u00f8royar'),'fr':u('\u00celes F\u00e9ro\u00e9'),'fy':u('Faer\u00f6er'),'ga':u('Oile\u00e1in Fhar\u00f3'),'gd':u('Na h-Eileanan F\u00e0ro'),'gl':'Illas Feroe','gn':'*aa','gu':u('\u0aab\u0ac7\u0ab0\u0acb \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8'),'gv':'*aa','ha':'*aa','he':u('\u05d0\u05d9\u05d9 \u05e4\u05d0\u05e8\u05d5'),'hi':u('\u092b\u093c\u0947\u0930\u094b \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939'),'ho':'*aa','hr':'Farski otoci','ht':'*aa','hu':u('Fer\u00f6er-szigetek'),'hy':u('\u0556\u0561\u0580\u0565\u0580\u0575\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'Kepulauan Faroe','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('F\u00e6reyjar'),'it':u('Isole F\u00e6r \u00d8er'),'iu':'*aa','iw':'*he','ja':u('\u30d5\u30a7\u30ed\u30fc\u8af8\u5cf6'),'ji':u('\u05e4\u05bf\u05d0\u05b7\u05e8\u05d0 \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df'),'jv':'*aa','ka':u('\u10e4\u10d0\u10e0\u10d4\u10e0\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u0424\u0430\u0440\u0435\u0440 \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'kl':'*aa','km':u('\u1780\u17c4\u17c7\u200b\u17a0\u17d2\u179c\u17b6\u179a\u17c9\u17bc'),'kn':u('\u0cab\u0cb0\u0ccb \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3\u0cc1'),'ko':u('\ud398\ub85c \uc81c\ub3c4'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*de','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0eab\u0ea1\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ec1\u0e9f\u0ec2\u0ea3'),'lt':u('Farer\u0173 Salos'),'lu':'*aa','lv':u('F\u0113ru salas'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0424\u0430\u0440\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438'),'ml':u('\u0d2b\u0d31\u0d4b \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e'),'mn':u('\u0424\u0430\u0440\u0435\u0440\u044b\u043d \u0430\u0440\u043b\u0443\u0443\u0434'),'mo':'Insulele Feroe','mr':u('\u092b\u0947\u0930\u094b \u092c\u0947\u091f\u0947'),'ms':'*id','mt':u('il-G\u017cejjer Faeroe'),'my':u('\u1016\u102c\u101b\u102d\u102f\u1038 \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f\u1019\u103b\u102c\u1038'),'na':'*aa','nb':u('F\u00e6r\u00f8yene'),'nd':'*aa','ne':u('\u092b\u093e\u0930\u094b \u091f\u093e\u092a\u0941\u0939\u0930\u0942'),'ng':'*aa','nl':'*fy','nn':u('F\u00e6r\u00f8yane'),'no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2b\u0b3e\u0b30\u0b4b\u0b07 \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c'),'os':'*aa','pa':u('\u0a2b\u0a48\u0a30\u0a4b \u0a1f\u0a3e\u0a2a\u0a42'),'pi':'*aa','pl':'Wyspy Owcze','ps':u('\u0641\u0627\u0631\u0648 \u067c\u0627\u067e\u0648'),'pt':'Ilhas Faroe','qu':'*aa','rm':'Inslas Feroe','rn':'*aa','ro':'*mo','ru':u('\u0424\u0430\u0440\u0435\u0440\u0441\u043a\u0438\u0435 \u043e-\u0432\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0641\u0627\u0631\u0648 \u067b\u064a\u067d'),'se':'Fearsullot','sg':'*aa','si':u('\u0dc6\u0dd0\u0dbb\u0ddd \u0daf\u0dd6\u0db4\u0dad\u0dca'),'sk':'*cs','sl':'Ferski otoki','sm':'*aa','sn':'*aa','so':'*aa','sq':'Ishujt Faroe','sr':u('\u0424\u0430\u0440\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('F\u00e4r\u00f6arna'),'sw':'Visiwa vya Faroe','ta':u('\u0b83\u0baa\u0bbe\u0bb0\u0bcb \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd'),'te':u('\u0c2b\u0c3e\u0c30\u0c4b \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41'),'tg':u('\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u0424\u0430\u0440\u0435\u0440'),'th':u('\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e41\u0e1f\u0e42\u0e23'),'ti':u('\u12f0\u1234\u1273\u1275 \u134b\u122b\u12a6'),'tk':'Farer adalary','tl':'*aa','tn':'*aa','to':u('\u02bbOtumotu Faloe'),'tr':u('Faroe Adalar\u0131'),'ts':'*aa','tt':u('\u0424\u0430\u0440\u0435\u0440 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0641\u0627\u0631\u0648 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649'),'uk':u('\u0424\u0430\u0440\u0435\u0440\u0441\u044c\u043a\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438'),'ur':u('\u062c\u0632\u0627\u0626\u0631 \u0641\u0627\u0631\u0648'),'uz':'Farer orollari','ve':'*aa','vi':u('Qu\u1ea7n \u0111\u1ea3o Faroe'),'vo':'*aa','wa':'*aa','wo':'Duni Faro','xh':'*aa','yi':'*ji','yo':'*aa','za':'*aa','zh':u('\u6cd5\u7f57\u7fa4\u5c9b'),'zu':'i-Faroe Islands',},
  'FR': {'aa':'France','ab':'*aa','ae':'*aa','af':'Frankryk','ak':u('Fr\u025bnkyeman'),'am':u('\u1348\u1228\u1295\u1233\u12ed'),'an':'*aa','ar':u('\u0641\u0631\u0646\u0633\u0627'),'as':u('\u09ab\u09cd\u09f0\u09be\u09a8\u09cd\u09b8'),'av':'*aa','ay':'*aa','az':'Fransa','ba':'*aa','be':u('\u0424\u0440\u0430\u043d\u0446\u044b\u044f'),'bg':u('\u0424\u0440\u0430\u043d\u0446\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Faransi','bn':u('\u09ab\u09cd\u09b0\u09be\u09a8\u09cd\u09b8'),'bo':'*aa','br':u('Fra\u00f1s'),'bs':'Francuska','ca':u('Fran\u00e7a'),'ce':u('\u0424\u0440\u0430\u043d\u0446\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Francie','cu':'*aa','cv':'*aa','cy':'Ffrainc','da':'Frankrig','de':'Frankreich','dv':'*aa','dz':u('\u0f55\u0fb2\u0f71\u0f53\u0f66'),'ee':'France nutome','el':u('\u0393\u03b1\u03bb\u03bb\u03af\u03b1'),'en':'*aa','eo':'Francujo','es':'Francia','et':'Prantsusmaa','eu':'Frantzia','fa':u('\u0641\u0631\u0627\u0646\u0633\u0647'),'ff':'Farayse','fi':'Ranska','fj':'*aa','fo':'Frakland','fr':'*aa','fy':'Frankrijk','ga':'an Fhrainc','gd':'An Fhraing','gl':'*es','gn':'*aa','gu':u('\u0aab\u0acd\u0ab0\u0abe\u0a82\u0ab8'),'gv':'*aa','ha':'Faransa','he':u('\u05e6\u05e8\u05e4\u05ea'),'hi':u('\u092b\u093c\u094d\u0930\u093e\u0902\u0938'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Franciaorsz\u00e1g'),'hy':u('\u0556\u0580\u0561\u0576\u057d\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'Prancis','ie':'*aa','ig':'*aa','ii':u('\ua0d4\ua1e9'),'ik':'*aa','in':'*id','io':'*aa','is':'Frakkland','it':'*es','iu':'*aa','iw':'*he','ja':u('\u30d5\u30e9\u30f3\u30b9'),'ji':u('\u05e4\u05bf\u05e8\u05d0\u05b7\u05e0\u05e7\u05e8\u05d9\u05d9\u05da'),'jv':'*aa','ka':u('\u10e1\u10d0\u10e4\u10e0\u10d0\u10dc\u10d2\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'Ubaranja','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1794\u17b6\u179a\u17b6\u17c6\u1784'),'kn':u('\u0cab\u0ccd\u0cb0\u0cbe\u0ca8\u0ccd\u0cb8\u0ccd'),'ko':u('\ud504\ub791\uc2a4'),'kr':'*aa','ks':u('\u0641\u0631\u065b\u0627\u0646\u0633'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':u('Frankr\u00e4ich'),'lg':'Bufalansa','li':'*aa','ln':u('Fal\u00e1ns\u025b'),'lo':u('\u0e9d\u0ea3\u0eb1\u0ec8\u0e87'),'lt':u('Pranc\u016bzija'),'lu':'Nfalanse','lv':'Francija','mg':'Frantsa','mh':'*aa','mi':'*aa','mk':u('\u0424\u0440\u0430\u043d\u0446\u0438\u0458\u0430'),'ml':u('\u0d2b\u0d4d\u0d30\u0d3e\u0d7b\u0d38\u0d4d'),'mn':u('\u0424\u0440\u0430\u043d\u0446'),'mo':u('Fran\u021ba'),'mr':u('\u092b\u094d\u0930\u093e\u0928\u094d\u0938'),'ms':'Perancis','mt':'Franza','my':u('\u1015\u103c\u1004\u103a\u101e\u1005\u103a'),'na':'*aa','nb':'Frankrike','nd':'Furansi','ne':'*mr','ng':'*aa','nl':'*fy','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2b\u0b4d\u0b30\u0b3e\u0b28\u0b4d\u0b38'),'os':'*mn','pa':u('\u0a2b\u0a3c\u0a30\u0a3e\u0a02\u0a38'),'pi':'*aa','pl':'Francja','ps':'*fa','pt':'*ca','qu':'*es','rm':'Frantscha','rn':'Ubufaransa','ro':'*mo','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0641\u0631\u0627\u0646\u0633'),'se':'Frankriika','sg':u('Far\u00e2nzi'),'si':u('\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1\u0dba'),'sk':u('Franc\u00fazsko'),'sl':'*lv','sm':'*aa','sn':'*aa','so':'Faransiis','sq':u('Franc\u00eb'),'sr':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*nb','sw':'Ufaransa','ta':u('\u0baa\u0bbf\u0bb0\u0bbe\u0ba9\u0bcd\u0bb8\u0bcd'),'te':u('\u0c2b\u0c4d\u0c30\u0c3e\u0c28\u0c4d\u0c38\u0c4d\u200c'),'tg':u('\u0424\u0440\u0430\u043d\u0441\u0438\u044f'),'th':u('\u0e1d\u0e23\u0e31\u0e48\u0e07\u0e40\u0e28\u0e2a'),'ti':'*am','tk':u('Fransi\u00fda'),'tl':'*aa','tn':'*aa','to':u('Falanis\u0113'),'tr':'*az','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0641\u0649\u0631\u0627\u0646\u0633\u0649\u064a\u06d5'),'uk':u('\u0424\u0440\u0430\u043d\u0446\u0456\u044f'),'ur':'*sd','uz':'Fransiya','ve':'*aa','vi':u('Ph\u00e1p'),'vo':'*aa','wa':'*aa','wo':'Faraans','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Faranse'),'za':'*aa','zh':u('\u6cd5\u56fd'),'zu':'i-France',},
  'GA': {'aa':'Gabon','ab':'*aa','ae':'*aa','af':'Gaboen','ak':u('Gab\u0254n'),'am':u('\u130b\u1266\u1295'),'an':'*aa','ar':u('\u0627\u0644\u063a\u0627\u0628\u0648\u0646'),'as':u('\u0997\u09c7\u09ac\u09a8'),'av':'*aa','ay':'*aa','az':'Qabon','ba':'*aa','be':u('\u0413\u0430\u0431\u043e\u043d'),'bg':'*be','bh':'*aa','bi':'*aa','bm':u('Gab\u0254\u014b'),'bn':u('\u0997\u09cd\u09af\u09be\u09ac\u09a8'),'bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'Gabun','dv':'*aa','dz':u('\u0f42\u0fb7\u0f0b\u0f56\u0fb7\u0f7c\u0f53'),'ee':u('Gab\u0254n nutome'),'el':u('\u0393\u03ba\u03b1\u03bc\u03c0\u03cc\u03bd'),'en':'*aa','eo':'Gabono','es':u('Gab\u00f3n'),'et':'*aa','eu':'*aa','fa':u('\u06af\u0627\u0628\u0646'),'ff':'Gaboo','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('an Ghab\u00fain'),'gd':'*aa','gl':'*es','gn':'*aa','gu':u('\u0a97\u0ac7\u0aac\u0aa8'),'gv':'*aa','ha':'*aa','he':u('\u05d2\u05d1\u05d5\u05df'),'hi':u('\u0917\u0948\u092c\u0949\u0928'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u0533\u0561\u0562\u0578\u0576'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30ac\u30dc\u30f3'),'ji':u('\u05d2\u05d0\u05b7\u05d1\u05d0\u05df'),'jv':'*aa','ka':u('\u10d2\u10d0\u10d1\u10dd\u10dc\u10d8'),'kg':'*aa','ki':'Gaboni','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u17a0\u17d2\u1782\u17b6\u1794\u17bb\u1784'),'kn':u('\u0c97\u0cc6\u0cac\u0cca\u0ca8\u0ccd'),'ko':u('\uac00\ubd09'),'kr':'*aa','ks':u('\u06af\u06cc\u0628\u0627\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*de','lg':'*ki','li':'*aa','ln':u('Gab\u0254'),'lo':u('\u0e81\u0eb2\u0e9a\u0ead\u0e99'),'lt':'Gabonas','lu':'Ngabu','lv':'Gabona','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d17\u0d3e\u0d2c\u0d7a'),'mn':'*be','mo':'*aa','mr':u('\u0917\u0945\u092c\u0949\u0928'),'ms':'*aa','mt':'il-Gabon','my':u('\u1002\u102b\u1018\u103d\u1014\u103a'),'na':'*aa','nb':'*aa','nd':'Gabhoni','ne':u('\u0917\u093e\u0935\u094b\u0928'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b17\u0b3e\u0b2c\u0b4b\u0b28\u0b4d'),'os':'*aa','pa':u('\u0a17\u0a2c\u0a4b\u0a28'),'pi':'*aa','pl':'*aa','ps':u('\u06ab\u0627\u0628\u0646'),'pt':u('Gab\u00e3o'),'qu':'*es','rm':'*de','rn':'Gabo','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06af\u0628\u0648\u0646'),'se':'*aa','sg':u('Gab\u00f6on'),'si':u('\u0d9c\u0dd0\u0db6\u0ddc\u0db1\u0dca'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'Gaaboon','sq':'*aa','sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b95\u0bc7\u0baa\u0bbe\u0ba9\u0bcd'),'te':u('\u0c17\u0c3e\u0c2c\u0c28\u0c4d'),'tg':'*be','th':u('\u0e01\u0e32\u0e1a\u0e2d\u0e07'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':'Kaponi','tr':'*aa','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u06af\u0627\u0628\u0648\u0646'),'uk':'*be','ur':u('\u06af\u06cc\u0628\u0648\u0646'),'uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':u('Gabo\u014b'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Gabon'),'za':'*aa','zh':u('\u52a0\u84ec'),'zu':'i-Gabon',},
  'GB': {'aa':'United Kingdom','ab':'*aa','ae':'*aa','af':'Verenigde Koninkryk','ak':'Ahendiman Nkabom','am':u('\u12e9\u1293\u12ed\u1275\u12f5 \u12aa\u1295\u130d\u12f0\u121d'),'an':'*aa','ar':u('\u0627\u0644\u0645\u0645\u0644\u0643\u0629 \u0627\u0644\u0645\u062a\u062d\u062f\u0629'),'as':u('\u09b8\u0982\u09af\u09c1\u0995\u09cd\u09a4 \u09f0\u09be\u099c\u09cd\u09af'),'av':'*aa','ay':'*aa','az':u('Birl\u0259\u015fmi\u015f Krall\u0131q'),'ba':'*aa','be':u('\u0412\u044f\u043b\u0456\u043a\u0430\u0431\u0440\u044b\u0442\u0430\u043d\u0456\u044f'),'bg':u('\u041e\u0431\u0435\u0434\u0438\u043d\u0435\u043d\u043e\u0442\u043e \u043a\u0440\u0430\u043b\u0441\u0442\u0432\u043e'),'bh':'*aa','bi':'*aa','bm':u('Angil\u025bt\u025bri'),'bn':u('\u09af\u09c1\u0995\u09cd\u09a4\u09b0\u09be\u099c\u09cd\u09af'),'bo':u('\u0f51\u0f56\u0fb1\u0f72\u0f53\u0f0b\u0f47\u0f72\u0f0b'),'br':'Rouantelezh-Unanet','bs':'Velika Britanija','ca':'Regne Unit','ce':u('\u0419\u043e\u043a\u043a\u0445\u0430 \u0411\u0440\u0438\u0442\u0430\u043d\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Spojen\u00e9 kr\u00e1lovstv\u00ed'),'cu':'*aa','cv':'*aa','cy':'Y Deyrnas Unedig','da':'Storbritannien','de':u('Vereinigtes K\u00f6nigreich'),'dv':'*aa','dz':u('\u0f61\u0f74\u0f0b\u0f53\u0f71\u0f60\u0f72\u0f0b\u0f4a\u0f7a\u0f4c\u0f0b \u0f40\u0f72\u0f44\u0f0b\u0f4c\u0f58'),'ee':'United Kingdom nutome','el':u('\u0397\u03bd\u03c9\u03bc\u03ad\u03bd\u03bf \u0392\u03b1\u03c3\u03af\u03bb\u03b5\u03b9\u03bf'),'en':'*aa','eo':u('Unui\u011dinta Re\u011dlando'),'es':'Reino Unido','et':'Suurbritannia','eu':'Erresuma Batua','fa':u('\u0628\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627'),'ff':'Laamateeri Rentundi','fi':'Iso-Britannia','fj':'*aa','fo':u('St\u00f3rabretland'),'fr':'Royaume-Uni','fy':'Verenigd Koninkrijk','ga':u('an R\u00edocht Aontaithe'),'gd':u('An R\u00ecoghachd Aonaichte'),'gl':'*es','gn':'*aa','gu':u('\u0aaf\u0ac1\u0aa8\u0abe\u0a87\u0a9f\u0ac7\u0aa1 \u0a95\u0abf\u0a82\u0a97\u0aa1\u0aae'),'gv':'Rywvaneth Unys','ha':'Birtaniya','he':u('\u05d4\u05de\u05de\u05dc\u05db\u05d4 \u05d4\u05de\u05d0\u05d5\u05d7\u05d3\u05ea'),'hi':u('\u092f\u0942\u0928\u093e\u0907\u091f\u0947\u0921 \u0915\u093f\u0902\u0917\u0921\u092e'),'ho':'*aa','hr':'Ujedinjeno Kraljevstvo','ht':'*aa','hu':u('Egyes\u00fclt Kir\u00e1lys\u00e1g'),'hy':u('\u0544\u056b\u0561\u0581\u0575\u0561\u056c \u0539\u0561\u0563\u0561\u057e\u0578\u0580\u0578\u0582\u0569\u0575\u0578\u0582\u0576'),'hz':'*aa','ia':'*aa','id':'Inggris Raya','ie':'*aa','ig':'*aa','ii':u('\ua471\ua1e9'),'ik':'*aa','in':'*id','io':'*aa','is':'Bretland','it':'Regno Unito','iu':'*aa','iw':'*he','ja':u('\u30a4\u30ae\u30ea\u30b9'),'ji':u('\u05e4\u05bf\u05d0\u05b7\u05e8\u05d0\u05d9\u05d9\u05e0\u05d9\u05d2\u05d8\u05e2 \u05e7\u05e2\u05e0\u05d9\u05d2\u05e8\u05d9\u05d9\u05da'),'jv':'*aa','ka':u('\u10d2\u10d0\u10d4\u10e0\u10d7\u10d8\u10d0\u10dc\u10d4\u10d1\u10e3\u10da\u10d8 \u10e1\u10d0\u10db\u10d4\u10e4\u10dd'),'kg':'*aa','ki':'Ngeretha','kj':'*aa','kk':u('\u04b0\u043b\u044b\u0431\u0440\u0438\u0442\u0430\u043d\u0438\u044f'),'kl':'*aa','km':u('\u1785\u1780\u17d2\u179a\u1797\u1796\u200b\u17a2\u1784\u17cb\u1782\u17d2\u179b\u17c1\u179f'),'kn':u('\u0cac\u0ccd\u0cb0\u0cbf\u0c9f\u0ca8\u0ccd/\u0c87\u0c82\u0c97\u0ccd\u0cb2\u0cc6\u0c82\u0ca1\u0ccd'),'ko':u('\uc601\uad6d'),'kr':'*aa','ks':u('\u06cc\u064f\u0646\u0627\u06cc\u0679\u0650\u0691 \u06a9\u0650\u0646\u065b\u06af\u0688\u064e\u0645'),'ku':'*aa','kv':'*aa','kw':'*gv','ky':u('\u0423\u043b\u0443\u0443 \u0411\u0440\u0438\u0442\u0430\u043d\u0438\u044f'),'la':'*aa','lb':'Groussbritannien','lg':'Bungereza','li':'*aa','ln':u('Ang\u025bl\u025bt\u025b\u0301l\u025b'),'lo':u('\u0eaa\u0eb0\u0eab\u0eb0\u0ea5\u0eb2\u0e94\u0e8a\u0eb0\u0ead\u0eb0\u0e99\u0eb2\u0e88\u0eb1\u0e81'),'lt':u('Jungtin\u0117 Karalyst\u0117'),'lu':'Angeletele','lv':u('Lielbrit\u0101nija'),'mg':'Angletera','mh':'*aa','mi':'*aa','mk':u('\u041e\u0431\u0435\u0434\u0438\u043d\u0435\u0442\u043e \u041a\u0440\u0430\u043b\u0441\u0442\u0432\u043e'),'ml':u('\u0d2f\u0d41\u0d23\u0d48\u0d31\u0d4d\u0d31\u0d21\u0d4d \u0d15\u0d3f\u0d02\u0d17\u0d4d\u0d21\u0d02'),'mn':u('\u0418\u0445 \u0411\u0440\u0438\u0442\u0430\u043d\u0438'),'mo':'Regatul Unit','mr':u('\u092f\u0941\u0928\u093e\u092f\u091f\u0947\u0921 \u0915\u093f\u0902\u0917\u0921\u092e'),'ms':'*aa','mt':'ir-Renju Unit','my':u('\u101a\u1030\u1014\u102d\u102f\u1000\u103a\u1010\u1000\u103a\u1000\u1004\u103a\u1038\u1012\u1019\u103a\u1038'),'na':'*aa','nb':'Storbritannia','nd':'*aa','ne':u('\u092c\u0947\u0932\u093e\u092f\u0924'),'ng':'*aa','nl':'*fy','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2f\u0b41\u0b15\u0b4d\u0b24\u0b30\u0b3e\u0b1c\u0b4d\u0b5f'),'os':u('\u0421\u0442\u044b\u0440 \u0411\u0440\u0438\u0442\u0430\u043d\u0438'),'pa':u('\u0a2f\u0a42\u0a28\u0a3e\u0a08\u0a1f\u0a21 \u0a15\u0a3f\u0a70\u0a17\u0a21\u0a2e'),'pi':'*aa','pl':'Wielka Brytania','ps':u('\u0628\u0631\u062a\u0627\u0646\u06cc\u0647'),'pt':'*es','qu':'*es','rm':u('Reginavel Un\u00ec'),'rn':'Ubwongereza','ro':'*mo','ru':u('\u0412\u0435\u043b\u0438\u043a\u043e\u0431\u0440\u0438\u0442\u0430\u043d\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0628\u0631\u0637\u0627\u0646\u064a\u0647'),'se':u('Stuorra-Brit\u00e1nnia'),'sg':u('K\u00f6d\u00f6r\u00f6gb\u00ef\u00e4--\u00d4ko'),'si':u('\u0d91\u0d9a\u0dca\u0dc3\u0dad\u0dca \u0dbb\u0dcf\u0da2\u0db0\u0dcf\u0db1\u0dd2\u0dba'),'sk':u('Spojen\u00e9 kr\u00e1\u013eovstvo'),'sl':u('Zdru\u017eeno kraljestvo'),'sm':'*aa','sn':'*aa','so':'*aa','sq':u('Mbret\u00ebria e Bashkuar'),'sr':u('\u0423\u0458\u0435\u0434\u0438\u045a\u0435\u043d\u043e \u041a\u0440\u0430\u0459\u0435\u0432\u0441\u0442\u0432\u043e'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'Uingereza','ta':u('\u0baf\u0bc1\u0ba9\u0bc8\u0b9f\u0bc6\u0b9f\u0bcd \u0b95\u0bbf\u0b99\u0bcd\u0b9f\u0bae\u0bcd'),'te':u('\u0c2f\u0c41\u0c28\u0c48\u0c1f\u0c46\u0c21\u0c4d \u0c15\u0c3f\u0c02\u0c17\u0c4d\u200c\u0c21\u0c2e\u0c4d'),'tg':u('\u0428\u043e\u04b3\u0438\u0433\u0430\u0440\u0438\u0438 \u041c\u0443\u0442\u0442\u0430\u04b3\u0438\u0434\u0430'),'th':u('\u0e2a\u0e2b\u0e23\u0e32\u0e0a\u0e2d\u0e32\u0e13\u0e32\u0e08\u0e31\u0e01\u0e23'),'ti':u('\u12a5\u1295\u130d\u120a\u12dd'),'tk':u('Birle\u015fen Paty\u015falyk'),'tl':'*aa','tn':'*aa','to':u('Pilit\u0101nia'),'tr':u('Birle\u015fik Krall\u0131k'),'ts':'*aa','tt':u('\u0411\u04e9\u0435\u043a\u0431\u0440\u0438\u0442\u0430\u043d\u0438\u044f'),'tw':'*aa','ty':'*aa','ug':u('\u0628\u0649\u0631\u0644\u06d5\u0634\u0645\u06d5 \u067e\u0627\u062f\u0649\u0634\u0627\u06be\u0644\u0649\u0642'),'uk':u('\u0412\u0435\u043b\u0438\u043a\u0430 \u0411\u0440\u0438\u0442\u0430\u043d\u0456\u044f'),'ur':u('\u0633\u0644\u0637\u0646\u062a \u0645\u062a\u062d\u062f\u06c1'),'uz':'Buyuk Britaniya','ve':'*aa','vi':u('V\u01b0\u01a1ng qu\u1ed1c Anh'),'vo':'*aa','wa':'*aa','wo':'Ruwaayom Ini','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Omobabirin'),'za':'*aa','zh':u('\u82f1\u56fd'),'zu':'i-United Kingdom',},
  'GD': {'aa':'Grenada','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u130d\u122c\u1293\u12f3'),'an':'*aa','ar':u('\u063a\u0631\u064a\u0646\u0627\u062f\u0627'),'as':u('\u0997\u09cd\u09f0\u09c7\u09a8\u09be\u09a1\u09be'),'av':'*aa','ay':'*aa','az':'Qrenada','ba':'*aa','be':u('\u0413\u0440\u044d\u043d\u0430\u0434\u0430'),'bg':u('\u0413\u0440\u0435\u043d\u0430\u0434\u0430'),'bh':'*aa','bi':'*aa','bm':'Granadi','bn':u('\u0997\u09cd\u09b0\u09c7\u09a8\u09be\u09a1\u09be'),'bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f42\u0fb2\u0f80\u0f0b\u0f53\u0f0b\u0f4c'),'ee':'Grenada nutome','el':u('\u0393\u03c1\u03b5\u03bd\u03ac\u03b4\u03b1'),'en':'*aa','eo':'Grenado','es':'Granada','et':'*aa','eu':'*aa','fa':u('\u06af\u0631\u0646\u0627\u062f\u0627'),'ff':'Garnaad','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Grenade','fy':'*aa','ga':u('Grean\u00e1da'),'gd':u('Grean\u00e0da'),'gl':'*es','gn':'*aa','gu':u('\u0a97\u0acd\u0ab0\u0ac7\u0aa8\u0ac7\u0aa1\u0abe'),'gv':'*aa','ha':'Girnada','he':u('\u05d2\u05e8\u05e0\u05d3\u05d4'),'hi':u('\u0917\u094d\u0930\u0947\u0928\u093e\u0921\u093e'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u0533\u0580\u0565\u0576\u0561\u0564\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30b0\u30ec\u30ca\u30c0'),'ji':u('\u05d2\u05e8\u05e2\u05e0\u05d0\u05b7\u05d3\u05d0\u05b7'),'jv':'*aa','ka':u('\u10d2\u10e0\u10d4\u10dc\u10d0\u10d3\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a0\u17d2\u1782\u17d2\u179a\u17be\u178e\u17b6\u178a'),'kn':u('\u0c97\u0ccd\u0cb0\u0cc6\u0ca8\u0cc6\u0ca1\u0cbe'),'ko':u('\uadf8\ub808\ub098\ub2e4'),'kr':'*aa','ks':u('\u06af\u0631\u065b\u0646\u06cc\u0691\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'Gurenada','li':'*aa','ln':u('Gelenad\u025b'),'lo':u('\u0ec0\u0e81\u0ea3\u0ec0\u0e99\u0e94\u0eb2'),'lt':'*aa','lu':'Ngelenade','lv':u('Gren\u0101da'),'mg':'Grenady','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d17\u0d4d\u0d30\u0d28\u0d47\u0d21'),'mn':'*bg','mo':'*aa','mr':u('\u0917\u094d\u0930\u0947\u0928\u0947\u0921\u093e'),'ms':'*aa','mt':'*aa','my':u('\u1002\u101b\u102e\u1014\u1031\u1012\u102b'),'na':'*aa','nb':'*aa','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b17\u0b4d\u0b30\u0b47\u0b28\u0b3e\u0b21\u0b3e'),'os':'*aa','pa':u('\u0a17\u0a4d\u0a30\u0a47\u0a28\u0a3e\u0a21\u0a3e'),'pi':'*aa','pl':'*aa','ps':u('\u06ab\u0631\u0646\u0627\u062f\u0627'),'pt':'*es','qu':'*aa','rm':'*aa','rn':'Gerenada','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06af\u0631\u064a\u0646\u068a\u0627'),'se':'*aa','sg':u('Gren\u00e2da'),'si':u('\u0d9c\u0dca\u200d\u0dbb\u0dd0\u0db1\u0da9\u0dcf\u0dc0'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'Giriinaada','sq':u('Grenad\u00eb'),'sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b95\u0bbf\u0bb0\u0ba9\u0bc6\u0b9f\u0bbe'),'te':u('\u0c17\u0c4d\u0c30\u0c46\u0c28\u0c21\u0c3e'),'tg':'*bg','th':u('\u0e40\u0e01\u0e23\u0e40\u0e19\u0e14\u0e32'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':u('Kelenat\u0101'),'tr':'*aa','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u06af\u0649\u0631\u06d0\u0646\u0627\u062f\u0627'),'uk':u('\u0490\u0440\u0435\u043d\u0430\u0434\u0430'),'ur':u('\u06af\u0631\u06cc\u0646\u0627\u0688\u0627'),'uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Garanad','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Genada'),'za':'*aa','zh':u('\u683c\u6797\u7eb3\u8fbe'),'zu':'i-Grenada',},
  'GE': {'aa':'Georgia','ab':'*aa','ae':'*aa','af':u('Georgi\u00eb'),'ak':u('Gy\u0254gyea'),'am':u('\u1306\u122d\u1302\u12eb'),'an':'*aa','ar':u('\u062c\u0648\u0631\u062c\u064a\u0627'),'as':u('\u099c\u09f0\u09cd\u099c\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':u('G\u00fcrc\u00fcstan'),'ba':'*aa','be':u('\u0413\u0440\u0443\u0437\u0456\u044f'),'bg':u('\u0413\u0440\u0443\u0437\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':u('Zey\u0254rzi'),'bn':u('\u099c\u09b0\u09cd\u099c\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'Jorjia','bs':'Gruzija','ca':u('Ge\u00f2rgia'),'ce':u('\u0413\u0443\u044c\u0440\u0436\u0438\u0439\u0447\u043e\u044c'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Gruzie','cu':'*aa','cv':'*aa','cy':'*aa','da':'Georgien','de':'*da','dv':'*aa','dz':u('\u0f47\u0f7d\u0f62\u0f0b\u0f47\u0f71'),'ee':'Georgia nutome','el':u('\u0393\u03b5\u03c9\u03c1\u03b3\u03af\u03b1'),'en':'*aa','eo':'Kartvelujo','es':'*aa','et':'Gruusia','eu':'*aa','fa':u('\u06af\u0631\u062c\u0633\u062a\u0627\u0646'),'ff':'Jeorgii','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('G\u00e9orgie'),'fy':'*af','ga':'an tSeoirsia','gd':u('A\u2019 Chairtbheil'),'gl':'Xeorxia','gn':'*aa','gu':u('\u0a9c\u0acd\u0aaf\u0acb\u0ab0\u0acd\u0a9c\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Jiwarjiya','he':u('\u05d2\u05d0\u05d5\u05e8\u05d2\u05d9\u05d4'),'hi':u('\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Gr\u00fazia'),'hy':u('\u054e\u0580\u0561\u057d\u057f\u0561\u0576'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Georg\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30b8\u30e7\u30fc\u30b8\u30a2'),'ji':u('\u05d2\u05e8\u05d5\u05d6\u05d9\u05e2'),'jv':'*aa','ka':u('\u10e1\u10d0\u10e5\u10d0\u10e0\u10d7\u10d5\u10d4\u10da\u10dd'),'kg':'*aa','ki':'Jojia','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17ca\u17b8'),'kn':u('\u0c9c\u0cbe\u0cb0\u0ccd\u0c9c\u0cbf\u0caf\u0cbe'),'ko':u('\uc870\uc9c0\uc544'),'kr':'*aa','ks':u('\u062c\u0627\u0631\u062c\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*da','lg':'Gyogya','li':'*aa','ln':'Zorzi','lo':u('\u0e88\u0ecd\u0ec0\u0e88\u0e8d'),'lt':'*bs','lu':'Joriji','lv':'*bs','mg':'Zeorzia','mh':'*aa','mi':'*aa','mk':u('\u0413\u0440\u0443\u0437\u0438\u0458\u0430'),'ml':u('\u0d1c\u0d4b\u0d7c\u0d1c\u0d4d\u0d1c\u0d3f\u0d2f'),'mn':u('\u0413\u04af\u0440\u0436'),'mo':'*aa','mr':'*hi','ms':'*aa','mt':'il-Georgia','my':u('\u1002\u103b\u1031\u102c\u103a\u1002\u103b\u102e\u101a\u102c'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u091c\u0930\u094d\u091c\u093f\u092f\u093e'),'ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b1c\u0b30\u0b4d\u0b1c\u0b3f\u0b06'),'os':u('\u0413\u0443\u044b\u0440\u0434\u0437\u044b\u0441\u0442\u043e\u043d'),'pa':u('\u0a1c\u0a3e\u0a30\u0a1c\u0a40\u0a06'),'pi':'*aa','pl':'Gruzja','ps':u('\u06af\u0648\u0631\u062c\u0633\u062a\u0627\u0646'),'pt':u('Ge\u00f3rgia'),'qu':'*aa','rm':'*aa','rn':'Jeworujiya','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u062c\u0627\u0631\u062c\u064a\u0627'),'se':'*aa','sg':u('Zorz\u00efi'),'si':u('\u0da2\u0ddd\u0dbb\u0dca\u0da2\u0dd2\u0dba\u0dcf\u0dc0'),'sk':u('Gruz\u00ednsko'),'sl':'*bs','sm':'*aa','sn':'*aa','so':'Joorjiya','sq':'Gjeorgji','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*ki','ta':u('\u0b9c\u0bbe\u0bb0\u0bcd\u0b9c\u0bbf\u0baf\u0bbe'),'te':u('\u0c1c\u0c3e\u0c30\u0c4d\u0c1c\u0c3f\u0c2f\u0c3e'),'tg':u('\u0413\u0443\u0440\u04b7\u0438\u0441\u0442\u043e\u043d'),'th':u('\u0e08\u0e2d\u0e23\u0e4c\u0e40\u0e08\u0e35\u0e22'),'ti':'*am','tk':u('Gruzi\u00fda'),'tl':'*aa','tn':'*aa','to':u('Se\u014dsia'),'tr':u('G\u00fcrcistan'),'ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u06af\u0649\u0631\u06c7\u0632\u0649\u064a\u06d5'),'uk':'*be','ur':u('\u062c\u0627\u0631\u062c\u06cc\u0627'),'uz':'Gruziya','ve':'*aa','vi':'Gruzia','vo':'*aa','wa':'*aa','wo':'Seworsi','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de G\u1ecdgia'),'za':'*aa','zh':u('\u683c\u9c81\u5409\u4e9a'),'zu':'i-Georgia',},
  'GF': {'aa':'French Guiana','ab':'*aa','ae':'*aa','af':'Frans-Guyana','ak':u('Fr\u025bnkye Gayana'),'am':u('\u12e8\u1348\u1228\u1295\u1233\u12ed \u1309\u12ca\u12a0\u1293'),'an':'*aa','ar':u('\u063a\u0648\u064a\u0627\u0646\u0627 \u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629'),'as':u('\u09ab\u09cd\u09f0\u09be\u09a8\u09cd\u09b8 \u0997\u09af\u09bc\u09be\u09a8\u09be'),'av':'*aa','ay':'*aa','az':u('Fransa Qvianas\u0131'),'ba':'*aa','be':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f \u0413\u0432\u0456\u044f\u043d\u0430'),'bg':u('\u0424\u0440\u0435\u043d\u0441\u043a\u0430 \u0413\u0432\u0438\u0430\u043d\u0430'),'bh':'*aa','bi':'*aa','bm':'Faransi ka gwiyani','bn':u('\u09ab\u09b0\u09be\u09b8\u09c0 \u0997\u09be\u09af\u09bc\u09be\u09a8\u09be'),'bo':'*aa','br':u('Gwiana c\u02bchall'),'bs':'Francuska Gvajana','ca':'Guaiana Francesa','ce':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0438\u0439\u043d \u0413\u0432\u0438\u0430\u043d\u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Francouzsk\u00e1 Guyana'),'cu':'*aa','cv':'*aa','cy':'Guyane Ffrengig','da':'Fransk Guyana','de':u('Franz\u00f6sisch-Guayana'),'dv':'*aa','dz':u('\u0f42\u0f74\u0f60\u0f72\u0f0b\u0f61\u0f0b\u0f53\u0f0b \u0f55\u0fb2\u0f53\u0f66\u0f84\u0f0b\u0f58\u0f44\u0f60\u0f0b\u0f41\u0f7c\u0f44\u0f66'),'ee':'Frentsi Gayana nutome','el':u('\u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03ae \u0393\u03bf\u03c5\u03b9\u03ac\u03bd\u03b1'),'en':'*aa','eo':'Franca Gviano','es':'Guayana Francesa','et':'Prantsuse Guajaana','eu':'Guyana Frantsesa','fa':u('\u06af\u0648\u06cc\u0627\u0646 \u0641\u0631\u0627\u0646\u0633\u0647'),'ff':'Giyaan Farayse','fi':'Ranskan Guayana','fj':'*aa','fo':'Franska Gujana','fr':u('Guyane fran\u00e7aise'),'fy':'*af','ga':u('Gu\u00e1in na Fraince'),'gd':u('Guidhe\u00e0na na Frainge'),'gl':u('G\u00fciana Francesa'),'gn':'*aa','gu':u('\u0aab\u0acd\u0ab0\u0ac7\u0a82\u0a9a \u0a97\u0aaf\u0abe\u0aa8\u0abe'),'gv':'*aa','ha':'Gini Ta Faransa','he':u('\u05d2\u05d9\u05d0\u05e0\u05d4 \u05d4\u05e6\u05e8\u05e4\u05ea\u05d9\u05ea'),'hi':u('\u092b\u093c\u094d\u0930\u0947\u0902\u091a \u0917\u0941\u092f\u093e\u0928\u093e'),'ho':'*aa','hr':'Francuska Gijana','ht':'*aa','hu':'Francia Guyana','hy':u('\u0556\u0580\u0561\u0576\u057d\u056b\u0561\u056f\u0561\u0576 \u0533\u057e\u056b\u0561\u0576\u0561'),'hz':'*aa','ia':'*aa','id':'Guyana Prancis','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Franska Gv\u00e6jana'),'it':'Guyana francese','iu':'*aa','iw':'*he','ja':u('\u4ecf\u9818\u30ae\u30a2\u30ca'),'ji':u('\u05e4\u05bf\u05e8\u05d0\u05b7\u05e0\u05e6\u05d5\u05d9\u05d6\u05d9\u05e9\u05e2 \u05d2\u05d5\u05d9\u05d0\u05b7\u05e0\u05e2'),'jv':'*aa','ka':u('\u10e1\u10d0\u10e4\u10e0\u10d0\u10dc\u10d2\u10d4\u10d7\u10d8\u10e1 \u10d2\u10d5\u10d8\u10d0\u10dc\u10d0'),'kg':'*aa','ki':'Gwiyana ya Ufaransa','kj':'*aa','kk':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0437 \u0413\u0432\u0438\u0430\u043d\u0430\u0441\u044b'),'kl':'*aa','km':u('\u17a0\u17d2\u1782\u17b8\u17a2\u17b6\u178e\u17b6 \u1794\u17b6\u179a\u17b6\u17c6\u1784'),'kn':u('\u0cab\u0ccd\u0cb0\u0cc6\u0c82\u0c9a\u0ccd \u0c97\u0caf\u0cbe\u0ca8\u0cbe'),'ko':u('\ud504\ub791\uc2a4\ub839 \uae30\uc544\ub098'),'kr':'*aa','ks':u('\u0641\u0631\u065b\u0627\u0646\u0633\u0650\u0633\u06cc \u06af\u0650\u0627\u0646\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0434\u0443\u043a \u0413\u0432\u0438\u0430\u043d\u0430'),'la':'*aa','lb':'Guayane','lg':'Guyana enfalansa','li':'*aa','ln':u('Giyan\u025b ya Fal\u00e1ns\u025b'),'lo':u('\u0ec0\u0e9f\u0ea3\u0e99\u0e8a\u0ecc \u0e81\u0eb8\u0e8d\u0ead\u0eb2\u0e99\u0eb2'),'lt':u('Pranc\u016bzijos Gviana'),'lu':'Giyane wa Nfalanse','lv':u('Francijas Gvi\u0101na'),'mg':'Guyana frantsay','mh':'*aa','mi':'*aa','mk':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0430 \u0413\u0432\u0430\u0458\u0430\u043d\u0430'),'ml':u('\u0d2b\u0d4d\u0d30\u0d1e\u0d4d\u0d1a\u0d4d \u0d17\u0d2f\u0d3e\u0d28'),'mn':u('\u0424\u0440\u0430\u043d\u0446\u044b\u043d \u0413\u0432\u0438\u0430\u043d\u0430'),'mo':u('Guyana Francez\u0103'),'mr':u('\u092b\u094d\u0930\u0947\u0902\u091a \u0917\u092f\u093e\u0928\u093e'),'ms':'Guiana Perancis','mt':u('il-Guyana Fran\u010bi\u017ca'),'my':u('\u1015\u103c\u1004\u103a\u101e\u1005\u103a \u1002\u102e\u101a\u102c\u1014\u102c'),'na':'*aa','nb':'*da','nd':'Gwiyana ye Furansi','ne':u('\u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0947\u0932\u0940 \u0917\u093e\u092f\u0928\u093e'),'ng':'*aa','nl':'*af','nn':'*da','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2b\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a \u0b17\u0b41\u0b07\u0b28\u0b3e'),'os':'*aa','pa':u('\u0a2b\u0a30\u0a48\u0a02\u0a1a \u0a17\u0a41\u0a07\u0a06\u0a28\u0a3e'),'pi':'*aa','pl':'Gujana Francuska','ps':u('\u0641\u0631\u0627\u0646\u0633\u0648\u064a \u06ab\u0627\u0646\u0627'),'pt':'Guiana Francesa','qu':'*aa','rm':'Guyana Franzosa','rn':u('Gwayana y\u2019Abafaransa'),'ro':'*mo','ru':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f \u0413\u0432\u0438\u0430\u043d\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0641\u0631\u0627\u0646\u0633\u064a\u0633\u064a \u06af\u064a\u0627\u0646\u0627'),'se':'Frankriikka Guayana','sg':u('G\u00fcy\u00e2ni t\u00ee far\u00e2nzi'),'si':u('\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1 \u0d9c\u0dba\u0db1\u0dcf\u0dc0'),'sk':u('Franc\u00fazska Guyana'),'sl':'Francoska Gvajana','sm':'*aa','sn':'*aa','so':'*aa','sq':'Guajana Franceze','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'Franska Guyana','sw':'Guiana ya Ufaransa','ta':u('\u0baa\u0bbf\u0bb0\u0bc6\u0b9e\u0bcd\u0b9a\u0bc1 \u0b95\u0baf\u0bbe\u0ba9\u0bbe'),'te':u('\u0c2b\u0c4d\u0c30\u0c46\u0c02\u0c1a\u0c4d \u0c17\u0c3f\u0c2f\u0c3e\u0c28\u0c3e'),'tg':u('\u0413\u0432\u0438\u0430\u043d\u0430\u0438 \u0424\u0430\u0440\u043e\u043d\u0441\u0430'),'th':u('\u0e40\u0e1f\u0e23\u0e19\u0e0a\u0e4c\u0e40\u0e01\u0e35\u0e22\u0e19\u0e32'),'ti':u('\u1293\u12ed \u1348\u1228\u1295\u1233\u12ed \u1309\u12ed\u1293'),'tk':'Fransuz Gwianasy','tl':'*aa','tn':'*aa','to':u('Kuiana fakafalanis\u0113'),'tr':u('Frans\u0131z Guyanas\u0131'),'ts':'*aa','tt':'*kk','tw':'*aa','ty':'*aa','ug':u('\u0641\u0649\u0631\u0627\u0646\u0633\u0649\u064a\u06d5\u06af\u06d5 \u0642\u0627\u0631\u0627\u0634\u0644\u0649\u0642 \u06af\u0649\u06cb\u0649\u064a\u0627\u0646\u0627'),'uk':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u044c\u043a\u0430 \u0490\u0432\u0456\u0430\u043d\u0430'),'ur':u('\u0641\u0631\u06cc\u0646\u0686 \u06af\u06cc\u0627\u0646\u0627'),'uz':'Fransuz Gvianasi','ve':'*aa','vi':u('Guiana thu\u1ed9c Ph\u00e1p'),'vo':'*aa','wa':'*aa','wo':u('Guyaan Fara\u00f1se'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Firen\u1e63i Guana'),'za':'*aa','zh':u('\u6cd5\u5c5e\u572d\u4e9a\u90a3'),'zu':'i-French Guiana',},
  'GG': {'aa':'Guernsey','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u1309\u122d\u1290\u1232'),'an':'*aa','ar':u('\u063a\u064a\u0631\u0646\u0632\u064a'),'as':u('\u0997\u09cb\u09f0\u09c7\u09a8\u099a\u09bf'),'av':'*aa','ay':'*aa','az':'Gernsi','ba':'*aa','be':u('\u0413\u0435\u0440\u043d\u0441\u0456'),'bg':u('\u0413\u044a\u0440\u043d\u0437\u0438'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u0997\u09c1\u09af\u09bc\u09be\u09b0\u09cd\u09a8\u09b8\u09bf'),'bo':'*aa','br':'Gwernenez','bs':'Gernzi','ca':'*aa','ce':u('\u0413\u0435\u0440\u043d\u0441\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'Ynys y Garn','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f42\u0f74\u0f0b\u0f68\u0f7a\u0f62\u0fa3\u0f0b\u0f66\u0f72'),'ee':'Guernse nutome','el':u('\u0393\u03ba\u03ad\u03c1\u03bd\u03b6\u03b9'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'Guernesey','fa':u('\u06af\u0631\u0646\u0632\u06cc'),'ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*eu','fy':'*aa','ga':u('Geansa\u00ed'),'gd':u('Ge\u00e0rnsaidh'),'gl':'*aa','gn':'*aa','gu':u('\u0a97\u0acd\u0ab5\u0ac7\u0ab0\u0acd\u0aa8\u0ab8\u0ac7'),'gv':'*aa','ha':'*aa','he':u('\u05d2\u05e8\u05e0\u05d6\u05d9'),'hi':u('\u0917\u0930\u094d\u0928\u0938\u0940'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u0533\u0565\u0580\u0576\u057d\u056b'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30ac\u30fc\u30f3\u30b8\u30fc'),'ji':u('\u05d2\u05e2\u05e8\u05e0\u05d6\u05d9'),'jv':'*aa','ka':u('\u10d2\u10d4\u10e0\u10dc\u10e1\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u17a0\u17d2\u1782\u17c1\u1793\u179f\u17ca\u17b8'),'kn':u('\u0c97\u0cc1\u0cb0\u0ccd\u0ca8\u0ccd\u200c\u0cb8\u0cc6'),'ko':u('\uac74\uc9c0'),'kr':'*aa','ks':u('\u06af\u06cc\u0648\u064e\u0646\u064e\u0631\u0633\u06d2'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*eu','lo':u('\u0ec0\u0e81\u0eb5\u0e99\u0e8a\u0eb5'),'lt':'Gernsis','lu':'*aa','lv':u('G\u0113rnsija'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0413\u0435\u0440\u043d\u0437\u0438'),'ml':u('\u0d17\u0d47\u0d7a\u0d38\u0d3f'),'mn':'*ce','mo':'*aa','mr':u('\u0917\u094d\u0935\u0947\u0930\u094d\u0928\u0938\u0947'),'ms':'*aa','mt':'*aa','my':u('\u1002\u103d\u1014\u103a\u1038\u1007\u102e'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0917\u0941\u090f\u0930\u094d\u0928\u0938\u0947'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b17\u0b41\u0b0f\u0b30\u0b28\u0b47\u0b38\u0b3f'),'os':'*aa','pa':u('\u0a17\u0a30\u0a28\u0a1c\u0a40'),'pi':'*aa','pl':'*aa','ps':u('\u06ab\u0631\u0646\u0633\u064a'),'pt':'*aa','qu':'*eu','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06af\u0648\u0631\u0646\u0633\u064a'),'se':'*aa','sg':'*aa','si':u('\u0d9c\u0dbb\u0dca\u0db1\u0dca\u0dc3\u0dd2\u0dba'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'Gernsej','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b95\u0bc6\u0bb0\u0bcd\u0ba9\u0bcd\u0b9a\u0bbf'),'te':u('\u0c17\u0c30\u0c4d\u0c28\u0c4d\u200c\u0c38\u0c40'),'tg':'*ce','th':u('\u0e40\u0e01\u0e34\u0e23\u0e4c\u0e19\u0e0b\u0e35\u0e22\u0e4c'),'ti':u('\u1308\u122d\u1295\u1232'),'tk':'*az','tl':'*aa','tn':'*aa','to':u('Kuenis\u012b'),'tr':'*aa','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u06af\u06c7\u0631\u0646\u0633\u06d0\u064a'),'uk':u('\u0490\u0435\u0440\u043d\u0441\u0456'),'ur':u('\u06af\u0648\u0626\u0631\u0646\u0633\u06cc'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Gernase','xh':'*aa','yi':'*ji','yo':'*aa','za':'*aa','zh':u('\u6839\u897f\u5c9b'),'zu':'i-Guernsey',},
  'GH': {'aa':'Ghana','ab':'*aa','ae':'*aa','af':'*aa','ak':'Gaana','am':u('\u130b\u1293'),'an':'*aa','ar':u('\u063a\u0627\u0646\u0627'),'as':u('\u0998\u09be\u09a8\u09be'),'av':'*aa','ay':'*aa','az':'Qana','ba':'*aa','be':u('\u0413\u0430\u043d\u0430'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'Gana','bn':'*as','bo':'*aa','br':'*aa','bs':'*bm','ca':'*aa','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f42\u0fb7\u0f0b\u0f53'),'ee':'Ghana nutome','el':u('\u0393\u03ba\u03ac\u03bd\u03b1'),'en':'*aa','eo':'Ganao','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u063a\u0646\u0627'),'ff':'Ganaa','fi':'*aa','fj':'*aa','fo':'*bm','fr':'*aa','fy':'*aa','ga':u('G\u00e1na'),'gd':u('G\u00e0na'),'gl':'*aa','gn':'*aa','gu':u('\u0a98\u0abe\u0aa8\u0abe'),'gv':'*aa','ha':'*bm','he':u('\u05d2\u05d0\u05e0\u05d4'),'hi':u('\u0918\u093e\u0928\u093e'),'ho':'*aa','hr':'*bm','ht':'*aa','hu':u('Gh\u00e1na'),'hy':u('\u0533\u0561\u0576\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*bm','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30ac\u30fc\u30ca'),'ji':u('\u05d2\u05d4\u05d0\u05b7\u05e0\u05e2'),'jv':'*aa','ka':u('\u10d2\u10d0\u10dc\u10d0'),'kg':'*aa','ki':'Ngana','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u17a0\u17d2\u1782\u17b6\u178e\u17b6'),'kn':u('\u0c98\u0cbe\u0ca8\u0cbe'),'ko':u('\uac00\ub098'),'kr':'*aa','ks':u('\u06af\u0627\u0646\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*aa','lg':'*bm','li':'*aa','ln':'*bm','lo':u('\u0e81\u0eb2\u0e99\u0eb2'),'lt':'*bm','lu':'*ki','lv':'*bm','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d18\u0d3e\u0d28'),'mn':'*be','mo':'*aa','mr':'*hi','ms':'*aa','mt':'il-Ghana','my':u('\u1002\u102b\u1014\u102c'),'na':'*aa','nb':'*aa','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b18\u0b3e\u0b28\u0b3e'),'os':'*aa','pa':u('\u0a18\u0a3e\u0a28\u0a3e'),'pi':'*aa','pl':'*aa','ps':u('\u06ab\u0627\u0646\u0627'),'pt':'*bm','qu':'*aa','rm':'*aa','rn':'*bm','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06af\u0647\u0627\u0646\u0627'),'se':'*aa','sg':u('Gan\u00e4a'),'si':u('\u0d9d\u0dcf\u0db1\u0dcf\u0dc0'),'sk':'*aa','sl':'*bm','sm':'*aa','sn':'*aa','so':'*ak','sq':u('Gan\u00eb'),'sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b95\u0bbe\u0ba9\u0bbe'),'te':u('\u0c18\u0c28\u0c3e'),'tg':'*be','th':u('\u0e01\u0e32\u0e19\u0e32'),'ti':'*am','tk':'*bm','tl':'*aa','tn':'*aa','to':'Kana','tr':'*bm','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':'*ks','uk':'*be','ur':u('\u06af\u06be\u0627\u0646\u0627'),'uz':'*bm','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*bm','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Gana'),'za':'*aa','zh':u('\u52a0\u7eb3'),'zu':'i-Ghana',},
  'GI': {'aa':'Gibraltar','ab':'*aa','ae':'*aa','af':'*aa','ak':'Gyebralta','am':u('\u1302\u1265\u122b\u120d\u1270\u122d'),'an':'*aa','ar':u('\u062c\u0628\u0644 \u0637\u0627\u0631\u0642'),'as':u('\u099c\u09bf\u09ac\u09cd\u09f0\u09be\u09b2\u09cd\u099f\u09f0'),'av':'*aa','ay':'*aa','az':u('C\u0259b\u0259ll\u00fctariq'),'ba':'*aa','be':u('\u0413\u0456\u0431\u0440\u0430\u043b\u0442\u0430\u0440'),'bg':u('\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440'),'bh':'*aa','bi':'*aa','bm':'Zibralitari','bn':u('\u099c\u09bf\u09ac\u09cd\u09b0\u09be\u09b2\u09cd\u099f\u09be\u09b0'),'bo':'*aa','br':'Jibraltar','bs':'*aa','ca':'*aa','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f47\u0f72\u0f56\u0f0b\u0f62\u0f71\u0f63\u0f0b\u0f4a\u0f62'),'ee':'Gibraltar nutome','el':u('\u0393\u03b9\u03b2\u03c1\u03b1\u03bb\u03c4\u03ac\u03c1'),'en':'*aa','eo':u('\u011cibraltaro'),'es':'*aa','et':'*aa','eu':'*aa','fa':u('\u062c\u0628\u0644\u200c\u0627\u0644\u0637\u0627\u0631\u0642'),'ff':'Jibraltaar','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Giobr\u00e1ltar'),'gd':'Diobraltar','gl':'Xibraltar','gn':'*aa','gu':u('\u0a9c\u0ac0\u0aac\u0acd\u0ab0\u0abe\u0ab2\u0acd\u0a9f\u0ab0'),'gv':'*aa','ha':'Jibaraltar','he':u('\u05d2\u05d9\u05d1\u05e8\u05dc\u05d8\u05e8'),'hi':u('\u091c\u093f\u092c\u094d\u0930\u093e\u0932\u094d\u091f\u0930'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':u('Gibralt\u00e1r'),'hy':u('\u054b\u056b\u0562\u0580\u0561\u056c\u0569\u0561\u0580'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('G\u00edbraltar'),'it':'Gibilterra','iu':'*aa','iw':'*he','ja':u('\u30b8\u30d6\u30e9\u30eb\u30bf\u30eb'),'ji':u('\u05d2\u05d9\u05d1\u05e8\u05d0\u05b7\u05dc\u05d8\u05d0\u05b7\u05e8'),'jv':'*aa','ka':u('\u10d2\u10d8\u10d1\u10e0\u10d0\u10da\u10e2\u10d0\u10e0\u10d8'),'kg':'*aa','ki':'Jibralta','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a0\u17d2\u179f\u17ca\u17b8\u1794\u17d2\u179a\u17b6\u179b\u17cb\u178f\u17b6'),'kn':u('\u0c97\u0cbf\u0cac\u0ccd\u0cb0\u0cbe\u0cb2\u0ccd\u0c9f\u0cb0\u0ccd'),'ko':u('\uc9c0\ube0c\ub864\ud130'),'kr':'*aa','ks':u('\u062c\u0650\u0628\u0631\u0627\u0644\u0679\u064e\u0631'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'Giburalita','li':'*aa','ln':u('Zibatal\u025b'),'lo':u('\u0e88\u0eb4\u0e9a\u0e9a\u0ea3\u0ead\u0e99\u0e97\u0eb2'),'lt':'Gibraltaras','lu':'Jibeletale','lv':u('Gibralt\u0101rs'),'mg':'Zibraltara','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d1c\u0d3f\u0d2c\u0d4d\u0d30\u0d3e\u0d7e\u0d1f\u0d4d\u0d1f\u0d7c'),'mn':'*bg','mo':'*aa','mr':'*hi','ms':'*aa','mt':u('\u0120ibilt\u00e0'),'my':u('\u1002\u103b\u102e\u1018\u101b\u1031\u102c\u103a\u101c\u103a\u1010\u102c'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u091c\u093f\u092c\u094d\u0930\u093e\u0932\u094d\u091f\u093e\u0930'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b1c\u0b3f\u0b2c\u0b4d\u0b30\u0b3e\u0b32\u0b4d\u0b1f\u0b30\u0b4d'),'os':'*aa','pa':u('\u0a1c\u0a3f\u0a2c\u0a30\u0a3e\u0a32\u0a1f\u0a30'),'pi':'*aa','pl':'*aa','ps':u('\u062c\u0628\u0644 \u0627\u0644\u0637\u0627\u0631\u0642'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'Juburalitari','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u062c\u0628\u0631\u0627\u0644\u067d\u0631'),'se':'*aa','sg':u('Zibralt\u00e4ra, Zibarat\u00e4ra'),'si':u('\u0da2\u0dd2\u0db6\u0dca\u200d\u0dbb\u0ddd\u0dbd\u0dca\u0da7\u0dcf\u0dc0'),'sk':'*hu','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'Gjibraltar','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b9c\u0bbf\u0baa\u0bcd\u0bb0\u0bbe\u0bb2\u0bcd\u0b9f\u0bb0\u0bcd'),'te':u('\u0c1c\u0c3f\u0c2c\u0c4d\u0c30\u0c3e\u0c32\u0c4d\u0c1f\u0c30\u0c4d'),'tg':'*bg','th':u('\u0e22\u0e34\u0e1a\u0e23\u0e2d\u0e25\u0e15\u0e32\u0e23\u0e4c'),'ti':u('\u130a\u1265\u122b\u120d\u1273\u122d'),'tk':'*aa','tl':'*aa','tn':'*aa','to':u('Sipal\u0101lit\u0101'),'tr':u('Cebelitar\u0131k'),'ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u062c\u06d5\u0628\u0649\u0644\u062a\u0627\u0631\u0649\u0642'),'uk':u('\u0490\u0456\u0431\u0440\u0430\u043b\u0442\u0430\u0440'),'ur':'*ps','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Sibraltaar','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Gibaratara'),'za':'*aa','zh':u('\u76f4\u5e03\u7f57\u9640'),'zu':'i-Gibraltar',},
  'GL': {'aa':'Greenland','ab':'*aa','ae':'*aa','af':'Groenland','ak':'Greenman','am':u('\u130d\u122a\u1295\u120b\u1295\u12f5'),'an':'*aa','ar':u('\u063a\u0631\u064a\u0646\u0644\u0627\u0646\u062f'),'as':u('\u0997\u09cd\u09f0\u09c0\u09a3\u09b2\u09c7\u09a3\u09cd\u09a1'),'av':'*aa','ay':'*aa','az':'Qrenlandiya','ba':'*aa','be':u('\u0413\u0440\u044d\u043d\u043b\u0430\u043d\u0434\u044b\u044f'),'bg':u('\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':u('G\u0254r\u0254henelandi'),'bn':u('\u0997\u09cd\u09b0\u09c0\u09a8\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1'),'bo':'*aa','br':'Greunland','bs':'Grenland','ca':u('Grenl\u00e0ndia'),'ce':u('\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Gr\u00f3nsko'),'cu':'*aa','cv':'*aa','cy':'Yr Ynys Las','da':u('Gr\u00f8nland'),'de':u('Gr\u00f6nland'),'dv':'*aa','dz':u('\u0f42\u0f72\u0f62\u0f71\u0f72\u0f53\u0f0b\u0f63\u0f53\u0f4c\u0f84'),'ee':'Grinland nutome','el':u('\u0393\u03c1\u03bf\u03b9\u03bb\u03b1\u03bd\u03b4\u03af\u03b1'),'en':'*aa','eo':'Gronlando','es':'Groenlandia','et':u('Gr\u00f6\u00f6nimaa'),'eu':'*es','fa':u('\u06af\u0631\u06cc\u0646\u0644\u0646\u062f'),'ff':'Gorwendland','fi':u('Gr\u00f6nlanti'),'fj':'*aa','fo':'*da','fr':'*af','fy':u('Grienl\u00e2n'),'ga':'an Ghraonlainn','gd':u('A\u2019 Ghraonlann'),'gl':'*es','gn':'*aa','gu':u('\u0a97\u0acd\u0ab0\u0ac0\u0aa8\u0ab2\u0ac7\u0aa8\u0acd\u0aa1'),'gv':'*aa','ha':'Grinlan','he':u('\u05d2\u05e8\u05d9\u05e0\u05dc\u05e0\u05d3'),'hi':u('\u0917\u094d\u0930\u0940\u0928\u0932\u0948\u0902\u0921'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*de','hy':u('\u0533\u0580\u0565\u0576\u056c\u0561\u0576\u0564\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'Grinlandia','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Gr\u00e6nland'),'it':'*es','iu':'*aa','iw':'*he','ja':u('\u30b0\u30ea\u30fc\u30f3\u30e9\u30f3\u30c9'),'ji':u('\u05d2\u05e8\u05d9\u05e0\u05dc\u05d0\u05b7\u05e0\u05d3'),'jv':'*aa','ka':u('\u10d2\u10e0\u10d4\u10dc\u10da\u10d0\u10dc\u10d3\u10d8\u10d0'),'kg':'*aa','ki':'Grinlandi','kj':'*aa','kk':'*bg','kl':'Kalaallit Nunaat','km':u('\u17a0\u17d2\u1782\u17d2\u179a\u17c4\u17a2\u1784\u17cb\u17a1\u1784\u17cb'),'kn':u('\u0c97\u0ccd\u0cb0\u0cc0\u0ca8\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd'),'ko':u('\uadf8\ub9b0\ub780\ub4dc'),'kr':'*aa','ks':u('\u06af\u0631\u06cc\u0656\u0646\u0644\u06cc\u0646\u065b\u0691'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*de','lg':'Gurenelandi','li':'*aa','ln':'Gowelande','lo':u('\u0e81\u0ea3\u0eb5\u0e99\u0ec1\u0ea5\u0e99'),'lt':'Grenlandija','lu':'Ngowelande','lv':'Grenlande','mg':'*af','mh':'*aa','mi':'*aa','mk':u('\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434'),'ml':u('\u0d17\u0d4d\u0d30\u0d40\u0d7b\u0d32\u0d3e\u0d7b\u0d31\u0d4d'),'mn':'*mk','mo':'Groenlanda','mr':u('\u0917\u094d\u0930\u0940\u0928\u0932\u0902\u0921'),'ms':'*aa','mt':'*aa','my':u('\u1002\u101b\u1004\u103a\u1038\u101c\u1014\u103a\u1038'),'na':'*aa','nb':'*da','nd':'*aa','ne':u('\u0917\u094d\u0930\u093f\u0928\u0932\u094d\u092f\u093e\u0923\u094d\u0921'),'ng':'*aa','nl':'*af','nn':'*da','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b17\u0b4d\u0b30\u0b40\u0b28\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21'),'os':'*aa','pa':u('\u0a17\u0a4d\u0a30\u0a40\u0a28\u0a32\u0a48\u0a02\u0a21'),'pi':'*aa','pl':'Grenlandia','ps':u('\u06ab\u0631\u06cc\u0646\u0644\u06cc\u0646\u0689'),'pt':u('Groenl\u00e2ndia'),'qu':'*aa','rm':u('Gr\u00f6nlanda'),'rn':'Gurunilandi','ro':'*mo','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06af\u0631\u064a\u0646 \u0644\u064a\u0646\u068a'),'se':'*kl','sg':u('Gorol\u00e2nde'),'si':u('\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba'),'sk':'*cs','sl':'*lt','sm':'*aa','sn':'*aa','so':'*aa','sq':u('Grenland\u00eb'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':u('\u0b95\u0bbf\u0bb0\u0bc0\u0ba9\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1'),'te':u('\u0c17\u0c4d\u0c30\u0c40\u0c28\u0c4d\u200c\u0c32\u0c4d\u0c2f\u0c3e\u0c02\u0c21\u0c4d'),'tg':'*bg','th':u('\u0e01\u0e23\u0e35\u0e19\u0e41\u0e25\u0e19\u0e14\u0e4c'),'ti':'*am','tk':u('Grenlandi\u00fda'),'tl':'*aa','tn':'*aa','to':'Kulinilani','tr':'*de','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u06af\u0649\u0631\u06d0\u0646\u0644\u0627\u0646\u062f\u0649\u064a\u06d5'),'uk':u('\u0490\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0456\u044f'),'ur':u('\u06af\u0631\u06cc\u0646 \u0644\u06cc\u0646\u0688'),'uz':'Grenlandiya','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':u('Girinl\u00e0nd'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Gerelandi'),'za':'*aa','zh':u('\u683c\u9675\u5170'),'zu':'i-Greenland',},
  'GM': {'aa':'Gambia','ab':'*aa','ae':'*aa','af':u('Gambi\u00eb'),'ak':'*aa','am':u('\u130b\u121d\u1262\u12eb'),'an':'*aa','ar':u('\u063a\u0627\u0645\u0628\u064a\u0627'),'as':u('\u0997\u09be\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Qambiya','ba':'*aa','be':u('\u0413\u0430\u043c\u0431\u0456\u044f'),'bg':u('\u0413\u0430\u043c\u0431\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Ganbi','bn':'*as','bo':'*aa','br':'*aa','bs':'Gambija','ca':u('G\u00e0mbia'),'ce':u('\u0413\u0430\u043c\u0431\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Gambie','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f42\u0fb7\u0f7a\u0f58\u0f0b\u0f56\u0f72\u0f0b\u0f61'),'ee':'Gambia nutome','el':u('\u0393\u03ba\u03ac\u03bc\u03c0\u03b9\u03b1'),'en':'*aa','eo':'Gambio','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u06af\u0627\u0645\u0628\u06cc\u0627'),'ff':'Gammbi','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*cs','fy':'*aa','ga':'an Ghaimbia','gd':u('A\u2019 Ghaimbia'),'gl':'*aa','gn':'*aa','gu':u('\u0a97\u0ac7\u0aae\u0acd\u0aac\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Gambiya','he':u('\u05d2\u05de\u05d1\u05d9\u05d4'),'hi':u('\u0917\u093e\u092e\u094d\u092c\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u0533\u0561\u0574\u0562\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Gamb\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30ac\u30f3\u30d3\u30a2'),'ji':u('\u05d2\u05d0\u05b7\u05de\u05d1\u05d9\u05e2'),'jv':'*aa','ka':u('\u10d2\u10d0\u10db\u10d1\u10d8\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a0\u17d2\u1782\u17c6\u1794\u17ca\u17b8'),'kn':u('\u0c97\u0ccd\u0caf\u0cbe\u0c82\u0cac\u0cbf\u0caf\u0cbe'),'ko':u('\uac10\ube44\uc544'),'kr':'*aa','ks':u('\u06af\u064e\u0645\u0628\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'Gambya','li':'*aa','ln':'Gambi','lo':u('\u0eaa\u0eb2\u0e97\u0eb2\u0ea5\u0eb0\u0e99\u0eb0\u0ea5\u0eb1\u0e94\u0ec1\u0e81\u0ea1\u0ec0\u0e9a\u0e8d'),'lt':'*bs','lu':'*ln','lv':'*bs','mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0413\u0430\u043c\u0431\u0438\u0458\u0430'),'ml':u('\u0d17\u0d3e\u0d02\u0d2c\u0d3f\u0d2f'),'mn':'*ce','mo':'*aa','mr':'*hi','ms':'*aa','mt':'il-Gambja','my':u('\u1002\u1019\u103a\u1018\u102e\u101b\u102c'),'na':'*aa','nb':'*aa','nd':'*ha','ne':u('\u0917\u093e\u092e\u094d\u0935\u093f\u092f\u093e'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b17\u0b3e\u0b2e\u0b4d\u0b2c\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a17\u0a48\u0a02\u0a2c\u0a40\u0a06'),'pi':'*aa','pl':'*aa','ps':u('\u06ab\u0627\u0645\u0628\u06cc\u0627'),'pt':u('G\u00e2mbia'),'qu':'*aa','rm':'*aa','rn':'*ha','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06af\u064a\u0645\u0628\u064a\u0627'),'se':u('G\u00e1mbia'),'sg':u('Gamb\u00efi'),'si':u('\u0d9c\u0dd0\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*aa','sl':'*bs','sm':'*aa','sn':'*aa','so':'*ha','sq':'*aa','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b95\u0bbe\u0bae\u0bcd\u0baa\u0bbf\u0baf\u0bbe'),'te':u('\u0c17\u0c3e\u0c02\u0c2c\u0c3f\u0c2f\u0c3e'),'tg':'*bg','th':u('\u0e41\u0e01\u0e21\u0e40\u0e1a\u0e35\u0e22'),'ti':'*am','tk':u('Gambi\u00fda'),'tl':'*aa','tn':'*aa','to':'Kamipia','tr':'*ha','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u06af\u0627\u0645\u0628\u0649\u064a\u06d5'),'uk':'*be','ur':u('\u06af\u06cc\u0645\u0628\u06cc\u0627'),'uz':'*ha','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':u('G\u00e0mbi'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Gambia'),'za':'*aa','zh':u('\u5188\u6bd4\u4e9a'),'zu':'i-Gambia',},
  'GN': {'aa':'Guinea','ab':'*aa','ae':'*aa','af':'Guinee','ak':'Gini','am':u('\u130a\u1292'),'an':'*aa','ar':u('\u063a\u064a\u0646\u064a\u0627'),'as':u('\u0997\u09bf\u09a8\u09bf'),'av':'*aa','ay':'*aa','az':'Qvineya','ba':'*aa','be':u('\u0413\u0432\u0456\u043d\u0435\u044f'),'bg':u('\u0413\u0432\u0438\u043d\u0435\u044f'),'bh':'*aa','bi':'*aa','bm':'Gine','bn':'*as','bo':'*aa','br':'Ginea','bs':'Gvineja','ca':'*aa','ce':u('\u0413\u0432\u0438\u043d\u0435\u0439'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':u('Guin\u00e9e'),'da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f42\u0fb7\u0f72\u0f0b\u0f53\u0f72'),'ee':'Guini nutome','el':u('\u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1'),'en':'*aa','eo':'Gvineo','es':'*aa','et':'*aa','eu':'*br','fa':u('\u06af\u06cc\u0646\u0647'),'ff':'*bm','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*cy','fy':'*af','ga':'an Ghuine','gd':'*ak','gl':'*aa','gn':'*aa','gu':u('\u0a97\u0abf\u0aa8\u0ac0'),'gv':'*aa','ha':'*ak','he':u('\u05d2\u05d9\u05e0\u05d0\u05d4'),'hi':u('\u0917\u093f\u0928\u0940'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u0533\u057e\u056b\u0576\u0565\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('G\u00ednea'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30ae\u30cb\u30a2'),'ji':u('\u05d2\u05d9\u05e0\u05e2'),'jv':'*aa','ka':u('\u10d2\u10d5\u10d8\u10dc\u10d4\u10d0'),'kg':'*aa','ki':'*bm','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a0\u17d2\u1782\u17b8\u178e\u17c1'),'kn':u('\u0c97\u0cbf\u0ca8\u0cbf'),'ko':u('\uae30\ub2c8'),'kr':'*aa','ks':u('\u06af\u0650\u0646\u06cc'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'*ak','li':'*aa','ln':u('Gin\u025b'),'lo':u('\u0e81\u0eb4\u0e99\u0eb5'),'lt':u('Gvin\u0117ja'),'lu':'Ngine','lv':'*bs','mg':'*br','mh':'*aa','mi':'*aa','mk':u('\u0413\u0432\u0438\u043d\u0435\u0458\u0430'),'ml':u('\u0d17\u0d3f\u0d28\u0d3f\u0d2f'),'mn':'*ce','mo':'Guineea','mr':'*hi','ms':'*aa','mt':'il-Guinea','my':u('\u1002\u102e\u1014\u102e'),'na':'*aa','nb':'*aa','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b17\u0b41\u0b07\u0b28\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a17\u0a3f\u0a28\u0a40'),'pi':'*aa','pl':'Gwinea','ps':u('\u06ab\u06cc\u0646\u0647'),'pt':u('Guin\u00e9'),'qu':'*aa','rm':'*aa','rn':'Guneya','ro':'*mo','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06af\u0646\u064a'),'se':'*aa','sg':u('Gin\u00ebe'),'si':u('\u0d9c\u0dd2\u0dab\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*aa','sl':'*bs','sm':'*aa','sn':'*aa','so':'*ak','sq':'Guine','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*bm','ta':u('\u0b95\u0bbf\u0ba9\u0bbf\u0baf\u0bbe'),'te':u('\u0c17\u0c3f\u0c28\u0c3f\u0c2f\u0c3e'),'tg':'*bg','th':u('\u0e01\u0e34\u0e19\u0e35'),'ti':'*am','tk':u('Gwine\u00fda'),'tl':'*aa','tn':'*aa','to':'Kini','tr':'*bm','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u06af\u0649\u06cb\u0649\u0646\u0649\u064a\u06d5'),'uk':'*be','ur':u('\u06af\u0646\u06cc'),'uz':'Gvineya','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*bm','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Gene'),'za':'*aa','zh':u('\u51e0\u5185\u4e9a'),'zu':'i-Guinea',},
  'GP': {'aa':'Guadeloupe','ab':'*aa','ae':'*aa','af':'*aa','ak':'Guwadelup','am':u('\u1309\u12cb\u12f0\u1209\u1355'),'an':'*aa','ar':u('\u063a\u0648\u0627\u062f\u0644\u0648\u0628'),'as':u('\u0997\u09c1\u09f1\u09be\u09a1\u09c7\u09b2\u09c1\u09aa'),'av':'*aa','ay':'*aa','az':'Qvadelupa','ba':'*aa','be':u('\u0413\u0432\u0430\u0434\u044d\u043b\u0443\u043f\u0430'),'bg':u('\u0413\u0432\u0430\u0434\u0435\u043b\u0443\u043f\u0430'),'bh':'*aa','bi':'*aa','bm':'Gwadelup','bn':u('\u0997\u09c1\u09af\u09bc\u09be\u09a6\u09c7\u09b2\u09cc\u09aa'),'bo':'*aa','br':'Gwadeloup','bs':'Gvadalupe','ca':'*aa','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f42\u0f7c\u0f0b\u0f4c\u0f7a\u0f0b\u0f63\u0f74\u0f0b\u0f54\u0f7a'),'ee':'Guadelupe nutome','el':u('\u0393\u03bf\u03c5\u03b1\u03b4\u03b5\u03bb\u03bf\u03cd\u03c0\u03b7'),'en':'*aa','eo':'Gvadelupo','es':'Guadalupe','et':'*aa','eu':'*es','fa':u('\u06af\u0648\u0627\u062f\u0644\u0648\u067e'),'ff':'Gwaadalup','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Guadal\u00faip'),'gd':'Guadalup','gl':'*es','gn':'*aa','gu':u('\u0a97\u0acd\u0ab5\u0abe\u0aa1\u0ac7\u0ab2\u0acb\u0aaa'),'gv':'*aa','ha':'Gwadaluf','he':u('\u05d2\u05d5\u05d5\u05d0\u05d3\u05dc\u05d5\u05e4'),'hi':u('\u0917\u094d\u0935\u093e\u0921\u0947\u0932\u0942\u092a'),'ho':'*aa','hr':'*es','ht':'*aa','hu':'*aa','hy':u('\u0533\u057e\u0561\u0564\u0565\u056c\u0578\u0582\u057a\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Gvadel\u00fapeyjar'),'it':'Guadalupa','iu':'*aa','iw':'*he','ja':u('\u30b0\u30a2\u30c9\u30eb\u30fc\u30d7'),'ji':u('\u05d2\u05d5\u05d5\u05d0\u05b7\u05d3\u05e2\u05dc\u05d5\u05e4'),'jv':'*aa','ka':u('\u10d2\u10d5\u10d0\u10d3\u10d4\u10da\u10e3\u10de\u10d0'),'kg':'*aa','ki':'Gwadelupe','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a0\u17d2\u1782\u17c4\u178a\u17ba\u17a1\u17bb\u1794'),'kn':u('\u0c97\u0cc1\u0ca1\u0cc6\u0cb2\u0ccb\u0caa\u0ccd'),'ko':u('\uacfc\ub4e4\ub8e8\ud504'),'kr':'*aa','ks':u('\u06af\u064e\u0648\u0627\u0691\u06cc\u0644\u0648\u067e'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'Gwadalupe','li':'*aa','ln':u('Gwad\u025blup\u025b'),'lo':u('\u0e81\u0ebb\u0ea7\u0e94\u0eb2\u0ea5\u0eb9\u0e9a'),'lt':'Gvadelupa','lu':'Ngwadelupe','lv':'*lt','mg':'Goadelopy','mh':'*aa','mi':'*aa','mk':u('\u0413\u0432\u0430\u0434\u0430\u043b\u0443\u043f\u0435'),'ml':u('\u0d17\u0d4d\u0d35\u0d3e\u0d21\u0d32\u0d42\u0d2a\u0d4d\u0d2a\u0d4d'),'mn':u('\u0413\u0432\u0430\u0434\u0435\u043b\u0443\u043f'),'mo':'Guadelupa','mr':u('\u0917\u094d\u0935\u093e\u0921\u0947\u0932\u094b\u0909\u092a\u0947'),'ms':'*aa','mt':'*aa','my':u('\u1002\u103d\u102b\u1012\u102e\u101c\u102f'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0917\u094d\u0935\u093e\u0921\u0947\u0932\u0941\u092a'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b17\u0b41\u0b06\u0b21\u0b47\u0b32\u0b4b\u0b2a\u0b4d\u200c'),'os':'*aa','pa':u('\u0a17\u0a41\u0a06\u0a21\u0a47\u0a32\u0a4b\u0a2a'),'pi':'*aa','pl':'Gwadelupa','ps':u('\u06ab\u0627\u0644\u0689\u06cc\u067e'),'pt':'*es','qu':'*aa','rm':'*aa','rn':'*ki','ro':'*mo','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06af\u0648\u0627\u068a\u06cc\u0644\u0648\u067e'),'se':'*aa','sg':u('Guadel\u00fbpu'),'si':u('\u0d9c\u0dca\u0dc0\u0ddd\u0da9\u0dbd\u0ddd\u0db4\u0dca'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*es','sr':'*mn','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b95\u0bcd\u0bb5\u0bbe\u0ba4\u0bc7\u0bb2\u0bcb\u0baa\u0bcd'),'te':u('\u0c17\u0c4d\u0c35\u0c3e\u0c21\u0c46\u0c32\u0c4b\u0c2a\u0c4d'),'tg':'*bg','th':u('\u0e01\u0e27\u0e32\u0e40\u0e14\u0e2d\u0e25\u0e39\u0e1b'),'ti':'*am','tk':'*pl','tl':'*aa','tn':'*aa','to':'Kuatalupe','tr':'*aa','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u06af\u0649\u06cb\u0627\u062f\u06d0\u0644\u06c7\u067e'),'uk':u('\u0490\u0432\u0430\u0434\u0435\u043b\u0443\u043f\u0430'),'ur':u('\u06af\u0648\u0627\u0688\u06cc\u0644\u0648\u067e'),'uz':'Gvadelupe','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Guwaadelup','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Gadelope'),'za':'*aa','zh':u('\u74dc\u5fb7\u7f57\u666e'),'zu':'i-Guadeloupe',},
  'GQ': {'aa':'Equatorial Guinea','ab':'*aa','ae':'*aa','af':'Ekwatoriaal-Guinee','ak':'Gini Ikuweta','am':u('\u12a2\u12b3\u1276\u122a\u12eb\u120d \u130a\u1292'),'an':'*aa','ar':u('\u063a\u064a\u0646\u064a\u0627 \u0627\u0644\u0627\u0633\u062a\u0648\u0627\u0626\u064a\u0629'),'as':u('\u0987\u0995\u09c1\u09f1\u09c7\u099f\u09f0\u09bf\u09af\u09bc\u09c7\u09b2 \u0997\u09bf\u09a8\u09bf'),'av':'*aa','ay':'*aa','az':'Ekvatorial Qvineya','ba':'*aa','be':u('\u042d\u043a\u0432\u0430\u0442\u0430\u0440\u044b\u044f\u043b\u044c\u043d\u0430\u044f \u0413\u0432\u0456\u043d\u0435\u044f'),'bg':u('\u0415\u043a\u0432\u0430\u0442\u043e\u0440\u0438\u0430\u043b\u043d\u0430 \u0413\u0432\u0438\u043d\u0435\u044f'),'bh':'*aa','bi':'*aa','bm':u('Gine ekwat\u0254ri'),'bn':u('\u09a8\u09bf\u09b0\u0995\u09cd\u09b7\u09c0\u09af\u09bc \u0997\u09bf\u09a8\u09bf'),'bo':'*aa','br':u('Ginea ar C\u02bcheheder'),'bs':'Ekvatorijalna Gvineja','ca':'Guinea Equatorial','ce':u('\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u0430\u043d \u0413\u0432\u0438\u043d\u0435\u0439'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Rovn\u00edkov\u00e1 Guinea'),'cu':'*aa','cv':'*aa','cy':'Guinea Gyhydeddol','da':u('\u00c6kvatorialguinea'),'de':u('\u00c4quatorialguinea'),'dv':'*aa','dz':u('\u0f68\u0f7a\u0f0b\u0f40\u0f74\u0f0b\u0f4a\u0f7c\u0f0b\u0f62\u0f7a\u0f63\u0f0b \u0f42\u0f72\u0f0b\u0f53\u0f72'),'ee':'Ekuatorial Guini nutome','el':u('\u0399\u03c3\u03b7\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1'),'en':'*aa','eo':'Ekvatora Gvineo','es':'Guinea Ecuatorial','et':'Ekvatoriaal-Guinea','eu':'Ekuatore Ginea','fa':u('\u06af\u06cc\u0646\u0647\u0654 \u0627\u0633\u062a\u0648\u0627\u06cc\u06cc'),'ff':'Ginee Ekuwaatoriyaal','fi':u('P\u00e4iv\u00e4ntasaajan Guinea'),'fj':'*aa','fo':'Ekvatorguinea','fr':u('Guin\u00e9e \u00e9quatoriale'),'fy':'Equatoriaal-Guinea','ga':u('an Ghuine Mhe\u00e1nchiorclach'),'gd':'Gini Mheadhan-Chriosach','gl':'*es','gn':'*aa','gu':u('\u0a87\u0a95\u0acd\u0ab5\u0ac7\u0a9f\u0acb\u0ab0\u0abf\u0aaf\u0ab2 \u0a97\u0abf\u0aa8\u0ac0'),'gv':'*aa','ha':'Gini Ta Ikwaita','he':u('\u05d2\u05d9\u05e0\u05d0\u05d4 \u05d4\u05de\u05e9\u05d5\u05d5\u05e0\u05d9\u05ea'),'hi':u('\u0907\u0915\u094d\u0935\u0947\u091f\u094b\u0930\u093f\u092f\u0932 \u0917\u093f\u0928\u0940'),'ho':'*aa','hr':'Ekvatorska Gvineja','ht':'*aa','hu':u('Egyenl\u00edt\u0151i-Guinea'),'hy':u('\u0540\u0561\u057d\u0561\u0580\u0561\u056f\u0561\u056e\u0561\u0575\u056b\u0576 \u0533\u057e\u056b\u0576\u0565\u0561'),'hz':'*aa','ia':'*aa','id':'Guinea Ekuatorial','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Mi\u00f0baugs-G\u00ednea'),'it':'Guinea Equatoriale','iu':'*aa','iw':'*he','ja':u('\u8d64\u9053\u30ae\u30cb\u30a2'),'ji':u('\u05e2\u05e7\u05d5\u05d5\u05d0\u05b7\u05d8\u05d0\u05e8\u05d9\u05e9\u05e2 \u05d2\u05d9\u05e0\u05e2'),'jv':'*aa','ka':u('\u10d4\u10d9\u10d5\u10d0\u10e2\u10dd\u10e0\u10e3\u10da\u10d8 \u10d2\u10d5\u10d8\u10dc\u10d4\u10d0'),'kg':'*aa','ki':'Ginekweta','kj':'*aa','kk':u('\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u043b\u044b\u049b \u0413\u0432\u0438\u043d\u0435\u044f'),'kl':'*aa','km':u('\u17a0\u17d2\u1782\u17b8\u178e\u17c1\u17a2\u17c1\u1780\u17d2\u179c\u17b6\u1791\u17d0\u179a'),'kn':u('\u0c88\u0c95\u0ccd\u0cb5\u0cc6\u0c9f\u0ccb\u0cb0\u0cbf\u0caf\u0cb2\u0ccd \u0c97\u0cbf\u0ca8\u0cbf'),'ko':u('\uc801\ub3c4 \uae30\ub2c8'),'kr':'*aa','ks':u('\u0627\u0650\u06a9\u0648\u0650\u0679\u0648\u0631\u0650\u06cc\u064e\u0644 \u06af\u0650\u0646\u06cc'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u0434\u0443\u043a \u0413\u0432\u0438\u043d\u0435\u044f'),'la':'*aa','lb':'Equatorialguinea','lg':u('Gayana ey\u2019oku ekweta'),'li':'*aa','ln':u('Gin\u025b\u0301kwat\u025b\u0301l\u025b'),'lo':u('\u0ec0\u0ead\u0e84\u0ebb\u0ea7\u0ec2\u0e97\u0ea3\u0ebd\u0ea7 \u0e81\u0eb5\u0e99\u0eb5'),'lt':u('Pusiaujo Gvin\u0117ja'),'lu':'Gine Ekwatele','lv':u('Ekvatori\u0101l\u0101 Gvineja'),'mg':'Guinea Ekoatera','mh':'*aa','mi':'*aa','mk':u('\u0415\u043a\u0432\u0430\u0442\u043e\u0440\u0441\u043a\u0430 \u0413\u0432\u0438\u043d\u0435\u0458\u0430'),'ml':u('\u0d07\u0d15\u0d4d\u0d35\u0d31\u0d4d\u0d31\u0d4b\u0d31\u0d3f\u0d2f\u0d7d \u0d17\u0d3f\u0d28\u0d3f\u0d2f'),'mn':u('\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u044b\u043d \u0413\u0432\u0438\u043d\u0435\u0439'),'mo':u('Guineea Ecuatorial\u0103'),'mr':'*hi','ms':'Guinea Khatulistiwa','mt':'il-Guinea Ekwatorjali','my':u('\u1021\u102e\u1000\u103d\u1031\u1010\u102c \u1002\u102e\u1014\u102e'),'na':'*aa','nb':'Ekvatorial-Guinea','nd':'*aa','ne':u('\u092d\u0942-\u092e\u0927\u094d\u092f\u0940\u092f \u0917\u093f\u0928\u0940'),'ng':'*aa','nl':'*fy','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b07\u0b15\u0b4d\u0b2c\u0b3e\u0b1f\u0b47\u0b30\u0b3f\u0b06\u0b32\u0b4d \u0b17\u0b41\u0b07\u0b28\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a2d\u0a42-\u0a16\u0a70\u0a21\u0a40 \u0a17\u0a3f\u0a28\u0a40'),'pi':'*aa','pl':u('Gwinea R\u00f3wnikowa'),'ps':u('\u0627\u0633\u062a\u0648\u0627\u06cc\u06cc \u06ab\u06cc\u0646\u0647'),'pt':u('Guin\u00e9 Equatorial'),'qu':'*es','rm':'Guinea Equatoriala','rn':'Gineya Ekwatoriyali','ro':'*mo','ru':u('\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u0438\u0430\u043b\u044c\u043d\u0430\u044f \u0413\u0432\u0438\u043d\u0435\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u064a\u06aa\u0648\u067d\u0648\u0631\u064a\u0644 \u06af\u0627\u0626\u064a\u0646\u0627'),'se':u('Ekvatori\u00e1la Guinea'),'sg':u('Gin\u00ebe t\u00ee Ekuat\u00ebre'),'si':u('\u0dc3\u0db8\u0d9a \u0d9c\u0dd2\u0db1\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*cs','sl':'Ekvatorialna Gvineja','sm':'*aa','sn':'*aa','so':'*aa','sq':'Guineja Ekuatoriale','sr':u('\u0415\u043a\u0432\u0430\u0442\u043e\u0440\u0438\u0458\u0430\u043b\u043d\u0430 \u0413\u0432\u0438\u043d\u0435\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Ekvatorialguinea','sw':'Guinea ya Ikweta','ta':u('\u0b88\u0b95\u0bcd\u0bb5\u0b9f\u0bcb\u0bb0\u0bbf\u0baf\u0bb2\u0bcd \u0b95\u0bbf\u0ba9\u0bbf\u0baf\u0bbe'),'te':u('\u0c08\u0c15\u0c4d\u0c35\u0c1f\u0c4b\u0c30\u0c3f\u0c2f\u0c32\u0c4d \u0c17\u0c3f\u0c28\u0c3f\u0c2f\u0c3e'),'tg':u('\u0413\u0432\u0438\u043d\u0435\u044f\u0438 \u042d\u043a\u0432\u0430\u0442\u043e\u0440\u04e3'),'th':u('\u0e2d\u0e34\u0e40\u0e04\u0e27\u0e17\u0e2d\u0e40\u0e23\u0e35\u0e22\u0e25\u0e01\u0e34\u0e19\u0e35'),'ti':'*am','tk':u('Ekwatorial Gwine\u00fda'),'tl':'*aa','tn':'*aa','to':u('\u02bbEkueta Kini'),'tr':'Ekvator Ginesi','ts':'*aa','tt':u('\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u0438\u0430\u043b\u044c \u0413\u0432\u0438\u043d\u0435\u044f'),'tw':'*aa','ty':'*aa','ug':u('\u0626\u06d0\u0643\u06cb\u0627\u062a\u0648\u0631 \u06af\u0649\u06cb\u0649\u0646\u0649\u064a\u06d5\u0633\u0649'),'uk':u('\u0415\u043a\u0432\u0430\u0442\u043e\u0440\u0456\u0430\u043b\u044c\u043d\u0430 \u0413\u0432\u0456\u043d\u0435\u044f'),'ur':u('\u0627\u0633\u062a\u0648\u0627\u0626\u06cc \u06af\u06cc\u0627\u0646\u0627'),'uz':'Ekvatorial Gvineya','ve':'*aa','vi':u('Guinea X\u00edch \u0110\u1ea1o'),'vo':'*aa','wa':'*aa','wo':'Gine Ekuwatoriyal','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Ekutoria Gini'),'za':'*aa','zh':u('\u8d64\u9053\u51e0\u5185\u4e9a'),'zu':'i-Equatorial Guinea',},
  'GR': {'aa':'Greece','ab':'*aa','ae':'*aa','af':'Griekeland','ak':'Greekman','am':u('\u130d\u122a\u12ad'),'an':'*aa','ar':u('\u0627\u0644\u064a\u0648\u0646\u0627\u0646'),'as':u('\u0997\u09cd\u09f0\u09c0\u099a'),'av':'*aa','ay':'*aa','az':u('Yunan\u0131stan'),'ba':'*aa','be':u('\u0413\u0440\u044d\u0446\u044b\u044f'),'bg':u('\u0413\u044a\u0440\u0446\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':u('G\u025br\u025bsi'),'bn':u('\u0997\u09cd\u09b0\u09c0\u09b8'),'bo':'*aa','br':'Gres','bs':u('Gr\u010dka'),'ca':u('Gr\u00e8cia'),'ce':u('\u0413\u0440\u0435\u0446\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('\u0158ecko'),'cu':'*aa','cv':'*aa','cy':'Gwlad Groeg','da':u('Gr\u00e6kenland'),'de':'Griechenland','dv':'*aa','dz':u('\u0f42\u0f72\u0f62\u0f72\u0f66\u0f84'),'ee':'Greece nutome','el':u('\u0395\u03bb\u03bb\u03ac\u03b4\u03b1'),'en':'*aa','eo':'Grekujo','es':'Grecia','et':'Kreeka','eu':'Grezia','fa':u('\u06cc\u0648\u0646\u0627\u0646'),'ff':'Gerees','fi':'Kreikka','fj':'*aa','fo':'Grikkaland','fr':u('Gr\u00e8ce'),'fy':u('Grikel\u00e2n'),'ga':u('an Ghr\u00e9ig'),'gd':u('A\u2019 Ghreug'),'gl':'*es','gn':'*aa','gu':u('\u0a97\u0acd\u0ab0\u0ac0\u0ab8'),'gv':'*aa','ha':'Girka','he':u('\u05d9\u05d5\u05d5\u05df'),'hi':u('\u092f\u0942\u0928\u093e\u0928'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('G\u00f6r\u00f6gorsz\u00e1g'),'hy':u('\u0540\u0578\u0582\u0576\u0561\u057d\u057f\u0561\u0576'),'hz':'*aa','ia':'*aa','id':'Yunani','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'Grikkland','it':'*es','iu':'*aa','iw':'*he','ja':u('\u30ae\u30ea\u30b7\u30e3'),'ji':u('\u05d2\u05e8\u05d9\u05db\u05e0\u05dc\u05d0\u05b7\u05e0\u05d3'),'jv':'*aa','ka':u('\u10e1\u10d0\u10d1\u10d4\u10e0\u10eb\u10dc\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'Ugiriki','kj':'*aa','kk':u('\u0413\u0440\u0435\u043a\u0438\u044f'),'kl':'*aa','km':u('\u1780\u17d2\u179a\u17b7\u1780'),'kn':u('\u0c97\u0ccd\u0cb0\u0cc0\u0cb8\u0ccd'),'ko':u('\uadf8\ub9ac\uc2a4'),'kr':'*aa','ks':u('\u06af\u0631\u06cc\u0656\u0633'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0413\u0440\u0435\u0446\u0438\u044f'),'la':'*aa','lb':'Griicheland','lg':'Bugereeki/Buyonaani','li':'*aa','ln':'Geleki','lo':u('\u0e81\u0ea3\u0eb5\u0e8a'),'lt':'Graikija','lu':'Ngeleka','lv':u('Grie\u0137ija'),'mg':'Gresy','mh':'*aa','mi':'*aa','mk':u('\u0413\u0440\u0446\u0438\u0458\u0430'),'ml':u('\u0d17\u0d4d\u0d30\u0d40\u0d38\u0d4d'),'mn':u('\u0413\u0440\u0435\u043a'),'mo':'*es','mr':u('\u0917\u094d\u0930\u0940\u0938'),'ms':'*aa','mt':u('il-Gre\u010bja'),'my':u('\u1002\u101b\u102d'),'na':'*aa','nb':'Hellas','nd':'*aa','ne':u('\u0917\u094d\u0930\u093f\u0938'),'ng':'*aa','nl':'Griekenland','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b17\u0b4d\u0b30\u0b40\u0b38\u0b4d'),'os':'*aa','pa':u('\u0a17\u0a4d\u0a30\u0a40\u0a38'),'pi':'*aa','pl':'Grecja','ps':'*fa','pt':u('Gr\u00e9cia'),'qu':'*es','rm':'*eu','rn':'Ubugereki','ro':'*es','ru':'*ky','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u064a\u0648\u0646\u0627\u0646'),'se':'Greika','sg':u('Ger\u00easi'),'si':u('\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2\u0dba'),'sk':u('Gr\u00e9cko'),'sl':u('Gr\u010dija'),'sm':'*aa','sn':'*aa','so':'Giriig','sq':'Greqi','sr':u('\u0413\u0440\u0447\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Grekland','sw':'*ki','ta':u('\u0b95\u0bbf\u0bb0\u0bc0\u0bb8\u0bcd'),'te':u('\u0c17\u0c4d\u0c30\u0c40\u0c38\u0c4d'),'tg':u('\u042e\u043d\u043e\u043d'),'th':u('\u0e01\u0e23\u0e35\u0e0b'),'ti':'*am','tk':u('Gresi\u00fda'),'tl':'*aa','tn':'*aa','to':'Kalisi','tr':'Yunanistan','ts':'*aa','tt':'*ky','tw':'*aa','ty':'*aa','ug':u('\u06af\u0649\u0631\u06d0\u062a\u0633\u0649\u064a\u06d5'),'uk':u('\u0413\u0440\u0435\u0446\u0456\u044f'),'ur':'*fa','uz':'Gretsiya','ve':'*aa','vi':u('Hy L\u1ea1p'),'vo':'*aa','wa':'*aa','wo':'*ff','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Geriisi'),'za':'*aa','zh':u('\u5e0c\u814a'),'zu':'i-Greece',},
  'GS': {'aa':'South Georgia And The South Sandwich Islands','ab':'*aa','ae':'*aa','af':u('Suid-Georgi\u00eb en die Suidelike Sandwicheilande'),'ak':'*aa','am':u('\u12f0\u1261\u1265 \u1306\u122d\u1302\u12eb \u12a5\u1293 \u12e8\u12f0\u1261\u1265 \u1233\u1295\u12f5\u12ca\u127d \u12f0\u1234\u1276\u127d'),'an':'*aa','ar':u('\u062c\u0648\u0631\u062c\u064a\u0627 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629 \u0648\u062c\u0632\u0631 \u0633\u0627\u0646\u062f\u0648\u064a\u062a\u0634 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629'),'as':u('\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u099c\u09f0\u09cd\u099c\u09bf\u09af\u09bc\u09be \u0986\u09f0\u09c1 \u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u099a\u09c7\u09a3\u09cd\u09a1\u09f1\u09bf\u099a \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'av':'*aa','ay':'*aa','az':u('C\u0259nubi Corciya v\u0259 C\u0259nubi Sendvi\u00e7 adalar\u0131'),'ba':'*aa','be':u('\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u044f \u0414\u0436\u043e\u0440\u0434\u0436\u044b\u044f \u0456 \u041f\u0430\u045e\u0434\u043d\u0451\u0432\u044b\u044f \u0421\u0430\u043d\u0434\u0432\u0456\u0447\u0430\u0432\u044b \u0430\u0441\u0442\u0440\u0430\u0432\u044b'),'bg':u('\u042e\u0436\u043d\u0430 \u0414\u0436\u043e\u0440\u0434\u0436\u0438\u044f \u0438 \u042e\u0436\u043d\u0438 \u0421\u0430\u043d\u0434\u0432\u0438\u0447\u0435\u0432\u0438 \u043e\u0441\u0442\u0440\u043e\u0432\u0438'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u099c\u09b0\u09cd\u099c\u09bf\u09af\u09bc\u09be \u0993 \u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u09b8\u09cd\u09af\u09be\u09a8\u09cd\u09a1\u0989\u0987\u099a \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'bo':'*aa','br':'Inizi Georgia ar Su hag Inizi Sandwich ar Su','bs':u('Ju\u017ena D\u017eord\u017eija i Ju\u017ena Sendvi\u010d ostrva'),'ca':u('Illes Ge\u00f2rgia del Sud i Sandwich del Sud'),'ce':u('\u041a\u044a\u0438\u043b\u0431\u0430 \u0414\u0436\u043e\u0440\u0434\u0436\u0438 \u0430, \u041a\u044a\u0438\u043b\u0431\u0430 \u0413\u0430\u0432\u0430\u0439\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448 \u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Ji\u017en\u00ed Georgie a Ji\u017en\u00ed Sandwichovy ostrovy'),'cu':'*aa','cv':'*aa','cy':'De Georgia ac Ynysoedd Sandwich y De','da':u('South Georgia og De Sydlige Sandwich\u00f8er'),'de':u('S\u00fcdgeorgien und die S\u00fcdlichen Sandwichinseln'),'dv':'*aa','dz':u('\u0f66\u0f71\u0f60\u0f74\u0f50\u0f0b\u0f47\u0f7d\u0f62\u0f0b\u0f47\u0f71\u0f0b \u0f51\u0f44\u0f0b \u0f66\u0f71\u0f60\u0f74\u0f50\u0f0b\u0f66\u0f7a\u0f53\u0f4c\u0f84\u0f0b\u0f5d\u0f72\u0f45\u0f0b\u0f42\u0fb3\u0f72\u0f44\u0f0b\u0f5a\u0f7c\u0f58'),'ee':u('Anyiehe Georgia kple Anyiehe Sandwich \u0192udomekpowo nutome'),'el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u039d\u03cc\u03c4\u03b9\u03b1 \u0393\u03b5\u03c9\u03c1\u03b3\u03af\u03b1 \u03ba\u03b1\u03b9 \u039d\u03cc\u03c4\u03b9\u03b5\u03c2 \u03a3\u03ac\u03bd\u03c4\u03bf\u03c5\u03b9\u03c4\u03c2'),'en':'South Georgia & South Sandwich Islands','eo':u('Sud-Georgio kaj Sud-Sandvi\u0109insuloj'),'es':'Islas Georgia del Sur y Sandwich del Sur','et':u('L\u00f5una-Georgia ja L\u00f5una-Sandwichi saared'),'eu':'Hegoaldeko Georgia eta Hegoaldeko Sandwich uharteak','fa':u('\u062c\u0632\u0627\u06cc\u0631 \u062c\u0648\u0631\u062c\u06cc\u0627\u06cc \u062c\u0646\u0648\u0628\u06cc \u0648 \u0633\u0627\u0646\u062f\u0648\u06cc\u0686 \u062c\u0646\u0648\u0628\u06cc'),'ff':'*aa','fi':u('Etel\u00e4-Georgia ja Etel\u00e4iset Sandwichsaaret'),'fj':'*aa','fo':u('Su\u00f0urgeorgia og Su\u00f0ursandwichoyggjar'),'fr':u('G\u00e9orgie du Sud et \u00eeles Sandwich du Sud'),'fy':u('S\u00fbd-Georgia en S\u00fbdlike Sandwicheilannen'),'ga':u('an tSeoirsia Theas agus Oile\u00e1in Sandwich Theas'),'gd':u('Se\u00f2irsea a Deas is na h-Eileanan Sandwich a Deas'),'gl':'Illas Xeorxia do Sur e Sandwich do Sur','gn':'*aa','gu':u('\u0aa6\u0a95\u0acd\u0ab7\u0abf\u0aa3 \u0a9c\u0acd\u0aaf\u0acb\u0ab0\u0acd\u0a9c\u0abf\u0aaf\u0abe \u0a85\u0aa8\u0ac7 \u0aa6\u0a95\u0acd\u0ab7\u0abf\u0aa3 \u0ab8\u0ac7\u0aa8\u0acd\u0aa1\u0ab5\u0abf\u0a9a \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8'),'gv':'*aa','ha':'*aa','he':u('\u05d2\u05f3\u05d5\u05e8\u05d2\u05f3\u05d9\u05d4 \u05d4\u05d3\u05e8\u05d5\u05de\u05d9\u05ea \u05d5\u05d0\u05d9\u05d9 \u05e1\u05e0\u05d3\u05d5\u05d5\u05d9\u05e5\u05f3 \u05d4\u05d3\u05e8\u05d5\u05de\u05d9\u05d9\u05dd'),'hi':u('\u0926\u0915\u094d\u0937\u093f\u0923 \u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e \u0914\u0930 \u0926\u0915\u094d\u0937\u093f\u0923 \u0938\u0948\u0902\u0921\u0935\u093f\u091a \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939'),'ho':'*aa','hr':u('Ju\u017ena Georgija i Ju\u017eni Sendvi\u010dki Otoci'),'ht':'*aa','hu':u('D\u00e9li-Georgia \u00e9s D\u00e9li-Sandwich-szigetek'),'hy':u('\u0540\u0561\u0580\u0561\u057e\u0561\u0575\u056b\u0576 \u054b\u0578\u0580\u057b\u056b\u0561 \u0587 \u0540\u0561\u0580\u0561\u057e\u0561\u0575\u056b\u0576 \u054d\u0565\u0576\u0564\u057e\u056b\u0579\u0575\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'Georgia Selatan & Kep. Sandwich Selatan','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Su\u00f0ur-Georg\u00eda og Su\u00f0ur-Sandv\u00edkureyjar'),'it':'Georgia del Sud e Sandwich australi','iu':'*aa','iw':'*he','ja':u('\u30b5\u30a6\u30b9\u30b8\u30e7\u30fc\u30b8\u30a2\u30fb\u30b5\u30a6\u30b9\u30b5\u30f3\u30c9\u30a6\u30a3\u30c3\u30c1\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':u('\u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7 \u10ef\u10dd\u10e0\u10ef\u10d8\u10d0 \u10d3\u10d0 \u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7 \u10e1\u10d4\u10dc\u10d3\u10d5\u10d8\u10e9\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u041e\u04a3\u0442\u04af\u0441\u0442\u0456\u043a \u0413\u0435\u043e\u0440\u0433\u0438\u044f \u0436\u04d9\u043d\u0435 \u041e\u04a3\u0442\u04af\u0441\u0442\u0456\u043a \u0421\u0430\u043d\u0434\u0432\u0438\u0447 \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'kl':'*aa','km':u('\u1780\u17c4\u17c7\u200b\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17ca\u17b8\u200b\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784 \u1793\u17b7\u1784 \u179f\u1784\u17cb\u179c\u17b7\u1785\u200b\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784'),'kn':u('\u0ca6\u0c95\u0ccd\u0cb7\u0cbf\u0ca3 \u0c9c\u0cbe\u0cb0\u0ccd\u0c9c\u0cbf\u0caf\u0cbe \u0cae\u0ca4\u0ccd\u0ca4\u0cc1 \u0ca6\u0c95\u0ccd\u0cb7\u0cbf\u0ca3 \u0cb8\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd\u200d\u0cb5\u0cbf\u0c9a\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3\u0cc1'),'ko':u('\uc0ac\uc6b0\uc2a4\uc870\uc9c0\uc544 \uc0ac\uc6b0\uc2a4\uc0cc\ub4dc\uc704\uce58 \uc81c\ub3c4'),'kr':'*aa','ks':u('\u062c\u0646\u0648\u0657\u0628\u06cc \u062c\u0627\u0631\u062c\u0650\u06cc\u0627 \u062a\u06c1\u0655 \u062c\u0646\u0648\u0657\u0628\u06cc \u0633\u06cc\u0646\u065b\u0691\u0648\u0655\u0686 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0422\u04af\u0448\u0442\u04af\u043a \u0416\u043e\u0440\u0436\u0438\u044f \u0436\u0430\u043d\u0430 \u0422\u04af\u0448\u0442\u04af\u043a \u0421\u044d\u043d\u0434\u0432\u0438\u0447 \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'la':'*aa','lb':u('S\u00fcdgeorgien an d\u00e9i S\u00fcdlech Sandwichinselen'),'lg':'*aa','li':'*aa','ln':u('\u00celes de G\u00e9orgie du Sud et Sandwich du Sud'),'lo':u('\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0 \u0e88\u0ecd\u0ec0\u0e88\u0e8d\u0e95\u0ead\u0e99\u0ec3\u0e95\u0ec9 \u0ec1\u0ea5\u0eb0 \u0ec1\u0e8a\u0e99\u0ea7\u0eb4\u0e94\u0e95\u0ead\u0e99\u0ec3\u0e95\u0ec9'),'lt':u('Piet\u0173 D\u017eord\u017eija ir Piet\u0173 Sandvi\u010do salos'),'lu':'*aa','lv':u('Dienvidd\u017eord\u017eija un Dienvidsendvi\u010du salas'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0408\u0443\u0436\u043d\u0430 \u040f\u043e\u0440\u045f\u0438\u0458\u0430 \u0438 \u0408\u0443\u0436\u043d\u0438 \u0421\u0435\u043d\u0434\u0432\u0438\u0447\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438'),'ml':u('\u0d26\u0d15\u0d4d\u0d37\u0d3f\u0d23 \u0d1c\u0d4b\u0d7c\u0d1c\u0d4d\u0d1c\u0d3f\u0d2f\u0d2f\u0d41\u0d02 \u0d26\u0d15\u0d4d\u0d37\u0d3f\u0d23 \u0d38\u0d3e\u0d7b\u0d21\u0d4d\u200c\u0d35\u0d3f\u0d1a\u0d4d\u0d1a\u0d4d \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d33\u0d41\u0d02'),'mn':u('\u04e8\u043c\u043d\u04e9\u0434 \u0416\u043e\u0440\u0436\u0438\u0430 \u0431\u0430 \u04e8\u043c\u043d\u04e9\u0434 \u0421\u044d\u043d\u0434\u0432\u0438\u0447\u0438\u0439\u043d \u0410\u0440\u043b\u0443\u0443\u0434'),'mo':u('Georgia de Sud \u0219i Insulele Sandwich de Sud'),'mr':u('\u0926\u0915\u094d\u0937\u093f\u0923 \u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e \u0906\u0923\u093f \u0926\u0915\u094d\u0937\u093f\u0923 \u0938\u0901\u0921\u0935\u093f\u091a \u092c\u0947\u091f\u0947'),'ms':'Kepulauan Georgia Selatan & Sandwich Selatan','mt':u('il-Georgia tan-Nofsinhar u l-G\u017cejjer Sandwich tan-Nofsinhar'),'my':u('\u1010\u1031\u102c\u1004\u103a \u1002\u103b\u1031\u102c\u103a\u1002\u103b\u102e\u101a\u102c \u1014\u103e\u1004\u1037\u103a \u1010\u1031\u102c\u1004\u103a \u1006\u1004\u103a\u1038\u1012\u101d\u1005\u103a\u1002\u103b\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f\u1019\u103b\u102c\u1038'),'na':'*aa','nb':u('S\u00f8r-Georgia og S\u00f8r-Sandwich\u00f8yene'),'nd':'*aa','ne':u('\u0926\u0915\u094d\u0937\u093f\u0923 \u091c\u0930\u094d\u091c\u093f\u092f\u093e \u0930 \u0926\u0915\u094d\u0937\u093f\u0923 \u0938\u094d\u092f\u093e\u0928\u094d\u0921\u0935\u0940\u091a \u091f\u093e\u092a\u0941\u0939\u0930\u0942'),'ng':'*aa','nl':'Zuid-Georgia en Zuidelijke Sandwicheilanden','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b1c\u0b30\u0b4d\u0b1c\u0b3f\u0b06 \u0b0f\u0b2c\u0b02 \u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b38\u0b3e\u0b23\u0b4d\u0b21\u0b71\u0b3f\u0b1a\u0b4d \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c'),'os':'*aa','pa':u('\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a1c\u0a3e\u0a30\u0a1c\u0a40\u0a06 \u0a05\u0a24\u0a47 \u0a26\u0a71\u0a16\u0a23\u0a40 \u0a38\u0a48\u0a02\u0a21\u0a35\u0a3f\u0a1a \u0a1f\u0a3e\u0a2a\u0a42'),'pi':'*aa','pl':u('Georgia Po\u0142udniowa i Sandwich Po\u0142udniowy'),'ps':u('\u0633\u0648\u06cc\u0644 \u062c\u0648\u0631\u062c\u06cc\u0627 \u0627\u0648 \u062c\u0646\u0648\u0628\u064a \u0633\u06cc\u0646\u0688\u0648\u0686 \u067c\u0627\u067e\u0648'),'pt':u('Ilhas Ge\u00f3rgia do Sul e Sandwich do Sul'),'qu':'*aa','rm':'Georgia dal Sid e las Inslas Sandwich dal Sid','rn':'*aa','ro':'*mo','ru':u('\u042e\u0436\u043d\u0430\u044f \u0413\u0435\u043e\u0440\u0433\u0438\u044f \u0438 \u042e\u0436\u043d\u044b\u0435 \u0421\u0430\u043d\u0434\u0432\u0438\u0447\u0435\u0432\u044b \u043e-\u0432\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u068f\u06a9\u06bb \u062c\u0627\u0631\u062c\u064a\u0627 \u06fd \u068f\u06a9\u06bb \u0633\u064a\u0646\u068a\u0648\u0686 \u067b\u064a\u067d'),'se':'Lulli Georgia ja Lulli Sandwich-sullot','sg':'*aa','si':u('\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0da2\u0ddd\u0dbb\u0dca\u0da2\u0dd2\u0dba\u0dcf\u0dc0 \u0dc3\u0dc4 \u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0dc3\u0dd0\u0db1\u0dca\u0da9\u0dca\u0dc0\u0dd2\u0da0\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca'),'sk':u('Ju\u017en\u00e1 Georgia a Ju\u017en\u00e9 Sandwichove ostrovy'),'sl':u('Ju\u017ena Georgia in Ju\u017eni Sandwichevi otoki'),'sm':'*aa','sn':'*aa','so':'*aa','sq':u('Xhorxha Jugore dhe Ishujt Sendui\u00e7\u00eb t\u00eb Jugut'),'sr':u('\u0408\u0443\u0436\u043d\u0430 \u040f\u043e\u0440\u045f\u0438\u0458\u0430 \u0438 \u0408\u0443\u0436\u043d\u0430 \u0421\u0435\u043d\u0434\u0432\u0438\u0447\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Sydgeorgien och Sydsandwich\u00f6arna'),'sw':'Georgia Kusini na Visiwa vya Sandwich Kusini','ta':u('\u0ba4\u0bc6\u0bb1\u0bcd\u0b95\u0bc1 \u0b9c\u0bbe\u0bb0\u0bcd\u0b9c\u0bbf\u0baf\u0bbe \u0bae\u0bb1\u0bcd\u0bb1\u0bc1\u0bae\u0bcd \u0ba4\u0bc6\u0bb1\u0bcd\u0b95\u0bc1 \u0b9a\u0bbe\u0ba3\u0bcd\u0b9f\u0bcd\u0bb5\u0bbf\u0b9a\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd'),'te':u('\u0c26\u0c15\u0c4d\u0c37\u0c3f\u0c23 \u0c1c\u0c3e\u0c30\u0c4d\u0c1c\u0c3f\u0c2f\u0c3e & \u0c26\u0c15\u0c4d\u0c37\u0c3f\u0c23 \u0c36\u0c3e\u0c02\u0c21\u0c4d\u0c35\u0c3f\u0c1a\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41'),'tg':u('\u04b6\u043e\u0440\u04b7\u0438\u044f\u0438 \u04b6\u0430\u043d\u0443\u0431\u04e3 \u0432\u0430 \u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u0421\u0430\u043d\u0434\u0432\u0438\u0447'),'th':u('\u0e40\u0e01\u0e32\u0e30\u0e40\u0e0b\u0e32\u0e17\u0e4c\u0e08\u0e2d\u0e23\u0e4c\u0e40\u0e08\u0e35\u0e22\u0e41\u0e25\u0e30\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e40\u0e0b\u0e32\u0e17\u0e4c\u0e41\u0e0b\u0e19\u0e14\u0e4c\u0e27\u0e34\u0e0a'),'ti':u('\u12f0\u1234\u1273\u1275 \u12f0\u1261\u1265 \u1306\u122d\u1302\u12eb\u1295 \u12f0\u1261\u12f5 \u1233\u1295\u12f5\u12ca\u127d\u1295'),'tk':u('G\u00fcnorta Georgi\u00fda we G\u00fcnorta Sendwi\u00e7 adasy'),'tl':'*en','tn':'*aa','to':u('\u02bbOtumotu Se\u014dsia-tonga mo Saniuisi-tonga'),'tr':u('G\u00fcney Georgia ve G\u00fcney Sandwich Adalar\u0131'),'ts':'*aa','tt':u('\u041a\u04e9\u043d\u044c\u044f\u043a \u0413\u0435\u043e\u0440\u0433\u0438\u044f \u04bb\u04d9\u043c \u041a\u04e9\u043d\u044c\u044f\u043a \u0421\u0430\u043d\u0434\u0432\u0438\u0447 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u062c\u0648\u0631\u062c\u0649\u064a\u06d5 \u06cb\u06d5 \u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u0633\u0627\u0646\u062f\u06cb\u0649\u0686 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649'),'uk':u('\u041f\u0456\u0432\u0434\u0435\u043d\u043d\u0430 \u0414\u0436\u043e\u0440\u0434\u0436\u0456\u044f \u0442\u0430 \u041f\u0456\u0432\u0434\u0435\u043d\u043d\u0456 \u0421\u0430\u043d\u0434\u0432\u0456\u0447\u0435\u0432\u0456 \u043e\u0441\u0442\u0440\u043e\u0432\u0438'),'ur':u('\u062c\u0646\u0648\u0628\u06cc \u062c\u0627\u0631\u062c\u06cc\u0627 \u0627\u0648\u0631 \u062c\u0646\u0648\u0628\u06cc \u0633\u06cc\u0646\u0688\u0648\u0686 \u062c\u0632\u0627\u0626\u0631'),'uz':'Janubiy Georgiya va Janubiy Sendvich orollari','ve':'*aa','vi':u('Nam Georgia & Qu\u1ea7n \u0111\u1ea3o Nam Sandwich'),'vo':'*aa','wa':'*aa','wo':u('Seworsi di Sid ak Duni S\u00e0ndwiis di Sid'),'xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u5357\u4e54\u6cbb\u4e9a\u548c\u5357\u6851\u5a01\u5947\u7fa4\u5c9b'),'zu':'i-South Georgia ne-South Sandwich Islands',},
  'GT': {'aa':'Guatemala','ab':'*aa','ae':'*aa','af':'*aa','ak':'Guwatemala','am':u('\u1309\u12cb\u1272\u121b\u120b'),'an':'*aa','ar':u('\u063a\u0648\u0627\u062a\u064a\u0645\u0627\u0644\u0627'),'as':u('\u0997\u09c1\u09f1\u09be\u099f\u09c7\u09ae\u09be\u09b2\u09be'),'av':'*aa','ay':'*aa','az':'Qvatemala','ba':'*aa','be':u('\u0413\u0432\u0430\u0442\u044d\u043c\u0430\u043b\u0430'),'bg':u('\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0430'),'bh':'*aa','bi':'*aa','bm':'Gwatemala','bn':u('\u0997\u09c1\u09af\u09bc\u09be\u09a4\u09c7\u09ae\u09be\u09b2\u09be'),'bo':'*aa','br':'*aa','bs':'Gvatemala','ca':'*aa','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f42\u0fb7\u0f7c\u0f0b\u0f4a\u0f0b\u0f58\u0f0b\u0f63'),'ee':'Guatemala nutome','el':u('\u0393\u03bf\u03c5\u03b1\u03c4\u03b5\u03bc\u03ac\u03bb\u03b1'),'en':'*aa','eo':'Gvatemalo','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u06af\u0648\u0627\u062a\u0645\u0627\u0644\u0627'),'ff':'Gwaatemalaa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'Guatamala','gd':'*ga','gl':'*aa','gn':'*aa','gu':u('\u0a97\u0acd\u0ab5\u0abe\u0a9f\u0ac7\u0aae\u0abe\u0ab2\u0abe'),'gv':'*aa','ha':'Gwatamala','he':u('\u05d2\u05d5\u05d0\u05d8\u05de\u05dc\u05d4'),'hi':u('\u0917\u094d\u0935\u093e\u091f\u0947\u092e\u093e\u0932\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u0533\u057e\u0561\u057f\u0565\u0574\u0561\u056c\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*bs','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30b0\u30a2\u30c6\u30de\u30e9'),'ji':u('\u05d2\u05d5\u05d5\u05d0\u05b7\u05d8\u05e2\u05de\u05d0\u05b7\u05dc\u05e2'),'jv':'*aa','ka':u('\u10d2\u10d5\u10d0\u10e2\u10d4\u10db\u10d0\u10da\u10d0'),'kg':'*aa','ki':'*bm','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1780\u17d2\u179c\u17b6\u178f\u17c1\u1798\u17c9\u17b6\u17a1\u17b6'),'kn':u('\u0c97\u0ccd\u0cb5\u0cbe\u0c9f\u0cc6\u0cae\u0cbe\u0cb2\u0cbe'),'ko':u('\uacfc\ud14c\ub9d0\ub77c'),'kr':'*aa','ks':u('\u06af\u0648\u062a\u06cc\u062f\u0627\u0644\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'*bm','li':'*aa','ln':u('Gwat\u00e9mala'),'lo':u('\u0e81\u0ebb\u0ea7\u0ec0\u0e97\u0ea1\u0eb2\u0ea5\u0eb2'),'lt':'*bs','lu':'Ngwatemala','lv':'*bs','mg':u('Goatemal\u00e0'),'mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d17\u0d4d\u0d35\u0d3e\u0d1f\u0d4d\u0d1f\u0d3f\u0d2e\u0d3e\u0d32'),'mn':u('\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b'),'mo':'*aa','mr':'*hi','ms':'*aa','mt':'il-Gwatemala','my':u('\u1002\u103d\u102b\u1010\u102e\u1019\u102c\u101c\u102c'),'na':'*aa','nb':'*aa','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b17\u0b41\u0b0f\u0b24\u0b2e\u0b3e\u0b32\u0b3e'),'os':'*aa','pa':u('\u0a17\u0a41\u0a06\u0a1f\u0a47\u0a2e\u0a3e\u0a32\u0a3e'),'pi':'*aa','pl':'*bm','ps':u('\u06ab\u0648\u0627\u062a\u06cc\u0645\u0627\u0644\u0627'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'*bm','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06af\u0648\u0626\u067d\u064a \u0645\u0627\u0644\u0627'),'se':'*aa','sg':u('Guat\u00eam\u00e4l\u00e4'),'si':u('\u0d9c\u0ddd\u0dad\u0db8\u0dcf\u0dbd\u0dcf\u0dc0'),'sk':'*aa','sl':'*bs','sm':'*aa','sn':'*aa','so':'Guwaatamaala','sq':u('Guatemal\u00eb'),'sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b95\u0bb5\u0bc1\u0ba4\u0bae\u0bbe\u0bb2\u0bbe'),'te':u('\u0c17\u0c4d\u0c35\u0c3e\u0c1f\u0c3f\u0c2e\u0c3e\u0c32\u0c3e'),'tg':'*bg','th':u('\u0e01\u0e31\u0e27\u0e40\u0e15\u0e21\u0e32\u0e25\u0e32'),'ti':'*am','tk':'*bm','tl':'*aa','tn':'*aa','to':'Kuatamala','tr':'*aa','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u06af\u0649\u06cb\u0627\u062a\u06d0\u0645\u0627\u0644\u0627'),'uk':u('\u0490\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0430'),'ur':u('\u06af\u0648\u0627\u0679\u06d2 \u0645\u0627\u0644\u0627'),'uz':'*bs','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*ak','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Guatemala'),'za':'*aa','zh':u('\u5371\u5730\u9a6c\u62c9'),'zu':'i-Guatemala',},
  'GU': {'aa':'Guam','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u1309\u12cb\u121d'),'an':'*aa','ar':u('\u063a\u0648\u0627\u0645'),'as':u('\u0997\u09c1\u09f1\u09be\u09ae'),'av':'*aa','ay':'*aa','az':'Quam','ba':'*aa','be':u('\u0413\u0443\u0430\u043c'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'Gwam','bn':u('\u0997\u09c1\u09af\u09bc\u09be\u09ae'),'bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f42\u0f74\u0f0b\u0f60\u0f58\u0f0b \u0f58\u0f5a\u0f7c\u0f0b\u0f42\u0fb3\u0f72\u0f44'),'ee':'Guam nutome','el':u('\u0393\u03ba\u03bf\u03c5\u03ac\u03bc'),'en':'*aa','eo':'Gvamo','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u06af\u0648\u0627\u0645'),'ff':'Guwam','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':u('\u0a97\u0acd\u0ab5\u0abe\u0aae'),'gv':'*aa','ha':'*bm','he':u('\u05d2\u05d5\u05d0\u05dd'),'hi':u('\u0917\u0941\u0906\u092e'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u0533\u0578\u0582\u0561\u0574'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'Gvam','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30b0\u30a2\u30e0'),'ji':u('\u05d2\u05d5\u05d5\u05d0\u05b7\u05dd'),'jv':'*aa','ka':u('\u10d2\u10e3\u10d0\u10db\u10d8'),'kg':'*aa','ki':'*bm','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u17a0\u17d2\u1782\u17b6\u17c6'),'kn':u('\u0c97\u0cc1\u0cb5\u0cbe\u0cae\u0ccd'),'ko':u('\uad0c'),'kr':'*aa','ks':u('\u06af\u064f\u0648\u0627\u0645'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*aa','lg':'Gwamu','li':'*aa','ln':u('Gwam\u025b'),'lo':u('\u0e81\u0ea7\u0eb2\u0ea1'),'lt':'Guamas','lu':'Ngwame','lv':'Guama','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d17\u0d4d\u0d35\u0d3e\u0d02'),'mn':'*be','mo':'*aa','mr':'*hi','ms':'*aa','mt':'*aa','my':u('\u1002\u1030\u1021\u1019\u103a'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0917\u0941\u0935\u093e\u092e'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b17\u0b41\u0b06\u0b2e\u0b4d'),'os':'*aa','pa':u('\u0a17\u0a41\u0a06\u0a2e'),'pi':'*aa','pl':'*aa','ps':u('\u06ab\u0648\u0627\u0645'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'*lg','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*fa','se':'*aa','sg':u('Gu\u00e2m'),'si':u('\u0d9c\u0dd4\u0dc0\u0dcf\u0db8\u0dca'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b95\u0bc1\u0bb5\u0bbe\u0bae\u0bcd'),'te':u('\u0c17\u0c4d\u0c35\u0c3e\u0c2e\u0c4d'),'tg':'*be','th':u('\u0e01\u0e27\u0e21'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':'Kuamu','tr':'*aa','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u06af\u06c7\u0626\u0627\u0645'),'uk':u('\u0490\u0443\u0430\u043c'),'ur':'*fa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*ff','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Guamu'),'za':'*aa','zh':u('\u5173\u5c9b'),'zu':'i-Guam',},
  'GW': {'aa':'Guinea-Bissau','ab':'*aa','ae':'*aa','af':'Guinee-Bissau','ak':'Gini Bisaw','am':u('\u130a\u1292 \u1262\u1233\u12a6'),'an':'*aa','ar':u('\u063a\u064a\u0646\u064a\u0627 \u0628\u064a\u0633\u0627\u0648'),'as':u('\u0997\u09bf\u09a8\u09bf-\u09ac\u09bf\u099b\u09be\u0993'),'av':'*aa','ay':'*aa','az':'Qvineya-Bisau','ba':'*aa','be':u('\u0413\u0432\u0456\u043d\u0435\u044f-\u0411\u0456\u0441\u0430\u0443'),'bg':u('\u0413\u0432\u0438\u043d\u0435\u044f-\u0411\u0438\u0441\u0430\u0443'),'bh':'*aa','bi':'*aa','bm':'Gine Bisawo','bn':u('\u0997\u09bf\u09a8\u09bf-\u09ac\u09bf\u09b8\u09be\u0989'),'bo':'*aa','br':'Ginea-Bissau','bs':'Gvineja-Bisao','ca':'Guinea Bissau','ce':u('\u0413\u0432\u0438\u043d\u0435\u0439-\u0411\u0438\u0441\u0430\u0443'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':u('Guin\u00e9-Bissau'),'da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f42\u0fb7\u0f72\u0f0b\u0f53\u0f72\u0f0b \u0f56\u0fb7\u0f72\u0f0b\u0f66\u0f71\u0f60\u0f74'),'ee':'Gini-Bisao nutome','el':u('\u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1 \u039c\u03c0\u03b9\u03c3\u03ac\u03bf\u03c5'),'en':'*aa','eo':u('Gvineo-Bisa\u016do'),'es':u('Guinea-Bis\u00e1u'),'et':'*aa','eu':'Ginea Bissau','fa':u('\u06af\u06cc\u0646\u0647\u0654 \u0628\u06cc\u0633\u0627\u0626\u0648'),'ff':'Gine-Bisaawo','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Guin\u00e9e-Bissau'),'fy':'*af','ga':'Guine Bissau','gd':'Gini-Bioso','gl':'*aa','gn':'*aa','gu':u('\u0a97\u0abf\u0aa8\u0ac0-\u0aac\u0abf\u0ab8\u0abe\u0a89'),'gv':'*aa','ha':'Gini Bisau','he':u('\u05d2\u05d9\u05e0\u05d0\u05d4-\u05d1\u05d9\u05e1\u05d0\u05d5'),'hi':u('\u0917\u093f\u0928\u0940-\u092c\u093f\u0938\u093e\u0909'),'ho':'*aa','hr':'Gvineja Bisau','ht':'*aa','hu':'Bissau-Guinea','hy':u('\u0533\u057e\u056b\u0576\u0565\u0561-\u0532\u056b\u057d\u0561\u0578\u0582'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('G\u00ednea-Biss\u00e1'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30ae\u30cb\u30a2\u30d3\u30b5\u30a6'),'ji':u('\u05d2\u05d9\u05e0\u05e2\u05be\u05d1\u05d9\u05e1\u05d0\u05b7\u05d5'),'jv':'*aa','ka':u('\u10d2\u10d5\u10d8\u10dc\u10d4\u10d0-\u10d1\u10d8\u10e1\u10d0\u10e3'),'kg':'*aa','ki':'Ginebisau','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a0\u17d2\u1782\u17b8\u178e\u17c1\u1794\u17ca\u17b8\u179f\u17d2\u179f\u17bc'),'kn':u('\u0c97\u0cbf\u0ca8\u0cbf-\u0cac\u0cbf\u0cb8\u0ccd\u0cb8\u0cbe\u0cb5\u0ccd'),'ko':u('\uae30\ub2c8\ube44\uc0ac\uc6b0'),'kr':'*aa','ks':u('\u06af\u06cc\u0656\u0646\u06cc \u0628\u0650\u0633\u0627\u0648'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'Gini-Bisawu','li':'*aa','ln':u('Gin\u025bbisau'),'lo':u('\u0e81\u0eb4\u0e99\u0eb5-\u0e9a\u0eb4\u0eaa\u0ec0\u0e8a\u0ebb\u0eb2'),'lt':u('Bisau Gvin\u0117ja'),'lu':'Nginebisau','lv':'Gvineja-Bisava','mg':u('Gin\u00e9-Bisao'),'mh':'*aa','mi':'*aa','mk':u('\u0413\u0432\u0438\u043d\u0435\u0458\u0430-\u0411\u0438\u0441\u0430\u0443'),'ml':u('\u0d17\u0d3f\u0d28\u0d3f\u0d2f-\u0d2c\u0d3f\u0d38\u0d57'),'mn':'*ce','mo':'Guineea-Bissau','mr':'*hi','ms':'*ca','mt':'il-Guinea-Bissau','my':u('\u1002\u102e\u1014\u102e-\u1018\u102e\u1005\u1031\u102c'),'na':'*aa','nb':'*aa','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b17\u0b41\u0b07\u0b28\u0b3f\u0b06-\u0b2c\u0b3f\u0b38\u0b3e\u0b09'),'os':'*aa','pa':u('\u0a17\u0a3f\u0a28\u0a40-\u0a2c\u0a3f\u0a38\u0a3e\u0a09'),'pi':'*aa','pl':'Gwinea Bissau','ps':u('\u06ab\u06cc\u0646\u0647 \u0628\u06cc\u0633\u0648'),'pt':'*cy','qu':'*es','rm':'*aa','rn':'Gineya Bisawu','ro':'*mo','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06af\u0646\u064a \u0628\u0633\u0627\u0626\u0648'),'se':'*aa','sg':u('Gnin\u00ebe-Bisau'),'si':u('\u0d9c\u0dd2\u0db1\u0dd2 \u0db6\u0dd2\u0dc3\u0dc0\u0dca'),'sk':'*aa','sl':'Gvineja Bissau','sm':'*aa','sn':'*aa','so':'Gini-Bisaaw','sq':'Guine-Bisau','sr':u('\u0413\u0432\u0438\u043d\u0435\u0458\u0430-\u0411\u0438\u0441\u0430\u043e'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*ki','ta':u('\u0b95\u0bbf\u0ba9\u0bbf\u0baf\u0bbe-\u0baa\u0bbf\u0bb8\u0bcd\u0bb8\u0bbe\u0bb5\u0bcd'),'te':u('\u0c17\u0c3f\u0c28\u0c3f\u0c2f\u0c3e-\u0c2c\u0c3f\u0c38\u0c4d\u0c38\u0c3e\u0c35\u0c4d'),'tg':'*bg','th':u('\u0e01\u0e34\u0e19\u0e35-\u0e1a\u0e34\u0e2a\u0e40\u0e0b\u0e32'),'ti':u('\u1262\u1233\u12ce'),'tk':u('Gwine\u00fda-Bisau'),'tl':'*aa','tn':'*aa','to':'Kini-Pisau','tr':'Gine-Bissau','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u06af\u0649\u06cb\u0649\u0646\u0649\u064a\u06d5 \u0628\u0649\u0633\u0633\u0627\u0626\u06c7'),'uk':'*be','ur':u('\u06af\u0646\u06cc \u0628\u0633\u0627\u0624'),'uz':'Gvineya-Bisau','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':u('Gine-Bisaaw\u00f3o'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Gene-Busau'),'za':'*aa','zh':u('\u51e0\u5185\u4e9a\u6bd4\u7ecd'),'zu':'i-Guinea-Bissau',},
  'GY': {'aa':'Guyana','ab':'*aa','ae':'*aa','af':'*aa','ak':'Gayana','am':u('\u1309\u12eb\u1293'),'an':'*aa','ar':u('\u063a\u064a\u0627\u0646\u0627'),'as':u('\u0997\u09be\u09af\u09bc\u09be\u09a8\u09be'),'av':'*aa','ay':'*aa','az':'Qayana','ba':'*aa','be':u('\u0413\u0430\u044f\u043d\u0430'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'Gwiyana','bn':u('\u0997\u09bf\u09af\u09bc\u09be\u09a8\u09be'),'bo':'*aa','br':'*aa','bs':'Gvajana','ca':'*aa','ce':u('\u0413\u0430\u0439\u0430\u043d\u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f42\u0fb7\u0f0b\u0f61\u0f0b\u0f53'),'ee':'Guyanadu','el':u('\u0393\u03bf\u03c5\u03b9\u03ac\u03bd\u03b1'),'en':'*aa','eo':'Gujano','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u06af\u0648\u06cc\u0627\u0646'),'ff':'Giyaan','fi':'*aa','fj':'*aa','fo':'Gujana','fr':'*aa','fy':'*aa','ga':u('an Ghu\u00e1in'),'gd':u('Guidhe\u00e0na'),'gl':u('G\u00fciana'),'gn':'*aa','gu':u('\u0a97\u0aaf\u0abe\u0aa8\u0abe'),'gv':'*aa','ha':'*aa','he':u('\u05d2\u05d9\u05d0\u05e0\u05d4'),'hi':u('\u0917\u0941\u092f\u093e\u0928\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u0533\u0561\u0575\u0561\u0576\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Gv\u00e6jana'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30ac\u30a4\u30a2\u30ca'),'ji':u('\u05d2\u05d5\u05d9\u05d0\u05b7\u05e0\u05e2'),'jv':'*aa','ka':u('\u10d2\u10d0\u10d8\u10d0\u10dc\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u17a0\u17d2\u1782\u17b8\u1799\u17c9\u17b6\u1793'),'kn':u('\u0c97\u0caf\u0cbe\u0ca8\u0cbe'),'ko':u('\uac00\uc774\uc544\ub098'),'kr':'*aa','ks':u('\u06af\u064f\u06cc\u0627\u0646\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*aa','lg':'*ak','li':'*aa','ln':'Giyane','lo':u('\u0e81\u0eb2\u0e8d\u0ea2\u0eb2\u0e99\u0eb2'),'lt':'Gajana','lu':'Ngiyane','lv':u('Gaj\u0101na'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0413\u0432\u0430\u0458\u0430\u043d\u0430'),'ml':u('\u0d17\u0d2f\u0d3e\u0d28'),'mn':'*ce','mo':'*aa','mr':u('\u0917\u092f\u093e\u0928\u093e'),'ms':'*aa','mt':'il-Guyana','my':u('\u1002\u102d\u102f\u1004\u103a\u101a\u102c\u1014\u102c'),'na':'*aa','nb':'*aa','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b17\u0b41\u0b07\u0b28\u0b3e'),'os':'*aa','pa':u('\u0a17\u0a41\u0a2f\u0a3e\u0a28\u0a3e'),'pi':'*aa','pl':'*fo','ps':u('\u06ab\u06cc\u0627\u0646\u0627'),'pt':'Guiana','qu':'*aa','rm':'*aa','rn':'Guyane','ro':'*aa','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06af\u064a\u0627\u0646\u0627'),'se':'*aa','sg':u('Gay\u00e2na'),'si':u('\u0d9c\u0dba\u0db1\u0dcf\u0dc0'),'sk':'*aa','sl':'*bs','sm':'*aa','sn':'*aa','so':'*aa','sq':u('Guajan\u00eb'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b95\u0baf\u0bbe\u0ba9\u0bbe'),'te':u('\u0c17\u0c2f\u0c3e\u0c28\u0c3e'),'tg':'*ce','th':u('\u0e01\u0e32\u0e22\u0e2d\u0e32\u0e19\u0e32'),'ti':'*am','tk':u('Ga\u00fdana'),'tl':'*aa','tn':'*aa','to':'Kuiana','tr':'*aa','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u06af\u0649\u06cb\u0649\u064a\u0627\u0646\u0627'),'uk':u('\u0490\u0430\u0439\u0430\u043d\u0430'),'ur':u('\u06af\u06cc\u0627\u0646\u0627'),'uz':'*ak','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*ff','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Guyana'),'za':'*aa','zh':u('\u572d\u4e9a\u90a3'),'zu':'i-Guyana',},
  'HK': {'aa':'Hong Kong','ab':'*aa','ae':'*aa','af':'Hongkong SAS Sjina','ak':'*aa','am':u('\u1206\u1295\u130d \u12ae\u1295\u130d \u120d\u12e9 \u12e8\u12a0\u1235\u1270\u12f3\u12f0\u122d \u12ad\u120d\u120d \u127b\u12ed\u1293'),'an':'*aa','ar':u('\u0647\u0648\u0646\u063a \u0643\u0648\u0646\u063a \u0627\u0644\u0635\u064a\u0646\u064a\u0629 (\u0645\u0646\u0637\u0642\u0629 \u0625\u062f\u0627\u0631\u064a\u0629 \u062e\u0627\u0635\u0629)'),'as':u('\u09b9\u0982 \u0995\u0982 \u098f\u099b. \u098f. \u0986\u09f0. \u099a\u09c0\u09a8'),'av':'*aa','ay':'*aa','az':u('Honq Konq X\u00fcsusi \u0130nzibati \u018frazi \u00c7in'),'ba':'*aa','be':u('\u0413\u0430\u043d\u043a\u043e\u043d\u0433, \u0421\u0410\u0420 (\u041a\u0456\u0442\u0430\u0439)'),'bg':u('\u0425\u043e\u043d\u043a\u043e\u043d\u0433, \u0421\u0410\u0420 \u043d\u0430 \u041a\u0438\u0442\u0430\u0439'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u09b9\u0982\u0995\u0982 \u098f\u09b8\u098f\u0986\u09b0 \u099a\u09c0\u09a8\u09be'),'bo':'*aa','br':'Hong Kong RMD Sina','bs':'Hong Kong (SAR Kina)','ca':'Hong Kong (RAE Xina)','ce':u('\u0413\u043e\u043d\u043a\u043e\u043d\u0433 (\u0448\u0430-\u043a\u044a\u0430\u044c\u0441\u0442\u0438\u043d\u0430 \u043a\u04c0\u043e\u0448\u0442)'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Hongkong \u2013 ZAO \u010c\u00edny'),'cu':'*aa','cv':'*aa','cy':'Hong Kong RhGA Tsieina','da':'SAR Hongkong','de':'Sonderverwaltungsregion Hongkong','dv':'*aa','dz':u('\u0f67\u0f7c\u0f44\u0f0b\u0f40\u0f7c\u0f44\u0f0b\u0f45\u0f71\u0f60\u0f72\u0f0b\u0f53'),'ee':u('H\u0254ng K\u0254ng SAR Tsaina nutome'),'el':u('\u03a7\u03bf\u03bd\u03b3\u03ba \u039a\u03bf\u03bd\u03b3\u03ba \u0395\u0394\u03a0 \u039a\u03af\u03bd\u03b1\u03c2'),'en':'Hong Kong SAR China','eo':'*aa','es':'RAE de Hong Kong (China)','et':'Hongkongi erihalduspiirkond','eu':'Hong Kong Txinako AEB','fa':u('\u0647\u0646\u06af\u200c\u06a9\u0646\u06af\u060c \u0646\u0627\u062d\u06cc\u0647\u0654 \u0648\u06cc\u0698\u0647\u0654 \u062d\u06a9\u0648\u0645\u062a\u06cc \u0686\u06cc\u0646'),'ff':'*aa','fi':u('Hongkong \u2013 Kiinan e.h.a.'),'fj':'*aa','fo':'Hong Kong SAR Kina','fr':'R.A.S. chinoise de Hong Kong','fy':'Hongkong SAR van Sina','ga':u('S.R.R. na S\u00edne Hong Cong'),'gd':u('Hong Kong SAR na S\u00ecne'),'gl':'Hong Kong RAE da China','gn':'*aa','gu':u('\u0ab9\u0acb\u0a82\u0a97\u0a95\u0acb\u0a82\u0a97 SAR \u0a9a\u0ac0\u0aa8'),'gv':'*aa','ha':'*aa','he':u('\u05d4\u05d5\u05e0\u05d2 \u05e7\u05d5\u05e0\u05d2 (\u05d0\u05d6\u05d5\u05e8 \u05de\u05e0\u05d4\u05dc\u05d9 \u05de\u05d9\u05d5\u05d7\u05d3 \u05e9\u05dc \u05e1\u05d9\u05df)'),'hi':u('\u0939\u093e\u0901\u0917 \u0915\u093e\u0901\u0917 (\u091a\u0940\u0928 \u0935\u093f\u0936\u0947\u0937 \u092a\u094d\u0930\u0936\u093e\u0938\u0928\u093f\u0915 \u0915\u094d\u0937\u0947\u0924\u094d\u0930)'),'ho':'*aa','hr':'PUP Hong Kong Kina','ht':'*aa','hu':'Hongkong KKT','hy':u('\u0540\u0578\u0576\u056f\u0578\u0576\u0563\u056b \u0540\u054e\u0547'),'hz':'*aa','ia':'*aa','id':'Hong Kong SAR Tiongkok','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('s\u00e9rstj\u00f3rnarsv\u00e6\u00f0i\u00f0 Hong Kong'),'it':'RAS di Hong Kong','iu':'*aa','iw':'*he','ja':u('\u4e2d\u83ef\u4eba\u6c11\u5171\u548c\u56fd\u9999\u6e2f\u7279\u5225\u884c\u653f\u533a'),'ji':'*aa','jv':'*aa','ka':u('\u10f0\u10dd\u10dc\u10d9\u10dd\u10dc\u10d2\u10d8\u10e1 \u10e1\u10de\u10d4\u10ea\u10d8\u10d0\u10da\u10e3\u10e0\u10d8 \u10d0\u10d3\u10db\u10d8\u10dc\u10d8\u10e1\u10e2\u10e0\u10d0\u10ea\u10d8\u10e3\u10da\u10d8 \u10e0\u10d4\u10d2\u10d8\u10dd\u10dc\u10d8 \u10e9\u10d8\u10dc\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u0421\u044f\u043d\u0433\u0430\u043d \u0410\u04d8\u0410'),'kl':'*aa','km':u('\u17a0\u17bb\u1784\u1780\u17bb\u1784'),'kn':u('\u0cb9\u0cbe\u0c82\u0c97\u0ccd \u0c95\u0cbe\u0c82\u0c97\u0ccd SAR \u0c9a\u0cc8\u0ca8\u0cbe'),'ko':u('\ud64d\ucf69(\uc911\uad6d \ud2b9\ubcc4\ud589\uc815\uad6c)'),'kr':'*aa','ks':u('\u06c1\u0627\u0646\u065b\u06af \u06a9\u0627\u0646\u065b\u06af \u0627\u06cc\u0633 \u0627\u06d2 \u0622\u0631 \u0686\u06cc\u0656\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0413\u043e\u043d\u043a\u043e\u043d\u0433 \u041a\u044b\u0442\u0430\u0439 \u0410\u0410\u0410'),'la':'*aa','lb':'Spezialverwaltungszon Hong Kong','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0eae\u0ebb\u0e87\u0e81\u0ebb\u0e87 \u0ec0\u0e82\u0e94\u0e9b\u0ebb\u0e81\u0e84\u0ead\u0e87\u0e9e\u0eb4\u0ec0\u0eaa\u0e94 \u0e88\u0eb5\u0e99'),'lt':'Ypatingasis Administracinis Kinijos Regionas Honkongas','lu':'*aa','lv':u('\u0136\u012bnas \u012bpa\u0161\u0101s p\u0101rvaldes apgabals Honkonga'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0425\u043e\u043d\u0433 \u041a\u043e\u043d\u0433 \u0421.\u0410.\u0420 \u041a\u0438\u043d\u0430'),'ml':u('\u0d39\u0d4b\u0d19\u0d4d\u0d15\u0d4b\u0d19\u0d4d (SAR) \u0d1a\u0d48\u0d28'),'mn':u('\u0411\u041d\u0425\u0410\u0423-\u044b\u043d \u0422\u0443\u0441\u0433\u0430\u0439 \u0437\u0430\u0445\u0438\u0440\u0433\u0430\u0430\u043d\u044b \u0431\u04af\u0441 \u0425\u043e\u043d\u0433 \u041a\u043e\u043d\u0433'),'mo':'R.A.S. Hong Kong a Chinei','mr':u('\u0939\u093e\u0901\u0917\u0915\u093e\u0901\u0917 \u090f\u0938\u090f\u0906\u0930 \u091a\u0940\u0928'),'ms':'*en','mt':u('ir-Re\u0121jun Amministrattiv Spe\u010bjali ta\u2019 Hong Kong tar-Repubblika tal-Poplu ta\u010b-\u010aina'),'my':u('\u101f\u1031\u102c\u1004\u103a\u1000\u1031\u102c\u1004\u103a (\u1010\u101b\u102f\u1010\u103a\u1015\u103c\u100a\u103a)'),'na':'*aa','nb':'Hongkong S.A.R. Kina','nd':'*aa','ne':u('\u0939\u0919\u0915\u0919 \u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0938\u092e\u093e\u091c\u092c\u093e\u0926\u0940 \u0938\u094d\u0935\u093e\u092f\u0924\u094d\u0924 \u0915\u094d\u0937\u0947\u0924\u094d\u0930'),'ng':'*aa','nl':'Hongkong SAR van China','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b39\u0b02 \u0b15\u0b02 \u0b0f\u0b38\u0b0f\u0b06\u0b30\u0b4d\u200c \u0b1a\u0b3e\u0b07\u0b28\u0b3e'),'os':'*aa','pa':u('\u0a39\u0a3e\u0a02\u0a17 \u0a15\u0a3e\u0a02\u0a17 \u0a10\u0a38\u0a0f\u0a06\u0a30 \u0a1a\u0a40\u0a28'),'pi':'*aa','pl':'SRA Hongkong (Chiny)','ps':u('\u0647\u0627\u0646\u06ab \u06a9\u0627\u0646\u06ab SAR \u0686\u06cc\u0646'),'pt':'Hong Kong, RAE da China','qu':'Hong Kong (RAE)','rm':u('Regiun d\u2019administraziun speziala da Hongkong, China'),'rn':'*aa','ro':'*mo','ru':u('\u0413\u043e\u043d\u043a\u043e\u043d\u0433 (\u0421\u0410\u0420)'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0647\u0627\u0646\u06af \u06aa\u0627\u0646\u06af'),'se':'Hongkong','sg':'*aa','si':u('\u0dc4\u0ddc\u0d82\u0d9a\u0ddc\u0d82 \u0da0\u0dd3\u0db1 \u0dc0\u0dd2\u0dc1\u0dda\u0dc2 \u0db4\u0dbb\u0dd2\u0db4\u0dcf\u0dbd\u0db1 \u0d9a\u0dbd\u0dcf\u0db4\u0dba'),'sk':u('Hongkong \u2013 OAO \u010c\u00edny'),'sl':u('Posebno administrativno obmo\u010dje LR Kitajske Hongkong'),'sm':'*aa','sn':'*aa','so':'*aa','sq':'RPA i Hong-Kongut','sr':u('\u0421\u0410\u0420 \u0425\u043e\u043d\u0433\u043a\u043e\u043d\u0433 (\u041a\u0438\u043d\u0430)'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*se','sw':'*en','ta':u('\u0bb9\u0bbe\u0b99\u0bcd\u0b95\u0bbe\u0b99\u0bcd \u0b8e\u0bb8\u0bcd\u0b8f\u0b86\u0bb0\u0bcd \u0b9a\u0bc0\u0ba9\u0bbe'),'te':u('\u0c39\u0c3e\u0c02\u0c15\u0c3e\u0c02\u0c17\u0c4d \u0c0e\u0c38\u0c4d\u0c0f\u0c06\u0c30\u0c4d \u0c1a\u0c48\u0c28\u0c3e'),'tg':u('\u04b2\u043e\u043d\u043a\u043e\u043d\u0433 (\u041c\u041c\u041c)'),'th':u('\u0e40\u0e02\u0e15\u0e1b\u0e01\u0e04\u0e23\u0e2d\u0e07\u0e1e\u0e34\u0e40\u0e28\u0e29\u0e2e\u0e48\u0e2d\u0e07\u0e01\u0e07\u0e41\u0e2b\u0e48\u0e07\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e1b\u0e23\u0e30\u0e0a\u0e32\u0e0a\u0e19\u0e08\u0e35\u0e19'),'ti':u('\u1206\u1295\u130d \u12ae\u1295\u130d'),'tk':u('Gonkong AAS Hyta\u00fd'),'tl':'*en','tn':'*aa','to':'Hongi Kongi SAR Siaina','tr':u('\u00c7in Hong Kong \u00d6\u0130B'),'ts':'*aa','tt':u('\u0413\u043e\u043d\u043a\u043e\u043d\u0433 \u041c\u0430\u0445\u0441\u0443\u0441 \u0418\u0434\u0430\u0440\u04d9\u043b\u0435 \u0422\u04e9\u0431\u04d9\u0433\u0435'),'tw':'*aa','ty':'*aa','ug':u('\u0634\u064a\u0627\u06ad\u06af\u0627\u06ad \u0626\u0627\u0644\u0627\u06be\u0649\u062f\u06d5 \u0645\u06d5\u0645\u06c7\u0631\u0649\u064a \u0631\u0627\u064a\u0648\u0646\u0649 (\u062c\u06c7\u06ad\u06af\u0648)'),'uk':u('\u0413\u043e\u043d\u043a\u043e\u043d\u0433, \u041e.\u0410.\u0420. \u041a\u0438\u0442\u0430\u044e'),'ur':u('\u06c1\u0627\u0646\u06af \u06a9\u0627\u0646\u06af SAR \u0686\u06cc\u0646'),'uz':'Gonkong (Xitoy MMH)','ve':'*aa','vi':u('H\u1ed3ng K\u00f4ng, Trung Qu\u1ed1c'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4e2d\u56fd\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a'),'zu':'i-Hong Kong SAR China',},
  'HM': {'aa':'Heard Island And McDonald Islands','ab':'*aa','ae':'*aa','af':'Heardeiland en McDonaldeilande','ak':'*aa','am':u('\u12bd\u122d\u12f5 \u12f0\u1234\u1276\u127d\u1293 \u121b\u12ad\u12f6\u1293\u120d\u12f5 \u12f0\u1234\u1276\u127d'),'an':'*aa','ar':u('\u062c\u0632\u064a\u0631\u0629 \u0647\u064a\u0631\u062f \u0648\u062c\u0632\u0631 \u0645\u0627\u0643\u062f\u0648\u0646\u0627\u0644\u062f'),'as':u('\u09b9\u09be\u09f0\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa \u0986\u09f0\u09c1 \u09ae\u09c7\u0995\u09a1\u09cb\u09a8\u09be\u09b2\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'av':'*aa','ay':'*aa','az':u('Herd v\u0259 Makdonald adalar\u0131'),'ba':'*aa','be':u('\u0410\u0441\u0442\u0440\u0430\u0432\u044b \u0425\u0435\u0440\u0434 \u0456 \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u044c\u0434'),'bg':u('\u043e\u0441\u0442\u0440\u043e\u0432\u0438 \u0425\u044a\u0440\u0434 \u0438 \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u0434'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u09b9\u09be\u09b0\u09cd\u09a1 \u098f\u09ac\u0982 \u09ae\u09cd\u09af\u09be\u0995\u09a1\u09cb\u09a8\u09be\u09b2\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'bo':'*aa','br':'Inizi Heard ha McDonald','bs':'Herd i arhipelag MekDonald','ca':'Illa Heard i Illes McDonald','ce':u('\u0425\u0435\u0440\u0434 \u0433\u04c0\u0430\u0439\u0440\u0435 \u0430, \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u044c\u0434 \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448 \u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Heard\u016fv ostrov a McDonaldovy ostrovy'),'cu':'*aa','cv':'*aa','cy':'Ynys Heard ac Ynysoedd McDonald','da':'Heard Island og McDonald Islands','de':'Heard und McDonaldinseln','dv':'*aa','dz':u('\u0f67\u0f71\u0f62\u0f4c\u0f0b\u0f58\u0f5a\u0f7c\u0f0b\u0f42\u0fb3\u0f72\u0f44\u0f0b \u0f51\u0f44\u0f0b \u0f58\u0f7a\u0f40\u0f0b\u0f4c\u0f7c\u0f0b\u0f53\u0f63\u0f4c\u0f84\u0f0b\u0f42\u0fb3\u0f72\u0f44\u0f0b\u0f5a\u0f7c\u0f58'),'ee':u('Heard kple Mcdonald \u0192udomekpowo nutome'),'el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u03a7\u03b5\u03c1\u03bd\u03c4 \u03ba\u03b1\u03b9 \u039c\u03b1\u03ba\u03bd\u03c4\u03cc\u03bd\u03b1\u03bb\u03bd\u03c4'),'en':'Heard & McDonald Islands','eo':'Herda kaj Makdonaldaj Insuloj','es':'Islas Heard y McDonald','et':'Heardi ja McDonaldi saared','eu':'Heard eta McDonald uharteak','fa':u('\u062c\u0632\u06cc\u0631\u0647\u0654 \u0647\u0631\u062f \u0648 \u062c\u0632\u0627\u06cc\u0631 \u0645\u06a9\u200c\u062f\u0648\u0646\u0627\u0644\u062f'),'ff':'*aa','fi':'Heard ja McDonaldinsaaret','fj':'*aa','fo':'Heard og McDonaldoyggjar','fr':u('\u00celes Heard et McDonald'),'fy':'Heard- en McDonaldeilannen','ga':u('Oile\u00e1n Heard agus Oile\u00e1in McDonald'),'gd':u('Eilean Heard is MhicDh\u00f2mhnaill'),'gl':'Illa Heard e Illas McDonald','gn':'*aa','gu':u('\u0ab9\u0ab0\u0acd\u0aa1 \u0a85\u0aa8\u0ac7 \u0aae\u0ac7\u0a95\u0aa1\u0acb\u0aa8\u0abe\u0ab2\u0acd\u0aa1 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8'),'gv':'*aa','ha':'*aa','he':u('\u05d0\u05d9\u05d9 \u05d4\u05e8\u05d3 \u05d5\u05de\u05e7\u05d3\u05d5\u05e0\u05dc\u05d3'),'hi':u('\u0939\u0930\u094d\u0921 \u0926\u094d\u0935\u0940\u092a \u0914\u0930 \u092e\u0948\u0915\u0921\u094b\u0928\u0949\u0932\u094d\u0921 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939'),'ho':'*aa','hr':'Otoci Heard i McDonald','ht':'*aa','hu':u('Heard-sziget \u00e9s McDonald-szigetek'),'hy':u('\u0540\u0565\u0580\u0564 \u056f\u0572\u0566\u056b \u0587 \u0544\u0561\u056f\u0534\u0578\u0576\u0561\u056c\u0564\u056b \u056f\u0572\u0566\u056b\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'Pulau Heard dan Kepulauan McDonald','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'Heard og McDonaldseyjar','it':'Isole Heard e McDonald','iu':'*aa','iw':'*he','ja':u('\u30cf\u30fc\u30c9\u5cf6\u30fb\u30de\u30af\u30c9\u30ca\u30eb\u30c9\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':u('\u10f0\u10d4\u10e0\u10d3\u10d8 \u10d3\u10d0 \u10db\u10d0\u10d9\u10d3\u10dd\u10dc\u10d0\u10da\u10d3\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u0425\u0435\u0440\u0434 \u0430\u0440\u0430\u043b\u044b \u0436\u04d9\u043d\u0435 \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u044c\u0434 \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'kl':'*aa','km':u('\u1780\u17c4\u17c7\u200b\u17a0\u17ba\u178a \u1793\u17b7\u1784\u200b\u1798\u17c9\u17b6\u1780\u17cb\u178a\u17bc\u178e\u17b6\u179b\u17cb'),'kn':u('\u0cb9\u0cb0\u0ccd\u0ca1\u0ccd \u0cae\u0ca4\u0ccd\u0ca4\u0cc1 \u0cae\u0ccd\u0caf\u0cbe\u0c95\u0ccd\u200c\u0ca1\u0ccb\u0ca8\u0cbe\u0cb2\u0ccd\u0ca1\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3\u0cc1'),'ko':u('\ud5c8\ub4dc \ub9e5\ub3c4\ub110\ub4dc \uc81c\ub3c4'),'kr':'*aa','ks':u('\u06c1\u064e\u0631\u0655\u0691 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655 \u062a\u06c1\u0655 \u0645\u066e\u06ea\u06a9\u0688\u0648\u0646\u0627\u0644\u0691\u0655 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0425\u0435\u0440\u0434 \u0436\u0430\u043d\u0430 \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u044c\u0434 \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'la':'*aa','lb':'Heard- a McDonald-Inselen','lg':'*aa','li':'*aa','ln':'Ile Heard et Iles McDonald','lo':u('\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ec0\u0eae\u0eb5\u0e94 & \u0ec1\u0ea1\u0eb1\u0e81\u0ec2\u0e94\u0e99\u0ead\u0ea5'),'lt':'Herdo ir Makdonaldo Salos','lu':'*aa','lv':u('H\u0113rda sala un Makdonalda salas'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u041e\u0441\u0442\u0440\u043e\u0432 \u0425\u0435\u0440\u0434 \u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438 \u041c\u0435\u043a\u0434\u043e\u043d\u0430\u043b\u0434'),'ml':u('\u0d39\u0d3f\u0d2f\u0d47\u0d7c\u0d21\u0d41\u0d02 \u0d2e\u0d15\u0d4d\u200c\u0d21\u0d4a\u0d23\u0d3e\u0d7e\u0d21\u0d4d \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d33\u0d41\u0d02'),'mn':u('\u0425\u0435\u0440\u0434 \u0431\u0430 \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u044c\u0434\u0438\u0439\u043d \u0430\u0440\u043b\u0443\u0443\u0434'),'mo':u('Insula Heard \u0219i Insulele McDonald'),'mr':u('\u0939\u0930\u094d\u0921 \u0906\u0923\u093f \u092e\u0945\u0915\u094d\u0921\u094b\u0928\u093e\u0932\u094d\u0921 \u092c\u0947\u091f\u0947'),'ms':'Kepulauan Heard & McDonald','mt':u('il-G\u017cejjer Heard u l-G\u017cejjer McDonald'),'my':u('\u101f\u1010\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u1014\u103e\u1004\u1037\u103a\u1019\u1000\u103a\u1012\u1031\u102b\u1014\u101a\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f'),'na':'*aa','nb':u('Heard- og McDonald\u00f8yene'),'nd':'*aa','ne':u('\u0939\u0930\u094d\u0921 \u091f\u093e\u092a\u0941 \u0930 \u092e\u094d\u092f\u093e\u0915\u0921\u094b\u0928\u093e\u0932\u094d\u0921 \u091f\u093e\u092a\u0941\u0939\u0930\u0941'),'ng':'*aa','nl':'Heard en McDonaldeilanden','nn':u('Heard\u00f8ya og McDonald\u00f8yane'),'no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b39\u0b3e\u0b30\u0b4d\u0b21\u0b4d\u200c \u0b0f\u0b2c\u0b02 \u0b2e\u0b4d\u0b5f\u0b3e\u0b15\u0b21\u0b4b\u0b28\u0b3e\u0b32\u0b4d\u0b21 \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c'),'os':'*aa','pa':u('\u0a39\u0a30\u0a21 \u0a24\u0a47 \u0a2e\u0a48\u0a15\u0a21\u0a4b\u0a28\u0a3e\u0a32\u0a21 \u0a1f\u0a3e\u0a2a\u0a42'),'pi':'*aa','pl':'Wyspy Heard i McDonalda','ps':'HM','pt':'Ilhas Heard e McDonald','qu':'*es','rm':'Inslas da Heard e da McDonald','rn':'*aa','ro':'*mo','ru':u('\u043e-\u0432\u0430 \u0425\u0435\u0440\u0434 \u0438 \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u044c\u0434'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0647\u0631\u068a \u06fd \u0645\u06aa\u068a\u0648\u0646\u0644\u068a \u067b\u064a\u067d'),'se':'Heard- ja McDonald-sullot','sg':'*aa','si':u('\u0dc4\u0dbb\u0dca\u0da9\u0dca \u0daf\u0dd6\u0db4\u0dad \u0dc3\u0dc4 \u0db8\u0dd0\u0d9a\u0dca\u0da9\u0ddc\u0db1\u0dbd\u0dca\u0da9\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca'),'sk':'Heardov ostrov a Macdonaldove ostrovy','sl':'Heardov otok in McDonaldovi otoki','sm':'*aa','sn':'*aa','so':'*aa','sq':u('Ishujt H\u00ebrd e Mekdonald'),'sr':u('\u041e\u0441\u0442\u0440\u0432\u043e \u0425\u0435\u0440\u0434 \u0438 \u041c\u0435\u043a\u0434\u043e\u043d\u0430\u043b\u0434\u043e\u0432\u0430 \u043e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Heard\u00f6n och McDonald\u00f6arna'),'sw':'Kisiwa cha Heard na Visiwa vya McDonald','ta':u('\u0bb9\u0bc7\u0bb0\u0bcd\u0b9f\u0bcd \u0bae\u0bb1\u0bcd\u0bb1\u0bc1\u0bae\u0bcd \u0bae\u0bc6\u0b95\u0bcd\u0b9f\u0bca\u0ba9\u0bbe\u0bb2\u0bcd\u0b9f\u0bc1 \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd'),'te':u('\u0c39\u0c46\u0c30\u0c4d\u0c21\u0c4d & \u0c2e\u0c46\u0c15\u0c4d \u0c21\u0c4a\u0c28\u0c3e\u0c32\u0c4d\u0c21\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41'),'tg':u('\u04b6\u0430\u0437\u0438\u0440\u0430\u0438 \u04b2\u0435\u0440\u0434 \u0432\u0430 \u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u0434'),'th':u('\u0e40\u0e01\u0e32\u0e30\u0e40\u0e2e\u0e34\u0e23\u0e4c\u0e14\u0e41\u0e25\u0e30\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e41\u0e21\u0e01\u0e14\u0e2d\u0e19\u0e31\u0e25\u0e14\u0e4c'),'ti':u('\u12f0\u1234\u1273\u1275 \u1200\u122d\u12f5\u1295 \u121b\u12ad\u12f6\u1293\u120d\u12f5\u1295'),'tk':'Herd we Makdonald adalary','tl':'*en','tn':'*aa','to':u('\u02bbOtumotu Heati mo Makitonali'),'tr':u('Heard Adas\u0131 ve McDonald Adalar\u0131'),'ts':'*aa','tt':u('\u0425\u0435\u0440\u0434 \u0443\u0442\u0440\u0430\u0432\u044b \u04bb\u04d9\u043c \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u044c\u0434 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u06be\u06d0\u0631\u062f \u0626\u0627\u0631\u0649\u0644\u0649 \u06cb\u06d5 \u0645\u0627\u0643\u062f\u0648\u0646\u0627\u0644\u062f \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649'),'uk':u('\u043e\u0441\u0442\u0440\u0456\u0432 \u0413\u0435\u0440\u0434 \u0456 \u043e\u0441\u0442\u0440\u043e\u0432\u0438 \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u0434'),'ur':u('\u06c1\u06cc\u0631\u0688 \u062c\u0632\u06cc\u0631\u06c1 \u0648 \u0645\u06cc\u06a9\u0688\u0648\u0644\u06cc\u0646\u0688 \u062c\u0632\u0627\u0626\u0631'),'uz':'Xerd va Makdonald orollari','ve':'*aa','vi':u('Qu\u1ea7n \u0111\u1ea3o Heard v\u00e0 McDonald'),'vo':'*aa','wa':'*aa','wo':u('Duni H\u00ebrd ak Duni MakDonald'),'xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u8d6b\u5fb7\u5c9b\u548c\u9ea6\u514b\u5510\u7eb3\u7fa4\u5c9b'),'zu':'i-Heard Island ne-McDonald Islands',},
  'HN': {'aa':'Honduras','ab':'*aa','ae':'*aa','af':'*aa','ak':u('H\u0254nduras'),'am':u('\u1206\u1295\u12f1\u122b\u1235'),'an':'*aa','ar':u('\u0647\u0646\u062f\u0648\u0631\u0627\u0633'),'as':u('\u09b9\u09a8\u09cd\u09a6\u09c1\u09f0\u09be\u099b'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u0413\u0430\u043d\u0434\u0443\u0440\u0430\u0441'),'bg':u('\u0425\u043e\u043d\u0434\u0443\u0440\u0430\u0441'),'bh':'*aa','bi':'*aa','bm':u('H\u0254ndirasi'),'bn':u('\u09b9\u09a8\u09cd\u09a1\u09c1\u09b0\u09be\u09b8'),'bo':'*aa','br':'*aa','bs':'*aa','ca':'Hondures','ce':u('\u0413\u043e\u043d\u0434\u0443\u0440\u0430\u0441'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f67\u0f71\u0f53\u0f0b\u0f4c\u0f74\u0f0b\u0f62\u0f71\u0f66\u0f84'),'ee':'Hondurasdu','el':u('\u039f\u03bd\u03b4\u03bf\u03cd\u03c1\u03b1'),'en':'*aa','eo':'Honduro','es':'*aa','et':'*aa','eu':'*aa','fa':'*ar','ff':'Onnduraas','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Hond\u00faras'),'gd':u('Hond\u00f9ras'),'gl':'*aa','gn':'*aa','gu':u('\u0ab9\u0acb\u0aa8\u0acd\u0aa1\u0ac1\u0ab0\u0ab8'),'gv':'*aa','ha':'*aa','he':u('\u05d4\u05d5\u05e0\u05d3\u05d5\u05e8\u05e1'),'hi':u('\u0939\u094b\u0902\u0921\u0942\u0930\u093e\u0938'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u0540\u0578\u0576\u0564\u0578\u0582\u0580\u0561\u057d'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*ga','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30db\u30f3\u30b8\u30e5\u30e9\u30b9'),'ji':u('\u05d4\u05d0\u05e0\u05d3\u05d5\u05e8\u05d0\u05b7\u05e1'),'jv':'*aa','ka':u('\u10f0\u10dd\u10dc\u10d3\u10e3\u10e0\u10d0\u10e1\u10d8'),'kg':'*aa','ki':'Hondurasi','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u17a0\u17bb\u1784\u178c\u17bc\u179a\u17c9\u17b6\u179f'),'kn':u('\u0cb9\u0cca\u0c82\u0ca1\u0cc1\u0cb0\u0cbe\u0cb8\u0ccd'),'ko':u('\uc628\ub450\ub77c\uc2a4'),'kr':'*aa','ks':u('\u06c1\u0627\u0646\u065b\u0688\u0648\u0657\u0631\u0650\u0633'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*aa','lg':'Hundurasi','li':'*aa','ln':u('Onduras\u025b'),'lo':u('\u0eae\u0ead\u0e99\u0e94\u0eb9\u0ea3\u0eb1\u0eaa'),'lt':u('Hond\u016bras'),'lu':'Ondurase','lv':'Hondurasa','mg':'Hondiorasy','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d39\u0d4b\u0d23\u0d4d\u0d1f\u0d41\u0d31\u0d3e\u0d38\u0d4d'),'mn':'*ce','mo':'*aa','mr':u('\u0939\u094b\u0902\u0921\u0941\u0930\u093e\u0938'),'ms':'*aa','mt':'il-Honduras','my':u('\u101f\u103d\u1014\u103a\u1012\u1030\u1038\u101b\u1015\u103a\u1005\u103a'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0939\u0928\u094d\u0921\u0941\u0930\u093e\u0938'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b39\u0b4b\u0b23\u0b4d\u0b21\u0b41\u0b30\u0b3e\u0b38\u0b4d\u200c'),'os':'*aa','pa':u('\u0a39\u0a4b\u0a02\u0a21\u0a41\u0a30\u0a38'),'pi':'*aa','pl':'*aa','ps':u('\u0647\u0627\u0646\u0689\u0648\u0631\u0627\u0633'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'*ki','ro':'*aa','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0647\u0646\u068a\u0648\u0631\u0633'),'se':'*aa','sg':u('Hondur\u00e4si'),'si':u('\u0dc4\u0ddc\u0db1\u0dca\u0da9\u0dd4\u0dbb\u0dcf\u0dc3\u0dca'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0bb9\u0bcb\u0ba3\u0bcd\u0b9f\u0bc2\u0bb0\u0bbe\u0bb8\u0bcd'),'te':u('\u0c39\u0c4b\u0c02\u0c21\u0c41\u0c30\u0c3e\u0c38\u0c4d'),'tg':'*ce','th':u('\u0e2e\u0e2d\u0e19\u0e14\u0e39\u0e23\u0e31\u0e2a'),'ti':'*am','tk':'Gonduras','tl':'*aa','tn':'*aa','to':'Honitulasi','tr':'*aa','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u06be\u0648\u0646\u062f\u06c7\u0631\u0627\u0633'),'uk':'*ce','ur':u('\u06c1\u0648\u0646\u0688\u0627\u0631\u0648\u0633'),'uz':'*tk','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Onduraas','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Hondurasi'),'za':'*aa','zh':u('\u6d2a\u90fd\u62c9\u65af'),'zu':'i-Honduras',},
  'HR': {'aa':'Croatia','ab':'*aa','ae':'*aa','af':u('Kroasi\u00eb'),'ak':'Krowehyia','am':u('\u12ad\u122e\u12a4\u123d\u12eb'),'an':'*aa','ar':u('\u0643\u0631\u0648\u0627\u062a\u064a\u0627'),'as':u('\u0995\u09cd\u09f0\u09cb\u09f1\u09c7\u099b\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Xorvatiya','ba':'*aa','be':u('\u0425\u0430\u0440\u0432\u0430\u0442\u044b\u044f'),'bg':u('\u0425\u044a\u0440\u0432\u0430\u0442\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Kroasi','bn':u('\u0995\u09cd\u09b0\u09cb\u09af\u09bc\u09c7\u09b6\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'Kroatia','bs':'Hrvatska','ca':u('Cro\u00e0cia'),'ce':u('\u0425\u043e\u0440\u0432\u0430\u0442\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Chorvatsko','cu':'*aa','cv':'*aa','cy':'*aa','da':'Kroatien','de':'*da','dv':'*aa','dz':u('\u0f40\u0fb2\u0f7c\u0f0b\u0f68\u0f7a\u0f0b\u0f64'),'ee':'Kroatsia nutome','el':u('\u039a\u03c1\u03bf\u03b1\u03c4\u03af\u03b1'),'en':'*aa','eo':'Kroatujo','es':'Croacia','et':'Horvaatia','eu':'Kroazia','fa':u('\u06a9\u0631\u0648\u0627\u0633\u06cc'),'ff':'Korwasii','fi':'*br','fj':'*aa','fo':'*br','fr':'Croatie','fy':u('Kroati\u00eb'),'ga':u('an Chr\u00f3it'),'gd':u('A\u2019 Chr\u00f2thais'),'gl':'*es','gn':'*aa','gu':u('\u0a95\u0acd\u0ab0\u0acb\u0a8f\u0ab6\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Kurowaishiya','he':u('\u05e7\u05e8\u05d5\u05d0\u05d8\u05d9\u05d4'),'hi':u('\u0915\u094d\u0930\u094b\u090f\u0936\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Horv\u00e1torsz\u00e1g'),'hy':u('\u053d\u0578\u0580\u057e\u0561\u0569\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'Kroasia','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Kr\u00f3at\u00eda'),'it':'Croazia','iu':'*aa','iw':'*he','ja':u('\u30af\u30ed\u30a2\u30c1\u30a2'),'ji':u('\u05e7\u05e8\u05d0\u05d0\u05b7\u05d8\u05d9\u05e2'),'jv':'*aa','ka':u('\u10ee\u10dd\u10e0\u10d5\u10d0\u10e2\u10d8\u10d0'),'kg':'*aa','ki':'Korasia','kj':'*aa','kk':u('\u0425\u043e\u0440\u0432\u0430\u0442\u0438\u044f'),'kl':'*aa','km':u('\u1780\u17d2\u179a\u17bc\u17a2\u17b6\u179f\u17ca\u17b8'),'kn':u('\u0c95\u0ccd\u0cb0\u0cca\u0caf\u0cc7\u0cb7\u0cbf\u0caf\u0cbe'),'ko':u('\ud06c\ub85c\uc544\ud2f0\uc544'),'kr':'*aa','ks':u('\u06a9\u0631\u065b\u0648\u0634\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*da','lg':'Kurowesya','li':'*aa','ln':'Krowasi','lo':u('\u0ec2\u0e84\u0ea3\u0ec0\u0ead\u0ec0\u0e97\u0e8d'),'lt':'Kroatija','lu':'*ln','lv':u('Horv\u0101tija'),'mg':'*id','mh':'*aa','mi':'*aa','mk':u('\u0425\u0440\u0432\u0430\u0442\u0441\u043a\u0430'),'ml':u('\u0d15\u0d4d\u0d30\u0d4a\u0d2f\u0d47\u0d37\u0d4d\u0d2f'),'mn':u('\u0425\u043e\u0440\u0432\u0430\u0442'),'mo':u('Croa\u021bia'),'mr':'*hi','ms':'*aa','mt':'il-Kroazja','my':u('\u1001\u101b\u102d\u102f\u1021\u1031\u1038\u101b\u103e\u102c\u1038'),'na':'*aa','nb':'*br','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*fy','nn':'*br','no':'*br','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b4d\u0b30\u0b4b\u0b0f\u0b38\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a15\u0a30\u0a4b\u0a0f\u0a38\u0a3c\u0a40\u0a06'),'pi':'*aa','pl':'Chorwacja','ps':u('\u06a9\u0631\u0648\u0627\u062b\u06cc\u0627'),'pt':u('Cro\u00e1cia'),'qu':'*es','rm':'*it','rn':'Korowasiya','ro':'*mo','ru':'*kk','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u0631\u0648\u0626\u064a\u0634\u064a\u0627'),'se':u('Kro\u00e1tia'),'sg':u('Kroas\u00efi'),'si':u('\u0d9a\u0dca\u200d\u0dbb\u0ddc\u0d92\u0dc2\u0dd2\u0dba\u0dcf\u0dc0'),'sk':u('Chorv\u00e1tsko'),'sl':u('Hrva\u0161ka'),'sm':'*aa','sn':'*ki','so':'Korweeshiya','sq':'Kroaci','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':u('\u0b95\u0bc1\u0bb0\u0bc7\u0bb7\u0bbf\u0baf\u0bbe'),'te':u('\u0c15\u0c4d\u0c30\u0c4b\u0c2f\u0c47\u0c37\u0c3f\u0c2f\u0c3e'),'tg':'*kk','th':u('\u0e42\u0e04\u0e23\u0e40\u0e2d\u0e40\u0e0a\u0e35\u0e22'),'ti':'*am','tk':u('Horwati\u00fda'),'tl':'*aa','tn':'*aa','to':'Kuloisia','tr':u('H\u0131rvatistan'),'ts':'*aa','tt':'*kk','tw':'*aa','ty':'*aa','ug':u('\u0643\u0649\u0631\u0648\u062f\u0649\u064a\u06d5'),'uk':u('\u0425\u043e\u0440\u0432\u0430\u0442\u0456\u044f'),'ur':u('\u06a9\u0631\u0648\u0634\u06cc\u0627'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Korowasi','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de K\u00f2r\u00f3\u00e1t\u00ed\u00e0'),'za':'*aa','zh':u('\u514b\u7f57\u5730\u4e9a'),'zu':'i-Croatia',},
  'HT': {'aa':'Haiti','ab':'*aa','ae':'*aa','af':u('Ha\u00efti'),'ak':'Heiti','am':u('\u1200\u12ed\u1272'),'an':'*aa','ar':u('\u0647\u0627\u064a\u062a\u064a'),'as':u('\u09b9\u09be\u0987\u099f\u09bf'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u0413\u0430\u0456\u0446\u0456'),'bg':u('\u0425\u0430\u0438\u0442\u0438'),'bh':'*aa','bi':'*aa','bm':'Ayiti','bn':u('\u09b9\u09be\u0987\u09a4\u09bf'),'bo':'*aa','br':'*aa','bs':'*aa','ca':u('Hait\u00ed'),'ce':u('\u0413\u0430\u0438\u0442\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f67\u0f7a\u0f0b\u0f4a\u0f72'),'ee':'Haiti nutome','el':u('\u0391\u03ca\u03c4\u03ae'),'en':'*aa','eo':'Haitio','es':'*ca','et':'*aa','eu':'*aa','fa':u('\u0647\u0627\u0626\u06cc\u062a\u06cc'),'ff':'Haytii','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*af','fy':'*af','ga':u('H\u00e1\u00edt\u00ed'),'gd':'Haidhti','gl':'*ca','gn':'*aa','gu':u('\u0ab9\u0ac8\u0aa4\u0abf'),'gv':'*aa','ha':'*aa','he':u('\u05d4\u05d0\u05d9\u05d8\u05d9'),'hi':u('\u0939\u0948\u0924\u0940'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u0540\u0561\u0575\u056b\u0569\u056b'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'Hati','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Ha\u00edt\u00ed'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30cf\u30a4\u30c1'),'ji':u('\u05d4\u05d0\u05b7\u05d9\u05d8\u05d9'),'jv':'*aa','ka':u('\u10f0\u10d0\u10d8\u10e2\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u17a0\u17c3\u1791\u17b8'),'kn':u('\u0cb9\u0cc8\u0c9f\u0cbf'),'ko':u('\uc544\uc774\ud2f0'),'kr':'*aa','ks':u('\u06c1\u0627\u06cc\u062a\u06cc'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*aa','lg':'Hayiti','li':'*aa','ln':'*bm','lo':u('\u0ec4\u0eae\u0e95\u0eb4'),'lt':'Haitis','lu':'*bm','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d39\u0d46\u0d2f\u0d4d\u0d24\u0d3f'),'mn':'*ce','mo':'*aa','mr':'*hi','ms':'*aa','mt':'il-Haiti','my':u('\u101f\u1031\u1010\u102e'),'na':'*aa','nb':'*aa','nd':'*lg','ne':u('\u0939\u0948\u091f\u0940'),'ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b39\u0b3e\u0b07\u0b24\u0b3f'),'os':'*aa','pa':u('\u0a39\u0a48\u0a24\u0a40'),'pi':'*aa','pl':'*aa','ps':u('\u0647\u0627\u06cc\u067c\u064a'),'pt':'*aa','qu':'*ca','rm':'*aa','rn':'*lg','ro':'*aa','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0647\u064a\u067d\u064a'),'se':'*aa','sg':u('Hait\u00efi'),'si':u('\u0dc4\u0dba\u0dd2\u0da7\u0dd2'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'Hayti','sq':'*aa','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0bb9\u0bc8\u0b9f\u0bcd\u0b9f\u0bbf'),'te':u('\u0c39\u0c48\u0c1f\u0c3f'),'tg':'*ce','th':u('\u0e40\u0e2e\u0e15\u0e34'),'ti':'*am','tk':'Gaiti','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u06be\u0627\u064a\u062a\u0649'),'uk':u('\u0413\u0430\u0457\u0442\u0456'),'ur':u('\u06c1\u06cc\u0679\u06cc'),'uz':'*tk','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Ayti','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Haati'),'za':'*aa','zh':u('\u6d77\u5730'),'zu':'i-Haiti',},
  'HU': {'aa':'Hungary','ab':'*aa','ae':'*aa','af':'Hongarye','ak':'Hangari','am':u('\u1200\u1295\u130b\u122a'),'an':'*aa','ar':u('\u0647\u0646\u063a\u0627\u0631\u064a\u0627'),'as':u('\u09b9\u09be\u0982\u0997\u09c7\u09f0\u09c0'),'av':'*aa','ay':'*aa','az':u('Macar\u0131stan'),'ba':'*aa','be':u('\u0412\u0435\u043d\u0433\u0440\u044b\u044f'),'bg':u('\u0423\u043d\u0433\u0430\u0440\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':u('H\u0254ngri'),'bn':u('\u09b9\u09be\u0999\u09cd\u0997\u09c7\u09b0\u09bf'),'bo':'*aa','br':'Hungaria','bs':u('Ma\u0111arska'),'ca':'Hongria','ce':u('\u0412\u0435\u043d\u0433\u0440\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Ma\u010farsko'),'cu':'*aa','cv':'*aa','cy':'Hwngari','da':'Ungarn','de':'*da','dv':'*aa','dz':u('\u0f67\u0f71\u0f44\u0f0b\u0f42\u0fb7\u0f0b\u0f62\u0f72'),'ee':'Hungari nutome','el':u('\u039f\u03c5\u03b3\u03b3\u03b1\u03c1\u03af\u03b1'),'en':'*aa','eo':'Hungarujo','es':u('Hungr\u00eda'),'et':'Ungari','eu':'*br','fa':u('\u0645\u062c\u0627\u0631\u0633\u062a\u0627\u0646'),'ff':'Onngiri','fi':'Unkari','fj':'*aa','fo':'*da','fr':'Hongrie','fy':'Hongarije','ga':u('an Ung\u00e1ir'),'gd':'An Ungair','gl':'*es','gn':'*aa','gu':u('\u0ab9\u0a82\u0a97\u0ac7\u0ab0\u0ac0'),'gv':'*aa','ha':'Hungari','he':u('\u05d4\u05d5\u05e0\u05d2\u05e8\u05d9\u05d4'),'hi':u('\u0939\u0902\u0917\u0930\u0940'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Magyarorsz\u00e1g'),'hy':u('\u0540\u0578\u0582\u0576\u0563\u0561\u0580\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*br','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*br','io':'*aa','is':'Ungverjaland','it':'Ungheria','iu':'*aa','iw':'*he','ja':u('\u30cf\u30f3\u30ac\u30ea\u30fc'),'ji':u('\u05d0\u05d5\u05e0\u05d2\u05e2\u05e8\u05df'),'jv':'*aa','ka':u('\u10e3\u10dc\u10d2\u10e0\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'*br','kj':'*aa','kk':u('\u0412\u0435\u043d\u0433\u0440\u0438\u044f'),'kl':'*aa','km':u('\u17a0\u17bb\u1784\u1782\u17d2\u179a\u17b8'),'kn':u('\u0cb9\u0c82\u0c97\u0cc7\u0cb0\u0cbf'),'ko':u('\ud5dd\uac00\ub9ac'),'kr':'*aa','ks':u('\u06c1\u064e\u0646\u065b\u06af\u0631\u06cc'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*da','lg':'Hangare','li':'*aa','ln':'Ongili','lo':u('\u0eae\u0eb1\u0e87\u0e81\u0eb2\u0ea3\u0eb5'),'lt':'Vengrija','lu':'*ln','lv':u('Ung\u0101rija'),'mg':'*ca','mh':'*aa','mi':'*aa','mk':u('\u0423\u043d\u0433\u0430\u0440\u0438\u0458\u0430'),'ml':u('\u0d39\u0d02\u0d17\u0d31\u0d3f'),'mn':u('\u0423\u043d\u0433\u0430\u0440'),'mo':'Ungaria','mr':u('\u0939\u0902\u0917\u0947\u0930\u0940'),'ms':'*aa','mt':'l-Ungerija','my':u('\u101f\u1014\u103a\u1002\u1031\u101b\u102e'),'na':'*aa','nb':'*da','nd':'*aa','ne':u('\u0939\u0919\u094d\u0917\u0947\u0930\u0940'),'ng':'*aa','nl':'*fy','nn':'*da','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b39\u0b19\u0b4d\u0b17\u0b47\u0b30\u0b40'),'os':'*aa','pa':u('\u0a39\u0a70\u0a17\u0a30\u0a40'),'pi':'*aa','pl':u('W\u0119gry'),'ps':'*fa','pt':'Hungria','qu':'*aa','rm':'*mo','rn':'Hungariya','ro':'*mo','ru':'*kk','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0686\u064a\u06aa \u062c\u0647\u0645\u0648\u0631\u064a\u0647'),'se':u('Ung\u00e1r'),'sg':u('Hongir\u00f9ii'),'si':u('\u0dc4\u0db1\u0dca\u0d9c\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*cs','sl':u('Mad\u017earska'),'sm':'*aa','sn':'*aa','so':'Hangeri','sq':'*ha','sr':u('\u041c\u0430\u0452\u0430\u0440\u0441\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Ungern','sw':'*br','ta':u('\u0bb9\u0b99\u0bcd\u0b95\u0bc7\u0bb0\u0bbf'),'te':u('\u0c39\u0c02\u0c17\u0c47\u0c30\u0c40'),'tg':u('\u041c\u0430\u04b7\u043e\u0440\u0438\u0441\u0442\u043e\u043d'),'th':u('\u0e2e\u0e31\u0e07\u0e01\u0e32\u0e23\u0e35'),'ti':'*am','tk':u('Wengri\u00fda'),'tl':'*aa','tn':'*aa','to':'Hungakalia','tr':'Macaristan','ts':'*aa','tt':'*kk','tw':'*aa','ty':'*aa','ug':u('\u06cb\u06d0\u0646\u06af\u0649\u0631\u0649\u064a\u06d5'),'uk':u('\u0423\u0433\u043e\u0440\u0449\u0438\u043d\u0430'),'ur':u('\u06c1\u0646\u06af\u0631\u06cc'),'uz':'Vengriya','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Ongari','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Hungari'),'za':'*aa','zh':u('\u5308\u7259\u5229'),'zu':'i-Hungary',},
  'ID': {'aa':'Indonesia','ab':'*aa','ae':'*aa','af':u('Indonesi\u00eb'),'ak':u('Ind\u0254nehyia'),'am':u('\u12a2\u1295\u12f6\u1294\u12e2\u12eb'),'an':'*aa','ar':u('\u0625\u0646\u062f\u0648\u0646\u064a\u0633\u064a\u0627'),'as':u('\u0987\u09a3\u09cd\u09a1\u09cb\u09a8\u09c7\u099a\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':u('\u0130ndoneziya'),'ba':'*aa','be':u('\u0406\u043d\u0434\u0430\u043d\u0435\u0437\u0456\u044f'),'bg':u('\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':u('\u0190ndonezi'),'bn':u('\u0987\u09a8\u09cd\u09a6\u09cb\u09a8\u09c7\u09b6\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'Indonezia','bs':'Indonezija','ca':u('Indon\u00e8sia'),'ce':u('\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Indon\u00e9sie'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'Indonesien','de':'*da','dv':'*aa','dz':u('\u0f68\u0f72\u0f53\u0f0b\u0f4c\u0f7c\u0f0b\u0f53\u0f7a\u0f0b\u0f64\u0f72\u0f0b\u0f61'),'ee':'Indonesia nutome','el':u('\u0399\u03bd\u03b4\u03bf\u03bd\u03b7\u03c3\u03af\u03b1'),'en':'*aa','eo':'Indonezio','es':'*aa','et':'Indoneesia','eu':'*aa','fa':u('\u0627\u0646\u062f\u0648\u0646\u0632\u06cc'),'ff':'Enndonesii','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*cs','fy':u('Yndonesi\u00eb'),'ga':u('an Indin\u00e9is'),'gd':'Na h-Innd-innse','gl':'*aa','gn':'*aa','gu':u('\u0a87\u0aa8\u0acd\u0aa1\u0acb\u0aa8\u0ac7\u0ab6\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Indunusiya','he':u('\u05d0\u05d9\u05e0\u05d3\u05d5\u05e0\u05d6\u05d9\u05d4'),'hi':u('\u0907\u0902\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Indon\u00e9zia'),'hy':u('\u053b\u0576\u0564\u0578\u0576\u0565\u0566\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Ind\u00f3nes\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30a4\u30f3\u30c9\u30cd\u30b7\u30a2'),'ji':u('\u05d0\u05d9\u05e0\u05d3\u05d0\u05e0\u05e2\u05d6\u05d9\u05e2'),'jv':'*aa','ka':u('\u10d8\u10dc\u10d3\u10dd\u10dc\u10d4\u10d6\u10d8\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a5\u178e\u17d2\u178c\u17bc\u178e\u17c1\u179f\u17ca\u17b8'),'kn':u('\u0c87\u0c82\u0ca1\u0ccb\u0ca8\u0cc7\u0cb6\u0cbf\u0caf\u0cbe'),'ko':u('\uc778\ub3c4\ub124\uc2dc\uc544'),'kr':'*aa','ks':u('\u0627\u0650\u0646\u0691\u0648\u0646\u06cc\u0634\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*da','lg':'Yindonezya','li':'*aa','ln':'Indonezi','lo':u('\u0ead\u0eb4\u0e99\u0ec2\u0e94\u0ec0\u0e99\u0ec0\u0e8a\u0e8d'),'lt':'*bs','lu':'*ln','lv':u('Indon\u0113zija'),'mg':'*br','mh':'*aa','mi':'*aa','mk':u('\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u0458\u0430'),'ml':u('\u0d07\u0d28\u0d4d\u0d24\u0d4b\u0d28\u0d47\u0d37\u0d4d\u0d2f'),'mn':u('\u0418\u043d\u0434\u043e\u043d\u0435\u0437'),'mo':'*br','mr':'*hi','ms':'*aa','mt':u('l-Indone\u017cja'),'my':u('\u1021\u1004\u103a\u1012\u102d\u102f\u1014\u102e\u1038\u101b\u103e\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'Indonesiya','ne':u('\u0907\u0928\u094d\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e'),'ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b07\u0b23\u0b4d\u0b21\u0b4b\u0b28\u0b47\u0b38\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a07\u0a70\u0a21\u0a4b\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06'),'pi':'*aa','pl':'Indonezja','ps':u('\u0627\u0646\u062f\u0648\u0646\u06cc\u0632\u06cc\u0627'),'pt':u('Indon\u00e9sia'),'qu':'*aa','rm':'*aa','rn':'Indoneziya','ro':'*br','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u0646\u068a\u0648\u0646\u064a\u0634\u064a\u0627'),'se':'*aa','sg':u('\u00canndonez\u00efi'),'si':u('\u0d89\u0db1\u0dca\u0daf\u0dd4\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*hu','sl':'*bs','sm':'*aa','sn':'*aa','so':'Indoneesiya','sq':'*ln','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':u('\u0b87\u0ba8\u0bcd\u0ba4\u0bcb\u0ba9\u0bc7\u0b9a\u0bbf\u0baf\u0bbe'),'te':u('\u0c07\u0c02\u0c21\u0c4b\u0c28\u0c47\u0c37\u0c3f\u0c2f\u0c3e'),'tg':'*bg','th':u('\u0e2d\u0e34\u0e19\u0e42\u0e14\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22'),'ti':'*am','tk':u('Indonezi\u00fda'),'tl':'*aa','tn':'*aa','to':u('\u02bbIniton\u0113sia'),'tr':'Endonezya','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u06be\u0649\u0646\u062f\u0648\u0646\u06d0\u0632\u0649\u064a\u06d5'),'uk':u('\u0406\u043d\u0434\u043e\u043d\u0435\u0437\u0456\u044f'),'ur':u('\u0627\u0646\u0688\u0648\u0646\u06cc\u0634\u06cc\u0627'),'uz':'*rn','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Indonesi','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Indonesia'),'za':'*aa','zh':u('\u5370\u5ea6\u5c3c\u897f\u4e9a'),'zu':'i-Indonesia',},
  'IE': {'aa':'Ireland','ab':'*aa','ae':'*aa','af':'Ierland','ak':'Aereland','am':u('\u12a0\u12e8\u122d\u120b\u1295\u12f5'),'an':'*aa','ar':u('\u0623\u064a\u0631\u0644\u0646\u062f\u0627'),'as':u('\u0986\u09af\u09bc\u09be\u09f0\u09b2\u09c7\u09a3\u09cd\u09a1'),'av':'*aa','ay':'*aa','az':u('\u0130rlandiya'),'ba':'*aa','be':u('\u0406\u0440\u043b\u0430\u043d\u0434\u044b\u044f'),'bg':u('\u0418\u0440\u043b\u0430\u043d\u0434\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Irilandi','bn':u('\u0986\u09af\u09bc\u09be\u09b0\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1'),'bo':'*aa','br':'Iwerzhon','bs':'Irska','ca':'Irlanda','ce':u('\u0418\u0440\u043b\u0430\u043d\u0434\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Irsko','cu':'*aa','cv':'*aa','cy':'Iwerddon','da':'Irland','de':'*da','dv':'*aa','dz':u('\u0f68\u0f71\u0f0b\u0f61\u0f0b\u0f63\u0f7a\u0f53\u0f4c'),'ee':'Ireland nutome','el':u('\u0399\u03c1\u03bb\u03b1\u03bd\u03b4\u03af\u03b1'),'en':'*aa','eo':'Irlando','es':'*ca','et':'Iirimaa','eu':'*ca','fa':u('\u0627\u06cc\u0631\u0644\u0646\u062f'),'ff':'Irlannda','fi':'Irlanti','fj':'*aa','fo':u('\u00cdrland'),'fr':'Irlande','fy':u('Ierl\u00e2n'),'ga':u('\u00c9ire'),'gd':u('\u00c8irinn'),'gl':'*ca','gn':'*aa','gu':u('\u0a86\u0aaf\u0ab0\u0acd\u0ab2\u0ac7\u0aa8\u0acd\u0aa1'),'gv':'*aa','ha':'Ayalan','he':u('\u05d0\u05d9\u05e8\u05dc\u05e0\u05d3'),'hi':u('\u0906\u092f\u0930\u0932\u0948\u0902\u0921'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('\u00cdrorsz\u00e1g'),'hy':u('\u053b\u057c\u056c\u0561\u0576\u0564\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'Irlandia','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*fo','it':'*ca','iu':'*aa','iw':'*he','ja':u('\u30a2\u30a4\u30eb\u30e9\u30f3\u30c9'),'ji':u('\u05d0\u05d9\u05e8\u05dc\u05d0\u05b7\u05e0\u05d3'),'jv':'*aa','ka':u('\u10d8\u10e0\u10da\u10d0\u10dc\u10d3\u10d8\u10d0'),'kg':'*aa','ki':'Ayalandi','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a2\u17c0\u179a\u17a1\u1784\u17cb'),'kn':u('\u0c90\u0cb0\u0ccd\u0cb2\u0cc6\u0c82\u0ca1\u0ccd'),'ko':u('\uc544\uc77c\ub79c\ub4dc'),'kr':'*aa','ks':u('\u0627\u064e\u06cc\u064e\u0631\u0644\u06cc\u0646\u065b\u0691'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*da','lg':'*ki','li':'*aa','ln':u('Ireland\u025b'),'lo':u('\u0ec4\u0ead\u0ec1\u0ea5\u0e99'),'lt':'Airija','lu':'Irelande','lv':u('\u012arija'),'mg':'Irlandy','mh':'*aa','mi':'*aa','mk':u('\u0418\u0440\u0441\u043a\u0430'),'ml':u('\u0d05\u0d2f\u0d7c\u0d32\u0d7b\u0d21\u0d4d'),'mn':u('\u0418\u0440\u043b\u0430\u043d\u0434'),'mo':'*ca','mr':u('\u0906\u092f\u0930\u094d\u0932\u0902\u0921'),'ms':'*aa','mt':'l-Irlanda','my':u('\u1021\u102d\u102f\u1004\u103a\u101a\u102c\u101c\u1014\u103a'),'na':'*aa','nb':'*da','nd':'*aa','ne':u('\u0906\u092f\u0930\u0932\u094d\u092f\u093e\u0923\u094d\u0921'),'ng':'*aa','nl':'*af','nn':'*da','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b06\u0b5f\u0b30\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21'),'os':'*aa','pa':u('\u0a06\u0a07\u0a30\u0a32\u0a48\u0a02\u0a21'),'pi':'*aa','pl':'*id','ps':u('\u0627\u06cc\u0631\u0644\u06cc\u0646\u0689'),'pt':'*ca','qu':'*aa','rm':'*ca','rn':'*bm','ro':'*ca','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0622\u0626\u0631\u0644\u064a\u0646\u068a'),'se':u('Irl\u00e1nda'),'sg':u('Irl\u00e2nde'),'si':u('\u0d85\u0dba\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba'),'sk':u('\u00cdrsko'),'sl':'*bs','sm':'*aa','sn':'*aa','so':'Ayrlaand','sq':u('Irland\u00eb'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*ki','ta':u('\u0b85\u0baf\u0bb0\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1'),'te':u('\u0c10\u0c30\u0c4d\u0c32\u0c3e\u0c02\u0c21\u0c4d'),'tg':'*bg','th':u('\u0e44\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c'),'ti':'*am','tk':u('Irlandi\u00fda'),'tl':'*aa','tn':'*aa','to':u('\u02bbAealani'),'tr':u('\u0130rlanda'),'ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0626\u0649\u0631\u06d0\u0644\u0627\u0646\u062f\u0649\u064a\u06d5'),'uk':u('\u0406\u0440\u043b\u0430\u043d\u0434\u0456\u044f'),'ur':u('\u0622\u0626\u0631\u0644\u06cc\u0646\u0688'),'uz':'Irlandiya','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':u('Irl\u00e0nd'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Ailandi'),'za':'*aa','zh':u('\u7231\u5c14\u5170'),'zu':'i-Ireland',},
  'IL': {'aa':'Israel','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u12a5\u1235\u122b\u12a4\u120d'),'an':'*aa','ar':u('\u0625\u0633\u0631\u0627\u0626\u064a\u0644'),'as':u('\u0987\u099c\u09f0\u09be\u0987\u09b2'),'av':'*aa','ay':'*aa','az':u('\u0130srail'),'ba':'*aa','be':u('\u0406\u0437\u0440\u0430\u0456\u043b\u044c'),'bg':u('\u0418\u0437\u0440\u0430\u0435\u043b'),'bh':'*aa','bi':'*aa','bm':'Isirayeli','bn':u('\u0987\u099c\u09b0\u09be\u09af\u09bc\u09c7\u09b2'),'bo':'*aa','br':'*aa','bs':'Izrael','ca':'*aa','ce':u('\u0418\u0437\u0440\u0430\u0438\u043b\u044c'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*bs','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f68\u0f72\u0f66\u0f0b\u0f62\u0f0b\u0f61\u0f7a\u0f63'),'ee':'Israel nutome','el':u('\u0399\u03c3\u03c1\u03b1\u03ae\u03bb'),'en':'*aa','eo':'Israelo','es':'*aa','et':'Iisrael','eu':'*aa','fa':u('\u0627\u0633\u0631\u0627\u0626\u06cc\u0644'),'ff':u('Israa\u2019iila'),'fi':'*aa','fj':'*aa','fo':u('\u00cdsrael'),'fr':u('Isra\u00ebl'),'fy':'*fr','ga':'Iosrael','gd':'*ga','gl':'*aa','gn':'*aa','gu':u('\u0a87\u0a9d\u0ab0\u0abe\u0a87\u0ab2'),'gv':'*aa','ha':u('Izira\u02bcila'),'he':u('\u05d9\u05e9\u05e8\u05d0\u05dc'),'hi':u('\u0907\u091c\u093c\u0930\u093e\u0907\u0932'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*bs','hy':u('\u053b\u057d\u0580\u0561\u0575\u0565\u056c'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*fo','it':'Israele','iu':'*aa','iw':'*he','ja':u('\u30a4\u30b9\u30e9\u30a8\u30eb'),'ji':'*he','jv':'*aa','ka':u('\u10d8\u10e1\u10e0\u10d0\u10d4\u10da\u10d8'),'kg':'*aa','ki':'Israeli','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u17a2\u17ca\u17b8\u179f\u17d2\u179a\u17b6\u17a2\u17c2\u179b'),'kn':u('\u0c87\u0cb8\u0ccd\u0cb0\u0cc7\u0cb2\u0ccd'),'ko':u('\uc774\uc2a4\ub77c\uc5d8'),'kr':'*aa','ks':u('\u0627\u0650\u0633\u0631\u0627\u06cc\u0656\u0644'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*aa','lg':'Yisirayeri','li':'*aa','ln':u('Isirayel\u025b'),'lo':u('\u0ead\u0eb4\u0eaa\u0ea3\u0eb2\u0ec0\u0ead\u0ea7'),'lt':'Izraelis','lu':'Isirayele','lv':u('Izra\u0113la'),'mg':'Israely','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d07\u0d38\u0d4d\u0d30\u0d3e\u0d2f\u0d47\u0d7d'),'mn':'*ce','mo':'*aa','mr':u('\u0907\u0938\u094d\u0924\u094d\u0930\u093e\u0907\u0932'),'ms':'*aa','mt':u('I\u017crael'),'my':u('\u1021\u1005\u1039\u1005\u101b\u1031\u1038'),'na':'*aa','nb':'*aa','nd':'Isuraeli','ne':u('\u0907\u091c\u0930\u093e\u092f\u0932'),'ng':'*aa','nl':'*fr','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b07\u0b38\u0b4d\u0b30\u0b3e\u0b0f\u0b32\u0b4d'),'os':'*aa','pa':u('\u0a07\u0a1c\u0a3c\u0a30\u0a3e\u0a08\u0a32'),'pi':'*aa','pl':'*bs','ps':u('\u0627\u0633\u0631\u0627\u064a\u064a\u0644'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'Isiraheli','ro':'*aa','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u0633\u0631\u0627\u0626\u064a\u0644'),'se':'*aa','sg':u('Isra\u00ebli'),'si':u('\u0d8a\u0dc1\u0dca\u200d\u0dbb\u0dcf\u0dba\u0dbd\u0dba'),'sk':'*bs','sl':'*bs','sm':'*aa','sn':'Izuraeri','so':u('Israa\u02bciil'),'sq':'*bs','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*ki','ta':u('\u0b87\u0bb8\u0bcd\u0bb0\u0bc7\u0bb2\u0bcd'),'te':u('\u0c07\u0c1c\u0c4d\u0c30\u0c3e\u0c2f\u0c3f\u0c32\u0c4d'),'tg':u('\u0418\u0441\u0440\u043e\u0438\u043b'),'th':u('\u0e2d\u0e34\u0e2a\u0e23\u0e32\u0e40\u0e2d\u0e25'),'ti':'*am','tk':u('Ysra\u00fdyl'),'tl':'*aa','tn':'*aa','to':u('\u02bbIsileli'),'tr':'*az','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u0626\u0649\u0633\u0631\u0627\u0626\u0649\u0644\u0649\u064a\u06d5'),'uk':u('\u0406\u0437\u0440\u0430\u0457\u043b\u044c'),'ur':'*fa','uz':'Isroil','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Israyel','xh':'*aa','yi':'*he','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Iser\u1eb9li'),'za':'*aa','zh':u('\u4ee5\u8272\u5217'),'zu':'kwa-Israel',},
  'IM': {'aa':'Isle Of Man','ab':'*aa','ae':'*aa','af':'Eiland Man','ak':'*aa','am':u('\u12a0\u12ed\u120d \u12a6\u134d \u121b\u1295'),'an':'*aa','ar':u('\u062c\u0632\u064a\u0631\u0629 \u0645\u0627\u0646'),'as':u('\u0986\u0987\u09b2 \u0985\u09ab \u09ae\u09c7\u09a8'),'av':'*aa','ay':'*aa','az':u('Men adas\u0131'),'ba':'*aa','be':u('\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u041c\u044d\u043d'),'bg':u('\u043e\u0441\u0442\u0440\u043e\u0432 \u041c\u0430\u043d'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u0986\u0987\u09b2 \u0985\u09ab \u09ae\u09cd\u09af\u09be\u09a8'),'bo':'*aa','br':'Enez Vanav','bs':'Ostrvo Man','ca':'Illa de Man','ce':u('\u041c\u044d\u043d \u0433\u04c0\u0430\u0439\u0440\u0435'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Ostrov Man','cu':'*aa','cv':'*aa','cy':'Ynys Manaw','da':'Isle of Man','de':'*da','dv':'*aa','dz':u('\u0f68\u0f0b\u0f61\u0f74\u0f63\u0f0b \u0f68\u0f7c\u0f55\u0f0b \u0f58\u0f71\u0f53'),'ee':'Aisle of Man nutome','el':u('\u039d\u03ae\u03c3\u03bf\u03c2 \u03c4\u03bf\u03c5 \u039c\u03b1\u03bd'),'en':'*da','eo':'*aa','es':'Isla de Man','et':'Mani saar','eu':'Man uhartea','fa':u('\u062c\u0632\u06cc\u0631\u0647\u0654 \u0645\u0646'),'ff':'*aa','fi':'Mansaari','fj':'*aa','fo':'*da','fr':u('\u00cele de Man'),'fy':'*da','ga':u('Oile\u00e1n Mhanann'),'gd':'Eilean Mhanainn','gl':'*ca','gn':'*aa','gu':u('\u0a86\u0a87\u0ab2 \u0a91\u0aab \u0aae\u0ac7\u0aa8'),'gv':'Ellan Vannin','ha':'*aa','he':u('\u05d4\u05d0\u05d9 \u05de\u05d0\u05df'),'hi':u('\u0906\u0907\u0932 \u0911\u092b\u093c \u092e\u0948\u0928'),'ho':'*aa','hr':'Otok Man','ht':'*aa','hu':'Man-sziget','hy':u('\u0544\u0565\u0576 \u056f\u0572\u0566\u056b'),'hz':'*aa','ia':'*aa','id':'Pulau Man','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('M\u00f6n'),'it':'Isola di Man','iu':'*aa','iw':'*he','ja':u('\u30de\u30f3\u5cf6'),'ji':'*aa','jv':'*aa','ka':u('\u10db\u10d4\u10dc\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u041c\u044d\u043d \u0430\u0440\u0430\u043b\u044b'),'kl':'*aa','km':u('\u17a2\u17c2\u179b\u17a2\u17bb\u17a0\u17d2\u179c\u1798\u17c2\u1793'),'kn':u('\u0c90\u0cb2\u0ccd \u0c86\u0cab\u0ccd \u0cae\u0ccd\u0caf\u0cbe\u0ca8\u0ccd'),'ko':u('\ub9e8 \uc12c'),'kr':'*aa','ks':u('\u0622\u06cc\u0650\u0644 \u0622\u0641 \u0645\u06cc\u065b\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*da','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0ec0\u0ead\u0ea7 \u0ead\u0ead\u0e9a \u0ec1\u0ea1\u0e99'),'lt':'Meno Sala','lu':'*aa','lv':'Mena','mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u041e\u0441\u0442\u0440\u043e\u0432 \u041c\u0430\u043d'),'ml':u('\u0d10\u0d7d \u0d13\u0d2b\u0d4d \u0d2e\u0d3e\u0d7b'),'mn':u('\u041c\u044d\u043d \u0410\u0440\u0430\u043b'),'mo':'Insula Man','mr':u('\u0906\u092f\u0932 \u0911\u092b \u092e\u0945\u0928'),'ms':'*da','mt':'*da','my':u('\u1019\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038'),'na':'*aa','nb':'Man','nd':'*aa','ne':u('\u0906\u0907\u0932 \u0905\u092b \u092e\u094d\u092f\u093e\u0928'),'ng':'*aa','nl':'*da','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b06\u0b07\u0b32\u0b4d\u200c \u0b05\u0b2b\u0b4d\u200c \u0b2e\u0b4d\u0b5f\u0b3e\u0b28\u0b4d\u200c'),'os':'*aa','pa':u('\u0a06\u0a07\u0a32 \u0a06\u0a2b \u0a2e\u0a48\u0a28'),'pi':'*aa','pl':'Wyspa Man','ps':u('\u062f \u0622\u0626\u0644 \u0622\u0641 \u0645\u06cc\u0646'),'pt':'Ilha de Man','qu':'*aa','rm':'Insla da Man','rn':'*aa','ro':'*mo','ru':u('\u043e-\u0432 \u041c\u044d\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u0646\u0633\u0627\u0646\u0646 \u062c\u0648 \u067b\u064a\u067d'),'se':'Mann-sullot','sg':'*aa','si':u('\u0d85\u0dba\u0dd2\u0dbd\u0dca \u0d94\u0dc6\u0dca \u0db8\u0dd1\u0db1\u0dca'),'sk':'*cs','sl':'*hr','sm':'*aa','sn':'*aa','so':'*aa','sq':'Ishulli i Manit','sr':u('\u041e\u0441\u0442\u0440\u0432\u043e \u041c\u0430\u043d'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*da','ta':u('\u0b90\u0bb2\u0bcd \u0b86\u0b83\u0baa\u0bcd \u0bae\u0bc7\u0ba9\u0bcd'),'te':u('\u0c10\u0c32\u0c4d \u0c06\u0c2b\u0c4d \u0c2e\u0c3e\u0c28\u0c4d'),'tg':u('\u04b6\u0430\u0437\u0438\u0440\u0430\u0438 \u041c\u044d\u043d'),'th':u('\u0e40\u0e01\u0e32\u0e30\u0e41\u0e21\u0e19'),'ti':'*am','tk':'Men adasy','tl':'*da','tn':'*aa','to':'Motu Mani','tr':u('Man Adas\u0131'),'ts':'*aa','tt':u('\u041c\u044d\u043d \u0443\u0442\u0440\u0430\u0432\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0645\u0627\u0646 \u0626\u0627\u0631\u0649\u0644\u0649'),'uk':u('\u041e\u0441\u0442\u0440\u0456\u0432 \u041c\u0435\u043d'),'ur':u('\u0622\u0626\u0644 \u0622\u0641 \u0645\u06cc\u0646'),'uz':'Men oroli','ve':'*aa','vi':u('\u0110\u1ea3o Man'),'vo':'*aa','wa':'*aa','wo':'Dunu Maan','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u9a6c\u6069\u5c9b'),'zu':'i-Isle of Man',},
  'IN': {'aa':'India','ab':'*aa','ae':'*aa','af':u('Indi\u00eb'),'ak':'*aa','am':u('\u1205\u1295\u12f5'),'an':'*aa','ar':u('\u0627\u0644\u0647\u0646\u062f'),'as':u('\u09ad\u09be\u09f0\u09a4'),'av':'*aa','ay':'*aa','az':'Hindistan','ba':'*aa','be':u('\u0406\u043d\u0434\u044b\u044f'),'bg':u('\u0418\u043d\u0434\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':u('\u0190ndujamana'),'bn':u('\u09ad\u09be\u09b0\u09a4'),'bo':u('\u0f62\u0f92\u0fb1\u0f0b\u0f42\u0f62\u0f0b'),'br':'*aa','bs':'Indija','ca':u('\u00cdndia'),'ce':u('\u0425\u04c0\u0438\u043d\u0434\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Indie','cu':'*aa','cv':'*aa','cy':'*aa','da':'Indien','de':'*da','dv':'*aa','dz':u('\u0f62\u0f92\u0fb1\u0f0b\u0f42\u0f62'),'ee':'India nutome','el':u('\u0399\u03bd\u03b4\u03af\u03b1'),'en':'*aa','eo':'Hindujo','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0647\u0646\u062f'),'ff':'Enndo','fi':'Intia','fj':'*aa','fo':'*aa','fr':'Inde','fy':'*aa','ga':'an India','gd':'Na h-Innseachan','gl':'*aa','gn':'*aa','gu':u('\u0aad\u0abe\u0ab0\u0aa4'),'gv':'*aa','ha':'Indiya','he':u('\u05d4\u05d5\u05d3\u05d5'),'hi':u('\u092d\u093e\u0930\u0924'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u0540\u0576\u0564\u056f\u0561\u057d\u057f\u0561\u0576'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':u('\ua474\ua117'),'ik':'*aa','in':'*aa','io':'*aa','is':'Indland','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30a4\u30f3\u30c9'),'ji':u('\u05d0\u05d9\u05e0\u05d3\u05d9\u05e2'),'jv':'*aa','ka':u('\u10d8\u10dc\u10d3\u10dd\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u04ae\u043d\u0434\u0456\u0441\u0442\u0430\u043d'),'kl':'*aa','km':u('\u17a5\u178e\u17d2\u178c\u17b6'),'kn':u('\u0cad\u0cbe\u0cb0\u0ca4'),'ko':u('\uc778\ub3c4'),'kr':'*aa','ks':u('\u06c1\u0650\u0646\u065b\u062f\u0648\u0633\u062a\u0627\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*da','lg':'Buyindi','li':'*aa','ln':u('\u00cdnd\u025b'),'lo':u('\u0ead\u0eb4\u0e99\u0ec0\u0e94\u0e8d'),'lt':'*bs','lu':'*fr','lv':'*bs','mg':'Indy','mh':'*aa','mi':'*aa','mk':u('\u0418\u043d\u0434\u0438\u0458\u0430'),'ml':u('\u0d07\u0d28\u0d4d\u0d24\u0d4d\u0d2f'),'mn':u('\u042d\u043d\u044d\u0442\u0445\u044d\u0433'),'mo':'*aa','mr':'*hi','ms':'*aa','mt':'l-Indja','my':u('\u1021\u102d\u1014\u1039\u1012\u102d\u101a'),'na':'*aa','nb':'*aa','nd':'*ha','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2d\u0b3e\u0b30\u0b24'),'os':u('\u0418\u043d\u0434\u0438'),'pa':u('\u0a2d\u0a3e\u0a30\u0a24'),'pi':'*aa','pl':'*cs','ps':'*fa','pt':'*ca','qu':'*aa','rm':'*aa','rn':'Ubuhindi','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u0646\u068a\u064a\u0627'),'se':'*aa','sg':u('\u00cannde'),'si':u('\u0d89\u0db1\u0dca\u0daf\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*aa','sl':'*bs','sm':'*aa','sn':'*aa','so':'Hindiya','sq':'Indi','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':u('\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf\u0bbe'),'te':u('\u0c2d\u0c3e\u0c30\u0c24\u0c26\u0c47\u0c36\u0c02'),'tg':u('\u04b2\u0438\u043d\u0434\u0443\u0441\u0442\u043e\u043d'),'th':u('\u0e2d\u0e34\u0e19\u0e40\u0e14\u0e35\u0e22'),'ti':u('\u1205\u1295\u12f2'),'tk':'*az','tl':'*aa','tn':'*aa','to':u('\u02bbInitia'),'tr':'*az','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u06be\u0649\u0646\u062f\u0649\u0633\u062a\u0627\u0646'),'uk':u('\u0406\u043d\u0434\u0456\u044f'),'ur':u('\u0628\u06be\u0627\u0631\u062a'),'uz':'Hindiston','ve':'*aa','vi':u('\u1ea4n \u0110\u1ed9'),'vo':'*aa','wa':'*aa','wo':'End','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de India'),'za':'*aa','zh':u('\u5370\u5ea6'),'zu':'i-India',},
  'IO': {'aa':'British Indian Ocean Territory','ab':'*aa','ae':'*aa','af':'Brits-Indiese Oseaangebied','ak':u('Britenfo H\u0254n Man W\u0254 India Po No Mu'),'am':u('\u12e8\u1265\u122a\u1273\u1292\u12eb \u1205\u1295\u12f5 \u12cd\u1242\u12eb\u1296\u1235 \u130d\u12db\u1275'),'an':'*aa','ar':u('\u0627\u0644\u0625\u0642\u0644\u064a\u0645 \u0627\u0644\u0628\u0631\u064a\u0637\u0627\u0646\u064a \u0641\u064a \u0627\u0644\u0645\u062d\u064a\u0637 \u0627\u0644\u0647\u0646\u062f\u064a'),'as':u('\u09ac\u09cd\u09f0\u09bf\u099f\u09bf\u099b \u0987\u09a3\u09cd\u09a1\u09bf\u09af\u09bc\u09be\u09a8 \u0985\u2019\u099a\u09a8 \u099f\u09c7\u09f0\u09bf\u099f\u2019\u09f0\u09bf'),'av':'*aa','ay':'*aa','az':u('Britaniyan\u0131n Hind Okean\u0131 \u018frazisi'),'ba':'*aa','be':u('\u0411\u0440\u044b\u0442\u0430\u043d\u0441\u043a\u0430\u044f \u0442\u044d\u0440\u044b\u0442\u043e\u0440\u044b\u044f \u045e \u0406\u043d\u0434\u044b\u0439\u0441\u043a\u0456\u043c \u0430\u043a\u0456\u044f\u043d\u0435'),'bg':u('\u0411\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0430 \u0442\u0435\u0440\u0438\u0442\u043e\u0440\u0438\u044f \u0432 \u0418\u043d\u0434\u0438\u0439\u0441\u043a\u0438\u044f \u043e\u043a\u0435\u0430\u043d'),'bh':'*aa','bi':'*aa','bm':u('Angil\u025b ka \u025bndu dugukolo'),'bn':u('\u09ac\u09cd\u09b0\u09bf\u099f\u09bf\u09b6 \u09ad\u09be\u09b0\u09a4 \u09ae\u09b9\u09be\u09b8\u09be\u0997\u09b0\u09c0\u09af\u09bc \u0985\u099e\u09cd\u099a\u09b2'),'bo':'*aa','br':'Tiriad breizhveurat Meurvor Indez','bs':'Britanska Teritorija u Indijskom Okeanu','ca':u('Territori Brit\u00e0nic de l\u2019Oce\u00e0 \u00cdndic'),'ce':u('\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u043d \u043b\u0430\u0442\u0442\u0430 \u0418\u043d\u0434\u0438\u043d \u043e\u043a\u0435\u0430\u043d\u0435\u0445\u044c'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Britsk\u00e9 indickooce\u00e1nsk\u00e9 \u00fazem\u00ed'),'cu':'*aa','cv':'*aa','cy':'Tiriogaeth Brydeinig Cefnfor India','da':'Det britiske territorium i Det Indiske Ocean','de':'Britisches Territorium im Indischen Ozean','dv':'*aa','dz':u('\u0f56\u0fb2\u0f72\u0f0b\u0f4a\u0f72\u0f64\u0f0b\u0f62\u0f92\u0fb1\u0f0b\u0f42\u0f62\u0f0b\u0f42\u0fb1\u0f72\u0f0b\u0f62\u0f92\u0fb1\u0f0b\u0f58\u0f5a\u0f7c\u0f0b\u0f66\u0f0b\u0f41\u0f7c\u0f44\u0f66'),'ee':u('Britaint\u0254wo \u0192e india \u0192udome nutome'),'el':u('\u0392\u03c1\u03b5\u03c4\u03b1\u03bd\u03b9\u03ba\u03ac \u0395\u03b4\u03ac\u03c6\u03b7 \u0399\u03bd\u03b4\u03b9\u03ba\u03bf\u03cd \u03a9\u03ba\u03b5\u03b1\u03bd\u03bf\u03cd'),'en':'*aa','eo':'Brita Hindoceana Teritorio','es':u('Territorio Brit\u00e1nico del Oc\u00e9ano \u00cdndico'),'et':'Briti India ookeani ala','eu':'Indiako Ozeanoko lurralde britainiarra','fa':u('\u0642\u0644\u0645\u0631\u0648 \u0628\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627 \u062f\u0631 \u0627\u0642\u06cc\u0627\u0646\u0648\u0633 \u0647\u0646\u062f'),'ff':'Keeriindi britaani to maayo enndo','fi':u('Brittil\u00e4inen Intian valtameren alue'),'fj':'*aa','fo':u('St\u00f3ra Bretlands Indiahavoyggjar'),'fr':u('Territoire britannique de l\u2019oc\u00e9an Indien'),'fy':'Britse Gebieden yn de Indyske Oseaan','ga':u('Cr\u00edoch Aig\u00e9an Indiach na Breataine'),'gd':'Ranntair Breatannach Cuan nan Innseachan','gl':u('Territorio Brit\u00e1nico do Oc\u00e9ano \u00cdndico'),'gn':'*aa','gu':u('\u0aac\u0acd\u0ab0\u0abf\u0a9f\u0abf\u0ab6 \u0a87\u0aa8\u0acd\u0aa1\u0abf\u0aaf\u0aa8 \u0a93\u0ab6\u0aa8 \u0a9f\u0ac7\u0ab0\u0abf\u0a9f\u0ab0\u0ac0'),'gv':'*aa','ha':'Yankin Birtaniya Na Tekun Indiya','he':u('\u05d4\u05d8\u05e8\u05d9\u05d8\u05d5\u05e8\u05d9\u05d4 \u05d4\u05d1\u05e8\u05d9\u05d8\u05d9\u05ea \u05d1\u05d0\u05d5\u05e7\u05d9\u05d9\u05e0\u05d5\u05e1 \u05d4\u05d4\u05d5\u05d3\u05d9'),'hi':u('\u092c\u094d\u0930\u093f\u091f\u093f\u0936 \u0939\u093f\u0902\u0926 \u092e\u0939\u093e\u0938\u093e\u0917\u0930\u0940\u092f \u0915\u094d\u0937\u0947\u0924\u094d\u0930'),'ho':'*aa','hr':'Britanski Indijskooceanski teritorij','ht':'*aa','hu':u('Brit Indiai-\u00f3ce\u00e1ni Ter\u00fclet'),'hy':u('\u0532\u0580\u056b\u057f\u0561\u0576\u0561\u056f\u0561\u0576 \u054f\u0561\u0580\u0561\u056e\u0584 \u0540\u0576\u0564\u056f\u0561\u056f\u0561\u0576 \u0555\u057e\u056f\u056b\u0561\u0576\u0578\u057d\u0578\u0582\u0574'),'hz':'*aa','ia':'*aa','id':'Wilayah Inggris di Samudra Hindia','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'Bresku Indlandshafseyjar','it':u('Territorio britannico dell\u2019Oceano Indiano'),'iu':'*aa','iw':'*he','ja':u('\u82f1\u9818\u30a4\u30f3\u30c9\u6d0b\u5730\u57df'),'ji':'*aa','jv':'*aa','ka':u('\u10d1\u10e0\u10d8\u10e2\u10d0\u10dc\u10d4\u10d7\u10d8\u10e1 \u10e2\u10d4\u10e0\u10d8\u10e2\u10dd\u10e0\u10d8\u10d0 \u10d8\u10dc\u10d3\u10dd\u10d4\u10d7\u10d8\u10e1 \u10dd\u10d9\u10d4\u10d0\u10dc\u10d4\u10e8\u10d8'),'kg':'*aa','ki':'Eneo la Uingereza katika Bahari Hindi','kj':'*aa','kk':u('\u04ae\u043d\u0434\u0456 \u043c\u04b1\u0445\u0438\u0442\u044b\u043d\u0434\u0430\u0493\u044b \u0411\u0440\u0438\u0442\u0430\u043d \u0430\u0439\u043c\u0430\u0493\u044b'),'kl':'*aa','km':u('\u178a\u17c2\u1793\u178a\u17b8\u200b\u17a2\u1784\u17cb\u1782\u17d2\u179b\u17c1\u179f\u200b\u1793\u17c5\u200b\u1798\u17a0\u17b6\u200b\u179f\u1798\u17bb\u1791\u17d2\u179a\u200b\u17a5\u178e\u17d2\u178c\u17b6'),'kn':u('\u0cac\u0ccd\u0cb0\u0cbf\u0c9f\u0cc0\u0cb7\u0ccd \u0cb9\u0cbf\u0c82\u0ca6\u0cc2 \u0cae\u0cb9\u0cbe\u0cb8\u0cbe\u0c97\u0cb0\u0ca6 \u0caa\u0ccd\u0cb0\u0ca6\u0cc7\u0cb6'),'ko':u('\uc601\uad6d\ub839 \uc778\ub3c4\uc591 \uc2dd\ubbfc\uc9c0'),'kr':'*aa','ks':u('\u0628\u0631\u0637\u0627\u0646\u0648\u06cc \u0628\u062d\u0631\u0650 \u06c1\u0650\u0646\u065b\u062f\u06cd \u0639\u0644\u0627\u0642\u06c1\u0655'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0418\u043d\u0434\u0438 \u043e\u043a\u0435\u0430\u043d\u044b\u043d\u0434\u0430\u0433\u044b \u0411\u0440\u0438\u0442\u0430\u043d \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044f\u0441\u044b'),'la':'*aa','lb':'Britescht Territorium am Indeschen Ozean','lg':u('Bizinga by\u2019eCago'),'li':'*aa','ln':u('Mabel\u00e9 ya Ang\u025bl\u025bt\u025b\u0301l\u025b na mb\u00fa ya Indiya'),'lo':u('\u0ec0\u0e82\u0e94\u0ec1\u0e94\u0e99\u0ead\u0eb1\u0e87\u0e81\u0eb4\u0e94\u0ec3\u0e99\u0ea1\u0eb0\u0eab\u0eb2\u0eaa\u0eb0\u0ea1\u0eb8\u0e94\u0ead\u0eb4\u0e99\u0ec0\u0e94\u0e8d'),'lt':u('Indijos Vandenyno Brit\u0173 Sritis'),'lu':'Lutanda lwa Angeletele ku mbu wa Indiya','lv':u('Indijas oke\u0101na Britu teritorija'),'mg':'Faridranomasina indiana britanika','mh':'*aa','mi':'*aa','mk':u('\u0411\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0430 \u0418\u043d\u0434\u043e\u043e\u043a\u0435\u0430\u043d\u0441\u043a\u0430 \u0422\u0435\u0440\u0438\u0442\u043e\u0440\u0438\u0458\u0430'),'ml':u('\u0d2c\u0d4d\u0d30\u0d3f\u0d1f\u0d4d\u0d1f\u0d40\u0d37\u0d4d \u0d07\u0d28\u0d4d\u0d24\u0d4d\u0d2f\u0d7b \u0d2e\u0d39\u0d3e\u0d38\u0d2e\u0d41\u0d26\u0d4d\u0d30 \u0d2a\u0d4d\u0d30\u0d26\u0d47\u0d36\u0d02'),'mn':u('\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u0439\u043d \u0445\u0430\u0440\u044c\u044f\u0430 \u042d\u043d\u044d\u0442\u0445\u044d\u0433\u0438\u0439\u043d \u0434\u0430\u043b\u0430\u0439 \u0434\u0430\u0445\u044c \u043d\u0443\u0442\u0430\u0433 \u0434\u044d\u0432\u0441\u0433\u044d\u0440'),'mo':'Teritoriul Britanic din Oceanul Indian','mr':u('\u092c\u094d\u0930\u093f\u091f\u093f\u0936 \u0939\u093f\u0902\u0926\u0940 \u092e\u0939\u093e\u0938\u093e\u0917\u0930 \u0915\u094d\u0937\u0947\u0924\u094d\u0930'),'ms':'Wilayah Lautan Hindi British','mt':u('Territorju Brittaniku tal-O\u010bean Indjan'),'my':u('\u1017\u103c\u102d\u1010\u102d\u101e\u103b\u103e\u1015\u102d\u102f\u1004\u103a \u1021\u102d\u1014\u1039\u1012\u102d\u101a\u101e\u1019\u102f\u1012\u1039\u1012\u101b\u102c\u1000\u103b\u103d\u1014\u103a\u1038\u1019\u103b\u102c\u1038'),'na':'*aa','nb':'Det britiske territoriet i Indiahavet','nd':'*aa','ne':u('\u092c\u0947\u0932\u093e\u092f\u0924\u0940 \u0939\u093f\u0928\u094d\u0926 \u092e\u0939\u093e\u0938\u093e\u0917\u0930 \u0915\u094d\u0937\u0947\u0924\u094d\u0930'),'ng':'*aa','nl':'Brits Indische Oceaanterritorium','nn':'Det britiske territoriet I Indiahavet','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2c\u0b4d\u0b30\u0b3f\u0b1f\u0b3f\u0b36\u0b4d\u200c \u0b2d\u0b3e\u0b30\u0b24 \u0b2e\u0b3e\u0b39\u0b3e\u0b38\u0b3e\u0b17\u0b30 \u0b15\u0b4d\u0b37\u0b47\u0b24\u0b4d\u0b30'),'os':'*aa','pa':u('\u0a2c\u0a30\u0a24\u0a3e\u0a28\u0a35\u0a40 \u0a39\u0a3f\u0a70\u0a26 \u0a2e\u0a39\u0a3e\u0a02\u0a38\u0a3e\u0a17\u0a30 \u0a16\u0a3f\u0a71\u0a24\u0a3e'),'pi':'*aa','pl':'Brytyjskie Terytorium Oceanu Indyjskiego','ps':u('\u062f \u0647\u0646\u062f \u0633\u0645\u0646\u062f\u0631 \u0633\u0645\u0646\u062f\u0631 \u0633\u06cc\u0645\u0647'),'pt':u('Territ\u00f3rio Brit\u00e2nico do Oceano \u00cdndico'),'qu':'*aa','rm':u('Territori Britannic en l\u2019Ocean Indic'),'rn':u('Intara y\u2019Ubwongereza yo mu birwa by\u2019Abahindi'),'ro':'*mo','ru':u('\u0411\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0430\u044f \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044f \u0432 \u0418\u043d\u0434\u0438\u0439\u0441\u043a\u043e\u043c \u043e\u043a\u0435\u0430\u043d\u0435'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0628\u0631\u0637\u0627\u0646\u0648\u064a \u0647\u0646\u062f\u064a \u0633\u0645\u0646\u068a \u062e\u0637\u0648'),'se':'*aa','sg':u('S\u00ease t\u00ee Angl\u00ebe na Ng\u00fby\u00e4m\u00e4 t\u00ee \u00cannde'),'si':u('\u0db6\u0dca\u200d\u0dbb\u0dd2\u0dad\u0dcf\u0db1\u0dca\u200d\u0dba \u0d89\u0db1\u0dca\u0daf\u0dd3\u0dba \u0dc3\u0dcf\u0d9c\u0dbb \u0db6\u0dbd \u0db4\u0dca\u200d\u0dbb\u0daf\u0dda\u0dc1\u0dba'),'sk':u('Britsk\u00e9 indickooce\u00e1nske \u00fazemie'),'sl':'Britansko ozemlje v Indijskem oceanu','sm':'*aa','sn':'*aa','so':'*aa','sq':'Territori Britanik i Oqeanit Indian','sr':u('\u0411\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0430 \u0442\u0435\u0440\u0438\u0442\u043e\u0440\u0438\u0458\u0430 \u0418\u043d\u0434\u0438\u0458\u0441\u043a\u043e\u0433 \u043e\u043a\u0435\u0430\u043d\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Brittiska territoriet i Indiska oceanen','sw':'*ki','ta':u('\u0baa\u0bbf\u0bb0\u0bbf\u0b9f\u0bcd\u0b9f\u0bbf\u0bb7\u0bcd \u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf\u0baa\u0bcd \u0baa\u0bc6\u0bb0\u0bc1\u0b99\u0bcd\u0b95\u0b9f\u0bb2\u0bcd \u0baa\u0bbf\u0bb0\u0ba4\u0bc7\u0b9a\u0bae\u0bcd'),'te':u('\u0c2c\u0c4d\u0c30\u0c3f\u0c1f\u0c40\u0c37\u0c4d \u0c39\u0c3f\u0c02\u0c26\u0c42 \u0c2e\u0c39\u0c3e\u0c38\u0c2e\u0c41\u0c26\u0c4d\u0c30 \u0c2a\u0c4d\u0c30\u0c3e\u0c02\u0c24\u0c02'),'tg':u('\u049a\u0430\u043b\u0430\u043c\u0440\u0430\u0432\u0438 \u0411\u0440\u0438\u0442\u0430\u043d\u0438\u044f \u0434\u0430\u0440 \u0443\u049b\u0451\u043d\u0443\u0441\u0438 \u04b2\u0438\u043d\u0434'),'th':u('\u0e1a\u0e23\u0e34\u0e15\u0e34\u0e0a\u0e2d\u0e34\u0e19\u0e40\u0e14\u0e35\u0e22\u0e19\u0e42\u0e2d\u0e40\u0e0a\u0e35\u0e22\u0e19\u0e40\u0e17\u0e23\u0e4c\u0e23\u0e34\u0e17\u0e2d\u0e23\u0e35'),'ti':u('\u1293\u12ed \u1265\u122a\u1323\u1295\u12eb \u1205\u1295\u12f3\u12ca \u12cd\u1245\u12eb\u1296\u1235 \u130d\u12dd\u12a3\u1275'),'tk':u('Britani\u00fdany\u0148 Hint okeanyndaky territori\u00fdalary'),'tl':'*aa','tn':'*aa','to':u('Potu fonua moana \u02bbInitia fakapilit\u0101nia'),'tr':u('Britanya Hint Okyanusu Topraklar\u0131'),'ts':'*aa','tt':u('\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u044f\u043d\u0435\u04a3 \u04ba\u0438\u043d\u0434 \u041e\u043a\u0435\u0430\u043d\u044b\u043d\u0434\u0430\u0433\u044b \u0422\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044f\u0441\u0435'),'tw':'*aa','ty':'*aa','ug':u('\u0626\u06d5\u0646\u06af\u0644\u0649\u064a\u06d5\u06af\u06d5 \u0642\u0627\u0631\u0627\u0634\u0644\u0649\u0642 \u06be\u0649\u0646\u062f\u0649 \u0626\u0648\u0643\u064a\u0627\u0646 \u062a\u06d0\u0631\u0631\u0649\u062a\u0648\u0631\u0649\u064a\u06d5\u0633\u0649'),'uk':u('\u0411\u0440\u0438\u0442\u0430\u043d\u0441\u044c\u043a\u0430 \u0442\u0435\u0440\u0438\u0442\u043e\u0440\u0456\u044f \u0432 \u0406\u043d\u0434\u0456\u0439\u0441\u044c\u043a\u043e\u043c\u0443 \u041e\u043a\u0435\u0430\u043d\u0456'),'ur':u('\u0628\u0631\u0637\u0627\u0646\u0648\u06cc \u0628\u062d\u0631 \u06c1\u0646\u062f \u06a9\u0627 \u0639\u0644\u0627\u0642\u06c1'),'uz':'Britaniyaning Hind okeanidagi hududi','ve':'*aa','vi':u('L\u00e3nh th\u1ed5 \u1ea4n \u0111\u1ed9 d\u01b0\u01a1ng thu\u1ed9c Anh'),'vo':'*aa','wa':'*aa','wo':u('Terituwaaru Br\u00ebtaa\u00f1 ci Oseyaa Enje\u014b'),'xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Et\u00edkun \u00cdnd\u00ed\u00e1n\u00ec ti \u00ccl\u00fa B\u00edr\u00edt\u00eds\u00ec'),'za':'*aa','zh':u('\u82f1\u5c5e\u5370\u5ea6\u6d0b\u9886\u5730'),'zu':'i-British Indian Ocean Territory',},
  'IQ': {'aa':'Iraq','ab':'*aa','ae':'*aa','af':'Irak','ak':'*af','am':u('\u12a2\u122b\u1245'),'an':'*aa','ar':u('\u0627\u0644\u0639\u0631\u0627\u0642'),'as':u('\u0987\u09f0\u09be\u0995'),'av':'*aa','ay':'*aa','az':u('\u0130raq'),'ba':'*aa','be':u('\u0406\u0440\u0430\u043a'),'bg':u('\u0418\u0440\u0430\u043a'),'bh':'*aa','bi':'*aa','bm':'Iraki','bn':u('\u0987\u09b0\u09be\u0995'),'bo':'*aa','br':'*aa','bs':'*af','ca':'*aa','ce':u('\u04c0\u0438\u0440\u0430\u043a\u044a'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Ir\u00e1k'),'cu':'*aa','cv':'*aa','cy':'Irac','da':'*af','de':'*af','dv':'*aa','dz':u('\u0f68\u0f72\u0f0b\u0f62\u0f71\u0f40'),'ee':u('iraqduk\u0254'),'el':u('\u0399\u03c1\u03ac\u03ba'),'en':'*aa','eo':'Irako','es':'*af','et':'Iraak','eu':'*af','fa':u('\u0639\u0631\u0627\u0642'),'ff':'*et','fi':'*af','fj':'*aa','fo':'*af','fr':'*af','fy':'*af','ga':u('an Iar\u00e1ic'),'gd':u('Ior\u00e0c'),'gl':'*aa','gn':'*aa','gu':u('\u0a87\u0ab0\u0abe\u0a95'),'gv':'*aa','ha':u('Ira\u0199i'),'he':u('\u05e2\u05d9\u05e8\u05d0\u05e7'),'hi':u('\u0907\u0930\u093e\u0915'),'ho':'*aa','hr':'*af','ht':'*aa','hu':'*af','hy':u('\u053b\u0580\u0561\u0584'),'hz':'*aa','ia':'*aa','id':'*af','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*af','io':'*aa','is':u('\u00cdrak'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30a4\u30e9\u30af'),'ji':'*aa','jv':'*aa','ka':u('\u10d4\u10e0\u10d0\u10e7\u10d8'),'kg':'*aa','ki':'*bm','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a2\u17ca\u17b8\u179a\u17c9\u17b6\u1780\u17cb'),'kn':u('\u0c87\u0cb0\u0cbe\u0c95\u0ccd'),'ko':u('\uc774\ub77c\ud06c'),'kr':'*aa','ks':u('\u0627\u06cc\u0656\u0631\u0627\u0642'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*af','lg':'Yiraaka','li':'*aa','ln':'*bm','lo':u('\u0ead\u0eb5\u0ea3\u0eb1\u0e81'),'lt':'Irakas','lu':'*bm','lv':u('Ir\u0101ka'),'mg':'*af','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d07\u0d31\u0d3e\u0d16\u0d4d'),'mn':'*bg','mo':'*af','mr':'*hi','ms':'*aa','mt':'l-Iraq','my':u('\u1021\u102e\u101b\u1010\u103a'),'na':'*aa','nb':'*af','nd':'*bm','ne':'*hi','ng':'*aa','nl':'*af','nn':'*af','no':'*af','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b07\u0b30\u0b3e\u0b15\u0b4d'),'os':'*aa','pa':u('\u0a07\u0a30\u0a3e\u0a15'),'pi':'*aa','pl':'*af','ps':'*fa','pt':'Iraque','qu':'*af','rm':'*cy','rn':'*bm','ro':'*af','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*fa','se':'*af','sg':u('Ir\u00e2ki'),'si':u('\u0d89\u0dbb\u0dcf\u0d9a\u0dba'),'sk':'*af','sl':'*af','sm':'*aa','sn':'*aa','so':'Ciraaq','sq':'*af','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*af','sw':'*bm','ta':u('\u0b88\u0bb0\u0bbe\u0b95\u0bcd'),'te':u('\u0c07\u0c30\u0c3e\u0c15\u0c4d'),'tg':u('\u0418\u0440\u043e\u049b'),'th':u('\u0e2d\u0e34\u0e23\u0e31\u0e01'),'ti':'*am','tk':'Yrak','tl':'*aa','tn':'*aa','to':u('\u02bbIlaaki'),'tr':'*af','ts':'*aa','tt':u('\u0413\u044b\u0439\u0440\u0430\u043a'),'tw':'*aa','ty':'*aa','ug':u('\u0626\u0649\u0631\u0627\u0642'),'uk':'*be','ur':'*fa','uz':'Iroq','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Irag','xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Iraki'),'za':'*aa','zh':u('\u4f0a\u62c9\u514b'),'zu':'i-Iraq',},
  'IR': {'aa':'Iran','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u12a2\u122b\u1295'),'an':'*aa','ar':u('\u0625\u064a\u0631\u0627\u0646'),'as':u('\u0987\u09f0\u09be\u09a8'),'av':'*aa','ay':'*aa','az':u('\u0130ran'),'ba':'*aa','be':u('\u0406\u0440\u0430\u043d'),'bg':u('\u0418\u0440\u0430\u043d'),'bh':'*aa','bi':'*aa','bm':u('Ira\u014b'),'bn':u('\u0987\u09b0\u09be\u09a8'),'bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':u('\u0413\u04c0\u0430\u0436\u0430\u0440\u0438\u0439\u0447\u043e\u044c'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('\u00cdr\u00e1n'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f68\u0f72\u0f0b\u0f62\u0f71\u0f53'),'ee':'Iran nutome','el':u('\u0399\u03c1\u03ac\u03bd'),'en':'*aa','eo':'Irano','es':u('Ir\u00e1n'),'et':'Iraan','eu':'*aa','fa':u('\u0627\u06cc\u0631\u0627\u0646'),'ff':'*et','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('an Iar\u00e1in'),'gd':u('Ior\u00e0n'),'gl':'*es','gn':'*aa','gu':u('\u0a88\u0ab0\u0abe\u0aa8'),'gv':'*aa','ha':'*aa','he':u('\u05d0\u05d9\u05e8\u05d0\u05df'),'hi':u('\u0908\u0930\u093e\u0928'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*es','hy':u('\u053b\u0580\u0561\u0576'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('\u00cdran'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30a4\u30e9\u30f3'),'ji':u('\u05d0\u05d9\u05e8\u05d0\u05b7\u05df'),'jv':'*aa','ka':u('\u10d8\u10e0\u10d0\u10dc\u10d8'),'kg':'*aa','ki':'Uajemi','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a2\u17ca\u17b8\u179a\u17c9\u1784\u17cb'),'kn':u('\u0c87\u0cb0\u0cbe\u0ca8\u0ccd'),'ko':u('\uc774\ub780'),'kr':'*aa','ks':u('\u0627\u06cc\u0656\u0631\u0627\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'Yiraani','li':'*aa','ln':u('Ir\u00e2'),'lo':u('\u0ead\u0eb5\u0ea3\u0eb2\u0e99'),'lt':'Iranas','lu':'Ira','lv':u('Ir\u0101na'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d07\u0d31\u0d3e\u0d7b'),'mn':'*bg','mo':'*aa','mr':u('\u0907\u0930\u093e\u0923'),'ms':'*aa','mt':'l-Iran','my':u('\u1021\u102e\u101b\u1014\u103a'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0907\u0930\u093e\u0928'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b07\u0b30\u0b3e\u0b28'),'os':'*aa','pa':u('\u0a08\u0a30\u0a3e\u0a28'),'pi':'*aa','pl':'*aa','ps':u('\u0627\u064a\u0631\u0627\u0646'),'pt':u('Ir\u00e3'),'qu':'*es','rm':'*aa','rn':'Irani','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*ps','se':'*aa','sg':u('Ir\u00e4an'),'si':u('\u0d89\u0dbb\u0dcf\u0db1\u0dba'),'sk':'*es','sl':'*aa','sm':'*aa','sn':'*aa','so':'Iiraan','sq':'*aa','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b88\u0bb0\u0bbe\u0ba9\u0bcd'),'te':u('\u0c07\u0c30\u0c3e\u0c28\u0c4d'),'tg':u('\u042d\u0440\u043e\u043d'),'th':u('\u0e2d\u0e34\u0e2b\u0e23\u0e48\u0e32\u0e19'),'ti':'*am','tk':u('E\u00fdran'),'tl':'*aa','tn':'*aa','to':u('\u02bbIlaani'),'tr':'*az','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0626\u0649\u0631\u0627\u0646'),'uk':'*be','ur':'*fa','uz':'Eron','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*bm','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Irani'),'za':'*aa','zh':u('\u4f0a\u6717'),'zu':'i-Iran',},
  'IS': {'aa':'Iceland','ab':'*aa','ae':'*aa','af':'Ysland','ak':'Aesland','am':u('\u12a0\u12ed\u1235\u120b\u1295\u12f5'),'an':'*aa','ar':u('\u0622\u064a\u0633\u0644\u0646\u062f\u0627'),'as':u('\u0986\u0987\u099a\u09b2\u09c7\u09a3\u09cd\u09a1'),'av':'*aa','ay':'*aa','az':u('\u0130slandiya'),'ba':'*aa','be':u('\u0406\u0441\u043b\u0430\u043d\u0434\u044b\u044f'),'bg':u('\u0418\u0441\u043b\u0430\u043d\u0434\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Isilandi','bn':u('\u0986\u0987\u09b8\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1'),'bo':'*aa','br':'Island','bs':'*br','ca':u('Isl\u00e0ndia'),'ce':u('\u0418\u0441\u043b\u0430\u043d\u0434\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*br','cu':'*aa','cv':'*aa','cy':u('Gwlad yr I\u00e2'),'da':'*br','de':'*br','dv':'*aa','dz':u('\u0f68\u0f71\u0f60\u0f72\u0f66\u0f0b\u0f63\u0f7a\u0f53\u0f4c'),'ee':'Aiseland nutome','el':u('\u0399\u03c3\u03bb\u03b1\u03bd\u03b4\u03af\u03b1'),'en':'*aa','eo':'Islando','es':'Islandia','et':'*br','eu':'*es','fa':u('\u0627\u06cc\u0633\u0644\u0646\u062f'),'ff':'Islannda','fi':'Islanti','fj':'*aa','fo':u('\u00cdsland'),'fr':'Islande','fy':u('Ysl\u00e2n'),'ga':u('an \u00cdoslainn'),'gd':u('Innis T\u00ecle'),'gl':'*es','gn':'*aa','gu':u('\u0a86\u0a87\u0ab8\u0ab2\u0ac7\u0aa8\u0acd\u0aa1'),'gv':'*aa','ha':'Aisalan','he':u('\u05d0\u05d9\u05e1\u05dc\u05e0\u05d3'),'hi':u('\u0906\u0907\u0938\u0932\u0948\u0902\u0921'),'ho':'*aa','hr':'*br','ht':'*aa','hu':'Izland','hy':u('\u053b\u057d\u056c\u0561\u0576\u0564\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*es','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*es','io':'*aa','is':'*fo','it':'Islanda','iu':'*aa','iw':'*he','ja':u('\u30a2\u30a4\u30b9\u30e9\u30f3\u30c9'),'ji':u('\u05d0\u05d9\u05e1\u05dc\u05d0\u05b7\u05e0\u05d3'),'jv':'*aa','ka':u('\u10d8\u10e1\u10da\u10d0\u10dc\u10d3\u10d8\u10d0'),'kg':'*aa','ki':'Aislandi','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a2\u17ca\u17b8\u179f\u17d2\u179b\u1784\u17cb'),'kn':u('\u0c90\u0cb8\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd'),'ko':u('\uc544\uc774\uc2ac\ub780\ub4dc'),'kr':'*aa','ks':u('\u0627\u064e\u06cc\u0650\u0633\u0644\u06cc\u0646\u065b\u0691'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*br','lg':'Ayisirandi','li':'*aa','ln':u('Isiland\u025b'),'lo':u('\u0ec4\u0ead\u0eaa\u0ec1\u0ea5\u0e99'),'lt':'Islandija','lu':'Isilande','lv':'*fr','mg':'Islandy','mh':'*aa','mi':'*aa','mk':u('\u0418\u0441\u043b\u0430\u043d\u0434'),'ml':u('\u0d10\u0d38\u0d4d\u200c\u0d32\u0d3e\u0d28\u0d4d\u0d31\u0d4d'),'mn':'*mk','mo':'*it','mr':u('\u0906\u0907\u0938\u0932\u0901\u0921'),'ms':'*aa','mt':u('l-i\u017clanda'),'my':u('\u1021\u102d\u102f\u1000\u103a\u1005\u101c\u1014\u103a'),'na':'*aa','nb':'*br','nd':'*aa','ne':u('\u0906\u0907\u0938\u094d\u0932\u094d\u092f\u093e\u0923\u094d\u0921'),'ng':'*aa','nl':'IJsland','nn':'*br','no':'*br','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b06\u0b07\u0b38\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21'),'os':'*aa','pa':u('\u0a06\u0a08\u0a38\u0a32\u0a48\u0a02\u0a21'),'pi':'*aa','pl':'*es','ps':u('\u0622\u06cc\u0633\u0644\u06cc\u0646\u0689'),'pt':u('Isl\u00e2ndia'),'qu':'*es','rm':'*it','rn':'Ayisilandi','ro':'*it','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0622\u0626\u0633 \u0644\u064a\u0646\u068a'),'se':u('Isl\u00e1nda'),'sg':u('Isl\u00e2nde'),'si':u('\u0d85\u0dba\u0dd2\u0dc3\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba'),'sk':'*br','sl':'*lt','sm':'*aa','sn':'*aa','so':'Iislaand','sq':u('Island\u00eb'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*br','sw':'*ki','ta':u('\u0b90\u0bb8\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1'),'te':u('\u0c10\u0c38\u0c4d\u0c32\u0c3e\u0c02\u0c21\u0c4d'),'tg':'*bg','th':u('\u0e44\u0e2d\u0e0b\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c'),'ti':'*am','tk':u('Islandi\u00fda'),'tl':'*aa','tn':'*aa','to':u('\u02bbAisilani'),'tr':u('\u0130zlanda'),'ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0626\u0649\u0633\u0644\u0627\u0646\u062f\u0649\u064a\u06d5'),'uk':u('\u0406\u0441\u043b\u0430\u043d\u0434\u0456\u044f'),'ur':u('\u0622\u0626\u0633 \u0644\u06cc\u0646\u0688'),'uz':'Islandiya','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':u('Isl\u00e0nd'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de A\u1e63ilandi'),'za':'*aa','zh':u('\u51b0\u5c9b'),'zu':'i-Iceland',},
  'IT': {'aa':'Italy','ab':'*aa','ae':'*aa','af':u('Itali\u00eb'),'ak':'Itali','am':u('\u1323\u120a\u12eb\u1295'),'an':'*aa','ar':u('\u0625\u064a\u0637\u0627\u0644\u064a\u0627'),'as':u('\u0987\u099f\u09be\u09b2\u09bf'),'av':'*aa','ay':'*aa','az':u('\u0130taliya'),'ba':'*aa','be':u('\u0406\u0442\u0430\u043b\u0456\u044f'),'bg':u('\u0418\u0442\u0430\u043b\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'*ak','bn':u('\u0987\u09a4\u09be\u09b2\u09bf'),'bo':u('\u0f68\u0f72\u0f0b\u0f40\u0fb2\u0f62\u0f0b\u0f63\u0f72\u0f0b'),'br':'Italia','bs':'Italija','ca':u('It\u00e0lia'),'ce':u('\u0418\u0442\u0430\u043b\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('It\u00e1lie'),'cu':'*aa','cv':'*aa','cy':'Yr Eidal','da':'Italien','de':'*da','dv':'*aa','dz':u('\u0f68\u0f72\u0f0b\u0f4a\u0f0b\u0f63\u0f72'),'ee':'Italia nutome','el':u('\u0399\u03c4\u03b1\u03bb\u03af\u03b1'),'en':'*aa','eo':'Italujo','es':'*br','et':'Itaalia','eu':'*br','fa':u('\u0627\u06cc\u062a\u0627\u0644\u06cc\u0627'),'ff':'*ak','fi':'*br','fj':'*aa','fo':'*br','fr':'Italie','fy':'*af','ga':u('an Iod\u00e1il'),'gd':'An Eadailt','gl':'*br','gn':'*aa','gu':u('\u0a87\u0a9f\u0abe\u0ab2\u0ac0'),'gv':'*aa','ha':'Italiya','he':u('\u05d0\u05d9\u05d8\u05dc\u05d9\u05d4'),'hi':u('\u0907\u091f\u0932\u0940'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Olaszorsz\u00e1g'),'hy':u('\u053b\u057f\u0561\u056c\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*br','ie':'*aa','ig':'*aa','ii':u('\ua474\ua10a\ua1ba'),'ik':'*aa','in':'*br','io':'*aa','is':u('\u00cdtal\u00eda'),'it':'*br','iu':'*aa','iw':'*he','ja':u('\u30a4\u30bf\u30ea\u30a2'),'ji':u('\u05d0\u05d9\u05d8\u05d0\u05b7\u05dc\u05d9\u05e2'),'jv':'*aa','ka':u('\u10d8\u10e2\u10d0\u10da\u10d8\u10d0'),'kg':'*aa','ki':'*br','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a2\u17ca\u17b8\u178f\u17b6\u179b\u17b8'),'kn':u('\u0c87\u0c9f\u0cb2\u0cbf'),'ko':u('\uc774\ud0c8\ub9ac\uc544'),'kr':'*aa','ks':u('\u0627\u0650\u0679\u0644\u06cc'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*da','lg':'Yitale','li':'*aa','ln':'*ak','lo':u('\u0ead\u0eb4\u0e95\u0eb2\u0ea5\u0eb5'),'lt':'*bs','lu':'*ak','lv':u('It\u0101lija'),'mg':'*br','mh':'*aa','mi':'*aa','mk':u('\u0418\u0442\u0430\u043b\u0438\u0458\u0430'),'ml':u('\u0d07\u0d31\u0d4d\u0d31\u0d32\u0d3f'),'mn':'*ce','mo':'*br','mr':'*hi','ms':'*ak','mt':'l-Italja','my':u('\u1021\u102e\u1010\u101c\u102e'),'na':'*aa','nb':'*br','nd':'*ak','ne':u('\u0907\u091f\u093e\u0932\u0940'),'ng':'*aa','nl':'*af','nn':'*br','no':'*br','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b07\u0b1f\u0b3e\u0b32\u0b40'),'os':'*ce','pa':u('\u0a07\u0a1f\u0a32\u0a40'),'pi':'*aa','pl':u('W\u0142ochy'),'ps':u('\u0627\u06cc\u067c\u0627\u0644\u06cc\u0647'),'pt':u('It\u00e1lia'),'qu':'*br','rm':'*br','rn':'Ubutaliyani','ro':'*br','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u067d\u0644\u064a'),'se':'*pt','sg':u('Ital\u00f9ii'),'si':u('\u0d89\u0dad\u0dcf\u0dbd\u0dd2\u0dba'),'sk':'Taliansko','sl':'*bs','sm':'*aa','sn':'*aa','so':'Talyaani','sq':'*ak','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*br','ta':u('\u0b87\u0ba4\u0bcd\u0ba4\u0bbe\u0bb2\u0bbf'),'te':u('\u0c07\u0c1f\u0c32\u0c40'),'tg':'*bg','th':u('\u0e2d\u0e34\u0e15\u0e32\u0e25\u0e35'),'ti':'*am','tk':u('Itali\u00fda'),'tl':'*aa','tn':'*aa','to':u('\u02bb\u012atali'),'tr':u('\u0130talya'),'ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0626\u0649\u062a\u0627\u0644\u0649\u064a\u06d5'),'uk':'*be','ur':u('\u0627\u0679\u0644\u06cc'),'uz':'*ha','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*ak','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Italiyi'),'za':'*aa','zh':u('\u610f\u5927\u5229'),'zu':'i-Italy',},
  'JE': {'aa':'Jersey','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u1300\u122d\u1232'),'an':'*aa','ar':u('\u062c\u064a\u0631\u0633\u064a'),'as':u('\u099c\u09be\u09f0\u09cd\u099a\u09bf'),'av':'*aa','ay':'*aa','az':'Cersi','ba':'*aa','be':u('\u0414\u0436\u044d\u0440\u0441\u0456'),'bg':u('\u0414\u0436\u044a\u0440\u0441\u0438'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u099c\u09be\u09b0\u09cd\u09b8\u09bf'),'bo':'*aa','br':'Jerzenez','bs':'*aa','ca':'*aa','ce':u('\u0414\u0436\u0435\u0440\u0441\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f47\u0f7a\u0f62\u0f0b\u0f66\u0f72'),'ee':u('Dz\u025bse nutome'),'el':u('\u03a4\u03b6\u03ad\u03c1\u03b6\u03b9'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u062c\u0631\u0632\u06cc'),'ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Geirs\u00ed'),'gd':u('De\u00e0rsaidh'),'gl':'*aa','gn':'*aa','gu':u('\u0a9c\u0ab0\u0acd\u0ab8\u0ac0'),'gv':'*aa','ha':'*aa','he':u('\u05d2\u05f3\u05e8\u05d6\u05d9'),'hi':u('\u091c\u0930\u094d\u0938\u0940'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u054b\u0565\u0580\u057d\u056b'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30b8\u30e3\u30fc\u30b8\u30fc'),'ji':u('\u05d3\u05d6\u05e9\u05e2\u05e8\u05d6\u05d9'),'jv':'*aa','ka':u('\u10ef\u10d4\u10e0\u10e1\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u1787\u17ba\u179f\u17ca\u17b8'),'kn':u('\u0c9c\u0cc6\u0cb0\u0ccd\u0cb8\u0cbf'),'ko':u('\uc800\uc9c0'),'kr':'*aa','ks':u('\u062c\u0654\u0631\u0633\u06cc'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0416\u0435\u0440\u0441\u0438'),'la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0ec0\u0e88\u0eb5\u0e8a\u0eb5'),'lt':u('D\u017eersis'),'lu':'*aa','lv':u('D\u017e\u0113rsija'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u040f\u0435\u0440\u0441\u0438'),'ml':u('\u0d1c\u0d47\u0d34\u0d4d\u0d38\u0d3f'),'mn':'*ky','mo':'*aa','mr':'*hi','ms':'*aa','mt':'*aa','my':u('\u1002\u103b\u102c\u1005\u102e'),'na':'*aa','nb':'*aa','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b1c\u0b30\u0b4d\u0b38\u0b3f'),'os':'*aa','pa':u('\u0a1c\u0a30\u0a38\u0a40'),'pi':'*aa','pl':'*aa','ps':u('\u062c\u0631\u0633\u06cc'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u062c\u0631\u0633\u064a'),'se':'*aa','sg':'*aa','si':u('\u0da2\u0dbb\u0dca\u0dc3\u0dd2'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'Xhersej','sr':u('\u040f\u0435\u0440\u0437\u0438'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b9c\u0bc6\u0bb0\u0bcd\u0b9a\u0bbf'),'te':u('\u0c1c\u0c46\u0c30\u0c4d\u0c38\u0c40'),'tg':u('\u04b6\u0435\u0440\u0441\u0438'),'th':u('\u0e40\u0e08\u0e2d\u0e23\u0e4c\u0e0b\u0e35\u0e22\u0e4c'),'ti':'*am','tk':'Jersi','tl':'*aa','tn':'*aa','to':u('Selus\u012b'),'tr':'*aa','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u062c\u06d0\u0631\u0633\u06d0\u064a'),'uk':u('\u0414\u0436\u0435\u0440\u0441\u0456'),'ur':'*ps','uz':'*tk','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Serse','xh':'*aa','yi':'*ji','yo':'*aa','za':'*aa','zh':u('\u6cfd\u897f\u5c9b'),'zu':'i-Jersey',},
  'JM': {'aa':'Jamaica','ab':'*aa','ae':'*aa','af':'Jamaika','ak':'Gyameka','am':u('\u1303\u121b\u12ed\u12ab'),'an':'*aa','ar':u('\u062c\u0627\u0645\u0627\u064a\u0643\u0627'),'as':u('\u099c\u09be\u09ae\u09be\u0987\u0995\u09be'),'av':'*aa','ay':'*aa','az':'Yamayka','ba':'*aa','be':u('\u042f\u043c\u0430\u0439\u043a\u0430'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'Zamayiki','bn':'*as','bo':'*aa','br':'*af','bs':'Jamajka','ca':'*aa','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*bs','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*af','dv':'*aa','dz':u('\u0f47\u0f71\u0f0b\u0f58\u0f7b\u0f0b\u0f40'),'ee':'Dzamaika nutome','el':u('\u03a4\u03b6\u03b1\u03bc\u03ac\u03b9\u03ba\u03b1'),'en':'*aa','eo':'Jamajko','es':'*aa','et':'*aa','eu':'*af','fa':u('\u062c\u0627\u0645\u0627\u0626\u06cc\u06a9\u0627'),'ff':'Jamayka','fi':'*af','fj':'*aa','fo':'*af','fr':u('Jama\u00efque'),'fy':'*aa','ga':u('Iam\u00e1ice'),'gd':'Diameuga','gl':'Xamaica','gn':'*aa','gu':u('\u0a9c\u0aae\u0ac8\u0a95\u0abe'),'gv':'*aa','ha':'*af','he':u('\u05d2\u05f3\u05de\u05d9\u05d9\u05e7\u05d4'),'hi':u('\u091c\u092e\u0948\u0915\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u0543\u0561\u0574\u0561\u0575\u056f\u0561'),'hz':'*aa','ia':'*aa','id':'*af','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*af','io':'*aa','is':u('Jama\u00edka'),'it':'Giamaica','iu':'*aa','iw':'*he','ja':u('\u30b8\u30e3\u30de\u30a4\u30ab'),'ji':u('\u05d3\u05d6\u05e9\u05d0\u05b7\u05de\u05d9\u05d9\u05e7\u05e2'),'jv':'*aa','ka':u('\u10d8\u10d0\u10db\u10d0\u10d8\u10d9\u10d0'),'kg':'*aa','ki':'*af','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u17a0\u17d2\u179f\u17b6\u1798\u17c9\u17b6\u17a2\u17ca\u17b8\u1780'),'kn':u('\u0c9c\u0cae\u0cc8\u0c95\u0cbe'),'ko':u('\uc790\uba54\uc774\uce74'),'kr':'*aa','ks':u('\u062c\u064e\u0645\u0627\u06cc\u06a9\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*af','lg':'Jamayika','li':'*aa','ln':'Zamaiki','lo':u('\u0e88\u0eb2\u0ec4\u0ea1\u0e84\u0eb2'),'lt':'*af','lu':'Jamaiki','lv':'*af','mg':u('Jama\u00efka'),'mh':'*aa','mi':'*aa','mk':u('\u0408\u0430\u043c\u0430\u0458\u043a\u0430'),'ml':u('\u0d1c\u0d2e\u0d48\u0d15\u0d4d\u0d15'),'mn':'*be','mo':'*aa','mr':'*hi','ms':'*aa','mt':u('il-\u0120amajka'),'my':u('\u1002\u103b\u1019\u1031\u1000\u102c'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u091c\u092e\u093e\u0907\u0915\u093e'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b1c\u0b3e\u0b2e\u0b3e\u0b07\u0b15\u0b3e'),'os':'*aa','pa':u('\u0a1c\u0a2e\u0a3e\u0a07\u0a15\u0a3e'),'pi':'*aa','pl':'*bs','ps':u('\u062c\u0645\u06cc\u06a9\u0627'),'pt':'*aa','qu':'*aa','rm':'*it','rn':'*lg','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u062c\u0645\u064a\u06aa\u0627'),'se':'*aa','sg':u('Zama\u00eeka'),'si':u('\u0da2\u0dd0\u0db8\u0dd9\u0dba\u0dd2\u0d9a\u0dcf\u0dc0'),'sk':'*bs','sl':'*bs','sm':'*aa','sn':'*aa','so':'Jameyka','sq':u('Xhamajk\u00eb'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*af','ta':u('\u0b9c\u0bae\u0bc8\u0b95\u0bbe'),'te':u('\u0c1c\u0c2e\u0c48\u0c15\u0c3e'),'tg':'*be','th':u('\u0e08\u0e32\u0e40\u0e21\u0e01\u0e32'),'ti':'*am','tk':u('\u00ddama\u00fdka'),'tl':'*aa','tn':'*aa','to':'Samaika','tr':'*af','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u064a\u0627\u0645\u0627\u064a\u0643\u0627'),'uk':'*be','ur':u('\u062c\u0645\u0627\u0626\u06cc\u06a9\u0627'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Samayig','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Jamaika'),'za':'*aa','zh':u('\u7259\u4e70\u52a0'),'zu':'i-Jamaica',},
  'JO': {'aa':'Jordan','ab':'*aa','ae':'*aa','af':u('Jordani\u00eb'),'ak':u('Gy\u0254dan'),'am':u('\u1306\u122d\u12f3\u1295'),'an':'*aa','ar':u('\u0627\u0644\u0623\u0631\u062f\u0646'),'as':u('\u099c\u09f0\u09cd\u09a1\u09be\u09a8'),'av':'*aa','ay':'*aa','az':u('\u0130ordaniya'),'ba':'*aa','be':u('\u0406\u0430\u0440\u0434\u0430\u043d\u0456\u044f'),'bg':u('\u0419\u043e\u0440\u0434\u0430\u043d\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':u('Z\u0254rdani'),'bn':u('\u099c\u09b0\u09cd\u09a1\u09a8'),'bo':'*aa','br':'Jordania','bs':'*aa','ca':u('Jord\u00e0nia'),'ce':u('\u0423\u0440\u0434\u0430\u043d'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Jord\u00e1nsko'),'cu':'*aa','cv':'*aa','cy':'Gwlad Iorddonen','da':'*aa','de':'Jordanien','dv':'*aa','dz':u('\u0f47\u0f7c\u0f62\u0f0b\u0f4c\u0f53'),'ee':'Yordan nutome','el':u('\u0399\u03bf\u03c1\u03b4\u03b1\u03bd\u03af\u03b1'),'en':'*aa','eo':'Jordanio','es':'*br','et':'Jordaania','eu':'*br','fa':u('\u0627\u0631\u062f\u0646'),'ff':'Jordani','fi':'*br','fj':'*aa','fo':'*aa','fr':'Jordanie','fy':'*af','ga':u('an Iord\u00e1in'),'gd':u('I\u00f2rdan'),'gl':'Xordania','gn':'*aa','gu':u('\u0a9c\u0acb\u0ab0\u0acd\u0aa1\u0aa8'),'gv':'*aa','ha':'*aa','he':u('\u05d9\u05e8\u05d3\u05df'),'hi':u('\u091c\u0949\u0930\u094d\u0921\u0928'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':u('Jord\u00e1nia'),'hy':u('\u0540\u0578\u0580\u0564\u0561\u0576\u0561\u0576'),'hz':'*aa','ia':'*aa','id':'Yordania','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('J\u00f3rdan\u00eda'),'it':'Giordania','iu':'*aa','iw':'*he','ja':u('\u30e8\u30eb\u30c0\u30f3'),'ji':'*aa','jv':'*aa','ka':u('\u10d8\u10dd\u10e0\u10d3\u10d0\u10dc\u10d8\u10d0'),'kg':'*aa','ki':'Njorondani','kj':'*aa','kk':u('\u0418\u043e\u0440\u0434\u0430\u043d\u0438\u044f'),'kl':'*aa','km':u('\u17a0\u17ca\u17d2\u179f\u1780\u178a\u17b6\u1793\u17b8'),'kn':u('\u0c9c\u0ccb\u0cb0\u0ccd\u0ca1\u0cbe\u0ca8\u0ccd'),'ko':u('\uc694\ub974\ub2e8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*de','lg':'Yorodani','li':'*aa','ln':u('Z\u0254dani'),'lo':u('\u0e88\u0ecd\u0ec1\u0e94\u0e99'),'lt':'Jordanija','lu':'Jodani','lv':u('Jord\u0101nija'),'mg':'*br','mh':'*aa','mi':'*aa','mk':u('\u0408\u043e\u0440\u0434\u0430\u043d'),'ml':u('\u0d1c\u0d4b\u0d7c\u0d26\u0d4d\u0d26\u0d3e\u0d7b'),'mn':u('\u0419\u043e\u0440\u0434\u0430\u043d'),'mo':'Iordania','mr':'*hi','ms':'*aa','mt':u('il-\u0120ordan'),'my':u('\u1002\u103b\u1031\u102c\u103a\u1012\u1014\u103a'),'na':'*aa','nb':'*aa','nd':'*lu','ne':u('\u091c\u094b\u0930\u094d\u0921\u0928'),'ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b1c\u0b4b\u0b30\u0b4d\u0b21\u0b3e\u0b28\u0b4d'),'os':'*aa','pa':u('\u0a1c\u0a3e\u0a30\u0a21\u0a28'),'pi':'*aa','pl':'*br','ps':'*fa','pt':u('Jord\u00e2nia'),'qu':'*br','rm':'*br','rn':'Yorudaniya','ro':'*mo','ru':'*kk','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*fa','se':'*hu','sg':u('Zordan\u00efi'),'si':u('\u0da2\u0ddd\u0dbb\u0dca\u0daf\u0dcf\u0db1\u0dba'),'sk':'*cs','sl':'*lt','sm':'*aa','sn':'*aa','so':'Urdun','sq':'*ff','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':u('\u0b9c\u0bcb\u0bb0\u0bcd\u0b9f\u0bbe\u0ba9\u0bcd'),'te':u('\u0c1c\u0c4b\u0c30\u0c4d\u0c21\u0c3e\u0c28\u0c4d'),'tg':u('\u0423\u0440\u0434\u0443\u043d'),'th':u('\u0e08\u0e2d\u0e23\u0e4c\u0e41\u0e14\u0e19'),'ti':'*am','tk':u('Iordani\u00fda'),'tl':'*aa','tn':'*aa','to':'Soatane','tr':u('\u00dcrd\u00fcn'),'ts':'*aa','tt':'*kk','tw':'*aa','ty':'*aa','ug':u('\u0626\u0649\u064a\u0648\u0631\u062f\u0627\u0646\u0649\u064a\u06d5'),'uk':u('\u0419\u043e\u0440\u0434\u0430\u043d\u0456\u044f'),'ur':'*fa','uz':'Iordaniya','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Sordani','xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de J\u1ecddani'),'za':'*aa','zh':u('\u7ea6\u65e6'),'zu':'i-Jordan',},
  'JP': {'aa':'Japan','ab':'*aa','ae':'*aa','af':'*aa','ak':'Gyapan','am':u('\u1303\u1353\u1295'),'an':'*aa','ar':u('\u0627\u0644\u064a\u0627\u0628\u0627\u0646'),'as':u('\u099c\u09be\u09aa\u09be\u09a8'),'av':'*aa','ay':'*aa','az':'Yaponiya','ba':'*aa','be':u('\u042f\u043f\u043e\u043d\u0456\u044f'),'bg':u('\u042f\u043f\u043e\u043d\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':u('Zap\u0254n'),'bn':'*as','bo':u('\u0f49\u0f72\u0f0b\u0f67\u0f7c\u0f44\u0f0b'),'br':'*aa','bs':'*aa','ca':u('Jap\u00f3'),'ce':u('\u042f\u043f\u043e\u043d\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Japonsko','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f47\u0f0b\u0f54\u0f71\u0f53'),'ee':'Dzapan nutome','el':u('\u0399\u03b1\u03c0\u03c9\u03bd\u03af\u03b1'),'en':'*aa','eo':'Japanujo','es':u('Jap\u00f3n'),'et':'Jaapan','eu':'Japonia','fa':u('\u0698\u0627\u067e\u0646'),'ff':'Sapoo','fi':'Japani','fj':'*aa','fo':'*aa','fr':'Japon','fy':'*aa','ga':u('an tSeap\u00e1in'),'gd':'An t-Seapan','gl':u('Xap\u00f3n'),'gn':'*aa','gu':u('\u0a9c\u0abe\u0aaa\u0abe\u0aa8'),'gv':'*aa','ha':'*aa','he':u('\u05d9\u05e4\u05df'),'hi':u('\u091c\u093e\u092a\u093e\u0928'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':u('Jap\u00e1n'),'hy':u('\u0543\u0561\u057a\u0578\u0576\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'Jepang','ie':'*aa','ig':'*aa','ii':u('\ua3dd\ua02a'),'ik':'*aa','in':'*id','io':'*aa','is':'*aa','it':'Giappone','iu':'*aa','iw':'*he','ja':u('\u65e5\u672c'),'ji':u('\u05d9\u05d0\u05b7\u05e4\u05bc\u05d0\u05b7\u05df'),'jv':'*aa','ka':u('\u10d8\u10d0\u10de\u10dd\u10dc\u10d8\u10d0'),'kg':'*aa','ki':'Njabani','kj':'*aa','kk':u('\u0416\u0430\u043f\u043e\u043d\u0438\u044f'),'kl':'*aa','km':u('\u1787\u1794\u17c9\u17bb\u1793'),'kn':u('\u0c9c\u0caa\u0cbe\u0ca8\u0ccd'),'ko':u('\uc77c\ubcf8'),'kr':'*aa','ks':u('\u062c\u0627\u067e\u0627\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'*fi','li':'*aa','ln':u('Zap\u0254'),'lo':u('\u0e8d\u0eb5\u0ec8\u0e9b\u0eb8\u0ec8\u0e99'),'lt':'Japonija','lu':'Japu','lv':u('Jap\u0101na'),'mg':'Japana','mh':'*aa','mi':'*aa','mk':u('\u0408\u0430\u043f\u043e\u043d\u0438\u0458\u0430'),'ml':u('\u0d1c\u0d2a\u0d4d\u0d2a\u0d3e\u0d7b'),'mn':u('\u042f\u043f\u043e\u043d'),'mo':'*eu','mr':u('\u091c\u092a\u093e\u0928'),'ms':'Jepun','mt':u('il-\u0120appun'),'my':u('\u1002\u103b\u1015\u1014\u103a'),'na':'*aa','nb':'*aa','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b1c\u0b3e\u0b2a\u0b3e\u0b28'),'os':'*mn','pa':u('\u0a1c\u0a2a\u0a3e\u0a28'),'pi':'*aa','pl':'*eu','ps':'*ks','pt':u('Jap\u00e3o'),'qu':'*aa','rm':'Giapun','rn':'Ubuyapani','ro':'*eu','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*ks','se':u('Jap\u00e1na'),'sg':u('Zap\u00f6on'),'si':u('\u0da2\u0db4\u0dcf\u0db1\u0dba'),'sk':'*cs','sl':'Japonska','sm':'*aa','sn':'*aa','so':'Jabaan','sq':'Japoni','sr':u('\u0408\u0430\u043f\u0430\u043d'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*fi','ta':u('\u0b9c\u0baa\u0bcd\u0baa\u0bbe\u0ba9\u0bcd'),'te':u('\u0c1c\u0c2a\u0c3e\u0c28\u0c4d'),'tg':'*bg','th':u('\u0e0d\u0e35\u0e48\u0e1b\u0e38\u0e48\u0e19'),'ti':'*am','tk':u('\u00ddaponi\u00fda'),'tl':'*aa','tn':'*aa','to':'Siapani','tr':'Japonya','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u064a\u0627\u067e\u0648\u0646\u0649\u064a\u06d5'),'uk':'*be','ur':'*ks','uz':'*az','ve':'*aa','vi':u('Nh\u1eadt B\u1ea3n'),'vo':'*aa','wa':'*aa','wo':u('S\u00e0ppo\u014b'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Japani'),'za':'*aa','zh':'*ja','zu':'i-Japan',},
  'KE': {'aa':'Kenya','ab':'*aa','ae':'*aa','af':'Kenia','ak':u('K\u025bnya'),'am':u('\u12ac\u1295\u12eb'),'an':'*aa','ar':u('\u0643\u064a\u0646\u064a\u0627'),'as':u('\u0995\u09c7\u09a8\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Keniya','ba':'*aa','be':u('\u041a\u0435\u043d\u0456\u044f'),'bg':u('\u041a\u0435\u043d\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'*az','bn':'*as','bo':'*aa','br':'*aa','bs':'Kenija','ca':'*aa','ce':u('\u041a\u0435\u043d\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Ke\u0148a'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*af','dv':'*aa','dz':u('\u0f40\u0f7a\u0f53\u0f0b\u0f61'),'ee':'Kenya nutome','el':u('\u039a\u03ad\u03bd\u03c5\u03b1'),'en':'*aa','eo':'Kenjo','es':'*af','et':'Keenia','eu':'*aa','fa':u('\u06a9\u0646\u06cc\u0627'),'ff':u('Ke\u00f1aa'),'fi':'*af','fj':'*aa','fo':'Kenja','fr':'*aa','fy':'*af','ga':u('an Ch\u00e9inia'),'gd':'Ceinia','gl':'*aa','gn':'*aa','gu':u('\u0a95\u0ac7\u0aa8\u0acd\u0aaf\u0abe'),'gv':'*aa','ha':'*aa','he':u('\u05e7\u05e0\u05d9\u05d4'),'hi':u('\u0915\u0947\u0928\u094d\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u0554\u0565\u0576\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Ken\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30b1\u30cb\u30a2'),'ji':u('\u05e7\u05e2\u05e0\u05d9\u05e2'),'jv':'*aa','ka':u('\u10d9\u10d4\u10dc\u10d8\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1780\u17c1\u1793\u1799\u17c9\u17b6'),'kn':u('\u0c95\u0cc0\u0ca8\u0ccd\u0caf\u0cbe'),'ko':u('\ucf00\ub0d0'),'kr':'*aa','ks':u('\u06a9\u0650\u0646\u065b\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*af','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0ec0\u0e84\u0e99\u0ea2\u0eb2'),'lt':'*bs','lu':'*aa','lv':'*bs','mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u041a\u0435\u043d\u0438\u0458\u0430'),'ml':u('\u0d15\u0d46\u0d28\u0d3f\u0d2f'),'mn':'*ce','mo':'*aa','mr':u('\u0915\u0947\u0928\u093f\u092f\u093e'),'ms':'*aa','mt':'il-Kenja','my':u('\u1000\u1004\u103a\u100a\u102c'),'na':'*aa','nb':'*aa','nd':'Khenya','ne':'*hi','ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'Keeniyaa','or':u('\u0b15\u0b47\u0b28\u0b3f\u0b5f\u0b3e'),'os':'*aa','pa':u('\u0a15\u0a40\u0a28\u0a40\u0a06'),'pi':'*aa','pl':'*af','ps':u('\u06a9\u06cc\u0646\u06cc\u0627'),'pt':u('Qu\u00eania'),'qu':'*af','rm':'*af','rn':'*aa','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u064a\u0646\u064a\u0627'),'se':'*af','sg':u('Keny\u00e4a'),'si':u('\u0d9a\u0dd9\u0db1\u0dca\u0dba\u0dcf\u0dc0'),'sk':'*cs','sl':'*bs','sm':'*aa','sn':'*aa','so':'Kiiniya','sq':'*af','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b95\u0bc6\u0ba9\u0bcd\u0baf\u0bbe'),'te':u('\u0c15\u0c46\u0c28\u0c4d\u0c2f\u0c3e'),'tg':'*bg','th':u('\u0e40\u0e04\u0e19\u0e22\u0e32'),'ti':'*am','tk':u('Keni\u00fda'),'tl':'*aa','tn':'*aa','to':u('Keni\u0101'),'tr':'*aa','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0643\u06d0\u0646\u0649\u064a\u06d5'),'uk':'*be','ur':'*ps','uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':u('Kee\u00f1a'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Kenya'),'za':'*aa','zh':u('\u80af\u5c3c\u4e9a'),'zu':'i-Kenya',},
  'KG': {'aa':'Kyrgyzstan','ab':'*aa','ae':'*aa','af':'Kirgistan','ak':u('K\u025b\u025bgestan'),'am':u('\u12aa\u122d\u130a\u1235\u1273\u1295'),'an':'*aa','ar':u('\u0642\u064a\u0631\u063a\u064a\u0632\u0633\u062a\u0627\u0646'),'as':u('\u0995\u09bf\u09f0\u09cd\u0997\u09bf\u099c\u09b8\u09cd\u09a4\u09be\u09a8'),'av':'*aa','ay':'*aa','az':u('Q\u0131r\u011f\u0131z\u0131stan'),'ba':'*aa','be':u('\u041a\u044b\u0440\u0433\u044b\u0437\u0441\u0442\u0430\u043d'),'bg':u('\u041a\u0438\u0440\u0433\u0438\u0437\u0441\u0442\u0430\u043d'),'bh':'*aa','bi':'*aa','bm':u('Kirigizisita\u014b'),'bn':u('\u0995\u09bf\u09b0\u0997\u09bf\u099c\u09bf\u09b8\u09cd\u09a4\u09be\u09a8'),'bo':'*aa','br':'*aa','bs':'*af','ca':'Kirguizistan','ce':u('\u041a\u0438\u0440\u0433\u0438\u0437\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Kyrgyzst\u00e1n'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'Kirgisistan','de':'*da','dv':'*aa','dz':u('\u0f40\u0f72\u0f62\u0f0b\u0f42\u0f72\u0f66\u0f0b\u0f66\u0f4f\u0f71\u0f53'),'ee':'Kirgizstan nutome','el':u('\u039a\u03b9\u03c1\u03b3\u03b9\u03c3\u03c4\u03ac\u03bd'),'en':'*aa','eo':'Kirgizistano','es':u('Kirguist\u00e1n'),'et':u('K\u00f5rg\u00f5zstan'),'eu':'Kirgizistan','fa':u('\u0642\u0631\u0642\u06cc\u0632\u0633\u062a\u0627\u0646'),'ff':'Kirgistaan','fi':'Kirgisia','fj':'*aa','fo':'*fi','fr':'Kirghizistan','fy':u('Kirgizi\u00eb'),'ga':u('an Chirgeast\u00e1in'),'gd':u('C\u00ecorgastan'),'gl':u('Kirguizist\u00e1n'),'gn':'*aa','gu':u('\u0a95\u0abf\u0ab0\u0acd\u0a97\u0abf\u0a9d\u0acd\u0ab8\u0acd\u0aa4\u0abe\u0aa8'),'gv':'*aa','ha':'*eu','he':u('\u05e7\u05d9\u05e8\u05d2\u05d9\u05d6\u05e1\u05d8\u05df'),'hi':u('\u0915\u093f\u0930\u094d\u0917\u093f\u091c\u093c\u0938\u094d\u0924\u093e\u0928'),'ho':'*aa','hr':'*af','ht':'*aa','hu':u('Kirgiziszt\u00e1n'),'hy':u('\u0542\u0580\u0572\u0566\u057d\u057f\u0561\u0576'),'hz':'*aa','ia':'*aa','id':'*af','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*af','io':'*aa','is':'*af','it':'*fr','iu':'*aa','iw':'*he','ja':u('\u30ad\u30eb\u30ae\u30b9'),'ji':'*aa','jv':'*aa','ka':u('\u10e7\u10d8\u10e0\u10d2\u10d8\u10d6\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'Kirigizistani','kj':'*aa','kk':u('\u049a\u044b\u0440\u0493\u044b\u0437\u0441\u0442\u0430\u043d'),'kl':'*aa','km':u('\u1780\u17c0\u17a0\u17d2\u179f\u17ca\u17b8\u179f\u17ca\u17b8\u179f\u17d2\u1790\u17b6\u1793'),'kn':u('\u0c95\u0cbf\u0cb0\u0ccd\u0c97\u0cbf\u0cb8\u0ccd\u0ca5\u0cbe\u0ca8\u0ccd'),'ko':u('\ud0a4\ub974\uae30\uc2a4\uc2a4\ud0c4'),'kr':'*aa','ks':u('\u06a9\u0650\u0631\u06af\u0650\u0633\u062a\u0627\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*da','lg':'Kirigizisitaani','li':'*aa','ln':u('Kigizisit\u00e1'),'lo':u('\u0e84\u0ebd\u0e81\u0e81\u0eb4\u0e94\u0eaa\u0eb0\u0e96\u0eb2\u0e99'),'lt':'Kirgizija','lu':'Kigizisita','lv':u('Kirgizst\u0101na'),'mg':'Kiordistan','mh':'*aa','mi':'*aa','mk':u('\u041a\u0438\u0440\u0433\u0438\u0441\u0442\u0430\u043d'),'ml':u('\u0d15\u0d3f\u0d7c\u0d17\u0d3f\u0d38\u0d4d\u0d25\u0d3e\u0d7b'),'mn':'*be','mo':u('K\u00e2rg\u00e2zstan'),'mr':u('\u0915\u093f\u0930\u0917\u093f\u091d\u0938\u094d\u0924\u093e\u0928'),'ms':'*aa','mt':u('il-Kirgi\u017cistan'),'my':u('\u1000\u102c\u1002\u103b\u1005\u1039\u1005\u1010\u1014\u103a'),'na':'*aa','nb':'*da','nd':'*aa','ne':u('\u0915\u093f\u0930\u094d\u0917\u093f\u0938\u094d\u0924\u093e\u0928'),'ng':'*aa','nl':'*fy','nn':'*da','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b3f\u0b30\u0b4d\u0b17\u0b3f\u0b1c\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28'),'os':'*aa','pa':u('\u0a15\u0a3f\u0a30\u0a17\u0a3f\u0a1c\u0a3c\u0a38\u0a24\u0a3e\u0a28'),'pi':'*aa','pl':'*af','ps':u('\u0642\u0631\u063a\u0632\u0633\u062a\u0627\u0646'),'pt':u('Quirguist\u00e3o'),'qu':'*es','rm':'Kirghisistan','rn':'Kirigisitani','ro':'*mo','ru':u('\u041a\u0438\u0440\u0433\u0438\u0437\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u0631\u063a\u0633\u062a\u0627\u0646'),'se':'*da','sg':u('Kirigizit\u00f9aan'),'si':u('\u0d9a\u0dd2\u0dbb\u0dca\u0d9c\u0dd2\u0dc3\u0dca\u0dad\u0dcf\u0db1\u0dba'),'sk':'Kirgizsko','sl':'*eu','sm':'*aa','sn':'*aa','so':'*ff','sq':'*af','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*eu','sw':'*ki','ta':u('\u0b95\u0bbf\u0bb0\u0bcd\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd'),'te':u('\u0c15\u0c3f\u0c30\u0c4d\u0c17\u0c3f\u0c1c\u0c3f\u0c38\u0c4d\u0c24\u0c3e\u0c28\u0c4d'),'tg':u('\u049a\u0438\u0440\u0493\u0438\u0437\u0438\u0441\u0442\u043e\u043d'),'th':u('\u0e04\u0e35\u0e23\u0e4c\u0e01\u0e35\u0e0b\u0e2a\u0e16\u0e32\u0e19'),'ti':u('\u12aa\u122d\u1302\u1235\u1273\u1295'),'tk':'Gyrgyzystan','tl':'*aa','tn':'*aa','to':u('K\u012bkisitani'),'tr':u('K\u0131rg\u0131zistan'),'ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u0642\u0649\u0631\u063a\u0649\u0632\u0649\u0633\u062a\u0627\u0646'),'uk':'*bg','ur':u('\u06a9\u0631\u063a\u0632\u0633\u062a\u0627\u0646'),'uz':u('Qirg\u02bbiziston'),'ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':u('Kirgista\u014b'),'xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Kuri\u1e63isitani'),'za':'*aa','zh':u('\u5409\u5c14\u5409\u65af\u65af\u5766'),'zu':'i-Kyrgyzstan',},
  'KH': {'aa':'Cambodia','ab':'*aa','ae':'*aa','af':'Kambodja','ak':'Kambodia','am':u('\u12ab\u121d\u1266\u12f2\u12eb'),'an':'*aa','ar':u('\u0643\u0645\u0628\u0648\u062f\u064a\u0627'),'as':u('\u0995\u09ae\u09cd\u09ac\u09cb\u09a1\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Kamboca','ba':'*aa','be':u('\u041a\u0430\u043c\u0431\u043e\u0434\u0436\u0430'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'Kamboji','bn':'*as','bo':'*aa','br':'*af','bs':u('Kambod\u017ea'),'ca':'Cambodja','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*bs','cu':'*aa','cv':'*aa','cy':'*aa','da':'*ca','de':'Kambodscha','dv':'*aa','dz':u('\u0f40\u0f58\u0f0b\u0f56\u0fb7\u0f7c\u0f0b\u0f4c\u0f72\u0f0b\u0f61'),'ee':'Kambodia nutome','el':u('\u039a\u03b1\u03bc\u03c0\u03cc\u03c4\u03b6\u03b7'),'en':'*aa','eo':u('Kambo\u011do'),'es':'Camboya','et':'*bs','eu':'Kanbodia','fa':u('\u06a9\u0627\u0645\u0628\u0648\u062c'),'ff':'Kambodso','fi':'*bs','fj':'*aa','fo':'*af','fr':'Cambodge','fy':'*ca','ga':u('an Chamb\u00f3id'),'gd':'Cambuidea','gl':'*ca','gn':'*aa','gu':u('\u0a95\u0a82\u0aac\u0acb\u0aa1\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Kambodiya','he':u('\u05e7\u05de\u05d1\u05d5\u05d3\u05d9\u05d4'),'hi':u('\u0915\u0902\u092c\u094b\u0921\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'Kambodzsa','hy':u('\u053f\u0561\u0574\u0562\u0578\u057b\u0561'),'hz':'*aa','ia':'*aa','id':'Kamboja','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Kamb\u00f3d\u00eda'),'it':'Cambogia','iu':'*aa','iw':'*he','ja':u('\u30ab\u30f3\u30dc\u30b8\u30a2'),'ji':u('\u05e7\u05d0\u05b7\u05de\u05d1\u05d0\u05d3\u05d9\u05e2'),'jv':'*aa','ka':u('\u10d9\u10d0\u10db\u10d1\u10dd\u10ef\u10d0'),'kg':'*aa','ki':'*ak','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u1780\u1798\u17d2\u1796\u17bb\u1787\u17b6'),'kn':u('\u0c95\u0cbe\u0c82\u0cac\u0ccb\u0ca1\u0cbf\u0caf\u0cbe'),'ko':u('\uce84\ubcf4\ub514\uc544'),'kr':'*aa','ks':u('\u06a9\u064e\u0645\u0628\u0648\u0691\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*de','lg':'Kambodya','li':'*aa','ln':'Kambodza','lo':u('\u0e81\u0eb3\u0e9b\u0eb9\u0ec0\u0e88\u0e8d'),'lt':'*bs','lu':'*ln','lv':'*bs','mg':u('Kamb\u00f4dja'),'mh':'*aa','mi':'*aa','mk':u('\u041a\u0430\u043c\u0431\u043e\u045f\u0430'),'ml':u('\u0d15\u0d02\u0d2c\u0d4b\u0d21\u0d3f\u0d2f'),'mn':u('\u041a\u0430\u043c\u0431\u043e\u0436'),'mo':'Cambodgia','mr':'*hi','ms':'Kemboja','mt':'il-Kambodja','my':u('\u1000\u1019\u1039\u1018\u1031\u102c\u1012\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'Kambodsja','nd':'*aa','ne':u('\u0915\u092e\u094d\u092c\u094b\u0921\u093f\u092f\u093e'),'ng':'*aa','nl':'*ca','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b3e\u0b2e\u0b4d\u0b2c\u0b4b\u0b21\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a15\u0a70\u0a2c\u0a4b\u0a21\u0a40\u0a06'),'pi':'*aa','pl':u('Kambod\u017ca'),'ps':u('\u06a9\u0645\u0628\u0648\u062f\u06cc\u0627'),'pt':'Camboja','qu':'*es','rm':'Cambodscha','rn':'Kamboje','ro':'*mo','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u0645\u0628\u0648\u068a\u064a\u0627'),'se':'*bs','sg':u('K\u00e4mb\u00f4zi'),'si':u('\u0d9a\u0dcf\u0db8\u0dca\u0db6\u0ddd\u0da2\u0dba'),'sk':'*bs','sl':'*bs','sm':'*aa','sn':'*ak','so':'Kamboodiya','sq':'Kamboxhia','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*af','sw':'*ak','ta':u('\u0b95\u0bae\u0bcd\u0baa\u0bcb\u0b9f\u0bbf\u0baf\u0bbe'),'te':u('\u0c15\u0c02\u0c2c\u0c4b\u0c21\u0c3f\u0c2f\u0c3e'),'tg':u('\u041a\u0430\u043c\u0431\u043e\u04b7\u0430'),'th':u('\u0e01\u0e31\u0e21\u0e1e\u0e39\u0e0a\u0e32'),'ti':'*am','tk':'*id','tl':'*aa','tn':'*aa','to':u('Kamip\u014dtia'),'tr':u('Kambo\u00e7ya'),'ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u0643\u0627\u0645\u0628\u0648\u062f\u0698\u0627'),'uk':'*be','ur':u('\u06a9\u0645\u0628\u0648\u0688\u06cc\u0627'),'uz':'*af','ve':'*aa','vi':'Campuchia','vo':'*aa','wa':'*aa','wo':u('K\u00e0mboj'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de K\u00e0m\u00f9b\u00f3d\u00ed\u00e0'),'za':'*aa','zh':u('\u67ec\u57d4\u5be8'),'zu':'i-Cambodia',},
  'KI': {'aa':'Kiribati','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u12aa\u122a\u1263\u1272'),'an':'*aa','ar':u('\u0643\u064a\u0631\u064a\u0628\u0627\u062a\u064a'),'as':u('\u0995\u09bf\u09f0\u09bf\u09ac\u09be\u099f\u09bf'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u041a\u0456\u0440\u044b\u0431\u0430\u0446\u0456'),'bg':u('\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u0995\u09bf\u09b0\u09bf\u09ac\u09be\u09a4\u09bf'),'bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f40\u0f72\u0f0b\u0f62\u0f72\u0f0b\u0f56\u0f0b\u0f4f\u0f72\u0f0b\u0f58\u0f5a\u0f7c\u0f0b\u0f42\u0fb3\u0f72\u0f44'),'ee':'Kiribati nutome','el':u('\u039a\u03b9\u03c1\u03b9\u03bc\u03c0\u03ac\u03c4\u03b9'),'en':'*aa','eo':'Kiribato','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u06a9\u06cc\u0631\u06cc\u0628\u0627\u062a\u06cc'),'ff':'Kiribari','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Cireabait\u00ed'),'gd':'Ciribeas','gl':'*aa','gn':'*aa','gu':u('\u0a95\u0abf\u0ab0\u0abf\u0aac\u0abe\u0a9f\u0ac0'),'gv':'*aa','ha':'*aa','he':u('\u05e7\u05d9\u05e8\u05d9\u05d1\u05d0\u05d8\u05d9'),'hi':u('\u0915\u093f\u0930\u093f\u092c\u093e\u0924\u0940'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u053f\u056b\u0580\u056b\u0562\u0561\u057f\u056b'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('K\u00edribat\u00ed'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30ad\u30ea\u30d0\u30b9'),'ji':u('\u05e7\u05d9\u05e8\u05d9\u05d1\u05d0\u05b7\u05d8\u05d9'),'jv':'*aa','ka':u('\u10d9\u10d8\u10e0\u10d8\u10d1\u10d0\u10e2\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1782\u17b7\u179a\u17b8\u1794\u17b6\u1791\u17b8'),'kn':u('\u0c95\u0cbf\u0cb0\u0cbf\u0cac\u0cbe\u0c9f\u0cbf'),'ko':u('\ud0a4\ub9ac\ubc14\uc2dc'),'kr':'*aa','ks':u('\u06a9\u0650\u0631\u0655\u0628\u0627\u062a\u06cc'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0e84\u0eb4\u0ea3\u0eb4\u0e9a\u0eb2\u0e97\u0eb4'),'lt':'Kiribatis','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d15\u0d3f\u0d30\u0d3f\u0d2c\u0d3e\u0d1f\u0d4d\u0d1f\u0d3f'),'mn':'*bg','mo':'*aa','mr':u('\u0915\u093f\u0930\u0940\u092c\u093e\u091f\u0940'),'ms':'*aa','mt':'*aa','my':u('\u1001\u102e\u101b\u102e\u1018\u102c\u1010\u102e'),'na':'*aa','nb':'*aa','nd':'Khiribati','ne':u('\u0915\u093f\u0930\u093f\u092c\u093e\u091f\u0940'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b3f\u0b30\u0b3f\u0b2c\u0b3e\u0b1f\u0b3f'),'os':'*aa','pa':u('\u0a15\u0a3f\u0a30\u0a2c\u0a3e\u0a24\u0a40'),'pi':'*aa','pl':'*aa','ps':u('\u06a9\u06cc\u0631\u064a \u0628\u0627\u062a\u064a'),'pt':'Quiribati','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u0631\u0628\u0627\u062a\u064a'),'se':'*aa','sg':'*aa','si':u('\u0d9a\u0dd2\u0dbb\u0dd2\u0db6\u0dad\u0dd2'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b95\u0bbf\u0bb0\u0bbf\u0baa\u0bbe\u0b9f\u0bcd\u0b9f\u0bbf'),'te':u('\u0c15\u0c3f\u0c30\u0c3f\u0c2c\u0c3e\u0c1f\u0c3f'),'tg':'*bg','th':u('\u0e04\u0e34\u0e23\u0e34\u0e1a\u0e32\u0e2a'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':'Kilipasi','tr':'*aa','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0643\u0649\u0631\u0649\u0628\u0627\u062a\u0649'),'uk':u('\u041a\u0456\u0440\u0456\u0431\u0430\u0442\u0456'),'ur':u('\u06a9\u0631\u06cc\u0628\u0627\u062a\u06cc'),'uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Kiribati'),'za':'*aa','zh':u('\u57fa\u91cc\u5df4\u65af'),'zu':'i-Kiribati',},
  'KM': {'aa':'Comoros','ab':'*aa','ae':'*aa','af':'Comore','ak':u('K\u0254m\u0254r\u0254s'),'am':u('\u12ae\u121e\u122e\u1235'),'an':'*aa','ar':u('\u062c\u0632\u0631 \u0627\u0644\u0642\u0645\u0631'),'as':u('\u0995\u09cb\u09ae\u09cb\u09f0\u09cb\u099c'),'av':'*aa','ay':'*aa','az':u('Komor adalar\u0131'),'ba':'*aa','be':u('\u041a\u0430\u043c\u043e\u0440\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b'),'bg':u('\u041a\u043e\u043c\u043e\u0440\u0441\u043a\u0438 \u043e\u0441\u0442\u0440\u043e\u0432\u0438'),'bh':'*aa','bi':'*aa','bm':u('Kom\u0254ri'),'bn':u('\u0995\u09ae\u09cb\u09b0\u09cb\u09b8'),'bo':'*aa','br':'Komorez','bs':'Komori','ca':'Comores','ce':u('\u041a\u043e\u043c\u043e\u0440\u0430\u0448'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Komory','cu':'*aa','cv':'*aa','cy':'*aa','da':'Comorerne','de':'Komoren','dv':'*aa','dz':u('\u0f40\u0f7c\u0f0b\u0f58\u0f7c\u0f0b\u0f62\u0f7c\u0f66'),'ee':'Komoros nutome','el':u('\u039a\u03bf\u03bc\u03cc\u03c1\u03b5\u03c2'),'en':'*aa','eo':'Komoroj','es':'Comoras','et':'Komoorid','eu':'Komoreak','fa':u('\u06a9\u0648\u0645\u0648\u0631\u0648'),'ff':'Komoor','fi':'Komorit','fj':'*aa','fo':'Komoroyggjar','fr':'*ca','fy':'Comoren','ga':u('Oile\u00e1in Chom\u00f3ra'),'gd':'*aa','gl':'*ca','gn':'*aa','gu':u('\u0a95\u0acb\u0aae\u0acb\u0ab0\u0ab8'),'gv':'*aa','ha':'Kwamoras','he':u('\u05e7\u05d5\u05de\u05d5\u05e8\u05d5'),'hi':u('\u0915\u094b\u092e\u094b\u0930\u094b\u0938'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'Comore-szigetek','hy':u('\u053f\u0578\u0574\u0578\u0580\u0575\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'Komoro','ie':'*aa','ig':'Comorosu','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('K\u00f3moreyjar'),'it':'*af','iu':'*aa','iw':'*he','ja':u('\u30b3\u30e2\u30ed'),'ji':u('\u05e7\u05d0\u05de\u05d0\u05e8\u05d0\u05e1'),'jv':'*aa','ka':u('\u10d9\u10dd\u10db\u10dd\u10e0\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'*id','kj':'*aa','kk':u('\u041a\u043e\u043c\u043e\u0440 \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'kl':'*aa','km':u('\u1780\u17bc\u1798\u17d0\u179a'),'kn':u('\u0c95\u0cca\u0cae\u0cca\u0cb0\u0cca\u0cb8\u0ccd'),'ko':u('\ucf54\ubaa8\ub85c'),'kr':'*aa','ks':u('\u06a9\u064e\u0645\u0648\u0631\u064e\u0633'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u041a\u043e\u043c\u043e\u0440\u043e\u0441'),'la':'*aa','lb':'*de','lg':u('Bizinga by\u2019eKomoro'),'li':'*aa','ln':u('Komor\u025b'),'lo':u('\u0ec2\u0e84\u0ec2\u0ea1\u0ec2\u0ea3\u0eaa'),'lt':'Komorai','lu':'Komoru','lv':'Komoru salas','mg':u('K\u00f4maoro'),'mh':'*aa','mi':'*aa','mk':u('\u041a\u043e\u043c\u043e\u0440\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438'),'ml':u('\u0d15\u0d4b\u0d2e\u0d4a\u0d31\u0d4b\u0d38\u0d4d'),'mn':u('\u041a\u043e\u043c\u043e\u0440\u044b\u043d \u0430\u0440\u043b\u0443\u0443\u0434'),'mo':'*af','mr':u('\u0915\u094b\u092e\u094b\u0930\u094b\u091c'),'ms':'*aa','mt':'*aa','my':u('\u1000\u102d\u102f\u1019\u102d\u102f\u101b\u102d\u102f\u1005\u103a'),'na':'*aa','nb':'Komorene','nd':'Khomoro','ne':'*hi','ng':'*aa','nl':'*fy','nn':'Komorane','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b4b\u0b2e\u0b4b\u0b30\u0b38\u0b4d\u200c'),'os':'*aa','pa':u('\u0a15\u0a4b\u0a2e\u0a4b\u0a30\u0a4b\u0a38'),'pi':'*aa','pl':'*cs','ps':u('\u06a9\u0648\u0645\u0648\u0631\u0648\u0633'),'pt':'*ca','qu':'*es','rm':'*es','rn':'Izinga rya Komore','ro':'*af','ru':u('\u041a\u043e\u043c\u043e\u0440\u044b'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u0648\u0645\u0648\u0631\u0648\u0633'),'se':'Komoros','sg':u('K\u00f6m\u00f4ro'),'si':u('\u0d9a\u0ddc\u0db8\u0ddc\u0dbb\u0ddd\u0dc3\u0dca'),'sk':'*cs','sl':'*bs','sm':'*aa','sn':'*id','so':'Komooros','sq':'Komore','sr':u('\u041a\u043e\u043c\u043e\u0440\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Komorerna','sw':'*id','ta':u('\u0b95\u0bcb\u0bae\u0bb0\u0bcb\u0bb8\u0bcd'),'te':u('\u0c15\u0c4a\u0c2e\u0c4a\u0c30\u0c4b\u0c38\u0c4d'),'tg':u('\u041a\u043e\u043c\u043e\u0440'),'th':u('\u0e04\u0e2d\u0e42\u0e21\u0e42\u0e23\u0e2a'),'ti':'*am','tk':'Komor Adalary','tl':'*aa','tn':'*aa','to':'Komolosi','tr':'Komorlar','ts':'*aa','tt':u('\u041a\u043e\u043c\u043e\u0440 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0643\u0648\u0645\u0648\u0631\u0648'),'uk':u('\u041a\u043e\u043c\u043e\u0440\u0441\u044c\u043a\u0456 \u043e\u0441\u0442\u0440\u043e\u0432\u0438'),'ur':'*ps','uz':'Komor orollari','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*ff','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de K\u00f2m\u00f2r\u00f3s\u00ec'),'za':'*aa','zh':u('\u79d1\u6469\u7f57'),'zu':'i-Comoros',},
  'KN': {'aa':'Saint Kitts And Nevis','ab':'*aa','ae':'*aa','af':'Sint Kitts en Nevis','ak':u('Saint Kitts ne N\u025bves'),'am':u('\u1245\u12f1\u1235 \u12aa\u1275\u1235 \u12a5\u1293 \u1294\u126a\u1235'),'an':'*aa','ar':u('\u0633\u0627\u0646\u062a \u0643\u064a\u062a\u0633 \u0648\u0646\u064a\u0641\u064a\u0633'),'as':u('\u099b\u09c7\u0987\u09a3\u09cd\u099f \u0995\u09bf\u099f\u099b \u0986\u09f0\u09c1 \u09a8\u09c7\u09ad\u09bf\u099b'),'av':'*aa','ay':'*aa','az':u('Sent-Kits v\u0259 Nevis'),'ba':'*aa','be':u('\u0421\u0435\u043d\u0442-\u041a\u0456\u0442\u0441 \u0456 \u041d\u0435\u0432\u0456\u0441'),'bg':u('\u0421\u0435\u0439\u043d\u0442 \u041a\u0438\u0442\u0441 \u0438 \u041d\u0435\u0432\u0438\u0441'),'bh':'*aa','bi':'*aa','bm':u('Krist\u0254fo-Senu-ni-\u019dev\u025bs'),'bn':u('\u09b8\u09c7\u09a8\u09cd\u099f \u0995\u09bf\u099f\u09b8 \u0993 \u09a8\u09c7\u09ad\u09bf\u09b8'),'bo':'*aa','br':'Saint Kitts ha Nevis','bs':'Sveti Kits i Nevis','ca':'Saint Christopher i Nevis','ce':u('\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0441 \u0430, \u041d\u0435\u0432\u0438\u0441 \u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Svat\u00fd Kry\u0161tof a Nevis'),'cu':'*aa','cv':'*aa','cy':'Saint Kitts a Nevis','da':'Saint Kitts og Nevis','de':'St. Kitts und Nevis','dv':'*aa','dz':u('\u0f66\u0f7a\u0f53\u0f4a\u0f0b \u0f40\u0f72\u0f4a\u0f66\u0f0b \u0f51\u0f44\u0f0b \u0f53\u0f7a\u0f0b\u0f56\u0f72\u0f66'),'ee':'Saint Kitis kple Nevis nutome','el':u('\u03a3\u03b5\u03bd \u039a\u03b9\u03c4\u03c2 \u03ba\u03b1\u03b9 \u039d\u03ad\u03b2\u03b9\u03c2'),'en':'St. Kitts & Nevis','eo':'Sent-Kristofo kaj Neviso','es':u('San Crist\u00f3bal y Nieves'),'et':'Saint Kitts ja Nevis','eu':'Saint Kitts eta Nevis','fa':u('\u0633\u0646\u062a \u06a9\u06cc\u062a\u0633 \u0648 \u0646\u0648\u06cc\u0633'),'ff':'Sent Kits e Newis','fi':'*et','fj':'*aa','fo':'*en','fr':u('Saint-Christophe-et-Ni\u00e9v\u00e8s'),'fy':'Saint Kitts en Nevis','ga':u('San Cr\u00edost\u00f3ir-Nimheas'),'gd':u('Naomh Cr\u00ecstean is Nibheis'),'gl':'Saint Kitts e Nevis','gn':'*aa','gu':u('\u0ab8\u0ac7\u0a82\u0a9f \u0a95\u0abf\u0a9f\u0acd\u0ab8 \u0a85\u0aa8\u0ac7 \u0aa8\u0ac7\u0ab5\u0abf\u0ab8'),'gv':'*aa','ha':'San Kiti Da Nebis','he':u('\u05e1\u05e0\u05d8 \u05e7\u05d9\u05d8\u05e1 \u05d5\u05e0\u05d5\u05d5\u05d9\u05e1'),'hi':u('\u0938\u0947\u0902\u091f \u0915\u093f\u091f\u094d\u0938 \u0914\u0930 \u0928\u0947\u0935\u093f\u0938'),'ho':'*aa','hr':'Sveti Kristofor i Nevis','ht':'*aa','hu':u('Saint Kitts \u00e9s Nevis'),'hy':u('\u054d\u0565\u0576\u0569 \u0554\u056b\u057f\u057d \u0587 \u0546\u0587\u056b\u057d'),'hz':'*aa','ia':'*aa','id':'Saint Kitts dan Nevis','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'Sankti Kitts og Nevis','it':'*gl','iu':'*aa','iw':'*he','ja':u('\u30bb\u30f3\u30c8\u30af\u30ea\u30b9\u30c8\u30d5\u30a1\u30fc\u30fb\u30cd\u30fc\u30f4\u30a3\u30b9'),'ji':'*aa','jv':'*aa','ka':u('\u10e1\u10d4\u10dc\u10e2-\u10d9\u10d8\u10e2\u10e1\u10d8 \u10d3\u10d0 \u10dc\u10d4\u10d5\u10d8\u10e1\u10d8'),'kg':'*aa','ki':'Santakitzi na Nevis','kj':'*aa','kk':u('\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0441 \u0436\u04d9\u043d\u0435 \u041d\u0435\u0432\u0438\u0441'),'kl':'*aa','km':u('\u179f\u17b6\u17c6\u1784\u200b\u1782\u17b8\u178f \u1793\u17b7\u1784 \u178e\u17c1\u179c\u17b8\u179f'),'kn':u('\u0cb8\u0cc7\u0c82\u0c9f\u0ccd \u0c95\u0cbf\u0c9f\u0ccd\u0cb8\u0ccd \u0cae\u0ca4\u0ccd\u0ca4\u0cc1 \u0ca8\u0cc6\u0cb5\u0cbf\u0cb8\u0ccd'),'ko':u('\uc138\uc778\ud2b8\ud0a4\uce20 \ub124\ube44\uc2a4'),'kr':'*aa','ks':u('\u0633\u06cc\u0646\u065b\u0679 \u06a9\u0650\u0679\u064e\u0633 \u062a\u06c1\u0655 \u0646\u06cc\u0648\u0650\u0633'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0441 \u0436\u0430\u043d\u0430 \u041d\u0435\u0432\u0438\u0441'),'la':'*aa','lb':'St. Kitts an Nevis','lg':'Senti Kitisi ne Nevisi','li':'*aa','ln':u('S\u00e1ntu kr\u00edstofe mp\u00e9 Nev\u025b\u0300s'),'lo':u('\u0ec0\u0e8a\u0e99 \u0e84\u0eb4\u0e94 \u0ec1\u0ea5\u0eb0 \u0ec0\u0e99\u0ea7\u0eb4\u0eaa'),'lt':'Sent Kitsas ir Nevis','lu':u('Santu kr\u00edstofe ne Neves'),'lv':'Sentkitsa un Nevisa','mg':'*fr','mh':'*aa','mi':'*aa','mk':u('\u0421\u0432\u0435\u0442\u0438 \u041a\u0438\u0442\u0441 \u0438 \u041d\u0435\u0432\u0438\u0441'),'ml':u('\u0d38\u0d46\u0d28\u0d4d\u0d31\u0d4d \u0d15\u0d3f\u0d31\u0d4d\u0d31\u0d4d\u200c\u0d38\u0d41\u0d02 \u0d28\u0d46\u0d35\u0d3f\u0d38\u0d41\u0d02'),'mn':u('\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0442\u0441 \u0431\u0430 \u041d\u0435\u0432\u0438\u0441'),'mo':u('Saint Kitts \u0219i Nevis'),'mr':u('\u0938\u0947\u0902\u091f \u0915\u093f\u091f\u094d\u0938 \u0906\u0923\u093f \u0928\u0947\u0935\u094d\u0939\u093f\u0938'),'ms':'*id','mt':'Saint Kitts u Nevis','my':u('\u1005\u102d\u1014\u1037\u103a\u1000\u1005\u103a\u1014\u103e\u1004\u1037\u103a\u1014\u102e\u1017\u102e\u1005\u103a'),'na':'*aa','nb':'*da','nd':'Saint Kitts and Nevis','ne':u('\u0938\u0947\u0928\u094d\u091f \u0915\u093f\u091f\u094d\u0938 \u0930 \u0928\u0947\u092d\u093f\u0938'),'ng':'*aa','nl':'*fy','nn':'*da','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b15\u0b3f\u0b1f\u0b38\u0b4d\u200c \u0b0f\u0b2c\u0b02 \u0b28\u0b47\u0b2d\u0b3f\u0b38\u0b4d\u200c'),'os':'*aa','pa':u('\u0a38\u0a47\u0a02\u0a1f \u0a15\u0a3f\u0a1f\u0a38 \u0a10\u0a02\u0a21 \u0a28\u0a47\u0a35\u0a3f\u0a38'),'pi':'*aa','pl':'Saint Kitts i Nevis','ps':u('\u0633\u06cc\u0646\u067c \u06a9\u067c\u0633 \u0627\u0648 \u0646\u06cc\u0648\u06cc\u0633'),'pt':u('S\u00e3o Crist\u00f3v\u00e3o e N\u00e9vis'),'qu':'*es','rm':'*gl','rn':'Sekitsi na Nevisi','ro':'*mo','ru':u('\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0441 \u0438 \u041d\u0435\u0432\u0438\u0441'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u064a\u0646\u067d \u06aa\u067d\u0633 \u0648 \u0646\u064a\u0648\u0633'),'se':'*et','sg':u('S\u00ean-Kr\u00efst\u00f4fo-na-Nev\u00eesi'),'si':u('\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0d9a\u0dd2\u0da7\u0dca\u0dc3\u0dca \u0dc3\u0dc4 \u0db1\u0dda\u0dc0\u0dd2\u0dc3\u0dca'),'sk':u('Sv\u00e4t\u00fd Kri\u0161tof a Nevis'),'sl':'Saint Kitts in Nevis','sm':'*aa','sn':'*nd','so':'*nd','sq':u('Sh\u00ebn-Kits dhe Nevis'),'sr':u('\u0421\u0435\u043d\u0442 \u041a\u0438\u0442\u0441 \u0438 \u041d\u0435\u0432\u0438\u0441'),'ss':'*aa','st':'*aa','su':'*aa','sv':'S:t Kitts och Nevis','sw':'St. Kitts na Nevis','ta':u('\u0b9a\u0bc6\u0baf\u0bbf\u0ba9\u0bcd\u0b9f\u0bcd \u0b95\u0bbf\u0b9f\u0bcd\u0bb8\u0bcd & \u0ba8\u0bc6\u0bb5\u0bbf\u0bb8\u0bcd'),'te':u('\u0c38\u0c46\u0c2f\u0c3f\u0c02\u0c1f\u0c4d \u0c15\u0c3f\u0c1f\u0c4d\u0c38\u0c4d \u0c2e\u0c30\u0c3f\u0c2f\u0c41 \u0c28\u0c46\u0c35\u0c3f\u0c38\u0c4d'),'tg':u('\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0441 \u0432\u0430 \u041d\u0435\u0432\u0438\u0441'),'th':u('\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e04\u0e34\u0e15\u0e2a\u0e4c\u0e41\u0e25\u0e30\u0e40\u0e19\u0e27\u0e34\u0e2a'),'ti':u('\u1245\u12f1\u1235 \u12aa\u1275\u1235\u1295 \u1294\u126a\u1235\u1295'),'tk':'Sent-Kits we Newis','tl':'*en','tn':'*aa','to':u('S\u0101 Kitisi mo Nevisi'),'tr':'Saint Kitts ve Nevis','ts':'*aa','tt':u('\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0441 \u04bb\u04d9\u043c \u041d\u0435\u0432\u0438\u0441'),'tw':'*aa','ty':'*aa','ug':u('\u0633\u0627\u064a\u0646\u062a \u0643\u0649\u062a\u0649\u0633 \u06cb\u06d5 \u0646\u06d0\u06cb\u0649\u0633'),'uk':'*be','ur':u('\u0633\u06cc\u0646\u0679 \u06a9\u0679\u0633 \u0627\u0648\u0631 \u0646\u06cc\u0648\u06cc\u0633'),'uz':'Sent-Kits va Nevis','ve':'*aa','vi':u('St. Kitts v\u00e0 Nevis'),'vo':'*aa','wa':'*aa','wo':u('Sa\u014b Kits ak Newis'),'xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Kiiti ati Neefi'),'za':'*aa','zh':u('\u5723\u57fa\u8328\u548c\u5c3c\u7ef4\u65af'),'zu':'i-Saint Kitts ne-Nevis',},
  'KP': {'aa':'North Korea','ab':'*aa','ae':'*aa','af':'Noord-Korea','ak':'Etifi Koria','am':u('\u1230\u121c\u1295 \u12ae\u122a\u12eb'),'an':'*aa','ar':u('\u0643\u0648\u0631\u064a\u0627 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629'),'as':u('\u0989\u09a4\u09cd\u09a4\u09f0 \u0995\u09cb\u09f0\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':u('\u015eimali Koreya'),'ba':'*aa','be':u('\u041f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u044f \u041a\u0430\u0440\u044d\u044f'),'bg':u('\u0421\u0435\u0432\u0435\u0440\u043d\u0430 \u041a\u043e\u0440\u0435\u044f'),'bh':'*aa','bi':'*aa','bm':u('K\u025b\u0272\u025bka Kore'),'bn':u('\u0989\u09a4\u09cd\u09a4\u09b0 \u0995\u09cb\u09b0\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'Korea an Norzh','bs':'Sjeverna Koreja','ca':'Corea del Nord','ce':u('\u041a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u041a\u043e\u0440\u0435\u0439'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Severn\u00ed Korea'),'cu':'*aa','cv':'*aa','cy':'Gogledd Korea','da':'Nordkorea','de':'*da','dv':'*aa','dz':u('\u0f56\u0fb1\u0f44\u0f0b \u0f40\u0f7c\u0f0b\u0f62\u0f72\u0f0b\u0f61'),'ee':'Dziehe Korea nutome','el':u('\u0392\u03cc\u03c1\u03b5\u03b9\u03b1 \u039a\u03bf\u03c1\u03ad\u03b1'),'en':'*aa','eo':'Nord-Koreo','es':'Corea del Norte','et':u('P\u00f5hja-Korea'),'eu':'Ipar Korea','fa':u('\u06a9\u0631\u0647\u0654 \u0634\u0645\u0627\u0644\u06cc'),'ff':'Koree Rewo','fi':'Pohjois-Korea','fj':'*aa','fo':u('Nor\u00f0urkorea'),'fr':u('Cor\u00e9e du Nord'),'fy':'Noard-Korea','ga':u('an Ch\u00f3ir\u00e9 Thuaidh'),'gd':u('Coir\u00e8a a Tuath'),'gl':'Corea do Norte','gn':'*aa','gu':u('\u0a89\u0aa4\u0acd\u0aa4\u0ab0 \u0a95\u0acb\u0ab0\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Koreya Ta Arewa','he':u('\u05e7\u05d5\u05e8\u05d9\u05d0\u05d4 \u05d4\u05e6\u05e4\u05d5\u05e0\u05d9\u05ea'),'hi':u('\u0909\u0924\u094d\u0924\u0930 \u0915\u094b\u0930\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('\u00c9szak-Korea'),'hy':u('\u0540\u0575\u0578\u0582\u057d\u056b\u057d\u0561\u0575\u056b\u0576 \u053f\u0578\u0580\u0565\u0561'),'hz':'*aa','ia':'*aa','id':'Korea Utara','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Nor\u00f0ur-K\u00f3rea'),'it':'*ca','iu':'*aa','iw':'*he','ja':u('\u5317\u671d\u9bae'),'ji':'*aa','jv':'*aa','ka':u('\u10e9\u10e0\u10d3\u10d8\u10da\u10dd\u10d4\u10d7 \u10d9\u10dd\u10e0\u10d4\u10d0'),'kg':'*aa','ki':'Korea Kaskazini','kj':'*aa','kk':u('\u0421\u043e\u043b\u0442\u04af\u0441\u0442\u0456\u043a \u041a\u043e\u0440\u0435\u044f'),'kl':'*aa','km':u('\u1780\u17bc\u179a\u17c9\u17c1\u200b\u1781\u17b6\u1784\u200b\u1787\u17be\u1784'),'kn':u('\u0c89\u0ca4\u0ccd\u0ca4\u0cb0 \u0c95\u0cca\u0cb0\u0cbf\u0caf\u0cbe'),'ko':u('\ubd81\ud55c'),'kr':'*aa','ks':u('\u0634\u064f\u0645\u0672\u0644\u06cc \u06a9\u0648\u0631\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0422\u04af\u043d\u0434\u04af\u043a \u041a\u043e\u0440\u0435\u044f'),'la':'*aa','lb':'*da','lg':u('Koreya ey\u2019omumambuka'),'li':'*aa','ln':u('Kor\u025b ya n\u0254\u0301rdi'),'lo':u('\u0ec0\u0e81\u0ebb\u0eb2\u0eab\u0ea5\u0eb5\u0ec0\u0edc\u0eb7\u0ead'),'lt':u('\u0160iaur\u0117s Kor\u0117ja'),'lu':'Kore wa muulu','lv':u('Zieme\u013ckoreja'),'mg':'Korea Avaratra','mh':'*aa','mi':'*aa','mk':u('\u0421\u0435\u0432\u0435\u0440\u043d\u0430 \u041a\u043e\u0440\u0435\u0458\u0430'),'ml':u('\u0d09\u0d24\u0d4d\u0d24\u0d30\u0d15\u0d4a\u0d31\u0d3f\u0d2f'),'mn':u('\u0425\u043e\u0439\u0434 \u0421\u043e\u043b\u043e\u043d\u0433\u043e\u0441'),'mo':'Coreea de Nord','mr':'*hi','ms':'*id','mt':u('il-Korea ta\u2019 Fuq'),'my':u('\u1019\u103c\u1031\u102c\u1000\u103a\u1000\u102d\u102f\u101b\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'Nord-Korea','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*af','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b15\u0b4b\u0b30\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a09\u0a71\u0a24\u0a30 \u0a15\u0a4b\u0a30\u0a40\u0a06'),'pi':'*aa','pl':u('Korea P\u00f3\u0142nocna'),'ps':u('\u0634\u0645\u0627\u0644\u06cc \u06a9\u0648\u0631\u06cc\u0627'),'pt':'Coreia do Norte','qu':'*es','rm':'Corea dal Nord','rn':u('Koreya y\u2019amajaruguru'),'ro':'*mo','ru':u('\u041a\u041d\u0414\u0420'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u062a\u0631 \u06aa\u0648\u0631\u064a\u0627'),'se':'Davvi-Korea','sg':u('Kor\u00ebe t\u00ee Banga'),'si':u('\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d9a\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0dc0'),'sk':u('Severn\u00e1 K\u00f3rea'),'sl':'Severna Koreja','sm':'*aa','sn':'Korea, North','so':'Kuuriyada Waqooyi','sq':'Koreja e Veriut','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*ki','ta':u('\u0bb5\u0b9f \u0b95\u0bca\u0bb0\u0bbf\u0baf\u0bbe'),'te':u('\u0c09\u0c24\u0c4d\u0c24\u0c30 \u0c15\u0c4a\u0c30\u0c3f\u0c2f\u0c3e'),'tg':u('\u041a\u043e\u0440\u0435\u044f\u0438 \u0428\u0438\u043c\u043e\u043b\u04e3'),'th':u('\u0e40\u0e01\u0e32\u0e2b\u0e25\u0e35\u0e40\u0e2b\u0e19\u0e37\u0e2d'),'ti':'*am','tk':u('Demirgazyk Kore\u00fda'),'tl':'Hilagang Korea','tn':'*aa','to':u('K\u014dlea tokelau'),'tr':'Kuzey Kore','ts':'*aa','tt':u('\u0422\u04e9\u043d\u044c\u044f\u043a \u041a\u043e\u0440\u0435\u044f'),'tw':'*aa','ty':'*aa','ug':u('\u0686\u0627\u06cb\u0634\u064a\u06d5\u0646'),'uk':u('\u041f\u0456\u0432\u043d\u0456\u0447\u043d\u0430 \u041a\u043e\u0440\u0435\u044f'),'ur':'*ps','uz':'Shimoliy Koreya','ve':'*aa','vi':u('Tri\u1ec1u Ti\u00ean'),'vo':'*aa','wa':'*aa','wo':'Kore Noor','xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Guusu K\u1ecdria'),'za':'*aa','zh':u('\u671d\u9c9c'),'zu':'i-North Korea',},
  'KR': {'aa':'South Korea','ab':'*aa','ae':'*aa','af':'Suid-Korea','ak':'Anaafo Koria','am':u('\u12f0\u1261\u1265 \u12ae\u122a\u12eb'),'an':'*aa','ar':u('\u0643\u0648\u0631\u064a\u0627 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629'),'as':u('\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0995\u09cb\u09f0\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':u('C\u0259nubi Koreya'),'ba':'*aa','be':u('\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u044f \u041a\u0430\u0440\u044d\u044f'),'bg':u('\u042e\u0436\u043d\u0430 \u041a\u043e\u0440\u0435\u044f'),'bh':'*aa','bi':'*aa','bm':'Worodugu Kore','bn':u('\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0995\u09cb\u09b0\u09bf\u09af\u09bc\u09be'),'bo':u('\u0f63\u0fb7\u0f7c\u0f0b\u0f40\u0f7c\u0f0b\u0f62\u0f72\u0f0b\u0f61\u0f0d'),'br':'Korea ar Su','bs':u('Ju\u017ena Koreja'),'ca':'Corea del Sud','ce':u('\u041a\u044a\u0438\u043b\u0431\u0430 \u041a\u043e\u0440\u0435\u0439'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Ji\u017en\u00ed Korea'),'cu':'*aa','cv':'*aa','cy':'De Korea','da':'Sydkorea','de':u('S\u00fcdkorea'),'dv':'*aa','dz':u('\u0f63\u0fb7\u0f7c\u0f0b \u0f40\u0f7c\u0f0b\u0f62\u0f72\u0f0b\u0f61'),'ee':'Anyiehe Korea nutome','el':u('\u039d\u03cc\u03c4\u03b9\u03b1 \u039a\u03bf\u03c1\u03ad\u03b1'),'en':'*aa','eo':'Sud-Koreo','es':'Corea del Sur','et':u('L\u00f5una-Korea'),'eu':'Hego Korea','fa':u('\u06a9\u0631\u0647\u0654 \u062c\u0646\u0648\u0628\u06cc'),'ff':'Koree Worgo','fi':u('Etel\u00e4-Korea'),'fj':'*aa','fo':u('Su\u00f0urkorea'),'fr':u('Cor\u00e9e du Sud'),'fy':u('S\u00fbd-Korea'),'ga':u('an Ch\u00f3ir\u00e9 Theas'),'gd':u('Coir\u00e8a'),'gl':'Corea do Sur','gn':'*aa','gu':u('\u0aa6\u0a95\u0acd\u0ab7\u0abf\u0aa3 \u0a95\u0acb\u0ab0\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Koreya Ta Kudu','he':u('\u05e7\u05d5\u05e8\u05d9\u05d0\u05d4 \u05d4\u05d3\u05e8\u05d5\u05de\u05d9\u05ea'),'hi':u('\u0926\u0915\u094d\u0937\u093f\u0923 \u0915\u094b\u0930\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('D\u00e9l-Korea'),'hy':u('\u0540\u0561\u0580\u0561\u057e\u0561\u0575\u056b\u0576 \u053f\u0578\u0580\u0565\u0561'),'hz':'*aa','ia':'*aa','id':'Korea Selatan','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Su\u00f0ur-K\u00f3rea'),'it':'*ca','iu':'*aa','iw':'*he','ja':u('\u97d3\u56fd'),'ji':'*aa','jv':'*aa','ka':u('\u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7 \u10d9\u10dd\u10e0\u10d4\u10d0'),'kg':'*aa','ki':'Korea Kusini','kj':'*aa','kk':u('\u041e\u04a3\u0442\u04af\u0441\u0442\u0456\u043a \u041a\u043e\u0440\u0435\u044f'),'kl':'*aa','km':u('\u1780\u17bc\u179a\u17c9\u17c1\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784'),'kn':u('\u0ca6\u0c95\u0ccd\u0cb7\u0cbf\u0ca3 \u0c95\u0cca\u0cb0\u0cbf\u0caf\u0cbe'),'ko':u('\ub300\ud55c\ubbfc\uad6d'),'kr':'*aa','ks':u('\u062c\u0646\u0648\u0657\u0628\u06cc \u06a9\u0648\u0631\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0422\u04af\u0448\u0442\u04af\u043a \u041a\u043e\u0440\u0435\u044f'),'la':'*aa','lb':'*de','lg':u('Koreya ey\u2019omumaserengeta'),'li':'*aa','ln':u('Kor\u025b ya s\u00fadi'),'lo':u('\u0ec0\u0e81\u0ebb\u0eb2\u0eab\u0ea5\u0eb5\u0ec3\u0e95\u0ec9'),'lt':u('Piet\u0173 Kor\u0117ja'),'lu':'Kore wa mwinshi','lv':'Dienvidkoreja','mg':'Korea Atsimo','mh':'*aa','mi':'*aa','mk':u('\u0408\u0443\u0436\u043d\u0430 \u041a\u043e\u0440\u0435\u0458\u0430'),'ml':u('\u0d26\u0d15\u0d4d\u0d37\u0d3f\u0d23\u0d15\u0d4a\u0d31\u0d3f\u0d2f'),'mn':u('\u04e8\u043c\u043d\u04e9\u0434 \u0421\u043e\u043b\u043e\u043d\u0433\u043e\u0441'),'mo':'Coreea de Sud','mr':'*hi','ms':'*id','mt':u('il-Korea t\u2019Isfel'),'my':u('\u1010\u1031\u102c\u1004\u103a\u1000\u102d\u102f\u101b\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':u('S\u00f8r-Korea'),'nd':'*aa','ne':'*hi','ng':'*aa','nl':'Zuid-Korea','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b15\u0b4b\u0b30\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a26\u0a71\u0a16\u0a23 \u0a15\u0a4b\u0a30\u0a40\u0a06'),'pi':'*aa','pl':u('Korea Po\u0142udniowa'),'ps':u('\u0633\u0648\u06cc\u0644\u064a \u06a9\u0648\u0631\u06cc\u0627'),'pt':'Coreia do Sul','qu':'*es','rm':'Corea dal Sid','rn':u('Koreya y\u2019amajepfo'),'ro':'*mo','ru':u('\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u043e\u0440\u0435\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u068f\u06a9\u06bb \u06aa\u0648\u0631\u064a\u0627'),'se':u('M\u00e1tta-Korea'),'sg':u('Kor\u00ebe t\u00ee Mbongo'),'si':u('\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d9a\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0dc0'),'sk':u('Ju\u017en\u00e1 K\u00f3rea'),'sl':'*bs','sm':'*aa','sn':'Korea, South','so':'Kuuriyada Koonfureed','sq':'Koreja e Jugut','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*ki','ta':u('\u0ba4\u0bc6\u0ba9\u0bcd \u0b95\u0bca\u0bb0\u0bbf\u0baf\u0bbe'),'te':u('\u0c26\u0c15\u0c4d\u0c37\u0c3f\u0c23 \u0c15\u0c4a\u0c30\u0c3f\u0c2f\u0c3e'),'tg':'*aa','th':u('\u0e40\u0e01\u0e32\u0e2b\u0e25\u0e35\u0e43\u0e15\u0e49'),'ti':'*am','tk':u('G\u00fcnorta Kore\u00fda'),'tl':'Timog Korea','tn':'*aa','to':u('K\u014dlea tonga'),'tr':u('G\u00fcney Kore'),'ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':u('\u0643\u0648\u0631\u06d0\u064a\u06d5'),'uk':u('\u041f\u0456\u0432\u0434\u0435\u043d\u043d\u0430 \u041a\u043e\u0440\u0435\u044f'),'ur':u('\u062c\u0646\u0648\u0628\u06cc \u06a9\u0648\u0631\u06cc\u0627'),'uz':'Janubiy Koreya','ve':'*aa','vi':u('H\u00e0n Qu\u1ed1c'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Ariwa K\u1ecdria'),'za':'*aa','zh':u('\u97e9\u56fd'),'zu':'i-South Korea',},
  'KW': {'aa':'Kuwait','ab':'*aa','ae':'*aa','af':'Koeweit','ak':'Kuwete','am':u('\u12ad\u12cc\u1275'),'an':'*aa','ar':u('\u0627\u0644\u0643\u0648\u064a\u062a'),'as':u('\u0995\u09c1\u09f1\u09c7\u0987\u099f'),'av':'*aa','ay':'*aa','az':u('K\u00fcveyt'),'ba':'*aa','be':u('\u041a\u0443\u0432\u0435\u0439\u0442'),'bg':'*be','bh':'*aa','bi':'*aa','bm':u('Kow\u025bti'),'bn':u('\u0995\u09c1\u09af\u09bc\u09c7\u09a4'),'bo':'*aa','br':'Koweit','bs':'Kuvajt','ca':'*aa','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*bs','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f40\u0f74\u0f0b\u0f5d\u0f7a\u0f4a'),'ee':'Kuwait nutome','el':u('\u039a\u03bf\u03c5\u03b2\u03ad\u03b9\u03c4'),'en':'*aa','eo':'Kuvajto','es':'*aa','et':'Kuveit','eu':'*aa','fa':u('\u06a9\u0648\u06cc\u062a'),'ff':'Kuweyti','fi':'*aa','fj':'*aa','fo':'Kuvait','fr':u('Kowe\u00eft'),'fy':'*af','ga':u('Cu\u00e1it'),'gd':u('Cuibh\u00e8it'),'gl':'*aa','gn':'*aa','gu':u('\u0a95\u0ac1\u0ab5\u0ac8\u0aa4'),'gv':'*aa','ha':'Kwiyat','he':u('\u05db\u05d5\u05d5\u05d9\u05ea'),'hi':u('\u0915\u0941\u0935\u0948\u0924'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*fo','hy':u('\u0554\u0578\u0582\u057e\u0565\u0575\u0569'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('K\u00faveit'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30af\u30a6\u30a7\u30fc\u30c8'),'ji':'*aa','jv':'*aa','ka':u('\u10e5\u10e3\u10d5\u10d4\u10d8\u10d7\u10d8'),'kg':'*aa','ki':'Kuwaiti','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u1780\u17bc\u179c\u17c9\u17c2\u178f'),'kn':u('\u0c95\u0cc1\u0cb5\u0cc8\u0ca4\u0ccd'),'ko':u('\ucfe0\uc6e8\uc774\ud2b8'),'kr':'*aa','ks':u('\u06a9\u064f\u0648\u06cc\u062a'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*aa','lg':'Kuweti','li':'*aa','ln':'Koweti','lo':u('\u0e81\u0eb9\u0ec0\u0ea7\u0e94'),'lt':'Kuveitas','lu':'*ln','lv':'Kuveita','mg':u('K\u00f4eity'),'mh':'*aa','mi':'*aa','mk':u('\u041a\u0443\u0432\u0430\u0458\u0442'),'ml':u('\u0d15\u0d41\u0d35\u0d48\u0d31\u0d4d\u0d31\u0d4d'),'mn':'*be','mo':'Kuweit','mr':u('\u0915\u0941\u0935\u0947\u0924'),'ms':'*aa','mt':'il-Kuwajt','my':u('\u1000\u1030\u101d\u102d\u1010\u103a'),'na':'*aa','nb':'*aa','nd':'Khuweiti','ne':'*mr','ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b41\u0b0f\u0b24\u0b4d'),'os':'*aa','pa':u('\u0a15\u0a41\u0a35\u0a48\u0a24'),'pi':'*aa','pl':'Kuwejt','ps':u('\u06a9\u0648\u06cc\u067c'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'*ln','ro':'*mo','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u0648\u064a\u062a'),'se':'*aa','sg':u('K\u00f6w\u00eati'),'si':u('\u0d9a\u0dd4\u0dc0\u0dda\u0da7\u0dba'),'sk':'*bs','sl':'*bs','sm':'*aa','sn':'*aa','so':'Kuwayt','sq':'*bs','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b95\u0bc1\u0bb5\u0bc8\u0ba4\u0bcd'),'te':u('\u0c15\u0c41\u0c35\u0c48\u0c1f\u0c4d'),'tg':u('\u049a\u0443\u0432\u0430\u0439\u0442'),'th':u('\u0e04\u0e39\u0e40\u0e27\u0e15'),'ti':'*am','tk':u('Kuwe\u00fdt'),'tl':'*aa','tn':'*aa','to':'Kueiti','tr':'Kuveyt','ts':'*aa','tt':u('\u041a\u04af\u0432\u04d9\u0439\u0442'),'tw':'*aa','ty':'*aa','ug':u('\u0643\u06c7\u06cb\u06d5\u064a\u062a'),'uk':'*be','ur':'*fa','uz':'Quvayt','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Kowet','xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Kuweti'),'za':'*aa','zh':u('\u79d1\u5a01\u7279'),'zu':'i-Kuwait',},
  'KY': {'aa':'Cayman Islands','ab':'*aa','ae':'*aa','af':'Kaaimanseilande','ak':'Kemanfo Islands','am':u('\u12ab\u12ed\u121b\u1295 \u12f0\u1234\u1276\u127d'),'an':'*aa','ar':u('\u062c\u0632\u0631 \u0643\u0627\u064a\u0645\u0627\u0646'),'as':u('\u0995\u09c7\u0987\u09ae\u09c7\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'av':'*aa','ay':'*aa','az':u('Kayman adalar\u0131'),'ba':'*aa','be':u('\u041a\u0430\u0439\u043c\u0430\u043d\u0430\u0432\u044b \u0430\u0441\u0442\u0440\u0430\u0432\u044b'),'bg':u('\u041a\u0430\u0439\u043c\u0430\u043d\u043e\u0432\u0438 \u043e\u0441\u0442\u0440\u043e\u0432\u0438'),'bh':'*aa','bi':'*aa','bm':'Bama Gun','bn':u('\u0995\u09c7\u09ae\u09cd\u09af\u09be\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'bo':'*aa','br':'Inizi Cayman','bs':'Kajmanska ostrva','ca':'Illes Caiman','ce':u('\u041a\u0430\u0439\u043c\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Kajmansk\u00e9 ostrovy'),'cu':'*aa','cv':'*aa','cy':'Ynysoedd Cayman','da':u('Cayman\u00f8erne'),'de':'Kaimaninseln','dv':'*aa','dz':u('\u0f41\u0f7a\u0f0b\u0f58\u0f7a\u0f53\u0f0b\u0f42\u0fb3\u0f72\u0f44\u0f0b\u0f5a\u0f7c\u0f58'),'ee':u('Kayman \u0192udomekpowo nutome'),'el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u039a\u03ad\u03b9\u03bc\u03b1\u03bd'),'en':'*aa','eo':'Kejmanoj','es':u('Islas Caim\u00e1n'),'et':'Kaimanisaared','eu':'Kaiman uharteak','fa':u('\u062c\u0632\u0627\u06cc\u0631 \u06a9\u0650\u06cc\u0645\u0646'),'ff':u('Duu\u0257e Kaymaa'),'fi':'Caymansaaret','fj':'*aa','fo':'Caymanoyggjar','fr':u('\u00celes Ca\u00efmans'),'fy':'Caymaneilannen','ga':u('Oile\u00e1in Cayman'),'gd':'Na h-Eileanan Caimean','gl':u('Illas Caim\u00e1n'),'gn':'*aa','gu':u('\u0a95\u0ac7\u0aae\u0ac7\u0aa8 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8'),'gv':'*aa','ha':'Tsibiran Kaiman','he':u('\u05d0\u05d9\u05d9 \u05e7\u05d9\u05d9\u05de\u05df'),'hi':u('\u0915\u0948\u092e\u0947\u0928 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939'),'ho':'*aa','hr':'Kajmanski otoci','ht':'*aa','hu':u('Kajm\u00e1n-szigetek'),'hy':u('\u053f\u0561\u0575\u0574\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'Kepulauan Cayman','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'Caymaneyjar','it':'Isole Cayman','iu':'*aa','iw':'*he','ja':u('\u30b1\u30a4\u30de\u30f3\u8af8\u5cf6'),'ji':u('\u05e7\u05d9\u05d9\u05de\u05d0\u05b7\u05df \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df'),'jv':'*aa','ka':u('\u10d9\u10d0\u10d8\u10db\u10d0\u10dc\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'Visiwa vya Kayman','kj':'*aa','kk':u('\u041a\u0430\u0439\u043c\u0430\u043d \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'kl':'*aa','km':u('\u1780\u17c4\u17c7\u200b\u1780\u17c3\u1798\u17c9\u1784\u17cb'),'kn':u('\u0c95\u0cc7\u0cae\u0ca8\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3\u0cc1'),'ko':u('\ucf00\uc774\ub9e8 \uc81c\ub3c4'),'kr':'*aa','ks':u('\u06a9\u06cc\u0645\u064e\u0646 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'Kaimaninselen','lg':'Bizinga ebya Kayimaani','li':'*aa','ln':u('Bisanga bya Kay\u00edma'),'lo':u('\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0 \u0ec0\u0e84\u0ec1\u0ea1\u0e99'),'lt':u('Kaiman\u0173 Salos'),'lu':'Lutanda lua Kayima','lv':'Kaimanu salas','mg':'Nosy Kayman','mh':'*aa','mi':'*aa','mk':u('\u041a\u0430\u0458\u043c\u0430\u043d\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438'),'ml':u('\u0d15\u0d47\u0d2f\u0d4d\u0d2e\u0d3e\u0d7b \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e'),'mn':u('\u041a\u0430\u0439\u043c\u0430\u043d\u044b \u0430\u0440\u043b\u0443\u0443\u0434'),'mo':'Insulele Cayman','mr':u('\u0915\u0947\u092e\u0928 \u092c\u0947\u091f\u0947'),'ms':'*id','mt':u('il-G\u017cejjer Cayman'),'my':u('\u1000\u1031\u1019\u1014\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f'),'na':'*aa','nb':u('Cayman\u00f8yene'),'nd':'*aa','ne':u('\u0915\u0947\u092f\u092e\u093e\u0928 \u091f\u093e\u092a\u0941'),'ng':'*aa','nl':'Kaaimaneilanden','nn':u('Cayman\u00f8yane'),'no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b47\u0b2e\u0b4d\u0b5f\u0b3e\u0b28\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c'),'os':'*aa','pa':u('\u0a15\u0a47\u0a2e\u0a48\u0a28 \u0a1f\u0a3e\u0a2a\u0a42'),'pi':'*aa','pl':'Kajmany','ps':u('\u06a9\u06cc\u0645\u0627\u0646 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646'),'pt':'Ilhas Cayman','qu':'*aa','rm':'Inslas Cayman','rn':'Ibirwa bya Keyimani','ro':'*mo','ru':u('\u041a\u0430\u0439\u043c\u0430\u043d\u043e\u0432\u044b \u043e-\u0432\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u06aa\u064a \u0645\u064a\u0646 \u067b\u064a\u067d'),'se':'Cayman-sullot','sg':u('\u00c2z\u00fb\u00e2 Ngund\u00eb, Kaim\u00e4ni'),'si':u('\u0d9a\u0dda\u0db8\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca'),'sk':'Kajmanie ostrovy','sl':'Kajmanski otoki','sm':'*aa','sn':'Zvitsuwa zveCayman','so':'*aa','sq':'Ishujt Kajman','sr':u('\u041a\u0430\u0458\u043c\u0430\u043d\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Cayman\u00f6arna'),'sw':'Visiwa vya Cayman','ta':u('\u0b95\u0bc6\u0baf\u0bcd\u0bae\u0bc6\u0ba9\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd'),'te':u('\u0c15\u0c47\u0c2e\u0c3e\u0c28\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41'),'tg':u('\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u041a\u0430\u0439\u043c\u0430\u043d'),'th':u('\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e40\u0e04\u0e22\u0e4c\u0e41\u0e21\u0e19'),'ti':'*am','tk':u('Ka\u00fdman adalary'),'tl':'*aa','tn':'*aa','to':u('\u02bbOtumotu Keimeni'),'tr':u('Cayman Adalar\u0131'),'ts':'*aa','tt':u('\u041a\u0430\u0439\u043c\u0430\u043d \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0643\u0627\u064a\u0645\u0627\u0646 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649'),'uk':u('\u041a\u0430\u0439\u043c\u0430\u043d\u043e\u0432\u0456 \u043e\u0441\u0442\u0440\u043e\u0432\u0438'),'ur':u('\u06a9\u06cc\u0645\u06cc\u0646 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632'),'uz':'Kayman orollari','ve':'*aa','vi':u('Qu\u1ea7n \u0111\u1ea3o Cayman'),'vo':'*aa','wa':'*aa','wo':u('Duni Kayma\u014b'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Et\u00edokun K\u00e1m\u00e1n\u00ec'),'za':'*aa','zh':u('\u5f00\u66fc\u7fa4\u5c9b'),'zu':'i-Cayman Islands',},
  'KZ': {'aa':'Kazakhstan','ab':'*aa','ae':'*aa','af':'Kazakstan','ak':'*af','am':u('\u12ab\u12db\u12aa\u1235\u1273\u1295'),'an':'*aa','ar':u('\u0643\u0627\u0632\u0627\u062e\u0633\u062a\u0627\u0646'),'as':u('\u0995\u09be\u099c\u09be\u0996\u09be\u09b8\u09cd\u09a4\u09be\u09a8'),'av':'*aa','ay':'*aa','az':u('Qazax\u0131stan'),'ba':'*aa','be':u('\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d'),'bg':'*be','bh':'*aa','bi':'*aa','bm':u('Kazakista\u014b'),'bn':u('\u0995\u09be\u099c\u09be\u0996\u09b8\u09cd\u09a4\u09be\u09a8'),'bo':'*aa','br':'*af','bs':'Kazahstan','ca':'*aa','ce':u('\u041a\u0445\u0430\u0437\u0430\u043a\u0445\u0441\u0442\u0430\u043d'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Kazachst\u00e1n'),'cu':'*aa','cv':'*aa','cy':'*af','da':'Kasakhstan','de':'Kasachstan','dv':'*aa','dz':u('\u0f40\u0f0b\u0f5b\u0f42\u0f66\u0f0b\u0f66\u0f4f\u0f71\u0f53'),'ee':'Kazakstan nutome','el':u('\u039a\u03b1\u03b6\u03b1\u03ba\u03c3\u03c4\u03ac\u03bd'),'en':'*aa','eo':u('Kaza\u0125stano'),'es':u('Kazajist\u00e1n'),'et':'Kasahstan','eu':'*aa','fa':u('\u0642\u0632\u0627\u0642\u0633\u062a\u0627\u0646'),'ff':'Kasakstaan','fi':'*af','fj':'*aa','fo':'Kasakstan','fr':'*aa','fy':'Kazachstan','ga':u('an Chasacst\u00e1in'),'gd':u('Casachst\u00e0n'),'gl':u('Casaquist\u00e1n'),'gn':'*aa','gu':u('\u0a95\u0a9d\u0abe\u0a95\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8'),'gv':'*aa','ha':'Kazakistan','he':u('\u05e7\u05d6\u05d7\u05e1\u05d8\u05df'),'hi':u('\u0915\u091c\u093c\u093e\u0916\u0938\u094d\u0924\u093e\u0928'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Kazahszt\u00e1n'),'hy':u('\u0542\u0561\u0566\u0561\u056d\u057d\u057f\u0561\u0576'),'hz':'*aa','ia':'*aa','id':'*af','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*af','io':'*aa','is':'*fo','it':'*ha','iu':'*aa','iw':'*he','ja':u('\u30ab\u30b6\u30d5\u30b9\u30bf\u30f3'),'ji':'*aa','jv':'*aa','ka':u('\u10e7\u10d0\u10d6\u10d0\u10ee\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'Kazakistani','kj':'*aa','kk':u('\u049a\u0430\u0437\u0430\u049b\u0441\u0442\u0430\u043d'),'kl':'*aa','km':u('\u1780\u17b6\u17a0\u17d2\u179f\u17b6\u1780\u17cb\u179f\u17d2\u1790\u17b6\u1793'),'kn':u('\u0c95\u0c9d\u0cbe\u0c95\u0cbf\u0cb8\u0ccd\u0ca5\u0cbe\u0ca8\u0ccd'),'ko':u('\uce74\uc790\ud750\uc2a4\ud0c4'),'kr':'*aa','ks':u('\u06a9\u064e\u0632\u0627\u06a9\u0650\u0633\u062a\u0627\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u041a\u0430\u0437\u0430\u043a\u0441\u0442\u0430\u043d'),'la':'*aa','lb':'*de','lg':'Kazakisitaani','li':'*aa','ln':u('Kazakisit\u00e1'),'lo':u('\u0e84\u0eb2\u0e8a\u0eb1\u0e81\u0eaa\u0eb0\u0e96\u0eb2\u0e99'),'lt':'Kazachstanas','lu':'Kazakusita','lv':u('Kazahst\u0101na'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d15\u0d38\u0d3e\u0d16\u0d3f\u0d38\u0d4d\u0d25\u0d3e\u0d7b'),'mn':'*be','mo':'*bs','mr':u('\u0915\u091d\u093e\u0915\u0938\u094d\u0924\u093e\u0928'),'ms':'*aa','mt':u('il-Ka\u017cakistan'),'my':u('\u1000\u102c\u1007\u1000\u103a\u1005\u1010\u1014\u103a'),'na':'*aa','nb':'*da','nd':'*aa','ne':u('\u0915\u093e\u091c\u093e\u0915\u0938\u094d\u0924\u093e\u0928'),'ng':'*aa','nl':'*fy','nn':'*da','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b3e\u0b1c\u0b3e\u0b15\u0b3e\u0b38\u0b4d\u0b24\u0b3e\u0b28'),'os':'*aa','pa':u('\u0a15\u0a1c\u0a3c\u0a3e\u0a16\u0a38\u0a24\u0a3e\u0a28'),'pi':'*aa','pl':'*fy','ps':'*fa','pt':u('Cazaquist\u00e3o'),'qu':'*es','rm':'*de','rn':'Kazakisitani','ro':'*bs','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0642\u0627\u0632\u0642\u0633\u062a\u0627\u0646'),'se':'*fo','sg':u('Kazakisit\u00e4an'),'si':u('\u0d9a\u0dc3\u0d9a\u0dc3\u0dca\u0dad\u0dcf\u0db1\u0dba'),'sk':'*fy','sl':'*bs','sm':'*aa','sn':'*aa','so':'Kasaakhistaan','sq':'*ha','sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*af','sw':'*ki','ta':u('\u0b95\u0bb8\u0b95\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd'),'te':u('\u0c15\u0c1c\u0c15\u0c3f\u0c38\u0c4d\u0c24\u0c3e\u0c28\u0c4d'),'tg':u('\u049a\u0430\u0437\u043e\u049b\u0438\u0441\u0442\u043e\u043d'),'th':u('\u0e04\u0e32\u0e0b\u0e31\u0e04\u0e2a\u0e16\u0e32\u0e19'),'ti':'*am','tk':'Gazagystan','tl':'*aa','tn':'*aa','to':'Kasakitani','tr':'*ha','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u0642\u0627\u0632\u0627\u0642\u0649\u0633\u062a\u0627\u0646'),'uk':'*be','ur':u('\u0642\u0632\u0627\u062e\u0633\u062a\u0627\u0646'),'uz':u('Qozog\u02bbiston'),'ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':u('Kasaxsta\u014b'),'xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Ka\u1e63a\u1e63atani'),'za':'*aa','zh':u('\u54c8\u8428\u514b\u65af\u5766'),'zu':'i-Kazakhstan',},
  'LA': {'aa':'Laos','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u120b\u12a6\u1235'),'an':'*aa','ar':u('\u0644\u0627\u0648\u0633'),'as':u('\u09b2\u09be\u0993\u099a'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u041b\u0430\u043e\u0441'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'Layosi','bn':u('\u09b2\u09be\u0993\u09b8'),'bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f63\u0f71\u0f0b\u0f5d\u0f7c\u0f66'),'ee':'Laos nutome','el':u('\u039b\u03ac\u03bf\u03c2'),'en':'*aa','eo':'Laoso','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0644\u0627\u0626\u0648\u0633'),'ff':'Lawoos','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':u('L\u00e0thos'),'gl':'*aa','gn':'*aa','gu':u('\u0ab2\u0abe\u0a93\u0ab8'),'gv':'*aa','ha':'Lawas','he':u('\u05dc\u05d0\u05d5\u05e1'),'hi':u('\u0932\u093e\u0913\u0938'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'Laosz','hy':u('\u053c\u0561\u0578\u057d'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30e9\u30aa\u30b9'),'ji':u('\u05dc\u05d0\u05b7\u05d0\u05e1'),'jv':'*aa','ka':u('\u10da\u10d0\u10dd\u10e1\u10d8'),'kg':'*aa','ki':'Laosi','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u17a1\u17b6\u179c'),'kn':u('\u0cb2\u0cbe\u0cb5\u0ccb\u0cb8\u0ccd'),'ko':u('\ub77c\uc624\uc2a4'),'kr':'*aa','ks':u('\u0644\u0627\u0633'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*aa','lg':'Lawosi','li':'*aa','ln':'*lg','lo':u('\u0ea5\u0eb2\u0ea7'),'lt':'Laosas','lu':'*lg','lv':'Laosa','mg':u('La\u00f4s'),'mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d32\u0d3e\u0d35\u0d4b\u0d38\u0d4d'),'mn':'*be','mo':'*aa','mr':'*hi','ms':'*aa','mt':'il-Laos','my':u('\u101c\u102c\u1021\u102d\u102f'),'na':'*aa','nb':'*aa','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b32\u0b3e\u0b13\u0b38\u0b4d'),'os':'*aa','pa':u('\u0a32\u0a3e\u0a13\u0a38'),'pi':'*aa','pl':'*aa','ps':u('\u0644\u0627\u0648\u0648\u0633'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'*bm','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*fa','se':'*aa','sg':u('L\u00f9a\u00f4si'),'si':u('\u0dbd\u0dcf\u0d95\u0dc3\u0dba'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0bb2\u0bbe\u0bb5\u0bcb\u0bb8\u0bcd'),'te':u('\u0c32\u0c3e\u0c35\u0c4b\u0c38\u0c4d'),'tg':'*be','th':u('\u0e25\u0e32\u0e27'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':'Lau','tr':'*aa','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':'*fa','uk':'*be','ur':u('\u0644\u0627\u0624\u0633'),'uz':'*aa','ve':'*aa','vi':u('L\u00e0o'),'vo':'*aa','wa':'*aa','wo':'Lawos','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Laosi'),'za':'*aa','zh':u('\u8001\u631d'),'zu':'i-Laos',},
  'LB': {'aa':'Lebanon','ab':'*aa','ae':'*aa','af':'Libanon','ak':u('L\u025bban\u0254n'),'am':u('\u120a\u1263\u1296\u1235'),'an':'*aa','ar':u('\u0644\u0628\u0646\u0627\u0646'),'as':u('\u09b2\u09c7\u09ac\u09be\u09a8\u09a8'),'av':'*aa','ay':'*aa','az':'Livan','ba':'*aa','be':u('\u041b\u0456\u0432\u0430\u043d'),'bg':u('\u041b\u0438\u0432\u0430\u043d'),'bh':'*aa','bi':'*aa','bm':u('Liba\u014b'),'bn':'*as','bo':'*aa','br':'Liban','bs':'*br','ca':u('L\u00edban'),'ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*af','cu':'*aa','cv':'*aa','cy':'Libanus','da':'*af','de':'*af','dv':'*aa','dz':u('\u0f63\u0f7a\u0f0b\u0f56\u0f0b\u0f53\u0f7c\u0f53'),'ee':u('Leban\u0254n nutome'),'el':u('\u039b\u03af\u03b2\u03b1\u03bd\u03bf\u03c2'),'en':'*aa','eo':'Libano','es':u('L\u00edbano'),'et':'Liibanon','eu':'*eo','fa':'*ar','ff':'Libaa','fi':'*af','fj':'*aa','fo':'*af','fr':'*br','fy':'*af','ga':u('an Liob\u00e1in'),'gd':'Leabanon','gl':'*es','gn':'*aa','gu':u('\u0ab2\u0ac7\u0aac\u0aa8\u0acb\u0aa8'),'gv':'*aa','ha':'Labanan','he':u('\u05dc\u05d1\u05e0\u05d5\u05df'),'hi':u('\u0932\u0947\u092c\u0928\u093e\u0928'),'ho':'*aa','hr':'*af','ht':'*aa','hu':'*af','hy':u('\u053c\u056b\u0562\u0561\u0576\u0561\u0576'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('L\u00edbanon'),'it':'*eo','iu':'*aa','iw':'*he','ja':u('\u30ec\u30d0\u30ce\u30f3'),'ji':'*he','jv':'*aa','ka':u('\u10da\u10d8\u10d1\u10d0\u10dc\u10d8'),'kg':'*aa','ki':'Lebanoni','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u179b\u17b8\u1794\u1784\u17cb'),'kn':u('\u0cb2\u0cc6\u0cac\u0ca8\u0cbe\u0ca8\u0ccd'),'ko':u('\ub808\ubc14\ub17c'),'kr':'*aa','ks':u('\u0644\u066e\u06ea\u0628\u0646\u0627\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*af','lg':'*ki','li':'*aa','ln':u('Lib\u00e1'),'lo':u('\u0ec0\u0ea5\u0e9a\u0eb2\u0e99\u0ead\u0e99'),'lt':'Libanas','lu':'Liba','lv':u('Lib\u0101na'),'mg':'Libana','mh':'*aa','mi':'*aa','mk':u('\u041b\u0438\u0431\u0430\u043d'),'ml':u('\u0d32\u0d46\u0d2c\u0d28\u0d7b'),'mn':'*bg','mo':'*br','mr':u('\u0932\u0947\u092c\u0928\u0949\u0928'),'ms':'Lubnan','mt':'il-Libanu','my':u('\u101c\u1000\u103a\u1018\u1014\u103d\u1014\u103a'),'na':'*aa','nb':'*af','nd':'Lebhanoni','ne':u('\u0932\u0947\u092c\u0928\u0928'),'ng':'*aa','nl':'*af','nn':'*af','no':'*af','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b32\u0b47\u0b2c\u0b3e\u0b28\u0b28\u0b4d'),'os':'*aa','pa':u('\u0a32\u0a48\u0a2c\u0a28\u0a3e\u0a28'),'pi':'*aa','pl':'*br','ps':u('\u0644\u06d0\u0628\u0646\u0627\u0646'),'pt':'*es','qu':'*es','rm':'*af','rn':'Libani','ro':'*br','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*ar','se':'*af','sg':u('Lib\u00f9aan'),'si':u('\u0dbd\u0dd9\u0db6\u0db1\u0db1\u0dba'),'sk':'*af','sl':'*af','sm':'*aa','sn':'*aa','so':'Lubnaan','sq':'*br','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*af','sw':'*aa','ta':u('\u0bb2\u0bc6\u0baa\u0ba9\u0bbe\u0ba9\u0bcd'),'te':u('\u0c32\u0c46\u0c2c\u0c28\u0c3e\u0c28\u0c4d'),'tg':u('\u041b\u0443\u0431\u043d\u043e\u043d'),'th':u('\u0e40\u0e25\u0e1a\u0e32\u0e19\u0e2d\u0e19'),'ti':'*am','tk':'Liwan','tl':'*aa','tn':'*aa','to':'Lepanoni','tr':u('L\u00fcbnan'),'ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0644\u0649\u06cb\u0627\u0646'),'uk':'*be','ur':'*ar','uz':'*az','ve':'*aa','vi':u('Li-b\u0103ng'),'vo':'*aa','wa':'*aa','wo':'*ff','xh':'*aa','yi':'*he','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Lebanoni'),'za':'*aa','zh':u('\u9ece\u5df4\u5ae9'),'zu':'i-Lebanon',},
  'LC': {'aa':'Saint Lucia','ab':'*aa','ae':'*aa','af':'Sint Lucia','ak':'*aa','am':u('\u1234\u1295\u1275 \u1209\u127a\u12eb'),'an':'*aa','ar':u('\u0633\u0627\u0646\u062a \u0644\u0648\u0633\u064a\u0627'),'as':u('\u099b\u09c7\u0987\u09a3\u09cd\u099f \u09b2\u09c1\u099a\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Sent-Lusiya','ba':'*aa','be':u('\u0421\u0435\u043d\u0442-\u041b\u044e\u0441\u0456\u044f'),'bg':u('\u0421\u0435\u0439\u043d\u0442 \u041b\u0443\u0441\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Lusi-Senu','bn':u('\u09b8\u09c7\u09a8\u09cd\u099f \u09b2\u09c1\u09b8\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'*aa','bs':'Sveta Lucija','ca':'*aa','ce':u('\u0421\u0435\u043d\u0442-\u041b\u044e\u0441\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Svat\u00e1 Lucie'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'St. Lucia','dv':'*aa','dz':u('\u0f66\u0f7a\u0f53\u0f4a\u0f0b \u0f63\u0f74\u0f0b\u0f66\u0f72\u0f0b\u0f61'),'ee':'Saint Lusia nutome','el':u('\u0391\u03b3\u03af\u03b1 \u039b\u03bf\u03c5\u03ba\u03af\u03b1'),'en':'*de','eo':'Sent-Lucio','es':u('Santa Luc\u00eda'),'et':'*aa','eu':'Santa Luzia','fa':u('\u0633\u0646\u062a \u0644\u0648\u0633\u06cc\u0627'),'ff':'Sent Lusiyaa','fi':'*aa','fj':'*aa','fo':'St. Lusia','fr':'Sainte-Lucie','fy':'*aa','ga':'*aa','gd':u('Naomh L\u00f9isea'),'gl':'*es','gn':'*aa','gu':u('\u0ab8\u0ac7\u0a82\u0a9f \u0ab2\u0ac1\u0ab8\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'San Lusiya','he':u('\u05e1\u05e0\u05d8 \u05dc\u05d5\u05e1\u05d9\u05d4'),'hi':u('\u0938\u0947\u0902\u091f \u0932\u0942\u0938\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u054d\u0565\u0576\u0569 \u053c\u0575\u0578\u0582\u057d\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Sankti L\u00fas\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30bb\u30f3\u30c8\u30eb\u30b7\u30a2'),'ji':'*aa','jv':'*aa','ka':u('\u10e1\u10d4\u10dc\u10e2-\u10da\u10e3\u10e1\u10d8\u10d0'),'kg':'*aa','ki':'Santalusia','kj':'*aa','kk':u('\u0421\u0435\u043d\u0442-\u041b\u044e\u0441\u0438\u044f'),'kl':'*aa','km':u('\u179f\u17b6\u17c6\u1784\u179b\u17bc\u179f\u17ca\u17b8'),'kn':u('\u0cb8\u0cc7\u0c82\u0c9f\u0ccd \u0cb2\u0cc2\u0cb8\u0cbf\u0caf\u0cbe'),'ko':u('\uc138\uc778\ud2b8\ub8e8\uc2dc\uc544'),'kr':'*aa','ks':u('\u0633\u06cc\u0646\u065b\u0679 \u0644\u0648\u0657\u0633\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*de','lg':'Senti Luciya','li':'*aa','ln':u('S\u00e1ntu lisi'),'lo':u('\u0ec0\u0e8a\u0e99 \u0ea5\u0eb9\u0ec0\u0e8a\u0e8d'),'lt':'Sent Lusija','lu':'Santu lisi','lv':u('Sentl\u016bsija'),'mg':'*fr','mh':'*aa','mi':'*aa','mk':u('\u0421\u0435\u043d\u0442 \u041b\u0443\u0441\u0438\u0458\u0430'),'ml':u('\u0d38\u0d46\u0d28\u0d4d\u0d31\u0d4d \u0d32\u0d42\u0d38\u0d3f\u0d2f'),'mn':u('\u0421\u0435\u043d\u0442 \u041b\u044e\u0441\u0438\u0430'),'mo':u('Sf\u00e2nta Lucia'),'mr':u('\u0938\u0947\u0902\u091f \u0932\u094d\u092f\u0942\u0938\u093f\u092f\u093e'),'ms':'*aa','mt':'*aa','my':u('\u1005\u102d\u1014\u1037\u103a\u101c\u1030\u1005\u102e\u101a\u102c'),'na':'*aa','nb':'*de','nd':'*aa','ne':u('\u0938\u0947\u0928\u094d\u091f \u0932\u0941\u0938\u093f\u092f\u093e'),'ng':'*aa','nl':'*aa','nn':'*de','no':'*de','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b32\u0b41\u0b38\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a38\u0a47\u0a02\u0a1f \u0a32\u0a42\u0a38\u0a40\u0a06'),'pi':'*aa','pl':'*aa','ps':u('\u0633\u06cc\u0646\u067c \u0644\u0648\u0633\u06cc\u0627'),'pt':u('Santa L\u00facia'),'qu':'*aa','rm':'*aa','rn':'Selusiya','ro':'*mo','ru':'*kk','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u064a\u0646\u067d \u0644\u0648\u0633\u064a\u0627'),'se':'*aa','sg':u('S\u00eant-Lis\u00efi'),'si':u('\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0dbd\u0dd4\u0dc3\u0dd2\u0dba\u0dcf'),'sk':u('Sv\u00e4t\u00e1 Lucia'),'sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':u('Sh\u00ebn-Lu\u00e7ia'),'sr':u('\u0421\u0432\u0435\u0442\u0430 \u041b\u0443\u0446\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'S:t Lucia','sw':'*de','ta':u('\u0b9a\u0bc6\u0baf\u0bbf\u0ba9\u0bcd\u0b9f\u0bcd \u0bb2\u0bc2\u0b9a\u0bbf\u0baf\u0bbe'),'te':u('\u0c38\u0c46\u0c2f\u0c3f\u0c02\u0c1f\u0c4d \u0c32\u0c42\u0c38\u0c3f\u0c2f\u0c3e'),'tg':'*kk','th':u('\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e25\u0e39\u0e40\u0e0b\u0e35\u0e22'),'ti':'*am','tk':u('Sent-L\u00fdusi\u00fda'),'tl':'*aa','tn':'*aa','to':u('S\u0101 L\u016bsia'),'tr':'*aa','ts':'*aa','tt':'*kk','tw':'*aa','ty':'*aa','ug':u('\u0633\u0627\u064a\u0646\u062a \u0644\u06c7\u0633\u0649\u064a\u06d5'),'uk':'*be','ur':u('\u0633\u06cc\u0646\u0679 \u0644\u0648\u0633\u06cc\u0627'),'uz':'Sent-Lyusiya','ve':'*aa','vi':'*de','vo':'*aa','wa':'*aa','wo':u('Sa\u014b Lusi'),'xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Lu\u1e63ia'),'za':'*aa','zh':u('\u5723\u5362\u897f\u4e9a'),'zu':'i-Saint Lucia',},
  'LI': {'aa':'Liechtenstein','ab':'*aa','ae':'*aa','af':'*aa','ak':'Lektenstaen','am':u('\u120a\u127d\u1270\u1295\u1235\u1273\u12ed\u1295'),'an':'*aa','ar':u('\u0644\u064a\u062e\u062a\u0646\u0634\u062a\u0627\u064a\u0646'),'as':u('\u09b2\u09bf\u099a\u099f\u09c7\u09a8\u09b7\u09cd\u099f\u09c7\u0987\u09a8'),'av':'*aa','ay':'*aa','az':u('Lixten\u015fteyn'),'ba':'*aa','be':u('\u041b\u0456\u0445\u0442\u044d\u043d\u0448\u0442\u044d\u0439\u043d'),'bg':u('\u041b\u0438\u0445\u0442\u0435\u043d\u0449\u0430\u0439\u043d'),'bh':'*aa','bi':'*aa','bm':u('Lis\u025bnsitayini'),'bn':u('\u09b2\u09bf\u099a\u09c7\u09a8\u09b8\u09cd\u099f\u09c7\u0987\u09a8'),'bo':'*aa','br':'*aa','bs':u('Lihten\u0161tajn'),'ca':'*aa','ce':u('\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0439\u043d'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Lichten\u0161tejnsko'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f63\u0f72\u0f40\u0f0b\u0f4f\u0f53\u0f66\u0f0b\u0f4f\u0f0b\u0f61\u0f72\u0f53'),'ee':'Litsenstein nutome','el':u('\u039b\u03b9\u03c7\u03c4\u03b5\u03bd\u03c3\u03c4\u03ac\u03b9\u03bd'),'en':'*aa','eo':u('Li\u0125ten\u015dtejno'),'es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0644\u06cc\u062e\u062a\u0646\u200c\u0627\u0634\u062a\u0627\u06cc\u0646'),'ff':'Lincenstayn','fi':'*aa','fj':'*aa','fo':'Liktinstein','fr':'*aa','fy':'*aa','ga':u('Lichtinst\u00e9in'),'gd':'Lichtenstein','gl':'*aa','gn':'*aa','gu':u('\u0ab2\u0ac8\u0a9a\u0a9f\u0ac7\u0a82\u0ab8\u0acd\u0a9f\u0ac7\u0a87\u0aa8'),'gv':'*aa','ha':'Licansitan','he':u('\u05dc\u05d9\u05db\u05d8\u05e0\u05e9\u05d8\u05d9\u05d9\u05df'),'hi':u('\u0932\u093f\u091a\u0947\u0902\u0938\u094d\u091f\u0940\u0928'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u053c\u056b\u056d\u057f\u0565\u0576\u0577\u057f\u0565\u0575\u0576'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30ea\u30d2\u30c6\u30f3\u30b7\u30e5\u30bf\u30a4\u30f3'),'ji':'*he','jv':'*aa','ka':u('\u10da\u10d8\u10ee\u10e2\u10d4\u10dc\u10e8\u10e2\u10d0\u10d8\u10dc\u10d8'),'kg':'*aa','ki':'Lishenteni','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u179b\u17b7\u1785\u178f\u17b7\u1793\u179f\u17d2\u178a\u17b6\u1789'),'kn':u('\u0cb2\u0cbf\u0c9a\u0cc6\u0ca8\u0ccd\u200c\u0cb8\u0ccd\u0c9f\u0cc8\u0ca8\u0ccd'),'ko':u('\ub9ac\ud788\ud150\uc288\ud0c0\uc778'),'kr':'*aa','ks':u('\u0644\u0650\u06a9\u0679\u06cc\u065b\u0633\u0679\u06cc\u0656\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*aa','lg':'Licitensitayini','li':'*aa','ln':u('Lish\u025bteni'),'lo':u('\u0ea5\u0eb4\u0e94\u0ec0\u0e97\u0e99\u0eaa\u0eb0\u0e95\u0eb2\u0e8d'),'lt':u('Lichten\u0161teinas'),'lu':'Lishuteni','lv':u('Lihten\u0161teina'),'mg':'Listenstein','mh':'*aa','mi':'*aa','mk':u('\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0430\u0458\u043d'),'ml':u('\u0d32\u0d3f\u0d1a\u0d4d\u0d1a\u0d7a\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d48\u0d7b'),'mn':'*ce','mo':'*aa','mr':u('\u0932\u093f\u0915\u094d\u091f\u0947\u0928\u0938\u094d\u091f\u093e\u0907\u0928'),'ms':'*aa','mt':'il-Liechtenstein','my':u('\u101c\u1005\u103a\u1010\u1014\u103a\u1005\u1010\u102d\u1014\u103a\u1038'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0932\u093f\u090f\u0916\u091f\u0947\u0928\u094d\u0938\u094d\u091f\u093e\u0907\u0928'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b32\u0b3f\u0b1a\u0b47\u0b1f\u0b28\u0b37\u0b4d\u0b1f\u0b47\u0b07\u0b28\u0b4d'),'os':'*aa','pa':u('\u0a32\u0a3f\u0a1a\u0a47\u0a02\u0a38\u0a1f\u0a3e\u0a07\u0a28'),'pi':'*aa','pl':'*aa','ps':u('\u0644\u06cc\u062e\u062a\u0646 \u0627\u0634\u062a\u0627\u06cc\u0646'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'Lishyitenshitayini','ro':'*aa','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0644\u0686\u064a \u067d\u064a\u0646\u0633\u067d\u064a\u0646'),'se':'*aa','sg':'Liechtenstein,','si':u('\u0dbd\u0dd2\u0d9a\u0dca\u0da7\u0db1\u0dca\u0dc3\u0dca\u0da7\u0dba\u0dd2\u0db1\u0dca'),'sk':u('Lichten\u0161tajnsko'),'sl':'*bs','sm':'*aa','sn':'*aa','so':'*aa','sq':'Lihtenshtajn','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0bb2\u0bbf\u0b9a\u0bcd\u0b9a\u0bc6\u0ba3\u0bcd\u0bb8\u0bcd\u0b9f\u0bc6\u0baf\u0bcd\u0ba9\u0bcd'),'te':u('\u0c32\u0c3f\u0c15\u0c4d\u0c1f\u0c46\u0c28\u0c4d\u200c\u0c38\u0c4d\u0c1f\u0c46\u0c2f\u0c3f\u0c28\u0c4d'),'tg':'*ce','th':u('\u0e25\u0e34\u0e01\u0e40\u0e15\u0e19\u0e2a\u0e44\u0e15\u0e19\u0e4c'),'ti':'*am','tk':u('Lihten\u015fte\u00fdn'),'tl':'*aa','tn':'*aa','to':'Likitenisiteini','tr':'*aa','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u0644\u0649\u0643\u062a\u06d0\u0646\u0633\u062a\u06d0\u064a\u0646'),'uk':u('\u041b\u0456\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0439\u043d'),'ur':u('\u0644\u06cc\u0634\u0679\u0646\u0633\u0679\u0627\u0626\u0646'),'uz':'Lixtenshteyn','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Liktensteyin','xh':'*aa','yi':'*he','yo':u('Or\u00edl\u1eb9\u0301\u00e8de L\u1eb9\u1e63it\u1eb9nisiteni'),'za':'*aa','zh':u('\u5217\u652f\u6566\u58eb\u767b'),'zu':'i-Liechtenstein',},
  'LK': {'aa':'Sri Lanka','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u1232\u122a\u120b\u1295\u12ab'),'an':'*aa','ar':u('\u0633\u0631\u064a\u0644\u0627\u0646\u0643\u0627'),'as':u('\u09b6\u09cd\u09b0\u09c0\u09b2\u0982\u0995\u09be'),'av':'*aa','ay':'*aa','az':u('\u015eri-Lanka'),'ba':'*aa','be':u('\u0428\u0440\u044b-\u041b\u0430\u043d\u043a\u0430'),'bg':u('\u0428\u0440\u0438 \u041b\u0430\u043d\u043a\u0430'),'bh':'*aa','bi':'*aa','bm':'Sirilanka','bn':u('\u09b6\u09cd\u09b0\u09c0\u09b2\u0999\u09cd\u0995\u09be'),'bo':'*aa','br':'*aa','bs':u('\u0160ri Lanka'),'ca':'*aa','ce':u('\u0428\u0440\u0438-\u041b\u0430\u043d\u043a\u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Sr\u00ed Lanka'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f64\u0fb2\u0f71\u0f72\u0f0b\u0f63\u0f44\u0f0b\u0f40'),'ee':'Sri Lanka nutome','el':u('\u03a3\u03c1\u03b9 \u039b\u03ac\u03bd\u03ba\u03b1'),'en':'*aa','eo':'Sri-Lanko','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0633\u0631\u06cc\u200c\u0644\u0627\u0646\u06a9\u0627'),'ff':'Siri Lanka','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Sr\u00ed Lanca'),'gd':'Sri Lanca','gl':'*aa','gn':'*aa','gu':u('\u0ab6\u0acd\u0ab0\u0ac0\u0ab2\u0a82\u0a95\u0abe'),'gv':'*aa','ha':'*ff','he':u('\u05e1\u05e8\u05d9 \u05dc\u05e0\u05e7\u05d4'),'hi':u('\u0936\u094d\u0930\u0940\u0932\u0902\u0915\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*cs','hy':u('\u0547\u0580\u056b \u053c\u0561\u0576\u056f\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*cs','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30b9\u30ea\u30e9\u30f3\u30ab'),'ji':u('\u05e1\u05e8\u05d9\u05be\u05dc\u05d0\u05b7\u05e0\u05e7\u05d0\u05b7'),'jv':'*aa','ka':u('\u10e8\u10e0\u10d8-\u10da\u10d0\u10dc\u10d9\u10d0'),'kg':'*aa','ki':'*bm','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u179f\u17d2\u179a\u17b8\u179b\u1784\u17d2\u1780\u17b6'),'kn':u('\u0cb6\u0ccd\u0cb0\u0cc0\u0cb2\u0c82\u0c95\u0cbe'),'ko':u('\uc2a4\ub9ac\ub791\uce74'),'kr':'*aa','ks':u('\u0633\u0650\u0631\u06cc\u0656\u0644\u064e\u0646\u065b\u06a9\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*aa','lg':'*bm','li':'*aa','ln':'*bm','lo':u('\u0eaa\u0eb5\u0ea5\u0eb1\u0e87\u0e81\u0eb2'),'lt':'*bs','lu':'*bm','lv':u('\u0160rilanka'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d36\u0d4d\u0d30\u0d40\u0d32\u0d19\u0d4d\u0d15'),'mn':'*ce','mo':'*aa','mr':'*hi','ms':'*aa','mt':'is-Sri Lanka','my':u('\u101e\u102e\u101b\u102d\u101c\u1004\u103a\u1039\u1000\u102c'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0936\u094d\u0930\u0940\u0932\u0919\u094d\u0915\u093e'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b36\u0b4d\u0b30\u0b40\u0b32\u0b19\u0b4d\u0b15\u0b3e'),'os':'*aa','pa':u('\u0a38\u0a4d\u0a30\u0a40 \u0a32\u0a70\u0a15\u0a3e'),'pi':'*aa','pl':'*aa','ps':u('\u0633\u0631\u064a\u0644\u0627\u0646\u06a9\u0627'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'*bm','ro':'*aa','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u0631\u064a \u0644\u0646\u06aa\u0627'),'se':'*aa','sg':u('Sir\u00ee-Lanka'),'si':u('\u0dc1\u0dca\u200d\u0dbb\u0dd3 \u0dbd\u0d82\u0d9a\u0dcf\u0dc0'),'sk':'*cs','sl':'*lv','sm':'*aa','sn':'*aa','so':'Sirilaanka','sq':u('Sri-Lank\u00eb'),'sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b87\u0bb2\u0b99\u0bcd\u0b95\u0bc8'),'te':u('\u0c36\u0c4d\u0c30\u0c40\u0c32\u0c02\u0c15'),'tg':'*ce','th':u('\u0e28\u0e23\u0e35\u0e25\u0e31\u0e07\u0e01\u0e32'),'ti':'*am','tk':'*az','tl':'*aa','tn':'*aa','to':u('S\u012blangik\u0101'),'tr':'*aa','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u0633\u0649\u0631\u0649\u0644\u0627\u0646\u0643\u0627'),'uk':u('\u0428\u0440\u0456-\u041b\u0430\u043d\u043a\u0430'),'ur':u('\u0633\u0631\u06cc \u0644\u0646\u06a9\u0627'),'uz':'Shri-Lanka','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':u('Siri L\u00e0nka'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Siri Lanka'),'za':'*aa','zh':u('\u65af\u91cc\u5170\u5361'),'zu':'i-Sri Lanka',},
  'LR': {'aa':'Liberia','ab':'*aa','ae':'*aa','af':u('Liberi\u00eb'),'ak':'Laeberia','am':u('\u120b\u12ed\u1264\u122a\u12eb'),'an':'*aa','ar':u('\u0644\u064a\u0628\u064a\u0631\u064a\u0627'),'as':u('\u09b2\u09bf\u09ac\u09c7\u09f0\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Liberiya','ba':'*aa','be':u('\u041b\u0456\u0431\u0435\u0440\u044b\u044f'),'bg':u('\u041b\u0438\u0431\u0435\u0440\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'*az','bn':u('\u09b2\u09be\u0987\u09ac\u09c7\u09b0\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'*aa','bs':'Liberija','ca':u('Lib\u00e8ria'),'ce':u('\u041b\u0438\u0431\u0435\u0440\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Lib\u00e9rie'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f63\u0f71\u0f60\u0f72\u0f0b\u0f56\u0f7a\u0f0b\u0f62\u0f72\u0f0b\u0f61'),'ee':'Liberia nutome','el':u('\u039b\u03b9\u03b2\u03b5\u03c1\u03af\u03b1'),'en':'*aa','eo':'Liberio','es':'*aa','et':'Libeeria','eu':'*aa','fa':u('\u0644\u06cc\u0628\u0631\u06cc\u0627'),'ff':'Liberiyaa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Lib\u00e9ria'),'fy':'*aa','ga':u('an Lib\u00e9ir'),'gd':u('Lib\u00e8ir'),'gl':'*aa','gn':'*aa','gu':u('\u0ab2\u0abe\u0a87\u0aac\u0ac7\u0ab0\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Laberiya','he':u('\u05dc\u05d9\u05d1\u05e8\u05d9\u05d4'),'hi':u('\u0932\u093e\u0907\u092c\u0947\u0930\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*fr','hy':u('\u053c\u056b\u0562\u0565\u0580\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('L\u00edber\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30ea\u30d9\u30ea\u30a2'),'ji':u('\u05dc\u05d9\u05d1\u05e2\u05e8\u05d9\u05e2'),'jv':'*aa','ka':u('\u10da\u10d8\u10d1\u10d4\u10e0\u10d8\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u179b\u17b8\u1794\u17c1\u179a\u17b8\u1799\u17c9\u17b6'),'kn':u('\u0cb2\u0cbf\u0cac\u0cc7\u0cb0\u0cbf\u0caf\u0cbe'),'ko':u('\ub77c\uc774\ubca0\ub9ac\uc544'),'kr':'*aa','ks':u('\u0644\u0627\u06cc\u0628\u06cc\u0631\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'Liberya','li':'*aa','ln':u('Lib\u00e9riya'),'lo':u('\u0ea5\u0eb4\u0ec0\u0e9a\u0eb5\u0ec0\u0ea3\u0e8d'),'lt':'*bs','lu':'*az','lv':u('Lib\u0113rija'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u041b\u0438\u0431\u0435\u0440\u0438\u0458\u0430'),'ml':u('\u0d32\u0d48\u0d2c\u0d40\u0d30\u0d3f\u0d2f'),'mn':'*ce','mo':'*aa','mr':u('\u0932\u093e\u092f\u092c\u0947\u0930\u093f\u092f\u093e'),'ms':'*aa','mt':'il-Liberja','my':u('\u101c\u102d\u102f\u1000\u103a\u1018\u1031\u1038\u101b\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'Libheriya','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b32\u0b3e\u0b07\u0b2c\u0b47\u0b30\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a32\u0a3e\u0a08\u0a2c\u0a40\u0a30\u0a40\u0a06'),'pi':'*aa','pl':'*aa','ps':u('\u0644\u0627\u06cc\u0628\u0631\u06cc\u0627'),'pt':'*fr','qu':'*aa','rm':'*aa','rn':'*az','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0644\u0627\u0626\u0628\u06cc\u0631\u06cc\u0627'),'se':'*aa','sg':u('Liber\u00efa'),'si':u('\u0dbd\u0dba\u0dd2\u0db6\u0dd3\u0dbb\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*fr','sl':'*bs','sm':'*aa','sn':'*aa','so':'Laybeeriya','sq':'Liberi','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0bb2\u0bc8\u0baa\u0bc0\u0bb0\u0bbf\u0baf\u0bbe'),'te':u('\u0c32\u0c48\u0c2c\u0c40\u0c30\u0c3f\u0c2f\u0c3e'),'tg':'*bg','th':u('\u0e44\u0e25\u0e1a\u0e35\u0e40\u0e23\u0e35\u0e22'),'ti':'*am','tk':u('Liberi\u00fda'),'tl':'*aa','tn':'*aa','to':'Laipelia','tr':'*lg','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0644\u0649\u0628\u06d0\u0631\u0649\u064a\u06d5'),'uk':u('\u041b\u0456\u0431\u0435\u0440\u0456\u044f'),'ur':'*sd','uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*az','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Laberia'),'za':'*aa','zh':u('\u5229\u6bd4\u91cc\u4e9a'),'zu':'i-Liberia',},
  'LS': {'aa':'Lesotho','ab':'*aa','ae':'*aa','af':'*aa','ak':u('L\u025bsutu'),'am':u('\u120c\u1236\u1276'),'an':'*aa','ar':u('\u0644\u064a\u0633\u0648\u062a\u0648'),'as':u('\u09b2\u09c7\u099b\u2019\u09a5\u2019'),'av':'*aa','ay':'*aa','az':'Lesoto','ba':'*aa','be':u('\u041b\u0435\u0441\u043e\u0442\u0430'),'bg':u('\u041b\u0435\u0441\u043e\u0442\u043e'),'bh':'*aa','bi':'*aa','bm':'*az','bn':u('\u09b2\u09c7\u09b8\u09cb\u09a5\u09cb'),'bo':'*aa','br':'*aa','bs':'*az','ca':'*aa','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f63\u0f7b\u0f0b\u0f66\u0f7c\u0f0b\u0f50\u0f7c'),'ee':u('L\u025bsoto nutome'),'el':u('\u039b\u03b5\u03c3\u03cc\u03c4\u03bf'),'en':'*aa','eo':'*az','es':'*az','et':'*aa','eu':'*aa','fa':u('\u0644\u0633\u0648\u062a\u0648'),'ff':'*az','fi':'*aa','fj':'*aa','fo':'*az','fr':'*aa','fy':'*aa','ga':u('Leos\u00f3ta'),'gd':'Leasoto','gl':'*az','gn':'*aa','gu':u('\u0ab2\u0ac7\u0ab8\u0acb\u0aa5\u0acb'),'gv':'*aa','ha':'*az','he':u('\u05dc\u05e1\u05d5\u05d8\u05d5'),'hi':u('\u0932\u0947\u0938\u094b\u0925\u094b'),'ho':'*aa','hr':'*az','ht':'*aa','hu':'*aa','hy':u('\u053c\u0565\u057d\u0578\u057f\u0578'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Les\u00f3t\u00f3'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30ec\u30bd\u30c8'),'ji':u('\u05dc\u05e2\u05e1\u05d0\u05d8\u05d0'),'jv':'*aa','ka':u('\u10da\u10d4\u10e1\u10dd\u10d7\u10dd'),'kg':'*aa','ki':'*az','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a1\u17c1\u179f\u17bc\u178f\u17bc'),'kn':u('\u0cb2\u0cc6\u0cb8\u0cca\u0ca5\u0cca'),'ko':u('\ub808\uc18c\ud1a0'),'kr':'*aa','ks':u('\u0644\u06cc\u0633\u0648\u062a\u06be\u0648'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'Lesoso','li':'*aa','ln':'*az','lo':u('\u0ec0\u0ea5\u0ec2\u0e8a\u0ec2\u0e97'),'lt':'Lesotas','lu':'*az','lv':'*az','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d32\u0d46\u0d38\u0d4b\u0d24\u0d4b'),'mn':'*bg','mo':'*aa','mr':'*hi','ms':'*aa','mt':'il-Lesoto','my':u('\u101c\u102e\u1006\u102d\u102f\u101e\u102d\u102f'),'na':'*aa','nb':'*aa','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b32\u0b47\u0b38\u0b4b\u0b25\u0b4b'),'os':'*aa','pa':u('\u0a32\u0a47\u0a38\u0a4b\u0a25\u0a4b'),'pi':'*aa','pl':'*aa','ps':'*fa','pt':'*az','qu':'*az','rm':'*aa','rn':'*az','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0644\u064a\u0633\u0648\u067f\u0648'),'se':'*aa','sg':u('Les\u00f4tho'),'si':u('\u0dbd\u0dd9\u0dc3\u0dad\u0ddd'),'sk':'*aa','sl':'*az','sm':'*aa','sn':'*aa','so':'Losooto','sq':'*az','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*az','ta':u('\u0bb2\u0bc6\u0b9a\u0bcb\u0ba4\u0bcb'),'te':u('\u0c32\u0c46\u0c38\u0c4b\u0c24\u0c4b'),'tg':'*bg','th':u('\u0e40\u0e25\u0e42\u0e0b\u0e42\u0e17'),'ti':'*am','tk':'*az','tl':'*aa','tn':'*aa','to':'*az','tr':'*aa','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0644\u06d0\u0633\u0648\u062a\u0648'),'uk':'*bg','ur':'*ks','uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*az','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Lesoto'),'za':'*aa','zh':u('\u83b1\u7d22\u6258'),'zu':'iLesotho',},
  'LT': {'aa':'Lithuania','ab':'*aa','ae':'*aa','af':'Litaue','ak':'Lituwenia','am':u('\u120a\u1271\u12cc\u1292\u12eb'),'an':'*aa','ar':u('\u0644\u064a\u062a\u0648\u0627\u0646\u064a\u0627'),'as':u('\u09b2\u09bf\u09a5\u09c1\u09f1\u09be\u09a8\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Litva','ba':'*aa','be':u('\u041b\u0456\u0442\u0432\u0430'),'bg':u('\u041b\u0438\u0442\u0432\u0430'),'bh':'*aa','bi':'*aa','bm':'Lituyani','bn':u('\u09b2\u09bf\u09a5\u09c1\u09af\u09bc\u09be\u09a8\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'Lituania','bs':'Litvanija','ca':u('Litu\u00e0nia'),'ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*az','cu':'*aa','cv':'*aa','cy':'*aa','da':'Litauen','de':'*da','dv':'*aa','dz':u('\u0f63\u0f72\u0f0b\u0f50\u0f74\u0f0b\u0f5d\u0f7a\u0f0b\u0f53\u0f72\u0f0b\u0f61'),'ee':'Lituania nutome','el':u('\u039b\u03b9\u03b8\u03bf\u03c5\u03b1\u03bd\u03af\u03b1'),'en':'*aa','eo':'Litovujo','es':'*br','et':'Leedu','eu':'*br','fa':u('\u0644\u06cc\u062a\u0648\u0627\u0646\u06cc'),'ff':'Lituaanii','fi':'Liettua','fj':'*aa','fo':'Litava','fr':'Lituanie','fy':'Litouwen','ga':u('an Liotu\u00e1in'),'gd':'An Liotuain','gl':'*br','gn':'*aa','gu':u('\u0ab2\u0abf\u0aa5\u0ac1\u0a86\u0aa8\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Lituweniya','he':u('\u05dc\u05d9\u05d8\u05d0'),'hi':u('\u0932\u093f\u0925\u0941\u0906\u0928\u093f\u092f\u093e'),'ho':'*aa','hr':'*az','ht':'*aa','hu':u('Litv\u00e1nia'),'hy':u('\u053c\u056b\u057f\u057e\u0561'),'hz':'*aa','ia':'*aa','id':'*br','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*br','io':'*aa','is':u('Lith\u00e1en'),'it':'*br','iu':'*aa','iw':'*he','ja':u('\u30ea\u30c8\u30a2\u30cb\u30a2'),'ji':u('\u05dc\u05d9\u05d8\u05e2'),'jv':'*aa','ka':u('\u10da\u10d8\u10e2\u10d5\u10d0'),'kg':'*aa','ki':'Litwania','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u179b\u17b8\u1791\u17bb\u1799\u17a2\u17b6\u1793\u17b8'),'kn':u('\u0cb2\u0cbf\u0ca5\u0cc1\u0cb5\u0cc7\u0ca8\u0cbf\u0caf\u0cbe'),'ko':u('\ub9ac\ud22c\uc544\ub2c8\uc544'),'kr':'*aa','ks':u('\u0644\u0650\u062a\u06be\u064f\u0648\u0627\u0646\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*da','lg':'Lisuwenya','li':'*aa','ln':'Litwani','lo':u('\u0ea5\u0eb4\u0e97\u0ebb\u0ea7\u0ec0\u0e99\u0e8d'),'lt':'Lietuva','lu':'*ln','lv':'*lt','mg':'Litoania','mh':'*aa','mi':'*aa','mk':u('\u041b\u0438\u0442\u0432\u0430\u043d\u0438\u0458\u0430'),'ml':u('\u0d32\u0d3f\u0d24\u0d4d\u0d35\u0d3e\u0d28\u0d3f\u0d2f'),'mn':'*bg','mo':'*br','mr':'*hi','ms':'*aa','mt':'il-Litwanja','my':u('\u101c\u1005\u103a\u101e\u1030\u101a\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'*da','nd':'*aa','ne':u('\u0932\u093f\u0925\u0941\u090f\u0928\u093f\u092f\u093e'),'ng':'*aa','nl':'*fy','nn':'*da','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b32\u0b3f\u0b25\u0b41\u0b06\u0b28\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a32\u0a3f\u0a25\u0a41\u0a06\u0a28\u0a40\u0a06'),'pi':'*aa','pl':'Litwa','ps':u('\u0644\u06cc\u062a\u0648\u0627\u0646\u06cc\u0627'),'pt':u('Litu\u00e2nia'),'qu':'*br','rm':'*br','rn':'Lituwaniya','ro':'*br','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0644\u067f\u0648\u0646\u064a\u0627'),'se':'*lt','sg':u('Lituan\u00efi'),'si':u('\u0dbd\u0dd2\u0dad\u0dd4\u0dc0\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*az','sl':'*az','sm':'*aa','sn':'*aa','so':'Lituweeniya','sq':'Lituani','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':u('\u0bb2\u0bbf\u0ba4\u0bc1\u0bb5\u0bc7\u0ba9\u0bbf\u0baf\u0bbe'),'te':u('\u0c32\u0c3f\u0c25\u0c41\u0c35\u0c47\u0c28\u0c3f\u0c2f\u0c3e'),'tg':'*bg','th':u('\u0e25\u0e34\u0e17\u0e31\u0e27\u0e40\u0e19\u0e35\u0e22'),'ti':'*am','tk':'*pl','tl':'*aa','tn':'*aa','to':'*br','tr':'Litvanya','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0644\u0649\u062a\u06cb\u0627\u0646\u0649\u064a\u06d5'),'uk':'*bg','ur':u('\u0644\u06cc\u062a\u06be\u0648\u0646\u06cc\u0627'),'uz':'*az','ve':'*aa','vi':'*az','vo':'*aa','wa':'*aa','wo':'Litiyani','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Lituania'),'za':'*aa','zh':u('\u7acb\u9676\u5b9b'),'zu':'i-Lithuania',},
  'LU': {'aa':'Luxembourg','ab':'*aa','ae':'*aa','af':'Luxemburg','ak':u('Laksemb\u025bg'),'am':u('\u1209\u12ad\u1230\u121d\u1260\u122d\u130d'),'an':'*aa','ar':u('\u0644\u0648\u0643\u0633\u0645\u0628\u0648\u0631\u063a'),'as':u('\u09b2\u09be\u0995\u09cd\u09b8\u09c7\u09ae\u09ac\u09be\u09f0\u09cd\u0997'),'av':'*aa','ay':'*aa','az':u('L\u00fcksemburq'),'ba':'*aa','be':u('\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'Likisanburu','bn':u('\u09b2\u09be\u0995\u09cd\u09b8\u09c7\u09ae\u09ac\u09be\u09b0\u09cd\u0997'),'bo':'*aa','br':'Luksembourg','bs':'Luksemburg','ca':'*af','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'Lucembursko','cu':'*aa','cv':'*aa','cy':'Lwcsembwrg','da':'*aa','de':'*af','dv':'*aa','dz':u('\u0f63\u0f42\u0f0b\u0f5b\u0f58\u0f0b\u0f56\u0f7c\u0f62\u0f92'),'ee':u('Lazemb\u0254g nutome'),'el':u('\u039b\u03bf\u03c5\u03be\u03b5\u03bc\u03b2\u03bf\u03cd\u03c1\u03b3\u03bf'),'en':'*aa','eo':'Luksemburgo','es':'Luxemburgo','et':'*bs','eu':'Luxenburgo','fa':u('\u0644\u0648\u06a9\u0632\u0627\u0645\u0628\u0648\u0631\u06af'),'ff':'Liksembuur','fi':'*af','fj':'*aa','fo':'Luksemborg','fr':'*aa','fy':'*af','ga':'Lucsamburg','gd':'Lugsamburg','gl':'*es','gn':'*aa','gu':u('\u0ab2\u0a95\u0acd\u0a9d\u0aae\u0aac\u0ab0\u0acd\u0a97'),'gv':'*aa','ha':'Lukusambur','he':u('\u05dc\u05d5\u05e7\u05e1\u05de\u05d1\u05d5\u05e8\u05d2'),'hi':u('\u0932\u0917\u094d\u091c\u093c\u092e\u092c\u0930\u094d\u0917'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*af','hy':u('\u053c\u0575\u0578\u0582\u0584\u057d\u0565\u0574\u0562\u0578\u0582\u0580\u0563'),'hz':'*aa','ia':'*aa','id':'*bs','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*bs','io':'*aa','is':u('L\u00faxemborg'),'it':'Lussemburgo','iu':'*aa','iw':'*he','ja':u('\u30eb\u30af\u30bb\u30f3\u30d6\u30eb\u30af'),'ji':u('\u05dc\u05d5\u05e7\u05e1\u05e2\u05de\u05d1\u05d5\u05e8\u05d2'),'jv':'*aa','ka':u('\u10da\u10e3\u10e5\u10e1\u10d4\u10db\u10d1\u10e3\u10e0\u10d2\u10d8'),'kg':'*aa','ki':'Lasembagi','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u179b\u17bb\u1785\u179f\u17c6\u1794\u17bd'),'kn':u('\u0cb2\u0c95\u0ccd\u0cb8\u0cc6\u0c82\u0cac\u0cb0\u0ccd\u0c97\u0ccd'),'ko':u('\ub8e9\uc148\ubd80\ub974\ud06c'),'kr':'*aa','ks':u('\u0644\u064e\u06a9\u0633\u064e\u0645\u0628\u0654\u0631\u0655\u06af'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':u('L\u00ebtzebuerg'),'lg':'Lukisembaaga','li':'*aa','ln':'Likisambulu','lo':u('\u0ea5\u0eb8\u0e81\u0ec1\u0e8a\u0ea1\u0ec0\u0e9a\u0eb5\u0e81'),'lt':'Liuksemburgas','lu':'*ln','lv':'Luksemburga','mg':'Lioksamboro','mh':'*aa','mi':'*aa','mk':u('\u041b\u0443\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433'),'ml':u('\u0d32\u0d15\u0d4d\u0d38\u0d02\u0d2c\u0d7c\u0d17\u0d4d'),'mn':'*be','mo':'*af','mr':u('\u0932\u0915\u094d\u091d\u0947\u0902\u092c\u0930\u094d\u0917'),'ms':'*aa','mt':'il-Lussemburgu','my':u('\u101c\u1030\u1007\u1004\u103a\u1018\u1010\u103a'),'na':'*aa','nb':'*af','nd':'*aa','ne':u('\u0932\u0915\u094d\u091c\u0947\u092e\u092c\u0930\u094d\u0917'),'ng':'*aa','nl':'*af','nn':'*aa','no':'*af','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b32\u0b15\u0b4d\u0b38\u0b47\u0b2e\u0b2c\u0b30\u0b4d\u0b17'),'os':'*aa','pa':u('\u0a32\u0a15\u0a1c\u0a3c\u0a2e\u0a2c\u0a30\u0a17'),'pi':'*aa','pl':'*bs','ps':u('\u0644\u0648\u06ab\u0632\u0627\u0645\u0628\u0648\u0631\u06ab'),'pt':'*es','qu':'*es','rm':'*af','rn':'Lukusamburu','ro':'*af','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0644\u06cc\u06af\u0632\u0645\u0628\u0631\u06af'),'se':'*aa','sg':u('Lugzamb\u00fbru'),'si':u('\u0dbd\u0d9a\u0dca\u0dc1\u0db8\u0dca\u0db6\u0dbb\u0dca\u0d9c\u0dca'),'sk':'Luxembursko','sl':'*bs','sm':'*aa','sn':'*aa','so':'Luksemboorg','sq':'*bs','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*af','sw':'*aa','ta':u('\u0bb2\u0b95\u0bcd\u0bb8\u0bcd\u0b9a\u0bae\u0bcd\u0baa\u0bb0\u0bcd\u0b95\u0bcd'),'te':u('\u0c32\u0c15\u0c4d\u0c38\u0c02\u0c2c\u0c30\u0c4d\u0c17\u0c4d'),'tg':'*be','th':u('\u0e25\u0e31\u0e01\u0e40\u0e0b\u0e21\u0e40\u0e1a\u0e34\u0e23\u0e4c\u0e01'),'ti':'*am','tk':u('L\u00fduksemburg'),'tl':'*aa','tn':'*aa','to':'Lakisimipeki','tr':u('L\u00fcksemburg'),'ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u0644\u0649\u064a\u06c7\u0643\u0633\u06d0\u0645\u0628\u06c7\u0631\u06af'),'uk':u('\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0491'),'ur':u('\u0644\u06a9\u0633\u0645\u0628\u0631\u06af'),'uz':'Lyuksemburg','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':u('Liks\u00e0mbur'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Lusemogi'),'za':'*aa','zh':u('\u5362\u68ee\u5821'),'zu':'i-Luxembourg',},
  'LV': {'aa':'Latvia','ab':'*aa','ae':'*aa','af':'Letland','ak':'*aa','am':u('\u120b\u1275\u126a\u12eb'),'an':'*aa','ar':u('\u0644\u0627\u062a\u0641\u064a\u0627'),'as':u('\u09b2\u09be\u099f\u09ad\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Latviya','ba':'*aa','be':u('\u041b\u0430\u0442\u0432\u0456\u044f'),'bg':u('\u041b\u0430\u0442\u0432\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Letoni','bn':u('\u09b2\u09be\u09a4\u09cd\u09ad\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'*aa','bs':'Latvija','ca':u('Let\u00f2nia'),'ce':u('\u041b\u0430\u0442\u0432\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Loty\u0161sko'),'cu':'*aa','cv':'*aa','cy':'Latfia','da':'*af','de':'Lettland','dv':'*aa','dz':u('\u0f63\u0f4a\u0f0b\u0f56\u0f72\u0f0b\u0f61'),'ee':'Latvia nutome','el':u('\u039b\u03b5\u03c4\u03bf\u03bd\u03af\u03b1'),'en':'*aa','eo':'Latvujo','es':'Letonia','et':u('L\u00e4ti'),'eu':'*es','fa':u('\u0644\u062a\u0648\u0646\u06cc'),'ff':'Letonii','fi':'*aa','fj':'*aa','fo':'*de','fr':'Lettonie','fy':u('Letl\u00e2n'),'ga':'an Laitvia','gd':'An Laitbhe','gl':'*es','gn':'*aa','gu':u('\u0ab2\u0abe\u0aa4\u0acd\u0ab5\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'latibiya','he':u('\u05dc\u05d8\u05d1\u05d9\u05d4'),'hi':u('\u0932\u093e\u0924\u0935\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Lettorsz\u00e1g'),'hy':u('\u053c\u0561\u057f\u057e\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*de','it':'Lettonia','iu':'*aa','iw':'*he','ja':u('\u30e9\u30c8\u30d3\u30a2'),'ji':u('\u05dc\u05e2\u05d8\u05dc\u05d0\u05b7\u05e0\u05d3'),'jv':'*aa','ka':u('\u10da\u10d0\u10e2\u10d5\u10d8\u10d0'),'kg':'*aa','ki':'Lativia','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a1\u17c1\u178f\u17bc\u1793\u17b8'),'kn':u('\u0cb2\u0cbe\u0c9f\u0ccd\u0cb5\u0cbf\u0caf\u0cbe'),'ko':u('\ub77c\ud2b8\ube44\uc544'),'kr':'*aa','ks':u('\u0644\u06cc\u065b\u0679\u0648\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*de','lg':'Lativya','li':'*aa','ln':'*bm','lo':u('\u0ea5\u0eb1\u0e94\u0ec0\u0ea7\u0e8d'),'lt':'*bs','lu':'*bm','lv':'*bs','mg':'*es','mh':'*aa','mi':'*aa','mk':u('\u041b\u0430\u0442\u0432\u0438\u0458\u0430'),'ml':u('\u0d32\u0d3e\u0d31\u0d4d\u0d31\u0d4d\u0d35\u0d3f\u0d2f'),'mn':'*ce','mo':'*es','mr':u('\u0932\u093e\u0924\u094d\u0935\u093f\u092f\u093e'),'ms':'*aa','mt':'il-Latvja','my':u('\u101c\u1010\u103a\u1017\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0932\u093e\u091f\u094d\u092d\u093f\u092f\u093e'),'ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b32\u0b3e\u0b1f\u0b2d\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a32\u0a3e\u0a24\u0a35\u0a40\u0a06'),'pi':'*aa','pl':u('\u0141otwa'),'ps':u('\u0644\u062a\u0648\u0646\u064a'),'pt':u('Let\u00f4nia'),'qu':'*es','rm':'*it','rn':'Lativa','ro':'*es','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0644\u0627\u062a\u0648\u064a\u0627'),'se':u('L\u00e1tvia'),'sg':u('Leton\u00f9ii'),'si':u('\u0dbd\u0dd0\u0da7\u0dca\u0dc0\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*cs','sl':'*bs','sm':'*aa','sn':'*aa','so':'Latfiya','sq':'*bm','sr':u('\u041b\u0435\u0442\u043e\u043d\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':u('\u0bb2\u0bbe\u0b9f\u0bcd\u0bb5\u0bbf\u0baf\u0bbe'),'te':u('\u0c32\u0c3e\u0c24\u0c4d\u0c35\u0c3f\u0c2f\u0c3e'),'tg':'*bg','th':u('\u0e25\u0e31\u0e15\u0e40\u0e27\u0e35\u0e22'),'ti':'*am','tk':u('Latwi\u00fda'),'tl':'*aa','tn':'*aa','to':'*ki','tr':'Letonya','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0644\u0627\u062a\u06cb\u0649\u064a\u06d5'),'uk':'*be','ur':u('\u0644\u0679\u0648\u06cc\u0627'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*bm','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Latifia'),'za':'*aa','zh':u('\u62c9\u8131\u7ef4\u4e9a'),'zu':'i-Latvia',},
  'LY': {'aa':'Libya','ab':'*aa','ae':'*aa','af':u('Libi\u00eb'),'ak':'*aa','am':u('\u120a\u1262\u12eb'),'an':'*aa','ar':u('\u0644\u064a\u0628\u064a\u0627'),'as':u('\u09b2\u09bf\u09ac\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Liviya','ba':'*aa','be':u('\u041b\u0456\u0432\u0456\u044f'),'bg':u('\u041b\u0438\u0431\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Libi','bn':'*as','bo':'*aa','br':'Libia','bs':'Libija','ca':u('L\u00edbia'),'ce':u('\u041b\u0438\u0432\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Libye','cu':'*aa','cv':'*aa','cy':'*aa','da':'Libyen','de':'*da','dv':'*aa','dz':u('\u0f63\u0f72\u0f0b\u0f56\u0f72\u0f0b\u0f61'),'ee':'Libya nutome','el':u('\u039b\u03b9\u03b2\u03cd\u03b7'),'en':'*aa','eo':'Libio','es':'*br','et':u('Liib\u00fca'),'eu':'*br','fa':u('\u0644\u06cc\u0628\u06cc'),'ff':'*bm','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*cs','fy':'*af','ga':'an Libia','gd':'*br','gl':'*br','gn':'*aa','gu':u('\u0ab2\u0abf\u0aac\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Libiya','he':u('\u05dc\u05d5\u05d1'),'hi':u('\u0932\u0940\u092c\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*ca','hy':u('\u053c\u056b\u0562\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*br','ie':'*aa','ig':'Libyia','ii':'*aa','ik':'*aa','in':'*br','io':'*aa','is':u('L\u00edb\u00eda'),'it':'*br','iu':'*aa','iw':'*he','ja':u('\u30ea\u30d3\u30a2'),'ji':u('\u05dc\u05d9\u05d1\u05d9\u05e2'),'jv':'*aa','ka':u('\u10da\u10d8\u10d1\u10d8\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u041b\u0438\u0432\u0438\u044f'),'kl':'*aa','km':u('\u179b\u17b8\u1794\u17ca\u17b8'),'kn':u('\u0cb2\u0cbf\u0cac\u0cbf\u0caf\u0cbe'),'ko':u('\ub9ac\ube44\uc544'),'kr':'*aa','ks':u('\u0644\u0650\u0628\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*da','lg':'*aa','li':'*aa','ln':u('Lib\u00ed'),'lo':u('\u0ea5\u0eb4\u0ec0\u0e9a\u0e8d'),'lt':'*bs','lu':'*bm','lv':u('L\u012bbija'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u041b\u0438\u0431\u0438\u0458\u0430'),'ml':u('\u0d32\u0d3f\u0d2c\u0d3f\u0d2f'),'mn':'*ce','mo':'*br','mr':u('\u0932\u093f\u092c\u093f\u092f\u093e'),'ms':'*aa','mt':'il-Libja','my':u('\u101c\u1005\u103a\u1017\u103b\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'Libhiya','ne':'*mr','ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b32\u0b3f\u0b2c\u0b4d\u0b5f\u0b3e'),'os':'*aa','pa':u('\u0a32\u0a40\u0a2c\u0a40\u0a06'),'pi':'*aa','pl':'*br','ps':u('\u0644\u06cc\u0628\u06cc\u0627'),'pt':'*ca','qu':'*aa','rm':'*br','rn':'*ha','ro':'*br','ru':'*kk','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0644\u0628\u064a\u0627'),'se':'*aa','sg':u('Lib\u00efi'),'si':u('\u0dbd\u0dd2\u0db6\u0dd2\u0dba\u0dcf\u0dc0'),'sk':u('L\u00edbya'),'sl':'*bs','sm':'*aa','sn':'*aa','so':'Liibiya','sq':'*bm','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':u('\u0bb2\u0bbf\u0baa\u0bbf\u0baf\u0bbe'),'te':u('\u0c32\u0c3f\u0c2c\u0c3f\u0c2f\u0c3e'),'tg':'*bg','th':u('\u0e25\u0e34\u0e40\u0e1a\u0e35\u0e22'),'ti':'*am','tk':u('Liwi\u00fda'),'tl':'*aa','tn':'*aa','to':u('L\u012bpia'),'tr':'*aa','ts':'*aa','tt':'*kk','tw':'*aa','ty':'*aa','ug':u('\u0644\u0649\u06cb\u0649\u064a\u06d5'),'uk':'*be','ur':'*ps','uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*bm','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Libiya'),'za':'*aa','zh':u('\u5229\u6bd4\u4e9a'),'zu':'i-Libya',},
  'MA': {'aa':'Morocco','ab':'*aa','ae':'*aa','af':'Marokko','ak':'Moroko','am':u('\u121e\u122e\u12ae'),'an':'*aa','ar':u('\u0627\u0644\u0645\u063a\u0631\u0628'),'as':u('\u09ae\u09f0\u0995\u09cd\u0995\u09cb'),'av':'*aa','ay':'*aa','az':u('M\u0259rake\u015f'),'ba':'*aa','be':u('\u041c\u0430\u0440\u043e\u043a\u0430'),'bg':u('\u041c\u0430\u0440\u043e\u043a\u043e'),'bh':'*aa','bi':'*aa','bm':u('Mar\u0254ku'),'bn':u('\u09ae\u09cb\u09b0\u0995\u09cd\u0995\u09cb'),'bo':'*aa','br':'Maroko','bs':'*br','ca':'Marroc','ce':u('\u041c\u0430\u0440\u043e\u043a\u043a\u043e'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*br','cu':'*aa','cv':'*aa','cy':'Moroco','da':'*af','de':'*af','dv':'*aa','dz':u('\u0f58\u0f7c\u0f0b\u0f62\u0f7c\u0f0b\u0f40\u0f7c'),'ee':'Moroko nutome','el':u('\u039c\u03b1\u03c1\u03cc\u03ba\u03bf'),'en':'*aa','eo':'*br','es':'Marruecos','et':'*br','eu':'*br','fa':u('\u0645\u0631\u0627\u06a9\u0634'),'ff':'Maruk','fi':'*af','fj':'*aa','fo':'*af','fr':'Maroc','fy':'*af','ga':u('Marac\u00f3'),'gd':'*cy','gl':'Marrocos','gn':'*aa','gu':u('\u0aae\u0acb\u0ab0\u0acb\u0a95\u0acd\u0a95\u0acb'),'gv':'*aa','ha':'*br','he':u('\u05de\u05e8\u05d5\u05e7\u05d5'),'hi':u('\u092e\u094b\u0930\u0915\u094d\u0915\u094b'),'ho':'*aa','hr':'*br','ht':'*aa','hu':u('Marokk\u00f3'),'hy':u('\u0544\u0561\u0580\u0578\u056f\u056f\u0578'),'hz':'*aa','ia':'*aa','id':'*br','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*br','io':'*aa','is':'*hu','it':'Marocco','iu':'*aa','iw':'*he','ja':u('\u30e2\u30ed\u30c3\u30b3'),'ji':u('\u05de\u05d0\u05b7\u05e8\u05d0\u05e7\u05d0'),'jv':'*aa','ka':u('\u10db\u10d0\u10e0\u10dd\u10d9\u10dd'),'kg':'*aa','ki':'*ak','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u1798\u17c9\u17b6\u179a\u17c9\u17bb\u1780'),'kn':u('\u0cae\u0cca\u0cb0\u0cbe\u0c95\u0ccd\u0c95\u0cca'),'ko':u('\ubaa8\ub85c\ucf54'),'kr':'*aa','ks':u('\u0645\u0648\u0631\u0648\u06a9\u0648'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*af','lg':'*ak','li':'*aa','ln':u('Marok\u025b'),'lo':u('\u0ec2\u0ea1\u0ea3\u0eb1\u0ead\u0e81\u0ec2\u0e84'),'lt':'Marokas','lu':'Maroke','lv':'Maroka','mg':u('Mar\u00f4ka'),'mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d2e\u0d4a\u0d31\u0d4b\u0d15\u0d4d\u0d15\u0d4a'),'mn':u('\u041c\u043e\u0440\u043e\u043a\u043a\u043e'),'mo':'*fr','mr':u('\u092e\u094b\u0930\u094b\u0915\u094d\u0915\u094b'),'ms':'Maghribi','mt':'il-Marokk','my':u('\u1019\u1031\u102c\u103a\u101b\u102d\u102f\u1000\u102d\u102f'),'na':'*aa','nb':'*af','nd':'Morokho','ne':'*mr','ng':'*aa','nl':'*af','nn':'*af','no':'*af','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b4b\u0b30\u0b4b\u0b15\u0b4d\u0b15\u0b4b'),'os':'*aa','pa':u('\u0a2e\u0a4b\u0a30\u0a71\u0a15\u0a4b'),'pi':'*aa','pl':'*br','ps':'*fa','pt':'*gl','qu':'*es','rm':'*fr','rn':'*lu','ro':'*fr','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0645\u0648\u0631\u0648\u06aa\u0648'),'se':'*af','sg':u('Mar\u00f4ko'),'si':u('\u0db8\u0ddc\u0dbb\u0ddc\u0d9a\u0dca\u0d9a\u0ddd\u0dc0'),'sk':'*br','sl':'*br','sm':'*aa','sn':'*aa','so':'Marooko','sq':'Marok','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'Marocko','sw':'*aa','ta':u('\u0bae\u0bca\u0bb0\u0bbe\u0b95\u0bcd\u0b95\u0bcb'),'te':u('\u0c2e\u0c4a\u0c30\u0c3e\u0c15\u0c4b'),'tg':u('\u041c\u0430\u0440\u043e\u043a\u0430\u0448'),'th':u('\u0e42\u0e21\u0e23\u0e47\u0e2d\u0e01\u0e42\u0e01'),'ti':'*am','tk':'*af','tl':'*aa','tn':'*aa','to':'Moloko','tr':'Fas','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u0645\u0627\u0631\u0627\u0643\u06d5\u0634'),'uk':'*ce','ur':'*fa','uz':'Marokash','ve':'*aa','vi':u('Ma-r\u1ed1c'),'vo':'*aa','wa':'*aa','wo':'Marog','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Moroko'),'za':'*aa','zh':u('\u6469\u6d1b\u54e5'),'zu':'i-Morocco',},
  'MC': {'aa':'Monaco','ab':'*aa','ae':'*aa','af':'*aa','ak':u('M\u0254nako'),'am':u('\u121e\u1293\u12ae'),'an':'*aa','ar':u('\u0645\u0648\u0646\u0627\u0643\u0648'),'as':u('\u09ae\u09cb\u09a8\u09be\u0995\u09cb'),'av':'*aa','ay':'*aa','az':'Monako','ba':'*aa','be':u('\u041c\u0430\u043d\u0430\u043a\u0430'),'bg':u('\u041c\u043e\u043d\u0430\u043a\u043e'),'bh':'*aa','bi':'*aa','bm':'*az','bn':'*as','bo':'*aa','br':'*aa','bs':'*az','ca':u('M\u00f2naco'),'ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*az','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f58\u0f7c\u0f0b\u0f53\u0f0b\u0f40\u0f7c'),'ee':'Monako nutome','el':u('\u039c\u03bf\u03bd\u03b1\u03ba\u03cc'),'en':'*aa','eo':'*az','es':u('M\u00f3naco'),'et':'*aa','eu':'*az','fa':u('\u0645\u0648\u0646\u0627\u06a9\u0648'),'ff':'Monaakoo','fi':'*aa','fj':'*aa','fo':'*az','fr':'*aa','fy':'*aa','ga':u('Monac\u00f3'),'gd':'*aa','gl':'*es','gn':'*aa','gu':u('\u0aae\u0acb\u0aa8\u0abe\u0a95\u0acb'),'gv':'*aa','ha':'*az','he':u('\u05de\u05d5\u05e0\u05e7\u05d5'),'hi':u('\u092e\u094b\u0928\u093e\u0915\u094b'),'ho':'*aa','hr':'*az','ht':'*aa','hu':'*aa','hy':u('\u0544\u0578\u0576\u0561\u056f\u0578'),'hz':'*aa','ia':'*aa','id':'*az','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*az','io':'*aa','is':u('M\u00f3nak\u00f3'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30e2\u30ca\u30b3'),'ji':u('\u05de\u05d0\u05e0\u05d0\u05b7\u05e7\u05d0'),'jv':'*aa','ka':u('\u10db\u10dd\u10dc\u10d0\u10d9\u10dd'),'kg':'*aa','ki':'*az','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1798\u17c9\u17bc\u178e\u17b6\u1780\u17bc'),'kn':u('\u0cae\u0cca\u0ca8\u0cbe\u0c95\u0cca'),'ko':u('\ubaa8\ub098\ucf54'),'kr':'*aa','ks':u('\u0645\u0648\u0646\u06cc\u065a\u06a9\u0648'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'*az','li':'*aa','ln':'*az','lo':u('\u0ec2\u0ea1\u0e99\u0eb2\u0ec2\u0e84'),'lt':'Monakas','lu':'Monaku','lv':'*az','mg':u('M\u00f4nak\u00f4'),'mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d2e\u0d4a\u0d23\u0d3e\u0d15\u0d4d\u0d15\u0d4b'),'mn':'*bg','mo':'*aa','mr':u('\u092e\u094b\u0928\u0945\u0915\u094b'),'ms':'*aa','mt':'*aa','my':u('\u1019\u102d\u102f\u1014\u102c\u1000\u102d\u102f'),'na':'*aa','nb':'*aa','nd':'Monakho','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b4b\u0b28\u0b3e\u0b15\u0b4b'),'os':'*aa','pa':u('\u0a2e\u0a4b\u0a28\u0a3e\u0a15\u0a4b'),'pi':'*aa','pl':'*az','ps':'*fa','pt':u('M\u00f4naco'),'qu':'*es','rm':'*aa','rn':'*az','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0645\u0648\u0646\u0627\u06aa\u0648'),'se':'*aa','sg':u('Monak\u00f6o'),'si':u('\u0db8\u0ddc\u0db1\u0dcf\u0d9a\u0ddd\u0dc0'),'sk':'*az','sl':'*az','sm':'*aa','sn':'*aa','so':'Moonako','sq':'*az','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0bae\u0bca\u0ba9\u0bbe\u0b95\u0bcd\u0b95\u0bcb'),'te':u('\u0c2e\u0c4a\u0c28\u0c3e\u0c15\u0c4b'),'tg':'*bg','th':u('\u0e42\u0e21\u0e19\u0e32\u0e42\u0e01'),'ti':'*am','tk':'*az','tl':'*aa','tn':'*aa','to':'*az','tr':'*az','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':'*ar','uk':'*bg','ur':'*fa','uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*az','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Monako'),'za':'*aa','zh':u('\u6469\u7eb3\u54e5'),'zu':'i-Monaco',},
  'MD': {'aa':'Moldova','ab':'*aa','ae':'*aa','af':'Moldowa','ak':u('M\u0254ldova'),'am':u('\u121e\u120d\u12f6\u126b'),'an':'*aa','ar':u('\u0645\u0648\u0644\u062f\u0648\u0641\u0627'),'as':u('\u09ae\u09cb\u09b2\u09a1\u09cb\u09ad\u09be'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u041c\u0430\u043b\u0434\u043e\u0432\u0430'),'bg':u('\u041c\u043e\u043b\u0434\u043e\u0432\u0430'),'bh':'*aa','bi':'*aa','bm':'Molidavi','bn':u('\u09ae\u09cb\u09b2\u09cd\u09a6\u09be\u09ad\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'*aa','bs':'Moldavija','ca':u('Mold\u00e0via'),'ce':u('\u041c\u043e\u043b\u0434\u0430\u0432\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Moldavsko','cu':'*aa','cv':'*aa','cy':'Moldofa','da':'*aa','de':'Republik Moldau','dv':'*aa','dz':u('\u0f58\u0f7c\u0f63\u0f0b\u0f51\u0f7c\u0f0b\u0f56\u0f71'),'ee':'Moldova nutome','el':u('\u039c\u03bf\u03bb\u03b4\u03b1\u03b2\u03af\u03b1'),'en':'*aa','eo':'Moldavujo','es':'Moldavia','et':'*aa','eu':'*es','fa':u('\u0645\u0648\u0644\u062f\u0627\u0648\u06cc'),'ff':'Moldawii','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Moldavie','fy':u('Moldavi\u00eb'),'ga':u('an Mhold\u00f3iv'),'gd':u('A\u2019 Mholdobha'),'gl':'*es','gn':'*aa','gu':u('\u0aae\u0acb\u0ab2\u0aa1\u0acb\u0ab5\u0abe'),'gv':'*aa','ha':'Maldoba','he':u('\u05de\u05d5\u05dc\u05d3\u05d5\u05d1\u05d4'),'hi':u('\u092e\u0949\u0932\u094d\u0921\u094b\u0935\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u0544\u0578\u056c\u0564\u0578\u057e\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Mold\u00f3va'),'it':'*es','iu':'*aa','iw':'*he','ja':u('\u30e2\u30eb\u30c9\u30d0'),'ji':u('\u05de\u05d0\u05dc\u05d3\u05d0\u05d5\u05d5\u05e2'),'jv':'*aa','ka':u('\u10db\u10dd\u10da\u10d3\u10dd\u10d5\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1798\u17c9\u17bb\u179b\u178a\u17b6\u179c\u17b8'),'kn':u('\u0cae\u0cca\u0cb2\u0ccd\u0ca1\u0ccb\u0cb5\u0cbe'),'ko':u('\ubab0\ub3c4\ubc14'),'kr':'*aa','ks':u('\u0645\u0648\u0644\u0691\u0627\u0648\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'Moldawien','lg':'Molodova','li':'*aa','ln':'*bm','lo':u('\u0ec2\u0ea1\u0e99\u0ec2\u0e94\u0ea7\u0eb2'),'lt':'*aa','lu':'*bm','lv':'*aa','mg':u('M\u00f4ldavia'),'mh':'*aa','mi':'*aa','mk':u('\u041c\u043e\u043b\u0434\u0430\u0432\u0438\u0458\u0430'),'ml':u('\u0d2e\u0d7e\u0d21\u0d4b\u0d35'),'mn':u('\u041c\u043e\u043b\u0434\u0430\u0432'),'mo':'Republica Moldova','mr':u('\u092e\u094b\u0932\u094d\u0921\u094b\u0935\u094d\u0939\u093e'),'ms':'*aa','mt':'il-Moldova','my':u('\u1019\u1031\u102c\u101c\u103a\u1012\u102d\u102f\u1017\u102c'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u092e\u093e\u0932\u094d\u0921\u094b\u092d\u093e'),'ng':'*aa','nl':'*fy','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b3e\u0b32\u0b21\u0b4b\u0b2d\u0b3e'),'os':'*aa','pa':u('\u0a2e\u0a4b\u0a32\u0a21\u0a4b\u0a35\u0a3e'),'pi':'*aa','pl':u('Mo\u0142dawia'),'ps':u('\u0645\u0648\u0644\u062f\u0648\u0627'),'pt':u('Mold\u00e1via'),'qu':'*aa','rm':'*es','rn':'Moludavi','ro':'*mo','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0645\u0627\u0644\u062f\u0648\u0648\u0627'),'se':'*pt','sg':u('Moldav\u00f9ii'),'si':u('\u0db8\u0ddc\u0dbd\u0dca\u0da9\u0ddd\u0dc0\u0dcf\u0dc0'),'sk':'*cs','sl':'*bs','sm':'*aa','sn':'*aa','so':'*cy','sq':'Moldavi','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'Moldavien','sw':'*aa','ta':u('\u0bae\u0bbe\u0bb2\u0bcd\u0b9f\u0bcb\u0bb5\u0bbe'),'te':u('\u0c2e\u0c4b\u0c32\u0c4d\u0c21\u0c4b\u0c35\u0c3e'),'tg':'*bg','th':u('\u0e21\u0e2d\u0e25\u0e42\u0e14\u0e27\u0e32'),'ti':'*am','tk':'*af','tl':'*aa','tn':'*aa','to':'Molotova','tr':'*aa','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0645\u0648\u0644\u062f\u0648\u06cb\u0627'),'uk':'*bg','ur':'*sd','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Moldawi','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Modofia'),'za':'*aa','zh':u('\u6469\u5c14\u591a\u74e6'),'zu':'i-Moldova',},
  'ME': {'aa':'Montenegro','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u121e\u1295\u1270\u1294\u130d\u122e'),'an':'*aa','ar':u('\u0627\u0644\u062c\u0628\u0644 \u0627\u0644\u0623\u0633\u0648\u062f'),'as':u('\u09ae\u09a3\u09cd\u099f\u09c7\u09a8\u09c7\u0997\u09cd\u09f0\u09c1'),'av':'*aa','ay':'*aa','az':'Monteneqro','ba':'*aa','be':u('\u0427\u0430\u0440\u043d\u0430\u0433\u043e\u0440\u044b\u044f'),'bg':u('\u0427\u0435\u0440\u043d\u0430 \u0433\u043e\u0440\u0430'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u09ae\u09a8\u09cd\u099f\u09bf\u09a8\u09bf\u0997\u09cd\u09b0\u09cb'),'bo':'*aa','br':'*aa','bs':'Crna Gora','ca':'*aa','ce':u('\u04c0\u0430\u044c\u0440\u0436\u0430\u043b\u0430\u043c\u0430\u043d\u0447\u043e\u044c'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('\u010cern\u00e1 Hora'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f58\u0f7c\u0f53\u0f0b\u0f4a\u0f72\u0f0b\u0f53\u0f7a\u0f42\u0f0b\u0f62\u0f7c'),'ee':'Montenegro nutome','el':u('\u039c\u03b1\u03c5\u03c1\u03bf\u03b2\u03bf\u03cd\u03bd\u03b9\u03bf'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0645\u0648\u0646\u062a\u0647\u200c\u0646\u06af\u0631\u0648'),'ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Mont\u00e9n\u00e9gro'),'fy':'*aa','ga':u('Montain\u00e9agr\u00f3'),'gd':'Am Monadh Neagrach','gl':'*aa','gn':'*aa','gu':u('\u0aae\u0ac9\u0aa8\u0acd\u0a9f\u0ac7\u0aa8\u0ac7\u0a97\u0acd\u0ab0\u0acb'),'gv':'*aa','ha':'*aa','he':u('\u05de\u05d5\u05e0\u05d8\u05e0\u05d2\u05e8\u05d5'),'hi':u('\u092e\u094b\u0902\u091f\u0947\u0928\u0947\u0917\u094d\u0930\u094b'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Montenegr\u00f3'),'hy':u('\u0549\u0565\u057c\u0576\u0578\u0563\u0578\u0580\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'Svartfjallaland','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30e2\u30f3\u30c6\u30cd\u30b0\u30ed'),'ji':u('\u05de\u05d0\u05e0\u05d8\u05e2\u05e0\u05e2\u05d2\u05e8\u05d0'),'jv':'*aa','ka':u('\u10db\u10dd\u10dc\u10e2\u10d4\u10dc\u10d4\u10d2\u10e0\u10dd'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u0427\u0435\u0440\u043d\u043e\u0433\u043e\u0440\u0438\u044f'),'kl':'*aa','km':u('\u1798\u17c9\u17bb\u1784\u178f\u17c1\u178e\u17c1\u17a0\u17d2\u1782\u17d2\u179a\u17c4'),'kn':u('\u0cae\u0cca\u0c82\u0c9f\u0cc6\u0ca8\u0cc6\u0c97\u0ccd\u0cb0\u0ccb'),'ko':u('\ubaac\ud14c\ub124\uadf8\ub85c'),'kr':'*aa','ks':u('\u0645\u0648\u0679\u0648\u0646\u06cc\u065b\u06af\u0650\u0631\u06cc\u0648'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*fr','lo':u('\u0ea1\u0ead\u0e99\u0ec0\u0e95\u0ec0\u0e99\u0ec2\u0e81\u0ea3'),'lt':'Juodkalnija','lu':'*aa','lv':'Melnkalne','mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0426\u0440\u043d\u0430 \u0413\u043e\u0440\u0430'),'ml':u('\u0d2e\u0d4b\u0d23\u0d4d\u0d1f\u0d46\u0d28\u0d46\u0d17\u0d4d\u0d30\u0d4b'),'mn':u('\u041c\u043e\u043d\u0442\u0435\u043d\u0435\u0433\u0440\u043e'),'mo':'Muntenegru','mr':'*hi','ms':'*aa','mt':'il-Montenegro','my':u('\u1019\u103d\u1014\u103a\u1010\u102e\u1014\u102d\u1002\u101b\u102d\u102f\u1038'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u092e\u094b\u0928\u094d\u091f\u0947\u0928\u0947\u0917\u094d\u0930\u094b'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b23\u0b4d\u0b1f\u0b47\u0b28\u0b3f\u0b17\u0b4d\u0b30\u0b4b'),'os':'*aa','pa':u('\u0a2e\u0a4b\u0a02\u0a1f\u0a47\u0a28\u0a47\u0a17\u0a30\u0a4b'),'pi':'*aa','pl':u('Czarnog\u00f3ra'),'ps':u('\u0645\u0648\u0646\u067c\u06cc\u0646\u06cc\u06ab\u0631\u0648'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*mo','ru':'*kk','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0645\u0648\u0646\u067d\u064a \u0646\u064a\u06af\u0631\u0648'),'se':'*aa','sg':'*aa','si':u('\u0db8\u0ddc\u0db1\u0dca\u0da7\u0dd9\u0db1\u0dd3\u0d9c\u0dca\u200d\u0dbb\u0ddd'),'sk':u('\u010cierna Hora'),'sl':u('\u010crna gora'),'sm':'*aa','sn':'*aa','so':'*aa','sq':'Mal i Zi','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0bae\u0bbe\u0ba9\u0bcd\u0b9f\u0bc7\u0ba9\u0bc6\u0b95\u0bcd\u0bb0\u0bcb'),'te':u('\u0c2e\u0c4b\u0c02\u0c1f\u0c46\u0c28\u0c40\u0c17\u0c4d\u0c30\u0c4b'),'tg':'*kk','th':u('\u0e21\u0e2d\u0e19\u0e40\u0e15\u0e40\u0e19\u0e42\u0e01\u0e23'),'ti':u('\u121e\u1295\u1274\u1294\u130d\u122e'),'tk':'*aa','tl':'*aa','tn':'*aa','to':'Monitenikalo','tr':u('Karada\u011f'),'ts':'*aa','tt':'*kk','tw':'*aa','ty':'*aa','ug':u('\u0642\u0627\u0631\u0627 \u062a\u0627\u063a'),'uk':u('\u0427\u043e\u0440\u043d\u043e\u0433\u043e\u0440\u0456\u044f'),'ur':u('\u0645\u0648\u0646\u0679\u06d2 \u0646\u06cc\u06af\u0631\u0648'),'uz':'Chernogoriya','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Montenegoro','xh':'*aa','yi':'*ji','yo':'*aa','za':'*aa','zh':u('\u9ed1\u5c71'),'zu':'i-Montenegro',},
  'MF': {'aa':'Saint Martin','ab':'*aa','ae':'*aa','af':'Sint Martin','ak':'*aa','am':u('\u1234\u1295\u1275 \u121b\u122d\u1272\u1295'),'an':'*aa','ar':u('\u0633\u0627\u0646 \u0645\u0627\u0631\u062a\u0646'),'as':u('\u099b\u09c7\u0987\u09a3\u09cd\u099f \u09ae\u09be\u09f0\u09cd\u099f\u09bf\u09a8'),'av':'*aa','ay':'*aa','az':'Sent Martin','ba':'*aa','be':u('\u0421\u0435\u043d-\u041c\u0430\u0440\u0442\u044d\u043d'),'bg':u('\u0421\u0435\u043d \u041c\u0430\u0440\u0442\u0435\u043d'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u09b8\u09c7\u09a8\u09cd\u099f \u09ae\u09be\u09b0\u09cd\u099f\u09bf\u09a8'),'bo':'*aa','br':'*aa','bs':'Sveti Martin','ca':'*aa','ce':u('\u0421\u0435\u043d-\u041c\u0430\u0440\u0442\u0435\u043d'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Svat\u00fd Martin (Francie)'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'St. Martin','dv':'*aa','dz':u('\u0f66\u0f7a\u0f53\u0f4a\u0f0b \u0f58\u0f71\u0f62\u0f0b\u0f4a\u0f72\u0f53'),'ee':'Saint Martin nutome','el':u('\u0386\u03b3\u03b9\u03bf\u03c2 \u039c\u03b1\u03c1\u03c4\u03af\u03bd\u03bf\u03c2 (\u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03cc \u03c4\u03bc\u03ae\u03bc\u03b1)'),'en':'*de','eo':'*aa','es':u('San Mart\u00edn'),'et':'Saint-Martin','eu':'San Martin','fa':u('\u0633\u0646\u062a \u0645\u0627\u0631\u062a\u06cc\u0646'),'ff':'*aa','fi':'*et','fj':'*aa','fo':'St-Martin','fr':'*et','fy':'*et','ga':'*et','gd':u('Naomh M\u00e0rtainn'),'gl':'*et','gn':'*aa','gu':u('\u0ab8\u0ac7\u0a82\u0a9f \u0aae\u0abe\u0ab0\u0acd\u0a9f\u0abf\u0aa8'),'gv':'*aa','ha':'*aa','he':u('\u05e1\u05df \u05de\u05e8\u05d8\u05df'),'hi':u('\u0938\u0947\u0902\u091f \u092e\u093e\u0930\u094d\u091f\u093f\u0928'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u054d\u0565\u0576 \u0544\u0561\u0580\u057f\u0565\u0576'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*de','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30b5\u30f3\u30fb\u30de\u30eb\u30bf\u30f3'),'ji':'*aa','jv':'*aa','ka':u('\u10e1\u10d4\u10dc-\u10db\u10d0\u10e0\u10e2\u10d4\u10dc\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u179f\u17b6\u17c6\u1784\u200b\u1798\u17c9\u17b6\u1791\u17b8\u1793'),'kn':u('\u0cb8\u0cc7\u0c82\u0c9f\u0ccd \u0cae\u0cbe\u0cb0\u0ccd\u0c9f\u0cbf\u0ca8\u0ccd'),'ko':u('\uc0dd\ub9c8\ub974\ud0f1'),'kr':'*aa','ks':u('\u0633\u06cc\u0646\u065b\u0679 \u0645\u0627\u0631\u0679\u0650\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0421\u0435\u043d\u0442-\u041c\u0430\u0440\u0442\u0438\u043d'),'la':'*aa','lb':'*de','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0ec0\u0e8a\u0e99 \u0ea1\u0eb2\u0e97\u0eb4\u0e99'),'lt':'Sen Martenas','lu':'*aa','lv':u('Senmart\u0113na'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0421\u0435\u043d\u0442 \u041c\u0430\u0440\u0442\u0438\u043d'),'ml':u('\u0d38\u0d46\u0d28\u0d4d\u0d31\u0d4d \u0d2e\u0d3e\u0d7c\u0d1f\u0d4d\u0d1f\u0d3f\u0d7b'),'mn':'*ky','mo':u('Sf\u00e2ntul Martin'),'mr':'*hi','ms':'*aa','mt':'*aa','my':u('\u1005\u102d\u1014\u1037\u103a\u1019\u102c\u1010\u1004\u103a'),'na':'*aa','nb':'*et','nd':'*aa','ne':u('\u0938\u0947\u0928\u094d\u091f \u092e\u093e\u0930\u094d\u091f\u093f\u0928'),'ng':'*aa','nl':'*et','nn':'*aa','no':'*et','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b2e\u0b3e\u0b30\u0b4d\u0b1f\u0b3f\u0b28\u0b4d'),'os':'*aa','pa':u('\u0a38\u0a47\u0a02\u0a1f \u0a2e\u0a3e\u0a30\u0a1f\u0a3f\u0a28'),'pi':'*aa','pl':'*et','ps':u('\u0633\u06cc\u0646\u067c \u0645\u0627\u0631\u067c\u0646'),'pt':u('S\u00e3o Martinho'),'qu':'*es','rm':'*aa','rn':'*aa','ro':'*mo','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u064a\u0646\u067d \u0645\u0627\u0631\u067d\u0646'),'se':'Frankriikka Saint Martin','sg':'*aa','si':u('\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0db8\u0dcf\u0dbb\u0dca\u0da7\u0dd2\u0db1\u0dca'),'sk':u('Sv\u00e4t\u00fd Martin (fr.)'),'sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':u('Sh\u00ebn-Martin'),'sr':u('\u0421\u0432\u0435\u0442\u0438 \u041c\u0430\u0440\u0442\u0438\u043d (\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0430)'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*et','sw':'*de','ta':u('\u0b9a\u0bc6\u0baf\u0bbf\u0ba9\u0bcd\u0b9f\u0bcd \u0bae\u0bbe\u0bb0\u0bcd\u0b9f\u0bcd\u0b9f\u0bc0\u0ba9\u0bcd'),'te':u('\u0c38\u0c46\u0c2f\u0c3f\u0c02\u0c1f\u0c4d \u0c2e\u0c3e\u0c30\u0c4d\u0c1f\u0c3f\u0c28\u0c4d'),'tg':u('\u04b6\u0430\u0437\u0438\u0440\u0430\u0438 \u0421\u0435\u043d\u0442-\u041c\u0430\u0440\u0442\u0438\u043d'),'th':u('\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e21\u0e32\u0e23\u0e4c\u0e15\u0e34\u0e19'),'ti':'*am','tk':'Sen-Marten','tl':'*aa','tn':'*aa','to':u('S\u0101 M\u0101tini (fakafalanis\u0113)'),'tr':'*aa','ts':'*aa','tt':'*ky','tw':'*aa','ty':'*aa','ug':u('\u0633\u0627\u064a\u0646\u062a \u0645\u0627\u0631\u062a\u0649\u0646'),'uk':'*ce','ur':u('\u0633\u06cc\u0646\u0679 \u0645\u0627\u0631\u0679\u0646'),'uz':'Sent-Martin','ve':'*aa','vi':'*de','vo':'*aa','wa':'*aa','wo':u('Sa\u014b Marte\u014b'),'xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u6cd5\u5c5e\u5723\u9a6c\u4e01'),'zu':'i-Saint Martin',},
  'MG': {'aa':'Madagascar','ab':'*aa','ae':'*aa','af':'Madagaskar','ak':'Madagaska','am':u('\u121b\u12f3\u130b\u1235\u12ab\u122d'),'an':'*aa','ar':u('\u0645\u062f\u063a\u0634\u0642\u0631'),'as':u('\u09ae\u09be\u09a6\u09be\u0997\u09be\u09b8\u09cd\u0995\u09be\u09f0'),'av':'*aa','ay':'*aa','az':'Madaqaskar','ba':'*aa','be':u('\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'Madagasikari','bn':u('\u09ae\u09be\u09a6\u09be\u0997\u09be\u09b8\u09cd\u0995\u09be\u09b0'),'bo':'*aa','br':'*af','bs':'*af','ca':'*aa','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*af','cu':'*aa','cv':'*aa','cy':'*aa','da':'*af','de':'*af','dv':'*aa','dz':u('\u0f58\u0f0b\u0f51\u0f71\u0f0b\u0f42\u0f7a\u0f66\u0f0b\u0f40\u0f62'),'ee':'Madagaska nutome','el':u('\u039c\u03b1\u03b4\u03b1\u03b3\u03b1\u03c3\u03ba\u03ac\u03c1\u03b7'),'en':'*aa','eo':'Madagaskaro','es':'*aa','et':'*af','eu':'*af','fa':u('\u0645\u0627\u062f\u0627\u06af\u0627\u0633\u06a9\u0627\u0631'),'ff':'Madagaskaar','fi':'*af','fj':'*aa','fo':'*af','fr':'*aa','fy':'Madeiaskar','ga':'*aa','gd':'Madagasgar','gl':'*aa','gn':'*aa','gu':u('\u0aae\u0ac7\u0aa1\u0abe\u0a97\u0abe\u0ab8\u0acd\u0a95\u0ab0'),'gv':'*aa','ha':'*af','he':u('\u05de\u05d3\u05d2\u05e1\u05e7\u05e8'),'hi':u('\u092e\u0947\u0921\u093e\u0917\u093e\u0938\u094d\u0915\u0930'),'ho':'*aa','hr':'*af','ht':'*aa','hu':u('Madagaszk\u00e1r'),'hy':u('\u0544\u0561\u0564\u0561\u0563\u0561\u057d\u056f\u0561\u0580'),'hz':'*aa','ia':'*aa','id':'*af','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*af','io':'*aa','is':'*af','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30de\u30c0\u30ac\u30b9\u30ab\u30eb'),'ji':u('\u05de\u05d0\u05b7\u05d3\u05d0\u05b7\u05d2\u05d0\u05b7\u05e1\u05e7\u05d0\u05b7\u05e8'),'jv':'*aa','ka':u('\u10db\u10d0\u10d3\u10d0\u10d2\u10d0\u10e1\u10d9\u10d0\u10e0\u10d8'),'kg':'*aa','ki':'Bukini','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u1798\u17c9\u17b6\u178a\u17b6\u17a0\u17d2\u1782\u17b6\u179f\u17d2\u1780\u17b6'),'kn':u('\u0cae\u0ca1\u0c97\u0cbe\u0cb8\u0ccd\u0c95\u0cb0\u0ccd'),'ko':u('\ub9c8\ub2e4\uac00\uc2a4\uce74\ub974'),'kr':'*aa','ks':u('\u0645\u06cc\u0691\u0627\u06af\u0627\u0633\u06a9\u0627\u0631'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*af','lg':'Madagasika','li':'*aa','ln':'*bm','lo':u('\u0ea1\u0eb2\u0e94\u0eb2\u0e81\u0eb2\u0eaa\u0eb0\u0e81\u0eb2'),'lt':'Madagaskaras','lu':'*bm','lv':'Madagaskara','mg':'Madagasikara','mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d2e\u0d21\u0d17\u0d3e\u0d38\u0d4d\u0d15\u0d7c'),'mn':'*be','mo':'*aa','mr':u('\u092e\u093e\u0926\u093e\u0917\u093e\u0938\u094d\u0915\u0930'),'ms':'*af','mt':'*aa','my':u('\u1019\u1012\u102b\u1002\u1010\u103a\u1005\u1000\u102c\u1038'),'na':'*aa','nb':'*af','nd':'*ak','ne':u('\u092e\u093e\u0921\u093e\u0917\u093e\u0938\u094d\u0915\u0930'),'ng':'*aa','nl':'*af','nn':'*af','no':'*af','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b3e\u0b21\u0b3e\u0b17\u0b3e\u0b38\u0b4d\u0b15\u0b30\u0b4d'),'os':'*aa','pa':u('\u0a2e\u0a48\u0a21\u0a3e\u0a17\u0a3e\u0a38\u0a15\u0a30'),'pi':'*aa','pl':'*af','ps':u('\u0645\u062f\u06ab\u0627\u0633\u06a9\u0627\u0631'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'*bm','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0645\u062f\u0627\u06af\u064a\u0633\u06aa\u0631'),'se':'*af','sg':u('Madagask\u00e4ra'),'si':u('\u0db8\u0dd0\u0da9\u0d9c\u0dc3\u0dca\u0d9a\u0dbb\u0dba'),'sk':'*af','sl':'*af','sm':'*aa','sn':'*aa','so':'*af','sq':'*af','sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*af','sw':'*ak','ta':u('\u0bae\u0b9f\u0b95\u0bbe\u0bb8\u0bcd\u0b95\u0bb0\u0bcd'),'te':u('\u0c2e\u0c21\u0c17\u0c3e\u0c38\u0c4d\u0c15\u0c30\u0c4d'),'tg':'*be','th':u('\u0e21\u0e32\u0e14\u0e32\u0e01\u0e31\u0e2a\u0e01\u0e32\u0e23\u0e4c'),'ti':'*am','tk':'*af','tl':'*aa','tn':'*aa','to':'Matakasika','tr':'*af','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u0645\u0627\u062f\u0627\u063a\u0627\u0633\u0642\u0627\u0631'),'uk':'*be','ur':u('\u0645\u0688\u063a\u0627\u0633\u06a9\u0631'),'uz':'*af','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*ff','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Madasika'),'za':'*aa','zh':u('\u9a6c\u8fbe\u52a0\u65af\u52a0'),'zu':'i-Madagascar',},
  'MH': {'aa':'Marshall Islands','ab':'*aa','ae':'*aa','af':'Marshalleilande','ak':'*aa','am':u('\u121b\u122d\u123b\u120d \u12a0\u12ed\u120b\u1295\u12f5'),'an':'*aa','ar':u('\u062c\u0632\u0631 \u0645\u0627\u0631\u0634\u0627\u0644'),'as':u('\u09ae\u09be\u09f0\u09cd\u09b6\u09cd\u09ac\u09be\u09b2 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'av':'*aa','ay':'*aa','az':u('Mar\u015fal adalar\u0131'),'ba':'*aa','be':u('\u041c\u0430\u0440\u0448\u0430\u043b\u0430\u0432\u044b \u0430\u0441\u0442\u0440\u0430\u0432\u044b'),'bg':u('\u041c\u0430\u0440\u0448\u0430\u043b\u043e\u0432\u0438 \u043e\u0441\u0442\u0440\u043e\u0432\u0438'),'bh':'*aa','bi':'*aa','bm':'Marisali Gun','bn':u('\u09ae\u09be\u09b0\u09cd\u09b6\u09be\u09b2 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'bo':'*aa','br':'Inizi Marshall','bs':u('Mar\u0161alova ostrva'),'ca':'Illes Marshall','ce':u('\u041c\u0430\u0440\u0448\u0430\u043b\u043b\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Marshallovy ostrovy','cu':'*aa','cv':'*aa','cy':'Ynysoedd Marshall','da':u('Marshall\u00f8erne'),'de':'Marshallinseln','dv':'*aa','dz':u('\u0f58\u0f62\u0f0b\u0f64\u0f7a\u0f63\u0f0b\u0f42\u0fb3\u0f72\u0f44\u0f0b\u0f5a\u0f7c\u0f58'),'ee':u('Marshal \u0192udomekpowo nutome'),'el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u039c\u03ac\u03c1\u03c3\u03b1\u03bb'),'en':'*aa','eo':u('Mar\u015daloj'),'es':'Islas Marshall','et':'Marshalli Saared','eu':'Marshall Uharteak','fa':u('\u062c\u0632\u0627\u06cc\u0631 \u0645\u0627\u0631\u0634\u0627\u0644'),'ff':u('Duu\u0257e Marsaal'),'fi':'Marshallinsaaret','fj':'*aa','fo':'Marshalloyggjar','fr':u('\u00celes Marshall'),'fy':'Marshalleilannen','ga':u('Oile\u00e1in Marshall'),'gd':'Eileanan Mharshall','gl':'Illas Marshall','gn':'*aa','gu':u('\u0aae\u0abe\u0ab0\u0acd\u0ab6\u0ab2 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8'),'gv':'*aa','ha':'Tsibiran Marshal','he':u('\u05d0\u05d9\u05d9 \u05de\u05e8\u05e9\u05dc'),'hi':u('\u092e\u093e\u0930\u094d\u0936\u0932 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939'),'ho':'*aa','hr':u('Mar\u0161alovi Otoci'),'ht':'*aa','hu':'Marshall-szigetek','hy':u('\u0544\u0561\u0580\u0577\u0561\u056c\u0575\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'Kepulauan Marshall','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'Marshalleyjar','it':'Isole Marshall','iu':'*aa','iw':'*he','ja':u('\u30de\u30fc\u30b7\u30e3\u30eb\u8af8\u5cf6'),'ji':u('\u05de\u05d0\u05b7\u05e8\u05e9\u05d0\u05b7\u05dc \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df'),'jv':'*aa','ka':u('\u10db\u10d0\u10e0\u10e8\u10d0\u10da\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'Visiwa vya Marshal','kj':'*aa','kk':u('\u041c\u0430\u0440\u0448\u0430\u043b\u043b \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'kl':'*aa','km':u('\u1780\u17c4\u17c7\u200b\u1798\u17c9\u17b6\u179f\u17cb\u179f\u179b'),'kn':u('\u0cae\u0cbe\u0cb0\u0ccd\u0cb7\u0cb2\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3\u0cc1'),'ko':u('\ub9c8\uc15c \uc81c\ub3c4'),'kr':'*aa','ks':u('\u0645\u0627\u0631\u0634\u064e\u0644 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'Marshallinselen','lg':'Bizinga bya Mariso','li':'*aa','ln':u('Bisanga bya Marishal\u025b'),'lo':u('\u0eab\u0ea1\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ea1\u0eb2\u0ec1\u0e8a\u0ea7'),'lt':u('Mar\u0161alo Salos'),'lu':'Lutanda lua Marishale','lv':u('M\u0101r\u0161ala salas'),'mg':'Nosy Marshall','mh':'*aa','mi':'*aa','mk':u('\u041c\u0430\u0440\u0448\u0430\u043b\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438'),'ml':u('\u0d2e\u0d3e\u0d7c\u0d37\u0d7d \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e'),'mn':u('\u041c\u0430\u0440\u0448\u0430\u043b\u043b\u044b\u043d \u0430\u0440\u043b\u0443\u0443\u0434'),'mo':'Insulele Marshall','mr':u('\u092e\u093e\u0930\u094d\u0936\u0932 \u092c\u0947\u091f\u0947'),'ms':'*id','mt':u('G\u017cejjer Marshall'),'my':u('\u1019\u102c\u101b\u103e\u101a\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f'),'na':'*aa','nb':u('Marshall\u00f8yene'),'nd':'*aa','ne':u('\u092e\u093e\u0930\u094d\u0936\u0932 \u091f\u093e\u092a\u0941\u0939\u0930\u0941'),'ng':'*aa','nl':'Marshalleilanden','nn':u('Marshall\u00f8yane'),'no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b3e\u0b30\u0b4d\u0b36\u0b3e\u0b32\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c'),'os':'*aa','pa':u('\u0a2e\u0a3e\u0a30\u0a38\u0a3c\u0a32 \u0a1f\u0a3e\u0a2a\u0a42'),'pi':'*aa','pl':'Wyspy Marshalla','ps':u('\u0645\u0627\u0631\u0634\u0627\u0644 \u067c\u0627\u067e\u0648'),'pt':'Ilhas Marshall','qu':'*es','rm':'Inslas da Marshall','rn':'Izinga rya Marishari','ro':'*mo','ru':u('\u041c\u0430\u0440\u0448\u0430\u043b\u043b\u043e\u0432\u044b \u041e\u0441\u0442\u0440\u043e\u0432\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0645\u0627\u0631\u0634\u0644 \u0680\u064a\u067d'),'se':'Marshallsullot','sg':u('\u00c2z\u00fb\u00e2 M\u00e4rsh\u00e2l'),'si':u('\u0db8\u0dcf\u0dc2\u0dbd\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca'),'sk':'Marshallove ostrovy','sl':'Marshallovi otoki','sm':'*aa','sn':'Zvitsuwa zveMarshall','so':'*aa','sq':'Ishujt Marshall','sr':u('\u041c\u0430\u0440\u0448\u0430\u043b\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Marshall\u00f6arna'),'sw':'Visiwa vya Marshall','ta':u('\u0bae\u0bbe\u0bb0\u0bcd\u0bb7\u0bb2\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd'),'te':u('\u0c2e\u0c3e\u0c30\u0c4d\u0c37\u0c32\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41'),'tg':u('\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u041c\u0430\u0440\u0448\u0430\u043b\u043b'),'th':u('\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e21\u0e32\u0e23\u0e4c\u0e41\u0e0a\u0e25\u0e25\u0e4c'),'ti':'*am','tk':u('Mar\u015fall adalary'),'tl':'*aa','tn':'*aa','to':u('\u02bbOtumotu M\u0101solo'),'tr':u('Marshall Adalar\u0131'),'ts':'*aa','tt':u('\u041c\u0430\u0440\u0448\u0430\u043b\u043b \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0645\u0627\u0631\u0634\u0627\u0644 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649'),'uk':u('\u041c\u0430\u0440\u0448\u0430\u043b\u043b\u043e\u0432\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438'),'ur':u('\u0645\u0627\u0631\u0634\u0644 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632'),'uz':'Marshall orollari','ve':'*aa','vi':u('Qu\u1ea7n \u0111\u1ea3o Marshall'),'vo':'*aa','wa':'*aa','wo':'Duni Marsaal','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Etikun M\u00e1\u1e63ali'),'za':'*aa','zh':u('\u9a6c\u7ecd\u5c14\u7fa4\u5c9b'),'zu':'i-Marshall Islands',},
  'MK': {'aa':'Macedonia','ab':'*aa','ae':'*aa','af':u('Macedoni\u00eb'),'ak':'Masedonia','am':u('\u1218\u1244\u12f6\u1295\u12eb'),'an':'*aa','ar':u('\u0645\u0642\u062f\u0648\u0646\u064a\u0627'),'as':u('\u09ae\u09c7\u099a\u09bf\u09a1\u09cb\u09a8\u09c0\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Makedoniya','ba':'*aa','be':u('\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0456\u044f'),'bg':u('\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':u('Maced\u0254ni'),'bn':u('\u09ae\u09cd\u09af\u09be\u09b8\u09be\u09a1\u09cb\u09a8\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'Makedonia','bs':'Makedonija','ca':u('Maced\u00f2nia'),'ce':u('\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Makedonie','cu':'*aa','cv':'*aa','cy':'*aa','da':'Makedonien','de':'Mazedonien','dv':'*aa','dz':u('\u0f58\u0f0b\u0f66\u0f7a\u0f0b\u0f4c\u0f7c\u0f0b\u0f53\u0f72\u0f0b\u0f61'),'ee':'Makedonia nutome','el':u('\u03a0\u03c1\u03ce\u03b7\u03bd \u0393\u03b9\u03bf\u03c5\u03b3\u03ba\u03bf\u03c3\u03bb\u03b1\u03b2\u03b9\u03ba\u03ae \u0394\u03b7\u03bc\u03bf\u03ba\u03c1\u03b1\u03c4\u03af\u03b1 \u03c4\u03b7\u03c2 \u039c\u03b1\u03ba\u03b5\u03b4\u03bf\u03bd\u03af\u03b1\u03c2'),'en':'*aa','eo':'Makedonujo','es':'*aa','et':'Makedoonia','eu':'Mazedonia','fa':u('\u0645\u0642\u062f\u0648\u0646\u06cc\u0647'),'ff':'Meceduwaan','fi':'*br','fj':'*aa','fo':u('Maked\u00f3nia'),'fr':u('Mac\u00e9doine'),'fy':'*af','ga':u('an Mhacad\u00f3in'),'gd':u('A\u2019 Mhasadon'),'gl':'*aa','gn':'*aa','gu':u('\u0aae\u0ac7\u0ab8\u0ac7\u0aa1\u0acb\u0aa8\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Masedoniya','he':u('\u05de\u05e7\u05d3\u05d5\u05e0\u05d9\u05d4'),'hi':u('\u092e\u0915\u0926\u0942\u0928\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Maced\u00f3nia'),'hy':u('\u0544\u0561\u056f\u0565\u0564\u0578\u0576\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*br','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*br','io':'*aa','is':u('Maked\u00f3n\u00eda'),'it':'Repubblica di Macedonia','iu':'*aa','iw':'*he','ja':u('\u30de\u30b1\u30c9\u30cb\u30a2'),'ji':u('\u05de\u05d0\u05b7\u05e7\u05e2\u05d3\u05d0\u05e0\u05d9\u05e2'),'jv':'*aa','ka':u('\u10db\u10d0\u10d9\u10d4\u10d3\u10dd\u10dc\u10d8\u10d0'),'kg':'*aa','ki':'*ak','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1798\u17c9\u17b6\u179f\u17c1\u178a\u17d2\u179c\u17b6\u1793'),'kn':u('\u0cae\u0ccd\u0caf\u0cbe\u0cb8\u0cbf\u0ca1\u0ccb\u0ca8\u0cbf\u0caf\u0cbe'),'ko':u('\ub9c8\ucf00\ub3c4\ub2c8\uc544'),'kr':'*aa','ks':u('\u0645\u066e\u06ea\u0633\u0648\u0691\u0648\u0646\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*de','lg':'*ha','li':'*aa','ln':u('Masedwan\u025b'),'lo':u('\u0ec1\u0ea1\u0e8a\u0eb4\u0ec2\u0e94\u0ec0\u0e99\u0e8d'),'lt':'*bs','lu':'Masedwane','lv':u('Ma\u0137edonija'),'mg':'*br','mh':'*aa','mi':'*aa','mk':u('\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438\u0458\u0430'),'ml':u('\u0d2e\u0d3e\u0d38\u0d3f\u0d21\u0d4b\u0d23\u0d3f\u0d2f'),'mn':u('\u041c\u0430\u043a\u0435\u0434\u043e\u043d'),'mo':'Republica Macedonia','mr':u('\u092e\u0945\u0938\u0947\u0921\u094b\u0928\u093f\u092f\u093e'),'ms':'*aa','mt':u('l-Eks-Repubblika Jugoslava tal-Ma\u010bedonia'),'my':u('\u1019\u1000\u103a\u1006\u102e\u1012\u102d\u102f\u1038\u1014\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'*br','nd':'*aa','ne':u('\u092e\u094d\u092f\u093e\u0938\u0947\u0921\u094b\u0928\u093f\u092f\u093e'),'ng':'*aa','nl':'*af','nn':'*br','no':'*br','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b3e\u0b38\u0b47\u0b21\u0b4b\u0b28\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a2e\u0a48\u0a15\u0a21\u0a4b\u0a28\u0a40\u0a06'),'pi':'*aa','pl':'*aa','ps':'*fa','pt':u('Maced\u00f4nia'),'qu':'ERY Macedonia','rm':'*aa','rn':'*ha','ro':'*mo','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0645\u064a\u0633\u064a \u068a\u0648\u0646\u064a\u0627'),'se':'*br','sg':u('Masedu\u00e4ni'),'si':u('\u0db8\u0dd0\u0dc3\u0dd2\u0da9\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0dc0'),'sk':u('Maced\u00f3nsko'),'sl':'*bs','sm':'*aa','sn':'*aa','so':'Makadooniya','sq':'Maqedoni','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':u('\u0bae\u0bbe\u0b9a\u0bbf\u0b9f\u0bcb\u0ba9\u0bbf\u0baf\u0bbe'),'te':u('\u0c2e\u0c47\u0c38\u0c3f\u0c21\u0c4b\u0c28\u0c3f\u0c2f\u0c3e'),'tg':u('\u041c\u0430\u049b\u0434\u0443\u043d'),'th':u('\u0e21\u0e32\u0e0b\u0e34\u0e42\u0e14\u0e40\u0e19\u0e35\u0e22'),'ti':u('\u121b\u12a8\u12f6\u1292\u12eb'),'tk':u('Makedoni\u00fda'),'tl':'*aa','tn':'*aa','to':u('Maset\u014dnia'),'tr':'Makedonya','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':u('\u0645\u0627\u0643\u06d0\u062f\u0648\u0646\u0649\u064a\u06d5'),'uk':'*be','ur':u('\u0645\u0642\u062f\u0648\u0646\u06cc\u06c1'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Maseduwaan','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Masidonia'),'za':'*aa','zh':u('\u9a6c\u5176\u987f'),'zu':'i-Macedonia',},
  'ML': {'aa':'Mali','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u121b\u120a'),'an':'*aa','ar':u('\u0645\u0627\u0644\u064a'),'as':u('\u09ae\u09be\u09b2\u09bf'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u041c\u0430\u043b\u0456'),'bg':u('\u041c\u0430\u043b\u0438'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':'*as','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f58\u0f71\u0f0b\u0f63\u0f72'),'ee':'Mali nutome','el':u('\u039c\u03ac\u03bb\u03b9'),'en':'*aa','eo':'Malio','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0645\u0627\u0644\u06cc'),'ff':'Maali','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('Mail\u00ed'),'gd':u('M\u00e0ili'),'gl':u('Mal\u00ed'),'gn':'*aa','gu':u('\u0aae\u0abe\u0ab2\u0ac0'),'gv':'*aa','ha':'*aa','he':u('\u05de\u05d0\u05dc\u05d9'),'hi':u('\u092e\u093e\u0932\u0940'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u0544\u0561\u056c\u056b'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*gl','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30de\u30ea'),'ji':u('\u05de\u05d0\u05b7\u05dc\u05d9'),'jv':'*aa','ka':u('\u10db\u10d0\u10da\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1798\u17c9\u17b6\u179b\u17b8'),'kn':u('\u0cae\u0cbe\u0cb2\u0cbf'),'ko':u('\ub9d0\ub9ac'),'kr':'*aa','ks':'*fa','ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*gl','lo':u('\u0ea1\u0eb2\u0ea5\u0eb5'),'lt':'Malis','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d2e\u0d3e\u0d32\u0d3f'),'mn':'*bg','mo':'*aa','mr':'*hi','ms':'*aa','mt':'il-Mali','my':u('\u1019\u102c\u101c\u102e'),'na':'*aa','nb':'*aa','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b3e\u0b32\u0b3f'),'os':'*aa','pa':u('\u0a2e\u0a3e\u0a32\u0a40'),'pi':'*aa','pl':'*aa','ps':'*ar','pt':'*aa','qu':'*gl','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*ar','se':'*aa','sg':u('Mal\u00efi'),'si':u('\u0db8\u0dcf\u0dbd\u0dd2'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*ff','sq':'*aa','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0bae\u0bbe\u0bb2\u0bbf'),'te':u('\u0c2e\u0c3e\u0c32\u0c3f'),'tg':'*bg','th':u('\u0e21\u0e32\u0e25\u0e35'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':u('M\u0101li'),'tr':'*aa','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0645\u0627\u0644\u0649'),'uk':'*be','ur':'*fa','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Mali'),'za':'*aa','zh':u('\u9a6c\u91cc'),'zu':'iMali',},
  'MM': {'aa':'Myanmar','ab':'*aa','ae':'*aa','af':'Mianmar (Birma)','ak':'Miyanma','am':u('\u121b\u12ed\u1293\u121b\u122d(\u1260\u122d\u121b)'),'an':'*aa','ar':u('\u0645\u064a\u0627\u0646\u0645\u0627\u0631 (\u0628\u0648\u0631\u0645\u0627)'),'as':u('\u09ae\u09cd\u09af\u09be\u09a8\u09ae\u09be\u09f0 (\u09ac\u09be\u09f0\u09cd\u09ae\u09be)'),'av':'*aa','ay':'*aa','az':'Myanma','ba':'*aa','be':u('\u041c\u2019\u044f\u043d\u043c\u0430 (\u0411\u0456\u0440\u043c\u0430)'),'bg':u('\u041c\u0438\u0430\u043d\u043c\u0430\u0440 (\u0411\u0438\u0440\u043c\u0430)'),'bh':'*aa','bi':'*aa','bm':'Myanimari','bn':u('\u09ae\u09be\u09af\u09bc\u09be\u09a8\u09ae\u09be\u09b0 (\u09ac\u09be\u09b0\u09cd\u09ae\u09be)'),'bo':'*aa','br':'Myanmar (Birmania)','bs':'Mjanmar','ca':u('Myanmar (Birm\u00e0nia)'),'ce':u('\u041c\u044c\u044f\u043d\u043c\u0430 (\u0411\u0438\u0440\u043c\u0430)'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Myanmar (Barma)','cu':'*aa','cv':'*aa','cy':'Myanmar (Burma)','da':'*cy','de':'*aa','dv':'*aa','dz':u('\u0f58\u0f72\u0f0b\u0f61\u0f71\u0f53\u0f0b\u0f58\u0f62\u0f0b (\u0f56\u0fb7\u0f62\u0f0b\u0f58)'),'ee':'Myanmar (Burma) nutome','el':u('\u039c\u03b9\u03b1\u03bd\u03bc\u03ac\u03c1 (\u0392\u03b9\u03c1\u03bc\u03b1\u03bd\u03af\u03b1)'),'en':'*cy','eo':'Mjanmao','es':'*br','et':'Myanmar (Birma)','eu':'*br','fa':u('\u0645\u06cc\u0627\u0646\u0645\u0627\u0631 (\u0628\u0631\u0645\u0647)'),'ff':'Miyamaar','fi':'*cy','fj':'*aa','fo':'*cy','fr':'Myanmar (Birmanie)','fy':'*et','ga':'Maenmar (Burma)','gd':u('Mi\u00e0nmar'),'gl':'*br','gn':'*aa','gu':u('\u0aae\u0acd\u0aaf\u0abe\u0a82\u0aae\u0abe\u0ab0 (\u0aac\u0ab0\u0acd\u0aae\u0abe)'),'gv':'*aa','ha':'Burma, Miyamar','he':u('\u05de\u05d9\u05d0\u05e0\u05de\u05e8 (\u05d1\u05d5\u05e8\u05de\u05d4)'),'hi':u('\u092e\u094d\u092f\u093e\u0902\u092e\u093e\u0930 (\u092c\u0930\u094d\u092e\u093e)'),'ho':'*aa','hr':'Mjanmar (Burma)','ht':'*aa','hu':'Mianmar (Burma)','hy':u('\u0544\u0575\u0561\u0576\u0574\u0561 (\u0532\u056b\u0580\u0574\u0561)'),'hz':'*aa','ia':'*aa','id':'*cy','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*cy','io':'*aa','is':u('Mjanmar (B\u00farma)'),'it':'*br','iu':'*aa','iw':'*he','ja':u('\u30df\u30e3\u30f3\u30de\u30fc (\u30d3\u30eb\u30de)'),'ji':u('\u05de\u05d9\u05d0\u05b7\u05e0\u05de\u05d0\u05b7\u05e8'),'jv':'*aa','ka':u('\u10db\u10d8\u10d0\u10dc\u10db\u10d0\u10e0\u10d8 (\u10d1\u10d8\u10e0\u10db\u10d0)'),'kg':'*aa','ki':'Myama','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u1798\u17b8\u1799\u17c9\u17b6\u1793\u17cb\u1798\u17c9\u17b6 (\u1797\u17bc\u1798\u17b6)'),'kn':u('\u0cae\u0caf\u0ca8\u0ccd\u0cae\u0cbe\u0cb0\u0ccd (\u0cac\u0cb0\u0ccd\u0cae\u0cbe)'),'ko':u('\ubbf8\uc580\ub9c8'),'kr':'*aa','ks':u('\u0645\u064e\u06cc\u064e\u0646\u0645\u0627 \u0628\u0654\u0631\u0645\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*aa','lg':'Myanima','li':'*aa','ln':'Birmanie','lo':u('\u0ea1\u0ebd\u0e99\u0ea1\u0eb2 (\u0ec0\u0e9a\u0eb5\u0ea1\u0eb2)'),'lt':'Mianmaras (Birma)','lu':'Myamare','lv':'Mjanma (Birma)','mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u041c\u0458\u0430\u043d\u043c\u0430\u0440 (\u0411\u0443\u0440\u043c\u0430)'),'ml':u('\u0d2e\u0d4d\u0d2f\u0d3e\u0d7b\u0d2e\u0d3e\u0d7c (\u0d2c\u0d7c\u0d2e\u0d4d\u0d2e)'),'mn':u('\u041c\u044c\u044f\u043d\u043c\u0430\u0440'),'mo':'*aa','mr':u('\u092e\u094d\u092f\u093e\u0928\u092e\u093e\u0930 (\u092c\u0930\u094d\u092e\u093e)'),'ms':'*cy','mt':'il-Myanmar/Burma','my':u('\u1019\u103c\u1014\u103a\u1019\u102c'),'na':'*aa','nb':'*cy','nd':'*aa','ne':u('\u092e\u094d\u092f\u093e\u0928\u094d\u092e\u093e\u0930 (\u092c\u0930\u094d\u092e\u093e)'),'ng':'*aa','nl':'*et','nn':'*cy','no':'*cy','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b3f\u0b06\u0b01\u0b2e\u0b3e\u0b30'),'os':'*aa','pa':u('\u0a2e\u0a3f\u0a06\u0a02\u0a2e\u0a3e\u0a30 (\u0a2c\u0a30\u0a2e\u0a3e)'),'pi':'*aa','pl':'*lv','ps':u('\u0645\u064a\u0627\u0646\u0627\u0645\u0627\u0631 (\u0628\u0631\u0645\u0627)'),'pt':u('Mianmar (Birm\u00e2nia)'),'qu':'*aa','rm':'*aa','rn':'Birimaniya','ro':'*br','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0645\u064a\u0627\u0646\u0645\u0627\u0631 (\u0628\u0631\u0645\u0627)'),'se':'Burma','sg':u('My\u00e4m\u00e2ra'),'si':u('\u0db8\u0dd2\u0dba\u0db1\u0dca\u0db8\u0dcf\u0dbb\u0dba (\u0db6\u0dd4\u0dbb\u0dd4\u0db8\u0dba)'),'sk':'Mjanmarsko','sl':'*hr','sm':'*aa','sn':'*aa','so':'Miyanmar','sq':'*hu','sr':u('\u041c\u0438\u0458\u0430\u043d\u043c\u0430\u0440 (\u0411\u0443\u0440\u043c\u0430)'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*cy','sw':'*cy','ta':u('\u0bae\u0bbf\u0baf\u0bbe\u0ba9\u0bcd\u0bae\u0bbe\u0bb0\u0bcd (\u0baa\u0bb0\u0bcd\u0bae\u0bbe)'),'te':u('\u0c2e\u0c2f\u0c28\u0c4d\u0c2e\u0c3e\u0c30\u0c4d (\u0c2c\u0c30\u0c4d\u0c2e\u0c3e)'),'tg':u('\u041c\u044f\u043d\u043c\u0430'),'th':u('\u0e40\u0e21\u0e35\u0e22\u0e19\u0e21\u0e32\u0e23\u0e4c (\u0e1e\u0e21\u0e48\u0e32)'),'ti':u('\u121b\u12eb\u1295\u121b\u122d'),'tk':u('M\u00fdanma (Burma)'),'tl':'*cy','tn':'*aa','to':'Pema','tr':'*cy','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':u('\u0628\u0649\u0631\u0645\u0627'),'uk':u('\u041c\u02bc\u044f\u043d\u043c\u0430 (\u0411\u0456\u0440\u043c\u0430)'),'ur':u('\u0645\u06cc\u0627\u0646\u0645\u0627\u0631 (\u0628\u0631\u0645\u0627)'),'uz':'Myanma (Birma)','ve':'*aa','vi':u('Myanmar (Mi\u1ebfn \u0110i\u1ec7n)'),'vo':'*aa','wa':'*aa','wo':'Miyanmaar','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Manamari'),'za':'*aa','zh':u('\u7f05\u7538'),'zu':'i-Myanmar (Burma)',},
  'MN': {'aa':'Mongolia','ab':'*aa','ae':'*aa','af':u('Mongoli\u00eb'),'ak':u('M\u0254ngolia'),'am':u('\u121e\u1295\u130e\u120a\u12eb'),'an':'*aa','ar':u('\u0645\u0646\u063a\u0648\u0644\u064a\u0627'),'as':u('\u09ae\u0999\u09cd\u0997\u09cb\u09b2\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Monqolustan','ba':'*aa','be':u('\u041c\u0430\u043d\u0433\u043e\u043b\u0456\u044f'),'bg':u('\u041c\u043e\u043d\u0433\u043e\u043b\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':u('Mo\u014boli'),'bn':'*as','bo':'*aa','br':'*aa','bs':'Mongolija','ca':u('Mong\u00f2lia'),'ce':u('\u041c\u043e\u043d\u0433\u043e\u043b\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Mongolsko','cu':'*aa','cv':'*aa','cy':'*aa','da':'Mongoliet','de':'Mongolei','dv':'*aa','dz':u('\u0f66\u0f7c\u0f42\u0f0b\u0f54\u0f7c\u0f0b\u0f61\u0f74\u0f63'),'ee':'Mongolia nutome','el':u('\u039c\u03bf\u03b3\u03b3\u03bf\u03bb\u03af\u03b1'),'en':'*aa','eo':'Mongolujo','es':'*aa','et':'Mongoolia','eu':'*aa','fa':u('\u0645\u063a\u0648\u0644\u0633\u062a\u0627\u0646'),'ff':'Monngolii','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Mongolie','fy':'*af','ga':u('an Mhong\u00f3il'),'gd':u('D\u00f9thaich nam Mongol'),'gl':'*aa','gn':'*aa','gu':u('\u0aae\u0a82\u0a97\u0acb\u0ab2\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Mangoliya','he':u('\u05de\u05d5\u05e0\u05d2\u05d5\u05dc\u05d9\u05d4'),'hi':u('\u092e\u0902\u0917\u094b\u0932\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Mong\u00f3lia'),'hy':u('\u0544\u0578\u0576\u0572\u0578\u056c\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Mong\u00f3l\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30e2\u30f3\u30b4\u30eb'),'ji':u('\u05de\u05d0\u05e0\u05d2\u05d0\u05dc\u05d9\u05d9'),'jv':'*aa','ka':u('\u10db\u10dd\u10dc\u10e6\u10dd\u10da\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u041c\u043e\u04a3\u0493\u043e\u043b\u0438\u044f'),'kl':'*aa','km':u('\u1798\u17c9\u17bb\u1784\u17a0\u17d2\u1782\u17c4\u179b\u17b8'),'kn':u('\u0cae\u0c82\u0c97\u0ccb\u0cb2\u0cbf\u0caf\u0cbe'),'ko':u('\ubabd\uace8'),'kr':'*aa','ks':u('\u0645\u064e\u0646\u065b\u06af\u0648\u0644\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*de','lg':'Mongoliya','li':'*aa','ln':u('Mongol\u00ed'),'lo':u('\u0ea1\u0ead\u0e87\u0ec2\u0e81\u0ec0\u0ea5\u0e8d'),'lt':'*bs','lu':'Mongoli','lv':'*bs','mg':u('M\u00f4ng\u00f4lia'),'mh':'*aa','mi':'*aa','mk':u('\u041c\u043e\u043d\u0433\u043e\u043b\u0438\u0458\u0430'),'ml':u('\u0d2e\u0d02\u0d17\u0d4b\u0d33\u0d3f\u0d2f'),'mn':u('\u041c\u043e\u043d\u0433\u043e\u043b'),'mo':'*aa','mr':'*hi','ms':'*aa','mt':'il-Mongolja','my':u('\u1019\u103d\u1014\u103a\u1002\u102d\u102f\u1038\u101c\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u092e\u0919\u094d\u0917\u094b\u0932\u093f\u092f\u093e'),'ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b19\u0b4d\u0b17\u0b4b\u0b32\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a2e\u0a70\u0a17\u0a4b\u0a32\u0a40\u0a06'),'pi':'*aa','pl':'*aa','ps':'*fa','pt':'*hu','qu':'*aa','rm':'*aa','rn':'*lg','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0645\u0646\u06af\u0648\u0644\u064a\u0627'),'se':'*aa','sg':u('Mongol\u00efi'),'si':u('\u0db8\u0ddc\u0db1\u0dca\u0d9c\u0ddd\u0dbd\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*cs','sl':'*bs','sm':'*aa','sn':'*aa','so':'Mongooliya','sq':'*lu','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':u('\u0bae\u0b99\u0bcd\u0b95\u0bcb\u0bb2\u0bbf\u0baf\u0bbe'),'te':u('\u0c2e\u0c02\u0c17\u0c4b\u0c32\u0c3f\u0c2f\u0c3e'),'tg':u('\u041c\u0443\u0493\u0443\u043b\u0438\u0441\u0442\u043e\u043d'),'th':u('\u0e21\u0e2d\u0e07\u0e42\u0e01\u0e40\u0e25\u0e35\u0e22'),'ti':'*am','tk':u('Mongoli\u00fda'),'tl':'*aa','tn':'*aa','to':u('Mongok\u014dlia'),'tr':u('Mo\u011folistan'),'ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0645\u0648\u06ad\u063a\u06c7\u0644\u0649\u064a\u06d5'),'uk':u('\u041c\u043e\u043d\u0433\u043e\u043b\u0456\u044f'),'ur':u('\u0645\u0646\u06af\u0648\u0644\u06cc\u0627'),'uz':'*lg','ve':'*aa','vi':u('M\u00f4ng C\u1ed5'),'vo':'*aa','wa':'*aa','wo':'*lu','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Mogolia'),'za':'*aa','zh':u('\u8499\u53e4'),'zu':'i-Mongolia',},
  'MO': {'aa':'Macao','ab':'*aa','ae':'*aa','af':'Macau SAS Sjina','ak':'*aa','am':u('\u121b\u12ab\u12a1 \u120d\u12e9 \u12e8\u12a0\u1235\u1270\u12f3\u12f0\u122d \u12ad\u120d\u120d \u127b\u12ed\u1293'),'an':'*aa','ar':u('\u0645\u0643\u0627\u0648 \u0627\u0644\u0635\u064a\u0646\u064a\u0629 (\u0645\u0646\u0637\u0642\u0629 \u0625\u062f\u0627\u0631\u064a\u0629 \u062e\u0627\u0635\u0629)'),'as':u('\u09ae\u09be\u0995\u09be\u0989 \u098f\u099b. \u098f. \u0986\u09f0. \u099a\u09c0\u09a8'),'av':'*aa','ay':'*aa','az':u('Makao X\u00fcsusi \u0130nzibati \u018frazi \u00c7in'),'ba':'*aa','be':u('\u041c\u0430\u043a\u0430\u0430, \u0421\u0410\u0420 (\u041a\u0456\u0442\u0430\u0439)'),'bg':u('\u041c\u0430\u043a\u0430\u043e, \u0421\u0410\u0420 \u043d\u0430 \u041a\u0438\u0442\u0430\u0439'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u09ae\u09cd\u09af\u09be\u0995\u09be\u0993 \u098f\u09b8\u098f\u0986\u09b0 \u099a\u09c0\u09a8\u09be'),'bo':'*aa','br':'Macau RMD Sina','bs':'Makao (SAR Kina)','ca':'Macau (RAE Xina)','ce':u('\u041c\u0430\u043a\u0430\u043e (\u0448\u0430-\u043a\u044a\u0430\u044c\u0441\u0442\u0438\u043d\u0430 \u043a\u04c0\u043e\u0448\u0442)'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Macao \u2013 ZAO \u010c\u00edny'),'cu':'*aa','cv':'*aa','cy':'Macau RhGA Tsieina','da':'SAR Macao','de':'Sonderverwaltungsregion Macau','dv':'*aa','dz':u('\u0f58\u0f40\u0f0b\u0f68\u0f60\u0f74\u0f0b\u0f45\u0f71\u0f60\u0f72\u0f0b\u0f53'),'ee':'Macau SAR Tsaina nutome','el':u('\u039c\u03b1\u03ba\u03ac\u03bf \u0395\u0394\u03a0 \u039a\u03af\u03bd\u03b1\u03c2'),'en':'Macau SAR China','eo':'*aa','es':'RAE de Macao (China)','et':'Macau erihalduspiirkond','eu':'Macau Txinako AEB','fa':u('\u0645\u0627\u06a9\u0627\u0626\u0648\u060c \u0646\u0627\u062d\u06cc\u0647\u0654 \u0648\u06cc\u0698\u0647\u0654 \u062d\u06a9\u0648\u0645\u062a\u06cc \u0686\u06cc\u0646'),'ff':'*aa','fi':u('Macao \u2013 Kiinan e.h.a.'),'fj':'*aa','fo':'Makao SAR Kina','fr':'R.A.S. chinoise de Macao','fy':'Macao SAR van Sina','ga':u('S.R.R. na S\u00edne Macao'),'gd':u('Mac\u00e0thu SAR na S\u00ecne'),'gl':'Macau RAE da China','gn':'*aa','gu':u('\u0aae\u0a95\u0abe\u0a89 SAR \u0a9a\u0ac0\u0aa8'),'gv':'*aa','ha':'*aa','he':u('\u05de\u05e7\u05d0\u05d5 (\u05d0\u05d6\u05d5\u05e8 \u05de\u05e0\u05d4\u05dc\u05d9 \u05de\u05d9\u05d5\u05d7\u05d3 \u05e9\u05dc \u05e1\u05d9\u05df)'),'hi':u('\u092e\u0915\u093e\u090a (\u0935\u093f\u0936\u0947\u0937 \u092a\u094d\u0930\u0936\u093e\u0938\u0928\u093f\u0915 \u0915\u094d\u0937\u0947\u0924\u094d\u0930 \u091a\u0940\u0928)'),'ho':'*aa','hr':'PUP Makao Kina','ht':'*aa','hu':u('Maka\u00f3 KKT'),'hy':u('\u0549\u056b\u0576\u0561\u057d\u057f\u0561\u0576\u056b \u0544\u0561\u056f\u0561\u0578 \u0540\u054e\u0547'),'hz':'*aa','ia':'*aa','id':'Makau SAR Tiongkok','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('s\u00e9rstj\u00f3rnarsv\u00e6\u00f0i\u00f0 Maka\u00f3'),'it':'RAS di Macao','iu':'*aa','iw':'*he','ja':u('\u4e2d\u83ef\u4eba\u6c11\u5171\u548c\u56fd\u30de\u30ab\u30aa\u7279\u5225\u884c\u653f\u533a'),'ji':'*aa','jv':'*aa','ka':u('\u10db\u10d0\u10d9\u10d0\u10dd\u10e1 \u10e1\u10de\u10d4\u10ea\u10d8\u10d0\u10da\u10e3\u10e0\u10d8 \u10d0\u10d3\u10db\u10d8\u10dc\u10d8\u10e1\u10e2\u10e0\u10d0\u10ea\u10d8\u10e3\u10da\u10d8 \u10e0\u10d4\u10d2\u10d8\u10dd\u10dc\u10d8 \u10e9\u10d8\u10dc\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u041c\u0430\u043a\u0430\u043e \u0410\u04d8\u0410'),'kl':'*aa','km':u('\u1798\u17c9\u17b6\u1780\u17b6\u179c \u178f\u17c6\u1794\u1793\u17cb\u179a\u178a\u17d2\u178b\u1794\u17b6\u179b\u1796\u17b7\u179f\u17c1\u179f\u1785\u17b7\u1793'),'kn':u('\u0cae\u0c95\u0cbe\u0cb5\u0cc1 SAR \u0c9a\u0cc8\u0ca8\u0cbe'),'ko':u('\ub9c8\uce74\uc624(\uc911\uad6d \ud2b9\ubcc4\ud589\uc815\uad6c)'),'kr':'*aa','ks':u('\u0645\u064e\u06a9\u0627\u0648\u0648 \u0627\u06cc\u0633 \u0627\u06d2 \u0622\u0631 \u0686\u06cc\u0656\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u041c\u0430\u043a\u0430\u0443 \u041a\u044b\u0442\u0430\u0439 \u0410\u0410\u0410'),'la':'*aa','lb':'Spezialverwaltungszon Macau','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0ea1\u0eb2\u0e81\u0eb2\u0ea7 \u0ec0\u0e82\u0e94\u0e9b\u0ebb\u0e81\u0e84\u0ead\u0e87\u0e9e\u0eb4\u0ec0\u0eaa\u0e94 \u0e88\u0eb5\u0e99'),'lt':'Ypatingasis Administracinis Kinijos Regionas Makao','lu':'*aa','lv':u('\u0136\u012bnas \u012bpa\u0161\u0101s p\u0101rvaldes apgabals Makao'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u041c\u0430\u043a\u0430\u043e \u0421\u0410\u0420'),'ml':u('\u0d2e\u0d15\u0d4d\u0d15\u0d3e\u0d35\u0d41 (SAR) \u0d1a\u0d48\u0d28'),'mn':u('\u0411\u041d\u0425\u0410\u0423-\u044b\u043d \u0422\u0443\u0441\u0433\u0430\u0439 \u0437\u0430\u0445\u0438\u0440\u0433\u0430\u0430\u043d\u044b \u0431\u04af\u0441 \u041c\u0430\u043a\u0430\u043e'),'mo':'R.A.S. Macao a Chinei','mr':u('\u092e\u0915\u093e\u0913 \u090f\u0938\u090f\u0906\u0930 \u091a\u0940\u0928'),'ms':'*en','mt':u('ir-Re\u0121jun Amministrattiv Spe\u010bjali tal-Macao tar-Repubblika tal-Poplu ta\u010b-\u010aina'),'my':u('\u1019\u1000\u102c\u1021\u102d\u102f (\u1010\u101b\u102f\u1010\u103a\u1015\u103c\u100a\u103a)'),'na':'*aa','nb':'Macao S.A.R. Kina','nd':'*aa','ne':u('\u092e\u0915\u093e\u0909 \u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0938\u094d\u0935\u0936\u093e\u0938\u093f\u0924 \u0915\u094d\u0937\u0947\u0924\u094d\u0930'),'ng':'*aa','nl':'Macau SAR van China','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b3e\u0b15\u0b3e\u0b09 \u0b0f\u0b38\u0b0f\u0b06\u0b30\u0b4d\u200c \u0b1a\u0b3e\u0b07\u0b28\u0b3e'),'os':'*aa','pa':u('\u0a2e\u0a15\u0a3e\u0a09 \u0a10\u0a38\u0a0f\u0a06\u0a30 \u0a1a\u0a40\u0a28'),'pi':'*aa','pl':'SRA Makau (Chiny)','ps':u('\u0645\u06a9\u0627 \u0633\u0627\u0631 \u0686\u06cc\u0646'),'pt':'Macau, RAE da China','qu':'Macao RAE','rm':u('Regiun d\u2019administraziun speziala Macao, China'),'rn':'*aa','ro':'*mo','ru':u('\u041c\u0430\u043a\u0430\u043e (\u0421\u0410\u0420)'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0645\u06aa\u0627\u0626\u0648'),'se':u('Mak\u00e1o'),'sg':'*aa','si':u('\u0db8\u0d9a\u0dcf\u0dc0\u0dd4 \u0da0\u0dd3\u0db1 \u0dc0\u0dd2\u0dc1\u0dda\u0dc2 \u0db4\u0dbb\u0dd2\u0db4\u0dcf\u0dbd\u0db1 \u0d9a\u0dbd\u0dcf\u0db4\u0dba'),'sk':u('Macao \u2013 OAO \u010c\u00edny'),'sl':u('Posebno administrativno obmo\u010dje LR Kitajske Macao'),'sm':'*aa','sn':'*aa','so':'*aa','sq':'RPA i Makaos','sr':u('\u0421\u0410\u0420 \u041c\u0430\u043a\u0430\u043e (\u041a\u0438\u043d\u0430)'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*en','ta':u('\u0bae\u0b95\u0bbe\u0bb5\u0bcd \u0b8e\u0bb8\u0bcd\u0b8f\u0b86\u0bb0\u0bcd \u0b9a\u0bc0\u0ba9\u0bbe'),'te':u('\u0c2e\u0c15\u0c3e\u0c35\u0c4d \u0c0e\u0c38\u0c4d\u0c0f\u0c06\u0c30\u0c4d \u0c1a\u0c48\u0c28\u0c3e'),'tg':u('\u041c\u0430\u043a\u0430\u043e (\u041c\u041c\u041c)'),'th':u('\u0e40\u0e02\u0e15\u0e1b\u0e01\u0e04\u0e23\u0e2d\u0e07\u0e1e\u0e34\u0e40\u0e28\u0e29\u0e21\u0e32\u0e40\u0e01\u0e4a\u0e32\u0e41\u0e2b\u0e48\u0e07\u0e2a\u0e32\u0e18\u0e32\u0e23\u0e13\u0e23\u0e31\u0e10\u0e1b\u0e23\u0e30\u0e0a\u0e32\u0e0a\u0e19\u0e08\u0e35\u0e19'),'ti':u('\u121b\u12ab\u12ce'),'tk':u('Makau AAS Hyta\u00fd'),'tl':'*en','tn':'*aa','to':'Makau SAR Siaina','tr':u('\u00c7in Makao \u00d6\u0130B'),'ts':'*aa','tt':u('\u041c\u0430\u043a\u0430\u043e \u041c\u0430\u0445\u0441\u0443\u0441 \u0418\u0434\u0430\u0440\u04d9\u043b\u0435 \u0422\u04e9\u0431\u04d9\u0433\u0435'),'tw':'*aa','ty':'*aa','ug':u('\u0626\u0627\u06cb\u0645\u06d0\u0646 \u0626\u0627\u0644\u0627\u06be\u0649\u062f\u06d5 \u0645\u06d5\u0645\u06c7\u0631\u0649\u064a \u0631\u0627\u064a\u0648\u0646\u0649'),'uk':u('\u041c\u0430\u043a\u0430\u043e, \u041e.\u0410.\u0420 \u041a\u0438\u0442\u0430\u044e'),'ur':u('\u0645\u06a9\u0627\u0624 SAR \u0686\u06cc\u0646'),'uz':'Makao (Xitoy MMH)','ve':'*aa','vi':u('Macao, Trung Qu\u1ed1c'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u4e2d\u56fd\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a'),'zu':'i-Macau SAR China',},
  'MP': {'aa':'Northern Mariana Islands','ab':'*aa','ae':'*aa','af':'Noord-Mariane-eilande','ak':'*aa','am':u('\u12e8\u1230\u121c\u1293\u12ca \u121b\u122a\u12eb\u1293 \u12f0\u1234\u1276\u127d'),'an':'*aa','ar':u('\u062c\u0632\u0631 \u0645\u0627\u0631\u064a\u0627\u0646\u0627 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629'),'as':u('\u0989\u09a4\u09cd\u09a4\u09f0 \u09ae\u09be\u09f0\u09bf\u09af\u09bc\u09be\u09a8\u09be \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'av':'*aa','ay':'*aa','az':u('\u015eimali Marian adalar\u0131'),'ba':'*aa','be':u('\u041f\u0430\u045e\u043d\u043e\u0447\u043d\u044b\u044f \u041c\u0430\u0440\u044b\u044f\u043d\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b'),'bg':u('\u0421\u0435\u0432\u0435\u0440\u043d\u0438 \u041c\u0430\u0440\u0438\u0430\u043d\u0441\u043a\u0438 \u043e\u0441\u0442\u0440\u043e\u0432\u0438'),'bh':'*aa','bi':'*aa','bm':u('K\u025b\u0272\u025bka Mariyani Gun'),'bn':u('\u0989\u09a4\u09cd\u09a4\u09b0\u09be\u099e\u09cd\u099a\u09b2\u09c0\u09af\u09bc \u09ae\u09be\u09b0\u09bf\u09af\u09bc\u09be\u09a8\u09be \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'bo':'*aa','br':'Inizi Mariana an Norzh','bs':'Sjeverna Marijanska ostrva','ca':'Illes Mariannes del Nord','ce':u('\u041a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u041c\u0430\u0440\u0438\u0430\u043d\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Severn\u00ed Mariany'),'cu':'*aa','cv':'*aa','cy':'Ynysoedd Gogledd Mariana','da':'Nordmarianerne','de':u('N\u00f6rdliche Marianen'),'dv':'*aa','dz':u('\u0f56\u0fb1\u0f44\u0f0b\u0f55\u0fb1\u0f7c\u0f42\u0f66\u0f0b\u0f40\u0fb1\u0f72\u0f0b\u0f58\u0f0b\u0f62\u0f0b\u0f61\u0f0b\u0f53\u0f0b\u0f42\u0fb3\u0f72\u0f44\u0f0b\u0f5a\u0f7c\u0f58'),'ee':u('Dziehe Marina \u0192udomekpowo nutome'),'el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u0392\u03cc\u03c1\u03b5\u03b9\u03b5\u03c2 \u039c\u03b1\u03c1\u03b9\u03ac\u03bd\u03b5\u03c2'),'en':'*aa','eo':'Nord-Marianoj','es':'Islas Marianas del Norte','et':u('P\u00f5hja-Mariaanid'),'eu':'Ipar Mariana uharteak','fa':u('\u062c\u0632\u0627\u06cc\u0631 \u0645\u0627\u0631\u06cc\u0627\u0646\u0627\u06cc \u0634\u0645\u0627\u0644\u06cc'),'ff':u('Duu\u0257e Mariyaana Rewo'),'fi':'Pohjois-Mariaanit','fj':'*aa','fo':u('Nor\u00f0aru Mariuoyggjar'),'fr':u('\u00celes Mariannes du Nord'),'fy':'Noardlike Marianeneilannen','ga':u('na hOile\u00e1in Mh\u00e1irianacha Thuaidh'),'gd':'Na h-Eileanan Mairianach a Tuath','gl':'Illas Marianas do Norte','gn':'*aa','gu':u('\u0a89\u0aa4\u0acd\u0aa4\u0ab0\u0ac0 \u0aae\u0abe\u0ab0\u0abf\u0aaf\u0abe\u0aa8\u0abe \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8'),'gv':'*aa','ha':'Tsibiran Mariyana Na Arewa','he':u('\u05d0\u05d9\u05d9 \u05de\u05e8\u05d9\u05d0\u05e0\u05d4 \u05d4\u05e6\u05e4\u05d5\u05e0\u05d9\u05d9\u05dd'),'hi':u('\u0909\u0924\u094d\u0924\u0930\u0940 \u092e\u093e\u0930\u093f\u092f\u093e\u0928\u093e \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939'),'ho':'*aa','hr':'Sjevernomarijanski otoci','ht':'*aa','hu':u('\u00c9szaki Mariana-szigetek'),'hy':u('\u0540\u0575\u0578\u0582\u057d\u056b\u057d\u0561\u0575\u056b\u0576 \u0544\u0561\u0580\u056b\u0561\u0576\u0575\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'Kepulauan Mariana Utara','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Nor\u00f0ur-Mar\u00edanaeyjar'),'it':'Isole Marianne settentrionali','iu':'*aa','iw':'*he','ja':u('\u5317\u30de\u30ea\u30a2\u30ca\u8af8\u5cf6'),'ji':'*aa','jv':'*aa','ka':u('\u10e9\u10e0\u10d3\u10d8\u10da\u10dd\u10d4\u10d7 \u10db\u10d0\u10e0\u10d8\u10d0\u10dc\u10d0\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'Visiwa vya Mariana vya Kaskazini','kj':'*aa','kk':u('\u0421\u043e\u043b\u0442\u04af\u0441\u0442\u0456\u043a \u041c\u0430\u0440\u0438\u0430\u043d\u0430 \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'kl':'*aa','km':u('\u1780\u17c4\u17c7\u200b\u1798\u17c9\u17b6\u179a\u17b8\u178e\u17b6\u200b\u1781\u17b6\u1784\u200b\u1787\u17be\u1784'),'kn':u('\u0c89\u0ca4\u0ccd\u0ca4\u0cb0 \u0cae\u0cb0\u0cbf\u0caf\u0cbe\u0ca8\u0cbe \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3\u0cc1'),'ko':u('\ubd81\ub9c8\ub9ac\uc544\ub098\uc81c\ub3c4'),'kr':'*aa','ks':u('\u0634\u064f\u0645\u0672\u0644\u06cc \u0645\u0627\u0631\u0650\u06cc\u0627\u0646\u0627 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0422\u04af\u043d\u0434\u04af\u043a \u041c\u0430\u0440\u0438\u0430\u043d\u0430 \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'la':'*aa','lb':u('N\u00ebrdlech Marianen'),'lg':u('Bizinga bya Mariyana eby\u2019omumambuka'),'li':'*aa','ln':u('Bisanga bya Marian\u025b ya n\u0254\u0301rdi'),'lo':u('\u0eab\u0ea1\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ea1\u0eb2\u0ec1\u0e8a\u0ea7\u0e95\u0ead\u0e99\u0ec0\u0eab\u0e99\u0eb7\u0ead'),'lt':u('Marianos \u0160iaurin\u0117s Salos'),'lu':'Lutanda lua Mariane wa muulu','lv':u('Zieme\u013cu Marianas salas'),'mg':'Nosy Mariana Atsinanana','mh':'*aa','mi':'*aa','mk':u('\u0421\u0435\u0432\u0435\u0440\u043d\u0438 \u041c\u0430\u0440\u0438\u0458\u0430\u043d\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438'),'ml':u('\u0d09\u0d24\u0d4d\u0d24\u0d30 \u0d2e\u0d31\u0d3f\u0d2f\u0d3e\u0d28\u0d3e \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e'),'mn':u('\u0425\u043e\u0439\u0434 \u041c\u0430\u0440\u0438\u0430\u043d\u044b \u0430\u0440\u043b\u0443\u0443\u0434'),'mo':'Insulele Mariane de Nord','mr':u('\u0909\u0924\u094d\u0924\u0930\u0940 \u092e\u093e\u0930\u093f\u092f\u093e\u0928\u093e \u092c\u0947\u091f\u0947'),'ms':'*id','mt':u('\u0120\u017cejjer Mariana tat-Tramuntana'),'my':u('\u1010\u1031\u102c\u1004\u103a\u1015\u102d\u102f\u1004\u103a\u1038\u1019\u102c\u101b\u102e\u1021\u102c\u1014\u102c\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f'),'na':'*aa','nb':'Nord-Marianene','nd':'*aa','ne':u('\u0909\u0924\u094d\u0924\u0930\u0940 \u092e\u093e\u0930\u093f\u0906\u0928\u093e \u091f\u093e\u092a\u0941'),'ng':'*aa','nl':'Noordelijke Marianen','nn':'Nord-Marianane','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b2e\u0b3e\u0b30\u0b3f\u0b06\u0b28\u0b3e \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c'),'os':'*aa','pa':u('\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a2e\u0a3e\u0a30\u0a40\u0a06\u0a28\u0a3e \u0a1f\u0a3e\u0a2a\u0a42'),'pi':'*aa','pl':u('Mariany P\u00f3\u0142nocne'),'ps':u('\u0634\u0645\u0627\u0644\u064a \u0645\u0627\u0631\u06cc\u0627\u0646\u0627 \u067c\u0627\u067e\u0648'),'pt':'Ilhas Marianas do Norte','qu':'*es','rm':'Inslas Mariannas dal Nord','rn':'Amazinga ya Mariyana ryo mu majaruguru','ro':'*mo','ru':u('\u0421\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u041c\u0430\u0440\u0438\u0430\u043d\u0441\u043a\u0438\u0435 \u043e-\u0432\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u062a\u0631 \u0645\u0631\u064a\u0646\u0627 \u067b\u064a\u067d'),'se':u('Davvi-Mari\u00e1nat'),'sg':u('\u00c2z\u00fb\u00e2 M\u00e4r\u00ef\u00e2ni t\u00ee Banga'),'si':u('\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0db8\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dcf \u0daf\u0dd6\u0db4\u0dad\u0dca'),'sk':u('Severn\u00e9 Mari\u00e1ny'),'sl':'Severni Marianski otoki','sm':'*aa','sn':'Zvitsuwa zvekumaodzanyemba eMariana','so':'*aa','sq':u('Ishujt e Marian\u00ebs Veriore'),'sr':u('\u0421\u0435\u0432\u0435\u0440\u043d\u0430 \u041c\u0430\u0440\u0438\u0458\u0430\u043d\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Nordmarianerna','sw':'*ki','ta':u('\u0bb5\u0b9f\u0b95\u0bcd\u0b95\u0bc1 \u0bae\u0bb0\u0bbf\u0baf\u0bbe\u0ba9\u0bbe \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd'),'te':u('\u0c09\u0c24\u0c4d\u0c24\u0c30 \u0c2e\u0c30\u0c3f\u0c2f\u0c3e\u0c28\u0c3e \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41'),'tg':u('\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u041c\u0430\u0440\u0438\u0430\u043d\u0430\u0438 \u0428\u0438\u043c\u043e\u043b\u04e3'),'th':u('\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e19\u0e2d\u0e23\u0e4c\u0e40\u0e17\u0e34\u0e23\u0e4c\u0e19\u0e21\u0e32\u0e40\u0e23\u0e35\u0e22\u0e19\u0e32'),'ti':u('\u12f0\u1234\u1273\u1275 \u1230\u121c\u1293\u12ca \u121b\u122a\u12eb\u1293'),'tk':'Demirgazyk Mariana adalary','tl':'*aa','tn':'*aa','to':u('\u02bbOtumotu Maliana tokelau'),'tr':u('Kuzey Mariana Adalar\u0131'),'ts':'*aa','tt':u('\u0422\u04e9\u043d\u044c\u044f\u043a \u041c\u0430\u0440\u0438\u0430\u043d\u0430 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0634\u0649\u0645\u0627\u0644\u0649\u064a \u0645\u0627\u0631\u0649\u064a\u0627\u0646\u0627 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649'),'uk':u('\u041f\u0456\u0432\u043d\u0456\u0447\u043d\u0456 \u041c\u0430\u0440\u0456\u0430\u043d\u0441\u044c\u043a\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438'),'ur':u('\u0634\u0645\u0627\u0644\u06cc \u0645\u0627\u0631\u06cc\u0627\u0646\u0627 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632'),'uz':'Shimoliy Mariana orollari','ve':'*aa','vi':u('Qu\u1ea7n \u0111\u1ea3o B\u1eafc Mariana'),'vo':'*aa','wa':'*aa','wo':'Duni Mariyaan Noor','xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Etikun Guusu Mariana'),'za':'*aa','zh':u('\u5317\u9a6c\u91cc\u4e9a\u7eb3\u7fa4\u5c9b'),'zu':'i-Northern Mariana Islands',},
  'MQ': {'aa':'Martinique','ab':'*aa','ae':'*aa','af':'*aa','ak':'Matinik','am':u('\u121b\u122d\u1272\u1292\u12ad'),'an':'*aa','ar':u('\u062c\u0632\u0631 \u0627\u0644\u0645\u0627\u0631\u062a\u064a\u0646\u064a\u0643'),'as':u('\u09ae\u09be\u09f0\u09cd\u099f\u09bf\u09a8\u09bf\u0995'),'av':'*aa','ay':'*aa','az':'Martinik','ba':'*aa','be':u('\u041c\u0430\u0440\u0446\u0456\u043d\u0456\u043a\u0430'),'bg':u('\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a\u0430'),'bh':'*aa','bi':'*aa','bm':'Maritiniki','bn':u('\u09ae\u09be\u09b0\u09cd\u099f\u09bf\u09a8\u09bf\u0995'),'bo':'*aa','br':'*az','bs':'*az','ca':'Martinica','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*az','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f58\u0f71\u0f62\u0f0b\u0f4a\u0f72\u0f0b\u0f53\u0f72\u0f40'),'ee':'Martiniki nutome','el':u('\u039c\u03b1\u03c1\u03c4\u03b9\u03bd\u03af\u03ba\u03b1'),'en':'*aa','eo':'Martiniko','es':'*ca','et':'*aa','eu':'Martinika','fa':u('\u0645\u0627\u0631\u062a\u06cc\u0646\u06cc\u06a9'),'ff':'*az','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'Mairtinic','gl':'*ca','gn':'*aa','gu':u('\u0aae\u0abe\u0ab0\u0acd\u0a9f\u0ac0\u0aa8\u0ac0\u0a95'),'gv':'*aa','ha':'*az','he':u('\u05de\u05e8\u05d8\u05d9\u05e0\u05d9\u05e7'),'hi':u('\u092e\u093e\u0930\u094d\u091f\u0940\u0928\u093f\u0915'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u0544\u0561\u0580\u057f\u056b\u0576\u056b\u056f\u0561'),'hz':'*aa','ia':'*aa','id':'*az','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*az','io':'*aa','is':u('Martin\u00edk'),'it':'*ca','iu':'*aa','iw':'*he','ja':u('\u30de\u30eb\u30c6\u30a3\u30cb\u30fc\u30af'),'ji':u('\u05de\u05d0\u05b7\u05e8\u05d8\u05d9\u05e0\u05d9\u05e7'),'jv':'*aa','ka':u('\u10db\u10d0\u10e0\u10e2\u10d8\u10dc\u10d8\u10d9\u10d0'),'kg':'*aa','ki':'Martiniki','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1798\u17c9\u17b6\u1791\u17b8\u1793\u17b8\u1780'),'kn':u('\u0cae\u0cbe\u0cb0\u0ccd\u0c9f\u0cbf\u0ca8\u0cbf\u0c95\u0ccd'),'ko':u('\ub9c8\ub974\ud2f0\ub2c8\ud06c'),'kr':'*aa','ks':u('\u0645\u0627\u0631\u0679\u0650\u0646\u0650\u06a9'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'Maritiniiki','li':'*aa','ln':'*ki','lo':u('\u0ea1\u0eb2\u0e95\u0eb4\u0e99\u0eb5\u0e81'),'lt':'*eu','lu':'*ki','lv':'*eu','mg':'*eu','mh':'*aa','mi':'*aa','mk':u('\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a'),'ml':u('\u0d2e\u0d3e\u0d7c\u0d1f\u0d4d\u0d1f\u0d3f\u0d28\u0d3f\u0d15\u0d4d\u0d15\u0d4d'),'mn':'*mk','mo':'*ca','mr':u('\u092e\u093e\u0930\u094d\u091f\u093f\u0928\u093f\u0915'),'ms':'*aa','mt':'*aa','my':u('\u1019\u102c\u1010\u102e\u1014\u102d\u1001\u103a'),'na':'*aa','nb':'*aa','nd':'*aa','ne':'*mr','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b3e\u0b30\u0b4d\u0b1f\u0b3f\u0b28\u0b3f\u0b15\u0b4d\u0b5f\u0b41'),'os':'*aa','pa':u('\u0a2e\u0a3e\u0a30\u0a1f\u0a40\u0a28\u0a3f\u0a15'),'pi':'*aa','pl':'Martynika','ps':u('\u0645\u0627\u0631\u067c\u06cc\u0646\u06cc\u06a9'),'pt':'*ca','qu':'*aa','rm':'*aa','rn':'*bm','ro':'*ca','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0645\u0627\u0631\u062a\u064a\u0646\u06aa'),'se':'*aa','sg':u('M\u00e4rt\u00efn\u00eeki'),'si':u('\u0db8\u0dbb\u0dca\u0da7\u0dd2\u0db1\u0dd2\u0d9a\u0dca'),'sk':'*az','sl':'*az','sm':'*aa','sn':'*aa','so':'*aa','sq':u('Martinik\u00eb'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0bae\u0bbe\u0bb0\u0bcd\u0b9f\u0bbf\u0ba9\u0bbf\u0b95\u0bcd'),'te':u('\u0c2e\u0c3e\u0c30\u0c4d\u0c1f\u0c3f\u0c28\u0c40\u0c15\u0c4d'),'tg':'*bg','th':u('\u0e21\u0e32\u0e23\u0e4c\u0e15\u0e34\u0e19\u0e35\u0e01'),'ti':'*am','tk':'*eu','tl':'*aa','tn':'*aa','to':u('M\u0101tiniki'),'tr':'*az','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0645\u0627\u0631\u062a\u0649\u0646\u0649\u0643\u0627'),'uk':u('\u041c\u0430\u0440\u0442\u0456\u043d\u0456\u043a\u0430'),'ur':u('\u0645\u0627\u0631\u0679\u06cc\u0646\u06a9'),'uz':'*eu','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*az','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Matinikuwi'),'za':'*aa','zh':u('\u9a6c\u63d0\u5c3c\u514b'),'zu':'i-Martinique',},
  'MR': {'aa':'Mauritania','ab':'*aa','ae':'*aa','af':u('Mauritani\u00eb'),'ak':u('M\u0254retenia'),'am':u('\u121e\u122a\u1274\u1292\u12eb'),'an':'*aa','ar':u('\u0645\u0648\u0631\u064a\u062a\u0627\u0646\u064a\u0627'),'as':u('\u09ae\u09be\u0989\u09f0\u09bf\u099f\u09be\u09a8\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Mavritaniya','ba':'*aa','be':u('\u041c\u0430\u045e\u0440\u044b\u0442\u0430\u043d\u0456\u044f'),'bg':u('\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':u('M\u0254ritani'),'bn':u('\u09ae\u09b0\u09bf\u09a4\u09be\u09a8\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'Maouritania','bs':'Mauritanija','ca':u('Maurit\u00e0nia'),'ce':u('\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Maurit\u00e1nie'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'Mauretanien','de':'*da','dv':'*aa','dz':u('\u0f58\u0f7c\u0f0b\u0f62\u0f72\u0f0b\u0f4a\u0f7a\u0f0b\u0f53\u0f72\u0f0b\u0f61'),'ee':'Mauritania nutome','el':u('\u039c\u03b1\u03c5\u03c1\u03b9\u03c4\u03b1\u03bd\u03af\u03b1'),'en':'*aa','eo':u('Ma\u016dritanujo'),'es':'*aa','et':'Mauritaania','eu':'*aa','fa':u('\u0645\u0648\u0631\u06cc\u062a\u0627\u0646\u06cc'),'ff':'Muritani','fi':'*aa','fj':'*aa','fo':u('M\u00f3ritania'),'fr':'Mauritanie','fy':'*af','ga':u('an Mh\u00e1rat\u00e1in'),'gd':u('Morat\u00e0inea'),'gl':'*aa','gn':'*aa','gu':u('\u0aae\u0acc\u0ab0\u0abf\u0a9f\u0abe\u0aa8\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Moritaniya','he':u('\u05de\u05d0\u05d5\u05e8\u05d9\u05d8\u05e0\u05d9\u05d4'),'hi':u('\u092e\u0949\u0930\u093f\u091f\u093e\u0928\u093f\u092f\u093e'),'ho':'*aa','hr':'Mauretanija','ht':'*aa','hu':u('Maurit\u00e1nia'),'hy':u('\u0544\u0561\u057e\u0580\u056b\u057f\u0561\u0576\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('M\u00e1ritan\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30e2\u30fc\u30ea\u30bf\u30cb\u30a2'),'ji':u('\u05de\u05d0\u05b7\u05e8\u05d9\u05d8\u05d0\u05b7\u05e0\u05d9\u05e2'),'jv':'*aa','ka':u('\u10db\u10d0\u10d5\u10e0\u10d8\u10e2\u10d0\u10dc\u10d8\u10d0'),'kg':'*aa','ki':'Moritania','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1798\u17c9\u17bc\u179a\u17b8\u178f\u17b6\u1793\u17b8'),'kn':u('\u0cae\u0cbe\u0cb0\u0cbf\u0c9f\u0cc7\u0ca8\u0cbf\u0caf\u0cbe'),'ko':u('\ubaa8\ub9ac\ud0c0\ub2c8'),'kr':'*aa','ks':u('\u0645\u0627\u0631\u0655\u0679\u0627\u0646\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*da','lg':'Mawulitenya','li':'*aa','ln':'Moritani','lo':u('\u0ea1\u0ebb\u0ea7\u0ea3\u0eb4\u0ec0\u0e97\u0ec0\u0e99\u0e8d'),'lt':'*bs','lu':'*ln','lv':u('Maurit\u0101nija'),'mg':'Maoritania','mh':'*aa','mi':'*aa','mk':u('\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438\u0458\u0430'),'ml':u('\u0d2e\u0d57\u0d31\u0d3f\u0d31\u0d4d\u0d31\u0d3e\u0d28\u0d3f\u0d2f'),'mn':'*ce','mo':'*aa','mr':'*hi','ms':'*aa','mt':'il-Mauritania','my':u('\u1019\u1031\u102c\u103a\u101b\u102e\u1010\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u092e\u093e\u0909\u0930\u093f\u091f\u093e\u0928\u093f\u092f\u093e'),'ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b4c\u0b30\u0b3f\u0b1f\u0b3e\u0b28\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a2e\u0a4b\u0a30\u0a3f\u0a1f\u0a3e\u0a28\u0a40\u0a06'),'pi':'*aa','pl':'Mauretania','ps':u('\u0645\u0648\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627'),'pt':u('Maurit\u00e2nia'),'qu':'*aa','rm':'*pl','rn':'*ha','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*ar','se':u('Mauret\u00e1nia'),'sg':u('Moritan\u00efi'),'si':u('\u0db8\u0ddc\u0dbb\u0dd2\u0da7\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*hu','sl':'Mavretanija','sm':'*aa','sn':'*aa','so':'Muritaaniya','sq':'Mauritani','sr':u('\u041c\u0430\u0443\u0440\u0438\u0442\u0430\u043d\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*ki','ta':u('\u0bae\u0bcc\u0bb0\u0bbf\u0b9f\u0bbe\u0ba9\u0bbf\u0baf\u0bbe'),'te':u('\u0c2e\u0c4c\u0c30\u0c3f\u0c1f\u0c47\u0c28\u0c3f\u0c2f\u0c3e'),'tg':'*bg','th':u('\u0e21\u0e2d\u0e23\u0e34\u0e40\u0e15\u0e40\u0e19\u0e35\u0e22'),'ti':'*am','tk':u('Mawritani\u00fda'),'tl':'*aa','tn':'*aa','to':'Maulitenia','tr':'Moritanya','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0645\u0627\u06cb\u0631\u0649\u062a\u0627\u0646\u0649\u064a\u06d5'),'uk':u('\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0456\u044f'),'ur':u('\u0645\u0648\u0631\u06cc\u0637\u0627\u0646\u06cc\u06c1'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Mooritani','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Maritania'),'za':'*aa','zh':u('\u6bdb\u91cc\u5854\u5c3c\u4e9a'),'zu':'i-Mauritania',},
  'MS': {'aa':'Montserrat','ab':'*aa','ae':'*aa','af':'*aa','ak':'Mantserat','am':u('\u121e\u1295\u1275\u1234\u122b\u1275'),'an':'*aa','ar':u('\u0645\u0648\u0646\u062a\u0633\u0631\u0627\u062a'),'as':u('\u09ae\u2019\u09a3\u09cd\u099f\u099b\u09c7\u09f0\u09be\u099f'),'av':'*aa','ay':'*aa','az':'Monserat','ba':'*aa','be':u('\u041c\u0430\u043d\u0442\u0441\u0435\u0440\u0430\u0442'),'bg':u('\u041c\u043e\u043d\u0442\u0441\u0435\u0440\u0430\u0442'),'bh':'*aa','bi':'*aa','bm':u('Mo\u014bsera'),'bn':u('\u09ae\u09a8\u09cd\u099f\u09b8\u09c7\u09b0\u09be\u099f'),'bo':'*aa','br':'*aa','bs':'*az','ca':'*aa','ce':u('\u041c\u043e\u043d\u0442\u0441\u0435\u0440\u0440\u0430\u0442'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f58\u0f7c\u0f53\u0f0b\u0f66\u0f0b\u0f62\u0f4a'),'ee':'Montserrat nutome','el':u('\u039c\u03bf\u03bd\u03c3\u03b5\u03c1\u03ac\u03c4'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0645\u0648\u0646\u062a\u200c\u0633\u0631\u0627\u062a'),'ff':'Monseraat','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'Montsarat','gd':'*ga','gl':'*aa','gn':'*aa','gu':u('\u0aae\u0acb\u0a82\u0a9f\u0ab8\u0ac7\u0ab0\u0abe\u0aa4'),'gv':'*aa','ha':'Manserati','he':u('\u05de\u05d5\u05e0\u05e1\u05e8\u05d0\u05d8'),'hi':u('\u092e\u094b\u0902\u091f\u0938\u0947\u0930\u093e\u0924'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u0544\u0578\u0576\u057d\u0565\u057c\u0561\u057f'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30e2\u30f3\u30c8\u30bb\u30e9\u30c8'),'ji':u('\u05de\u05d0\u05e0\u05d8\u05e1\u05e2\u05e8\u05d0\u05b7\u05d8'),'jv':'*aa','ka':u('\u10db\u10dd\u10dc\u10e1\u10d4\u10e0\u10d0\u10e2\u10d8'),'kg':'*aa','ki':'Montserrati','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u1798\u17c9\u17bb\u1784\u179f\u17ca\u17c2\u179a\u17c9\u17b6'),'kn':u('\u0cae\u0cbe\u0c82\u0c9f\u0ccd\u200c\u0cb8\u0cc6\u0cb0\u0c9f\u0ccd'),'ko':u('\ubaac\ud2b8\uc138\ub77c\ud2b8'),'kr':'*aa','ks':u('\u0645\u0627\u0646\u065b\u0679\u0633\u06cc\u0631\u0627\u0679'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*aa','lg':'Monteseraati','li':'*aa','ln':u('M\u0254sera'),'lo':u('\u0ea1\u0ead\u0e99\u0ec0\u0e8a\u0eb5\u0ea3\u0eb2\u0e94'),'lt':'Montseratas','lu':'Musera','lv':'Montserrata','mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u041c\u043e\u043d\u0441\u0435\u0440\u0430\u0442'),'ml':u('\u0d2e\u0d4a\u0d23\u0d4d\u0d1f\u0d46\u0d38\u0d30\u0d24\u0d4d\u0d24\u0d4d'),'mn':'*ce','mo':'*aa','mr':u('\u092e\u0949\u0928\u094d\u091f\u094d\u0938\u0947\u0930\u093e\u091f'),'ms':'*aa','mt':'*aa','my':u('\u1019\u1031\u102c\u1004\u1037\u103a\u1005\u1032\u101b\u1000\u103a'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u092e\u094b\u0928\u094d\u091f\u0938\u0947\u0930\u094d\u0930\u093e\u091f'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b23\u0b4d\u0b1f\u0b47\u0b38\u0b47\u0b30\u0b3e\u0b1f\u0b4d'),'os':'*aa','pa':u('\u0a2e\u0a4b\u0a02\u0a1f\u0a38\u0a47\u0a30\u0a3e\u0a24'),'pi':'*aa','pl':'*aa','ps':u('\u0645\u0627\u0646\u067c\u06cc\u0633\u06cc\u0631\u062a'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'Monteserati','ro':'*aa','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0645\u0648\u0646\u067d\u0633\u0631\u0627\u067d'),'se':'*aa','sg':u('Monser\u00e2te'),'si':u('\u0db8\u0ddc\u0db1\u0dca\u0dc3\u0dd9\u0dbb\u0dcf\u0da7\u0dca'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'Montserat','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0bae\u0bbe\u0ba3\u0bcd\u0b9f\u0bcd\u0b9a\u0bc6\u0bb0\u0bbe\u0b9f\u0bcd'),'te':u('\u0c2e\u0c3e\u0c02\u0c1f\u0c4d\u0c38\u0c46\u0c30\u0c3e\u0c1f\u0c4d'),'tg':'*ce','th':u('\u0e21\u0e2d\u0e19\u0e15\u0e4c\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e23\u0e31\u0e15'),'ti':'*am','tk':'Monserrat','tl':'*aa','tn':'*aa','to':u('Mo\u02bbungaselati'),'tr':'*aa','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u0645\u0648\u0646\u062a\u0633\u06d0\u0631\u0631\u0627\u062a'),'uk':'*ce','ur':u('\u0645\u0648\u0646\u0679\u0633\u06cc\u0631\u0627\u0679'),'uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Mooseraa','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Motserati'),'za':'*aa','zh':u('\u8499\u7279\u585e\u62c9\u7279'),'zu':'i-Montserrat',},
  'MT': {'aa':'Malta','ab':'*aa','ae':'*aa','af':'*aa','ak':u('M\u0254lta'),'am':u('\u121b\u120d\u1273'),'an':'*aa','ar':u('\u0645\u0627\u0644\u0637\u0627'),'as':u('\u09ae\u09be\u09b2\u09cd\u099f\u09be'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u041c\u0430\u043b\u044c\u0442\u0430'),'bg':u('\u041c\u0430\u043b\u0442\u0430'),'bh':'*aa','bi':'*aa','bm':'Malti','bn':'*as','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f58\u0f71\u0f63\u0f0b\u0f4a'),'ee':'Malta nutome','el':u('\u039c\u03ac\u03bb\u03c4\u03b1'),'en':'*aa','eo':'Malto','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0645\u0627\u0644\u062a'),'ff':'Malte','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*ff','fy':'*aa','ga':u('M\u00e1lta'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':u('\u0aae\u0abe\u0ab2\u0acd\u0a9f\u0abe'),'gv':'*aa','ha':'*aa','he':u('\u05de\u05dc\u05d8\u05d4'),'hi':u('\u092e\u093e\u0932\u094d\u091f\u093e'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*ga','hy':u('\u0544\u0561\u056c\u0569\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30de\u30eb\u30bf'),'ji':u('\u05de\u05d0\u05b7\u05dc\u05d8\u05d0\u05b7'),'jv':'*aa','ka':u('\u10db\u10d0\u10da\u10e2\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u1798\u17c9\u17b6\u179b\u17cb\u178f\u17cd'),'kn':u('\u0cae\u0cbe\u0cb2\u0ccd\u0c9f\u0cbe'),'ko':u('\ubab0\ud0c0'),'kr':'*aa','ks':u('\u0645\u0627\u0644\u0679\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*aa','lg':'Malita','li':'*aa','ln':u('Malit\u025b'),'lo':u('\u0ea1\u0ead\u0e99\u0e97\u0eb2'),'lt':'*aa','lu':'Malite','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d2e\u0d3e\u0d7e\u0d1f\u0d4d\u0d1f'),'mn':'*be','mo':'*aa','mr':'*hi','ms':'*aa','mt':'*aa','my':u('\u1019\u1031\u102c\u101c\u103a\u1010\u102c'),'na':'*aa','nb':'*aa','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b3e\u0b32\u0b4d\u0b1f\u0b3e'),'os':'*aa','pa':u('\u0a2e\u0a3e\u0a32\u0a1f\u0a3e'),'pi':'*aa','pl':'*aa','ps':u('\u0645\u0627\u0644\u062a\u0627'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'*lg','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0645\u0627\u0644\u067d\u0627'),'se':'*ga','sg':u('M\u00e2lta'),'si':u('\u0db8\u0ddd\u0dbd\u0dca\u0da7\u0dcf\u0dc0'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'Maalda','sq':u('Malt\u00eb'),'sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0bae\u0bbe\u0bb2\u0bcd\u0b9f\u0bbe'),'te':u('\u0c2e\u0c3e\u0c32\u0c4d\u0c1f\u0c3e'),'tg':'*bg','th':u('\u0e21\u0e2d\u0e25\u0e15\u0e32'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':'*lg','tr':'*aa','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':'*ps','uk':'*be','ur':'*ks','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Malt','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Malata'),'za':'*aa','zh':u('\u9a6c\u8033\u4ed6'),'zu':'i-Malta',},
  'MU': {'aa':'Mauritius','ab':'*aa','ae':'*aa','af':'*aa','ak':u('M\u0254rehye\u0254s'),'am':u('\u121e\u122a\u1238\u1235'),'an':'*aa','ar':u('\u0645\u0648\u0631\u064a\u0634\u064a\u0648\u0633'),'as':u('\u09ae\u09f0\u09bf\u099b\u09be\u099b'),'av':'*aa','ay':'*aa','az':'Mavriki','ba':'*aa','be':u('\u041c\u0430\u045e\u0440\u044b\u043a\u0456\u0439'),'bg':u('\u041c\u0430\u0432\u0440\u0438\u0446\u0438\u0439'),'bh':'*aa','bi':'*aa','bm':'Morisi','bn':u('\u09ae\u09b0\u09bf\u09b6\u09be\u09b8'),'bo':'*aa','br':'Moris','bs':'Mauricijus','ca':'Maurici','ce':u('\u041c\u0430\u0432\u0440\u0438\u043a\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Mauricius','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f58\u0f7c\u0f0b\u0f62\u0f72\u0f0b\u0f64\u0f71\u0f66'),'ee':u('mauritiusduk\u0254'),'el':u('\u039c\u03b1\u03c5\u03c1\u03af\u03ba\u03b9\u03bf\u03c2'),'en':'*aa','eo':u('Ma\u016dricio'),'es':'Mauricio','et':'*aa','eu':'Maurizio','fa':u('\u0645\u0648\u0631\u06cc\u0633'),'ff':'Moriis','fi':'*aa','fj':'*aa','fo':u('M\u00f3ritius'),'fr':'Maurice','fy':'*aa','ga':u('Oile\u00e1n Mhuir\u00eds'),'gd':'Na h-Eileanan Mhoiriseas','gl':'*es','gn':'*aa','gu':u('\u0aae\u0acb\u0ab0\u0abf\u0ab6\u0abf\u0aaf\u0ab8'),'gv':'*aa','ha':'Moritus','he':u('\u05de\u05d0\u05d5\u05e8\u05d9\u05e6\u05d9\u05d5\u05e1'),'hi':u('\u092e\u0949\u0930\u0940\u0936\u0938'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u0544\u0561\u057e\u0580\u056b\u056f\u056b\u0578\u057d'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('M\u00e1rit\u00edus'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30e2\u30fc\u30ea\u30b7\u30e3\u30b9'),'ji':u('\u05de\u05d0\u05e8\u05d9\u05e6\u05d9\u05d5\u05e1'),'jv':'*aa','ka':u('\u10db\u10d0\u10d5\u10e0\u10d8\u10d9\u10d8'),'kg':'*aa','ki':'*bm','kj':'*aa','kk':u('\u041c\u0430\u0432\u0440\u0438\u043a\u0438\u0439'),'kl':'*aa','km':u('\u1798\u17c9\u17bc\u179a\u17b8\u179f'),'kn':u('\u0cae\u0cbe\u0cb0\u0cbf\u0cb7\u0cb8\u0ccd'),'ko':u('\ubaa8\ub9ac\uc154\uc2a4'),'kr':'*aa','ks':u('\u0645\u0648\u0631\u0650\u0634\u064e\u0633'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*aa','lg':'Mawulisyasi','li':'*aa','ln':u('Moris\u025b'),'lo':u('\u0ea1\u0ebb\u0ea7\u0ea3\u0eb4\u0e8a\u0ebd\u0eaa'),'lt':'*bs','lu':'Morise','lv':u('Maur\u012bcija'),'mg':'Maorisy','mh':'*aa','mi':'*aa','mk':u('\u041c\u0430\u0432\u0440\u0438\u0446\u0438\u0443\u0441'),'ml':u('\u0d2e\u0d57\u0d31\u0d40\u0d37\u0d4d\u0d2f\u0d38\u0d4d'),'mn':'*ce','mo':'*aa','mr':u('\u092e\u0949\u0930\u093f\u0936\u0938'),'ms':'*aa','mt':'*aa','my':u('\u1019\u1031\u102c\u101b\u1005\u103a\u101b\u103e'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u092e\u093e\u0909\u0930\u093f\u091f\u0938'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b30\u0b3f\u0b38\u0b38'),'os':'*aa','pa':u('\u0a2e\u0a4c\u0a30\u0a40\u0a38\u0a3c\u0a38'),'pi':'*aa','pl':'*aa','ps':u('\u0645\u0648\u0631\u06cc\u0634\u06cc\u0633'),'pt':u('Maur\u00edcio'),'qu':'*es','rm':'*aa','rn':'Izinga rya Morise','ro':'*aa','ru':'*kk','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0645\u0648\u0631\u064a\u0634\u0633'),'se':'*aa','sg':u('M\u00f6r\u00eesi'),'si':u('\u0db8\u0dd4\u0dbb\u0dd4\u0dc3\u0dd2\u0dba'),'sk':u('Maur\u00edcius'),'sl':'*aa','sm':'*aa','sn':'*aa','so':'Murishiyoos','sq':'*aa','sr':u('\u041c\u0430\u0443\u0440\u0438\u0446\u0438\u0458\u0443\u0441'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*bm','ta':u('\u0bae\u0bca\u0bb0\u0bbf\u0b9a\u0bbf\u0baf\u0bb8\u0bcd'),'te':u('\u0c2e\u0c3e\u0c30\u0c3f\u0c37\u0c38\u0c4d'),'tg':'*kk','th':u('\u0e21\u0e2d\u0e23\u0e34\u0e40\u0e0a\u0e35\u0e22\u0e2a'),'ti':u('\u121b\u1229\u1238\u1235'),'tk':u('Mawriki\u00fd'),'tl':'*aa','tn':'*aa','to':'Maulitiusi','tr':'*aa','ts':'*aa','tt':'*kk','tw':'*aa','ty':'*aa','ug':u('\u0645\u0627\u06cb\u0631\u0649\u062a\u0649\u064a\u06c7\u0633'),'uk':u('\u041c\u0430\u0432\u0440\u0456\u043a\u0456\u0439'),'ur':u('\u0645\u0627\u0631\u06cc\u0634\u0633'),'uz':'Mavrikiy','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*ff','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Maritiusi'),'za':'*aa','zh':u('\u6bdb\u91cc\u6c42\u65af'),'zu':'i-Mauritius',},
  'MV': {'aa':'Maldives','ab':'*aa','ae':'*aa','af':'Maledive','ak':'*aa','am':u('\u121b\u120d\u12f2\u126d\u1235'),'an':'*aa','ar':u('\u062c\u0632\u0631 \u0627\u0644\u0645\u0627\u0644\u062f\u064a\u0641'),'as':u('\u09ae\u09be\u09b2\u09a6\u09cd\u09ac\u09c0\u09aa'),'av':'*aa','ay':'*aa','az':u('Maldiv adalar\u0131'),'ba':'*aa','be':u('\u041c\u0430\u043b\u044c\u0434\u044b\u0432\u044b'),'bg':u('\u041c\u0430\u043b\u0434\u0438\u0432\u0438'),'bh':'*aa','bi':'*aa','bm':'Maldivi','bn':'*as','bo':'*aa','br':'Maldivez','bs':'*bm','ca':'*aa','ce':u('\u041c\u0430\u043b\u044c\u0434\u0438\u0432\u0430\u0448'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Maledivy','cu':'*aa','cv':'*aa','cy':'Y Maldives','da':'Maldiverne','de':'Malediven','dv':'*aa','dz':u('\u0f58\u0f71\u0f63\u0f0b\u0f51\u0f72\u0f56\u0f66'),'ee':u('maldivesduk\u0254'),'el':u('\u039c\u03b1\u03bb\u03b4\u03af\u03b2\u03b5\u03c2'),'en':'*aa','eo':'Maldivoj','es':'Maldivas','et':'Maldiivid','eu':'Maldivak','fa':u('\u0645\u0627\u0644\u062f\u06cc\u0648'),'ff':'Maldiiwe','fi':'Malediivit','fj':'*aa','fo':'Maldivoyggjar','fr':'*aa','fy':'Maldiven','ga':u('Oile\u00e1in Mhaild\u00edve'),'gd':'Na h-Eileanan Mhaladaibh','gl':'*es','gn':'*aa','gu':u('\u0aae\u0abe\u0ab2\u0aa6\u0abf\u0ab5\u0acd\u0ab8'),'gv':'*aa','ha':'Maldibi','he':u('\u05d4\u05d0\u05d9\u05d9\u05dd \u05d4\u05de\u05dc\u05d3\u05d9\u05d1\u05d9\u05d9\u05dd'),'hi':u('\u092e\u093e\u0932\u0926\u0940\u0935'),'ho':'*aa','hr':'*bm','ht':'*aa','hu':u('Mald\u00edv-szigetek'),'hy':u('\u0544\u0561\u056c\u0564\u056b\u057e\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'Maladewa','ie':'*aa','ig':'Maldivesa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Mald\u00edveyjar'),'it':'Maldive','iu':'*aa','iw':'*he','ja':u('\u30e2\u30eb\u30c7\u30a3\u30d6'),'ji':u('\u05de\u05d0\u05b7\u05dc\u05d3\u05d9\u05d5\u05d5\u05df'),'jv':'*aa','ka':u('\u10db\u10d0\u10da\u10d3\u10d8\u10d5\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'Modivu','kj':'*aa','kk':u('\u041c\u0430\u043b\u044c\u0434\u0438\u0432 \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'kl':'*aa','km':u('\u1798\u17c9\u17b6\u179b\u17cb\u178c\u17b8\u179c'),'kn':u('\u0cae\u0cbe\u0cb2\u0ccd\u0ca1\u0cc0\u0cb5\u0ccd\u0cb8\u0ccd'),'ko':u('\ubab0\ub514\ube0c'),'kr':'*aa','ks':u('\u0645\u0627\u0644\u062f\u06cc\u0656\u0648'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u041c\u0430\u043b\u044c\u0434\u0438\u0432'),'la':'*aa','lb':'*fy','lg':u('Bizinga by\u2019eMalidive'),'li':'*aa','ln':u('Mad\u00edv\u025b'),'lo':u('\u0ea1\u0eb1\u0e99\u0e94\u0eb4\u0e9f'),'lt':'Maldyvai','lu':'Madive','lv':u('Mald\u012bvija'),'mg':'Maldiva','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d2e\u0d3e\u0d32\u0d3f\u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d4d'),'mn':'*ky','mo':'*it','mr':'*hi','ms':'*aa','mt':'il-Maldivi','my':u('\u1019\u1031\u102c\u103a\u101c\u103a\u1012\u102d\u102f\u1000\u103a'),'na':'*aa','nb':'Maldivene','nd':'*aa','ne':u('\u092e\u093e\u0932\u094d\u0926\u093f\u092d\u094d\u0938'),'ng':'*aa','nl':'*fy','nn':'Maldivane','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b3e\u0b32\u0b26\u0b3f\u0b2d\u0b38\u0b4d\u200c'),'os':'*aa','pa':u('\u0a2e\u0a3e\u0a32\u0a26\u0a40\u0a35'),'pi':'*aa','pl':'Malediwy','ps':u('\u0645\u0627\u0644\u062f\u064a\u067e'),'pt':'*es','qu':'*es','rm':'*es','rn':'Moludave','ro':'*it','ru':u('\u041c\u0430\u043b\u044c\u0434\u0438\u0432\u044b'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':'*ps','se':'Malediivvat','sg':u('Mald\u00eeva'),'si':u('\u0db8\u0dcf\u0dbd \u0daf\u0dd2\u0dc0\u0dba\u0dd2\u0db1'),'sk':'Maldivy','sl':'*bm','sm':'*aa','sn':'*aa','so':'Maaldiqeen','sq':'*it','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'Maldiverna','sw':'*aa','ta':u('\u0bae\u0bbe\u0bb2\u0ba4\u0bcd\u0ba4\u0bc0\u0bb5\u0bc1'),'te':u('\u0c2e\u0c3e\u0c32\u0c4d\u0c26\u0c40\u0c35\u0c41\u0c32\u0c41'),'tg':u('\u041c\u0430\u043b\u0434\u0438\u0432'),'th':u('\u0e21\u0e31\u0e25\u0e14\u0e35\u0e1f\u0e2a\u0e4c'),'ti':'*am','tk':'Maldiwler','tl':'*aa','tn':'*aa','to':'Malativisi','tr':'Maldivler','ts':'*aa','tt':u('\u041c\u0430\u043b\u044c\u0434\u0438\u0432 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0645\u0627\u0644\u062f\u0649\u06cb\u06d0'),'uk':u('\u041c\u0430\u043b\u044c\u0434\u0456\u0432\u0438'),'ur':u('\u0645\u0627\u0644\u062f\u06cc\u067e'),'uz':'Maldiv orollari','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Maldiiw','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Maladifi'),'za':'*aa','zh':u('\u9a6c\u5c14\u4ee3\u592b'),'zu':'i-Maldives',},
  'MW': {'aa':'Malawi','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u121b\u120b\u12ca'),'an':'*aa','ar':u('\u0645\u0644\u0627\u0648\u064a'),'as':u('\u09ae\u09be\u09b2\u09be\u09f1\u09bf'),'av':'*aa','ay':'*aa','az':'Malavi','ba':'*aa','be':u('\u041c\u0430\u043b\u0430\u0432\u0456'),'bg':u('\u041c\u0430\u043b\u0430\u0432\u0438'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u09ae\u09be\u09b2\u09be\u0989\u0987'),'bo':'*aa','br':'*aa','bs':'*az','ca':'*aa','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f58\u0f0b\u0f63\u0f0b\u0f5d\u0f72'),'ee':'Malawi nutome','el':u('\u039c\u03b1\u03bb\u03ac\u03bf\u03c5\u03b9'),'en':'*aa','eo':'Malavio','es':'Malaui','et':'*aa','eu':'*aa','fa':u('\u0645\u0627\u0644\u0627\u0648\u06cc'),'ff':'Malaawi','fi':'*aa','fj':'*aa','fo':'*az','fr':'*aa','fy':'*aa','ga':u('an Mhal\u00e1iv'),'gd':'Malabhaidh','gl':'*aa','gn':'*aa','gu':u('\u0aae\u0abe\u0ab2\u0abe\u0ab5\u0ac0'),'gv':'*aa','ha':'*aa','he':u('\u05de\u05dc\u05d0\u05d5\u05d5\u05d9'),'hi':u('\u092e\u0932\u093e\u0935\u0940'),'ho':'*aa','hr':'*az','ht':'*aa','hu':'*aa','hy':u('\u0544\u0561\u056c\u0561\u057e\u056b'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Malav\u00ed'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30de\u30e9\u30a6\u30a4'),'ji':u('\u05de\u05d0\u05b7\u05dc\u05d0\u05b7\u05d5\u05d5\u05d9'),'jv':'*aa','ka':u('\u10db\u10d0\u10da\u10d0\u10d5\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1798\u17c9\u17b6\u17a1\u17b6\u179c\u17b8'),'kn':u('\u0cae\u0cb2\u0cbe\u0cb5\u0cbf'),'ko':u('\ub9d0\ub77c\uc704'),'kr':'*aa','ks':u('\u0645\u0644\u0627\u0648\u06cc'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0ea1\u0eb2\u0ea5\u0eb2\u0ea7\u0eb5'),'lt':'Malavis','lu':'*aa','lv':u('Mal\u0101vija'),'mg':u('Malao\u00ec'),'mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d2e\u0d32\u0d3e\u0d35\u0d3f'),'mn':'*bg','mo':'*aa','mr':'*hi','ms':'*aa','mt':'il-Malawi','my':u('\u1019\u102c\u101c\u102c\u101d\u102e'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u092e\u093e\u0932\u093e\u0935\u0940'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b3e\u0b32\u0b71\u0b3f'),'os':'*aa','pa':u('\u0a2e\u0a32\u0a3e\u0a35\u0a40'),'pi':'*aa','pl':'*aa','ps':u('\u0645\u0627\u0644\u0627\u0648\u064a'),'pt':'*es','qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*ps','se':'*aa','sg':u('Malaw\u00efi'),'si':u('\u0db8\u0dbd\u0dcf\u0dc0\u0dd2'),'sk':'*aa','sl':'*az','sm':'*aa','sn':'*aa','so':'*ff','sq':'*az','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0bae\u0bb2\u0bbe\u0bb5\u0bbf'),'te':u('\u0c2e\u0c3e\u0c32\u0c3e\u0c35\u0c3f'),'tg':'*bg','th':u('\u0e21\u0e32\u0e25\u0e32\u0e27\u0e35'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':'*es','tr':'*az','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0645\u0627\u0644\u0627\u06cb\u0649'),'uk':'*be','ur':'*ks','uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Malawi'),'za':'*aa','zh':u('\u9a6c\u62c9\u7ef4'),'zu':'iMalawi',},
  'MX': {'aa':'Mexico','ab':'*aa','ae':'*aa','af':'Meksiko','ak':u('M\u025bksiko'),'am':u('\u121c\u12ad\u1232\u12ae'),'an':'*aa','ar':u('\u0627\u0644\u0645\u0643\u0633\u064a\u0643'),'as':u('\u09ae\u09c7\u0995\u09cd\u09b8\u09bf\u0995\u09cb'),'av':'*aa','ay':'*aa','az':'Meksika','ba':'*aa','be':u('\u041c\u0435\u043a\u0441\u0456\u043a\u0430'),'bg':u('\u041c\u0435\u043a\u0441\u0438\u043a\u043e'),'bh':'*aa','bi':'*aa','bm':'Meksiki','bn':'*as','bo':'*aa','br':u('Mec\u02bchiko'),'bs':'*af','ca':u('M\u00e8xic'),'ce':u('\u041c\u0435\u043a\u0441\u0438\u043a\u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Mexiko','cu':'*aa','cv':'*aa','cy':'Mecsico','da':'*aa','de':'*cs','dv':'*aa','dz':u('\u0f58\u0f7a\u0f40\u0f0b\u0f66\u0f72\u0f0b\u0f40\u0f7c'),'ee':'Mexico nutome','el':u('\u039c\u03b5\u03be\u03b9\u03ba\u03cc'),'en':'*aa','eo':'*af','es':u('M\u00e9xico'),'et':'Mehhiko','eu':'*cs','fa':u('\u0645\u06a9\u0632\u06cc\u06a9'),'ff':'Meksik','fi':'*af','fj':'*aa','fo':'*af','fr':'Mexique','fy':'*aa','ga':'Meicsiceo','gd':'Meagsago','gl':'*es','gn':'*aa','gu':u('\u0aae\u0ac7\u0a95\u0acd\u0ab8\u0abf\u0a95\u0acb'),'gv':'*aa','ha':'Makasiko','he':u('\u05de\u05e7\u05e1\u05d9\u05e7\u05d5'),'hi':u('\u092e\u0948\u0915\u094d\u0938\u093f\u0915\u094b'),'ho':'*aa','hr':'*af','ht':'*aa','hu':u('Mexik\u00f3'),'hy':u('\u0544\u0565\u0584\u057d\u056b\u056f\u0561'),'hz':'*aa','ia':'*aa','id':'*af','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*af','io':'*aa','is':u('Mex\u00edk\u00f3'),'it':'Messico','iu':'*aa','iw':'*he','ja':u('\u30e1\u30ad\u30b7\u30b3'),'ji':u('\u05de\u05e2\u05e7\u05e1\u05d9\u05e7\u05e2'),'jv':'*aa','ka':u('\u10db\u10d4\u10e5\u10e1\u10d8\u10d9\u10d0'),'kg':'*aa','ki':'*af','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u1798\u17c9\u17b7\u1780\u179f\u17ca\u17b7\u1780'),'kn':u('\u0cae\u0cc6\u0c95\u0ccd\u0cb8\u0cbf\u0c95\u0cca'),'ko':u('\uba55\uc2dc\ucf54'),'kr':'*aa','ks':u('\u0645\u066e\u06ea\u06a9\u0633\u0650\u06a9\u0648'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*cs','lg':'Mekisiko','li':'*aa','ln':'Meksike','lo':u('\u0ec0\u0ea1\u0eb1\u0e81\u0e8a\u0eb4\u0ec2\u0e81'),'lt':'*az','lu':'*ln','lv':'*az','mg':'*az','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d2e\u0d46\u0d15\u0d4d\u0d38\u0d3f\u0d15\u0d4d\u0d15\u0d4b'),'mn':u('\u041c\u0435\u043a\u0441\u0438\u043a'),'mo':'Mexic','mr':u('\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u094b'),'ms':'*aa','mt':'il-Messiku','my':u('\u1019\u1000\u1039\u1000\u1006\u102e\u1000\u102d\u102f'),'na':'*aa','nb':'*aa','nd':'Meksikho','ne':'*mr','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b47\u0b15\u0b4d\u0b38\u0b3f\u0b15\u0b4b'),'os':'*aa','pa':u('\u0a2e\u0a48\u0a15\u0a38\u0a40\u0a15\u0a4b'),'pi':'*aa','pl':'Meksyk','ps':u('\u0645\u06cc\u06a9\u0633\u06cc\u06a9\u0648'),'pt':'*es','qu':'*es','rm':'*aa','rn':'Migizike','ro':'*mo','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0645\u064a\u06aa\u0633\u064a\u06aa\u0648'),'se':'*af','sg':u('Mekis\u00eeki'),'si':u('\u0db8\u0dd9\u0d9a\u0dca\u0dc3\u0dd2\u0d9a\u0ddd\u0dc0'),'sk':'*cs','sl':'Mehika','sm':'*aa','sn':'*aa','so':'*af','sq':u('Meksik\u00eb'),'sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*cs','sw':'*af','ta':u('\u0bae\u0bc6\u0b95\u0bcd\u0b9a\u0bbf\u0b95\u0bcb'),'te':u('\u0c2e\u0c46\u0c15\u0c4d\u0c38\u0c3f\u0c15\u0c4b'),'tg':'*ce','th':u('\u0e40\u0e21\u0e47\u0e01\u0e0b\u0e34\u0e42\u0e01'),'ti':'*am','tk':'*az','tl':'*aa','tn':'*aa','to':'Mekisikou','tr':'*az','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u0645\u06d0\u0643\u0633\u0649\u0643\u0627'),'uk':'*ce','ur':'*ps','uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*af','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Mesiko'),'za':'*aa','zh':u('\u58a8\u897f\u54e5'),'zu':'i-Mexico',},
  'MY': {'aa':'Malaysia','ab':'*aa','ae':'*aa','af':u('Maleisi\u00eb'),'ak':'Malehyia','am':u('\u121b\u120c\u12e2\u12eb'),'an':'*aa','ar':u('\u0645\u0627\u0644\u064a\u0632\u064a\u0627'),'as':u('\u09ae\u09be\u09b2\u09af\u09bc\u09c7\u099a\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Malayziya','ba':'*aa','be':u('\u041c\u0430\u043b\u0430\u0439\u0437\u0456\u044f'),'bg':u('\u041c\u0430\u043b\u0430\u0439\u0437\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':u('Mal\u025bzi'),'bn':u('\u09ae\u09be\u09b2\u09af\u09bc\u09c7\u09b6\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'*aa','bs':'Malezija','ca':u('Mal\u00e0isia'),'ce':u('\u041c\u0430\u043b\u0430\u0439\u0437\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Malajsie','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f58\u0f0b\u0f63\u0f7a\u0f0b\u0f64\u0f72\u0f0b\u0f61'),'ee':'Malaysia nutome','el':u('\u039c\u03b1\u03bb\u03b1\u03b9\u03c3\u03af\u03b1'),'en':'*aa','eo':'Malajzio','es':'Malasia','et':'Malaisia','eu':'*aa','fa':u('\u0645\u0627\u0644\u0632\u06cc'),'ff':'Malesii','fi':'Malesia','fj':'*aa','fo':'*et','fr':'Malaisie','fy':'*af','ga':'an Mhalaeisia','gd':'Malaidhsea','gl':'*et','gn':'*aa','gu':u('\u0aae\u0ab2\u0ac7\u0ab6\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Malaisiya','he':u('\u05de\u05dc\u05d6\u05d9\u05d4'),'hi':u('\u092e\u0932\u0947\u0936\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'Malajzia','hy':u('\u0544\u0561\u056c\u0561\u0575\u0566\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Malas\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30de\u30ec\u30fc\u30b7\u30a2'),'ji':u('\u05de\u05d0\u05b7\u05dc\u05d9\u05d9\u05d6\u05d9\u05e2'),'jv':'*aa','ka':u('\u10db\u10d0\u10da\u10d0\u10d8\u10d6\u10d8\u10d0'),'kg':'*aa','ki':'*fi','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1798\u17c9\u17b6\u17a1\u17c1\u179f\u17ca\u17b8'),'kn':u('\u0cae\u0cb2\u0cc7\u0cb6\u0cbf\u0caf\u0cbe'),'ko':u('\ub9d0\ub808\uc774\uc2dc\uc544'),'kr':'*aa','ks':u('\u0645\u064e\u0644\u06cc\u0634\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'Malezya','li':'*aa','ln':'Malezi','lo':u('\u0ea1\u0eb2\u0ec0\u0ea5\u0ec0\u0e8a\u0e8d'),'lt':'Malaizija','lu':'*ln','lv':'*lt','mg':'Malaizia','mh':'*aa','mi':'*aa','mk':u('\u041c\u0430\u043b\u0435\u0437\u0438\u0458\u0430'),'ml':u('\u0d2e\u0d32\u0d47\u0d37\u0d4d\u0d2f'),'mn':u('\u041c\u0430\u043b\u0430\u0439\u0437'),'mo':'*aa','mr':'*hi','ms':'*aa','mt':'il-Malasja','my':u('\u1019\u101c\u1031\u1038\u101b\u103e\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'Malezhiya','ne':u('\u092e\u0932\u0947\u0938\u093f\u092f\u093e'),'ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b3e\u0b32\u0b47\u0b38\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a2e\u0a32\u0a47\u0a38\u0a3c\u0a40\u0a06'),'pi':'*aa','pl':'Malezja','ps':u('\u0645\u0627\u0644\u06cc\u0632\u06cc\u0627'),'pt':u('Mal\u00e1sia'),'qu':'*aa','rm':'*et','rn':'Maleziya','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0645\u0644\u0627\u0626\u064a\u0634\u064a\u0627'),'se':'*fi','sg':u('Malez\u00efi'),'si':u('\u0db8\u0dd0\u0dbd\u0dda\u0dc3\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*hu','sl':'*bs','sm':'*aa','sn':'*aa','so':'*aa','sq':'Malajzi','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*fi','ta':u('\u0bae\u0bb2\u0bc7\u0b9a\u0bbf\u0baf\u0bbe'),'te':u('\u0c2e\u0c32\u0c47\u0c37\u0c3f\u0c2f\u0c3e'),'tg':'*bg','th':u('\u0e21\u0e32\u0e40\u0e25\u0e40\u0e0b\u0e35\u0e22'),'ti':'*am','tk':u('Mala\u00fdzi\u00fda'),'tl':'*aa','tn':'*aa','to':u('Mal\u0113sia'),'tr':'*lg','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0645\u0627\u0644\u0627\u064a\u0633\u0649\u064a\u0627'),'uk':'*be','ur':u('\u0645\u0644\u0627\u0626\u0634\u06cc\u0627'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Malesi','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Malasia'),'za':'*aa','zh':u('\u9a6c\u6765\u897f\u4e9a'),'zu':'i-Malaysia',},
  'MZ': {'aa':'Mozambique','ab':'*aa','ae':'*aa','af':'Mosambiek','ak':'Mozambik','am':u('\u121e\u12db\u121d\u1262\u12ad'),'an':'*aa','ar':u('\u0645\u0648\u0632\u0645\u0628\u064a\u0642'),'as':u('\u09ae\u2019\u099c\u09be\u09ae\u09ac\u09bf\u0995'),'av':'*aa','ay':'*aa','az':'*ak','ba':'*aa','be':u('\u041c\u0430\u0437\u0430\u043c\u0431\u0456\u043a'),'bg':u('\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a'),'bh':'*aa','bi':'*aa','bm':'Mozanbiki','bn':u('\u09ae\u09cb\u099c\u09be\u09ae\u09cd\u09ac\u09bf\u0995'),'bo':'*aa','br':'*ak','bs':'*ak','ca':u('Mo\u00e7ambic'),'ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'Mosambik','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*cs','dv':'*aa','dz':u('\u0f58\u0f7c\u0f0b\u0f5b\u0f58\u0f0b\u0f56\u0fb7\u0f72\u0f40'),'ee':'Mozambiki nutome','el':u('\u039c\u03bf\u03b6\u03b1\u03bc\u03b2\u03af\u03ba\u03b7'),'en':'*aa','eo':'Mozambiko','es':'*aa','et':'Mosambiik','eu':'Mozambike','fa':u('\u0645\u0648\u0632\u0627\u0645\u0628\u06cc\u06a9'),'ff':'Mosammbik','fi':'*cs','fj':'*aa','fo':'*cs','fr':'*aa','fy':'*aa','ga':u('M\u00f3saimb\u00edc'),'gd':u('M\u00f2saimbic'),'gl':'*aa','gn':'*aa','gu':u('\u0aae\u0acb\u0a9d\u0abe\u0aae\u0acd\u0aac\u0abf\u0a95'),'gv':'*aa','ha':'*ak','he':u('\u05de\u05d5\u05d6\u05de\u05d1\u05d9\u05e7'),'hi':u('\u092e\u094b\u091c\u093c\u093e\u0902\u092c\u093f\u0915'),'ho':'*aa','hr':'*ak','ht':'*aa','hu':'*ak','hy':u('\u0544\u0578\u0566\u0561\u0574\u0562\u056b\u056f'),'hz':'*aa','ia':'*aa','id':'*ak','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*ak','io':'*aa','is':u('M\u00f3samb\u00edk'),'it':'Mozambico','iu':'*aa','iw':'*he','ja':u('\u30e2\u30b6\u30f3\u30d3\u30fc\u30af'),'ji':u('\u05de\u05d0\u05d6\u05d0\u05b7\u05de\u05d1\u05d9\u05e7'),'jv':'*aa','ka':u('\u10db\u10dd\u10d6\u10d0\u10db\u10d1\u10d8\u10d9\u10d8'),'kg':'*aa','ki':'Msumbiji','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1798\u17c9\u17bc\u179f\u17c6\u1794\u17ca\u17b7\u1780'),'kn':u('\u0cae\u0cca\u0c9c\u0cbe\u0c82\u0cac\u0cbf\u0c95\u0ccd'),'ko':u('\ubaa8\uc7a0\ube44\ud06c'),'kr':'*aa','ks':u('\u0645\u0648\u0632\u064e\u0645\u0628\u0650\u06a9'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*cs','lg':'Mozambiiki','li':'*aa','ln':u('Mozamb\u00edki'),'lo':u('\u0ec2\u0ea1\u0ec1\u0e8a\u0ea1\u0e9a\u0eb4\u0e81'),'lt':'Mozambikas','lu':'Mozambiki','lv':'Mozambika','mg':'*lv','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d2e\u0d4a\u0d38\u0d3e\u0d02\u0d2c\u0d3f\u0d15\u0d4d\u0d15\u0d4d'),'mn':'*bg','mo':'Mozambic','mr':u('\u092e\u094b\u091d\u093e\u092e\u094d\u092c\u093f\u0915'),'ms':'*aa','mt':'il-Mozambique','my':u('\u1019\u102d\u102f\u1007\u1019\u103a\u1018\u1005\u103a'),'na':'*aa','nb':'*cs','nd':'*aa','ne':u('\u092e\u094b\u091c\u093e\u092e\u094d\u092c\u093f\u0915'),'ng':'*aa','nl':'*aa','nn':'*cs','no':'*cs','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2e\u0b4b\u0b1c\u0b3e\u0b2e\u0b4d\u0b2c\u0b3f\u0b15\u0b4d\u200c'),'os':'*aa','pa':u('\u0a2e\u0a4b\u0a1c\u0a3c\u0a3e\u0a2e\u0a2c\u0a40\u0a15'),'pi':'*aa','pl':'*ak','ps':u('\u0645\u0648\u0632\u0645\u0628\u06cc\u06a9'),'pt':u('Mo\u00e7ambique'),'qu':'*aa','rm':'Mosambic','rn':'*lu','ro':'*mo','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0645\u0648\u0632\u0645\u0628\u06cc\u0642'),'se':'*cs','sg':u('M\u00f6z\u00e4mb\u00eeka'),'si':u('\u0db8\u0ddc\u0dc3\u0dd0\u0db8\u0dca\u0db6\u0dd2\u0d9a\u0dca'),'sk':'*ak','sl':'*ak','sm':'*aa','sn':'*aa','so':'Musambiig','sq':'*ak','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*pt','sw':'*ki','ta':u('\u0bae\u0bca\u0b9a\u0bbe\u0bae\u0bcd\u0baa\u0bbf\u0b95\u0bcd'),'te':u('\u0c2e\u0c4a\u0c1c\u0c3e\u0c02\u0c2c\u0c3f\u0c15\u0c4d'),'tg':'*bg','th':u('\u0e42\u0e21\u0e0b\u0e31\u0e21\u0e1a\u0e34\u0e01'),'ti':'*am','tk':'*ak','tl':'*aa','tn':'*aa','to':u('Mos\u0113mipiki'),'tr':'*ak','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0645\u0648\u0632\u0627\u0645\u0628\u0649\u0643'),'uk':u('\u041c\u043e\u0437\u0430\u043c\u0431\u0456\u043a'),'ur':'*sd','uz':'*ak','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':u('Mos\u00e0mbig'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Mo\u1e63amibiku'),'za':'*aa','zh':u('\u83ab\u6851\u6bd4\u514b'),'zu':'i-Mozambique',},
  'NA': {'aa':'Namibia','ab':'*aa','ae':'*aa','af':u('Namibi\u00eb'),'ak':'*aa','am':u('\u1293\u121a\u1262\u12eb'),'an':'*aa','ar':u('\u0646\u0627\u0645\u064a\u0628\u064a\u0627'),'as':u('\u09a8\u09be\u09ae\u09bf\u09ac\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Namibiya','ba':'*aa','be':u('\u041d\u0430\u043c\u0456\u0431\u0456\u044f'),'bg':u('\u041d\u0430\u043c\u0438\u0431\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Namibi','bn':'*as','bo':'*aa','br':'*aa','bs':'Namibija','ca':u('Nam\u00edbia'),'ce':u('\u041d\u0430\u043c\u0438\u0431\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Namibie','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f53\u0f0b\u0f58\u0f72\u0f0b\u0f56\u0f72\u0f0b\u0f61'),'ee':'Namibia nutome','el':u('\u039d\u03b1\u03bc\u03af\u03bc\u03c0\u03b9\u03b1'),'en':'*aa','eo':'Namibio','es':'*aa','et':'Namiibia','eu':'*aa','fa':u('\u0646\u0627\u0645\u06cc\u0628\u06cc\u0627'),'ff':'Namibii','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*cs','fy':'*af','ga':'an Namaib','gd':'An Namaib','gl':'*aa','gn':'*aa','gu':u('\u0aa8\u0abe\u0aae\u0abf\u0aac\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'*az','he':u('\u05e0\u05de\u05d9\u05d1\u05d9\u05d4'),'hi':u('\u0928\u093e\u092e\u0940\u092c\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*ca','hy':u('\u0546\u0561\u0574\u056b\u0562\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Namib\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30ca\u30df\u30d3\u30a2'),'ji':u('\u05e0\u05d0\u05b7\u05de\u05d9\u05d1\u05d9\u05e2'),'jv':'*aa','ka':u('\u10dc\u10d0\u10db\u10d8\u10d1\u10d8\u10d0'),'kg':'*aa','ki':'Namimbia','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u178e\u17b6\u1798\u17b8\u1794\u17ca\u17b8'),'kn':u('\u0ca8\u0cae\u0cc0\u0cac\u0cbf\u0caf\u0cbe'),'ko':u('\ub098\ubbf8\ube44\uc544'),'kr':'*aa','ks':u('\u0646\u0627\u0645\u0650\u0628\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'*az','li':'*aa','ln':'*bm','lo':u('\u0e99\u0eb2\u0ea1\u0eb5\u0ec0\u0e9a\u0e8d'),'lt':'*bs','lu':'*bm','lv':u('Nam\u012bbija'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u041d\u0430\u043c\u0438\u0431\u0438\u0458\u0430'),'ml':u('\u0d28\u0d2e\u0d40\u0d2c\u0d3f\u0d2f'),'mn':'*ce','mo':'*aa','mr':u('\u0928\u093e\u092e\u093f\u092c\u093f\u092f\u093e'),'ms':'*aa','mt':'in-Namibja','my':u('\u1014\u1019\u102e\u1038\u1018\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'Namibhiya','ne':'*mr','ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b28\u0b3e\u0b2e\u0b3f\u0b2c\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a28\u0a3e\u0a2e\u0a40\u0a2c\u0a40\u0a06'),'pi':'*aa','pl':'*aa','ps':u('\u0646\u06cc\u0645\u0628\u06cc\u0627'),'pt':'*ca','qu':'*aa','rm':'*aa','rn':'*az','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0646\u064a\u0645\u064a\u0628\u064a\u0627'),'se':'*aa','sg':u('Namib\u00f9ii'),'si':u('\u0db1\u0dd0\u0db8\u0dd3\u0db6\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*ca','sl':'*bs','sm':'*aa','sn':'*aa','so':'Namiibiya','sq':'*bm','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0ba8\u0bae\u0bc0\u0baa\u0bbf\u0baf\u0bbe'),'te':u('\u0c28\u0c2e\u0c40\u0c2c\u0c3f\u0c2f\u0c3e'),'tg':'*bg','th':u('\u0e19\u0e32\u0e21\u0e34\u0e40\u0e1a\u0e35\u0e22'),'ti':'*am','tk':u('Namibi\u00fda'),'tl':'*aa','tn':'*aa','to':'Namipia','tr':'Namibya','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0646\u0627\u0645\u0649\u0628\u0649\u064a\u06d5'),'uk':'*be','ur':'*fa','uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*bm','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Namibia'),'za':'*aa','zh':u('\u7eb3\u7c73\u6bd4\u4e9a'),'zu':'i-Namibia',},
  'NC': {'aa':'New Caledonia','ab':'*aa','ae':'*aa','af':u('Nieu-Kaledoni\u00eb'),'ak':'Kaledonia Foforo','am':u('\u1292\u12cd \u12ab\u120c\u12f6\u1292\u12eb'),'an':'*aa','ar':u('\u0643\u0627\u0644\u064a\u062f\u0648\u0646\u064a\u0627 \u0627\u0644\u062c\u062f\u064a\u062f\u0629'),'as':u('\u09a8\u09bf\u0989 \u0995\u09c7\u09b2\u09bf\u09a1\u09cb\u09a8\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Yeni Kaledoniya','ba':'*aa','be':u('\u041d\u043e\u0432\u0430\u044f \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0456\u044f'),'bg':u('\u041d\u043e\u0432\u0430 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Kaledoni Koura','bn':u('\u09a8\u09bf\u0989 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a1\u09cb\u09a8\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'Kaledonia Nevez','bs':'Nova Kaledonija','ca':u('Nova Caled\u00f2nia'),'ce':u('\u041a\u0435\u0440\u043b\u0430 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Nov\u00e1 Kaledonie'),'cu':'*aa','cv':'*aa','cy':'Caledonia Newydd','da':'Ny Kaledonien','de':'Neukaledonien','dv':'*aa','dz':u('\u0f53\u0f72\u0f60\u0f74\u0f0b\u0f40\u0f0b\u0f63\u0f72\u0f0b\u0f51\u0f7c\u0f0b\u0f53\u0f72\u0f0b\u0f61'),'ee':'New Kaledonia nutome','el':u('\u039d\u03ad\u03b1 \u039a\u03b1\u03bb\u03b7\u03b4\u03bf\u03bd\u03af\u03b1'),'en':'*aa','eo':'Nov-Kaledonio','es':'Nueva Caledonia','et':'Uus-Kaledoonia','eu':'Kaledonia Berria','fa':u('\u06a9\u0627\u0644\u062f\u0648\u0646\u06cc\u0627\u06cc \u062c\u062f\u06cc\u062f'),'ff':'Nuwel Kaledonii','fi':'Uusi-Kaledonia','fj':'*aa','fo':u('N\u00fdkaled\u00f3nia'),'fr':u('Nouvelle-Cal\u00e9donie'),'fy':u('Nij-Caledoni\u00eb'),'ga':u('an Nua-Chalad\u00f3in'),'gd':'Cailleann Nuadh','gl':'Nova Caledonia','gn':'*aa','gu':u('\u0aa8\u0acd\u0aaf\u0ac1 \u0ab8\u0ac7\u0ab2\u0ac7\u0aa1\u0acb\u0aa8\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Kaledoniya Sabuwa','he':u('\u05e7\u05dc\u05d3\u05d5\u05e0\u05d9\u05d4 \u05d4\u05d7\u05d3\u05e9\u05d4'),'hi':u('\u0928\u094d\u092f\u0942 \u0915\u0948\u0932\u0947\u0921\u094b\u0928\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('\u00daj-Kaled\u00f3nia'),'hy':u('\u0546\u0578\u0580 \u053f\u0561\u056c\u0565\u0564\u0578\u0576\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'Kaledonia Baru','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('N\u00fdja-Kaled\u00f3n\u00eda'),'it':'Nuova Caledonia','iu':'*aa','iw':'*he','ja':u('\u30cb\u30e5\u30fc\u30ab\u30ec\u30c9\u30cb\u30a2'),'ji':u('\u05e0\u05f2\u05b7 \u05e7\u05d0\u05b7\u05dc\u05e2\u05d3\u05d0\u05e0\u05d9\u05e2'),'jv':'*aa','ka':u('\u10d0\u10ee\u10d0\u10da\u10d8 \u10d9\u10d0\u10da\u10d4\u10d3\u10dd\u10dc\u10d8\u10d0'),'kg':'*aa','ki':'Nyukaledonia','kj':'*aa','kk':u('\u0416\u0430\u04a3\u0430 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u044f'),'kl':'*aa','km':u('\u1793\u17bc\u179c\u17c2\u179b\u200b\u1780\u17b6\u17a1\u17c1\u178a\u17bc\u1793\u17b8'),'kn':u('\u0ca8\u0ccd\u0caf\u0cc2 \u0c95\u0ccd\u0caf\u0cbe\u0cb2\u0cbf\u0ca1\u0ccb\u0ca8\u0cbf\u0caf\u0cbe'),'ko':u('\ub274\uce7c\ub808\ub3c4\ub2c8\uc544'),'kr':'*aa','ks':u('\u0646\u0650\u0648 \u06a9\u06cc\u0644\u0650\u0691\u0648\u0646\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0416\u0430\u04ca\u044b \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u044f'),'la':'*aa','lb':'Neikaledonien','lg':'Kaledonya mupya','li':'*aa','ln':'Kaledoni ya sika','lo':u('\u0e99\u0eb4\u0ea7 \u0e84\u0eb2\u0ec0\u0ea5\u0ec2\u0e94\u0ec0\u0e99\u0e8d'),'lt':'Naujoji Kaledonija','lu':'Kaledoni wa mumu','lv':'Jaunkaledonija','mg':'*fr','mh':'*aa','mi':'*aa','mk':u('\u041d\u043e\u0432\u0430 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u0458\u0430'),'ml':u('\u0d28\u0d4d\u0d2f\u0d42 \u0d15\u0d3e\u0d32\u0d3f\u0d21\u0d4b\u0d23\u0d3f\u0d2f'),'mn':u('\u0428\u0438\u043d\u044d \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438'),'mo':'Noua Caledonie','mr':u('\u0928\u094d\u092f\u0942 \u0915\u0945\u0932\u0947\u0921\u094b\u0928\u093f\u092f\u093e'),'ms':'*aa','mt':'*aa','my':u('\u1014\u101a\u1030\u1038 \u1000\u101a\u103a\u101c\u102e\u1012\u102d\u102f\u1014\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'Ny-Caledonia','nd':'*aa','ne':u('\u0928\u094d\u092f\u0941 \u0915\u094d\u092f\u093e\u0932\u0947\u0921\u094b\u0928\u093f\u092f\u093e'),'ng':'*aa','nl':u('Nieuw-Caledoni\u00eb'),'nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b28\u0b42\u0b24\u0b28 \u0b15\u0b3e\u0b32\u0b47\u0b21\u0b4b\u0b28\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a28\u0a3f\u0a0a \u0a15\u0a48\u0a32\u0a47\u0a21\u0a4b\u0a28\u0a40\u0a06'),'pi':'*aa','pl':'Nowa Kaledonia','ps':u('\u0646\u0648\u06cc \u06a9\u0627\u0644\u06cc\u0689\u0648\u0646\u06cc\u0627'),'pt':u('Nova Caled\u00f4nia'),'qu':'*es','rm':'*gl','rn':'Niyukaledoniya','ro':'*mo','ru':u('\u041d\u043e\u0432\u0430\u044f \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0646\u06cc\u0648 \u06aa\u0627\u0644\u06cc\u068a\u0648\u0646\u06cc\u0627'),'se':u('O\u0111\u0111a-Kaledonia'),'sg':u('Fin\u00ee Kaledon\u00efi'),'si':u('\u0db1\u0dc0 \u0d9a\u0dd0\u0dbd\u0dd2\u0da9\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0dc0'),'sk':u('Nov\u00e1 Kaled\u00f3nia'),'sl':'*bs','sm':'*aa','sn':'*aa','so':'*aa','sq':'Kaledonia e Re','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'Nya Kaledonien','sw':'*aa','ta':u('\u0ba8\u0bbf\u0baf\u0bc2 \u0b95\u0bc7\u0bb2\u0bbf\u0b9f\u0bcb\u0ba9\u0bbf\u0baf\u0bbe'),'te':u('\u0c15\u0c4d\u0c30\u0c4a\u0c24\u0c4d\u0c24 \u0c15\u0c3e\u0c32\u0c46\u0c21\u0c4b\u0c28\u0c3f\u0c2f\u0c3e'),'tg':u('\u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u044f\u0438 \u041d\u0430\u0432'),'th':u('\u0e19\u0e34\u0e27\u0e41\u0e04\u0e25\u0e34\u0e42\u0e14\u0e40\u0e19\u0e35\u0e22'),'ti':'*am','tk':u('T\u00e4ze Kaledoni\u00fda'),'tl':'*aa','tn':'*aa','to':u('Niu Kalet\u014dnia'),'tr':'Yeni Kaledonya','ts':'*aa','tt':u('\u042f\u04a3\u0430 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u044f'),'tw':'*aa','ty':'*aa','ug':u('\u064a\u06d0\u06ad\u0649 \u0643\u0627\u0644\u06d0\u062f\u0648\u0646\u0649\u064a\u06d5'),'uk':u('\u041d\u043e\u0432\u0430 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0456\u044f'),'ur':u('\u0646\u06cc\u0648 \u06a9\u0644\u06cc\u0688\u0648\u0646\u06cc\u0627'),'uz':'Yangi Kaledoniya','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Nuwel Kaledoni','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Kaledonia Titun'),'za':'*aa','zh':u('\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a'),'zu':'i-New Caledonia',},
  'NE': {'aa':'Niger','ab':'*aa','ae':'*aa','af':'*aa','ak':u('Nigy\u025b'),'am':u('\u1292\u1300\u122d'),'an':'*aa','ar':u('\u0627\u0644\u0646\u064a\u062c\u0631'),'as':u('\u09a8\u09be\u0987\u099c\u09be\u09f0'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u041d\u0456\u0433\u0435\u0440'),'bg':u('\u041d\u0438\u0433\u0435\u0440'),'bh':'*aa','bi':'*aa','bm':u('Niz\u025bri'),'bn':u('\u09a8\u09be\u0987\u099c\u09be\u09b0'),'bo':'*aa','br':'*aa','bs':'*aa','ca':u('N\u00edger'),'ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f53\u0f71\u0f60\u0f72\u0f0b\u0f47\u0f71'),'ee':'Niger nutome','el':u('\u039d\u03af\u03b3\u03b7\u03c1\u03b1\u03c2'),'en':'*aa','eo':u('Ni\u011dero'),'es':'*ca','et':'*aa','eu':'*aa','fa':u('\u0646\u06cc\u062c\u0631'),'ff':'Nijeer','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('an N\u00edgir'),'gd':u('N\u00ecgeir'),'gl':u('N\u00edxer'),'gn':'*aa','gu':u('\u0aa8\u0abe\u0a87\u0a9c\u0ab0'),'gv':'*aa','ha':'Nijar','he':u('\u05e0\u05d9\u05d6\u05f3\u05e8'),'hi':u('\u0928\u093e\u0907\u091c\u0930'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u0546\u056b\u0563\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*ca','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30cb\u30b8\u30a7\u30fc\u30eb'),'ji':u('\u05e0\u05d9\u05d6\u05e9\u05e2\u05e8'),'jv':'*aa','ka':u('\u10dc\u10d8\u10d2\u10d4\u10e0\u10d8'),'kg':'*aa','ki':'Nijeri','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1793\u17b8\u17a0\u17d2\u179f\u17c1'),'kn':u('\u0ca8\u0cc8\u0c9c\u0cb0\u0ccd'),'ko':u('\ub2c8\uc81c\ub974'),'kr':'*aa','ks':u('\u0646\u0627\u06cc\u062c\u064e\u0631'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'Nije','li':'*aa','ln':u('Niz\u025br\u025b'),'lo':u('\u0e99\u0eb4\u0ec0\u0e88\u0eb5'),'lt':'Nigeris','lu':'Nijere','lv':u('Nig\u0113ra'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d28\u0d48\u0d1c\u0d7c'),'mn':'*bg','mo':'*aa','mr':'*hi','ms':'*aa','mt':u('in-Ni\u0121er'),'my':u('\u1014\u102d\u102f\u1004\u103a\u1002\u103b\u102c'),'na':'*aa','nb':'*aa','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b28\u0b3e\u0b07\u0b1c\u0b30'),'os':'*aa','pa':u('\u0a28\u0a3e\u0a08\u0a1c\u0a30'),'pi':'*aa','pl':'*aa','ps':'*fa','pt':'*ca','qu':'*ca','rm':'*aa','rn':'*ki','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0646\u0627\u0626\u064a\u062c\u0631'),'se':'*aa','sg':u('Niz\u00ebre'),'si':u('\u0db1\u0dba\u0dd2\u0da2\u0dbb\u0dca'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'Nayjer','sq':'*aa','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0ba8\u0bc8\u0b9c\u0bb0\u0bcd'),'te':u('\u0c28\u0c48\u0c1c\u0c30\u0c4d'),'tg':'*bg','th':u('\u0e44\u0e19\u0e40\u0e08\u0e2d\u0e23\u0e4c'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':'Nisia','tr':'Nijer','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0646\u0649\u06af\u06d0\u0631'),'uk':'*be','ur':u('\u0646\u0627\u0626\u062c\u0631'),'uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Niiseer','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de N\u00e0\u00ecj\u00e1'),'za':'*aa','zh':u('\u5c3c\u65e5\u5c14'),'zu':'i-Niger',},
  'NF': {'aa':'Norfolk Island','ab':'*aa','ae':'*aa','af':'Norfolkeiland','ak':u('N\u0254folk Aeland'),'am':u('\u1296\u122d\u134e\u120d\u12ad \u12f0\u1234\u1275'),'an':'*aa','ar':u('\u062c\u0632\u064a\u0631\u0629 \u0646\u0648\u0631\u0641\u0648\u0644\u0643'),'as':u('\u09a8\u2019\u09f0\u09ab\u2019\u0995 \u09a6\u09cd\u09ac\u09c0\u09aa'),'av':'*aa','ay':'*aa','az':u('Norfolk adas\u0131'),'ba':'*aa','be':u('\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u041d\u043e\u0440\u0444\u0430\u043b\u043a'),'bg':u('\u043e\u0441\u0442\u0440\u043e\u0432 \u041d\u043e\u0440\u0444\u043e\u043b\u043a'),'bh':'*aa','bi':'*aa','bm':u('N\u0254rofoliki Gun'),'bn':u('\u09a8\u09b0\u09ab\u09cb\u0995 \u09a6\u09cd\u09ac\u09c0\u09aa'),'bo':'*aa','br':'Enez Norfolk','bs':'Ostrvo Norfolk','ca':'Norfolk','ce':u('\u041d\u043e\u0440\u0444\u043e\u043b\u043a \u0433\u04c0\u0430\u0439\u0440\u0435'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*ca','cu':'*aa','cv':'*aa','cy':'Ynys Norfolk','da':'*aa','de':'Norfolkinsel','dv':'*aa','dz':u('\u0f53\u0f7c\u0f62\u0f0b\u0f55\u0f7c\u0f63\u0f40\u0f0b\u0f58\u0f5a\u0f7c\u0f0b\u0f42\u0fb3\u0f72\u0f44\u0f0c'),'ee':u('Norfolk \u0192udomekpo nutome'),'el':u('\u039d\u03ae\u03c3\u03bf\u03c2 \u039d\u03cc\u03c1\u03c6\u03bf\u03bb\u03ba'),'en':'*aa','eo':'Norfolkinsulo','es':'Isla Norfolk','et':'*ca','eu':'Norfolk uhartea','fa':u('\u062c\u0632\u06cc\u0631\u0647\u0654 \u0646\u0648\u0631\u0641\u0648\u0644\u06a9'),'ff':u('Duu\u0257e Norfolk'),'fi':'Norfolkinsaari','fj':'*aa','fo':'Norfolksoyggj','fr':u('\u00cele Norfolk'),'fy':u('Norfolkeil\u00e2n'),'ga':u('Oile\u00e1n Norfolk'),'gd':'Eilean Norfolk','gl':'Illa Norfolk','gn':'*aa','gu':u('\u0aa8\u0acb\u0ab0\u0aab\u0acb\u0a95 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8'),'gv':'*aa','ha':'Tsibirin Narfalk','he':u('\u05d0\u05d9\u05d9 \u05e0\u05d5\u05e8\u05e4\u05d5\u05e7'),'hi':u('\u0928\u0949\u0930\u092b\u093c\u0949\u0915 \u0926\u094d\u0935\u0940\u092a'),'ho':'*aa','hr':'Otok Norfolk','ht':'*aa','hu':'Norfolk-sziget','hy':u('\u0546\u0578\u0580\u0586\u0578\u056c\u056f \u056f\u0572\u0566\u056b'),'hz':'*aa','ia':'*aa','id':'Kepulauan Norfolk','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'Norfolkeyja','it':'Isola Norfolk','iu':'*aa','iw':'*he','ja':u('\u30ce\u30fc\u30d5\u30a9\u30fc\u30af\u5cf6'),'ji':u('\u05e0\u05d0\u05e8\u05e4\u05bf\u05d0\u05dc\u05e7 \u05d0\u05d9\u05e0\u05d6\u05dc'),'jv':'*aa','ka':u('\u10dc\u10dd\u10e0\u10e4\u10dd\u10da\u10d9\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d8'),'kg':'*aa','ki':'Kisiwa cha Norfok','kj':'*aa','kk':u('\u041d\u043e\u0440\u0444\u043e\u043b\u043a \u0430\u0440\u0430\u043b\u044b'),'kl':'*aa','km':u('\u1780\u17c4\u17c7\u200b\u178e\u17d0\u179a\u17a0\u17d2\u179c\u1780\u17cb'),'kn':u('\u0ca8\u0cbe\u0cb0\u0ccd\u0cab\u0ccb\u0c95\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa'),'ko':u('\ub178\ud37d\uc12c'),'kr':'*aa','ks':u('\u0646\u0627\u0631\u0641\u0627\u06a9 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*de','lg':u('Kizinga ky\u2019eNorofoko'),'li':'*aa','ln':u('Esanga Norfok\u025b'),'lo':u('\u0ec0\u0e81\u0eb2\u0eb0\u0e99\u0ecd\u0ec2\u0e9f\u0e81'),'lt':'Norfolko sala','lu':'Lutanda lua Norfok','lv':'Norfolkas sala','mg':'Nosy Norfolk','mh':'*aa','mi':'*aa','mk':u('\u041d\u043e\u0440\u0444\u043e\u043b\u0448\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432'),'ml':u('\u0d28\u0d4b\u0d7c\u0d2b\u0d4b\u0d15\u0d4d \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d4d'),'mn':u('\u041d\u043e\u0440\u0444\u043e\u043b\u043a \u0430\u0440\u0430\u043b'),'mo':'Insula Norfolk','mr':u('\u0928\u0949\u0930\u092b\u0949\u0915 \u092c\u0947\u091f'),'ms':'Pulau Norfolk','mt':u('G\u017cira Norfolk'),'my':u('\u1014\u1031\u102c\u1016\u102f\u1010\u103a\u1000\u103b\u103d\u1014\u103a\u1038'),'na':'*aa','nb':u('Norfolk\u00f8ya'),'nd':'*aa','ne':u('\u0928\u094b\u0930\u092b\u094b\u0932\u094d\u0915 \u091f\u093e\u092a\u0941'),'ng':'*aa','nl':'*ca','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b28\u0b30\u0b4d\u0b2b\u0b15\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a'),'os':'*aa','pa':u('\u0a28\u0a4b\u0a30\u0a2b\u0a4c\u0a15 \u0a1f\u0a3e\u0a2a\u0a42'),'pi':'*aa','pl':'*ca','ps':u('\u0646\u0627\u0631\u0641\u0648\u0644\u06a9 \u067c\u0627\u067e\u0648\u06ab\u0627\u0646'),'pt':'Ilha Norfolk','qu':'*es','rm':'Insla Norfolk','rn':'izinga rya Norufoluke','ro':'*mo','ru':u('\u043e-\u0432 \u041d\u043e\u0440\u0444\u043e\u043b\u043a'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0646\u0648\u0631\u0641\u0648\u06aa \u067b\u064a\u067d'),'se':'Norfolksullot','sg':u('Z\u00fb\u00e2 N\u00f4rf\u00f4lko'),'si':u('\u0db1\u0ddd\u0dc6\u0ddd\u0d9a\u0dca \u0daf\u0dd6\u0db4\u0dad'),'sk':'*ca','sl':u('Norfol\u0161ki otok'),'sm':'*aa','sn':'Chitsuwa cheNorfolk','so':'*aa','sq':'Ishulli Norfolk','sr':u('\u041e\u0441\u0442\u0440\u0432\u043e \u041d\u043e\u0440\u0444\u043e\u043a'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Norfolk\u00f6n'),'sw':'Kisiwa cha Norfolk','ta':u('\u0ba8\u0bbe\u0bb0\u0bcd\u0b83\u0baa\u0bcb\u0b95\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd'),'te':u('\u0c28\u0c3e\u0c30\u0c4d\u0c2b\u0c4b\u0c15\u0c4d \u0c26\u0c40\u0c35\u0c3f'),'tg':u('\u04b6\u0430\u0437\u0438\u0440\u0430\u0438 \u041d\u043e\u0440\u0444\u043e\u043b\u043a'),'th':u('\u0e40\u0e01\u0e32\u0e30\u0e19\u0e2d\u0e23\u0e4c\u0e1f\u0e2d\u0e25\u0e4c\u0e01'),'ti':'*am','tk':'Norfolk adasy','tl':'*aa','tn':'*aa','to':u('Motu N\u014dfoliki'),'tr':u('Norfolk Adas\u0131'),'ts':'*aa','tt':u('\u041d\u043e\u0440\u0444\u043e\u043b\u043a \u0443\u0442\u0440\u0430\u0432\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0646\u0648\u0631\u0641\u0648\u0644\u0643 \u0626\u0627\u0631\u0649\u0644\u0649'),'uk':u('\u041e\u0441\u0442\u0440\u0456\u0432 \u041d\u043e\u0440\u0444\u043e\u043b\u043a'),'ur':u('\u0646\u0627\u0631\u0641\u0648\u06a9 \u0622\u0626\u0644\u06cc\u0646\u0688'),'uz':'Norfolk oroli','ve':'*aa','vi':u('\u0110\u1ea3o Norfolk'),'vo':'*aa','wa':'*aa','wo':'Dunu Norfolk','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Etikun N\u1ecd\u0301\u00faf\u00f3k\u00ec'),'za':'*aa','zh':u('\u8bfa\u798f\u514b\u5c9b'),'zu':'i-Norfolk Island',},
  'NG': {'aa':'Nigeria','ab':'*aa','ae':'*aa','af':u('Nigeri\u00eb'),'ak':'Naegyeria','am':u('\u1293\u12ed\u1304\u122a\u12eb'),'an':'*aa','ar':u('\u0646\u064a\u062c\u064a\u0631\u064a\u0627'),'as':u('\u09a8\u09be\u0987\u099c\u09c7\u09f0\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Nigeriya','ba':'*aa','be':u('\u041d\u0456\u0433\u0435\u0440\u044b\u044f'),'bg':u('\u041d\u0438\u0433\u0435\u0440\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Nizeriya','bn':u('\u09a8\u09be\u0987\u099c\u09c7\u09b0\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'*aa','bs':'Nigerija','ca':u('Nig\u00e8ria'),'ce':u('\u041d\u0438\u0433\u0435\u0440\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Nig\u00e9rie'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f53\u0f71\u0f60\u0f72\u0f0b\u0f47\u0f72\u0f0b\u0f62\u0f72\u0f0b\u0f61'),'ee':'Nigeria nutome','el':u('\u039d\u03b9\u03b3\u03b7\u03c1\u03af\u03b1'),'en':'*aa','eo':u('Ni\u011derio'),'es':'*aa','et':'Nigeeria','eu':'*aa','fa':u('\u0646\u06cc\u062c\u0631\u06cc\u0647'),'ff':'Nijeriyaa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Nig\u00e9ria'),'fy':'*aa','ga':u('an Nig\u00e9ir'),'gd':u('Nig\u00e8iria'),'gl':'Nixeria','gn':'*aa','gu':u('\u0aa8\u0abe\u0a87\u0a9c\u0ac7\u0ab0\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Najeriya','he':u('\u05e0\u05d9\u05d2\u05e8\u05d9\u05d4'),'hi':u('\u0928\u093e\u0907\u091c\u0940\u0930\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*fr','hy':u('\u0546\u056b\u0563\u0565\u0580\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':u('Na\u1ecbj\u1ecbr\u1ecba'),'ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('N\u00edger\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30ca\u30a4\u30b8\u30a7\u30ea\u30a2'),'ji':u('\u05e0\u05d9\u05d2\u05e2\u05e8\u05d9\u05e2'),'jv':'*aa','ka':u('\u10dc\u10d8\u10d2\u10d4\u10e0\u10d8\u10d0'),'kg':'*aa','ki':'Nainjeria','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1793\u17b8\u17a0\u17d2\u179f\u17c1\u179a\u17b8\u1799\u17c9\u17b6'),'kn':u('\u0ca8\u0cc8\u0c9c\u0cc0\u0cb0\u0cbf\u0caf\u0cbe'),'ko':u('\ub098\uc774\uc9c0\ub9ac\uc544'),'kr':'*aa','ks':u('\u0646\u0627\u06cc\u062c\u06cc\u0631\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'Nayijerya','li':'*aa','ln':'Nizerya','lo':u('\u0ec4\u0e99\u0e88\u0eb5\u0ec0\u0ea3\u0e8d'),'lt':'*bs','lu':'Nijerya','lv':u('Nig\u0113rija'),'mg':'Nizeria','mh':'*aa','mi':'*aa','mk':u('\u041d\u0438\u0433\u0435\u0440\u0438\u0458\u0430'),'ml':u('\u0d28\u0d48\u0d1c\u0d40\u0d30\u0d3f\u0d2f'),'mn':'*ce','mo':'*aa','mr':u('\u0928\u093e\u092f\u091c\u0947\u0930\u093f\u092f\u093e'),'ms':'*aa','mt':u('in-Ni\u0121erja'),'my':u('\u1014\u102d\u102f\u1004\u103a\u1002\u103b\u102e\u1038\u101b\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'*az','ne':u('\u0928\u093e\u0907\u091c\u0947\u0930\u093f\u092f\u093e'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b28\u0b3e\u0b07\u0b1c\u0b47\u0b30\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a28\u0a3e\u0a08\u0a1c\u0a40\u0a30\u0a40\u0a06'),'pi':'*aa','pl':'*aa','ps':u('\u0646\u0627\u06cc\u062c\u06cc\u0631\u06cc\u0627'),'pt':'*fr','qu':'*aa','rm':'*aa','rn':'Nijeriya','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0646\u0627\u0626\u064a\u062c\u064a\u0631\u064a\u0627'),'se':'*aa','sg':u('Nizer\u00efa'),'si':u('\u0db1\u0dba\u0dd2\u0da2\u0dd3\u0dbb\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*fr','sl':'*bs','sm':'*aa','sn':'*aa','so':'Nayjeeriya','sq':'Nigeri','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0ba8\u0bc8\u0b9c\u0bc0\u0bb0\u0bbf\u0baf\u0bbe'),'te':u('\u0c28\u0c48\u0c1c\u0c40\u0c30\u0c3f\u0c2f\u0c3e'),'tg':'*bg','th':u('\u0e44\u0e19\u0e08\u0e35\u0e40\u0e23\u0e35\u0e22'),'ti':'*am','tk':u('Nigeri\u00fda'),'tl':'*aa','tn':'*aa','to':'Naisilia','tr':'*lu','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0646\u0649\u06af\u06d0\u0631\u0649\u064a\u06d5'),'uk':u('\u041d\u0456\u0433\u0435\u0440\u0456\u044f'),'ur':u('\u0646\u0627\u0626\u062c\u06cc\u0631\u06cc\u0627'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Niseriya','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de N\u00e0\u00ecj\u00edr\u00ed\u00e0'),'za':'*aa','zh':u('\u5c3c\u65e5\u5229\u4e9a'),'zu':'i-Nigeria',},
  'NI': {'aa':'Nicaragua','ab':'*aa','ae':'*aa','af':'*aa','ak':'Nekaraguwa','am':u('\u1292\u12ab\u122b\u1313'),'an':'*aa','ar':u('\u0646\u064a\u0643\u0627\u0631\u0627\u063a\u0648\u0627'),'as':u('\u09a8\u09bf\u0995\u09be\u09f0\u09be\u0997\u09c1\u09f1\u09be'),'av':'*aa','ay':'*aa','az':'Nikaraqua','ba':'*aa','be':u('\u041d\u0456\u043a\u0430\u0440\u0430\u0433\u0443\u0430'),'bg':u('\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430'),'bh':'*aa','bi':'*aa','bm':'Nikaragwa','bn':u('\u09a8\u09bf\u0995\u09be\u09b0\u09be\u0997\u09c1\u09af\u09bc\u09be'),'bo':'*aa','br':'*aa','bs':'Nikaragva','ca':'*aa','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'Nikaragua','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f53\u0f72\u0f0b\u0f40\u0fb2\u0f0b\u0f5d\u0f0b\u0f42'),'ee':u('Nicaraguaduk\u0254'),'el':u('\u039d\u03b9\u03ba\u03b1\u03c1\u03ac\u03b3\u03bf\u03c5\u03b1'),'en':'*aa','eo':'Nikaragvo','es':'*aa','et':'*aa','eu':'*cs','fa':u('\u0646\u06cc\u06a9\u0627\u0631\u0627\u06af\u0648\u0626\u0647'),'ff':'Nikaraguwaa','fi':'*aa','fj':'*aa','fo':'*cs','fr':'*aa','fy':'*aa','ga':'Nicearagua','gd':'Niocaragua','gl':'*aa','gn':'*aa','gu':u('\u0aa8\u0abf\u0a95\u0abe\u0ab0\u0abe\u0a97\u0ac1\u0a86'),'gv':'*aa','ha':'Nikaraguwa','he':u('\u05e0\u05d9\u05e7\u05e8\u05d2\u05d5\u05d0\u05d4'),'hi':u('\u0928\u093f\u0915\u093e\u0930\u093e\u0917\u0941\u0906'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u0546\u056b\u056f\u0561\u0580\u0561\u0563\u0578\u0582\u0561'),'hz':'*aa','ia':'*aa','id':'*cs','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*cs','io':'*aa','is':u('N\u00edkaragva'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30cb\u30ab\u30e9\u30b0\u30a2'),'ji':u('\u05e0\u05d9\u05e7\u05d0\u05b7\u05e8\u05d0\u05b7\u05d2\u05d5\u05e2'),'jv':'*aa','ka':u('\u10dc\u10d8\u10d9\u10d0\u10e0\u10d0\u10d2\u10e3\u10d0'),'kg':'*aa','ki':'*bm','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1793\u17b8\u1780\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17b6'),'kn':u('\u0ca8\u0cbf\u0c95\u0cbe\u0cb0\u0cbe\u0c97\u0cc1\u0cb5\u0cbe'),'ko':u('\ub2c8\uce74\ub77c\uacfc'),'kr':'*aa','ks':u('\u0646\u0627\u06a9\u0627\u0631\u0627\u06af\u064f\u0648\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'*ha','li':'*aa','ln':'*bm','lo':u('\u0e99\u0eb4\u0e81\u0e84\u0eb2\u0ea3\u0eb2\u0e81\u0ebb\u0ea7'),'lt':'*bs','lu':'*bm','lv':'*bs','mg':u('Nikarago\u00e0'),'mh':'*aa','mi':'*aa','mk':u('\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0432\u0430'),'ml':u('\u0d28\u0d3f\u0d15\u0d4d\u0d15\u0d30\u0d3e\u0d17\u0d4d\u0d35'),'mn':'*bg','mo':'*aa','mr':u('\u0928\u093f\u0915\u093e\u0930\u093e\u0917\u094d\u0935\u093e'),'ms':'*aa','mt':'in-Nikaragwa','my':u('\u1014\u102e\u1000\u102c\u101b\u102c\u1002\u103d\u102b'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0928\u093f\u0915\u093e\u0930\u093e\u0917\u0941\u0935\u093e'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b28\u0b3f\u0b15\u0b3e\u0b30\u0b3e\u0b17\u0b41\u0b06'),'os':'*aa','pa':u('\u0a28\u0a3f\u0a15\u0a3e\u0a30\u0a3e\u0a17\u0a41\u0a06'),'pi':'*aa','pl':'*cs','ps':u('\u0646\u06a9\u0627\u0631\u0627\u06ab\u0648\u0627'),'pt':u('Nicar\u00e1gua'),'qu':'*aa','rm':'*aa','rn':'*bm','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0646\u06aa\u0631\u0627\u06af\u0648\u0627'),'se':'*aa','sg':'*cs','si':u('\u0db1\u0dd2\u0d9a\u0dbb\u0d9c\u0dd4\u0dc0\u0dcf\u0dc0'),'sk':'*cs','sl':'*bs','sm':'*aa','sn':'*aa','so':'Nikaraaguwa','sq':'*cs','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*bm','ta':u('\u0ba8\u0bbf\u0b95\u0bb0\u0b95\u0bc1\u0bb5\u0bbe'),'te':u('\u0c28\u0c3f\u0c15\u0c30\u0c3e\u0c17\u0c41\u0c35\u0c3e'),'tg':'*bg','th':u('\u0e19\u0e34\u0e01\u0e32\u0e23\u0e32\u0e01\u0e31\u0e27'),'ti':'*am','tk':'*cs','tl':'*aa','tn':'*aa','to':'Nikalakua','tr':'*cs','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0646\u0649\u0643\u0627\u0631\u0627\u06af\u06c7\u0626\u0627'),'uk':u('\u041d\u0456\u043a\u0430\u0440\u0430\u0491\u0443\u0430'),'ur':u('\u0646\u06a9\u0627\u0631\u0627\u06af\u0648\u0648\u0627'),'uz':'*cs','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*ha','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de NIkaragua'),'za':'*aa','zh':u('\u5c3c\u52a0\u62c9\u74dc'),'zu':'i-Nicaragua',},
  'NL': {'aa':'Netherlands','ab':'*aa','ae':'*aa','af':'Nederland','ak':u('N\u025bd\u025bland'),'am':u('\u1294\u12d8\u122d\u120b\u1295\u12f5'),'an':'*aa','ar':u('\u0647\u0648\u0644\u0646\u062f\u0627'),'as':u('\u09a8\u09c7\u09a1\u09be\u09f0\u09b2\u09c7\u09a3\u09cd\u09a1'),'av':'*aa','ay':'*aa','az':'Niderland','ba':'*aa','be':u('\u041d\u0456\u0434\u044d\u0440\u043b\u0430\u043d\u0434\u044b'),'bg':u('\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Peyiba','bn':u('\u09a8\u09c7\u09a6\u09be\u09b0\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1\u09b8'),'bo':'*aa','br':u('Izelvroio\u00f9'),'bs':'Holandija','ca':u('Pa\u00efsos Baixos'),'ce':u('\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0430\u0448'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Nizozemsko','cu':'*aa','cv':'*aa','cy':'Yr Iseldiroedd','da':'Holland','de':'Niederlande','dv':'*aa','dz':u('\u0f53\u0f7a\u0f0b\u0f51\u0f62\u0f0b\u0f63\u0f53\u0f4c\u0f66\u0f84'),'ee':'Netherlands nutome','el':u('\u039f\u03bb\u03bb\u03b1\u03bd\u03b4\u03af\u03b1'),'en':'*aa','eo':'Nederlando','es':u('Pa\u00edses Bajos'),'et':'*da','eu':'Herbehereak','fa':u('\u0647\u0644\u0646\u062f'),'ff':'Nederlannda','fi':'Alankomaat','fj':'*aa','fo':u('Ni\u00f0urlond'),'fr':'Pays-Bas','fy':u('Nederl\u00e2n'),'ga':u('an \u00cdsilt\u00edr'),'gd':u('Na T\u00ecrean \u00ccsle'),'gl':u('Pa\u00edses Baixos'),'gn':'*aa','gu':u('\u0aa8\u0ac7\u0aa7\u0ab0\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8'),'gv':'*aa','ha':'Holan','he':u('\u05d4\u05d5\u05dc\u05e0\u05d3'),'hi':u('\u0928\u0940\u0926\u0930\u0932\u0948\u0902\u0921'),'ho':'*aa','hr':'Nizozemska','ht':'*aa','hu':'Hollandia','hy':u('\u0546\u056b\u0564\u0565\u057c\u056c\u0561\u0576\u0564\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'Belanda','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*da','it':'Paesi Bassi','iu':'*aa','iw':'*he','ja':u('\u30aa\u30e9\u30f3\u30c0'),'ji':u('\u05d4\u05d0\u05dc\u05d0\u05b7\u05e0\u05d3'),'jv':'*aa','ka':u('\u10dc\u10d8\u10d3\u10d4\u10e0\u10da\u10d0\u10dc\u10d3\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'Uholanzi','kj':'*aa','kk':u('\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434'),'kl':'*aa','km':u('\u17a0\u17bc\u17a1\u1784\u17cb'),'kn':u('\u0ca8\u0cc6\u0ca6\u0cb0\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd\u0cb8\u0ccd'),'ko':u('\ub124\ub35c\ub780\ub4dc'),'kr':'*aa','ks':u('\u0646\u06cc\u0656\u062f\u064e\u0631\u0644\u06cc\u0646\u065b\u0691'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*da','lg':'Holandi','li':'*aa','ln':u('Oland\u025b'),'lo':u('\u0ec0\u0e99\u0ec0\u0e97\u0eb5\u0ec1\u0ea5\u0e99'),'lt':'Nyderlandai','lu':'*ln','lv':u('N\u012bderlande'),'mg':'Holanda','mh':'*aa','mi':'*aa','mk':u('\u0425\u043e\u043b\u0430\u043d\u0434\u0438\u0458\u0430'),'ml':u('\u0d28\u0d46\u0d24\u0d7c\u0d32\u0d3e\u0d7b\u0d21\u0d4d\u200c\u0d38\u0d4d'),'mn':'*kk','mo':u('\u021a\u0103rile de Jos'),'mr':u('\u0928\u0947\u0926\u0930\u0932\u0901\u0921'),'ms':'*id','mt':'in-Netherlands','my':u('\u1014\u101a\u103a\u101e\u102c\u101c\u1014\u103a'),'na':'*aa','nb':'*af','nd':'*aa','ne':u('\u0928\u0947\u0926\u0930\u0932\u094d\u092f\u093e\u0923\u094d\u0921'),'ng':'*aa','nl':'*af','nn':'*af','no':'*af','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b28\u0b47\u0b26\u0b30\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21'),'os':'*aa','pa':u('\u0a28\u0a40\u0a26\u0a30\u0a32\u0a48\u0a02\u0a21'),'pi':'*aa','pl':'Holandia','ps':u('\u0647\u0627\u0644\u06d0\u0646\u0689'),'pt':'*mg','qu':'*es','rm':'Pajais Bass','rn':'Ubuholandi','ro':'*mo','ru':u('\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u044b'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0646\u064a\u062f\u0631\u0644\u064a\u0646\u068a'),'se':'Vuolleeatnamat','sg':u('Hol\u00e4nde'),'si':u('\u0db1\u0dd9\u0daf\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba'),'sk':'Holandsko','sl':'*hr','sm':'*aa','sn':'*aa','so':'*aa','sq':u('Holand\u00eb'),'sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':u('Nederl\u00e4nderna'),'sw':'*ki','ta':u('\u0ba8\u0bc6\u0ba4\u0bb0\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1'),'te':u('\u0c28\u0c46\u0c26\u0c30\u0c4d\u0c32\u0c3e\u0c02\u0c21\u0c4d\u0c38\u0c4d'),'tg':'*bg','th':u('\u0e40\u0e19\u0e40\u0e18\u0e2d\u0e23\u0e4c\u0e41\u0e25\u0e19\u0e14\u0e4c'),'ti':u('\u1294\u12d8\u122d\u120b\u1295\u12f5\u1235'),'tk':u('Niderlandi\u00fda'),'tl':'*aa','tn':'*aa','to':u('H\u014dlani'),'tr':'Hollanda','ts':'*aa','tt':'*kk','tw':'*aa','ty':'*aa','ug':u('\u06af\u0648\u0644\u0644\u0627\u0646\u062f\u0649\u064a\u06d5'),'uk':u('\u041d\u0456\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0438'),'ur':u('\u0646\u06cc\u062f\u0631 \u0644\u06cc\u0646\u0688\u0632'),'uz':'Niderlandiya','ve':'*aa','vi':u('H\u00e0 Lan'),'vo':'*aa','wa':'*aa','wo':'Peyi Baa','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Nedalandi'),'za':'*aa','zh':u('\u8377\u5170'),'zu':'i-Netherlands',},
  'NO': {'aa':'Norway','ab':'*aa','ae':'*aa','af':u('Noorwe\u00eb'),'ak':u('N\u0254\u0254we'),'am':u('\u1296\u122d\u12cc\u12ed'),'an':'*aa','ar':u('\u0627\u0644\u0646\u0631\u0648\u064a\u062c'),'as':u('\u09a8\u09f0\u09f1\u09c7'),'av':'*aa','ay':'*aa','az':u('Norve\u00e7'),'ba':'*aa','be':u('\u041d\u0430\u0440\u0432\u0435\u0433\u0456\u044f'),'bg':u('\u041d\u043e\u0440\u0432\u0435\u0433\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':u('N\u0254riw\u025bzi'),'bn':u('\u09a8\u09b0\u0993\u09af\u09bc\u09c7'),'bo':'*aa','br':'Norvegia','bs':u('Norve\u0161ka'),'ca':'Noruega','ce':u('\u041d\u043e\u0440\u0432\u0435\u0433\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Norsko','cu':'*aa','cv':'*aa','cy':'Norwy','da':'Norge','de':'Norwegen','dv':'*aa','dz':u('\u0f53\u0f7c\u0f62\u0f0b\u0f5d\u0f7a'),'ee':'Norway nutome','el':u('\u039d\u03bf\u03c1\u03b2\u03b7\u03b3\u03af\u03b1'),'en':'*aa','eo':'Norvegujo','es':'*ca','et':'Norra','eu':'*br','fa':u('\u0646\u0631\u0648\u0698'),'ff':'Norwees','fi':'Norja','fj':'*aa','fo':'Noreg','fr':u('Norv\u00e8ge'),'fy':'Noarwegen','ga':'an Iorua','gd':'Nirribhidh','gl':'*ca','gn':'*aa','gu':u('\u0aa8\u0ac9\u0ab0\u0acd\u0ab5\u0ac7'),'gv':'*aa','ha':'Norwe','he':u('\u05e0\u05d5\u05e8\u05d5\u05d5\u05d2\u05d9\u05d4'),'hi':u('\u0928\u0949\u0930\u094d\u0935\u0947'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Norv\u00e9gia'),'hy':u('\u0546\u0578\u0580\u057e\u0565\u0563\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'Norwegia','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'Noregur','it':'*br','iu':'*aa','iw':'*he','ja':u('\u30ce\u30eb\u30a6\u30a7\u30fc'),'ji':u('\u05e0\u05d0\u05e8\u05d5\u05d5\u05e2\u05d2\u05d9\u05e2'),'jv':'*aa','ka':u('\u10dc\u10dd\u10e0\u10d5\u10d4\u10d2\u10d8\u10d0'),'kg':'*aa','ki':'*ha','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1793\u17d0\u179a\u179c\u17c2\u179f'),'kn':u('\u0ca8\u0cbe\u0cb0\u0ccd\u0cb5\u0cc6'),'ko':u('\ub178\ub974\uc6e8\uc774'),'kr':'*aa','ks':u('\u0646\u0627\u0631\u0648\u06d2'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*de','lg':'Nowe','li':'*aa','ln':u('Norivez\u025b'),'lo':u('\u0e99\u0ecd\u0ec0\u0ea7'),'lt':'Norvegija','lu':'Noriveje','lv':u('Norv\u0113\u0123ija'),'mg':u('N\u00f4rvezy'),'mh':'*aa','mi':'*aa','mk':u('\u041d\u043e\u0440\u0432\u0435\u0448\u043a\u0430'),'ml':u('\u0d28\u0d4b\u0d7c\u0d35\u0d46'),'mn':'*ce','mo':'*br','mr':'*hi','ms':'*aa','mt':u('in-Norve\u0121ja'),'my':u('\u1014\u1031\u102c\u103a\u101d\u1031'),'na':'*aa','nb':'*da','nd':'Noweyi','ne':u('\u0928\u0930\u094d\u0935\u0947'),'ng':'*aa','nl':'Noorwegen','nn':'*fo','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b28\u0b30\u0b71\u0b47'),'os':'*aa','pa':u('\u0a28\u0a3e\u0a30\u0a35\u0a47'),'pi':'*aa','pl':'*id','ps':u('\u0646\u0627\u0631\u0648\u06cd'),'pt':'*ca','qu':'*ca','rm':'*br','rn':'Noruveji','ro':'*br','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0646\u0627\u0631\u0648\u064a'),'se':'Norga','sg':u('N\u00f6rv\u00eazi'),'si':u('\u0db1\u0ddd\u0dbb\u0dca\u0dc0\u0dda'),'sk':u('N\u00f3rsko'),'sl':'*bs','sm':'*aa','sn':'*aa','so':'Noorweey','sq':'Norvegji','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':u('\u0ba8\u0bbe\u0bb0\u0bcd\u0bb5\u0bc7'),'te':u('\u0c28\u0c3e\u0c30\u0c4d\u0c35\u0c47'),'tg':'*bg','th':u('\u0e19\u0e2d\u0e23\u0e4c\u0e40\u0e27\u0e22\u0e4c'),'ti':u('\u1296\u122d\u12cc'),'tk':u('Norwegi\u00fda'),'tl':'*aa','tn':'*aa','to':u('Noau\u0113'),'tr':'*az','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0646\u0648\u0631\u06cb\u06d0\u06af\u0649\u064a\u06d5'),'uk':u('\u041d\u043e\u0440\u0432\u0435\u0491\u0456\u044f'),'ur':'*ks','uz':'Norvegiya','ve':'*aa','vi':'Na Uy','vo':'*aa','wa':'*aa','wo':'*ff','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de N\u1ecd\u1ecdwii'),'za':'*aa','zh':u('\u632a\u5a01'),'zu':'i-Norway',},
  'NP': {'aa':'Nepal','ab':'*aa','ae':'*aa','af':'*aa','ak':u('N\u025bp\u0254l'),'am':u('\u1294\u1353\u120d'),'an':'*aa','ar':u('\u0646\u064a\u0628\u0627\u0644'),'as':u('\u09a8\u09c7\u09aa\u09be\u09b2'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u041d\u0435\u043f\u0430\u043b'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'Nepali','bn':'*as','bo':u('\u0f56\u0f63\u0f0b\u0f61\u0f74\u0f63\u0f0b'),'br':'*aa','bs':'*aa','ca':'*aa','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':u('Nep\u00e1l'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f56\u0f63\u0f0b\u0f61\u0f74\u0f63'),'ee':'Nepal nutome','el':u('\u039d\u03b5\u03c0\u03ac\u03bb'),'en':'*aa','eo':'Nepalo','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0646\u067e\u0627\u0644'),'ff':'Nepaal','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('N\u00e9pal'),'fy':'*aa','ga':'Neipeal','gd':u('Neap\u00e0l'),'gl':'*aa','gn':'*aa','gu':u('\u0aa8\u0ac7\u0aaa\u0abe\u0ab3'),'gv':'*aa','ha':'Nefal','he':u('\u05e0\u05e4\u05d0\u05dc'),'hi':u('\u0928\u0947\u092a\u093e\u0932'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*cs','hy':u('\u0546\u0565\u057a\u0561\u056c'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30cd\u30d1\u30fc\u30eb'),'ji':u('\u05e0\u05e2\u05e4\u05bc\u05d0\u05b7\u05dc'),'jv':'*aa','ka':u('\u10dc\u10d4\u10de\u10d0\u10da\u10d8'),'kg':'*aa','ki':'*bm','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u1793\u17c1\u1794\u17c9\u17b6\u179b\u17cb'),'kn':u('\u0ca8\u0cc7\u0caa\u0cbe\u0cb3'),'ko':u('\ub124\ud314'),'kr':'*aa','ks':u('\u0646\u06cc\u067e\u0627\u0644'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*aa','lg':'*eo','li':'*aa','ln':u('Nep\u00e1l\u025b'),'lo':u('\u0ec0\u0e99\u0e9b\u0eb2\u0e99'),'lt':'Nepalas','lu':'*ln','lv':u('Nep\u0101la'),'mg':'Nepala','mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d28\u0d47\u0d2a\u0d4d\u0d2a\u0d3e\u0d7e'),'mn':u('\u0411\u0430\u043b\u0431\u0430'),'mo':'*aa','mr':u('\u0928\u0947\u092a\u093e\u0933'),'ms':'*aa','mt':'in-Nepal','my':u('\u1014\u102e\u1015\u1031\u102b'),'na':'*aa','nb':'*aa','nd':'Nephali','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b28\u0b47\u0b2a\u0b3e\u0b33'),'os':'*aa','pa':u('\u0a28\u0a47\u0a2a\u0a3e\u0a32'),'pi':'*aa','pl':'*aa','ps':'*ks','pt':'*aa','qu':'*aa','rm':'*aa','rn':'*bm','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0646\u064a\u067e\u0627\u0644'),'se':'*aa','sg':u('N\u00ebp\u00e2li'),'si':u('\u0db1\u0dda\u0db4\u0dcf\u0dbd\u0dba'),'sk':'*cs','sl':'*aa','sm':'*aa','sn':'*aa','so':'Nebaal','sq':'*aa','sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0ba8\u0bc7\u0baa\u0bbe\u0bb3\u0bae\u0bcd'),'te':u('\u0c28\u0c47\u0c2a\u0c3e\u0c32\u0c4d'),'tg':'*be','th':u('\u0e40\u0e19\u0e1b\u0e32\u0e25'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':'*bm','tr':'*aa','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u0646\u06d0\u067e\u0627\u0644'),'uk':'*be','ur':'*ks','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*ff','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Nepa'),'za':'*aa','zh':u('\u5c3c\u6cca\u5c14'),'zu':'i-Nepal',},
  'NR': {'aa':'Nauru','ab':'*aa','ae':'*aa','af':'*aa','ak':'Naworu','am':u('\u1293\u12a1\u1229'),'an':'*aa','ar':u('\u0646\u0627\u0648\u0631\u0648'),'as':u('\u09a8\u09be\u0989\u09f0\u09c1'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u041d\u0430\u0443\u0440\u0443'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'Nawuru','bn':u('\u09a8\u09be\u0989\u09b0\u09c1'),'bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f53\u0f60\u0f74\u0f0b\u0f62\u0f74\u0f0b'),'ee':'Nauru nutome','el':u('\u039d\u03b1\u03bf\u03c5\u03c1\u03bf\u03cd'),'en':'*aa','eo':'Nauro','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0646\u0627\u0626\u0648\u0631\u0648'),'ff':'*bm','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('N\u00e1r\u00fa'),'gd':'Nabhru','gl':'*aa','gn':'*aa','gu':u('\u0aa8\u0acc\u0ab0\u0ac1'),'gv':'*aa','ha':'*aa','he':u('\u05e0\u05d0\u05d5\u05e8\u05d5'),'hi':u('\u0928\u093e\u0909\u0930\u0941'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u0546\u0561\u0578\u0582\u0580\u0578\u0582'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*ga','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30ca\u30a6\u30eb'),'ji':'*aa','jv':'*aa','ka':u('\u10dc\u10d0\u10e3\u10e0\u10e3'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u178e\u17bc\u179a\u17bc'),'kn':u('\u0ca8\u0ccc\u0cb0\u0cc1'),'ko':u('\ub098\uc6b0\ub8e8'),'kr':'*aa','ks':u('\u0646\u0627\u0631\u0648\u0648\u0657'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*aa','lg':'*bm','li':'*aa','ln':'*aa','lo':u('\u0e99\u0eb2\u0ead\u0eb9\u0ea3\u0eb9'),'lt':'*aa','lu':'*aa','lv':'*aa','mg':u('Naor\u00f2'),'mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d28\u0d57\u0d31\u0d41'),'mn':'*be','mo':'*aa','mr':u('\u0928\u093e\u0909\u0930\u0942'),'ms':'*aa','mt':'*aa','my':u('\u1014\u1031\u102c\u103a\u101b\u1030\u1038'),'na':'*aa','nb':'*aa','nd':'*aa','ne':'*mr','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b28\u0b3e\u0b09\u0b30\u0b41'),'os':'*aa','pa':u('\u0a28\u0a3e\u0a09\u0a30\u0a42'),'pi':'*aa','pl':'*aa','ps':u('\u0646\u0627\u06cc\u0631\u0648'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'*bm','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*fa','se':'*aa','sg':'*aa','si':u('\u0db1\u0dcf\u0dc0\u0dd4\u0dbb\u0dd4'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0ba8\u0bcc\u0bb0\u0bc1'),'te':u('\u0c28\u0c4c\u0c30\u0c41'),'tg':'*be','th':u('\u0e19\u0e32\u0e2d\u0e39\u0e23\u0e39'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':'Naulu','tr':'*aa','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u0646\u0627\u06cb\u0631\u06c7'),'uk':'*be','ur':u('\u0646\u0624\u0631\u0648'),'uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Nawru','xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Nauru'),'za':'*aa','zh':u('\u7459\u9c81'),'zu':'i-Nauru',},
  'NU': {'aa':'Niue','ab':'*aa','ae':'*aa','af':'*aa','ak':'Niyu','am':u('\u1292\u12a1\u12ed'),'an':'*aa','ar':u('\u0646\u064a\u0648\u064a'),'as':u('\u09a8\u09bf\u0989'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u041d\u0456\u0443\u044d'),'bg':u('\u041d\u0438\u0443\u0435'),'bh':'*aa','bi':'*aa','bm':'Nyuwe','bn':u('\u09a8\u09bf\u0989\u09af\u09bc\u09c7'),'bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':u('\u041d\u0438\u0443\u044d'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f53\u0f72\u0f0b\u0f68\u0f74\u0f0b\u0f68\u0f7b'),'ee':'Niue nutome','el':u('\u039d\u03b9\u03bf\u03cd\u03b5'),'en':'*aa','eo':'Niuo','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0646\u06cc\u0648\u0626\u0647'),'ff':'Niuwe','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*aa','gn':'*aa','gu':u('\u0aa8\u0ac0\u0aaf\u0ac1'),'gv':'*aa','ha':'*ak','he':u('\u05e0\u05d9\u05d5\u05d5\u05d4'),'hi':u('\u0928\u0940\u092f\u0942'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u0546\u056b\u0578\u0582\u0565'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30cb\u30a6\u30a8'),'ji':'*aa','jv':'*aa','ka':u('\u10dc\u10d8\u10e3\u10d4'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u178e\u17c0'),'kn':u('\u0ca8\u0cbf\u0caf\u0cc1'),'ko':u('\ub2c8\uc6b0\uc5d0'),'kr':'*aa','ks':u('\u0646\u06cc\u0648\u0657'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*aa','lg':'Niyuwe','li':'*aa','ln':u('Nyu\u00e9'),'lo':u('\u0e99\u0eb5\u0ead\u0eb9\u0ec0\u0ead'),'lt':u('Niuj\u0117'),'lu':'Nyue','lv':'*aa','mg':u('Nio\u00e9'),'mh':'*aa','mi':'*aa','mk':u('\u041d\u0438\u0443\u0458\u0435'),'ml':u('\u0d28\u0d4d\u0d2f\u0d42\u0d2f\u0d3f'),'mn':'*ce','mo':'*aa','mr':'*hi','ms':'*aa','mt':'*aa','my':u('\u1014\u102e\u1025\u1030\u1021\u1031'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0928\u093f\u092f\u0941\u0907'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b28\u0b3f\u0b09'),'os':'*aa','pa':u('\u0a28\u0a3f\u0a2f\u0a42'),'pi':'*aa','pl':'*aa','ps':u('\u0646\u06cc\u0648\u0648'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'*lg','ro':'*aa','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0646\u0648\u0648\u064a'),'se':'*aa','sg':'*aa','si':u('\u0db1\u0dd2\u0dba\u0dd6'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0ba8\u0bbf\u0baf\u0bc2'),'te':u('\u0c28\u0c3f\u0c2f\u0c42'),'tg':'*ce','th':u('\u0e19\u0e35\u0e2d\u0e39\u0e40\u0e2d'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':u('Niu\u0113'),'tr':'*aa','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u0646\u064a\u06c7\u0626\u06d0'),'uk':u('\u041d\u0456\u0443\u0435'),'ur':u('\u0646\u06cc\u0626\u0648'),'uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Niw','xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Niue'),'za':'*aa','zh':u('\u7ebd\u57c3'),'zu':'i-Niue',},
  'NZ': {'aa':'New Zealand','ab':'*aa','ae':'*aa','af':'Nieu-Seeland','ak':'Ziland Foforo','am':u('\u1292\u12cd \u12da\u120b\u1295\u12f5'),'an':'*aa','ar':u('\u0646\u064a\u0648\u0632\u064a\u0644\u0646\u062f\u0627'),'as':u('\u09a8\u09bf\u0989\u099c\u09bf\u09b2\u09c7\u09a3\u09cd\u09a1'),'av':'*aa','ay':'*aa','az':'Yeni Zelandiya','ba':'*aa','be':u('\u041d\u043e\u0432\u0430\u044f \u0417\u0435\u043b\u0430\u043d\u0434\u044b\u044f'),'bg':u('\u041d\u043e\u0432\u0430 \u0417\u0435\u043b\u0430\u043d\u0434\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Zelandi Koura','bn':u('\u09a8\u09bf\u0989\u099c\u09bf\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1'),'bo':'*aa','br':'Zeland-Nevez','bs':'Novi Zeland','ca':'Nova Zelanda','ce':u('\u041a\u0435\u0440\u043b\u0430 \u0417\u0435\u043b\u0430\u043d\u0434\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Nov\u00fd Z\u00e9land'),'cu':'*aa','cv':'*aa','cy':'Seland Newydd','da':'*aa','de':'Neuseeland','dv':'*aa','dz':u('\u0f53\u0f72\u0f60\u0f74\u0f0b\u0f5b\u0f72\u0f0b\u0f63\u0f7a\u0f53\u0f4c'),'ee':'New Zealand nutome','el':u('\u039d\u03ad\u03b1 \u0396\u03b7\u03bb\u03b1\u03bd\u03b4\u03af\u03b1'),'en':'*aa','eo':'Nov-Zelando','es':'Nueva Zelanda','et':'Uus-Meremaa','eu':'Zeelanda Berria','fa':u('\u0646\u06cc\u0648\u0632\u06cc\u0644\u0646\u062f'),'ff':'Nuwel Selannda','fi':'Uusi-Seelanti','fj':'*aa','fo':u('N\u00fds\u00e6land'),'fr':u('Nouvelle-Z\u00e9lande'),'fy':u('Nij-Seel\u00e2n'),'ga':u('an Nua-Sh\u00e9alainn'),'gd':'Sealainn Nuadh','gl':'Nova Zelandia','gn':'*aa','gu':u('\u0aa8\u0acd\u0aaf\u0ac1\u0a9d\u0ac0\u0ab2\u0ac7\u0aa8\u0acd\u0aa1'),'gv':'*aa','ha':'Nuzilan','he':u('\u05e0\u05d9\u05d5 \u05d6\u05d9\u05dc\u05e0\u05d3'),'hi':u('\u0928\u094d\u092f\u0942\u091c\u093c\u0940\u0932\u0948\u0902\u0921'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('\u00daj-Z\u00e9land'),'hy':u('\u0546\u0578\u0580 \u0536\u0565\u056c\u0561\u0576\u0564\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'Selandia Baru','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('N\u00fdja-Sj\u00e1land'),'it':'Nuova Zelanda','iu':'*aa','iw':'*he','ja':u('\u30cb\u30e5\u30fc\u30b8\u30fc\u30e9\u30f3\u30c9'),'ji':u('\u05e0\u05d9\u05d5 \u05d6\u05d9\u05dc\u05d0\u05b7\u05e0\u05d3'),'jv':'*aa','ka':u('\u10d0\u10ee\u10d0\u10da\u10d8 \u10d6\u10d4\u10da\u10d0\u10dc\u10d3\u10d8\u10d0'),'kg':'*aa','ki':'Nyuzilandi','kj':'*aa','kk':u('\u0416\u0430\u04a3\u0430 \u0417\u0435\u043b\u0430\u043d\u0434\u0438\u044f'),'kl':'*aa','km':u('\u1793\u17bc\u179c\u17c2\u179b\u200b\u179f\u17c1\u17a1\u1784\u17cb'),'kn':u('\u0ca8\u0ccd\u0caf\u0cc2\u0c9c\u0cbf\u0cb2\u0cc6\u0c82\u0ca1\u0ccd'),'ko':u('\ub274\uc9c8\ub79c\ub4dc'),'kr':'*aa','ks':u('\u0646\u06cc\u0648\u0657\u0632\u0650\u0644\u06cc\u0646\u065b\u0691'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0416\u0430\u04ca\u044b \u0417\u0435\u043b\u0430\u043d\u0434\u0438\u044f'),'la':'*aa','lb':u('Neis\u00e9iland'),'lg':'Niyuziirandi','li':'*aa','ln':u('Zeland\u025b ya sika'),'lo':u('\u0e99\u0eb4\u0ea7\u0e8a\u0eb5\u0ec1\u0ea5\u0e99'),'lt':'Naujoji Zelandija','lu':'Zelanda wa mumu','lv':u('Jaunz\u0113lande'),'mg':'*fr','mh':'*aa','mi':'*aa','mk':u('\u041d\u043e\u0432 \u0417\u0435\u043b\u0430\u043d\u0434'),'ml':u('\u0d28\u0d4d\u0d2f\u0d42\u0d38\u0d3f\u0d32\u0d3e\u0d7b\u0d31\u0d4d'),'mn':u('\u0428\u0438\u043d\u044d \u0417\u0435\u043b\u0430\u043d\u0434'),'mo':u('Noua Zeeland\u0103'),'mr':u('\u0928\u094d\u092f\u0942\u091d\u0940\u0932\u0902\u0921'),'ms':'*aa','mt':'*aa','my':u('\u1014\u101a\u1030\u1038\u1007\u102e\u101c\u1014\u103a'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0928\u094d\u092f\u0941\u091c\u093f\u0932\u094d\u092f\u093e\u0923\u094d\u0921'),'ng':'*aa','nl':'Nieuw-Zeeland','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b28\u0b4d\u0b5f\u0b41\u0b1c\u0b3f\u0b32\u0b3e\u0b23\u0b4d\u0b21'),'os':'*aa','pa':u('\u0a28\u0a3f\u0a0a\u0a1c\u0a3c\u0a40\u0a32\u0a48\u0a02\u0a21'),'pi':'*aa','pl':'Nowa Zelandia','ps':u('\u0646\u06cc\u0648\u0632\u06cc\u0644\u0646\u0689'),'pt':u('Nova Zel\u00e2ndia'),'qu':'*aa','rm':'*ca','rn':'Nuvelizelandi','ro':'*mo','ru':u('\u041d\u043e\u0432\u0430\u044f \u0417\u0435\u043b\u0430\u043d\u0434\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0646\u064a\u0648 \u0632\u064a\u0644\u064a\u0646\u068a'),'se':u('O\u0111\u0111a-Sel\u00e1nda'),'sg':u('Fin\u00ee Zel\u00e2nde'),'si':u('\u0db1\u0dc0\u0dc3\u0dd3\u0dbd\u0db1\u0dca\u0dad\u0dba'),'sk':'*cs','sl':'Nova Zelandija','sm':'*aa','sn':'*aa','so':'Neyuusilaand','sq':u('Zeland\u00eb e Re'),'sr':u('\u041d\u043e\u0432\u0438 \u0417\u0435\u043b\u0430\u043d\u0434'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Nya Zeeland','sw':'*ki','ta':u('\u0ba8\u0bbf\u0baf\u0bc2\u0b9a\u0bbf\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1'),'te':u('\u0c28\u0c4d\u0c2f\u0c42\u0c1c\u0c3f\u0c32\u0c3e\u0c02\u0c21\u0c4d'),'tg':u('\u0417\u0435\u043b\u0430\u043d\u0434\u0438\u044f\u0438 \u041d\u0430\u0432'),'th':u('\u0e19\u0e34\u0e27\u0e0b\u0e35\u0e41\u0e25\u0e19\u0e14\u0e4c'),'ti':'*am','tk':u('T\u00e4ze Zelandi\u00fda'),'tl':'*aa','tn':'*aa','to':u('Nu\u02bbusila'),'tr':'Yeni Zelanda','ts':'*aa','tt':u('\u042f\u04a3\u0430 \u0417\u0435\u043b\u0430\u043d\u0434\u0438\u044f'),'tw':'*aa','ty':'*aa','ug':u('\u064a\u06d0\u06ad\u0649 \u0632\u06d0\u0644\u0627\u0646\u062f\u0649\u064a\u06d5'),'uk':u('\u041d\u043e\u0432\u0430 \u0417\u0435\u043b\u0430\u043d\u0434\u0456\u044f'),'ur':u('\u0646\u06cc\u0648\u0632\u06cc \u0644\u06cc\u0646\u0688'),'uz':'Yangi Zelandiya','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':u('Nuwel Sel\u00e0nd'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de \u1e63ilandi Titun'),'za':'*aa','zh':u('\u65b0\u897f\u5170'),'zu':'i-New Zealand',},
  'OM': {'aa':'Oman','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u12a6\u121b\u1295'),'an':'*aa','ar':u('\u0639\u064f\u0645\u0627\u0646'),'as':u('\u0993\u09ae\u09be\u09a8'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u0410\u043c\u0430\u043d'),'bg':u('\u041e\u043c\u0430\u043d'),'bh':'*aa','bi':'*aa','bm':u('Oma\u014b'),'bn':'*as','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':u('\u04c0\u043e\u043c\u0430\u043d'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Om\u00e1n'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f68\u0f7c\u0f0b\u0f58\u0f71\u0f53'),'ee':'Oman nutome','el':u('\u039f\u03bc\u03ac\u03bd'),'en':'*aa','eo':'Omano','es':'*cs','et':'Omaan','eu':'*aa','fa':u('\u0639\u0645\u0627\u0646'),'ff':'*et','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('\u00d3man'),'gd':u('Om\u00e0n'),'gl':'*cs','gn':'*aa','gu':u('\u0a93\u0aae\u0abe\u0aa8'),'gv':'*aa','ha':'*aa','he':u('\u05e2\u05d5\u05de\u05d0\u05df'),'hi':u('\u0913\u092e\u093e\u0928'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*cs','hy':u('\u0555\u0574\u0561\u0576'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*ga','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30aa\u30de\u30fc\u30f3'),'ji':'*aa','jv':'*aa','ka':u('\u10dd\u10db\u10d0\u10dc\u10d8'),'kg':'*aa','ki':'Omani','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u17a2\u17bc\u1798\u17c9\u1784\u17cb'),'kn':u('\u0c93\u0cae\u0ca8\u0ccd'),'ko':u('\uc624\ub9cc'),'kr':'*aa','ks':u('\u0627\u0648\u0645\u0627\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'Omaani','li':'*aa','ln':u('Om\u00e1n\u025b'),'lo':u('\u0ec2\u0ead\u0ea1\u0eb2\u0e99'),'lt':'Omanas','lu':'Omane','lv':u('Om\u0101na'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d12\u0d2e\u0d3e\u0d7b'),'mn':'*bg','mo':'*aa','mr':'*hi','ms':'*aa','mt':'l-Oman','my':u('\u1021\u102d\u102f\u1019\u1014\u103a'),'na':'*aa','nb':'*aa','nd':'*ki','ne':u('\u0913\u092e\u0928'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b13\u0b2e\u0b3e\u0b28\u0b4d'),'os':'*aa','pa':u('\u0a13\u0a2e\u0a3e\u0a28'),'pi':'*aa','pl':'*aa','ps':'*fa','pt':u('Om\u00e3'),'qu':'*cs','rm':'*aa','rn':'*ki','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*fa','se':'*aa','sg':u('Om\u00e2ni'),'si':u('\u0d95\u0db8\u0dcf\u0db1\u0dba'),'sk':'*cs','sl':'*aa','sm':'*aa','sn':'*aa','so':'Cumaan','sq':'*aa','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b93\u0bae\u0ba9\u0bcd'),'te':u('\u0c12\u0c2e\u0c28\u0c4d'),'tg':u('\u0423\u043c\u043e\u043d'),'th':u('\u0e42\u0e2d\u0e21\u0e32\u0e19'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':u('\u02bbOmani'),'tr':'Umman','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0626\u0648\u0645\u0627\u0646'),'uk':'*bg','ur':'*fa','uz':'Ummon','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*et','xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de \u1ecc\u1ecdma'),'za':'*aa','zh':u('\u963f\u66fc'),'zu':'i-Oman',},
  'PA': {'aa':'Panama','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u1353\u1293\u121b'),'an':'*aa','ar':u('\u0628\u0646\u0645\u0627'),'as':u('\u09aa\u09be\u09a8\u09be\u09ae\u09be'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u041f\u0430\u043d\u0430\u043c\u0430'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'*aa','bn':'*as','bo':'*aa','br':u('Panam\u00e1'),'bs':'*aa','ca':u('Panam\u00e0'),'ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f54\u0f0b\u0f53\u0f0b\u0f58'),'ee':'Panama nutome','el':u('\u03a0\u03b1\u03bd\u03b1\u03bc\u03ac\u03c2'),'en':'*aa','eo':'Panamo','es':'*br','et':'*aa','eu':'*aa','fa':u('\u067e\u0627\u0646\u0627\u0645\u0627'),'ff':'Panamaa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':'*aa','gd':'*aa','gl':'*br','gn':'*aa','gu':u('\u0aaa\u0aa8\u0abe\u0aae\u0abe'),'gv':'*aa','ha':'*aa','he':u('\u05e4\u05e0\u05de\u05d4'),'hi':u('\u092a\u0928\u093e\u092e\u093e'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u054a\u0561\u0576\u0561\u0574\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*br','iu':'*aa','iw':'*he','ja':u('\u30d1\u30ca\u30de'),'ji':u('\u05e4\u05bc\u05d0\u05b7\u05e0\u05d0\u05b7\u05de\u05d0\u05b7'),'jv':'*aa','ka':u('\u10de\u10d0\u10dc\u10d0\u10db\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u1794\u17c9\u17b6\u178e\u17b6\u1798\u17c9\u17b6'),'kn':u('\u0caa\u0ca8\u0cbe\u0cae\u0cbe'),'ko':u('\ud30c\ub098\ub9c8'),'kr':'*aa','ks':u('\u067e\u064e\u0646\u0627\u0645\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0e9e\u0eb2\u0e99\u0eb2\u0ea1\u0eb2'),'lt':'*aa','lu':'*aa','lv':'*aa','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d2a\u0d28\u0d3e\u0d2e'),'mn':u('\u041f\u0430\u043d\u0430\u043c'),'mo':'*aa','mr':'*hi','ms':'*aa','mt':'il-Panama','my':u('\u1015\u1014\u102c\u1038\u1019\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u092a\u094d\u092f\u093e\u0928\u093e\u092e\u093e'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2a\u0b3e\u0b28\u0b3e\u0b2e\u0b3e'),'os':'*aa','pa':u('\u0a2a\u0a28\u0a3e\u0a2e\u0a3e'),'pi':'*aa','pl':'*aa','ps':'*fa','pt':'*br','qu':'*br','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u067e\u0646\u0627\u0645\u0627'),'se':'*aa','sg':'*aa','si':u('\u0db4\u0dd0\u0db1\u0db8\u0dcf\u0dc0'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0baa\u0ba9\u0bbe\u0bae\u0bbe'),'te':u('\u0c2a\u0c28\u0c3e\u0c2e\u0c3e'),'tg':'*be','th':u('\u0e1b\u0e32\u0e19\u0e32\u0e21\u0e32'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':u('Panam\u0101'),'tr':'*aa','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':'*fa','uk':'*be','ur':u('\u067e\u0627\u0646\u0627\u0645\u06c1'),'uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Panama'),'za':'*aa','zh':u('\u5df4\u62ff\u9a6c'),'zu':'i-Panama',},
  'PE': {'aa':'Peru','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u1354\u1229'),'an':'*aa','ar':u('\u0628\u064a\u0631\u0648'),'as':u('\u09aa\u09c7\u09f0\u09c1'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u041f\u0435\u0440\u0443'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u09aa\u09c7\u09b0\u09c1'),'bo':'*aa','br':'Perou','bs':'*aa','ca':u('Per\u00fa'),'ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'Periw','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f54\u0f7a\u0f0b\u0f62\u0f74'),'ee':'Peru nutome','el':u('\u03a0\u03b5\u03c1\u03bf\u03cd'),'en':'*aa','eo':'Peruo','es':'*ca','et':'Peruu','eu':'*aa','fa':u('\u067e\u0631\u0648'),'ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('P\u00e9rou'),'fy':'*aa','ga':u('Peiri\u00fa'),'gd':u('Pear\u00f9'),'gl':'*ca','gn':'*aa','gu':u('\u0aaa\u0ac7\u0ab0\u0ac1'),'gv':'*aa','ha':'*aa','he':u('\u05e4\u05e8\u05d5'),'hi':u('\u092a\u0947\u0930\u0942'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u054a\u0565\u0580\u0578\u0582'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*ca','it':u('Per\u00f9'),'iu':'*aa','iw':'*he','ja':u('\u30da\u30eb\u30fc'),'ji':u('\u05e4\u05bc\u05e2\u05e8\u05d5'),'jv':'*aa','ka':u('\u10de\u10d4\u10e0\u10e3'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u1794\u17c9\u17c1\u179a\u17bc'),'kn':u('\u0caa\u0cc6\u0cb0\u0cc1'),'ko':u('\ud398\ub8e8'),'kr':'*aa','ks':u('\u067e\u06cc\u0656\u0631\u0648\u0657'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*aa','lg':'*aa','li':'*aa','ln':u('P\u00e9ru'),'lo':u('\u0ec0\u0e9b\u0ea3\u0eb9'),'lt':'*aa','lu':'*aa','lv':'*aa','mg':'Peroa','mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d2a\u0d46\u0d31\u0d41'),'mn':'*be','mo':'*aa','mr':'*hi','ms':'*aa','mt':u('il-Per\u00f9'),'my':u('\u1015\u102e\u101b\u1030\u1038'),'na':'*aa','nb':'*aa','nd':'Pheru','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2a\u0b47\u0b30\u0b41'),'os':'*aa','pa':u('\u0a2a\u0a47\u0a30\u0a42'),'pi':'*aa','pl':'*aa','ps':u('\u067e\u06cc\u0631\u0648'),'pt':'*aa','qu':'*ca','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u067e\u064a\u0631\u0648'),'se':'*aa','sg':u('Per\u00fcu'),'si':u('\u0db4\u0dda\u0dbb\u0dd4'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0baa\u0bc6\u0bb0\u0bc1'),'te':u('\u0c2a\u0c46\u0c30\u0c42'),'tg':'*be','th':u('\u0e40\u0e1b\u0e23\u0e39'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':u('Pel\u016b'),'tr':'*aa','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u067e\u06d0\u0631\u06c7'),'uk':'*be','ur':'*ps','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Peru'),'za':'*aa','zh':u('\u79d8\u9c81'),'zu':'i-Peru',},
  'PF': {'aa':'French Polynesia','ab':'*aa','ae':'*aa','af':u('Frans-Polinesi\u00eb'),'ak':u('Fr\u025bnkye P\u0254lenehyia'),'am':u('\u12e8\u1348\u1228\u1295\u1233\u12ed \u1356\u120a\u1294\u12e2\u12eb'),'an':'*aa','ar':u('\u0628\u0648\u0644\u064a\u0646\u064a\u0632\u064a\u0627 \u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629'),'as':u('\u09ab\u09cd\u09f0\u09be\u09a8\u09cd\u09b8 \u09aa\u09cb\u09b2\u09c7\u09a8\u099a\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':u('Fransa Polineziyas\u0131'),'ba':'*aa','be':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f \u041f\u0430\u043b\u0456\u043d\u0435\u0437\u0456\u044f'),'bg':u('\u0424\u0440\u0435\u043d\u0441\u043a\u0430 \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Faransi ka polinezi','bn':u('\u09ab\u09b0\u09be\u09b8\u09c0 \u09aa\u09b2\u09bf\u09a8\u09c7\u09b6\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':u('Polinezia C\u02bchall'),'bs':'Francuska Polinezija','ca':u('Polin\u00e8sia Francesa'),'ce':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0438\u0439\u043d \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Francouzsk\u00e1 Polyn\u00e9sie'),'cu':'*aa','cv':'*aa','cy':'Polynesia Ffrengig','da':'Fransk Polynesien','de':u('Franz\u00f6sisch-Polynesien'),'dv':'*aa','dz':u('\u0f55\u0fb2\u0f71\u0f53\u0f66\u0f84\u0f0b\u0f40\u0fb1\u0f72\u0f0b\u0f54\u0f7c\u0f0b\u0f63\u0f72\u0f0b\u0f53\u0f72\u0f0b\u0f64\u0f72\u0f0b\u0f61'),'ee':u('Frentsi P\u0254linesia nutome'),'el':u('\u0393\u03b1\u03bb\u03bb\u03b9\u03ba\u03ae \u03a0\u03bf\u03bb\u03c5\u03bd\u03b7\u03c3\u03af\u03b1'),'en':'*aa','eo':'Franca Polinezio','es':'Polinesia Francesa','et':u('Prantsuse Pol\u00fcneesia'),'eu':'Polinesia Frantsesa','fa':u('\u067e\u0644\u06cc\u200c\u0646\u0632\u06cc \u0641\u0631\u0627\u0646\u0633\u0647'),'ff':'Polinesii Farayse','fi':'Ranskan Polynesia','fj':'*aa','fo':'Franska Polynesia','fr':u('Polyn\u00e9sie fran\u00e7aise'),'fy':u('Frans-Polynesi\u00eb'),'ga':u('Polain\u00e9is na Fraince'),'gd':u('Poilin\u00e8is na Frainge'),'gl':'*es','gn':'*aa','gu':u('\u0aab\u0acd\u0ab0\u0ac7\u0a82\u0a9a \u0aaa\u0acb\u0ab2\u0abf\u0aa8\u0ac7\u0ab6\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Folinesiya Ta Faransa','he':u('\u05e4\u05d5\u05dc\u05d9\u05e0\u05d6\u05d9\u05d4 \u05d4\u05e6\u05e8\u05e4\u05ea\u05d9\u05ea'),'hi':u('\u092b\u093c\u094d\u0930\u0947\u0902\u091a \u092a\u094b\u0932\u093f\u0928\u0947\u0936\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Francia Polin\u00e9zia'),'hy':u('\u0556\u0580\u0561\u0576\u057d\u056b\u0561\u056f\u0561\u0576 \u054a\u0578\u056c\u056b\u0576\u0565\u0566\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'Polinesia Prancis','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Franska P\u00f3l\u00fdnes\u00eda'),'it':'Polinesia francese','iu':'*aa','iw':'*he','ja':u('\u4ecf\u9818\u30dd\u30ea\u30cd\u30b7\u30a2'),'ji':u('\u05e4\u05bf\u05e8\u05d0\u05b7\u05e0\u05e6\u05d5\u05d9\u05d6\u05d9\u05e9\u05e2 \u05e4\u05bc\u05d0\u05dc\u05d9\u05e0\u05e2\u05d6\u05d9\u05e2'),'jv':'*aa','ka':u('\u10e1\u10d0\u10e4\u10e0\u10d0\u10dc\u10d2\u10d4\u10d7\u10d8\u10e1 \u10de\u10dd\u10da\u10d8\u10dc\u10d4\u10d6\u10d8\u10d0'),'kg':'*aa','ki':'Polinesia ya Ufaransa','kj':'*aa','kk':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0437 \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u044f\u0441\u044b'),'kl':'*aa','km':u('\u1794\u17c9\u17bc\u179b\u17b8\u200b\u178e\u17c1\u179f\u17ca\u17b8\u200b\u1794\u17b6\u179a\u17b6\u17c6\u1784'),'kn':u('\u0cab\u0ccd\u0cb0\u0cc6\u0c82\u0c9a\u0ccd \u0caa\u0cbe\u0cb2\u0cbf\u0ca8\u0cc7\u0cb7\u0ccd\u0caf\u0cbe'),'ko':u('\ud504\ub791\uc2a4\ub839 \ud3f4\ub9ac\ub124\uc2dc\uc544'),'kr':'*aa','ks':u('\u0641\u0631\u065b\u0627\u0646\u0633\u06cc \u067e\u0648\u0644\u0650\u0646\u06cc\u0634\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u044f (\u0444\u0440\u0430\u043d\u0446\u0438\u044f\u043b\u044b\u043a)'),'la':'*aa','lb':u('Frans\u00e9isch-Polynesien'),'lg':'Polinesiya enfalansa','li':'*aa','ln':u('Polinezi ya Fal\u00e1ns\u025b'),'lo':u('\u0ec0\u0e9f\u0ea3\u0e99\u0e8a\u0ecc \u0ec2\u0e9e\u0ea5\u0eb4\u0e99\u0eb5\u0ec0\u0e8a\u0e8d'),'lt':u('Pranc\u016bzijos Polinezija'),'lu':'Polinezi wa Nfalanse','lv':u('Francijas Polin\u0113zija'),'mg':'Polynezia frantsay','mh':'*aa','mi':'*aa','mk':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0430 \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u0458\u0430'),'ml':u('\u0d2b\u0d4d\u0d30\u0d1e\u0d4d\u0d1a\u0d4d \u0d2a\u0d4b\u0d33\u0d3f\u0d28\u0d47\u0d37\u0d4d\u0d2f'),'mn':u('\u0424\u0440\u0430\u043d\u0446\u044b\u043d \u041f\u043e\u043b\u0438\u043d\u0435\u0437'),'mo':u('Polinezia Francez\u0103'),'mr':u('\u092b\u094d\u0930\u0947\u0902\u091a \u092a\u0949\u0932\u093f\u0928\u0947\u0936\u093f\u092f\u093e'),'ms':'Polinesia Perancis','mt':u('Poline\u017cja Fran\u010bi\u017ca'),'my':u('\u1015\u103c\u1004\u103a\u101e\u1005\u103a \u1015\u1031\u102b\u103a\u101c\u102e\u1014\u102e\u1038\u101b\u103e\u102c\u1038'),'na':'*aa','nb':'Fransk Polynesia','nd':'Pholinesiya ye Fulansi','ne':u('\u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0947\u0932\u0940 \u092a\u094b\u0932\u093f\u0928\u0947\u0938\u093f\u092f\u093e'),'ng':'*aa','nl':'*fy','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2b\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a \u0b2a\u0b32\u0b3f\u0b28\u0b47\u0b38\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a2b\u0a30\u0a48\u0a02\u0a1a \u0a2a\u0a4b\u0a32\u0a40\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06'),'pi':'*aa','pl':'Polinezja Francuska','ps':u('\u0641\u0631\u0627\u0646\u0633\u0648\u064a \u067e\u0648\u0644\u06cc\u0646\u06cc\u0627'),'pt':u('Polin\u00e9sia Francesa'),'qu':'*es','rm':'Polinesia Franzosa','rn':u('Polineziya y\u2019Abafaransa'),'ro':'*mo','ru':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0641\u0631\u0627\u0646\u0633\u064a\u0633\u064a \u067e\u0648\u0644\u064a\u0646\u064a\u0634\u064a\u0627'),'se':'Frankriikka Polynesia','sg':u('Polinez\u00efi t\u00ee far\u00e2nzi'),'si':u('\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1 \u0db4\u0ddc\u0dbd\u0dd2\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0'),'sk':u('Franc\u00fazska Polyn\u00e9zia'),'sl':'Francoska Polinezija','sm':'*aa','sn':'*aa','so':'*aa','sq':'Polinezia Franceze','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'Franska Polynesien','sw':'Polynesia ya Ufaransa','ta':u('\u0baa\u0bbf\u0bb0\u0bc6\u0b9e\u0bcd\u0b9a\u0bc1 \u0baa\u0bbe\u0bb2\u0bbf\u0ba9\u0bc7\u0bb7\u0bbf\u0baf\u0bbe'),'te':u('\u0c2b\u0c4d\u0c30\u0c46\u0c02\u0c1a\u0c4d \u0c2a\u0c4b\u0c32\u0c3f\u0c28\u0c40\u0c37\u0c3f\u0c2f\u0c3e'),'tg':u('\u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u044f\u0438 \u0424\u0430\u0440\u043e\u043d\u0441\u0430'),'th':u('\u0e40\u0e1f\u0e23\u0e19\u0e0a\u0e4c\u0e42\u0e1b\u0e25\u0e34\u0e19\u0e35\u0e40\u0e0b\u0e35\u0e22'),'ti':u('\u1293\u12ed \u1348\u1228\u1295\u1233\u12ed \u1356\u120a\u1290\u12dd\u12eb'),'tk':u('Fransuz Polinezi\u00fdasy'),'tl':'*aa','tn':'*aa','to':u('Polinisia fakafalanis\u0113'),'tr':u('Frans\u0131z Polinezyas\u0131'),'ts':'*aa','tt':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0437 \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u044f\u0441\u0435'),'tw':'*aa','ty':'*aa','ug':u('\u0641\u0649\u0631\u0627\u0646\u0633\u0649\u064a\u06d5\u06af\u06d5 \u0642\u0627\u0631\u0627\u0634\u0644\u0649\u0642 \u067e\u0648\u0644\u0649\u0646\u06d0\u0632\u0649\u064a\u06d5'),'uk':u('\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u044c\u043a\u0430 \u041f\u043e\u043b\u0456\u043d\u0435\u0437\u0456\u044f'),'ur':u('\u0641\u0631\u0627\u0646\u0633\u06cc\u0633\u06cc \u067e\u0648\u0644\u06cc\u0646\u06cc\u0634\u06cc\u0627'),'uz':'Fransuz Polineziyasi','ve':'*aa','vi':u('Polynesia thu\u1ed9c Ph\u00e1p'),'vo':'*aa','wa':'*aa','wo':u('Polinesi Fara\u00f1se'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Firen\u1e63i Polinesia'),'za':'*aa','zh':u('\u6cd5\u5c5e\u6ce2\u5229\u5c3c\u897f\u4e9a'),'zu':'i-French Polynesia',},
  'PG': {'aa':'Papua New Guinea','ab':'*aa','ae':'*aa','af':'Papoea-Nieu-Guinee','ak':'Papua Guinea Foforo','am':u('\u1353\u1351\u12cb \u1292\u12cd \u130a\u1292'),'an':'*aa','ar':u('\u0628\u0627\u0628\u0648\u0627 \u063a\u064a\u0646\u064a\u0627 \u0627\u0644\u062c\u062f\u064a\u062f\u0629'),'as':u('\u09aa\u09be\u09aa\u09c1\u09f1\u09be \u09a8\u09bf\u0989 \u0997\u09bf\u09a8\u09bf'),'av':'*aa','ay':'*aa','az':'Papua-Yeni Qvineya','ba':'*aa','be':u('\u041f\u0430\u043f\u0443\u0430-\u041d\u043e\u0432\u0430\u044f \u0413\u0432\u0456\u043d\u0435\u044f'),'bg':u('\u041f\u0430\u043f\u0443\u0430-\u041d\u043e\u0432\u0430 \u0413\u0432\u0438\u043d\u0435\u044f'),'bh':'*aa','bi':'*aa','bm':'Papuwasi-Gine-Koura','bn':u('\u09aa\u09be\u09aa\u09c1\u09af\u09bc\u09be \u09a8\u09bf\u0989 \u0997\u09bf\u09a8\u09bf'),'bo':'*aa','br':'Papoua Ginea-Nevez','bs':'Papua Nova Gvineja','ca':'Papua Nova Guinea','ce':u('\u041f\u0430\u043f\u0443\u0430 \u2014 \u041a\u0435\u0440\u043b\u0430 \u0413\u0432\u0438\u043d\u0435\u0439'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Papua-Nov\u00e1 Guinea'),'cu':'*aa','cv':'*aa','cy':'Papua Guinea Newydd','da':'Papua Ny Guinea','de':'Papua-Neuguinea','dv':'*aa','dz':u('\u0f54\u0f0b\u0f54\u0f74\u0f0b \u0f53\u0f72\u0f60\u0f74\u0f0b\u0f42\u0f72\u0f0b\u0f53\u0f72'),'ee':'Papua New Gini nutome','el':u('\u03a0\u03b1\u03c0\u03bf\u03cd\u03b1 \u039d\u03ad\u03b1 \u0393\u03bf\u03c5\u03b9\u03bd\u03ad\u03b1'),'en':'*aa','eo':'Papuo-Nov-Gvineo','es':u('Pap\u00faa Nueva Guinea'),'et':'Paapua Uus-Guinea','eu':'Papua Ginea Berria','fa':u('\u067e\u0627\u067e\u0648\u0627 \u06af\u06cc\u0646\u0647\u0654 \u0646\u0648'),'ff':'Papuwaa Nuwel Gine','fi':'Papua-Uusi-Guinea','fj':'*aa','fo':u('Papua N\u00fdguinea'),'fr':u('Papouasie-Nouvelle-Guin\u00e9e'),'fy':'Papoea-Nij-Guinea','ga':'Nua-Ghuine Phapua','gd':'Gini Nuadh Phaputhach','gl':u('Pap\u00faa-Nova Guinea'),'gn':'*aa','gu':u('\u0aaa\u0abe\u0aaa\u0ac1\u0a86 \u0aa8\u0acd\u0aaf\u0ac2 \u0a97\u0abf\u0aa8\u0ac0'),'gv':'*aa','ha':'Papuwa Nugini','he':u('\u05e4\u05e4\u05d5\u05d0\u05d4 \u05d2\u05d9\u05e0\u05d0\u05d4 \u05d4\u05d7\u05d3\u05e9\u05d4'),'hi':u('\u092a\u093e\u092a\u0941\u0906 \u0928\u094d\u092f\u0942 \u0917\u093f\u0928\u0940'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('P\u00e1pua \u00daj-Guinea'),'hy':u('\u054a\u0561\u057a\u0578\u0582\u0561 \u0546\u0578\u0580 \u0533\u057e\u056b\u0576\u0565\u0561'),'hz':'*aa','ia':'*aa','id':'Papua Nugini','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Pap\u00faa N\u00fdja-G\u00ednea'),'it':'Papua Nuova Guinea','iu':'*aa','iw':'*he','ja':u('\u30d1\u30d7\u30a2\u30cb\u30e5\u30fc\u30ae\u30cb\u30a2'),'ji':u('\u05e4\u05bc\u05d0\u05b7\u05e4\u05bc\u05d5\u05d0\u05b7 \u05e0\u05f2\u05b7 \u05d2\u05d9\u05e0\u05e2'),'jv':'*aa','ka':u('\u10de\u10d0\u10de\u10e3\u10d0-\u10d0\u10ee\u10d0\u10da\u10d8 \u10d2\u10d5\u10d8\u10dc\u10d4\u10d0'),'kg':'*aa','ki':'Papua','kj':'*aa','kk':u('\u041f\u0430\u043f\u0443\u0430 \u2014 \u0416\u0430\u04a3\u0430 \u0413\u0432\u0438\u043d\u0435\u044f'),'kl':'*aa','km':u('\u1794\u17c9\u17b6\u1796\u17bc\u17a2\u17b6\u179f\u17ca\u17b8\u200b\u1793\u17bc\u179c\u17c2\u179b\u17a0\u17d2\u1782\u17b8\u178e\u17c1'),'kn':u('\u0caa\u0caa\u0cc1\u0cb5\u0cbe \u0ca8\u0ccd\u0caf\u0cc2\u0c97\u0cbf\u0ca8\u0cbf\u0caf\u0cbe'),'ko':u('\ud30c\ud478\uc544\ub274\uae30\ub2c8'),'kr':'*aa','ks':u('\u067e\u0627\u067e\u064f\u0648\u0627 \u0646\u06cc\u0648\u0657 \u06af\u06cc\u0656\u0646\u06cc'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u041f\u0430\u043f\u0443\u0430-\u0416\u0430\u04a3\u044b \u0413\u0432\u0438\u043d\u0435\u044f'),'la':'*aa','lb':'Papua-Neiguinea','lg':'Papwa Nyugini','li':'*aa','ln':u('Papwazi Gin\u025b ya sika'),'lo':u('\u0e9b\u0eb2\u0e9b\u0ebb\u0ea7\u0e99\u0eb4\u0ea7\u0e81\u0eb5\u0e99\u0eb5'),'lt':u('Papua Naujoji Gvin\u0117ja'),'lu':u('Papwazi wa Ngin\u025b wa mumu'),'lv':'Papua-Jaungvineja','mg':'*fr','mh':'*aa','mi':'*aa','mk':u('\u041f\u0430\u043f\u0443\u0430 \u041d\u043e\u0432\u0430 \u0413\u0432\u0438\u043d\u0435\u0458\u0430'),'ml':u('\u0d2a\u0d3e\u0d2a\u0d4d\u0d2a\u0d41\u0d35 \u0d28\u0d4d\u0d2f\u0d42 \u0d17\u0d3f\u0d28\u0d3f\u0d2f'),'mn':u('\u041f\u0430\u043f\u0443\u0430 \u0428\u0438\u043d\u044d \u0413\u0432\u0438\u043d\u0435\u0439'),'mo':'Papua-Noua Guinee','mr':'*hi','ms':'*aa','mt':'*aa','my':u('\u1015\u102b\u1015\u1030\u1021\u102c \u1014\u101a\u1030\u1038\u1002\u102e\u1014\u102e'),'na':'*aa','nb':'Papua Ny-Guinea','nd':'*aa','ne':u('\u092a\u092a\u0941\u0906 \u0928\u094d\u092f\u0942 \u0917\u093e\u0907\u0928\u093f\u092f\u093e'),'ng':'*aa','nl':'Papoea-Nieuw-Guinea','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2a\u0b2a\u0b41\u0b06 \u0b28\u0b4d\u0b5f\u0b41 \u0b17\u0b41\u0b0f\u0b28\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a2a\u0a3e\u0a2a\u0a42\u0a06 \u0a28\u0a3f\u0a0a \u0a17\u0a3f\u0a28\u0a40'),'pi':'*aa','pl':'Papua-Nowa Gwinea','ps':u('\u067e\u0627\u067e \u0646\u064a\u0648 \u06ab\u064a\u0646\u064a\u060c \u062f \u064a\u0648 \u0647\u06d0\u0648\u0627\u062f \u0646\u0648\u0645 \u062f\u06d0'),'pt':u('Papua-Nova Guin\u00e9'),'qu':'*es','rm':'*ca','rn':'Papuwa Niyugineya','ro':'*mo','ru':u('\u041f\u0430\u043f\u0443\u0430 \u2014 \u041d\u043e\u0432\u0430\u044f \u0413\u0432\u0438\u043d\u0435\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u067e\u0627\u067e\u0648\u0627 \u0646\u06cc\u0648 \u06af\u0646\u064a'),'se':u('Papua-O\u0111\u0111a-Guinea'),'sg':u('Pap\u00fb Fin\u00ee Gin\u00ebe, Papuaz\u00efi'),'si':u('\u0db4\u0dd0\u0db4\u0dd4\u0dc0\u0dcf \u0db1\u0dd2\u0dc0\u0dca \u0d9c\u0dd2\u0db1\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*cs','sl':'*bs','sm':'*aa','sn':'*aa','so':'*aa','sq':'Guineja e Re-Papua','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'Papua Nya Guinea','sw':'*aa','ta':u('\u0baa\u0baa\u0bcd\u0baa\u0bc1\u0bb5\u0bbe \u0ba8\u0bbf\u0baf\u0bc2 \u0b95\u0bbf\u0ba9\u0bbf\u0baf\u0bbe'),'te':u('\u0c2a\u0c3e\u0c2a\u0c41\u0c35\u0c3e \u0c28\u0c4d\u0c2f\u0c42 \u0c17\u0c3f\u0c28\u0c3f\u0c2f\u0c3e'),'tg':u('\u041f\u0430\u043f\u0443\u0430 \u0413\u0432\u0438\u043d\u0435\u044f\u0438 \u041d\u0430\u0432'),'th':u('\u0e1b\u0e32\u0e1b\u0e31\u0e27\u0e19\u0e34\u0e27\u0e01\u0e34\u0e19\u0e35'),'ti':'*am','tk':u('Papua - T\u00e4ze Gwine\u00fda'),'tl':'*aa','tn':'*aa','to':'Papuaniukini','tr':'Papua Yeni Gine','ts':'*aa','tt':u('\u041f\u0430\u043f\u0443\u0430 - \u042f\u04a3\u0430 \u0413\u0432\u0438\u043d\u0435\u044f'),'tw':'*aa','ty':'*aa','ug':u('\u067e\u0627\u067e\u06c7\u0626\u0627 \u064a\u06d0\u06ad\u0649 \u06af\u0649\u06cb\u0649\u0646\u0649\u064a\u06d5\u0633\u0649'),'uk':u('\u041f\u0430\u043f\u0443\u0430-\u041d\u043e\u0432\u0430 \u0490\u0432\u0456\u043d\u0435\u044f'),'ur':u('\u067e\u0627\u067e\u0648\u0622 \u0646\u06cc\u0648 \u06af\u0646\u06cc'),'uz':u('Papua \u2013 Yangi Gvineya'),'ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Papuwasi Gine Gu Bees','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Paapu ti Giini'),'za':'*aa','zh':u('\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a'),'zu':'i-Papua New Guinea',},
  'PH': {'aa':'Philippines','ab':'*aa','ae':'*aa','af':'Filippyne','ak':'*aa','am':u('\u134a\u120a\u1352\u1295\u1235'),'an':'*aa','ar':u('\u0627\u0644\u0641\u0644\u0628\u064a\u0646'),'as':u('\u09ab\u09bf\u09b2\u09bf\u09aa\u09be\u0987\u09a8\u099b'),'av':'*aa','ay':'*aa','az':'Filippin','ba':'*aa','be':u('\u0424\u0456\u043b\u0456\u043f\u0456\u043d\u044b'),'bg':u('\u0424\u0438\u043b\u0438\u043f\u0438\u043d\u0438'),'bh':'*aa','bi':'*aa','bm':'Filipini','bn':u('\u09ab\u09bf\u09b2\u09bf\u09aa\u09be\u0987\u09a8'),'bo':'*aa','br':'Filipinez','bs':'*bm','ca':'Filipines','ce':u('\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d\u0430\u0448'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Filip\u00edny'),'cu':'*aa','cv':'*aa','cy':'Y Philipinau','da':'Filippinerne','de':'Philippinen','dv':'*aa','dz':u('\u0f55\u0f72\u0f0b\u0f63\u0f72\u0f0b\u0f54\u0f72\u0f53\u0f66'),'ee':'Filipini nutome','el':u('\u03a6\u03b9\u03bb\u03b9\u03c0\u03c0\u03af\u03bd\u03b5\u03c2'),'en':'*aa','eo':'Filipinoj','es':'Filipinas','et':'Filipiinid','eu':'Filipinak','fa':u('\u0641\u06cc\u0644\u06cc\u067e\u06cc\u0646'),'ff':'Filipiin','fi':'Filippiinit','fj':'*aa','fo':'Filipsoyggjar','fr':'*aa','fy':'Filipijnen','ga':u('na hOile\u00e1in Fhilip\u00edneacha'),'gd':'Na h-Eileanan Filipineach','gl':'*es','gn':'*aa','gu':u('\u0aab\u0abf\u0ab2\u0abf\u0aaa\u0abf\u0aa8\u0acd\u0ab8'),'gv':'*aa','ha':'Filipin','he':u('\u05d4\u05e4\u05d9\u05dc\u05d9\u05e4\u05d9\u05e0\u05d9\u05dd'),'hi':u('\u092b\u093c\u093f\u0932\u093f\u092a\u0940\u0902\u0938'),'ho':'*aa','hr':'*bm','ht':'*aa','hu':u('F\u00fcl\u00f6p-szigetek'),'hy':u('\u0556\u056b\u056c\u056b\u057a\u056b\u0576\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'Filipina','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'Filippseyjar','it':'Filippine','iu':'*aa','iw':'*he','ja':u('\u30d5\u30a3\u30ea\u30d4\u30f3'),'ji':u('\u05e4\u05bf\u05d9\u05dc\u05d9\u05e4\u05bc\u05d9\u05e0\u05e2\u05df'),'jv':'*aa','ka':u('\u10e4\u10d8\u10da\u10d8\u10de\u10d8\u10dc\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'Filipino','kj':'*aa','kk':u('\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'kl':'*aa','km':u('\u17a0\u17d2\u179c\u17b8\u179b\u17b8\u1796\u17b8\u1793'),'kn':u('\u0cab\u0cbf\u0cb2\u0cbf\u0cab\u0cc8\u0ca8\u0ccd\u0cb8\u0ccd'),'ko':u('\ud544\ub9ac\ud540'),'kr':'*aa','ks':u('\u0641\u0650\u0644\u0650\u067e\u0650\u06cc\u0646\u0633'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0424\u0438\u043b\u043b\u0438\u043f\u0438\u043d'),'la':'*aa','lb':'Philippinnen','lg':'Bizinga bya Firipino','li':'*aa','ln':u('Filipin\u025b'),'lo':u('\u0e9f\u0eb4\u0ea5\u0eb4\u0e9a\u0e9b\u0eb4\u0e99'),'lt':'Filipinai','lu':'Nfilipi','lv':u('Filip\u012bnas'),'mg':'*id','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d2b\u0d3f\u0d32\u0d3f\u0d2a\u0d4d\u0d2a\u0d40\u0d7b\u0d38\u0d4d'),'mn':u('\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d'),'mo':'Filipine','mr':u('\u092b\u093f\u0932\u093f\u092a\u093f\u0928\u094d\u0938'),'ms':'*id','mt':'il-Filippini','my':u('\u1016\u102d\u101c\u1005\u103a\u1015\u102d\u102f\u1004\u103a'),'na':'*aa','nb':'Filippinene','nd':'*aa','ne':'*mr','ng':'*aa','nl':'*fy','nn':'Filippinane','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2b\u0b3f\u0b32\u0b3f\u0b2a\u0b3e\u0b07\u0b28\u0b38\u0b4d'),'os':'*aa','pa':u('\u0a2b\u0a3f\u0a32\u0a40\u0a2a\u0a40\u0a28\u0a1c'),'pi':'*aa','pl':'Filipiny','ps':u('\u0641\u0644\u067e\u064a\u0646'),'pt':'*es','qu':'*es','rm':'Filippinas','rn':'Amazinga ya Filipine','ro':'*mo','ru':u('\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d\u044b'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0641\u0644\u067e\u0627\u0626\u0646'),'se':'Filippiinnat','sg':u('Filip\u00eeni'),'si':u('\u0db4\u0dd2\u0dbd\u0dd2\u0db4\u0dd3\u0db1\u0dba'),'sk':'*cs','sl':'*bm','sm':'*aa','sn':'*aa','so':'Filibiin','sq':'*mo','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'Filippinerna','sw':'Ufilipino','ta':u('\u0baa\u0bbf\u0bb2\u0bbf\u0baa\u0bcd\u0baa\u0bc8\u0ba9\u0bcd\u0bb8\u0bcd'),'te':u('\u0c2b\u0c3f\u0c32\u0c3f\u0c2a\u0c4d\u0c2a\u0c48\u0c28\u0c4d\u0c38\u0c4d'),'tg':'*mn','th':u('\u0e1f\u0e34\u0e25\u0e34\u0e1b\u0e1b\u0e34\u0e19\u0e2a\u0e4c'),'ti':'*am','tk':'Filippinler','tl':'Pilipinas','tn':'*aa','to':'Filipaini','tr':'Filipinler','ts':'*aa','tt':'*mn','tw':'*aa','ty':'*aa','ug':u('\u0641\u0649\u0644\u0649\u067e\u067e\u0649\u0646'),'uk':u('\u0424\u0456\u043b\u0456\u043f\u043f\u0456\u043d\u0438'),'ur':'*sd','uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*ha','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de filipini'),'za':'*aa','zh':u('\u83f2\u5f8b\u5bbe'),'zu':'i-Philippines',},
  'PK': {'aa':'Pakistan','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u1353\u12aa\u1235\u1273\u1295'),'an':'*aa','ar':u('\u0628\u0627\u0643\u0633\u062a\u0627\u0646'),'as':u('\u09aa\u09be\u0995\u09bf\u09b8\u09cd\u09a4\u09be\u09a8'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u041f\u0430\u043a\u0456\u0441\u0442\u0430\u043d'),'bg':u('\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d'),'bh':'*aa','bi':'*aa','bm':u('Pakisita\u014b'),'bn':'*as','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':u('P\u00e1kist\u00e1n'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f54\u0f0b\u0f40\u0f72\u0f0b\u0f66\u0f4f\u0f71\u0f53'),'ee':'Pakistan nutome','el':u('\u03a0\u03b1\u03ba\u03b9\u03c3\u03c4\u03ac\u03bd'),'en':'*aa','eo':'Pakistano','es':u('Pakist\u00e1n'),'et':'*aa','eu':'*aa','fa':u('\u067e\u0627\u06a9\u0633\u062a\u0627\u0646'),'ff':'Pakistaan','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('an Phacast\u00e1in'),'gd':u('Pagast\u00e0n'),'gl':u('Paquist\u00e1n'),'gn':'*aa','gu':u('\u0aaa\u0abe\u0a95\u0abf\u0ab8\u0acd\u0aa4\u0abe\u0aa8'),'gv':'*aa','ha':'*aa','he':u('\u05e4\u05e7\u05d9\u05e1\u05d8\u05df'),'hi':u('\u092a\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':u('Pakiszt\u00e1n'),'hy':u('\u054a\u0561\u056f\u056b\u057d\u057f\u0561\u0576'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30d1\u30ad\u30b9\u30bf\u30f3'),'ji':u('\u05e4\u05bc\u05d0\u05b7\u05e7\u05d9\u05e1\u05d8\u05d0\u05b7\u05df'),'jv':'*aa','ka':u('\u10de\u10d0\u10d9\u10d8\u10e1\u10e2\u10d0\u10dc\u10d8'),'kg':'*aa','ki':'Pakistani','kj':'*aa','kk':u('\u041f\u04d9\u043a\u0456\u0441\u0442\u0430\u043d'),'kl':'*aa','km':u('\u1794\u17c9\u17b6\u1782\u17b8\u179f\u17d2\u1790\u17b6\u1793'),'kn':u('\u0caa\u0cbe\u0c95\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8'),'ko':u('\ud30c\ud0a4\uc2a4\ud0c4'),'kr':'*aa','ks':u('\u067e\u0627\u06a9\u0650\u0633\u062a\u0627\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'Pakisitaani','li':'*aa','ln':u('Pakisit\u00e1'),'lo':u('\u0e9b\u0eb2\u0e81\u0eb4\u0e94\u0eaa\u0eb0\u0e96\u0eb2\u0e99'),'lt':'Pakistanas','lu':'Pakisita','lv':u('Pakist\u0101na'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d2a\u0d3e\u0d15\u0d4d\u0d15\u0d3f\u0d38\u0d4d\u0d25\u0d3e\u0d7b'),'mn':'*bg','mo':'*aa','mr':'*hi','ms':'*aa','mt':'il-Pakistan','my':u('\u1015\u102b\u1000\u1005\u1039\u1005\u1010\u1014\u103a'),'na':'*aa','nb':'*aa','nd':'Phakistani','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2a\u0b3e\u0b15\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28'),'os':'*aa','pa':u('\u0a2a\u0a3e\u0a15\u0a3f\u0a38\u0a24\u0a3e\u0a28'),'pi':'*aa','pl':'*aa','ps':'*fa','pt':u('Paquist\u00e3o'),'qu':'*es','rm':'*aa','rn':'Pakisitani','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u067e\u0627\u06aa\u0633\u062a\u0627\u0646'),'se':'*aa','sg':u('Pakist\u00e4an'),'si':u('\u0db4\u0dcf\u0d9a\u0dd2\u0dc3\u0dca\u0dad\u0dcf\u0db1\u0dba'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'Bakistaan','sq':'*aa','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*ki','ta':u('\u0baa\u0bbe\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd'),'te':u('\u0c2a\u0c3e\u0c15\u0c3f\u0c38\u0c4d\u0c24\u0c3e\u0c28\u0c4d'),'tg':u('\u041f\u043e\u043a\u0438\u0441\u0442\u043e\u043d'),'th':u('\u0e1b\u0e32\u0e01\u0e35\u0e2a\u0e16\u0e32\u0e19'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':u('P\u0101kisitani'),'tr':'*aa','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u067e\u0627\u0643\u0649\u0633\u062a\u0627\u0646'),'uk':'*bg','ur':'*fa','uz':'Pokiston','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':u('Pakista\u014b'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Pakisitan'),'za':'*aa','zh':u('\u5df4\u57fa\u65af\u5766'),'zu':'i-Pakistan',},
  'PL': {'aa':'Poland','ab':'*aa','ae':'*aa','af':'Pole','ak':'*aa','am':u('\u1356\u120b\u1295\u12f5'),'an':'*aa','ar':u('\u0628\u0648\u0644\u0646\u062f\u0627'),'as':u('\u09aa\u09cb\u09b2\u09c7\u09a3\u09cd\u09a1'),'av':'*aa','ay':'*aa','az':u('Pol\u015fa'),'ba':'*aa','be':u('\u041f\u043e\u043b\u044c\u0448\u0447\u0430'),'bg':u('\u041f\u043e\u043b\u0448\u0430'),'bh':'*aa','bi':'*aa','bm':u('Polo\u0272i'),'bn':u('\u09aa\u09cb\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1'),'bo':'*aa','br':'Polonia','bs':'Poljska','ca':u('Pol\u00f2nia'),'ce':u('\u041f\u043e\u043b\u044c\u0448\u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Polsko','cu':'*aa','cv':'*aa','cy':'Gwlad Pwyl','da':'Polen','de':'*da','dv':'*aa','dz':u('\u0f54\u0f7c\u0f0b\u0f63\u0f7a\u0f53\u0f4c'),'ee':'Poland nutome','el':u('\u03a0\u03bf\u03bb\u03c9\u03bd\u03af\u03b1'),'en':'*aa','eo':'Pollando','es':'*br','et':'Poola','eu':'*br','fa':u('\u0644\u0647\u0633\u062a\u0627\u0646'),'ff':u('Polo\u00f1'),'fi':'Puola','fj':'*aa','fo':u('P\u00f3lland'),'fr':'Pologne','fy':'*da','ga':'an Pholainn','gd':u('A\u2019 Ph\u00f2lainn'),'gl':'*br','gn':'*aa','gu':u('\u0aaa\u0acb\u0ab2\u0ac7\u0a82\u0aa1'),'gv':'*aa','ha':'Polan','he':u('\u05e4\u05d5\u05dc\u05d9\u05df'),'hi':u('\u092a\u094b\u0932\u0948\u0902\u0921'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Lengyelorsz\u00e1g'),'hy':u('\u053c\u0565\u0570\u0561\u057d\u057f\u0561\u0576'),'hz':'*aa','ia':'*aa','id':'Polandia','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'*fo','it':'*br','iu':'*aa','iw':'*he','ja':u('\u30dd\u30fc\u30e9\u30f3\u30c9'),'ji':u('\u05e4\u05bc\u05d5\u05d9\u05dc\u05df'),'jv':'*aa','ka':u('\u10de\u10dd\u10da\u10dd\u10dc\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'Polandi','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u1794\u17c9\u17bc\u17a1\u17bc\u1789'),'kn':u('\u0caa\u0ccb\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd'),'ko':u('\ud3f4\ub780\ub4dc'),'kr':'*aa','ks':u('\u067e\u0648\u0644\u06cc\u0646\u065b\u0691'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*da','lg':'*ki','li':'*aa','ln':'Poloni','lo':u('\u0ec2\u0e9b\u0ec1\u0ea5\u0e99'),'lt':'Lenkija','lu':'Mpoloni','lv':'Polija','mg':u('P\u00f4l\u00f4na'),'mh':'*aa','mi':'*aa','mk':u('\u041f\u043e\u043b\u0441\u043a\u0430'),'ml':u('\u0d2a\u0d4b\u0d33\u0d23\u0d4d\u0d1f\u0d4d'),'mn':u('\u041f\u043e\u043b\u044c\u0448'),'mo':'*br','mr':u('\u092a\u094b\u0932\u0902\u0921'),'ms':'*aa','mt':'il-Polonja','my':u('\u1015\u102d\u102f\u101c\u1014\u103a'),'na':'*aa','nb':'*da','nd':'Pholandi','ne':u('\u092a\u094b\u0932\u094d\u092f\u093e\u0923\u094d\u0921'),'ng':'*aa','nl':'*da','nn':'*da','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2a\u0b4b\u0b32\u0b3e\u0b23\u0b4d\u0b21'),'os':'*aa','pa':u('\u0a2a\u0a4b\u0a32\u0a48\u0a02\u0a21'),'pi':'*aa','pl':'Polska','ps':u('\u067e\u0648\u0644\u0646\u0689'),'pt':u('Pol\u00f4nia'),'qu':'*br','rm':'Pologna','rn':'Polonye','ro':'*br','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u067e\u0648\u0644\u064a\u0646\u068a'),'se':'*da','sg':u('P\u00f6l\u00f4ni'),'si':u('\u0db4\u0ddd\u0dbd\u0db1\u0dca\u0dad\u0dba'),'sk':u('Po\u013esko'),'sl':'*bs','sm':'*aa','sn':'*aa','so':'Booland','sq':'*ln','sr':u('\u041f\u043e\u0459\u0441\u043a\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':u('\u0baa\u0bcb\u0bb2\u0ba8\u0bcd\u0ba4\u0bc1'),'te':u('\u0c2a\u0c4b\u0c32\u0c3e\u0c02\u0c21\u0c4d'),'tg':u('\u041b\u0430\u04b3\u0438\u0441\u0442\u043e\u043d'),'th':u('\u0e42\u0e1b\u0e41\u0e25\u0e19\u0e14\u0e4c'),'ti':'*am','tk':'*az','tl':'*aa','tn':'*aa','to':'Polani','tr':'Polonya','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u067e\u0648\u0644\u0634\u0627'),'uk':u('\u041f\u043e\u043b\u044c\u0449\u0430'),'ur':u('\u067e\u0648\u0644\u06cc\u0646\u0688'),'uz':'Polsha','ve':'*aa','vi':'Ba Lan','vo':'*aa','wa':'*aa','wo':'*ff','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Polandi'),'za':'*aa','zh':u('\u6ce2\u5170'),'zu':'i-Poland',},
  'PM': {'aa':'Saint Pierre And Miquelon','ab':'*aa','ae':'*aa','af':'Sint Pierre en Miquelon','ak':'Saint Pierre ne Miquelon','am':u('\u1245\u12f1\u1235 \u1352\u12ec\u122d \u12a5\u1293 \u121a\u12a9\u12a4\u120e\u1295'),'an':'*aa','ar':u('\u0633\u0627\u0646 \u0628\u064a\u064a\u0631 \u0648\u0645\u0643\u0648\u064a\u0644\u0648\u0646'),'as':u('\u099b\u09c7\u0987\u09a3\u09cd\u099f \u09aa\u09bf\u09af\u09bc\u09c7\u09f0\u09c7 \u0986\u09f0\u09c1 \u09ae\u09bf\u0995\u09bf\u0989\u09f1\u09c7\u09b2\u09a8'),'av':'*aa','ay':'*aa','az':u('M\u00fcq\u0259dd\u0259s Pyer v\u0259 Mikelon'),'ba':'*aa','be':u('\u0421\u0435\u043d-\u041f\u2019\u0435\u0440 \u0456 \u041c\u0456\u043a\u0435\u043b\u043e\u043d'),'bg':u('\u0421\u0435\u043d \u041f\u0438\u0435\u0440 \u0438 \u041c\u0438\u043a\u0435\u043b\u043e\u043d'),'bh':'*aa','bi':'*aa','bm':u('Piy\u025bri-Senu-ni-Mikel\u0254\u014b'),'bn':u('\u09b8\u09c7\u09a8\u09cd\u099f \u09aa\u09bf\u09af\u09bc\u09c7\u09b0 \u0993 \u09ae\u09bf\u0995\u09c1\u09af\u09bc\u09c7\u09b2\u09a8'),'bo':'*aa','br':u('Sant-P\u00ear-ha-Mikelon'),'bs':'Sveti Petar i Mikelon','ca':'Saint-Pierre-et-Miquelon','ce':u('\u0421\u0435\u043d-\u041f\u044c\u0435\u0440 \u0430, \u041c\u0438\u043a\u0435\u043b\u043e\u043d \u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Saint-Pierre a Miquelon','cu':'*aa','cv':'*aa','cy':'*ca','da':'Saint Pierre og Miquelon','de':'St. Pierre und Miquelon','dv':'*aa','dz':u('\u0f66\u0f72\u0f53\u0f4a\u0f0b\u0f54\u0f72\u0f0b\u0f61\u0f7a\u0f62\u0f0b \u0f68\u0f7a\u0f53\u0f4c\u0f0b \u0f58\u0f72\u0f40\u0f7c\u0f0b\u0f63\u0f7a\u0f53'),'ee':u('Saint Pierre kple Mikel\u0254n nutome'),'el':u('\u03a3\u03b5\u03bd \u03a0\u03b9\u03b5\u03c1 \u03ba\u03b1\u03b9 \u039c\u03b9\u03ba\u03b5\u03bb\u03cc\u03bd'),'en':'St. Pierre & Miquelon','eo':'Sent-Piero kaj Mikelono','es':u('San Pedro y Miquel\u00f3n'),'et':'Saint-Pierre ja Miquelon','eu':'Saint-Pierre eta Mikelune','fa':u('\u0633\u0646 \u067e\u06cc\u0631 \u0648 \u0645\u06cc\u06a9\u0644\u0646'),'ff':'See Piyeer e Mikeloo','fi':'*et','fj':'*aa','fo':'Saint Pierre & Miquelon','fr':'*ca','fy':'Saint-Pierre en Miquelon','ga':'San Pierre agus Miquelon','gd':'Saint Pierre agus Miquelon','gl':'*ca','gn':'*aa','gu':u('\u0ab8\u0ac7\u0a82\u0a9f \u0aaa\u0ac0\u0a8f\u0ab0\u0ac0 \u0a85\u0aa8\u0ac7 \u0aae\u0abf\u0a95\u0acd\u0aaf\u0ac1\u0ab2\u0acb\u0aa8'),'gv':'*aa','ha':'San Piyar Da Mikelan','he':u('\u05e1\u05e0\u05d8 \u05e4\u05d9\u05d9\u05e8 \u05d5\u05de\u05d9\u05e7\u05dc\u05d5\u05df'),'hi':u('\u0938\u0947\u0902\u091f \u092a\u093f\u090f\u0930\u0947 \u0914\u0930 \u092e\u093f\u0915\u094d\u0935\u0947\u0932\u093e\u0928'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Saint-Pierre \u00e9s Miquelon'),'hy':u('\u054d\u0565\u0576 \u054a\u056b\u0565\u057c \u0587 \u0544\u056b\u0584\u0565\u056c\u0578\u0576'),'hz':'*aa','ia':'*aa','id':'Saint Pierre dan Miquelon','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'Sankti Pierre og Miquelon','it':'Saint-Pierre e Miquelon','iu':'*aa','iw':'*he','ja':u('\u30b5\u30f3\u30d4\u30a8\u30fc\u30eb\u5cf6\u30fb\u30df\u30af\u30ed\u30f3\u5cf6'),'ji':'*aa','jv':'*aa','ka':u('\u10e1\u10d4\u10dc-\u10de\u10d8\u10d4\u10e0\u10d8 \u10d3\u10d0 \u10db\u10d8\u10d9\u10d4\u10da\u10dd\u10dc\u10d8'),'kg':'*aa','ki':'Santapieri na Mikeloni','kj':'*aa','kk':u('\u0421\u0435\u043d-\u041f\u044c\u0435\u0440 \u0436\u04d9\u043d\u0435 \u041c\u0438\u043a\u0435\u043b\u043e\u043d'),'kl':'*aa','km':u('\u179f\u1784\u17cb\u1796\u17d2\u1799\u17c2\u179a \u1793\u17b7\u1784\u200b\u1798\u17b8\u1782\u17b8\u17a1\u17bb\u1784'),'kn':u('\u0cb8\u0cc7\u0c82\u0c9f\u0ccd \u0caa\u0cbf\u0caf\u0cb0\u0ccd \u0cae\u0ca4\u0ccd\u0ca4\u0cc1 \u0cae\u0cbf\u0c95\u0ccd\u0cb5\u0cc6\u0cb2\u0ca8\u0ccd'),'ko':u('\uc0dd\ud53c\uc5d0\ub974 \ubbf8\ud074\ub871'),'kr':'*aa','ks':u('\u0633\u06cc\u0646\u065b\u0679 \u067e\u06cc\u0656\u0631\u06cc \u062a\u06c1\u0655 \u0645\u0648\u06a9\u06cc\u0644\u0650\u06cc\u064e\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0421\u0435\u043d-\u041f\u044c\u0435\u0440 \u0436\u0430\u043d\u0430 \u041c\u0438\u043a\u0435\u043b\u043e\u043d'),'la':'*aa','lb':'St. Pierre a Miquelon','lg':'Senti Piyere ne Mikeloni','li':'*aa','ln':u('S\u00e1ntu p\u00e9t\u00e9to mp\u00e9 Mikel\u0254'),'lo':u('\u0ec0\u0e8a\u0e99 \u0e9b\u0eb5\u0ec1\u0ead \u0ea1\u0eb4\u0ec0\u0e81\u0ea7\u0ea5\u0ead\u0e99'),'lt':'Sen Pjeras ir Mikelonas','lu':u('Santu p\u00e9t\u00e9to ne Mikelu'),'lv':u('Senpj\u0113ra un Mikelona'),'mg':'*ca','mh':'*aa','mi':'*aa','mk':u('\u0421\u0435\u043d\u0442 \u041f\u0458\u0435\u0440 \u0438 \u041c\u0438\u043a\u0435\u043b\u0430\u043d'),'ml':u('\u0d38\u0d46\u0d28\u0d4d\u0d31\u0d4d \u0d2a\u0d3f\u0d2f\u0d31\u0d3f\u0d2f\u0d41\u0d02 \u0d2e\u0d3f\u0d15\u0d4d\u0d15\u0d32\u0d23\u0d41\u0d02'),'mn':u('\u0421\u0435\u043d\u0442-\u041f\u044c\u0435\u0440 \u0431\u0430 \u041c\u0438\u043a\u0435\u043b\u043e'),'mo':u('Saint-Pierre \u0219i Miquelon'),'mr':u('\u0938\u0947\u0902\u091f \u092a\u093f\u092f\u0930\u0947 \u0906\u0923\u093f \u092e\u093f\u0915\u094d\u0935\u0947\u0932\u094b\u0928'),'ms':'*id','mt':'Saint Pierre u Miquelon','my':u('\u1005\u102d\u1014\u1037\u103a\u1015\u102e\u1021\u1032\u101b\u103a\u1014\u103e\u1004\u1037\u103a \u1019\u102e\u1000\u103d\u102e\u101c\u103d\u1014\u103a'),'na':'*aa','nb':'*ca','nd':'Saint Pierre and Miquelon','ne':u('\u0938\u0947\u0928\u094d\u091f \u092a\u093f\u0930\u094d\u0930\u0947 \u0930 \u092e\u093f\u0915\u094d\u0915\u0947\u0932\u094b\u0928'),'ng':'*aa','nl':'*fy','nn':'*ca','no':'*ca','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b2a\u0b3f\u0b0f\u0b30\u0b47 \u0b0f\u0b2c\u0b02 \u0b2e\u0b3f\u0b15\u0b4d\u0b71\u0b47\u0b32\u0b28\u0b4d\u200c'),'os':'*aa','pa':u('\u0a38\u0a47\u0a02\u0a1f \u0a2a\u0a40\u0a05\u0a30\u0a47 \u0a10\u0a02\u0a21 \u0a2e\u0a3f\u0a15\u0a47\u0a32\u0a28'),'pi':'*aa','pl':'Saint-Pierre i Miquelon','ps':u('\u0633\u06cc\u0646\u067c \u067e\u06cc\u06cc\u0631 \u0627\u0648 \u0645\u06cc\u06a9\u0648\u0644\u0648\u0646'),'pt':u('S\u00e3o Pedro e Miquel\u00e3o'),'qu':'*es','rm':'Saint Pierre e Miquelon','rn':'Sempiyeri na Mikeloni','ro':'*mo','ru':u('\u0421\u0435\u043d-\u041f\u044c\u0435\u0440 \u0438 \u041c\u0438\u043a\u0435\u043b\u043e\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u06cc\u0646\u067d \u067e\u06cc\u0626\u0631 \u0648 \u0645\u06cc\u06aa\u0648\u0626\u06cc\u0644\u0648\u0646'),'se':'Saint Pierre ja Miquelon','sg':u('S\u00ean-Py\u00eare na Mikel\u00f6on'),'si':u('\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0db4\u0dd2\u0dba\u0dbb\u0dda \u0dc3\u0dc4 \u0db8\u0dd0\u0d9a\u0ddd\u0dbd\u0db1\u0dca'),'sk':'Saint Pierre a Miquelon','sl':'Saint Pierre in Miquelon','sm':'*aa','sn':'*nd','so':'*nd','sq':u('Sh\u00ebn-Pier dhe Mikelon'),'sr':u('\u0421\u0435\u043d \u041f\u0458\u0435\u0440 \u0438 \u041c\u0438\u043a\u0435\u043b\u043e\u043d'),'ss':'*aa','st':'*aa','su':'*aa','sv':'S:t Pierre och Miquelon','sw':'Santapierre na Miquelon','ta':u('\u0b9a\u0bc6\u0baf\u0bbf\u0ba9\u0bcd\u0b9f\u0bcd \u0baa\u0bbf\u0baf\u0bb0\u0bcd & \u0bae\u0bbf\u0b95\u0bcd\u0bb5\u0bc7\u0bb2\u0bbe\u0ba9\u0bcd'),'te':u('\u0c38\u0c46\u0c2f\u0c3f\u0c02\u0c1f\u0c4d \u0c2a\u0c3f\u0c2f\u0c46\u0c30\u0c4d \u0c2e\u0c30\u0c3f\u0c2f\u0c41 \u0c2e\u0c3f\u0c15\u0c46\u0c32\u0c3e\u0c28\u0c4d'),'tg':u('\u0421\u0435\u043d\u0442-\u041f\u0435\u0440 \u0432\u0430 \u041c\u0438\u043a\u0435\u043b\u043e\u043d'),'th':u('\u0e41\u0e0b\u0e07\u0e1b\u0e35\u0e41\u0e22\u0e23\u0e4c\u0e41\u0e25\u0e30\u0e21\u0e35\u0e40\u0e01\u0e2d\u0e25\u0e07'),'ti':u('\u1245\u12f1\u1235 \u1352\u12ec\u122d\u1295 \u121a\u12a9\u12a4\u120e\u1295'),'tk':u('Sen-P\u00fder we Mikelon'),'tl':'*en','tn':'*aa','to':u('S\u0101 Piea mo Mikeloni'),'tr':'Saint Pierre ve Miquelon','ts':'*aa','tt':u('\u0421\u0435\u043d-\u041f\u044c\u0435\u0440 \u04bb\u04d9\u043c \u041c\u0438\u043a\u0435\u043b\u043e\u043d'),'tw':'*aa','ty':'*aa','ug':u('\u0633\u0627\u064a\u0646\u062a \u067e\u0649\u064a\u06d0\u0631 \u06cb\u06d5 \u0645\u0649\u0643\u06d0\u0644\u0648\u0646 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649'),'uk':u('\u0421\u0435\u043d-\u041f\u02bc\u0454\u0440 \u0456 \u041c\u0456\u043a\u0435\u043b\u043e\u043d'),'ur':u('\u0633\u06cc\u0646\u0679 \u067e\u06cc\u0626\u0631 \u0627\u0648\u0631 \u0645\u06cc\u06a9\u0644\u06cc\u0626\u0648\u0646'),'uz':'Sen-Pyer va Mikelon','ve':'*aa','vi':u('Saint Pierre v\u00e0 Miquelon'),'vo':'*aa','wa':'*aa','wo':u('Sa\u014b Peer ak Mikelo\u014b'),'xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de P\u1eb9\u1eb9ri ati mikuloni'),'za':'*aa','zh':u('\u5723\u76ae\u57c3\u5c14\u548c\u5bc6\u514b\u9686\u7fa4\u5c9b'),'zu':'i-Saint Pierre kanye ne-Miquelon',},
  'PN': {'aa':'Pitcairn','ab':'*aa','ae':'*aa','af':'Pitcairneilande','ak':'*aa','am':u('\u1352\u1275\u12ab\u12a2\u122d\u1295 \u12a0\u12ed\u1235\u120b\u1295\u12f5'),'an':'*aa','ar':u('\u062c\u0632\u0631 \u0628\u064a\u062a\u0643\u064a\u0631\u0646'),'as':u('\u09aa\u09bf\u099f\u0995\u09c7\u0987\u09f0\u09cd\u09a3 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'av':'*aa','ay':'*aa','az':u('Pitkern adalar\u0131'),'ba':'*aa','be':u('\u0410\u0441\u0442\u0440\u0430\u0432\u044b \u041f\u0456\u0442\u043a\u044d\u0440\u043d'),'bg':u('\u041e\u0441\u0442\u0440\u043e\u0432\u0438 \u041f\u0438\u0442\u043a\u0435\u0440\u043d'),'bh':'*aa','bi':'*aa','bm':'Pitikarini','bn':u('\u09aa\u09bf\u099f\u0995\u09c7\u09af\u09bc\u09be\u09b0\u09cd\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'bo':'*aa','br':'Enez Pitcairn','bs':'Pitkernska Ostrva','ca':'Illes Pitcairn','ce':u('\u041f\u0438\u0442\u043a\u044d\u0440\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Pitcairnovy ostrovy','cu':'*aa','cv':'*aa','cy':'Ynysoedd Pitcairn','da':'*aa','de':'Pitcairninseln','dv':'*aa','dz':u('\u0f54\u0f72\u0f4a\u0f0b\u0f40\u0f7a\u0f0b\u0f61\u0f7a\u0f62\u0f53\u0f0b\u0f42\u0fb3\u0f72\u0f44\u0f0b\u0f5a\u0f7c\u0f58'),'ee':u('Pitkairn \u0192udomekpo nutome'),'el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u03a0\u03af\u03c4\u03ba\u03b5\u03c1\u03bd'),'en':'Pitcairn Islands','eo':'Pitkarna Insulo','es':'Islas Pitcairn','et':'Pitcairni saared','eu':'Pitcairn uharteak','fa':u('\u062c\u0632\u0627\u06cc\u0631 \u067e\u06cc\u062a\u200c\u06a9\u0631\u0646'),'ff':'Pitkern','fi':'*aa','fj':'*aa','fo':'Pitcairnoyggjar','fr':u('\u00celes Pitcairn'),'fy':'Pitcairneilannen','ga':u('Oile\u00e1in Pitcairn'),'gd':u('Eileanan Pheit a\u2019 Ch\u00e0irn'),'gl':'Illas Pitcairn','gn':'*aa','gu':u('\u0aaa\u0ac0\u0a9f\u0a95\u0ac8\u0ab0\u0acd\u0aa8 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8'),'gv':'*aa','ha':'Pitakarin','he':u('\u05d0\u05d9\u05d9 \u05e4\u05d9\u05d8\u05e7\u05e8\u05df'),'hi':u('\u092a\u093f\u091f\u0915\u0948\u0930\u094d\u0928 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939'),'ho':'*aa','hr':'Otoci Pitcairn','ht':'*aa','hu':'Pitcairn-szigetek','hy':u('\u054a\u056b\u057f\u056f\u0565\u057c\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'Kepulauan Pitcairn','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':'Pitcairn-eyjar','it':'Isole Pitcairn','iu':'*aa','iw':'*he','ja':u('\u30d4\u30c8\u30b1\u30a2\u30f3\u8af8\u5cf6'),'ji':u('\u05e4\u05bc\u05d9\u05d8\u05e7\u05e2\u05e8\u05df \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df'),'jv':'*aa','ka':u('\u10de\u10d8\u10e2\u10d9\u10d4\u10e0\u10dc\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'Pitkairni','kj':'*aa','kk':u('\u041f\u0438\u0442\u043a\u044d\u0440\u043d \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'kl':'*aa','km':u('\u1780\u17c4\u17c7\u200b\u1797\u17b8\u178f\u1780\u17b6\u1793'),'kn':u('\u0caa\u0cbf\u0c9f\u0ccd\u200c\u0c95\u0cc8\u0cb0\u0ccd\u0ca8\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3\u0cc1'),'ko':u('\ud54f\ucf00\uc5b8 \uc12c'),'kr':'*aa','ks':u('\u067e\u0650\u0679\u06a9\u06cc\u0631\u0655\u0646\u06cd \u062c\u0654\u0632\u06cc\u0656\u0631\u0655'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'Pitcairninselen','lg':'Pitikeeni','li':'*aa','ln':'Pikairni','lo':u('\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0e9e\u0eb4\u0e94\u0ec1\u0e84\u0e99'),'lt':'Pitkerno salos','lu':'*ln','lv':u('Pitk\u0113rnas salas'),'mg':'Pitkairn','mh':'*aa','mi':'*aa','mk':u('\u041f\u0438\u0442\u043a\u0435\u0440\u043d\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438'),'ml':u('\u0d2a\u0d3f\u0d31\u0d4d\u0d31\u0d4d\u200c\u0d15\u0d46\u0d2f\u0d4d\u200c\u0d7b \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e'),'mn':u('\u041f\u0438\u0442\u043a\u044d\u0440\u043d \u0430\u0440\u043b\u0443\u0443\u0434'),'mo':'Insulele Pitcairn','mr':u('\u092a\u093f\u091f\u0915\u0948\u0930\u094d\u0928 \u092c\u0947\u091f\u0947'),'ms':'*id','mt':u('G\u017cejjer Pitcairn'),'my':u('\u1015\u1005\u103a\u1010\u103a\u1000\u102d\u1014\u103a\u1038\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u092a\u093f\u091f\u0915\u093e\u0907\u0930\u094d\u0928 \u091f\u093e\u092a\u0941\u0939\u0930\u0941'),'ng':'*aa','nl':'Pitcairneilanden','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2a\u0b3f\u0b1f\u0b15\u0b3e\u0b07\u0b30\u0b3f\u0b28\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c'),'os':'*aa','pa':u('\u0a2a\u0a3f\u0a1f\u0a15\u0a47\u0a30\u0a28 \u0a1f\u0a3e\u0a2a\u0a42'),'pi':'*aa','pl':'*aa','ps':u('\u067e\u06cc\u067c\u06a9\u06cc\u0631\u0646 \u067c\u0627\u067e\u0648'),'pt':'Ilhas Pitcairn','qu':'*es','rm':'*aa','rn':'Pitikeyirini','ro':'*mo','ru':u('\u043e-\u0432\u0430 \u041f\u0438\u0442\u043a\u044d\u0440\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u067e\u067d\u06aa\u0626\u0631\u0646 \u067b\u064a\u067d'),'se':'*aa','sg':u('Pitik\u00earni'),'si':u('\u0db4\u0dd2\u0da7\u0dca\u0d9a\u0dd9\u0dba\u0dca\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca'),'sk':'Pitcairnove ostrovy','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'Ishujt Pitkern','sr':u('\u041f\u0438\u0442\u043a\u0435\u0440\u043d'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Pitcairn\u00f6arna'),'sw':'Visiwa vya Pitcairn','ta':u('\u0baa\u0bbf\u0b9f\u0bcd\u0b95\u0bc6\u0baf\u0bcd\u0bb0\u0bcd\u0ba9\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd'),'te':u('\u0c2a\u0c3f\u0c1f\u0c4d\u200c\u0c15\u0c46\u0c2f\u0c3f\u0c30\u0c4d\u0c28\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41'),'tg':u('\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u041f\u0438\u0442\u043a\u0435\u0439\u0440\u043d'),'th':u('\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e1e\u0e34\u0e15\u0e41\u0e04\u0e23\u0e4c\u0e19'),'ti':u('\u1352\u1275\u12ab\u12a2\u122d\u1295'),'tk':'Pitkern adalary','tl':'*en','tn':'*aa','to':u('\u02bbOtumotu Pitikeni'),'tr':u('Pitcairn Adalar\u0131'),'ts':'*aa','tt':u('\u041f\u0438\u0442\u043a\u044d\u0440\u043d \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u067e\u0649\u062a\u0643\u0627\u064a\u0631\u0646 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649'),'uk':u('\u041e\u0441\u0442\u0440\u043e\u0432\u0438 \u041f\u0456\u0442\u043a\u0435\u0440\u043d'),'ur':u('\u067e\u0679\u06a9\u0627\u0626\u0631\u0646 \u062c\u0632\u0627\u0626\u0631'),'uz':'Pitkern orollari','ve':'*aa','vi':u('Qu\u1ea7n \u0111\u1ea3o Pitcairn'),'vo':'*aa','wa':'*aa','wo':'Duni Pitkayirn','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Pikarini'),'za':'*aa','zh':u('\u76ae\u7279\u51ef\u6069\u7fa4\u5c9b'),'zu':'i-Pitcairn Islands',},
  'PR': {'aa':'Puerto Rico','ab':'*aa','ae':'*aa','af':'*aa','ak':u('Pu\u025bto Riko'),'am':u('\u1356\u122d\u1273 \u122a\u12ae'),'an':'*aa','ar':u('\u0628\u0648\u0631\u062a\u0648\u0631\u064a\u0643\u0648'),'as':u('\u09aa\u09c1\u09f1\u09c7\u09f0\u09cd\u099f\u09cb \u09f0\u09bf\u0995\u09cb'),'av':'*aa','ay':'*aa','az':'Puerto Riko','ba':'*aa','be':u('\u041f\u0443\u044d\u0440\u0442\u0430-\u0420\u044b\u043a\u0430'),'bg':u('\u041f\u0443\u0435\u0440\u0442\u043e \u0420\u0438\u043a\u043e'),'bh':'*aa','bi':'*aa','bm':u('P\u0254rotoriko'),'bn':u('\u09aa\u09c1\u09af\u09bc\u09c7\u09b0\u09cd\u09a4\u09cb \u09b0\u09bf\u0995\u09cb'),'bo':'*aa','br':'*aa','bs':'Porto Riko','ca':'*aa','ce':u('\u041f\u0443\u044d\u0440\u0442\u043e-\u0420\u0438\u043a\u043e'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Portoriko','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f54\u0f74\u0f0b\u0f60\u0f7a\u0f62\u0f0b\u0f4a\u0f7c\u0f0b\u0f62\u0f72\u0f0b\u0f41\u0f7c'),'ee':'Puerto Riko nutome','el':u('\u03a0\u03bf\u03c5\u03ad\u03c1\u03c4\u03bf \u03a1\u03af\u03ba\u03bf'),'en':'*aa','eo':'Puerto-Riko','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u067e\u0648\u0631\u062a\u0648\u0631\u06cc\u06a9\u0648'),'ff':'Porto Rikoo','fi':'*aa','fj':'*aa','fo':'*az','fr':'Porto Rico','fy':'*aa','ga':u('P\u00f3rt\u00f3 R\u00edce'),'gd':u('Porto R\u00ecceo'),'gl':'*fr','gn':'*aa','gu':u('\u0aaa\u0acd\u0aaf\u0ac1\u0a85\u0ab0\u0acd\u0a9f\u0acb \u0ab0\u0abf\u0a95\u0acb'),'gv':'*aa','ha':'*bs','he':u('\u05e4\u05d5\u05d0\u05e8\u05d8\u05d5 \u05e8\u05d9\u05e7\u05d5'),'hi':u('\u092a\u094b\u0930\u094d\u091f\u094b \u0930\u093f\u0915\u094b'),'ho':'*aa','hr':'*cs','ht':'*aa','hu':'*aa','hy':u('\u054a\u0578\u0582\u0565\u0580\u057f\u0578 \u054c\u056b\u056f\u0578'),'hz':'*aa','ia':'*aa','id':'*az','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*az','io':'*aa','is':u('P\u00faert\u00f3 R\u00edk\u00f3'),'it':'Portorico','iu':'*aa','iw':'*he','ja':u('\u30d7\u30a8\u30eb\u30c8\u30ea\u30b3'),'ji':u('\u05e4\u05bc\u05d0\u05e8\u05d8\u05d0\u05be\u05e8\u05d9\u05e7\u05d0'),'jv':'*aa','ka':u('\u10de\u10e3\u10d4\u10e0\u10e2\u10dd-\u10e0\u10d8\u10d9\u10dd'),'kg':'*aa','ki':'Pwetoriko','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u1796\u17d0\u179a\u178f\u17bc\u179a\u17b8\u1780\u17bc'),'kn':u('\u0caa\u0ccd\u0caf\u0cc2\u0cb0\u0ccd\u0c9f\u0ccb \u0cb0\u0cbf\u0c95\u0cca'),'ko':u('\ud478\uc5d0\ub974\ud1a0\ub9ac\ucf54'),'kr':'*aa','ks':u('\u067e\u0654\u0631\u0679\u0648 \u0631\u0650\u06a9\u0648'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*aa','lg':'Potoriko','li':'*aa','ln':u('P\u0254toriko'),'lo':u('\u0ec0\u0e9e\u0eb7\u0ead\u0ec2\u0e95 \u0ea3\u0eb4\u0ec2\u0e81'),'lt':'Puerto Rikas','lu':'Mpotoriku','lv':'Puertoriko','mg':u('P\u00f4rt\u00f4 Rik\u00f4'),'mh':'*aa','mi':'*aa','mk':u('\u041f\u043e\u0440\u0442\u043e\u0440\u0438\u043a\u043e'),'ml':u('\u0d2a\u0d4b\u0d7c\u0d1f\u0d4d\u0d1f\u0d4b \u0d31\u0d3f\u0d15\u0d4d\u0d15\u0d4b'),'mn':'*ce','mo':'*aa','mr':u('\u092a\u094d\u092f\u0941\u090f\u0930\u094d\u0924\u094b \u0930\u093f\u0915\u094b'),'ms':'*aa','mt':'*aa','my':u('\u1015\u1031\u102b\u103a\u1010\u102d\u102f\u101b\u102e\u1000\u102d\u102f'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u092a\u0941\u090f\u0930\u094d\u091f\u094b \u0930\u093f\u0915\u094b'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2a\u0b41\u0b0f\u0b30\u0b4d\u0b24\u0b4d\u0b24\u0b4b \u0b30\u0b3f\u0b15\u0b4b'),'os':'*aa','pa':u('\u0a2a\u0a3f\u0a0a\u0a30\u0a1f\u0a4b \u0a30\u0a3f\u0a15\u0a4b'),'pi':'*aa','pl':'Portoryko','ps':u('\u067e\u0648\u0631\u062a\u0648 \u0631\u06cc\u06a9\u0648'),'pt':'*fr','qu':'*aa','rm':'*aa','rn':'Puwetoriko','ro':'*aa','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u067e\u064a\u0648\u0626\u0631\u067d\u0648 \u0631\u064a\u06aa\u0648'),'se':'*aa','sg':u('Porto R\u00eeko'),'si':u('\u0db4\u0dd4\u0dc0\u0dbb\u0dca\u0da7\u0ddd \u0dbb\u0dd2\u0d9a\u0ddd'),'sk':'*cs','sl':'*cs','sm':'*aa','sn':'*aa','so':'*aa','sq':'Porto-Riko','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0baa\u0bbf\u0baf\u0bc2\u0bb0\u0bcd\u0b9f\u0bcb \u0bb0\u0bbf\u0b95\u0bcb'),'te':u('\u0c2a\u0c4d\u0c2f\u0c42\u0c30\u0c4d\u0c1f\u0c4b \u0c30\u0c3f\u0c15\u0c4b'),'tg':'*ce','th':u('\u0e40\u0e1b\u0e2d\u0e23\u0e4c\u0e42\u0e15\u0e23\u0e34\u0e42\u0e01'),'ti':'*am','tk':'*eo','tl':'*aa','tn':'*aa','to':u('Pu\u0113to Liko'),'tr':'*bs','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u067e\u06c7\u0626\u06d0\u0631\u062a\u0648 \u0631\u0649\u0643\u0648'),'uk':u('\u041f\u0443\u0435\u0440\u0442\u043e-\u0420\u0456\u043a\u043e'),'ur':u('\u067e\u06cc\u0648\u0631\u0679\u0648 \u0631\u06cc\u06a9\u0648'),'uz':'*eo','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*bs','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de P\u1ecdto Riko'),'za':'*aa','zh':u('\u6ce2\u591a\u9ece\u5404'),'zu':'i-Puerto Rico',},
  'PS': {'aa':'Palestine','ab':'*aa','ae':'*aa','af':'Palestynse gebiede','ak':'Palestaen West Bank ne Gaza','am':u('\u12e8\u134d\u120d\u1235\u1324\u121d \u130d\u12db\u1275'),'an':'*aa','ar':u('\u0627\u0644\u0623\u0631\u0627\u0636\u064a \u0627\u0644\u0641\u0644\u0633\u0637\u064a\u0646\u064a\u0629'),'as':u('\u09ab\u09bf\u09b2\u09bf\u09b8\u09cd\u09a4\u09bf\u09a8 \u0985\u099e\u09cd\u099a\u09b2'),'av':'*aa','ay':'*aa','az':u('F\u0259l\u0259stin \u018frazil\u0259ri'),'ba':'*aa','be':u('\u041f\u0430\u043b\u0435\u0441\u0446\u0456\u043d\u0441\u043a\u0456\u044f \u0422\u044d\u0440\u044b\u0442\u043e\u0440\u044b\u0456'),'bg':u('\u041f\u0430\u043b\u0435\u0441\u0442\u0438\u043d\u0441\u043a\u0438 \u0442\u0435\u0440\u0438\u0442\u043e\u0440\u0438\u0438'),'bh':'*aa','bi':'*aa','bm':'Palesitini','bn':u('\u09aa\u09cd\u09af\u09be\u09b2\u09c7\u09b8\u09cd\u099f\u09be\u0987\u09a8\u09c7\u09b0 \u0985\u099e\u09cd\u099a\u09b2\u09b8\u09ae\u09c2\u09b9'),'bo':'*aa','br':u('Tiriado\u00f9 Palestina'),'bs':'Palestinska Teritorija','ca':'territoris palestins','ce':u('\u041f\u0430\u043b\u0435\u0441\u0442\u04c0\u0438\u043d\u0430\u043d \u043b\u0430\u0442\u0442\u0430\u043d\u0430\u0448'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Palestinsk\u00e1 \u00fazem\u00ed'),'cu':'*aa','cv':'*aa','cy':'Tiriogaethau Palesteinaidd','da':u('De pal\u00e6stinensiske omr\u00e5der'),'de':u('Pal\u00e4stinensische Autonomiegebiete'),'dv':'*aa','dz':u('\u0f54\u0f7a\u0f0b\u0f63\u0f72\u0f66\u0f72\u0f0b\u0f4a\u0f72\u0f0b\u0f53\u0f72\u0f0b\u0f61\u0f53\u0f0b\u0f4a\u0f7a\u0f0b\u0f62\u0f72\u0f0b\u0f50\u0f7c\u0f0b\u0f62\u0f72'),'ee':'Palestinia nutome','el':u('\u03a0\u03b1\u03bb\u03b1\u03b9\u03c3\u03c4\u03b9\u03bd\u03b9\u03b1\u03ba\u03ac \u0395\u03b4\u03ac\u03c6\u03b7'),'en':'Palestinian Territories','eo':'*aa','es':'Territorios Palestinos','et':'Palestiina alad','eu':'Palestinako Lurraldeak','fa':u('\u0633\u0631\u0632\u0645\u06cc\u0646\u200c\u0647\u0627\u06cc \u0641\u0644\u0633\u0637\u06cc\u0646\u06cc'),'ff':'Palestiin Sisjordani e Gaasaa','fi':'Palestiinalaisalueet','fj':'*aa','fo':u('Palestinskt land\u00f8ki'),'fr':'Territoires palestiniens','fy':'Palestynske gebieten','ga':u('na Cr\u00edocha Palaist\u00edneacha'),'gd':'Na Ranntairean Palastaineach','gl':'*es','gn':'*aa','gu':u('\u0aaa\u0ac7\u0ab2\u0ac7\u0ab8\u0acd\u0a9f\u0abf\u0aa8\u0abf\u0aaf\u0aa8 \u0a9f\u0ac7\u0ab0\u0abf\u0a9f\u0ab0\u0ac0'),'gv':'*aa','ha':u('Palas\u0257inu'),'he':u('\u05d4\u05e9\u05d8\u05d7\u05d9\u05dd \u05d4\u05e4\u05dc\u05e1\u05d8\u05d9\u05e0\u05d9\u05d9\u05dd'),'hi':u('\u092b\u093c\u093f\u0932\u093f\u0938\u094d\u0924\u0940\u0928\u0940 \u0915\u094d\u0937\u0947\u0924\u094d\u0930'),'ho':'*aa','hr':u('Palestinsko podru\u010dje'),'ht':'*aa','hu':u('Palesztin Ter\u00fclet'),'hy':u('\u054a\u0561\u0572\u0565\u057d\u057f\u056b\u0576\u0575\u0561\u0576 \u057f\u0561\u0580\u0561\u056e\u0584\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'Wilayah Palestina','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Heimastj\u00f3rnarsv\u00e6\u00f0i Palest\u00ednumanna'),'it':'Territori palestinesi','iu':'*aa','iw':'*he','ja':u('\u30d1\u30ec\u30b9\u30c1\u30ca\u81ea\u6cbb\u533a'),'ji':'*aa','jv':'*aa','ka':u('\u10de\u10d0\u10da\u10d4\u10e1\u10e2\u10d8\u10dc\u10d8\u10e1 \u10e2\u10d4\u10e0\u10d8\u10e2\u10dd\u10e0\u10d8\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina','kj':'*aa','kk':u('\u041f\u0430\u043b\u0435\u0441\u0442\u0438\u043d\u0430 \u0430\u0439\u043c\u0430\u049b\u0442\u0430\u0440\u044b'),'kl':'*aa','km':u('\u178a\u17c2\u1793\u200b\u178a\u17b8\u1794\u17c9\u17b6\u179b\u17c1\u179f\u17d2\u1791\u17b8\u1793'),'kn':u('\u0caa\u0ccd\u0caf\u0cbe\u0cb2\u0cc7\u0cb8\u0ccd\u0c9f\u0cc7\u0ca8\u0cbf\u0caf\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0ca6\u0cc7\u0cb6\u0c97\u0cb3\u0cc1'),'ko':u('\ud314\ub808\uc2a4\ud0c0\uc778 \uc9c0\uad6c'),'kr':'*aa','ks':u('\u0641\u064e\u0644\u064e\u0633\u062a\u06cc\u0656\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u041f\u0430\u043b\u0435\u0441\u0442\u0438\u043d\u0430 \u0430\u0439\u043c\u0430\u043a\u0442\u0430\u0440\u044b'),'la':'*aa','lb':'Palestinensesch Autonomiegebidder','lg':'Palesitayini','li':'*aa','ln':u('Pal\u025bsine'),'lo':u('\u0e94\u0eb4\u0e99\u0ec1\u0e94\u0e99 \u0e9b\u0eb2\u0ec0\u0ea5\u0eaa\u0e95\u0eb4\u0e99\u0ebd\u0e99'),'lt':'Palestinos teritorija','lu':'Palesine','lv':u('Palest\u012bna'),'mg':'Palestina','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d2a\u0d3e\u0d32\u0d38\u0d4d\u200c\u0d24\u0d40\u0d7b \u0d2a\u0d4d\u0d30\u0d26\u0d47\u0d36\u0d19\u0d4d\u0d19\u0d7e'),'mn':u('\u041f\u0430\u043b\u0435\u0441\u0442\u0438\u043d\u044b \u043d\u0443\u0442\u0430\u0433 \u0434\u044d\u0432\u0441\u0433\u044d\u0440\u04af\u04af\u0434'),'mo':'Teritoriile Palestiniene','mr':u('\u092a\u0945\u0932\u0947\u0938\u094d\u091f\u093f\u0928\u093f\u092f\u0928 \u092a\u094d\u0930\u0926\u0947\u0936'),'ms':'Wilayah Palestin','mt':'it-Territorji Palestinjani','my':u('\u1015\u102b\u101c\u1000\u103a\u1005\u1010\u102d\u102f\u1004\u103a\u1038 \u1015\u102d\u102f\u1004\u103a\u1014\u1000\u103a'),'na':'*aa','nb':u('Det palestinske omr\u00e5det'),'nd':'Palestinian West Bank and Gaza','ne':u('\u092a\u094d\u092f\u093e\u0932\u0947\u0938\u094d\u091f\u0928\u0940 \u092d\u0942-\u092d\u093e\u0917\u0939\u0930\u0941'),'ng':'*aa','nl':'Palestijnse gebieden','nn':'Palestinsk territorium','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2a\u0b3e\u0b32\u0b47\u0b37\u0b4d\u0b1f\u0b47\u0b28\u0b3f\u0b5f \u0b2d\u0b42\u0b2d\u0b3e\u0b17'),'os':'*aa','pa':u('\u0a2b\u0a3f\u0a32\u0a40\u0a38\u0a24\u0a40\u0a28\u0a40 \u0a07\u0a32\u0a3e\u0a15\u0a3e'),'pi':'*aa','pl':u('Terytoria Palesty\u0144skie'),'ps':u('\u0641\u0644\u0633\u0637\u064a\u0646 \u0633\u064a\u0645\u06d0'),'pt':u('Territ\u00f3rios palestinos'),'qu':'Palestina Kamachikuq','rm':'Territori Palestinais','rn':'Palesitina Wesitibanka na Gaza','ro':'*mo','ru':u('\u041f\u0430\u043b\u0435\u0441\u0442\u0438\u043d\u0441\u043a\u0438\u0435 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0641\u0644\u0633\u0637\u06cc\u0646\u06cc'),'se':'*mg','sg':u('S\u00ease t\u00ee Palest\u00eeni'),'si':u('\u0db4\u0dbd\u0dc3\u0dca\u0dad\u0dd3\u0db1 \u0dbb\u0dcf\u0da2\u0dca\u200d\u0dba\u0dba'),'sk':u('Palest\u00ednske \u00fazemia'),'sl':'Palestinsko ozemlje','sm':'*aa','sn':'*aa','so':'Falastiin Daanka galbeed iyo Qasa','sq':'Territoret Palestineze','sr':u('\u041f\u0430\u043b\u0435\u0441\u0442\u0438\u043d\u0441\u043a\u0435 \u0442\u0435\u0440\u0438\u0442\u043e\u0440\u0438\u0458\u0435'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Palestinska territorierna','sw':'Maeneo ya Palestina','ta':u('\u0baa\u0bbe\u0bb2\u0bb8\u0bcd\u0ba4\u0bc0\u0ba9\u0bbf\u0baf \u0baa\u0bbf\u0bb0\u0ba4\u0bc7\u0b9a\u0b99\u0bcd\u0b95\u0bb3\u0bcd'),'te':u('\u0c2a\u0c3e\u0c32\u0c38\u0c4d\u0c24\u0c40\u0c28\u0c3f\u0c2f\u0c28\u0c4d \u0c2a\u0c4d\u0c30\u0c3e\u0c02\u0c24\u0c3e\u0c32\u0c41'),'tg':'*aa','th':u('\u0e14\u0e34\u0e19\u0e41\u0e14\u0e19\u0e1b\u0e32\u0e40\u0e25\u0e2a\u0e44\u0e15\u0e19\u0e4c'),'ti':u('\u121d\u121d\u1215\u12f3\u122d \u134d\u120d\u1235\u1324\u121d'),'tk':u('Palestina territori\u00fdasy'),'tl':'*en','tn':'*aa','to':'Potu Palesitaine','tr':u('Filistin B\u00f6lgeleri'),'ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':u('\u067e\u06d5\u0644\u06d5\u0633\u062a\u0649\u0646 \u0632\u06d0\u0645\u0649\u0646\u0649'),'uk':u('\u041f\u0430\u043b\u0435\u0441\u0442\u0438\u043d\u0441\u044c\u043a\u0456 \u0442\u0435\u0440\u0438\u0442\u043e\u0440\u0456\u0457'),'ur':u('\u0641\u0644\u0633\u0637\u06cc\u0646\u06cc \u062e\u0637\u06d2'),'uz':'Falastin hududlari','ve':'*aa','vi':u('L\u00e3nh th\u1ed5 Palestine'),'vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Iw\u1ecdorun Pakisitian ati Ga\u1e63a'),'za':'*aa','zh':u('\u5df4\u52d2\u65af\u5766\u9886\u571f'),'zu':'i-Palestinian Territories',},
  'PT': {'aa':'Portugal','ab':'*aa','ae':'*aa','af':'*aa','ak':u('P\u0254tugal'),'am':u('\u1356\u122d\u1271\u130b\u120d'),'an':'*aa','ar':u('\u0627\u0644\u0628\u0631\u062a\u063a\u0627\u0644'),'as':u('\u09aa\u09f0\u09cd\u09a4\u09c1\u0997\u09be\u09b2'),'av':'*aa','ay':'*aa','az':'Portuqaliya','ba':'*aa','be':u('\u041f\u0430\u0440\u0442\u0443\u0433\u0430\u043b\u0456\u044f'),'bg':u('\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':u('P\u0254ritigali'),'bn':u('\u09aa\u09b0\u09cd\u09a4\u09c1\u0997\u09be\u09b2'),'bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':u('\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Portugalsko','cu':'*aa','cv':'*aa','cy':'Portiwgal','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f54\u0f7c\u0f62\u0f0b\u0f45\u0f74\u0f0b\u0f42\u0f71\u0f63'),'ee':'Portugal nutome','el':u('\u03a0\u03bf\u03c1\u03c4\u03bf\u03b3\u03b1\u03bb\u03af\u03b1'),'en':'*aa','eo':'Portugalujo','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u067e\u0631\u062a\u063a\u0627\u0644'),'ff':'Purtugaal','fi':'Portugali','fj':'*aa','fo':'*aa','fr':'*aa','fy':'*aa','ga':u('an Phortaing\u00e9il'),'gd':u('A\u2019 Phortagail'),'gl':'*aa','gn':'*aa','gu':u('\u0aaa\u0acb\u0ab0\u0acd\u0a9f\u0ac1\u0a97\u0ab2'),'gv':'*aa','ha':'*aa','he':u('\u05e4\u05d5\u05e8\u05d8\u05d5\u05d2\u05dc'),'hi':u('\u092a\u0941\u0930\u094d\u0924\u0917\u093e\u0932'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':u('Portug\u00e1lia'),'hy':u('\u054a\u0578\u0580\u057f\u0578\u0582\u0563\u0561\u056c\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Port\u00fagal'),'it':'Portogallo','iu':'*aa','iw':'*he','ja':u('\u30dd\u30eb\u30c8\u30ac\u30eb'),'ji':u('\u05e4\u05bc\u05d0\u05e8\u05d8\u05d5\u05d2\u05d0\u05b7\u05dc'),'jv':'*aa','ka':u('\u10de\u10dd\u10e0\u10e2\u10e3\u10d2\u10d0\u10da\u10d8\u10d0'),'kg':'*aa','ki':'Ureno','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u1796\u17d0\u179a\u1791\u17bb\u1799\u17a0\u17d2\u1782\u17b6\u179b\u17cb'),'kn':u('\u0caa\u0ccb\u0cb0\u0ccd\u0c9a\u0cc1\u0c97\u0cb2\u0ccd'),'ko':u('\ud3ec\ub974\ud22c\uac08'),'kr':'*aa','ks':u('\u067e\u064f\u0631\u062a\u0650\u06af\u0627\u0644'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'Potugaali','li':'*aa','ln':u('Put\u00falug\u025bsi'),'lo':u('\u0e9e\u0ead\u0ea5\u0e97\u0eb9\u0ec2\u0e81'),'lt':'Portugalija','lu':'Mputulugeshi','lv':u('Portug\u0101le'),'mg':u('P\u00f4rtiogala'),'mh':'*aa','mi':'*aa','mk':u('\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u0458\u0430'),'ml':u('\u0d2a\u0d4b\u0d7c\u0d1a\u0d4d\u0d1a\u0d41\u0d17\u0d7d'),'mn':u('\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b'),'mo':'Portugalia','mr':u('\u092a\u094b\u0930\u094d\u0924\u0941\u0917\u093e\u0932'),'ms':'*aa','mt':'il-Portugall','my':u('\u1015\u1031\u102b\u103a\u1010\u1030\u1002\u102e'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u092a\u094b\u0930\u094d\u091a\u0941\u0917\u0932'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2a\u0b30\u0b4d\u0b24\u0b4d\u0b24\u0b41\u0b17\u0b3e\u0b32\u0b4d'),'os':'*aa','pa':u('\u0a2a\u0a41\u0a30\u0a24\u0a17\u0a3e\u0a32'),'pi':'*aa','pl':'*mo','ps':u('\u067e\u0648\u0631\u062a\u06ab\u0627\u0644'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'Porutugali','ro':'*mo','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u067e\u0631\u062a\u06af\u0627\u0644'),'se':u('Portug\u00e1la'),'sg':u('P\u00f6rtug\u00e4le, K\u00f6d\u00f6r\u00f6 P\u00fbra'),'si':u('\u0db4\u0dd8\u0dad\u0dd4\u0d9c\u0dcf\u0dbd\u0dba'),'sk':'*cs','sl':'Portugalska','sm':'*aa','sn':'*aa','so':'Bortuqaal','sq':'*fi','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*ki','ta':u('\u0baa\u0bcb\u0bb0\u0bcd\u0b9a\u0bcd\u0b9a\u0bc1\u0b95\u0bcd\u0b95\u0bb2\u0bcd'),'te':u('\u0c2a\u0c4b\u0c30\u0c4d\u0c1a\u0c41\u0c17\u0c32\u0c4d'),'tg':'*bg','th':u('\u0e42\u0e1b\u0e23\u0e15\u0e38\u0e40\u0e01\u0e2a'),'ti':'*am','tk':u('Portugali\u00fda'),'tl':'*aa','tn':'*aa','to':'Potukali','tr':'Portekiz','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u067e\u0648\u0631\u062a\u06c7\u06af\u0627\u0644\u0649\u064a\u06d5'),'uk':u('\u041f\u043e\u0440\u0442\u0443\u0491\u0430\u043b\u0456\u044f'),'ur':'*sd','uz':'Portugaliya','ve':'*aa','vi':u('B\u1ed3 \u0110\u00e0o Nha'),'vo':'*aa','wa':'*aa','wo':'Portigaal','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de P\u1ecdtugi'),'za':'*aa','zh':u('\u8461\u8404\u7259'),'zu':'i-Portugal',},
  'PW': {'aa':'Palau','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u1353\u120b\u12cd'),'an':'*aa','ar':u('\u0628\u0627\u0644\u0627\u0648'),'as':u('\u09aa\u09be\u09b2\u09be\u0989'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u041f\u0430\u043b\u0430\u0443'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'Palawu','bn':'*as','bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f54\u0f0b\u0f63\u0f60\u0f74'),'ee':'Palau nutome','el':u('\u03a0\u03b1\u03bb\u03ac\u03bf\u03c5'),'en':'*aa','eo':u('Bela\u016do'),'es':'Palaos','et':'Belau','eu':'*aa','fa':u('\u067e\u0627\u0644\u0627\u0626\u0648'),'ff':'*bm','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*es','fy':'*aa','ga':u('Oile\u00e1in Palau'),'gd':'Palabh','gl':'*aa','gn':'*aa','gu':u('\u0aaa\u0ab2\u0abe\u0a89'),'gv':'*aa','ha':'*aa','he':u('\u05e4\u05dc\u05d0\u05d5'),'hi':u('\u092a\u0932\u093e\u090a'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u054a\u0561\u056c\u0561\u0578\u0582'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Pal\u00e1'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30d1\u30e9\u30aa'),'ji':'*aa','jv':'*aa','ka':u('\u10de\u10d0\u10da\u10d0\u10e3'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u1795\u17c5\u17a1\u17bc'),'kn':u('\u0caa\u0cb2\u0cbe\u0cb5\u0cc1'),'ko':u('\ud314\ub77c\uc6b0'),'kr':'*aa','ks':u('\u067e\u064e\u0644\u0627\u0648'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*aa','lg':'*bm','li':'*aa','ln':'*aa','lo':u('\u0e9b\u0eb2\u0ea5\u0eb2\u0ea7'),'lt':'*aa','lu':'*aa','lv':'*aa','mg':'Palao','mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d2a\u0d32\u0d3e\u0d35\u0d41'),'mn':'*be','mo':'*aa','mr':'*hi','ms':'*aa','mt':'*aa','my':u('\u1015\u101c\u102c\u1021\u102d\u102f'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u092a\u0932\u093e\u0909'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2a\u0b3e\u0b32\u0b3e\u0b09'),'os':'*aa','pa':u('\u0a2a\u0a32\u0a3e\u0a09'),'pi':'*aa','pl':'*aa','ps':u('\u067e\u0644\u0648'),'pt':'*aa','qu':'*es','rm':'*aa','rn':'*bm','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u067e\u0644\u0627\u0626\u0648'),'se':'*aa','sg':'*aa','si':u('\u0db4\u0dbd\u0dcf\u0dc0\u0dd4'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*aa','sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0baa\u0bbe\u0bb2\u0bcb'),'te':u('\u0c2a\u0c3e\u0c32\u0c3e\u0c35\u0c4d'),'tg':'*be','th':u('\u0e1b\u0e32\u0e40\u0e25\u0e32'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':'*aa','tr':'*aa','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u067e\u0627\u0644\u0627\u0626\u06c7'),'uk':'*be','ur':u('\u067e\u0644\u0627\u0624'),'uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Palaw','xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Paalu'),'za':'*aa','zh':u('\u5e15\u52b3'),'zu':'i-Palau',},
  'PY': {'aa':'Paraguay','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u1353\u122b\u1313\u12ed'),'an':'*aa','ar':u('\u0628\u0627\u0631\u0627\u063a\u0648\u0627\u064a'),'as':u('\u09aa\u09be\u09f0\u09be\u0997\u09c1\u09f1\u09c7'),'av':'*aa','ay':'*aa','az':'Paraqvay','ba':'*aa','be':u('\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'Paraguwayi','bn':u('\u09aa\u09cd\u09af\u09be\u09b0\u09be\u0997\u09c1\u09af\u09bc\u09c7'),'bo':'*aa','br':'*aa','bs':'Paragvaj','ca':'Paraguai','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f54\u0f0b\u0f62\u0f0b\u0f42\u0f74\u0f0b\u0f5d\u0f60\u0f72'),'ee':'Paragua nutome','el':u('\u03a0\u03b1\u03c1\u03b1\u03b3\u03bf\u03c5\u03ac\u03b7'),'en':'*aa','eo':'Paragvajo','es':'*aa','et':'*aa','eu':'*ca','fa':u('\u067e\u0627\u0631\u0627\u06af\u0648\u0626\u0647'),'ff':'Paraguwaay','fi':'*aa','fj':'*aa','fo':'*ca','fr':'*aa','fy':'*aa','ga':'Paragua','gd':'Paraguaidh','gl':'*ca','gn':'*aa','gu':u('\u0aaa\u0ac7\u0ab0\u0abe\u0a97\u0acd\u0ab5\u0ac7'),'gv':'*aa','ha':'Paragai','he':u('\u05e4\u05e8\u05d2\u05d5\u05d5\u05d0\u05d9'),'hi':u('\u092a\u0930\u093e\u0917\u094d\u0935\u0947'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u054a\u0561\u0580\u0561\u0563\u057e\u0561\u0575'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Paragv\u00e6'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30d1\u30e9\u30b0\u30a2\u30a4'),'ji':u('\u05e4\u05bc\u05d0\u05b7\u05e8\u05d0\u05b7\u05d2\u05d5\u05d5\u05f2\u05b7'),'jv':'*aa','ka':u('\u10de\u10d0\u10e0\u10d0\u10d2\u10d5\u10d0\u10d8'),'kg':'*aa','ki':'Paragwai','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u1794\u17c9\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17b6\u1799'),'kn':u('\u0caa\u0cb0\u0cbe\u0c97\u0ccd\u0cb5\u0cc7'),'ko':u('\ud30c\ub77c\uacfc\uc774'),'kr':'*aa','ks':u('\u067e\u064e\u0631\u0627\u06af\u064f\u06d2'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*aa','lg':'Paragwayi','li':'*aa','ln':'Palagwei','lo':u('\u0e9e\u0eb2\u0ea3\u0eb2\u0e81\u0ea7\u0e8d'),'lt':'Paragvajus','lu':'*ln','lv':'Paragvaja','mg':'Paragoay','mh':'*aa','mi':'*aa','mk':u('\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0458'),'ml':u('\u0d2a\u0d30\u0d3e\u0d17\u0d4d\u0d35\u0d47'),'mn':'*be','mo':'*aa','mr':'*hi','ms':'*aa','mt':'il-Paragwaj','my':u('\u1015\u102b\u101b\u102c\u1002\u103d\u1031\u1038'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u092a\u094d\u092f\u093e\u0930\u093e\u0917\u094d\u0935\u0947'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b2a\u0b3e\u0b30\u0b3e\u0b17\u0b41\u0b0f'),'os':'*aa','pa':u('\u0a2a\u0a48\u0a30\u0a3e\u0a17\u0a35\u0a47'),'pi':'*aa','pl':'Paragwaj','ps':u('\u067e\u0627\u0631\u0627\u06ab\u0648\u06cc'),'pt':'*ca','qu':'*aa','rm':'*ca','rn':'Paragwe','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u067e\u064a\u0631\u0627\u06af\u0648\u0621\u0650'),'se':'*aa','sg':u('Paragu\u00ebe'),'si':u('\u0db4\u0dd0\u0dbb\u0d9c\u0dd4\u0dc0\u0dda'),'sk':'Paraguaj','sl':'*bs','sm':'*aa','sn':'*aa','so':'*aa','sq':'*ca','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0baa\u0bb0\u0bbe\u0b95\u0bc1\u0bb5\u0bc7'),'te':u('\u0c2a\u0c30\u0c3e\u0c17\u0c4d\u0c35\u0c47'),'tg':'*be','th':u('\u0e1b\u0e32\u0e23\u0e32\u0e01\u0e27\u0e31\u0e22'),'ti':'*am','tk':u('Paragwa\u00fd'),'tl':'*aa','tn':'*aa','to':'Palakuai','tr':'*aa','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u067e\u0627\u0631\u0627\u06af\u06cb\u0627\u064a'),'uk':u('\u041f\u0430\u0440\u0430\u0491\u0432\u0430\u0439'),'ur':u('\u067e\u06cc\u0631\u0627\u06af\u0648\u0626\u06d2'),'uz':'Paragvay','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Paraguwe','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Paraguye'),'za':'*aa','zh':u('\u5df4\u62c9\u572d'),'zu':'i-Paraguay',},
  'QA': {'aa':'Qatar','ab':'*aa','ae':'*aa','af':'Katar','ak':'Kata','am':u('\u12b3\u1273\u122d'),'an':'*aa','ar':u('\u0642\u0637\u0631'),'as':u('\u0995\u09be\u099f\u09be\u09f0'),'av':'*aa','ay':'*aa','az':u('Q\u0259t\u0259r'),'ba':'*aa','be':u('\u041a\u0430\u0442\u0430\u0440'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'Katari','bn':u('\u0995\u09be\u09a4\u09be\u09b0'),'bo':'*aa','br':'*aa','bs':'*af','ca':'*aa','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*af','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*af','dv':'*aa','dz':u('\u0f40\u0f0b\u0f4a\u0f62'),'ee':'Katar nutome','el':u('\u039a\u03b1\u03c4\u03ac\u03c1'),'en':'*aa','eo':'Kataro','es':'Catar','et':'*af','eu':'*aa','fa':'*ar','ff':'Kataar','fi':'*aa','fj':'*aa','fo':'*af','fr':'*aa','fy':'*aa','ga':'*es','gd':'*es','gl':'*aa','gn':'*aa','gu':u('\u0a95\u0aa4\u0abe\u0ab0'),'gv':'*aa','ha':'Kwatar','he':u('\u05e7\u05d8\u05d0\u05e8'),'hi':u('\u0915\u093c\u0924\u0930'),'ho':'*aa','hr':'*af','ht':'*aa','hu':'*af','hy':u('\u053f\u0561\u057f\u0561\u0580'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*af','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30ab\u30bf\u30fc\u30eb'),'ji':u('\u05e7\u05d0\u05b7\u05d8\u05d0\u05b7\u05e8'),'jv':'*aa','ka':u('\u10d9\u10d0\u10e2\u10d0\u10e0\u10d8'),'kg':'*aa','ki':'*bm','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u1780\u17b6\u178f\u17b6'),'kn':u('\u0c96\u0ca4\u0cbe\u0cb0\u0ccd'),'ko':u('\uce74\ud0c0\ub974'),'kr':'*aa','ks':u('\u0642\u064e\u0637\u0650\u0631'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*af','lg':'Kataa','li':'*aa','ln':'*bm','lo':u('\u0e81\u0eb2\u0e95\u0eb2'),'lt':'Kataras','lu':'*bm','lv':'Katara','mg':'*af','mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d16\u0d24\u0d4d\u0d24\u0d7c'),'mn':'*be','mo':'*aa','mr':u('\u0915\u0924\u093e\u0930'),'ms':'*aa','mt':'il-Qatar','my':u('\u1000\u102c\u1010\u102c'),'na':'*aa','nb':'*aa','nd':'Kathari','ne':'*mr','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b15\u0b24\u0b3e\u0b30\u0b4d'),'os':'*aa','pa':u('\u0a15\u0a24\u0a30'),'pi':'*aa','pl':'*af','ps':'*ar','pt':'*es','qu':'*aa','rm':'*af','rn':'*bm','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*ar','se':'*aa','sg':u('Kat\u00e4ra'),'si':u('\u0d9a\u0da7\u0dcf\u0dbb\u0dca'),'sk':'*af','sl':'*af','sm':'*aa','sn':'*aa','so':'Qadar','sq':'*af','sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b95\u0ba4\u0bcd\u0ba4\u0bbe\u0bb0\u0bcd'),'te':u('\u0c16\u0c24\u0c3e\u0c30\u0c4d'),'tg':u('\u049a\u0430\u0442\u0430\u0440'),'th':u('\u0e01\u0e32\u0e15\u0e32\u0e23\u0e4c'),'ti':u('\u1240\u1320\u122d'),'tk':'*af','tl':'*aa','tn':'*aa','to':u('Kat\u0101'),'tr':'*af','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u0642\u0627\u062a\u0627\u0631'),'uk':'*be','ur':'*ar','uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*ff','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Kota'),'za':'*aa','zh':u('\u5361\u5854\u5c14'),'zu':'i-Qatar',},
  'RE': {'aa':'Reunion','ab':'*aa','ae':'*aa','af':u('R\u00e9union'),'ak':u('Reyuni\u0254n'),'am':u('\u122a\u12e9\u1292\u12e8\u1295'),'an':'*aa','ar':u('\u0631\u0648\u064a\u0646\u064a\u0648\u0646'),'as':u('\u09f0\u09bf\u0987\u0989\u09a8\u09bf\u09af\u09bc\u09a8'),'av':'*aa','ay':'*aa','az':'Reyunyon','ba':'*aa','be':u('\u0420\u044d\u044e\u043d\u044c\u0451\u043d'),'bg':u('\u0420\u0435\u044e\u043d\u0438\u043e\u043d'),'bh':'*aa','bi':'*aa','bm':u('Reyu\u0272\u0254\u014b'),'bn':u('\u09b0\u09bf\u0987\u0989\u09a8\u09bf\u09af\u09bc\u09a8'),'bo':'*aa','br':u('Ar Re\u00fcnion'),'bs':'*aa','ca':u('Illa de la Reuni\u00f3'),'ce':u('\u0420\u0435\u044e\u043d\u044c\u043e\u043d'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*af','cu':'*aa','cv':'*aa','cy':'*af','da':'*af','de':'*af','dv':'*aa','dz':u('\u0f62\u0f7a\u0f0b\u0f61\u0f74\u0f0b\u0f53\u0f72\u0f0b\u0f61\u0f7c\u0f53'),'ee':u('R\u00e9union nutome'),'el':u('\u03a1\u03b5\u03ca\u03bd\u03b9\u03cc\u03bd'),'en':'*af','eo':'Reunio','es':u('Reuni\u00f3n'),'et':'*af','eu':'*aa','fa':u('\u0631\u0626\u0648\u0646\u06cc\u0648\u0646'),'ff':u('Rewi\u00f1oo'),'fi':'*af','fj':'*aa','fo':'*af','fr':u('La R\u00e9union'),'fy':'*af','ga':'*af','gd':'*af','gl':'*es','gn':'*aa','gu':u('\u0ab0\u0ac0\u0aaf\u0ac1\u0aa8\u0abf\u0aaf\u0aa8'),'gv':'*aa','ha':'Rawuniyan','he':u('\u05e8\u05d0\u05d5\u05e0\u05d9\u05d5\u05df'),'hi':u('\u0930\u093f\u092f\u0942\u0928\u093f\u092f\u0928'),'ho':'*aa','hr':'*af','ht':'*aa','hu':'*af','hy':u('\u054c\u0565\u0575\u0578\u0582\u0576\u056b\u0578\u0576'),'hz':'*aa','ia':'*aa','id':'*af','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*af','io':'*aa','is':'*af','it':'Riunione','iu':'*aa','iw':'*he','ja':u('\u30ec\u30e6\u30cb\u30aa\u30f3'),'ji':u('\u05e8\u05e2\u05d0\u05d5\u05e0\u05d9\u05d0\u05df'),'jv':'*aa','ka':u('\u10e0\u10d4\u10e3\u10dc\u10d8\u10dd\u10dc\u10d8'),'kg':'*aa','ki':'Riyunioni','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u179a\u17c1\u17a2\u17bb\u1799\u1789\u17c9\u17bb\u1784'),'kn':u('\u0cb0\u0cbf\u0caf\u0cc2\u0ca8\u0cbf\u0caf\u0ca8\u0ccd'),'ko':u('\ub9ac\uc720\ub2c8\uc628'),'kr':'*aa','ks':u('\u0631\u0650\u06cc\u0648\u0657\u0646\u0650\u06cc\u064e\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*af','lg':'Leyunyoni','li':'*aa','ln':'Lenyo','lo':u('\u0ec0\u0ea3\u0ead\u0eb9\u0e99\u0eb4\u0e8d\u0ebb\u0e87'),'lt':'Reunjonas','lu':'*ln','lv':'Reinjona','mg':'Larenion','mh':'*aa','mi':'*aa','mk':u('\u0420\u0435\u0443\u043d\u0438\u043e\u043d'),'ml':u('\u0d31\u0d40\u0d2f\u0d42\u0d23\u0d3f\u0d2f\u0d7b'),'mn':'*bg','mo':'*af','mr':u('\u0930\u093f\u092f\u0941\u0928\u093f\u092f\u0928'),'ms':'*aa','mt':'*af','my':u('\u101b\u102e\u101a\u1030\u1014\u102e\u101a\u1014\u103a'),'na':'*aa','nb':'*af','nd':'*af','ne':'*mr','ng':'*aa','nl':'*af','nn':'*af','no':'*af','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b30\u0b3f\u0b5f\u0b41\u0b28\u0b3f\u0b05\u0b28\u0b4d'),'os':'*aa','pa':u('\u0a30\u0a3f\u0a2f\u0a42\u0a28\u0a40\u0a05\u0a28'),'pi':'*aa','pl':'*aa','ps':u('\u0631\u06cc\u0648\u0646\u06cc\u0646'),'pt':u('Reuni\u00e3o'),'qu':'*aa','rm':'*af','rn':'Amazinga ya Reyiniyo','ro':'*af','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0631\u064a \u064a\u0648\u0646\u064a\u0646'),'se':'*af','sg':u('Rein\u00efon'),'si':u('\u0dbb\u0dd3\u0dba\u0dd4\u0db1\u0dd2\u0dba\u0db1\u0dca'),'sk':'*af','sl':'*aa','sm':'*aa','sn':'*af','so':'*af','sq':'*aa','sr':u('\u0420\u0435\u0438\u043d\u0438\u043e\u043d'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*af','sw':'*aa','ta':u('\u0bb0\u0bc0\u0baf\u0bc2\u0ba9\u0bbf\u0baf\u0ba9\u0bcd'),'te':u('\u0c30\u0c3f\u0c2f\u0c42\u0c28\u0c3f\u0c2f\u0c28\u0c4d'),'tg':'*bg','th':u('\u0e40\u0e23\u0e2d\u0e39\u0e19\u0e35\u0e22\u0e07'),'ti':'*am','tk':u('Re\u00fdun\u00fdon'),'tl':'*af','tn':'*aa','to':u('L\u0113unioni'),'tr':'*af','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u0631\u06d0\u064a\u06c7\u0646\u0649\u064a\u0648\u0646'),'uk':u('\u0420\u0435\u044e\u043d\u044c\u0439\u043e\u043d'),'ur':u('\u0631\u06cc \u06cc\u0648\u0646\u06cc\u0646'),'uz':'Reyunion','ve':'*aa','vi':'*af','vo':'*aa','wa':'*aa','wo':u('Ree\u00f1oo'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Riuniyan'),'za':'*aa','zh':u('\u7559\u5c3c\u6c6a'),'zu':u('i-R\u00e9union'),},
  'RO': {'aa':'Romania','ab':'*aa','ae':'*aa','af':u('Roemeni\u00eb'),'ak':'Romenia','am':u('\u122e\u121c\u1292\u12eb'),'an':'*aa','ar':u('\u0631\u0648\u0645\u0627\u0646\u064a\u0627'),'as':u('\u09f0\u09cb\u09ae\u09be\u09a8\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':u('Rum\u0131niya'),'ba':'*aa','be':u('\u0420\u0443\u043c\u044b\u043d\u0456\u044f'),'bg':u('\u0420\u0443\u043c\u044a\u043d\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Rumani','bn':u('\u09b0\u09cb\u09ae\u09be\u09a8\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'Roumania','bs':'Rumunija','ca':'*aa','ce':u('\u0420\u0443\u043c\u044b\u043d\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Rumunsko','cu':'*aa','cv':'*aa','cy':'Rwmania','da':u('Rum\u00e6nien'),'de':u('Rum\u00e4nien'),'dv':'*aa','dz':u('\u0f62\u0f7c\u0f0b\u0f58\u0f7a\u0f0b\u0f53\u0f72\u0f0b\u0f61'),'ee':'Romania nutome','el':u('\u03a1\u03bf\u03c5\u03bc\u03b1\u03bd\u03af\u03b1'),'en':'*aa','eo':'Rumanujo','es':u('Ruman\u00eda'),'et':'Rumeenia','eu':'Errumania','fa':u('\u0631\u0648\u0645\u0627\u0646\u06cc'),'ff':'Rumanii','fi':'*aa','fj':'*aa','fo':'Rumenia','fr':'Roumanie','fy':'*af','ga':u('an R\u00f3m\u00e1in'),'gd':u('Rom\u00e0inia'),'gl':u('Roman\u00eda'),'gn':'*aa','gu':u('\u0ab0\u0acb\u0aae\u0abe\u0aa8\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Romaniya','he':u('\u05e8\u05d5\u05de\u05e0\u05d9\u05d4'),'hi':u('\u0930\u094b\u092e\u093e\u0928\u093f\u092f\u093e'),'ho':'*aa','hr':'Rumunjska','ht':'*aa','hu':u('Rom\u00e1nia'),'hy':u('\u054c\u0578\u0582\u0574\u056b\u0576\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'Rumania','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('R\u00famen\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30eb\u30fc\u30de\u30cb\u30a2'),'ji':u('\u05e8\u05d5\u05de\u05e2\u05e0\u05d9\u05e2'),'jv':'*aa','ka':u('\u10e0\u10e3\u10db\u10d8\u10dc\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u0420\u0443\u043c\u044b\u043d\u0438\u044f'),'kl':'*aa','km':u('\u179a\u17bc\u1798\u17c9\u17b6\u1793\u17b8'),'kn':u('\u0cb0\u0cca\u0cae\u0cc7\u0ca8\u0cbf\u0caf\u0cbe'),'ko':u('\ub8e8\ub9c8\ub2c8\uc544'),'kr':'*aa','ks':u('\u0631\u0648\u0645\u0627\u0646\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*de','lg':'Lomaniya','li':'*aa','ln':'Romani','lo':u('\u0ec2\u0ea3\u0ec1\u0ea1\u0ec0\u0e99\u0e8d'),'lt':'*bs','lu':'*ln','lv':u('Rum\u0101nija'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0420\u043e\u043c\u0430\u043d\u0438\u0458\u0430'),'ml':u('\u0d31\u0d4a\u0d2e\u0d3e\u0d28\u0d3f\u0d2f'),'mn':u('\u0420\u0443\u043c\u044b\u043d'),'mo':u('Rom\u00e2nia'),'mr':'*hi','ms':'*aa','mt':'ir-Rumanija','my':u('\u101b\u102d\u102f\u1019\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0930\u094b\u092e\u0947\u0928\u093f\u092f\u093e'),'ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b30\u0b4b\u0b2e\u0b3e\u0b28\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a30\u0a4b\u0a2e\u0a3e\u0a28\u0a40\u0a06'),'pi':'*aa','pl':'Rumunia','ps':u('\u0631\u0648\u0645\u0627\u0646\u06cc\u0627'),'pt':u('Rom\u00eania'),'qu':'*aa','rm':'*fo','rn':'Rumaniya','ro':'*mo','ru':'*kk','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*ar','se':'*hu','sg':u('Ruman\u00efi'),'si':u('\u0dbb\u0dd4\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*cs','sl':'Romunija','sm':'*aa','sn':'*aa','so':'Rumaaniya','sq':'*bm','sr':u('\u0420\u0443\u043c\u0443\u043d\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*de','sw':'*aa','ta':u('\u0bb0\u0bc1\u0bae\u0bc7\u0ba9\u0bbf\u0baf\u0bbe'),'te':u('\u0c30\u0c4b\u0c2e\u0c3e\u0c28\u0c3f\u0c2f\u0c3e'),'tg':u('\u0420\u0443\u043c\u0438\u043d\u0438\u044f'),'th':u('\u0e42\u0e23\u0e21\u0e32\u0e40\u0e19\u0e35\u0e22'),'ti':'*am','tk':u('Rumyni\u00fda'),'tl':'*aa','tn':'*aa','to':u('Lom\u0113nia'),'tr':'Romanya','ts':'*aa','tt':'*kk','tw':'*aa','ty':'*aa','ug':u('\u0631\u0648\u0645\u0649\u0646\u0649\u064a\u06d5'),'uk':u('\u0420\u0443\u043c\u0443\u043d\u0456\u044f'),'ur':u('\u0631\u0648\u0645\u0627\u0646\u06cc\u06c1'),'uz':'Ruminiya','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*bm','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Romaniya'),'za':'*aa','zh':u('\u7f57\u9a6c\u5c3c\u4e9a'),'zu':'i-Romania',},
  'RS': {'aa':'Serbia','ab':'*aa','ae':'*aa','af':u('Serwi\u00eb'),'ak':'*aa','am':u('\u1230\u122d\u1265\u12eb'),'an':'*aa','ar':u('\u0635\u0631\u0628\u064a\u0627'),'as':u('\u099b\u09be\u09f0\u09cd\u09ac\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Serbiya','ba':'*aa','be':u('\u0421\u0435\u0440\u0431\u0456\u044f'),'bg':u('\u0421\u044a\u0440\u0431\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u09b8\u09be\u09b0\u09cd\u09ac\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'*aa','bs':'Srbija','ca':u('S\u00e8rbia'),'ce':u('\u0421\u0435\u0440\u0431\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Srbsko','cu':'*aa','cv':'*aa','cy':'*aa','da':'Serbien','de':'*da','dv':'*aa','dz':u('\u0f66\u0f71\u0f62\u0f0b\u0f56\u0fb7\u0f72\u0f0b\u0f61'),'ee':'*aa','el':u('\u03a3\u03b5\u03c1\u03b2\u03af\u03b1'),'en':'*aa','eo':'*aa','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0635\u0631\u0628\u0633\u062a\u0627\u0646'),'ff':'*aa','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Serbie','fy':u('Servi\u00eb'),'ga':'an tSeirbia','gd':u('An t-S\u00e8irb'),'gl':'*aa','gn':'*aa','gu':u('\u0ab8\u0ab0\u0acd\u0aac\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'*aa','he':u('\u05e1\u05e8\u05d1\u05d9\u05d4'),'hi':u('\u0938\u0930\u094d\u092c\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'Szerbia','hy':u('\u054d\u0565\u0580\u0562\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Serb\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30bb\u30eb\u30d3\u30a2'),'ji':u('\u05e1\u05e2\u05e8\u05d1\u05d9\u05e2'),'jv':'*aa','ka':u('\u10e1\u10d4\u10e0\u10d1\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u0421\u0435\u0440\u0431\u0438\u044f'),'kl':'*aa','km':u('\u179f\u17c2\u1794\u17ca\u17b8'),'kn':u('\u0cb8\u0cc6\u0cb0\u0ccd\u0cac\u0cbf\u0caf\u0cbe'),'ko':u('\uc138\ub974\ube44\uc544'),'kr':'*aa','ks':u('\u0633\u064e\u0631\u0628\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*da','lg':'*aa','li':'*aa','ln':'*fr','lo':u('\u0ec0\u0e8a\u0eb5\u0ec0\u0e9a\u0e8d'),'lt':'Serbija','lu':'*aa','lv':'*lt','mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0421\u0440\u0431\u0438\u0458\u0430'),'ml':u('\u0d38\u0d46\u0d7c\u0d2c\u0d3f\u0d2f'),'mn':'*ce','mo':'*aa','mr':'*hi','ms':'*aa','mt':'is-Serbja','my':u('\u1006\u102c\u1038\u1018\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'*aa','ne':'*hi','ng':'*aa','nl':'*fy','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b30\u0b4d\u0b2c\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a38\u0a30\u0a2c\u0a40\u0a06'),'pi':'*aa','pl':'*aa','ps':u('\u0635\u0631\u0628\u06cc\u0627'),'pt':u('S\u00e9rvia'),'qu':'*aa','rm':'*aa','rn':'*aa','ro':'*aa','ru':'*kk','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u0631\u0628\u064a\u0627'),'se':'*aa','sg':'*aa','si':u('\u0dc3\u0dbb\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*cs','sl':'*bs','sm':'*aa','sn':'*aa','so':'*aa','sq':'Serbi','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':u('\u0b9a\u0bc6\u0bb0\u0bcd\u0baa\u0bbf\u0baf\u0bbe'),'te':u('\u0c38\u0c46\u0c30\u0c4d\u0c2c\u0c3f\u0c2f\u0c3e'),'tg':'*kk','th':u('\u0e40\u0e0b\u0e2d\u0e23\u0e4c\u0e40\u0e1a\u0e35\u0e22'),'ti':u('\u1230\u122d\u1262\u12eb'),'tk':u('Serbi\u00fda'),'tl':'*aa','tn':'*aa','to':u('S\u0113pia'),'tr':u('S\u0131rbistan'),'ts':'*aa','tt':'*kk','tw':'*aa','ty':'*aa','ug':u('\u0633\u06d0\u0631\u0628\u0649\u064a\u06d5'),'uk':'*be','ur':u('\u0633\u0631\u0628\u06cc\u0627'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*sq','xh':'*aa','yi':'*ji','yo':'*aa','za':'*aa','zh':u('\u585e\u5c14\u7ef4\u4e9a'),'zu':'i-Serbia',},
  'RU': {'aa':'Russia','ab':'*aa','ae':'*aa','af':'Rusland','ak':u('R\u0254hyea'),'am':u('\u1229\u1235\u12eb'),'an':'*aa','ar':u('\u0631\u0648\u0633\u064a\u0627'),'as':u('\u09f0\u09be\u099b\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Rusiya','ba':'*aa','be':u('\u0420\u0430\u0441\u0456\u044f'),'bg':u('\u0420\u0443\u0441\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Irisi','bn':u('\u09b0\u09be\u09b6\u09bf\u09af\u09bc\u09be'),'bo':u('\u0f68\u0f74\u0f0b\u0f62\u0f74\u0f0b\u0f66\u0f74\u0f0b'),'br':'Rusia','bs':'Rusija','ca':u('R\u00fassia'),'ce':u('\u0420\u043e\u0441\u0441\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Rusko','cu':'*aa','cv':'*aa','cy':'Rwsia','da':'*af','de':'Russland','dv':'*aa','dz':u('\u0f68\u0f74\u0f0b\u0f62\u0f74\u0f0b\u0f66\u0f74'),'ee':'Russia nutome','el':u('\u03a1\u03c9\u03c3\u03af\u03b1'),'en':'*aa','eo':'Rusujo','es':'*br','et':'Venemaa','eu':'Errusia','fa':u('\u0631\u0648\u0633\u06cc\u0647'),'ff':'Riisii','fi':u('Ven\u00e4j\u00e4'),'fj':'*aa','fo':'*de','fr':'Russie','fy':u('Rusl\u00e2n'),'ga':u('an R\u00fais'),'gd':'An Ruis','gl':'*br','gn':'*aa','gu':u('\u0ab0\u0ab6\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Rasha','he':u('\u05e8\u05d5\u05e1\u05d9\u05d4'),'hi':u('\u0930\u0942\u0938'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Oroszorsz\u00e1g'),'hy':u('\u054c\u0578\u0582\u057d\u0561\u057d\u057f\u0561\u0576'),'hz':'*aa','ia':'*aa','id':'*br','ie':'*aa','ig':'*aa','ii':u('\ua289\ua1c6\ua326'),'ik':'*aa','in':'*br','io':'*aa','is':u('R\u00fassland'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30ed\u30b7\u30a2'),'ji':u('\u05e8\u05d5\u05e1\u05dc\u05d0\u05b7\u05e0\u05d3'),'jv':'*aa','ka':u('\u10e0\u10e3\u10e1\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'Urusi','kj':'*aa','kk':u('\u0420\u0435\u0441\u0435\u0439'),'kl':'*aa','km':u('\u179a\u17bb\u179f\u17d2\u179f\u17ca\u17b8'),'kn':u('\u0cb0\u0cb7\u0ccd\u0caf\u0cbe'),'ko':u('\ub7ec\uc2dc\uc544'),'kr':'*aa','ks':u('\u0631\u0648\u0657\u0633'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0420\u043e\u0441\u0441\u0438\u044f'),'la':'*aa','lb':'*de','lg':'Lasa','li':'*aa','ln':u('Ris\u00ed'),'lo':u('\u0ea3\u0eb1\u0e94\u0ec0\u0e8a\u0e8d'),'lt':'*bs','lu':'Risi','lv':'Krievija','mg':'Rosia','mh':'*aa','mi':'*aa','mk':u('\u0420\u0443\u0441\u0438\u0458\u0430'),'ml':u('\u0d31\u0d37\u0d4d\u0d2f'),'mn':u('\u041e\u0440\u043e\u0441'),'mo':'*br','mr':u('\u0930\u0936\u093f\u092f\u093e'),'ms':'*br','mt':'ir-Russja','my':u('\u101b\u102f\u101b\u103e\u102c\u1038'),'na':'*aa','nb':'*de','nd':'Rashiya','ne':'*hi','ng':'*aa','nl':'*af','nn':'*de','no':'*de','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b30\u0b41\u0b37\u0b3f\u0b06'),'os':u('\u0423\u04d5\u0440\u04d5\u0441\u0435'),'pa':u('\u0a30\u0a42\u0a38'),'pi':'*aa','pl':'Rosja','ps':'*fa','pt':'*ca','qu':'*br','rm':'*aa','rn':'Uburusiya','ro':'*br','ru':'*ky','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0631\u0648\u0633'),'se':u('Ruo\u0161\u0161a'),'sg':u('Rus\u00efi'),'si':u('\u0dbb\u0dd4\u0dc3\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*cs','sl':'*bs','sm':'*aa','sn':'*aa','so':'Ruush','sq':'Rusi','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'Ryssland','sw':'*ki','ta':u('\u0bb0\u0bb7\u0bcd\u0baf\u0bbe'),'te':u('\u0c30\u0c37\u0c4d\u0c2f\u0c3e'),'tg':'*bg','th':u('\u0e23\u0e31\u0e2a\u0e40\u0e0b\u0e35\u0e22'),'ti':u('\u122b\u123a\u12eb'),'tk':u('Russi\u00fda'),'tl':'*aa','tn':'*aa','to':u('L\u016bsia'),'tr':'Rusya','ts':'*aa','tt':'*ky','tw':'*aa','ty':'*aa','ug':u('\u0631\u06c7\u0633\u0649\u064a\u06d5'),'uk':u('\u0420\u043e\u0441\u0456\u044f'),'ur':'*sd','uz':'Rossiya','ve':'*aa','vi':'Nga','vo':'*aa','wa':'*aa','wo':'*lu','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de R\u1ecd\u1e63ia'),'za':'*aa','zh':u('\u4fc4\u7f57\u65af'),'zu':'i-Russia',},
  'RW': {'aa':'Rwanda','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u1229\u12cb\u1295\u12f3'),'an':'*aa','ar':u('\u0631\u0648\u0627\u0646\u062f\u0627'),'as':u('\u09f0\u09cb\u09f1\u09be\u09a3\u09cd\u09a1\u09be'),'av':'*aa','ay':'*aa','az':'Ruanda','ba':'*aa','be':u('\u0420\u0443\u0430\u043d\u0434\u0430'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'Ruwanda','bn':u('\u09b0\u09c1\u09af\u09bc\u09be\u09a8\u09cd\u09a1\u09be'),'bo':'*aa','br':'*aa','bs':'*az','ca':'*az','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*az','dv':'*aa','dz':u('\u0f62\u0f74\u0f0b\u0f5d\u0f53\u0f0b\u0f4c'),'ee':'Rwanda nutome','el':u('\u03a1\u03bf\u03c5\u03ac\u03bd\u03c4\u03b1'),'en':'*aa','eo':'Ruando','es':'*az','et':'*aa','eu':'*az','fa':'*ar','ff':'Ruwanndaa','fi':'*az','fj':'*aa','fo':'*az','fr':'*aa','fy':'*aa','ga':'*az','gd':'Rubhanda','gl':'*az','gn':'*aa','gu':u('\u0ab0\u0ab5\u0abe\u0a82\u0aa1\u0abe'),'gv':'*aa','ha':'*bm','he':u('\u05e8\u05d5\u05d0\u05e0\u05d3\u05d4'),'hi':u('\u0930\u0935\u093e\u0902\u0921\u093e'),'ho':'*aa','hr':'*az','ht':'*aa','hu':'*az','hy':u('\u054c\u0578\u0582\u0561\u0576\u0564\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('R\u00faanda'),'it':'*az','iu':'*aa','iw':'*he','ja':u('\u30eb\u30ef\u30f3\u30c0'),'ji':u('\u05e8\u05d5\u05d5\u05d0\u05b7\u05e0\u05d3\u05e2'),'jv':'*aa','ka':u('\u10e0\u10e3\u10d0\u10dc\u10d3\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u179a\u179c\u17c9\u17b6\u1793\u17cb\u178a\u17b6'),'kn':u('\u0cb0\u0cc1\u0cb5\u0cbe\u0c82\u0ca1\u0cbe'),'ko':u('\ub974\uc644\ub2e4'),'kr':'*aa','ks':u('\u0631\u0648\u0657\u0648\u0627\u0646\u065b\u0688\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*az','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0ea3\u0ea7\u0eb1\u0e99\u0e94\u0eb2'),'lt':'*az','lu':'*aa','lv':'*az','mg':'Roanda','mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d31\u0d41\u0d35\u0d3e\u0d23\u0d4d\u0d1f'),'mn':'*be','mo':'*aa','mr':'*hi','ms':'*aa','mt':'ir-Rwanda','my':u('\u101b\u101d\u1014\u103a\u1012\u102b'),'na':'*aa','nb':'*aa','nd':'*bm','ne':u('\u0930\u0935\u093e\u0923\u094d\u0921\u093e'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b30\u0b3e\u0b71\u0b3e\u0b23\u0b4d\u0b21\u0b3e'),'os':'*aa','pa':u('\u0a30\u0a35\u0a3e\u0a02\u0a21\u0a3e'),'pi':'*aa','pl':'*aa','ps':u('\u0631\u0648\u0646\u062f\u0627'),'pt':'*az','qu':'*az','rm':'*az','rn':'u Rwanda','ro':'*aa','ru':'*be','rw':'U Rwanda','sa':'*aa','sc':'*aa','sd':u('\u0631\u0648\u0627\u0646\u068a\u0627'),'se':'*aa','sg':u('Ruand\u00e4a'),'si':u('\u0dbb\u0dd4\u0dc0\u0db1\u0dca\u0da9\u0dcf\u0dc0'),'sk':'*aa','sl':'*az','sm':'*aa','sn':'*aa','so':'*bm','sq':u('Ruand\u00eb'),'sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0bb0\u0bc1\u0bb5\u0bbe\u0ba3\u0bcd\u0b9f\u0bbe'),'te':u('\u0c30\u0c41\u0c35\u0c3e\u0c02\u0c21\u0c3e'),'tg':'*be','th':u('\u0e23\u0e27\u0e31\u0e19\u0e14\u0e32'),'ti':'*am','tk':'*az','tl':'*aa','tn':'*aa','to':u('Luanit\u0101'),'tr':'*az','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u0631\u0649\u06cb\u0627\u0646\u062f\u0627'),'uk':'*be','ur':u('\u0631\u0648\u0627\u0646\u0688\u0627'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':u('Ruw\u00e0nda'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Ruwanda'),'za':'*aa','zh':u('\u5362\u65fa\u8fbe'),'zu':'i-Rwanda',},
  'SA': {'aa':'Saudi Arabia','ab':'*aa','ae':'*aa','af':u('Saoedi-Arabi\u00eb'),'ak':'*aa','am':u('\u1233\u12cd\u12f5\u12a0\u1228\u1262\u12eb'),'an':'*aa','ar':u('\u0627\u0644\u0645\u0645\u0644\u0643\u0629 \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629'),'as':u('\u099a\u09cc\u09a1\u09bf \u0986\u09f0\u09ac\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':u('S\u0259udiyy\u0259 \u018fr\u0259bistan\u0131'),'ba':'*aa','be':u('\u0421\u0430\u0443\u0434\u0430\u045e\u0441\u043a\u0430\u044f \u0410\u0440\u0430\u0432\u0456\u044f'),'bg':u('\u0421\u0430\u0443\u0434\u0438\u0442\u0441\u043a\u0430 \u0410\u0440\u0430\u0431\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Arabiya Sawudiya','bn':u('\u09b8\u09cc\u09a6\u09bf \u0986\u09b0\u09ac'),'bo':'*aa','br':'Arabia Saoudat','bs':'Saudijska Arabija','ca':u('Ar\u00e0bia Saudita'),'ce':u('\u0421\u0430\u04c0\u0443\u0434\u0438\u0439\u043d \u04c0\u0430\u044c\u0440\u0431\u0438\u0439\u0447\u043e\u044c'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Sa\u00fadsk\u00e1 Ar\u00e1bie'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'Saudi-Arabien','de':'*da','dv':'*aa','dz':u('\u0f66\u0f71\u0f5d\u0f0b\u0f51\u0f72\u0f0b \u0f68\u0f0b\u0f62\u0f7a\u0f0b\u0f56\u0fb7\u0f72\u0f0b\u0f61'),'ee':'Saudi Arabia nutome','el':u('\u03a3\u03b1\u03bf\u03c5\u03b4\u03b9\u03ba\u03ae \u0391\u03c1\u03b1\u03b2\u03af\u03b1'),'en':'*aa','eo':u('Sa\u016dda Arabujo'),'es':u('Arabia Saud\u00ed'),'et':'Saudi Araabia','eu':'*aa','fa':u('\u0639\u0631\u0628\u0633\u062a\u0627\u0646 \u0633\u0639\u0648\u062f\u06cc'),'ff':'Arabii Sawdit','fi':'Saudi-Arabia','fj':'*aa','fo':'Saudiarabia','fr':'Arabie saoudite','fy':'*af','ga':u('an Araib Sh\u00e1dach'),'gd':u('Ar\u00e0ibia nan Sabhd'),'gl':'Arabia Saudita','gn':'*aa','gu':u('\u0ab8\u0abe\u0a89\u0aa6\u0ac0 \u0a85\u0ab0\u0ac7\u0aac\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':u('\u0198asar Makka'),'he':u('\u05e2\u05e8\u05d1 \u05d4\u05e1\u05e2\u05d5\u05d3\u05d9\u05ea'),'hi':u('\u0938\u090a\u0926\u0940 \u0905\u0930\u092c'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Sza\u00fad-Ar\u00e1bia'),'hy':u('\u054d\u0561\u0578\u0582\u0564\u0575\u0561\u0576 \u0531\u0580\u0561\u0562\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'Arab Saudi','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('S\u00e1di-Arab\u00eda'),'it':'*gl','iu':'*aa','iw':'*he','ja':u('\u30b5\u30a6\u30b8\u30a2\u30e9\u30d3\u30a2'),'ji':'*aa','jv':'*aa','ka':u('\u10e1\u10d0\u10e3\u10d3\u10d8\u10e1 \u10d0\u10e0\u10d0\u10d1\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'Saudi','kj':'*aa','kk':u('\u0421\u0430\u0443\u0434 \u0410\u0440\u0430\u0431\u0438\u044f\u0441\u044b'),'kl':'*aa','km':u('\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17ca\u17b8\u179f\u17b6\u17a2\u17bc\u178c\u17b8\u178f'),'kn':u('\u0cb8\u0ccc\u0ca6\u0cbf \u0c85\u0cb0\u0cc7\u0cac\u0cbf\u0caf\u0cbe'),'ko':u('\uc0ac\uc6b0\ub514\uc544\ub77c\ube44\uc544'),'kr':'*aa','ks':u('\u0633\u0648\u0657\u062f\u06cc \u0639\u0631\u0628\u0650\u06cc\u06c1'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*da','lg':'Sawudarebya - Buwarabu','li':'*aa','ln':u('Alabi Sawudit\u025b'),'lo':u('\u0e8a\u0eb2\u0ead\u0eb8\u0e94\u0eb4 \u0ead\u0eb2\u0ea3\u0eb2\u0ec0\u0e9a\u0e8d'),'lt':'Saudo Arabija','lu':'Alabu Nsawudi','lv':u('Sa\u016bda Ar\u0101bija'),'mg':'Arabia saodita','mh':'*aa','mi':'*aa','mk':u('\u0421\u0430\u0443\u0434\u0438\u0441\u043a\u0430 \u0410\u0440\u0430\u0431\u0438\u0458\u0430'),'ml':u('\u0d38\u0d57\u0d26\u0d3f \u0d05\u0d31\u0d47\u0d2c\u0d4d\u0d2f'),'mn':u('\u0421\u0430\u0443\u0434\u044b\u043d \u0410\u0440\u0430\u0431'),'mo':u('Arabia Saudit\u0103'),'mr':u('\u0938\u094c\u0926\u0940 \u0905\u0930\u092c'),'ms':'*id','mt':'l-Arabia Sawdija','my':u('\u1006\u1031\u102c\u103a\u1012\u102e\u1021\u102c\u101b\u1031\u1038\u1018\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'*fi','nd':'*aa','ne':u('\u0938\u093e\u0909\u0926\u0940 \u0905\u0930\u092c'),'ng':'*aa','nl':'*af','nn':'*fi','no':'*fi','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b3e\u0b09\u0b26\u0b3f \u0b06\u0b30\u0b2c\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a38\u0a3e\u0a0a\u0a26\u0a40 \u0a05\u0a30\u0a2c'),'pi':'*aa','pl':'Arabia Saudyjska','ps':u('\u0633\u0639\u0648\u062f\u064a \u0639\u0631\u0628\u0633\u062a\u0627\u0646'),'pt':u('Ar\u00e1bia Saudita'),'qu':'*es','rm':'*gl','rn':'Arabiya Sawudite','ro':'*mo','ru':u('\u0421\u0430\u0443\u0434\u043e\u0432\u0441\u043a\u0430\u044f \u0410\u0440\u0430\u0432\u0438\u044f'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u0639\u0648\u062f\u06cc \u0639\u0631\u0628'),'se':u('Saudi-Ar\u00e1bia'),'sg':u('Sa\u00fbdi Arab\u00efi'),'si':u('\u0dc3\u0dde\u0daf\u0dd2 \u0d85\u0dbb\u0dcf\u0db6\u0dd2\u0dba'),'sk':u('Saudsk\u00e1 Ar\u00e1bia'),'sl':'Saudova Arabija','sm':'*aa','sn':'*aa','so':'Sacuudi Carabiya','sq':'Arabia Saudite','sr':u('\u0421\u0430\u0443\u0434\u0438\u0458\u0441\u043a\u0430 \u0410\u0440\u0430\u0431\u0438\u0458\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Saudiarabien','sw':'Saudia','ta':u('\u0b9a\u0bb5\u0bc2\u0ba4\u0bbf \u0b85\u0bb0\u0bc7\u0baa\u0bbf\u0baf\u0bbe'),'te':u('\u0c38\u0c4c\u0c26\u0c40 \u0c05\u0c30\u0c47\u0c2c\u0c3f\u0c2f\u0c3e'),'tg':u('\u0410\u0440\u0430\u0431\u0438\u0441\u0442\u043e\u043d\u0438 \u0421\u0430\u0443\u0434\u04e3'),'th':u('\u0e0b\u0e32\u0e2d\u0e38\u0e14\u0e35\u0e2d\u0e32\u0e23\u0e30\u0e40\u0e1a\u0e35\u0e22'),'ti':u('\u1235\u12d1\u12f2 \u12d3\u1228\u1265'),'tk':'Saud Arabystany','tl':'*aa','tn':'*aa','to':u('Saute \u02bbAlepea'),'tr':'Suudi Arabistan','ts':'*aa','tt':u('\u0421\u043e\u0433\u0443\u0434 \u0413\u0430\u0440\u04d9\u0431\u0441\u0442\u0430\u043d\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0633\u06d5\u0626\u06c7\u062f\u0649\u064a \u0626\u06d5\u0631\u06d5\u0628\u0649\u0633\u062a\u0627\u0646'),'uk':u('\u0421\u0430\u0443\u0434\u0456\u0432\u0441\u044c\u043a\u0430 \u0410\u0440\u0430\u0432\u0456\u044f'),'ur':'*sd','uz':'Saudiya Arabistoni','ve':'*aa','vi':u('\u1ea2 R\u1eadp X\u00ea-\u00fat'),'vo':'*aa','wa':'*aa','wo':'Arabi Sawudi','xh':'*aa','yi':'*aa','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Saudi Arabia'),'za':'*aa','zh':u('\u6c99\u7279\u963f\u62c9\u4f2f'),'zu':'i-Saudi Arabia',},
  'SB': {'aa':'Solomon Islands','ab':'*aa','ae':'*aa','af':'Salomonseilande','ak':'*aa','am':u('\u1230\u120e\u121e\u1295 \u12f0\u1234\u1275'),'an':'*aa','ar':u('\u062c\u0632\u0631 \u0633\u0644\u064a\u0645\u0627\u0646'),'as':u('\u099a\u09cb\u09b2\u09cb\u09ae\u09cb\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'av':'*aa','ay':'*aa','az':u('Solomon adalar\u0131'),'ba':'*aa','be':u('\u0421\u0430\u043b\u0430\u043c\u043e\u043d\u0430\u0432\u044b \u0430\u0441\u0442\u0440\u0430\u0432\u044b'),'bg':u('\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u043e\u0432\u0438 \u043e\u0441\u0442\u0440\u043e\u0432\u0438'),'bh':'*aa','bi':'*aa','bm':'Salomo Gun','bn':u('\u09b8\u09b2\u09cb\u09ae\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c'),'bo':'*aa','br':'Inizi Salomon','bs':'Solomonska Ostrva','ca':u('Illes Salom\u00f3'),'ce':u('\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('\u0160alamounovy ostrovy'),'cu':'*aa','cv':'*aa','cy':'Ynysoedd Solomon','da':u('Salomon\u00f8erne'),'de':'Salomonen','dv':'*aa','dz':u('\u0f66\u0f7c\u0f0b\u0f63\u0f7c\u0f0b\u0f58\u0f7c\u0f53\u0f0b \u0f42\u0fb3\u0f72\u0f44\u0f0b\u0f5a\u0f7c\u0f58'),'ee':u('Solomon \u0192udomekpowo nutome'),'el':u('\u039d\u03ae\u03c3\u03bf\u03b9 \u03a3\u03bf\u03bb\u03bf\u03bc\u03ce\u03bd\u03c4\u03bf\u03c2'),'en':'*aa','eo':'Salomonoj','es':u('Islas Salom\u00f3n'),'et':'Saalomoni Saared','eu':'Salomon Uharteak','fa':u('\u062c\u0632\u0627\u06cc\u0631 \u0633\u0644\u06cc\u0645\u0627\u0646'),'ff':u('Duu\u0257e Solomon'),'fi':'Salomonsaaret','fj':'*aa','fo':'Salomonoyggjar','fr':u('\u00celes Salomon'),'fy':'Salomonseilannen','ga':u('Oile\u00e1in Sholom\u00f3n'),'gd':'Eileanan Sholaimh','gl':u('Illas Salom\u00f3n'),'gn':'*aa','gu':u('\u0ab8\u0acb\u0ab2\u0acb\u0aae\u0aa8 \u0a86\u0a87\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0acd\u0ab8'),'gv':'*aa','ha':'Tsibiran Salaman','he':u('\u05d0\u05d9\u05d9 \u05e9\u05dc\u05de\u05d4'),'hi':u('\u0938\u094b\u0932\u094b\u092e\u0928 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939'),'ho':'*aa','hr':'Salomonski Otoci','ht':'*aa','hu':'Salamon-szigetek','hy':u('\u054d\u0578\u0572\u0578\u0574\u0578\u0576\u0575\u0561\u0576 \u056f\u0572\u0566\u056b\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'Kepulauan Solomon','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Sal\u00f3monseyjar'),'it':'Isole Salomone','iu':'*aa','iw':'*he','ja':u('\u30bd\u30ed\u30e2\u30f3\u8af8\u5cf6'),'ji':u('\u05e1\u05d0\u05dc\u05d0\u05de\u05d0\u05df \u05d0\u05d9\u05e0\u05d6\u05dc\u05e2\u05df'),'jv':'*aa','ka':u('\u10e1\u10dd\u10da\u10dd\u10db\u10dd\u10dc\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'Visiwa vya Solomon','kj':'*aa','kk':u('\u0421\u043e\u043b\u043e\u043c\u043e\u043d \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'kl':'*aa','km':u('\u1780\u17c4\u17c7\u200b\u179f\u17bc\u17a1\u17bc\u1798\u17c9\u17bb\u1784'),'kn':u('\u0cb8\u0cbe\u0cb2\u0cca\u0cae\u0ca8\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3\u0cc1'),'ko':u('\uc194\ub85c\ubaac \uc81c\ub3c4'),'kr':'*aa','ks':u('\u0633\u0648\u0644\u0627\u0645\u0627\u0646 \u062c\u0654\u0632\u06cc\u0656\u0631\u0655'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*de','lg':u('Bizanga by\u2019eSolomooni'),'li':'*aa','ln':u('Bisanga Solom\u0254'),'lo':u('\u0eab\u0ea1\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ec2\u0e8a\u0ec2\u0ea5\u0ea1\u0ead\u0e99'),'lt':'Saliamono Salos','lu':'Lutanda lua Solomu','lv':u('Z\u0101lamana salas'),'mg':'Nosy Salomona','mh':'*aa','mi':'*aa','mk':u('\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438'),'ml':u('\u0d38\u0d4b\u0d33\u0d2e\u0d7b \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d7e'),'mn':u('\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u044b \u0430\u0440\u043b\u0443\u0443\u0434'),'mo':'Insulele Solomon','mr':u('\u0938\u094b\u0932\u094b\u092e\u0928 \u092c\u0947\u091f\u0947'),'ms':'*id','mt':u('il-G\u017cejjer Solomon'),'my':u('\u1006\u1031\u102c\u103a\u101c\u1019\u103d\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f'),'na':'*aa','nb':u('Salomon\u00f8yene'),'nd':'*aa','ne':u('\u0938\u094b\u0932\u094b\u092e\u094b\u0928 \u091f\u093e\u092a\u0941\u0939\u0930\u0941'),'ng':'*aa','nl':'Salomonseilanden','nn':u('Salomon\u00f8yane'),'no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b4b\u0b32\u0b4b\u0b2e\u0b28\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c'),'os':'*aa','pa':u('\u0a38\u0a4b\u0a32\u0a4b\u0a2e\u0a28 \u0a1f\u0a3e\u0a2a\u0a42'),'pi':'*aa','pl':'Wyspy Salomona','ps':u('\u0633\u0644\u06cc\u0645\u0627\u0646 \u067c\u0627\u067e\u0648'),'pt':u('Ilhas Salom\u00e3o'),'qu':'*aa','rm':'Salomonas','rn':'Amazinga ya Salumoni','ro':'*mo','ru':u('\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u043e\u0432\u044b \u041e\u0441\u0442\u0440\u043e\u0432\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u0648\u0644\u0648\u0645\u0648\u0646 \u067b\u064a\u067d\u064e'),'se':'Salomon-sullot','sg':u('Z\u00fb\u00e2 Salom\u00f6on'),'si':u('\u0dc3\u0ddc\u0dbd\u0db8\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca'),'sk':u('\u0160alam\u00fanove ostrovy'),'sl':'Salomonovi otoki','sm':'*aa','sn':'Zvitsuwa zvaSolomon','so':'*aa','sq':'Ishujt Solomon','sr':u('\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('Salomon\u00f6arna'),'sw':'*ki','ta':u('\u0b9a\u0bbe\u0bb2\u0bae\u0ba9\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd'),'te':u('\u0c38\u0c4b\u0c32\u0c2e\u0c28\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41'),'tg':u('\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u0421\u043e\u043b\u043e\u043c\u043e\u043d'),'th':u('\u0e2b\u0e21\u0e39\u0e48\u0e40\u0e01\u0e32\u0e30\u0e42\u0e0b\u0e42\u0e25\u0e21\u0e2d\u0e19'),'ti':'*am','tk':'Solomon adalary','tl':'*aa','tn':'*aa','to':u('\u02bbOtumotu Solomone'),'tr':u('Solomon Adalar\u0131'),'ts':'*aa','tt':u('\u0421\u04e9\u043b\u04d9\u0439\u043c\u0430\u043d \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0633\u0648\u0644\u0648\u0645\u0648\u0646 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649'),'uk':u('\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u043e\u0432\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438'),'ur':u('\u0633\u0648\u0644\u0648\u0645\u0646 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632'),'uz':'Solomon orollari','ve':'*aa','vi':u('Qu\u1ea7n \u0111\u1ea3o Solomon'),'vo':'*aa','wa':'*aa','wo':'Duni Salmoon','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Etikun Solomoni'),'za':'*aa','zh':u('\u6240\u7f57\u95e8\u7fa4\u5c9b'),'zu':'i-Solomon Islands',},
  'SC': {'aa':'Seychelles','ab':'*aa','ae':'*aa','af':'Seychelle','ak':u('Seyhy\u025bl'),'am':u('\u1232\u123c\u120d\u1235'),'an':'*aa','ar':u('\u0633\u064a\u0634\u0644'),'as':u('\u099b\u09bf\u099a\u09bf\u09b2\u09bf\u099b'),'av':'*aa','ay':'*aa','az':u('Sey\u015fel adalar\u0131'),'ba':'*aa','be':u('\u0421\u0435\u0439\u0448\u044d\u043b\u044c\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b'),'bg':u('\u0421\u0435\u0439\u0448\u0435\u043b\u0438'),'bh':'*aa','bi':'*aa','bm':u('Ses\u025bli'),'bn':u('\u09b8\u09bf\u09b8\u09bf\u09b2\u09bf'),'bo':'*aa','br':'Sechelez','bs':u('Sej\u0161eli'),'ca':'*aa','ce':u('\u0421\u0435\u0439\u0448\u0435\u043b\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Seychely','cu':'*aa','cv':'*aa','cy':'*aa','da':'Seychellerne','de':'Seychellen','dv':'*aa','dz':u('\u0f66\u0f7a\u0f0b\u0f64\u0f71\u0f63\u0f66'),'ee':u('Sesh\u025bls nutome'),'el':u('\u03a3\u03b5\u03cb\u03c7\u03ad\u03bb\u03bb\u03b5\u03c2'),'en':'*aa','eo':u('Sej\u015deloj'),'es':'*aa','et':u('Sei\u0161ellid'),'eu':'Seychelleak','fa':u('\u0633\u06cc\u0634\u0644'),'ff':'Seysel','fi':'Seychellit','fj':'*aa','fo':'Seyskelloyggjar','fr':'*aa','fy':'*de','ga':u('na S\u00e9is\u00e9il'),'gd':'Na h-Eileanan Sheiseall','gl':'*aa','gn':'*aa','gu':u('\u0ab8\u0ac7\u0ab6\u0ac7\u0ab2\u0acd\u0ab8'),'gv':'*aa','ha':'Saishal','he':u('\u05d0\u05d9\u05d9 \u05e1\u05d9\u05d9\u05e9\u05dc'),'hi':u('\u0938\u0947\u0936\u0947\u0932\u094d\u0938'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'Seychelle-szigetek','hy':u('\u054d\u0565\u0575\u0577\u0565\u056c\u0576\u0565\u0580'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'Seychelles-eyjar','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30bb\u30fc\u30b7\u30a7\u30eb'),'ji':u('\u05e1\u05d9\u05d9\u05e9\u05e2\u05dc'),'jv':'*aa','ka':u('\u10e1\u10d4\u10d8\u10e8\u10d4\u10da\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8'),'kg':'*aa','ki':'Shelisheli','kj':'*aa','kk':u('\u0421\u0435\u0439\u0448\u0435\u043b\u044c \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'kl':'*aa','km':u('\u179f\u17b8\u179f\u17d2\u17a0\u17c2\u179b'),'kn':u('\u0cb8\u0cc0\u0cb6\u0cc6\u0cb2\u0ccd\u0cb2\u0cc6\u0cb8\u0ccd'),'ko':u('\uc138\uc774\uc178'),'kr':'*aa','ks':u('\u0633\u06cc\u0634\u064e\u0644\u0650\u0633'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0421\u0435\u0439\u0448\u0435\u043b \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b'),'la':'*aa','lb':'*de','lg':'Sesere','li':'*aa','ln':u('S\u025bsh\u025bl\u025b'),'lo':u('\u0ec0\u0e8a\u0ec0\u0e8a\u0ea7\u0ec0\u0ea5\u0eaa'),'lt':u('Sei\u0161eliai'),'lu':'Seshele','lv':u('Sei\u0161elu salas'),'mg':'Seyshela','mh':'*aa','mi':'*aa','mk':u('\u0421\u0435\u0458\u0448\u0435\u043b\u0438'),'ml':u('\u0d38\u0d40\u0d37\u0d46\u0d7d\u0d38\u0d4d'),'mn':u('\u0421\u0435\u0439\u0448\u0435\u043b\u0438\u0439\u043d \u0430\u0440\u043b\u0443\u0443\u0434'),'mo':'*aa','mr':'*hi','ms':'*aa','mt':'is-Seychelles','my':u('\u1006\u1031\u1038\u101b\u103e\u1032'),'na':'*aa','nb':'Seychellene','nd':'*aa','ne':u('\u0938\u0947\u091a\u0947\u0932\u0947\u0938'),'ng':'*aa','nl':'*de','nn':'Seychellane','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b47\u0b1a\u0b47\u0b32\u0b38\u0b4d'),'os':'*aa','pa':u('\u0a38\u0a47\u0a38\u0a3c\u0a32\u0a38'),'pi':'*aa','pl':'Seszele','ps':u('\u0633\u06cc\u0686\u06cc\u0644\u06cc\u0633'),'pt':'Seicheles','qu':'*aa','rm':'Seychellas','rn':'Amazinga ya Seyisheli','ro':'*aa','ru':u('\u0421\u0435\u0439\u0448\u0435\u043b\u044c\u0441\u043a\u0438\u0435 \u041e\u0441\u0442\u0440\u043e\u0432\u0430'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0634\u064a \u0634\u0644\u0632'),'se':'Seychellsullot','sg':u('S\u00ebysh\u00eale'),'si':u('\u0dc3\u0dd3\u0dc1\u0dd9\u0dbd\u0dca\u0dc3\u0dca'),'sk':'*cs','sl':'*bs','sm':'*aa','sn':'*aa','so':'Sishelis','sq':'Sejshelle','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'Seychellerna','sw':'Ushelisheli','ta':u('\u0b9a\u0bc0\u0bb7\u0bc6\u0bb2\u0bcd\u0bb8\u0bcd'),'te':u('\u0c38\u0c40\u0c37\u0c46\u0c32\u0c4d\u0c38\u0c4d'),'tg':u('\u0421\u0435\u0439\u0448\u0435\u043b'),'th':u('\u0e40\u0e0b\u0e40\u0e0a\u0e25\u0e2a\u0e4c'),'ti':'*am','tk':u('Se\u00fd\u015fel Adalary'),'tl':'*aa','tn':'*aa','to':u('\u02bbOtumotu Seiseli'),'tr':u('Sey\u015feller'),'ts':'*aa','tt':u('\u0421\u0435\u0439\u0448\u0435\u043b \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b'),'tw':'*aa','ty':'*aa','ug':u('\u0633\u06d0\u064a\u0634\u06d0\u0644'),'uk':u('\u0421\u0435\u0439\u0448\u0435\u043b\u044c\u0441\u044c\u043a\u0456 \u041e\u0441\u0442\u0440\u043e\u0432\u0438'),'ur':u('\u0633\u0634\u0644\u06cc\u0632'),'uz':'Seyshel orollari','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*ff','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de se\u1e63\u1eb9l\u1eb9si'),'za':'*aa','zh':u('\u585e\u820c\u5c14'),'zu':'i-Seychelles',},
  'SD': {'aa':'Sudan','ab':'*aa','ae':'*aa','af':'Soedan','ak':'*aa','am':u('\u1231\u12f3\u1295'),'an':'*aa','ar':u('\u0627\u0644\u0633\u0648\u062f\u0627\u0646'),'as':u('\u099a\u09c1\u09a1\u09be\u09a8'),'av':'*aa','ay':'*aa','az':'*aa','ba':'*aa','be':u('\u0421\u0443\u0434\u0430\u043d'),'bg':'*be','bh':'*aa','bi':'*aa','bm':u('Suda\u014b'),'bn':u('\u09b8\u09c1\u09a6\u09be\u09a8'),'bo':'*aa','br':'Soudan','bs':'*aa','ca':'*aa','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':u('S\u00fad\u00e1n'),'cu':'*aa','cv':'*aa','cy':'Swdan','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f66\u0f74\u0f0b\u0f4c\u0f71\u0f53'),'ee':'Sudan nutome','el':u('\u03a3\u03bf\u03c5\u03b4\u03ac\u03bd'),'en':'*aa','eo':'Sudano','es':u('Sud\u00e1n'),'et':'Sudaan','eu':'*aa','fa':u('\u0633\u0648\u062f\u0627\u0646'),'ff':'*et','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*br','fy':'*af','ga':u('an tS\u00fad\u00e1in'),'gd':u('Sud\u00e0n'),'gl':'*es','gn':'*aa','gu':u('\u0ab8\u0ac1\u0aa6\u0abe\u0aa8'),'gv':'*aa','ha':'*aa','he':u('\u05e1\u05d5\u05d3\u05df'),'hi':u('\u0938\u0942\u0921\u093e\u0928'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':u('Szud\u00e1n'),'hy':u('\u054d\u0578\u0582\u0564\u0561\u0576'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('S\u00fadan'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30b9\u30fc\u30c0\u30f3'),'ji':u('\u05e1\u05d5\u05d3\u05d0\u05b7\u05df'),'jv':'*aa','ka':u('\u10e1\u10e3\u10d3\u10d0\u10dc\u10d8'),'kg':'*aa','ki':'Sudani','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u179f\u17ca\u17bc\u178a\u1784\u17cb'),'kn':u('\u0cb8\u0cc1\u0ca1\u0cbe\u0ca8\u0ccd'),'ko':u('\uc218\ub2e8'),'kr':'*aa','ks':u('\u0633\u0648\u0657\u0688\u0627\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*aa','lg':'Sudaani','li':'*aa','ln':u('Sud\u00e1'),'lo':u('\u0e8a\u0eb9\u0e94\u0eb2\u0e99'),'lt':'Sudanas','lu':'Suda','lv':u('Sud\u0101na'),'mg':'Sodan','mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d38\u0d41\u0d21\u0d3e\u0d7b'),'mn':'*be','mo':'*aa','mr':u('\u0938\u0941\u0926\u093e\u0928'),'ms':'*aa','mt':'is-Sudan','my':u('\u1006\u1030\u1012\u1014\u103a'),'na':'*aa','nb':'*aa','nd':'*ki','ne':u('\u0938\u0941\u0921\u093e\u0928'),'ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b41\u0b26\u0b3e\u0b28'),'os':'*aa','pa':u('\u0a38\u0a42\u0a21\u0a3e\u0a28'),'pi':'*aa','pl':'*aa','ps':u('\u0633\u0648\u0689\u0627\u0646'),'pt':u('Sud\u00e3o'),'qu':'*es','rm':'*aa','rn':'*ki','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u0648\u068a\u0627\u0646'),'se':'Davvisudan','sg':u('Sud\u00e4an'),'si':u('\u0dc3\u0dd6\u0da9\u0dcf\u0db1\u0dba'),'sk':'*es','sl':'*aa','sm':'*aa','sn':'*aa','so':'Suudaan','sq':'*aa','sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b9a\u0bc2\u0b9f\u0bbe\u0ba9\u0bcd'),'te':u('\u0c38\u0c42\u0c21\u0c3e\u0c28\u0c4d'),'tg':u('\u0421\u0443\u0434\u043e\u043d'),'th':u('\u0e0b\u0e39\u0e14\u0e32\u0e19'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':u('S\u016bteni'),'tr':'*aa','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u0633\u06c7\u062f\u0627\u0646'),'uk':'*be','ur':u('\u0633\u0648\u0688\u0627\u0646'),'uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*bm','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Sudani'),'za':'*aa','zh':u('\u82cf\u4e39'),'zu':'i-Sudan',},
  'SE': {'aa':'Sweden','ab':'*aa','ae':'*aa','af':'Swede','ak':'*aa','am':u('\u1235\u12ca\u12f5\u1295'),'an':'*aa','ar':u('\u0627\u0644\u0633\u0648\u064a\u062f'),'as':u('\u099a\u09c1\u0987\u09a1\u09c7\u09a8'),'av':'*aa','ay':'*aa','az':u('\u0130sve\u00e7'),'ba':'*aa','be':u('\u0428\u0432\u0435\u0446\u044b\u044f'),'bg':u('\u0428\u0432\u0435\u0446\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':u('Suw\u025bdi'),'bn':u('\u09b8\u09c1\u0987\u09a1\u09c7\u09a8'),'bo':'*aa','br':'Sveden','bs':u('\u0160vedska'),'ca':u('Su\u00e8cia'),'ce':u('\u0428\u0432\u0435\u0446\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('\u0160v\u00e9dsko'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'Sverige','de':'Schweden','dv':'*aa','dz':u('\u0f66\u0f74\u0f60\u0f72\u0f0b\u0f4c\u0f7a\u0f53'),'ee':'Sweden nutome','el':u('\u03a3\u03bf\u03c5\u03b7\u03b4\u03af\u03b1'),'en':'*aa','eo':'Svedujo','es':'Suecia','et':'Rootsi','eu':'Suedia','fa':u('\u0633\u0648\u0626\u062f'),'ff':'Suweed','fi':'Ruotsi','fj':'*aa','fo':u('Sv\u00f8r\u00edki'),'fr':u('Su\u00e8de'),'fy':'Zweden','ga':'an tSualainn','gd':'An t-Suain','gl':'*es','gn':'*aa','gu':u('\u0ab8\u0acd\u0ab5\u0ac0\u0aa1\u0aa8'),'gv':'*aa','ha':'Suwedan','he':u('\u05e9\u05d5\u05d5\u05d3\u05d9\u05d4'),'hi':u('\u0938\u094d\u0935\u0940\u0921\u0928'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Sv\u00e9dorsz\u00e1g'),'hy':u('\u0547\u057e\u0565\u0564\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'Swedia','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Sv\u00ed\u00fej\u00f3\u00f0'),'it':'Svezia','iu':'*aa','iw':'*he','ja':u('\u30b9\u30a6\u30a7\u30fc\u30c7\u30f3'),'ji':u('\u05e9\u05d5\u05d5\u05e2\u05d3\u05df'),'jv':'*aa','ka':u('\u10e8\u10d5\u10d4\u10d3\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'Uswidi','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u179f\u17ca\u17bb\u1799\u17a2\u17c2\u178f'),'kn':u('\u0cb8\u0ccd\u0cb5\u0cc0\u0ca1\u0ca8\u0ccd'),'ko':u('\uc2a4\uc6e8\ub374'),'kr':'*aa','ks':u('\u0633\u064f\u0648\u0650\u0688\u064e\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*de','lg':'Swideni','li':'*aa','ln':u('Sw\u00e9d\u025b'),'lo':u('\u0eaa\u0eb0\u0ea7\u0eb5\u0ec0\u0e94\u0eb1\u0e99'),'lt':u('\u0160vedija'),'lu':'Suwedi','lv':'Zviedrija','mg':'Soedy','mh':'*aa','mi':'*aa','mk':u('\u0428\u0432\u0435\u0434\u0441\u043a\u0430'),'ml':u('\u0d38\u0d4d\u0d35\u0d40\u0d21\u0d7b'),'mn':u('\u0428\u0432\u0435\u0434'),'mo':'*eu','mr':'*hi','ms':'*aa','mt':u('l-I\u017cvezja'),'my':u('\u1006\u103d\u102e\u1012\u1004\u103a'),'na':'*aa','nb':'*da','nd':'*aa','ne':u('\u0938\u094d\u0935\u093f\u0921\u0947\u0928'),'ng':'*aa','nl':'*fy','nn':'*da','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b4d\u0b71\u0b47\u0b21\u0b47\u0b28\u0b4d'),'os':'*aa','pa':u('\u0a38\u0a35\u0a40\u0a21\u0a28'),'pi':'*aa','pl':'Szwecja','ps':u('\u0633\u0648\u06cc\u0689\u0646'),'pt':u('Su\u00e9cia'),'qu':'*es','rm':'*it','rn':'*lu','ro':'*eu','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u0648\u0626\u064a\u068a\u0646'),'se':u('Ruo\u0167\u0167a'),'sg':u('Su\u00eade'),'si':u('\u0dc3\u0dca\u0dc0\u0dd3\u0da9\u0db1\u0dba'),'sk':'*cs','sl':'*bs','sm':'*aa','sn':'*aa','so':'Iswidhan','sq':'Suedi','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*ki','ta':u('\u0bb8\u0bcd\u0bb5\u0bc0\u0b9f\u0ba9\u0bcd'),'te':u('\u0c38\u0c4d\u0c35\u0c40\u0c21\u0c28\u0c4d'),'tg':u('\u0428\u0432\u0435\u0442\u0441\u0438\u044f'),'th':u('\u0e2a\u0e27\u0e35\u0e40\u0e14\u0e19'),'ti':'*am','tk':u('\u015ewesi\u00fda'),'tl':'*aa','tn':'*aa','to':u('Su\u0113teni'),'tr':'*az','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0634\u0649\u06cb\u06d0\u062a\u0633\u0649\u064a\u06d5'),'uk':u('\u0428\u0432\u0435\u0446\u0456\u044f'),'ur':u('\u0633\u0648\u06cc\u0688\u0646'),'uz':'Shvetsiya','ve':'*aa','vi':u('Th\u1ee5y \u0110i\u1ec3n'),'vo':'*aa','wa':'*aa','wo':'Suwed','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Swidini'),'za':'*aa','zh':u('\u745e\u5178'),'zu':'i-Sweden',},
  'SG': {'aa':'Singapore','ab':'*aa','ae':'*aa','af':'Singapoer','ak':u('Singap\u0254'),'am':u('\u1232\u1295\u130b\u1356\u122d'),'an':'*aa','ar':u('\u0633\u0646\u063a\u0627\u0641\u0648\u0631\u0629'),'as':u('\u099b\u09bf\u0982\u0997\u09be\u09aa\u09c1\u09f0'),'av':'*aa','ay':'*aa','az':'Sinqapur','ba':'*aa','be':u('\u0421\u0456\u043d\u0433\u0430\u043f\u0443\u0440'),'bg':u('\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440'),'bh':'*aa','bi':'*aa','bm':u('S\u025bngapuri'),'bn':u('\u09b8\u09bf\u0999\u09cd\u0997\u09be\u09aa\u09c1\u09b0'),'bo':'*aa','br':'Singapour','bs':'Singapur','ca':'*bs','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*bs','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*bs','dv':'*aa','dz':u('\u0f66\u0f72\u0f44\u0f0b\u0f42\u0f0b\u0f54\u0f7c\u0f62'),'ee':u('Singap\u0254r nutome'),'el':u('\u03a3\u03b9\u03b3\u03ba\u03b1\u03c0\u03bf\u03cd\u03c1\u03b7'),'en':'*aa','eo':'Singapuro','es':'*bs','et':'*bs','eu':'*bs','fa':u('\u0633\u0646\u06af\u0627\u067e\u0648\u0631'),'ff':'Sinngapuur','fi':'*aa','fj':'*aa','fo':'Singapor','fr':'*br','fy':'*aa','ga':u('Singeap\u00f3r'),'gd':u('Singeap\u00f2r'),'gl':'*bs','gn':'*aa','gu':u('\u0ab8\u0abf\u0a82\u0a97\u0abe\u0aaa\u0ac1\u0ab0'),'gv':'*aa','ha':'*bs','he':u('\u05e1\u05d9\u05e0\u05d2\u05e4\u05d5\u05e8'),'hi':u('\u0938\u093f\u0902\u0917\u093e\u092a\u0941\u0930'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Szingap\u00far'),'hy':u('\u054d\u056b\u0576\u0563\u0561\u057a\u0578\u0582\u0580'),'hz':'*aa','ia':'*aa','id':'Singapura','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Singap\u00far'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30b7\u30f3\u30ac\u30dd\u30fc\u30eb'),'ji':u('\u05e1\u05d9\u05e0\u05d2\u05d0\u05b7\u05e4\u05bc\u05d5\u05e8'),'jv':'*aa','ka':u('\u10e1\u10d8\u10dc\u10d2\u10d0\u10de\u10e3\u10e0\u10d8'),'kg':'*aa','ki':'Singapoo','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u179f\u17b7\u1784\u17d2\u17a0\u1794\u17bb\u179a\u17b8'),'kn':u('\u0cb8\u0cbf\u0c82\u0c97\u0cbe\u0caa\u0cc1\u0cb0\u0ccd'),'ko':u('\uc2f1\uac00\ud3ec\ub974'),'kr':'*aa','ks':u('\u065b\u0633\u0650\u0646\u065b\u06af\u0627\u067e\u0648\u0657\u0631'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*bs','lg':'Singapowa','li':'*aa','ln':u('Singapur\u025b'),'lo':u('\u0eaa\u0eb4\u0e87\u0e81\u0eb0\u0ec2\u0e9b'),'lt':u('Singap\u016bras'),'lu':'Singapure','lv':u('Singap\u016bra'),'mg':'Singaporo','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d38\u0d3f\u0d02\u0d17\u0d2a\u0d4d\u0d2a\u0d42\u0d7c'),'mn':'*bg','mo':'*aa','mr':u('\u0938\u093f\u0902\u0917\u093e\u092a\u0942\u0930'),'ms':'*id','mt':'*aa','my':u('\u1005\u1004\u103a\u1039\u1000\u102c\u1015\u1030'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0938\u093f\u0919\u094d\u0917\u093e\u092a\u0941\u0930'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b3f\u0b19\u0b4d\u0b17\u0b3e\u0b2a\u0b41\u0b30\u0b4d'),'os':'*aa','pa':u('\u0a38\u0a3f\u0a70\u0a17\u0a3e\u0a2a\u0a41\u0a30'),'pi':'*aa','pl':'*bs','ps':u('\u0633\u064a\u0646\u06af\u0627\u067e\u0648\u0631'),'pt':'*id','qu':'*bs','rm':'*bs','rn':'Singapuru','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*ps','se':'*aa','sg':u('S\u00efng\u00e4p\u00fbru'),'si':u('\u0dc3\u0dd2\u0d82\u0d9c\u0db4\u0dca\u0db4\u0dd6\u0dbb\u0dd4\u0dc0'),'sk':'*bs','sl':'*bs','sm':'*aa','sn':'*aa','so':'Singaboor','sq':'*fo','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b9a\u0bbf\u0b99\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0bc2\u0bb0\u0bcd'),'te':u('\u0c38\u0c3f\u0c02\u0c17\u0c2a\u0c42\u0c30\u0c4d'),'tg':'*bg','th':u('\u0e2a\u0e34\u0e07\u0e04\u0e42\u0e1b\u0e23\u0e4c'),'ti':'*am','tk':'*bs','tl':'*aa','tn':'*aa','to':'Singapoa','tr':'*bs','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0633\u0649\u0646\u06af\u0627\u067e\u0648\u0631'),'uk':'*be','ur':'*fa','uz':'*bs','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Singapuur','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Singapo'),'za':'*aa','zh':u('\u65b0\u52a0\u5761'),'zu':'i-Singapore',},
  'SH': {'aa':'Saint Helena','ab':'*aa','ae':'*aa','af':'Sint Helena','ak':'*aa','am':u('\u1234\u1295\u1275 \u1204\u1208\u1293'),'an':'*aa','ar':u('\u0633\u0627\u0646\u062a \u0647\u064a\u0644\u064a\u0646\u0627'),'as':u('\u099b\u09c7\u0987\u09a3\u09cd\u099f \u09b9\u09c7\u09b2\u09c7\u09a8\u09be'),'av':'*aa','ay':'*aa','az':u('M\u00fcq\u0259dd\u0259s Yelena'),'ba':'*aa','be':u('\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u0421\u0432\u044f\u0442\u043e\u0439 \u0410\u043b\u0435\u043d\u044b'),'bg':u('\u0421\u0432\u0435\u0442\u0430 \u0415\u043b\u0435\u043d\u0430'),'bh':'*aa','bi':'*aa','bm':u('\u0190l\u025bni Senu'),'bn':u('\u09b8\u09c7\u09a8\u09cd\u099f \u09b9\u09c7\u09b2\u09c7\u09a8\u09be'),'bo':'*aa','br':'Saint-Helena','bs':'Sveta Helena','ca':'*aa','ce':u('\u0421\u0438\u0439\u043b\u0430\u0445\u044c\u0447\u0443 \u0415\u043b\u0435\u043d\u0438\u043d \u0433\u04c0\u0430\u0439\u0440\u0435'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Svat\u00e1 Helena'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'St. Helena','de':'*da','dv':'*aa','dz':u('\u0f66\u0f7a\u0f53\u0f4a\u0f0b \u0f67\u0f7a\u0f0b\u0f63\u0f72\u0f0b\u0f53'),'ee':'Saint Helena nutome','el':u('\u0391\u03b3\u03af\u03b1 \u0395\u03bb\u03ad\u03bd\u03b7'),'en':'*da','eo':'Sent-Heleno','es':'Santa Elena','et':'*aa','eu':'Santa Helena','fa':u('\u0633\u0646\u062a \u0647\u0644\u0646'),'ff':'Sent Helen','fi':'*aa','fj':'*aa','fo':'*da','fr':u('Sainte-H\u00e9l\u00e8ne'),'fy':'Sint-Helena','ga':u('San H\u00e9ilin'),'gd':'Eilean Naomh Eilidh','gl':'*eu','gn':'*aa','gu':u('\u0ab8\u0ac7\u0a82\u0a9f \u0ab9\u0ac7\u0ab2\u0ac7\u0aa8\u0abe'),'gv':'*aa','ha':'San Helena','he':u('\u05e1\u05e0\u05d8 \u05d4\u05dc\u05e0\u05d4'),'hi':u('\u0938\u0947\u0902\u091f \u0939\u0947\u0932\u0947\u0928\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'Szent Ilona','hy':u('\u054d\u0578\u0582\u0580\u0562 \u0540\u0565\u0572\u056b\u0576\u0565\u056b \u056f\u0572\u0566\u056b'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'Sankti Helena','it':u('Sant\u2019Elena'),'iu':'*aa','iw':'*he','ja':u('\u30bb\u30f3\u30c8\u30d8\u30ec\u30ca'),'ji':u('\u05e1\u05d8 \u05d4\u05e2\u05dc\u05e2\u05e0\u05e2'),'jv':'*aa','ka':u('\u10ec\u10db\u10d8\u10dc\u10d3\u10d0 \u10d4\u10da\u10d4\u10dc\u10d4\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d8'),'kg':'*aa','ki':'Santahelena','kj':'*aa','kk':u('\u04d8\u0443\u043b\u0438\u0435 \u0415\u043b\u0435\u043d\u0430 \u0430\u0440\u0430\u043b\u044b'),'kl':'*aa','km':u('\u179f\u1784\u17cb\u200b\u17a0\u17c1\u17a1\u17c1\u178e\u17b6'),'kn':u('\u0cb8\u0cc7\u0c82\u0c9f\u0ccd \u0cb9\u0cc6\u0cb2\u0cc6\u0ca8\u0cbe'),'ko':u('\uc138\uc778\ud2b8\ud5ec\ub808\ub098'),'kr':'*aa','ks':u('\u0633\u06cc\u0646\u065b\u0679 \u06c1\u066e\u06ea\u0644\u0650\u0646\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u042b\u0439\u044b\u043a \u0415\u043b\u0435\u043d\u0430'),'la':'*aa','lb':'*da','lg':'Senti Herena','li':'*aa','ln':u('S\u00e1ntu eleni'),'lo':u('\u0ec0\u0e8a\u0e99 \u0ec0\u0eae\u0ec0\u0ea5\u0e99\u0eb2'),'lt':u('\u0160v. Elenos Sala'),'lu':'Santu eleni','lv':u('Sv.Hel\u0113nas sala'),'mg':'*fr','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d38\u0d46\u0d28\u0d4d\u0d31\u0d4d \u0d39\u0d46\u0d32\u0d40\u0d28'),'mn':u('\u0421\u0435\u043d\u0442 \u0425\u0435\u043b\u0435\u043d\u0430'),'mo':u('Sf\u00e2nta Elena'),'mr':'*hi','ms':'*aa','mt':'*aa','my':u('\u1005\u102d\u1014\u1037\u103a\u101f\u101a\u103a\u101c\u101a\u103a\u1014\u102c'),'na':'*aa','nb':'*da','nd':'*aa','ne':u('\u0938\u0947\u0928\u094d\u091f \u0939\u0947\u0932\u0947\u0928\u093e'),'ng':'*aa','nl':'*fy','nn':'*aa','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b39\u0b47\u0b32\u0b47\u0b28\u0b3e'),'os':'*aa','pa':u('\u0a38\u0a47\u0a02\u0a1f \u0a39\u0a47\u0a32\u0a47\u0a28\u0a3e'),'pi':'*aa','pl':u('Wyspa \u015awi\u0119tej Heleny'),'ps':u('\u0633\u06cc\u0646\u067c \u0647\u06cc\u0644\u06cc\u0646\u0627'),'pt':'*eu','qu':'*aa','rm':u('Sontg\u2019Elena'),'rn':'Sehelene','ro':'*mo','ru':u('\u043e-\u0432 \u0421\u0432. \u0415\u043b\u0435\u043d\u044b'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u064a\u0646\u067d \u06be\u064a\u0644\u064a\u0646\u0627'),'se':'*aa','sg':u('S\u00eant-Hel\u00eana'),'si':u('\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0dc4\u0dd9\u0dbd\u0dda\u0db1\u0dcf'),'sk':u('Sv\u00e4t\u00e1 Helena'),'sl':'*bs','sm':'*aa','sn':'*aa','so':'*aa','sq':u('Sh\u00ebn-Helen\u00eb'),'sr':u('\u0421\u0432\u0435\u0442\u0430 \u0408\u0435\u043b\u0435\u043d\u0430'),'ss':'*aa','st':'*aa','su':'*aa','sv':'S:t Helena','sw':'*da','ta':u('\u0b9a\u0bc6\u0baf\u0bbf\u0ba9\u0bcd\u0b9f\u0bcd \u0bb9\u0bc6\u0bb2\u0bc6\u0ba9\u0bbe'),'te':u('\u0c38\u0c46\u0c2f\u0c3f\u0c02\u0c1f\u0c4d \u0c39\u0c46\u0c32\u0c46\u0c28\u0c3e'),'tg':u('\u0421\u0435\u043d\u0442 \u0415\u043b\u0435\u043d\u0430'),'th':u('\u0e40\u0e0b\u0e19\u0e15\u0e4c\u0e40\u0e2e\u0e40\u0e25\u0e19\u0e32'),'ti':'*am','tk':u('Keramatly \u00ddelena adasy'),'tl':'*da','tn':'*aa','to':u('S\u0101 Helena'),'tr':'*aa','ts':'*aa','tt':'*aa','tw':'*aa','ty':'*aa','ug':u('\u0633\u0627\u064a\u0646\u0649\u062a \u06be\u06d0\u0644\u06d0\u0646\u0627'),'uk':u('\u041e\u0441\u0442\u0440\u0456\u0432 \u0421\u0432\u044f\u0442\u043e\u0457 \u0404\u043b\u0435\u043d\u0438'),'ur':u('\u0633\u06cc\u0646\u0679 \u06c1\u06cc\u0644\u06cc\u0646\u0627'),'uz':'Muqaddas Yelena oroli','ve':'*aa','vi':'*da','vo':'*aa','wa':'*aa','wo':u('Sa\u014b Eleen'),'xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de H\u1eb9lena'),'za':'*aa','zh':u('\u5723\u8d6b\u52d2\u62ff'),'zu':'i-St. Helena',},
  'SI': {'aa':'Slovenia','ab':'*aa','ae':'*aa','af':u('Sloweni\u00eb'),'ak':'Slovinia','am':u('\u1235\u120e\u126c\u1292\u12eb'),'an':'*aa','ar':u('\u0633\u0644\u0648\u0641\u064a\u0646\u064a\u0627'),'as':u('\u09b6\u09cd\u09b2\u09cb\u09ad\u09c7\u09a8\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Sloveniya','ba':'*aa','be':u('\u0421\u043b\u0430\u0432\u0435\u043d\u0456\u044f'),'bg':u('\u0421\u043b\u043e\u0432\u0435\u043d\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Sloveni','bn':u('\u09b8\u09cd\u09b2\u09cb\u09ad\u09be\u09a8\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'*aa','bs':'Slovenija','ca':u('Eslov\u00e8nia'),'ce':u('\u0421\u043b\u043e\u0432\u0435\u043d\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Slovinsko','cu':'*aa','cv':'*aa','cy':'Slofenia','da':'Slovenien','de':'Slowenien','dv':'*aa','dz':u('\u0f66\u0f74\u0f0b\u0f63\u0f7c\u0f0b\u0f56\u0f72\u0f0b\u0f53\u0f72\u0f0b\u0f61'),'ee':'Slovenia nutome','el':u('\u03a3\u03bb\u03bf\u03b2\u03b5\u03bd\u03af\u03b1'),'en':'*aa','eo':'Slovenujo','es':'Eslovenia','et':'Sloveenia','eu':'*es','fa':u('\u0627\u0633\u0644\u0648\u0648\u0646\u06cc'),'ff':'Slowenii','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('Slov\u00e9nie'),'fy':u('Sloveni\u00eb'),'ga':u('an tSl\u00f3iv\u00e9in'),'gd':u('An t-Sl\u00f2bhain'),'gl':'*es','gn':'*aa','gu':u('\u0ab8\u0acd\u0ab2\u0acb\u0ab5\u0ac7\u0aa8\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Sulobeniya','he':u('\u05e1\u05dc\u05d5\u05d1\u05e0\u05d9\u05d4'),'hi':u('\u0938\u094d\u0932\u094b\u0935\u0947\u0928\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Szlov\u00e9nia'),'hy':u('\u054d\u056c\u0578\u057e\u0565\u0576\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Sl\u00f3ven\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30b9\u30ed\u30d9\u30cb\u30a2'),'ji':u('\u05e1\u05dc\u05d0\u05d5\u05d5\u05e2\u05e0\u05d9\u05e2'),'jv':'*aa','ka':u('\u10e1\u10da\u10dd\u10d5\u10d4\u10dc\u10d8\u10d0'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u179f\u17d2\u179b\u17bc\u179c\u17c1\u1793\u17b8'),'kn':u('\u0cb8\u0ccd\u0cb2\u0ccb\u0cb5\u0cc7\u0ca8\u0cbf\u0caf\u0cbe'),'ko':u('\uc2ac\ub85c\ubca0\ub2c8\uc544'),'kr':'*aa','ks':u('\u0633\u064e\u0644\u0648\u0648\u06cc\u0646\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*de','lg':'Sirovenya','li':'*aa','ln':'Siloveni','lo':u('\u0eaa\u0eb0\u0ec2\u0ea5\u0ec0\u0ea7\u0ec0\u0e99\u0e8d'),'lt':u('Slov\u0117nija'),'lu':'*ln','lv':u('Slov\u0113nija'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0421\u043b\u043e\u0432\u0435\u043d\u0438\u0458\u0430'),'ml':u('\u0d38\u0d4d\u0d32\u0d4b\u0d35\u0d47\u0d28\u0d3f\u0d2f'),'mn':'*ce','mo':'*aa','mr':u('\u0938\u094d\u0932\u094b\u0935\u094d\u0939\u0947\u0928\u093f\u092f\u093e'),'ms':'*aa','mt':'is-Slovenja','my':u('\u1006\u101c\u102d\u102f\u1017\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0938\u094d\u0932\u094b\u092d\u0947\u0928\u093f\u092f\u093e'),'ng':'*aa','nl':'*fy','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b4d\u0b32\u0b4b\u0b2d\u0b47\u0b28\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a38\u0a32\u0a4b\u0a35\u0a47\u0a28\u0a40\u0a06'),'pi':'*aa','pl':u('S\u0142owenia'),'ps':u('\u0633\u0644\u0648\u0627\u0646\u06cc\u0627'),'pt':u('Eslov\u00eania'),'qu':'*es','rm':'*aa','rn':'Siloveniya','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u0644\u0648\u06cc\u0646\u06cc\u0627'),'se':'*aa','sg':u('Soloven\u00efi'),'si':u('\u0dc3\u0dca\u0dbd\u0ddd\u0dc0\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*cs','sl':'*bs','sm':'*aa','sn':'*aa','so':'*aa','sq':'Slloveni','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'*aa','ta':u('\u0bb8\u0bcd\u0bb2\u0bcb\u0bb5\u0bc7\u0ba9\u0bbf\u0baf\u0bbe'),'te':u('\u0c38\u0c4d\u0c32\u0c4b\u0c35\u0c47\u0c28\u0c3f\u0c2f\u0c3e'),'tg':'*bg','th':u('\u0e2a\u0e42\u0e25\u0e27\u0e35\u0e40\u0e19\u0e35\u0e22'),'ti':'*am','tk':u('Sloweni\u00fda'),'tl':'*aa','tn':'*aa','to':u('Sil\u014dvenia'),'tr':'Slovenya','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0633\u0649\u0644\u0648\u06cb\u06d0\u0646\u0649\u064a\u06d5'),'uk':u('\u0421\u043b\u043e\u0432\u0435\u043d\u0456\u044f'),'ur':u('\u0633\u0644\u0648\u0648\u06cc\u0646\u06cc\u0627'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Esloweni','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Silofania'),'za':'*aa','zh':u('\u65af\u6d1b\u6587\u5c3c\u4e9a'),'zu':'i-Slovenia',},
  'SJ': {'aa':'Svalbard And Jan Mayen','ab':'*aa','ae':'*aa','af':'Svalbard en Jan Mayen','ak':'*aa','am':u('\u1235\u126b\u120d\u1263\u122d\u12f5 \u12a5\u1293 \u1303\u1295 \u121b\u12e8\u1295'),'an':'*aa','ar':u('\u0633\u0641\u0627\u0644\u0628\u0627\u0631\u062f \u0648\u062c\u0627\u0646 \u0645\u0627\u064a\u0646'),'as':u('\u099a\u09be\u09ad\u09be\u09b2\u09ac\u09be\u09f0\u09cd\u09a1 \u0986\u09f0\u09c1 \u099c\u09a8 \u09ae\u09c7\u09af\u09bc\u09a8'),'av':'*aa','ay':'*aa','az':u('Svalbard v\u0259 Yan-Mayen'),'ba':'*aa','be':u('\u0428\u043f\u0456\u0446\u0431\u0435\u0440\u0433\u0435\u043d \u0456 \u042f\u043d-\u041c\u0430\u0435\u043d'),'bg':u('\u0421\u0432\u0430\u043b\u0431\u0430\u0440\u0434 \u0438 \u042f\u043d \u041c\u0430\u0439\u0435\u043d'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u09b8\u09cd\u09ac\u09be\u09b2\u09ac\u09be\u09b0\u09cd\u09a1 \u0993 \u099c\u09be\u09a8 \u09ae\u09c7\u09af\u09bc\u09c7\u09a8'),'bo':'*aa','br':'Svalbard','bs':'Svalbard i Jan Majen','ca':'Svalbard i Jan Mayen','ce':u('\u0428\u043f\u0438\u0446\u0431\u0435\u0440\u0433\u0435\u043d \u0430, \u042f\u043d-\u041c\u0430\u0439\u0435\u043d \u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('\u0160picberky a Jan Mayen'),'cu':'*aa','cv':'*aa','cy':'Svalbard a Jan Mayen','da':'Svalbard og Jan Mayen','de':'Spitzbergen und Jan Mayen','dv':'*aa','dz':u('\u0f66\u0fad\u0f71\u0f63\u0f0b\u0f56\u0fb7\u0f62\u0fa1\u0f0b \u0f68\u0f7a\u0f53\u0f4c\u0f0b \u0f47\u0f71\u0f53\u0f0b\u0f58\u0f0b\u0f61\u0f7a\u0f53'),'ee':'Svalbard kple Yan Mayen nutome','el':u('\u03a3\u03b2\u03ac\u03bb\u03bc\u03c0\u03b1\u03c1\u03bd\u03c4 \u03ba\u03b1\u03b9 \u0393\u03b9\u03b1\u03bd \u039c\u03b1\u03b3\u03b9\u03ad\u03bd'),'en':'Svalbard & Jan Mayen','eo':'Svalbardo kaj Jan-Majen-insulo','es':'Svalbard y Jan Mayen','et':'Svalbard ja Jan Mayen','eu':'Svalbard eta Jan Mayen uharteak','fa':u('\u0627\u0633\u0648\u0627\u0644\u0628\u0627\u0631\u062f \u0648 \u062c\u0627\u0646\u200c\u0645\u0627\u06cc\u0646'),'ff':'*aa','fi':'Huippuvuoret ja Jan Mayen','fj':'*aa','fo':'*en','fr':'Svalbard et Jan Mayen','fy':'Spitsbergen en Jan Mayen','ga':'Svalbard agus Jan Mayen','gd':'*ga','gl':'Svalbard e Jan Mayen','gn':'*aa','gu':u('\u0ab8\u0acd\u0ab5\u0abe\u0ab2\u0aac\u0ab0\u0acd\u0aa1 \u0a85\u0aa8\u0ac7 \u0a9c\u0ac7\u0aa8 \u0aae\u0ac7\u0aaf\u0aa8'),'gv':'*aa','ha':'*aa','he':u('\u05e1\u05d1\u05d0\u05dc\u05d1\u05e8\u05d3 \u05d5\u05d9\u05d0\u05df \u05de\u05d0\u05d9\u05d9\u05df'),'hi':u('\u0938\u094d\u0935\u093e\u0932\u092c\u093e\u0930\u094d\u0921 \u0914\u0930 \u091c\u093e\u0928 \u092e\u093e\u092f\u0947\u0928'),'ho':'*aa','hr':'*ca','ht':'*aa','hu':u('Svalbard \u00e9s Jan Mayen'),'hy':u('\u054d\u057e\u0561\u056c\u0562\u0561\u0580\u0564 \u0587 \u0545\u0561\u0576 \u0544\u0561\u0575\u0565\u0576'),'hz':'*aa','ia':'*aa','id':'Kepulauan Svalbard dan Jan Mayen','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Svalbar\u00f0i og Jan Mayen'),'it':'*gl','iu':'*aa','iw':'*he','ja':u('\u30b9\u30d0\u30fc\u30eb\u30d0\u30eb\u8af8\u5cf6\u30fb\u30e4\u30f3\u30de\u30a4\u30a8\u30f3\u5cf6'),'ji':'*aa','jv':'*aa','ka':u('\u10e8\u10de\u10d8\u10ea\u10d1\u10d4\u10e0\u10d2\u10d4\u10dc\u10d8 \u10d3\u10d0 \u10d8\u10d0\u10dc-\u10db\u10d0\u10d8\u10d4\u10dc\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u0428\u043f\u0438\u0446\u0431\u0435\u0440\u0433\u0435\u043d \u0436\u04d9\u043d\u0435 \u042f\u043d-\u041c\u0430\u0439\u0435\u043d'),'kl':'*aa','km':u('\u179f\u17d2\u179c\u17b6\u179b\u1794\u17b6\u178a \u1793\u17b7\u1784 \u17a0\u17d2\u179f\u1784\u17cb\u1798\u17c9\u17b6\u1799\u17c1\u1793'),'kn':u('\u0cb8\u0ccd\u0cb5\u0cbe\u0cb2\u0ccd\u0cac\u0cbe\u0cb0\u0ccd\u0ca1\u0ccd \u0cae\u0ca4\u0ccd\u0ca4\u0cc1 \u0c9c\u0cbe\u0ca8\u0ccd \u0cae\u0cc6\u0caf\u0ca8\u0ccd'),'ko':u('\uc2a4\ubc1c\ubc14\ub974\uc81c\ub3c4-\uc580\ub9c8\uc6ec\uc12c'),'kr':'*aa','ks':u('\u0633\u064e\u0648\u0627\u0644\u0628\u0631\u06cc\u0691 \u062a\u06c1\u0655 \u062c\u0627\u0646 \u0645\u0627\u06cc\u06cc\u0691'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0428\u043f\u0438\u0446\u0431\u0435\u0440\u0433\u0435\u043d \u0436\u0430\u043d\u0430 \u042f\u043d-\u041c\u0430\u0439\u0435\u043d'),'la':'*aa','lb':'*cy','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0eaa\u0eb0\u0ea7\u0eb2\u0e9a\u0eb2 \u0ec1\u0ea5\u0eb0 \u0ec1\u0ea2\u0e99 \u0ea1\u0eb2\u0ec0\u0ea2\u0e99'),'lt':'Svalbardas ir Janas Majenas','lu':'*aa','lv':u('Svalb\u0101ra un Jana Majena sala'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0421\u0432\u0430\u043b\u0431\u0430\u0440\u0434 \u0438 \u0416\u0430\u043d \u041c\u0435\u0458\u0435\u043d'),'ml':u('\u0d38\u0d4d\u0d35\u0d3e\u0d7d\u0d2c\u0d3e\u0d21\u0d41\u0d02 \u0d1c\u0d3e\u0d7b \u0d2e\u0d3e\u0d2f\u0d47\u0d28\u0d41\u0d02'),'mn':u('\u0421\u0432\u0430\u043b\u0431\u0430\u0440\u0434 \u0431\u0430 \u042f\u043d \u041c\u0430\u0439\u0435\u043d'),'mo':u('Svalbard \u0219i Jan Mayen'),'mr':u('\u0938\u094d\u0935\u093e\u0932\u092c\u0930\u094d\u0921 \u0906\u0923\u093f \u091c\u093e\u0928 \u092e\u093e\u092f\u0947\u0928'),'ms':'Svalbard dan Jan Mayen','mt':'Svalbard u Jan Mayen','my':u('\u1005\u1017\u102d\u102f\u101c\u103a\u1018\u1010\u103a\u1014\u103e\u1004\u1037\u103a\u1002\u103b\u1014\u103a\u1019\u1031\u101b\u1014\u103a'),'na':'*aa','nb':'*da','nd':'*aa','ne':u('\u0938\u092d\u093e\u0932\u094d\u092c\u093e\u0930\u094d\u0921 \u0930 \u091c\u093e\u0928 \u092e\u093e\u092f\u0947\u0928'),'ng':'*aa','nl':'*fy','nn':'*da','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b3e\u0b32\u0b2c\u0b3e\u0b30\u0b4d\u0b21 \u0b0f\u0b2c\u0b02 \u0b1c\u0b3e\u0b28\u0b4d\u200c \u0b2e\u0b3e\u0b5f\u0b47\u0b28\u0b4d\u200c'),'os':'*aa','pa':u('\u0a38\u0a35\u0a3e\u0a32\u0a2c\u0a30\u0a21 \u0a05\u0a24\u0a47 \u0a1c\u0a3e\u0a28 \u0a2e\u0a3e\u0a2f\u0a47\u0a28'),'pi':'*aa','pl':'*ca','ps':u('\u0633\u0644\u0648\u0627\u0689\u0631 \u0627\u0648 \u062c\u0627\u0646 \u0645\u06cc\u06cc\u0646'),'pt':'*gl','qu':'*aa','rm':'*gl','rn':'*aa','ro':'*mo','ru':u('\u0428\u043f\u0438\u0446\u0431\u0435\u0440\u0433\u0435\u043d \u0438 \u042f\u043d-\u041c\u0430\u0439\u0435\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u0648\u0627\u0644\u0628\u0627\u0631\u068a \u06fd \u062c\u0627\u0646 \u0645\u0627\u06cc\u0646'),'se':u('Svalb\u00e1rda ja Jan Mayen'),'sg':'*aa','si':u('\u0dc3\u0dca\u0dc0\u0dd9\u0dbd\u0dca\u0db6\u0dbb\u0dca\u0da9\u0dca \u0dc3\u0dc4 \u0da2\u0dda\u0db1\u0dca \u0db8\u0dba\u0dda\u0db1\u0dca'),'sk':'*cy','sl':'Svalbard in Jan Mayen','sm':'*aa','sn':'*aa','so':'*aa','sq':'Svalbard e Jan-Majen','sr':u('\u0421\u0432\u0430\u043b\u0431\u0430\u0440\u0434 \u0438 \u0408\u0430\u043d \u041c\u0430\u0458\u0435\u043d'),'ss':'*aa','st':'*aa','su':'*aa','sv':'Svalbard och Jan Mayen','sw':'Svalbard na Jan Mayen','ta':u('\u0bb8\u0bcd\u0bb5\u0bb2\u0bcd\u0baa\u0bbe\u0bb0\u0bcd\u0b9f\u0bc1 & \u0b9c\u0bbe\u0ba9\u0bcd \u0bae\u0bc7\u0baf\u0ba9\u0bcd'),'te':u('\u0c38\u0c4d\u0c35\u0c3e\u0c32\u0c4d\u200c\u0c2c\u0c3e\u0c30\u0c4d\u0c21\u0c4d & \u0c1c\u0c3e\u0c28\u0c4d \u0c2e\u0c3e\u0c2f\u0c46\u0c28\u0c4d'),'tg':u('\u0428\u043f\u0438\u0442\u0441\u0431\u0435\u0440\u0433\u0435\u043d \u0432\u0430 \u042f\u043d \u041c\u0430\u0439\u0435\u043d'),'th':u('\u0e2a\u0e1f\u0e32\u0e25\u0e1a\u0e32\u0e23\u0e4c\u0e41\u0e25\u0e30\u0e22\u0e32\u0e19\u0e44\u0e21\u0e40\u0e2d\u0e19'),'ti':u('\u1235\u126b\u120d\u1263\u122d\u12f5\u1295 \u12e3\u1295 \u121b\u12e8\u1295 \u12f0\u1234\u1273\u1275'),'tk':u('\u015episbergen we \u00ddan-Ma\u00fden'),'tl':'*en','tn':'*aa','to':u('Sivolop\u0101ti mo Sani Maieni'),'tr':'Svalbard ve Jan Mayen','ts':'*aa','tt':u('\u0428\u043f\u0438\u0446\u0431\u0435\u0440\u0433\u0435\u043d \u04bb\u04d9\u043c \u042f\u043d-\u041c\u0430\u0439\u0435\u043d'),'tw':'*aa','ty':'*aa','ug':u('\u0633\u0649\u06cb\u0627\u0644\u0628\u0627\u0631\u062f \u06cb\u06d5 \u064a\u0627\u0646 \u0645\u0627\u064a\u06d0\u0646'),'uk':u('\u0428\u043f\u0456\u0446\u0431\u0435\u0440\u0491\u0435\u043d \u0456 \u042f\u043d-\u041c\u0430\u0439\u0435\u043d'),'ur':u('\u0633\u0648\u0627\u0644\u0628\u0631\u0688 \u0627\u0648\u0631 \u062c\u0627\u0646 \u0645\u0627\u06cc\u0646'),'uz':'Shpitsbergen va Yan-Mayen','ve':'*aa','vi':u('Svalbard v\u00e0 Jan Mayen'),'vo':'*aa','wa':'*aa','wo':'Swalbaar ak Jan Mayen','xh':'*aa','yi':'*aa','yo':'*aa','za':'*aa','zh':u('\u65af\u74e6\u5c14\u5df4\u548c\u626c\u9a6c\u5ef6'),'zu':'i-Svalbard ne-Jan Mayen',},
  'SK': {'aa':'Slovakia','ab':'*aa','ae':'*aa','af':'Slowakye','ak':'*aa','am':u('\u1235\u120e\u126b\u12aa\u12eb'),'an':'*aa','ar':u('\u0633\u0644\u0648\u0641\u0627\u0643\u064a\u0627'),'as':u('\u09b6\u09cd\u09b2\u09cb\u09ad\u09be\u0995\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Slovakiya','ba':'*aa','be':u('\u0421\u043b\u0430\u0432\u0430\u043a\u0456\u044f'),'bg':u('\u0421\u043b\u043e\u0432\u0430\u043a\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'Slowaki','bn':u('\u09b8\u09cd\u09b2\u09cb\u09ad\u09be\u0995\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'*aa','bs':u('Slova\u010dka'),'ca':u('Eslov\u00e0quia'),'ce':u('\u0421\u043b\u043e\u0432\u0430\u043a\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'Slovensko','cu':'*aa','cv':'*aa','cy':'Slofacia','da':'Slovakiet','de':'Slowakei','dv':'*aa','dz':u('\u0f66\u0f74\u0f0b\u0f63\u0f7c\u0f0b\u0f56\u0f71\u0f0b\u0f40\u0f72\u0f0b\u0f61'),'ee':'Slovakia nutome','el':u('\u03a3\u03bb\u03bf\u03b2\u03b1\u03ba\u03af\u03b1'),'en':'*aa','eo':'Slovakujo','es':'Eslovaquia','et':'Slovakkia','eu':'Eslovakia','fa':u('\u0627\u0633\u0644\u0648\u0627\u06a9\u06cc'),'ff':'Slowakii','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Slovaquie','fy':'Slowakije','ga':u('an tSl\u00f3vaic'),'gd':u('An t-Sl\u00f2bhac'),'gl':'*es','gn':'*aa','gu':u('\u0ab8\u0acd\u0ab2\u0acb\u0ab5\u0ac7\u0a95\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Sulobakiya','he':u('\u05e1\u05dc\u05d5\u05d1\u05e7\u05d9\u05d4'),'hi':u('\u0938\u094d\u0932\u094b\u0935\u093e\u0915\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Szlov\u00e1kia'),'hy':u('\u054d\u056c\u0578\u057e\u0561\u056f\u056b\u0561'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('Sl\u00f3vak\u00eda'),'it':'Slovacchia','iu':'*aa','iw':'*he','ja':u('\u30b9\u30ed\u30d0\u30ad\u30a2'),'ji':u('\u05e1\u05dc\u05d0\u05d5\u05d5\u05d0\u05b7\u05e7\u05d9\u05d9'),'jv':'*aa','ka':u('\u10e1\u10da\u10dd\u10d5\u10d0\u10d9\u10d4\u10d7\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u179f\u17d2\u179b\u17bc\u179c\u17c9\u17b6\u1782\u17b8'),'kn':u('\u0cb8\u0ccd\u0cb2\u0cca\u0cb5\u0cbe\u0c95\u0cbf\u0caf\u0cbe'),'ko':u('\uc2ac\ub85c\ubc14\ud0a4\uc544'),'kr':'*aa','ks':u('\u0633\u064e\u0644\u0648\u0648\u0627\u06a9\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*de','lg':'Sirovakya','li':'*aa','ln':'Silovaki','lo':u('\u0eaa\u0eb0\u0ec2\u0ea5\u0ea7\u0eb2\u0ec0\u0e81\u0e8d'),'lt':'Slovakija','lu':'*ln','lv':u('Slov\u0101kija'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0421\u043b\u043e\u0432\u0430\u0447\u043a\u0430'),'ml':u('\u0d38\u0d4d\u0d32\u0d4b\u0d35\u0d3e\u0d15\u0d4d\u0d2f'),'mn':u('\u0421\u043b\u043e\u0432\u0430\u043a'),'mo':'Slovacia','mr':u('\u0938\u094d\u0932\u094b\u0935\u094d\u0939\u093e\u0915\u093f\u092f\u093e'),'ms':'*aa','mt':'is-Slovakkja','my':u('\u1006\u101c\u102d\u102f\u1017\u1000\u103a\u1000\u102e\u1038\u101a\u102c\u1038'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0938\u094d\u0932\u094b\u092d\u093e\u0915\u093f\u092f\u093e'),'ng':'*aa','nl':'*fy','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b4d\u0b32\u0b4b\u0b2d\u0b3e\u0b15\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a38\u0a32\u0a4b\u0a35\u0a3e\u0a15\u0a40\u0a06'),'pi':'*aa','pl':u('S\u0142owacja'),'ps':u('\u0633\u0644\u0648\u0627\u06a9\u06cc\u0627'),'pt':u('Eslov\u00e1quia'),'qu':'*es','rm':'Slovachia','rn':'Silovakiya','ro':'*mo','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u0644\u0648\u0648\u0627\u06aa\u064a\u0627'),'se':u('Slov\u00e1kia'),'sg':u('Solovak\u00efi'),'si':u('\u0dc3\u0dca\u0dbd\u0ddd\u0dc0\u0dd0\u0d9a\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*cs','sl':u('Slova\u0161ka'),'sm':'*aa','sn':'*aa','so':'*aa','sq':'Sllovaki','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'Slovakien','sw':'*aa','ta':u('\u0bb8\u0bcd\u0bb2\u0bcb\u0bb5\u0bbe\u0b95\u0bbf\u0baf\u0bbe'),'te':u('\u0c38\u0c4d\u0c32\u0c4b\u0c35\u0c47\u0c15\u0c3f\u0c2f\u0c3e'),'tg':'*bg','th':u('\u0e2a\u0e42\u0e25\u0e27\u0e30\u0e40\u0e01\u0e35\u0e22'),'ti':'*am','tk':u('Slowaki\u00fda'),'tl':'*aa','tn':'*aa','to':u('Sil\u014dvakia'),'tr':'Slovakya','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0633\u0649\u0644\u0648\u06cb\u0627\u0643\u0649\u064a\u06d5'),'uk':u('\u0421\u043b\u043e\u0432\u0430\u0447\u0447\u0438\u043d\u0430'),'ur':u('\u0633\u0644\u0648\u0648\u0627\u06a9\u06cc\u06c1'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Eslowaki','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Silofakia'),'za':'*aa','zh':u('\u65af\u6d1b\u4f10\u514b'),'zu':'i-Slovakia',},
  'SL': {'aa':'Sierra Leone','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u1234\u122b\u120a\u12ee\u1295'),'an':'*aa','ar':u('\u0633\u064a\u0631\u0627\u0644\u064a\u0648\u0646'),'as':u('\u099a\u09bf\u09af\u09bc\u09c7\u09f0\u09be \u09b2\u09bf\u0985\u2019\u09a8'),'av':'*aa','ay':'*aa','az':'Syerra-Leone','ba':'*aa','be':u('\u0421\u044c\u0435\u0440\u0430-\u041b\u0435\u043e\u043d\u044d'),'bg':u('\u0421\u0438\u0435\u0440\u0430 \u041b\u0435\u043e\u043d\u0435'),'bh':'*aa','bi':'*aa','bm':u('Siyera Lew\u0254ni'),'bn':u('\u09b8\u09bf\u09af\u09bc\u09c7\u09b0\u09be \u09b2\u09bf\u0993\u09a8'),'bo':'*aa','br':'*aa','bs':'Sijera Leone','ca':'*aa','ce':u('\u0421\u044c\u0435\u0440\u0440\u0430- \u041b\u0435\u043e\u043d\u0435'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f66\u0f72\u0f0b\u0f62\u0f0b \u0f63\u0f72\u0f0b\u0f60\u0f7c\u0f53'),'ee':'Sierra Leone nutome','el':u('\u03a3\u03b9\u03ad\u03c1\u03b1 \u039b\u03b5\u03cc\u03bd\u03b5'),'en':'*aa','eo':'Siera-Leono','es':'Sierra Leona','et':'*aa','eu':'*es','fa':u('\u0633\u06cc\u0631\u0627\u0644\u0626\u0648\u0646'),'ff':'Seraa liyon','fi':'*aa','fj':'*aa','fo':'*es','fr':'*aa','fy':'*aa','ga':'Siarra Leon','gd':u('Siarra Le\u00f2mhann'),'gl':'Serra Leoa','gn':'*aa','gu':u('\u0ab8\u0ac0\u0a8f\u0ab0\u0abe \u0ab2\u0ac7\u0a93\u0aa8'),'gv':'*aa','ha':'Salewo','he':u('\u05e1\u05d9\u05d9\u05e8\u05d4 \u05dc\u05d0\u05d5\u05e0\u05d4'),'hi':u('\u0938\u093f\u090f\u0930\u093e \u0932\u093f\u092f\u094b\u0928'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':'*aa','hy':u('\u054d\u056b\u0565\u057c\u0561 \u053c\u0565\u0578\u0576\u0565'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('S\u00ederra Le\u00f3ne'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30b7\u30a8\u30e9\u30ec\u30aa\u30cd'),'ji':u('\u05e1\u05d9\u05e2\u05e8\u05e2 \u05dc\u05e2\u05d0\u05e0\u05e2'),'jv':'*aa','ka':u('\u10e1\u10d8\u10d4\u10e0\u10d0-\u10da\u10d4\u10dd\u10dc\u10d4'),'kg':'*aa','ki':'Siera Leoni','kj':'*aa','kk':u('\u0421\u044c\u0435\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435'),'kl':'*aa','km':u('\u179f\u17c0\u179a\u17c9\u17b6\u17a1\u17c1\u17a2\u17bc\u1793'),'kn':u('\u0cb8\u0cbf\u0caf\u0cc6\u0cb0\u0ccd\u0cb0\u0cbe \u0cb2\u0cbf\u0caf\u0ccb\u0ca8\u0ccd'),'ko':u('\uc2dc\uc5d0\ub77c\ub9ac\uc628'),'kr':'*aa','ks':u('\u0633\u06cc\u0656\u0631\u0627\u0644\u06cc\u0648\u0648\u0646'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*kk','la':'*aa','lb':'*aa','lg':'Siyeralewone','li':'*aa','ln':u('Siera Leon\u025b'),'lo':u('\u0ec0\u0e8a\u0e8d\u0ea3\u0eb2 \u0ea5\u0eb5\u0ec2\u0ead\u0e99'),'lt':u('Siera Leon\u0117'),'lu':'Siera Leone','lv':'Sjerraleone','mg':'*aa','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d38\u0d3f\u0d2f\u0d46\u0d31 \u0d32\u0d3f\u0d2f\u0d4b\u0d7a'),'mn':'*kk','mo':'*aa','mr':u('\u0938\u093f\u090f\u0930\u093e \u0932\u093f\u0913\u0928'),'ms':'*aa','mt':'*aa','my':u('\u1006\u102e\u101a\u102c\u101b\u102c \u101c\u102e\u101a\u103d\u1014\u103a\u1038'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0938\u093f\u090f\u0930\u094d\u0930\u093e \u0932\u093f\u0913\u0928'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b3f\u0b0f\u0b30\u0b3e \u0b32\u0b3f\u0b13\u0b28'),'os':'*aa','pa':u('\u0a38\u0a3f\u0a0f\u0a30\u0a3e \u0a32\u0a3f\u0a13\u0a28'),'pi':'*aa','pl':'*aa','ps':u('\u0633\u06cc\u06cc\u0631\u0627 \u0644\u06cc\u0648\u0646'),'pt':'*gl','qu':'*es','rm':'*aa','rn':'*lg','ro':'*aa','ru':'*kk','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u064a\u0631\u0627 \u0644\u064a\u0648\u0646'),'se':'*aa','sg':u('Sier\u00e4-Le\u00f4ne'),'si':u('\u0dc3\u0dd2\u0dba\u0dbb\u0dcf\u0dbd\u0dd2\u0dba\u0ddd\u0db1\u0dca'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'Siraaliyoon','sq':'Siera-Leone','sr':u('\u0421\u0438\u0458\u0435\u0440\u0430 \u041b\u0435\u043e\u043d\u0435'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*ki','ta':u('\u0b9a\u0bbf\u0baf\u0bbe\u0bb0\u0bbe \u0bb2\u0bbf\u0baf\u0bcb\u0ba9\u0bcd'),'te':u('\u0c38\u0c3f\u0c2f\u0c46\u0c30\u0c4d\u0c30\u0c3e \u0c32\u0c3f\u0c2f\u0c3e\u0c28\u0c4d'),'tg':u('\u0421\u0438\u0435\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435'),'th':u('\u0e40\u0e0b\u0e35\u0e22\u0e23\u0e4c\u0e23\u0e32\u0e25\u0e35\u0e42\u0e2d\u0e19'),'ti':'*am','tk':u('S\u00fderra-Leone'),'tl':'*aa','tn':'*aa','to':'Siela Leone','tr':'*aa','ts':'*aa','tt':'*kk','tw':'*aa','ty':'*aa','ug':u('\u0633\u06d0\u0631\u0631\u0627\u0644\u06d0\u0626\u0648\u0646'),'uk':u('\u0421\u044c\u0454\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435'),'ur':u('\u0633\u06cc\u0631\u0627\u0644\u06cc\u0648\u0646'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Siyera Lewon','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Siria looni'),'za':'*aa','zh':u('\u585e\u62c9\u5229\u6602'),'zu':'i-Sierra Leone',},
  'SM': {'aa':'San Marino','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u1233\u1295 \u121b\u122a\u1296'),'an':'*aa','ar':u('\u0633\u0627\u0646 \u0645\u0627\u0631\u064a\u0646\u0648'),'as':u('\u099a\u09be\u09a8 \u09ae\u09be\u09f0\u09bf\u09a8\u09cb'),'av':'*aa','ay':'*aa','az':'San-Marino','ba':'*aa','be':u('\u0421\u0430\u043d-\u041c\u0430\u0440\u044b\u043d\u0430'),'bg':u('\u0421\u0430\u043d \u041c\u0430\u0440\u0438\u043d\u043e'),'bh':'*aa','bi':'*aa','bm':'Marini-Senu','bn':u('\u09b8\u09be\u09a8 \u09ae\u09be\u09b0\u09bf\u09a8\u09cb'),'bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':u('\u0421\u0430\u043d-\u041c\u0430\u0440\u0438\u043d\u043e'),'ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f66\u0f71\u0f53\u0f0b\u0f58\u0f0b\u0f62\u0f72\u0f0b\u0f53\u0f7c'),'ee':'San Marino nutome','el':u('\u0386\u03b3\u03b9\u03bf\u03c2 \u039c\u03b1\u03c1\u03af\u03bd\u03bf\u03c2'),'en':'*aa','eo':'*az','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0633\u0627\u0646\u200c\u0645\u0627\u0631\u06cc\u0646\u0648'),'ff':'See Maree','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Saint-Marin','fy':'*aa','ga':u('San Mair\u00edne'),'gd':'*aa','gl':'*aa','gn':'*aa','gu':u('\u0ab8\u0ac5\u0aa8 \u0aae\u0ac7\u0ab0\u0abf\u0aa8\u0acb'),'gv':'*aa','ha':'*aa','he':u('\u05e1\u05df \u05de\u05e8\u05d9\u05e0\u05d5'),'hi':u('\u0938\u0948\u0928 \u092e\u0947\u0930\u0940\u0928\u094b'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':'*aa','hy':u('\u054d\u0561\u0576 \u0544\u0561\u0580\u056b\u0576\u0578'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('San Mar\u00edn\u00f3'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30b5\u30f3\u30de\u30ea\u30ce'),'ji':u('\u05e1\u05d0\u05b7\u05df \u05de\u05d0\u05b7\u05e8\u05d9\u05e0\u05d0'),'jv':'*aa','ka':u('\u10e1\u10d0\u10dc-\u10db\u10d0\u10e0\u10d8\u10dc\u10dd'),'kg':'*aa','ki':'Samarino','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u179f\u17b6\u1793\u200b\u1798\u17c9\u17b6\u179a\u17b8\u178e\u17bc'),'kn':u('\u0cb8\u0ccd\u0caf\u0cbe\u0ca8\u0ccd \u0cae\u0cc6\u0cb0\u0cbf\u0ca8\u0ccb'),'ko':u('\uc0b0\ub9c8\ub9ac\ub178'),'kr':'*aa','ks':u('\u0633\u06cc\u0646 \u0645\u06cc\u0631\u0650\u0646\u0648'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'Sanimarino','li':'*aa','ln':u('S\u00e1ntu Marin\u025b'),'lo':u('\u0ec1\u0e8a\u0e99 \u0ea1\u0eb2\u0ea3\u0eb4\u0ec2\u0e99'),'lt':'San Marinas','lu':'Santu Marine','lv':u('Sanmar\u012bno'),'mg':'*fr','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d38\u0d3e\u0d7b \u0d2e\u0d31\u0d3f\u0d28\u0d4b'),'mn':'*ce','mo':'*aa','mr':u('\u0938\u0945\u0928 \u092e\u0930\u0940\u0928\u094b'),'ms':'*aa','mt':'*aa','my':u('\u1006\u1014\u103a\u1019\u102c\u101b\u102e\u1014\u102d\u102f'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u0938\u093e\u0928\u094d \u092e\u093e\u0930\u093f\u0928\u094b'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b3e\u0b28\u0b4d \u0b2e\u0b3e\u0b30\u0b3f\u0b28\u0b4b'),'os':'*aa','pa':u('\u0a38\u0a48\u0a28 \u0a2e\u0a30\u0a40\u0a28\u0a4b'),'pi':'*aa','pl':'*aa','ps':u('\u0633\u0627\u0646 \u0645\u0627\u0631\u06cc\u0646\u0648'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'*lg','ro':'*aa','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u06cc\u0646 \u0645\u0631\u06cc\u0646\u0648'),'se':'*aa','sg':u('S\u00ean-Mar\u00eben'),'si':u('\u0dc3\u0dd0\u0db1\u0dca \u0db8\u0dd0\u0dbb\u0dd2\u0db1\u0ddd'),'sk':u('San Mar\u00edno'),'sl':'*aa','sm':'*aa','sn':'*aa','so':'*aa','sq':'*az','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b9a\u0bbe\u0ba9\u0bcd \u0bae\u0bb0\u0bbf\u0ba9\u0bcb'),'te':u('\u0c36\u0c3e\u0c28\u0c4d \u0c2e\u0c3e\u0c30\u0c3f\u0c28\u0c4b'),'tg':'*ce','th':u('\u0e0b\u0e32\u0e19\u0e21\u0e32\u0e23\u0e34\u0e42\u0e19'),'ti':'*am','tk':'*az','tl':'*aa','tn':'*aa','to':u('S\u0101 Malino'),'tr':'*aa','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u0633\u0627\u0646 \u0645\u0627\u0631\u0649\u0646\u0648'),'uk':u('\u0421\u0430\u043d-\u041c\u0430\u0440\u0456\u043d\u043e'),'ur':'*ps','uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*aa','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Sani Marino'),'za':'*aa','zh':u('\u5723\u9a6c\u529b\u8bfa'),'zu':'i-San Marino',},
  'SN': {'aa':'Senegal','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u1234\u1294\u130b\u120d'),'an':'*aa','ar':u('\u0627\u0644\u0633\u0646\u063a\u0627\u0644'),'as':u('\u099a\u09c7\u09a8\u09c7\u0997\u09be\u09b2'),'av':'*aa','ay':'*aa','az':'Seneqal','ba':'*aa','be':u('\u0421\u0435\u043d\u0435\u0433\u0430\u043b'),'bg':'*be','bh':'*aa','bi':'*aa','bm':'Senegali','bn':u('\u09b8\u09c7\u09a8\u09c7\u0997\u09be\u09b2'),'bo':'*aa','br':'*aa','bs':'*aa','ca':'*aa','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*aa','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f66\u0f7a\u0f0b\u0f53\u0f72\u0f0b\u0f42\u0fb7\u0f63'),'ee':'Senegal nutome','el':u('\u03a3\u03b5\u03bd\u03b5\u03b3\u03ac\u03bb\u03b7'),'en':'*aa','eo':'Senegalo','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0633\u0646\u06af\u0627\u0644'),'ff':'Senegaal','fi':'*aa','fj':'*aa','fo':'*aa','fr':u('S\u00e9n\u00e9gal'),'fy':'*aa','ga':u('an tSeineag\u00e1il'),'gd':'Seanagal','gl':'*aa','gn':'*aa','gu':u('\u0ab8\u0ac7\u0aa8\u0ac7\u0a97\u0ab2'),'gv':'*aa','ha':'Sinigal','he':u('\u05e1\u05e0\u05d2\u05dc'),'hi':u('\u0938\u0947\u0928\u0947\u0917\u0932'),'ho':'*aa','hr':'*aa','ht':'*aa','hu':u('Szeneg\u00e1l'),'hy':u('\u054d\u0565\u0576\u0565\u0563\u0561\u056c'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30bb\u30cd\u30ac\u30eb'),'ji':u('\u05e1\u05e2\u05e0\u05e2\u05d2\u05d0\u05b7\u05dc'),'jv':'*aa','ka':u('\u10e1\u10d4\u10dc\u10d4\u10d2\u10d0\u10da\u10d8'),'kg':'*aa','ki':'*bm','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u179f\u17c1\u178e\u17c1\u17a0\u17d2\u1782\u17b6\u179b\u17cb'),'kn':u('\u0cb8\u0cc6\u0ca8\u0cc6\u0c97\u0cb2\u0ccd'),'ko':u('\uc138\ub124\uac08'),'kr':'*aa','ks':u('\u0633\u06cc\u0646\u06cc\u06af\u064e\u0644'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*be','la':'*aa','lb':'*aa','lg':'Senegaalo','li':'*aa','ln':u('Senegal\u025b'),'lo':u('\u0ec0\u0e8a\u0e99\u0eb5\u0ec2\u0e81\u0ea5'),'lt':'Senegalas','lu':'Senegale','lv':u('Seneg\u0101la'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':'*be','ml':u('\u0d38\u0d46\u0d28\u0d17\u0d7d'),'mn':'*be','mo':'*aa','mr':'*hi','ms':'*aa','mt':'is-Senegal','my':u('\u1006\u102e\u1014\u102e\u1002\u1031\u102b'),'na':'*aa','nb':'*aa','nd':'*bm','ne':'*hi','ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b47\u0b28\u0b47\u0b17\u0b3e\u0b32\u0b4d'),'os':'*aa','pa':u('\u0a38\u0a47\u0a28\u0a47\u0a17\u0a32'),'pi':'*aa','pl':'*aa','ps':u('\u0633\u0646\u06ab\u0627\u0644'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'*bm','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u064a\u0646\u064a\u06af\u0627\u0644'),'se':'*aa','sg':u('Seneg\u00e4le'),'si':u('\u0dc3\u0dd9\u0db1\u0d9c\u0dcf\u0dbd\u0dba'),'sk':'*aa','sl':'*aa','sm':'*aa','sn':'*aa','so':'Sinigaal','sq':'*aa','sr':'*be','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*bm','ta':u('\u0b9a\u0bc6\u0ba9\u0bc6\u0b95\u0bb2\u0bcd'),'te':u('\u0c38\u0c46\u0c28\u0c46\u0c17\u0c32\u0c4d'),'tg':'*be','th':u('\u0e40\u0e0b\u0e40\u0e19\u0e01\u0e31\u0e25'),'ti':'*am','tk':'*aa','tl':'*aa','tn':'*aa','to':'Senekalo','tr':'*aa','ts':'*aa','tt':'*be','tw':'*aa','ty':'*aa','ug':u('\u0633\u06d0\u0646\u06d0\u06af\u0627\u0644'),'uk':'*be','ur':u('\u0633\u06cc\u0646\u06cc\u06af\u0644'),'uz':'*aa','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*ff','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de S\u1eb9n\u1eb9ga'),'za':'*aa','zh':u('\u585e\u5185\u52a0\u5c14'),'zu':'i-Senegal',},
  'SO': {'aa':'Somalia','ab':'*aa','ae':'*aa','af':u('Somali\u00eb'),'ak':'*aa','am':u('\u1231\u121b\u120c'),'an':'*aa','ar':u('\u0627\u0644\u0635\u0648\u0645\u0627\u0644'),'as':u('\u099a\u09cb\u09ae\u09be\u09b2\u09bf\u09af\u09bc\u09be'),'av':'*aa','ay':'*aa','az':'Somali','ba':'*aa','be':u('\u0421\u0430\u043c\u0430\u043b\u0456'),'bg':u('\u0421\u043e\u043c\u0430\u043b\u0438\u044f'),'bh':'*aa','bi':'*aa','bm':'*az','bn':u('\u09b8\u09cb\u09ae\u09be\u09b2\u09bf\u09af\u09bc\u09be'),'bo':'*aa','br':'*aa','bs':'Somalija','ca':u('Som\u00e0lia'),'ce':u('\u0421\u043e\u043c\u0430\u043b\u0438'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Som\u00e1lsko'),'cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f66\u0f7c\u0f0b\u0f58\u0f0b\u0f63\u0f72\u0f0b\u0f61'),'ee':'Somalia nutome','el':u('\u03a3\u03bf\u03bc\u03b1\u03bb\u03af\u03b1'),'en':'*aa','eo':'Somalujo','es':'*aa','et':'Somaalia','eu':'*aa','fa':u('\u0633\u0648\u0645\u0627\u0644\u06cc'),'ff':'Somalii','fi':'*aa','fj':'*aa','fo':'*aa','fr':'Somalie','fy':'*af','ga':u('an tSom\u00e1il'),'gd':u('Som\u00e0ilia'),'gl':'*aa','gn':'*aa','gu':u('\u0ab8\u0acb\u0aae\u0abe\u0ab2\u0abf\u0aaf\u0abe'),'gv':'*aa','ha':'Somaliya','he':u('\u05e1\u05d5\u05de\u05dc\u05d9\u05d4'),'hi':u('\u0938\u094b\u092e\u093e\u0932\u093f\u092f\u093e'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('Szom\u00e1lia'),'hy':u('\u054d\u0578\u0574\u0561\u056c\u056b'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('S\u00f3mal\u00eda'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30bd\u30de\u30ea\u30a2'),'ji':u('\u05e1\u05d0\u05de\u05d0\u05b7\u05dc\u05d9\u05e2'),'jv':'*aa','ka':u('\u10e1\u10dd\u10db\u10d0\u10da\u10d8'),'kg':'*aa','ki':'Somaria','kj':'*aa','kk':'*ce','kl':'*aa','km':u('\u179f\u17bc\u1798\u17c9\u17b6\u179b\u17b8'),'kn':u('\u0cb8\u0cca\u0cae\u0cbe\u0cb2\u0cbf\u0caf\u0cbe'),'ko':u('\uc18c\ub9d0\ub9ac\uc544'),'kr':'*aa','ks':u('\u0633\u0648\u0645\u0627\u0644\u0650\u06cc\u0627'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*ce','la':'*aa','lb':'*aa','lg':'*ha','li':'*aa','ln':'*az','lo':u('\u0ec2\u0e8a\u0ea1\u0eb2\u0ec0\u0ea5\u0e8d'),'lt':'Somalis','lu':'*az','lv':u('Som\u0101lija'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0421\u043e\u043c\u0430\u043b\u0438\u0458\u0430'),'ml':u('\u0d38\u0d4b\u0d2e\u0d3e\u0d32\u0d3f\u0d2f'),'mn':'*ce','mo':'*aa','mr':'*hi','ms':'*aa','mt':'is-Somalja','my':u('\u1006\u102d\u102f\u1019\u102c\u101c\u102e\u101a\u102c'),'na':'*aa','nb':'*aa','nd':'*ha','ne':'*hi','ng':'*aa','nl':'*af','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b4b\u0b2e\u0b3e\u0b32\u0b3f\u0b06'),'os':'*aa','pa':u('\u0a38\u0a4b\u0a2e\u0a3e\u0a32\u0a40\u0a06'),'pi':'*aa','pl':'*aa','ps':u('\u0633\u0648\u0645\u0627\u0644\u06cc\u0627'),'pt':u('Som\u00e1lia'),'qu':'*aa','rm':'*aa','rn':'*ha','ro':'*aa','ru':'*ce','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u0648\u0645\u0627\u0644\u064a\u0627'),'se':'*pt','sg':u('Somal\u00efi'),'si':u('\u0dc3\u0ddd\u0db8\u0dcf\u0dbd\u0dd2\u0dba\u0dcf\u0dc0'),'sk':'*cs','sl':'*bs','sm':'*aa','sn':'*aa','so':'Soomaaliya','sq':'*az','sr':'*mk','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b9a\u0bcb\u0bae\u0bbe\u0bb2\u0bbf\u0baf\u0bbe'),'te':u('\u0c38\u0c4b\u0c2e\u0c3e\u0c32\u0c3f\u0c2f\u0c3e'),'tg':u('\u0421\u043e\u043c\u0430\u043b\u04e3'),'th':u('\u0e42\u0e0b\u0e21\u0e32\u0e40\u0e25\u0e35\u0e22'),'ti':'*am','tk':'*az','tl':'*aa','tn':'*aa','to':u('S\u014dmalia'),'tr':'*az','ts':'*aa','tt':'*ce','tw':'*aa','ty':'*aa','ug':u('\u0633\u0648\u0645\u0627\u0644\u0649'),'uk':u('\u0421\u043e\u043c\u0430\u043b\u0456'),'ur':u('\u0635\u0648\u0645\u0627\u0644\u06cc\u06c1'),'uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'*az','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Somalia'),'za':'*aa','zh':u('\u7d22\u9a6c\u91cc'),'zu':'i-Somalia',},
  'SR': {'aa':'Suriname','ab':'*aa','ae':'*aa','af':'*aa','ak':'*aa','am':u('\u1231\u122a\u1293\u121d'),'an':'*aa','ar':u('\u0633\u0648\u0631\u064a\u0646\u0627\u0645'),'as':u('\u099b\u09c1\u09f0\u09bf\u09a8\u09be\u09ae'),'av':'*aa','ay':'*aa','az':'Surinam','ba':'*aa','be':u('\u0421\u0443\u0440\u044b\u043d\u0430\u043c'),'bg':u('\u0421\u0443\u0440\u0438\u043d\u0430\u043c'),'bh':'*aa','bi':'*aa','bm':'Surinami','bn':u('\u09b8\u09c1\u09b0\u09bf\u09a8\u09be\u09ae'),'bo':'*aa','br':'*az','bs':'*az','ca':'*az','ce':'*bg','ch':'*aa','co':'*aa','cr':'*aa','cs':'*az','cu':'*aa','cv':'*aa','cy':'*aa','da':'*az','de':'*aa','dv':'*aa','dz':u('\u0f66\u0f74\u0f0b\u0f62\u0f72\u0f0b\u0f53\u0f71\u0f58'),'ee':'Suriname nutome','el':u('\u03a3\u03bf\u03c5\u03c1\u03b9\u03bd\u03ac\u03bc'),'en':'*aa','eo':'Surinamo','es':'*az','et':'*aa','eu':'*az','fa':u('\u0633\u0648\u0631\u06cc\u0646\u0627\u0645'),'ff':'Surinaam','fi':'*aa','fj':'*aa','fo':'*az','fr':'*aa','fy':'*aa','ga':'Suranam','gd':'*ga','gl':'*aa','gn':'*aa','gu':u('\u0ab8\u0ac1\u0ab0\u0ac0\u0aa8\u0abe\u0aae'),'gv':'*aa','ha':'*aa','he':u('\u05e1\u05d5\u05e8\u05d9\u05e0\u05d0\u05dd'),'hi':u('\u0938\u0942\u0930\u0940\u0928\u093e\u092e'),'ho':'*aa','hr':'*az','ht':'*aa','hu':'*aa','hy':u('\u054d\u0578\u0582\u0580\u056b\u0576\u0561\u0574'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':u('S\u00far\u00ednam'),'it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30b9\u30ea\u30ca\u30e0'),'ji':u('\u05e1\u05d5\u05e8\u05d9\u05e0\u05d0\u05b7\u05dd'),'jv':'*aa','ka':u('\u10e1\u10e3\u10e0\u10d8\u10dc\u10d0\u10db\u10d8'),'kg':'*aa','ki':'Surinamu','kj':'*aa','kk':'*bg','kl':'*aa','km':u('\u179f\u17bc\u179a\u17b8\u178e\u17b6\u1798'),'kn':u('\u0cb8\u0cc1\u0cb0\u0cbf\u0ca8\u0cbe\u0cae\u0ccd'),'ko':u('\uc218\ub9ac\ub0a8'),'kr':'*aa','ks':u('\u0633\u064f\u0631\u0650\u0646\u0627\u0645'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':'*bg','la':'*aa','lb':'*aa','lg':'Surinaamu','li':'*aa','ln':u('Surinam\u025b'),'lo':u('\u0e8a\u0eb9\u0ea3\u0eb4\u0e99\u0eb2\u0ea1'),'lt':'Surinamas','lu':'*aa','lv':'Surinama','mg':'Sorinam','mh':'*aa','mi':'*aa','mk':'*bg','ml':u('\u0d38\u0d41\u0d30\u0d3f\u0d28\u0d3e\u0d02'),'mn':'*bg','mo':'*aa','mr':u('\u0938\u0941\u0930\u093f\u0928\u093e\u092e'),'ms':'*az','mt':'is-Suriname','my':u('\u1006\u1030\u101b\u102c\u1014\u1019\u103a'),'na':'*aa','nb':'*az','nd':'*aa','ne':u('\u0938\u0941\u0930\u093f\u0928\u0947\u092e'),'ng':'*aa','nl':'*aa','nn':'*az','no':'*az','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b41\u0b30\u0b3f\u0b28\u0b3e\u0b2e'),'os':'*aa','pa':u('\u0a38\u0a42\u0a30\u0a40\u0a28\u0a3e\u0a2e'),'pi':'*aa','pl':'*az','ps':'*fa','pt':'*aa','qu':'*az','rm':'*az','rn':'*aa','ro':'*aa','ru':'*bg','rw':'*aa','sa':'*aa','sc':'*aa','sd':'*ar','se':'*az','sg':u('Surin\u00e4m'),'si':u('\u0dc3\u0dd4\u0dbb\u0dd2\u0db1\u0dcf\u0db8\u0dba'),'sk':'*az','sl':'*az','sm':'*aa','sn':'*aa','so':'*aa','sq':'*bm','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*az','sw':'*aa','ta':u('\u0b9a\u0bc1\u0bb0\u0bbf\u0ba9\u0bbe\u0bae\u0bcd'),'te':u('\u0c38\u0c42\u0c30\u0c3f\u0c28\u0c3e\u0c2e\u0c4d'),'tg':'*bg','th':u('\u0e0b\u0e39\u0e23\u0e34\u0e19\u0e32\u0e40\u0e21'),'ti':'*am','tk':'*az','tl':'*aa','tn':'*aa','to':'Suliname','tr':'*az','ts':'*aa','tt':'*bg','tw':'*aa','ty':'*aa','ug':u('\u0633\u06c7\u0631\u0649\u0646\u0627\u0645'),'uk':u('\u0421\u0443\u0440\u0456\u043d\u0430\u043c'),'ur':'*fa','uz':'*az','ve':'*aa','vi':'*aa','vo':'*aa','wa':'*aa','wo':'Sirinam','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Surinami'),'za':'*aa','zh':u('\u82cf\u91cc\u5357'),'zu':'i-Suriname',},
  'SS': {'aa':'South Sudan','ab':'*aa','ae':'*aa','af':'Suid-Soedan','ak':'*aa','am':u('\u12f0\u1261\u1265 \u1231\u12f3\u1295'),'an':'*aa','ar':u('\u062c\u0646\u0648\u0628 \u0627\u0644\u0633\u0648\u062f\u0627\u0646'),'as':u('\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u099a\u09c1\u09a1\u09be\u09a8'),'av':'*aa','ay':'*aa','az':u('C\u0259nubi Sudan'),'ba':'*aa','be':u('\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u044b \u0421\u0443\u0434\u0430\u043d'),'bg':u('\u042e\u0436\u0435\u043d \u0421\u0443\u0434\u0430\u043d'),'bh':'*aa','bi':'*aa','bm':'*aa','bn':u('\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u09b8\u09c1\u09a6\u09be\u09a8'),'bo':'*aa','br':'Susoudan','bs':u('Ju\u017eni Sudan'),'ca':'Sudan del Sud','ce':u('\u041a\u044a\u0438\u043b\u0431\u0430 \u0421\u0443\u0434\u0430\u043d'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Ji\u017en\u00ed S\u00fad\u00e1n'),'cu':'*aa','cv':'*aa','cy':'De Swdan','da':'Sydsudan','de':u('S\u00fcdsudan'),'dv':'*aa','dz':u('\u0f66\u0f71\u0f60\u0f74\u0f50\u0f0b \u0f66\u0f74\u0f0b\u0f4c\u0f71\u0f53'),'ee':'*aa','el':u('\u039d\u03cc\u03c4\u03b9\u03bf \u03a3\u03bf\u03c5\u03b4\u03ac\u03bd'),'en':'*aa','eo':'*aa','es':u('Sud\u00e1n del Sur'),'et':u('L\u00f5una-Sudaan'),'eu':'Hego Sudan','fa':u('\u0633\u0648\u062f\u0627\u0646 \u062c\u0646\u0648\u0628\u06cc'),'ff':'*aa','fi':u('Etel\u00e4-Sudan'),'fj':'*aa','fo':u('Su\u00f0ursudan'),'fr':'Soudan du Sud','fy':u('S\u00fbd-Soedan'),'ga':u('an tS\u00fad\u00e1in Theas'),'gd':u('Sud\u00e0n a Deas'),'gl':u('Sud\u00e1n do Sur'),'gn':'*aa','gu':u('\u0aa6\u0a95\u0acd\u0ab7\u0abf\u0aa3 \u0ab8\u0ac1\u0aa6\u0abe\u0aa8'),'gv':'*aa','ha':'*aa','he':u('\u05d3\u05e8\u05d5\u05dd \u05e1\u05d5\u05d3\u05df'),'hi':u('\u0926\u0915\u094d\u0937\u093f\u0923 \u0938\u0942\u0921\u093e\u0928'),'ho':'*aa','hr':'*bs','ht':'*aa','hu':u('D\u00e9l-Szud\u00e1n'),'hy':u('\u0540\u0561\u0580\u0561\u057e\u0561\u0575\u056b\u0576 \u054d\u0578\u0582\u0564\u0561\u0576'),'hz':'*aa','ia':'*aa','id':'Sudan Selatan','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Su\u00f0ur-S\u00fadan'),'it':'Sud Sudan','iu':'*aa','iw':'*he','ja':u('\u5357\u30b9\u30fc\u30c0\u30f3'),'ji':u('\u05d3\u05e8\u05d5\u05dd\u05be\u05e1\u05d5\u05d3\u05d0\u05b7\u05df'),'jv':'*aa','ka':u('\u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7 \u10e1\u10e3\u10d3\u10d0\u10dc\u10d8'),'kg':'*aa','ki':'*aa','kj':'*aa','kk':u('\u041e\u04a3\u0442\u04af\u0441\u0442\u0456\u043a \u0421\u0443\u0434\u0430\u043d'),'kl':'*aa','km':u('\u179f\u17ca\u17bc\u178a\u1784\u17cb\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784'),'kn':u('\u0ca6\u0c95\u0ccd\u0cb7\u0cbf\u0ca3 \u0cb8\u0cc1\u0ca1\u0cbe\u0ca8\u0ccd'),'ko':u('\ub0a8\uc218\ub2e8'),'kr':'*aa','ks':'*aa','ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0422\u04af\u0448\u0442\u04af\u043a \u0421\u0443\u0434\u0430\u043d'),'la':'*aa','lb':'*de','lg':'*aa','li':'*aa','ln':'*aa','lo':u('\u0e8a\u0eb9\u0e94\u0eb2\u0e99\u0ec3\u0e95\u0ec9'),'lt':u('Piet\u0173 Sudanas'),'lu':'*aa','lv':u('Dienvidsud\u0101na'),'mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0408\u0443\u0436\u0435\u043d \u0421\u0443\u0434\u0430\u043d'),'ml':u('\u0d26\u0d15\u0d4d\u0d37\u0d3f\u0d23 \u0d38\u0d41\u0d21\u0d3e\u0d7b'),'mn':u('\u04e8\u043c\u043d\u04e9\u0434 \u0421\u0443\u0434\u0430\u043d'),'mo':'Sudanul de Sud','mr':u('\u0926\u0915\u094d\u0937\u093f\u0923 \u0938\u0941\u0926\u093e\u0928'),'ms':'*id','mt':u('is-Sudan t\u2019Isfel'),'my':u('\u1010\u1031\u102c\u1004\u103a \u1006\u1030\u1012\u1014\u103a'),'na':'*aa','nb':u('S\u00f8r-Sudan'),'nd':'*aa','ne':u('\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0938\u0941\u0921\u093e\u0928'),'ng':'*aa','nl':'Zuid-Soedan','nn':'*nb','no':'*nb','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b38\u0b41\u0b26\u0b3e\u0b28'),'os':'*aa','pa':u('\u0a26\u0a71\u0a16\u0a23 \u0a38\u0a41\u0a21\u0a3e\u0a28'),'pi':'*aa','pl':u('Sudan Po\u0142udniowy'),'ps':u('\u062c\u0646\u0648\u0628\u064a \u0633\u0648\u0689\u0627\u0646'),'pt':u('Sud\u00e3o do Sul'),'qu':'*es','rm':'*aa','rn':'*aa','ro':'*mo','ru':u('\u042e\u0436\u043d\u044b\u0439 \u0421\u0443\u0434\u0430\u043d'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u068f\u06a9\u06bb \u0633\u0648\u068a\u0627\u0646'),'se':u('M\u00e1ttasudan'),'sg':'*aa','si':u('\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0dc3\u0dd4\u0da9\u0dcf\u0db1\u0dba'),'sk':u('Ju\u017en\u00fd Sud\u00e1n'),'sl':'*bs','sm':'*aa','sn':'*aa','so':'*aa','sq':'Sudani i Jugut','sr':u('\u0408\u0443\u0436\u043d\u0438 \u0421\u0443\u0434\u0430\u043d'),'ss':'*aa','st':'*aa','su':'*aa','sv':'*da','sw':'Sudan Kusini','ta':u('\u0ba4\u0bc6\u0bb1\u0bcd\u0b95\u0bc1 \u0b9a\u0bc2\u0b9f\u0bbe\u0ba9\u0bcd'),'te':u('\u0c26\u0c15\u0c4d\u0c37\u0c3f\u0c23 \u0c38\u0c42\u0c21\u0c3e\u0c28\u0c4d'),'tg':u('\u0421\u0443\u0434\u043e\u043d\u0438 \u04b6\u0430\u043d\u0443\u0431\u04e3'),'th':u('\u0e0b\u0e39\u0e14\u0e32\u0e19\u0e43\u0e15\u0e49'),'ti':'*am','tk':u('G\u00fcnorta Sudan'),'tl':'Timog Sudan','tn':'*aa','to':u('S\u016btani fakatonga'),'tr':u('G\u00fcney Sudan'),'ts':'*aa','tt':u('\u041a\u04e9\u043d\u044c\u044f\u043a \u0421\u0443\u0434\u0430\u043d'),'tw':'*aa','ty':'*aa','ug':u('\u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u0633\u06c7\u062f\u0627\u0646'),'uk':u('\u041f\u0456\u0432\u0434\u0435\u043d\u043d\u0438\u0439 \u0421\u0443\u0434\u0430\u043d'),'ur':u('\u062c\u0646\u0648\u0628\u06cc \u0633\u0648\u0688\u0627\u0646'),'uz':'Janubiy Sudan','ve':'*aa','vi':'Nam Sudan','vo':'*aa','wa':'*aa','wo':u('Suda\u014b di Sid'),'xh':'*aa','yi':'*ji','yo':'*aa','za':'*aa','zh':u('\u5357\u82cf\u4e39'),'zu':'i-South Sudan',},
  'ST': {'aa':'Sao Tome And Principe','ab':'*aa','ae':'*aa','af':u('S\u00e3o Tom\u00e9 en Pr\u00edncipe'),'ak':u('S\u00e3o Tom\u00e9 and Pr\u00edncipe'),'am':u('\u1233\u12a6 \u1276\u121c \u12a5\u1293 \u1355\u122a\u1295\u1232\u1354'),'an':'*aa','ar':u('\u0633\u0627\u0648 \u062a\u0648\u0645\u064a \u0648\u0628\u0631\u064a\u0646\u0633\u064a\u0628\u064a'),'as':u('\u099a\u09be\u0993 \u099f\u09cb\u09ae\u09c7 \u0986\u09f0\u09c1 \u09aa\u09cd\u09f0\u09bf\u09a8\u099a\u09bf\u09aa\u09c7'),'av':'*aa','ay':'*aa','az':u('San-Tome v\u0259 Prinsipi'),'ba':'*aa','be':u('\u0421\u0430\u043d-\u0422\u0430\u043c\u044d \u0456 \u041f\u0440\u044b\u043d\u0441\u0456\u043f\u0456'),'bg':u('\u0421\u0430\u043e \u0422\u043e\u043c\u0435 \u0438 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438'),'bh':'*aa','bi':'*aa','bm':'Sawo Tome-ni-Prinicipe','bn':u('\u09b8\u09be\u0993\u099f\u09cb\u09ae\u09be \u0993 \u09aa\u09cd\u09b0\u09bf\u09a8\u09cd\u09b8\u09bf\u09aa\u09bf'),'bo':'*aa','br':u('S\u00e3o Tom\u00e9 ha Pr\u00edncipe'),'bs':'Sao Tome i Principe','ca':u('S\u00e3o Tom\u00e9 i Pr\u00edncipe'),'ce':u('\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0430, \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438 \u0430'),'ch':'*aa','co':'*aa','cr':'*aa','cs':u('Svat\u00fd Tom\u00e1\u0161 a Princ\u016fv ostrov'),'cu':'*aa','cv':'*aa','cy':u('S\u00e3o Tom\u00e9 a Pr\u00edncipe'),'da':u('S\u00e3o Tom\u00e9 og Pr\u00edncipe'),'de':u('S\u00e3o Tom\u00e9 und Pr\u00edncipe'),'dv':'*aa','dz':u('\u0f66\u0f5d\u0f0b \u0f4a\u0f7c\u0f0b\u0f58\u0f7a\u0f0b \u0f68\u0f7a\u0f53\u0f4c\u0f0b \u0f54\u0fb2\u0f80\u0f53\u0f0b\u0f66\u0f72\u0f0b\u0f54\u0f7a'),'ee':u('S\u00e3o Tom\u00e9 kple Pr\u00edncipe nutome'),'el':u('\u03a3\u03ac\u03bf \u03a4\u03bf\u03bc\u03ad \u03ba\u03b1\u03b9 \u03a0\u03c1\u03af\u03bd\u03c3\u03b9\u03c0\u03b5'),'en':u('S\u00e3o Tom\u00e9 & Pr\u00edncipe'),'eo':'Sao-Tomeo kaj Principeo','es':u('Santo Tom\u00e9 y Pr\u00edncipe'),'et':u('S\u00e3o Tom\u00e9 ja Pr\u00edncipe'),'eu':'Sao Tome eta Principe','fa':u('\u0633\u0627\u0626\u0648\u062a\u0648\u0645\u0647 \u0648 \u067e\u0631\u06cc\u0646\u0633\u06cc\u067e'),'ff':'Sawo Tome e Perensipe','fi':'*et','fj':'*aa','fo':'Sao Tome & Prinsipi','fr':u('Sao Tom\u00e9-et-Principe'),'fy':u('Sao Tom\u00e9 en Principe'),'ga':u('S\u00e3o Tom\u00e9 agus Pr\u00edncipe'),'gd':'*ga','gl':u('San Tom\u00e9 e Pr\u00edncipe'),'gn':'*aa','gu':u('\u0ab8\u0abe\u0a93 \u0a9f\u0ac9\u0aae \u0a85\u0aa8\u0ac7 \u0aaa\u0acd\u0ab0\u0abf\u0a82\u0ab8\u0abf\u0aaa\u0ac7'),'gv':'*aa','ha':'Sawo Tome Da Paransip','he':u('\u05e1\u05d0\u05d5 \u05d8\u05d5\u05de\u05d4 \u05d5\u05e4\u05e8\u05d9\u05e0\u05e1\u05d9\u05e4\u05d4'),'hi':u('\u0938\u093e\u0913 \u091f\u094b\u092e \u0914\u0930 \u092a\u094d\u0930\u093f\u0902\u0938\u093f\u092a\u0947'),'ho':'*aa','hr':'Sveti Toma i Princip','ht':'*aa','hu':u('S\u00e3o Tom\u00e9 \u00e9s Pr\u00edncipe'),'hy':u('\u054d\u0561\u0576 \u054f\u0578\u0574\u0565 \u0587 \u0553\u0580\u056b\u0576\u057d\u056b\u057a\u056b'),'hz':'*aa','ia':'*aa','id':'Sao Tome dan Principe','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*id','io':'*aa','is':u('Sa\u00f3 T\u00f3me og Prins\u00edpe'),'it':u('S\u00e3o Tom\u00e9 e Pr\u00edncipe'),'iu':'*aa','iw':'*he','ja':u('\u30b5\u30f3\u30c8\u30e1\u30fb\u30d7\u30ea\u30f3\u30b7\u30da'),'ji':u('\u05e1\u05d0\u05b7\u05d0 \u05d8\u05d0\u05de\u05e2 \u05d0\u05d5\u05df \u05e4\u05bc\u05e8\u05d9\u05e0\u05e1\u05d9\u05e4\u05bc\u05e2'),'jv':'*aa','ka':u('\u10e1\u10d0\u10dc-\u10e2\u10dd\u10db\u10d4 \u10d3\u10d0 \u10de\u10e0\u10d8\u10dc\u10e1\u10d8\u10de\u10d8'),'kg':'*aa','ki':'Sao Tome na Principe','kj':'*aa','kk':u('\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0436\u04d9\u043d\u0435 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438'),'kl':'*aa','km':u('\u179f\u17c5\u178f\u17bc\u1798\u17c9\u17c1 \u1793\u17b7\u1784 \u1794\u17d2\u179a\u17b6\u17c6\u1784\u179f\u17ca\u17b8\u1794'),'kn':u('\u0cb8\u0cbe\u0cb5\u0ccb \u0c9f\u0ccb\u0cae\u0ccd \u0cae\u0ca4\u0ccd\u0ca4\u0cc1 \u0caa\u0ccd\u0cb0\u0cbf\u0ca8\u0ccd\u0cb8\u0cbf\u0caa\u0cbf'),'ko':u('\uc0c1\ud22c\uba54 \ud504\ub9b0\uc2dc\ud398'),'kr':'*aa','ks':u('\u0633\u0627\u0648 \u062a\u0648\u0645 \u062a\u06c1\u0655 \u067e\u0631\u065b\u0646\u0633\u0650\u067e\u06cc'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0436\u0430\u043d\u0430 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438'),'la':'*aa','lb':'*cy','lg':'Sanitome ne Purincipe','li':'*aa','ln':u('Sao Tom\u00e9 mp\u00e9 Presip\u025b'),'lo':u('\u0ec0\u0e8a\u0ebb\u0eb2\u0e97\u0eb9\u0ec0\u0ea1 \u0ec1\u0ea5\u0eb0 \u0e9e\u0ea3\u0eb4\u0e99\u0e8a\u0eb4\u0e9a'),'lt':u('San Tom\u0117 ir Prinsip\u0117'),'lu':u('Sao Tome ne Presip\u025b'),'lv':'Santome un Prinsipi','mg':u('S\u00e3o Tom\u00e9-et-Pr\u00edncipe'),'mh':'*aa','mi':'*aa','mk':u('\u0421\u0430\u043e \u0422\u043e\u043c\u0435 \u0438 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0435'),'ml':u('\u0d38\u0d3e\u0d35\u0d4b \u0d1f\u0d4b\u0d2e\u0d41\u0d02 \u0d2a\u0d4d\u0d30\u0d3f\u0d7b\u0d38\u0d3f\u0d2a\u0d46\u0d2f\u0d41\u0d02'),'mn':u('\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438'),'mo':u('Sao Tome \u0219i Principe'),'mr':u('\u0938\u093e\u0913 \u091f\u094b\u092e \u0906\u0923\u093f \u092a\u094d\u0930\u093f\u0902\u0938\u093f\u092a\u0947'),'ms':'*id','mt':u('S\u00e3o Tom\u00e9 u Pr\u00edncipe'),'my':u('\u1006\u1031\u102c\u1004\u103a\u1010\u1030\u1019\u1031\u1038\u1014\u103e\u1004\u1037\u103a \u1015\u101b\u1004\u103a\u1005\u102e\u1015\u102e'),'na':'*aa','nb':'*da','nd':'*ak','ne':u('\u0938\u093e\u0913 \u091f\u094b\u092e\u0947 \u0930 \u092a\u094d\u0930\u093f\u0928\u094d\u0938\u093f\u092a'),'ng':'*aa','nl':'*fy','nn':'*da','no':'*da','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b38\u0b3e\u0b13 \u0b1f\u0b4b\u0b2e\u0b47 \u0b0f\u0b2c\u0b02 \u0b2a\u0b4d\u0b30\u0b3f\u0b28\u0b38\u0b3f\u0b2a\u0b3f'),'os':'*aa','pa':u('\u0a38\u0a3e\u0a13 \u0a1f\u0a4b\u0a2e \u0a05\u0a24\u0a47 \u0a2a\u0a4d\u0a30\u0a3f\u0a70\u0a38\u0a40\u0a2a\u0a47'),'pi':'*aa','pl':u('Wyspy \u015awi\u0119tego Tomasza i Ksi\u0105\u017c\u0119ca'),'ps':u('\u0633\u0627\u0648 \u067c\u06cc\u0645 \u0627\u0648 \u067e\u0631\u0646\u0633\u06cc\u067e'),'pt':'*it','qu':'*es','rm':u('S\u00e3o Tom\u00e9 e Principe'),'rn':'Sawotome na Perensipe','ro':'*mo','ru':u('\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0438 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438'),'rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0633\u0627\u0626\u0648 \u067d\u0648\u0645 \u06fd \u067e\u0631\u0646\u0633\u067e\u06cc\u064a'),'se':'*et','sg':u('S\u00e2\u00f4 T\u00f6m\u00ea na Prins\u00eepe'),'si':u('\u0dc3\u0dcf\u0d95 \u0dad\u0ddd\u0db8\u0dca \u0dc3\u0dc4 \u0db4\u0dca\u200d\u0dbb\u0dd2\u0db1\u0dca\u0dc3\u0dd2\u0db4\u0dca'),'sk':u('Sv\u00e4t\u00fd Tom\u00e1\u0161 a Princov ostrov'),'sl':'Sao Tome in Principe','sm':'*aa','sn':'*ak','so':'*ak','sq':'Sao-Tome e Principe','sr':u('\u0421\u0430\u043e \u0422\u043e\u043c\u0435 \u0438 \u041f\u0440\u0438\u043d\u0446\u0438\u043f\u0435'),'ss':'*aa','st':'*aa','su':'*aa','sv':u('S\u00e3o Tom\u00e9 och Pr\u00edncipe'),'sw':u('S\u00e3o Tom\u00e9 na Pr\u00edncipe'),'ta':u('\u0b9a\u0bbe\u0bb5\u0bcd \u0ba4\u0bcb\u0bae\u0bcd & \u0baa\u0bcd\u0bb0\u0bbf\u0ba9\u0bcd\u0b9a\u0bbf\u0baa\u0bbf'),'te':u('\u0c38\u0c3e\u0c35\u0c4b\u0c1f\u0c4b\u0c2e\u0c4d & \u0c2a\u0c4d\u0c30\u0c3f\u0c28\u0c4d\u0c38\u0c3f\u0c2a\u0c47'),'tg':u('\u0421\u0430\u043d \u0422\u043e\u043c\u0435 \u0432\u0430 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438'),'th':u('\u0e40\u0e0b\u0e32\u0e15\u0e39\u0e40\u0e21\u0e41\u0e25\u0e30\u0e1b\u0e23\u0e34\u0e19\u0e0b\u0e34\u0e1b\u0e35'),'ti':u('\u1233\u12a6 \u1276\u121c\u1295 \u1355\u122a\u1295\u1232\u1354\u1295'),'tk':'San-Tome we Prinsipi','tl':'*en','tn':'*aa','to':u('Sao Tom\u0113 mo Pilinisipe'),'tr':u('S\u00e3o Tom\u00e9 ve Pr\u00edncipe'),'ts':'*aa','tt':u('\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u04bb\u04d9\u043c \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438'),'tw':'*aa','ty':'*aa','ug':u('\u0633\u0627\u0646 \u062a\u0648\u0645\u06d0 \u06cb\u06d5 \u067e\u0631\u0649\u0646\u0633\u0649\u067e\u06d0'),'uk':u('\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0456 \u041f\u0440\u0456\u043d\u0441\u0456\u043f\u0456'),'ur':u('\u0633\u0627\u0624 \u0679\u0648\u0645 \u0627\u0648\u0631 \u067e\u0631\u0646\u0633\u067e\u06d2'),'uz':'San-Tome va Prinsipi','ve':'*aa','vi':u('S\u00e3o Tom\u00e9 v\u00e0 Pr\u00edncipe'),'vo':'*aa','wa':'*aa','wo':'Sawo Tome ak Pirinsipe','xh':'*aa','yi':'*ji','yo':u('Or\u00edl\u1eb9\u0301\u00e8de Sao tomi ati pirii\u1e63ipi'),'za':'*aa','zh':u('\u5723\u591a\u7f8e\u548c\u666e\u6797\u897f\u6bd4'),'zu':u('i-S\u00e3o Tom\u00e9 kanye ne-Pr\u00edncipe'),},
  'SV': {'aa':'El Salvador','ab':'*aa','ae':'*aa','af':'*aa','ak':u('\u0190l Salvad\u0254'),'am':u('\u12a4\u120d \u1233\u120d\u126b\u12f6\u122d'),'an':'*aa','ar':u('\u0627\u0644\u0633\u0644\u0641\u0627\u062f\u0648\u0631'),'as':u('\u098f\u09b2 \u099b\u09c7\u09b2\u09ad\u09c7\u09a1\u2019\u09f0'),'av':'*aa','ay':'*aa','az':'Salvador','ba':'*aa','be':u('\u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440'),'bg':u('\u0421\u0430\u043b\u0432\u0430\u0434\u043e\u0440'),'bh':'*aa','bi':'*aa','bm':u('Salivad\u0254r'),'bn':u('\u098f\u09b2 \u09b8\u09be\u09b2\u09ad\u09c7\u09a6\u09b0'),'bo':'*aa','br':'*az','bs':'*az','ca':'*aa','ce':'*be','ch':'*aa','co':'*aa','cr':'*aa','cs':'*az','cu':'*aa','cv':'*aa','cy':'*aa','da':'*aa','de':'*aa','dv':'*aa','dz':u('\u0f68\u0f7a\u0f63\u0f0b\u0f66\u0f63\u0f0b\u0f56\u0f0b\u0f4c\u0f7c\u0f62'),'ee':u('El Salvad\u0254 nutome'),'el':u('\u0395\u03bb \u03a3\u03b1\u03bb\u03b2\u03b1\u03b4\u03cc\u03c1'),'en':'*aa','eo':'Salvadoro','es':'*aa','et':'*aa','eu':'*aa','fa':u('\u0627\u0644\u0633\u0627\u0644\u0648\u0627\u062f\u0648\u0631'),'ff':'El Salwador','fi':'*aa','fj':'*aa','fo':'*aa','fr':'*az','fy':'*aa','ga':u('an tSalvad\u00f3ir'),'gd':'An Salbhador','gl':'O Salvador','gn':'*aa','gu':u('\u0a8f\u0ab2 \u0ab8\u0ac7\u0ab2\u0acd\u0ab5\u0abe\u0aa1\u0acb\u0ab0'),'gv':'*aa','ha':'El Salbador','he':u('\u05d0\u05dc \u05e1\u05dc\u05d1\u05d3\u05d5\u05e8'),'hi':u('\u0905\u0932 \u0938\u0932\u094d\u0935\u093e\u0921\u094b\u0930'),'ho':'*aa','hr':'*az','ht':'*aa','hu':'*az','hy':u('\u054d\u0561\u056c\u057e\u0561\u0564\u0578\u0580'),'hz':'*aa','ia':'*aa','id':'*aa','ie':'*aa','ig':'*aa','ii':'*aa','ik':'*aa','in':'*aa','io':'*aa','is':'*aa','it':'*aa','iu':'*aa','iw':'*he','ja':u('\u30a8\u30eb\u30b5\u30eb\u30d0\u30c9\u30eb'),'ji':u('\u05e2\u05dc \u05e1\u05d0\u05b7\u05dc\u05d5\u05d5\u05d0\u05b7\u05d3\u05d0\u05e8'),'jv':'*aa','ka':u('\u10e1\u10d0\u10da\u10d5\u10d0\u10d3\u10dd\u10e0\u10d8'),'kg':'*aa','ki':'Elsavado','kj':'*aa','kk':'*be','kl':'*aa','km':u('\u17a2\u17c2\u179b\u179f\u17b6\u179b\u17cb\u179c\u17c9\u17b6\u178c\u17d0\u179a'),'kn':u('\u0c8e\u0cb2\u0ccd \u0cb8\u0cbe\u0cb2\u0ccd\u0cb5\u0cc7\u0ca1\u0cbe\u0cb0\u0ccd'),'ko':u('\uc5d8\uc0b4\ubc14\ub3c4\ub974'),'kr':'*aa','ks':u('\u0627\u066e\u06ea\u0644 \u0633\u064e\u0644\u0648\u0627\u0691\u0648\u0631'),'ku':'*aa','kv':'*aa','kw':'*aa','ky':u('\u042d\u043b\u044c-\u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440'),'la':'*aa','lb':'*aa','lg':'El salivado','li':'*aa','ln':u('Savad\u0254r\u025b'),'lo':u('\u0ec0\u0ead\u0ea7 \u0e8a\u0ecd\u0ea7\u0eb2\u0e94\u0ecd'),'lt':'Salvadoras','lu':'Savadore','lv':'Salvadora','mg':'*aa','mh':'*aa','mi':'*aa','mk':u('\u0415\u043b \u0421\u0430\u043b\u0432\u0430\u0434\u043e\u0440'),'ml':u('\u0d0e\u0d7d \u0d38\u0d3e\u0d7d\u0d35\u0d26\u0d4b\u0d7c'),'mn':u('\u042d\u043b\u044c \u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440'),'mo':'*aa','mr':u('\u0905\u0932 \u0938\u093e\u0932\u094d\u0935\u093e\u0921\u094b\u0930'),'ms':'*aa','mt':'*aa','my':u('\u1021\u101a\u103a\u101c\u103a\u1006\u102c\u1017\u1031\u1038\u1012\u102d\u102f\u1038'),'na':'*aa','nb':'*aa','nd':'*aa','ne':u('\u090f\u0932\u094d \u0938\u093e\u0932\u094d\u092d\u093e\u0921\u094b\u0930'),'ng':'*aa','nl':'*aa','nn':'*aa','no':'*aa','nr':'*aa','nv':'*aa','ny':'*aa','oc':'*aa','oj':'*aa','om':'*aa','or':u('\u0b0f\u0b32\u0b4d \u0b38\u0b3e\u0b32\u0b2d\u0b3e\u0b21\u0b4b\u0b30\u0b4d'),'os':'*aa','pa':u('\u0a05\u0a32 \u0a38\u0a32\u0a35\u0a3e\u0a21\u0a4b\u0a30'),'pi':'*aa','pl':'Salwador','ps':u('\u0633\u0627\u0644\u0648\u06d0\u0689\u0648\u0631'),'pt':'*aa','qu':'*aa','rm':'*aa','rn':'Eli Saluvatori','ro':'*aa','ru':'*be','rw':'*aa','sa':'*aa','sc':'*aa','sd':u('\u0627\u0644 \u0633\u0644\u0648\u0627\u068a\u0648\u0631'),'se':'*aa','sg':u('Salvad\u00f6ro'),'si':u('\u0d91\u0dbd\u0dca \u0dc3\u0dd0\u0dbd\u0dca\u0dc0\u0daf\u0ddd\u0dbb\u0dba'),'sk':u('Salv\u00e1dor'),'sl':'*az','sm':'*aa','sn':'*aa','so':'*aa','sq':'*az','sr':'*bg','ss':'*aa','st':'*aa','su':'*aa','sv':'*aa','sw':'*aa','ta':u('\u0b8e\u0bb2\u0bcd \u0b9a\u0bbe\u0bb2\u0bcd\u0bb5\u0b9f\u0bbe\u0bb0\u0bcd'),'te':u('\u0c0e\u0c32\u0c4d \u0c38\u0c3e\u0c32\u0c4d\u0c35\u0c21\u0c4b\u0c30\u0c4d'),'tg':u('\u042d\u043b-\u0421\u0430\u043b\u0432\u0430\u0434\u043e\u0440'),'th':u('\u0e40\u0e2d\u0e25\u0e0b\u0e31\u0e25\u0e27\u0e32\u0e14\u0e2d\u0e23\u0e4c'),'ti':'*am','tk':'*pl','tl':'*aa','tn':'*aa','to':u('\u02bbEle Salavatoa'),'tr':'*aa',