/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.SBlock;
import org.elasticsearch.painless.node.SSubEachArray;
import org.elasticsearch.painless.node.SSubEachIterable;

public class SEach
extends AStatement {
    private final String type;
    private final String name;
    private AExpression expression;
    private final SBlock block;
    private AStatement sub = null;

    public SEach(Location location, String type, String name, AExpression expression, SBlock block) {
        super(location);
        this.type = Objects.requireNonNull(type);
        this.name = Objects.requireNonNull(name);
        this.expression = Objects.requireNonNull(expression);
        this.block = block;
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        this.expression.storeSettings(settings);
        if (this.block != null) {
            this.block.storeSettings(settings);
        }
    }

    @Override
    void extractVariables(Set<String> variables) {
        variables.add(this.name);
        this.expression.extractVariables(variables);
        if (this.block != null) {
            this.block.extractVariables(variables);
        }
    }

    @Override
    void analyze(Locals locals) {
        this.expression.analyze(locals);
        this.expression.expected = this.expression.actual;
        this.expression = this.expression.cast(locals);
        Class<?> clazz = locals.getPainlessLookup().canonicalTypeNameToType(this.type);
        if (clazz == null) {
            throw this.createError(new IllegalArgumentException("Not a type [" + this.type + "]."));
        }
        locals = Locals.newLocalScope(locals);
        Locals.Variable variable = locals.addVariable(this.location, clazz, this.name, true);
        if (this.expression.actual.isArray()) {
            this.sub = new SSubEachArray(this.location, variable, this.expression, this.block);
        } else if (this.expression.actual == def.class || Iterable.class.isAssignableFrom(this.expression.actual)) {
            this.sub = new SSubEachIterable(this.location, variable, this.expression, this.block);
        } else {
            throw this.createError(new IllegalArgumentException("Illegal for each type [" + PainlessLookupUtility.typeToCanonicalTypeName(this.expression.actual) + "]."));
        }
        this.sub.analyze(locals);
        if (this.block == null) {
            throw this.createError(new IllegalArgumentException("Extraneous for each loop."));
        }
        this.block.beginLoop = true;
        this.block.inLoop = true;
        this.block.analyze(locals);
        this.block.statementCount = Math.max(1, this.block.statementCount);
        if (this.block.loopEscape && !this.block.anyContinue) {
            throw this.createError(new IllegalArgumentException("Extraneous for loop."));
        }
        this.statementCount = 1;
        if (locals.hasVariable("#loop")) {
            this.sub.loopCounter = locals.getVariable(this.location, "#loop");
        }
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        this.sub.write(writer, globals);
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.type, this.name, this.expression, this.block);
    }
}

