/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.ServerLoadMonitor;
import org.directwebremoting.extend.UninitializingBean;
import org.directwebremoting.extend.WaitController;

public abstract class AbstractServerLoadMonitor
implements ServerLoadMonitor,
UninitializingBean {
    private boolean shutdownCalled = false;
    protected final List<WaitController> waitControllers = new ArrayList<WaitController>();
    private static final Log log = LogFactory.getLog(AbstractServerLoadMonitor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (this.shutdownCalled) {
            return;
        }
        List<WaitController> list = this.waitControllers;
        synchronized (list) {
            ArrayList<WaitController> copy = new ArrayList<WaitController>();
            copy.addAll(this.waitControllers);
            for (WaitController controller : copy) {
                controller.shutdown();
            }
            log.debug((Object)(" - shutdown on: " + this));
            this.shutdownCalled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadWaitStarting(WaitController controller) {
        List<WaitController> list = this.waitControllers;
        synchronized (list) {
            this.waitControllers.add(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadWaitEnding(WaitController controller) {
        List<WaitController> list = this.waitControllers;
        synchronized (list) {
            this.waitControllers.remove(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownRandomWaitControllers(int count) {
        List<WaitController> list = this.waitControllers;
        synchronized (list) {
            for (int i = 0; i < count && !this.waitControllers.isEmpty(); ++i) {
                this.waitControllers.get(0).shutdown();
            }
        }
    }
}

