/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.support.ArrayValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;

public abstract class ArrayValuesSourceAggregationBuilder<VS extends ValuesSource, AB extends ArrayValuesSourceAggregationBuilder<VS, AB>>
extends AbstractAggregationBuilder<AB> {
    public static final ParseField MULTIVALUE_MODE_FIELD = new ParseField("mode", new String[0]);
    private final ValuesSourceType valuesSourceType;
    private final ValueType targetValueType;
    private List<String> fields = Collections.emptyList();
    private ValueType valueType = null;
    private String format = null;
    private Object missing = null;
    private Map<String, Object> missingMap = Collections.emptyMap();

    protected ArrayValuesSourceAggregationBuilder(String name, ValuesSourceType valuesSourceType, ValueType targetValueType) {
        super(name);
        if (valuesSourceType == null) {
            throw new IllegalArgumentException("[valuesSourceType] must not be null: [" + name + "]");
        }
        this.valuesSourceType = valuesSourceType;
        this.targetValueType = targetValueType;
    }

    protected ArrayValuesSourceAggregationBuilder(ArrayValuesSourceAggregationBuilder<VS, AB> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.valuesSourceType = clone.valuesSourceType;
        this.targetValueType = clone.targetValueType;
        this.fields = new ArrayList<String>(clone.fields);
        this.valueType = clone.valueType;
        this.format = clone.format;
        this.missingMap = new HashMap<String, Object>(clone.missingMap);
        this.missing = clone.missing;
    }

    protected ArrayValuesSourceAggregationBuilder(StreamInput in, ValuesSourceType valuesSourceType, ValueType targetValueType) throws IOException {
        super(in);
        assert (!this.serializeTargetValueType()) : "Wrong read constructor called for subclass that provides its targetValueType";
        this.valuesSourceType = valuesSourceType;
        this.targetValueType = targetValueType;
        this.read(in);
    }

    protected ArrayValuesSourceAggregationBuilder(StreamInput in, ValuesSourceType valuesSourceType) throws IOException {
        super(in);
        assert (this.serializeTargetValueType()) : "Wrong read constructor called for subclass that serializes its targetValueType";
        this.valuesSourceType = valuesSourceType;
        this.targetValueType = (ValueType)in.readOptionalWriteable(ValueType::readFromStream);
        this.read(in);
    }

    private void read(StreamInput in) throws IOException {
        this.fields = (ArrayList)in.readGenericValue();
        this.valueType = (ValueType)in.readOptionalWriteable(ValueType::readFromStream);
        this.format = in.readOptionalString();
        this.missingMap = in.readMap();
    }

    protected final void doWriteTo(StreamOutput out) throws IOException {
        if (this.serializeTargetValueType()) {
            out.writeOptionalWriteable((Writeable)this.targetValueType);
        }
        out.writeGenericValue(this.fields);
        out.writeOptionalWriteable((Writeable)this.valueType);
        out.writeOptionalString(this.format);
        out.writeMap(this.missingMap);
        this.innerWriteTo(out);
    }

    protected abstract void innerWriteTo(StreamOutput var1) throws IOException;

    public AB fields(List<String> fields) {
        if (fields == null) {
            throw new IllegalArgumentException("[field] must not be null: [" + this.name + "]");
        }
        this.fields = fields;
        return (AB)((Object)this);
    }

    public List<String> fields() {
        return this.fields;
    }

    public AB valueType(ValueType valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("[valueType] must not be null: [" + this.name + "]");
        }
        this.valueType = valueType;
        return (AB)((Object)this);
    }

    public ValueType valueType() {
        return this.valueType;
    }

    public AB format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return (AB)((Object)this);
    }

    public String format() {
        return this.format;
    }

    public AB missingMap(Map<String, Object> missingMap) {
        if (missingMap == null) {
            throw new IllegalArgumentException("[missing] must not be null: [" + this.name + "]");
        }
        this.missingMap = missingMap;
        return (AB)((Object)this);
    }

    public Map<String, Object> missingMap() {
        return this.missingMap;
    }

    protected final ArrayValuesSourceAggregatorFactory<VS> doBuild(SearchContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        Map<String, ValuesSourceConfig<VS>> configs = this.resolveConfig(context);
        ArrayValuesSourceAggregatorFactory<VS> factory = this.innerBuild(context, configs, parent, subFactoriesBuilder);
        return factory;
    }

    protected Map<String, ValuesSourceConfig<VS>> resolveConfig(SearchContext context) {
        HashMap<String, ValuesSourceConfig<VS>> configs = new HashMap<String, ValuesSourceConfig<VS>>();
        for (String field : this.fields) {
            ValuesSourceConfig<VS> config = this.config(context, field, null);
            configs.put(field, config);
        }
        return configs;
    }

    protected abstract ArrayValuesSourceAggregatorFactory<VS> innerBuild(SearchContext var1, Map<String, ValuesSourceConfig<VS>> var2, AggregatorFactory var3, AggregatorFactories.Builder var4) throws IOException;

    public ValuesSourceConfig<VS> config(SearchContext context, String field, Script script) {
        ValueType valueType;
        ValueType valueType2 = valueType = this.valueType != null ? this.valueType : this.targetValueType;
        if (field == null) {
            ValuesSourceType valuesSourceType;
            if (script == null) {
                ValuesSourceConfig config = new ValuesSourceConfig(ValuesSourceType.ANY);
                return config.format(ArrayValuesSourceAggregationBuilder.resolveFormat(null, valueType));
            }
            ValuesSourceType valuesSourceType2 = valuesSourceType = valueType != null ? valueType.getValuesSourceType() : this.valuesSourceType;
            if (valuesSourceType == null || valuesSourceType == ValuesSourceType.ANY) {
                valuesSourceType = ValuesSourceType.BYTES;
            }
            ValuesSourceConfig config = new ValuesSourceConfig(valuesSourceType);
            config.missing(this.missingMap.get(field));
            return config.format(ArrayValuesSourceAggregationBuilder.resolveFormat(this.format, valueType));
        }
        MappedFieldType fieldType = context.smartNameFieldType(field);
        if (fieldType == null) {
            ValuesSourceType valuesSourceType = valueType != null ? valueType.getValuesSourceType() : this.valuesSourceType;
            ValuesSourceConfig config = new ValuesSourceConfig(valuesSourceType);
            config.missing(this.missingMap.get(field));
            config.format(ArrayValuesSourceAggregationBuilder.resolveFormat(this.format, valueType));
            return config.unmapped(true);
        }
        IndexFieldData indexFieldData = context.getForField(fieldType);
        ValuesSourceConfig config = this.valuesSourceType == ValuesSourceType.ANY ? (indexFieldData instanceof IndexNumericFieldData ? new ValuesSourceConfig(ValuesSourceType.NUMERIC) : (indexFieldData instanceof IndexGeoPointFieldData ? new ValuesSourceConfig(ValuesSourceType.GEOPOINT) : new ValuesSourceConfig(ValuesSourceType.BYTES))) : new ValuesSourceConfig(this.valuesSourceType);
        config.fieldContext(new FieldContext(field, indexFieldData, fieldType));
        config.missing(this.missingMap.get(field));
        return config.format(fieldType.docValueFormat(this.format, null));
    }

    private static DocValueFormat resolveFormat(@Nullable String format, @Nullable ValueType valueType) {
        if (valueType == null) {
            return DocValueFormat.RAW;
        }
        DocValueFormat valueFormat = valueType.defaultFormat();
        if (valueFormat instanceof DocValueFormat.Decimal && format != null) {
            valueFormat = new DocValueFormat.Decimal(format);
        }
        return valueFormat;
    }

    protected boolean serializeTargetValueType() {
        return false;
    }

    public final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.fields != null) {
            builder.field(AggregationBuilder.CommonFields.FIELDS.getPreferredName(), this.fields);
        }
        if (this.missing != null) {
            builder.field(AggregationBuilder.CommonFields.MISSING.getPreferredName(), this.missing);
        }
        if (this.format != null) {
            builder.field(AggregationBuilder.CommonFields.FORMAT.getPreferredName(), this.format);
        }
        if (this.valueType != null) {
            builder.field(AggregationBuilder.CommonFields.VALUE_TYPE.getPreferredName(), this.valueType.getPreferredName());
        }
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fields, this.format, this.missing, this.targetValueType, this.valueType, this.valuesSourceType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ArrayValuesSourceAggregationBuilder other = (ArrayValuesSourceAggregationBuilder)((Object)obj);
        return Objects.equals(this.fields, other.fields) && Objects.equals(this.format, other.format) && Objects.equals(this.missing, other.missing) && Objects.equals(this.targetValueType, other.targetValueType) && Objects.equals(this.valueType, other.valueType) && Objects.equals(this.valuesSourceType, other.valuesSourceType);
    }

    public static abstract class LeafOnly<VS extends ValuesSource, AB extends ArrayValuesSourceAggregationBuilder<VS, AB>>
    extends ArrayValuesSourceAggregationBuilder<VS, AB> {
        protected LeafOnly(String name, ValuesSourceType valuesSourceType, ValueType targetValueType) {
            super(name, valuesSourceType, targetValueType);
        }

        protected LeafOnly(LeafOnly<VS, AB> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
            super(clone, factoriesBuilder, metaData);
            if (factoriesBuilder.count() > 0) {
                throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
            }
        }

        protected LeafOnly(StreamInput in, ValuesSourceType valuesSourceType, ValueType targetValueType) throws IOException {
            super(in, valuesSourceType, targetValueType);
        }

        protected LeafOnly(StreamInput in, ValuesSourceType valuesSourceType) throws IOException {
            super(in, valuesSourceType);
        }

        public AB subAggregations(AggregatorFactories.Builder subFactories) {
            throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
        }
    }
}

