/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.node.AExpression;
import org.objectweb.asm.Type;

public final class EInstanceof
extends AExpression {
    private AExpression expression;
    private final String type;
    private Class<?> resolvedType;
    private Class<?> expressionType;
    private boolean primitiveExpression;

    public EInstanceof(Location location, AExpression expression, String type) {
        super(location);
        this.expression = Objects.requireNonNull(expression);
        this.type = Objects.requireNonNull(type);
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        this.expression.storeSettings(settings);
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.expression.extractVariables(variables);
    }

    @Override
    void analyze(Locals locals) {
        Class<?> clazz = locals.getPainlessLookup().canonicalTypeNameToType(this.type);
        if (clazz == null) {
            throw this.createError(new IllegalArgumentException("Not a type [" + this.type + "]."));
        }
        this.resolvedType = clazz.isPrimitive() ? PainlessLookupUtility.typeToBoxedType(clazz) : PainlessLookupUtility.typeToJavaType(clazz);
        this.expression.analyze(locals);
        this.expression.expected = this.expression.actual;
        this.expression = this.expression.cast(locals);
        this.primitiveExpression = this.expression.actual.isPrimitive();
        this.expressionType = this.expression.actual.isPrimitive() ? PainlessLookupUtility.typeToBoxedType(this.expression.actual) : PainlessLookupUtility.typeToJavaType(clazz);
        this.actual = Boolean.TYPE;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        if (this.primitiveExpression) {
            this.expression.write(writer, globals);
            writer.writePop(MethodWriter.getType(this.expression.actual).getSize());
            writer.push(this.resolvedType.isAssignableFrom(this.expressionType));
        } else {
            this.expression.write(writer, globals);
            writer.instanceOf(Type.getType(this.resolvedType));
        }
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.expression, this.type);
    }
}

