/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.display;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.display.LafPreference;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;

public class LanguagePreference
implements SubPreferenceSetting {
    private static final String LANGUAGE = "language";
    private JosmComboBox<Locale> langCombo;

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        LanguageComboBoxModel model = new LanguageComboBoxModel();
        model.selectLanguage(Config.getPref().get(LANGUAGE));
        this.langCombo = new JosmComboBox<Locale>(model);
        this.langCombo.setRenderer(new LanguageCellRenderer());
        LafPreference lafPreference = gui.getSetting(LafPreference.class);
        VerticallyScrollablePanel panel = lafPreference.panel;
        panel.add((Component)new JLabel(I18n.tr("Language", new Object[0])), GBC.std().insets(20, 0, 0, 0));
        panel.add(GBC.glue(5, 0), GBC.std().fill(2));
        panel.add(this.langCombo, GBC.eol().fill(2));
        panel.add(Box.createVerticalGlue(), GBC.eol().fill(1));
        TabPreferenceSetting tabPref = lafPreference.getTabPreferenceSetting(gui);
        tabPref.registerSubTab(this, tabPref.getSubTab(lafPreference));
    }

    @Override
    public boolean ok() {
        if (this.langCombo.getSelectedItem() == null) {
            return Config.getPref().put(LANGUAGE, null);
        }
        return Config.getPref().put(LANGUAGE, LanguageInfo.getJOSMLocaleCode((Locale)this.langCombo.getSelectedItem()));
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return gui.getSetting(LafPreference.class).getTabPreferenceSetting(gui);
    }

    private static class LanguageCellRenderer
    implements ListCellRenderer<Locale> {
        private final DefaultListCellRenderer dispatch = new DefaultListCellRenderer();

        LanguageCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Locale> list, Locale l, int index, boolean isSelected, boolean cellHasFocus) {
            return this.dispatch.getListCellRendererComponent(list, l == null ? I18n.tr("Default (Auto determined)", new Object[0]) : LanguageInfo.getDisplayName(l), index, isSelected, cellHasFocus);
        }
    }

    private static class LanguageComboBoxModel
    extends DefaultComboBoxModel<Locale> {
        private final List<Locale> data = new ArrayList<Locale>();

        LanguageComboBoxModel() {
            this.data.add(0, null);
            List<Locale> locales = Arrays.asList(I18n.getAvailableTranslations());
            locales.sort(Comparator.comparing(Locale::getDisplayLanguage));
            this.data.addAll(locales);
        }

        private void selectLanguage(String language) {
            this.setSelectedItem(null);
            if (language != null) {
                String lang = LanguageInfo.getJavaLocaleCode(language);
                for (Locale locale : this.data) {
                    if (locale == null || !locale.toString().equals(lang)) continue;
                    this.setSelectedItem(locale);
                    return;
                }
            }
        }

        @Override
        public Locale getElementAt(int index) {
            return this.data.get(index);
        }

        @Override
        public int getSize() {
            return this.data.size();
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new LanguagePreference();
        }
    }
}

