/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.locationtech.spatial4j.exception.InvalidShapeException;

public final class GeoShapeIndexer
implements AbstractGeometryFieldMapper.Indexer<Geometry, Geometry> {
    private static final double DATELINE = 180.0;
    protected static final Comparator<Edge> INTERSECTION_ORDER = Comparator.comparingDouble(o -> o.intersect.getY());
    private final boolean orientation;
    private final String name;

    public GeoShapeIndexer(boolean orientation, String name) {
        this.orientation = orientation;
        this.name = name;
    }

    @Override
    public Geometry prepareForIndexing(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        return (Geometry)geometry.visit((GeometryVisitor)new GeometryVisitor<Geometry, RuntimeException>(){

            public Geometry visit(Circle circle) {
                throw new UnsupportedOperationException("CIRCLE geometry is not supported");
            }

            public Geometry visit(GeometryCollection<?> collection) {
                if (collection.isEmpty()) {
                    return GeometryCollection.EMPTY;
                }
                ArrayList<Geometry> shapes = new ArrayList<Geometry>(collection.size());
                for (Geometry shape : collection) {
                    shapes.add((Geometry)shape.visit((GeometryVisitor)this));
                }
                if (shapes.size() == 1) {
                    return (Geometry)shapes.get(0);
                }
                return new GeometryCollection(shapes);
            }

            public Geometry visit(Line line) {
                List lines = GeoShapeIndexer.this.decomposeGeometry(line, new ArrayList());
                if (lines.size() == 1) {
                    return (Geometry)lines.get(0);
                }
                return new MultiLine(lines);
            }

            public Geometry visit(LinearRing ring) {
                throw new UnsupportedOperationException("cannot index linear ring [" + ring + "] directly");
            }

            public Geometry visit(MultiLine multiLine) {
                ArrayList lines = new ArrayList();
                for (Line line : multiLine) {
                    GeoShapeIndexer.this.decomposeGeometry(line, lines);
                }
                if (lines.isEmpty()) {
                    return GeometryCollection.EMPTY;
                }
                if (lines.size() == 1) {
                    return (Geometry)lines.get(0);
                }
                return new MultiLine(lines);
            }

            public Geometry visit(MultiPoint multiPoint) {
                if (multiPoint.isEmpty()) {
                    return MultiPoint.EMPTY;
                }
                if (multiPoint.size() == 1) {
                    return (Geometry)((Point)multiPoint.get(0)).visit((GeometryVisitor)this);
                }
                ArrayList<Point> points = new ArrayList<Point>();
                for (Point point : multiPoint) {
                    points.add((Point)point.visit((GeometryVisitor)this));
                }
                return new MultiPoint(points);
            }

            public Geometry visit(MultiPolygon multiPolygon) {
                ArrayList polygons = new ArrayList();
                for (org.elasticsearch.geometry.Polygon polygon : multiPolygon) {
                    polygons.addAll(GeoShapeIndexer.this.decompose(polygon, GeoShapeIndexer.this.orientation));
                }
                if (polygons.size() == 1) {
                    return (Geometry)polygons.get(0);
                }
                return new MultiPolygon(polygons);
            }

            public Geometry visit(Point point) {
                return new Point(point.getX(), point.getY());
            }

            public Geometry visit(org.elasticsearch.geometry.Polygon polygon) {
                List polygons = GeoShapeIndexer.this.decompose(polygon, GeoShapeIndexer.this.orientation);
                if (polygons.size() == 1) {
                    return (Geometry)polygons.get(0);
                }
                return new MultiPolygon(polygons);
            }

            public Geometry visit(Rectangle rectangle) {
                return rectangle;
            }
        });
    }

    @Override
    public Class<Geometry> processedClass() {
        return Geometry.class;
    }

    @Override
    public List<IndexableField> indexShape(ParseContext context, Geometry shape) {
        LuceneGeometryIndexer visitor = new LuceneGeometryIndexer(this.name);
        shape.visit((GeometryVisitor)visitor);
        return visitor.fields();
    }

    protected static double intersection(double p1x, double p2x, double dateline) {
        if (p1x == p2x && p1x != dateline) {
            return Double.NaN;
        }
        if (p1x == p2x && p1x == dateline) {
            return 1.0;
        }
        double t = (dateline - p1x) / (p2x - p1x);
        if (t > 1.0 || t <= 0.0) {
            return Double.NaN;
        }
        return t;
    }

    private List<Line> decomposeGeometry(Line line, List<Line> lines) {
        for (Line partPlus : this.decompose(180.0, line)) {
            for (Line partMinus : this.decompose(-180.0, partPlus)) {
                double[] lats = new double[partMinus.length()];
                double[] lons = new double[partMinus.length()];
                for (int i = 0; i < partMinus.length(); ++i) {
                    lats[i] = GeoUtils.normalizeLat(partMinus.getY(i));
                    lons[i] = GeoUtils.normalizeLon(partMinus.getX(i));
                }
                lines.add(new Line(lons, lats));
            }
        }
        return lines;
    }

    private List<Line> decompose(double dateline, Line line) {
        double[] lons = line.getX();
        double[] lats = line.getY();
        return this.decompose(dateline, lons, lats);
    }

    private List<Line> decompose(double dateline, double[] lons, double[] lats) {
        int offset = 0;
        ArrayList<Line> parts = new ArrayList<Line>();
        double lastLon = lons[0];
        double shift = lastLon > 180.0 ? 180.0 : (lastLon < -180.0 ? -180.0 : 0.0);
        for (int i = 1; i < lons.length; ++i) {
            double t = GeoShapeIndexer.intersection(lastLon, lons[i], dateline);
            lastLon = lons[i];
            if (Double.isNaN(t)) continue;
            double[] partLons = Arrays.copyOfRange(lons, offset, i + 1);
            double[] partLats = Arrays.copyOfRange(lats, offset, i + 1);
            if (t < 1.0) {
                Point intersection = GeoShapeIndexer.position(new Point(lons[i - 1], lats[i - 1]), new Point(lons[i], lats[i]), t);
                partLons[partLons.length - 1] = intersection.getX();
                partLats[partLats.length - 1] = intersection.getY();
                lons[offset + i - 1] = intersection.getX();
                lats[offset + i - 1] = intersection.getY();
                GeoShapeIndexer.shift(shift, lons);
                offset = i - 1;
                shift = lons[i] > 180.0 ? 180.0 : (lons[i] < -180.0 ? -180.0 : 0.0);
            } else {
                GeoShapeIndexer.shift(shift, partLons);
                offset = i;
            }
            parts.add(new Line(partLons, partLats));
        }
        if (offset == 0) {
            GeoShapeIndexer.shift(shift, lons);
            parts.add(new Line(lons, lats));
        } else if (offset < lons.length - 1) {
            double[] partLons = Arrays.copyOfRange(lons, offset, lons.length);
            double[] partLats = Arrays.copyOfRange(lats, offset, lats.length);
            GeoShapeIndexer.shift(shift, partLons);
            parts.add(new Line(partLons, partLats));
        }
        return parts;
    }

    private static void shift(double shift, double[] lons) {
        if (shift != 0.0) {
            for (int j = 0; j < lons.length; ++j) {
                lons[j] = lons[j] - 2.0 * shift;
            }
        }
    }

    protected static Point shift(Point coordinate, double dateline) {
        if (dateline == 0.0) {
            return coordinate;
        }
        return new Point(-2.0 * dateline + coordinate.getX(), coordinate.getY());
    }

    private List<org.elasticsearch.geometry.Polygon> decompose(org.elasticsearch.geometry.Polygon polygon, boolean orientation) {
        int numEdges = polygon.getPolygon().length() - 1;
        for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
            numEdges += polygon.getHole(i).length() - 1;
            this.validateHole(polygon.getPolygon(), polygon.getHole(i));
        }
        Edge[] edges = new Edge[numEdges];
        Edge[] holeComponents = new Edge[polygon.getNumberOfHoles()];
        AtomicBoolean translated = new AtomicBoolean(false);
        int offset = this.createEdges(0, orientation, polygon.getPolygon(), null, edges, 0, translated);
        for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
            int length = this.createEdges(i + 1, orientation, polygon.getPolygon(), polygon.getHole(i), edges, offset, translated);
            holeComponents[i] = edges[offset];
            offset += length;
        }
        int numHoles = holeComponents.length;
        numHoles = this.merge(edges, 0, GeoShapeIndexer.intersections(180.0, edges), holeComponents, numHoles);
        numHoles = this.merge(edges, 0, GeoShapeIndexer.intersections(-180.0, edges), holeComponents, numHoles);
        return GeoShapeIndexer.compose(edges, holeComponents, numHoles);
    }

    private void validateHole(LinearRing shell, LinearRing hole) {
        int i;
        HashSet<Point> exterior = new HashSet<Point>();
        HashSet<Point> interior = new HashSet<Point>();
        for (i = 0; i < shell.length(); ++i) {
            exterior.add(new Point(shell.getX(i), shell.getY(i)));
        }
        for (i = 0; i < hole.length(); ++i) {
            interior.add(new Point(hole.getX(i), hole.getY(i)));
        }
        exterior.retainAll(interior);
        if (exterior.size() >= 2) {
            throw new IllegalArgumentException("Invalid polygon, interior cannot share more than one point with the exterior");
        }
    }

    protected static Point position(Point p1, Point p2, double position) {
        if (position == 0.0) {
            return p1;
        }
        if (position == 1.0) {
            return p2;
        }
        double x = p1.getX() + position * (p2.getX() - p1.getX());
        double y = p1.getY() + position * (p2.getY() - p1.getY());
        return new Point(x, y);
    }

    private int createEdges(int component, boolean orientation, LinearRing shell, LinearRing hole, Edge[] edges, int offset, AtomicBoolean translated) {
        boolean direction = component == 0 ^ orientation;
        Point[] points = hole != null ? this.points(hole) : this.points(shell);
        this.ring(component, direction, !orientation, points, 0, edges, offset, points.length - 1, translated);
        return points.length - 1;
    }

    private Point[] points(LinearRing linearRing) {
        Point[] points = new Point[linearRing.length()];
        for (int i = 0; i < linearRing.length(); ++i) {
            points[i] = new Point(linearRing.getX(i), linearRing.getY(i));
        }
        return points;
    }

    private Edge[] ring(int component, boolean direction, boolean handedness, Point[] points, int offset, Edge[] edges, int toffset, int length, AtomicBoolean translated) {
        boolean incorrectOrientation;
        boolean orientation = GeoShapeIndexer.getOrientation(points, offset, length);
        double[] range = GeoShapeIndexer.range(points, offset, length);
        double rng = range[1] - range[0];
        boolean bl = incorrectOrientation = component == 0 && handedness != orientation;
        if (incorrectOrientation && rng > 180.0 && rng != 360.0 || translated.get() && component != 0) {
            GeoShapeIndexer.translate(points);
            if (component == 0) {
                translated.set(true);
            }
            if (component == 0 || component != 0 && handedness == orientation) {
                orientation = !orientation;
            }
        }
        return GeoShapeIndexer.concat(component, direction ^ orientation, points, offset, edges, toffset, length);
    }

    private static void translate(Point[] points) {
        for (int i = 0; i < points.length; ++i) {
            if (!(points[i].getX() < 0.0)) continue;
            points[i] = new Point(points[i].getX() + 360.0, points[i].getY());
        }
    }

    private static boolean getOrientation(Point[] points, int offset, int length) {
        int top = GeoShapeIndexer.top(points, offset, length);
        int prev = (top + length - 1) % length;
        int next = (top + 1) % length;
        int determinantSign = org.apache.lucene.geo.GeoUtils.orient((double)points[offset + prev].getX(), (double)points[offset + prev].getY(), (double)points[offset + top].getX(), (double)points[offset + top].getY(), (double)points[offset + next].getX(), (double)points[offset + next].getY());
        if (determinantSign == 0) {
            throw new InvalidShapeException("Cannot determine orientation: edges adjacent to (" + points[offset + top].getX() + "," + points[offset + top].getY() + ") coincide");
        }
        return determinantSign < 0;
    }

    private static int top(Point[] points, int offset, int length) {
        int top = 0;
        for (int i = 1; i < length; ++i) {
            if (points[offset + i].getY() < points[offset + top].getY()) {
                top = i;
                continue;
            }
            if (points[offset + i].getY() != points[offset + top].getY() || !(points[offset + i].getX() < points[offset + top].getX())) continue;
            top = i;
        }
        return top;
    }

    private static double[] range(Point[] points, int offset, int length) {
        double minY;
        double minX;
        double maxX = minX = points[0].getX();
        double maxY = minY = points[0].getY();
        for (int i = 1; i < length; ++i) {
            Point point = points[offset + i];
            if (point.getX() < minX) {
                minX = point.getX();
            }
            if (point.getX() > maxX) {
                maxX = point.getX();
            }
            if (point.getY() < minY) {
                minY = point.getY();
            }
            if (!(point.getY() > maxY)) continue;
            maxY = point.getY();
        }
        return new double[]{minX, maxX, minY, maxY};
    }

    private int merge(Edge[] intersections, int offset, int length, Edge[] holes, int numHoles) {
        for (int i = 0; i < length; i += 2) {
            Edge e1 = intersections[offset + i + 0];
            Edge e2 = intersections[offset + i + 1];
            if (e2.component > 0) {
                holes[e2.component - 1] = holes[--numHoles];
                holes[numHoles] = null;
            }
            if (e1.intersect == Edge.MAX_COORDINATE || e2.intersect == Edge.MAX_COORDINATE || e1.next.next.coordinate.equals((Object)e2.coordinate) && Math.abs(e1.next.coordinate.getX()) == 180.0 && Math.abs(e2.coordinate.getX()) == 180.0) continue;
            this.connect(e1, e2);
        }
        return numHoles;
    }

    private void connect(Edge in, Edge out) {
        assert (in != null && out != null);
        assert (in != out);
        if (in.intersect != in.next.coordinate) {
            Edge e1 = new Edge(in.intersect, in.next);
            if (out.intersect != out.next.coordinate) {
                Edge e2 = new Edge(out.intersect, out.next);
                in.next = new Edge(in.intersect, e2, in.intersect);
            } else {
                in.next = new Edge(in.intersect, out.next, in.intersect);
            }
            out.next = new Edge(out.intersect, e1, out.intersect);
        } else if (in.next != out && in.coordinate != out.intersect) {
            Edge e2 = new Edge(out.intersect, in.next, out.intersect);
            if (out.intersect != out.next.coordinate) {
                Edge e1 = new Edge(out.intersect, out.next);
                in.next = new Edge(in.intersect, e1, in.intersect);
            } else {
                in.next = new Edge(in.intersect, out.next, in.intersect);
            }
            out.next = e2;
        }
    }

    private static Edge[] concat(int component, boolean direction, Point[] points, int pointOffset, Edge[] edges, int edgeOffset, int length) {
        assert (edges.length >= length + edgeOffset);
        assert (points.length >= length + pointOffset);
        edges[edgeOffset] = new Edge(new Point(points[pointOffset].getX(), points[pointOffset].getY()), null);
        for (int i = 1; i < length; ++i) {
            Point nextPoint = new Point(points[pointOffset + i].getX(), points[pointOffset + i].getY());
            if (direction) {
                edges[edgeOffset + i] = new Edge(nextPoint, edges[edgeOffset + i - 1]);
                edges[edgeOffset + i].component = component;
                continue;
            }
            if (!edges[edgeOffset + i - 1].coordinate.equals((Object)nextPoint)) {
                Edge edge = new Edge(nextPoint, null);
                edges[edgeOffset + i] = edge;
                edges[edgeOffset + i - 1].next = edge;
                edges[edgeOffset + i - 1].component = component;
                continue;
            }
            throw new InvalidShapeException("Provided shape has duplicate consecutive coordinates at: (" + nextPoint + ")");
        }
        if (direction) {
            edges[edgeOffset].setNext(edges[edgeOffset + length - 1]);
            edges[edgeOffset].component = component;
        } else {
            edges[edgeOffset + length - 1].setNext(edges[edgeOffset]);
            edges[edgeOffset + length - 1].component = component;
        }
        return edges;
    }

    protected static int intersections(double dateline, Edge[] edges) {
        int numIntersections = 0;
        assert (!Double.isNaN(dateline));
        for (int i = 0; i < edges.length; ++i) {
            Point p1 = edges[i].coordinate;
            Point p2 = edges[i].next.coordinate;
            assert (!Double.isNaN(p2.getX()) && !Double.isNaN(p1.getX()));
            edges[i].intersect = Edge.MAX_COORDINATE;
            double position = GeoShapeIndexer.intersection(p1.getX(), p2.getX(), dateline);
            if (Double.isNaN(position)) continue;
            edges[i].intersection(position);
            ++numIntersections;
        }
        Arrays.sort(edges, INTERSECTION_ORDER);
        return numIntersections;
    }

    private static Edge[] edges(Edge[] edges, int numHoles, List<List<Point[]>> components) {
        ArrayList<Edge> mainEdges = new ArrayList<Edge>(edges.length);
        for (int i = 0; i < edges.length; ++i) {
            if (edges[i].component < 0) continue;
            double[] partitionPoint = new double[3];
            int length = GeoShapeIndexer.component(edges[i], -(components.size() + numHoles + 1), mainEdges, partitionPoint);
            ArrayList<Point[]> component = new ArrayList<Point[]>();
            component.add(GeoShapeIndexer.coordinates(edges[i], new Point[length + 1], partitionPoint));
            components.add(component);
        }
        return mainEdges.toArray(new Edge[mainEdges.size()]);
    }

    private static List<org.elasticsearch.geometry.Polygon> compose(Edge[] edges, Edge[] holes, int numHoles) {
        ArrayList<List<Point[]>> components = new ArrayList<List<Point[]>>();
        GeoShapeIndexer.assign(holes, GeoShapeIndexer.holes(holes, numHoles), numHoles, GeoShapeIndexer.edges(edges, numHoles, components), components);
        return GeoShapeIndexer.buildPoints(components);
    }

    private static void assign(Edge[] holes, Point[][] points, int numHoles, Edge[] edges, List<List<Point[]>> components) {
        for (int i = 0; i < numHoles; ++i) {
            Edge current = new Edge(holes[i].coordinate, holes[i].next);
            current.intersect = current.coordinate;
            int intersections = GeoShapeIndexer.intersections(current.coordinate.getX(), edges);
            if (intersections == 0) {
                throw new InvalidShapeException("Invalid shape: Hole is not within polygon");
            }
            boolean sharedVertex = false;
            int pos = Arrays.binarySearch(edges, 0, intersections, current, INTERSECTION_ORDER);
            if (pos >= 0 && !(sharedVertex = edges[pos].intersect.equals((Object)current.coordinate))) {
                throw new InvalidShapeException("Invalid shape: Hole is not within polygon");
            }
            int index = sharedVertex ? 0 : (pos == -1 ? 0 : -(pos + 2));
            int component = -edges[index].component - numHoles - 1;
            components.get(component).add(points[i]);
        }
    }

    private static int component(Edge edge, int id, ArrayList<Edge> edges, double[] partitionPoint) {
        Edge any = edge;
        while ((any.coordinate.getX() == 180.0 || any.coordinate.getX() == -180.0) && (any = any.next) != edge) {
        }
        double shiftOffset = any.coordinate.getX() > 180.0 ? 180.0 : (any.coordinate.getX() < -180.0 ? -180.0 : 0.0);
        int length = 0;
        int connectedComponents = 0;
        int splitIndex = 1;
        Edge current = edge;
        Edge prev = edge;
        HashMap<Point, Tuple> visitedEdge = new HashMap<Point, Tuple>();
        do {
            current.coordinate = GeoShapeIndexer.shift(current.coordinate, shiftOffset);
            current.component = id;
            if (edges != null) {
                if (visitedEdge.containsKey(current.coordinate)) {
                    partitionPoint[0] = current.coordinate.getX();
                    partitionPoint[1] = current.coordinate.getY();
                    if (connectedComponents > 0 && current.next != edge) {
                        throw new InvalidShapeException("Shape contains more than one shared point");
                    }
                    int visitID = -id;
                    Edge firstAppearance = (Edge)((Tuple)visitedEdge.get(current.coordinate)).v2();
                    Edge temp = firstAppearance.next;
                    firstAppearance.next = current.next;
                    current.next = temp;
                    current.component = visitID;
                    do {
                        prev.component = visitID;
                        prev = (Edge)((Tuple)visitedEdge.get(prev.coordinate)).v1();
                        ++splitIndex;
                    } while (!current.coordinate.equals((Object)prev.coordinate));
                    ++connectedComponents;
                } else {
                    visitedEdge.put(current.coordinate, new Tuple((Object)prev, (Object)current));
                }
                edges.add(current);
                prev = current;
            }
            ++length;
        } while (connectedComponents == 0 && (current = current.next) != edge);
        return splitIndex != 1 ? length - splitIndex : length;
    }

    private static Point[] coordinates(Edge component, Point[] coordinates, double[] partitionPoint) {
        for (int i = 0; i < coordinates.length; ++i) {
            component = component.next;
            coordinates[i] = component.coordinate;
        }
        if (!coordinates[0].equals((Object)coordinates[coordinates.length - 1])) {
            if (partitionPoint[2] == Double.NaN) {
                throw new InvalidShapeException("Self-intersection at or near point [" + partitionPoint[0] + "," + partitionPoint[1] + "]");
            }
            throw new InvalidShapeException("Self-intersection at or near point [" + partitionPoint[0] + "," + partitionPoint[1] + "," + partitionPoint[2] + "]");
        }
        return coordinates;
    }

    private static List<org.elasticsearch.geometry.Polygon> buildPoints(List<List<Point[]>> components) {
        ArrayList<org.elasticsearch.geometry.Polygon> result = new ArrayList<org.elasticsearch.geometry.Polygon>(components.size());
        for (int i = 0; i < components.size(); ++i) {
            List<Point[]> component = components.get(i);
            result.add(GeoShapeIndexer.buildPolygon(component));
        }
        return result;
    }

    private static org.elasticsearch.geometry.Polygon buildPolygon(List<Point[]> polygon) {
        List holes;
        Point[] shell = polygon.get(0);
        if (polygon.size() > 1) {
            holes = new ArrayList(polygon.size() - 1);
            for (int i = 1; i < polygon.size(); ++i) {
                Point[] coords = polygon.get(i);
                double[] x = new double[coords.length];
                double[] y = new double[coords.length];
                for (int c = 0; c < coords.length; ++c) {
                    x[c] = GeoUtils.normalizeLon(coords[c].getX());
                    y[c] = GeoUtils.normalizeLat(coords[c].getY());
                }
                holes.add(new LinearRing(x, y));
            }
        } else {
            holes = Collections.emptyList();
        }
        double[] x = new double[shell.length];
        double[] y = new double[shell.length];
        for (int i = 0; i < shell.length; ++i) {
            x[i] = Math.abs(shell[i].getX()) > 180.0 ? GeoUtils.normalizeLon(shell[i].getX()) : shell[i].getX();
            y[i] = GeoUtils.normalizeLat(shell[i].getY());
        }
        return new org.elasticsearch.geometry.Polygon(new LinearRing(x, y), holes);
    }

    private static Point[][] holes(Edge[] holes, int numHoles) {
        if (numHoles == 0) {
            return new Point[0][];
        }
        Point[][] points = new Point[numHoles][];
        for (int i = 0; i < numHoles; ++i) {
            double[] partitionPoint = new double[3];
            int length = GeoShapeIndexer.component(holes[i], -(i + 1), null, partitionPoint);
            points[i] = GeoShapeIndexer.coordinates(holes[i], new Point[length + 1], partitionPoint);
        }
        return points;
    }

    public static Polygon toLucenePolygon(org.elasticsearch.geometry.Polygon polygon) {
        Polygon[] holes = new Polygon[polygon.getNumberOfHoles()];
        for (int i = 0; i < holes.length; ++i) {
            holes[i] = new Polygon(polygon.getHole(i).getY(), polygon.getHole(i).getX(), new Polygon[0]);
        }
        return new Polygon(polygon.getPolygon().getY(), polygon.getPolygon().getX(), holes);
    }

    private static class LuceneGeometryIndexer
    implements GeometryVisitor<Void, RuntimeException> {
        private List<IndexableField> fields = new ArrayList<IndexableField>();
        private String name;

        private LuceneGeometryIndexer(String name) {
            this.name = name;
        }

        List<IndexableField> fields() {
            return this.fields;
        }

        public Void visit(Circle circle) {
            throw new IllegalArgumentException("invalid shape type found [Circle] while indexing shape");
        }

        public Void visit(GeometryCollection<?> collection) {
            for (Geometry geometry : collection) {
                geometry.visit((GeometryVisitor)this);
            }
            return null;
        }

        public Void visit(Line line) {
            this.addFields((IndexableField[])LatLonShape.createIndexableFields((String)this.name, (org.apache.lucene.geo.Line)new org.apache.lucene.geo.Line(line.getY(), line.getX())));
            return null;
        }

        public Void visit(LinearRing ring) {
            throw new IllegalArgumentException("invalid shape type found [LinearRing] while indexing shape");
        }

        public Void visit(MultiLine multiLine) {
            for (Line line : multiLine) {
                this.visit(line);
            }
            return null;
        }

        public Void visit(MultiPoint multiPoint) {
            for (Point point : multiPoint) {
                this.visit(point);
            }
            return null;
        }

        public Void visit(MultiPolygon multiPolygon) {
            for (org.elasticsearch.geometry.Polygon polygon : multiPolygon) {
                this.visit(polygon);
            }
            return null;
        }

        public Void visit(Point point) {
            this.addFields((IndexableField[])LatLonShape.createIndexableFields((String)this.name, (double)point.getY(), (double)point.getX()));
            return null;
        }

        public Void visit(org.elasticsearch.geometry.Polygon polygon) {
            this.addFields((IndexableField[])LatLonShape.createIndexableFields((String)this.name, (Polygon)GeoShapeIndexer.toLucenePolygon(polygon)));
            return null;
        }

        public Void visit(Rectangle r) {
            Polygon p = new Polygon(new double[]{r.getMinY(), r.getMinY(), r.getMaxY(), r.getMaxY(), r.getMinY()}, new double[]{r.getMinX(), r.getMaxX(), r.getMaxX(), r.getMinX(), r.getMinX()}, new Polygon[0]);
            this.addFields((IndexableField[])LatLonShape.createIndexableFields((String)this.name, (Polygon)p));
            return null;
        }

        private void addFields(IndexableField[] fields) {
            this.fields.addAll(Arrays.asList(fields));
        }
    }

    private static final class Edge {
        Point coordinate;
        Edge next;
        Point intersect;
        int component = -1;
        public static final Point MAX_COORDINATE = new Point(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

        protected Edge(Point coordinate, Edge next, Point intersection) {
            this.coordinate = coordinate;
            this.setNext(next);
            this.intersect = intersection;
            if (next != null) {
                this.component = next.component;
            }
        }

        protected Edge(Point coordinate, Edge next) {
            this(coordinate, next, MAX_COORDINATE);
        }

        protected void setNext(Edge next) {
            if (next != null) {
                if (this.coordinate.equals((Object)next.coordinate)) {
                    throw new InvalidShapeException("Provided shape has duplicate consecutive coordinates at: " + this.coordinate);
                }
                this.next = next;
            }
        }

        protected Point intersection(double position) {
            this.intersect = GeoShapeIndexer.position(this.coordinate, this.next.coordinate, position);
            return this.intersect;
        }

        public String toString() {
            return "Edge[Component=" + this.component + "; start=" + this.coordinate + " ; intersection=" + this.intersect + "]";
        }
    }
}

