/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.document;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public class RestMultiGetAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestMultiGetAction.class));
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in multi get requests is deprecated.";
    private final boolean allowExplicitIndex;

    public RestMultiGetAction(Settings settings, RestController controller) {
        controller.registerHandler(RestRequest.Method.GET, "/_mget", this);
        controller.registerHandler(RestRequest.Method.POST, "/_mget", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mget", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mget", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_mget", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_mget", this);
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
    }

    @Override
    public String getName() {
        return "document_mget_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (request.param("type") != null) {
            deprecationLogger.deprecatedAndMaybeLog("mget_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        MultiGetRequest multiGetRequest = new MultiGetRequest();
        multiGetRequest.refresh(request.paramAsBoolean("refresh", multiGetRequest.refresh()));
        multiGetRequest.preference(request.param("preference"));
        multiGetRequest.realtime(request.paramAsBoolean("realtime", multiGetRequest.realtime()));
        if (request.param("fields") != null) {
            throw new IllegalArgumentException("The parameter [fields] is no longer supported, please use [stored_fields] to retrieve stored fields or _source filtering if the field is not stored");
        }
        String[] sFields = null;
        String sField = request.param("stored_fields");
        if (sField != null) {
            sFields = Strings.splitStringByCommaToArray(sField);
        }
        FetchSourceContext defaultFetchSource = FetchSourceContext.parseFromRestRequest(request);
        try (XContentParser parser = request.contentOrSourceParamParser();){
            multiGetRequest.add(request.param("index"), request.param("type"), sFields, defaultFetchSource, request.param("routing"), parser, this.allowExplicitIndex);
        }
        for (MultiGetRequest.Item item : multiGetRequest.getItems()) {
            if (item.type() == null) continue;
            deprecationLogger.deprecated(TYPES_DEPRECATION_MESSAGE, new Object[0]);
            break;
        }
        return channel -> client.multiGet(multiGetRequest, new RestToXContentListener<MultiGetResponse>((RestChannel)channel));
    }
}

