/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BaseAggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.internal.SearchContext;

public abstract class AggregationBuilder
implements NamedWriteable,
ToXContentFragment,
BaseAggregationBuilder {
    protected final String name;
    protected AggregatorFactories.Builder factoriesBuilder = AggregatorFactories.builder();

    protected AggregationBuilder(String name) {
        if (name == null) {
            throw new IllegalArgumentException("[name] must not be null: [" + name + "]");
        }
        this.name = name;
    }

    protected AggregationBuilder(AggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder) {
        this.name = clone.name;
        this.factoriesBuilder = factoriesBuilder;
    }

    public String getName() {
        return this.name;
    }

    protected abstract AggregatorFactory build(SearchContext var1, AggregatorFactory var2) throws IOException;

    @Override
    public abstract AggregationBuilder setMetaData(Map<String, Object> var1);

    public abstract Map<String, Object> getMetaData();

    public abstract AggregationBuilder subAggregation(AggregationBuilder var1);

    public abstract AggregationBuilder subAggregation(PipelineAggregationBuilder var1);

    public Collection<AggregationBuilder> getSubAggregations() {
        return this.factoriesBuilder.getAggregatorFactories();
    }

    public Collection<PipelineAggregationBuilder> getPipelineAggregations() {
        return this.factoriesBuilder.getPipelineAggregatorFactories();
    }

    @Override
    public abstract AggregationBuilder subAggregations(AggregatorFactories.Builder var1);

    protected abstract AggregationBuilder shallowCopy(AggregatorFactories.Builder var1, Map<String, Object> var2);

    public final AggregationBuilder rewrite(QueryRewriteContext context) throws IOException {
        AggregationBuilder rewritten = this.doRewrite(context);
        AggregatorFactories.Builder rewrittenSubAggs = this.factoriesBuilder.rewrite(context);
        if (rewritten != this) {
            return ((AggregationBuilder)rewritten.setMetaData((Map)this.getMetaData())).subAggregations(rewrittenSubAggs);
        }
        if (rewrittenSubAggs != this.factoriesBuilder) {
            return this.shallowCopy(rewrittenSubAggs, this.getMetaData());
        }
        return this;
    }

    protected AggregationBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        return this;
    }

    static AggregationBuilder rewriteAggregation(AggregationBuilder original, QueryRewriteContext context) throws IOException {
        AggregationBuilder builder = original;
        AggregationBuilder rewrittenBuilder = builder.rewrite(context);
        while (rewrittenBuilder != builder) {
            builder = rewrittenBuilder;
            rewrittenBuilder = builder.rewrite(context);
        }
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static final class CommonFields
    extends ParseField.CommonFields {
        public static final ParseField VALUE_TYPE = new ParseField("value_type", new String[0]);
    }
}

