/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.Version;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.transport.OutboundHandler;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportResponse;

public final class TcpTransportChannel
implements TransportChannel {
    private final AtomicBoolean released = new AtomicBoolean();
    private final OutboundHandler outboundHandler;
    private final TcpChannel channel;
    private final String action;
    private final long requestId;
    private final Version version;
    private final Set<String> features;
    private final CircuitBreakerService breakerService;
    private final long reservedBytes;
    private final boolean compressResponse;
    private Exception releaseBy;

    TcpTransportChannel(OutboundHandler outboundHandler, TcpChannel channel, String action, long requestId, Version version, Set<String> features, CircuitBreakerService breakerService, long reservedBytes, boolean compressResponse) {
        this.version = version;
        this.features = features;
        this.channel = channel;
        this.outboundHandler = outboundHandler;
        this.action = action;
        this.requestId = requestId;
        this.breakerService = breakerService;
        this.reservedBytes = reservedBytes;
        this.compressResponse = compressResponse;
    }

    @Override
    public String getProfileName() {
        return this.channel.getProfile();
    }

    @Override
    public void sendResponse(TransportResponse response) throws IOException {
        try {
            this.outboundHandler.sendResponse(this.version, this.features, this.channel, this.requestId, this.action, response, this.compressResponse, false);
        }
        finally {
            this.release(false);
        }
    }

    @Override
    public void sendResponse(Exception exception) throws IOException {
        try {
            this.outboundHandler.sendErrorResponse(this.version, this.features, this.channel, this.requestId, this.action, exception);
        }
        finally {
            this.release(true);
        }
    }

    private void release(boolean isExceptionResponse) {
        if (this.released.compareAndSet(false, true)) {
            assert ((this.releaseBy = new Exception()) != null);
            this.breakerService.getBreaker("in_flight_requests").addWithoutBreaking(-this.reservedBytes);
        } else if (!isExceptionResponse) {
            throw new IllegalStateException("reserved bytes are already released", this.releaseBy);
        }
    }

    @Override
    public String getChannelType() {
        return "transport";
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public TcpChannel getChannel() {
        return this.channel;
    }
}

