/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.painless.Constant;
import org.elasticsearch.painless.node.SFunction;

public class Globals {
    private final Map<String, SFunction> syntheticMethods = new HashMap<String, SFunction>();
    private final Map<String, Constant> constantInitializers = new HashMap<String, Constant>();
    private final Map<String, Class<?>> classBindings = new HashMap();
    private final Map<Object, String> instanceBindings = new HashMap<Object, String>();
    private final BitSet statements;

    public Globals(BitSet statements) {
        this.statements = statements;
    }

    public void addSyntheticMethod(SFunction function) {
        if (!function.synthetic) {
            throw new IllegalStateException("method: " + function.name + " is not synthetic");
        }
        if (this.syntheticMethods.put(function.name, function) != null) {
            throw new IllegalStateException("synthetic method: " + function.name + " already exists");
        }
    }

    public void addConstantInitializer(Constant constant) {
        if (this.constantInitializers.put(constant.name, constant) != null) {
            throw new IllegalStateException("constant initializer: " + constant.name + " already exists");
        }
    }

    public String addClassBinding(Class<?> type) {
        String name = "$class_binding$" + this.classBindings.size();
        this.classBindings.put(name, type);
        return name;
    }

    public String addInstanceBinding(Object instance) {
        return this.instanceBindings.computeIfAbsent(instance, key -> "$instance_binding$" + this.instanceBindings.size());
    }

    public Map<String, SFunction> getSyntheticMethods() {
        return this.syntheticMethods;
    }

    public Map<String, Constant> getConstantInitializers() {
        return this.constantInitializers;
    }

    public Map<String, Class<?>> getClassBindings() {
        return this.classBindings;
    }

    public Map<Object, String> getInstanceBindings() {
        return this.instanceBindings;
    }

    public BitSet getStatements() {
        return this.statements;
    }
}

