/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.SBlock;
import org.objectweb.asm.Label;

public final class SCatch
extends AStatement {
    private final String type;
    private final String name;
    private final SBlock block;
    private Locals.Variable variable = null;
    Label begin = null;
    Label end = null;
    Label exception = null;

    public SCatch(Location location, String type, String name, SBlock block) {
        super(location);
        this.type = Objects.requireNonNull(type);
        this.name = Objects.requireNonNull(name);
        this.block = block;
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        if (this.block != null) {
            this.block.storeSettings(settings);
        }
    }

    @Override
    void extractVariables(Set<String> variables) {
        variables.add(this.name);
        if (this.block != null) {
            this.block.extractVariables(variables);
        }
    }

    @Override
    void analyze(Locals locals) {
        Class<?> clazz = locals.getPainlessLookup().canonicalTypeNameToType(this.type);
        if (clazz == null) {
            throw this.createError(new IllegalArgumentException("Not a type [" + this.type + "]."));
        }
        if (!Exception.class.isAssignableFrom(clazz)) {
            throw this.createError(new ClassCastException("Not an exception type [" + this.type + "]."));
        }
        this.variable = locals.addVariable(this.location, clazz, this.name, true);
        if (this.block != null) {
            this.block.lastSource = this.lastSource;
            this.block.inLoop = this.inLoop;
            this.block.lastLoop = this.lastLoop;
            this.block.analyze(locals);
            this.methodEscape = this.block.methodEscape;
            this.loopEscape = this.block.loopEscape;
            this.allEscape = this.block.allEscape;
            this.anyContinue = this.block.anyContinue;
            this.anyBreak = this.block.anyBreak;
            this.statementCount = this.block.statementCount;
        }
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeStatementOffset(this.location);
        Label jump = new Label();
        writer.mark(jump);
        writer.visitVarInsn(MethodWriter.getType(this.variable.clazz).getOpcode(54), this.variable.getSlot());
        if (this.block != null) {
            this.block.continu = this.continu;
            this.block.brake = this.brake;
            this.block.write(writer, globals);
        }
        writer.visitTryCatchBlock(this.begin, this.end, jump, MethodWriter.getType(this.variable.clazz).getInternalName());
        if (!(this.exception == null || this.block != null && this.block.allEscape)) {
            writer.goTo(this.exception);
        }
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.type, this.name, this.block);
    }
}

