/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1SetParser;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.BERTaggedObjectParser;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.SignedDataParser;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.PEMUtil;
import org.bouncycastle.jcajce.provider.PKIXCertPath;
import org.bouncycastle.jcajce.provider.X509CRLObject;
import org.bouncycastle.jcajce.provider.X509CertificateObject;
import org.bouncycastle.util.io.Streams;

class CertificateFactory
extends CertificateFactorySpi {
    private static final PEMUtil PEM_CERT_PARSER = new PEMUtil("CERTIFICATE");
    private static final PEMUtil PEM_CRL_PARSER = new PEMUtil("CRL");
    private final BouncyCastleFipsProvider fipsProvider;
    private ASN1Set sData = null;
    private int sDataObjectCount = 0;
    private InputStream currentStream = null;
    private ASN1StreamParser currentAsn1Parser = null;
    private ASN1Set sCrlData = null;
    private int sCrlDataObjectCount = 0;
    private InputStream currentCrlStream = null;
    private SignedDataParser signedDataParser = null;

    CertificateFactory(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        this.fipsProvider = bouncyCastleFipsProvider;
    }

    private java.security.cert.Certificate readDERCertificate() throws IOException, CertificateParsingException {
        ASN1Encodable aSN1Encodable;
        ASN1SequenceParser aSN1SequenceParser = (ASN1SequenceParser)this.currentAsn1Parser.readObject();
        ASN1Encodable aSN1Encodable2 = aSN1SequenceParser.readObject();
        if (aSN1Encodable2 instanceof ASN1ObjectIdentifier && aSN1Encodable2.equals(PKCSObjectIdentifiers.signedData)) {
            ASN1SetParser aSN1SetParser;
            this.signedDataParser = SignedDataParser.getInstance(((BERTaggedObjectParser)aSN1SequenceParser.readObject()).getObjectParser(1, true));
            this.signedDataParser.getDigestAlgorithms().toASN1Primitive();
            ASN1Encodable aSN1Encodable3 = this.signedDataParser.getEncapContentInfo().getContent(0);
            if (aSN1Encodable3 != null) {
                aSN1Encodable3.toASN1Primitive();
            }
            if ((aSN1SetParser = this.signedDataParser.getCertificates()) != null) {
                this.sData = this.pruneSet(aSN1SetParser);
                return this.getCertificate();
            }
            return null;
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(aSN1Encodable2.toASN1Primitive());
        while ((aSN1Encodable = aSN1SequenceParser.readObject()) != null) {
            aSN1EncodableVector.add(aSN1Encodable.toASN1Primitive());
        }
        return new X509CertificateObject(this.fipsProvider, Certificate.getInstance(new DERSequence(aSN1EncodableVector)));
    }

    private ASN1Set pruneSet(ASN1SetParser aSN1SetParser) {
        ASN1Set aSN1Set = ASN1Set.getInstance(aSN1SetParser.toASN1Primitive());
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration = aSN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1Encodable aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
            if (!(aSN1Encodable instanceof ASN1Sequence)) continue;
            aSN1EncodableVector.add(aSN1Encodable);
        }
        return new DERSet(aSN1EncodableVector);
    }

    private java.security.cert.Certificate getCertificate() throws CertificateParsingException, IOException {
        if (this.sData != null) {
            while (this.sDataObjectCount < this.sData.size()) {
                ASN1Encodable aSN1Encodable;
                if (!((aSN1Encodable = this.sData.getObjectAt(this.sDataObjectCount++)) instanceof ASN1Sequence)) continue;
                if (this.sDataObjectCount == this.sData.size()) {
                    ASN1SetParser aSN1SetParser = this.signedDataParser.getCrls();
                    if (aSN1SetParser != null) {
                        aSN1SetParser.toASN1Primitive();
                    }
                    if ((aSN1SetParser = this.signedDataParser.getSignerInfos()) != null) {
                        aSN1SetParser.toASN1Primitive();
                    }
                }
                return new X509CertificateObject(this.fipsProvider, Certificate.getInstance(aSN1Encodable));
            }
        }
        return null;
    }

    private java.security.cert.Certificate readPEMCertificate(InputStream inputStream) throws IOException, CertificateParsingException {
        ASN1Sequence aSN1Sequence = PEM_CERT_PARSER.readPEMObject(inputStream);
        if (aSN1Sequence != null) {
            return new X509CertificateObject(this.fipsProvider, Certificate.getInstance(aSN1Sequence));
        }
        return null;
    }

    protected CRL createCRL(CertificateList certificateList) throws CRLException {
        return new X509CRLObject(this.fipsProvider, certificateList);
    }

    private CRL readPEMCRL(InputStream inputStream) throws IOException, CRLException {
        ASN1Sequence aSN1Sequence = PEM_CRL_PARSER.readPEMObject(inputStream);
        if (aSN1Sequence != null) {
            return this.createCRL(CertificateList.getInstance(aSN1Sequence));
        }
        return null;
    }

    private CRL readDERCRL() throws IOException, CRLException {
        ASN1Encodable aSN1Encodable;
        ASN1SequenceParser aSN1SequenceParser = (ASN1SequenceParser)this.currentAsn1Parser.readObject();
        ASN1Encodable aSN1Encodable2 = aSN1SequenceParser.readObject();
        if (aSN1Encodable2 instanceof ASN1ObjectIdentifier && aSN1Encodable2.equals(PKCSObjectIdentifiers.signedData)) {
            this.signedDataParser = SignedDataParser.getInstance(((BERTaggedObjectParser)aSN1SequenceParser.readObject()).getObjectParser(1, true));
            this.signedDataParser.getDigestAlgorithms().toASN1Primitive();
            ASN1Encodable aSN1Encodable3 = this.signedDataParser.getEncapContentInfo().getContent(0);
            if (aSN1Encodable3 != null) {
                aSN1Encodable3.toASN1Primitive();
            }
            this.signedDataParser.getCertificates().toASN1Primitive();
            ASN1SetParser aSN1SetParser = this.signedDataParser.getCrls();
            if (aSN1SetParser != null) {
                this.sCrlData = this.pruneSet(aSN1SetParser);
                return this.getCRL();
            }
            return null;
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(aSN1Encodable2.toASN1Primitive());
        while ((aSN1Encodable = aSN1SequenceParser.readObject()) != null) {
            aSN1EncodableVector.add(aSN1Encodable.toASN1Primitive());
        }
        return this.createCRL(CertificateList.getInstance(new DERSequence(aSN1EncodableVector)));
    }

    private CRL getCRL() throws CRLException, IOException {
        if (this.sCrlData != null) {
            while (this.sCrlDataObjectCount < this.sCrlData.size()) {
                ASN1SetParser aSN1SetParser;
                ASN1Encodable aSN1Encodable;
                if (!((aSN1Encodable = this.sCrlData.getObjectAt(this.sCrlDataObjectCount++)) instanceof ASN1Sequence)) continue;
                if (this.sCrlDataObjectCount == this.sCrlData.size() && (aSN1SetParser = this.signedDataParser.getSignerInfos()) != null) {
                    aSN1SetParser.toASN1Primitive();
                }
                return this.createCRL(CertificateList.getInstance(aSN1Encodable));
            }
        }
        return null;
    }

    private java.security.cert.Certificate readCertificate(InputStream inputStream) throws CertificateException {
        if (this.currentStream == null) {
            this.currentStream = inputStream;
            this.sData = null;
            this.sDataObjectCount = 0;
        } else if (this.currentStream != inputStream) {
            this.currentStream = inputStream;
            this.sData = null;
            this.sDataObjectCount = 0;
        }
        java.security.cert.Certificate certificate = null;
        try {
            if (this.sData != null) {
                if (this.sDataObjectCount != this.sData.size()) {
                    certificate = this.getCertificate();
                } else {
                    this.sData = null;
                    this.sDataObjectCount = 0;
                }
            }
            if (certificate == null) {
                InputStream inputStream2 = inputStream.markSupported() ? inputStream : new ByteArrayInputStream(Streams.readAll(inputStream));
                inputStream2.mark(1);
                int n = inputStream2.read();
                if (n == -1) {
                    return null;
                }
                inputStream2.reset();
                if (n != 48) {
                    certificate = this.readPEMCertificate(inputStream2);
                } else {
                    this.currentAsn1Parser = new ASN1StreamParser(inputStream2);
                    certificate = this.readDERCertificate();
                }
            }
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Exception exception) {
            throw new CertificateException(exception.getMessage(), exception);
        }
        return certificate;
    }

    public java.security.cert.Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        java.security.cert.Certificate certificate = this.readCertificate(inputStream);
        if (certificate != null) {
            return certificate;
        }
        throw new CertificateException("Unexpected data detected in stream");
    }

    public Collection engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        java.security.cert.Certificate certificate;
        ArrayList<java.security.cert.Certificate> arrayList = new ArrayList<java.security.cert.Certificate>();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        while ((certificate = this.readCertificate(bufferedInputStream)) != null) {
            arrayList.add(certificate);
        }
        return arrayList;
    }

    private CRL readCrl(InputStream inputStream) throws CRLException {
        if (this.currentCrlStream == null) {
            this.currentCrlStream = inputStream;
            this.sCrlData = null;
            this.sCrlDataObjectCount = 0;
        } else if (this.currentCrlStream != inputStream) {
            this.currentCrlStream = inputStream;
            this.sCrlData = null;
            this.sCrlDataObjectCount = 0;
        }
        CRL cRL = null;
        try {
            if (this.sCrlData != null) {
                if (this.sCrlDataObjectCount != this.sCrlData.size()) {
                    cRL = this.getCRL();
                } else {
                    this.sCrlData = null;
                    this.sCrlDataObjectCount = 0;
                }
            }
            if (cRL == null) {
                InputStream inputStream2 = inputStream.markSupported() ? inputStream : new ByteArrayInputStream(Streams.readAll(inputStream));
                inputStream2.mark(1);
                int n = inputStream2.read();
                if (n == -1) {
                    return null;
                }
                inputStream2.reset();
                if (n != 48) {
                    cRL = this.readPEMCRL(inputStream2);
                } else {
                    this.currentAsn1Parser = new ASN1StreamParser(inputStream2);
                    cRL = this.readDERCRL();
                }
            }
        }
        catch (CRLException cRLException) {
            throw cRLException;
        }
        catch (Exception exception) {
            throw new CRLException(exception.toString(), exception);
        }
        return cRL;
    }

    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        CRL cRL = this.readCrl(inputStream);
        if (cRL != null) {
            return cRL;
        }
        throw new CRLException("unexpected data detected in stream");
    }

    public Collection engineGenerateCRLs(InputStream inputStream) throws CRLException {
        CRL cRL;
        ArrayList<CRL> arrayList = new ArrayList<CRL>();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        while ((cRL = this.readCrl(bufferedInputStream)) != null) {
            arrayList.add(cRL);
        }
        return arrayList;
    }

    public Iterator engineGetCertPathEncodings() {
        return PKIXCertPath.certPathEncodings.iterator();
    }

    public CertPath engineGenerateCertPath(InputStream inputStream) throws CertificateException {
        return this.engineGenerateCertPath(inputStream, "PkiPath");
    }

    public CertPath engineGenerateCertPath(InputStream inputStream, String string) throws CertificateException {
        return new PKIXCertPath(this.fipsProvider, inputStream, string);
    }

    public CertPath engineGenerateCertPath(List list) throws CertificateException {
        for (Object e : list) {
            if (e == null || e instanceof X509Certificate) continue;
            throw new CertificateException("List contains non X509Certificate object while creating CertPath\n" + e.toString());
        }
        return new PKIXCertPath(this.fipsProvider, list);
    }
}

