/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.ECImplicitDomainParameters;
import org.bouncycastle.jcajce.spec.ECDomainParameterSpec;
import org.bouncycastle.jcajce.spec.ECImplicitDomainParameterSpec;
import org.bouncycastle.math.ec.ECCurve;

class ECUtil {
    ECUtil() {
    }

    public static ECParameterSpec convertToSpec(ECDomainParameters eCDomainParameters) {
        if (eCDomainParameters instanceof ECImplicitDomainParameters) {
            return new ECImplicitDomainParameterSpec((ECImplicitDomainParameters)eCDomainParameters);
        }
        return new ECDomainParameterSpec(eCDomainParameters);
    }

    public static ECDomainParameters convertFromSpec(ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = new ECDomainParameterSpec(eCParameterSpec).getDomainParameters();
        if (eCParameterSpec instanceof ECImplicitDomainParameterSpec) {
            return new ECImplicitDomainParameters(eCDomainParameters);
        }
        return eCDomainParameters;
    }

    public static org.bouncycastle.math.ec.ECPoint convertPoint(ECParameterSpec eCParameterSpec, ECPoint eCPoint) {
        return ECUtil.convertPoint(ECUtil.convertFromSpec(eCParameterSpec).getCurve(), eCPoint);
    }

    public static org.bouncycastle.math.ec.ECPoint convertPoint(ECCurve eCCurve, ECPoint eCPoint) {
        return eCCurve.validatePoint(eCPoint.getAffineX(), eCPoint.getAffineY());
    }
}

