/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.ECSecretBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.gpg.SXprUtils;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class SExprParser {
    private final PGPDigestCalculatorProvider digestProvider;

    public SExprParser(PGPDigestCalculatorProvider digestProvider) {
        this.digestProvider = digestProvider;
    }

    public PGPSecretKey parseSecretKey(InputStream inputStream, PBEProtectionRemoverFactory keyProtectionRemoverFactory, PGPPublicKey pubKey) throws IOException, PGPException {
        SXprUtils.skipOpenParenthesis(inputStream);
        String type = SXprUtils.readString(inputStream, inputStream.read());
        if (type.equals("protected-private-key")) {
            SXprUtils.skipOpenParenthesis(inputStream);
            String keyType = SXprUtils.readString(inputStream, inputStream.read());
            if (keyType.equals("ecc")) {
                SXprUtils.skipOpenParenthesis(inputStream);
                String curveID = SXprUtils.readString(inputStream, inputStream.read());
                String curveName = SXprUtils.readString(inputStream, inputStream.read());
                SXprUtils.skipCloseParenthesis(inputStream);
                SXprUtils.skipOpenParenthesis(inputStream);
                type = SXprUtils.readString(inputStream, inputStream.read());
                if (!type.equals("q")) {
                    throw new PGPException("no q value found");
                }
                byte[] qVal = SXprUtils.readBytes(inputStream, inputStream.read());
                SXprUtils.skipCloseParenthesis(inputStream);
                BigInteger d = this.processECSecretKey(inputStream, curveID, curveName, qVal, keyProtectionRemoverFactory);
                if (curveName.startsWith("NIST ")) {
                    curveName = curveName.substring("NIST ".length());
                }
                ECDSAPublicBCPGKey basePubKey = new ECDSAPublicBCPGKey(ECNamedCurveTable.getOID((String)curveName), new BigInteger(1, qVal));
                ECPublicBCPGKey assocPubKey = (ECPublicBCPGKey)pubKey.getPublicKeyPacket().getKey();
                if (!basePubKey.getCurveOID().equals((Object)assocPubKey.getCurveOID()) || !basePubKey.getEncodedPoint().equals(assocPubKey.getEncodedPoint())) {
                    throw new PGPException("passed in public key does not match secret key");
                }
                return new PGPSecretKey(new SecretKeyPacket(pubKey.getPublicKeyPacket(), 0, null, null, new ECSecretBCPGKey(d).getEncoded()), pubKey);
            }
            if (keyType.equals("dsa")) {
                BigInteger p = this.readBigInteger("p", inputStream);
                BigInteger q = this.readBigInteger("q", inputStream);
                BigInteger g = this.readBigInteger("g", inputStream);
                BigInteger y = this.readBigInteger("y", inputStream);
                BigInteger x = this.processDSASecretKey(inputStream, p, q, g, y, keyProtectionRemoverFactory);
                DSAPublicBCPGKey basePubKey = new DSAPublicBCPGKey(p, q, g, y);
                DSAPublicBCPGKey assocPubKey = (DSAPublicBCPGKey)pubKey.getPublicKeyPacket().getKey();
                if (!(basePubKey.getP().equals(assocPubKey.getP()) && basePubKey.getQ().equals(assocPubKey.getQ()) && basePubKey.getG().equals(assocPubKey.getG()) && basePubKey.getY().equals(assocPubKey.getY()))) {
                    throw new PGPException("passed in public key does not match secret key");
                }
                return new PGPSecretKey(new SecretKeyPacket(pubKey.getPublicKeyPacket(), 0, null, null, new DSASecretBCPGKey(x).getEncoded()), pubKey);
            }
            if (keyType.equals("elg")) {
                BigInteger p = this.readBigInteger("p", inputStream);
                BigInteger g = this.readBigInteger("g", inputStream);
                BigInteger y = this.readBigInteger("y", inputStream);
                BigInteger x = this.processElGamalSecretKey(inputStream, p, g, y, keyProtectionRemoverFactory);
                ElGamalPublicBCPGKey basePubKey = new ElGamalPublicBCPGKey(p, g, y);
                ElGamalPublicBCPGKey assocPubKey = (ElGamalPublicBCPGKey)pubKey.getPublicKeyPacket().getKey();
                if (!(basePubKey.getP().equals(assocPubKey.getP()) && basePubKey.getG().equals(assocPubKey.getG()) && basePubKey.getY().equals(assocPubKey.getY()))) {
                    throw new PGPException("passed in public key does not match secret key");
                }
                return new PGPSecretKey(new SecretKeyPacket(pubKey.getPublicKeyPacket(), 0, null, null, new ElGamalSecretBCPGKey(x).getEncoded()), pubKey);
            }
            if (keyType.equals("rsa")) {
                BigInteger n = this.readBigInteger("n", inputStream);
                BigInteger e = this.readBigInteger("e", inputStream);
                BigInteger[] values = this.processRSASecretKey(inputStream, n, e, keyProtectionRemoverFactory);
                RSAPublicBCPGKey basePubKey = new RSAPublicBCPGKey(n, e);
                RSAPublicBCPGKey assocPubKey = (RSAPublicBCPGKey)pubKey.getPublicKeyPacket().getKey();
                if (!basePubKey.getModulus().equals(assocPubKey.getModulus()) || !basePubKey.getPublicExponent().equals(assocPubKey.getPublicExponent())) {
                    throw new PGPException("passed in public key does not match secret key");
                }
                return new PGPSecretKey(new SecretKeyPacket(pubKey.getPublicKeyPacket(), 0, null, null, new RSASecretBCPGKey(values[0], values[1], values[2]).getEncoded()), pubKey);
            }
            throw new PGPException("unknown key type: " + keyType);
        }
        throw new PGPException("unknown key type found");
    }

    public PGPSecretKey parseSecretKey(InputStream inputStream, PBEProtectionRemoverFactory keyProtectionRemoverFactory, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        SXprUtils.skipOpenParenthesis(inputStream);
        String type = SXprUtils.readString(inputStream, inputStream.read());
        if (type.equals("protected-private-key")) {
            SXprUtils.skipOpenParenthesis(inputStream);
            String keyType = SXprUtils.readString(inputStream, inputStream.read());
            if (keyType.equals("ecc")) {
                SXprUtils.skipOpenParenthesis(inputStream);
                String curveID = SXprUtils.readString(inputStream, inputStream.read());
                String curveName = SXprUtils.readString(inputStream, inputStream.read());
                if (curveName.startsWith("NIST ")) {
                    curveName = curveName.substring("NIST ".length());
                }
                SXprUtils.skipCloseParenthesis(inputStream);
                SXprUtils.skipOpenParenthesis(inputStream);
                type = SXprUtils.readString(inputStream, inputStream.read());
                if (!type.equals("q")) {
                    throw new PGPException("no q value found");
                }
                byte[] qVal = SXprUtils.readBytes(inputStream, inputStream.read());
                PublicKeyPacket pubPacket = new PublicKeyPacket(19, new Date(), new ECDSAPublicBCPGKey(ECNamedCurveTable.getOID((String)curveName), new BigInteger(1, qVal)));
                SXprUtils.skipCloseParenthesis(inputStream);
                BigInteger d = this.processECSecretKey(inputStream, curveID, curveName, qVal, keyProtectionRemoverFactory);
                return new PGPSecretKey(new SecretKeyPacket(pubPacket, 0, null, null, new ECSecretBCPGKey(d).getEncoded()), new PGPPublicKey(pubPacket, fingerPrintCalculator));
            }
            if (keyType.equals("dsa")) {
                BigInteger p = this.readBigInteger("p", inputStream);
                BigInteger q = this.readBigInteger("q", inputStream);
                BigInteger g = this.readBigInteger("g", inputStream);
                BigInteger y = this.readBigInteger("y", inputStream);
                BigInteger x = this.processDSASecretKey(inputStream, p, q, g, y, keyProtectionRemoverFactory);
                PublicKeyPacket pubPacket = new PublicKeyPacket(17, new Date(), new DSAPublicBCPGKey(p, q, g, y));
                return new PGPSecretKey(new SecretKeyPacket(pubPacket, 0, null, null, new DSASecretBCPGKey(x).getEncoded()), new PGPPublicKey(pubPacket, fingerPrintCalculator));
            }
            if (keyType.equals("elg")) {
                BigInteger p = this.readBigInteger("p", inputStream);
                BigInteger g = this.readBigInteger("g", inputStream);
                BigInteger y = this.readBigInteger("y", inputStream);
                BigInteger x = this.processElGamalSecretKey(inputStream, p, g, y, keyProtectionRemoverFactory);
                PublicKeyPacket pubPacket = new PublicKeyPacket(16, new Date(), new ElGamalPublicBCPGKey(p, g, y));
                return new PGPSecretKey(new SecretKeyPacket(pubPacket, 0, null, null, new ElGamalSecretBCPGKey(x).getEncoded()), new PGPPublicKey(pubPacket, fingerPrintCalculator));
            }
            if (keyType.equals("rsa")) {
                BigInteger n = this.readBigInteger("n", inputStream);
                BigInteger e = this.readBigInteger("e", inputStream);
                BigInteger[] values = this.processRSASecretKey(inputStream, n, e, keyProtectionRemoverFactory);
                PublicKeyPacket pubPacket = new PublicKeyPacket(1, new Date(), new RSAPublicBCPGKey(n, e));
                return new PGPSecretKey(new SecretKeyPacket(pubPacket, 0, null, null, new RSASecretBCPGKey(values[0], values[1], values[2]).getEncoded()), new PGPPublicKey(pubPacket, fingerPrintCalculator));
            }
            throw new PGPException("unknown key type: " + keyType);
        }
        throw new PGPException("unknown key type found");
    }

    private BigInteger readBigInteger(String expectedType, InputStream inputStream) throws IOException, PGPException {
        SXprUtils.skipOpenParenthesis(inputStream);
        String type = SXprUtils.readString(inputStream, inputStream.read());
        if (!type.equals(expectedType)) {
            throw new PGPException(expectedType + " value expected");
        }
        byte[] nBytes = SXprUtils.readBytes(inputStream, inputStream.read());
        BigInteger v = new BigInteger(1, nBytes);
        SXprUtils.skipCloseParenthesis(inputStream);
        return v;
    }

    private static byte[][] extractData(InputStream inputStream, PBEProtectionRemoverFactory keyProtectionRemoverFactory) throws PGPException, IOException {
        byte[] data;
        byte[] protectedAt = null;
        SXprUtils.skipOpenParenthesis(inputStream);
        String type = SXprUtils.readString(inputStream, inputStream.read());
        if (type.equals("protected")) {
            String protection = SXprUtils.readString(inputStream, inputStream.read());
            SXprUtils.skipOpenParenthesis(inputStream);
            S2K s2k = SXprUtils.parseS2K(inputStream);
            byte[] iv = SXprUtils.readBytes(inputStream, inputStream.read());
            SXprUtils.skipCloseParenthesis(inputStream);
            byte[] secKeyData = SXprUtils.readBytes(inputStream, inputStream.read());
            SXprUtils.skipCloseParenthesis(inputStream);
            PBESecretKeyDecryptor keyDecryptor = keyProtectionRemoverFactory.createDecryptor(protection);
            byte[] key = keyDecryptor.makeKeyFromPassPhrase(7, s2k);
            data = keyDecryptor.recoverKeyData(7, key, iv, secKeyData, 0, secKeyData.length);
            if (inputStream.read() == 40) {
                int ch;
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                bOut.write(40);
                while ((ch = inputStream.read()) >= 0 && ch != 41) {
                    bOut.write(ch);
                }
                if (ch != 41) {
                    throw new IOException("unexpected end to SExpr");
                }
                bOut.write(41);
                protectedAt = bOut.toByteArray();
            }
        } else {
            throw new PGPException("protected block not found");
        }
        SXprUtils.skipCloseParenthesis(inputStream);
        SXprUtils.skipCloseParenthesis(inputStream);
        return new byte[][]{data, protectedAt};
    }

    private BigInteger processDSASecretKey(InputStream inputStream, BigInteger p, BigInteger q, BigInteger g, BigInteger y, PBEProtectionRemoverFactory keyProtectionRemoverFactory) throws IOException, PGPException {
        byte[][] basicData = SExprParser.extractData(inputStream, keyProtectionRemoverFactory);
        byte[] keyData = basicData[0];
        byte[] protectedAt = basicData[1];
        ByteArrayInputStream keyIn = new ByteArrayInputStream(keyData);
        SXprUtils.skipOpenParenthesis(keyIn);
        SXprUtils.skipOpenParenthesis(keyIn);
        BigInteger x = this.readBigInteger("x", keyIn);
        SXprUtils.skipCloseParenthesis(keyIn);
        SXprUtils.skipOpenParenthesis(keyIn);
        String type = SXprUtils.readString(keyIn, ((InputStream)keyIn).read());
        if (!type.equals("hash")) {
            throw new PGPException("hash keyword expected");
        }
        type = SXprUtils.readString(keyIn, ((InputStream)keyIn).read());
        if (!type.equals("sha1")) {
            throw new PGPException("hash keyword expected");
        }
        byte[] hashBytes = SXprUtils.readBytes(keyIn, ((InputStream)keyIn).read());
        SXprUtils.skipCloseParenthesis(keyIn);
        if (this.digestProvider != null) {
            PGPDigestCalculator digestCalculator = this.digestProvider.get(2);
            OutputStream dOut = digestCalculator.getOutputStream();
            dOut.write(Strings.toByteArray((String)"(3:dsa"));
            this.writeCanonical(dOut, "p", p);
            this.writeCanonical(dOut, "q", q);
            this.writeCanonical(dOut, "g", g);
            this.writeCanonical(dOut, "y", y);
            this.writeCanonical(dOut, "x", x);
            if (protectedAt != null) {
                dOut.write(protectedAt);
            }
            dOut.write(Strings.toByteArray((String)")"));
            byte[] check = digestCalculator.getDigest();
            if (!Arrays.constantTimeAreEqual((byte[])check, (byte[])hashBytes)) {
                throw new PGPException("checksum on protected data failed in SExpr");
            }
        }
        return x;
    }

    private BigInteger processElGamalSecretKey(InputStream inputStream, BigInteger p, BigInteger g, BigInteger y, PBEProtectionRemoverFactory keyProtectionRemoverFactory) throws IOException, PGPException {
        byte[][] basicData = SExprParser.extractData(inputStream, keyProtectionRemoverFactory);
        byte[] keyData = basicData[0];
        byte[] protectedAt = basicData[1];
        ByteArrayInputStream keyIn = new ByteArrayInputStream(keyData);
        SXprUtils.skipOpenParenthesis(keyIn);
        SXprUtils.skipOpenParenthesis(keyIn);
        BigInteger x = this.readBigInteger("x", keyIn);
        SXprUtils.skipCloseParenthesis(keyIn);
        SXprUtils.skipOpenParenthesis(keyIn);
        String type = SXprUtils.readString(keyIn, ((InputStream)keyIn).read());
        if (!type.equals("hash")) {
            throw new PGPException("hash keyword expected");
        }
        type = SXprUtils.readString(keyIn, ((InputStream)keyIn).read());
        if (!type.equals("sha1")) {
            throw new PGPException("hash keyword expected");
        }
        byte[] hashBytes = SXprUtils.readBytes(keyIn, ((InputStream)keyIn).read());
        SXprUtils.skipCloseParenthesis(keyIn);
        if (this.digestProvider != null) {
            PGPDigestCalculator digestCalculator = this.digestProvider.get(2);
            OutputStream dOut = digestCalculator.getOutputStream();
            dOut.write(Strings.toByteArray((String)"(3:elg"));
            this.writeCanonical(dOut, "p", p);
            this.writeCanonical(dOut, "g", g);
            this.writeCanonical(dOut, "y", y);
            this.writeCanonical(dOut, "x", x);
            if (protectedAt != null) {
                dOut.write(protectedAt);
            }
            dOut.write(Strings.toByteArray((String)")"));
            byte[] check = digestCalculator.getDigest();
            if (!Arrays.constantTimeAreEqual((byte[])check, (byte[])hashBytes)) {
                throw new PGPException("checksum on protected data failed in SExpr");
            }
        }
        return x;
    }

    private BigInteger processECSecretKey(InputStream inputStream, String curveID, String curveName, byte[] qVal, PBEProtectionRemoverFactory keyProtectionRemoverFactory) throws IOException, PGPException {
        byte[][] basicData = SExprParser.extractData(inputStream, keyProtectionRemoverFactory);
        byte[] keyData = basicData[0];
        byte[] protectedAt = basicData[1];
        ByteArrayInputStream keyIn = new ByteArrayInputStream(keyData);
        SXprUtils.skipOpenParenthesis(keyIn);
        SXprUtils.skipOpenParenthesis(keyIn);
        BigInteger d = this.readBigInteger("d", keyIn);
        SXprUtils.skipCloseParenthesis(keyIn);
        SXprUtils.skipOpenParenthesis(keyIn);
        String type = SXprUtils.readString(keyIn, ((InputStream)keyIn).read());
        if (!type.equals("hash")) {
            throw new PGPException("hash keyword expected");
        }
        type = SXprUtils.readString(keyIn, ((InputStream)keyIn).read());
        if (!type.equals("sha1")) {
            throw new PGPException("hash keyword expected");
        }
        byte[] hashBytes = SXprUtils.readBytes(keyIn, ((InputStream)keyIn).read());
        SXprUtils.skipCloseParenthesis(keyIn);
        if (this.digestProvider != null) {
            PGPDigestCalculator digestCalculator = this.digestProvider.get(2);
            OutputStream dOut = digestCalculator.getOutputStream();
            dOut.write(Strings.toByteArray((String)"(3:ecc"));
            dOut.write(Strings.toByteArray((String)("(" + curveID.length() + ":" + curveID + curveName.length() + ":" + curveName + ")")));
            this.writeCanonical(dOut, "q", qVal);
            this.writeCanonical(dOut, "d", d);
            if (protectedAt != null) {
                dOut.write(protectedAt);
            }
            dOut.write(Strings.toByteArray((String)")"));
            byte[] check = digestCalculator.getDigest();
            if (!Arrays.constantTimeAreEqual((byte[])check, (byte[])hashBytes)) {
                throw new PGPException("checksum on protected data failed in SExpr");
            }
        }
        return d;
    }

    private BigInteger[] processRSASecretKey(InputStream inputStream, BigInteger n, BigInteger e, PBEProtectionRemoverFactory keyProtectionRemoverFactory) throws IOException, PGPException {
        byte[][] basicData = SExprParser.extractData(inputStream, keyProtectionRemoverFactory);
        byte[] keyData = basicData[0];
        byte[] protectedAt = basicData[1];
        ByteArrayInputStream keyIn = new ByteArrayInputStream(keyData);
        SXprUtils.skipOpenParenthesis(keyIn);
        SXprUtils.skipOpenParenthesis(keyIn);
        BigInteger d = this.readBigInteger("d", keyIn);
        BigInteger p = this.readBigInteger("p", keyIn);
        BigInteger q = this.readBigInteger("q", keyIn);
        BigInteger u = this.readBigInteger("u", keyIn);
        SXprUtils.skipCloseParenthesis(keyIn);
        SXprUtils.skipOpenParenthesis(keyIn);
        String type = SXprUtils.readString(keyIn, ((InputStream)keyIn).read());
        if (!type.equals("hash")) {
            throw new PGPException("hash keyword expected");
        }
        type = SXprUtils.readString(keyIn, ((InputStream)keyIn).read());
        if (!type.equals("sha1")) {
            throw new PGPException("hash keyword expected");
        }
        byte[] hashBytes = SXprUtils.readBytes(keyIn, ((InputStream)keyIn).read());
        SXprUtils.skipCloseParenthesis(keyIn);
        if (this.digestProvider != null) {
            PGPDigestCalculator digestCalculator = this.digestProvider.get(2);
            OutputStream dOut = digestCalculator.getOutputStream();
            dOut.write(Strings.toByteArray((String)"(3:rsa"));
            this.writeCanonical(dOut, "n", n);
            this.writeCanonical(dOut, "e", e);
            this.writeCanonical(dOut, "d", d);
            this.writeCanonical(dOut, "p", p);
            this.writeCanonical(dOut, "q", q);
            this.writeCanonical(dOut, "u", u);
            if (protectedAt != null) {
                dOut.write(protectedAt);
            }
            dOut.write(Strings.toByteArray((String)")"));
            byte[] check = digestCalculator.getDigest();
            if (!Arrays.constantTimeAreEqual((byte[])check, (byte[])hashBytes)) {
                throw new PGPException("checksum on protected data failed in SExpr");
            }
        }
        return new BigInteger[]{d, p, q, u};
    }

    private void writeCanonical(OutputStream dOut, String label, BigInteger i) throws IOException {
        this.writeCanonical(dOut, label, i.toByteArray());
    }

    private void writeCanonical(OutputStream dOut, String label, byte[] data) throws IOException {
        dOut.write(Strings.toByteArray((String)("(" + label.length() + ":" + label + data.length + ":")));
        dOut.write(data);
        dOut.write(Strings.toByteArray((String)")"));
    }
}

