/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg.keybox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BlobType {
    EMPTY_BLOB(0),
    FIRST_BLOB(1),
    OPEN_PGP_BLOB(2),
    X509_BLOB(3);

    private final int byteValue;

    private BlobType(int byteValue) {
        this.byteValue = byteValue;
    }

    public static BlobType fromByte(int byteVal) {
        for (BlobType blobType : BlobType.values()) {
            if (blobType.byteValue != byteVal) continue;
            return blobType;
        }
        throw new IllegalArgumentException("Unknown blob type " + Integer.toHexString(byteVal));
    }

    public int getByteValue() {
        return this.byteValue;
    }
}

