/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.client;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.UnmarshalException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.daemon.client.BasicCompilerServicesWithResultsFacadeServer;
import org.jetbrains.kotlin.daemon.client.CompilationServices;
import org.jetbrains.kotlin.daemon.client.CompileServiceSession;
import org.jetbrains.kotlin.daemon.client.CompilerCallbackServicesFacadeServer;
import org.jetbrains.kotlin.daemon.client.DaemonReportingTargets;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient$ClientOptions$mappers$1;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClientKt;
import org.jetbrains.kotlin.daemon.client.NativePlatformUtilKt;
import org.jetbrains.kotlin.daemon.client.RemoteOutputStreamServer;
import org.jetbrains.kotlin.daemon.common.BoolPropMapper;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerMode;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptionsMemoryComparator;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DaemonWithMetadata;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.FileAgeComparator;
import org.jetbrains.kotlin.daemon.common.NetworkUtilsKt;
import org.jetbrains.kotlin.daemon.common.OptionsGroup;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.PropMapper;
import org.jetbrains.kotlin.daemon.common.RemoteOperationsTracer;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\\B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JS\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007\u00a2\u0006\u0002\u0010 J\u0087\u0001\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a2\u0006\u0010!\u001a\u00020\"2\"\b\u0002\u0010#\u001a\u001c\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0&\u0012\u0004\u0012\u00020'\u0018\u00010$2\b\b\u0002\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020+2\b\b\u0002\u0010\u001d\u001a\u00020\b2\b\b\u0002\u0010,\u001a\u00020-\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u000200H\u0002J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0002JL\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020%2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00102\u0006\u0010>\u001a\u00020\u00102\n\b\u0002\u0010?\u001a\u0004\u0018\u00010%J<\u0010@\u001a\u0004\u0018\u0001HA\"\u0004\b\u0000\u0010A2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00102\u0014\u0010B\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u0001HA0CH\u0082\b\u00a2\u0006\u0002\u0010DJ:\u0010E\u001a\u0004\u0018\u00010\u00152\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020%2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\b\b\u0002\u0010=\u001a\u00020\u0010J<\u0010E\u001a\u0004\u0018\u00010\u00152\u0006\u00104\u001a\u0002052\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\b\b\u0002\u0010=\u001a\u00020\u00102\b\b\u0002\u0010F\u001a\u00020\u0010J\u000e\u0010G\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&J\u000e\u0010H\u001a\u00020%2\u0006\u00109\u001a\u00020:Jm\u0010I\u001a\u00020\b2\u0006\u0010J\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\u001c2\u0006\u0010N\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\b2\b\b\u0002\u0010,\u001a\u00020-2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007\u00a2\u0006\u0002\u0010OJ\u0018\u0010P\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010Q\u001a\u0004\u0018\u00010\u0004J!\u0010R\u001a\u00020'2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a\"\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010SJ\u0016\u0010T\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bJ\u000e\u0010U\u001a\u00020'2\u0006\u00104\u001a\u000205J\u0016\u0010U\u001a\u00020'2\u0006\u00104\u001a\u0002052\u0006\u00109\u001a\u00020:J(\u0010V\u001a\u00020\u00102\u0006\u00104\u001a\u0002052\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0002JH\u0010W\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u0002080X2\u0006\u0010Y\u001a\u00020%2\u0006\u00104\u001a\u0002052\u0006\u00107\u001a\u0002082\u0018\u0010Z\u001a\u0014\u0012\u0004\u0012\u00020[\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020'0$H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006]"}, d2={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient;", "", "()V", "COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY", "", "getCOMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY", "()Ljava/lang/String;", "DAEMON_CONNECT_CYCLE_ATTEMPTS", "", "getDAEMON_CONNECT_CYCLE_ATTEMPTS", "()I", "DAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "", "getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "()J", "verboseReporting", "", "getVerboseReporting", "()Z", "compile", "compilerService", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "sessionId", "targetPlatform", "Lorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;", "args", "", "out", "Ljava/io/OutputStream;", "port", "operationsTracer", "Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Ljava/io/OutputStream;ILorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)I", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "outputsCollector", "Lkotlin/Function2;", "Ljava/io/File;", "", "", "compilerMode", "Lorg/jetbrains/kotlin/daemon/common/CompilerMode;", "reportSeverity", "Lorg/jetbrains/kotlin/daemon/common/ReportSeverity;", "profiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lkotlin/jvm/functions/Function2;Lorg/jetbrains/kotlin/daemon/common/CompilerMode;Lorg/jetbrains/kotlin/daemon/common/ReportSeverity;ILorg/jetbrains/kotlin/daemon/common/Profiler;)I", "configureClientOptions", "Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$ClientOptions;", "opts", "connectAndLease", "Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "clientAliveFlagFile", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "reportingTargets", "Lorg/jetbrains/kotlin/daemon/client/DaemonReportingTargets;", "autostart", "leaseSession", "sessionAliveFlagFile", "connectLoop", "R", "body", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/daemon/client/DaemonReportingTargets;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "connectToCompileService", "checkId", "detectCompilerClasspath", "getOrCreateClientFlagFile", "incrementalCompile", "compileService", "callbackServices", "Lorg/jetbrains/kotlin/daemon/client/CompilationServices;", "compilerOut", "daemonOut", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/client/CompilationServices;Ljava/io/OutputStream;Ljava/io/OutputStream;ILorg/jetbrains/kotlin/daemon/common/Profiler;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)I", "leaseCompileSession", "aliveFlagPath", "main", "([Ljava/lang/String;)V", "releaseCompileSession", "shutdownCompileService", "startDaemon", "tryFindSuitableDaemonOrNewOpts", "Lkotlin/Pair;", "registryDir", "report", "Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;", "ClientOptions", "kotlin-daemon-client"})
public final class KotlinCompilerClient {
    private static final long DAEMON_DEFAULT_STARTUP_TIMEOUT_MS = 10000L;
    private static final int DAEMON_CONNECT_CYCLE_ATTEMPTS = 3;
    private static final boolean verboseReporting;
    @NotNull
    private static final String COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY = "kotlin.daemon.client.options";
    public static final KotlinCompilerClient INSTANCE;

    public final long getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS() {
        return DAEMON_DEFAULT_STARTUP_TIMEOUT_MS;
    }

    public final int getDAEMON_CONNECT_CYCLE_ATTEMPTS() {
        return DAEMON_CONNECT_CYCLE_ATTEMPTS;
    }

    public final boolean getVerboseReporting() {
        return verboseReporting;
    }

    @NotNull
    public final File getOrCreateClientFlagFile(@NotNull DaemonOptions daemonOptions) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
                object = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_CLIENT_ALIVE_PATH_PROPERTY());
                if (object == null) break block2;
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object p1 = object2;
                boolean bl3 = false;
                object = DaemonParamsKt.trimQuotes((String)p1);
                if (object == null) break block2;
                object2 = object;
                bl = false;
                bl2 = false;
                p1 = object2;
                boolean bl4 = false;
                object = !StringsKt.isBlank((CharSequence)((CharSequence)p1)) ? object2 : null;
                if (object == null) break block2;
                object2 = object;
                bl = false;
                bl2 = false;
                p1 = object2;
                boolean bl5 = false;
                object2 = new File((String)p1);
                bl = false;
                bl2 = false;
                p1 = object2;
                boolean bl6 = false;
                object = ((File)p1).exists() ? object2 : null;
                if (object != null) break block3;
            }
            object = ClientUtilsKt.makeAutodeletingFlagFile$default(null, new File(DaemonParamsKt.getRunFilesPathOrDefault(daemonOptions)), 1, null);
        }
        return object;
    }

    @Nullable
    public final CompileService connectToCompileService(@NotNull CompilerId compilerId, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart, boolean checkId) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        Intrinsics.checkParameterIsNotNull((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkParameterIsNotNull((Object)reportingTargets, (String)"reportingTargets");
        File flagFile = this.getOrCreateClientFlagFile(daemonOptions);
        return this.connectToCompileService(compilerId, flagFile, daemonJVMOptions, daemonOptions, reportingTargets, autostart);
    }

    public static /* synthetic */ CompileService connectToCompileService$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        return kotlinCompilerClient.connectToCompileService(compilerId, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl, bl2);
    }

    @Nullable
    public final CompileService connectToCompileService(@NotNull CompilerId compilerId, @NotNull File clientAliveFlagFile, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        Intrinsics.checkParameterIsNotNull((Object)clientAliveFlagFile, (String)"clientAliveFlagFile");
        Intrinsics.checkParameterIsNotNull((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkParameterIsNotNull((Object)reportingTargets, (String)"reportingTargets");
        CompileServiceSession compileServiceSession = this.connectAndLease(compilerId, clientAliveFlagFile, daemonJVMOptions, daemonOptions, reportingTargets, autostart, false, null);
        return compileServiceSession != null ? compileServiceSession.getCompileService() : null;
    }

    public static /* synthetic */ CompileService connectToCompileService$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, File file, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return kotlinCompilerClient.connectToCompileService(compilerId, file, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final CompileServiceSession connectAndLease(@NotNull CompilerId compilerId, @NotNull File clientAliveFlagFile, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart, boolean leaseSession, @Nullable File sessionAliveFlagFile) {
        Object v1;
        block13: {
            Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
            Intrinsics.checkParameterIsNotNull((Object)clientAliveFlagFile, (String)"clientAliveFlagFile");
            Intrinsics.checkParameterIsNotNull((Object)daemonJVMOptions, (String)"daemonJVMOptions");
            Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
            Intrinsics.checkParameterIsNotNull((Object)reportingTargets, (String)"reportingTargets");
            KotlinCompilerClient this_$iv = this;
            boolean $i$f$connectLoop = false;
            try {
                int attempts$iv = 1;
                do {
                    void res$iv;
                    Pair pair;
                    try {
                        CompileServiceSession compileServiceSession;
                        void service;
                        boolean isLastAttempt = attempts$iv >= this_$iv.getDAEMON_CONNECT_CYCLE_ATTEMPTS();
                        boolean bl = false;
                        Function1<CompileService, CompileServiceSession> $fun$leaseImpl$1 = new Function1<CompileService, CompileServiceSession>(clientAliveFlagFile, reportingTargets, leaseSession, sessionAliveFlagFile, daemonOptions, compilerId, daemonJVMOptions, autostart){
                            final /* synthetic */ File $clientAliveFlagFile$inlined;
                            final /* synthetic */ DaemonReportingTargets $reportingTargets$inlined;
                            final /* synthetic */ boolean $leaseSession$inlined;
                            final /* synthetic */ File $sessionAliveFlagFile$inlined;
                            final /* synthetic */ DaemonOptions $daemonOptions$inlined;
                            final /* synthetic */ CompilerId $compilerId$inlined;
                            final /* synthetic */ DaemonJVMOptions $daemonJVMOptions$inlined;
                            final /* synthetic */ boolean $autostart$inlined;
                            {
                                this.$clientAliveFlagFile$inlined = file;
                                this.$reportingTargets$inlined = daemonReportingTargets;
                                this.$leaseSession$inlined = bl;
                                this.$sessionAliveFlagFile$inlined = file2;
                                this.$daemonOptions$inlined = daemonOptions;
                                this.$compilerId$inlined = compilerId;
                                this.$daemonJVMOptions$inlined = daemonJVMOptions;
                                this.$autostart$inlined = bl2;
                                super(1);
                            }

                            @Nullable
                            public final CompileServiceSession invoke(@NotNull CompileService $this$leaseImpl) {
                                CompileServiceSession compileServiceSession;
                                Intrinsics.checkParameterIsNotNull((Object)$this$leaseImpl, (String)"$this$leaseImpl");
                                $this$leaseImpl.registerClient(this.$clientAliveFlagFile$inlined.getAbsolutePath());
                                KotlinCompilerClientKt.report$default(this.$reportingTargets$inlined, DaemonReportCategory.DEBUG, "connected to the daemon", null, 4, null);
                                if (!this.$leaseSession$inlined) {
                                    return new CompileServiceSession($this$leaseImpl, CompileService.Companion.getNO_SESSION());
                                }
                                File file = this.$sessionAliveFlagFile$inlined;
                                CompileService.CallResult<Integer> callResult = $this$leaseImpl.leaseCompileSession(file != null ? file.getAbsolutePath() : null);
                                boolean bl = false;
                                boolean bl2 = false;
                                CompileService.CallResult<Integer> it = callResult;
                                boolean bl3 = false;
                                CompileService.CallResult<Integer> callResult2 = !(it instanceof CompileService.CallResult.Dying) ? callResult : null;
                                if (callResult2 != null) {
                                    callResult = callResult2;
                                    bl = false;
                                    bl2 = false;
                                    it = callResult;
                                    boolean bl4 = false;
                                    compileServiceSession = new CompileServiceSession($this$leaseImpl, ((Number)it.get()).intValue());
                                } else {
                                    compileServiceSession = null;
                                }
                                return compileServiceSession;
                            }
                        };
                        NetworkUtilsKt.ensureServerHostnameIsSetUp();
                        Pair<CompileService, DaemonJVMOptions> pair2 = INSTANCE.tryFindSuitableDaemonOrNewOpts(new File(daemonOptions.getRunFilesPath()), compilerId, daemonJVMOptions, (Function2<? super DaemonReportCategory, ? super String, Unit>)((Function2)new Function2<DaemonReportCategory, String, Unit>(clientAliveFlagFile, reportingTargets, leaseSession, sessionAliveFlagFile, daemonOptions, compilerId, daemonJVMOptions, autostart){
                            final /* synthetic */ File $clientAliveFlagFile$inlined;
                            final /* synthetic */ DaemonReportingTargets $reportingTargets$inlined;
                            final /* synthetic */ boolean $leaseSession$inlined;
                            final /* synthetic */ File $sessionAliveFlagFile$inlined;
                            final /* synthetic */ DaemonOptions $daemonOptions$inlined;
                            final /* synthetic */ CompilerId $compilerId$inlined;
                            final /* synthetic */ DaemonJVMOptions $daemonJVMOptions$inlined;
                            final /* synthetic */ boolean $autostart$inlined;
                            {
                                this.$clientAliveFlagFile$inlined = file;
                                this.$reportingTargets$inlined = daemonReportingTargets;
                                this.$leaseSession$inlined = bl;
                                this.$sessionAliveFlagFile$inlined = file2;
                                this.$daemonOptions$inlined = daemonOptions;
                                this.$compilerId$inlined = compilerId;
                                this.$daemonJVMOptions$inlined = daemonJVMOptions;
                                this.$autostart$inlined = bl2;
                                super(2);
                            }

                            public final void invoke(@NotNull DaemonReportCategory cat, @NotNull String msg) {
                                Intrinsics.checkParameterIsNotNull((Object)((Object)cat), (String)"cat");
                                Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                                KotlinCompilerClientKt.report$default(this.$reportingTargets$inlined, cat, msg, null, 4, null);
                            }
                        }));
                        CompileService compileService = (CompileService)pair2.component1();
                        DaemonJVMOptions newJVMOptions = (DaemonJVMOptions)pair2.component2();
                        if (service != null) {
                            compileServiceSession = $fun$leaseImpl$1.invoke((CompileService)service);
                        } else {
                            if (!isLastAttempt && autostart && INSTANCE.startDaemon(compilerId, newJVMOptions, daemonOptions, reportingTargets)) {
                                KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.DEBUG, "new daemon started, trying to find it", null, 4, null);
                            }
                            compileServiceSession = null;
                        }
                        pair = TuplesKt.to((Object)compileServiceSession, null);
                    }
                    catch (SocketException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    catch (ConnectException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    catch (ConnectIOException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    catch (UnmarshalException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    catch (RuntimeException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    Pair pair3 = pair;
                    Object object = pair3.component1();
                    Exception err$iv = (Exception)pair3.component2();
                    if (res$iv != null) {
                        v1 = res$iv;
                        break block13;
                    }
                    if (err$iv == null) continue;
                    KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, (attempts$iv >= this_$iv.getDAEMON_CONNECT_CYCLE_ATTEMPTS() || !autostart ? "no more retries on: " : "retrying(" + attempts$iv + ") on: ") + err$iv.toString(), null, 4, null);
                } while (attempts$iv++ <= this_$iv.getDAEMON_CONNECT_CYCLE_ATTEMPTS() && autostart);
                v1 = null;
            }
            catch (Throwable e$iv) {
                KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.EXCEPTION, e$iv.toString(), null, 4, null);
                v1 = null;
            }
        }
        return v1;
    }

    public static /* synthetic */ CompileServiceSession connectAndLease$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, File file, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, boolean bl2, File file2, int n, Object object) {
        if ((n & 0x80) != 0) {
            file2 = null;
        }
        return kotlinCompilerClient.connectAndLease(compilerId, file, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl, bl2, file2);
    }

    public final void shutdownCompileService(@NotNull CompilerId compilerId, @NotNull DaemonOptions daemonOptions) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
            Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
            CompileService compileService = this.connectToCompileService(compilerId, new DaemonJVMOptions(null, null, null, null, null, 31, null), daemonOptions, new DaemonReportingTargets(System.out, null, null, null, 14, null), false, false);
            if (compileService == null) break block0;
            compileService.shutdown();
        }
    }

    public final void shutdownCompileService(@NotNull CompilerId compilerId) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        this.shutdownCompileService(compilerId, new DaemonOptions(null, 0L, 0, 0, 0L, 0L, false, false, 255, null));
    }

    public final int leaseCompileSession(@NotNull CompileService compilerService, @Nullable String aliveFlagPath) {
        Intrinsics.checkParameterIsNotNull((Object)compilerService, (String)"compilerService");
        return ((Number)compilerService.leaseCompileSession(aliveFlagPath).get()).intValue();
    }

    public final void releaseCompileSession(@NotNull CompileService compilerService, int sessionId) {
        Intrinsics.checkParameterIsNotNull((Object)compilerService, (String)"compilerService");
        compilerService.releaseCompileSession(sessionId);
    }

    @Deprecated(message="Use other compile method", replaceWith=@ReplaceWith(imports={}, expression="compile"))
    public final int compile(@NotNull CompileService compilerService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull OutputStream out, int port, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkParameterIsNotNull((Object)compilerService, (String)"compilerService");
        Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        RemoteOutputStreamServer outStrm = new RemoteOutputStreamServer(out, port);
        return ((Number)compilerService.remoteCompile(sessionId, targetPlatform, args, new CompilerCallbackServicesFacadeServer(null, null, null, null, null, null, port, 63, null), outStrm, CompileService.OutputFormat.PLAIN, outStrm, operationsTracer).get()).intValue();
    }

    public static /* synthetic */ int compile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, OutputStream outputStream, int n2, RemoteOperationsTracer remoteOperationsTracer, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x40) != 0) {
            remoteOperationsTracer = null;
        }
        return kotlinCompilerClient.compile(compileService, n, targetPlatform, stringArray, outputStream, n2, remoteOperationsTracer);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Use non-deprecated compile method", replaceWith=@ReplaceWith(imports={}, expression="compile"))
    public final int incrementalCompile(@NotNull CompileService compileService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull CompilationServices callbackServices, @NotNull OutputStream compilerOut, @NotNull OutputStream daemonOut, int port, @NotNull Profiler profiler, @Nullable RemoteOperationsTracer operationsTracer) {
        void $this$withMeasure$iv;
        Intrinsics.checkParameterIsNotNull((Object)compileService, (String)"compileService");
        Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)callbackServices, (String)"callbackServices");
        Intrinsics.checkParameterIsNotNull((Object)compilerOut, (String)"compilerOut");
        Intrinsics.checkParameterIsNotNull((Object)daemonOut, (String)"daemonOut");
        Intrinsics.checkParameterIsNotNull((Object)profiler, (String)"profiler");
        Profiler profiler2 = profiler;
        KotlinCompilerClient obj$iv = this;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(obj$iv);
        boolean bl = false;
        int res$iv = ((Number)compileService.remoteIncrementalCompile(sessionId, targetPlatform, args, new CompilerCallbackServicesFacadeServer(callbackServices.getIncrementalCompilationComponents(), callbackServices.getLookupTracker(), callbackServices.getCompilationCanceledStatus(), null, null, null, port, 56, null), new RemoteOutputStreamServer(compilerOut, port), CompileService.OutputFormat.XML, new RemoteOutputStreamServer(daemonOut, port), operationsTracer).get()).intValue();
        $this$withMeasure$iv.endMeasure(obj$iv, startState$iv);
        return res$iv;
    }

    public static /* synthetic */ int incrementalCompile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, CompilationServices compilationServices, OutputStream outputStream, OutputStream outputStream2, int n2, Profiler profiler, RemoteOperationsTracer remoteOperationsTracer, int n3, Object object) {
        if ((n3 & 0x80) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x100) != 0) {
            profiler = new DummyProfiler();
        }
        if ((n3 & 0x200) != 0) {
            remoteOperationsTracer = null;
        }
        return kotlinCompilerClient.incrementalCompile(compileService, n, targetPlatform, stringArray, compilationServices, outputStream, outputStream2, n2, profiler, remoteOperationsTracer);
    }

    /*
     * WARNING - void declaration
     */
    public final int compile(@NotNull CompileService compilerService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull MessageCollector messageCollector, @Nullable Function2<? super File, ? super List<? extends File>, Unit> outputsCollector, @NotNull CompilerMode compilerMode, @NotNull ReportSeverity reportSeverity, int port, @NotNull Profiler profiler) {
        void $this$withMeasure$iv;
        Intrinsics.checkParameterIsNotNull((Object)compilerService, (String)"compilerService");
        Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkParameterIsNotNull((Object)compilerMode, (String)"compilerMode");
        Intrinsics.checkParameterIsNotNull((Object)((Object)reportSeverity), (String)"reportSeverity");
        Intrinsics.checkParameterIsNotNull((Object)profiler, (String)"profiler");
        Profiler profiler2 = profiler;
        KotlinCompilerClient obj$iv = this;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(obj$iv);
        boolean bl = false;
        BasicCompilerServicesWithResultsFacadeServer services = new BasicCompilerServicesWithResultsFacadeServer(messageCollector, outputsCollector, port);
        int n = reportSeverity.getCode();
        Integer[] integerArray = new Integer[]{ReportCategory.COMPILER_MESSAGE.getCode(), ReportCategory.DAEMON_MESSAGE.getCode(), ReportCategory.EXCEPTION.getCode(), ReportCategory.OUTPUT_MESSAGE.getCode()};
        CompileService.TargetPlatform targetPlatform2 = targetPlatform;
        CompilerMode compilerMode2 = compilerMode;
        String[] stringArray = args;
        int n2 = sessionId;
        CompileService compileService = compilerService;
        Integer[] integerArray2 = new Integer[]{};
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n3 = 32;
        String[] stringArray2 = null;
        Integer[] integerArray3 = integerArray2;
        int n4 = n;
        Integer[] integerArray4 = integerArray;
        CompileService.TargetPlatform targetPlatform3 = targetPlatform2;
        CompilerMode compilerMode3 = compilerMode2;
        int res$iv = ((Number)compileService.compile(n2, stringArray, new CompilationOptions(compilerMode3, targetPlatform3, integerArray4, n4, integerArray3, stringArray2, n3, defaultConstructorMarker), services, null).get()).intValue();
        $this$withMeasure$iv.endMeasure(obj$iv, startState$iv);
        return res$iv;
    }

    public static /* synthetic */ int compile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, MessageCollector messageCollector, Function2 function2, CompilerMode compilerMode, ReportSeverity reportSeverity, int n2, Profiler profiler, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            function2 = null;
        }
        if ((n3 & 0x40) != 0) {
            compilerMode = CompilerMode.NON_INCREMENTAL_COMPILER;
        }
        if ((n3 & 0x80) != 0) {
            reportSeverity = ReportSeverity.INFO;
        }
        if ((n3 & 0x100) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x200) != 0) {
            profiler = new DummyProfiler();
        }
        return kotlinCompilerClient.compile(compileService, n, targetPlatform, stringArray, messageCollector, (Function2<? super File, ? super List<? extends File>, Unit>)function2, compilerMode, reportSeverity, n2, profiler);
    }

    @NotNull
    public final String getCOMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY() {
        return COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY;
    }

    private final ClientOptions configureClientOptions(ClientOptions opts) {
        String string = System.getProperty(COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            Iterable unrecognized = DaemonParamsKt.filterExtractProps$default(StringsKt.split$default((CharSequence)DaemonParamsKt.trimQuotes(it), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null), opts.getMappers(), "", null, 4, null);
            if (CollectionsKt.any((Iterable)unrecognized)) {
                throw (Throwable)new IllegalArgumentException("Unrecognized client options passed via property " + DaemonParamsKt.getCOMPILE_DAEMON_OPTIONS_PROPERTY() + ": " + CollectionsKt.joinToString$default((Iterable)unrecognized, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "\nSupported options: " + CollectionsKt.joinToString$default((Iterable)opts.getMappers(), (CharSequence)", ", null, null, (int)0, null, (Function1)configureClientOptions.1.1.INSTANCE, (int)30, null));
            }
        }
        return opts;
    }

    private final ClientOptions configureClientOptions() {
        return this.configureClientOptions(new ClientOptions(false, 1, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final void main(String ... args) {
        CompileService compileService;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        CompilerId compilerId = new CompilerId(null, null, 3, null);
        DaemonOptions daemonOptions = DaemonParamsKt.configureDaemonOptions();
        String[] stringArray = new String[]{};
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = true;
        DaemonJVMOptions daemonLaunchingOptions = DaemonParamsKt.configureDaemonJVMOptions(stringArray, bl4, bl3, bl2);
        ClientOptions clientOptions = INSTANCE.configureClientOptions();
        OptionsGroup[] optionsGroupArray = new OptionsGroup[]{compilerId, daemonOptions, daemonLaunchingOptions, clientOptions};
        String string = DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX();
        Iterable<String> filteredArgs = DaemonParamsKt.filterExtractProps(ArraysKt.asIterable((Object[])args), optionsGroupArray, string);
        if (!clientOptions.getStop()) {
            if (CollectionsKt.none((Iterable)compilerId.getCompilerClasspath())) {
                System.err.println("compiler wasn't explicitly specified, attempt to find appropriate jar");
                List<String> list = INSTANCE.detectCompilerClasspath();
                if (list != null) {
                    List<String> list2 = list;
                    boolean bl5 = false;
                    bl = false;
                    List<String> list3 = list2;
                    boolean bl6 = false;
                    compilerId.setCompilerClasspath(list3);
                }
            }
            if (CollectionsKt.none((Iterable)compilerId.getCompilerClasspath())) {
                throw (Throwable)new IllegalArgumentException("Cannot find compiler jar");
            }
            StringBuilder stringBuilder = new StringBuilder().append("desired compiler classpath: ");
            Iterable iterable = compilerId.getCompilerClasspath();
            String string2 = File.pathSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File.pathSeparator");
            String string3 = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null)).toString();
            boolean bl7 = false;
            System.out.println((Object)string3);
        }
        if ((compileService = INSTANCE.connectToCompileService(compilerId, daemonLaunchingOptions, daemonOptions, new DaemonReportingTargets(System.out, null, null, null, 14, null), !clientOptions.getStop(), !clientOptions.getStop())) == null) {
            if (!clientOptions.getStop()) throw (Throwable)new Exception("Unable to connect to daemon");
            System.err.println("No daemon found to shut down");
            return;
        }
        if (clientOptions.getStop()) {
            String string4 = "Shutdown the daemon";
            bl = false;
            System.out.println((Object)string4);
            compileService.shutdown();
            string4 = "Daemon shut down successfully";
            bl = false;
            System.out.println((Object)string4);
            return;
        }
        if (CollectionsKt.none(filteredArgs)) {
            String string5 = "Warning: empty arguments list, only daemon check is performed: checkCompilerId() returns " + compileService.checkCompilerId(compilerId);
            bl = false;
            System.out.println((Object)string5);
            return;
        }
        String string6 = "Executing daemon compilation with args: " + CollectionsKt.joinToString$default(filteredArgs, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        bl = false;
        System.out.println((Object)string6);
        PrintStream printStream = System.out;
        Intrinsics.checkExpressionValueIsNotNull((Object)printStream, (String)"System.out");
        RemoteOutputStreamServer outStrm = new RemoteOutputStreamServer(printStream, 0, 2, null);
        CompilerCallbackServicesFacadeServer servicesFacade = new CompilerCallbackServicesFacadeServer(null, null, null, null, null, null, 0, 127, null);
        try {
            void $this$toTypedArray$iv;
            long l = ((Number)compileService.getUsedMemory().get()).longValue() / (long)1024;
            long startTime = System.nanoTime();
            Collection collection = CollectionsKt.toList(filteredArgs);
            CompileService.TargetPlatform targetPlatform = CompileService.TargetPlatform.JVM;
            int n = CompileService.Companion.getNO_SESSION();
            Object object = compileService;
            boolean $i$f$toTypedArray = false;
            String thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray3 = stringArray2;
            CompileService.CallResult<Integer> res = object.remoteCompile(n, targetPlatform, stringArray3, servicesFacade, outStrm, CompileService.OutputFormat.PLAIN, outStrm, null);
            long endTime = System.nanoTime();
            thisCollection$iv = "Compilation " + (res.isGood() ? "succeeded" : "failed") + ", result code: " + ((Number)res.get()).intValue();
            boolean bl8 = false;
            System.out.println((Object)thisCollection$iv);
            long memAfter = ((Number)compileService.getUsedMemory().get()).longValue() / (long)1024;
            String string7 = "Compilation time: " + TimeUnit.NANOSECONDS.toMillis(endTime - startTime) + " ms";
            boolean bl9 = false;
            System.out.println((Object)string7);
            string7 = "%+d";
            Object[] objectArray = new Object[]{memAfter - l};
            object = new StringBuilder().append("Used memory ").append(memAfter).append(" (");
            boolean bl10 = false;
            String string8 = String.format(string7, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"java.lang.String.format(this, *args)");
            String string9 = string8;
            string7 = ((StringBuilder)object).append(string9).append(" kb)").toString();
            boolean bl11 = false;
            System.out.println((Object)string7);
            return;
        }
        finally {
            UnicastRemoteObject.unexportObject(servicesFacade, true);
            UnicastRemoteObject.unexportObject(outStrm, true);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final List<String> detectCompilerClasspath() {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        String string = System.getProperty("java.class.path");
        Object object2 = string;
        if (string == null) return null;
        CharSequence charSequence = (CharSequence)object2;
        String[] stringArray = new String[1];
        String string2 = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File.pathSeparator");
        stringArray[0] = string2;
        List list = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        object2 = list;
        if (list == null) return null;
        Iterable $this$map$iv = (Iterable)object2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = new File((String)it).getParentFile();
            collection.add(file);
        }
        List list2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        object2 = list2;
        if (list2 == null) return null;
        Iterable $this$mapNotNull$iv = (Iterable)object2;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            File file;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            File file2 = it;
            if (file2 != null && (file2 = FilesKt.walk$default((File)file2, null, (int)1, null)) != null) {
                Object v8;
                block5: {
                    Sequence $this$firstOrNull$iv = (Sequence)file2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        File it2 = (File)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.equals((String)it2.getName(), (String)DaemonParamsKt.getCOMPILER_JAR_NAME(), (boolean)true)) continue;
                        v8 = element$iv;
                        break block5;
                    }
                    v8 = null;
                }
                file = v8;
            } else {
                file = null;
            }
            if (file == null) continue;
            File file3 = file;
            boolean bl4 = false;
            boolean bl5 = false;
            File it$iv$iv = file3;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        File file = (File)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        object2 = file;
        if (file == null) return null;
        Object object3 = object2;
        boolean bl = false;
        boolean bl7 = false;
        Object it = object3;
        boolean bl8 = false;
        List list3 = CollectionsKt.listOf((Object)((File)it).getAbsolutePath());
        return list3;
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized <R> R connectLoop(DaemonReportingTargets reportingTargets, boolean autostart, Function1<? super Boolean, ? extends R> body) {
        int $i$f$connectLoop = 0;
        try {
            int attempts = 1;
            do {
                void res;
                Pair pair;
                try {
                    pair = TuplesKt.to((Object)body.invoke((Object)(attempts >= this.getDAEMON_CONNECT_CYCLE_ATTEMPTS() ? 1 : 0)), null);
                }
                catch (SocketException e) {
                    pair = TuplesKt.to(null, (Object)e);
                }
                catch (ConnectException e) {
                    pair = TuplesKt.to(null, (Object)e);
                }
                catch (ConnectIOException e) {
                    pair = TuplesKt.to(null, (Object)e);
                }
                catch (UnmarshalException e) {
                    pair = TuplesKt.to(null, (Object)e);
                }
                catch (RuntimeException e) {
                    pair = TuplesKt.to(null, (Object)e);
                }
                Pair pair2 = pair;
                Object object = pair2.component1();
                Exception err = (Exception)pair2.component2();
                if (res != null) {
                    return res;
                }
                if (err == null) continue;
                KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, (attempts >= this.getDAEMON_CONNECT_CYCLE_ATTEMPTS() || !autostart ? "no more retries on: " : "retrying(" + attempts + ") on: ") + err.toString(), null, 4, null);
            } while (attempts++ <= this.getDAEMON_CONNECT_CYCLE_ATTEMPTS() && autostart);
            return null;
        }
        catch (Throwable e) {
            KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.EXCEPTION, e.toString(), null, 4, null);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Pair<CompileService, DaemonJVMOptions> tryFindSuitableDaemonOrNewOpts(File registryDir, CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, Function2<? super DaemonReportCategory, ? super String, Unit> report2) {
        void $this$fold$iv;
        Pair pair;
        List list;
        registryDir.mkdirs();
        File timestampMarker = FilesKt.createTempFile$default((String)"kotlin-daemon-client-tsmarker", null, (File)registryDir, (int)2, null);
        try {
            list = SequencesKt.toList((Sequence)ClientUtilsKt.walkDaemons$default(registryDir, compilerId, timestampMarker, null, report2, 8, null));
        }
        finally {
            timestampMarker.delete();
        }
        List aliveWithMetadata = list;
        Comparator comparator = new DaemonJVMOptionsMemoryComparator();
        boolean bl = false;
        comparator = new Comparator<T>(comparator){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = comparator;
            }

            public final int compare(T a, T b) {
                DaemonWithMetadata it;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)a;
                Comparator comparator2 = comparator;
                boolean bl2 = false;
                DaemonJVMOptions daemonJVMOptions = it.getJvmOptions();
                it = (DaemonWithMetadata)b;
                bl2 = false;
                DaemonJVMOptions daemonJVMOptions2 = it.getJvmOptions();
                return comparator2.compare(daemonJVMOptions, daemonJVMOptions2);
            }
        };
        Object object = new FileAgeComparator();
        boolean bl2 = false;
        Comparator comparator2 = new Comparator<T>(comparator, (Comparator)object){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = comparator;
                this.$comparator = comparator2;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    DaemonWithMetadata it;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)a;
                    Comparator comparator2 = comparator;
                    boolean bl2 = false;
                    File file = it.getRunFile();
                    it = (DaemonWithMetadata)b;
                    bl2 = false;
                    File file2 = it.getRunFile();
                    n = comparator2.compare(file, file2);
                }
                return n;
            }
        };
        DaemonJVMOptions optsCopy = DaemonJVMOptions.copy$default(daemonJVMOptions, null, null, null, null, null, 31, null);
        Object object2 = (DaemonWithMetadata)CollectionsKt.maxWith((Iterable)aliveWithMetadata, (Comparator)comparator2);
        if (object2 != null) {
            object = object2;
            bl2 = false;
            boolean bl3 = false;
            Object it = object;
            boolean bl4 = false;
            object2 = DaemonParamsKt.memorywiseFitsInto(daemonJVMOptions, ((DaemonWithMetadata)it).getJvmOptions()) ? object : null;
            if (object2 != null) {
                object = object2;
                bl2 = false;
                bl3 = false;
                it = object;
                boolean bl5 = false;
                pair = new Pair((Object)((DaemonWithMetadata)it).getDaemon(), (Object)DaemonParamsKt.updateMemoryUpperBounds(optsCopy, ((DaemonWithMetadata)it).getJvmOptions()));
                return pair;
            }
        }
        object = aliveWithMetadata;
        Object var19_18 = null;
        boolean $i$f$fold = false;
        DaemonJVMOptions accumulator$iv = optsCopy;
        Iterator iterator = $this$fold$iv.iterator();
        while (true) {
            void d;
            if (!iterator.hasNext()) {
                DaemonJVMOptions daemonJVMOptions2;
                DaemonJVMOptions daemonJVMOptions3 = daemonJVMOptions2 = accumulator$iv;
                Object var22_24 = var19_18;
                pair = new Pair(var22_24, (Object)daemonJVMOptions3);
                return pair;
            }
            Object element$iv = iterator.next();
            DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)element$iv;
            DaemonJVMOptions opts = accumulator$iv;
            boolean bl6 = false;
            accumulator$iv = DaemonParamsKt.updateMemoryUpperBounds(opts, d.getJvmOptions());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final boolean startDaemon(CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets reportingTargets) {
        javaExecutable = new File(new File(System.getProperty("java.home"), "bin"), "java");
        v0 = System.getProperty("java.rmi.server.hostname");
        if (v0 == null) {
            var7_6 = "java.rmi.server.hostname is not set!";
            var8_8 = false;
            throw (Throwable)new IllegalStateException(var7_6.toString());
        }
        serverHostname = v0;
        platformSpecificOptions = CollectionsKt.listOf((Object[])new String[]{"-Djava.awt.headless=true", "-Djava.rmi.server.hostname=" + serverHostname});
        v1 = new String[3];
        v1[0] = javaExecutable.getAbsolutePath();
        v1[1] = "-cp";
        v2 = compilerId.getCompilerClasspath();
        v3 = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"File.pathSeparator");
        v1[2] = CollectionsKt.joinToString$default((Iterable)v2, (CharSequence)v3, null, null, (int)0, null, null, (int)62, null);
        var9_11 = daemonJVMOptions.getMappers();
        var23_12 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])v1), (Iterable)platformSpecificOptions);
        $i$f$flatMap = false;
        var11_15 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        var14_21 = $this$flatMapTo$iv$iv.iterator();
        while (var14_21.hasNext()) {
            element$iv$iv = var14_21.next();
            it = (PropMapper)element$iv$iv;
            $i$a$-flatMap-KotlinCompilerClient$startDaemon$args$1 = false;
            list$iv$iv = it.toArgs("-");
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        var24_30 = (List)destination$iv$iv;
        $this$flatMap$iv = daemonOptions.getMappers();
        var23_12 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)var23_12, (Iterable)var24_30), (Object)DaemonParamsKt.getCOMPILER_DAEMON_CLASS_FQN());
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        var14_21 = $this$flatMapTo$iv$iv.iterator();
        while (var14_21.hasNext()) {
            element$iv$iv = var14_21.next();
            it = (PropMapper)element$iv$iv;
            $i$a$-flatMap-KotlinCompilerClient$startDaemon$args$2 = false;
            list$iv$iv = it.toArgs(DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        var24_30 = (List)destination$iv$iv;
        $this$flatMap$iv = compilerId.getMappers();
        var23_12 = CollectionsKt.plus((Collection)var23_12, (Iterable)var24_30);
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        var14_21 = $this$flatMapTo$iv$iv.iterator();
        while (var14_21.hasNext()) {
            element$iv$iv = var14_21.next();
            it = (PropMapper)element$iv$iv;
            $i$a$-flatMap-KotlinCompilerClient$startDaemon$args$3 = false;
            list$iv$iv = it.toArgs(DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        var24_30 = (List)destination$iv$iv;
        args = CollectionsKt.plus((Collection)var23_12, (Iterable)var24_30);
        KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.DEBUG, "starting the daemon as: " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), null, 4, null);
        processBuilder = new ProcessBuilder(args);
        processBuilder.redirectErrorStream(true);
        $this$flatMapTo$iv$iv = new File(daemonOptions.getRunFilesPath());
        destination$iv$iv = false;
        $i$f$flatMapTo = false;
        $this$apply = $this$flatMapTo$iv$iv;
        $i$a$-apply-KotlinCompilerClient$startDaemon$workingDir$1 = false;
        $this$apply.mkdirs();
        workingDir = $this$flatMapTo$iv$iv;
        processBuilder.directory((File)workingDir);
        daemon = NativePlatformUtilKt.launchProcessWithFallback(processBuilder, reportingTargets, "daemon client");
        isEchoRead = new Semaphore(1);
        isEchoRead.acquire();
        stdoutThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(daemon, reportingTargets, isEchoRead){
            final /* synthetic */ Process $daemon;
            final /* synthetic */ DaemonReportingTargets $reportingTargets;
            final /* synthetic */ Semaphore $isEchoRead;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    InputStream inputStream = this.$daemon.getInputStream();
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"daemon.inputStream");
                    InputStream inputStream2 = inputStream;
                    Charset charset = Charsets.UTF_8;
                    boolean bl = false;
                    TextStreamsKt.forEachLine((Reader)new InputStreamReader(inputStream2, charset), (Function1)((Function1)new Function1<String, Unit>(this){
                        final /* synthetic */ startDaemon.stdoutThread.1 this$0;

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            if (Intrinsics.areEqual((Object)it, (Object)DaemonParamsKt.getCOMPILE_DAEMON_IS_READY_MESSAGE())) {
                                KotlinCompilerClientKt.report$default(this.this$0.$reportingTargets, DaemonReportCategory.DEBUG, "Received the message signalling that the daemon is ready", null, 4, null);
                                this.this$0.$isEchoRead.release();
                                return;
                            }
                            KotlinCompilerClientKt.report(this.this$0.$reportingTargets, DaemonReportCategory.INFO, it, "daemon");
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                }
                finally {
                    this.$daemon.getInputStream().close();
                    this.$daemon.getOutputStream().close();
                    this.$daemon.getErrorStream().close();
                    this.$isEchoRead.release();
                }
            }
            {
                this.$daemon = process;
                this.$reportingTargets = daemonReportingTargets;
                this.$isEchoRead = semaphore;
                super(0);
            }
        }), (int)31, null);
        try {
            v4 = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_STARTUP_TIMEOUT_PROPERTY());
            if (v4 == null) ** GOTO lbl-1000
            list$iv$iv = v4;
            var17_29 = false;
            var18_31 = false;
            it = list$iv$iv;
            $i$a$-let-KotlinCompilerClient$startDaemon$daemonStartupTimeout$1 = false;
            try {
                var21_34 = it;
                var22_35 = false;
                var21_34 = Long.parseLong((String)var21_34);
            }
            catch (Exception e) {
                KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, "unable to interpret " + DaemonParamsKt.getCOMPILE_DAEMON_STARTUP_TIMEOUT_PROPERTY() + " property ('" + (String)it + "'); using default timeout " + KotlinCompilerClient.DAEMON_DEFAULT_STARTUP_TIMEOUT_MS + " ms", null, 4, null);
                var21_34 = null;
            }
            v5 = var21_34;
            v4 = v5;
            if (v5 != null) {
                v6 = v4.longValue();
            } else lbl-1000:
            // 2 sources

            {
                v6 = KotlinCompilerClient.DAEMON_DEFAULT_STARTUP_TIMEOUT_MS;
            }
            daemonStartupTimeout = v6;
            list$iv$iv = daemonOptions.getRunFilesPath();
            var17_29 = false;
            if (list$iv$iv.length() > 0) {
                succeeded = isEchoRead.tryAcquire(daemonStartupTimeout, TimeUnit.MILLISECONDS);
                if (!KotlinCompilerClientKt.isProcessAlive(daemon)) {
                    KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, "Daemon terminated unexpectedly with error code: " + daemon.exitValue(), null, 4, null);
                    v7 = false;
                } else if (!succeeded) {
                    KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, "Unable to get response from daemon in " + daemonStartupTimeout + " ms", null, 4, null);
                    v7 = false;
                } else {
                    v7 = true;
                }
                var17_29 = v7;
                return var17_29;
            }
            Thread.sleep(daemonStartupTimeout);
            var16_28 = true;
            return var16_28;
        }
        finally {
            block18: {
                if (stdoutThread.isAlive()) {
                    stdoutThread.stop();
                }
                v8 = reportingTargets.getOut();
                if (v8 == null) break block18;
                v8.flush();
            }
        }
    }

    private KotlinCompilerClient() {
    }

    static {
        KotlinCompilerClient kotlinCompilerClient;
        INSTANCE = kotlinCompilerClient = new KotlinCompilerClient();
        DAEMON_DEFAULT_STARTUP_TIMEOUT_MS = 10000L;
        DAEMON_CONNECT_CYCLE_ATTEMPTS = 3;
        verboseReporting = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_VERBOSE_REPORT_PROPERTY()) != null;
        COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY = COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R&\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$ClientOptions;", "Lorg/jetbrains/kotlin/daemon/common/OptionsGroup;", "stop", "", "(Z)V", "mappers", "", "Lorg/jetbrains/kotlin/daemon/common/PropMapper;", "getMappers", "()Ljava/util/List;", "getStop", "()Z", "setStop", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "kotlin-daemon-client"})
    public static final class ClientOptions
    implements OptionsGroup {
        private boolean stop;

        @Override
        @NotNull
        public List<PropMapper<?, ?, ?>> getMappers() {
            return CollectionsKt.listOf(new BoolPropMapper(this, KotlinCompilerClient$ClientOptions$mappers$1.INSTANCE, null, 4, null));
        }

        public final boolean getStop() {
            return this.stop;
        }

        public final void setStop(boolean bl) {
            this.stop = bl;
        }

        public ClientOptions(boolean stop) {
            this.stop = stop;
        }

        public /* synthetic */ ClientOptions(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public ClientOptions() {
            this(false, 1, null);
        }

        public final boolean component1() {
            return this.stop;
        }

        @NotNull
        public final ClientOptions copy(boolean stop) {
            return new ClientOptions(stop);
        }

        public static /* synthetic */ ClientOptions copy$default(ClientOptions clientOptions, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = clientOptions.stop;
            }
            return clientOptions.copy(bl);
        }

        @NotNull
        public String toString() {
            return "ClientOptions(stop=" + this.stop + ")";
        }

        public int hashCode() {
            int n = this.stop ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ClientOptions)) break block3;
                    ClientOptions clientOptions = (ClientOptions)object;
                    if (!(this.stop == clientOptions.stop)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

