/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.AbstractInvoker;
import org.jruby.ext.ffi.NullMemoryIO;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.TypeResolver;
import org.jruby.internal.runtime.methods.DynamicMethod;

public class FFI {
    public final RubyModule ffiModule;
    public final RubyClass memoryClass;
    public final RubyClass bufferClass;
    public final RubyClass pointerClass;
    public final RubyClass memptrClass;
    public final RubyClass structClass;
    public final RubyClass functionClass;
    public final RubyClass callbackClass;
    public final RubyClass typeClass;
    public final RubyHash typedefs;
    public final Pointer nullPointer;
    private final NullMemoryIO nullMemoryIO;
    private final TypeResolver typeResolver;
    private final Map<DynamicMethod, AbstractInvoker> refmap = Collections.synchronizedMap(new WeakHashMap());

    public FFI(RubyModule ffiModule) {
        this.ffiModule = ffiModule;
        this.bufferClass = ffiModule.getClass("Buffer");
        this.pointerClass = ffiModule.getClass("Pointer");
        this.memptrClass = ffiModule.getClass("MemoryPointer");
        this.memoryClass = ffiModule.getClass("AbstractMemory");
        this.structClass = ffiModule.getClass("Struct");
        this.functionClass = ffiModule.getClass("Function");
        this.callbackClass = ffiModule.getClass("Callback");
        this.typeClass = ffiModule.getClass("Type");
        this.typedefs = (RubyHash)ffiModule.getConstant("TypeDefs");
        this.typeResolver = new TypeResolver(this);
        this.nullMemoryIO = new NullMemoryIO(ffiModule.getRuntime());
        this.nullPointer = (Pointer)this.pointerClass.getConstant("NULL");
    }

    public final TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public NullMemoryIO getNullMemoryIO() {
        return this.nullMemoryIO;
    }

    public void registerAttachedMethod(DynamicMethod method2, AbstractInvoker invoker) {
        this.refmap.put(method2, invoker);
    }
}

