/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.m2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.m2.DefaultPomDependencyMgt;
import org.apache.ivy.plugins.parser.m2.PomDependencyMgt;
import org.apache.ivy.plugins.parser.m2.PomModuleDescriptorBuilder;
import org.apache.ivy.plugins.parser.m2.PomReader;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;
import org.xml.sax.SAXException;

public final class PomModuleDescriptorParser
implements ModuleDescriptorParser {
    private static final PomModuleDescriptorParser INSTANCE = new PomModuleDescriptorParser();

    public static PomModuleDescriptorParser getInstance() {
        return INSTANCE;
    }

    private PomModuleDescriptorParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toIvyFile(InputStream inputStream, Resource resource, File file, ModuleDescriptor moduleDescriptor) throws ParseException, IOException {
        try {
            XmlModuleDescriptorWriter.write(moduleDescriptor, file);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    public boolean accept(Resource resource) {
        return resource.getName().endsWith(".pom") || resource.getName().endsWith("pom.xml") || resource.getName().endsWith("project.xml");
    }

    public String toString() {
        return "pom parser";
    }

    @Override
    public Artifact getMetadataArtifact(ModuleRevisionId moduleRevisionId, Resource resource) {
        return DefaultArtifact.newPomArtifact(moduleRevisionId, new Date(resource.getLastModified()));
    }

    @Override
    public String getType() {
        return "pom";
    }

    @Override
    public ModuleDescriptor parseDescriptor(ParserSettings parserSettings, URL uRL, boolean bl) throws ParseException, IOException {
        URLResource uRLResource = new URLResource(uRL);
        return this.parseDescriptor(parserSettings, uRL, uRLResource, bl);
    }

    @Override
    public ModuleDescriptor parseDescriptor(ParserSettings parserSettings, URL uRL, Resource resource, boolean bl) throws ParseException, IOException {
        PomModuleDescriptorBuilder pomModuleDescriptorBuilder;
        block29: {
            pomModuleDescriptorBuilder = new PomModuleDescriptorBuilder(this, resource, parserSettings);
            try {
                Object object;
                Object object2;
                Object object32;
                Object object4;
                Object object5;
                PomReader pomReader = new PomReader(uRL, resource);
                pomReader.setProperty("parent.version", pomReader.getParentVersion());
                pomReader.setProperty("parent.groupId", pomReader.getParentGroupId());
                pomReader.setProperty("project.parent.version", pomReader.getParentVersion());
                pomReader.setProperty("project.parent.groupId", pomReader.getParentGroupId());
                Map map = pomReader.getPomProperties();
                for (Map.Entry object72 : map.entrySet()) {
                    pomReader.setProperty((String)object72.getKey(), (String)object72.getValue());
                    pomModuleDescriptorBuilder.addProperty((String)object72.getKey(), (String)object72.getValue());
                }
                Object object8 = null;
                if (pomReader.hasParent()) {
                    ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance(pomReader.getParentGroupId(), pomReader.getParentArtifactId(), pomReader.getParentVersion());
                    object5 = this.parseOtherPom(parserSettings, moduleRevisionId);
                    if (object5 == null) {
                        throw new IOException("Impossible to load parent for " + resource.getName() + ". Parent=" + moduleRevisionId);
                    }
                    object8 = ((ResolvedModuleRevision)object5).getDescriptor();
                    if (object8 != null) {
                        object4 = PomModuleDescriptorBuilder.extractPomProperties(object8.getExtraInfo());
                        for (Map.Entry entry : object4.entrySet()) {
                            pomReader.setProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                }
                String string = pomReader.getGroupId();
                object5 = pomReader.getArtifactId();
                object4 = pomReader.getVersion();
                pomModuleDescriptorBuilder.setModuleRevId(string, (String)object5, (String)object4);
                pomModuleDescriptorBuilder.setHomePage(pomReader.getHomePage());
                pomModuleDescriptorBuilder.setDescription(pomReader.getDescription());
                License[] licenseArray = pomReader.getLicenses();
                if (licenseArray != null && licenseArray.length > 0) {
                    pomModuleDescriptorBuilder.setLicenses(licenseArray);
                } else if (object8 != null) {
                    pomModuleDescriptorBuilder.setLicenses(object8.getLicenses());
                }
                ModuleRevisionId moduleRevisionId = pomReader.getRelocation();
                if (moduleRevisionId != null) {
                    if (string != null && object5 != null && ((String)object5).equals(moduleRevisionId.getName()) && string.equals(moduleRevisionId.getOrganisation())) {
                        Message.error("Relocation to an other version number not supported in ivy : " + pomModuleDescriptorBuilder.getModuleDescriptor().getModuleRevisionId() + " relocated to " + moduleRevisionId + ". Please update your dependency to directly use the right version.");
                        Message.warn("Resolution will only pick dependencies of the relocated element.  Artefact and other metadata will be ignored.");
                        ResolvedModuleRevision resolvedModuleRevision = this.parseOtherPom(parserSettings, moduleRevisionId);
                        if (resolvedModuleRevision == null) {
                            throw new ParseException("impossible to load module " + moduleRevisionId + " to which " + pomModuleDescriptorBuilder.getModuleDescriptor().getModuleRevisionId() + " has been relocated", 0);
                        }
                        DependencyDescriptor[] dependencyDescriptorArray = resolvedModuleRevision.getDescriptor().getDependencies();
                        for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
                            pomModuleDescriptorBuilder.addDependency(dependencyDescriptorArray[i]);
                        }
                    } else {
                        Message.info(pomModuleDescriptorBuilder.getModuleDescriptor().getModuleRevisionId() + " is relocated to " + moduleRevisionId + ". Please update your dependencies.");
                        Message.verbose("Relocated module will be considered as a dependency");
                        DefaultDependencyDescriptor defaultDependencyDescriptor = new DefaultDependencyDescriptor(pomModuleDescriptorBuilder.getModuleDescriptor(), moduleRevisionId, true, false, true);
                        Configuration[] configurationArray = PomModuleDescriptorBuilder.MAVEN2_CONFIGURATIONS;
                        for (int i = 0; i < configurationArray.length; ++i) {
                            if (!Configuration.Visibility.PUBLIC.equals(configurationArray[i].getVisibility())) continue;
                            defaultDependencyDescriptor.addDependencyConfiguration(configurationArray[i].getName(), configurationArray[i].getName());
                        }
                        pomModuleDescriptorBuilder.addDependency(defaultDependencyDescriptor);
                    }
                    break block29;
                }
                pomReader.setProperty("project.groupId", string);
                pomReader.setProperty("pom.groupId", string);
                pomReader.setProperty("groupId", string);
                pomReader.setProperty("project.artifactId", (String)object5);
                pomReader.setProperty("pom.artifactId", (String)object5);
                pomReader.setProperty("artifactId", (String)object5);
                pomReader.setProperty("project.version", (String)object4);
                pomReader.setProperty("pom.version", (String)object4);
                pomReader.setProperty("version", (String)object4);
                if (object8 != null) {
                    pomModuleDescriptorBuilder.addExtraInfos(object8.getExtraInfo());
                    Iterator iterator = PomModuleDescriptorBuilder.getDependencyManagements((ModuleDescriptor)object8);
                    object32 = iterator.iterator();
                    while (object32.hasNext()) {
                        object2 = (PomDependencyMgt)object32.next();
                        if (object2 instanceof PomReader.PomDependencyMgtElement) {
                            PomReader pomReader2 = pomReader;
                            pomReader2.getClass();
                            object2 = pomReader2.new PomReader.PomDependencyMgtElement((PomReader.PomDependencyMgtElement)object2);
                        }
                        pomModuleDescriptorBuilder.addDependencyMgt((PomDependencyMgt)object2);
                    }
                    object32 = PomModuleDescriptorBuilder.getPlugins((ModuleDescriptor)object8);
                    object2 = object32.iterator();
                    while (object2.hasNext()) {
                        pomModuleDescriptorBuilder.addPlugin((PomDependencyMgt)object2.next());
                    }
                }
                for (Object object32 : pomReader.getDependencyMgt()) {
                    if ("import".equals(object32.getScope())) {
                        object2 = ModuleRevisionId.newInstance(object32.getGroupId(), object32.getArtifactId(), object32.getVersion());
                        object = this.parseOtherPom(parserSettings, (ModuleRevisionId)object2);
                        if (object != null) {
                            ModuleDescriptor moduleDescriptor = ((ResolvedModuleRevision)object).getDescriptor();
                            List list = PomModuleDescriptorBuilder.getDependencyManagements(moduleDescriptor);
                            for (PomDependencyMgt pomDependencyMgt : list) {
                                pomModuleDescriptorBuilder.addDependencyMgt(new DefaultPomDependencyMgt(pomDependencyMgt.getGroupId(), pomDependencyMgt.getArtifactId(), pomDependencyMgt.getVersion(), pomDependencyMgt.getScope(), pomDependencyMgt.getExcludedModules()));
                            }
                            continue;
                        }
                        throw new IOException("Impossible to import module for " + resource.getName() + ". Import=" + object2);
                    }
                    pomModuleDescriptorBuilder.addDependencyMgt((PomDependencyMgt)object32);
                }
                for (Object object32 : pomReader.getDependencies()) {
                    pomModuleDescriptorBuilder.addDependency(resource, (PomReader.PomDependencyData)object32);
                }
                if (object8 != null) {
                    for (int i = 0; i < object8.getDependencies().length; ++i) {
                        object32 = object8.getDependencies()[i];
                        if (object32 instanceof PomModuleDescriptorBuilder.PomDependencyDescriptor) {
                            object2 = ((PomModuleDescriptorBuilder.PomDependencyDescriptor)object32).getPomDependencyData();
                            PomReader pomReader3 = pomReader;
                            pomReader3.getClass();
                            object = pomReader3.new PomReader.PomDependencyData((PomReader.PomDependencyData)object2);
                            pomModuleDescriptorBuilder.addDependency(resource, (PomReader.PomDependencyData)object);
                            continue;
                        }
                        pomModuleDescriptorBuilder.addDependency((DependencyDescriptor)object32);
                    }
                }
                for (Object object32 : pomReader.getPlugins()) {
                    pomModuleDescriptorBuilder.addPlugin((PomDependencyMgt)object32);
                }
                pomModuleDescriptorBuilder.addMainArtifact((String)object5, pomReader.getPackaging());
                this.addSourcesAndJavadocArtifactsIfPresent(pomModuleDescriptorBuilder, parserSettings);
            }
            catch (SAXException sAXException) {
                throw this.newParserException(sAXException);
            }
        }
        return pomModuleDescriptorBuilder.getModuleDescriptor();
    }

    private void addSourcesAndJavadocArtifactsIfPresent(PomModuleDescriptorBuilder pomModuleDescriptorBuilder, ParserSettings parserSettings) {
        if (pomModuleDescriptorBuilder.getMainArtifact() == null) {
            return;
        }
        ModuleDescriptor moduleDescriptor = pomModuleDescriptorBuilder.getModuleDescriptor();
        ModuleRevisionId moduleRevisionId = moduleDescriptor.getModuleRevisionId();
        DependencyResolver dependencyResolver = parserSettings.getResolver(moduleRevisionId);
        if (dependencyResolver == null) {
            Message.debug("no resolver found for " + moduleRevisionId + ": no source or javadoc artifact lookup");
        } else {
            ArtifactOrigin artifactOrigin = dependencyResolver.locate(pomModuleDescriptorBuilder.getMainArtifact());
            if (!ArtifactOrigin.isUnknown(artifactOrigin)) {
                ArtifactOrigin artifactOrigin2;
                String string = artifactOrigin.getLocation();
                ArtifactOrigin artifactOrigin3 = dependencyResolver.locate(pomModuleDescriptorBuilder.getSourceArtifact());
                if (!ArtifactOrigin.isUnknown(artifactOrigin3) && !artifactOrigin3.getLocation().equals(string)) {
                    Message.debug("source artifact found for " + moduleRevisionId);
                    pomModuleDescriptorBuilder.addSourceArtifact();
                } else {
                    artifactOrigin2 = dependencyResolver.locate(pomModuleDescriptorBuilder.getSrcArtifact());
                    if (!ArtifactOrigin.isUnknown(artifactOrigin2) && !artifactOrigin2.getLocation().equals(string)) {
                        Message.debug("source artifact found for " + moduleRevisionId);
                        pomModuleDescriptorBuilder.addSrcArtifact();
                    } else {
                        Message.debug("no source artifact found for " + moduleRevisionId);
                    }
                }
                artifactOrigin2 = dependencyResolver.locate(pomModuleDescriptorBuilder.getJavadocArtifact());
                if (!ArtifactOrigin.isUnknown(artifactOrigin2) && !artifactOrigin2.getLocation().equals(string)) {
                    Message.debug("javadoc artifact found for " + moduleRevisionId);
                    pomModuleDescriptorBuilder.addJavadocArtifact();
                } else {
                    Message.debug("no javadoc artifact found for " + moduleRevisionId);
                }
            }
        }
    }

    private ResolvedModuleRevision parseOtherPom(ParserSettings parserSettings, ModuleRevisionId moduleRevisionId) throws ParseException {
        Object object;
        Object object2;
        DependencyDescriptor dependencyDescriptor = new DefaultDependencyDescriptor(moduleRevisionId, true);
        ResolveData resolveData = IvyContext.getContext().getResolveData();
        if (resolveData == null) {
            object2 = IvyContext.getContext().getIvy().getResolveEngine();
            object = new ResolveOptions();
            ((ResolveOptions)object).setDownload(false);
            resolveData = new ResolveData((ResolveEngine)object2, (ResolveOptions)object);
        }
        if ((object2 = parserSettings.getResolver(moduleRevisionId)) == null) {
            return null;
        }
        dependencyDescriptor = NameSpaceHelper.toSystem(dependencyDescriptor, parserSettings.getContextNamespace());
        object = object2.getDependency(dependencyDescriptor, resolveData);
        return object;
    }

    private ParseException newParserException(Exception exception) {
        Message.error(exception.getMessage());
        ParseException parseException = new ParseException(exception.getMessage(), 0);
        parseException.initCause(exception);
        return parseException;
    }
}

