/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.forkjoin;

import java.util.concurrent.RejectedExecutionException;
import scala.concurrent.forkjoin.CountedCompleter;
import scala.concurrent.forkjoin.ForkJoinPool;
import scala.concurrent.forkjoin.ForkJoinPool$EmptyTask;
import scala.concurrent.forkjoin.ForkJoinTask;
import scala.concurrent.forkjoin.ForkJoinWorkerThread;
import sun.misc.Unsafe;

final class ForkJoinPool$WorkQueue {
    int seed;
    volatile int eventCount;
    int nextWait;
    int hint;
    int poolIndex;
    private int mode;
    int nsteals;
    volatile int qlock;
    volatile int base;
    int top;
    ForkJoinTask[] array;
    private ForkJoinPool pool;
    final ForkJoinWorkerThread owner;
    volatile Thread parker;
    volatile ForkJoinTask currentJoin;
    ForkJoinTask currentSteal;
    private static final Unsafe U;
    private static final int ABASE;
    private static final int ASHIFT;

    ForkJoinPool$WorkQueue(ForkJoinPool forkJoinPool, ForkJoinWorkerThread forkJoinWorkerThread, int n, int n2) {
        this.pool = forkJoinPool;
        this.owner = forkJoinWorkerThread;
        this.mode = n;
        this.seed = n2;
        this.top = 4096;
        this.base = 4096;
    }

    final int queueSize() {
        int n = this.base - this.top;
        if (n >= 0) {
            return 0;
        }
        return -n;
    }

    final boolean isEmpty() {
        block3: {
            block2: {
                int n;
                int n2 = this.top;
                int n3 = this.base - n2;
                if (n3 >= 0) break block2;
                if (n3 != -1) break block3;
                ForkJoinTask[] forkJoinTaskArray = this.array;
                if (this.array != null && (n = forkJoinTaskArray.length - 1) >= 0 && U.getObject(forkJoinTaskArray, (long)((n & n2 - 1) << ASHIFT) + (long)ABASE) != null) break block3;
            }
            return true;
        }
        return false;
    }

    final void push(ForkJoinTask forkJoinTask) {
        int n = this.top;
        ForkJoinTask[] forkJoinTaskArray = this.array;
        if (this.array != null) {
            int n2 = forkJoinTaskArray.length - 1;
            int n3 = ((n2 & n) << ASHIFT) + ABASE;
            U.putOrderedObject(forkJoinTaskArray, n3, forkJoinTask);
            this.top = n + 1;
            int n4 = this.top - this.base;
            if (n4 <= 2) {
                ForkJoinPool forkJoinPool = this.pool;
                if (forkJoinPool != null) {
                    forkJoinPool.signalWork(this);
                    return;
                }
            } else if (n4 >= n2) {
                this.growArray();
            }
        }
    }

    final ForkJoinTask[] growArray() {
        int n;
        int n2;
        int n3;
        ForkJoinTask[] forkJoinTaskArray = this.array;
        int n4 = this.array != null ? forkJoinTaskArray.length << 1 : 8192;
        if (n4 > 0x4000000) {
            throw new RejectedExecutionException("Queue capacity exceeded");
        }
        this.array = new ForkJoinTask[n4];
        ForkJoinTask[] forkJoinTaskArray2 = this.array;
        if (forkJoinTaskArray != null && (n3 = forkJoinTaskArray.length - 1) >= 0 && (n2 = this.top) - (n = this.base) > 0) {
            int n5 = n4 - 1;
            do {
                int n6 = ((n & n3) << ASHIFT) + ABASE;
                int n7 = ((n & n5) << ASHIFT) + ABASE;
                ForkJoinTask forkJoinTask = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n6);
                if (forkJoinTask == null || !U.compareAndSwapObject(forkJoinTaskArray, n6, forkJoinTask, null)) continue;
                U.putObjectVolatile(forkJoinTaskArray2, n7, forkJoinTask);
            } while (++n != n2);
        }
        return forkJoinTaskArray2;
    }

    final ForkJoinTask pollAt(int n) {
        int n2;
        ForkJoinTask forkJoinTask;
        ForkJoinTask[] forkJoinTaskArray = this.array;
        if (this.array != null && (forkJoinTask = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n2 = ((forkJoinTaskArray.length - 1 & n) << ASHIFT) + ABASE)) != null && this.base == n && U.compareAndSwapObject(forkJoinTaskArray, n2, forkJoinTask, null)) {
            this.base = n + 1;
            return forkJoinTask;
        }
        return null;
    }

    private ForkJoinTask poll() {
        int n;
        while ((n = this.base) - this.top < 0) {
            ForkJoinTask[] forkJoinTaskArray = this.array;
            if (this.array == null) break;
            int n2 = ((forkJoinTaskArray.length - 1 & n) << ASHIFT) + ABASE;
            ForkJoinTask forkJoinTask = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n2);
            if (forkJoinTask != null) {
                if (this.base != n || !U.compareAndSwapObject(forkJoinTaskArray, n2, forkJoinTask, null)) continue;
                this.base = n + 1;
                return forkJoinTask;
            }
            if (this.base != n) continue;
            if (n + 1 == this.top) break;
            Thread.yield();
        }
        return null;
    }

    final ForkJoinTask nextLocalTask() {
        if (this.mode == 0) {
            int n;
            ForkJoinPool$WorkQueue forkJoinPool$WorkQueue = this;
            ForkJoinTask[] forkJoinTaskArray = forkJoinPool$WorkQueue.array;
            if (forkJoinPool$WorkQueue.array != null && (n = forkJoinTaskArray.length - 1) >= 0) {
                long l;
                ForkJoinTask forkJoinTask;
                int n2;
                while ((n2 = forkJoinPool$WorkQueue.top - 1) - forkJoinPool$WorkQueue.base >= 0 && (forkJoinTask = (ForkJoinTask)U.getObject(forkJoinTaskArray, l = (long)(((n & n2) << ASHIFT) + ABASE))) != null) {
                    if (!U.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null)) continue;
                    forkJoinPool$WorkQueue.top = n2;
                    return forkJoinTask;
                }
            }
            return null;
        }
        return this.poll();
    }

    final boolean tryUnpush(ForkJoinTask forkJoinTask) {
        int n;
        ForkJoinTask[] forkJoinTaskArray = this.array;
        if (this.array != null && (n = this.top) != this.base && U.compareAndSwapObject(forkJoinTaskArray, ((forkJoinTaskArray.length - 1 & --n) << ASHIFT) + ABASE, forkJoinTask, null)) {
            this.top = n;
            return true;
        }
        return false;
    }

    final void cancelAll() {
        ForkJoinTask forkJoinTask;
        ForkJoinTask.cancelIgnoringExceptions(this.currentJoin);
        ForkJoinTask.cancelIgnoringExceptions(this.currentSteal);
        while ((forkJoinTask = this.poll()) != null) {
            ForkJoinTask.cancelIgnoringExceptions(forkJoinTask);
        }
    }

    final int nextSeed() {
        int n = this.seed;
        n ^= n << 13;
        n ^= n >>> 17;
        this.seed = n ^ n << 5;
        return this.seed;
    }

    final boolean tryRemoveAndExec(ForkJoinTask forkJoinTask) {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        ForkJoinTask[] forkJoinTaskArray = this.array;
        if (this.array != null && (n4 = forkJoinTaskArray.length - 1) >= 0 && (n3 = (n2 = this.top) - (n = this.base)) > 0) {
            int n5;
            ForkJoinTask forkJoinTask2;
            while ((forkJoinTask2 = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n5 = ((--n2 & n4) << ASHIFT) + ABASE)) != null) {
                if (forkJoinTask2 == forkJoinTask) {
                    if (n2 + 1 == this.top) {
                        if (!U.compareAndSwapObject(forkJoinTaskArray, n5, forkJoinTask, null)) break;
                        this.top = n2;
                        bl2 = true;
                        break;
                    }
                    if (this.base != n) break;
                    bl2 = U.compareAndSwapObject(forkJoinTaskArray, n5, forkJoinTask, new ForkJoinPool$EmptyTask());
                    break;
                }
                if (forkJoinTask2.status >= 0) {
                    bl3 = false;
                } else if (n2 + 1 == this.top) {
                    if (!U.compareAndSwapObject(forkJoinTaskArray, n5, forkJoinTask2, null)) break;
                    this.top = n2;
                    break;
                }
                if (--n3 != 0) continue;
                if (bl3 || this.base != n) break;
                bl = false;
                break;
            }
        }
        if (bl2) {
            forkJoinTask.doExec();
        }
        return bl;
    }

    final boolean pollAndExecCC(ForkJoinTask forkJoinTask) {
        int n;
        while ((n = this.base) - this.top < 0) {
            CountedCompleter countedCompleter;
            long l;
            Object object;
            ForkJoinTask[] forkJoinTaskArray = this.array;
            if (this.array == null || (object = U.getObject(forkJoinTaskArray, l = (long)(((forkJoinTaskArray.length - 1 & n) << ASHIFT) + ABASE))) == null || !(object instanceof CountedCompleter) || (countedCompleter = (CountedCompleter)object) != forkJoinTask) break;
            if (this.base != n || !U.compareAndSwapObject(forkJoinTaskArray, l, countedCompleter, null)) continue;
            this.base = n + 1;
            countedCompleter.doExec();
            return true;
        }
        return false;
    }

    final void runTask(ForkJoinTask forkJoinTask) {
        if (forkJoinTask != null) {
            this.currentSteal = forkJoinTask;
            this.currentSteal.doExec();
            this.currentSteal = null;
            ++this.nsteals;
            if (this.base - this.top < 0) {
                ForkJoinTask forkJoinTask2;
                if (this.mode == 0) {
                    ForkJoinPool$WorkQueue forkJoinPool$WorkQueue = this;
                    while (true) {
                        long l;
                        ForkJoinTask forkJoinTask3;
                        int n;
                        int n2;
                        ForkJoinTask[] forkJoinTaskArray = forkJoinPool$WorkQueue.array;
                        if (forkJoinPool$WorkQueue.array == null || (n2 = forkJoinTaskArray.length - 1) < 0 || (n = forkJoinPool$WorkQueue.top - 1) - forkJoinPool$WorkQueue.base < 0 || (forkJoinTask3 = (ForkJoinTask)U.getObject(forkJoinTaskArray, l = (long)(((n2 & n) << ASHIFT) + ABASE))) == null) break;
                        if (!U.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask3, null)) continue;
                        forkJoinPool$WorkQueue.top = n;
                        forkJoinTask3.doExec();
                    }
                    return;
                }
                ForkJoinPool$WorkQueue forkJoinPool$WorkQueue = this;
                while ((forkJoinTask2 = forkJoinPool$WorkQueue.poll()) != null) {
                    forkJoinTask2.doExec();
                }
            }
        }
    }

    final void runSubtask(ForkJoinTask forkJoinTask) {
        if (forkJoinTask != null) {
            ForkJoinTask forkJoinTask2 = this.currentSteal;
            this.currentSteal = forkJoinTask;
            this.currentSteal.doExec();
            this.currentSteal = forkJoinTask2;
        }
    }

    final boolean isApparentlyUnblocked() {
        Thread.State state;
        ForkJoinWorkerThread forkJoinWorkerThread;
        return this.eventCount >= 0 && (forkJoinWorkerThread = this.owner) != null && (state = forkJoinWorkerThread.getState()) != Thread.State.BLOCKED && state != Thread.State.WAITING && state != Thread.State.TIMED_WAITING;
    }

    static {
        try {
            U = ForkJoinPool.access$000();
            Class<ForkJoinPool$WorkQueue> clazz = ForkJoinPool$WorkQueue.class;
            Class<ForkJoinTask[]> clazz2 = ForkJoinTask[].class;
            U.objectFieldOffset(clazz.getDeclaredField("qlock"));
            ABASE = U.arrayBaseOffset(clazz2);
            int n = U.arrayIndexScale(clazz2);
            if ((n & n - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(n);
            return;
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

