/*
 * Decompiled with CFR 0.152.
 */
package bt747.j2se_view;

import bt747.j2se_view.GPSKMZFile;
import bt747.j2se_view.J2SEController;
import bt747.j2se_view.helpers.TaggedFilePathFactory;
import bt747.j2se_view.model.BT747Waypoint;
import bt747.j2se_view.model.ImageData;
import bt747.model.Model;
import bt747.model.ModelEvent;
import bt747.model.ModelListener;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.Settings;
import bt747.sys.interfaces.BT747Exception;
import bt747.sys.interfaces.BT747FileName;
import bt747.sys.interfaces.BT747Int;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747Time;
import gps.GpsEvent;
import gps.connection.GPSRxTxPort;
import gps.connection.GPSrxtx;
import gps.convert.Conv;
import gps.log.GPSRecord;
import gps.log.LogFileInfo;
import gps.log.out.CommonOut;
import gps.mvc.MtkModel;
import java.io.File;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import net.sf.bt747.j2se.app.filefilters.KnownFileFilter;
import net.sf.bt747.j2se.app.utils.GPSRecordTimeComparator;
import net.sf.bt747.j2se.system.J2SEJavaTranslations;

public class BT747cmd
implements ModelListener {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd-hh:mm:ss");
    private int eraseTimeoutMs = 60000;
    private Model m;
    private J2SEController c;
    private volatile boolean downloadIsSuccessFull = true;
    private volatile Integer eraseStarted = 0;
    private volatile Integer eraseOngoing = 0;
    private long conversionStartTime;
    private long downloadStartTime;
    private volatile boolean overwriteDownloadOk = false;
    private int prevPercent = -1;
    private int prevAgpsPercent = 0;
    private volatile boolean agpsUploadDone = false;
    private final Vector<BT747Waypoint> waypointsToTag = new Vector();
    private static final Vector<File> filesToTag;
    private TaggedFilePathFactory fpf = new TaggedFilePathFactory();

    public BT747cmd(Model model, J2SEController modelListener, OptionSet optionSet) {
        Settings.setAppSettings(new String(new byte[2633]));
        Object object = modelListener;
        this.c = object;
        object = model;
        modelListener = this;
        if (((BT747cmd)modelListener).m != null) {
            ((BT747cmd)modelListener).m.removeListener(modelListener);
        }
        ((BT747cmd)modelListener).m = object;
        this.handleOptions(optionSet);
    }

    private static void reportError(int n, String string) {
        System.err.println("\n####    PROBLEM  !!! ####");
        switch (n) {
            case -1: {
                System.err.println("ERROR - Could not open " + string);
                return;
            }
            case -2: {
                System.err.println("WARNING - No files were created - Check the input type.");
                return;
            }
            case -3: {
                System.err.println("ERROR - Problem reading" + string);
            }
        }
    }

    @Override
    public void modelEvent(ModelEvent object) {
        try {
            switch (((GpsEvent)object).getType()) {
                case 5: {
                    this.downloadStartTime = System.currentTimeMillis();
                    this.downloadIsSuccessFull = false;
                    this.progressUpdate();
                    return;
                }
                case 6: {
                    this.progressUpdate();
                    return;
                }
                case 7: {
                    this.progressUpdate();
                    if (!this.downloadIsSuccessFull) {
                        System.out.println("\n#### DOWNLOAD FAILED ####");
                    } else {
                        System.out.println("\n#### DOWNLOAD SUCCESS ####");
                    }
                    System.out.println("Time to download data (ms): " + (int)(System.currentTimeMillis() - this.downloadStartTime) + " ms");
                    return;
                }
                case 14: {
                    this.downloadIsSuccessFull = true;
                    return;
                }
                case 38: {
                    if (this.agpsUploadDone) break;
                    this.agpsUploadDone = true;
                    return;
                }
                case 272: {
                    object = this;
                    System.out.println();
                    ((BT747cmd)object).agpsUploadDone = true;
                    return;
                }
                case 273: {
                    this.agpsProgressBarUpdate(((BT747Int)((GpsEvent)object).getArg()).getValue());
                    return;
                }
                case 8: {
                    if (this.overwriteDownloadOk) {
                        System.out.println("Overwriting previously downloaded data that looks different.");
                        this.c.replyToOkToOverwrite(true);
                        return;
                    }
                    System.out.println("\n#### DOWNLOAD ABORTED BECAUSE DATA ON DISK IS DIFFERENT ####");
                    System.out.println("\n####    Change destination file or use '-overwrite'     ####");
                    this.c.replyToOkToOverwrite(false);
                    return;
                }
                case 9: {
                    this.setEraseOngoing(true);
                    return;
                }
                case 10: {
                    this.setEraseOngoing(false);
                    return;
                }
                case 256: {
                    this.conversionStartTime = System.currentTimeMillis();
                    return;
                }
                case 257: {
                    System.out.println("Time to convert data (ms): " + (int)(System.currentTimeMillis() - this.conversionStartTime) + " ms");
                }
            }
            return;
        }
        catch (BT747Exception bT747Exception) {
            System.err.println("\n####    ERROR  !!! ####");
            String string = bT747Exception.getCause().toString().equals("open") ? "Error - Could not open " + bT747Exception.getMessage() : bT747Exception.getCause().toString() + '\n' + bT747Exception.getMessage();
            System.err.println(string);
            return;
        }
    }

    private void flushOutstandingCmds() {
        while (this.m.getOutstandingCommandsCount() > 0) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void progressUpdate() {
        int n = this.prevPercent;
        if (this.m.isDownloadOnGoing()) {
            int n2 = this.m.getStartAddr();
            int n3 = this.m.getEndAddr();
            int n4 = this.m.getNextReadAddr();
            if (n3 != n2) {
                n = (n4 - n2) * 100 / (n3 - n2);
            }
            if (n != this.prevPercent) {
                while (this.prevPercent < n) {
                    ++this.prevPercent;
                    System.out.print('*');
                    if (this.prevPercent % 10 != 0) continue;
                    System.out.print("#" + n + "%#");
                    System.out.flush();
                }
            }
        }
    }

    private void agpsProgressBarUpdate(int n) {
        if (n != this.prevAgpsPercent) {
            while (this.prevAgpsPercent < n) {
                ++this.prevAgpsPercent;
                System.out.print('*');
                if (this.prevAgpsPercent % 10 != 0) continue;
                System.out.print("#" + n + "%#");
                System.out.flush();
            }
        }
    }

    private String waitForErase() {
        byte[] byArray = new byte[]{45, 92, 124, 47};
        J2SEJavaTranslations.getInstance().getTimeStamp();
        long l = 0L;
        int n = 0;
        int n2 = 0;
        this.flushOutstandingCmds();
        System.out.print(byArray[0]);
        while (l == 0L || this.getEraseOngoing() && l > System.currentTimeMillis()) {
            if (this.eraseStarted == 0 && l == 0L) {
                l = System.currentTimeMillis() + (long)this.eraseTimeoutMs;
            }
            try {
                Thread.sleep(50L);
                if ((n += 50) <= 512) continue;
                n -= 512;
                ++n2;
                System.out.print("\r");
                System.out.print((char)byArray[n2 &= 3]);
                System.out.flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.getEraseOngoing()) {
            return "WARNING: Waiting for end of erase timed out";
        }
        return null;
    }

    private static GPSRecord[] getSortedGPSRecords(List<BT747Waypoint> object) {
        GPSRecord[] gPSRecordArray = new GPSRecord[object.size()];
        int n = 0;
        object = object.iterator();
        while (object.hasNext()) {
            GPSRecord gPSRecord = ((BT747Waypoint)object.next()).getGpsRecord();
            if (gPSRecord != null) {
                gPSRecordArray[n++] = gPSRecord;
                continue;
            }
            GPSRecord.getLogFormatRecord(0);
            Generic.debug("Null GPS Record found");
        }
        Arrays.sort(gPSRecordArray, new GPSRecordTimeComparator());
        return gPSRecordArray;
    }

    private int convertLog(int n) {
        System.out.println("Input file: " + this.m.getStringOpt(12));
        if (Model.logFiles.size() != 0) {
            for (int i = 0; i < Model.logFiles.size(); ++i) {
                LogFileInfo object = (LogFileInfo)Model.logFiles.elementAt(i);
                System.out.println("Input file: " + object.getBT747Path().getPath());
            }
        }
        System.out.println("Output directory: " + this.m.getStringOpt(9));
        System.out.println("Output basename: " + this.m.getStringOpt(10));
        if (Model.logFiles.size() != 0) {
            this.c.setStringOpt(12, "");
        }
        if (filesToTag.size() != 0) {
            for (File file : filesToTag) {
                ImageData imageData = new ImageData();
                imageData.setFilePath(new BT747Path(file.getAbsolutePath()));
                this.waypointsToTag.add(imageData);
            }
        }
        this.c.setUserWayPoints(BT747cmd.getSortedGPSRecords(this.waypointsToTag));
        n = n == 11 ? this.c.doConvertLog(n, new GPSKMZFile(), ".kmz") : this.c.doConvertLog(n);
        if (n == 0 && this.waypointsToTag.size() != 0) {
            for (BT747Waypoint bT747Waypoint : this.waypointsToTag) {
                try {
                    if (!ImageData.class.isInstance(bT747Waypoint)) continue;
                    J2SEController.tagImage(this.fpf, (ImageData)bT747Waypoint);
                }
                catch (Exception exception) {
                    Generic.debug("Problem converting", exception);
                }
            }
        }
        return n;
    }

    private void handleOptions(OptionSet optionSet) {
        int n;
        Object object;
        int n2;
        Object object2;
        this.m.init();
        this.c.setStringOpt(9, ".");
        this.c.setOutputFileRelPath("GPSDATA");
        this.c.setIntOpt(7, -1);
        this.c.setIntOpt(47, 60);
        this.c.setStringOpt(43, "0000FF");
        this.c.setStringOpt(44, "0000FF");
        this.c.setBooleanOpt(0, false);
        this.c.setBooleanOpt(1, false);
        this.c.setIntOpt(73, 0);
        this.c.setIntOpt(84, 2);
        optionSet.nonOptionArguments();
        this.m.addListener(this);
        this.c.setChunkSize(65536);
        if (optionSet.has("d")) {
            switch ((Integer)optionSet.valueOf("d")) {
                case 1: {
                    this.c.setDebug(true);
                    this.c.setDebugConn(false);
                    break;
                }
                case 2: {
                    this.c.setDebug(true);
                    this.c.setDebugConn(true);
                    break;
                }
                default: {
                    this.c.setDebug(false);
                    this.c.setDebugConn(false);
                    break;
                }
            }
        } else {
            this.c.setDebug(false);
            this.c.setDebugConn(false);
        }
        this.c.setStringOpt(12, "BT747_log.bin");
        if (optionSet.has("f")) {
            String string;
            object2 = (String)optionSet.valueOf("f");
            n2 = Math.max(((String)object2).lastIndexOf(47), ((String)object2).lastIndexOf(92));
            if (n2 > 0) {
                string = ((String)object2).substring(0, n2);
                object = ((String)object2).substring(n2 + 1);
            } else {
                string = "";
                object = object2;
            }
            if (string.length() != 0) {
                this.c.setStringOpt(9, string);
            }
            this.c.setStringOpt(12, (String)object + ".bin");
            this.c.setOutputFileRelPath((String)object);
        }
        if (optionSet.has("b")) {
            this.c.setStringOpt(12, (String)optionSet.valueOf("b"));
        }
        if (optionSet.has("s")) {
            this.c.setBaudRate((Integer)optionSet.valueOf("s"));
        }
        if (optionSet.has("p")) {
            object2 = (String)optionSet.valueOf("p");
            this.c.setStringOpt(18, (String)object2);
        }
        if (optionSet.has("height")) {
            object2 = ((String)optionSet.valueOf("height")).toUpperCase();
            if (((String)object2).equals("AUTOMATIC")) {
                this.c.setIntOpt(84, 2);
            } else if (((String)object2).equals("MSL_TO_WGS84")) {
                this.c.setIntOpt(84, 3);
            } else if (((String)object2).equals("WGS84_TO_MSL")) {
                this.c.setIntOpt(84, 1);
            } else if (((String)object2).equals("KEEP")) {
                this.c.setIntOpt(84, 0);
            } else {
                System.err.println("Height parameter (" + (String)object2 + "unknown");
            }
        }
        if (optionSet.has("UTC")) {
            object2 = (Integer)optionSet.valueOf("UTC");
            this.c.setIntOpt(68, ((Integer)object2 << 2) + 48);
            this.c.setIntOpt(15, (Integer)object2 * 3600);
        }
        int n3 = 0;
        if (optionSet.has("tz")) {
            object = (String)optionSet.valueOf("tz");
            n2 = 0;
            int n4 = 0;
            n = 0;
            if (((String)object).matches("(-?[0-9][0-9]):([0-9][0-9])")) {
                n2 = Integer.valueOf(((String)object).substring(0, ((String)object).length() - 4));
                n4 = Integer.valueOf(((String)object).substring(((String)object).length() - 3));
            } else if (((String)object).matches("(-?[0-9][0-9]):([0-9][0-9]):([0-9][0-9])")) {
                n2 = Integer.valueOf(((String)object).substring(0, ((String)object).length() - 7));
                n4 = Integer.valueOf(((String)object).substring(((String)object).length() - 6, ((String)object).length() - 3));
                n = Integer.valueOf(((String)object).substring(((String)object).length() - 3));
            }
            n3 = n2 * 3600 + n4 * 60 + n;
            this.c.setIntOpt(15, n3);
        }
        if (optionSet.has("start")) {
            try {
                dateFormat.setLenient(true);
                object = dateFormat.parse((String)optionSet.valueOf("start"));
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                calendar.setTime((Date)object);
                n = JavaLibBridge.getDateInstance(calendar.get(5), calendar.get(2) + 1, calendar.get(1)).dateToUTCepoch1970() + n3;
                this.c.setFilterStartTime(n);
            }
            catch (ParseException parseException) {
                System.out.println("Start date could not be parsed - ignoring start date.");
            }
        }
        if (optionSet.has("end")) {
            try {
                dateFormat.setLenient(true);
                object = dateFormat.parse((String)optionSet.valueOf("end"));
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                calendar.setTime((Date)object);
                n = JavaLibBridge.getDateInstance(calendar.get(5), calendar.get(2) + 1, calendar.get(1)).dateToUTCepoch1970() + n3;
                this.c.setFilterEndTime(n);
            }
            catch (ParseException parseException) {
                System.out.println("End date could not be parsed - ignoring start date.");
            }
        }
        if (optionSet.has("add-missing")) {
            this.c.setBooleanOpt(93, true);
        }
        if (optionSet.has("min-speed")) {
            object = (Float)optionSet.valueOf("min-speed");
            this.c.setFloatOpt(74, ((Float)object).floatValue());
            this.c.setBooleanOpt(39, true);
        }
        if (optionSet.has("max-speed")) {
            object = (Float)optionSet.valueOf("max-speed");
            this.c.setFloatOpt(75, ((Float)object).floatValue());
            this.c.setBooleanOpt(39, true);
        }
        if (optionSet.has("min-reccount")) {
            object = (Integer)optionSet.valueOf("min-reccount");
            this.c.setIntOpt(77, (Integer)object);
            this.c.setBooleanOpt(39, true);
        }
        if (optionSet.has("max-reccount")) {
            object = (Integer)optionSet.valueOf("max-reccount");
            this.c.setIntOpt(78, (Integer)object);
            this.c.setBooleanOpt(39, true);
        }
        if (optionSet.has("min-nsat")) {
            object = (Integer)optionSet.valueOf("min-nsat");
            this.c.setIntOpt(76, (Integer)object);
            this.c.setBooleanOpt(39, true);
        }
        if (optionSet.has("min-distance")) {
            object = (Float)optionSet.valueOf("min-distance");
            this.c.setFloatOpt(79, ((Float)object).floatValue());
            this.c.setBooleanOpt(39, true);
        }
        if (optionSet.has("max-distance")) {
            object = (Float)optionSet.valueOf("max-distance");
            this.c.setFloatOpt(83, ((Float)object).floatValue());
            this.c.setBooleanOpt(39, true);
        }
        if (optionSet.has("max-hdop")) {
            object = (Float)optionSet.valueOf("max-hdop");
            this.c.setFloatOpt(82, ((Float)object).floatValue());
            this.c.setBooleanOpt(39, true);
        }
        if (optionSet.has("max-vdop")) {
            object = (Float)optionSet.valueOf("max-vdop");
            this.c.setFloatOpt(80, ((Float)object).floatValue());
            this.c.setBooleanOpt(39, true);
        }
        if (optionSet.has("max-pdop")) {
            object = (Float)optionSet.valueOf("max-pdop");
            this.c.setFloatOpt(81, ((Float)object).floatValue());
            this.c.setBooleanOpt(39, true);
        }
        if (optionSet.has("color")) {
            this.c.setStringOpt(43, (String)optionSet.valueOf("color"));
            this.c.setStringOpt(44, (String)optionSet.valueOf("color"));
        }
        if (optionSet.has("badcolor")) {
            this.c.setStringOpt(44, (String)optionSet.valueOf("badcolor"));
        }
        if (optionSet.has("splittype")) {
            object = ((String)optionSet.valueOf("splittype")).toUpperCase();
            if (((String)object).equals("DAY")) {
                this.c.setIntOpt(73, 1);
            } else if (((String)object).equals("TRACK")) {
                this.c.setIntOpt(73, 2);
            } else {
                this.c.setIntOpt(73, 0);
            }
        }
        if (optionSet.has("timesplit")) {
            object = (Integer)optionSet.valueOf("timesplit");
            this.c.setIntOpt(47, (Integer)object);
        }
        if (optionSet.has("p") || optionSet.has("a") || optionSet.has("l") || optionSet.has("m") || optionSet.has("r") || optionSet.has("E") || optionSet.has("o") || optionSet.has("R") || optionSet.has("agps-clear") || optionSet.has("agps") || optionSet.has("agps-status") || optionSet.has("agps-url")) {
            this.c.connectGPS();
        }
        if (optionSet.has("device")) {
            object = ((String)optionSet.valueOf("device")).toLowerCase();
            n2 = 0;
            if (((String)object).equals("default")) {
                n2 = 0;
            } else if (((String)object).equals("holux")) {
                n2 = 5;
            } else if (((String)object).equals("holux245")) {
                n2 = 4;
            } else if (((String)object).equals("skytraq")) {
                n2 = 6;
            }
            this.c.setIntOpt(23, n2);
        }
        if (optionSet.has("trkptinfo")) {
            this.c.setBooleanOpt(0, true);
        }
        if (optionSet.has("trkptname")) {
            this.c.setBooleanOpt(1, true);
        }
        if (optionSet.has("overwrite")) {
            this.overwriteDownloadOk = true;
        }
        if (this.m.isConnected()) {
            if (optionSet.has("start")) {
                object = ((String)optionSet.valueOf("start")).toLowerCase();
                if (((String)object).equals("cold")) {
                    this.c.gpsCmd(2);
                } else if (((String)object).equals("warm")) {
                    this.c.gpsCmd(1);
                } else if (((String)object).equals("hot")) {
                    this.c.gpsCmd(0);
                } else if (((String)object).equals("factory")) {
                    this.c.gpsCmd(3);
                }
            }
            if (optionSet.has("l")) {
                object = ((String)optionSet.valueOf("l")).toLowerCase();
                if (((String)object).equals("on")) {
                    System.out.println(">> Switch recording to ON\n");
                    this.c.setLoggingActive(true);
                } else if (((String)object).equals("off")) {
                    System.out.println(">> Switch recording to OFF\n");
                    this.c.setLoggingActive(false);
                } else {
                    System.err.println("Argument of '-l' must be 'ON' or 'OFF'");
                }
            }
            this.c.reqDeviceInfo();
            this.c.setMtkDataNeeded(2);
            this.c.setMtkDataNeeded(18);
            this.c.setMtkDataNeeded(8);
            this.c.setMtkDataNeeded(13);
            this.c.setMtkDataNeeded(11);
            this.c.setMtkDataNeeded(12);
            this.c.setMtkDataNeeded(6);
            if (optionSet.has("mac-address")) {
                this.c.setMtkDataNeeded(25);
            }
            this.flushOutstandingCmds();
            System.out.println("MTK Firmware: Version: " + this.m.getFirmwareVersion() + ", ID(Device): " + this.m.getModelStr() + (this.m.getMainVersion().length() != 0 ? ", MainVersion:" + this.m.getMainVersion() : ""));
            if (optionSet.has("mac-address")) {
                System.out.println("Bluetooth Mac Addr:" + this.m.getBTAddr());
            }
            System.out.println(TaggedFilePathFactory.format("Log Conditions: Time:%.1f Distance:%.1f Speed:%d", (double)this.m.getLogTimeInterval() / 10.0, (double)this.m.getLogDistanceInterval() / 10.0, this.m.getLogSpeedInterval()));
            if (optionSet.has("agps-clear")) {
                System.out.println(">> Clearing AGPS data\n");
                this.c.gpsCmd(20);
            }
            object = null;
            if (optionSet.has("agps-url")) {
                object = (String)optionSet.valueOf("agps-url");
            }
            if (optionSet.has("agps") || object != null) {
                this.agpsUploadDone = false;
                if (object != null) {
                    System.out.println(">> Using " + (String)object + "\n and uploading to device.");
                    this.c.downloadAndUploadAgpsData((String)object);
                } else {
                    this.c.downloadAndUploadAgpsData();
                }
                while (!this.agpsUploadDone) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            if (optionSet.has("agps-status")) {
                MtkModel mtkModel = this.m.mtkModel();
                if (!mtkModel.hasAgps()) {
                    System.out.println("AGPS STATUS: Not supported\n");
                } else {
                    System.out.println(">> Getting AGPS status\n");
                    this.c.setMtkDataNeeded(17);
                    this.flushOutstandingCmds();
                    if (mtkModel.hasAgps()) {
                        String string = TaggedFilePathFactory.format("AGPS Range 1: %S blocks.  From %s to %S.", mtkModel.getAgpsDataCount(), CommonOut.getDateTimeStr(mtkModel.getAgpsStartTime()), CommonOut.getDateTimeStr(mtkModel.getAgpsEndTime()));
                        String string2 = TaggedFilePathFactory.format("AGPS Range 2: %s and %s (unknown meaning)", CommonOut.getDateTimeStr(mtkModel.getAgpsStart2Time()), CommonOut.getDateTimeStr(mtkModel.getAgpsEnd2Time()));
                        System.out.println(string);
                        System.out.println(string2);
                    }
                }
            }
            if (optionSet.has("r")) {
                List list = optionSet.valuesOf("r");
                if (list.size() == 3) {
                    System.out.println(">> Setting recording criteria: time, distance, speed\n");
                    int n5 = (Integer)list.get(0);
                    int n6 = (Integer)list.get(1);
                    n3 = (Integer)list.get(2);
                    System.out.println("Setting time interval to " + n5);
                    this.c.setLogTimeInterval(n5 * 10);
                    System.out.println("Setting speed interval to " + n6);
                    this.c.setLogSpeedInterval(n6);
                    System.out.println("Setting distance interval to " + n3);
                    this.c.setLogDistanceInterval(n3 * 10);
                } else {
                    System.err.println("parameter for '-r' option is invalid");
                }
            }
            this.flushOutstandingCmds();
            if (optionSet.has("o")) {
                Iterator iterator = optionSet.valuesOf("o").iterator();
                int n7 = this.m.getLogFormat();
                while (iterator.hasNext()) {
                    String string = ((String)iterator.next()).toUpperCase();
                    boolean bl = true;
                    int n8 = 0;
                    if (string.length() <= 0) continue;
                    if (string.charAt(0) == '-') {
                        string = string.substring(1);
                        bl = false;
                    }
                    if (string.equals("UTC")) {
                        n8 = 1;
                    } else if (string.equals("VALID")) {
                        n8 = 2;
                    } else if (string.equals("LATITUDE")) {
                        n8 = 4;
                    } else if (string.equals("LONGITUDE")) {
                        n8 = 8;
                    } else if (string.equals("HEIGHT")) {
                        n8 = 16;
                    } else if (string.equals("SPEED")) {
                        n8 = 32;
                    } else if (string.equals("HEADING")) {
                        n8 = 64;
                    } else if (string.equals("DSTA")) {
                        n8 = 128;
                    } else if (string.equals("DAGE")) {
                        n8 = 256;
                    } else if (string.equals("PDOP")) {
                        n8 = 512;
                    } else if (string.equals("HDOP")) {
                        n8 = 1024;
                    } else if (string.equals("VDOP")) {
                        n8 = 2048;
                    } else if (string.equals("NSAT")) {
                        n8 = 4096;
                    } else if (string.equals("SID")) {
                        n8 = 8192;
                    } else if (string.equals("ELEVATION")) {
                        n8 = 16384;
                    } else if (string.equals("AZIMUTH")) {
                        n8 = 32768;
                    } else if (string.equals("SNR")) {
                        n8 = 65536;
                    } else if (string.equals("RCR")) {
                        n8 = 131072;
                    } else if (string.equals("MILLISECOND")) {
                        n8 = 262144;
                    } else if (string.equals("DISTANCE")) {
                        n8 = 524288;
                    } else if (string.equals("VALID_ONLY")) {
                        n8 = Integer.MIN_VALUE;
                    } else {
                        System.err.println("Field type" + string + " unknown.");
                    }
                    if (n8 == 0) continue;
                    if (bl) {
                        n7 |= n8;
                        continue;
                    }
                    n7 &= 0xFFFFFFFF ^ n8;
                }
                System.out.println(">> Setting log format\n");
                this.c.setLogFormat(n7);
            }
            if (optionSet.has("m")) {
                String string = ((String)optionSet.valueOf("m")).toLowerCase();
                if (string.equals("overlap")) {
                    System.out.println(">> Setting method OVERLAP on memory full\n");
                    this.c.setLogOverwrite(true);
                } else if (string.equals("stop")) {
                    System.out.println(">> Setting method STOP on memory full\n");
                    this.c.setLogOverwrite(false);
                } else {
                    System.err.println("Argument of '-p' must be 'STOP' or 'OVERLAP'");
                }
            }
            this.flushOutstandingCmds();
            System.out.println("Device reports " + this.m.logMemUsed() + " bytes used (" + this.m.logMemUsedPercent() + "% of " + this.m.logMemSize() + ").");
            System.out.println("Device is in " + (this.m.isLogFullOverwrite() ? "OVERLAP" : "STOP") + " (" + (this.m.isInitialLogOverwrite() ? "OVERLAP" : "STOP") + " on erase or memory wrap)");
            if (optionSet.has("a")) {
                this.c.setDownloadMethod(1);
                if (optionSet.has("download-method")) {
                    String string = ((String)optionSet.valueOf("download-method")).toLowerCase();
                    if (string.equals("full")) {
                        this.c.setDownloadMethod(2);
                    } else if (string.equals("smart")) {
                        this.c.setDownloadMethod(1);
                    } else if (string.equals("reported")) {
                        this.c.setDownloadMethod(0);
                    }
                }
                System.out.println(">> Getting data from device");
                this.c.startDefaultDownload();
                this.downloadIsSuccessFull = false;
                while (this.m.isDownloadOnGoing()) {
                    try {
                        this.progressUpdate();
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            if (optionSet.has("E")) {
                if (this.downloadIsSuccessFull) {
                    System.out.println(">> Erasing log memory...\n");
                    this.c.eraseLog();
                    String string = this.waitForErase();
                    if (string != null) {
                        System.out.println(string);
                    }
                } else {
                    System.out.println("WARNING - Not erasing memory - download failed.\n");
                }
            }
            if (optionSet.has("R")) {
                if (this.downloadIsSuccessFull) {
                    System.out.println(">> Recover from disable log: ENABLE LOG and FORMAT LOG ALL...\n");
                    this.c.recoveryEraseLog();
                    this.waitForErase();
                } else {
                    System.out.println("WARNING - Not recovering memory - download failed.\n");
                }
            }
            this.c.closeGPS();
        }
        if (optionSet.has("template-taggedfilename")) {
            this.fpf.setDestTemplate((String)optionSet.valueOf("template-taggedfilename"));
            System.out.println("Output filename template is \"" + this.fpf.getDestTemplate() + "\"");
        }
        if (optionSet.has("t")) {
            System.out.println("Converting to GPX (trackpoints)");
            this.c.setIntOpt(88, -66);
            this.c.setIntOpt(86, -66);
            this.c.setIntOpt(89, 0);
            this.c.setIntOpt(87, -1);
            this.c.setFileNameBuilder(new BT747FileName(this){
                private /* synthetic */ BT747cmd this$0;
                {
                    this.this$0 = bT747cmd;
                }

                @Override
                public final BT747Path getOutputFileName(BT747Path bT747Path, int n, String string, String string2) {
                    BT747Time bT747Time = JavaLibBridge.getTimeInstance();
                    bT747Time.setUTCTime(n);
                    String string3 = Conv.expandDate(bT747Path.getPath(), bT747Time);
                    boolean bl = bT747Path.getPath().indexOf(37) < 0;
                    switch (this.this$0.m.getIntOpt(73)) {
                        case 0: {
                            bl = false;
                        }
                    }
                    if (!(bl & true)) {
                        return new BT747Path(string3 + "_trk" + string);
                    }
                    return new BT747Path(string3 + string2 + "_trk" + string);
                }
            });
            if (this.convertLog(3) != 0) {
                BT747cmd.reportError(this.c.getLastError(), this.c.getLastErrorInfo());
            }
        }
        if (optionSet.has("w")) {
            System.out.println("Converting to GPX (waypoints)");
            this.c.setIntOpt(88, -66);
            this.c.setIntOpt(86, -66);
            this.c.setIntOpt(89, 65528);
            this.c.setIntOpt(87, 0);
            this.c.setFileNameBuilder(new BT747FileName(this){
                private /* synthetic */ BT747cmd this$0;
                {
                    this.this$0 = bT747cmd;
                }

                @Override
                public final BT747Path getOutputFileName(BT747Path bT747Path, int n, String string, String string2) {
                    BT747Time bT747Time = JavaLibBridge.getTimeInstance();
                    bT747Time.setUTCTime(n);
                    String string3 = Conv.expandDate(bT747Path.getPath(), bT747Time);
                    boolean bl = bT747Path.getPath().indexOf(37) < 0;
                    switch (this.this$0.m.getIntOpt(73)) {
                        case 0: {
                            bl = false;
                        }
                    }
                    if (bl & true) {
                        return new BT747Path(string3 + string2 + "_wpt" + string);
                    }
                    return new BT747Path(string3 + "_wpt" + string);
                }
            });
            if (this.convertLog(3) != 0) {
                BT747cmd.reportError(this.c.getLastError(), this.c.getLastErrorInfo());
            }
        }
        if (optionSet.has("outtype")) {
            Iterator iterator = optionSet.valuesOf("outtype").iterator();
            while (iterator.hasNext()) {
                String string = ((String)iterator.next()).toUpperCase();
                int n9 = 0;
                if (string.equals("GPX")) {
                    n9 = 3;
                } else if (string.equals("NMEA")) {
                    n9 = 5;
                } else if (string.equals("GMAP") || string.equals("HTML")) {
                    n9 = 2;
                } else if (string.equals("CSV")) {
                    n9 = 1;
                } else if (string.equals("KML")) {
                    n9 = 4;
                } else if (string.equals("KMZ")) {
                    n9 = 11;
                } else if (string.equals("PLT")) {
                    n9 = 6;
                } else if (string.equals("TRK")) {
                    n9 = 7;
                } else if (string.equals("GMAPURL")) {
                    n9 = 17;
                } else if (string.equals("SQL")) {
                    n9 = 18;
                } else if (string.equals("POSTGIS")) {
                    n9 = 19;
                } else {
                    System.err.println("Unknown outtype '" + string + "'");
                }
                if (n9 == 0) continue;
                System.out.println("Converting to " + string);
                this.c.setIntOpt(88, -66);
                this.c.setIntOpt(86, -66);
                this.c.setIntOpt(89, 65528);
                this.c.setIntOpt(87, -1);
                this.c.setFileNameBuilder(new BT747FileName(this){
                    private /* synthetic */ BT747cmd this$0;
                    {
                        this.this$0 = bT747cmd;
                    }

                    @Override
                    public final BT747Path getOutputFileName(BT747Path bT747Path, int n, String string, String string2) {
                        BT747Time bT747Time = JavaLibBridge.getTimeInstance();
                        bT747Time.setUTCTime(n);
                        String string3 = Conv.expandDate(bT747Path.getPath(), bT747Time);
                        boolean bl = bT747Path.getPath().indexOf(37) < 0;
                        switch (this.this$0.m.getIntOpt(73)) {
                            case 0: {
                                bl = false;
                            }
                        }
                        if (!(bl & true)) {
                            return new BT747Path(string3 + string);
                        }
                        return new BT747Path(string3 + string2 + string);
                    }
                });
                if (this.convertLog(n9) == 0) continue;
                BT747cmd.reportError(this.c.getLastError(), this.c.getLastErrorInfo());
            }
            if (optionSet.has("a") && !optionSet.has("b") && !this.downloadIsSuccessFull) {
                System.out.println("\n####    DOWNLOAD FAILED !!!!!!!!!!!!!!!!!!!   ####");
                System.out.println("#### [Conversions used partial or wrong data] ####");
            }
        }
        System.exit(0);
    }

    public static void main(String[] object) {
        boolean bl = true;
        Exception exception = null;
        OptionParser optionParser = new OptionParser(){
            {
                this.accepts("h", "Displays help");
                this.accepts("a", "Download the log memory (default method = smart)");
                this.accepts("b", "Do not read device, read a previously saved file.The file type is selected according to the filename extension.Recognized file extensions are .bin, .csv, .gpx, .trl,.nmea, .nme, .nma, .txt, .log, .sr .").withRequiredArg().describedAs("filename.bin").ofType(String.class);
                this.accepts("d", "Debug level: 0..2").withRequiredArg().describedAs("DEBUG_LEVEL").ofType(Integer.class);
                this.accepts("E", "Erase data log memory");
                this.accepts("f", "Base name for saved files (.bin and other)").withRequiredArg().describedAs("filename").ofType(String.class);
                this.accepts("l", "Turn logging ON/OFF").withRequiredArg().describedAs("(on|off)").ofType(String.class);
                this.accepts("m", "Set STOP/OVERLAP recording method on memory full").withRequiredArg().describedAs("(stop|overlap)").ofType(String.class);
                this.accepts("o", "Enable or disable log fields (FIELD1,-FIELD2,...), available fields: UTC,VALID,LATITUDE,LONGITUDE,HEIGHT,SPEED,HEADING,DSTA,DAGE,PDOP,HDOP,VDOP,NSAT,SID,ELEVATION,AZIMUTH,SNR,RCR,MILLISECOND,DISTANCE,VALID_ONLY").withRequiredArg().describedAs("log_format").withValuesSeparatedBy(',').ofType(String.class);
                this.accepts("p", "Communication port, default: /dev/ttyUSB0").withRequiredArg().describedAs("port").ofType(String.class);
                this.accepts("R", "Recover from disabled log: erase data and reset recording criteria");
                this.accepts("r", "Set logging criteria (zero to disable)").withRequiredArg().describedAs("time:distance:speed").ofType(Integer.class).withValuesSeparatedBy(':');
                this.accepts("s", "Serial port speed, default 115200 baud").withRequiredArg().describedAs("speed").ofType(Integer.class);
                this.accepts("min-speed", "Filter Minimum Speed").withRequiredArg().describedAs("min_speed").ofType(Float.class);
                this.accepts("max-speed", "Filter Maximum Speed").withRequiredArg().describedAs("max_speed").ofType(Float.class);
                this.accepts("min-nsat", "Filter Minimum Satelites").withRequiredArg().describedAs("min_nsat").ofType(Integer.class);
                this.accepts("min-reccount", "Filter Minimum Record Number").withRequiredArg().describedAs("min_recnbr").ofType(Integer.class);
                this.accepts("max-reccount", "Filter Maximum Record Number").withRequiredArg().describedAs("max_recnbr").ofType(Integer.class);
                this.accepts("min-distance", "Filter Minimum Distance").withRequiredArg().describedAs("min_dist").ofType(Float.class);
                this.accepts("max-vdop", "Filter Maximum VDOP").withRequiredArg().describedAs("max_vdop").ofType(Float.class);
                this.accepts("max-pdop", "Filter Maximum PDOP").withRequiredArg().describedAs("max_pdop").ofType(Float.class);
                this.accepts("max-hdop", "Filter Maximum HDOP").withRequiredArg().describedAs("max_hdop").ofType(Float.class);
                this.accepts("max-distance", "Filter Maximum Distance").withRequiredArg().describedAs("max_dist").ofType(Float.class);
                this.accepts("t", "Create a gpx file with tracks");
                this.accepts("v", "Print BT747 version and exit");
                this.accepts("w", "Create a gpx file with waypoints");
                this.accepts("outtype", "Create a gpx file of type NMEA, GPX, GMAP or HTML, KML, KMZ, CSV, PLT, TRK.More than one format can be specified when separated with ','").withRequiredArg().describedAs("OUTPUTTYPE").withValuesSeparatedBy(',');
                this.accepts("UTC", "Define UTC offset to apply to output file").withRequiredArg().describedAs("UTCoffset").ofType(Integer.class);
                this.accepts("device", "Make sure the raw bin file is correctly interpreted (DEFAULT, HOLUX, HOLUX245, SKYTRAQ).").withRequiredArg().describedAs("DEVICE");
                this.accepts("mac-address", "Report the BT Mac Address.  Can be used for unique identification.");
                this.accepts("trkptinfo", "Add record information for each trackpoint.");
                this.accepts("trkptname", "Give each trackpoint a name (based on time)");
                this.accepts("color", "Color to use for tracks (HEX RGB value, ex 00FF00)").withRequiredArg().describedAs("HEXCOLOR");
                this.accepts("badcolor", "Color to use for 'bad part' in tracks  (HEX RGB value), ex 00FFFF").withRequiredArg().describedAs("HEXCOLOR");
                this.accepts("splittype", "The way to split the input data: NOSPLIT, DAY or TRACK").withRequiredArg().describedAs("SPLITTYPE");
                this.accepts("timesplit", "Time separation in minutes needed for track segment or track separation.").withRequiredArg().describedAs("MINUTES").ofType(Integer.class);
                this.accepts("height", "Adjust height.  According to formats when 'AUTOMATIC',WGS84 height (elevation) to MSL (Mean Sea Level) when 'MSL',MSL to WGS84 when 'WGS84'").withRequiredArg().describedAs("AUTOMATIC|KEEP|WGS84_TO_MSL|MSL_TO_WGS84");
                this.accepts("download-method", "Select the download method. FULL = All the memory, SMART=According to previous download, REPORTED=Ignores overwrite setting and download reported used memory.").withRequiredArg().describedAs("FULL|SMART|REPORTED");
                this.accepts("overwrite", "Overwrite data even if downloaded data is different");
                this.accepts("tz", "Time zone expressed in difference to Greenwhich time (e.g. -01:00).Defaults to UTC value.").withRequiredArg().describedAs("TIME");
                this.accepts("template-taggedfilename", "Specify the template for the tagged filename.  Default is \"%p" + File.separator + "%f_tagged%e\".\n%p is replaced by the directory of the original file.\n%e is replaced by the extension of the original file.\n%f is replaced with the base of the original file.\n" + "So the default will convert a file \"BT747" + File.separator + "org.jpg\" to \"BT747" + File.separator + "org_tagged\".").withRequiredArg().describedAs("FORMAT");
                this.accepts("agps-url", "Specify the URL (file://, ftp://, http://) to the AGPS (EPO) data.\nThe basename of this file is usually MTK7d.EPO, MTK3d.EPO, MTK8d.EPO or MTK14.EPO\nImplies agps option.").withRequiredArg().describedAs("URL");
                this.accepts("agps-clear", "Clears the AGPS data in the device (done before the upload.");
                this.accepts("agps-status", "Returns the status of APGS data in the device after the APGS upload (if any).");
                this.accepts("agps", "Upload APGS data using the default URL (or the provided url when available).");
                this.accepts("start", "Perform HOT, WARM or COLD start.  FACTORY will set GPS to factory values.").withRequiredArg().describedAs("METHOD");
                this.accepts("start", "Start date and time according to format'yyyy/MM/dd-hh:mm:ss'").withRequiredArg().describedAs("DATETIME").ofType(String.class);
                this.accepts("end", "Enddate and time according to format'yyyy/MM/dd-hh:mm:ss'").withRequiredArg().describedAs("DATETIME").ofType(String.class);
                this.accepts("add-missing", "Add missing but requested fields to output");
            }
        };
        try {
            System.out.println("BT747 Cmd V2.2.1 build BT747_mdeweerd.1.20190513010548430 GPL V3 LICENSE");
            object = optionParser.parse((String[])object);
            if (object.has("h")) {
                optionParser.printHelpOn((OutputStream)System.out);
            } else if (!object.has("v")) {
                KnownFileFilter knownFileFilter = new KnownFileFilter();
                for (String string : object.nonOptionArguments()) {
                    File file = new File(string);
                    if (file.exists()) {
                        if (knownFileFilter.accept(file)) {
                            J2SEController.addLogFile(file);
                            continue;
                        }
                        filesToTag.add(file);
                        continue;
                    }
                    System.err.println("File not found: " + string);
                    bl = false;
                }
                if (bl) {
                    new Runnable((OptionSet)object){
                        private Model m = new Model();
                        private J2SEController c = new J2SEController(this.m);
                        private /* synthetic */ OptionSet val$options;
                        {
                            this.val$options = optionSet;
                        }

                        @Override
                        public final void run() {
                            new BT747cmd(this.m, this.c, this.val$options);
                        }
                    }.run();
                }
            }
        }
        catch (Exception exception2) {
            bl = false;
            exception = exception2;
        }
        if (!bl) {
            try {
                optionParser.printHelpOn((OutputStream)System.err);
            }
            catch (Exception exception3) {
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            if (exception != null) {
                System.err.println("====");
                System.err.println(exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean getEraseOngoing() {
        Integer n = this.eraseOngoing;
        synchronized (n) {
            return this.eraseOngoing != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setEraseOngoing(boolean bl) {
        Integer n = this.eraseOngoing;
        synchronized (n) {
            this.eraseStarted = 1;
            this.eraseOngoing = bl ? 1 : 0;
            return;
        }
    }

    static {
        JavaLibBridge.setJavaLibImplementation(J2SEJavaTranslations.getInstance());
        if (!GPSrxtx.hasDefaultPortInstance()) {
            GPSrxtx.setDefaultGpsPortInstance(new GPSRxTxPort());
        }
        filesToTag = new Vector();
    }
}

